import { Mistral } from "@mistralai/mistralai";
import mysql from "mysql2/promise";
import express from 'express';
import multer from 'multer';
import * as pdfParse from 'pdf-parse';
import mammoth from 'mammoth';
import fs from 'fs/promises';
import { createReadStream } from 'fs';
import cors from 'cors';
import tesseract from 'node-tesseract-ocr';
import pdf from "pdf-poppler";
import path from "path";
import fsSync from "fs";
import sharp from 'sharp';
import { exec } from 'child_process';
import { promisify } from 'util';
const execAsync = promisify(exec);

const app = express();
const PORT = 3000;

// ─── Middleware (sabse pehle lagao) ───
app.use(cors());                    // CORS sabse pehle
app.use(express.json());            // JSON parsing

// MySQL Connection Pool (global)
const db = mysql.createPool({
  host: "localhost",
  user: "root",
  password: "",
  database: "3access_aspecthousing",
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0
});

// Mistral Client
const mistral = new Mistral({
  apiKey: "zu9b3eT55j4blzxutfxoWgXBH0gYUwrQ", // ← .env mein daal do production mein!
});

// ─── Helper Function (DRY - code repeat avoid karne ke liye) ───
async function callMistralAgent(content) {
  try {
    const result = await mistral.chat.complete({
      model: "mistral-large-latest",
      messages: [{ role: "user", content: content }],
    });

    return result.choices[0].message.content.trim();
  } catch (error) {
    console.error("Mistral Chat Error:", error);
    throw error;
  }
}

async function pdfToImages(pdfPath) {
  const outputDir = path.join(process.cwd(), "uploads");
  const opts = {
    format: "png",
    out_dir: outputDir,
    out_prefix: path.basename(pdfPath, path.extname(pdfPath)),
    page: null,
    resolution: 600  // Increased resolution for better tick detection
  };
  await pdf.convert(pdfPath, opts);
  return outputDir;
}

async function ocrImage(imagePath) {
  return await tesseract.recognize(imagePath, {
    lang: "eng",
    oem: 1,
    psm: 3,  // Changed to auto page segmentation for better symbol detection
    tessedit_char_whitelist: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789✓✔✗✘XxYyNnOo☑☒ '
  });
}

// OCR for page detection
async function ocrPageForText(imgPath) {
  return await tesseract.recognize(imgPath, {
    lang: "eng",
    oem: 1,
    psm: 3, // Auto page segmentation
    tessedit_char_whitelist: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789✓✔✗✘XxYyNnOo☑☒ '
  });
}

// Extract support plan page as image
async function extractSupportPlanImage(pdfPath) {
  const images = await pdfToImagesAllPages(pdfPath);
  for (const imgPath of images) {
    console.log("Processing image:", imgPath);
    const pageText = await ocrPageForText(imgPath);
    console.log("Page text sample:", pageText.substring(0, 500));
    if (pageText.toLowerCase().includes('support') && pageText.toLowerCase().includes('plan') && pageText.toLowerCase().includes('choices')) {
      console.log("Found Support Plan Choices on page:", imgPath);
      return imgPath; // Return the full page image
    }
  }
  console.log("Support Plan Choices not found in any page");
  return null; // Not found
}

// ─── Common Response Formatter ───
function formatNumberedSuggestions(content) {
  const suggestions = content
    .split("\n")
    .map(line => line.trim())
    .filter(line => /^[0-9]+\./.test(line));

  const obj = {};
  suggestions.forEach((item, i) => obj[i] = item);
  return obj;
}

function formatSummarySuggestions(content) {
  // Remove unwanted starting lines
  let cleaned = content
    .replace(/^\d+\.\s*/, '')
    .replace(/Here are .*? suggestions for .*?:/i, '')
    .replace(/Starting Line:/gi, '')
    .trim();

  // Split on property visit phrases
  const splitSuggestions = cleaned
    .split(/(?=I visited the property today|Went to the property today)/g)
    .map(s => s.trim())
    .filter(s => s.length > 0);

  const obj = {};
  splitSuggestions.forEach((item, i) => obj[i] = item);
  return obj;
}

function extractLatestDate(text) {
  const dateRegex = /\b(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{2}|\d{4})\b/g;
  const dates = [];
  let match;
  while ((match = dateRegex.exec(text)) !== null) {
    let day = parseInt(match[1]);
    let month = parseInt(match[2]);
    let year = parseInt(match[3]);
    if (year < 100) year += 2000;
    if (day >= 1 && day <= 31 && month >= 1 && month <= 12 && year >= 1900 && year <= 2100) {
      dates.push(new Date(year, month - 1, day));
    }
  }
  if (dates.length > 0) {
    dates.sort((a, b) => b - a);
    return dates[0].toISOString().split('T')[0];
  }
  return null;
}

// ─── Week Blocks Validation for Daily Case and Contact Notes ───
function parseWeekBlocks(weekBlocksStr) {
  try {
    const weekBlocks = JSON.parse(weekBlocksStr);
    return weekBlocks.map(block => {
      // Parse format: "2026-02-02 ---------- 2026-02-08"
      const parts = block.split('----------').map(p => p.trim());
      return {
        start: parts[0],
        end: parts[1]
      };
    });
  } catch (e) {
    console.error("Failed to parse week_blocks:", e);
    return [];
  }
}

function extractAllDates(text) {
  // Extract all dates from text in various formats - comprehensive list
  const dates = new Set();
  const months = {jan:'01', january:'01', feb:'02', february:'02', mar:'03', march:'03', apr:'04', april:'04', may:'05', jun:'06', june:'06', jul:'07', july:'07', aug:'08', augu:'08', sep:'09', sept:'09', september:'09', oct:'10', october:'10', nov:'11', november:'11', dec:'12', december:'12'};
  
  // Format: DD-MM-YYYY or DD/MM/YYYY (4-digit year)
  const dateRegex1 = /\b(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{4})\b/g;
  let match;
  while ((match = dateRegex1.exec(text)) !== null) {
    const day = String(match[1]).padStart(2, '0');
    const month = String(match[2]).padStart(2, '0');
    const year = match[3];
    dates.add(`${year}-${month}-${day}`);
  }
  
  // Format: DD-MM-YY or DD/MM/YY (2-digit year - assume 2000s)
  const dateRegex1b = /\b(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{2})\b/g;
  while ((match = dateRegex1b.exec(text)) !== null) {
    const day = String(match[1]).padStart(2, '0');
    const month = String(match[2]).padStart(2, '0');
    const year = parseInt(match[3]) < 50 ? `20${match[3]}` : `19${match[3]}`;
    dates.add(`${year}-${month}-${day}`);
  }
  
  // Format: YYYY-MM-DD
  const dateRegex2 = /\b(\d{4})-(\d{1,2})-(\d{1,2})\b/g;
  while ((match = dateRegex2.exec(text)) !== null) {
    const year = match[1];
    const month = String(match[2]).padStart(2, '0');
    const day = String(match[3]).padStart(2, '0');
    dates.add(`${year}-${month}-${day}`);
  }
  
  // Format: DD MMM YYYY (e.g., 02 Feb 2026 or 2 February 2026)
  const dateRegex3 = /\b(\d{1,2})\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[a-z]*\s+(\d{4})\b/gi;
  while ((match = dateRegex3.exec(text)) !== null) {
    const day = String(match[1]).padStart(2, '0');
    const month = months[match[2].toLowerCase().substring(0, 3)];
    const year = match[3];
    if (month) {
      dates.add(`${year}-${month}-${day}`);
    }
  }

  // Format: DD MMM YY (e.g., 02 Feb 26)
  const dateRegex4 = /\b(\d{1,2})\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[a-z]*\s+(\d{2})\b/gi;
  while ((match = dateRegex4.exec(text)) !== null) {
    const day = String(match[1]).padStart(2, '0');
    const month = months[match[2].toLowerCase().substring(0, 3)];
    const year = parseInt(match[3]) < 50 ? `20${match[3]}` : `19${match[3]}`;
    if (month) {
      dates.add(`${year}-${month}-${day}`);
    }
  }

  // Format: Month DD, YYYY (e.g., February 02, 2026)
  const dateRegex5 = /\b(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[a-z]*\s+(\d{1,2}),?\s+(\d{4})\b/gi;
  while ((match = dateRegex5.exec(text)) !== null) {
    const month = months[match[1].toLowerCase().substring(0, 3)];
    const day = String(match[2]).padStart(2, '0');
    const year = match[3];
    if (month) {
      dates.add(`${year}-${month}-${day}`);
    }
  }

  // Format: Month DD, YY (e.g., February 02, 26)
  const dateRegex6 = /\b(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[a-z]*\s+(\d{1,2}),?\s+(\d{2})\b/gi;
  while ((match = dateRegex6.exec(text)) !== null) {
    const month = months[match[1].toLowerCase().substring(0, 3)];
    const day = String(match[2]).padStart(2, '0');
    const year = parseInt(match[3]) < 50 ? `20${match[3]}` : `19${match[3]}`;
    if (month) {
      dates.add(`${year}-${month}-${day}`);
    }
  }

  // Format: YYYY/MM/DD
  const dateRegex7 = /\b(\d{4})[\/\-](\d{1,2})[\/\-](\d{1,2})\b/g;
  while ((match = dateRegex7.exec(text)) !== null) {
    const year = match[1];
    const month = String(match[2]).padStart(2, '0');
    const day = String(match[3]).padStart(2, '0');
    dates.add(`${year}-${month}-${day}`);
  }

  // Format: DD (just day number - assume current month/year context, skip for now)
  // Skip this as it's ambiguous

  // Format: DDth MMM YYYY (e.g., 02nd Feb 2026, 3rd March 2026)
  const dateRegex8 = /\b(\d{1,2})(st|nd|rd|th)\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[a-z]*\s+(\d{4})\b/gi;
  while ((match = dateRegex8.exec(text)) !== null) {
    const day = String(match[1]).padStart(2, '0');
    const month = months[match[3].toLowerCase().substring(0, 3)];
    const year = match[4];
    if (month) {
      dates.add(`${year}-${month}-${day}`);
    }
  }

  // Format: DDth MMM YY
  const dateRegex9 = /\b(\d{1,2})(st|nd|rd|th)\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[a-z]*\s+(\d{2})\b/gi;
  while ((match = dateRegex9.exec(text)) !== null) {
    const day = String(match[1]).padStart(2, '0');
    const month = months[match[3].toLowerCase().substring(0, 3)];
    const year = parseInt(match[4]) < 50 ? `20${match[4]}` : `19${match[4]}`;
    if (month) {
      dates.add(`${year}-${month}-${day}`);
    }
  }
  
  console.log("Extracted dates:", Array.from(dates));
  return Array.from(dates);
}

function getDatesInRange(startDate, endDate) {
  const dates = [];
  let current = new Date(startDate);
  const end = new Date(endDate);
  
  while (current <= end) {
    dates.push(current.toISOString().split('T')[0]);
    current.setDate(current.getDate() + 1);
  }
  
  return dates;
}

// function validateWeekBlocksDates(text, weekBlocks) {
//   if (!text || !weekBlocks || weekBlocks.length === 0) {
//     return { valid: false, error: "Text or week blocks not provided" };
//   }

//   const foundDates = extractAllDates(text);
//   console.log("Dates found in document:", foundDates);
  
//   const missingDatesByBlock = [];
  
//   // For each week block, check if ANY date from that block exists in the document
//   // If yes → pass (don't require ALL dates)
//   // If no → show error with missing dates
//   for (const block of weekBlocks) {
//     const datesInBlock = getDatesInRange(block.start, block.end);
    
//     // Check if any date from this block is found
//     const foundInBlock = datesInBlock.filter(d => foundDates.includes(d));
    
//     if (foundInBlock.length === 0) {
//       // No dates from this block found - this is an error
//       missingDatesByBlock.push({
//         block: `${block.start} to ${block.end}`,
//         missingDates: datesInBlock
//       });
//     } else {
//       // At least one date from this block found - that's enough, log it
//       console.log(`Block ${block.start} to ${block.end}: Found dates ${foundInBlock.join(', ')} - OK`);
//     }
//   }
  
//   if (missingDatesByBlock.length > 0) {
//     return { 
//       valid: false, 
//       error: "Missing dates in document",
//       missingDatesByBlock: missingDatesByBlock
//     };
//   }
  
//   return { valid: true, message: "All dates present" };
// }

  // 2nd not found
// function validateWeekBlocksDates(text, weekBlocks) {
//   if (!text || !weekBlocks || weekBlocks.length === 0) {
//     return { valid: false, error: "Text or week blocks not provided" };
//   }

//   const foundDates = extractAllDates(text);
//   console.log("Dates found in document:", foundDates);

//   const missingDatesByBlock = [];

//   for (const block of weekBlocks) {
//     const datesInBlock = getDatesInRange(block.start, block.end);
//     const foundInBlock = datesInBlock.filter(d => foundDates.includes(d));

//     if (foundInBlock.length > 0) {
//       // Agar koi date mil gayi to OK dikhao
//       console.log(`Block ${block.start} to ${block.end}: Found dates ${foundInBlock.join(', ')} - OK`);
//     } else {
//       // Agar koi date nahi mili to Not Found dikhao (yahan aap ek example date show kar sakte ho)
//       // Agar chaho to first date hi dikha sakte ho:
//       console.log(`Block ${block.start} to ${block.end}: Not Found dates ${datesInBlock[0]}`);
      
//       // Optional: missingDatesByBlock me store bhi kar sakte ho agar API response me chahiye
//       missingDatesByBlock.push({
//         block: `${block.start} to ${block.end}`,
//         missingDates: datesInBlock
//       });
//     }
//   }

//   // Agar aap chahte ho valid/invalid return karna to
//   if (missingDatesByBlock.length > 0) {
//     return { 
//       valid: false,
//       missingDatesByBlock: missingDatesByBlock
//     };
//   }

//   return { valid: true, message: "All dates present" };
// }


function validateWeekBlocksDates(text, weekBlocks) {
  if (!text || !weekBlocks || weekBlocks.length === 0) {
    return { valid: false, error: "Text or week blocks not provided" };
  }

  const foundDates = extractAllDates(text);
  console.log("Dates found in document:", foundDates);

  let missingBlocks = []; // store all missing block messages

  for (const block of weekBlocks) {
    const datesInBlock = getDatesInRange(block.start, block.end);
    const foundInBlock = datesInBlock.filter(d => foundDates.includes(d));

    if (foundInBlock.length > 0) {
      console.log(`Block ${block.start} to ${block.end}: Found dates ${foundInBlock.join(', ')} - OK`);
    } else {
      const msg = `Block ${block.start} to ${block.end}: Not Found dates ${datesInBlock[0]}`;
      console.log(msg);

      // store this message for return
      missingBlocks.push(msg);
    }
  }

  if (missingBlocks.length > 0) {
    return {
      valid: false,
      error: missingBlocks.join(';<br/> ')
    };
  }

  return { valid: true, message: "All dates present" };
}



// ─── Routes ───
app.get('/', (req, res) => {
  res.send('Hello from Node.js & Express + Mistral!');
});

// Weekly Support (Summary + Points logic)
app.get('/weekly-support', async (req, res) => {
  try {
    const prompt = (req.query.prompt || "Default prompt").trim();

    const content = await callMistralAgent(prompt);

    if (
      prompt.toLowerCase().includes("windrush-please-give-a-summary") ||
      prompt.toLowerCase().includes("summary")
    ) {
      const suggestions = formatSummarySuggestions(content);
      return res.json({ type: "summary", suggestions });
    }

    // Default: numbered suggestions
    const suggestions = formatNumberedSuggestions(content);
    return res.json({ type: "points", suggestions });

  } catch (error) {
    res.status(500).json({ error: 'Failed to generate weekly support response' });
  }
});


app.get('/daily-contact', async (req, res) => {

  try {


     console.log("Incoming request query:", req.query);
    const prompt = req.query.prompt || "Default prompt";

    const result = await mistral.agents.complete({
      model: "mistral-large-latest",
      messages: [{ role: "user", content: prompt }],
      agentId: "ag_019ae85af969750387d21325ec7bc943",
    });

    // Get the generated text
    const question = result.choices[0].message.content.trim();

    // Split into numbered suggestions only
    let suggestions = question
      .split("\n")
      .map(line => line.trim())
      .filter(line => /^[0-9]+\./.test(line));

    // Convert array to object with numeric keys
    const suggestionsObj = {};
    suggestions.forEach((item, index) => {
      suggestionsObj[index] = item;
    });

    res.json(suggestionsObj);

  } catch (error) {
    console.log(3);
    console.error(error);
    res.status(500).json({ error: 'Failed to generate daily contact question' });
  }
});



const upload = multer({
  dest: 'uploads/',                    // ye folder khud bana lo
  limits: { fileSize: 25 * 1024 * 1024 } // 25MB max
});

// Important fields jo PHP se aa rahe hain
const uploadMiddleware = upload.fields([
  { name: 'referral_assessment', maxCount: 1 },
  { name: 'support_session_notes', maxCount: 1 },
  { name: 'daily_case_and_contact_notes', maxCount: 1 },
  { name: 'risk_assessment', maxCount: 1 },
  { name: 'support_plan_upload_old_tenant_document', maxCount: 1 }
]);


app.post('/existing-tenants', uploadMiddleware, async (req, res) => {
  try {
    console.log("===== REQUEST BODY =====");
    console.log(req.body);

    console.log("===== REQUEST FILES =====");
    console.log(Object.keys(req.files || {}));

    const basePrompt = (req.body.prompt || "existing tenant document upload").trim();
    const files = req.files || {};

    if (Object.keys(files).length === 0) {
      return res.status(400).json({ error: "No files uploaded" });
    }

    const results = {};

    // Field names jo special handling chahiye
    const SUPPORT_SESSION_NOTES_FIELD = 'support_session_notes';     // detailed yes/no steps logic
    const SUPPORT_PLAN_FIELD          = 'support_plan_upload_old_tenant_document';  // table JSON extraction

    for (const field in files) {
      const file = files[field][0];
      const fileName = file.originalname;
      const filePath = file.path;
      const ext = fileName.split('.').pop().toLowerCase();

      console.log(`Processing field: ${field} | originalname: ${fileName}`);

      // Mistral file upload (default)
      let uploadedFile = null;
      try {
        const fileStream = createReadStream(filePath);
        uploadedFile = await mistral.files.upload({
          file: fileStream,
          purpose: "assistants"
        });
      } catch (e) {
        console.error("Mistral file upload failed:", e);
        uploadedFile = null;
      }

      // Text extraction for metadata / fallback / keyword search
      let text = "";
      try {
        if (ext === 'pdf') {
          const imgDir = await pdfToImages(filePath);
          const imageFile = fsSync.readdirSync(imgDir).find(f => f.endsWith(".png"));
          if (!imageFile) throw new Error("PDF image conversion failed");
          const imagePath = path.join(imgDir, imageFile);
          text = await ocrImage(imagePath);
        } else if (ext === 'docx') {
          const result = await mammoth.extractRawText({ path: filePath });
          text = result.value.trim();
        }
      } catch (e) {
        text = "[Extraction failed]";
        console.error("Text extraction failed for", fileName, ":", e);
      }

      let filePrompt = "";
      let isSupportPlan = false;
      let messageContent;

      // ────────────────────────────────────────────────
      // Check if tenant_full_name exists in ALL documents
      // Extract text for validation (pdf-parse for PDFs, OCR for images, mammoth for docx)
      let searchText = text;
      let tenantFound = false;
      let propertyAddressFound = false;
      
      if (req.body.tenant_full_name) {
        const tenantFullName = req.body.tenant_full_name.trim();
        
        // Get better text for keyword matching from PDFs
        if (ext === 'pdf') {
          try {
            const pdfParse = require('pdf-parse');
            const dataBuffer = fsSync.readFileSync(filePath);
            const pdfData = await pdfParse(dataBuffer);
            searchText = pdfData.text.trim();
          } catch (pdfErr) {
            console.warn("pdf-parse failed → using OCR text", pdfErr);
          }
        }
        
        // Normalize text for case-insensitive search
        const lowerSearchText = searchText.toLowerCase();
        const lowerTenantName = tenantFullName.toLowerCase().trim();
        
        // Check if tenant name exists in document text
        if (lowerSearchText.includes(lowerTenantName)) {
          tenantFound = true;
          console.log(`Tenant name '${tenantFullName}' found in ${fileName}`);
        } else {
          console.log(`Tenant name '${tenantFullName}' NOT found in ${fileName}`);
        }
      }

      // Check if property_address exists in document
      if (req.body.property_address) {
        const propertyAddress = req.body.property_address.trim();
        
        // Use the same searchText that was prepared above (pdf-parse text if available)
        const lowerSearchText = searchText.toLowerCase();
        const lowerPropertyAddress = propertyAddress.toLowerCase().trim();
        
        // Check if property address exists in document text
        if (lowerSearchText.includes(lowerPropertyAddress)) {
          propertyAddressFound = true;
          console.log(`Property address '${propertyAddress}' found in ${fileName}`);
        } else {
          console.log(`Property address '${propertyAddress}' NOT found in ${fileName}`);
        }
      }

      // ────────────────────────────────────────────────
      // Special case 1: Support Session Notes → detailed yes/no steps (NO Mistral)
      if (field === SUPPORT_SESSION_NOTES_FIELD) {
        console.log(`→ Running DETAILED SUPPORT NEEDS logic for ${field}`);

        if (!tenantFound) {
          return res.status(400).json({ error: `Invalid document: tenant full name not found in ${fileName}` });
        }

        if (!propertyAddressFound) {
          return res.status(400).json({ error: `Invalid document: property address not found in ${fileName}` });
        }

        // ─── Week Blocks Validation for Support Session Notes ───
        if (req.body.week_blocks) {
          console.log(`→ Running WEEK BLOCKS validation for ${field}`);
          
          const weekBlocks = parseWeekBlocks(req.body.week_blocks);
          console.log("Parsed week blocks:", weekBlocks);
          
          // Use searchText for better extraction
          const textToValidate = searchText || text;
          
          if (weekBlocks.length > 0) {
            console.log(`Validating dates in ${fileName} against ${weekBlocks.length} week blocks`);
            const dateValidation = validateWeekBlocksDates(textToValidate, weekBlocks);
            
            if (!dateValidation.valid) {
              console.error(`Date validation failed for ${fileName}:`, dateValidation.error);
              return res.status(400).json({ 
                error: `Missing dates in ${fileName}: ${dateValidation.error}`,
                missingDatesByBlock: dateValidation.missingDatesByBlock
              });
            }
//             if (!dateValidation.valid) {
//   console.error(`Date validation failed for ${fileName}:`, dateValidation.error);

//   // Each block on a new line
//   const allMissing = Object.entries(dateValidation.missingDatesByBlock)
//     .map(
//       ([block, dates]) => `Block ${block}: Not Found dates ${dates.join(', ')};`
//     )
//     .join('\n'); // join with newline

//   return res.status(400).json({ 
//     error: `Missing dates in ${fileName}:<br>${allMissing}`,
//     missingDatesByBlock: dateValidation.missingDatesByBlock
//   });
// }
            
            console.log(`All dates are present in ${fileName}`);
          }
        }

        // Dynamic keys from frontend
        let supportNeedsKeys = [];
        try {
          if (req.body.supportNeedsKeys) {
            const parsed = JSON.parse(req.body.supportNeedsKeys);
            if (Array.isArray(parsed)) {
              supportNeedsKeys = parsed
                .map(k => String(k).trim().toLowerCase())
                .filter(k => k.length > 0);
            }
          }
        } catch (parseErr) {
          console.error("Failed to parse supportNeedsKeys:", parseErr);
        }

        // if (supportNeedsKeys.length === 0) {
        //   supportNeedsKeys = [
        //     "budgeting", "follow_a_healthy_diet", "register_with_a_dentist",
        //     "move_on", "maintain_accommodation"
        //   ];
        //   console.warn("No supportNeedsKeys → fallback list used");
        // }

        console.log("Processing support needs keys:", supportNeedsKeys);

        // ── COMPLETE stepExamples object (saare entries jo original code mein the) ──
        const stepExamples = {
          budgeting: [
            "1. Discussion and completion of income and expenditure form.",
            "2. Discussion and completion of a budgeting plan.",
            "3. Establish and review success of budget plan."
          ],
          follow_a_healthy_diet: [
            "1. Discussion and assessment of current eating habits.",
            "2. Discussion and agreement on an improvement strategy/plan.",
            "3. Guidance for access local services that may be required such as food banks or open kitchens."
          ],
          register_with_a_dentist: [
            "1. If already registered, locate dentist and seek to transfer to local surgery.",
            "2. If not already registered, register at nearest appropriate dentist",
            "3. Initiate first visit for a basic health check-up."
          ],
          move_on: [
            "1. Discussion on level of independent living skills and readiness for move-on.",
            "2. Discuss available housing including both social and private rented options.",
            "3. Agreement on a move-on strategy (areas, types of accommodation).",
            "4. Contacting relevant organisations and completion of forms.",
            "5. Provide updates on relevant and suitable housing options."
          ],
          maintain_accommodation: [
            "1. Discuss accommodation needs/issues.",
            "2. Discuss tenancy obligations and agreement to comply.",
            "3. On-going review of accommodation needs."
          ],
          accessing_benefits: [
            "1. Ensuring housing benefit claim is active.",
            "2. Address any benefit issues/concerns.",
            "3. Check all benefit entitlements are in place.",
            "4. Assist in making any necessary applications."
          ],
          better_manage_improve_mental_health: [
            "1. GP assessment of current mental health condition.",
            "2. Set targets for mental health improvement with relevant plan produced."
          ],
          reduce_substance_misuse_alcohol_drugs: [
            "1. Assessment of current substance misuse (amount and regularity etc).",
            "2. Discussion and agreement on reduction strategy",
            "3. On-going review/support with regards to"
          ],
          access_training_education: [
            "1. Agreement on appropriate training needs/desires.",
            "2. Searching local training providers for relevant courses",
            "3. Enrolment on course(s) and on-going review of attendances."
          ],
          accessing_employment: [
            "1. Production of Curriculum Vitae/work history.",
            "2. Agreement on appropriate job opportunities and job searching",
            "3. Interview techniques/confidence building programmes",
            "4. Ensure that client is actively seeking employment opportunities."
          ],
          reducing_debt: [
            "1. Assessment of debt/loan amounts.",
            "2. Gathering of paperwork on those owed money.",
            "3. Agreement on repayment plan.",
            "4. On-going review of commitment to repayment plan."
          ],
          setting_up_a_bank_savings_account: [
            "1. Agreeing on what type of account is required.",
            "2. Collecting and completing account forms.",
            "3. Assistance in obtaining and proof or documents required.",
            "4. Ensure benefit payments are set up for the new account if applicable."
          ],
          learn_how_to_shop_wisely: [
            "1. Discussion on shopping and spending habits.",
            "2. Agreement on relevant shopping/buying strategies.",
            "3. Implementation of spending plan and review timescales to help manage finances better."
          ],
          recoup_monies_owed: [
            "1. Assessment of exact amounts owed and contacting of debtors.",
            "2. Broker repayment plan(s) and make offer(s) of repayment.",
            "3. On-going review and/or the overseeing of "
          ],
          better_manage_improve_physical_health: [
            "1. GP assessment of current physical health condition.",
            "2. Set targets for physical health improvements.",
            "3. Agreement on a relevant health improvement plan. "
          ],
          maintain_good_personal_hygiene: [
            "1. Discussion and assessment of current personal hygiene habits",
            "2. Discussion and agreement to maintain personal hygien.",
            "3. On-going review of commitment plan and reminder to adhere to hygiene routine. "
          ],
          register_with_a_gp: [
            "1. If already registered, locate GP and seek to transfer to local surgery.",
            "2. If not already registered, register at nearest appropriate GP.",
            "3. Initiate first visit for a basic health check-up.",
            "4. Give reminders for any appointments when applicable."
          ],
          accessing_leisure_faith_or_cultural_activities: [
            "1. Discussion on what relevant and appropriate activities are of interest. ",
            "2. Sourcing where such opportunities are available and signpost.",
            "3. Provide guidance on how to access relevant services.",
            "4. Engagement in activities with a review of on going relevancy. "
          ],
          access_volunteering: [
            "1. Discussion on interests and skills as initial criteria.",
            "2. Investigation of what relevant schemes are available that fit these criteria.",
            "3. Assisting with completing applications.",
            "4. Agreeing volunteering commitment with on-going review of usefulness. "
          ],
          support_with_equality_and_diversity: [
            "1. Discussion on relevant equality and diversity support needs.",
            "2. Internal or external arrangement of support delivery.",
            "3. Delivery and on-going review of support received/delivered "
          ],
          establishing_positive_support_networks: [
            "1. Discussion and agreement on developing positive support networks. ",
            "2. Help with understanding positive and negative relationships.",
            "3. Guidance on how to build and maintain good support networks. "
          ],
          address_anti_social_behaviour: [
            "1. Discussion on tenancy and legal obligations.",
            "2. Agreement on a behaviour improvement plan/strategy.",
            "3. On-going review of behavioural support needs. "
          ],
          address_offending_behaviour: [
            "1. Discussion on the causes for the offending behaviour.",
            "2. Agreement and commitment to a reducing offending behaviour plan.",
            "3. On-going review including commitment to outside specialist agencies.",
            "4. Discuss probation agreement if applicable and ensure adherence.",
            "5. Monitor behaviour to check for improvement or any relapses."
          ],
          develop_independent_living_skills: [
            "1. Assessment of current living skills/abilities.",
            "2. Identify areas where skills need to be improved.",
            "3. Support in developing identified life skills.",
            "4. Provide information on how to improve life skills.",
            "5. Agreement on areas of development and commitment to improvement plan.",
            "6. On-going review of development."          
          ],
          minimize_risk_of_harm: [
            "1. Discussion and assessment on vulnerability and/or anger management.",
            "2. Agreement and commitment to a harm minimisation plan/strategy.",
            "3. Undertaking of helpful support and/or programmes to raise awareness.",
            "4. On-going review of adherence to the plan/strategy."
          ]
        };

        const resultsForFile = {};
        supportNeedsKeys.forEach(key => {
          resultsForFile[key] = [];
          const steps = stepExamples[key] || [];
          const positivePatterns = [/yes/i, /completed/i, /complete/i, /achieved/i, /done/i,
            /agreed/i, /✓/, /✔/, /active/i, /in place/i, /on-going review/i];

          steps.forEach(step => {
            const keyWords = step.replace(/^\d+\.\s*/, '').split(/\s+/).filter(w => w.length > 2).map(w => w.toLowerCase());
            const matchedKeyWords = keyWords.filter(w => {
              const escaped = w.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
              return new RegExp('\\b' + escaped + '\\b', 'i').test(searchText);
            });
            const hasKeyWords = matchedKeyWords.length >= 2;
            const hasPositive = positivePatterns.some(pat => pat.test(searchText));
            const isPositive = hasKeyWords && hasPositive;
            const prefix = isPositive ? "yes - " : "no - ";
            resultsForFile[key].push(prefix + step);
          });
        });

        results[fileName] = {
          file: fileName,
          type: "detailed_support_needs",
          selectedSupportItems: resultsForFile,
          chars: searchText.length,
          latestDate: extractLatestDate(searchText),
          supportNeedsKeysUsed: supportNeedsKeys
        };

        continue;  // Mistral call skip kar diya
      }

      // ────────────────────────────────────────────────
      // Special case 2: Support Plan → table extraction
      if (field === SUPPORT_PLAN_FIELD) {
        console.log(`→ Running SUPPORT PLAN CHOICES logic for ${field}`);
        
        // Validate tenant name and property address in support plan document
        if (!tenantFound) {
          return res.status(400).json({ error: `Invalid document: tenant full name not found in ${fileName}` });
        }
        
        if (!propertyAddressFound) {
          return res.status(400).json({ error: `Invalid document: property address not found in ${fileName}` });
        }
        
        isSupportPlan = true;

        filePrompt = `Extract the selected support choices from the Support Plan Choices table in the uploaded image.

The table has categories: ACHIEVING ECONOMIC WELLBEING, BEING HEALTHY, ENJOY AND ACHIEVE, MAKING A POSITIVE CONTRIBUTION, STAY SAFE.

Each category has sub-items with three columns: Sub-item name, Yes, No.

IMPORTANT: Carefully examine the image for visual marks in the Yes and No columns. Selections are indicated by:
- Text 'Yes' or 'No' written in the cells
- Visual symbols like ticks (✓), checkmarks (✔), X's (✗), crosses (✘), filled boxes, or any mark indicating selection
- If a symbol is present in the Yes column, it means "yes"
- If a symbol is present in the No column, it means "no"
- If no symbol in either column, default to "no"

Look closely at each row; the marks might be small or faint. Use the exact sub-item names as they appear.

Output ONLY a valid JSON object with no extra text or explanations: {"ACHIEVING ECONOMIC WELLBEING": {"Sub-item name": "yes", ...}, ...}`;
      } else {
        // Normal files (Referral, Daily Contact, Risk, etc.)
        // Validate tenant name and property address in normal document
        if (!tenantFound) {
          return res.status(400).json({ error: `Invalid document: tenant full name not found in ${fileName}` });
        }
        
        if (!propertyAddressFound) {
          return res.status(400).json({ error: `Invalid document: property address not found in ${fileName}` });
        }

        // ─── Week Blocks Validation for Daily Case and Contact Notes ───
        // Check if this is a daily_case_and_contact_notes file and week_blocks is provided
        const fieldLower = field.toLowerCase();
        const isDailyCaseAndContactNotes = fieldLower.includes('daily_case_and_contact_notes');
        
        if (isDailyCaseAndContactNotes && req.body.week_blocks) {
          console.log(`→ Running WEEK BLOCKS validation for ${field}`);
          
          const weekBlocks = parseWeekBlocks(req.body.week_blocks);
          console.log("Parsed week blocks:", weekBlocks);
          
          // Use searchText for better extraction (pdf-parse text for PDFs)
          const textToValidate = searchText || text;
          
          // Log the full text for debugging
          console.log("=== FULL TEXT FOR DATE EXTRACTION ===");
          console.log(textToValidate);
          console.log("=== END OF TEXT ===");
          
          if (weekBlocks.length > 0) {
            console.log(`Validating dates in ${fileName} against ${weekBlocks.length} week blocks`);
            const dateValidation = validateWeekBlocksDates(textToValidate, weekBlocks);
            
            if (!dateValidation.valid) {
              console.error(`Date validation failed for ${fileName}:`, dateValidation.error);
              return res.status(400).json({ 
                error: `Missing dates in ${fileName}: <br> ${dateValidation.error} <br>`,
                missingDatesByBlock: dateValidation.missingDatesByBlock
              });
            }
            
            console.log(`All dates are present in ${fileName}`);
          }
        }
        
        filePrompt = `Analyze ONLY this document for tenancy/support information.
Do NOT give generic support plan ideas.
Give numbered suggestions strictly from this file's content.

File: ${fileName}`;
      }

      // Support Plan ke liye PDF → image extract + upload
      let fileToUpload = uploadedFile;
      if (isSupportPlan && ext === 'pdf') {
        const imagePath = await extractSupportPlanImage(filePath);
        if (imagePath) {
          console.log("Uploading extracted support plan image:", imagePath);
          try {
            fileToUpload = await mistral.files.upload({
              file: createReadStream(imagePath),
              purpose: "assistants"
            });
            console.log("Uploaded image ID:", fileToUpload.id);
          } catch (e) {
            console.error("Image upload failed:", e);
            fileToUpload = uploadedFile; // fallback
          }
        }
      }

      messageContent = fileToUpload
        ? [{ type: "text", text: filePrompt }, { type: "file", file_id: fileToUpload.id }]
        : filePrompt + "\n\n[File upload failed, using extracted text]\n" + text;

      const content = await callMistralAgent(messageContent);

      if (isSupportPlan) {
        let selectedObject = {};
        let cleaned = content
          .replace(/```json|```/g, '')
          .replace(/^\s*[\w\s,:.-]+?\{/, '{')
          .trim();

        try {
          const parsed = JSON.parse(cleaned);
          if (typeof parsed === 'object' && !Array.isArray(parsed)) {
            selectedObject = parsed;
          }
        } catch (parseErr) {
          console.error("JSON parse failed for support plan:", parseErr);
        }

        results[fileName] = {
          file: fileName,
          type: "support_plan_choices",
          selectedSupportItems: selectedObject,
          chars: text.length,
          latestDate: extractLatestDate(text)
        };
      } else {
        const suggestions = formatNumberedSuggestions(content);
        results[fileName] = {
          file: fileName,
          type: "suggestions",
          suggestions,
          chars: text.length,
          latestDate: extractLatestDate(text)
        };
      }
    }

    res.json({
      success: true,
      results,
      totalFiles: Object.keys(files).length,
      tenantId: req.body.tenant_id
    });

  } catch (error) {
    console.error("Endpoint error:", error);
    res.status(500).json({ error: error.message || "Internal server error" });
  }
});




// ─── Only one listen call ───
app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});
