/**
 * Consumes a stream and returns a concatenated array buffer. Useful in
 * situations where we need to read the whole file because it forms part of a
 * larger payload containing other fields, and we can't modify the underlying
 * request structure.
 */
export declare function readableStreamToArrayBuffer(readable: ReadableStream<Uint8Array>): Promise<ArrayBuffer>;
/**
 * Determines the MIME content type based on a file's extension.
 * Returns null if the extension is not recognized.
 */
export declare function getContentTypeFromFileName(fileName: string): string | null;
//# sourceMappingURL=files.d.ts.map