"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryOut$ = exports.LibraryOut$outboundSchema = exports.LibraryOut$inboundSchema = void 0;
exports.libraryOutToJSON = libraryOutToJSON;
exports.libraryOutFromJSON = libraryOutFromJSON;
const z = __importStar(require("zod"));
const primitives_js_1 = require("../../lib/primitives.js");
const schemas_js_1 = require("../../lib/schemas.js");
/** @internal */
exports.LibraryOut$inboundSchema = z.object({
    id: z.string(),
    name: z.string(),
    created_at: z.string().datetime({ offset: true }).transform(v => new Date(v)),
    updated_at: z.string().datetime({ offset: true }).transform(v => new Date(v)),
    owner_id: z.string(),
    owner_type: z.string(),
    total_size: z.number().int(),
    nb_documents: z.number().int(),
    chunk_size: z.nullable(z.number().int()),
    emoji: z.nullable(z.string()).optional(),
    description: z.nullable(z.string()).optional(),
    generated_name: z.nullable(z.string()).optional(),
    generated_description: z.nullable(z.string()).optional(),
    explicit_user_members_count: z.nullable(z.number().int()).optional(),
    explicit_workspace_members_count: z.nullable(z.number().int()).optional(),
    org_sharing_role: z.nullable(z.string()).optional(),
}).transform((v) => {
    return (0, primitives_js_1.remap)(v, {
        "created_at": "createdAt",
        "updated_at": "updatedAt",
        "owner_id": "ownerId",
        "owner_type": "ownerType",
        "total_size": "totalSize",
        "nb_documents": "nbDocuments",
        "chunk_size": "chunkSize",
        "generated_name": "generatedName",
        "generated_description": "generatedDescription",
        "explicit_user_members_count": "explicitUserMembersCount",
        "explicit_workspace_members_count": "explicitWorkspaceMembersCount",
        "org_sharing_role": "orgSharingRole",
    });
});
/** @internal */
exports.LibraryOut$outboundSchema = z.object({
    id: z.string(),
    name: z.string(),
    createdAt: z.date().transform(v => v.toISOString()),
    updatedAt: z.date().transform(v => v.toISOString()),
    ownerId: z.string(),
    ownerType: z.string(),
    totalSize: z.number().int(),
    nbDocuments: z.number().int(),
    chunkSize: z.nullable(z.number().int()),
    emoji: z.nullable(z.string()).optional(),
    description: z.nullable(z.string()).optional(),
    generatedName: z.nullable(z.string()).optional(),
    generatedDescription: z.nullable(z.string()).optional(),
    explicitUserMembersCount: z.nullable(z.number().int()).optional(),
    explicitWorkspaceMembersCount: z.nullable(z.number().int()).optional(),
    orgSharingRole: z.nullable(z.string()).optional(),
}).transform((v) => {
    return (0, primitives_js_1.remap)(v, {
        createdAt: "created_at",
        updatedAt: "updated_at",
        ownerId: "owner_id",
        ownerType: "owner_type",
        totalSize: "total_size",
        nbDocuments: "nb_documents",
        chunkSize: "chunk_size",
        generatedName: "generated_name",
        generatedDescription: "generated_description",
        explicitUserMembersCount: "explicit_user_members_count",
        explicitWorkspaceMembersCount: "explicit_workspace_members_count",
        orgSharingRole: "org_sharing_role",
    });
});
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
var LibraryOut$;
(function (LibraryOut$) {
    /** @deprecated use `LibraryOut$inboundSchema` instead. */
    LibraryOut$.inboundSchema = exports.LibraryOut$inboundSchema;
    /** @deprecated use `LibraryOut$outboundSchema` instead. */
    LibraryOut$.outboundSchema = exports.LibraryOut$outboundSchema;
})(LibraryOut$ || (exports.LibraryOut$ = LibraryOut$ = {}));
function libraryOutToJSON(libraryOut) {
    return JSON.stringify(exports.LibraryOut$outboundSchema.parse(libraryOut));
}
function libraryOutFromJSON(jsonString) {
    return (0, schemas_js_1.safeParse)(jsonString, (x) => exports.LibraryOut$inboundSchema.parse(JSON.parse(x)), `Failed to parse 'LibraryOut' from JSON`);
}
//# sourceMappingURL=libraryout.js.map