"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SDKError = void 0;
const mistralerror_js_1 = require("./mistralerror.js");
/** The fallback error class if no more specific error class is matched */
class SDKError extends mistralerror_js_1.MistralError {
    constructor(message, httpMeta) {
        if (message) {
            message += `: `;
        }
        message += `Status ${httpMeta.response.status}`;
        const contentType = httpMeta.response.headers.get("content-type") || `""`;
        if (contentType !== "application/json") {
            message += ` Content-Type ${contentType.includes(" ") ? `"${contentType}"` : contentType}`;
        }
        const body = httpMeta.body || `""`;
        message += body.length > 100 ? "\n" : ". ";
        let bodyDisplay = body;
        if (body.length > 10000) {
            const truncated = body.substring(0, 10000);
            const remaining = body.length - 10000;
            bodyDisplay = `${truncated}...and ${remaining} more chars`;
        }
        message += `Body: ${bodyDisplay}`;
        message = message.trim();
        super(message, httpMeta);
        this.name = "SDKError";
    }
}
exports.SDKError = SDKError;
//# sourceMappingURL=sdkerror.js.map