import * as z from "zod";
import { Result as SafeParseResult } from "../../types/fp.js";
import * as components from "../components/index.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
export type AgentsApiV1ConversationsGetRequest = {
    /**
     * ID of the conversation from which we are fetching metadata.
     */
    conversationId: string;
};
/**
 * Successful Response
 */
export type AgentsApiV1ConversationsGetResponseV1ConversationsGet = components.ModelConversation | components.AgentConversation;
/** @internal */
export declare const AgentsApiV1ConversationsGetRequest$inboundSchema: z.ZodType<AgentsApiV1ConversationsGetRequest, z.ZodTypeDef, unknown>;
/** @internal */
export type AgentsApiV1ConversationsGetRequest$Outbound = {
    conversation_id: string;
};
/** @internal */
export declare const AgentsApiV1ConversationsGetRequest$outboundSchema: z.ZodType<AgentsApiV1ConversationsGetRequest$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsGetRequest>;
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export declare namespace AgentsApiV1ConversationsGetRequest$ {
    /** @deprecated use `AgentsApiV1ConversationsGetRequest$inboundSchema` instead. */
    const inboundSchema: z.ZodType<AgentsApiV1ConversationsGetRequest, z.ZodTypeDef, unknown>;
    /** @deprecated use `AgentsApiV1ConversationsGetRequest$outboundSchema` instead. */
    const outboundSchema: z.ZodType<AgentsApiV1ConversationsGetRequest$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsGetRequest>;
    /** @deprecated use `AgentsApiV1ConversationsGetRequest$Outbound` instead. */
    type Outbound = AgentsApiV1ConversationsGetRequest$Outbound;
}
export declare function agentsApiV1ConversationsGetRequestToJSON(agentsApiV1ConversationsGetRequest: AgentsApiV1ConversationsGetRequest): string;
export declare function agentsApiV1ConversationsGetRequestFromJSON(jsonString: string): SafeParseResult<AgentsApiV1ConversationsGetRequest, SDKValidationError>;
/** @internal */
export declare const AgentsApiV1ConversationsGetResponseV1ConversationsGet$inboundSchema: z.ZodType<AgentsApiV1ConversationsGetResponseV1ConversationsGet, z.ZodTypeDef, unknown>;
/** @internal */
export type AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound = components.ModelConversation$Outbound | components.AgentConversation$Outbound;
/** @internal */
export declare const AgentsApiV1ConversationsGetResponseV1ConversationsGet$outboundSchema: z.ZodType<AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsGetResponseV1ConversationsGet>;
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export declare namespace AgentsApiV1ConversationsGetResponseV1ConversationsGet$ {
    /** @deprecated use `AgentsApiV1ConversationsGetResponseV1ConversationsGet$inboundSchema` instead. */
    const inboundSchema: z.ZodType<AgentsApiV1ConversationsGetResponseV1ConversationsGet, z.ZodTypeDef, unknown>;
    /** @deprecated use `AgentsApiV1ConversationsGetResponseV1ConversationsGet$outboundSchema` instead. */
    const outboundSchema: z.ZodType<AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsGetResponseV1ConversationsGet>;
    /** @deprecated use `AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound` instead. */
    type Outbound = AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound;
}
export declare function agentsApiV1ConversationsGetResponseV1ConversationsGetToJSON(agentsApiV1ConversationsGetResponseV1ConversationsGet: AgentsApiV1ConversationsGetResponseV1ConversationsGet): string;
export declare function agentsApiV1ConversationsGetResponseV1ConversationsGetFromJSON(jsonString: string): SafeParseResult<AgentsApiV1ConversationsGetResponseV1ConversationsGet, SDKValidationError>;
//# sourceMappingURL=agentsapiv1conversationsget.d.ts.map