import * as z from "zod";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
export type AgentsApiV1ConversationsHistoryRequest = {
    /**
     * ID of the conversation from which we are fetching entries.
     */
    conversationId: string;
};
/** @internal */
export declare const AgentsApiV1ConversationsHistoryRequest$inboundSchema: z.ZodType<AgentsApiV1ConversationsHistoryRequest, z.ZodTypeDef, unknown>;
/** @internal */
export type AgentsApiV1ConversationsHistoryRequest$Outbound = {
    conversation_id: string;
};
/** @internal */
export declare const AgentsApiV1ConversationsHistoryRequest$outboundSchema: z.ZodType<AgentsApiV1ConversationsHistoryRequest$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsHistoryRequest>;
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export declare namespace AgentsApiV1ConversationsHistoryRequest$ {
    /** @deprecated use `AgentsApiV1ConversationsHistoryRequest$inboundSchema` instead. */
    const inboundSchema: z.ZodType<AgentsApiV1ConversationsHistoryRequest, z.ZodTypeDef, unknown>;
    /** @deprecated use `AgentsApiV1ConversationsHistoryRequest$outboundSchema` instead. */
    const outboundSchema: z.ZodType<AgentsApiV1ConversationsHistoryRequest$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsHistoryRequest>;
    /** @deprecated use `AgentsApiV1ConversationsHistoryRequest$Outbound` instead. */
    type Outbound = AgentsApiV1ConversationsHistoryRequest$Outbound;
}
export declare function agentsApiV1ConversationsHistoryRequestToJSON(agentsApiV1ConversationsHistoryRequest: AgentsApiV1ConversationsHistoryRequest): string;
export declare function agentsApiV1ConversationsHistoryRequestFromJSON(jsonString: string): SafeParseResult<AgentsApiV1ConversationsHistoryRequest, SDKValidationError>;
//# sourceMappingURL=agentsapiv1conversationshistory.d.ts.map