"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Documents = void 0;
const betaLibrariesDocumentsDelete_js_1 = require("../funcs/betaLibrariesDocumentsDelete.js");
const betaLibrariesDocumentsExtractedTextSignedUrl_js_1 = require("../funcs/betaLibrariesDocumentsExtractedTextSignedUrl.js");
const betaLibrariesDocumentsGet_js_1 = require("../funcs/betaLibrariesDocumentsGet.js");
const betaLibrariesDocumentsGetSignedUrl_js_1 = require("../funcs/betaLibrariesDocumentsGetSignedUrl.js");
const betaLibrariesDocumentsList_js_1 = require("../funcs/betaLibrariesDocumentsList.js");
const betaLibrariesDocumentsReprocess_js_1 = require("../funcs/betaLibrariesDocumentsReprocess.js");
const betaLibrariesDocumentsStatus_js_1 = require("../funcs/betaLibrariesDocumentsStatus.js");
const betaLibrariesDocumentsTextContent_js_1 = require("../funcs/betaLibrariesDocumentsTextContent.js");
const betaLibrariesDocumentsUpdate_js_1 = require("../funcs/betaLibrariesDocumentsUpdate.js");
const betaLibrariesDocumentsUpload_js_1 = require("../funcs/betaLibrariesDocumentsUpload.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
class Documents extends sdks_js_1.ClientSDK {
    /**
     * List document in a given library.
     *
     * @remarks
     * Given a library, lists the document that have been uploaded to that library.
     */
    async list(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsList_js_1.betaLibrariesDocumentsList)(this, request, options));
    }
    /**
     * Upload a new document.
     *
     * @remarks
     * Given a library, upload a new document to that library. It is queued for processing, it status will change it has been processed. The processing has to be completed in order be discoverable for the library search
     */
    async upload(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsUpload_js_1.betaLibrariesDocumentsUpload)(this, request, options));
    }
    /**
     * Retrieve the metadata of a specific document.
     *
     * @remarks
     * Given a library and a document in this library, you can retrieve the metadata of that document.
     */
    async get(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsGet_js_1.betaLibrariesDocumentsGet)(this, request, options));
    }
    /**
     * Update the metadata of a specific document.
     *
     * @remarks
     * Given a library and a document in that library, update the name of that document.
     */
    async update(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsUpdate_js_1.betaLibrariesDocumentsUpdate)(this, request, options));
    }
    /**
     * Delete a document.
     *
     * @remarks
     * Given a library and a document in that library, delete that document. The document will be deleted from the library and the search index.
     */
    async delete(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsDelete_js_1.betaLibrariesDocumentsDelete)(this, request, options));
    }
    /**
     * Retrieve the text content of a specific document.
     *
     * @remarks
     * Given a library and a document in that library, you can retrieve the text content of that document if it exists. For documents like pdf, docx and pptx the text content results from our processing using Mistral OCR.
     */
    async textContent(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsTextContent_js_1.betaLibrariesDocumentsTextContent)(this, request, options));
    }
    /**
     * Retrieve the processing status of a specific document.
     *
     * @remarks
     * Given a library and a document in that library, retrieve the processing status of that document.
     */
    async status(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsStatus_js_1.betaLibrariesDocumentsStatus)(this, request, options));
    }
    /**
     * Retrieve the signed URL of a specific document.
     *
     * @remarks
     * Given a library and a document in that library, retrieve the signed URL of a specific document.The url will expire after 30 minutes and can be accessed by anyone with the link.
     */
    async getSignedUrl(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsGetSignedUrl_js_1.betaLibrariesDocumentsGetSignedUrl)(this, request, options));
    }
    /**
     * Retrieve the signed URL of text extracted from a given document.
     *
     * @remarks
     * Given a library and a document in that library, retrieve the signed URL of text extracted. For documents that are sent to the OCR this returns the result of the OCR queries.
     */
    async extractedTextSignedUrl(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsExtractedTextSignedUrl_js_1.betaLibrariesDocumentsExtractedTextSignedUrl)(this, request, options));
    }
    /**
     * Reprocess a document.
     *
     * @remarks
     * Given a library and a document in that library, reprocess that document, it will be billed again.
     */
    async reprocess(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDocumentsReprocess_js_1.betaLibrariesDocumentsReprocess)(this, request, options));
    }
}
exports.Documents = Documents;
//# sourceMappingURL=documents.js.map