## Context

The `src/extra` folder contains the custom logic which is too complex to be generated by Speakeasy from the OpenAPI specs. It was introduced to add the Structured Outputs feature.

## Development / Contributing

To add custom code in the SDK, you need to use [Speakeasy custom code regions](https://www.speakeasy.com/docs/customize/code/code-regions/overview) as below.

### Runbook of SDK customization

1. Add the code you want to import in the `src/extra/` folder. To have it importable from the SDK, don't forget the `export` statement.


2. Add a new custom code region in the SDK files, e.g in `src/sdk/chat.py`:
```ts
// #region imports
import { my_custom_function } from "../extra/my_custom_file.js";
// #endregion imports

export class Chat extends ClientSDK {
    // #region sdk-class-body
    async myMethod(param1: string): Promise<some_type> {
        const output = await my_custom_function(param1);
        return output;
    }
    // #endregion sdk-class-body
}
```

3. Now build the SDK with the custom code:
```bash
npm run build
```

4. And now you should be able to call the custom method:
```ts
import { Mistral } from "@mistralai/mistralai";

const apiKey = process.env["MISTRAL_API_KEY"];
const client = new Mistral({ apiKey: apiKey });

const response = await client.chat.myMethod("test");
```

### Run the unit tests

To run the unit tests for the `extra` package, you can run the following command from the root of the repository:
```bash
npm install --prefix tests
npm run build
(cd tests && npm test)
```
