/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { MistralCore } from "../core.js";
import { appendForm } from "../lib/encodings.js";
import {
  getContentTypeFromFileName,
  readableStreamToArrayBuffer,
} from "../lib/files.js";
import * as M from "../lib/matchers.js";
import { compactMap } from "../lib/primitives.js";
import { safeParse } from "../lib/schemas.js";
import { RequestOptions } from "../lib/sdks.js";
import { extractSecurity, resolveGlobalSecurity } from "../lib/security.js";
import { pathToFunc } from "../lib/url.js";
import * as components from "../models/components/index.js";
import {
  ConnectionError,
  InvalidRequestError,
  RequestAbortedError,
  RequestTimeoutError,
  UnexpectedClientError,
} from "../models/errors/httpclienterrors.js";
import { MistralError } from "../models/errors/mistralerror.js";
import { ResponseValidationError } from "../models/errors/responsevalidationerror.js";
import { SDKValidationError } from "../models/errors/sdkvalidationerror.js";
import * as operations from "../models/operations/index.js";
import { APICall, APIPromise } from "../types/async.js";
import { isBlobLike } from "../types/blobs.js";
import { Result } from "../types/fp.js";
import { isReadableStream } from "../types/streams.js";

/**
 * Upload File
 *
 * @remarks
 * Upload a file that can be used across various endpoints.
 *
 * The size of individual files can be a maximum of 512 MB. The Fine-tuning API only supports .jsonl files.
 *
 * Please contact us if you need to increase these storage limits.
 */
export function filesUpload(
  client: MistralCore,
  request: operations.FilesApiRoutesUploadFileMultiPartBodyParams,
  options?: RequestOptions,
): APIPromise<
  Result<
    components.UploadFileOut,
    | MistralError
    | ResponseValidationError
    | ConnectionError
    | RequestAbortedError
    | RequestTimeoutError
    | InvalidRequestError
    | UnexpectedClientError
    | SDKValidationError
  >
> {
  return new APIPromise($do(
    client,
    request,
    options,
  ));
}

async function $do(
  client: MistralCore,
  request: operations.FilesApiRoutesUploadFileMultiPartBodyParams,
  options?: RequestOptions,
): Promise<
  [
    Result<
      components.UploadFileOut,
      | MistralError
      | ResponseValidationError
      | ConnectionError
      | RequestAbortedError
      | RequestTimeoutError
      | InvalidRequestError
      | UnexpectedClientError
      | SDKValidationError
    >,
    APICall,
  ]
> {
  const parsed = safeParse(
    request,
    (value) =>
      operations.FilesApiRoutesUploadFileMultiPartBodyParams$outboundSchema
        .parse(value),
    "Input validation failed",
  );
  if (!parsed.ok) {
    return [parsed, { status: "invalid" }];
  }
  const payload = parsed.value;
  const body = new FormData();

  if (isBlobLike(payload.file)) {
    appendForm(body, "file", payload.file);
  } else if (isReadableStream(payload.file.content)) {
    const buffer = await readableStreamToArrayBuffer(payload.file.content);
    const contentType = getContentTypeFromFileName(payload.file.fileName)
      || "application/octet-stream";
    const blob = new Blob([buffer], { type: contentType });
    appendForm(body, "file", blob, payload.file.fileName);
  } else {
    const contentType = getContentTypeFromFileName(payload.file.fileName)
      || "application/octet-stream";
    appendForm(
      body,
      "file",
      new Blob([payload.file.content], { type: contentType }),
      payload.file.fileName,
    );
  }
  if (payload.purpose !== undefined) {
    appendForm(body, "purpose", payload.purpose);
  }

  const path = pathToFunc("/v1/files")();

  const headers = new Headers(compactMap({
    Accept: "application/json",
  }));

  const secConfig = await extractSecurity(client._options.apiKey);
  const securityInput = secConfig == null ? {} : { apiKey: secConfig };
  const requestSecurity = resolveGlobalSecurity(securityInput);

  const context = {
    options: client._options,
    baseURL: options?.serverURL ?? client._baseURL ?? "",
    operationID: "files_api_routes_upload_file",
    oAuth2Scopes: [],

    resolvedSecurity: requestSecurity,

    securitySource: client._options.apiKey,
    retryConfig: options?.retries
      || client._options.retryConfig
      || { strategy: "none" },
    retryCodes: options?.retryCodes || ["429", "500", "502", "503", "504"],
  };

  const requestRes = client._createRequest(context, {
    security: requestSecurity,
    method: "POST",
    baseURL: options?.serverURL,
    path: path,
    headers: headers,
    body: body,
    userAgent: client._options.userAgent,
    timeoutMs: options?.timeoutMs || client._options.timeoutMs || -1,
  }, options);
  if (!requestRes.ok) {
    return [requestRes, { status: "invalid" }];
  }
  const req = requestRes.value;

  const doResult = await client._do(req, {
    context,
    errorCodes: ["4XX", "5XX"],
    retryConfig: context.retryConfig,
    retryCodes: context.retryCodes,
  });
  if (!doResult.ok) {
    return [doResult, { status: "request-error", request: req }];
  }
  const response = doResult.value;

  const [result] = await M.match<
    components.UploadFileOut,
    | MistralError
    | ResponseValidationError
    | ConnectionError
    | RequestAbortedError
    | RequestTimeoutError
    | InvalidRequestError
    | UnexpectedClientError
    | SDKValidationError
  >(
    M.json(200, components.UploadFileOut$inboundSchema),
    M.fail("4XX"),
    M.fail("5XX"),
  )(response, req);
  if (!result.ok) {
    return [result, { status: "complete", request: req, response }];
  }

  return [result, { status: "complete", request: req, response }];
}
