/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export const AgentConversationObject = {
  Conversation: "conversation",
} as const;
export type AgentConversationObject = ClosedEnum<
  typeof AgentConversationObject
>;

export type AgentConversation = {
  /**
   * Name given to the conversation.
   */
  name?: string | null | undefined;
  /**
   * Description of the what the conversation is about.
   */
  description?: string | null | undefined;
  object?: AgentConversationObject | undefined;
  id: string;
  createdAt: Date;
  updatedAt: Date;
  agentId: string;
};

/** @internal */
export const AgentConversationObject$inboundSchema: z.ZodNativeEnum<
  typeof AgentConversationObject
> = z.nativeEnum(AgentConversationObject);

/** @internal */
export const AgentConversationObject$outboundSchema: z.ZodNativeEnum<
  typeof AgentConversationObject
> = AgentConversationObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentConversationObject$ {
  /** @deprecated use `AgentConversationObject$inboundSchema` instead. */
  export const inboundSchema = AgentConversationObject$inboundSchema;
  /** @deprecated use `AgentConversationObject$outboundSchema` instead. */
  export const outboundSchema = AgentConversationObject$outboundSchema;
}

/** @internal */
export const AgentConversation$inboundSchema: z.ZodType<
  AgentConversation,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  object: AgentConversationObject$inboundSchema.default("conversation"),
  id: z.string(),
  created_at: z.string().datetime({ offset: true }).transform(v => new Date(v)),
  updated_at: z.string().datetime({ offset: true }).transform(v => new Date(v)),
  agent_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "created_at": "createdAt",
    "updated_at": "updatedAt",
    "agent_id": "agentId",
  });
});

/** @internal */
export type AgentConversation$Outbound = {
  name?: string | null | undefined;
  description?: string | null | undefined;
  object: string;
  id: string;
  created_at: string;
  updated_at: string;
  agent_id: string;
};

/** @internal */
export const AgentConversation$outboundSchema: z.ZodType<
  AgentConversation$Outbound,
  z.ZodTypeDef,
  AgentConversation
> = z.object({
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  object: AgentConversationObject$outboundSchema.default("conversation"),
  id: z.string(),
  createdAt: z.date().transform(v => v.toISOString()),
  updatedAt: z.date().transform(v => v.toISOString()),
  agentId: z.string(),
}).transform((v) => {
  return remap$(v, {
    createdAt: "created_at",
    updatedAt: "updated_at",
    agentId: "agent_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentConversation$ {
  /** @deprecated use `AgentConversation$inboundSchema` instead. */
  export const inboundSchema = AgentConversation$inboundSchema;
  /** @deprecated use `AgentConversation$outboundSchema` instead. */
  export const outboundSchema = AgentConversation$outboundSchema;
  /** @deprecated use `AgentConversation$Outbound` instead. */
  export type Outbound = AgentConversation$Outbound;
}

export function agentConversationToJSON(
  agentConversation: AgentConversation,
): string {
  return JSON.stringify(
    AgentConversation$outboundSchema.parse(agentConversation),
  );
}

export function agentConversationFromJSON(
  jsonString: string,
): SafeParseResult<AgentConversation, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentConversation$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentConversation' from JSON`,
  );
}
