/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CodeInterpreterTool,
  CodeInterpreterTool$inboundSchema,
  CodeInterpreterTool$Outbound,
  CodeInterpreterTool$outboundSchema,
} from "./codeinterpretertool.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  DocumentLibraryTool,
  DocumentLibraryTool$inboundSchema,
  DocumentLibraryTool$Outbound,
  DocumentLibraryTool$outboundSchema,
} from "./documentlibrarytool.js";
import {
  FunctionTool,
  FunctionTool$inboundSchema,
  FunctionTool$Outbound,
  FunctionTool$outboundSchema,
} from "./functiontool.js";
import {
  ImageGenerationTool,
  ImageGenerationTool$inboundSchema,
  ImageGenerationTool$Outbound,
  ImageGenerationTool$outboundSchema,
} from "./imagegenerationtool.js";
import {
  WebSearchPremiumTool,
  WebSearchPremiumTool$inboundSchema,
  WebSearchPremiumTool$Outbound,
  WebSearchPremiumTool$outboundSchema,
} from "./websearchpremiumtool.js";
import {
  WebSearchTool,
  WebSearchTool$inboundSchema,
  WebSearchTool$Outbound,
  WebSearchTool$outboundSchema,
} from "./websearchtool.js";

export type AgentCreationRequestTools =
  | (DocumentLibraryTool & { type: "document_library" })
  | (FunctionTool & { type: "function" })
  | (CodeInterpreterTool & { type: "code_interpreter" })
  | (ImageGenerationTool & { type: "image_generation" })
  | (WebSearchTool & { type: "web_search" })
  | (WebSearchPremiumTool & { type: "web_search_premium" });

export type AgentCreationRequest = {
  /**
   * Instruction prompt the model will follow during the conversation.
   */
  instructions?: string | null | undefined;
  /**
   * List of tools which are available to the model during the conversation.
   */
  tools?:
    | Array<
      | (DocumentLibraryTool & { type: "document_library" })
      | (FunctionTool & { type: "function" })
      | (CodeInterpreterTool & { type: "code_interpreter" })
      | (ImageGenerationTool & { type: "image_generation" })
      | (WebSearchTool & { type: "web_search" })
      | (WebSearchPremiumTool & { type: "web_search_premium" })
    >
    | undefined;
  /**
   * White-listed arguments from the completion API
   */
  completionArgs?: CompletionArgs | undefined;
  model: string;
  name: string;
  description?: string | null | undefined;
  handoffs?: Array<string> | null | undefined;
};

/** @internal */
export const AgentCreationRequestTools$inboundSchema: z.ZodType<
  AgentCreationRequestTools,
  z.ZodTypeDef,
  unknown
> = z.union([
  DocumentLibraryTool$inboundSchema.and(
    z.object({ type: z.literal("document_library") }).transform((v) => ({
      type: v.type,
    })),
  ),
  FunctionTool$inboundSchema.and(
    z.object({ type: z.literal("function") }).transform((v) => ({
      type: v.type,
    })),
  ),
  CodeInterpreterTool$inboundSchema.and(
    z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ImageGenerationTool$inboundSchema.and(
    z.object({ type: z.literal("image_generation") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchTool$inboundSchema.and(
    z.object({ type: z.literal("web_search") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchPremiumTool$inboundSchema.and(
    z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/** @internal */
export type AgentCreationRequestTools$Outbound =
  | (DocumentLibraryTool$Outbound & { type: "document_library" })
  | (FunctionTool$Outbound & { type: "function" })
  | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
  | (ImageGenerationTool$Outbound & { type: "image_generation" })
  | (WebSearchTool$Outbound & { type: "web_search" })
  | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" });

/** @internal */
export const AgentCreationRequestTools$outboundSchema: z.ZodType<
  AgentCreationRequestTools$Outbound,
  z.ZodTypeDef,
  AgentCreationRequestTools
> = z.union([
  DocumentLibraryTool$outboundSchema.and(
    z.object({ type: z.literal("document_library") }).transform((v) => ({
      type: v.type,
    })),
  ),
  FunctionTool$outboundSchema.and(
    z.object({ type: z.literal("function") }).transform((v) => ({
      type: v.type,
    })),
  ),
  CodeInterpreterTool$outboundSchema.and(
    z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ImageGenerationTool$outboundSchema.and(
    z.object({ type: z.literal("image_generation") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchTool$outboundSchema.and(
    z.object({ type: z.literal("web_search") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchPremiumTool$outboundSchema.and(
    z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentCreationRequestTools$ {
  /** @deprecated use `AgentCreationRequestTools$inboundSchema` instead. */
  export const inboundSchema = AgentCreationRequestTools$inboundSchema;
  /** @deprecated use `AgentCreationRequestTools$outboundSchema` instead. */
  export const outboundSchema = AgentCreationRequestTools$outboundSchema;
  /** @deprecated use `AgentCreationRequestTools$Outbound` instead. */
  export type Outbound = AgentCreationRequestTools$Outbound;
}

export function agentCreationRequestToolsToJSON(
  agentCreationRequestTools: AgentCreationRequestTools,
): string {
  return JSON.stringify(
    AgentCreationRequestTools$outboundSchema.parse(agentCreationRequestTools),
  );
}

export function agentCreationRequestToolsFromJSON(
  jsonString: string,
): SafeParseResult<AgentCreationRequestTools, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentCreationRequestTools$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentCreationRequestTools' from JSON`,
  );
}

/** @internal */
export const AgentCreationRequest$inboundSchema: z.ZodType<
  AgentCreationRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  instructions: z.nullable(z.string()).optional(),
  tools: z.array(
    z.union([
      DocumentLibraryTool$inboundSchema.and(
        z.object({ type: z.literal("document_library") }).transform((v) => ({
          type: v.type,
        })),
      ),
      FunctionTool$inboundSchema.and(
        z.object({ type: z.literal("function") }).transform((v) => ({
          type: v.type,
        })),
      ),
      CodeInterpreterTool$inboundSchema.and(
        z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
          type: v.type,
        })),
      ),
      ImageGenerationTool$inboundSchema.and(
        z.object({ type: z.literal("image_generation") }).transform((v) => ({
          type: v.type,
        })),
      ),
      WebSearchTool$inboundSchema.and(
        z.object({ type: z.literal("web_search") }).transform((v) => ({
          type: v.type,
        })),
      ),
      WebSearchPremiumTool$inboundSchema.and(
        z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
          type: v.type,
        })),
      ),
    ]),
  ).optional(),
  completion_args: CompletionArgs$inboundSchema.optional(),
  model: z.string(),
  name: z.string(),
  description: z.nullable(z.string()).optional(),
  handoffs: z.nullable(z.array(z.string())).optional(),
}).transform((v) => {
  return remap$(v, {
    "completion_args": "completionArgs",
  });
});

/** @internal */
export type AgentCreationRequest$Outbound = {
  instructions?: string | null | undefined;
  tools?:
    | Array<
      | (DocumentLibraryTool$Outbound & { type: "document_library" })
      | (FunctionTool$Outbound & { type: "function" })
      | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
      | (ImageGenerationTool$Outbound & { type: "image_generation" })
      | (WebSearchTool$Outbound & { type: "web_search" })
      | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" })
    >
    | undefined;
  completion_args?: CompletionArgs$Outbound | undefined;
  model: string;
  name: string;
  description?: string | null | undefined;
  handoffs?: Array<string> | null | undefined;
};

/** @internal */
export const AgentCreationRequest$outboundSchema: z.ZodType<
  AgentCreationRequest$Outbound,
  z.ZodTypeDef,
  AgentCreationRequest
> = z.object({
  instructions: z.nullable(z.string()).optional(),
  tools: z.array(
    z.union([
      DocumentLibraryTool$outboundSchema.and(
        z.object({ type: z.literal("document_library") }).transform((v) => ({
          type: v.type,
        })),
      ),
      FunctionTool$outboundSchema.and(
        z.object({ type: z.literal("function") }).transform((v) => ({
          type: v.type,
        })),
      ),
      CodeInterpreterTool$outboundSchema.and(
        z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
          type: v.type,
        })),
      ),
      ImageGenerationTool$outboundSchema.and(
        z.object({ type: z.literal("image_generation") }).transform((v) => ({
          type: v.type,
        })),
      ),
      WebSearchTool$outboundSchema.and(
        z.object({ type: z.literal("web_search") }).transform((v) => ({
          type: v.type,
        })),
      ),
      WebSearchPremiumTool$outboundSchema.and(
        z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
          type: v.type,
        })),
      ),
    ]),
  ).optional(),
  completionArgs: CompletionArgs$outboundSchema.optional(),
  model: z.string(),
  name: z.string(),
  description: z.nullable(z.string()).optional(),
  handoffs: z.nullable(z.array(z.string())).optional(),
}).transform((v) => {
  return remap$(v, {
    completionArgs: "completion_args",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentCreationRequest$ {
  /** @deprecated use `AgentCreationRequest$inboundSchema` instead. */
  export const inboundSchema = AgentCreationRequest$inboundSchema;
  /** @deprecated use `AgentCreationRequest$outboundSchema` instead. */
  export const outboundSchema = AgentCreationRequest$outboundSchema;
  /** @deprecated use `AgentCreationRequest$Outbound` instead. */
  export type Outbound = AgentCreationRequest$Outbound;
}

export function agentCreationRequestToJSON(
  agentCreationRequest: AgentCreationRequest,
): string {
  return JSON.stringify(
    AgentCreationRequest$outboundSchema.parse(agentCreationRequest),
  );
}

export function agentCreationRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentCreationRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentCreationRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentCreationRequest' from JSON`,
  );
}
