/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export const AgentHandoffEntryObject = {
  Entry: "entry",
} as const;
export type AgentHandoffEntryObject = ClosedEnum<
  typeof AgentHandoffEntryObject
>;

export const AgentHandoffEntryType = {
  AgentHandoff: "agent.handoff",
} as const;
export type AgentHandoffEntryType = ClosedEnum<typeof AgentHandoffEntryType>;

export type AgentHandoffEntry = {
  object?: AgentHandoffEntryObject | undefined;
  type?: AgentHandoffEntryType | undefined;
  createdAt?: Date | undefined;
  completedAt?: Date | null | undefined;
  id?: string | undefined;
  previousAgentId: string;
  previousAgentName: string;
  nextAgentId: string;
  nextAgentName: string;
};

/** @internal */
export const AgentHandoffEntryObject$inboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffEntryObject
> = z.nativeEnum(AgentHandoffEntryObject);

/** @internal */
export const AgentHandoffEntryObject$outboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffEntryObject
> = AgentHandoffEntryObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentHandoffEntryObject$ {
  /** @deprecated use `AgentHandoffEntryObject$inboundSchema` instead. */
  export const inboundSchema = AgentHandoffEntryObject$inboundSchema;
  /** @deprecated use `AgentHandoffEntryObject$outboundSchema` instead. */
  export const outboundSchema = AgentHandoffEntryObject$outboundSchema;
}

/** @internal */
export const AgentHandoffEntryType$inboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffEntryType
> = z.nativeEnum(AgentHandoffEntryType);

/** @internal */
export const AgentHandoffEntryType$outboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffEntryType
> = AgentHandoffEntryType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentHandoffEntryType$ {
  /** @deprecated use `AgentHandoffEntryType$inboundSchema` instead. */
  export const inboundSchema = AgentHandoffEntryType$inboundSchema;
  /** @deprecated use `AgentHandoffEntryType$outboundSchema` instead. */
  export const outboundSchema = AgentHandoffEntryType$outboundSchema;
}

/** @internal */
export const AgentHandoffEntry$inboundSchema: z.ZodType<
  AgentHandoffEntry,
  z.ZodTypeDef,
  unknown
> = z.object({
  object: AgentHandoffEntryObject$inboundSchema.default("entry"),
  type: AgentHandoffEntryType$inboundSchema.default("agent.handoff"),
  created_at: z.string().datetime({ offset: true }).transform(v => new Date(v))
    .optional(),
  completed_at: z.nullable(
    z.string().datetime({ offset: true }).transform(v => new Date(v)),
  ).optional(),
  id: z.string().optional(),
  previous_agent_id: z.string(),
  previous_agent_name: z.string(),
  next_agent_id: z.string(),
  next_agent_name: z.string(),
}).transform((v) => {
  return remap$(v, {
    "created_at": "createdAt",
    "completed_at": "completedAt",
    "previous_agent_id": "previousAgentId",
    "previous_agent_name": "previousAgentName",
    "next_agent_id": "nextAgentId",
    "next_agent_name": "nextAgentName",
  });
});

/** @internal */
export type AgentHandoffEntry$Outbound = {
  object: string;
  type: string;
  created_at?: string | undefined;
  completed_at?: string | null | undefined;
  id?: string | undefined;
  previous_agent_id: string;
  previous_agent_name: string;
  next_agent_id: string;
  next_agent_name: string;
};

/** @internal */
export const AgentHandoffEntry$outboundSchema: z.ZodType<
  AgentHandoffEntry$Outbound,
  z.ZodTypeDef,
  AgentHandoffEntry
> = z.object({
  object: AgentHandoffEntryObject$outboundSchema.default("entry"),
  type: AgentHandoffEntryType$outboundSchema.default("agent.handoff"),
  createdAt: z.date().transform(v => v.toISOString()).optional(),
  completedAt: z.nullable(z.date().transform(v => v.toISOString())).optional(),
  id: z.string().optional(),
  previousAgentId: z.string(),
  previousAgentName: z.string(),
  nextAgentId: z.string(),
  nextAgentName: z.string(),
}).transform((v) => {
  return remap$(v, {
    createdAt: "created_at",
    completedAt: "completed_at",
    previousAgentId: "previous_agent_id",
    previousAgentName: "previous_agent_name",
    nextAgentId: "next_agent_id",
    nextAgentName: "next_agent_name",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentHandoffEntry$ {
  /** @deprecated use `AgentHandoffEntry$inboundSchema` instead. */
  export const inboundSchema = AgentHandoffEntry$inboundSchema;
  /** @deprecated use `AgentHandoffEntry$outboundSchema` instead. */
  export const outboundSchema = AgentHandoffEntry$outboundSchema;
  /** @deprecated use `AgentHandoffEntry$Outbound` instead. */
  export type Outbound = AgentHandoffEntry$Outbound;
}

export function agentHandoffEntryToJSON(
  agentHandoffEntry: AgentHandoffEntry,
): string {
  return JSON.stringify(
    AgentHandoffEntry$outboundSchema.parse(agentHandoffEntry),
  );
}

export function agentHandoffEntryFromJSON(
  jsonString: string,
): SafeParseResult<AgentHandoffEntry, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentHandoffEntry$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentHandoffEntry' from JSON`,
  );
}
