/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { blobLikeSchema } from "../../types/blobs.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  FileT,
  FileT$inboundSchema,
  FileT$Outbound,
  FileT$outboundSchema,
} from "./file.js";
import {
  TimestampGranularity,
  TimestampGranularity$inboundSchema,
  TimestampGranularity$outboundSchema,
} from "./timestampgranularity.js";

export type AudioTranscriptionRequestStream = {
  model: string;
  file?: FileT | Blob | undefined;
  /**
   * Url of a file to be transcribed
   */
  fileUrl?: string | null | undefined;
  /**
   * ID of a file uploaded to /v1/files
   */
  fileId?: string | null | undefined;
  /**
   * Language of the audio, e.g. 'en'. Providing the language can boost accuracy.
   */
  language?: string | null | undefined;
  temperature?: number | null | undefined;
  stream?: true | undefined;
  /**
   * Granularities of timestamps to include in the response.
   */
  timestampGranularities?: Array<TimestampGranularity> | undefined;
};

/** @internal */
export const AudioTranscriptionRequestStream$inboundSchema: z.ZodType<
  AudioTranscriptionRequestStream,
  z.ZodTypeDef,
  unknown
> = z.object({
  model: z.string(),
  file: FileT$inboundSchema.optional(),
  file_url: z.nullable(z.string()).optional(),
  file_id: z.nullable(z.string()).optional(),
  language: z.nullable(z.string()).optional(),
  temperature: z.nullable(z.number()).optional(),
  stream: z.literal(true).default(true),
  timestamp_granularities: z.array(TimestampGranularity$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "file_url": "fileUrl",
    "file_id": "fileId",
    "timestamp_granularities": "timestampGranularities",
  });
});

/** @internal */
export type AudioTranscriptionRequestStream$Outbound = {
  model: string;
  file?: FileT$Outbound | Blob | undefined;
  file_url?: string | null | undefined;
  file_id?: string | null | undefined;
  language?: string | null | undefined;
  temperature?: number | null | undefined;
  stream: true;
  timestamp_granularities?: Array<string> | undefined;
};

/** @internal */
export const AudioTranscriptionRequestStream$outboundSchema: z.ZodType<
  AudioTranscriptionRequestStream$Outbound,
  z.ZodTypeDef,
  AudioTranscriptionRequestStream
> = z.object({
  model: z.string(),
  file: FileT$outboundSchema.or(blobLikeSchema).optional(),
  fileUrl: z.nullable(z.string()).optional(),
  fileId: z.nullable(z.string()).optional(),
  language: z.nullable(z.string()).optional(),
  temperature: z.nullable(z.number()).optional(),
  stream: z.literal(true).default(true as const),
  timestampGranularities: z.array(TimestampGranularity$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    fileUrl: "file_url",
    fileId: "file_id",
    timestampGranularities: "timestamp_granularities",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AudioTranscriptionRequestStream$ {
  /** @deprecated use `AudioTranscriptionRequestStream$inboundSchema` instead. */
  export const inboundSchema = AudioTranscriptionRequestStream$inboundSchema;
  /** @deprecated use `AudioTranscriptionRequestStream$outboundSchema` instead. */
  export const outboundSchema = AudioTranscriptionRequestStream$outboundSchema;
  /** @deprecated use `AudioTranscriptionRequestStream$Outbound` instead. */
  export type Outbound = AudioTranscriptionRequestStream$Outbound;
}

export function audioTranscriptionRequestStreamToJSON(
  audioTranscriptionRequestStream: AudioTranscriptionRequestStream,
): string {
  return JSON.stringify(
    AudioTranscriptionRequestStream$outboundSchema.parse(
      audioTranscriptionRequestStream,
    ),
  );
}

export function audioTranscriptionRequestStreamFromJSON(
  jsonString: string,
): SafeParseResult<AudioTranscriptionRequestStream, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AudioTranscriptionRequestStream$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AudioTranscriptionRequestStream' from JSON`,
  );
}
