/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  ApiEndpoint,
  ApiEndpoint$inboundSchema,
  ApiEndpoint$outboundSchema,
} from "./apiendpoint.js";

export type BatchJobIn = {
  inputFiles: Array<string>;
  endpoint: ApiEndpoint;
  model?: string | null | undefined;
  agentId?: string | null | undefined;
  metadata?: { [k: string]: string } | null | undefined;
  timeoutHours?: number | undefined;
};

/** @internal */
export const BatchJobIn$inboundSchema: z.ZodType<
  BatchJobIn,
  z.ZodTypeDef,
  unknown
> = z.object({
  input_files: z.array(z.string()),
  endpoint: ApiEndpoint$inboundSchema,
  model: z.nullable(z.string()).optional(),
  agent_id: z.nullable(z.string()).optional(),
  metadata: z.nullable(z.record(z.string())).optional(),
  timeout_hours: z.number().int().default(24),
}).transform((v) => {
  return remap$(v, {
    "input_files": "inputFiles",
    "agent_id": "agentId",
    "timeout_hours": "timeoutHours",
  });
});

/** @internal */
export type BatchJobIn$Outbound = {
  input_files: Array<string>;
  endpoint: string;
  model?: string | null | undefined;
  agent_id?: string | null | undefined;
  metadata?: { [k: string]: string } | null | undefined;
  timeout_hours: number;
};

/** @internal */
export const BatchJobIn$outboundSchema: z.ZodType<
  BatchJobIn$Outbound,
  z.ZodTypeDef,
  BatchJobIn
> = z.object({
  inputFiles: z.array(z.string()),
  endpoint: ApiEndpoint$outboundSchema,
  model: z.nullable(z.string()).optional(),
  agentId: z.nullable(z.string()).optional(),
  metadata: z.nullable(z.record(z.string())).optional(),
  timeoutHours: z.number().int().default(24),
}).transform((v) => {
  return remap$(v, {
    inputFiles: "input_files",
    agentId: "agent_id",
    timeoutHours: "timeout_hours",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BatchJobIn$ {
  /** @deprecated use `BatchJobIn$inboundSchema` instead. */
  export const inboundSchema = BatchJobIn$inboundSchema;
  /** @deprecated use `BatchJobIn$outboundSchema` instead. */
  export const outboundSchema = BatchJobIn$outboundSchema;
  /** @deprecated use `BatchJobIn$Outbound` instead. */
  export type Outbound = BatchJobIn$Outbound;
}

export function batchJobInToJSON(batchJobIn: BatchJobIn): string {
  return JSON.stringify(BatchJobIn$outboundSchema.parse(batchJobIn));
}

export function batchJobInFromJSON(
  jsonString: string,
): SafeParseResult<BatchJobIn, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => BatchJobIn$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'BatchJobIn' from JSON`,
  );
}
