/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  Inputs,
  Inputs$inboundSchema,
  Inputs$Outbound,
  Inputs$outboundSchema,
} from "./inputs.js";

export type ChatClassificationRequest = {
  model: string;
  /**
   * Chat to classify
   */
  inputs: Inputs;
};

/** @internal */
export const ChatClassificationRequest$inboundSchema: z.ZodType<
  ChatClassificationRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  model: z.string(),
  input: Inputs$inboundSchema,
}).transform((v) => {
  return remap$(v, {
    "input": "inputs",
  });
});

/** @internal */
export type ChatClassificationRequest$Outbound = {
  model: string;
  input: Inputs$Outbound;
};

/** @internal */
export const ChatClassificationRequest$outboundSchema: z.ZodType<
  ChatClassificationRequest$Outbound,
  z.ZodTypeDef,
  ChatClassificationRequest
> = z.object({
  model: z.string(),
  inputs: Inputs$outboundSchema,
}).transform((v) => {
  return remap$(v, {
    inputs: "input",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ChatClassificationRequest$ {
  /** @deprecated use `ChatClassificationRequest$inboundSchema` instead. */
  export const inboundSchema = ChatClassificationRequest$inboundSchema;
  /** @deprecated use `ChatClassificationRequest$outboundSchema` instead. */
  export const outboundSchema = ChatClassificationRequest$outboundSchema;
  /** @deprecated use `ChatClassificationRequest$Outbound` instead. */
  export type Outbound = ChatClassificationRequest$Outbound;
}

export function chatClassificationRequestToJSON(
  chatClassificationRequest: ChatClassificationRequest,
): string {
  return JSON.stringify(
    ChatClassificationRequest$outboundSchema.parse(chatClassificationRequest),
  );
}

export function chatClassificationRequestFromJSON(
  jsonString: string,
): SafeParseResult<ChatClassificationRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ChatClassificationRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ChatClassificationRequest' from JSON`,
  );
}
