/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  MetricOut,
  MetricOut$inboundSchema,
  MetricOut$Outbound,
  MetricOut$outboundSchema,
} from "./metricout.js";

export type CheckpointOut = {
  /**
   * Metrics at the step number during the fine-tuning job. Use these metrics to assess if the training is going smoothly (loss should decrease, token accuracy should increase).
   */
  metrics: MetricOut;
  /**
   * The step number that the checkpoint was created at.
   */
  stepNumber: number;
  /**
   * The UNIX timestamp (in seconds) for when the checkpoint was created.
   */
  createdAt: number;
};

/** @internal */
export const CheckpointOut$inboundSchema: z.ZodType<
  CheckpointOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  metrics: MetricOut$inboundSchema,
  step_number: z.number().int(),
  created_at: z.number().int(),
}).transform((v) => {
  return remap$(v, {
    "step_number": "stepNumber",
    "created_at": "createdAt",
  });
});

/** @internal */
export type CheckpointOut$Outbound = {
  metrics: MetricOut$Outbound;
  step_number: number;
  created_at: number;
};

/** @internal */
export const CheckpointOut$outboundSchema: z.ZodType<
  CheckpointOut$Outbound,
  z.ZodTypeDef,
  CheckpointOut
> = z.object({
  metrics: MetricOut$outboundSchema,
  stepNumber: z.number().int(),
  createdAt: z.number().int(),
}).transform((v) => {
  return remap$(v, {
    stepNumber: "step_number",
    createdAt: "created_at",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CheckpointOut$ {
  /** @deprecated use `CheckpointOut$inboundSchema` instead. */
  export const inboundSchema = CheckpointOut$inboundSchema;
  /** @deprecated use `CheckpointOut$outboundSchema` instead. */
  export const outboundSchema = CheckpointOut$outboundSchema;
  /** @deprecated use `CheckpointOut$Outbound` instead. */
  export type Outbound = CheckpointOut$Outbound;
}

export function checkpointOutToJSON(checkpointOut: CheckpointOut): string {
  return JSON.stringify(CheckpointOut$outboundSchema.parse(checkpointOut));
}

export function checkpointOutFromJSON(
  jsonString: string,
): SafeParseResult<CheckpointOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => CheckpointOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CheckpointOut' from JSON`,
  );
}
