/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  ClassifierTrainingParameters,
  ClassifierTrainingParameters$inboundSchema,
  ClassifierTrainingParameters$Outbound,
  ClassifierTrainingParameters$outboundSchema,
} from "./classifiertrainingparameters.js";
import {
  JobMetadataOut,
  JobMetadataOut$inboundSchema,
  JobMetadataOut$Outbound,
  JobMetadataOut$outboundSchema,
} from "./jobmetadataout.js";
import {
  WandbIntegrationOut,
  WandbIntegrationOut$inboundSchema,
  WandbIntegrationOut$Outbound,
  WandbIntegrationOut$outboundSchema,
} from "./wandbintegrationout.js";

/**
 * The current status of the fine-tuning job.
 */
export const ClassifierJobOutStatus = {
  Queued: "QUEUED",
  Started: "STARTED",
  Validating: "VALIDATING",
  Validated: "VALIDATED",
  Running: "RUNNING",
  FailedValidation: "FAILED_VALIDATION",
  Failed: "FAILED",
  Success: "SUCCESS",
  Cancelled: "CANCELLED",
  CancellationRequested: "CANCELLATION_REQUESTED",
} as const;
/**
 * The current status of the fine-tuning job.
 */
export type ClassifierJobOutStatus = ClosedEnum<typeof ClassifierJobOutStatus>;

/**
 * The object type of the fine-tuning job.
 */
export const ClassifierJobOutObject = {
  Job: "job",
} as const;
/**
 * The object type of the fine-tuning job.
 */
export type ClassifierJobOutObject = ClosedEnum<typeof ClassifierJobOutObject>;

export type ClassifierJobOutIntegrations = WandbIntegrationOut;

/**
 * The type of job (`FT` for fine-tuning).
 */
export const ClassifierJobOutJobType = {
  Classifier: "classifier",
} as const;
/**
 * The type of job (`FT` for fine-tuning).
 */
export type ClassifierJobOutJobType = ClosedEnum<
  typeof ClassifierJobOutJobType
>;

export type ClassifierJobOut = {
  /**
   * The ID of the job.
   */
  id: string;
  autoStart: boolean;
  /**
   * The name of the model to fine-tune.
   */
  model: string;
  /**
   * The current status of the fine-tuning job.
   */
  status: ClassifierJobOutStatus;
  /**
   * The UNIX timestamp (in seconds) for when the fine-tuning job was created.
   */
  createdAt: number;
  /**
   * The UNIX timestamp (in seconds) for when the fine-tuning job was last modified.
   */
  modifiedAt: number;
  /**
   * A list containing the IDs of uploaded files that contain training data.
   */
  trainingFiles: Array<string>;
  /**
   * A list containing the IDs of uploaded files that contain validation data.
   */
  validationFiles?: Array<string> | null | undefined;
  /**
   * The object type of the fine-tuning job.
   */
  object?: ClassifierJobOutObject | undefined;
  /**
   * The name of the fine-tuned model that is being created. The value will be `null` if the fine-tuning job is still running.
   */
  fineTunedModel?: string | null | undefined;
  /**
   * Optional text/code that adds more context for the model. When given a `prompt` and a `suffix` the model will fill what is between them. When `suffix` is not provided, the model will simply execute completion starting with `prompt`.
   */
  suffix?: string | null | undefined;
  /**
   * A list of integrations enabled for your fine-tuning job.
   */
  integrations?: Array<WandbIntegrationOut> | null | undefined;
  /**
   * Total number of tokens trained.
   */
  trainedTokens?: number | null | undefined;
  metadata?: JobMetadataOut | null | undefined;
  /**
   * The type of job (`FT` for fine-tuning).
   */
  jobType?: ClassifierJobOutJobType | undefined;
  hyperparameters: ClassifierTrainingParameters;
};

/** @internal */
export const ClassifierJobOutStatus$inboundSchema: z.ZodNativeEnum<
  typeof ClassifierJobOutStatus
> = z.nativeEnum(ClassifierJobOutStatus);

/** @internal */
export const ClassifierJobOutStatus$outboundSchema: z.ZodNativeEnum<
  typeof ClassifierJobOutStatus
> = ClassifierJobOutStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierJobOutStatus$ {
  /** @deprecated use `ClassifierJobOutStatus$inboundSchema` instead. */
  export const inboundSchema = ClassifierJobOutStatus$inboundSchema;
  /** @deprecated use `ClassifierJobOutStatus$outboundSchema` instead. */
  export const outboundSchema = ClassifierJobOutStatus$outboundSchema;
}

/** @internal */
export const ClassifierJobOutObject$inboundSchema: z.ZodNativeEnum<
  typeof ClassifierJobOutObject
> = z.nativeEnum(ClassifierJobOutObject);

/** @internal */
export const ClassifierJobOutObject$outboundSchema: z.ZodNativeEnum<
  typeof ClassifierJobOutObject
> = ClassifierJobOutObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierJobOutObject$ {
  /** @deprecated use `ClassifierJobOutObject$inboundSchema` instead. */
  export const inboundSchema = ClassifierJobOutObject$inboundSchema;
  /** @deprecated use `ClassifierJobOutObject$outboundSchema` instead. */
  export const outboundSchema = ClassifierJobOutObject$outboundSchema;
}

/** @internal */
export const ClassifierJobOutIntegrations$inboundSchema: z.ZodType<
  ClassifierJobOutIntegrations,
  z.ZodTypeDef,
  unknown
> = WandbIntegrationOut$inboundSchema;

/** @internal */
export type ClassifierJobOutIntegrations$Outbound =
  WandbIntegrationOut$Outbound;

/** @internal */
export const ClassifierJobOutIntegrations$outboundSchema: z.ZodType<
  ClassifierJobOutIntegrations$Outbound,
  z.ZodTypeDef,
  ClassifierJobOutIntegrations
> = WandbIntegrationOut$outboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierJobOutIntegrations$ {
  /** @deprecated use `ClassifierJobOutIntegrations$inboundSchema` instead. */
  export const inboundSchema = ClassifierJobOutIntegrations$inboundSchema;
  /** @deprecated use `ClassifierJobOutIntegrations$outboundSchema` instead. */
  export const outboundSchema = ClassifierJobOutIntegrations$outboundSchema;
  /** @deprecated use `ClassifierJobOutIntegrations$Outbound` instead. */
  export type Outbound = ClassifierJobOutIntegrations$Outbound;
}

export function classifierJobOutIntegrationsToJSON(
  classifierJobOutIntegrations: ClassifierJobOutIntegrations,
): string {
  return JSON.stringify(
    ClassifierJobOutIntegrations$outboundSchema.parse(
      classifierJobOutIntegrations,
    ),
  );
}

export function classifierJobOutIntegrationsFromJSON(
  jsonString: string,
): SafeParseResult<ClassifierJobOutIntegrations, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassifierJobOutIntegrations$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassifierJobOutIntegrations' from JSON`,
  );
}

/** @internal */
export const ClassifierJobOutJobType$inboundSchema: z.ZodNativeEnum<
  typeof ClassifierJobOutJobType
> = z.nativeEnum(ClassifierJobOutJobType);

/** @internal */
export const ClassifierJobOutJobType$outboundSchema: z.ZodNativeEnum<
  typeof ClassifierJobOutJobType
> = ClassifierJobOutJobType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierJobOutJobType$ {
  /** @deprecated use `ClassifierJobOutJobType$inboundSchema` instead. */
  export const inboundSchema = ClassifierJobOutJobType$inboundSchema;
  /** @deprecated use `ClassifierJobOutJobType$outboundSchema` instead. */
  export const outboundSchema = ClassifierJobOutJobType$outboundSchema;
}

/** @internal */
export const ClassifierJobOut$inboundSchema: z.ZodType<
  ClassifierJobOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  auto_start: z.boolean(),
  model: z.string(),
  status: ClassifierJobOutStatus$inboundSchema,
  created_at: z.number().int(),
  modified_at: z.number().int(),
  training_files: z.array(z.string()),
  validation_files: z.nullable(z.array(z.string())).optional(),
  object: ClassifierJobOutObject$inboundSchema.default("job"),
  fine_tuned_model: z.nullable(z.string()).optional(),
  suffix: z.nullable(z.string()).optional(),
  integrations: z.nullable(z.array(WandbIntegrationOut$inboundSchema))
    .optional(),
  trained_tokens: z.nullable(z.number().int()).optional(),
  metadata: z.nullable(JobMetadataOut$inboundSchema).optional(),
  job_type: ClassifierJobOutJobType$inboundSchema.default("classifier"),
  hyperparameters: ClassifierTrainingParameters$inboundSchema,
}).transform((v) => {
  return remap$(v, {
    "auto_start": "autoStart",
    "created_at": "createdAt",
    "modified_at": "modifiedAt",
    "training_files": "trainingFiles",
    "validation_files": "validationFiles",
    "fine_tuned_model": "fineTunedModel",
    "trained_tokens": "trainedTokens",
    "job_type": "jobType",
  });
});

/** @internal */
export type ClassifierJobOut$Outbound = {
  id: string;
  auto_start: boolean;
  model: string;
  status: string;
  created_at: number;
  modified_at: number;
  training_files: Array<string>;
  validation_files?: Array<string> | null | undefined;
  object: string;
  fine_tuned_model?: string | null | undefined;
  suffix?: string | null | undefined;
  integrations?: Array<WandbIntegrationOut$Outbound> | null | undefined;
  trained_tokens?: number | null | undefined;
  metadata?: JobMetadataOut$Outbound | null | undefined;
  job_type: string;
  hyperparameters: ClassifierTrainingParameters$Outbound;
};

/** @internal */
export const ClassifierJobOut$outboundSchema: z.ZodType<
  ClassifierJobOut$Outbound,
  z.ZodTypeDef,
  ClassifierJobOut
> = z.object({
  id: z.string(),
  autoStart: z.boolean(),
  model: z.string(),
  status: ClassifierJobOutStatus$outboundSchema,
  createdAt: z.number().int(),
  modifiedAt: z.number().int(),
  trainingFiles: z.array(z.string()),
  validationFiles: z.nullable(z.array(z.string())).optional(),
  object: ClassifierJobOutObject$outboundSchema.default("job"),
  fineTunedModel: z.nullable(z.string()).optional(),
  suffix: z.nullable(z.string()).optional(),
  integrations: z.nullable(z.array(WandbIntegrationOut$outboundSchema))
    .optional(),
  trainedTokens: z.nullable(z.number().int()).optional(),
  metadata: z.nullable(JobMetadataOut$outboundSchema).optional(),
  jobType: ClassifierJobOutJobType$outboundSchema.default("classifier"),
  hyperparameters: ClassifierTrainingParameters$outboundSchema,
}).transform((v) => {
  return remap$(v, {
    autoStart: "auto_start",
    createdAt: "created_at",
    modifiedAt: "modified_at",
    trainingFiles: "training_files",
    validationFiles: "validation_files",
    fineTunedModel: "fine_tuned_model",
    trainedTokens: "trained_tokens",
    jobType: "job_type",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierJobOut$ {
  /** @deprecated use `ClassifierJobOut$inboundSchema` instead. */
  export const inboundSchema = ClassifierJobOut$inboundSchema;
  /** @deprecated use `ClassifierJobOut$outboundSchema` instead. */
  export const outboundSchema = ClassifierJobOut$outboundSchema;
  /** @deprecated use `ClassifierJobOut$Outbound` instead. */
  export type Outbound = ClassifierJobOut$Outbound;
}

export function classifierJobOutToJSON(
  classifierJobOut: ClassifierJobOut,
): string {
  return JSON.stringify(
    ClassifierJobOut$outboundSchema.parse(classifierJobOut),
  );
}

export function classifierJobOutFromJSON(
  jsonString: string,
): SafeParseResult<ClassifierJobOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassifierJobOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassifierJobOut' from JSON`,
  );
}
