/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CheckpointOut,
  CheckpointOut$inboundSchema,
  CheckpointOut$Outbound,
  CheckpointOut$outboundSchema,
} from "./checkpointout.js";
import {
  CompletionTrainingParameters,
  CompletionTrainingParameters$inboundSchema,
  CompletionTrainingParameters$Outbound,
  CompletionTrainingParameters$outboundSchema,
} from "./completiontrainingparameters.js";
import {
  EventOut,
  EventOut$inboundSchema,
  EventOut$Outbound,
  EventOut$outboundSchema,
} from "./eventout.js";
import {
  GithubRepositoryOut,
  GithubRepositoryOut$inboundSchema,
  GithubRepositoryOut$Outbound,
  GithubRepositoryOut$outboundSchema,
} from "./githubrepositoryout.js";
import {
  JobMetadataOut,
  JobMetadataOut$inboundSchema,
  JobMetadataOut$Outbound,
  JobMetadataOut$outboundSchema,
} from "./jobmetadataout.js";
import {
  WandbIntegrationOut,
  WandbIntegrationOut$inboundSchema,
  WandbIntegrationOut$Outbound,
  WandbIntegrationOut$outboundSchema,
} from "./wandbintegrationout.js";

export const CompletionDetailedJobOutStatus = {
  Queued: "QUEUED",
  Started: "STARTED",
  Validating: "VALIDATING",
  Validated: "VALIDATED",
  Running: "RUNNING",
  FailedValidation: "FAILED_VALIDATION",
  Failed: "FAILED",
  Success: "SUCCESS",
  Cancelled: "CANCELLED",
  CancellationRequested: "CANCELLATION_REQUESTED",
} as const;
export type CompletionDetailedJobOutStatus = ClosedEnum<
  typeof CompletionDetailedJobOutStatus
>;

export const CompletionDetailedJobOutObject = {
  Job: "job",
} as const;
export type CompletionDetailedJobOutObject = ClosedEnum<
  typeof CompletionDetailedJobOutObject
>;

export type CompletionDetailedJobOutIntegrations = WandbIntegrationOut;

export const CompletionDetailedJobOutJobType = {
  Completion: "completion",
} as const;
export type CompletionDetailedJobOutJobType = ClosedEnum<
  typeof CompletionDetailedJobOutJobType
>;

export type CompletionDetailedJobOutRepositories = GithubRepositoryOut;

export type CompletionDetailedJobOut = {
  id: string;
  autoStart: boolean;
  /**
   * The name of the model to fine-tune.
   */
  model: string;
  status: CompletionDetailedJobOutStatus;
  createdAt: number;
  modifiedAt: number;
  trainingFiles: Array<string>;
  validationFiles?: Array<string> | null | undefined;
  object?: CompletionDetailedJobOutObject | undefined;
  fineTunedModel?: string | null | undefined;
  suffix?: string | null | undefined;
  integrations?: Array<WandbIntegrationOut> | null | undefined;
  trainedTokens?: number | null | undefined;
  metadata?: JobMetadataOut | null | undefined;
  jobType?: CompletionDetailedJobOutJobType | undefined;
  hyperparameters: CompletionTrainingParameters;
  repositories?: Array<GithubRepositoryOut> | undefined;
  /**
   * Event items are created every time the status of a fine-tuning job changes. The timestamped list of all events is accessible here.
   */
  events?: Array<EventOut> | undefined;
  checkpoints?: Array<CheckpointOut> | undefined;
};

/** @internal */
export const CompletionDetailedJobOutStatus$inboundSchema: z.ZodNativeEnum<
  typeof CompletionDetailedJobOutStatus
> = z.nativeEnum(CompletionDetailedJobOutStatus);

/** @internal */
export const CompletionDetailedJobOutStatus$outboundSchema: z.ZodNativeEnum<
  typeof CompletionDetailedJobOutStatus
> = CompletionDetailedJobOutStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionDetailedJobOutStatus$ {
  /** @deprecated use `CompletionDetailedJobOutStatus$inboundSchema` instead. */
  export const inboundSchema = CompletionDetailedJobOutStatus$inboundSchema;
  /** @deprecated use `CompletionDetailedJobOutStatus$outboundSchema` instead. */
  export const outboundSchema = CompletionDetailedJobOutStatus$outboundSchema;
}

/** @internal */
export const CompletionDetailedJobOutObject$inboundSchema: z.ZodNativeEnum<
  typeof CompletionDetailedJobOutObject
> = z.nativeEnum(CompletionDetailedJobOutObject);

/** @internal */
export const CompletionDetailedJobOutObject$outboundSchema: z.ZodNativeEnum<
  typeof CompletionDetailedJobOutObject
> = CompletionDetailedJobOutObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionDetailedJobOutObject$ {
  /** @deprecated use `CompletionDetailedJobOutObject$inboundSchema` instead. */
  export const inboundSchema = CompletionDetailedJobOutObject$inboundSchema;
  /** @deprecated use `CompletionDetailedJobOutObject$outboundSchema` instead. */
  export const outboundSchema = CompletionDetailedJobOutObject$outboundSchema;
}

/** @internal */
export const CompletionDetailedJobOutIntegrations$inboundSchema: z.ZodType<
  CompletionDetailedJobOutIntegrations,
  z.ZodTypeDef,
  unknown
> = WandbIntegrationOut$inboundSchema;

/** @internal */
export type CompletionDetailedJobOutIntegrations$Outbound =
  WandbIntegrationOut$Outbound;

/** @internal */
export const CompletionDetailedJobOutIntegrations$outboundSchema: z.ZodType<
  CompletionDetailedJobOutIntegrations$Outbound,
  z.ZodTypeDef,
  CompletionDetailedJobOutIntegrations
> = WandbIntegrationOut$outboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionDetailedJobOutIntegrations$ {
  /** @deprecated use `CompletionDetailedJobOutIntegrations$inboundSchema` instead. */
  export const inboundSchema =
    CompletionDetailedJobOutIntegrations$inboundSchema;
  /** @deprecated use `CompletionDetailedJobOutIntegrations$outboundSchema` instead. */
  export const outboundSchema =
    CompletionDetailedJobOutIntegrations$outboundSchema;
  /** @deprecated use `CompletionDetailedJobOutIntegrations$Outbound` instead. */
  export type Outbound = CompletionDetailedJobOutIntegrations$Outbound;
}

export function completionDetailedJobOutIntegrationsToJSON(
  completionDetailedJobOutIntegrations: CompletionDetailedJobOutIntegrations,
): string {
  return JSON.stringify(
    CompletionDetailedJobOutIntegrations$outboundSchema.parse(
      completionDetailedJobOutIntegrations,
    ),
  );
}

export function completionDetailedJobOutIntegrationsFromJSON(
  jsonString: string,
): SafeParseResult<CompletionDetailedJobOutIntegrations, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      CompletionDetailedJobOutIntegrations$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CompletionDetailedJobOutIntegrations' from JSON`,
  );
}

/** @internal */
export const CompletionDetailedJobOutJobType$inboundSchema: z.ZodNativeEnum<
  typeof CompletionDetailedJobOutJobType
> = z.nativeEnum(CompletionDetailedJobOutJobType);

/** @internal */
export const CompletionDetailedJobOutJobType$outboundSchema: z.ZodNativeEnum<
  typeof CompletionDetailedJobOutJobType
> = CompletionDetailedJobOutJobType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionDetailedJobOutJobType$ {
  /** @deprecated use `CompletionDetailedJobOutJobType$inboundSchema` instead. */
  export const inboundSchema = CompletionDetailedJobOutJobType$inboundSchema;
  /** @deprecated use `CompletionDetailedJobOutJobType$outboundSchema` instead. */
  export const outboundSchema = CompletionDetailedJobOutJobType$outboundSchema;
}

/** @internal */
export const CompletionDetailedJobOutRepositories$inboundSchema: z.ZodType<
  CompletionDetailedJobOutRepositories,
  z.ZodTypeDef,
  unknown
> = GithubRepositoryOut$inboundSchema;

/** @internal */
export type CompletionDetailedJobOutRepositories$Outbound =
  GithubRepositoryOut$Outbound;

/** @internal */
export const CompletionDetailedJobOutRepositories$outboundSchema: z.ZodType<
  CompletionDetailedJobOutRepositories$Outbound,
  z.ZodTypeDef,
  CompletionDetailedJobOutRepositories
> = GithubRepositoryOut$outboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionDetailedJobOutRepositories$ {
  /** @deprecated use `CompletionDetailedJobOutRepositories$inboundSchema` instead. */
  export const inboundSchema =
    CompletionDetailedJobOutRepositories$inboundSchema;
  /** @deprecated use `CompletionDetailedJobOutRepositories$outboundSchema` instead. */
  export const outboundSchema =
    CompletionDetailedJobOutRepositories$outboundSchema;
  /** @deprecated use `CompletionDetailedJobOutRepositories$Outbound` instead. */
  export type Outbound = CompletionDetailedJobOutRepositories$Outbound;
}

export function completionDetailedJobOutRepositoriesToJSON(
  completionDetailedJobOutRepositories: CompletionDetailedJobOutRepositories,
): string {
  return JSON.stringify(
    CompletionDetailedJobOutRepositories$outboundSchema.parse(
      completionDetailedJobOutRepositories,
    ),
  );
}

export function completionDetailedJobOutRepositoriesFromJSON(
  jsonString: string,
): SafeParseResult<CompletionDetailedJobOutRepositories, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      CompletionDetailedJobOutRepositories$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CompletionDetailedJobOutRepositories' from JSON`,
  );
}

/** @internal */
export const CompletionDetailedJobOut$inboundSchema: z.ZodType<
  CompletionDetailedJobOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  auto_start: z.boolean(),
  model: z.string(),
  status: CompletionDetailedJobOutStatus$inboundSchema,
  created_at: z.number().int(),
  modified_at: z.number().int(),
  training_files: z.array(z.string()),
  validation_files: z.nullable(z.array(z.string())).optional(),
  object: CompletionDetailedJobOutObject$inboundSchema.default("job"),
  fine_tuned_model: z.nullable(z.string()).optional(),
  suffix: z.nullable(z.string()).optional(),
  integrations: z.nullable(z.array(WandbIntegrationOut$inboundSchema))
    .optional(),
  trained_tokens: z.nullable(z.number().int()).optional(),
  metadata: z.nullable(JobMetadataOut$inboundSchema).optional(),
  job_type: CompletionDetailedJobOutJobType$inboundSchema.default("completion"),
  hyperparameters: CompletionTrainingParameters$inboundSchema,
  repositories: z.array(GithubRepositoryOut$inboundSchema).optional(),
  events: z.array(EventOut$inboundSchema).optional(),
  checkpoints: z.array(CheckpointOut$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "auto_start": "autoStart",
    "created_at": "createdAt",
    "modified_at": "modifiedAt",
    "training_files": "trainingFiles",
    "validation_files": "validationFiles",
    "fine_tuned_model": "fineTunedModel",
    "trained_tokens": "trainedTokens",
    "job_type": "jobType",
  });
});

/** @internal */
export type CompletionDetailedJobOut$Outbound = {
  id: string;
  auto_start: boolean;
  model: string;
  status: string;
  created_at: number;
  modified_at: number;
  training_files: Array<string>;
  validation_files?: Array<string> | null | undefined;
  object: string;
  fine_tuned_model?: string | null | undefined;
  suffix?: string | null | undefined;
  integrations?: Array<WandbIntegrationOut$Outbound> | null | undefined;
  trained_tokens?: number | null | undefined;
  metadata?: JobMetadataOut$Outbound | null | undefined;
  job_type: string;
  hyperparameters: CompletionTrainingParameters$Outbound;
  repositories?: Array<GithubRepositoryOut$Outbound> | undefined;
  events?: Array<EventOut$Outbound> | undefined;
  checkpoints?: Array<CheckpointOut$Outbound> | undefined;
};

/** @internal */
export const CompletionDetailedJobOut$outboundSchema: z.ZodType<
  CompletionDetailedJobOut$Outbound,
  z.ZodTypeDef,
  CompletionDetailedJobOut
> = z.object({
  id: z.string(),
  autoStart: z.boolean(),
  model: z.string(),
  status: CompletionDetailedJobOutStatus$outboundSchema,
  createdAt: z.number().int(),
  modifiedAt: z.number().int(),
  trainingFiles: z.array(z.string()),
  validationFiles: z.nullable(z.array(z.string())).optional(),
  object: CompletionDetailedJobOutObject$outboundSchema.default("job"),
  fineTunedModel: z.nullable(z.string()).optional(),
  suffix: z.nullable(z.string()).optional(),
  integrations: z.nullable(z.array(WandbIntegrationOut$outboundSchema))
    .optional(),
  trainedTokens: z.nullable(z.number().int()).optional(),
  metadata: z.nullable(JobMetadataOut$outboundSchema).optional(),
  jobType: CompletionDetailedJobOutJobType$outboundSchema.default("completion"),
  hyperparameters: CompletionTrainingParameters$outboundSchema,
  repositories: z.array(GithubRepositoryOut$outboundSchema).optional(),
  events: z.array(EventOut$outboundSchema).optional(),
  checkpoints: z.array(CheckpointOut$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    autoStart: "auto_start",
    createdAt: "created_at",
    modifiedAt: "modified_at",
    trainingFiles: "training_files",
    validationFiles: "validation_files",
    fineTunedModel: "fine_tuned_model",
    trainedTokens: "trained_tokens",
    jobType: "job_type",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionDetailedJobOut$ {
  /** @deprecated use `CompletionDetailedJobOut$inboundSchema` instead. */
  export const inboundSchema = CompletionDetailedJobOut$inboundSchema;
  /** @deprecated use `CompletionDetailedJobOut$outboundSchema` instead. */
  export const outboundSchema = CompletionDetailedJobOut$outboundSchema;
  /** @deprecated use `CompletionDetailedJobOut$Outbound` instead. */
  export type Outbound = CompletionDetailedJobOut$Outbound;
}

export function completionDetailedJobOutToJSON(
  completionDetailedJobOut: CompletionDetailedJobOut,
): string {
  return JSON.stringify(
    CompletionDetailedJobOut$outboundSchema.parse(completionDetailedJobOut),
  );
}

export function completionDetailedJobOutFromJSON(
  jsonString: string,
): SafeParseResult<CompletionDetailedJobOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => CompletionDetailedJobOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CompletionDetailedJobOut' from JSON`,
  );
}
