/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  FTModelCapabilitiesOut,
  FTModelCapabilitiesOut$inboundSchema,
  FTModelCapabilitiesOut$Outbound,
  FTModelCapabilitiesOut$outboundSchema,
} from "./ftmodelcapabilitiesout.js";

export const CompletionFTModelOutObject = {
  Model: "model",
} as const;
export type CompletionFTModelOutObject = ClosedEnum<
  typeof CompletionFTModelOutObject
>;

export const ModelType = {
  Completion: "completion",
} as const;
export type ModelType = ClosedEnum<typeof ModelType>;

export type CompletionFTModelOut = {
  id: string;
  object?: CompletionFTModelOutObject | undefined;
  created: number;
  ownedBy: string;
  workspaceId: string;
  root: string;
  rootVersion: string;
  archived: boolean;
  name?: string | null | undefined;
  description?: string | null | undefined;
  capabilities: FTModelCapabilitiesOut;
  maxContextLength?: number | undefined;
  aliases?: Array<string> | undefined;
  job: string;
  modelType?: ModelType | undefined;
};

/** @internal */
export const CompletionFTModelOutObject$inboundSchema: z.ZodNativeEnum<
  typeof CompletionFTModelOutObject
> = z.nativeEnum(CompletionFTModelOutObject);

/** @internal */
export const CompletionFTModelOutObject$outboundSchema: z.ZodNativeEnum<
  typeof CompletionFTModelOutObject
> = CompletionFTModelOutObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionFTModelOutObject$ {
  /** @deprecated use `CompletionFTModelOutObject$inboundSchema` instead. */
  export const inboundSchema = CompletionFTModelOutObject$inboundSchema;
  /** @deprecated use `CompletionFTModelOutObject$outboundSchema` instead. */
  export const outboundSchema = CompletionFTModelOutObject$outboundSchema;
}

/** @internal */
export const ModelType$inboundSchema: z.ZodNativeEnum<typeof ModelType> = z
  .nativeEnum(ModelType);

/** @internal */
export const ModelType$outboundSchema: z.ZodNativeEnum<typeof ModelType> =
  ModelType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ModelType$ {
  /** @deprecated use `ModelType$inboundSchema` instead. */
  export const inboundSchema = ModelType$inboundSchema;
  /** @deprecated use `ModelType$outboundSchema` instead. */
  export const outboundSchema = ModelType$outboundSchema;
}

/** @internal */
export const CompletionFTModelOut$inboundSchema: z.ZodType<
  CompletionFTModelOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  object: CompletionFTModelOutObject$inboundSchema.default("model"),
  created: z.number().int(),
  owned_by: z.string(),
  workspace_id: z.string(),
  root: z.string(),
  root_version: z.string(),
  archived: z.boolean(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  capabilities: FTModelCapabilitiesOut$inboundSchema,
  max_context_length: z.number().int().default(32768),
  aliases: z.array(z.string()).optional(),
  job: z.string(),
  model_type: ModelType$inboundSchema.default("completion"),
}).transform((v) => {
  return remap$(v, {
    "owned_by": "ownedBy",
    "workspace_id": "workspaceId",
    "root_version": "rootVersion",
    "max_context_length": "maxContextLength",
    "model_type": "modelType",
  });
});

/** @internal */
export type CompletionFTModelOut$Outbound = {
  id: string;
  object: string;
  created: number;
  owned_by: string;
  workspace_id: string;
  root: string;
  root_version: string;
  archived: boolean;
  name?: string | null | undefined;
  description?: string | null | undefined;
  capabilities: FTModelCapabilitiesOut$Outbound;
  max_context_length: number;
  aliases?: Array<string> | undefined;
  job: string;
  model_type: string;
};

/** @internal */
export const CompletionFTModelOut$outboundSchema: z.ZodType<
  CompletionFTModelOut$Outbound,
  z.ZodTypeDef,
  CompletionFTModelOut
> = z.object({
  id: z.string(),
  object: CompletionFTModelOutObject$outboundSchema.default("model"),
  created: z.number().int(),
  ownedBy: z.string(),
  workspaceId: z.string(),
  root: z.string(),
  rootVersion: z.string(),
  archived: z.boolean(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  capabilities: FTModelCapabilitiesOut$outboundSchema,
  maxContextLength: z.number().int().default(32768),
  aliases: z.array(z.string()).optional(),
  job: z.string(),
  modelType: ModelType$outboundSchema.default("completion"),
}).transform((v) => {
  return remap$(v, {
    ownedBy: "owned_by",
    workspaceId: "workspace_id",
    rootVersion: "root_version",
    maxContextLength: "max_context_length",
    modelType: "model_type",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionFTModelOut$ {
  /** @deprecated use `CompletionFTModelOut$inboundSchema` instead. */
  export const inboundSchema = CompletionFTModelOut$inboundSchema;
  /** @deprecated use `CompletionFTModelOut$outboundSchema` instead. */
  export const outboundSchema = CompletionFTModelOut$outboundSchema;
  /** @deprecated use `CompletionFTModelOut$Outbound` instead. */
  export type Outbound = CompletionFTModelOut$Outbound;
}

export function completionFTModelOutToJSON(
  completionFTModelOut: CompletionFTModelOut,
): string {
  return JSON.stringify(
    CompletionFTModelOut$outboundSchema.parse(completionFTModelOut),
  );
}

export function completionFTModelOutFromJSON(
  jsonString: string,
): SafeParseResult<CompletionFTModelOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => CompletionFTModelOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CompletionFTModelOut' from JSON`,
  );
}
