/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type CompletionTrainingParameters = {
  trainingSteps?: number | null | undefined;
  learningRate?: number | undefined;
  weightDecay?: number | null | undefined;
  warmupFraction?: number | null | undefined;
  epochs?: number | null | undefined;
  seqLen?: number | null | undefined;
  fimRatio?: number | null | undefined;
};

/** @internal */
export const CompletionTrainingParameters$inboundSchema: z.ZodType<
  CompletionTrainingParameters,
  z.ZodTypeDef,
  unknown
> = z.object({
  training_steps: z.nullable(z.number().int()).optional(),
  learning_rate: z.number().default(0.0001),
  weight_decay: z.nullable(z.number()).optional(),
  warmup_fraction: z.nullable(z.number()).optional(),
  epochs: z.nullable(z.number()).optional(),
  seq_len: z.nullable(z.number().int()).optional(),
  fim_ratio: z.nullable(z.number()).optional(),
}).transform((v) => {
  return remap$(v, {
    "training_steps": "trainingSteps",
    "learning_rate": "learningRate",
    "weight_decay": "weightDecay",
    "warmup_fraction": "warmupFraction",
    "seq_len": "seqLen",
    "fim_ratio": "fimRatio",
  });
});

/** @internal */
export type CompletionTrainingParameters$Outbound = {
  training_steps?: number | null | undefined;
  learning_rate: number;
  weight_decay?: number | null | undefined;
  warmup_fraction?: number | null | undefined;
  epochs?: number | null | undefined;
  seq_len?: number | null | undefined;
  fim_ratio?: number | null | undefined;
};

/** @internal */
export const CompletionTrainingParameters$outboundSchema: z.ZodType<
  CompletionTrainingParameters$Outbound,
  z.ZodTypeDef,
  CompletionTrainingParameters
> = z.object({
  trainingSteps: z.nullable(z.number().int()).optional(),
  learningRate: z.number().default(0.0001),
  weightDecay: z.nullable(z.number()).optional(),
  warmupFraction: z.nullable(z.number()).optional(),
  epochs: z.nullable(z.number()).optional(),
  seqLen: z.nullable(z.number().int()).optional(),
  fimRatio: z.nullable(z.number()).optional(),
}).transform((v) => {
  return remap$(v, {
    trainingSteps: "training_steps",
    learningRate: "learning_rate",
    weightDecay: "weight_decay",
    warmupFraction: "warmup_fraction",
    seqLen: "seq_len",
    fimRatio: "fim_ratio",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionTrainingParameters$ {
  /** @deprecated use `CompletionTrainingParameters$inboundSchema` instead. */
  export const inboundSchema = CompletionTrainingParameters$inboundSchema;
  /** @deprecated use `CompletionTrainingParameters$outboundSchema` instead. */
  export const outboundSchema = CompletionTrainingParameters$outboundSchema;
  /** @deprecated use `CompletionTrainingParameters$Outbound` instead. */
  export type Outbound = CompletionTrainingParameters$Outbound;
}

export function completionTrainingParametersToJSON(
  completionTrainingParameters: CompletionTrainingParameters,
): string {
  return JSON.stringify(
    CompletionTrainingParameters$outboundSchema.parse(
      completionTrainingParameters,
    ),
  );
}

export function completionTrainingParametersFromJSON(
  jsonString: string,
): SafeParseResult<CompletionTrainingParameters, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => CompletionTrainingParameters$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CompletionTrainingParameters' from JSON`,
  );
}
