/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  AgentHandoffEntry,
  AgentHandoffEntry$inboundSchema,
  AgentHandoffEntry$Outbound,
  AgentHandoffEntry$outboundSchema,
} from "./agenthandoffentry.js";
import {
  FunctionCallEntry,
  FunctionCallEntry$inboundSchema,
  FunctionCallEntry$Outbound,
  FunctionCallEntry$outboundSchema,
} from "./functioncallentry.js";
import {
  FunctionResultEntry,
  FunctionResultEntry$inboundSchema,
  FunctionResultEntry$Outbound,
  FunctionResultEntry$outboundSchema,
} from "./functionresultentry.js";
import {
  MessageInputEntry,
  MessageInputEntry$inboundSchema,
  MessageInputEntry$Outbound,
  MessageInputEntry$outboundSchema,
} from "./messageinputentry.js";
import {
  MessageOutputEntry,
  MessageOutputEntry$inboundSchema,
  MessageOutputEntry$Outbound,
  MessageOutputEntry$outboundSchema,
} from "./messageoutputentry.js";
import {
  ToolExecutionEntry,
  ToolExecutionEntry$inboundSchema,
  ToolExecutionEntry$Outbound,
  ToolExecutionEntry$outboundSchema,
} from "./toolexecutionentry.js";

export const ConversationHistoryObject = {
  ConversationHistory: "conversation.history",
} as const;
export type ConversationHistoryObject = ClosedEnum<
  typeof ConversationHistoryObject
>;

export type Entries =
  | AgentHandoffEntry
  | FunctionCallEntry
  | MessageInputEntry
  | FunctionResultEntry
  | ToolExecutionEntry
  | MessageOutputEntry;

/**
 * Retrieve all entries in a conversation.
 */
export type ConversationHistory = {
  object?: ConversationHistoryObject | undefined;
  conversationId: string;
  entries: Array<
    | AgentHandoffEntry
    | FunctionCallEntry
    | MessageInputEntry
    | FunctionResultEntry
    | ToolExecutionEntry
    | MessageOutputEntry
  >;
};

/** @internal */
export const ConversationHistoryObject$inboundSchema: z.ZodNativeEnum<
  typeof ConversationHistoryObject
> = z.nativeEnum(ConversationHistoryObject);

/** @internal */
export const ConversationHistoryObject$outboundSchema: z.ZodNativeEnum<
  typeof ConversationHistoryObject
> = ConversationHistoryObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationHistoryObject$ {
  /** @deprecated use `ConversationHistoryObject$inboundSchema` instead. */
  export const inboundSchema = ConversationHistoryObject$inboundSchema;
  /** @deprecated use `ConversationHistoryObject$outboundSchema` instead. */
  export const outboundSchema = ConversationHistoryObject$outboundSchema;
}

/** @internal */
export const Entries$inboundSchema: z.ZodType<Entries, z.ZodTypeDef, unknown> =
  z.union([
    AgentHandoffEntry$inboundSchema,
    FunctionCallEntry$inboundSchema,
    MessageInputEntry$inboundSchema,
    FunctionResultEntry$inboundSchema,
    ToolExecutionEntry$inboundSchema,
    MessageOutputEntry$inboundSchema,
  ]);

/** @internal */
export type Entries$Outbound =
  | AgentHandoffEntry$Outbound
  | FunctionCallEntry$Outbound
  | MessageInputEntry$Outbound
  | FunctionResultEntry$Outbound
  | ToolExecutionEntry$Outbound
  | MessageOutputEntry$Outbound;

/** @internal */
export const Entries$outboundSchema: z.ZodType<
  Entries$Outbound,
  z.ZodTypeDef,
  Entries
> = z.union([
  AgentHandoffEntry$outboundSchema,
  FunctionCallEntry$outboundSchema,
  MessageInputEntry$outboundSchema,
  FunctionResultEntry$outboundSchema,
  ToolExecutionEntry$outboundSchema,
  MessageOutputEntry$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Entries$ {
  /** @deprecated use `Entries$inboundSchema` instead. */
  export const inboundSchema = Entries$inboundSchema;
  /** @deprecated use `Entries$outboundSchema` instead. */
  export const outboundSchema = Entries$outboundSchema;
  /** @deprecated use `Entries$Outbound` instead. */
  export type Outbound = Entries$Outbound;
}

export function entriesToJSON(entries: Entries): string {
  return JSON.stringify(Entries$outboundSchema.parse(entries));
}

export function entriesFromJSON(
  jsonString: string,
): SafeParseResult<Entries, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => Entries$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'Entries' from JSON`,
  );
}

/** @internal */
export const ConversationHistory$inboundSchema: z.ZodType<
  ConversationHistory,
  z.ZodTypeDef,
  unknown
> = z.object({
  object: ConversationHistoryObject$inboundSchema.default(
    "conversation.history",
  ),
  conversation_id: z.string(),
  entries: z.array(
    z.union([
      AgentHandoffEntry$inboundSchema,
      FunctionCallEntry$inboundSchema,
      MessageInputEntry$inboundSchema,
      FunctionResultEntry$inboundSchema,
      ToolExecutionEntry$inboundSchema,
      MessageOutputEntry$inboundSchema,
    ]),
  ),
}).transform((v) => {
  return remap$(v, {
    "conversation_id": "conversationId",
  });
});

/** @internal */
export type ConversationHistory$Outbound = {
  object: string;
  conversation_id: string;
  entries: Array<
    | AgentHandoffEntry$Outbound
    | FunctionCallEntry$Outbound
    | MessageInputEntry$Outbound
    | FunctionResultEntry$Outbound
    | ToolExecutionEntry$Outbound
    | MessageOutputEntry$Outbound
  >;
};

/** @internal */
export const ConversationHistory$outboundSchema: z.ZodType<
  ConversationHistory$Outbound,
  z.ZodTypeDef,
  ConversationHistory
> = z.object({
  object: ConversationHistoryObject$outboundSchema.default(
    "conversation.history",
  ),
  conversationId: z.string(),
  entries: z.array(
    z.union([
      AgentHandoffEntry$outboundSchema,
      FunctionCallEntry$outboundSchema,
      MessageInputEntry$outboundSchema,
      FunctionResultEntry$outboundSchema,
      ToolExecutionEntry$outboundSchema,
      MessageOutputEntry$outboundSchema,
    ]),
  ),
}).transform((v) => {
  return remap$(v, {
    conversationId: "conversation_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationHistory$ {
  /** @deprecated use `ConversationHistory$inboundSchema` instead. */
  export const inboundSchema = ConversationHistory$inboundSchema;
  /** @deprecated use `ConversationHistory$outboundSchema` instead. */
  export const outboundSchema = ConversationHistory$outboundSchema;
  /** @deprecated use `ConversationHistory$Outbound` instead. */
  export type Outbound = ConversationHistory$Outbound;
}

export function conversationHistoryToJSON(
  conversationHistory: ConversationHistory,
): string {
  return JSON.stringify(
    ConversationHistory$outboundSchema.parse(conversationHistory),
  );
}

export function conversationHistoryFromJSON(
  jsonString: string,
): SafeParseResult<ConversationHistory, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationHistory$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationHistory' from JSON`,
  );
}
