/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  ConversationInputs,
  ConversationInputs$inboundSchema,
  ConversationInputs$Outbound,
  ConversationInputs$outboundSchema,
} from "./conversationinputs.js";

export const ConversationRestartRequestHandoffExecution = {
  Client: "client",
  Server: "server",
} as const;
export type ConversationRestartRequestHandoffExecution = ClosedEnum<
  typeof ConversationRestartRequestHandoffExecution
>;

/**
 * Request to restart a new conversation from a given entry in the conversation.
 */
export type ConversationRestartRequest = {
  inputs: ConversationInputs;
  stream?: boolean | undefined;
  /**
   * Whether to store the results into our servers or not.
   */
  store?: boolean | undefined;
  handoffExecution?: ConversationRestartRequestHandoffExecution | undefined;
  /**
   * White-listed arguments from the completion API
   */
  completionArgs?: CompletionArgs | undefined;
  fromEntryId: string;
};

/** @internal */
export const ConversationRestartRequestHandoffExecution$inboundSchema:
  z.ZodNativeEnum<typeof ConversationRestartRequestHandoffExecution> = z
    .nativeEnum(ConversationRestartRequestHandoffExecution);

/** @internal */
export const ConversationRestartRequestHandoffExecution$outboundSchema:
  z.ZodNativeEnum<typeof ConversationRestartRequestHandoffExecution> =
    ConversationRestartRequestHandoffExecution$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationRestartRequestHandoffExecution$ {
  /** @deprecated use `ConversationRestartRequestHandoffExecution$inboundSchema` instead. */
  export const inboundSchema =
    ConversationRestartRequestHandoffExecution$inboundSchema;
  /** @deprecated use `ConversationRestartRequestHandoffExecution$outboundSchema` instead. */
  export const outboundSchema =
    ConversationRestartRequestHandoffExecution$outboundSchema;
}

/** @internal */
export const ConversationRestartRequest$inboundSchema: z.ZodType<
  ConversationRestartRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  inputs: ConversationInputs$inboundSchema,
  stream: z.boolean().default(false),
  store: z.boolean().default(true),
  handoff_execution: ConversationRestartRequestHandoffExecution$inboundSchema
    .default("server"),
  completion_args: CompletionArgs$inboundSchema.optional(),
  from_entry_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "handoff_execution": "handoffExecution",
    "completion_args": "completionArgs",
    "from_entry_id": "fromEntryId",
  });
});

/** @internal */
export type ConversationRestartRequest$Outbound = {
  inputs: ConversationInputs$Outbound;
  stream: boolean;
  store: boolean;
  handoff_execution: string;
  completion_args?: CompletionArgs$Outbound | undefined;
  from_entry_id: string;
};

/** @internal */
export const ConversationRestartRequest$outboundSchema: z.ZodType<
  ConversationRestartRequest$Outbound,
  z.ZodTypeDef,
  ConversationRestartRequest
> = z.object({
  inputs: ConversationInputs$outboundSchema,
  stream: z.boolean().default(false),
  store: z.boolean().default(true),
  handoffExecution: ConversationRestartRequestHandoffExecution$outboundSchema
    .default("server"),
  completionArgs: CompletionArgs$outboundSchema.optional(),
  fromEntryId: z.string(),
}).transform((v) => {
  return remap$(v, {
    handoffExecution: "handoff_execution",
    completionArgs: "completion_args",
    fromEntryId: "from_entry_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationRestartRequest$ {
  /** @deprecated use `ConversationRestartRequest$inboundSchema` instead. */
  export const inboundSchema = ConversationRestartRequest$inboundSchema;
  /** @deprecated use `ConversationRestartRequest$outboundSchema` instead. */
  export const outboundSchema = ConversationRestartRequest$outboundSchema;
  /** @deprecated use `ConversationRestartRequest$Outbound` instead. */
  export type Outbound = ConversationRestartRequest$Outbound;
}

export function conversationRestartRequestToJSON(
  conversationRestartRequest: ConversationRestartRequest,
): string {
  return JSON.stringify(
    ConversationRestartRequest$outboundSchema.parse(conversationRestartRequest),
  );
}

export function conversationRestartRequestFromJSON(
  jsonString: string,
): SafeParseResult<ConversationRestartRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationRestartRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationRestartRequest' from JSON`,
  );
}
