/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CodeInterpreterTool,
  CodeInterpreterTool$inboundSchema,
  CodeInterpreterTool$Outbound,
  CodeInterpreterTool$outboundSchema,
} from "./codeinterpretertool.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  ConversationInputs,
  ConversationInputs$inboundSchema,
  ConversationInputs$Outbound,
  ConversationInputs$outboundSchema,
} from "./conversationinputs.js";
import {
  DocumentLibraryTool,
  DocumentLibraryTool$inboundSchema,
  DocumentLibraryTool$Outbound,
  DocumentLibraryTool$outboundSchema,
} from "./documentlibrarytool.js";
import {
  FunctionTool,
  FunctionTool$inboundSchema,
  FunctionTool$Outbound,
  FunctionTool$outboundSchema,
} from "./functiontool.js";
import {
  ImageGenerationTool,
  ImageGenerationTool$inboundSchema,
  ImageGenerationTool$Outbound,
  ImageGenerationTool$outboundSchema,
} from "./imagegenerationtool.js";
import {
  WebSearchPremiumTool,
  WebSearchPremiumTool$inboundSchema,
  WebSearchPremiumTool$Outbound,
  WebSearchPremiumTool$outboundSchema,
} from "./websearchpremiumtool.js";
import {
  WebSearchTool,
  WebSearchTool$inboundSchema,
  WebSearchTool$Outbound,
  WebSearchTool$outboundSchema,
} from "./websearchtool.js";

export const ConversationStreamRequestHandoffExecution = {
  Client: "client",
  Server: "server",
} as const;
export type ConversationStreamRequestHandoffExecution = ClosedEnum<
  typeof ConversationStreamRequestHandoffExecution
>;

export type ConversationStreamRequestTools =
  | (DocumentLibraryTool & { type: "document_library" })
  | (FunctionTool & { type: "function" })
  | (CodeInterpreterTool & { type: "code_interpreter" })
  | (ImageGenerationTool & { type: "image_generation" })
  | (WebSearchTool & { type: "web_search" })
  | (WebSearchPremiumTool & { type: "web_search_premium" });

export type ConversationStreamRequest = {
  inputs: ConversationInputs;
  stream?: boolean | undefined;
  store?: boolean | null | undefined;
  handoffExecution?:
    | ConversationStreamRequestHandoffExecution
    | null
    | undefined;
  instructions?: string | null | undefined;
  tools?:
    | Array<
      | (DocumentLibraryTool & { type: "document_library" })
      | (FunctionTool & { type: "function" })
      | (CodeInterpreterTool & { type: "code_interpreter" })
      | (ImageGenerationTool & { type: "image_generation" })
      | (WebSearchTool & { type: "web_search" })
      | (WebSearchPremiumTool & { type: "web_search_premium" })
    >
    | null
    | undefined;
  completionArgs?: CompletionArgs | null | undefined;
  name?: string | null | undefined;
  description?: string | null | undefined;
  agentId?: string | null | undefined;
  model?: string | null | undefined;
};

/** @internal */
export const ConversationStreamRequestHandoffExecution$inboundSchema:
  z.ZodNativeEnum<typeof ConversationStreamRequestHandoffExecution> = z
    .nativeEnum(ConversationStreamRequestHandoffExecution);

/** @internal */
export const ConversationStreamRequestHandoffExecution$outboundSchema:
  z.ZodNativeEnum<typeof ConversationStreamRequestHandoffExecution> =
    ConversationStreamRequestHandoffExecution$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationStreamRequestHandoffExecution$ {
  /** @deprecated use `ConversationStreamRequestHandoffExecution$inboundSchema` instead. */
  export const inboundSchema =
    ConversationStreamRequestHandoffExecution$inboundSchema;
  /** @deprecated use `ConversationStreamRequestHandoffExecution$outboundSchema` instead. */
  export const outboundSchema =
    ConversationStreamRequestHandoffExecution$outboundSchema;
}

/** @internal */
export const ConversationStreamRequestTools$inboundSchema: z.ZodType<
  ConversationStreamRequestTools,
  z.ZodTypeDef,
  unknown
> = z.union([
  DocumentLibraryTool$inboundSchema.and(
    z.object({ type: z.literal("document_library") }).transform((v) => ({
      type: v.type,
    })),
  ),
  FunctionTool$inboundSchema.and(
    z.object({ type: z.literal("function") }).transform((v) => ({
      type: v.type,
    })),
  ),
  CodeInterpreterTool$inboundSchema.and(
    z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ImageGenerationTool$inboundSchema.and(
    z.object({ type: z.literal("image_generation") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchTool$inboundSchema.and(
    z.object({ type: z.literal("web_search") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchPremiumTool$inboundSchema.and(
    z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/** @internal */
export type ConversationStreamRequestTools$Outbound =
  | (DocumentLibraryTool$Outbound & { type: "document_library" })
  | (FunctionTool$Outbound & { type: "function" })
  | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
  | (ImageGenerationTool$Outbound & { type: "image_generation" })
  | (WebSearchTool$Outbound & { type: "web_search" })
  | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" });

/** @internal */
export const ConversationStreamRequestTools$outboundSchema: z.ZodType<
  ConversationStreamRequestTools$Outbound,
  z.ZodTypeDef,
  ConversationStreamRequestTools
> = z.union([
  DocumentLibraryTool$outboundSchema.and(
    z.object({ type: z.literal("document_library") }).transform((v) => ({
      type: v.type,
    })),
  ),
  FunctionTool$outboundSchema.and(
    z.object({ type: z.literal("function") }).transform((v) => ({
      type: v.type,
    })),
  ),
  CodeInterpreterTool$outboundSchema.and(
    z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ImageGenerationTool$outboundSchema.and(
    z.object({ type: z.literal("image_generation") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchTool$outboundSchema.and(
    z.object({ type: z.literal("web_search") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchPremiumTool$outboundSchema.and(
    z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationStreamRequestTools$ {
  /** @deprecated use `ConversationStreamRequestTools$inboundSchema` instead. */
  export const inboundSchema = ConversationStreamRequestTools$inboundSchema;
  /** @deprecated use `ConversationStreamRequestTools$outboundSchema` instead. */
  export const outboundSchema = ConversationStreamRequestTools$outboundSchema;
  /** @deprecated use `ConversationStreamRequestTools$Outbound` instead. */
  export type Outbound = ConversationStreamRequestTools$Outbound;
}

export function conversationStreamRequestToolsToJSON(
  conversationStreamRequestTools: ConversationStreamRequestTools,
): string {
  return JSON.stringify(
    ConversationStreamRequestTools$outboundSchema.parse(
      conversationStreamRequestTools,
    ),
  );
}

export function conversationStreamRequestToolsFromJSON(
  jsonString: string,
): SafeParseResult<ConversationStreamRequestTools, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationStreamRequestTools$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationStreamRequestTools' from JSON`,
  );
}

/** @internal */
export const ConversationStreamRequest$inboundSchema: z.ZodType<
  ConversationStreamRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  inputs: ConversationInputs$inboundSchema,
  stream: z.boolean().default(true),
  store: z.nullable(z.boolean()).optional(),
  handoff_execution: z.nullable(
    ConversationStreamRequestHandoffExecution$inboundSchema,
  ).optional(),
  instructions: z.nullable(z.string()).optional(),
  tools: z.nullable(
    z.array(
      z.union([
        DocumentLibraryTool$inboundSchema.and(
          z.object({ type: z.literal("document_library") }).transform((v) => ({
            type: v.type,
          })),
        ),
        FunctionTool$inboundSchema.and(
          z.object({ type: z.literal("function") }).transform((v) => ({
            type: v.type,
          })),
        ),
        CodeInterpreterTool$inboundSchema.and(
          z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
            type: v.type,
          })),
        ),
        ImageGenerationTool$inboundSchema.and(
          z.object({ type: z.literal("image_generation") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchTool$inboundSchema.and(
          z.object({ type: z.literal("web_search") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchPremiumTool$inboundSchema.and(
          z.object({ type: z.literal("web_search_premium") }).transform((
            v,
          ) => ({ type: v.type })),
        ),
      ]),
    ),
  ).optional(),
  completion_args: z.nullable(CompletionArgs$inboundSchema).optional(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  agent_id: z.nullable(z.string()).optional(),
  model: z.nullable(z.string()).optional(),
}).transform((v) => {
  return remap$(v, {
    "handoff_execution": "handoffExecution",
    "completion_args": "completionArgs",
    "agent_id": "agentId",
  });
});

/** @internal */
export type ConversationStreamRequest$Outbound = {
  inputs: ConversationInputs$Outbound;
  stream: boolean;
  store?: boolean | null | undefined;
  handoff_execution?: string | null | undefined;
  instructions?: string | null | undefined;
  tools?:
    | Array<
      | (DocumentLibraryTool$Outbound & { type: "document_library" })
      | (FunctionTool$Outbound & { type: "function" })
      | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
      | (ImageGenerationTool$Outbound & { type: "image_generation" })
      | (WebSearchTool$Outbound & { type: "web_search" })
      | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" })
    >
    | null
    | undefined;
  completion_args?: CompletionArgs$Outbound | null | undefined;
  name?: string | null | undefined;
  description?: string | null | undefined;
  agent_id?: string | null | undefined;
  model?: string | null | undefined;
};

/** @internal */
export const ConversationStreamRequest$outboundSchema: z.ZodType<
  ConversationStreamRequest$Outbound,
  z.ZodTypeDef,
  ConversationStreamRequest
> = z.object({
  inputs: ConversationInputs$outboundSchema,
  stream: z.boolean().default(true),
  store: z.nullable(z.boolean()).optional(),
  handoffExecution: z.nullable(
    ConversationStreamRequestHandoffExecution$outboundSchema,
  ).optional(),
  instructions: z.nullable(z.string()).optional(),
  tools: z.nullable(
    z.array(
      z.union([
        DocumentLibraryTool$outboundSchema.and(
          z.object({ type: z.literal("document_library") }).transform((v) => ({
            type: v.type,
          })),
        ),
        FunctionTool$outboundSchema.and(
          z.object({ type: z.literal("function") }).transform((v) => ({
            type: v.type,
          })),
        ),
        CodeInterpreterTool$outboundSchema.and(
          z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
            type: v.type,
          })),
        ),
        ImageGenerationTool$outboundSchema.and(
          z.object({ type: z.literal("image_generation") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchTool$outboundSchema.and(
          z.object({ type: z.literal("web_search") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchPremiumTool$outboundSchema.and(
          z.object({ type: z.literal("web_search_premium") }).transform((
            v,
          ) => ({ type: v.type })),
        ),
      ]),
    ),
  ).optional(),
  completionArgs: z.nullable(CompletionArgs$outboundSchema).optional(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  agentId: z.nullable(z.string()).optional(),
  model: z.nullable(z.string()).optional(),
}).transform((v) => {
  return remap$(v, {
    handoffExecution: "handoff_execution",
    completionArgs: "completion_args",
    agentId: "agent_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationStreamRequest$ {
  /** @deprecated use `ConversationStreamRequest$inboundSchema` instead. */
  export const inboundSchema = ConversationStreamRequest$inboundSchema;
  /** @deprecated use `ConversationStreamRequest$outboundSchema` instead. */
  export const outboundSchema = ConversationStreamRequest$outboundSchema;
  /** @deprecated use `ConversationStreamRequest$Outbound` instead. */
  export type Outbound = ConversationStreamRequest$Outbound;
}

export function conversationStreamRequestToJSON(
  conversationStreamRequest: ConversationStreamRequest,
): string {
  return JSON.stringify(
    ConversationStreamRequest$outboundSchema.parse(conversationStreamRequest),
  );
}

export function conversationStreamRequestFromJSON(
  jsonString: string,
): SafeParseResult<ConversationStreamRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationStreamRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationStreamRequest' from JSON`,
  );
}
