/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  DocumentURLChunk,
  DocumentURLChunk$inboundSchema,
  DocumentURLChunk$Outbound,
  DocumentURLChunk$outboundSchema,
} from "./documenturlchunk.js";
import {
  ImageURLChunk,
  ImageURLChunk$inboundSchema,
  ImageURLChunk$Outbound,
  ImageURLChunk$outboundSchema,
} from "./imageurlchunk.js";
import {
  TextChunk,
  TextChunk$inboundSchema,
  TextChunk$Outbound,
  TextChunk$outboundSchema,
} from "./textchunk.js";
import {
  ThinkChunk,
  ThinkChunk$inboundSchema,
  ThinkChunk$Outbound,
  ThinkChunk$outboundSchema,
} from "./thinkchunk.js";
import {
  ToolFileChunk,
  ToolFileChunk$inboundSchema,
  ToolFileChunk$Outbound,
  ToolFileChunk$outboundSchema,
} from "./toolfilechunk.js";
import {
  ToolReferenceChunk,
  ToolReferenceChunk$inboundSchema,
  ToolReferenceChunk$Outbound,
  ToolReferenceChunk$outboundSchema,
} from "./toolreferencechunk.js";

export type MessageOutputContentChunks =
  | ToolFileChunk
  | ToolReferenceChunk
  | TextChunk
  | ImageURLChunk
  | DocumentURLChunk
  | ThinkChunk;

/** @internal */
export const MessageOutputContentChunks$inboundSchema: z.ZodType<
  MessageOutputContentChunks,
  z.ZodTypeDef,
  unknown
> = z.union([
  ToolFileChunk$inboundSchema,
  ToolReferenceChunk$inboundSchema,
  TextChunk$inboundSchema,
  ImageURLChunk$inboundSchema,
  DocumentURLChunk$inboundSchema,
  ThinkChunk$inboundSchema,
]);

/** @internal */
export type MessageOutputContentChunks$Outbound =
  | ToolFileChunk$Outbound
  | ToolReferenceChunk$Outbound
  | TextChunk$Outbound
  | ImageURLChunk$Outbound
  | DocumentURLChunk$Outbound
  | ThinkChunk$Outbound;

/** @internal */
export const MessageOutputContentChunks$outboundSchema: z.ZodType<
  MessageOutputContentChunks$Outbound,
  z.ZodTypeDef,
  MessageOutputContentChunks
> = z.union([
  ToolFileChunk$outboundSchema,
  ToolReferenceChunk$outboundSchema,
  TextChunk$outboundSchema,
  ImageURLChunk$outboundSchema,
  DocumentURLChunk$outboundSchema,
  ThinkChunk$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace MessageOutputContentChunks$ {
  /** @deprecated use `MessageOutputContentChunks$inboundSchema` instead. */
  export const inboundSchema = MessageOutputContentChunks$inboundSchema;
  /** @deprecated use `MessageOutputContentChunks$outboundSchema` instead. */
  export const outboundSchema = MessageOutputContentChunks$outboundSchema;
  /** @deprecated use `MessageOutputContentChunks$Outbound` instead. */
  export type Outbound = MessageOutputContentChunks$Outbound;
}

export function messageOutputContentChunksToJSON(
  messageOutputContentChunks: MessageOutputContentChunks,
): string {
  return JSON.stringify(
    MessageOutputContentChunks$outboundSchema.parse(messageOutputContentChunks),
  );
}

export function messageOutputContentChunksFromJSON(
  jsonString: string,
): SafeParseResult<MessageOutputContentChunks, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => MessageOutputContentChunks$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'MessageOutputContentChunks' from JSON`,
  );
}
