/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  TextChunk,
  TextChunk$inboundSchema,
  TextChunk$Outbound,
  TextChunk$outboundSchema,
} from "./textchunk.js";
import {
  ThinkChunk,
  ThinkChunk$inboundSchema,
  ThinkChunk$Outbound,
  ThinkChunk$outboundSchema,
} from "./thinkchunk.js";

export type SystemMessageContentChunks =
  | (TextChunk & { type: "text" })
  | (ThinkChunk & { type: "thinking" });

/** @internal */
export const SystemMessageContentChunks$inboundSchema: z.ZodType<
  SystemMessageContentChunks,
  z.ZodTypeDef,
  unknown
> = z.union([
  TextChunk$inboundSchema.and(
    z.object({ type: z.literal("text") }).transform((v) => ({ type: v.type })),
  ),
  ThinkChunk$inboundSchema.and(
    z.object({ type: z.literal("thinking") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/** @internal */
export type SystemMessageContentChunks$Outbound =
  | (TextChunk$Outbound & { type: "text" })
  | (ThinkChunk$Outbound & { type: "thinking" });

/** @internal */
export const SystemMessageContentChunks$outboundSchema: z.ZodType<
  SystemMessageContentChunks$Outbound,
  z.ZodTypeDef,
  SystemMessageContentChunks
> = z.union([
  TextChunk$outboundSchema.and(
    z.object({ type: z.literal("text") }).transform((v) => ({ type: v.type })),
  ),
  ThinkChunk$outboundSchema.and(
    z.object({ type: z.literal("thinking") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace SystemMessageContentChunks$ {
  /** @deprecated use `SystemMessageContentChunks$inboundSchema` instead. */
  export const inboundSchema = SystemMessageContentChunks$inboundSchema;
  /** @deprecated use `SystemMessageContentChunks$outboundSchema` instead. */
  export const outboundSchema = SystemMessageContentChunks$outboundSchema;
  /** @deprecated use `SystemMessageContentChunks$Outbound` instead. */
  export type Outbound = SystemMessageContentChunks$Outbound;
}

export function systemMessageContentChunksToJSON(
  systemMessageContentChunks: SystemMessageContentChunks,
): string {
  return JSON.stringify(
    SystemMessageContentChunks$outboundSchema.parse(systemMessageContentChunks),
  );
}

export function systemMessageContentChunksFromJSON(
  jsonString: string,
): SafeParseResult<SystemMessageContentChunks, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => SystemMessageContentChunks$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'SystemMessageContentChunks' from JSON`,
  );
}
