/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1AgentsGetRequest = {
  agentId: string;
};

/** @internal */
export const AgentsApiV1AgentsGetRequest$inboundSchema: z.ZodType<
  AgentsApiV1AgentsGetRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  agent_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "agent_id": "agentId",
  });
});

/** @internal */
export type AgentsApiV1AgentsGetRequest$Outbound = {
  agent_id: string;
};

/** @internal */
export const AgentsApiV1AgentsGetRequest$outboundSchema: z.ZodType<
  AgentsApiV1AgentsGetRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1AgentsGetRequest
> = z.object({
  agentId: z.string(),
}).transform((v) => {
  return remap$(v, {
    agentId: "agent_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1AgentsGetRequest$ {
  /** @deprecated use `AgentsApiV1AgentsGetRequest$inboundSchema` instead. */
  export const inboundSchema = AgentsApiV1AgentsGetRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1AgentsGetRequest$outboundSchema` instead. */
  export const outboundSchema = AgentsApiV1AgentsGetRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1AgentsGetRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1AgentsGetRequest$Outbound;
}

export function agentsApiV1AgentsGetRequestToJSON(
  agentsApiV1AgentsGetRequest: AgentsApiV1AgentsGetRequest,
): string {
  return JSON.stringify(
    AgentsApiV1AgentsGetRequest$outboundSchema.parse(
      agentsApiV1AgentsGetRequest,
    ),
  );
}

export function agentsApiV1AgentsGetRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1AgentsGetRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentsApiV1AgentsGetRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1AgentsGetRequest' from JSON`,
  );
}
