/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1AgentsListRequest = {
  page?: number | undefined;
  pageSize?: number | undefined;
};

/** @internal */
export const AgentsApiV1AgentsListRequest$inboundSchema: z.ZodType<
  AgentsApiV1AgentsListRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  page: z.number().int().default(0),
  page_size: z.number().int().default(20),
}).transform((v) => {
  return remap$(v, {
    "page_size": "pageSize",
  });
});

/** @internal */
export type AgentsApiV1AgentsListRequest$Outbound = {
  page: number;
  page_size: number;
};

/** @internal */
export const AgentsApiV1AgentsListRequest$outboundSchema: z.ZodType<
  AgentsApiV1AgentsListRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1AgentsListRequest
> = z.object({
  page: z.number().int().default(0),
  pageSize: z.number().int().default(20),
}).transform((v) => {
  return remap$(v, {
    pageSize: "page_size",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1AgentsListRequest$ {
  /** @deprecated use `AgentsApiV1AgentsListRequest$inboundSchema` instead. */
  export const inboundSchema = AgentsApiV1AgentsListRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1AgentsListRequest$outboundSchema` instead. */
  export const outboundSchema = AgentsApiV1AgentsListRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1AgentsListRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1AgentsListRequest$Outbound;
}

export function agentsApiV1AgentsListRequestToJSON(
  agentsApiV1AgentsListRequest: AgentsApiV1AgentsListRequest,
): string {
  return JSON.stringify(
    AgentsApiV1AgentsListRequest$outboundSchema.parse(
      agentsApiV1AgentsListRequest,
    ),
  );
}

export function agentsApiV1AgentsListRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1AgentsListRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentsApiV1AgentsListRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1AgentsListRequest' from JSON`,
  );
}
