/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1AgentsUpdateVersionRequest = {
  agentId: string;
  version: number;
};

/** @internal */
export const AgentsApiV1AgentsUpdateVersionRequest$inboundSchema: z.ZodType<
  AgentsApiV1AgentsUpdateVersionRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  agent_id: z.string(),
  version: z.number().int(),
}).transform((v) => {
  return remap$(v, {
    "agent_id": "agentId",
  });
});

/** @internal */
export type AgentsApiV1AgentsUpdateVersionRequest$Outbound = {
  agent_id: string;
  version: number;
};

/** @internal */
export const AgentsApiV1AgentsUpdateVersionRequest$outboundSchema: z.ZodType<
  AgentsApiV1AgentsUpdateVersionRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1AgentsUpdateVersionRequest
> = z.object({
  agentId: z.string(),
  version: z.number().int(),
}).transform((v) => {
  return remap$(v, {
    agentId: "agent_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1AgentsUpdateVersionRequest$ {
  /** @deprecated use `AgentsApiV1AgentsUpdateVersionRequest$inboundSchema` instead. */
  export const inboundSchema =
    AgentsApiV1AgentsUpdateVersionRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1AgentsUpdateVersionRequest$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1AgentsUpdateVersionRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1AgentsUpdateVersionRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1AgentsUpdateVersionRequest$Outbound;
}

export function agentsApiV1AgentsUpdateVersionRequestToJSON(
  agentsApiV1AgentsUpdateVersionRequest: AgentsApiV1AgentsUpdateVersionRequest,
): string {
  return JSON.stringify(
    AgentsApiV1AgentsUpdateVersionRequest$outboundSchema.parse(
      agentsApiV1AgentsUpdateVersionRequest,
    ),
  );
}

export function agentsApiV1AgentsUpdateVersionRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1AgentsUpdateVersionRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1AgentsUpdateVersionRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1AgentsUpdateVersionRequest' from JSON`,
  );
}
