/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type DeleteModelV1ModelsModelIdDeleteRequest = {
  /**
   * The ID of the model to delete.
   */
  modelId: string;
};

/** @internal */
export const DeleteModelV1ModelsModelIdDeleteRequest$inboundSchema: z.ZodType<
  DeleteModelV1ModelsModelIdDeleteRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  model_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "model_id": "modelId",
  });
});

/** @internal */
export type DeleteModelV1ModelsModelIdDeleteRequest$Outbound = {
  model_id: string;
};

/** @internal */
export const DeleteModelV1ModelsModelIdDeleteRequest$outboundSchema: z.ZodType<
  DeleteModelV1ModelsModelIdDeleteRequest$Outbound,
  z.ZodTypeDef,
  DeleteModelV1ModelsModelIdDeleteRequest
> = z.object({
  modelId: z.string(),
}).transform((v) => {
  return remap$(v, {
    modelId: "model_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DeleteModelV1ModelsModelIdDeleteRequest$ {
  /** @deprecated use `DeleteModelV1ModelsModelIdDeleteRequest$inboundSchema` instead. */
  export const inboundSchema =
    DeleteModelV1ModelsModelIdDeleteRequest$inboundSchema;
  /** @deprecated use `DeleteModelV1ModelsModelIdDeleteRequest$outboundSchema` instead. */
  export const outboundSchema =
    DeleteModelV1ModelsModelIdDeleteRequest$outboundSchema;
  /** @deprecated use `DeleteModelV1ModelsModelIdDeleteRequest$Outbound` instead. */
  export type Outbound = DeleteModelV1ModelsModelIdDeleteRequest$Outbound;
}

export function deleteModelV1ModelsModelIdDeleteRequestToJSON(
  deleteModelV1ModelsModelIdDeleteRequest:
    DeleteModelV1ModelsModelIdDeleteRequest,
): string {
  return JSON.stringify(
    DeleteModelV1ModelsModelIdDeleteRequest$outboundSchema.parse(
      deleteModelV1ModelsModelIdDeleteRequest,
    ),
  );
}

export function deleteModelV1ModelsModelIdDeleteRequestFromJSON(
  jsonString: string,
): SafeParseResult<
  DeleteModelV1ModelsModelIdDeleteRequest,
  SDKValidationError
> {
  return safeParse(
    jsonString,
    (x) =>
      DeleteModelV1ModelsModelIdDeleteRequest$inboundSchema.parse(
        JSON.parse(x),
      ),
    `Failed to parse 'DeleteModelV1ModelsModelIdDeleteRequest' from JSON`,
  );
}
