// src/worker/index.ts
import path from "node:path";
import { fileURLToPath } from "node:url";

// dataurl:/home/runner/work/pdf-parse/pdf-parse/node_modules/pdfjs-dist/legacy/build/pdf.worker.min.mjs
var pdf_worker_min_default = "data:text/javascript;base64,LyoqCiAqIEBsaWNzdGFydCBUaGUgZm9sbG93aW5nIGlzIHRoZSBlbnRpcmUgbGljZW5zZSBub3RpY2UgZm9yIHRoZQogKiBKYXZhU2NyaXB0IGNvZGUgaW4gdGhpcyBwYWdlCiAqCiAqIENvcHlyaWdodCAyMDI0IE1vemlsbGEgRm91bmRhdGlvbgogKgogKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgIkxpY2Vuc2UiKTsKICogeW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLgogKiBZb3UgbWF5IG9idGFpbiBhIGNvcHkgb2YgdGhlIExpY2Vuc2UgYXQKICoKICogICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMAogKgogKiBVbmxlc3MgcmVxdWlyZWQgYnkgYXBwbGljYWJsZSBsYXcgb3IgYWdyZWVkIHRvIGluIHdyaXRpbmcsIHNvZnR3YXJlCiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICJBUyBJUyIgQkFTSVMsCiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLgogKiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kCiAqIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLgogKgogKiBAbGljZW5kIFRoZSBhYm92ZSBpcyB0aGUgZW50aXJlIGxpY2Vuc2Ugbm90aWNlIGZvciB0aGUKICogSmF2YVNjcmlwdCBjb2RlIGluIHRoaXMgcGFnZQogKi8KLyoqCiAqIHBkZmpzVmVyc2lvbiA9IDUuNC4yOTYKICogcGRmanNCdWlsZCA9IGY1NmRjODYwMQogKi92YXIgZT17MzQ6KGUsdCxyKT0+e3ZhciBhPXIoNDkwMSk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3JldHVybiJvYmplY3QiPT10eXBlb2YgZT9udWxsIT09ZTphKGUpfX0sODE6KGUsdCxyKT0+e3ZhciBhPXIoOTU2NSksbj1yKDkzMDYpLGk9cig4NTUxKSxzPXIoNjgyMyksbz1yKDg1MSksYz1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7dmFyIHI9YXJndW1lbnRzLmxlbmd0aDwyP28oZSk6dDtpZihuKHIpKXJldHVybiBpKGEocixlKSk7dGhyb3cgbmV3IGMocyhlKSsiIGlzIG5vdCBpdGVyYWJsZSIpfX0sMTE2OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig5NTY1KSxpPXIoMjY1Mikscz1yKDkzMDYpLG89cig4NTUxKSxjPXIoMTc2NyksbD1yKDk1MzkpLGg9cig0NTQ5KSgiZmluZCIsVHlwZUVycm9yKTthKHt0YXJnZXQ6Ikl0ZXJhdG9yIixwcm90bzohMCxyZWFsOiEwLGZvcmNlZDpofSx7ZmluZDpmdW5jdGlvbiBmaW5kKGUpe28odGhpcyk7dHJ5e3MoZSl9Y2F0Y2goZSl7bCh0aGlzLCJ0aHJvdyIsZSl9aWYoaClyZXR1cm4gbihoLHRoaXMsZSk7dmFyIHQ9Yyh0aGlzKSxyPTA7cmV0dXJuIGkodCxmdW5jdGlvbih0LGEpe2lmKGUodCxyKyspKXJldHVybiBhKHQpfSx7SVNfUkVDT1JEOiEwLElOVEVSUlVQVEVEOiEwfSkucmVzdWx0fX0pfSwyODM6KGUsdCxyKT0+e3ZhciBhPXIoOTUwNCksbj1yKDkwMzkpLGk9cig0OTAxKSxzPXIoOTI5Nyksbz1yKDM3MjQpLGM9cigzNTApLkNPTkZJR1VSQUJMRSxsPXIoMzcwNiksaD1yKDExODEpLHU9aC5lbmZvcmNlLGQ9aC5nZXQsZj1TdHJpbmcsZz1PYmplY3QuZGVmaW5lUHJvcGVydHkscD1hKCIiLnNsaWNlKSxtPWEoIiIucmVwbGFjZSksYj1hKFtdLmpvaW4pLHk9byYmIW4oZnVuY3Rpb24oKXtyZXR1cm4gOCE9PWcoZnVuY3Rpb24oKXt9LCJsZW5ndGgiLHt2YWx1ZTo4fSkubGVuZ3RofSksdz1TdHJpbmcoU3RyaW5nKS5zcGxpdCgiU3RyaW5nIikseD1lLmV4cG9ydHM9ZnVuY3Rpb24oZSx0LHIpeyJTeW1ib2woIj09PXAoZih0KSwwLDcpJiYodD0iWyIrbShmKHQpLC9eU3ltYm9sXCgoW14pXSopXCkuKiQvLCIkMSIpKyJdIik7ciYmci5nZXR0ZXImJih0PSJnZXQgIit0KTtyJiZyLnNldHRlciYmKHQ9InNldCAiK3QpOyghcyhlLCJuYW1lIil8fGMmJmUubmFtZSE9PXQpJiYobz9nKGUsIm5hbWUiLHt2YWx1ZTp0LGNvbmZpZ3VyYWJsZTohMH0pOmUubmFtZT10KTt5JiZyJiZzKHIsImFyaXR5IikmJmUubGVuZ3RoIT09ci5hcml0eSYmZyhlLCJsZW5ndGgiLHt2YWx1ZTpyLmFyaXR5fSk7dHJ5e3ImJnMociwiY29uc3RydWN0b3IiKSYmci5jb25zdHJ1Y3Rvcj9vJiZnKGUsInByb3RvdHlwZSIse3dyaXRhYmxlOiExfSk6ZS5wcm90b3R5cGUmJihlLnByb3RvdHlwZT12b2lkIDApfWNhdGNoKGUpe312YXIgYT11KGUpO3MoYSwic291cmNlIil8fChhLnNvdXJjZT1iKHcsInN0cmluZyI9PXR5cGVvZiB0P3Q6IiIpKTtyZXR1cm4gZX07RnVuY3Rpb24ucHJvdG90eXBlLnRvU3RyaW5nPXgoZnVuY3Rpb24gdG9TdHJpbmcoKXtyZXR1cm4gaSh0aGlzKSYmZCh0aGlzKS5zb3VyY2V8fGwodGhpcyl9LCJ0b1N0cmluZyIpfSwzNTA6KGUsdCxyKT0+e3ZhciBhPXIoMzcyNCksbj1yKDkyOTcpLGk9RnVuY3Rpb24ucHJvdG90eXBlLHM9YSYmT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcixvPW4oaSwibmFtZSIpLGM9byYmInNvbWV0aGluZyI9PT1mdW5jdGlvbiBzb21ldGhpbmcoKXt9Lm5hbWUsbD1vJiYoIWF8fGEmJnMoaSwibmFtZSIpLmNvbmZpZ3VyYWJsZSk7ZS5leHBvcnRzPXtFWElTVFM6byxQUk9QRVI6YyxDT05GSUdVUkFCTEU6bH19LDM5NzooZSx0LHIpPT57dmFyIGE9cig3NzUxKTtlLmV4cG9ydHM9YSgiZG9jdW1lbnQiLCJkb2N1bWVudEVsZW1lbnQiKX0sNDIxOmU9PntlLmV4cG9ydHM9e319LDQ1NjooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoNDU3NiksaT1yKDk1MDQpLHM9cig0MTU0KSxvPXIoNTE2OSksYz1pKDEuMS50b1N0cmluZyksbD1uLlVpbnQ4QXJyYXksaD0hbHx8IWwucHJvdG90eXBlLnRvSGV4fHwhZnVuY3Rpb24oKXt0cnl7cmV0dXJuImZmZmZmZmZmZmZmZmZmZmYiPT09bmV3IGwoWzI1NSwyNTUsMjU1LDI1NSwyNTUsMjU1LDI1NSwyNTVdKS50b0hleCgpfWNhdGNoKGUpe3JldHVybiExfX0oKTtsJiZhKHt0YXJnZXQ6IlVpbnQ4QXJyYXkiLHByb3RvOiEwLGZvcmNlZDpofSx7dG9IZXg6ZnVuY3Rpb24gdG9IZXgoKXtzKHRoaXMpO28odGhpcy5idWZmZXIpO2Zvcih2YXIgZT0iIix0PTAscj10aGlzLmxlbmd0aDt0PHI7dCsrKXt2YXIgYT1jKHRoaXNbdF0sMTYpO2UrPTE9PT1hLmxlbmd0aD8iMCIrYTphfXJldHVybiBlfX0pfSw1MDc6KGUsdCxyKT0+e3ZhciBhPXIoOTU2NSk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCxyKXtmb3IodmFyIG4saSxzPXI/ZTplLml0ZXJhdG9yLG89ZS5uZXh0OyEobj1hKG8scykpLmRvbmU7KWlmKHZvaWQgMCE9PShpPXQobi52YWx1ZSkpKXJldHVybiBpfX0sNTMxOihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig5NTY1KSxpPXIoOTMwNikscz1yKDg1NTEpLG89cigxNzY3KSxjPXIoODY0NiksbD1yKDk0NjIpLGg9cig5NTM5KSx1PXIoNjM5NSksZD1yKDY4NCksZj1yKDQ1NDkpLGc9IXUmJiFkKCJmbGF0TWFwIixmdW5jdGlvbigpe30pLHA9IXUmJiFnJiZmKCJmbGF0TWFwIixUeXBlRXJyb3IpLG09dXx8Z3x8cCxiPWwoZnVuY3Rpb24oKXtmb3IodmFyIGUsdCxyPXRoaXMuaXRlcmF0b3IsYT10aGlzLm1hcHBlcjs7KXtpZih0PXRoaXMuaW5uZXIpdHJ5e2lmKCEoZT1zKG4odC5uZXh0LHQuaXRlcmF0b3IpKSkuZG9uZSlyZXR1cm4gZS52YWx1ZTt0aGlzLmlubmVyPW51bGx9Y2F0Y2goZSl7aChyLCJ0aHJvdyIsZSl9ZT1zKG4odGhpcy5uZXh0LHIpKTtpZih0aGlzLmRvbmU9ISFlLmRvbmUpcmV0dXJuO3RyeXt0aGlzLmlubmVyPWMoYShlLnZhbHVlLHRoaXMuY291bnRlcisrKSwhMSl9Y2F0Y2goZSl7aChyLCJ0aHJvdyIsZSl9fX0pO2Eoe3RhcmdldDoiSXRlcmF0b3IiLHByb3RvOiEwLHJlYWw6ITAsZm9yY2VkOm19LHtmbGF0TWFwOmZ1bmN0aW9uIGZsYXRNYXAoZSl7cyh0aGlzKTt0cnl7aShlKX1jYXRjaChlKXtoKHRoaXMsInRocm93IixlKX1yZXR1cm4gcD9uKHAsdGhpcyxlKTpuZXcgYihvKHRoaXMpLHttYXBwZXI6ZSxpbm5lcjpudWxsfSl9fSl9LDYxNjooZSx0LHIpPT57dmFyIGE9cig5MDM5KTtlLmV4cG9ydHM9IWEoZnVuY3Rpb24oKXt2YXIgZT1mdW5jdGlvbigpe30uYmluZCgpO3JldHVybiJmdW5jdGlvbiIhPXR5cGVvZiBlfHxlLmhhc093blByb3BlcnR5KCJwcm90b3R5cGUiKX0pfSw2NTU6KGUsdCxyKT0+e3ZhciBhPXIoNjk1NSksbj1TdHJpbmc7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2lmKCJTeW1ib2wiPT09YShlKSl0aHJvdyBuZXcgVHlwZUVycm9yKCJDYW5ub3QgY29udmVydCBhIFN5bWJvbCB2YWx1ZSB0byBhIHN0cmluZyIpO3JldHVybiBuKGUpfX0sNjc5OihlLHQscik9Pnt2YXIgYT1yKDE2MjUpLG49VHlwZUVycm9yO2UuZXhwb3J0cz1mdW5jdGlvbihlLHQpe2lmKGEodCxlKSlyZXR1cm4gZTt0aHJvdyBuZXcgbigiSW5jb3JyZWN0IGludm9jYXRpb24iKX19LDY4NDplPT57ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7dmFyIHI9ImZ1bmN0aW9uIj09dHlwZW9mIEl0ZXJhdG9yJiZJdGVyYXRvci5wcm90b3R5cGVbZV07aWYocil0cnl7ci5jYWxsKHtuZXh0Om51bGx9LHQpLm5leHQoKX1jYXRjaChlKXtyZXR1cm4hMH19fSw3NDE6ZT0+e3ZhciB0PU1hdGguY2VpbCxyPU1hdGguZmxvb3I7ZS5leHBvcnRzPU1hdGgudHJ1bmN8fGZ1bmN0aW9uIHRydW5jKGUpe3ZhciBhPStlO3JldHVybihhPjA/cjp0KShhKX19LDc1NzooZSx0LHIpPT57dmFyIGE9cig3NzUxKSxuPXIoNDkwMSksaT1yKDE2MjUpLHM9cig3MDQwKSxvPU9iamVjdDtlLmV4cG9ydHM9cz9mdW5jdGlvbihlKXtyZXR1cm4ic3ltYm9sIj09dHlwZW9mIGV9OmZ1bmN0aW9uKGUpe3ZhciB0PWEoIlN5bWJvbCIpO3JldHVybiBuKHQpJiZpKHQucHJvdG90eXBlLG8oZSkpfX0sODUxOihlLHQscik9Pnt2YXIgYT1yKDY5NTUpLG49cig1OTY2KSxpPXIoNDExNykscz1yKDYyNjkpLG89cig4MjI3KSgiaXRlcmF0b3IiKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7aWYoIWkoZSkpcmV0dXJuIG4oZSxvKXx8bihlLCJAQGl0ZXJhdG9yIil8fHNbYShlKV19fSw5NDQ6ZT0+e3ZhciB0PVR5cGVFcnJvcjtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7dmFyIHI9ZSYmZS5hbHBoYWJldDtpZih2b2lkIDA9PT1yfHwiYmFzZTY0Ij09PXJ8fCJiYXNlNjR1cmwiPT09cilyZXR1cm4gcnx8ImJhc2U2NCI7dGhyb3cgbmV3IHQoIkluY29ycmVjdCBgYWxwaGFiZXRgIG9wdGlvbiIpfX0sMTA3MjooZSx0LHIpPT57dmFyIGE9cigxODI4KSxuPXIoODcyNyk7ZS5leHBvcnRzPU9iamVjdC5rZXlzfHxmdW5jdGlvbiBrZXlzKGUpe3JldHVybiBhKGUsbil9fSwxMTAzOmU9PntlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7dHJ5e3JldHVybntlcnJvcjohMSx2YWx1ZTplKCl9fWNhdGNoKGUpe3JldHVybntlcnJvcjohMCx2YWx1ZTplfX19fSwxMTA4OihlLHQscik9Pnt2YXIgYT1yKDY5NTUpO2UuZXhwb3J0cz1mdW5jdGlvbihlKXt2YXIgdD1hKGUpO3JldHVybiJCaWdJbnQ2NEFycmF5Ij09PXR8fCJCaWdVaW50NjRBcnJheSI9PT10fX0sMTE0ODooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoOTU2NSksaT1yKDI2NTIpLHM9cig5MzA2KSxvPXIoODU1MSksYz1yKDE3NjcpLGw9cig5NTM5KSxoPXIoNDU0OSkoImV2ZXJ5IixUeXBlRXJyb3IpO2Eoe3RhcmdldDoiSXRlcmF0b3IiLHByb3RvOiEwLHJlYWw6ITAsZm9yY2VkOmh9LHtldmVyeTpmdW5jdGlvbiBldmVyeShlKXtvKHRoaXMpO3RyeXtzKGUpfWNhdGNoKGUpe2wodGhpcywidGhyb3ciLGUpfWlmKGgpcmV0dXJuIG4oaCx0aGlzLGUpO3ZhciB0PWModGhpcykscj0wO3JldHVybiFpKHQsZnVuY3Rpb24odCxhKXtpZighZSh0LHIrKykpcmV0dXJuIGEoKX0se0lTX1JFQ09SRDohMCxJTlRFUlJVUFRFRDohMH0pLnN0b3BwZWR9fSl9LDExODE6KGUsdCxyKT0+e3ZhciBhLG4saSxzPXIoODYyMiksbz1yKDQ1NzYpLGM9cigzNCksbD1yKDY2OTkpLGg9cig5Mjk3KSx1PXIoNzYyOSksZD1yKDYxMTkpLGY9cig0MjEpLGc9Ik9iamVjdCBhbHJlYWR5IGluaXRpYWxpemVkIixwPW8uVHlwZUVycm9yLG09by5XZWFrTWFwO2lmKHN8fHUuc3RhdGUpe3ZhciBiPXUuc3RhdGV8fCh1LnN0YXRlPW5ldyBtKTtiLmdldD1iLmdldDtiLmhhcz1iLmhhcztiLnNldD1iLnNldDthPWZ1bmN0aW9uKGUsdCl7aWYoYi5oYXMoZSkpdGhyb3cgbmV3IHAoZyk7dC5mYWNhZGU9ZTtiLnNldChlLHQpO3JldHVybiB0fTtuPWZ1bmN0aW9uKGUpe3JldHVybiBiLmdldChlKXx8e319O2k9ZnVuY3Rpb24oZSl7cmV0dXJuIGIuaGFzKGUpfX1lbHNle3ZhciB5PWQoInN0YXRlIik7Zlt5XT0hMDthPWZ1bmN0aW9uKGUsdCl7aWYoaChlLHkpKXRocm93IG5ldyBwKGcpO3QuZmFjYWRlPWU7bChlLHksdCk7cmV0dXJuIHR9O249ZnVuY3Rpb24oZSl7cmV0dXJuIGgoZSx5KT9lW3ldOnt9fTtpPWZ1bmN0aW9uKGUpe3JldHVybiBoKGUseSl9fWUuZXhwb3J0cz17c2V0OmEsZ2V0Om4saGFzOmksZW5mb3JjZTpmdW5jdGlvbihlKXtyZXR1cm4gaShlKT9uKGUpOmEoZSx7fSl9LGdldHRlckZvcjpmdW5jdGlvbihlKXtyZXR1cm4gZnVuY3Rpb24odCl7dmFyIHI7aWYoIWModCl8fChyPW4odCkpLnR5cGUhPT1lKXRocm93IG5ldyBwKCJJbmNvbXBhdGlibGUgcmVjZWl2ZXIsICIrZSsiIHJlcXVpcmVkIik7cmV0dXJuIHJ9fX19LDEyOTE6KGUsdCxyKT0+e3ZhciBhPXIoNzQxKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7dmFyIHQ9K2U7cmV0dXJuIHQhPXR8fDA9PT10PzA6YSh0KX19LDEzODU6KGUsdCxyKT0+e3ZhciBhPXIoOTUzOSk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCxyKXtmb3IodmFyIG49ZS5sZW5ndGgtMTtuPj0wO24tLSlpZih2b2lkIDAhPT1lW25dKXRyeXtyPWEoZVtuXS5pdGVyYXRvcix0LHIpfWNhdGNoKGUpe3Q9InRocm93IjtyPWV9aWYoInRocm93Ij09PXQpdGhyb3cgcjtyZXR1cm4gcn19LDE1NDg6KGUsdCxyKT0+e3ZhciBhPXIoNDU3Niksbj1yKDkwMzkpLGk9cig5NTE5KSxzPXIoNDIxNSksbz1hLnN0cnVjdHVyZWRDbG9uZTtlLmV4cG9ydHM9ISFvJiYhbihmdW5jdGlvbigpe2lmKCJERU5PIj09PXMmJmk+OTJ8fCJOT0RFIj09PXMmJmk+OTR8fCJCUk9XU0VSIj09PXMmJmk+OTcpcmV0dXJuITE7dmFyIGU9bmV3IEFycmF5QnVmZmVyKDgpLHQ9byhlLHt0cmFuc2ZlcjpbZV19KTtyZXR1cm4gMCE9PWUuYnl0ZUxlbmd0aHx8OCE9PXQuYnl0ZUxlbmd0aH0pfSwxNTQ5OihlLHQscik9PntyKDY2MzIpfSwxNjI1OihlLHQscik9Pnt2YXIgYT1yKDk1MDQpO2UuZXhwb3J0cz1hKHt9LmlzUHJvdG90eXBlT2YpfSwxNjg5OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig0NTc2KSxpPXIoODc0NSkscz1yKDc2ODApLG89cig2MDQzKSxjPXIoOTMwNiksbD1yKDExMDMpLGg9bi5Qcm9taXNlLHU9ITE7YSh7dGFyZ2V0OiJQcm9taXNlIixzdGF0OiEwLGZvcmNlZDohaHx8IWgudHJ5fHxsKGZ1bmN0aW9uKCl7aC50cnkoZnVuY3Rpb24oZSl7dT04PT09ZX0sOCl9KS5lcnJvcnx8IXV9LHt0cnk6ZnVuY3Rpb24oZSl7dmFyIHQ9YXJndW1lbnRzLmxlbmd0aD4xP3MoYXJndW1lbnRzLDEpOltdLHI9by5mKHRoaXMpLGE9bChmdW5jdGlvbigpe3JldHVybiBpKGMoZSksdm9pZCAwLHQpfSk7KGEuZXJyb3I/ci5yZWplY3Q6ci5yZXNvbHZlKShhLnZhbHVlKTtyZXR1cm4gci5wcm9taXNlfX0pfSwxNjk4OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig0MjA0KSxpPXIoOTgzNSk7YSh7dGFyZ2V0OiJTZXQiLHByb3RvOiEwLHJlYWw6ITAsZm9yY2VkOiFyKDQ5MTYpKCJ1bmlvbiIpfHwhaSgidW5pb24iKX0se3VuaW9uOm59KX0sMTcwMTooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoOTU2NSksaT1yKDkzMDYpLHM9cig4NTUxKSxvPXIoMTc2NyksYz1yKDk0NjIpLGw9cig2MzE5KSxoPXIoOTUzOSksdT1yKDY4NCksZD1yKDQ1NDkpLGY9cig2Mzk1KSxnPSFmJiYhdSgibWFwIixmdW5jdGlvbigpe30pLHA9IWYmJiFnJiZkKCJtYXAiLFR5cGVFcnJvciksbT1mfHxnfHxwLGI9YyhmdW5jdGlvbigpe3ZhciBlPXRoaXMuaXRlcmF0b3IsdD1zKG4odGhpcy5uZXh0LGUpKTtpZighKHRoaXMuZG9uZT0hIXQuZG9uZSkpcmV0dXJuIGwoZSx0aGlzLm1hcHBlcixbdC52YWx1ZSx0aGlzLmNvdW50ZXIrK10sITApfSk7YSh7dGFyZ2V0OiJJdGVyYXRvciIscHJvdG86ITAscmVhbDohMCxmb3JjZWQ6bX0se21hcDpmdW5jdGlvbiBtYXAoZSl7cyh0aGlzKTt0cnl7aShlKX1jYXRjaChlKXtoKHRoaXMsInRocm93IixlKX1yZXR1cm4gcD9uKHAsdGhpcyxlKTpuZXcgYihvKHRoaXMpLHttYXBwZXI6ZX0pfX0pfSwxNzY3OmU9PntlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7cmV0dXJue2l0ZXJhdG9yOmUsbmV4dDplLm5leHQsZG9uZTohMX19fSwxODA2OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig4NTUxKSxpPXIoMjY1Mikscz1yKDE3NjcpLG89W10ucHVzaDthKHt0YXJnZXQ6Ikl0ZXJhdG9yIixwcm90bzohMCxyZWFsOiEwfSx7dG9BcnJheTpmdW5jdGlvbiB0b0FycmF5KCl7dmFyIGU9W107aShzKG4odGhpcykpLG8se3RoYXQ6ZSxJU19SRUNPUkQ6ITB9KTtyZXR1cm4gZX19KX0sMTgyODooZSx0LHIpPT57dmFyIGE9cig5NTA0KSxuPXIoOTI5NyksaT1yKDUzOTcpLHM9cig5NjE3KS5pbmRleE9mLG89cig0MjEpLGM9YShbXS5wdXNoKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXt2YXIgcixhPWkoZSksbD0wLGg9W107Zm9yKHIgaW4gYSkhbihvLHIpJiZuKGEscikmJmMoaCxyKTtmb3IoO3QubGVuZ3RoPmw7KW4oYSxyPXRbbCsrXSkmJih+cyhoLHIpfHxjKGgscikpO3JldHVybiBofX0sMjEwNjooZSx0LHIpPT57dmFyIGE9cigyODMpLG49cig0OTEzKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0LHIpe3IuZ2V0JiZhKHIuZ2V0LHQse2dldHRlcjohMH0pO3Iuc2V0JiZhKHIuc2V0LHQse3NldHRlcjohMH0pO3JldHVybiBuLmYoZSx0LHIpfX0sMjE0MDooZSx0LHIpPT57dmFyIGE9e307YVtyKDgyMjcpKCJ0b1N0cmluZ1RhZyIpXT0ieiI7ZS5leHBvcnRzPSJbb2JqZWN0IHpdIj09PVN0cmluZyhhKX0sMjE5NTooZSx0LHIpPT57dmFyIGE9cig5NTA0KSxuPWEoe30udG9TdHJpbmcpLGk9YSgiIi5zbGljZSk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3JldHVybiBpKG4oZSksOCwtMSl9fSwyMjExOihlLHQscik9Pnt2YXIgYT1yKDkwMzkpO2UuZXhwb3J0cz0hYShmdW5jdGlvbigpe2Z1bmN0aW9uIEYoKXt9Ri5wcm90b3R5cGUuY29uc3RydWN0b3I9bnVsbDtyZXR1cm4gT2JqZWN0LmdldFByb3RvdHlwZU9mKG5ldyBGKSE9PUYucHJvdG90eXBlfSl9LDIzMDM6KGUsdCxyKT0+e3ZhciBhPXIoNDU3Niksbj1yKDk1MDQpLGk9YS5VaW50OEFycmF5LHM9YS5TeW50YXhFcnJvcixvPWEucGFyc2VJbnQsYz1NYXRoLm1pbixsPS9bXlxkYS1mXS9pLGg9bihsLmV4ZWMpLHU9bigiIi5zbGljZSk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7dmFyIHI9ZS5sZW5ndGg7aWYociUyIT0wKXRocm93IG5ldyBzKCJTdHJpbmcgc2hvdWxkIGJlIGFuIGV2ZW4gbnVtYmVyIG9mIGNoYXJhY3RlcnMiKTtmb3IodmFyIGE9dD9jKHQubGVuZ3RoLHIvMik6ci8yLG49dHx8bmV3IGkoYSksZD0wLGY9MDtmPGE7KXt2YXIgZz11KGUsZCxkKz0yKTtpZihoKGwsZykpdGhyb3cgbmV3IHMoIlN0cmluZyBzaG91bGQgb25seSBjb250YWluIGhleCBjaGFyYWN0ZXJzIik7bltmKytdPW8oZywxNil9cmV0dXJue2J5dGVzOm4scmVhZDpkfX19LDIzNjA6KGUsdCxyKT0+e3ZhciBhLG49cig4NTUxKSxpPXIoNjgwMSkscz1yKDg3MjcpLG89cig0MjEpLGM9cigzOTcpLGw9cig0MDU1KSxoPXIoNjExOSksdT0icHJvdG90eXBlIixkPSJzY3JpcHQiLGY9aCgiSUVfUFJPVE8iKSxFbXB0eUNvbnN0cnVjdG9yPWZ1bmN0aW9uKCl7fSxzY3JpcHRUYWc9ZnVuY3Rpb24oZSl7cmV0dXJuIjwiK2QrIj4iK2UrIjwvIitkKyI+In0sTnVsbFByb3RvT2JqZWN0VmlhQWN0aXZlWD1mdW5jdGlvbihlKXtlLndyaXRlKHNjcmlwdFRhZygiIikpO2UuY2xvc2UoKTt2YXIgdD1lLnBhcmVudFdpbmRvdy5PYmplY3Q7ZT1udWxsO3JldHVybiB0fSxOdWxsUHJvdG9PYmplY3Q9ZnVuY3Rpb24oKXt0cnl7YT1uZXcgQWN0aXZlWE9iamVjdCgiaHRtbGZpbGUiKX1jYXRjaChlKXt9TnVsbFByb3RvT2JqZWN0PSJ1bmRlZmluZWQiIT10eXBlb2YgZG9jdW1lbnQ/ZG9jdW1lbnQuZG9tYWluJiZhP051bGxQcm90b09iamVjdFZpYUFjdGl2ZVgoYSk6ZnVuY3Rpb24oKXt2YXIgZSx0PWwoImlmcmFtZSIpLHI9ImphdmEiK2QrIjoiO3Quc3R5bGUuZGlzcGxheT0ibm9uZSI7Yy5hcHBlbmRDaGlsZCh0KTt0LnNyYz1TdHJpbmcocik7KGU9dC5jb250ZW50V2luZG93LmRvY3VtZW50KS5vcGVuKCk7ZS53cml0ZShzY3JpcHRUYWcoImRvY3VtZW50LkY9T2JqZWN0IikpO2UuY2xvc2UoKTtyZXR1cm4gZS5GfSgpOk51bGxQcm90b09iamVjdFZpYUFjdGl2ZVgoYSk7Zm9yKHZhciBlPXMubGVuZ3RoO2UtLTspZGVsZXRlIE51bGxQcm90b09iamVjdFt1XVtzW2VdXTtyZXR1cm4gTnVsbFByb3RvT2JqZWN0KCl9O29bZl09ITA7ZS5leHBvcnRzPU9iamVjdC5jcmVhdGV8fGZ1bmN0aW9uIGNyZWF0ZShlLHQpe3ZhciByO2lmKG51bGwhPT1lKXtFbXB0eUNvbnN0cnVjdG9yW3VdPW4oZSk7cj1uZXcgRW1wdHlDb25zdHJ1Y3RvcjtFbXB0eUNvbnN0cnVjdG9yW3VdPW51bGw7cltmXT1lfWVsc2Ugcj1OdWxsUHJvdG9PYmplY3QoKTtyZXR1cm4gdm9pZCAwPT09dD9yOmkuZihyLHQpfX0sMjQ3NTooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoODUyNyk7YSh7dGFyZ2V0OiJTZXQiLHByb3RvOiEwLHJlYWw6ITAsZm9yY2VkOiFyKDQ5MTYpKCJpc1N1cGVyc2V0T2YiLGZ1bmN0aW9uKGUpe3JldHVybiFlfSl9LHtpc1N1cGVyc2V0T2Y6bn0pfSwyNDg5OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig5NTY1KSxpPXIoOTMwNikscz1yKDg1NTEpLG89cigxNzY3KSxjPXIoOTQ2MiksbD1yKDYzMTkpLGg9cig2Mzk1KSx1PXIoOTUzOSksZD1yKDY4NCksZj1yKDQ1NDkpLGc9IWgmJiFkKCJmaWx0ZXIiLGZ1bmN0aW9uKCl7fSkscD0haCYmIWcmJmYoImZpbHRlciIsVHlwZUVycm9yKSxtPWh8fGd8fHAsYj1jKGZ1bmN0aW9uKCl7Zm9yKHZhciBlLHQscj10aGlzLml0ZXJhdG9yLGE9dGhpcy5wcmVkaWNhdGUsaT10aGlzLm5leHQ7Oyl7ZT1zKG4oaSxyKSk7aWYodGhpcy5kb25lPSEhZS5kb25lKXJldHVybjt0PWUudmFsdWU7aWYobChyLGEsW3QsdGhpcy5jb3VudGVyKytdLCEwKSlyZXR1cm4gdH19KTthKHt0YXJnZXQ6Ikl0ZXJhdG9yIixwcm90bzohMCxyZWFsOiEwLGZvcmNlZDptfSx7ZmlsdGVyOmZ1bmN0aW9uIGZpbHRlcihlKXtzKHRoaXMpO3RyeXtpKGUpfWNhdGNoKGUpe3UodGhpcywidGhyb3ciLGUpfXJldHVybiBwP24ocCx0aGlzLGUpOm5ldyBiKG8odGhpcykse3ByZWRpY2F0ZTplfSl9fSl9LDI1Mjk6ZT0+e2UuZXhwb3J0cz1mdW5jdGlvbihlLHQpe3JldHVybnt2YWx1ZTplLGRvbmU6dH19fSwyNjAzOihlLHQscik9Pnt2YXIgYT1yKDY1NSk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHZvaWQgMD09PWU/YXJndW1lbnRzLmxlbmd0aDwyPyIiOnQ6YShlKX19LDI2NTI6KGUsdCxyKT0+e3ZhciBhPXIoNjA4MCksbj1yKDk1NjUpLGk9cig4NTUxKSxzPXIoNjgyMyksbz1yKDQyMDkpLGM9cig2MTk4KSxsPXIoMTYyNSksaD1yKDgxKSx1PXIoODUxKSxkPXIoOTUzOSksZj1UeXBlRXJyb3IsUmVzdWx0PWZ1bmN0aW9uKGUsdCl7dGhpcy5zdG9wcGVkPWU7dGhpcy5yZXN1bHQ9dH0sZz1SZXN1bHQucHJvdG90eXBlO2UuZXhwb3J0cz1mdW5jdGlvbihlLHQscil7dmFyIHAsbSxiLHksdyx4LFMsaz1yJiZyLnRoYXQsQz0hKCFyfHwhci5BU19FTlRSSUVTKSx2PSEoIXJ8fCFyLklTX1JFQ09SRCksVD0hKCFyfHwhci5JU19JVEVSQVRPUiksTz0hKCFyfHwhci5JTlRFUlJVUFRFRCksTT1hKHQsayksc3RvcD1mdW5jdGlvbihlKXtwJiZkKHAsIm5vcm1hbCIpO3JldHVybiBuZXcgUmVzdWx0KCEwLGUpfSxjYWxsRm49ZnVuY3Rpb24oZSl7aWYoQyl7aShlKTtyZXR1cm4gTz9NKGVbMF0sZVsxXSxzdG9wKTpNKGVbMF0sZVsxXSl9cmV0dXJuIE8/TShlLHN0b3ApOk0oZSl9O2lmKHYpcD1lLml0ZXJhdG9yO2Vsc2UgaWYoVClwPWU7ZWxzZXtpZighKG09dShlKSkpdGhyb3cgbmV3IGYocyhlKSsiIGlzIG5vdCBpdGVyYWJsZSIpO2lmKG8obSkpe2ZvcihiPTAseT1jKGUpO3k+YjtiKyspaWYoKHc9Y2FsbEZuKGVbYl0pKSYmbChnLHcpKXJldHVybiB3O3JldHVybiBuZXcgUmVzdWx0KCExKX1wPWgoZSxtKX14PXY/ZS5uZXh0OnAubmV4dDtmb3IoOyEoUz1uKHgscCkpLmRvbmU7KXt0cnl7dz1jYWxsRm4oUy52YWx1ZSl9Y2F0Y2goZSl7ZChwLCJ0aHJvdyIsZSl9aWYoIm9iamVjdCI9PXR5cGVvZiB3JiZ3JiZsKGcsdykpcmV0dXJuIHd9cmV0dXJuIG5ldyBSZXN1bHQoITEpfX0sMjc3NzooZSx0LHIpPT57dmFyIGE9cig5NTY1KSxuPXIoMzQpLGk9cig3NTcpLHM9cig1OTY2KSxvPXIoNDI3MCksYz1yKDgyMjcpLGw9VHlwZUVycm9yLGg9YygidG9QcmltaXRpdmUiKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXtpZighbihlKXx8aShlKSlyZXR1cm4gZTt2YXIgcixjPXMoZSxoKTtpZihjKXt2b2lkIDA9PT10JiYodD0iZGVmYXVsdCIpO3I9YShjLGUsdCk7aWYoIW4ocil8fGkocikpcmV0dXJuIHI7dGhyb3cgbmV3IGwoIkNhbid0IGNvbnZlcnQgb2JqZWN0IHRvIHByaW1pdGl2ZSB2YWx1ZSIpfXZvaWQgMD09PXQmJih0PSJudW1iZXIiKTtyZXR1cm4gbyhlLHQpfX0sMjc4NzooZSx0LHIpPT57dmFyIGE9cig5Mjk3KSxuPXIoNDkwMSksaT1yKDg5ODEpLHM9cig2MTE5KSxvPXIoMjIxMSksYz1zKCJJRV9QUk9UTyIpLGw9T2JqZWN0LGg9bC5wcm90b3R5cGU7ZS5leHBvcnRzPW8/bC5nZXRQcm90b3R5cGVPZjpmdW5jdGlvbihlKXt2YXIgdD1pKGUpO2lmKGEodCxjKSlyZXR1cm4gdFtjXTt2YXIgcj10LmNvbnN0cnVjdG9yO3JldHVybiBuKHIpJiZ0IGluc3RhbmNlb2Ygcj9yLnByb3RvdHlwZTp0IGluc3RhbmNlb2YgbD9oOm51bGx9fSwyNzk2OihlLHQscik9Pnt2YXIgYT1yKDkwMzkpLG49cig0OTAxKSxpPS8jfFwucHJvdG90eXBlXC4vLGlzRm9yY2VkPWZ1bmN0aW9uKGUsdCl7dmFyIHI9b1tzKGUpXTtyZXR1cm4gcj09PWx8fHIhPT1jJiYobih0KT9hKHQpOiEhdCl9LHM9aXNGb3JjZWQubm9ybWFsaXplPWZ1bmN0aW9uKGUpe3JldHVybiBTdHJpbmcoZSkucmVwbGFjZShpLCIuIikudG9Mb3dlckNhc2UoKX0sbz1pc0ZvcmNlZC5kYXRhPXt9LGM9aXNGb3JjZWQuTkFUSVZFPSJOIixsPWlzRm9yY2VkLlBPTFlGSUxMPSJQIjtlLmV4cG9ydHM9aXNGb3JjZWR9LDI4MDQ6ZT0+e3ZhciB0PSJBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWmFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6MDEyMzQ1Njc4OSIscj10KyIrLyIsYT10KyItXyIsaW52ZXJzZT1mdW5jdGlvbihlKXtmb3IodmFyIHQ9e30scj0wO3I8NjQ7cisrKXRbZS5jaGFyQXQocildPXI7cmV0dXJuIHR9O2UuZXhwb3J0cz17aTJjOnIsYzJpOmludmVyc2UociksaTJjVXJsOmEsYzJpVXJsOmludmVyc2UoYSl9fSwyODEyOmU9Pnt2YXIgdD1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUscil7aWYoZTxyKXRocm93IG5ldyB0KCJOb3QgZW5vdWdoIGFyZ3VtZW50cyIpO3JldHVybiBlfX0sMjgzOTooZSx0LHIpPT57dmFyIGE9cig0NTc2KS5uYXZpZ2F0b3Isbj1hJiZhLnVzZXJBZ2VudDtlLmV4cG9ydHM9bj9TdHJpbmcobik6IiJ9LDI5Njc6KGUsdCxyKT0+e3ZhciBhPXIoNjcwNiksbj1yKDM0KSxpPXIoNzc1MCkscz1yKDM1MDYpO2UuZXhwb3J0cz1PYmplY3Quc2V0UHJvdG90eXBlT2Z8fCgiX19wcm90b19fImlue30/ZnVuY3Rpb24oKXt2YXIgZSx0PSExLHI9e307dHJ5eyhlPWEoT2JqZWN0LnByb3RvdHlwZSwiX19wcm90b19fIiwic2V0IikpKHIsW10pO3Q9ciBpbnN0YW5jZW9mIEFycmF5fWNhdGNoKGUpe31yZXR1cm4gZnVuY3Rpb24gc2V0UHJvdG90eXBlT2YocixhKXtpKHIpO3MoYSk7aWYoIW4ocikpcmV0dXJuIHI7dD9lKHIsYSk6ci5fX3Byb3RvX189YTtyZXR1cm4gcn19KCk6dm9pZCAwKX0sMzA2ODooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoOTUwNCksaT1yKDI2NTIpLHM9UmFuZ2VFcnJvcixvPVR5cGVFcnJvcixjPTEvMCxsPU1hdGguYWJzLGg9TWF0aC5wb3csdT1uKFtdLnB1c2gpLGQ9aCgyLDEwMjMpLGY9aCgyLDUzKS0xLGc9TnVtYmVyLk1BWF9WQUxVRSxwPWgoMiw5NzEpLG09e30sYj17fSx5PXt9LHc9e30seD17fSx0d29zdW09ZnVuY3Rpb24oZSx0KXt2YXIgcj1lK3Q7cmV0dXJue2hpOnIsbG86dC0oci1lKX19O2Eoe3RhcmdldDoiTWF0aCIsc3RhdDohMH0se3N1bVByZWNpc2U6ZnVuY3Rpb24gc3VtUHJlY2lzZShlKXt2YXIgdD1bXSxyPTAsYT13O2koZSxmdW5jdGlvbihlKXtpZigrK3I+PWYpdGhyb3cgbmV3IHMoIk1heGltdW0gYWxsb3dlZCBpbmRleCBleGNlZWRlZCIpO2lmKCJudW1iZXIiIT10eXBlb2YgZSl0aHJvdyBuZXcgbygiVmFsdWUgaXMgbm90IGEgbnVtYmVyIik7aWYoYSE9PW0paWYoZSE9ZSlhPW07ZWxzZSBpZihlPT09YylhPWE9PT1iP206eTtlbHNlIGlmKGU9PT0tMS8wKWE9YT09PXk/bTpiO2Vsc2UgaWYoISgwPT09ZSYmMS9lIT09Y3x8YSE9PXcmJmEhPT14KSl7YT14O3UodCxlKX19KTtzd2l0Y2goYSl7Y2FzZSBtOnJldHVybiBOYU47Y2FzZSBiOnJldHVybi0xLzA7Y2FzZSB5OnJldHVybiBjO2Nhc2UgdzpyZXR1cm4tMH1mb3IodmFyIG4saCxTLGssQyx2LFQ9W10sTz0wLE09MDtNPHQubGVuZ3RoO00rKyl7bj10W01dO2Zvcih2YXIgRD0wLFI9MDtSPFQubGVuZ3RoO1IrKyl7aD1UW1JdO2lmKGwobik8bChoKSl7dj1uO249aDtoPXZ9az0oUz10d29zdW0obixoKSkuaGk7Qz1TLmxvO2lmKGwoayk9PT1jKXt2YXIgRT1rPT09Yz8xOi0xO08rPUU7aWYobChuPW4tRSpkLUUqZCk8bChoKSl7dj1uO249aDtoPXZ9az0oUz10d29zdW0obixoKSkuaGk7Qz1TLmxvfTAhPT1DJiYoVFtEKytdPUMpO249a31ULmxlbmd0aD1EOzAhPT1uJiZ1KFQsbil9dmFyIE49VC5sZW5ndGgtMTtrPTA7Qz0wO2lmKDAhPT1PKXt2YXIgXz1OPj0wP1RbTl06MDtOLS07aWYobChPKT4xfHxPPjAmJl8+MHx8TzwwJiZfPDApcmV0dXJuIE8+MD9jOi0xLzA7az0oUz10d29zdW0oTypkLF8vMikpLmhpO0M9Uy5sbztDKj0yO2lmKGwoMiprKT09PWMpcmV0dXJuIGs+MD9rPT09ZCYmQz09PS1wLzImJk4+PTAmJlRbTl08MD9nOmM6az09PS1kJiZDPT09cC8yJiZOPj0wJiZUW05dPjA/LWc6LTEvMDtpZigwIT09Qyl7VFsrK05dPUM7Qz0wfWsqPTJ9Zm9yKDtOPj0wOyl7az0oUz10d29zdW0oayxUW04tLV0pKS5oaTtpZigwIT09KEM9Uy5sbykpYnJlYWt9Tj49MCYmKEM8MCYmVFtOXTwwfHxDPjAmJlRbTl0+MCkmJihoPTIqQyk9PT0obj1rK2gpLWsmJihrPW4pO3JldHVybiBrfX0pfSwzMTY3OihlLHQscik9Pnt2YXIgYT1yKDQ5MDEpLG49cigzNCksaT1yKDI5NjcpO2UuZXhwb3J0cz1mdW5jdGlvbihlLHQscil7dmFyIHMsbztpJiZhKHM9dC5jb25zdHJ1Y3RvcikmJnMhPT1yJiZuKG89cy5wcm90b3R5cGUpJiZvIT09ci5wcm90b3R5cGUmJmkoZSxvKTtyZXR1cm4gZX19LDMyMzg6KGUsdCxyKT0+e3ZhciBhPXIoNDU3Niksbj1yKDc4MTEpLGk9cig3Mzk0KSxzPWEuRGF0YVZpZXc7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2lmKCFufHwwIT09aShlKSlyZXR1cm4hMTt0cnl7bmV3IHMoZSk7cmV0dXJuITF9Y2F0Y2goZSl7cmV0dXJuITB9fX0sMzM5MjooZSx0LHIpPT57dmFyIGE9cig5NTA0KSxuPTAsaT1NYXRoLnJhbmRvbSgpLHM9YSgxLjEudG9TdHJpbmcpO2UuZXhwb3J0cz1mdW5jdGlvbihlKXtyZXR1cm4iU3ltYm9sKCIrKHZvaWQgMD09PWU/IiI6ZSkrIilfIitzKCsrbitpLDM2KX19LDM0NDA6KGUsdCxyKT0+e3ZhciBhPXIoNzA4MCksbj1yKDQ0MDIpLGk9cig5Mjg2KSxzPXIoNTE3MCksbz1yKDM3ODkpLGM9cig4NDY5KSxsPXIoNTA3KSxoPW4uaGFzLHU9bi5yZW1vdmU7ZS5leHBvcnRzPWZ1bmN0aW9uIGRpZmZlcmVuY2UoZSl7dmFyIHQ9YSh0aGlzKSxyPW8oZSksbj1pKHQpO3ModCk8PXIuc2l6ZT9jKHQsZnVuY3Rpb24oZSl7ci5pbmNsdWRlcyhlKSYmdShuLGUpfSk6bChyLmdldEl0ZXJhdG9yKCksZnVuY3Rpb24oZSl7aChuLGUpJiZ1KG4sZSl9KTtyZXR1cm4gbn19LDM0NjM6ZT0+e3ZhciB0PVR5cGVFcnJvcjtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7aWYoInN0cmluZyI9PXR5cGVvZiBlKXJldHVybiBlO3Rocm93IG5ldyB0KCJBcmd1bWVudCBpcyBub3QgYSBzdHJpbmciKX19LDM1MDY6KGUsdCxyKT0+e3ZhciBhPXIoMzkyNSksbj1TdHJpbmcsaT1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2lmKGEoZSkpcmV0dXJuIGU7dGhyb3cgbmV3IGkoIkNhbid0IHNldCAiK24oZSkrIiBhcyBhIHByb3RvdHlwZSIpfX0sMzU3OTooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoOTU2NSksaT1yKDI2NTIpLHM9cig5MzA2KSxvPXIoODU1MSksYz1yKDE3NjcpLGw9cig5NTM5KSxoPXIoNDU0OSkoInNvbWUiLFR5cGVFcnJvcik7YSh7dGFyZ2V0OiJJdGVyYXRvciIscHJvdG86ITAscmVhbDohMCxmb3JjZWQ6aH0se3NvbWU6ZnVuY3Rpb24gc29tZShlKXtvKHRoaXMpO3RyeXtzKGUpfWNhdGNoKGUpe2wodGhpcywidGhyb3ciLGUpfWlmKGgpcmV0dXJuIG4oaCx0aGlzLGUpO3ZhciB0PWModGhpcykscj0wO3JldHVybiBpKHQsZnVuY3Rpb24odCxhKXtpZihlKHQscisrKSlyZXR1cm4gYSgpfSx7SVNfUkVDT1JEOiEwLElOVEVSUlVQVEVEOiEwfSkuc3RvcHBlZH19KX0sMzYxMTooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoNDU3NiksaT1yKDIxMDYpLHM9cigzNzI0KSxvPVR5cGVFcnJvcixjPU9iamVjdC5kZWZpbmVQcm9wZXJ0eSxsPW4uc2VsZiE9PW47dHJ5e2lmKHMpe3ZhciBoPU9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3Iobiwic2VsZiIpOyFsJiZoJiZoLmdldCYmaC5lbnVtZXJhYmxlfHxpKG4sInNlbGYiLHtnZXQ6ZnVuY3Rpb24gc2VsZigpe3JldHVybiBufSxzZXQ6ZnVuY3Rpb24gc2VsZihlKXtpZih0aGlzIT09bil0aHJvdyBuZXcgbygiSWxsZWdhbCBpbnZvY2F0aW9uIik7YyhuLCJzZWxmIix7dmFsdWU6ZSx3cml0YWJsZTohMCxjb25maWd1cmFibGU6ITAsZW51bWVyYWJsZTohMH0pfSxjb25maWd1cmFibGU6ITAsZW51bWVyYWJsZTohMH0pfWVsc2UgYSh7Z2xvYmFsOiEwLHNpbXBsZTohMCxmb3JjZWQ6bH0se3NlbGY6bn0pfWNhdGNoKGUpe319LDM2NTA6KGUsdCxyKT0+e3ZhciBhPXIoNzA4MCksbj1yKDQ0MDIpLGk9cig5Mjg2KSxzPXIoMzc4OSksbz1yKDUwNyksYz1uLmFkZCxsPW4uaGFzLGg9bi5yZW1vdmU7ZS5leHBvcnRzPWZ1bmN0aW9uIHN5bW1ldHJpY0RpZmZlcmVuY2UoZSl7dmFyIHQ9YSh0aGlzKSxyPXMoZSkuZ2V0SXRlcmF0b3IoKSxuPWkodCk7byhyLGZ1bmN0aW9uKGUpe2wodCxlKT9oKG4sZSk6YyhuLGUpfSk7cmV0dXJuIG59fSwzNzA2OihlLHQscik9Pnt2YXIgYT1yKDk1MDQpLG49cig0OTAxKSxpPXIoNzYyOSkscz1hKEZ1bmN0aW9uLnRvU3RyaW5nKTtuKGkuaW5zcGVjdFNvdXJjZSl8fChpLmluc3BlY3RTb3VyY2U9ZnVuY3Rpb24oZSl7cmV0dXJuIHMoZSl9KTtlLmV4cG9ydHM9aS5pbnNwZWN0U291cmNlfSwzNzE3OihlLHQpPT57dC5mPU9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHN9LDM3MjQ6KGUsdCxyKT0+e3ZhciBhPXIoOTAzOSk7ZS5leHBvcnRzPSFhKGZ1bmN0aW9uKCl7cmV0dXJuIDchPT1PYmplY3QuZGVmaW5lUHJvcGVydHkoe30sMSx7Z2V0OmZ1bmN0aW9uKCl7cmV0dXJuIDd9fSlbMV19KX0sMzc4OTooZSx0LHIpPT57dmFyIGE9cig5MzA2KSxuPXIoODU1MSksaT1yKDk1NjUpLHM9cigxMjkxKSxvPXIoMTc2NyksYz0iSW52YWxpZCBzaXplIixsPVJhbmdlRXJyb3IsaD1UeXBlRXJyb3IsdT1NYXRoLm1heCxTZXRSZWNvcmQ9ZnVuY3Rpb24oZSx0KXt0aGlzLnNldD1lO3RoaXMuc2l6ZT11KHQsMCk7dGhpcy5oYXM9YShlLmhhcyk7dGhpcy5rZXlzPWEoZS5rZXlzKX07U2V0UmVjb3JkLnByb3RvdHlwZT17Z2V0SXRlcmF0b3I6ZnVuY3Rpb24oKXtyZXR1cm4gbyhuKGkodGhpcy5rZXlzLHRoaXMuc2V0KSkpfSxpbmNsdWRlczpmdW5jdGlvbihlKXtyZXR1cm4gaSh0aGlzLmhhcyx0aGlzLnNldCxlKX19O2UuZXhwb3J0cz1mdW5jdGlvbihlKXtuKGUpO3ZhciB0PStlLnNpemU7aWYodCE9dCl0aHJvdyBuZXcgaChjKTt2YXIgcj1zKHQpO2lmKHI8MCl0aHJvdyBuZXcgbChjKTtyZXR1cm4gbmV3IFNldFJlY29yZChlLHIpfX0sMzgzODooZSx0LHIpPT57dmFyIGE9cig3MDgwKSxuPXIoNTE3MCksaT1yKDg0NjkpLHM9cigzNzg5KTtlLmV4cG9ydHM9ZnVuY3Rpb24gaXNTdWJzZXRPZihlKXt2YXIgdD1hKHRoaXMpLHI9cyhlKTtyZXR1cm4hKG4odCk+ci5zaXplKSYmITEhPT1pKHQsZnVuY3Rpb24oZSl7aWYoIXIuaW5jbHVkZXMoZSkpcmV0dXJuITF9LCEwKX19LDM4NTM6KGUsdCxyKT0+e3ZhciBhPXIoNjUxOCksbj1yKDQ0NDkpO2Eoe3RhcmdldDoiU2V0Iixwcm90bzohMCxyZWFsOiEwLGZvcmNlZDohcig0OTE2KSgiaXNEaXNqb2ludEZyb20iLGZ1bmN0aW9uKGUpe3JldHVybiFlfSl9LHtpc0Rpc2pvaW50RnJvbTpufSl9LDM5MjU6KGUsdCxyKT0+e3ZhciBhPXIoMzQpO2UuZXhwb3J0cz1mdW5jdGlvbihlKXtyZXR1cm4gYShlKXx8bnVsbD09PWV9fSwzOTcyOihlLHQscik9Pnt2YXIgYT1yKDM0KSxuPVN0cmluZyxpPVR5cGVFcnJvcjtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7aWYodm9pZCAwPT09ZXx8YShlKSlyZXR1cm4gZTt0aHJvdyBuZXcgaShuKGUpKyIgaXMgbm90IGFuIG9iamVjdCBvciB1bmRlZmluZWQiKX19LDQwNTU6KGUsdCxyKT0+e3ZhciBhPXIoNDU3Niksbj1yKDM0KSxpPWEuZG9jdW1lbnQscz1uKGkpJiZuKGkuY3JlYXRlRWxlbWVudCk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3JldHVybiBzP2kuY3JlYXRlRWxlbWVudChlKTp7fX19LDQxMTQ6KGUsdCxyKT0+e3ZhciBhPXIoNjUxOCksbj1yKDg5ODEpLGk9cig2MTk4KSxzPXIoNDUyNyksbz1yKDY4MzcpO2Eoe3RhcmdldDoiQXJyYXkiLHByb3RvOiEwLGFyaXR5OjEsZm9yY2VkOnIoOTAzOSkoZnVuY3Rpb24oKXtyZXR1cm4gNDI5NDk2NzI5NyE9PVtdLnB1c2guY2FsbCh7bGVuZ3RoOjQyOTQ5NjcyOTZ9LDEpfSl8fCFmdW5jdGlvbigpe3RyeXtPYmplY3QuZGVmaW5lUHJvcGVydHkoW10sImxlbmd0aCIse3dyaXRhYmxlOiExfSkucHVzaCgpfWNhdGNoKGUpe3JldHVybiBlIGluc3RhbmNlb2YgVHlwZUVycm9yfX0oKX0se3B1c2g6ZnVuY3Rpb24gcHVzaChlKXt2YXIgdD1uKHRoaXMpLHI9aSh0KSxhPWFyZ3VtZW50cy5sZW5ndGg7byhyK2EpO2Zvcih2YXIgYz0wO2M8YTtjKyspe3Rbcl09YXJndW1lbnRzW2NdO3IrK31zKHQscik7cmV0dXJuIHJ9fSl9LDQxMTc6ZT0+e2UuZXhwb3J0cz1mdW5jdGlvbihlKXtyZXR1cm4gbnVsbD09ZX19LDQxNTQ6KGUsdCxyKT0+e3ZhciBhPXIoNjk1NSksbj1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2lmKCJVaW50OEFycmF5Ij09PWEoZSkpcmV0dXJuIGU7dGhyb3cgbmV3IG4oIkFyZ3VtZW50IGlzIG5vdCBhbiBVaW50OEFycmF5Iil9fSw0MjA0OihlLHQscik9Pnt2YXIgYT1yKDcwODApLG49cig0NDAyKS5hZGQsaT1yKDkyODYpLHM9cigzNzg5KSxvPXIoNTA3KTtlLmV4cG9ydHM9ZnVuY3Rpb24gdW5pb24oZSl7dmFyIHQ9YSh0aGlzKSxyPXMoZSkuZ2V0SXRlcmF0b3IoKSxjPWkodCk7byhyLGZ1bmN0aW9uKGUpe24oYyxlKX0pO3JldHVybiBjfX0sNDIwOTooZSx0LHIpPT57dmFyIGE9cig4MjI3KSxuPXIoNjI2OSksaT1hKCJpdGVyYXRvciIpLHM9QXJyYXkucHJvdG90eXBlO2UuZXhwb3J0cz1mdW5jdGlvbihlKXtyZXR1cm4gdm9pZCAwIT09ZSYmKG4uQXJyYXk9PT1lfHxzW2ldPT09ZSl9fSw0MjE1OihlLHQscik9Pnt2YXIgYT1yKDQ1NzYpLG49cigyODM5KSxpPXIoMjE5NSksdXNlckFnZW50U3RhcnRzV2l0aD1mdW5jdGlvbihlKXtyZXR1cm4gbi5zbGljZSgwLGUubGVuZ3RoKT09PWV9O2UuZXhwb3J0cz11c2VyQWdlbnRTdGFydHNXaXRoKCJCdW4vIik/IkJVTiI6dXNlckFnZW50U3RhcnRzV2l0aCgiQ2xvdWRmbGFyZS1Xb3JrZXJzIik/IkNMT1VERkxBUkUiOnVzZXJBZ2VudFN0YXJ0c1dpdGgoIkRlbm8vIik/IkRFTk8iOnVzZXJBZ2VudFN0YXJ0c1dpdGgoIk5vZGUuanMvIik/Ik5PREUiOmEuQnVuJiYic3RyaW5nIj09dHlwZW9mIEJ1bi52ZXJzaW9uPyJCVU4iOmEuRGVubyYmIm9iamVjdCI9PXR5cGVvZiBEZW5vLnZlcnNpb24/IkRFTk8iOiJwcm9jZXNzIj09PWkoYS5wcm9jZXNzKT8iTk9ERSI6YS53aW5kb3cmJmEuZG9jdW1lbnQ/IkJST1dTRVIiOiJSRVNUIn0sNDIyNjooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoNDU3NiksaT1yKDM0NjMpLHM9cig0MTU0KSxvPXIoNTE2OSksYz1yKDIzMDMpO24uVWludDhBcnJheSYmYSh7dGFyZ2V0OiJVaW50OEFycmF5Iixwcm90bzohMH0se3NldEZyb21IZXg6ZnVuY3Rpb24gc2V0RnJvbUhleChlKXtzKHRoaXMpO2koZSk7byh0aGlzLmJ1ZmZlcik7dmFyIHQ9YyhlLHRoaXMpLnJlYWQ7cmV0dXJue3JlYWQ6dCx3cml0dGVuOnQvMn19fSl9LDQyMzU6KGUsdCxyKT0+e3IoMzA2OCl9LDQyNzA6KGUsdCxyKT0+e3ZhciBhPXIoOTU2NSksbj1yKDQ5MDEpLGk9cigzNCkscz1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7dmFyIHIsbztpZigic3RyaW5nIj09PXQmJm4ocj1lLnRvU3RyaW5nKSYmIWkobz1hKHIsZSkpKXJldHVybiBvO2lmKG4ocj1lLnZhbHVlT2YpJiYhaShvPWEocixlKSkpcmV0dXJuIG87aWYoInN0cmluZyIhPT10JiZuKHI9ZS50b1N0cmluZykmJiFpKG89YShyLGUpKSlyZXR1cm4gbzt0aHJvdyBuZXcgcygiQ2FuJ3QgY29udmVydCBvYmplY3QgdG8gcHJpbWl0aXZlIHZhbHVlIil9fSw0Mzc2OihlLHQscik9Pnt2YXIgYT1yKDIxOTUpO2UuZXhwb3J0cz1BcnJheS5pc0FycmF5fHxmdW5jdGlvbiBpc0FycmF5KGUpe3JldHVybiJBcnJheSI9PT1hKGUpfX0sNDQwMjooZSx0LHIpPT57dmFyIGE9cig5NTA0KSxuPVNldC5wcm90b3R5cGU7ZS5leHBvcnRzPXtTZXQsYWRkOmEobi5hZGQpLGhhczphKG4uaGFzKSxyZW1vdmU6YShuLmRlbGV0ZSkscHJvdG86bn19LDQ0NDk6KGUsdCxyKT0+e3ZhciBhPXIoNzA4MCksbj1yKDQ0MDIpLmhhcyxpPXIoNTE3MCkscz1yKDM3ODkpLG89cig4NDY5KSxjPXIoNTA3KSxsPXIoOTUzOSk7ZS5leHBvcnRzPWZ1bmN0aW9uIGlzRGlzam9pbnRGcm9tKGUpe3ZhciB0PWEodGhpcykscj1zKGUpO2lmKGkodCk8PXIuc2l6ZSlyZXR1cm4hMSE9PW8odCxmdW5jdGlvbihlKXtpZihyLmluY2x1ZGVzKGUpKXJldHVybiExfSwhMCk7dmFyIGg9ci5nZXRJdGVyYXRvcigpO3JldHVybiExIT09YyhoLGZ1bmN0aW9uKGUpe2lmKG4odCxlKSlyZXR1cm4gbChoLCJub3JtYWwiLCExKX0pfX0sNDQ4MzooZSx0LHIpPT57dmFyIGEsbixpLHMsbz1yKDQ1NzYpLGM9cig5NDI5KSxsPXIoMTU0OCksaD1vLnN0cnVjdHVyZWRDbG9uZSx1PW8uQXJyYXlCdWZmZXIsZD1vLk1lc3NhZ2VDaGFubmVsLGY9ITE7aWYobClmPWZ1bmN0aW9uKGUpe2goZSx7dHJhbnNmZXI6W2VdfSl9O2Vsc2UgaWYodSl0cnl7ZHx8KGE9Yygid29ya2VyX3RocmVhZHMiKSkmJihkPWEuTWVzc2FnZUNoYW5uZWwpO2lmKGQpe249bmV3IGQ7aT1uZXcgdSgyKTtzPWZ1bmN0aW9uKGUpe24ucG9ydDEucG9zdE1lc3NhZ2UobnVsbCxbZV0pfTtpZigyPT09aS5ieXRlTGVuZ3RoKXtzKGkpOzA9PT1pLmJ5dGVMZW5ndGgmJihmPXMpfX19Y2F0Y2goZSl7fWUuZXhwb3J0cz1mfSw0NDk1OihlLHQscik9Pnt2YXIgYT1yKDk1MTkpLG49cig5MDM5KSxpPXIoNDU3NikuU3RyaW5nO2UuZXhwb3J0cz0hIU9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHMmJiFuKGZ1bmN0aW9uKCl7dmFyIGU9U3ltYm9sKCJzeW1ib2wgZGV0ZWN0aW9uIik7cmV0dXJuIWkoZSl8fCEoT2JqZWN0KGUpaW5zdGFuY2VvZiBTeW1ib2wpfHwhU3ltYm9sLnNoYW0mJmEmJmE8NDF9KX0sNDUyNzooZSx0LHIpPT57dmFyIGE9cigzNzI0KSxuPXIoNDM3NiksaT1UeXBlRXJyb3Iscz1PYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yLG89YSYmIWZ1bmN0aW9uKCl7aWYodm9pZCAwIT09dGhpcylyZXR1cm4hMDt0cnl7T2JqZWN0LmRlZmluZVByb3BlcnR5KFtdLCJsZW5ndGgiLHt3cml0YWJsZTohMX0pLmxlbmd0aD0xfWNhdGNoKGUpe3JldHVybiBlIGluc3RhbmNlb2YgVHlwZUVycm9yfX0oKTtlLmV4cG9ydHM9bz9mdW5jdGlvbihlLHQpe2lmKG4oZSkmJiFzKGUsImxlbmd0aCIpLndyaXRhYmxlKXRocm93IG5ldyBpKCJDYW5ub3Qgc2V0IHJlYWQgb25seSAubGVuZ3RoIik7cmV0dXJuIGUubGVuZ3RoPXR9OmZ1bmN0aW9uKGUsdCl7cmV0dXJuIGUubGVuZ3RoPXR9fSw0NTQ5OihlLHQscik9Pnt2YXIgYT1yKDQ1NzYpO2UuZXhwb3J0cz1mdW5jdGlvbihlLHQpe3ZhciByPWEuSXRlcmF0b3Isbj1yJiZyLnByb3RvdHlwZSxpPW4mJm5bZV0scz0hMTtpZihpKXRyeXtpLmNhbGwoe25leHQ6ZnVuY3Rpb24oKXtyZXR1cm57ZG9uZTohMH19LHJldHVybjpmdW5jdGlvbigpe3M9ITB9fSwtMSl9Y2F0Y2goZSl7ZSBpbnN0YW5jZW9mIHR8fChzPSExKX1pZighcylyZXR1cm4gaX19LDQ1NzY6ZnVuY3Rpb24oZSl7dmFyIGNoZWNrPWZ1bmN0aW9uKGUpe3JldHVybiBlJiZlLk1hdGg9PT1NYXRoJiZlfTtlLmV4cG9ydHM9Y2hlY2soIm9iamVjdCI9PXR5cGVvZiBnbG9iYWxUaGlzJiZnbG9iYWxUaGlzKXx8Y2hlY2soIm9iamVjdCI9PXR5cGVvZiB3aW5kb3cmJndpbmRvdyl8fGNoZWNrKCJvYmplY3QiPT10eXBlb2Ygc2VsZiYmc2VsZil8fGNoZWNrKCJvYmplY3QiPT10eXBlb2YgZ2xvYmFsJiZnbG9iYWwpfHxjaGVjaygib2JqZWN0Ij09dHlwZW9mIHRoaXMmJnRoaXMpfHxmdW5jdGlvbigpe3JldHVybiB0aGlzfSgpfHxGdW5jdGlvbigicmV0dXJuIHRoaXMiKSgpfSw0NjAzOihlLHQscik9Pnt2YXIgYT1yKDY4NDApLG49cig5NTA0KSxpPXIoNjU1KSxzPXIoMjgxMiksbz1VUkxTZWFyY2hQYXJhbXMsYz1vLnByb3RvdHlwZSxsPW4oYy5hcHBlbmQpLGg9bihjLmRlbGV0ZSksdT1uKGMuZm9yRWFjaCksZD1uKFtdLnB1c2gpLGY9bmV3IG8oImE9MSZhPTImYj0zIik7Zi5kZWxldGUoImEiLDEpO2YuZGVsZXRlKCJiIix2b2lkIDApO2YrIiIhPSJhPTIiJiZhKGMsImRlbGV0ZSIsZnVuY3Rpb24oZSl7dmFyIHQ9YXJndW1lbnRzLmxlbmd0aCxyPXQ8Mj92b2lkIDA6YXJndW1lbnRzWzFdO2lmKHQmJnZvaWQgMD09PXIpcmV0dXJuIGgodGhpcyxlKTt2YXIgYT1bXTt1KHRoaXMsZnVuY3Rpb24oZSx0KXtkKGEse2tleTp0LHZhbHVlOmV9KX0pO3ModCwxKTtmb3IodmFyIG4sbz1pKGUpLGM9aShyKSxmPTAsZz0wLHA9ITEsbT1hLmxlbmd0aDtmPG07KXtuPWFbZisrXTtpZihwfHxuLmtleT09PW8pe3A9ITA7aCh0aGlzLG4ua2V5KX1lbHNlIGcrK31mb3IoO2c8bTspKG49YVtnKytdKS5rZXk9PT1vJiZuLnZhbHVlPT09Y3x8bCh0aGlzLG4ua2V5LG4udmFsdWUpfSx7ZW51bWVyYWJsZTohMCx1bnNhZmU6ITB9KX0sNDYyODooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoNjA0Myk7YSh7dGFyZ2V0OiJQcm9taXNlIixzdGF0OiEwfSx7d2l0aFJlc29sdmVyczpmdW5jdGlvbiB3aXRoUmVzb2x2ZXJzKCl7dmFyIGU9bi5mKHRoaXMpO3JldHVybntwcm9taXNlOmUucHJvbWlzZSxyZXNvbHZlOmUucmVzb2x2ZSxyZWplY3Q6ZS5yZWplY3R9fX0pfSw0NjQ0OihlLHQscik9Pnt2YXIgYSxuLGkscz1yKDc4MTEpLG89cigzNzI0KSxjPXIoNDU3NiksbD1yKDQ5MDEpLGg9cigzNCksdT1yKDkyOTcpLGQ9cig2OTU1KSxmPXIoNjgyMyksZz1yKDY2OTkpLHA9cig2ODQwKSxtPXIoMjEwNiksYj1yKDE2MjUpLHk9cigyNzg3KSx3PXIoMjk2NykseD1yKDgyMjcpLFM9cigzMzkyKSxrPXIoMTE4MSksQz1rLmVuZm9yY2Usdj1rLmdldCxUPWMuSW50OEFycmF5LE89VCYmVC5wcm90b3R5cGUsTT1jLlVpbnQ4Q2xhbXBlZEFycmF5LEQ9TSYmTS5wcm90b3R5cGUsUj1UJiZ5KFQpLEU9TyYmeShPKSxOPU9iamVjdC5wcm90b3R5cGUsXz1jLlR5cGVFcnJvcixMPXgoInRvU3RyaW5nVGFnIiksaj1TKCJUWVBFRF9BUlJBWV9UQUciKSxVPSJUeXBlZEFycmF5Q29uc3RydWN0b3IiLHE9cyYmISF3JiYiT3BlcmEiIT09ZChjLm9wZXJhKSxYPSExLEg9e0ludDhBcnJheToxLFVpbnQ4QXJyYXk6MSxVaW50OENsYW1wZWRBcnJheToxLEludDE2QXJyYXk6MixVaW50MTZBcnJheToyLEludDMyQXJyYXk6NCxVaW50MzJBcnJheTo0LEZsb2F0MzJBcnJheTo0LEZsb2F0NjRBcnJheTo4fSxXPXtCaWdJbnQ2NEFycmF5OjgsQmlnVWludDY0QXJyYXk6OH0sZ2V0VHlwZWRBcnJheUNvbnN0cnVjdG9yPWZ1bmN0aW9uKGUpe3ZhciB0PXkoZSk7aWYoaCh0KSl7dmFyIHI9dih0KTtyZXR1cm4gciYmdShyLFUpP3JbVV06Z2V0VHlwZWRBcnJheUNvbnN0cnVjdG9yKHQpfX0saXNUeXBlZEFycmF5PWZ1bmN0aW9uKGUpe2lmKCFoKGUpKXJldHVybiExO3ZhciB0PWQoZSk7cmV0dXJuIHUoSCx0KXx8dShXLHQpfTtmb3IoYSBpbiBIKShpPShuPWNbYV0pJiZuLnByb3RvdHlwZSk/QyhpKVtVXT1uOnE9ITE7Zm9yKGEgaW4gVykoaT0obj1jW2FdKSYmbi5wcm90b3R5cGUpJiYoQyhpKVtVXT1uKTtpZighcXx8IWwoUil8fFI9PT1GdW5jdGlvbi5wcm90b3R5cGUpe1I9ZnVuY3Rpb24gVHlwZWRBcnJheSgpe3Rocm93IG5ldyBfKCJJbmNvcnJlY3QgaW52b2NhdGlvbiIpfTtpZihxKWZvcihhIGluIEgpY1thXSYmdyhjW2FdLFIpfWlmKCFxfHwhRXx8RT09PU4pe0U9Ui5wcm90b3R5cGU7aWYocSlmb3IoYSBpbiBIKWNbYV0mJncoY1thXS5wcm90b3R5cGUsRSl9cSYmeShEKSE9PUUmJncoRCxFKTtpZihvJiYhdShFLEwpKXtYPSEwO20oRSxMLHtjb25maWd1cmFibGU6ITAsZ2V0OmZ1bmN0aW9uKCl7cmV0dXJuIGgodGhpcyk/dGhpc1tqXTp2b2lkIDB9fSk7Zm9yKGEgaW4gSCljW2FdJiZnKGNbYV0saixhKX1lLmV4cG9ydHM9e05BVElWRV9BUlJBWV9CVUZGRVJfVklFV1M6cSxUWVBFRF9BUlJBWV9UQUc6WCYmaixhVHlwZWRBcnJheTpmdW5jdGlvbihlKXtpZihpc1R5cGVkQXJyYXkoZSkpcmV0dXJuIGU7dGhyb3cgbmV3IF8oIlRhcmdldCBpcyBub3QgYSB0eXBlZCBhcnJheSIpfSxhVHlwZWRBcnJheUNvbnN0cnVjdG9yOmZ1bmN0aW9uKGUpe2lmKGwoZSkmJighd3x8YihSLGUpKSlyZXR1cm4gZTt0aHJvdyBuZXcgXyhmKGUpKyIgaXMgbm90IGEgdHlwZWQgYXJyYXkgY29uc3RydWN0b3IiKX0sZXhwb3J0VHlwZWRBcnJheU1ldGhvZDpmdW5jdGlvbihlLHQscixhKXtpZihvKXtpZihyKWZvcih2YXIgbiBpbiBIKXt2YXIgaT1jW25dO2lmKGkmJnUoaS5wcm90b3R5cGUsZSkpdHJ5e2RlbGV0ZSBpLnByb3RvdHlwZVtlXX1jYXRjaChyKXt0cnl7aS5wcm90b3R5cGVbZV09dH1jYXRjaChlKXt9fX1FW2VdJiYhcnx8cChFLGUscj90OnEmJk9bZV18fHQsYSl9fSxleHBvcnRUeXBlZEFycmF5U3RhdGljTWV0aG9kOmZ1bmN0aW9uKGUsdCxyKXt2YXIgYSxuO2lmKG8pe2lmKHcpe2lmKHIpZm9yKGEgaW4gSClpZigobj1jW2FdKSYmdShuLGUpKXRyeXtkZWxldGUgbltlXX1jYXRjaChlKXt9aWYoUltlXSYmIXIpcmV0dXJuO3RyeXtyZXR1cm4gcChSLGUscj90OnEmJlJbZV18fHQpfWNhdGNoKGUpe319Zm9yKGEgaW4gSCkhKG49Y1thXSl8fG5bZV0mJiFyfHxwKG4sZSx0KX19LGdldFR5cGVkQXJyYXlDb25zdHJ1Y3Rvcixpc1ZpZXc6ZnVuY3Rpb24gaXNWaWV3KGUpe2lmKCFoKGUpKXJldHVybiExO3ZhciB0PWQoZSk7cmV0dXJuIkRhdGFWaWV3Ij09PXR8fHUoSCx0KXx8dShXLHQpfSxpc1R5cGVkQXJyYXksVHlwZWRBcnJheTpSLFR5cGVkQXJyYXlQcm90b3R5cGU6RX19LDQ2NTk6KGUsdCxyKT0+e3ZhciBhPXIoMzcyNCksbj1yKDQ5MTMpLGk9cig2OTgwKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0LHIpe2E/bi5mKGUsdCxpKDAscikpOmVbdF09cn19LDQ5MDE6ZT0+e3ZhciB0PSJvYmplY3QiPT10eXBlb2YgZG9jdW1lbnQmJmRvY3VtZW50LmFsbDtlLmV4cG9ydHM9dm9pZCAwPT09dCYmdm9pZCAwIT09dD9mdW5jdGlvbihlKXtyZXR1cm4iZnVuY3Rpb24iPT10eXBlb2YgZXx8ZT09PXR9OmZ1bmN0aW9uKGUpe3JldHVybiJmdW5jdGlvbiI9PXR5cGVvZiBlfX0sNDkxMzooZSx0LHIpPT57dmFyIGE9cigzNzI0KSxuPXIoNTkxNyksaT1yKDg2ODYpLHM9cig4NTUxKSxvPXIoNjk2OSksYz1UeXBlRXJyb3IsbD1PYmplY3QuZGVmaW5lUHJvcGVydHksaD1PYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yLHU9ImVudW1lcmFibGUiLGQ9ImNvbmZpZ3VyYWJsZSIsZj0id3JpdGFibGUiO3QuZj1hP2k/ZnVuY3Rpb24gZGVmaW5lUHJvcGVydHkoZSx0LHIpe3MoZSk7dD1vKHQpO3Mocik7aWYoImZ1bmN0aW9uIj09dHlwZW9mIGUmJiJwcm90b3R5cGUiPT09dCYmInZhbHVlImluIHImJmYgaW4gciYmIXJbZl0pe3ZhciBhPWgoZSx0KTtpZihhJiZhW2ZdKXtlW3RdPXIudmFsdWU7cj17Y29uZmlndXJhYmxlOmQgaW4gcj9yW2RdOmFbZF0sZW51bWVyYWJsZTp1IGluIHI/clt1XTphW3VdLHdyaXRhYmxlOiExfX19cmV0dXJuIGwoZSx0LHIpfTpsOmZ1bmN0aW9uIGRlZmluZVByb3BlcnR5KGUsdCxyKXtzKGUpO3Q9byh0KTtzKHIpO2lmKG4pdHJ5e3JldHVybiBsKGUsdCxyKX1jYXRjaChlKXt9aWYoImdldCJpbiByfHwic2V0ImluIHIpdGhyb3cgbmV3IGMoIkFjY2Vzc29ycyBub3Qgc3VwcG9ydGVkIik7InZhbHVlImluIHImJihlW3RdPXIudmFsdWUpO3JldHVybiBlfX0sNDkxNjooZSx0LHIpPT57dmFyIGE9cig3NzUxKSxjcmVhdGVTZXRMaWtlPWZ1bmN0aW9uKGUpe3JldHVybntzaXplOmUsaGFzOmZ1bmN0aW9uKCl7cmV0dXJuITF9LGtleXM6ZnVuY3Rpb24oKXtyZXR1cm57bmV4dDpmdW5jdGlvbigpe3JldHVybntkb25lOiEwfX19fX19LGNyZWF0ZVNldExpa2VXaXRoSW5maW5pdHlTaXplPWZ1bmN0aW9uKGUpe3JldHVybntzaXplOmUsaGFzOmZ1bmN0aW9uKCl7cmV0dXJuITB9LGtleXM6ZnVuY3Rpb24oKXt0aHJvdyBuZXcgRXJyb3IoImUiKX19fTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXt2YXIgcj1hKCJTZXQiKTt0cnl7KG5ldyByKVtlXShjcmVhdGVTZXRMaWtlKDApKTt0cnl7KG5ldyByKVtlXShjcmVhdGVTZXRMaWtlKC0xKSk7cmV0dXJuITF9Y2F0Y2goYSl7aWYoIXQpcmV0dXJuITA7dHJ5eyhuZXcgcilbZV0oY3JlYXRlU2V0TGlrZVdpdGhJbmZpbml0eVNpemUoLTEvMCkpO3JldHVybiExfWNhdGNoKGEpe3ZhciBuPW5ldyByO24uYWRkKDEpO24uYWRkKDIpO3JldHVybiB0KG5bZV0oY3JlYXRlU2V0TGlrZVdpdGhJbmZpbml0eVNpemUoMS8wKSkpfX19Y2F0Y2goZSl7cmV0dXJuITF9fX0sNDk3OTooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoNDU3NiksaT1yKDc3NTEpLHM9cig2OTgwKSxvPXIoNDkxMykuZixjPXIoOTI5NyksbD1yKDY3OSksaD1yKDMxNjcpLHU9cigyNjAzKSxkPXIoNTAwMiksZj1yKDg1NzQpLGc9cigzNzI0KSxwPXIoNjM5NSksbT0iRE9NRXhjZXB0aW9uIixiPWkoIkVycm9yIikseT1pKG0pLHc9ZnVuY3Rpb24gRE9NRXhjZXB0aW9uKCl7bCh0aGlzLHgpO3ZhciBlPWFyZ3VtZW50cy5sZW5ndGgsdD11KGU8MT92b2lkIDA6YXJndW1lbnRzWzBdKSxyPXUoZTwyP3ZvaWQgMDphcmd1bWVudHNbMV0sIkVycm9yIiksYT1uZXcgeSh0LHIpLG49bmV3IGIodCk7bi5uYW1lPW07byhhLCJzdGFjayIscygxLGYobi5zdGFjaywxKSkpO2goYSx0aGlzLHcpO3JldHVybiBhfSx4PXcucHJvdG90eXBlPXkucHJvdG90eXBlLFM9InN0YWNrImluIG5ldyBiKG0pLGs9InN0YWNrImluIG5ldyB5KDEsMiksQz15JiZnJiZPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKG4sbSksdj0hKCFDfHxDLndyaXRhYmxlJiZDLmNvbmZpZ3VyYWJsZSksVD1TJiYhdiYmIWs7YSh7Z2xvYmFsOiEwLGNvbnN0cnVjdG9yOiEwLGZvcmNlZDpwfHxUfSx7RE9NRXhjZXB0aW9uOlQ/dzp5fSk7dmFyIE89aShtKSxNPU8ucHJvdG90eXBlO2lmKE0uY29uc3RydWN0b3IhPT1PKXtwfHxvKE0sImNvbnN0cnVjdG9yIixzKDEsTykpO2Zvcih2YXIgRCBpbiBkKWlmKGMoZCxEKSl7dmFyIFI9ZFtEXSxFPVIucztjKE8sRSl8fG8oTyxFLHMoNixSLmMpKX19fSw1MDAyOmU9PntlLmV4cG9ydHM9e0luZGV4U2l6ZUVycm9yOntzOiJJTkRFWF9TSVpFX0VSUiIsYzoxLG06MX0sRE9NU3RyaW5nU2l6ZUVycm9yOntzOiJET01TVFJJTkdfU0laRV9FUlIiLGM6MixtOjB9LEhpZXJhcmNoeVJlcXVlc3RFcnJvcjp7czoiSElFUkFSQ0hZX1JFUVVFU1RfRVJSIixjOjMsbToxfSxXcm9uZ0RvY3VtZW50RXJyb3I6e3M6IldST05HX0RPQ1VNRU5UX0VSUiIsYzo0LG06MX0sSW52YWxpZENoYXJhY3RlckVycm9yOntzOiJJTlZBTElEX0NIQVJBQ1RFUl9FUlIiLGM6NSxtOjF9LE5vRGF0YUFsbG93ZWRFcnJvcjp7czoiTk9fREFUQV9BTExPV0VEX0VSUiIsYzo2LG06MH0sTm9Nb2RpZmljYXRpb25BbGxvd2VkRXJyb3I6e3M6Ik5PX01PRElGSUNBVElPTl9BTExPV0VEX0VSUiIsYzo3LG06MX0sTm90Rm91bmRFcnJvcjp7czoiTk9UX0ZPVU5EX0VSUiIsYzo4LG06MX0sTm90U3VwcG9ydGVkRXJyb3I6e3M6Ik5PVF9TVVBQT1JURURfRVJSIixjOjksbToxfSxJblVzZUF0dHJpYnV0ZUVycm9yOntzOiJJTlVTRV9BVFRSSUJVVEVfRVJSIixjOjEwLG06MX0sSW52YWxpZFN0YXRlRXJyb3I6e3M6IklOVkFMSURfU1RBVEVfRVJSIixjOjExLG06MX0sU3ludGF4RXJyb3I6e3M6IlNZTlRBWF9FUlIiLGM6MTIsbToxfSxJbnZhbGlkTW9kaWZpY2F0aW9uRXJyb3I6e3M6IklOVkFMSURfTU9ESUZJQ0FUSU9OX0VSUiIsYzoxMyxtOjF9LE5hbWVzcGFjZUVycm9yOntzOiJOQU1FU1BBQ0VfRVJSIixjOjE0LG06MX0sSW52YWxpZEFjY2Vzc0Vycm9yOntzOiJJTlZBTElEX0FDQ0VTU19FUlIiLGM6MTUsbToxfSxWYWxpZGF0aW9uRXJyb3I6e3M6IlZBTElEQVRJT05fRVJSIixjOjE2LG06MH0sVHlwZU1pc21hdGNoRXJyb3I6e3M6IlRZUEVfTUlTTUFUQ0hfRVJSIixjOjE3LG06MX0sU2VjdXJpdHlFcnJvcjp7czoiU0VDVVJJVFlfRVJSIixjOjE4LG06MX0sTmV0d29ya0Vycm9yOntzOiJORVRXT1JLX0VSUiIsYzoxOSxtOjF9LEFib3J0RXJyb3I6e3M6IkFCT1JUX0VSUiIsYzoyMCxtOjF9LFVSTE1pc21hdGNoRXJyb3I6e3M6IlVSTF9NSVNNQVRDSF9FUlIiLGM6MjEsbToxfSxRdW90YUV4Y2VlZGVkRXJyb3I6e3M6IlFVT1RBX0VYQ0VFREVEX0VSUiIsYzoyMixtOjF9LFRpbWVvdXRFcnJvcjp7czoiVElNRU9VVF9FUlIiLGM6MjMsbToxfSxJbnZhbGlkTm9kZVR5cGVFcnJvcjp7czoiSU5WQUxJRF9OT0RFX1RZUEVfRVJSIixjOjI0LG06MX0sRGF0YUNsb25lRXJyb3I6e3M6IkRBVEFfQ0xPTkVfRVJSIixjOjI1LG06MX19fSw1MDI0OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cigzNjUwKSxpPXIoOTgzNSk7YSh7dGFyZ2V0OiJTZXQiLHByb3RvOiEwLHJlYWw6ITAsZm9yY2VkOiFyKDQ5MTYpKCJzeW1tZXRyaWNEaWZmZXJlbmNlIil8fCFpKCJzeW1tZXRyaWNEaWZmZXJlbmNlIil9LHtzeW1tZXRyaWNEaWZmZXJlbmNlOm59KX0sNTAzMTooZSx0LHIpPT57dmFyIGE9cig3NzUxKSxuPXIoOTUwNCksaT1yKDg0ODApLHM9cigzNzE3KSxvPXIoODU1MSksYz1uKFtdLmNvbmNhdCk7ZS5leHBvcnRzPWEoIlJlZmxlY3QiLCJvd25LZXlzIil8fGZ1bmN0aW9uIG93bktleXMoZSl7dmFyIHQ9aS5mKG8oZSkpLHI9cy5mO3JldHVybiByP2ModCxyKGUpKTp0fX0sNTE2OTooZSx0LHIpPT57dmFyIGE9cigzMjM4KSxuPVR5cGVFcnJvcjtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7aWYoYShlKSl0aHJvdyBuZXcgbigiQXJyYXlCdWZmZXIgaXMgZGV0YWNoZWQiKTtyZXR1cm4gZX19LDUxNzA6KGUsdCxyKT0+e3ZhciBhPXIoNjcwNiksbj1yKDQ0MDIpO2UuZXhwb3J0cz1hKG4ucHJvdG8sInNpemUiLCJnZXQiKXx8ZnVuY3Rpb24oZSl7cmV0dXJuIGUuc2l6ZX19LDUyMTM6KGUsdCxyKT0+e3ZhciBhPXIoNjUxOCksbj1yKDQ1NzYpLGk9cig1MzcwKSxzPXIoOTE0Myksbz1uLlVpbnQ4QXJyYXksYz0hb3x8IW8uZnJvbUJhc2U2NHx8IWZ1bmN0aW9uKCl7dHJ5e28uZnJvbUJhc2U2NCgiYSIpO3JldHVybn1jYXRjaChlKXt9dHJ5e28uZnJvbUJhc2U2NCgiIixudWxsKX1jYXRjaChlKXtyZXR1cm4hMH19KCk7byYmYSh7dGFyZ2V0OiJVaW50OEFycmF5IixzdGF0OiEwLGZvcmNlZDpjfSx7ZnJvbUJhc2U2NDpmdW5jdGlvbiBmcm9tQmFzZTY0KGUpe3ZhciB0PXMoZSxhcmd1bWVudHMubGVuZ3RoPjE/YXJndW1lbnRzWzFdOnZvaWQgMCxudWxsLDkwMDcxOTkyNTQ3NDA5OTEpO3JldHVybiBpKG8sdC5ieXRlcyl9fSl9LDUzNzA6KGUsdCxyKT0+e3ZhciBhPXIoNjE5OCk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCxyKXtmb3IodmFyIG49MCxpPWFyZ3VtZW50cy5sZW5ndGg+Mj9yOmEodCkscz1uZXcgZShpKTtpPm47KXNbbl09dFtuKytdO3JldHVybiBzfX0sNTM5NzooZSx0LHIpPT57dmFyIGE9cig3MDU1KSxuPXIoNzc1MCk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3JldHVybiBhKG4oZSkpfX0sNTYxMDooZSx0LHIpPT57dmFyIGE9cigxMjkxKSxuPU1hdGgubWF4LGk9TWF0aC5taW47ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7dmFyIHI9YShlKTtyZXR1cm4gcjwwP24ocit0LDApOmkocix0KX19LDU2MjM6KGUsdCxyKT0+e3IoNDU2KX0sNTYzNjooZSx0LHIpPT57dmFyIGE9cig0NTc2KSxuPXIoOTUwNCksaT1yKDY3MDYpLHM9cig3Njk2KSxvPXIoNTE2OSksYz1yKDczOTQpLGw9cig0NDgzKSxoPXIoMTU0OCksdT1hLnN0cnVjdHVyZWRDbG9uZSxkPWEuQXJyYXlCdWZmZXIsZj1hLkRhdGFWaWV3LGc9TWF0aC5taW4scD1kLnByb3RvdHlwZSxtPWYucHJvdG90eXBlLGI9bihwLnNsaWNlKSx5PWkocCwicmVzaXphYmxlIiwiZ2V0Iiksdz1pKHAsIm1heEJ5dGVMZW5ndGgiLCJnZXQiKSx4PW4obS5nZXRJbnQ4KSxTPW4obS5zZXRJbnQ4KTtlLmV4cG9ydHM9KGh8fGwpJiZmdW5jdGlvbihlLHQscil7dmFyIGEsbj1jKGUpLGk9dm9pZCAwPT09dD9uOnModCkscD0heXx8IXkoZSk7byhlKTtpZihoKXtlPXUoZSx7dHJhbnNmZXI6W2VdfSk7aWYobj09PWkmJihyfHxwKSlyZXR1cm4gZX1pZihuPj1pJiYoIXJ8fHApKWE9YihlLDAsaSk7ZWxzZXt2YXIgbT1yJiYhcCYmdz97bWF4Qnl0ZUxlbmd0aDp3KGUpfTp2b2lkIDA7YT1uZXcgZChpLG0pO2Zvcih2YXIgaz1uZXcgZihlKSxDPW5ldyBmKGEpLHY9ZyhpLG4pLFQ9MDtUPHY7VCsrKVMoQyxULHgoayxUKSl9aHx8bChlKTtyZXR1cm4gYX19LDU3NDU6KGUsdCxyKT0+e3ZhciBhPXIoNzYyOSk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIGFbZV18fChhW2VdPXR8fHt9KX19LDU3ODE6KGUsdCxyKT0+e3ZhciBhPXIoNjUxOCksbj1yKDc3NTEpLGk9cigyODEyKSxzPXIoNjU1KSxvPXIoNzQxNiksYz1uKCJVUkwiKTthKHt0YXJnZXQ6IlVSTCIsc3RhdDohMCxmb3JjZWQ6IW99LHtwYXJzZTpmdW5jdGlvbiBwYXJzZShlKXt2YXIgdD1pKGFyZ3VtZW50cy5sZW5ndGgsMSkscj1zKGUpLGE9dDwyfHx2b2lkIDA9PT1hcmd1bWVudHNbMV0/dm9pZCAwOnMoYXJndW1lbnRzWzFdKTt0cnl7cmV0dXJuIG5ldyBjKHIsYSl9Y2F0Y2goZSl7cmV0dXJuIG51bGx9fX0pfSw1ODU0OihlLHQscik9Pnt2YXIgYT1yKDI3NzcpLG49VHlwZUVycm9yO2UuZXhwb3J0cz1mdW5jdGlvbihlKXt2YXIgdD1hKGUsIm51bWJlciIpO2lmKCJudW1iZXIiPT10eXBlb2YgdCl0aHJvdyBuZXcgbigiQ2FuJ3QgY29udmVydCBudW1iZXIgdG8gYmlnaW50Iik7cmV0dXJuIEJpZ0ludCh0KX19LDU4NzY6KGUsdCxyKT0+e3ZhciBhPXIoNjUxOCksbj1yKDM4MzgpO2Eoe3RhcmdldDoiU2V0Iixwcm90bzohMCxyZWFsOiEwLGZvcmNlZDohcig0OTE2KSgiaXNTdWJzZXRPZiIsZnVuY3Rpb24oZSl7cmV0dXJuIGV9KX0se2lzU3Vic2V0T2Y6bn0pfSw1OTE3OihlLHQscik9Pnt2YXIgYT1yKDM3MjQpLG49cig5MDM5KSxpPXIoNDA1NSk7ZS5leHBvcnRzPSFhJiYhbihmdW5jdGlvbigpe3JldHVybiA3IT09T2JqZWN0LmRlZmluZVByb3BlcnR5KGkoImRpdiIpLCJhIix7Z2V0OmZ1bmN0aW9uKCl7cmV0dXJuIDd9fSkuYX0pfSw1OTY2OihlLHQscik9Pnt2YXIgYT1yKDkzMDYpLG49cig0MTE3KTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXt2YXIgcj1lW3RdO3JldHVybiBuKHIpP3ZvaWQgMDphKHIpfX0sNjA0MzooZSx0LHIpPT57dmFyIGE9cig5MzA2KSxuPVR5cGVFcnJvcixQcm9taXNlQ2FwYWJpbGl0eT1mdW5jdGlvbihlKXt2YXIgdCxyO3RoaXMucHJvbWlzZT1uZXcgZShmdW5jdGlvbihlLGEpe2lmKHZvaWQgMCE9PXR8fHZvaWQgMCE9PXIpdGhyb3cgbmV3IG4oIkJhZCBQcm9taXNlIGNvbnN0cnVjdG9yIik7dD1lO3I9YX0pO3RoaXMucmVzb2x2ZT1hKHQpO3RoaXMucmVqZWN0PWEocil9O2UuZXhwb3J0cy5mPWZ1bmN0aW9uKGUpe3JldHVybiBuZXcgUHJvbWlzZUNhcGFiaWxpdHkoZSl9fSw2MDgwOihlLHQscik9Pnt2YXIgYT1yKDc0NzYpLG49cig5MzA2KSxpPXIoNjE2KSxzPWEoYS5iaW5kKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXtuKGUpO3JldHVybiB2b2lkIDA9PT10P2U6aT9zKGUsdCk6ZnVuY3Rpb24oKXtyZXR1cm4gZS5hcHBseSh0LGFyZ3VtZW50cyl9fX0sNjExOTooZSx0LHIpPT57dmFyIGE9cig1NzQ1KSxuPXIoMzM5MiksaT1hKCJrZXlzIik7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3JldHVybiBpW2VdfHwoaVtlXT1uKGUpKX19LDYxOTM6KGUsdCxyKT0+e3ZhciBhPXIoNDIxNSk7ZS5leHBvcnRzPSJOT0RFIj09PWF9LDYxOTg6KGUsdCxyKT0+e3ZhciBhPXIoODAxNCk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3JldHVybiBhKGUubGVuZ3RoKX19LDYyNjk6ZT0+e2UuZXhwb3J0cz17fX0sNjI3OTooZSx0LHIpPT57dmFyIGE9cig2ODQwKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0LHIpe2Zvcih2YXIgbiBpbiB0KWEoZSxuLHRbbl0scik7cmV0dXJuIGV9fSw2MzE5OihlLHQscik9Pnt2YXIgYT1yKDg1NTEpLG49cig5NTM5KTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0LHIsaSl7dHJ5e3JldHVybiBpP3QoYShyKVswXSxyWzFdKTp0KHIpfWNhdGNoKHQpe24oZSwidGhyb3ciLHQpfX19LDYzOTU6ZT0+e2UuZXhwb3J0cz0hMX0sNjUxODooZSx0LHIpPT57dmFyIGE9cig0NTc2KSxuPXIoNzM0NykuZixpPXIoNjY5OSkscz1yKDY4NDApLG89cig5NDMzKSxjPXIoNzc0MCksbD1yKDI3OTYpO2UuZXhwb3J0cz1mdW5jdGlvbihlLHQpe3ZhciByLGgsdSxkLGYsZz1lLnRhcmdldCxwPWUuZ2xvYmFsLG09ZS5zdGF0O2lmKHI9cD9hOm0/YVtnXXx8byhnLHt9KTphW2ddJiZhW2ddLnByb3RvdHlwZSlmb3IoaCBpbiB0KXtkPXRbaF07dT1lLmRvbnRDYWxsR2V0U2V0PyhmPW4ocixoKSkmJmYudmFsdWU6cltoXTtpZighbChwP2g6ZysobT8iLiI6IiMiKStoLGUuZm9yY2VkKSYmdm9pZCAwIT09dSl7aWYodHlwZW9mIGQ9PXR5cGVvZiB1KWNvbnRpbnVlO2MoZCx1KX0oZS5zaGFtfHx1JiZ1LnNoYW0pJiZpKGQsInNoYW0iLCEwKTtzKHIsaCxkLGUpfX19LDY1NzM6KGUsdCxyKT0+e3ZhciBhPXIoMzcyNCksbj1yKDIxMDYpLGk9cigzMjM4KSxzPUFycmF5QnVmZmVyLnByb3RvdHlwZTthJiYhKCJkZXRhY2hlZCJpbiBzKSYmbihzLCJkZXRhY2hlZCIse2NvbmZpZ3VyYWJsZTohMCxnZXQ6ZnVuY3Rpb24gZGV0YWNoZWQoKXtyZXR1cm4gaSh0aGlzKX19KX0sNjYzMjooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoNDU3NiksaT1yKDkxNDMpLHM9cig0MTU0KSxvPW4uVWludDhBcnJheSxjPSFvfHwhby5wcm90b3R5cGUuc2V0RnJvbUJhc2U2NHx8IWZ1bmN0aW9uKCl7dmFyIGU9bmV3IG8oWzI1NSwyNTUsMjU1LDI1NSwyNTVdKTt0cnl7ZS5zZXRGcm9tQmFzZTY0KCIiLG51bGwpO3JldHVybn1jYXRjaChlKXt9dHJ5e2Uuc2V0RnJvbUJhc2U2NCgiYSIpO3JldHVybn1jYXRjaChlKXt9dHJ5e2Uuc2V0RnJvbUJhc2U2NCgiTWpZeVpnPT09Iil9Y2F0Y2godCl7cmV0dXJuIDUwPT09ZVswXSYmNTQ9PT1lWzFdJiY1MD09PWVbMl0mJjI1NT09PWVbM10mJjI1NT09PWVbNF19fSgpO28mJmEoe3RhcmdldDoiVWludDhBcnJheSIscHJvdG86ITAsZm9yY2VkOmN9LHtzZXRGcm9tQmFzZTY0OmZ1bmN0aW9uIHNldEZyb21CYXNlNjQoZSl7cyh0aGlzKTt2YXIgdD1pKGUsYXJndW1lbnRzLmxlbmd0aD4xP2FyZ3VtZW50c1sxXTp2b2lkIDAsdGhpcyx0aGlzLmxlbmd0aCk7cmV0dXJue3JlYWQ6dC5yZWFkLHdyaXR0ZW46dC53cml0dGVufX19KX0sNjY5OTooZSx0LHIpPT57dmFyIGE9cigzNzI0KSxuPXIoNDkxMyksaT1yKDY5ODApO2UuZXhwb3J0cz1hP2Z1bmN0aW9uKGUsdCxyKXtyZXR1cm4gbi5mKGUsdCxpKDEscikpfTpmdW5jdGlvbihlLHQscil7ZVt0XT1yO3JldHVybiBlfX0sNjcwNjooZSx0LHIpPT57dmFyIGE9cig5NTA0KSxuPXIoOTMwNik7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCxyKXt0cnl7cmV0dXJuIGEobihPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKGUsdClbcl0pKX1jYXRjaChlKXt9fX0sNjgwMTooZSx0LHIpPT57dmFyIGE9cigzNzI0KSxuPXIoODY4NiksaT1yKDQ5MTMpLHM9cig4NTUxKSxvPXIoNTM5NyksYz1yKDEwNzIpO3QuZj1hJiYhbj9PYmplY3QuZGVmaW5lUHJvcGVydGllczpmdW5jdGlvbiBkZWZpbmVQcm9wZXJ0aWVzKGUsdCl7cyhlKTtmb3IodmFyIHIsYT1vKHQpLG49Yyh0KSxsPW4ubGVuZ3RoLGg9MDtsPmg7KWkuZihlLHI9bltoKytdLGFbcl0pO3JldHVybiBlfX0sNjgyMzplPT57dmFyIHQ9U3RyaW5nO2UuZXhwb3J0cz1mdW5jdGlvbihlKXt0cnl7cmV0dXJuIHQoZSl9Y2F0Y2goZSl7cmV0dXJuIk9iamVjdCJ9fX0sNjgzNzplPT57dmFyIHQ9VHlwZUVycm9yO2UuZXhwb3J0cz1mdW5jdGlvbihlKXtpZihlPjkwMDcxOTkyNTQ3NDA5OTEpdGhyb3cgdCgiTWF4aW11bSBhbGxvd2VkIGluZGV4IGV4Y2VlZGVkIik7cmV0dXJuIGV9fSw2ODQwOihlLHQscik9Pnt2YXIgYT1yKDQ5MDEpLG49cig0OTEzKSxpPXIoMjgzKSxzPXIoOTQzMyk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCxyLG8pe298fChvPXt9KTt2YXIgYz1vLmVudW1lcmFibGUsbD12b2lkIDAhPT1vLm5hbWU/by5uYW1lOnQ7YShyKSYmaShyLGwsbyk7aWYoby5nbG9iYWwpYz9lW3RdPXI6cyh0LHIpO2Vsc2V7dHJ5e28udW5zYWZlP2VbdF0mJihjPSEwKTpkZWxldGUgZVt0XX1jYXRjaChlKXt9Yz9lW3RdPXI6bi5mKGUsdCx7dmFsdWU6cixlbnVtZXJhYmxlOiExLGNvbmZpZ3VyYWJsZTohby5ub25Db25maWd1cmFibGUsd3JpdGFibGU6IW8ubm9uV3JpdGFibGV9KX1yZXR1cm4gZX19LDY5NTU6KGUsdCxyKT0+e3ZhciBhPXIoMjE0MCksbj1yKDQ5MDEpLGk9cigyMTk1KSxzPXIoODIyNykoInRvU3RyaW5nVGFnIiksbz1PYmplY3QsYz0iQXJndW1lbnRzIj09PWkoZnVuY3Rpb24oKXtyZXR1cm4gYXJndW1lbnRzfSgpKTtlLmV4cG9ydHM9YT9pOmZ1bmN0aW9uKGUpe3ZhciB0LHIsYTtyZXR1cm4gdm9pZCAwPT09ZT8iVW5kZWZpbmVkIjpudWxsPT09ZT8iTnVsbCI6InN0cmluZyI9PXR5cGVvZihyPWZ1bmN0aW9uKGUsdCl7dHJ5e3JldHVybiBlW3RdfWNhdGNoKGUpe319KHQ9byhlKSxzKSk/cjpjP2kodCk6Ik9iamVjdCI9PT0oYT1pKHQpKSYmbih0LmNhbGxlZSk/IkFyZ3VtZW50cyI6YX19LDY5Njk6KGUsdCxyKT0+e3ZhciBhPXIoMjc3Nyksbj1yKDc1Nyk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3ZhciB0PWEoZSwic3RyaW5nIik7cmV0dXJuIG4odCk/dDp0KyIifX0sNjk4MDplPT57ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7cmV0dXJue2VudW1lcmFibGU6ISgxJmUpLGNvbmZpZ3VyYWJsZTohKDImZSksd3JpdGFibGU6ISg0JmUpLHZhbHVlOnR9fX0sNzA0MDooZSx0LHIpPT57dmFyIGE9cig0NDk1KTtlLmV4cG9ydHM9YSYmIVN5bWJvbC5zaGFtJiYic3ltYm9sIj09dHlwZW9mIFN5bWJvbC5pdGVyYXRvcn0sNzA1NTooZSx0LHIpPT57dmFyIGE9cig5NTA0KSxuPXIoOTAzOSksaT1yKDIxOTUpLHM9T2JqZWN0LG89YSgiIi5zcGxpdCk7ZS5leHBvcnRzPW4oZnVuY3Rpb24oKXtyZXR1cm4hcygieiIpLnByb3BlcnR5SXNFbnVtZXJhYmxlKDApfSk/ZnVuY3Rpb24oZSl7cmV0dXJuIlN0cmluZyI9PT1pKGUpP28oZSwiIik6cyhlKX06c30sNzA4MDooZSx0LHIpPT57dmFyIGE9cig0NDAyKS5oYXM7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2EoZSk7cmV0dXJuIGV9fSw3MzQ3OihlLHQscik9Pnt2YXIgYT1yKDM3MjQpLG49cig5NTY1KSxpPXIoODc3Mykscz1yKDY5ODApLG89cig1Mzk3KSxjPXIoNjk2OSksbD1yKDkyOTcpLGg9cig1OTE3KSx1PU9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3I7dC5mPWE/dTpmdW5jdGlvbiBnZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IoZSx0KXtlPW8oZSk7dD1jKHQpO2lmKGgpdHJ5e3JldHVybiB1KGUsdCl9Y2F0Y2goZSl7fWlmKGwoZSx0KSlyZXR1cm4gcyghbihpLmYsZSx0KSxlW3RdKX19LDczOTQ6KGUsdCxyKT0+e3ZhciBhPXIoNDU3Niksbj1yKDY3MDYpLGk9cigyMTk1KSxzPWEuQXJyYXlCdWZmZXIsbz1hLlR5cGVFcnJvcjtlLmV4cG9ydHM9cyYmbihzLnByb3RvdHlwZSwiYnl0ZUxlbmd0aCIsImdldCIpfHxmdW5jdGlvbihlKXtpZigiQXJyYXlCdWZmZXIiIT09aShlKSl0aHJvdyBuZXcgbygiQXJyYXlCdWZmZXIgZXhwZWN0ZWQiKTtyZXR1cm4gZS5ieXRlTGVuZ3RofX0sNzQxNjooZSx0LHIpPT57dmFyIGE9cig5MDM5KSxuPXIoODIyNyksaT1yKDM3MjQpLHM9cig2Mzk1KSxvPW4oIml0ZXJhdG9yIik7ZS5leHBvcnRzPSFhKGZ1bmN0aW9uKCl7dmFyIGU9bmV3IFVSTCgiYj9hPTEmYj0yJmM9MyIsImh0dHBzOi8vYSIpLHQ9ZS5zZWFyY2hQYXJhbXMscj1uZXcgVVJMU2VhcmNoUGFyYW1zKCJhPTEmYT0yJmI9MyIpLGE9IiI7ZS5wYXRobmFtZT0iYyUyMGQiO3QuZm9yRWFjaChmdW5jdGlvbihlLHIpe3QuZGVsZXRlKCJiIik7YSs9citlfSk7ci5kZWxldGUoImEiLDIpO3IuZGVsZXRlKCJiIix2b2lkIDApO3JldHVybiBzJiYoIWUudG9KU09OfHwhci5oYXMoImEiLDEpfHxyLmhhcygiYSIsMil8fCFyLmhhcygiYSIsdm9pZCAwKXx8ci5oYXMoImIiKSl8fCF0LnNpemUmJihzfHwhaSl8fCF0LnNvcnR8fCJodHRwczovL2EvYyUyMGQ/YT0xJmM9MyIhPT1lLmhyZWZ8fCIzIiE9PXQuZ2V0KCJjIil8fCJhPTEiIT09U3RyaW5nKG5ldyBVUkxTZWFyY2hQYXJhbXMoIj9hPTEiKSl8fCF0W29dfHwiYSIhPT1uZXcgVVJMKCJodHRwczovL2FAYiIpLnVzZXJuYW1lfHwiYiIhPT1uZXcgVVJMU2VhcmNoUGFyYW1zKG5ldyBVUkxTZWFyY2hQYXJhbXMoImE9YiIpKS5nZXQoImEiKXx8InhuLS1lMWF5YmMiIT09bmV3IFVSTCgiaHR0cHM6Ly/RgtC10YHRgiIpLmhvc3R8fCIjJUQwJUIxIiE9PW5ldyBVUkwoImh0dHBzOi8vYSPQsSIpLmhhc2h8fCJhMWMzIiE9PWF8fCJ4IiE9PW5ldyBVUkwoImh0dHBzOi8veCIsdm9pZCAwKS5ob3N0fSl9LDc0NzY6KGUsdCxyKT0+e3ZhciBhPXIoMjE5NSksbj1yKDk1MDQpO2UuZXhwb3J0cz1mdW5jdGlvbihlKXtpZigiRnVuY3Rpb24iPT09YShlKSlyZXR1cm4gbihlKX19LDc1NjY6KGUsdCxyKT0+e3ZhciBhPXIoNjg0MCksbj1yKDk1MDQpLGk9cig2NTUpLHM9cigyODEyKSxvPVVSTFNlYXJjaFBhcmFtcyxjPW8ucHJvdG90eXBlLGw9bihjLmdldEFsbCksaD1uKGMuaGFzKSx1PW5ldyBvKCJhPTEiKTshdS5oYXMoImEiLDIpJiZ1LmhhcygiYSIsdm9pZCAwKXx8YShjLCJoYXMiLGZ1bmN0aW9uIGhhcyhlKXt2YXIgdD1hcmd1bWVudHMubGVuZ3RoLHI9dDwyP3ZvaWQgMDphcmd1bWVudHNbMV07aWYodCYmdm9pZCAwPT09cilyZXR1cm4gaCh0aGlzLGUpO3ZhciBhPWwodGhpcyxlKTtzKHQsMSk7Zm9yKHZhciBuPWkociksbz0wO288YS5sZW5ndGg7KWlmKGFbbysrXT09PW4pcmV0dXJuITA7cmV0dXJuITF9LHtlbnVtZXJhYmxlOiEwLHVuc2FmZTohMH0pfSw3NTg4OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig5NTY1KSxpPXIoMjY1Mikscz1yKDkzMDYpLG89cig4NTUxKSxjPXIoMTc2NyksbD1yKDk1MzkpLGg9cig0NTQ5KSgiZm9yRWFjaCIsVHlwZUVycm9yKTthKHt0YXJnZXQ6Ikl0ZXJhdG9yIixwcm90bzohMCxyZWFsOiEwLGZvcmNlZDpofSx7Zm9yRWFjaDpmdW5jdGlvbiBmb3JFYWNoKGUpe28odGhpcyk7dHJ5e3MoZSl9Y2F0Y2goZSl7bCh0aGlzLCJ0aHJvdyIsZSl9aWYoaClyZXR1cm4gbihoLHRoaXMsZSk7dmFyIHQ9Yyh0aGlzKSxyPTA7aSh0LGZ1bmN0aW9uKHQpe2UodCxyKyspfSx7SVNfUkVDT1JEOiEwfSl9fSl9LDc1OTQ6KGUsdCxyKT0+e3ZhciBhPXIoNDU3Niksbj1yKDkwMzkpLGk9YS5SZWdFeHAscz0hbihmdW5jdGlvbigpe3ZhciBlPSEwO3RyeXtpKCIuIiwiZCIpfWNhdGNoKHQpe2U9ITF9dmFyIHQ9e30scj0iIixhPWU/ImRnaW1zeSI6ImdpbXN5IixhZGRHZXR0ZXI9ZnVuY3Rpb24oZSxhKXtPYmplY3QuZGVmaW5lUHJvcGVydHkodCxlLHtnZXQ6ZnVuY3Rpb24oKXtyKz1hO3JldHVybiEwfX0pfSxuPXtkb3RBbGw6InMiLGdsb2JhbDoiZyIsaWdub3JlQ2FzZToiaSIsbXVsdGlsaW5lOiJtIixzdGlja3k6InkifTtlJiYobi5oYXNJbmRpY2VzPSJkIik7Zm9yKHZhciBzIGluIG4pYWRkR2V0dGVyKHMsbltzXSk7cmV0dXJuIE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IoaS5wcm90b3R5cGUsImZsYWdzIikuZ2V0LmNhbGwodCkhPT1hfHxyIT09YX0pO2UuZXhwb3J0cz17Y29ycmVjdDpzfX0sNzYyOTooZSx0LHIpPT57dmFyIGE9cig2Mzk1KSxuPXIoNDU3NiksaT1yKDk0MzMpLHM9Il9fY29yZS1qc19zaGFyZWRfXyIsbz1lLmV4cG9ydHM9bltzXXx8aShzLHt9KTsoby52ZXJzaW9uc3x8KG8udmVyc2lvbnM9W10pKS5wdXNoKHt2ZXJzaW9uOiIzLjQ1LjEiLG1vZGU6YT8icHVyZSI6Imdsb2JhbCIsY29weXJpZ2h0OiLCqSAyMDE0LTIwMjUgRGVuaXMgUHVzaGthcmV2ICh6bG9pcm9jay5ydSkiLGxpY2Vuc2U6Imh0dHBzOi8vZ2l0aHViLmNvbS96bG9pcm9jay9jb3JlLWpzL2Jsb2IvdjMuNDUuMS9MSUNFTlNFIixzb3VyY2U6Imh0dHBzOi8vZ2l0aHViLmNvbS96bG9pcm9jay9jb3JlLWpzIn0pfSw3NjQyOihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cigzNDQwKSxpPXIoOTAzOSk7YSh7dGFyZ2V0OiJTZXQiLHByb3RvOiEwLHJlYWw6ITAsZm9yY2VkOiFyKDQ5MTYpKCJkaWZmZXJlbmNlIixmdW5jdGlvbihlKXtyZXR1cm4gMD09PWUuc2l6ZX0pfHxpKGZ1bmN0aW9uKCl7dmFyIGU9e3NpemU6MSxoYXM6ZnVuY3Rpb24oKXtyZXR1cm4hMH0sa2V5czpmdW5jdGlvbigpe3ZhciBlPTA7cmV0dXJue25leHQ6ZnVuY3Rpb24oKXt2YXIgcj1lKys+MTt0LmhhcygxKSYmdC5jbGVhcigpO3JldHVybntkb25lOnIsdmFsdWU6Mn19fX19LHQ9bmV3IFNldChbMSwyLDMsNF0pO3JldHVybiAzIT09dC5kaWZmZXJlbmNlKGUpLnNpemV9KX0se2RpZmZlcmVuY2U6bn0pfSw3NjU3OihlLHQscik9Pnt2YXIgYSxuLGkscz1yKDkwMzkpLG89cig0OTAxKSxjPXIoMzQpLGw9cigyMzYwKSxoPXIoMjc4NyksdT1yKDY4NDApLGQ9cig4MjI3KSxmPXIoNjM5NSksZz1kKCJpdGVyYXRvciIpLHA9ITE7W10ua2V5cyYmKCJuZXh0ImluKGk9W10ua2V5cygpKT8obj1oKGgoaSkpKSE9PU9iamVjdC5wcm90b3R5cGUmJihhPW4pOnA9ITApOyFjKGEpfHxzKGZ1bmN0aW9uKCl7dmFyIGU9e307cmV0dXJuIGFbZ10uY2FsbChlKSE9PWV9KT9hPXt9OmYmJihhPWwoYSkpO28oYVtnXSl8fHUoYSxnLGZ1bmN0aW9uKCl7cmV0dXJuIHRoaXN9KTtlLmV4cG9ydHM9e0l0ZXJhdG9yUHJvdG90eXBlOmEsQlVHR1lfU0FGQVJJX0lURVJBVE9SUzpwfX0sNzY4MDooZSx0LHIpPT57dmFyIGE9cig5NTA0KTtlLmV4cG9ydHM9YShbXS5zbGljZSl9LDc2OTY6KGUsdCxyKT0+e3ZhciBhPXIoMTI5MSksbj1yKDgwMTQpLGk9UmFuZ2VFcnJvcjtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7aWYodm9pZCAwPT09ZSlyZXR1cm4gMDt2YXIgdD1hKGUpLHI9bih0KTtpZih0IT09cil0aHJvdyBuZXcgaSgiV3JvbmcgbGVuZ3RoIG9yIGluZGV4Iik7cmV0dXJuIHJ9fSw3NzQwOihlLHQscik9Pnt2YXIgYT1yKDkyOTcpLG49cig1MDMxKSxpPXIoNzM0Nykscz1yKDQ5MTMpO2UuZXhwb3J0cz1mdW5jdGlvbihlLHQscil7Zm9yKHZhciBvPW4odCksYz1zLmYsbD1pLmYsaD0wO2g8by5sZW5ndGg7aCsrKXt2YXIgdT1vW2hdO2EoZSx1KXx8ciYmYShyLHUpfHxjKGUsdSxsKHQsdSkpfX19LDc3NTA6KGUsdCxyKT0+e3ZhciBhPXIoNDExNyksbj1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2lmKGEoZSkpdGhyb3cgbmV3IG4oIkNhbid0IGNhbGwgbWV0aG9kIG9uICIrZSk7cmV0dXJuIGV9fSw3NzUxOihlLHQscik9Pnt2YXIgYT1yKDQ1NzYpLG49cig0OTAxKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gYXJndW1lbnRzLmxlbmd0aDwyPyhyPWFbZV0sbihyKT9yOnZvaWQgMCk6YVtlXSYmYVtlXVt0XTt2YXIgcn19LDc4MTE6ZT0+e2UuZXhwb3J0cz0idW5kZWZpbmVkIiE9dHlwZW9mIEFycmF5QnVmZmVyJiYidW5kZWZpbmVkIiE9dHlwZW9mIERhdGFWaWV3fSw3OTM2OihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig1NjM2KTtuJiZhKHt0YXJnZXQ6IkFycmF5QnVmZmVyIixwcm90bzohMH0se3RyYW5zZmVyVG9GaXhlZExlbmd0aDpmdW5jdGlvbiB0cmFuc2ZlclRvRml4ZWRMZW5ndGgoKXtyZXR1cm4gbih0aGlzLGFyZ3VtZW50cy5sZW5ndGg/YXJndW1lbnRzWzBdOnZvaWQgMCwhMSl9fSl9LDc5Nzk6KGUsdCxyKT0+e3ZhciBhPXIoODU1MSk7ZS5leHBvcnRzPWZ1bmN0aW9uKCl7dmFyIGU9YSh0aGlzKSx0PSIiO2UuaGFzSW5kaWNlcyYmKHQrPSJkIik7ZS5nbG9iYWwmJih0Kz0iZyIpO2UuaWdub3JlQ2FzZSYmKHQrPSJpIik7ZS5tdWx0aWxpbmUmJih0Kz0ibSIpO2UuZG90QWxsJiYodCs9InMiKTtlLnVuaWNvZGUmJih0Kz0idSIpO2UudW5pY29kZVNldHMmJih0Kz0idiIpO2Uuc3RpY2t5JiYodCs9InkiKTtyZXR1cm4gdH19LDgwMDQ6KGUsdCxyKT0+e3ZhciBhPXIoNjUxOCksbj1yKDkwMzkpLGk9cig4NzUwKTthKHt0YXJnZXQ6IlNldCIscHJvdG86ITAscmVhbDohMCxmb3JjZWQ6IXIoNDkxNikoImludGVyc2VjdGlvbiIsZnVuY3Rpb24oZSl7cmV0dXJuIDI9PT1lLnNpemUmJmUuaGFzKDEpJiZlLmhhcygyKX0pfHxuKGZ1bmN0aW9uKCl7cmV0dXJuIjMsMiIhPT1TdHJpbmcoQXJyYXkuZnJvbShuZXcgU2V0KFsxLDIsM10pLmludGVyc2VjdGlvbihuZXcgU2V0KFszLDJdKSkpKX0pfSx7aW50ZXJzZWN0aW9uOml9KX0sODAxNDooZSx0LHIpPT57dmFyIGE9cigxMjkxKSxuPU1hdGgubWluO2UuZXhwb3J0cz1mdW5jdGlvbihlKXt2YXIgdD1hKGUpO3JldHVybiB0PjA/bih0LDkwMDcxOTkyNTQ3NDA5OTEpOjB9fSw4MTAwOihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig1NjM2KTtuJiZhKHt0YXJnZXQ6IkFycmF5QnVmZmVyIixwcm90bzohMH0se3RyYW5zZmVyOmZ1bmN0aW9uIHRyYW5zZmVyKCl7cmV0dXJuIG4odGhpcyxhcmd1bWVudHMubGVuZ3RoP2FyZ3VtZW50c1swXTp2b2lkIDAsITApfX0pfSw4MTExOihlLHQscik9Pnt2YXIgYT1yKDY1MTgpLG49cig0NTc2KSxpPXIoNjc5KSxzPXIoODU1MSksbz1yKDQ5MDEpLGM9cigyNzg3KSxsPXIoMjEwNiksaD1yKDQ2NTkpLHU9cig5MDM5KSxkPXIoOTI5NyksZj1yKDgyMjcpLGc9cig3NjU3KS5JdGVyYXRvclByb3RvdHlwZSxwPXIoMzcyNCksbT1yKDYzOTUpLGI9ImNvbnN0cnVjdG9yIix5PSJJdGVyYXRvciIsdz1mKCJ0b1N0cmluZ1RhZyIpLHg9VHlwZUVycm9yLFM9blt5XSxrPW18fCFvKFMpfHxTLnByb3RvdHlwZSE9PWd8fCF1KGZ1bmN0aW9uKCl7Uyh7fSl9KSxDPWZ1bmN0aW9uIEl0ZXJhdG9yKCl7aSh0aGlzLGcpO2lmKGModGhpcyk9PT1nKXRocm93IG5ldyB4KCJBYnN0cmFjdCBjbGFzcyBJdGVyYXRvciBub3QgZGlyZWN0bHkgY29uc3RydWN0YWJsZSIpfSxkZWZpbmVJdGVyYXRvclByb3RvdHlwZUFjY2Vzc29yPWZ1bmN0aW9uKGUsdCl7cD9sKGcsZSx7Y29uZmlndXJhYmxlOiEwLGdldDpmdW5jdGlvbigpe3JldHVybiB0fSxzZXQ6ZnVuY3Rpb24odCl7cyh0aGlzKTtpZih0aGlzPT09Zyl0aHJvdyBuZXcgeCgiWW91IGNhbid0IHJlZGVmaW5lIHRoaXMgcHJvcGVydHkiKTtkKHRoaXMsZSk/dGhpc1tlXT10OmgodGhpcyxlLHQpfX0pOmdbZV09dH07ZChnLHcpfHxkZWZpbmVJdGVyYXRvclByb3RvdHlwZUFjY2Vzc29yKHcseSk7IWsmJmQoZyxiKSYmZ1tiXSE9PU9iamVjdHx8ZGVmaW5lSXRlcmF0b3JQcm90b3R5cGVBY2Nlc3NvcihiLEMpO0MucHJvdG90eXBlPWc7YSh7Z2xvYmFsOiEwLGNvbnN0cnVjdG9yOiEwLGZvcmNlZDprfSx7SXRlcmF0b3I6Q30pfSw4MjI3OihlLHQscik9Pnt2YXIgYT1yKDQ1NzYpLG49cig1NzQ1KSxpPXIoOTI5Nykscz1yKDMzOTIpLG89cig0NDk1KSxjPXIoNzA0MCksbD1hLlN5bWJvbCxoPW4oIndrcyIpLHU9Yz9sLmZvcnx8bDpsJiZsLndpdGhvdXRTZXR0ZXJ8fHM7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2koaCxlKXx8KGhbZV09byYmaShsLGUpP2xbZV06dSgiU3ltYm9sLiIrZSkpO3JldHVybiBoW2VdfX0sODIzNzooZSx0LHIpPT57dmFyIGE9cig2NTE4KSxuPXIoMjY1MiksaT1yKDkzMDYpLHM9cig4NTUxKSxvPXIoMTc2NyksYz1yKDk1MzkpLGw9cig0NTQ5KSxoPXIoODc0NSksdT1yKDkwMzkpLGQ9VHlwZUVycm9yLGY9dShmdW5jdGlvbigpe1tdLmtleXMoKS5yZWR1Y2UoZnVuY3Rpb24oKXt9LHZvaWQgMCl9KSxnPSFmJiZsKCJyZWR1Y2UiLGQpO2Eoe3RhcmdldDoiSXRlcmF0b3IiLHByb3RvOiEwLHJlYWw6ITAsZm9yY2VkOmZ8fGd9LHtyZWR1Y2U6ZnVuY3Rpb24gcmVkdWNlKGUpe3ModGhpcyk7dHJ5e2koZSl9Y2F0Y2goZSl7Yyh0aGlzLCJ0aHJvdyIsZSl9dmFyIHQ9YXJndW1lbnRzLmxlbmd0aDwyLHI9dD92b2lkIDA6YXJndW1lbnRzWzFdO2lmKGcpcmV0dXJuIGgoZyx0aGlzLHQ/W2VdOltlLHJdKTt2YXIgYT1vKHRoaXMpLGw9MDtuKGEsZnVuY3Rpb24oYSl7aWYodCl7dD0hMTtyPWF9ZWxzZSByPWUocixhLGwpO2wrK30se0lTX1JFQ09SRDohMH0pO2lmKHQpdGhyb3cgbmV3IGQoIlJlZHVjZSBvZiBlbXB0eSBpdGVyYXRvciB3aXRoIG5vIGluaXRpYWwgdmFsdWUiKTtyZXR1cm4gcn19KX0sODQ2OTooZSx0LHIpPT57dmFyIGE9cig5NTA0KSxuPXIoNTA3KSxpPXIoNDQwMikscz1pLlNldCxvPWkucHJvdG8sYz1hKG8uZm9yRWFjaCksbD1hKG8ua2V5cyksaD1sKG5ldyBzKS5uZXh0O2UuZXhwb3J0cz1mdW5jdGlvbihlLHQscil7cmV0dXJuIHI/bih7aXRlcmF0b3I6bChlKSxuZXh0Omh9LHQpOmMoZSx0KX19LDg0ODA6KGUsdCxyKT0+e3ZhciBhPXIoMTgyOCksbj1yKDg3MjcpLmNvbmNhdCgibGVuZ3RoIiwicHJvdG90eXBlIik7dC5mPU9iamVjdC5nZXRPd25Qcm9wZXJ0eU5hbWVzfHxmdW5jdGlvbiBnZXRPd25Qcm9wZXJ0eU5hbWVzKGUpe3JldHVybiBhKGUsbil9fSw4NTI3OihlLHQscik9Pnt2YXIgYT1yKDcwODApLG49cig0NDAyKS5oYXMsaT1yKDUxNzApLHM9cigzNzg5KSxvPXIoNTA3KSxjPXIoOTUzOSk7ZS5leHBvcnRzPWZ1bmN0aW9uIGlzU3VwZXJzZXRPZihlKXt2YXIgdD1hKHRoaXMpLHI9cyhlKTtpZihpKHQpPHIuc2l6ZSlyZXR1cm4hMTt2YXIgbD1yLmdldEl0ZXJhdG9yKCk7cmV0dXJuITEhPT1vKGwsZnVuY3Rpb24oZSl7aWYoIW4odCxlKSlyZXR1cm4gYyhsLCJub3JtYWwiLCExKX0pfX0sODU1MTooZSx0LHIpPT57dmFyIGE9cigzNCksbj1TdHJpbmcsaT1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2lmKGEoZSkpcmV0dXJuIGU7dGhyb3cgbmV3IGkobihlKSsiIGlzIG5vdCBhbiBvYmplY3QiKX19LDg1NzQ6KGUsdCxyKT0+e3ZhciBhPXIoOTUwNCksbj1FcnJvcixpPWEoIiIucmVwbGFjZSkscz1TdHJpbmcobmV3IG4oInp4Y2FzZCIpLnN0YWNrKSxvPS9cblxzKmF0IFteOl0qOlteXG5dKi8sYz1vLnRlc3Qocyk7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCl7aWYoYyYmInN0cmluZyI9PXR5cGVvZiBlJiYhbi5wcmVwYXJlU3RhY2tUcmFjZSlmb3IoO3QtLTspZT1pKGUsbywiIik7cmV0dXJuIGV9fSw4NjIyOihlLHQscik9Pnt2YXIgYT1yKDQ1NzYpLG49cig0OTAxKSxpPWEuV2Vha01hcDtlLmV4cG9ydHM9bihpKSYmL25hdGl2ZSBjb2RlLy50ZXN0KFN0cmluZyhpKSl9LDg2NDY6KGUsdCxyKT0+e3ZhciBhPXIoOTU2NSksbj1yKDg1NTEpLGk9cigxNzY3KSxzPXIoODUxKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXt0JiYic3RyaW5nIj09dHlwZW9mIGV8fG4oZSk7dmFyIHI9cyhlKTtyZXR1cm4gaShuKHZvaWQgMCE9PXI/YShyLGUpOmUpKX19LDg2ODY6KGUsdCxyKT0+e3ZhciBhPXIoMzcyNCksbj1yKDkwMzkpO2UuZXhwb3J0cz1hJiZuKGZ1bmN0aW9uKCl7cmV0dXJuIDQyIT09T2JqZWN0LmRlZmluZVByb3BlcnR5KGZ1bmN0aW9uKCl7fSwicHJvdG90eXBlIix7dmFsdWU6NDIsd3JpdGFibGU6ITF9KS5wcm90b3R5cGV9KX0sODcyMTooZSx0LHIpPT57dmFyIGE9cigzNzI0KSxuPXIoOTUwNCksaT1yKDIxMDYpLHM9VVJMU2VhcmNoUGFyYW1zLnByb3RvdHlwZSxvPW4ocy5mb3JFYWNoKTthJiYhKCJzaXplImluIHMpJiZpKHMsInNpemUiLHtnZXQ6ZnVuY3Rpb24gc2l6ZSgpe3ZhciBlPTA7byh0aGlzLGZ1bmN0aW9uKCl7ZSsrfSk7cmV0dXJuIGV9LGNvbmZpZ3VyYWJsZTohMCxlbnVtZXJhYmxlOiEwfSl9LDg3Mjc6ZT0+e2UuZXhwb3J0cz1bImNvbnN0cnVjdG9yIiwiaGFzT3duUHJvcGVydHkiLCJpc1Byb3RvdHlwZU9mIiwicHJvcGVydHlJc0VudW1lcmFibGUiLCJ0b0xvY2FsZVN0cmluZyIsInRvU3RyaW5nIiwidmFsdWVPZiJdfSw4NzQ1OihlLHQscik9Pnt2YXIgYT1yKDYxNiksbj1GdW5jdGlvbi5wcm90b3R5cGUsaT1uLmFwcGx5LHM9bi5jYWxsO2UuZXhwb3J0cz0ib2JqZWN0Ij09dHlwZW9mIFJlZmxlY3QmJlJlZmxlY3QuYXBwbHl8fChhP3MuYmluZChpKTpmdW5jdGlvbigpe3JldHVybiBzLmFwcGx5KGksYXJndW1lbnRzKX0pfSw4NzUwOihlLHQscik9Pnt2YXIgYT1yKDcwODApLG49cig0NDAyKSxpPXIoNTE3MCkscz1yKDM3ODkpLG89cig4NDY5KSxjPXIoNTA3KSxsPW4uU2V0LGg9bi5hZGQsdT1uLmhhcztlLmV4cG9ydHM9ZnVuY3Rpb24gaW50ZXJzZWN0aW9uKGUpe3ZhciB0PWEodGhpcykscj1zKGUpLG49bmV3IGw7aSh0KT5yLnNpemU/YyhyLmdldEl0ZXJhdG9yKCksZnVuY3Rpb24oZSl7dSh0LGUpJiZoKG4sZSl9KTpvKHQsZnVuY3Rpb24oZSl7ci5pbmNsdWRlcyhlKSYmaChuLGUpfSk7cmV0dXJuIG59fSw4NzczOihlLHQpPT57dmFyIHI9e30ucHJvcGVydHlJc0VudW1lcmFibGUsYT1PYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yLG49YSYmIXIuY2FsbCh7MToyfSwxKTt0LmY9bj9mdW5jdGlvbiBwcm9wZXJ0eUlzRW51bWVyYWJsZShlKXt2YXIgdD1hKHRoaXMsZSk7cmV0dXJuISF0JiZ0LmVudW1lcmFibGV9OnJ9LDg5ODE6KGUsdCxyKT0+e3ZhciBhPXIoNzc1MCksbj1PYmplY3Q7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3JldHVybiBuKGEoZSkpfX0sOTAzOTplPT57ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3RyeXtyZXR1cm4hIWUoKX1jYXRjaChlKXtyZXR1cm4hMH19fSw5MTQzOihlLHQscik9Pnt2YXIgYT1yKDQ1NzYpLG49cig5NTA0KSxpPXIoMzk3Mikscz1yKDM0NjMpLG89cig5Mjk3KSxjPXIoMjgwNCksbD1yKDk0NCksaD1yKDUxNjkpLHU9Yy5jMmksZD1jLmMyaVVybCxmPWEuU3ludGF4RXJyb3IsZz1hLlR5cGVFcnJvcixwPW4oIiIuY2hhckF0KSxza2lwQXNjaWlXaGl0ZXNwYWNlPWZ1bmN0aW9uKGUsdCl7Zm9yKHZhciByPWUubGVuZ3RoO3Q8cjt0Kyspe3ZhciBhPXAoZSx0KTtpZigiICIhPT1hJiYiXHQiIT09YSYmIlxuIiE9PWEmJiJcZiIhPT1hJiYiXHIiIT09YSlicmVha31yZXR1cm4gdH0sZGVjb2RlQmFzZTY0Q2h1bms9ZnVuY3Rpb24oZSx0LHIpe3ZhciBhPWUubGVuZ3RoO2E8NCYmKGUrPTI9PT1hPyJBQSI6IkEiKTt2YXIgbj0odFtwKGUsMCldPDwxOCkrKHRbcChlLDEpXTw8MTIpKyh0W3AoZSwyKV08PDYpK3RbcChlLDMpXSxpPVtuPj4xNiYyNTUsbj4+OCYyNTUsMjU1Jm5dO2lmKDI9PT1hKXtpZihyJiYwIT09aVsxXSl0aHJvdyBuZXcgZigiRXh0cmEgYml0cyIpO3JldHVybltpWzBdXX1pZigzPT09YSl7aWYociYmMCE9PWlbMl0pdGhyb3cgbmV3IGYoIkV4dHJhIGJpdHMiKTtyZXR1cm5baVswXSxpWzFdXX1yZXR1cm4gaX0sd3JpdGVCeXRlcz1mdW5jdGlvbihlLHQscil7Zm9yKHZhciBhPXQubGVuZ3RoLG49MDtuPGE7bisrKWVbcituXT10W25dO3JldHVybiByK2F9O2UuZXhwb3J0cz1mdW5jdGlvbihlLHQscixhKXtzKGUpO2kodCk7dmFyIG49ImJhc2U2NCI9PT1sKHQpP3U6ZCxjPXQ/dC5sYXN0Q2h1bmtIYW5kbGluZzp2b2lkIDA7dm9pZCAwPT09YyYmKGM9Imxvb3NlIik7aWYoImxvb3NlIiE9PWMmJiJzdHJpY3QiIT09YyYmInN0b3AtYmVmb3JlLXBhcnRpYWwiIT09Yyl0aHJvdyBuZXcgZygiSW5jb3JyZWN0IGBsYXN0Q2h1bmtIYW5kbGluZ2Agb3B0aW9uIik7ciYmaChyLmJ1ZmZlcik7dmFyIG09ZS5sZW5ndGgsYj1yfHxbXSx5PTAsdz0wLHg9IiIsUz0wO2lmKGEpZm9yKDs7KXtpZigoUz1za2lwQXNjaWlXaGl0ZXNwYWNlKGUsUykpPT09bSl7aWYoeC5sZW5ndGg+MCl7aWYoInN0b3AtYmVmb3JlLXBhcnRpYWwiPT09YylicmVhaztpZigibG9vc2UiIT09Yyl0aHJvdyBuZXcgZigiTWlzc2luZyBwYWRkaW5nIik7aWYoMT09PXgubGVuZ3RoKXRocm93IG5ldyBmKCJNYWxmb3JtZWQgcGFkZGluZzogZXhhY3RseSBvbmUgYWRkaXRpb25hbCBjaGFyYWN0ZXIiKTt5PXdyaXRlQnl0ZXMoYixkZWNvZGVCYXNlNjRDaHVuayh4LG4sITEpLHkpfXc9bTticmVha312YXIgaz1wKGUsUyk7KytTO2lmKCI9Ij09PWspe2lmKHgubGVuZ3RoPDIpdGhyb3cgbmV3IGYoIlBhZGRpbmcgaXMgdG9vIGVhcmx5Iik7Uz1za2lwQXNjaWlXaGl0ZXNwYWNlKGUsUyk7aWYoMj09PXgubGVuZ3RoKXtpZihTPT09bSl7aWYoInN0b3AtYmVmb3JlLXBhcnRpYWwiPT09YylicmVhazt0aHJvdyBuZXcgZigiTWFsZm9ybWVkIHBhZGRpbmc6IG9ubHkgb25lID0iKX1pZigiPSI9PT1wKGUsUykpeysrUztTPXNraXBBc2NpaVdoaXRlc3BhY2UoZSxTKX19aWYoUzxtKXRocm93IG5ldyBmKCJVbmV4cGVjdGVkIGNoYXJhY3RlciBhZnRlciBwYWRkaW5nIik7eT13cml0ZUJ5dGVzKGIsZGVjb2RlQmFzZTY0Q2h1bmsoeCxuLCJzdHJpY3QiPT09YykseSk7dz1tO2JyZWFrfWlmKCFvKG4saykpdGhyb3cgbmV3IGYoIlVuZXhwZWN0ZWQgY2hhcmFjdGVyIik7dmFyIEM9YS15O2lmKDE9PT1DJiYyPT09eC5sZW5ndGh8fDI9PT1DJiYzPT09eC5sZW5ndGgpYnJlYWs7aWYoND09PSh4Kz1rKS5sZW5ndGgpe3k9d3JpdGVCeXRlcyhiLGRlY29kZUJhc2U2NENodW5rKHgsbiwhMSkseSk7eD0iIjt3PVM7aWYoeT09PWEpYnJlYWt9fXJldHVybntieXRlczpiLHJlYWQ6dyx3cml0dGVuOnl9fX0sOTI4NjooZSx0LHIpPT57dmFyIGE9cig0NDAyKSxuPXIoODQ2OSksaT1hLlNldCxzPWEuYWRkO2UuZXhwb3J0cz1mdW5jdGlvbihlKXt2YXIgdD1uZXcgaTtuKGUsZnVuY3Rpb24oZSl7cyh0LGUpfSk7cmV0dXJuIHR9fSw5Mjk3OihlLHQscik9Pnt2YXIgYT1yKDk1MDQpLG49cig4OTgxKSxpPWEoe30uaGFzT3duUHJvcGVydHkpO2UuZXhwb3J0cz1PYmplY3QuaGFzT3dufHxmdW5jdGlvbiBoYXNPd24oZSx0KXtyZXR1cm4gaShuKGUpLHQpfX0sOTMwNjooZSx0LHIpPT57dmFyIGE9cig0OTAxKSxuPXIoNjgyMyksaT1UeXBlRXJyb3I7ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe2lmKGEoZSkpcmV0dXJuIGU7dGhyb3cgbmV3IGkobihlKSsiIGlzIG5vdCBhIGZ1bmN0aW9uIil9fSw5NDI5OihlLHQscik9Pnt2YXIgYT1yKDQ1NzYpLG49cig2MTkzKTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSl7aWYobil7dHJ5e3JldHVybiBhLnByb2Nlc3MuZ2V0QnVpbHRpbk1vZHVsZShlKX1jYXRjaChlKXt9dHJ5e3JldHVybiBGdW5jdGlvbigncmV0dXJuIHJlcXVpcmUoIicrZSsnIiknKSgpfWNhdGNoKGUpe319fX0sOTQzMjooZSx0LHIpPT57cig1MjEzKX0sOTQzMzooZSx0LHIpPT57dmFyIGE9cig0NTc2KSxuPU9iamVjdC5kZWZpbmVQcm9wZXJ0eTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0KXt0cnl7bihhLGUse3ZhbHVlOnQsY29uZmlndXJhYmxlOiEwLHdyaXRhYmxlOiEwfSl9Y2F0Y2gocil7YVtlXT10fXJldHVybiB0fX0sOTQ2MjooZSx0LHIpPT57dmFyIGE9cig5NTY1KSxuPXIoMjM2MCksaT1yKDY2OTkpLHM9cig2Mjc5KSxvPXIoODIyNyksYz1yKDExODEpLGw9cig1OTY2KSxoPXIoNzY1NykuSXRlcmF0b3JQcm90b3R5cGUsdT1yKDI1MjkpLGQ9cig5NTM5KSxmPXIoMTM4NSksZz1vKCJ0b1N0cmluZ1RhZyIpLHA9Ikl0ZXJhdG9ySGVscGVyIixtPSJXcmFwRm9yVmFsaWRJdGVyYXRvciIsYj0ibm9ybWFsIix5PSJ0aHJvdyIsdz1jLnNldCxjcmVhdGVJdGVyYXRvclByb3h5UHJvdG90eXBlPWZ1bmN0aW9uKGUpe3ZhciB0PWMuZ2V0dGVyRm9yKGU/bTpwKTtyZXR1cm4gcyhuKGgpLHtuZXh0OmZ1bmN0aW9uIG5leHQoKXt2YXIgcj10KHRoaXMpO2lmKGUpcmV0dXJuIHIubmV4dEhhbmRsZXIoKTtpZihyLmRvbmUpcmV0dXJuIHUodm9pZCAwLCEwKTt0cnl7dmFyIGE9ci5uZXh0SGFuZGxlcigpO3JldHVybiByLnJldHVybkhhbmRsZXJSZXN1bHQ/YTp1KGEsci5kb25lKX1jYXRjaChlKXtyLmRvbmU9ITA7dGhyb3cgZX19LHJldHVybjpmdW5jdGlvbigpe3ZhciByPXQodGhpcyksbj1yLml0ZXJhdG9yO3IuZG9uZT0hMDtpZihlKXt2YXIgaT1sKG4sInJldHVybiIpO3JldHVybiBpP2EoaSxuKTp1KHZvaWQgMCwhMCl9aWYoci5pbm5lcil0cnl7ZChyLmlubmVyLml0ZXJhdG9yLGIpfWNhdGNoKGUpe3JldHVybiBkKG4seSxlKX1pZihyLm9wZW5JdGVycyl0cnl7ZihyLm9wZW5JdGVycyxiKX1jYXRjaChlKXtyZXR1cm4gZChuLHksZSl9biYmZChuLGIpO3JldHVybiB1KHZvaWQgMCwhMCl9fSl9LHg9Y3JlYXRlSXRlcmF0b3JQcm94eVByb3RvdHlwZSghMCksUz1jcmVhdGVJdGVyYXRvclByb3h5UHJvdG90eXBlKCExKTtpKFMsZywiSXRlcmF0b3IgSGVscGVyIik7ZS5leHBvcnRzPWZ1bmN0aW9uKGUsdCxyKXt2YXIgYT1mdW5jdGlvbiBJdGVyYXRvcihhLG4pe2lmKG4pe24uaXRlcmF0b3I9YS5pdGVyYXRvcjtuLm5leHQ9YS5uZXh0fWVsc2Ugbj1hO24udHlwZT10P206cDtuLnJldHVybkhhbmRsZXJSZXN1bHQ9ISFyO24ubmV4dEhhbmRsZXI9ZTtuLmNvdW50ZXI9MDtuLmRvbmU9ITE7dyh0aGlzLG4pfTthLnByb3RvdHlwZT10P3g6UztyZXR1cm4gYX19LDk0Nzk6KGUsdCxyKT0+e3ZhciBhPXIoMzcyNCksbj1yKDIxMDYpLGk9cig3NTk0KSxzPXIoNzk3OSk7aWYoYSYmIWkuY29ycmVjdCl7bihSZWdFeHAucHJvdG90eXBlLCJmbGFncyIse2NvbmZpZ3VyYWJsZTohMCxnZXQ6c30pO2kuY29ycmVjdD0hMH19LDk0ODY6KGUsdCxyKT0+e3ZhciBhPXIoNjUxOCksbj1yKDQ1NzYpLGk9cig5NTA0KSxzPXIoMzk3Miksbz1yKDQxNTQpLGM9cig1MTY5KSxsPXIoMjgwNCksaD1yKDk0NCksdT1sLmkyYyxkPWwuaTJjVXJsLGY9aSgiIi5jaGFyQXQpLGc9bi5VaW50OEFycmF5LHA9IWd8fCFnLnByb3RvdHlwZS50b0Jhc2U2NHx8IWZ1bmN0aW9uKCl7dHJ5eyhuZXcgZykudG9CYXNlNjQobnVsbCl9Y2F0Y2goZSl7cmV0dXJuITB9fSgpO2cmJmEoe3RhcmdldDoiVWludDhBcnJheSIscHJvdG86ITAsZm9yY2VkOnB9LHt0b0Jhc2U2NDpmdW5jdGlvbiB0b0Jhc2U2NCgpe3ZhciBlPW8odGhpcyksdD1hcmd1bWVudHMubGVuZ3RoP3MoYXJndW1lbnRzWzBdKTp2b2lkIDAscj0iYmFzZTY0Ij09PWgodCk/dTpkLGE9ISF0JiYhIXQub21pdFBhZGRpbmc7Yyh0aGlzLmJ1ZmZlcik7Zm9yKHZhciBuLGk9IiIsbD0wLGc9ZS5sZW5ndGgsYXQ9ZnVuY3Rpb24oZSl7cmV0dXJuIGYocixuPj42KmUmNjMpfTtsKzI8ZztsKz0zKXtuPShlW2xdPDwxNikrKGVbbCsxXTw8OCkrZVtsKzJdO2krPWF0KDMpK2F0KDIpK2F0KDEpK2F0KDApfWlmKGwrMj09PWcpe249KGVbbF08PDE2KSsoZVtsKzFdPDw4KTtpKz1hdCgzKSthdCgyKSthdCgxKSsoYT8iIjoiPSIpfWVsc2UgaWYobCsxPT09Zyl7bj1lW2xdPDwxNjtpKz1hdCgzKSthdCgyKSsoYT8iIjoiPT0iKX1yZXR1cm4gaX19KX0sOTUwNDooZSx0LHIpPT57dmFyIGE9cig2MTYpLG49RnVuY3Rpb24ucHJvdG90eXBlLGk9bi5jYWxsLHM9YSYmbi5iaW5kLmJpbmQoaSxpKTtlLmV4cG9ydHM9YT9zOmZ1bmN0aW9uKGUpe3JldHVybiBmdW5jdGlvbigpe3JldHVybiBpLmFwcGx5KGUsYXJndW1lbnRzKX19fSw5NTE5OihlLHQscik9Pnt2YXIgYSxuLGk9cig0NTc2KSxzPXIoMjgzOSksbz1pLnByb2Nlc3MsYz1pLkRlbm8sbD1vJiZvLnZlcnNpb25zfHxjJiZjLnZlcnNpb24saD1sJiZsLnY4O2gmJihuPShhPWguc3BsaXQoIi4iKSlbMF0+MCYmYVswXTw0PzE6KyhhWzBdK2FbMV0pKTshbiYmcyYmKCEoYT1zLm1hdGNoKC9FZGdlXC8oXGQrKS8pKXx8YVsxXT49NzQpJiYoYT1zLm1hdGNoKC9DaHJvbWVcLyhcZCspLykpJiYobj0rYVsxXSk7ZS5leHBvcnRzPW59LDk1Mzk6KGUsdCxyKT0+e3ZhciBhPXIoOTU2NSksbj1yKDg1NTEpLGk9cig1OTY2KTtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0LHIpe3ZhciBzLG87bihlKTt0cnl7aWYoIShzPWkoZSwicmV0dXJuIikpKXtpZigidGhyb3ciPT09dCl0aHJvdyByO3JldHVybiByfXM9YShzLGUpfWNhdGNoKGUpe289ITA7cz1lfWlmKCJ0aHJvdyI9PT10KXRocm93IHI7aWYobyl0aHJvdyBzO24ocyk7cmV0dXJuIHJ9fSw5NTY1OihlLHQscik9Pnt2YXIgYT1yKDYxNiksbj1GdW5jdGlvbi5wcm90b3R5cGUuY2FsbDtlLmV4cG9ydHM9YT9uLmJpbmQobik6ZnVuY3Rpb24oKXtyZXR1cm4gbi5hcHBseShuLGFyZ3VtZW50cyl9fSw5NTc3OihlLHQscik9Pnt2YXIgYT1yKDk5MjgpLG49cig0NjQ0KSxpPXIoMTEwOCkscz1yKDEyOTEpLG89cig1ODU0KSxjPW4uYVR5cGVkQXJyYXksbD1uLmdldFR5cGVkQXJyYXlDb25zdHJ1Y3RvcixoPW4uZXhwb3J0VHlwZWRBcnJheU1ldGhvZCx1PWZ1bmN0aW9uKCl7dHJ5e25ldyBJbnQ4QXJyYXkoMSkud2l0aCgyLHt2YWx1ZU9mOmZ1bmN0aW9uKCl7dGhyb3cgOH19KX1jYXRjaChlKXtyZXR1cm4gOD09PWV9fSgpLGQ9dSYmZnVuY3Rpb24oKXt0cnl7bmV3IEludDhBcnJheSgxKS53aXRoKC0uNSwxKX1jYXRjaChlKXtyZXR1cm4hMH19KCk7aCgid2l0aCIse3dpdGg6ZnVuY3Rpb24oZSx0KXt2YXIgcj1jKHRoaXMpLG49cyhlKSxoPWkocik/byh0KTordDtyZXR1cm4gYShyLGwociksbixoKX19LndpdGgsIXV8fGQpfSw5NjE3OihlLHQscik9Pnt2YXIgYT1yKDUzOTcpLG49cig1NjEwKSxpPXIoNjE5OCksY3JlYXRlTWV0aG9kPWZ1bmN0aW9uKGUpe3JldHVybiBmdW5jdGlvbih0LHIscyl7dmFyIG89YSh0KSxjPWkobyk7aWYoMD09PWMpcmV0dXJuIWUmJi0xO3ZhciBsLGg9bihzLGMpO2lmKGUmJnIhPXIpe2Zvcig7Yz5oOylpZigobD1vW2grK10pIT1sKXJldHVybiEwfWVsc2UgZm9yKDtjPmg7aCsrKWlmKChlfHxoIGluIG8pJiZvW2hdPT09cilyZXR1cm4gZXx8aHx8MDtyZXR1cm4hZSYmLTF9fTtlLmV4cG9ydHM9e2luY2x1ZGVzOmNyZWF0ZU1ldGhvZCghMCksaW5kZXhPZjpjcmVhdGVNZXRob2QoITEpfX0sOTYzMTooZSx0LHIpPT57cig5NDg2KX0sOTc5NzooZSx0LHIpPT57cig0MjI2KX0sOTgzNTplPT57ZS5leHBvcnRzPWZ1bmN0aW9uKGUpe3RyeXt2YXIgdD1uZXcgU2V0LHI9e3NpemU6MCxoYXM6ZnVuY3Rpb24oKXtyZXR1cm4hMH0sa2V5czpmdW5jdGlvbigpe3JldHVybiBPYmplY3QuZGVmaW5lUHJvcGVydHkoe30sIm5leHQiLHtnZXQ6ZnVuY3Rpb24oKXt0LmNsZWFyKCk7dC5hZGQoNCk7cmV0dXJuIGZ1bmN0aW9uKCl7cmV0dXJue2RvbmU6ITB9fX19KX19LGE9dFtlXShyKTtyZXR1cm4gMT09PWEuc2l6ZSYmND09PWEudmFsdWVzKCkubmV4dCgpLnZhbHVlfWNhdGNoKGUpe3JldHVybiExfX19LDk5Mjg6KGUsdCxyKT0+e3ZhciBhPXIoNjE5OCksbj1yKDEyOTEpLGk9UmFuZ2VFcnJvcjtlLmV4cG9ydHM9ZnVuY3Rpb24oZSx0LHIscyl7dmFyIG89YShlKSxjPW4ociksbD1jPDA/bytjOmM7aWYobD49b3x8bDwwKXRocm93IG5ldyBpKCJJbmNvcnJlY3QgaW5kZXgiKTtmb3IodmFyIGg9bmV3IHQobyksdT0wO3U8bzt1KyspaFt1XT11PT09bD9zOmVbdV07cmV0dXJuIGh9fX0sdD17fTtmdW5jdGlvbiBfX3dlYnBhY2tfcmVxdWlyZV9fKHIpe3ZhciBhPXRbcl07aWYodm9pZCAwIT09YSlyZXR1cm4gYS5leHBvcnRzO3ZhciBuPXRbcl09e2V4cG9ydHM6e319O2Vbcl0uY2FsbChuLmV4cG9ydHMsbixuLmV4cG9ydHMsX193ZWJwYWNrX3JlcXVpcmVfXyk7cmV0dXJuIG4uZXhwb3J0c31fX3dlYnBhY2tfcmVxdWlyZV9fLmQ9KGUsdCk9Pntmb3IodmFyIHIgaW4gdClfX3dlYnBhY2tfcmVxdWlyZV9fLm8odCxyKSYmIV9fd2VicGFja19yZXF1aXJlX18ubyhlLHIpJiZPYmplY3QuZGVmaW5lUHJvcGVydHkoZSxyLHtlbnVtZXJhYmxlOiEwLGdldDp0W3JdfSl9O19fd2VicGFja19yZXF1aXJlX18ubz0oZSx0KT0+T2JqZWN0LnByb3RvdHlwZS5oYXNPd25Qcm9wZXJ0eS5jYWxsKGUsdCk7X193ZWJwYWNrX3JlcXVpcmVfXyg0MTE0KSxfX3dlYnBhY2tfcmVxdWlyZV9fKDY1NzMpLF9fd2VicGFja19yZXF1aXJlX18oODEwMCksX193ZWJwYWNrX3JlcXVpcmVfXyg3OTM2KSxfX3dlYnBhY2tfcmVxdWlyZV9fKDgxMTEpLF9fd2VicGFja19yZXF1aXJlX18oMjQ4OSksX193ZWJwYWNrX3JlcXVpcmVfXygxNzAxKSxfX3dlYnBhY2tfcmVxdWlyZV9fKDM1NzkpLF9fd2VicGFja19yZXF1aXJlX18oNDYyOCksX193ZWJwYWNrX3JlcXVpcmVfXyg3NjQyKSxfX3dlYnBhY2tfcmVxdWlyZV9fKDgwMDQpLF9fd2VicGFja19yZXF1aXJlX18oMzg1MyksX193ZWJwYWNrX3JlcXVpcmVfXyg1ODc2KSxfX3dlYnBhY2tfcmVxdWlyZV9fKDI0NzUpLF9fd2VicGFja19yZXF1aXJlX18oNTAyNCksX193ZWJwYWNrX3JlcXVpcmVfXygxNjk4KSxfX3dlYnBhY2tfcmVxdWlyZV9fKDk1NzcpLF9fd2VicGFja19yZXF1aXJlX18oMTU0OSksX193ZWJwYWNrX3JlcXVpcmVfXyg5Nzk3KSxfX3dlYnBhY2tfcmVxdWlyZV9fKDk2MzEpLF9fd2VicGFja19yZXF1aXJlX18oNTYyMyksX193ZWJwYWNrX3JlcXVpcmVfXygzNjExKSxfX3dlYnBhY2tfcmVxdWlyZV9fKDgyMzcpLF9fd2VicGFja19yZXF1aXJlX18oMTY4OSksX193ZWJwYWNrX3JlcXVpcmVfXyg0MjM1KSxfX3dlYnBhY2tfcmVxdWlyZV9fKDk0MzIpLF9fd2VicGFja19yZXF1aXJlX18oNDk3OSksX193ZWJwYWNrX3JlcXVpcmVfXyg1NzgxKTtjb25zdCByPSEoIm9iamVjdCIhPXR5cGVvZiBwcm9jZXNzfHxwcm9jZXNzKyIiIT0iW29iamVjdCBwcm9jZXNzXSJ8fHByb2Nlc3MudmVyc2lvbnMubnd8fHByb2Nlc3MudmVyc2lvbnMuZWxlY3Ryb24mJnByb2Nlc3MudHlwZSYmImJyb3dzZXIiIT09cHJvY2Vzcy50eXBlKSxhPVsuMDAxLDAsMCwuMDAxLDAsMF0sbj0xLjM1LGk9LjM1LHM9LjI1OTI1OTI1OTI1OTI1OTI0LG89MSxjPTIsbD00LGg9OCx1PTE2LGQ9NjQsZj0xMjgsZz0yNTYscD0icGRmanNfaW50ZXJuYWxfZWRpdG9yXyIsbT0zLGI9OSx5PTEzLHc9MTUseD0xMDEsUz17UFJJTlQ6NCxNT0RJRllfQ09OVEVOVFM6OCxDT1BZOjE2LE1PRElGWV9BTk5PVEFUSU9OUzozMixGSUxMX0lOVEVSQUNUSVZFX0ZPUk1TOjI1NixDT1BZX0ZPUl9BQ0NFU1NJQklMSVRZOjUxMixBU1NFTUJMRToxMDI0LFBSSU5UX0hJR0hfUVVBTElUWToyMDQ4fSxrPTAsQz00LHY9MSxUPTIsTz0zLE09e1RFWFQ6MSxMSU5LOjIsRlJFRVRFWFQ6MyxMSU5FOjQsU1FVQVJFOjUsQ0lSQ0xFOjYsUE9MWUdPTjo3LFBPTFlMSU5FOjgsSElHSExJR0hUOjksVU5ERVJMSU5FOjEwLFNRVUlHR0xZOjExLFNUUklLRU9VVDoxMixTVEFNUDoxMyxDQVJFVDoxNCxJTks6MTUsUE9QVVA6MTYsRklMRUFUVEFDSE1FTlQ6MTcsU09VTkQ6MTgsTU9WSUU6MTksV0lER0VUOjIwLFNDUkVFTjoyMSxQUklOVEVSTUFSSzoyMixUUkFQTkVUOjIzLFdBVEVSTUFSSzoyNCxUSFJFRUQ6MjUsUkVEQUNUOjI2fSxEPSJHcm91cCIsUj0iUiIsRT0xLE49MixfPTQsTD0xNixqPTMyLFU9MTI4LHE9NTEyLFg9MSxIPTIsVz00MDk2LHo9ODE5MixHPTMyNzY4LCQ9NjU1MzYsVj0xMzEwNzIsSz0xMDQ4NTc2LEo9MjA5NzE1MixZPTgzODg2MDgsWj0xNjc3NzIxNixRPTEsZWU9Mix0ZT0zLHJlPTQsYWU9NSxuZT17RToiTW91c2UgRW50ZXIiLFg6Ik1vdXNlIEV4aXQiLEQ6Ik1vdXNlIERvd24iLFU6Ik1vdXNlIFVwIixGbzoiRm9jdXMiLEJsOiJCbHVyIixQTzoiUGFnZU9wZW4iLFBDOiJQYWdlQ2xvc2UiLFBWOiJQYWdlVmlzaWJsZSIsUEk6IlBhZ2VJbnZpc2libGUiLEs6IktleXN0cm9rZSIsRjoiRm9ybWF0IixWOiJWYWxpZGF0ZSIsQzoiQ2FsY3VsYXRlIn0saWU9e1dDOiJXaWxsQ2xvc2UiLFdTOiJXaWxsU2F2ZSIsRFM6IkRpZFNhdmUiLFdQOiJXaWxsUHJpbnQiLERQOiJEaWRQcmludCJ9LHNlPXtPOiJQYWdlT3BlbiIsQzoiUGFnZUNsb3NlIn0sb2U9MSxjZT01LGxlPTEsaGU9Mix1ZT0zLGRlPTQsZmU9NSxnZT02LHBlPTcsbWU9OCxiZT05LHllPTEwLHdlPTExLHhlPTEyLFNlPTEzLEFlPTE0LGtlPTE1LENlPTE2LHZlPTE3LEZlPTE4LEllPTE5LFRlPTIwLE9lPTIxLE1lPTIyLERlPTIzLEJlPTI0LFJlPTI1LEVlPTI2LE5lPTI3LFBlPTI4LF9lPTI5LExlPTMwLGplPTMxLFVlPTMyLHFlPTMzLFhlPTM0LEhlPTM1LFdlPTM2LHplPTM3LEdlPTM4LCRlPTM5LFZlPTQwLEtlPTQxLEplPTQyLFllPTQzLFplPTQ0LFFlPTQ1LGV0PTQ2LHR0PTQ3LHJ0PTQ4LG50PTQ5LGl0PTUwLHN0PTUxLG90PTUyLGN0PTUzLGx0PTU0LGh0PTU1LHV0PTU2LGR0PTU3LGZ0PTU4LGd0PTU5LHB0PTYwLG10PTYxLGJ0PTYyLHl0PTYzLHd0PTY0LHh0PTY1LFN0PTY2LEF0PTY3LGt0PTY4LEN0PTY5LHZ0PTcwLEZ0PTcxLEl0PTcyLFR0PTczLE90PTc0LE10PTc1LER0PTc2LEJ0PTc3LFJ0PTgwLEV0PTgxLE50PTgzLFB0PTg0LF90PTg1LEx0PTg2LGp0PTg3LFV0PTg4LHF0PTg5LFh0PTkwLEh0PTkxLFd0PTkyLHp0PTkzLEd0PTk0LCR0PTAsVnQ9MSxLdD0yLEp0PTMsWXQ9MSxadD0yO2xldCBRdD1vZTtmdW5jdGlvbiBnZXRWZXJib3NpdHlMZXZlbCgpe3JldHVybiBRdH1mdW5jdGlvbiBpbmZvKGUpe1F0Pj1jZSYmY29uc29sZS5pbmZvKGBJbmZvOiAke2V9YCl9ZnVuY3Rpb24gd2FybihlKXtRdD49b2UmJmNvbnNvbGUud2FybihgV2FybmluZzogJHtlfWApfWZ1bmN0aW9uIHVucmVhY2hhYmxlKGUpe3Rocm93IG5ldyBFcnJvcihlKX1mdW5jdGlvbiBhc3NlcnQoZSx0KXtlfHx1bnJlYWNoYWJsZSh0KX1mdW5jdGlvbiBjcmVhdGVWYWxpZEFic29sdXRlVXJsKGUsdD1udWxsLHI9bnVsbCl7aWYoIWUpcmV0dXJuIG51bGw7aWYociYmInN0cmluZyI9PXR5cGVvZiBlKXtpZihyLmFkZERlZmF1bHRQcm90b2NvbCYmZS5zdGFydHNXaXRoKCJ3d3cuIikpe2NvbnN0IHQ9ZS5tYXRjaCgvXC4vZyk7dD8ubGVuZ3RoPj0yJiYoZT1gaHR0cDovLyR7ZX1gKX1pZihyLnRyeUNvbnZlcnRFbmNvZGluZyl0cnl7ZT1zdHJpbmdUb1VURjhTdHJpbmcoZSl9Y2F0Y2h7fX1jb25zdCBhPXQ/VVJMLnBhcnNlKGUsdCk6VVJMLnBhcnNlKGUpO3JldHVybiBmdW5jdGlvbiBfaXNWYWxpZFByb3RvY29sKGUpe3N3aXRjaChlPy5wcm90b2NvbCl7Y2FzZSJodHRwOiI6Y2FzZSJodHRwczoiOmNhc2UiZnRwOiI6Y2FzZSJtYWlsdG86IjpjYXNlInRlbDoiOnJldHVybiEwO2RlZmF1bHQ6cmV0dXJuITF9fShhKT9hOm51bGx9ZnVuY3Rpb24gc2hhZG93KGUsdCxyLGE9ITEpe09iamVjdC5kZWZpbmVQcm9wZXJ0eShlLHQse3ZhbHVlOnIsZW51bWVyYWJsZTohYSxjb25maWd1cmFibGU6ITAsd3JpdGFibGU6ITF9KTtyZXR1cm4gcn1jb25zdCBlcj1mdW5jdGlvbiBCYXNlRXhjZXB0aW9uQ2xvc3VyZSgpe2Z1bmN0aW9uIEJhc2VFeGNlcHRpb24oZSx0KXt0aGlzLm1lc3NhZ2U9ZTt0aGlzLm5hbWU9dH1CYXNlRXhjZXB0aW9uLnByb3RvdHlwZT1uZXcgRXJyb3I7QmFzZUV4Y2VwdGlvbi5jb25zdHJ1Y3Rvcj1CYXNlRXhjZXB0aW9uO3JldHVybiBCYXNlRXhjZXB0aW9ufSgpO2NsYXNzIFBhc3N3b3JkRXhjZXB0aW9uIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSx0KXtzdXBlcihlLCJQYXNzd29yZEV4Y2VwdGlvbiIpO3RoaXMuY29kZT10fX1jbGFzcyBVbmtub3duRXJyb3JFeGNlcHRpb24gZXh0ZW5kcyBlcntjb25zdHJ1Y3RvcihlLHQpe3N1cGVyKGUsIlVua25vd25FcnJvckV4Y2VwdGlvbiIpO3RoaXMuZGV0YWlscz10fX1jbGFzcyBJbnZhbGlkUERGRXhjZXB0aW9uIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSl7c3VwZXIoZSwiSW52YWxpZFBERkV4Y2VwdGlvbiIpfX1jbGFzcyBSZXNwb25zZUV4Y2VwdGlvbiBleHRlbmRzIGVye2NvbnN0cnVjdG9yKGUsdCxyKXtzdXBlcihlLCJSZXNwb25zZUV4Y2VwdGlvbiIpO3RoaXMuc3RhdHVzPXQ7dGhpcy5taXNzaW5nPXJ9fWNsYXNzIEZvcm1hdEVycm9yIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSl7c3VwZXIoZSwiRm9ybWF0RXJyb3IiKX19Y2xhc3MgQWJvcnRFeGNlcHRpb24gZXh0ZW5kcyBlcntjb25zdHJ1Y3RvcihlKXtzdXBlcihlLCJBYm9ydEV4Y2VwdGlvbiIpfX1mdW5jdGlvbiBieXRlc1RvU3RyaW5nKGUpeyJvYmplY3QiPT10eXBlb2YgZSYmdm9pZCAwIT09ZT8ubGVuZ3RofHx1bnJlYWNoYWJsZSgiSW52YWxpZCBhcmd1bWVudCBmb3IgYnl0ZXNUb1N0cmluZyIpO2NvbnN0IHQ9ZS5sZW5ndGgscj04MTkyO2lmKHQ8cilyZXR1cm4gU3RyaW5nLmZyb21DaGFyQ29kZS5hcHBseShudWxsLGUpO2NvbnN0IGE9W107Zm9yKGxldCBuPTA7bjx0O24rPXIpe2NvbnN0IGk9TWF0aC5taW4obityLHQpLHM9ZS5zdWJhcnJheShuLGkpO2EucHVzaChTdHJpbmcuZnJvbUNoYXJDb2RlLmFwcGx5KG51bGwscykpfXJldHVybiBhLmpvaW4oIiIpfWZ1bmN0aW9uIHN0cmluZ1RvQnl0ZXMoZSl7InN0cmluZyIhPXR5cGVvZiBlJiZ1bnJlYWNoYWJsZSgiSW52YWxpZCBhcmd1bWVudCBmb3Igc3RyaW5nVG9CeXRlcyIpO2NvbnN0IHQ9ZS5sZW5ndGgscj1uZXcgVWludDhBcnJheSh0KTtmb3IobGV0IGE9MDthPHQ7KythKXJbYV09MjU1JmUuY2hhckNvZGVBdChhKTtyZXR1cm4gcn1mdW5jdGlvbiBzdHJpbmczMihlKXtyZXR1cm4gU3RyaW5nLmZyb21DaGFyQ29kZShlPj4yNCYyNTUsZT4+MTYmMjU1LGU+PjgmMjU1LDI1NSZlKX1mdW5jdGlvbiBvYmplY3RTaXplKGUpe3JldHVybiBPYmplY3Qua2V5cyhlKS5sZW5ndGh9Y2xhc3MgRmVhdHVyZVRlc3R7c3RhdGljIGdldCBpc0xpdHRsZUVuZGlhbigpe3JldHVybiBzaGFkb3codGhpcywiaXNMaXR0bGVFbmRpYW4iLGZ1bmN0aW9uIGlzTGl0dGxlRW5kaWFuKCl7Y29uc3QgZT1uZXcgVWludDhBcnJheSg0KTtlWzBdPTE7cmV0dXJuIDE9PT1uZXcgVWludDMyQXJyYXkoZS5idWZmZXIsMCwxKVswXX0oKSl9c3RhdGljIGdldCBpc0V2YWxTdXBwb3J0ZWQoKXtyZXR1cm4gc2hhZG93KHRoaXMsImlzRXZhbFN1cHBvcnRlZCIsZnVuY3Rpb24gaXNFdmFsU3VwcG9ydGVkKCl7dHJ5e25ldyBGdW5jdGlvbigiIik7cmV0dXJuITB9Y2F0Y2h7cmV0dXJuITF9fSgpKX1zdGF0aWMgZ2V0IGlzT2Zmc2NyZWVuQ2FudmFzU3VwcG9ydGVkKCl7cmV0dXJuIHNoYWRvdyh0aGlzLCJpc09mZnNjcmVlbkNhbnZhc1N1cHBvcnRlZCIsInVuZGVmaW5lZCIhPXR5cGVvZiBPZmZzY3JlZW5DYW52YXMpfXN0YXRpYyBnZXQgaXNJbWFnZURlY29kZXJTdXBwb3J0ZWQoKXtyZXR1cm4gc2hhZG93KHRoaXMsImlzSW1hZ2VEZWNvZGVyU3VwcG9ydGVkIiwidW5kZWZpbmVkIiE9dHlwZW9mIEltYWdlRGVjb2Rlcil9c3RhdGljIGdldCBwbGF0Zm9ybSgpe2NvbnN0e3BsYXRmb3JtOmUsdXNlckFnZW50OnR9PW5hdmlnYXRvcjtyZXR1cm4gc2hhZG93KHRoaXMsInBsYXRmb3JtIix7aXNBbmRyb2lkOnQuaW5jbHVkZXMoIkFuZHJvaWQiKSxpc0xpbnV4OmUuaW5jbHVkZXMoIkxpbnV4IiksaXNNYWM6ZS5pbmNsdWRlcygiTWFjIiksaXNXaW5kb3dzOmUuaW5jbHVkZXMoIldpbiIpLGlzRmlyZWZveDp0LmluY2x1ZGVzKCJGaXJlZm94Iil9KX1zdGF0aWMgZ2V0IGlzQ1NTUm91bmRTdXBwb3J0ZWQoKXtyZXR1cm4gc2hhZG93KHRoaXMsImlzQ1NTUm91bmRTdXBwb3J0ZWQiLGdsb2JhbFRoaXMuQ1NTPy5zdXBwb3J0cz8uKCJ3aWR0aDogcm91bmQoMS41cHgsIDFweCkiKSl9fWNvbnN0IHRyPUFycmF5LmZyb20oQXJyYXkoMjU2KS5rZXlzKCksZT0+ZS50b1N0cmluZygxNikucGFkU3RhcnQoMiwiMCIpKTtjbGFzcyBVdGlse3N0YXRpYyBtYWtlSGV4Q29sb3IoZSx0LHIpe3JldHVybmAjJHt0cltlXX0ke3RyW3RdfSR7dHJbcl19YH1zdGF0aWMgZG9tTWF0cml4VG9UcmFuc2Zvcm0oZSl7cmV0dXJuW2UuYSxlLmIsZS5jLGUuZCxlLmUsZS5mXX1zdGF0aWMgc2NhbGVNaW5NYXgoZSx0KXtsZXQgcjtpZihlWzBdKXtpZihlWzBdPDApe3I9dFswXTt0WzBdPXRbMl07dFsyXT1yfXRbMF0qPWVbMF07dFsyXSo9ZVswXTtpZihlWzNdPDApe3I9dFsxXTt0WzFdPXRbM107dFszXT1yfXRbMV0qPWVbM107dFszXSo9ZVszXX1lbHNle3I9dFswXTt0WzBdPXRbMV07dFsxXT1yO3I9dFsyXTt0WzJdPXRbM107dFszXT1yO2lmKGVbMV08MCl7cj10WzFdO3RbMV09dFszXTt0WzNdPXJ9dFsxXSo9ZVsxXTt0WzNdKj1lWzFdO2lmKGVbMl08MCl7cj10WzBdO3RbMF09dFsyXTt0WzJdPXJ9dFswXSo9ZVsyXTt0WzJdKj1lWzJdfXRbMF0rPWVbNF07dFsxXSs9ZVs1XTt0WzJdKz1lWzRdO3RbM10rPWVbNV19c3RhdGljIHRyYW5zZm9ybShlLHQpe3JldHVybltlWzBdKnRbMF0rZVsyXSp0WzFdLGVbMV0qdFswXStlWzNdKnRbMV0sZVswXSp0WzJdK2VbMl0qdFszXSxlWzFdKnRbMl0rZVszXSp0WzNdLGVbMF0qdFs0XStlWzJdKnRbNV0rZVs0XSxlWzFdKnRbNF0rZVszXSp0WzVdK2VbNV1dfXN0YXRpYyBtdWx0aXBseUJ5RE9NTWF0cml4KGUsdCl7cmV0dXJuW2VbMF0qdC5hK2VbMl0qdC5iLGVbMV0qdC5hK2VbM10qdC5iLGVbMF0qdC5jK2VbMl0qdC5kLGVbMV0qdC5jK2VbM10qdC5kLGVbMF0qdC5lK2VbMl0qdC5mK2VbNF0sZVsxXSp0LmUrZVszXSp0LmYrZVs1XV19c3RhdGljIGFwcGx5VHJhbnNmb3JtKGUsdCxyPTApe2NvbnN0IGE9ZVtyXSxuPWVbcisxXTtlW3JdPWEqdFswXStuKnRbMl0rdFs0XTtlW3IrMV09YSp0WzFdK24qdFszXSt0WzVdfXN0YXRpYyBhcHBseVRyYW5zZm9ybVRvQmV6aWVyKGUsdCxyPTApe2NvbnN0IGE9dFswXSxuPXRbMV0saT10WzJdLHM9dFszXSxvPXRbNF0sYz10WzVdO2ZvcihsZXQgdD0wO3Q8Njt0Kz0yKXtjb25zdCBsPWVbcit0XSxoPWVbcit0KzFdO2Vbcit0XT1sKmEraCppK287ZVtyK3QrMV09bCpuK2gqcytjfX1zdGF0aWMgYXBwbHlJbnZlcnNlVHJhbnNmb3JtKGUsdCl7Y29uc3Qgcj1lWzBdLGE9ZVsxXSxuPXRbMF0qdFszXS10WzFdKnRbMl07ZVswXT0ocip0WzNdLWEqdFsyXSt0WzJdKnRbNV0tdFs0XSp0WzNdKS9uO2VbMV09KC1yKnRbMV0rYSp0WzBdK3RbNF0qdFsxXS10WzVdKnRbMF0pL259c3RhdGljIGF4aWFsQWxpZ25lZEJvdW5kaW5nQm94KGUsdCxyKXtjb25zdCBhPXRbMF0sbj10WzFdLGk9dFsyXSxzPXRbM10sbz10WzRdLGM9dFs1XSxsPWVbMF0saD1lWzFdLHU9ZVsyXSxkPWVbM107bGV0IGY9YSpsK28sZz1mLHA9YSp1K28sbT1wLGI9cypoK2MseT1iLHc9cypkK2MseD13O2lmKDAhPT1ufHwwIT09aSl7Y29uc3QgZT1uKmwsdD1uKnUscj1pKmgsYT1pKmQ7Zis9cjttKz1yO3ArPWE7Zys9YTtiKz1lO3grPWU7dys9dDt5Kz10fXJbMF09TWF0aC5taW4oclswXSxmLHAsZyxtKTtyWzFdPU1hdGgubWluKHJbMV0sYix3LHkseCk7clsyXT1NYXRoLm1heChyWzJdLGYscCxnLG0pO3JbM109TWF0aC5tYXgoclszXSxiLHcseSx4KX1zdGF0aWMgaW52ZXJzZVRyYW5zZm9ybShlKXtjb25zdCB0PWVbMF0qZVszXS1lWzFdKmVbMl07cmV0dXJuW2VbM10vdCwtZVsxXS90LC1lWzJdL3QsZVswXS90LChlWzJdKmVbNV0tZVs0XSplWzNdKS90LChlWzRdKmVbMV0tZVs1XSplWzBdKS90XX1zdGF0aWMgc2luZ3VsYXJWYWx1ZURlY29tcG9zZTJkU2NhbGUoZSx0KXtjb25zdCByPWVbMF0sYT1lWzFdLG49ZVsyXSxpPWVbM10scz1yKioyK2EqKjIsbz1yKm4rYSppLGM9bioqMitpKioyLGw9KHMrYykvMixoPU1hdGguc3FydChsKioyLShzKmMtbyoqMikpO3RbMF09TWF0aC5zcXJ0KGwraHx8MSk7dFsxXT1NYXRoLnNxcnQobC1ofHwxKX1zdGF0aWMgbm9ybWFsaXplUmVjdChlKXtjb25zdCB0PWUuc2xpY2UoMCk7aWYoZVswXT5lWzJdKXt0WzBdPWVbMl07dFsyXT1lWzBdfWlmKGVbMV0+ZVszXSl7dFsxXT1lWzNdO3RbM109ZVsxXX1yZXR1cm4gdH1zdGF0aWMgaW50ZXJzZWN0KGUsdCl7Y29uc3Qgcj1NYXRoLm1heChNYXRoLm1pbihlWzBdLGVbMl0pLE1hdGgubWluKHRbMF0sdFsyXSkpLGE9TWF0aC5taW4oTWF0aC5tYXgoZVswXSxlWzJdKSxNYXRoLm1heCh0WzBdLHRbMl0pKTtpZihyPmEpcmV0dXJuIG51bGw7Y29uc3Qgbj1NYXRoLm1heChNYXRoLm1pbihlWzFdLGVbM10pLE1hdGgubWluKHRbMV0sdFszXSkpLGk9TWF0aC5taW4oTWF0aC5tYXgoZVsxXSxlWzNdKSxNYXRoLm1heCh0WzFdLHRbM10pKTtyZXR1cm4gbj5pP251bGw6W3IsbixhLGldfXN0YXRpYyBwb2ludEJvdW5kaW5nQm94KGUsdCxyKXtyWzBdPU1hdGgubWluKHJbMF0sZSk7clsxXT1NYXRoLm1pbihyWzFdLHQpO3JbMl09TWF0aC5tYXgoclsyXSxlKTtyWzNdPU1hdGgubWF4KHJbM10sdCl9c3RhdGljIHJlY3RCb3VuZGluZ0JveChlLHQscixhLG4pe25bMF09TWF0aC5taW4oblswXSxlLHIpO25bMV09TWF0aC5taW4oblsxXSx0LGEpO25bMl09TWF0aC5tYXgoblsyXSxlLHIpO25bM109TWF0aC5tYXgoblszXSx0LGEpfXN0YXRpYyNlKGUsdCxyLGEsbixpLHMsbyxjLGwpe2lmKGM8PTB8fGM+PTEpcmV0dXJuO2NvbnN0IGg9MS1jLHU9YypjLGQ9dSpjLGY9aCooaCooaCplKzMqYyp0KSszKnUqcikrZCphLGc9aCooaCooaCpuKzMqYyppKSszKnUqcykrZCpvO2xbMF09TWF0aC5taW4obFswXSxmKTtsWzFdPU1hdGgubWluKGxbMV0sZyk7bFsyXT1NYXRoLm1heChsWzJdLGYpO2xbM109TWF0aC5tYXgobFszXSxnKX1zdGF0aWMjdChlLHQscixhLG4saSxzLG8sYyxsLGgsdSl7aWYoTWF0aC5hYnMoYyk8MWUtMTIpe01hdGguYWJzKGwpPj0xZS0xMiYmdGhpcy4jZShlLHQscixhLG4saSxzLG8sLWgvbCx1KTtyZXR1cm59Y29uc3QgZD1sKioyLTQqaCpjO2lmKGQ8MClyZXR1cm47Y29uc3QgZj1NYXRoLnNxcnQoZCksZz0yKmM7dGhpcy4jZShlLHQscixhLG4saSxzLG8sKC1sK2YpL2csdSk7dGhpcy4jZShlLHQscixhLG4saSxzLG8sKC1sLWYpL2csdSl9c3RhdGljIGJlemllckJvdW5kaW5nQm94KGUsdCxyLGEsbixpLHMsbyxjKXtjWzBdPU1hdGgubWluKGNbMF0sZSxzKTtjWzFdPU1hdGgubWluKGNbMV0sdCxvKTtjWzJdPU1hdGgubWF4KGNbMl0sZSxzKTtjWzNdPU1hdGgubWF4KGNbM10sdCxvKTt0aGlzLiN0KGUscixuLHMsdCxhLGksbywzKigzKihyLW4pLWUrcyksNiooZS0yKnIrbiksMyooci1lKSxjKTt0aGlzLiN0KGUscixuLHMsdCxhLGksbywzKigzKihhLWkpLXQrbyksNioodC0yKmEraSksMyooYS10KSxjKX19Y29uc3QgcnI9WzAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDcyOCw3MTEsNzEwLDcyOSw3MzMsNzMxLDczMCw3MzIsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsODIyNiw4MjI0LDgyMjUsODIzMCw4MjEyLDgyMTEsNDAyLDgyNjAsODI0OSw4MjUwLDg3MjIsODI0MCw4MjIyLDgyMjAsODIyMSw4MjE2LDgyMTcsODIxOCw4NDgyLDY0MjU3LDY0MjU4LDMyMSwzMzgsMzUyLDM3NiwzODEsMzA1LDMyMiwzMzksMzUzLDM4MiwwLDgzNjRdO2Z1bmN0aW9uIHN0cmluZ1RvUERGU3RyaW5nKGUsdD0hMSl7aWYoZVswXT49IsOvIil7bGV0IHI7aWYoIsO+Ij09PWVbMF0mJiLDvyI9PT1lWzFdKXtyPSJ1dGYtMTZiZSI7ZS5sZW5ndGglMj09MSYmKGU9ZS5zbGljZSgwLC0xKSl9ZWxzZSBpZigiw78iPT09ZVswXSYmIsO+Ij09PWVbMV0pe3I9InV0Zi0xNmxlIjtlLmxlbmd0aCUyPT0xJiYoZT1lLnNsaWNlKDAsLTEpKX1lbHNlIsOvIj09PWVbMF0mJiLCuyI9PT1lWzFdJiYiwr8iPT09ZVsyXSYmKHI9InV0Zi04Iik7aWYocil0cnl7Y29uc3QgYT1uZXcgVGV4dERlY29kZXIocix7ZmF0YWw6ITB9KSxuPXN0cmluZ1RvQnl0ZXMoZSksaT1hLmRlY29kZShuKTtyZXR1cm4gdHx8IWkuaW5jbHVkZXMoIhsiKT9pOmkucmVwbGFjZUFsbCgvXHgxYlteXHgxYl0qKD86XHgxYnwkKS9nLCIiKX1jYXRjaChlKXt3YXJuKGBzdHJpbmdUb1BERlN0cmluZzogIiR7ZX0iLmApfX1jb25zdCByPVtdO2ZvcihsZXQgYT0wLG49ZS5sZW5ndGg7YTxuO2ErKyl7Y29uc3QgaT1lLmNoYXJDb2RlQXQoYSk7aWYoIXQmJjI3PT09aSl7Zm9yKDsrK2E8biYmMjchPT1lLmNoYXJDb2RlQXQoYSk7KTtjb250aW51ZX1jb25zdCBzPXJyW2ldO3IucHVzaChzP1N0cmluZy5mcm9tQ2hhckNvZGUocyk6ZS5jaGFyQXQoYSkpfXJldHVybiByLmpvaW4oIiIpfWZ1bmN0aW9uIHN0cmluZ1RvVVRGOFN0cmluZyhlKXtyZXR1cm4gZGVjb2RlVVJJQ29tcG9uZW50KGVzY2FwZShlKSl9ZnVuY3Rpb24gdXRmOFN0cmluZ1RvU3RyaW5nKGUpe3JldHVybiB1bmVzY2FwZShlbmNvZGVVUklDb21wb25lbnQoZSkpfWZ1bmN0aW9uIGlzQXJyYXlFcXVhbChlLHQpe2lmKGUubGVuZ3RoIT09dC5sZW5ndGgpcmV0dXJuITE7Zm9yKGxldCByPTAsYT1lLmxlbmd0aDtyPGE7cisrKWlmKGVbcl0hPT10W3JdKXJldHVybiExO3JldHVybiEwfWZ1bmN0aW9uIGdldE1vZGlmaWNhdGlvbkRhdGUoZT1uZXcgRGF0ZSl7ZSBpbnN0YW5jZW9mIERhdGV8fChlPW5ldyBEYXRlKGUpKTtyZXR1cm5bZS5nZXRVVENGdWxsWWVhcigpLnRvU3RyaW5nKCksKGUuZ2V0VVRDTW9udGgoKSsxKS50b1N0cmluZygpLnBhZFN0YXJ0KDIsIjAiKSxlLmdldFVUQ0RhdGUoKS50b1N0cmluZygpLnBhZFN0YXJ0KDIsIjAiKSxlLmdldFVUQ0hvdXJzKCkudG9TdHJpbmcoKS5wYWRTdGFydCgyLCIwIiksZS5nZXRVVENNaW51dGVzKCkudG9TdHJpbmcoKS5wYWRTdGFydCgyLCIwIiksZS5nZXRVVENTZWNvbmRzKCkudG9TdHJpbmcoKS5wYWRTdGFydCgyLCIwIildLmpvaW4oIiIpfWxldCBhcj1udWxsLG5yPW51bGw7ZnVuY3Rpb24gTWF0aENsYW1wKGUsdCxyKXtyZXR1cm4gTWF0aC5taW4oTWF0aC5tYXgoZSx0KSxyKX1mdW5jdGlvbiB0b0hleFV0aWwoZSl7cmV0dXJuIFVpbnQ4QXJyYXkucHJvdG90eXBlLnRvSGV4P2UudG9IZXgoKTpBcnJheS5mcm9tKGUsZT0+dHJbZV0pLmpvaW4oIiIpfSJmdW5jdGlvbiIhPXR5cGVvZiBNYXRoLnN1bVByZWNpc2UmJihNYXRoLnN1bVByZWNpc2U9ZnVuY3Rpb24oZSl7cmV0dXJuIGUucmVkdWNlKChlLHQpPT5lK3QsMCl9KTsiZnVuY3Rpb24iIT10eXBlb2YgQWJvcnRTaWduYWwuYW55JiYoQWJvcnRTaWduYWwuYW55PWZ1bmN0aW9uKGUpe2NvbnN0IHQ9bmV3IEFib3J0Q29udHJvbGxlcix7c2lnbmFsOnJ9PXQ7Zm9yKGNvbnN0IGEgb2YgZSlpZihhLmFib3J0ZWQpe3QuYWJvcnQoYS5yZWFzb24pO3JldHVybiByfWZvcihjb25zdCBhIG9mIGUpYS5hZGRFdmVudExpc3RlbmVyKCJhYm9ydCIsKCk9Pnt0LmFib3J0KGEucmVhc29uKX0se3NpZ25hbDpyfSk7cmV0dXJuIHJ9KTtfX3dlYnBhY2tfcmVxdWlyZV9fKDExNDgpO2NvbnN0IGlyPVN5bWJvbCgiQ0lSQ1VMQVJfUkVGIiksc3I9U3ltYm9sKCJFT0YiKTtsZXQgb3I9T2JqZWN0LmNyZWF0ZShudWxsKSxjcj1PYmplY3QuY3JlYXRlKG51bGwpLGxyPU9iamVjdC5jcmVhdGUobnVsbCk7Y2xhc3MgTmFtZXtjb25zdHJ1Y3RvcihlKXt0aGlzLm5hbWU9ZX1zdGF0aWMgZ2V0KGUpe3JldHVybiBjcltlXXx8PW5ldyBOYW1lKGUpfX1jbGFzcyBDbWR7Y29uc3RydWN0b3IoZSl7dGhpcy5jbWQ9ZX1zdGF0aWMgZ2V0KGUpe3JldHVybiBvcltlXXx8PW5ldyBDbWQoZSl9fWNvbnN0IGhyPWZ1bmN0aW9uIG5vblNlcmlhbGl6YWJsZUNsb3N1cmUoKXtyZXR1cm4gaHJ9O2NsYXNzIERpY3R7Y29uc3RydWN0b3IoZT1udWxsKXt0aGlzLl9tYXA9bmV3IE1hcDt0aGlzLnhyZWY9ZTt0aGlzLm9iaklkPW51bGw7dGhpcy5zdXBwcmVzc0VuY3J5cHRpb249ITE7dGhpcy5fX25vblNlcmlhbGl6YWJsZV9fPWhyfWFzc2lnblhyZWYoZSl7dGhpcy54cmVmPWV9Z2V0IHNpemUoKXtyZXR1cm4gdGhpcy5fbWFwLnNpemV9Z2V0KGUsdCxyKXtsZXQgYT10aGlzLl9tYXAuZ2V0KGUpO2lmKHZvaWQgMD09PWEmJnZvaWQgMCE9PXQpe2E9dGhpcy5fbWFwLmdldCh0KTt2b2lkIDA9PT1hJiZ2b2lkIDAhPT1yJiYoYT10aGlzLl9tYXAuZ2V0KHIpKX1yZXR1cm4gYSBpbnN0YW5jZW9mIFJlZiYmdGhpcy54cmVmP3RoaXMueHJlZi5mZXRjaChhLHRoaXMuc3VwcHJlc3NFbmNyeXB0aW9uKTphfWFzeW5jIGdldEFzeW5jKGUsdCxyKXtsZXQgYT10aGlzLl9tYXAuZ2V0KGUpO2lmKHZvaWQgMD09PWEmJnZvaWQgMCE9PXQpe2E9dGhpcy5fbWFwLmdldCh0KTt2b2lkIDA9PT1hJiZ2b2lkIDAhPT1yJiYoYT10aGlzLl9tYXAuZ2V0KHIpKX1yZXR1cm4gYSBpbnN0YW5jZW9mIFJlZiYmdGhpcy54cmVmP3RoaXMueHJlZi5mZXRjaEFzeW5jKGEsdGhpcy5zdXBwcmVzc0VuY3J5cHRpb24pOmF9Z2V0QXJyYXkoZSx0LHIpe2xldCBhPXRoaXMuX21hcC5nZXQoZSk7aWYodm9pZCAwPT09YSYmdm9pZCAwIT09dCl7YT10aGlzLl9tYXAuZ2V0KHQpO3ZvaWQgMD09PWEmJnZvaWQgMCE9PXImJihhPXRoaXMuX21hcC5nZXQocikpfWEgaW5zdGFuY2VvZiBSZWYmJnRoaXMueHJlZiYmKGE9dGhpcy54cmVmLmZldGNoKGEsdGhpcy5zdXBwcmVzc0VuY3J5cHRpb24pKTtpZihBcnJheS5pc0FycmF5KGEpKXthPWEuc2xpY2UoKTtmb3IobGV0IGU9MCx0PWEubGVuZ3RoO2U8dDtlKyspYVtlXWluc3RhbmNlb2YgUmVmJiZ0aGlzLnhyZWYmJihhW2VdPXRoaXMueHJlZi5mZXRjaChhW2VdLHRoaXMuc3VwcHJlc3NFbmNyeXB0aW9uKSl9cmV0dXJuIGF9Z2V0UmF3KGUpe3JldHVybiB0aGlzLl9tYXAuZ2V0KGUpfWdldEtleXMoKXtyZXR1cm5bLi4udGhpcy5fbWFwLmtleXMoKV19Z2V0UmF3VmFsdWVzKCl7cmV0dXJuWy4uLnRoaXMuX21hcC52YWx1ZXMoKV19c2V0KGUsdCl7dGhpcy5fbWFwLnNldChlLHQpfXNldElmTm90RXhpc3RzKGUsdCl7dGhpcy5oYXMoZSl8fHRoaXMuc2V0KGUsdCl9c2V0SWZOdW1iZXIoZSx0KXsibnVtYmVyIj09dHlwZW9mIHQmJnRoaXMuc2V0KGUsdCl9c2V0SWZBcnJheShlLHQpeyhBcnJheS5pc0FycmF5KHQpfHxBcnJheUJ1ZmZlci5pc1ZpZXcodCkpJiZ0aGlzLnNldChlLHQpfXNldElmRGVmaW5lZChlLHQpe251bGwhPXQmJnRoaXMuc2V0KGUsdCl9c2V0SWZOYW1lKGUsdCl7InN0cmluZyI9PXR5cGVvZiB0P3RoaXMuc2V0KGUsTmFtZS5nZXQodCkpOnQgaW5zdGFuY2VvZiBOYW1lJiZ0aGlzLnNldChlLHQpfWhhcyhlKXtyZXR1cm4gdGhpcy5fbWFwLmhhcyhlKX0qW1N5bWJvbC5pdGVyYXRvcl0oKXtmb3IoY29uc3RbZSx0XW9mIHRoaXMuX21hcCl5aWVsZFtlLHQgaW5zdGFuY2VvZiBSZWYmJnRoaXMueHJlZj90aGlzLnhyZWYuZmV0Y2godCx0aGlzLnN1cHByZXNzRW5jcnlwdGlvbik6dF19c3RhdGljIGdldCBlbXB0eSgpe2NvbnN0IGU9bmV3IERpY3QobnVsbCk7ZS5zZXQ9KGUsdCk9Pnt1bnJlYWNoYWJsZSgiU2hvdWxkIG5vdCBjYWxsIGBzZXRgIG9uIHRoZSBlbXB0eSBkaWN0aW9uYXJ5LiIpfTtyZXR1cm4gc2hhZG93KHRoaXMsImVtcHR5IixlKX1zdGF0aWMgbWVyZ2Uoe3hyZWY6ZSxkaWN0QXJyYXk6dCxtZXJnZVN1YkRpY3RzOnI9ITF9KXtjb25zdCBhPW5ldyBEaWN0KGUpLG49bmV3IE1hcDtmb3IoY29uc3QgZSBvZiB0KWlmKGUgaW5zdGFuY2VvZiBEaWN0KWZvcihjb25zdFt0LGFdb2YgZS5fbWFwKXtsZXQgZT1uLmdldCh0KTtpZih2b2lkIDA9PT1lKXtlPVtdO24uc2V0KHQsZSl9ZWxzZSBpZighKHImJmEgaW5zdGFuY2VvZiBEaWN0KSljb250aW51ZTtlLnB1c2goYSl9Zm9yKGNvbnN0W3Qscl1vZiBuKXtpZigxPT09ci5sZW5ndGh8fCEoclswXWluc3RhbmNlb2YgRGljdCkpe2EuX21hcC5zZXQodCxyWzBdKTtjb250aW51ZX1jb25zdCBuPW5ldyBEaWN0KGUpO2Zvcihjb25zdCBlIG9mIHIpZm9yKGNvbnN0W3Qscl1vZiBlLl9tYXApbi5fbWFwLmhhcyh0KXx8bi5fbWFwLnNldCh0LHIpO24uc2l6ZT4wJiZhLl9tYXAuc2V0KHQsbil9bi5jbGVhcigpO3JldHVybiBhLnNpemU+MD9hOkRpY3QuZW1wdHl9Y2xvbmUoKXtjb25zdCBlPW5ldyBEaWN0KHRoaXMueHJlZik7Zm9yKGNvbnN0IHQgb2YgdGhpcy5nZXRLZXlzKCkpZS5zZXQodCx0aGlzLmdldFJhdyh0KSk7cmV0dXJuIGV9ZGVsZXRlKGUpe3RoaXMuX21hcC5kZWxldGUoZSl9fWNsYXNzIFJlZntjb25zdHJ1Y3RvcihlLHQpe3RoaXMubnVtPWU7dGhpcy5nZW49dH10b1N0cmluZygpe3JldHVybiAwPT09dGhpcy5nZW4/YCR7dGhpcy5udW19UmA6YCR7dGhpcy5udW19UiR7dGhpcy5nZW59YH1zdGF0aWMgZnJvbVN0cmluZyhlKXtjb25zdCB0PWxyW2VdO2lmKHQpcmV0dXJuIHQ7Y29uc3Qgcj0vXihcZCspUihcZCopJC8uZXhlYyhlKTtyZXR1cm4gciYmIjAiIT09clsxXT9scltlXT1uZXcgUmVmKHBhcnNlSW50KHJbMV0pLHJbMl0/cGFyc2VJbnQoclsyXSk6MCk6bnVsbH1zdGF0aWMgZ2V0KGUsdCl7Y29uc3Qgcj0wPT09dD9gJHtlfVJgOmAke2V9UiR7dH1gO3JldHVybiBscltyXXx8PW5ldyBSZWYoZSx0KX19Y2xhc3MgUmVmU2V0e2NvbnN0cnVjdG9yKGU9bnVsbCl7dGhpcy5fc2V0PW5ldyBTZXQoZT8uX3NldCl9aGFzKGUpe3JldHVybiB0aGlzLl9zZXQuaGFzKGUudG9TdHJpbmcoKSl9cHV0KGUpe3RoaXMuX3NldC5hZGQoZS50b1N0cmluZygpKX1yZW1vdmUoZSl7dGhpcy5fc2V0LmRlbGV0ZShlLnRvU3RyaW5nKCkpfVtTeW1ib2wuaXRlcmF0b3JdKCl7cmV0dXJuIHRoaXMuX3NldC52YWx1ZXMoKX1jbGVhcigpe3RoaXMuX3NldC5jbGVhcigpfX1jbGFzcyBSZWZTZXRDYWNoZXtjb25zdHJ1Y3Rvcigpe3RoaXMuX21hcD1uZXcgTWFwfWdldCBzaXplKCl7cmV0dXJuIHRoaXMuX21hcC5zaXplfWdldChlKXtyZXR1cm4gdGhpcy5fbWFwLmdldChlLnRvU3RyaW5nKCkpfWhhcyhlKXtyZXR1cm4gdGhpcy5fbWFwLmhhcyhlLnRvU3RyaW5nKCkpfXB1dChlLHQpe3RoaXMuX21hcC5zZXQoZS50b1N0cmluZygpLHQpfXB1dEFsaWFzKGUsdCl7dGhpcy5fbWFwLnNldChlLnRvU3RyaW5nKCksdGhpcy5nZXQodCkpfVtTeW1ib2wuaXRlcmF0b3JdKCl7cmV0dXJuIHRoaXMuX21hcC52YWx1ZXMoKX1jbGVhcigpe3RoaXMuX21hcC5jbGVhcigpfSp2YWx1ZXMoKXt5aWVsZCp0aGlzLl9tYXAudmFsdWVzKCl9Kml0ZW1zKCl7Zm9yKGNvbnN0W2UsdF1vZiB0aGlzLl9tYXApeWllbGRbUmVmLmZyb21TdHJpbmcoZSksdF19fWZ1bmN0aW9uIGlzTmFtZShlLHQpe3JldHVybiBlIGluc3RhbmNlb2YgTmFtZSYmKHZvaWQgMD09PXR8fGUubmFtZT09PXQpfWZ1bmN0aW9uIGlzQ21kKGUsdCl7cmV0dXJuIGUgaW5zdGFuY2VvZiBDbWQmJih2b2lkIDA9PT10fHxlLmNtZD09PXQpfWZ1bmN0aW9uIGlzRGljdChlLHQpe3JldHVybiBlIGluc3RhbmNlb2YgRGljdCYmKHZvaWQgMD09PXR8fGlzTmFtZShlLmdldCgiVHlwZSIpLHQpKX1mdW5jdGlvbiBpc1JlZnNFcXVhbChlLHQpe3JldHVybiBlLm51bT09PXQubnVtJiZlLmdlbj09PXQuZ2VufWNsYXNzIEJhc2VTdHJlYW17Z2V0IGxlbmd0aCgpe3VucmVhY2hhYmxlKCJBYnN0cmFjdCBnZXR0ZXIgYGxlbmd0aGAgYWNjZXNzZWQiKX1nZXQgaXNFbXB0eSgpe3VucmVhY2hhYmxlKCJBYnN0cmFjdCBnZXR0ZXIgYGlzRW1wdHlgIGFjY2Vzc2VkIil9Z2V0IGlzRGF0YUxvYWRlZCgpe3JldHVybiBzaGFkb3codGhpcywiaXNEYXRhTG9hZGVkIiwhMCl9Z2V0Qnl0ZSgpe3VucmVhY2hhYmxlKCJBYnN0cmFjdCBtZXRob2QgYGdldEJ5dGVgIGNhbGxlZCIpfWdldEJ5dGVzKGUpe3VucmVhY2hhYmxlKCJBYnN0cmFjdCBtZXRob2QgYGdldEJ5dGVzYCBjYWxsZWQiKX1hc3luYyBnZXRJbWFnZURhdGEoZSx0KXtyZXR1cm4gdGhpcy5nZXRCeXRlcyhlLHQpfWFzeW5jIGFzeW5jR2V0Qnl0ZXMoKXt1bnJlYWNoYWJsZSgiQWJzdHJhY3QgbWV0aG9kIGBhc3luY0dldEJ5dGVzYCBjYWxsZWQiKX1nZXQgaXNBc3luYygpe3JldHVybiExfWdldCBpc0FzeW5jRGVjb2Rlcigpe3JldHVybiExfWdldCBjYW5Bc3luY0RlY29kZUltYWdlRnJvbUJ1ZmZlcigpe3JldHVybiExfWFzeW5jIGdldFRyYW5zZmVyYWJsZUltYWdlKCl7cmV0dXJuIG51bGx9cGVla0J5dGUoKXtjb25zdCBlPXRoaXMuZ2V0Qnl0ZSgpOy0xIT09ZSYmdGhpcy5wb3MtLTtyZXR1cm4gZX1wZWVrQnl0ZXMoZSl7Y29uc3QgdD10aGlzLmdldEJ5dGVzKGUpO3RoaXMucG9zLT10Lmxlbmd0aDtyZXR1cm4gdH1nZXRVaW50MTYoKXtjb25zdCBlPXRoaXMuZ2V0Qnl0ZSgpLHQ9dGhpcy5nZXRCeXRlKCk7cmV0dXJuLTE9PT1lfHwtMT09PXQ/LTE6KGU8PDgpK3R9Z2V0SW50MzIoKXtyZXR1cm4odGhpcy5nZXRCeXRlKCk8PDI0KSsodGhpcy5nZXRCeXRlKCk8PDE2KSsodGhpcy5nZXRCeXRlKCk8PDgpK3RoaXMuZ2V0Qnl0ZSgpfWdldEJ5dGVSYW5nZShlLHQpe3VucmVhY2hhYmxlKCJBYnN0cmFjdCBtZXRob2QgYGdldEJ5dGVSYW5nZWAgY2FsbGVkIil9Z2V0U3RyaW5nKGUpe3JldHVybiBieXRlc1RvU3RyaW5nKHRoaXMuZ2V0Qnl0ZXMoZSkpfXNraXAoZSl7dGhpcy5wb3MrPWV8fDF9cmVzZXQoKXt1bnJlYWNoYWJsZSgiQWJzdHJhY3QgbWV0aG9kIGByZXNldGAgY2FsbGVkIil9bW92ZVN0YXJ0KCl7dW5yZWFjaGFibGUoIkFic3RyYWN0IG1ldGhvZCBgbW92ZVN0YXJ0YCBjYWxsZWQiKX1tYWtlU3ViU3RyZWFtKGUsdCxyPW51bGwpe3VucmVhY2hhYmxlKCJBYnN0cmFjdCBtZXRob2QgYG1ha2VTdWJTdHJlYW1gIGNhbGxlZCIpfWdldEJhc2VTdHJlYW1zKCl7cmV0dXJuIG51bGx9fWNvbnN0IHVyPS9eWzEtOV1cLlxkJC8sZHI9MioqMzEtMSxmcj1bMSwwLDAsMSwwLDBdLGdyPVsiQ29sb3JTcGFjZSIsIkV4dEdTdGF0ZSIsIkZvbnQiLCJQYXR0ZXJuIiwiUHJvcGVydGllcyIsIlNoYWRpbmciLCJYT2JqZWN0Il0scHI9WyJFeHRHU3RhdGUiLCJGb250IiwiUHJvcGVydGllcyIsIlhPYmplY3QiXTtmdW5jdGlvbiBnZXRMb29rdXBUYWJsZUZhY3RvcnkoZSl7bGV0IHQ7cmV0dXJuIGZ1bmN0aW9uKCl7aWYoZSl7dD1PYmplY3QuY3JlYXRlKG51bGwpO2UodCk7ZT1udWxsfXJldHVybiB0fX1jbGFzcyBNaXNzaW5nRGF0YUV4Y2VwdGlvbiBleHRlbmRzIGVye2NvbnN0cnVjdG9yKGUsdCl7c3VwZXIoYE1pc3NpbmcgZGF0YSBbJHtlfSwgJHt0fSlgLCJNaXNzaW5nRGF0YUV4Y2VwdGlvbiIpO3RoaXMuYmVnaW49ZTt0aGlzLmVuZD10fX1jbGFzcyBQYXJzZXJFT0ZFeGNlcHRpb24gZXh0ZW5kcyBlcntjb25zdHJ1Y3RvcihlKXtzdXBlcihlLCJQYXJzZXJFT0ZFeGNlcHRpb24iKX19Y2xhc3MgWFJlZkVudHJ5RXhjZXB0aW9uIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSl7c3VwZXIoZSwiWFJlZkVudHJ5RXhjZXB0aW9uIil9fWNsYXNzIFhSZWZQYXJzZUV4Y2VwdGlvbiBleHRlbmRzIGVye2NvbnN0cnVjdG9yKGUpe3N1cGVyKGUsIlhSZWZQYXJzZUV4Y2VwdGlvbiIpfX1mdW5jdGlvbiBhcnJheUJ1ZmZlcnNUb0J5dGVzKGUpe2NvbnN0IHQ9ZS5sZW5ndGg7aWYoMD09PXQpcmV0dXJuIG5ldyBVaW50OEFycmF5KDApO2lmKDE9PT10KXJldHVybiBuZXcgVWludDhBcnJheShlWzBdKTtsZXQgcj0wO2ZvcihsZXQgYT0wO2E8dDthKyspcis9ZVthXS5ieXRlTGVuZ3RoO2NvbnN0IGE9bmV3IFVpbnQ4QXJyYXkocik7bGV0IG49MDtmb3IobGV0IHI9MDtyPHQ7cisrKXtjb25zdCB0PW5ldyBVaW50OEFycmF5KGVbcl0pO2Euc2V0KHQsbik7bis9dC5ieXRlTGVuZ3RofXJldHVybiBhfWFzeW5jIGZ1bmN0aW9uIGZldGNoQmluYXJ5RGF0YShlKXtjb25zdCB0PWF3YWl0IGZldGNoKGUpO2lmKCF0Lm9rKXRocm93IG5ldyBFcnJvcihgRmFpbGVkIHRvIGZldGNoIGZpbGUgIiR7ZX0iIHdpdGggIiR7dC5zdGF0dXNUZXh0fSIuYCk7cmV0dXJuIG5ldyBVaW50OEFycmF5KGF3YWl0IHQuYXJyYXlCdWZmZXIoKSl9ZnVuY3Rpb24gZ2V0SW5oZXJpdGFibGVQcm9wZXJ0eSh7ZGljdDplLGtleTp0LGdldEFycmF5OnI9ITEsc3RvcFdoZW5Gb3VuZDphPSEwfSl7bGV0IG47Y29uc3QgaT1uZXcgUmVmU2V0O2Zvcig7ZSBpbnN0YW5jZW9mIERpY3QmJighZS5vYmpJZHx8IWkuaGFzKGUub2JqSWQpKTspe2Uub2JqSWQmJmkucHV0KGUub2JqSWQpO2NvbnN0IHM9cj9lLmdldEFycmF5KHQpOmUuZ2V0KHQpO2lmKHZvaWQgMCE9PXMpe2lmKGEpcmV0dXJuIHM7KG58fD1bXSkucHVzaChzKX1lPWUuZ2V0KCJQYXJlbnQiKX1yZXR1cm4gbn1jb25zdCBtcj1bIiIsIkMiLCJDQyIsIkNDQyIsIkNEIiwiRCIsIkRDIiwiRENDIiwiRENDQyIsIkNNIiwiIiwiWCIsIlhYIiwiWFhYIiwiWEwiLCJMIiwiTFgiLCJMWFgiLCJMWFhYIiwiWEMiLCIiLCJJIiwiSUkiLCJJSUkiLCJJViIsIlYiLCJWSSIsIlZJSSIsIlZJSUkiLCJJWCJdO2Z1bmN0aW9uIHRvUm9tYW5OdW1lcmFscyhlLHQ9ITEpe2Fzc2VydChOdW1iZXIuaXNJbnRlZ2VyKGUpJiZlPjAsIlRoZSBudW1iZXIgc2hvdWxkIGJlIGEgcG9zaXRpdmUgaW50ZWdlci4iKTtjb25zdCByPSJNIi5yZXBlYXQoZS8xZTN8MCkrbXJbZSUxZTMvMTAwfDBdK21yWzEwKyhlJTEwMC8xMHwwKV0rbXJbMjArZSUxMF07cmV0dXJuIHQ/ci50b0xvd2VyQ2FzZSgpOnJ9ZnVuY3Rpb24gbG9nMihlKXtyZXR1cm4gZT4wP01hdGguY2VpbChNYXRoLmxvZzIoZSkpOjB9ZnVuY3Rpb24gcmVhZEludDgoZSx0KXtyZXR1cm4gZVt0XTw8MjQ+PjI0fWZ1bmN0aW9uIHJlYWRJbnQxNihlLHQpe3JldHVybihlW3RdPDwyNHxlW3QrMV08PDE2KT4+MTZ9ZnVuY3Rpb24gcmVhZFVpbnQxNihlLHQpe3JldHVybiBlW3RdPDw4fGVbdCsxXX1mdW5jdGlvbiByZWFkVWludDMyKGUsdCl7cmV0dXJuKGVbdF08PDI0fGVbdCsxXTw8MTZ8ZVt0KzJdPDw4fGVbdCszXSk+Pj4wfWZ1bmN0aW9uIGlzV2hpdGVTcGFjZShlKXtyZXR1cm4gMzI9PT1lfHw5PT09ZXx8MTM9PT1lfHwxMD09PWV9ZnVuY3Rpb24gaXNOdW1iZXJBcnJheShlLHQpe3JldHVybiBBcnJheS5pc0FycmF5KGUpPyhudWxsPT09dHx8ZS5sZW5ndGg9PT10KSYmZS5ldmVyeShlPT4ibnVtYmVyIj09dHlwZW9mIGUpOkFycmF5QnVmZmVyLmlzVmlldyhlKSYmIShlIGluc3RhbmNlb2YgQmlnSW50NjRBcnJheXx8ZSBpbnN0YW5jZW9mIEJpZ1VpbnQ2NEFycmF5KSYmKG51bGw9PT10fHxlLmxlbmd0aD09PXQpfWZ1bmN0aW9uIGxvb2t1cE1hdHJpeChlLHQpe3JldHVybiBpc051bWJlckFycmF5KGUsNik/ZTp0fWZ1bmN0aW9uIGxvb2t1cFJlY3QoZSx0KXtyZXR1cm4gaXNOdW1iZXJBcnJheShlLDQpP2U6dH1mdW5jdGlvbiBsb29rdXBOb3JtYWxSZWN0KGUsdCl7cmV0dXJuIGlzTnVtYmVyQXJyYXkoZSw0KT9VdGlsLm5vcm1hbGl6ZVJlY3QoZSk6dH1mdW5jdGlvbiBwYXJzZVhGQVBhdGgoZSl7Y29uc3QgdD0vKC4rKVxbKFxkKylcXSQvO3JldHVybiBlLnNwbGl0KCIuIikubWFwKGU9Pntjb25zdCByPWUubWF0Y2godCk7cmV0dXJuIHI/e25hbWU6clsxXSxwb3M6cGFyc2VJbnQoclsyXSwxMCl9OntuYW1lOmUscG9zOjB9fSl9ZnVuY3Rpb24gZXNjYXBlUERGTmFtZShlKXtjb25zdCB0PVtdO2xldCByPTA7Zm9yKGxldCBhPTAsbj1lLmxlbmd0aDthPG47YSsrKXtjb25zdCBuPWUuY2hhckNvZGVBdChhKTtpZihuPDMzfHxuPjEyNnx8MzU9PT1ufHw0MD09PW58fDQxPT09bnx8NjA9PT1ufHw2Mj09PW58fDkxPT09bnx8OTM9PT1ufHwxMjM9PT1ufHwxMjU9PT1ufHw0Nz09PW58fDM3PT09bil7cjxhJiZ0LnB1c2goZS5zdWJzdHJpbmcocixhKSk7dC5wdXNoKGAjJHtuLnRvU3RyaW5nKDE2KX1gKTtyPWErMX19aWYoMD09PXQubGVuZ3RoKXJldHVybiBlO3I8ZS5sZW5ndGgmJnQucHVzaChlLnN1YnN0cmluZyhyLGUubGVuZ3RoKSk7cmV0dXJuIHQuam9pbigiIil9ZnVuY3Rpb24gZXNjYXBlU3RyaW5nKGUpe3JldHVybiBlLnJlcGxhY2VBbGwoLyhbKClcXFxuXHJdKS9nLGU9PiJcbiI9PT1lPyJcXG4iOiJcciI9PT1lPyJcXHIiOmBcXCR7ZX1gKX1mdW5jdGlvbiBfY29sbGVjdEpTKGUsdCxyLGEpe2lmKCFlKXJldHVybjtsZXQgbj1udWxsO2lmKGUgaW5zdGFuY2VvZiBSZWYpe2lmKGEuaGFzKGUpKXJldHVybjtuPWU7YS5wdXQobik7ZT10LmZldGNoKGUpfWlmKEFycmF5LmlzQXJyYXkoZSkpZm9yKGNvbnN0IG4gb2YgZSlfY29sbGVjdEpTKG4sdCxyLGEpO2Vsc2UgaWYoZSBpbnN0YW5jZW9mIERpY3Qpe2lmKGlzTmFtZShlLmdldCgiUyIpLCJKYXZhU2NyaXB0Iikpe2NvbnN0IHQ9ZS5nZXQoIkpTIik7bGV0IGE7dCBpbnN0YW5jZW9mIEJhc2VTdHJlYW0/YT10LmdldFN0cmluZygpOiJzdHJpbmciPT10eXBlb2YgdCYmKGE9dCk7YSYmPXN0cmluZ1RvUERGU3RyaW5nKGEsITApLnJlcGxhY2VBbGwoIlwwIiwiIik7YSYmci5wdXNoKGEudHJpbSgpKX1fY29sbGVjdEpTKGUuZ2V0UmF3KCJOZXh0IiksdCxyLGEpfW4mJmEucmVtb3ZlKG4pfWZ1bmN0aW9uIGNvbGxlY3RBY3Rpb25zKGUsdCxyKXtjb25zdCBhPU9iamVjdC5jcmVhdGUobnVsbCksbj1nZXRJbmhlcml0YWJsZVByb3BlcnR5KHtkaWN0OnQsa2V5OiJBQSIsc3RvcFdoZW5Gb3VuZDohMX0pO2lmKG4pZm9yKGxldCB0PW4ubGVuZ3RoLTE7dD49MDt0LS0pe2NvbnN0IGk9blt0XTtpZihpIGluc3RhbmNlb2YgRGljdClmb3IoY29uc3QgdCBvZiBpLmdldEtleXMoKSl7Y29uc3Qgbj1yW3RdO2lmKCFuKWNvbnRpbnVlO2NvbnN0IHM9W107X2NvbGxlY3RKUyhpLmdldFJhdyh0KSxlLHMsbmV3IFJlZlNldCk7cy5sZW5ndGg+MCYmKGFbbl09cyl9fWlmKHQuaGFzKCJBIikpe2NvbnN0IHI9W107X2NvbGxlY3RKUyh0LmdldCgiQSIpLGUscixuZXcgUmVmU2V0KTtyLmxlbmd0aD4wJiYoYS5BY3Rpb249cil9cmV0dXJuIG9iamVjdFNpemUoYSk+MD9hOm51bGx9Y29uc3QgYnI9ezYwOiImbHQ7Iiw2MjoiJmd0OyIsMzg6IiZhbXA7IiwzNDoiJnF1b3Q7IiwzOToiJmFwb3M7In07ZnVuY3Rpb24qY29kZVBvaW50SXRlcihlKXtmb3IobGV0IHQ9MCxyPWUubGVuZ3RoO3Q8cjt0Kyspe2NvbnN0IHI9ZS5jb2RlUG9pbnRBdCh0KTtyPjU1Mjk1JiYocjw1NzM0NHx8cj42NTUzMykmJnQrKzt5aWVsZCByfX1mdW5jdGlvbiBlbmNvZGVUb1htbFN0cmluZyhlKXtjb25zdCB0PVtdO2xldCByPTA7Zm9yKGxldCBhPTAsbj1lLmxlbmd0aDthPG47YSsrKXtjb25zdCBuPWUuY29kZVBvaW50QXQoYSk7aWYoMzI8PW4mJm48PTEyNil7Y29uc3QgaT1icltuXTtpZihpKXtyPGEmJnQucHVzaChlLnN1YnN0cmluZyhyLGEpKTt0LnB1c2goaSk7cj1hKzF9fWVsc2V7cjxhJiZ0LnB1c2goZS5zdWJzdHJpbmcocixhKSk7dC5wdXNoKGAmI3gke24udG9TdHJpbmcoMTYpLnRvVXBwZXJDYXNlKCl9O2ApO24+NTUyOTUmJihuPDU3MzQ0fHxuPjY1NTMzKSYmYSsrO3I9YSsxfX1pZigwPT09dC5sZW5ndGgpcmV0dXJuIGU7cjxlLmxlbmd0aCYmdC5wdXNoKGUuc3Vic3RyaW5nKHIsZS5sZW5ndGgpKTtyZXR1cm4gdC5qb2luKCIiKX1mdW5jdGlvbiB2YWxpZGF0ZUZvbnROYW1lKGUsdD0hMSl7Y29uc3Qgcj0vXigifCcpLiooInwnKSQvLmV4ZWMoZSk7aWYociYmclsxXT09PXJbMl0pe2lmKG5ldyBSZWdFeHAoYFteXFxcXF0ke3JbMV19YCkudGVzdChlLnNsaWNlKDEsLTEpKSl7dCYmd2FybihgRm9udEZhbWlseSBjb250YWlucyB1bmVzY2FwZWQgJHtyWzFdfTogJHtlfS5gKTtyZXR1cm4hMX19ZWxzZSBmb3IoY29uc3QgciBvZiBlLnNwbGl0KC9bIFx0XSsvKSlpZigvXihcZHwoLShcZHwtKSkpLy50ZXN0KHIpfHwhL15bXHctXFxdKyQvLnRlc3Qocikpe3QmJndhcm4oYEZvbnRGYW1pbHkgY29udGFpbnMgaW52YWxpZCA8Y3VzdG9tLWlkZW50PjogJHtlfS5gKTtyZXR1cm4hMX1yZXR1cm4hMH1mdW5jdGlvbiB2YWxpZGF0ZUNTU0ZvbnQoZSl7Y29uc3QgdD1uZXcgU2V0KFsiMTAwIiwiMjAwIiwiMzAwIiwiNDAwIiwiNTAwIiwiNjAwIiwiNzAwIiwiODAwIiwiOTAwIiwiMTAwMCIsIm5vcm1hbCIsImJvbGQiLCJib2xkZXIiLCJsaWdodGVyIl0pLHtmb250RmFtaWx5OnIsZm9udFdlaWdodDphLGl0YWxpY0FuZ2xlOm59PWU7aWYoIXZhbGlkYXRlRm9udE5hbWUociwhMCkpcmV0dXJuITE7Y29uc3QgaT1hP2EudG9TdHJpbmcoKToiIjtlLmZvbnRXZWlnaHQ9dC5oYXMoaSk/aToiNDAwIjtjb25zdCBzPXBhcnNlRmxvYXQobik7ZS5pdGFsaWNBbmdsZT1pc05hTihzKXx8czwtOTB8fHM+OTA/IjE0IjpuLnRvU3RyaW5nKCk7cmV0dXJuITB9ZnVuY3Rpb24gcmVjb3ZlckpzVVJMKGUpe2NvbnN0IHQ9bmV3IFJlZ0V4cCgiXlxccyooIitbImFwcC5sYXVuY2hVUkwiLCJ3aW5kb3cub3BlbiIsInhmYS5ob3N0LmdvdG9VUkwiXS5qb2luKCJ8IikucmVwbGFjZUFsbCgiLiIsIlxcLiIpKyIpXFwoKD86J3xcIikoW14nXCJdKikoPzonfFwiKSg/OixcXHMqKFxcdyspXFwpfFxcKSkiLCJpIikuZXhlYyhlKTtyZXR1cm4gdD8uWzJdP3t1cmw6dFsyXSxuZXdXaW5kb3c6ImFwcC5sYXVuY2hVUkwiPT09dFsxXSYmInRydWUiPT09dFszXX06bnVsbH1mdW5jdGlvbiBudW1iZXJUb1N0cmluZyhlKXtpZihOdW1iZXIuaXNJbnRlZ2VyKGUpKXJldHVybiBlLnRvU3RyaW5nKCk7Y29uc3QgdD1NYXRoLnJvdW5kKDEwMCplKTtyZXR1cm4gdCUxMDA9PTA/KHQvMTAwKS50b1N0cmluZygpOnQlMTA9PTA/ZS50b0ZpeGVkKDEpOmUudG9GaXhlZCgyKX1mdW5jdGlvbiBnZXROZXdBbm5vdGF0aW9uc01hcChlKXtpZighZSlyZXR1cm4gbnVsbDtjb25zdCB0PW5ldyBNYXA7Zm9yKGNvbnN0W3IsYV1vZiBlKXtpZighci5zdGFydHNXaXRoKHApKWNvbnRpbnVlO2xldCBlPXQuZ2V0KGEucGFnZUluZGV4KTtpZighZSl7ZT1bXTt0LnNldChhLnBhZ2VJbmRleCxlKX1lLnB1c2goYSl9cmV0dXJuIHQuc2l6ZT4wP3Q6bnVsbH1mdW5jdGlvbiBzdHJpbmdUb0FzY2lpT3JVVEYxNkJFKGUpe3JldHVybiBudWxsPT1lfHxmdW5jdGlvbiBpc0FzY2lpKGUpe2lmKCJzdHJpbmciIT10eXBlb2YgZSlyZXR1cm4hMTtyZXR1cm4hZXx8L15bXHgwMC1ceDdGXSokLy50ZXN0KGUpfShlKT9lOnN0cmluZ1RvVVRGMTZTdHJpbmcoZSwhMCl9ZnVuY3Rpb24gc3RyaW5nVG9VVEYxNkhleFN0cmluZyhlKXtjb25zdCB0PVtdO2ZvcihsZXQgcj0wLGE9ZS5sZW5ndGg7cjxhO3IrKyl7Y29uc3QgYT1lLmNoYXJDb2RlQXQocik7dC5wdXNoKHRyW2E+PjgmMjU1XSx0clsyNTUmYV0pfXJldHVybiB0LmpvaW4oIiIpfWZ1bmN0aW9uIHN0cmluZ1RvVVRGMTZTdHJpbmcoZSx0PSExKXtjb25zdCByPVtdO3QmJnIucHVzaCgiw77DvyIpO2ZvcihsZXQgdD0wLGE9ZS5sZW5ndGg7dDxhO3QrKyl7Y29uc3QgYT1lLmNoYXJDb2RlQXQodCk7ci5wdXNoKFN0cmluZy5mcm9tQ2hhckNvZGUoYT4+OCYyNTUpLFN0cmluZy5mcm9tQ2hhckNvZGUoMjU1JmEpKX1yZXR1cm4gci5qb2luKCIiKX1mdW5jdGlvbiBnZXRSb3RhdGlvbk1hdHJpeChlLHQscil7c3dpdGNoKGUpe2Nhc2UgOTA6cmV0dXJuWzAsMSwtMSwwLHQsMF07Y2FzZSAxODA6cmV0dXJuWy0xLDAsMCwtMSx0LHJdO2Nhc2UgMjcwOnJldHVyblswLC0xLDEsMCwwLHJdO2RlZmF1bHQ6dGhyb3cgbmV3IEVycm9yKCJJbnZhbGlkIHJvdGF0aW9uIil9fWZ1bmN0aW9uIGdldFNpemVJbkJ5dGVzKGUpe3JldHVybiBNYXRoLmNlaWwoTWF0aC5jZWlsKE1hdGgubG9nMigxK2UpKS84KX1fX3dlYnBhY2tfcmVxdWlyZV9fKDQ2MDMpLF9fd2VicGFja19yZXF1aXJlX18oNzU2NiksX193ZWJwYWNrX3JlcXVpcmVfXyg4NzIxKTtjbGFzcyBRQ01Te3N0YXRpYyNyPW51bGw7c3RhdGljIF9tZW1vcnk9bnVsbDtzdGF0aWMgX211c3RBZGRBbHBoYT0hMTtzdGF0aWMgX2Rlc3RCdWZmZXI9bnVsbDtzdGF0aWMgX2Rlc3RPZmZzZXQ9MDtzdGF0aWMgX2Rlc3RMZW5ndGg9MDtzdGF0aWMgX2Nzc0NvbG9yPSIiO3N0YXRpYyBfbWFrZUhleENvbG9yPW51bGw7c3RhdGljIGdldCBfbWVtb3J5QXJyYXkoKXtjb25zdCBlPXRoaXMuI3I7cmV0dXJuIGU/LmJ5dGVMZW5ndGg/ZTp0aGlzLiNyPW5ldyBVaW50OEFycmF5KHRoaXMuX21lbW9yeS5idWZmZXIpfX1sZXQgeXI7Y29uc3Qgd3I9InVuZGVmaW5lZCIhPXR5cGVvZiBUZXh0RGVjb2Rlcj9uZXcgVGV4dERlY29kZXIoInV0Zi04Iix7aWdub3JlQk9NOiEwLGZhdGFsOiEwfSk6e2RlY29kZTooKT0+e3Rocm93IEVycm9yKCJUZXh0RGVjb2RlciBub3QgYXZhaWxhYmxlIil9fTsidW5kZWZpbmVkIiE9dHlwZW9mIFRleHREZWNvZGVyJiZ3ci5kZWNvZGUoKTtsZXQgeHI9bnVsbDtmdW5jdGlvbiBnZXRVaW50OEFycmF5TWVtb3J5MCgpe251bGwhPT14ciYmMCE9PXhyLmJ5dGVMZW5ndGh8fCh4cj1uZXcgVWludDhBcnJheSh5ci5tZW1vcnkuYnVmZmVyKSk7cmV0dXJuIHhyfWxldCBTcj0wO2Z1bmN0aW9uIHBhc3NBcnJheThUb1dhc20wKGUsdCl7Y29uc3Qgcj10KDEqZS5sZW5ndGgsMSk+Pj4wO2dldFVpbnQ4QXJyYXlNZW1vcnkwKCkuc2V0KGUsci8xKTtTcj1lLmxlbmd0aDtyZXR1cm4gcn1jb25zdCBBcj1PYmplY3QuZnJlZXplKHtSR0I4OjAsMDoiUkdCOCIsUkdCQTg6MSwxOiJSR0JBOCIsQkdSQTg6MiwyOiJCR1JBOCIsR3JheTg6MywzOiJHcmF5OCIsR3JheUE4OjQsNDoiR3JheUE4IixDTVlLOjUsNToiQ01ZSyJ9KSxrcj1PYmplY3QuZnJlZXplKHtQZXJjZXB0dWFsOjAsMDoiUGVyY2VwdHVhbCIsUmVsYXRpdmVDb2xvcmltZXRyaWM6MSwxOiJSZWxhdGl2ZUNvbG9yaW1ldHJpYyIsU2F0dXJhdGlvbjoyLDI6IlNhdHVyYXRpb24iLEFic29sdXRlQ29sb3JpbWV0cmljOjMsMzoiQWJzb2x1dGVDb2xvcmltZXRyaWMifSk7ZnVuY3Rpb24gX193YmdfZ2V0X2ltcG9ydHMoKXtjb25zdCBlPXt3Ymc6e319O2Uud2JnLl9fd2JnX2NvcHlyZXN1bHRfYjA4ZWU3ZDI3M2YyOTVkZD1mdW5jdGlvbihlLHQpeyFmdW5jdGlvbiBjb3B5X3Jlc3VsdChlLHQpe2NvbnN0e19tdXN0QWRkQWxwaGE6cixfZGVzdEJ1ZmZlcjphLF9kZXN0T2Zmc2V0Om4sX2Rlc3RMZW5ndGg6aSxfbWVtb3J5QXJyYXk6c309UUNNUztpZih0IT09aSlpZihyKWZvcihsZXQgcj1lLGk9ZSt0LG89bjtyPGk7cis9MyxvKz00KXthW29dPXNbcl07YVtvKzFdPXNbcisxXTthW28rMl09c1tyKzJdO2FbbyszXT0yNTV9ZWxzZSBmb3IobGV0IHI9ZSxpPWUrdCxvPW47cjxpO3IrPTMsbys9NCl7YVtvXT1zW3JdO2FbbysxXT1zW3IrMV07YVtvKzJdPXNbcisyXX1lbHNlIGEuc2V0KHMuc3ViYXJyYXkoZSxlK3QpLG4pfShlPj4+MCx0Pj4+MCl9O2Uud2JnLl9fd2JnX2NvcHlyZ2JfZDYwY2UxN2JiMDVkOWI2Nz1mdW5jdGlvbihlKXshZnVuY3Rpb24gY29weV9yZ2IoZSl7Y29uc3R7X2Rlc3RCdWZmZXI6dCxfZGVzdE9mZnNldDpyLF9tZW1vcnlBcnJheTphfT1RQ01TO3Rbcl09YVtlXTt0W3IrMV09YVtlKzFdO3RbcisyXT1hW2UrMl19KGU+Pj4wKX07ZS53YmcuX193YmdfbWFrZWNzc1JHQl84OTNiZjBjZDlmZGIzMDJkPWZ1bmN0aW9uKGUpeyFmdW5jdGlvbiBtYWtlX2Nzc1JHQihlKXtjb25zdHtfbWVtb3J5QXJyYXk6dH09UUNNUztRQ01TLl9jc3NDb2xvcj1RQ01TLl9tYWtlSGV4Q29sb3IodFtlXSx0W2UrMV0sdFtlKzJdKX0oZT4+PjApfTtlLndiZy5fX3diaW5kZ2VuX2luaXRfZXh0ZXJucmVmX3RhYmxlPWZ1bmN0aW9uKCl7Y29uc3QgZT15ci5fX3diaW5kZ2VuX2V4cG9ydF8wLHQ9ZS5ncm93KDQpO2Uuc2V0KDAsdm9pZCAwKTtlLnNldCh0KzAsdm9pZCAwKTtlLnNldCh0KzEsbnVsbCk7ZS5zZXQodCsyLCEwKTtlLnNldCh0KzMsITEpfTtlLndiZy5fX3diaW5kZ2VuX3Rocm93PWZ1bmN0aW9uKGUsdCl7dGhyb3cgbmV3IEVycm9yKGZ1bmN0aW9uIGdldFN0cmluZ0Zyb21XYXNtMChlLHQpe2U+Pj49MDtyZXR1cm4gd3IuZGVjb2RlKGdldFVpbnQ4QXJyYXlNZW1vcnkwKCkuc3ViYXJyYXkoZSxlK3QpKX0oZSx0KSl9O3JldHVybiBlfWZ1bmN0aW9uIF9fd2JnX2ZpbmFsaXplX2luaXQoZSx0KXt5cj1lLmV4cG9ydHM7X193YmdfaW5pdC5fX3diaW5kZ2VuX3dhc21fbW9kdWxlPXQ7eHI9bnVsbDt5ci5fX3diaW5kZ2VuX3N0YXJ0KCk7cmV0dXJuIHlyfWFzeW5jIGZ1bmN0aW9uIF9fd2JnX2luaXQoZSl7aWYodm9pZCAwIT09eXIpcmV0dXJuIHlyO3ZvaWQgMCE9PWUmJihPYmplY3QuZ2V0UHJvdG90eXBlT2YoZSk9PT1PYmplY3QucHJvdG90eXBlPyh7bW9kdWxlX29yX3BhdGg6ZX09ZSk6Y29uc29sZS53YXJuKCJ1c2luZyBkZXByZWNhdGVkIHBhcmFtZXRlcnMgZm9yIHRoZSBpbml0aWFsaXphdGlvbiBmdW5jdGlvbjsgcGFzcyBhIHNpbmdsZSBvYmplY3QgaW5zdGVhZCIpKTtjb25zdCB0PV9fd2JnX2dldF9pbXBvcnRzKCk7KCJzdHJpbmciPT10eXBlb2YgZXx8ImZ1bmN0aW9uIj09dHlwZW9mIFJlcXVlc3QmJmUgaW5zdGFuY2VvZiBSZXF1ZXN0fHwiZnVuY3Rpb24iPT10eXBlb2YgVVJMJiZlIGluc3RhbmNlb2YgVVJMKSYmKGU9ZmV0Y2goZSkpO2NvbnN0e2luc3RhbmNlOnIsbW9kdWxlOmF9PWF3YWl0IGFzeW5jIGZ1bmN0aW9uIF9fd2JnX2xvYWQoZSx0KXtpZigiZnVuY3Rpb24iPT10eXBlb2YgUmVzcG9uc2UmJmUgaW5zdGFuY2VvZiBSZXNwb25zZSl7aWYoImZ1bmN0aW9uIj09dHlwZW9mIFdlYkFzc2VtYmx5Lmluc3RhbnRpYXRlU3RyZWFtaW5nKXRyeXtyZXR1cm4gYXdhaXQgV2ViQXNzZW1ibHkuaW5zdGFudGlhdGVTdHJlYW1pbmcoZSx0KX1jYXRjaCh0KXtpZigiYXBwbGljYXRpb24vd2FzbSI9PWUuaGVhZGVycy5nZXQoIkNvbnRlbnQtVHlwZSIpKXRocm93IHQ7Y29uc29sZS53YXJuKCJgV2ViQXNzZW1ibHkuaW5zdGFudGlhdGVTdHJlYW1pbmdgIGZhaWxlZCBiZWNhdXNlIHlvdXIgc2VydmVyIGRvZXMgbm90IHNlcnZlIFdhc20gd2l0aCBgYXBwbGljYXRpb24vd2FzbWAgTUlNRSB0eXBlLiBGYWxsaW5nIGJhY2sgdG8gYFdlYkFzc2VtYmx5Lmluc3RhbnRpYXRlYCB3aGljaCBpcyBzbG93ZXIuIE9yaWdpbmFsIGVycm9yOlxuIix0KX1jb25zdCByPWF3YWl0IGUuYXJyYXlCdWZmZXIoKTtyZXR1cm4gYXdhaXQgV2ViQXNzZW1ibHkuaW5zdGFudGlhdGUocix0KX17Y29uc3Qgcj1hd2FpdCBXZWJBc3NlbWJseS5pbnN0YW50aWF0ZShlLHQpO3JldHVybiByIGluc3RhbmNlb2YgV2ViQXNzZW1ibHkuSW5zdGFuY2U/e2luc3RhbmNlOnIsbW9kdWxlOmV9OnJ9fShhd2FpdCBlLHQpO3JldHVybiBfX3diZ19maW5hbGl6ZV9pbml0KHIsYSl9Y2xhc3MgQ29sb3JTcGFjZXtzdGF0aWMjYT1uZXcgVWludDhDbGFtcGVkQXJyYXkoMyk7Y29uc3RydWN0b3IoZSx0KXt0aGlzLm5hbWU9ZTt0aGlzLm51bUNvbXBzPXR9Z2V0UmdiKGUsdCxyPW5ldyBVaW50OENsYW1wZWRBcnJheSgzKSl7dGhpcy5nZXRSZ2JJdGVtKGUsdCxyLDApO3JldHVybiByfWdldFJnYkhleChlLHQpe2NvbnN0IHI9dGhpcy5nZXRSZ2IoZSx0LENvbG9yU3BhY2UuI2EpO3JldHVybiBVdGlsLm1ha2VIZXhDb2xvcihyWzBdLHJbMV0sclsyXSl9Z2V0UmdiSXRlbShlLHQscixhKXt1bnJlYWNoYWJsZSgiU2hvdWxkIG5vdCBjYWxsIENvbG9yU3BhY2UuZ2V0UmdiSXRlbSIpfWdldFJnYkJ1ZmZlcihlLHQscixhLG4saSxzKXt1bnJlYWNoYWJsZSgiU2hvdWxkIG5vdCBjYWxsIENvbG9yU3BhY2UuZ2V0UmdiQnVmZmVyIil9Z2V0T3V0cHV0TGVuZ3RoKGUsdCl7dW5yZWFjaGFibGUoIlNob3VsZCBub3QgY2FsbCBDb2xvclNwYWNlLmdldE91dHB1dExlbmd0aCIpfWlzUGFzc3Rocm91Z2goZSl7cmV0dXJuITF9aXNEZWZhdWx0RGVjb2RlKGUsdCl7cmV0dXJuIENvbG9yU3BhY2UuaXNEZWZhdWx0RGVjb2RlKGUsdGhpcy5udW1Db21wcyl9ZmlsbFJnYihlLHQscixhLG4saSxzLG8sYyl7Y29uc3QgbD10KnI7bGV0IGg9bnVsbDtjb25zdCB1PTE8PHMsZD1yIT09bnx8dCE9PWE7aWYodGhpcy5pc1Bhc3N0aHJvdWdoKHMpKWg9bztlbHNlIGlmKDE9PT10aGlzLm51bUNvbXBzJiZsPnUmJiJEZXZpY2VHcmF5IiE9PXRoaXMubmFtZSYmIkRldmljZVJHQiIhPT10aGlzLm5hbWUpe2NvbnN0IHQ9czw9OD9uZXcgVWludDhBcnJheSh1KTpuZXcgVWludDE2QXJyYXkodSk7Zm9yKGxldCBlPTA7ZTx1O2UrKyl0W2VdPWU7Y29uc3Qgcj1uZXcgVWludDhDbGFtcGVkQXJyYXkoMyp1KTt0aGlzLmdldFJnYkJ1ZmZlcih0LDAsdSxyLDAscywwKTtpZihkKXtoPW5ldyBVaW50OEFycmF5KDMqbCk7bGV0IGU9MDtmb3IobGV0IHQ9MDt0PGw7Kyt0KXtjb25zdCBhPTMqb1t0XTtoW2UrK109clthXTtoW2UrK109clthKzFdO2hbZSsrXT1yW2ErMl19fWVsc2V7bGV0IHQ9MDtmb3IobGV0IGE9MDthPGw7KythKXtjb25zdCBuPTMqb1thXTtlW3QrK109cltuXTtlW3QrK109cltuKzFdO2VbdCsrXT1yW24rMl07dCs9Y319fWVsc2UgaWYoZCl7aD1uZXcgVWludDhDbGFtcGVkQXJyYXkoMypsKTt0aGlzLmdldFJnYkJ1ZmZlcihvLDAsbCxoLDAscywwKX1lbHNlIHRoaXMuZ2V0UmdiQnVmZmVyKG8sMCxhKmksZSwwLHMsYyk7aWYoaClpZihkKSFmdW5jdGlvbiByZXNpemVSZ2JJbWFnZShlLHQscixhLG4saSxzKXtzPTEhPT1zPzA6cztjb25zdCBvPXIvbixjPWEvaTtsZXQgbCxoPTA7Y29uc3QgdT1uZXcgVWludDE2QXJyYXkobiksZD0zKnI7Zm9yKGxldCBlPTA7ZTxuO2UrKyl1W2VdPTMqTWF0aC5mbG9vcihlKm8pO2ZvcihsZXQgcj0wO3I8aTtyKyspe2NvbnN0IGE9TWF0aC5mbG9vcihyKmMpKmQ7Zm9yKGxldCByPTA7cjxuO3IrKyl7bD1hK3Vbcl07dFtoKytdPWVbbCsrXTt0W2grK109ZVtsKytdO3RbaCsrXT1lW2wrK107aCs9c319fShoLGUsdCxyLGEsbixjKTtlbHNle2xldCB0PTAscj0wO2ZvcihsZXQgbj0wLHM9YSppO248cztuKyspe2VbdCsrXT1oW3IrK107ZVt0KytdPWhbcisrXTtlW3QrK109aFtyKytdO3QrPWN9fX1nZXQgdXNlc1plcm9Ub09uZVJhbmdlKCl7cmV0dXJuIHNoYWRvdyh0aGlzLCJ1c2VzWmVyb1RvT25lUmFuZ2UiLCEwKX1zdGF0aWMgaXNEZWZhdWx0RGVjb2RlKGUsdCl7aWYoIUFycmF5LmlzQXJyYXkoZSkpcmV0dXJuITA7aWYoMip0IT09ZS5sZW5ndGgpe3dhcm4oIlRoZSBkZWNvZGUgbWFwIGlzIG5vdCB0aGUgY29ycmVjdCBsZW5ndGgiKTtyZXR1cm4hMH1mb3IobGV0IHQ9MCxyPWUubGVuZ3RoO3Q8cjt0Kz0yKWlmKDAhPT1lW3RdfHwxIT09ZVt0KzFdKXJldHVybiExO3JldHVybiEwfX1jbGFzcyBBbHRlcm5hdGVDUyBleHRlbmRzIENvbG9yU3BhY2V7Y29uc3RydWN0b3IoZSx0LHIpe3N1cGVyKCJBbHRlcm5hdGUiLGUpO3RoaXMuYmFzZT10O3RoaXMudGludEZuPXI7dGhpcy50bXBCdWY9bmV3IEZsb2F0MzJBcnJheSh0Lm51bUNvbXBzKX1nZXRSZ2JJdGVtKGUsdCxyLGEpe2NvbnN0IG49dGhpcy50bXBCdWY7dGhpcy50aW50Rm4oZSx0LG4sMCk7dGhpcy5iYXNlLmdldFJnYkl0ZW0obiwwLHIsYSl9Z2V0UmdiQnVmZmVyKGUsdCxyLGEsbixpLHMpe2NvbnN0IG89dGhpcy50aW50Rm4sYz10aGlzLmJhc2UsbD0xLygoMTw8aSktMSksaD1jLm51bUNvbXBzLHU9Yy51c2VzWmVyb1RvT25lUmFuZ2UsZD0oYy5pc1Bhc3N0aHJvdWdoKDgpfHwhdSkmJjA9PT1zO2xldCBmPWQ/bjowO2NvbnN0IGc9ZD9hOm5ldyBVaW50OENsYW1wZWRBcnJheShoKnIpLHA9dGhpcy5udW1Db21wcyxtPW5ldyBGbG9hdDMyQXJyYXkocCksYj1uZXcgRmxvYXQzMkFycmF5KGgpO2xldCB5LHc7Zm9yKHk9MDt5PHI7eSsrKXtmb3Iodz0wO3c8cDt3KyspbVt3XT1lW3QrK10qbDtvKG0sMCxiLDApO2lmKHUpZm9yKHc9MDt3PGg7dysrKWdbZisrXT0yNTUqYlt3XTtlbHNle2MuZ2V0UmdiSXRlbShiLDAsZyxmKTtmKz1ofX1kfHxjLmdldFJnYkJ1ZmZlcihnLDAscixhLG4sOCxzKX1nZXRPdXRwdXRMZW5ndGgoZSx0KXtyZXR1cm4gdGhpcy5iYXNlLmdldE91dHB1dExlbmd0aChlKnRoaXMuYmFzZS5udW1Db21wcy90aGlzLm51bUNvbXBzLHQpfX1jbGFzcyBQYXR0ZXJuQ1MgZXh0ZW5kcyBDb2xvclNwYWNle2NvbnN0cnVjdG9yKGUpe3N1cGVyKCJQYXR0ZXJuIixudWxsKTt0aGlzLmJhc2U9ZX1pc0RlZmF1bHREZWNvZGUoZSx0KXt1bnJlYWNoYWJsZSgiU2hvdWxkIG5vdCBjYWxsIFBhdHRlcm5DUy5pc0RlZmF1bHREZWNvZGUiKX19Y2xhc3MgSW5kZXhlZENTIGV4dGVuZHMgQ29sb3JTcGFjZXtjb25zdHJ1Y3RvcihlLHQscil7c3VwZXIoIkluZGV4ZWQiLDEpO3RoaXMuYmFzZT1lO3RoaXMuaGlnaFZhbD10O2NvbnN0IGE9ZS5udW1Db21wcyoodCsxKTt0aGlzLmxvb2t1cD1uZXcgVWludDhBcnJheShhKTtpZihyIGluc3RhbmNlb2YgQmFzZVN0cmVhbSl7Y29uc3QgZT1yLmdldEJ5dGVzKGEpO3RoaXMubG9va3VwLnNldChlKX1lbHNle2lmKCJzdHJpbmciIT10eXBlb2Ygcil0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYEluZGV4ZWRDUyAtIHVucmVjb2duaXplZCBsb29rdXAgdGFibGU6ICR7cn1gKTtmb3IobGV0IGU9MDtlPGE7KytlKXRoaXMubG9va3VwW2VdPTI1NSZyLmNoYXJDb2RlQXQoZSl9fWdldFJnYkl0ZW0oZSx0LHIsYSl7Y29uc3R7YmFzZTpuLGhpZ2hWYWw6aSxsb29rdXA6c309dGhpcyxvPU1hdGhDbGFtcChNYXRoLnJvdW5kKGVbdF0pLDAsaSkqbi5udW1Db21wcztuLmdldFJnYkJ1ZmZlcihzLG8sMSxyLGEsOCwwKX1nZXRSZ2JCdWZmZXIoZSx0LHIsYSxuLGkscyl7Y29uc3R7YmFzZTpvLGhpZ2hWYWw6Yyxsb29rdXA6bH09dGhpcyx7bnVtQ29tcHM6aH09byx1PW8uZ2V0T3V0cHV0TGVuZ3RoKGgscyk7Zm9yKGxldCBpPTA7aTxyOysraSl7Y29uc3Qgcj1NYXRoQ2xhbXAoTWF0aC5yb3VuZChlW3QrK10pLDAsYykqaDtvLmdldFJnYkJ1ZmZlcihsLHIsMSxhLG4sOCxzKTtuKz11fX1nZXRPdXRwdXRMZW5ndGgoZSx0KXtyZXR1cm4gdGhpcy5iYXNlLmdldE91dHB1dExlbmd0aChlKnRoaXMuYmFzZS5udW1Db21wcyx0KX1pc0RlZmF1bHREZWNvZGUoZSx0KXtpZighQXJyYXkuaXNBcnJheShlKSlyZXR1cm4hMDtpZigyIT09ZS5sZW5ndGgpe3dhcm4oIkRlY29kZSBtYXAgbGVuZ3RoIGlzIG5vdCBjb3JyZWN0Iik7cmV0dXJuITB9aWYoIU51bWJlci5pc0ludGVnZXIodCl8fHQ8MSl7d2FybigiQml0cyBwZXIgY29tcG9uZW50IGlzIG5vdCBjb3JyZWN0Iik7cmV0dXJuITB9cmV0dXJuIDA9PT1lWzBdJiZlWzFdPT09KDE8PHQpLTF9fWNsYXNzIERldmljZUdyYXlDUyBleHRlbmRzIENvbG9yU3BhY2V7Y29uc3RydWN0b3IoKXtzdXBlcigiRGV2aWNlR3JheSIsMSl9Z2V0UmdiSXRlbShlLHQscixhKXtjb25zdCBuPTI1NSplW3RdO3JbYV09clthKzFdPXJbYSsyXT1ufWdldFJnYkJ1ZmZlcihlLHQscixhLG4saSxzKXtjb25zdCBvPTI1NS8oKDE8PGkpLTEpO2xldCBjPXQsbD1uO2ZvcihsZXQgdD0wO3Q8cjsrK3Qpe2NvbnN0IHQ9byplW2MrK107YVtsKytdPXQ7YVtsKytdPXQ7YVtsKytdPXQ7bCs9c319Z2V0T3V0cHV0TGVuZ3RoKGUsdCl7cmV0dXJuIGUqKDMrdCl9fWNsYXNzIERldmljZVJnYkNTIGV4dGVuZHMgQ29sb3JTcGFjZXtjb25zdHJ1Y3Rvcigpe3N1cGVyKCJEZXZpY2VSR0IiLDMpfWdldFJnYkl0ZW0oZSx0LHIsYSl7clthXT0yNTUqZVt0XTtyW2ErMV09MjU1KmVbdCsxXTtyW2ErMl09MjU1KmVbdCsyXX1nZXRSZ2JCdWZmZXIoZSx0LHIsYSxuLGkscyl7aWYoOD09PWkmJjA9PT1zKXthLnNldChlLnN1YmFycmF5KHQsdCszKnIpLG4pO3JldHVybn1jb25zdCBvPTI1NS8oKDE8PGkpLTEpO2xldCBjPXQsbD1uO2ZvcihsZXQgdD0wO3Q8cjsrK3Qpe2FbbCsrXT1vKmVbYysrXTthW2wrK109byplW2MrK107YVtsKytdPW8qZVtjKytdO2wrPXN9fWdldE91dHB1dExlbmd0aChlLHQpe3JldHVybiBlKigzK3QpLzN8MH1pc1Bhc3N0aHJvdWdoKGUpe3JldHVybiA4PT09ZX19Y2xhc3MgRGV2aWNlUmdiYUNTIGV4dGVuZHMgQ29sb3JTcGFjZXtjb25zdHJ1Y3Rvcigpe3N1cGVyKCJEZXZpY2VSR0JBIiw0KX1nZXRPdXRwdXRMZW5ndGgoZSx0KXtyZXR1cm4gNCplfWlzUGFzc3Rocm91Z2goZSl7cmV0dXJuIDg9PT1lfWZpbGxSZ2IoZSx0LHIsYSxuLGkscyxvLGMpe3IhPT1ufHx0IT09YT9mdW5jdGlvbiByZXNpemVSZ2JhSW1hZ2UoZSx0LHIsYSxuLGkscyl7Y29uc3Qgbz1yL24sYz1hL2k7bGV0IGw9MDtjb25zdCBoPW5ldyBVaW50MTZBcnJheShuKTtpZigxPT09cyl7Zm9yKGxldCBlPTA7ZTxuO2UrKyloW2VdPU1hdGguZmxvb3IoZSpvKTtjb25zdCBhPW5ldyBVaW50MzJBcnJheShlLmJ1ZmZlcikscz1uZXcgVWludDMyQXJyYXkodC5idWZmZXIpLHU9RmVhdHVyZVRlc3QuaXNMaXR0bGVFbmRpYW4/MTY3NzcyMTU6NDI5NDk2NzA0MDtmb3IobGV0IGU9MDtlPGk7ZSsrKXtjb25zdCB0PWEuc3ViYXJyYXkoTWF0aC5mbG9vcihlKmMpKnIpO2ZvcihsZXQgZT0wO2U8bjtlKyspc1tsKytdfD10W2hbZV1dJnV9fWVsc2V7Y29uc3QgYT00LHM9ciphO2ZvcihsZXQgZT0wO2U8bjtlKyspaFtlXT1NYXRoLmZsb29yKGUqbykqYTtmb3IobGV0IHI9MDtyPGk7cisrKXtjb25zdCBhPWUuc3ViYXJyYXkoTWF0aC5mbG9vcihyKmMpKnMpO2ZvcihsZXQgZT0wO2U8bjtlKyspe2NvbnN0IHI9aFtlXTt0W2wrK109YVtyXTt0W2wrK109YVtyKzFdO3RbbCsrXT1hW3IrMl19fX19KG8sZSx0LHIsYSxuLGMpOmZ1bmN0aW9uIGNvcHlSZ2JhSW1hZ2UoZSx0LHIpe2lmKDE9PT1yKXtjb25zdCByPW5ldyBVaW50MzJBcnJheShlLmJ1ZmZlciksYT1uZXcgVWludDMyQXJyYXkodC5idWZmZXIpLG49RmVhdHVyZVRlc3QuaXNMaXR0bGVFbmRpYW4/MTY3NzcyMTU6NDI5NDk2NzA0MDtmb3IobGV0IGU9MCx0PXIubGVuZ3RoO2U8dDtlKyspYVtlXXw9cltlXSZufWVsc2V7bGV0IHI9MDtmb3IobGV0IGE9MCxuPWUubGVuZ3RoO2E8bjthKz00KXt0W3IrK109ZVthXTt0W3IrK109ZVthKzFdO3RbcisrXT1lW2ErMl19fX0obyxlLGMpfX1jbGFzcyBEZXZpY2VDbXlrQ1MgZXh0ZW5kcyBDb2xvclNwYWNle2NvbnN0cnVjdG9yKCl7c3VwZXIoIkRldmljZUNNWUsiLDQpfSNuKGUsdCxyLGEsbil7Y29uc3QgaT1lW3RdKnIscz1lW3QrMV0qcixvPWVbdCsyXSpyLGM9ZVt0KzNdKnI7YVtuXT0yNTUraSooLTQuMzg3MzMyMzg0NjA5OTg4KmkrNTQuNDg2MTUxOTQxODkxNzYqcysxOC44MjI5MDUwMjE2NTMwMipvKzIxMi4yNTY2MjQ1MTYzOTU4NSpjLTI4NS4yMzMxMDI2MTM3MDA0KStzKigxLjcxNDk3NjM0NzczNjIxMzQqcy01LjYwOTY3MzY5MDQwNDczMTUqbystMTcuODczODcwODYxNDE1NDQ0KmMtNS40OTcwMDY0MjcxOTYzNjYpK28qKC0yLjUyMTczNDAxMzE2ODMwMzMqby0yMS4yNDg5MjMzMzczNTMwNzMqYysxNy41MTE5MjcwODQxODEzKStjKigtMjEuODYxMjIxNDc0NjM2MDUqYy0xODkuNDgxODA4MzU5MjI3NDcpO2FbbisxXT0yNTUraSooOC44NDEwNDE0MjIwMzYxNDkqaSs2MC4xMTgwMjcwNDU1OTczNjYqcys2Ljg3MTQyNTU5MjA0OTAwNypvKzMxLjE1OTEwMDEzMDA1NTkyMipjLTc5LjI5NzA4NDQ4MTY1NDgpK3MqKC0xNS4zMTAzNjEzMDY5Njc4MTcqcysxNy41NzUyNTEyNjExMDk0ODIqbysxMzEuMzUyNTA5MTI0OTM5NzYqYy0xOTAuOTQ1MzMwMjU4ODk1MSkrbyooNC40NDQzMzkxMDI4NTI3Mzkqbys5Ljg2MzI4NjE0OTM0MDUqYy0yNC44Njc0MTU4MjU1NTg3OCkrYyooLTIwLjczNzMyNTQ3MTE4MTAzNCpjLTE4Ny44MDQ1MzcwOTcxOTU3OCk7YVtuKzJdPTI1NStpKiguODg0MjUyMjQzMDAwMzI5NippKzguMDc4Njc3NTAzMTEyOTI4KnMrMzAuODk5NzgzMDk3MDM3Mjkqby0uMjM4ODMyMzg2ODkxNzg5MzQqYy0xNC4xODM1NzY3OTk2NzMyODYpK3MqKDEwLjQ5NTkzMjczNDMyMDcyKnMrNjMuMDIzNzg0OTQ3NTQwNTIqbys1MC42MDY5NTc2NTYzNjA3MzQqYy0xMTIuMjM4ODQyNTM3MTkyNDgpK28qKC4wMzI5NjA0MTExNDg3MzIxNypvKzExNS42MDM4NDQ0OTY0NjY0MSpjLTE5My41ODIwOTM1Njg2MTUwNSkrYyooLTIyLjMzODE2ODA3MzA5ODg2KmMtMTgwLjEyNjEzOTc0NzA4MzY3KX1nZXRSZ2JJdGVtKGUsdCxyLGEpe3RoaXMuI24oZSx0LDEscixhKX1nZXRSZ2JCdWZmZXIoZSx0LHIsYSxuLGkscyl7Y29uc3Qgbz0xLygoMTw8aSktMSk7Zm9yKGxldCBpPTA7aTxyO2krKyl7dGhpcy4jbihlLHQsbyxhLG4pO3QrPTQ7bis9MytzfX1nZXRPdXRwdXRMZW5ndGgoZSx0KXtyZXR1cm4gZS80KigzK3QpfDB9fWNsYXNzIENhbEdyYXlDUyBleHRlbmRzIENvbG9yU3BhY2V7Y29uc3RydWN0b3IoZSx0LHIpe3N1cGVyKCJDYWxHcmF5IiwxKTtpZighZSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIldoaXRlUG9pbnQgbWlzc2luZyAtIHJlcXVpcmVkIGZvciBjb2xvciBzcGFjZSBDYWxHcmF5Iik7W3RoaXMuWFcsdGhpcy5ZVyx0aGlzLlpXXT1lO1t0aGlzLlhCLHRoaXMuWUIsdGhpcy5aQl09dHx8WzAsMCwwXTt0aGlzLkc9cnx8MTtpZih0aGlzLlhXPDB8fHRoaXMuWlc8MHx8MSE9PXRoaXMuWVcpdGhyb3cgbmV3IEZvcm1hdEVycm9yKGBJbnZhbGlkIFdoaXRlUG9pbnQgY29tcG9uZW50cyBmb3IgJHt0aGlzLm5hbWV9LCBubyBmYWxsYmFjayBhdmFpbGFibGVgKTtpZih0aGlzLlhCPDB8fHRoaXMuWUI8MHx8dGhpcy5aQjwwKXtpbmZvKGBJbnZhbGlkIEJsYWNrUG9pbnQgZm9yICR7dGhpcy5uYW1lfSwgZmFsbGluZyBiYWNrIHRvIGRlZmF1bHQuYCk7dGhpcy5YQj10aGlzLllCPXRoaXMuWkI9MH0wPT09dGhpcy5YQiYmMD09PXRoaXMuWUImJjA9PT10aGlzLlpCfHx3YXJuKGAke3RoaXMubmFtZX0sIEJsYWNrUG9pbnQ6IFhCOiAke3RoaXMuWEJ9LCBZQjogJHt0aGlzLllCfSwgWkI6ICR7dGhpcy5aQn0sIG9ubHkgZGVmYXVsdCB2YWx1ZXMgYXJlIHN1cHBvcnRlZC5gKTtpZih0aGlzLkc8MSl7aW5mbyhgSW52YWxpZCBHYW1tYTogJHt0aGlzLkd9IGZvciAke3RoaXMubmFtZX0sIGZhbGxpbmcgYmFjayB0byBkZWZhdWx0LmApO3RoaXMuRz0xfX0jbihlLHQscixhLG4pe2NvbnN0IGk9KGVbdF0qbikqKnRoaXMuRyxzPXRoaXMuWVcqaSxvPU1hdGgubWF4KDI5NS44KnMqKi4zMzMzMzMzMzMzMzMzMzMzLTQwLjgsMCk7clthXT1vO3JbYSsxXT1vO3JbYSsyXT1vfWdldFJnYkl0ZW0oZSx0LHIsYSl7dGhpcy4jbihlLHQscixhLDEpfWdldFJnYkJ1ZmZlcihlLHQscixhLG4saSxzKXtjb25zdCBvPTEvKCgxPDxpKS0xKTtmb3IobGV0IGk9MDtpPHI7KytpKXt0aGlzLiNuKGUsdCxhLG4sbyk7dCs9MTtuKz0zK3N9fWdldE91dHB1dExlbmd0aChlLHQpe3JldHVybiBlKigzK3QpfX1jbGFzcyBDYWxSR0JDUyBleHRlbmRzIENvbG9yU3BhY2V7c3RhdGljI2k9bmV3IEZsb2F0MzJBcnJheShbLjg5NTEsLjI2NjQsLS4xNjE0LC0uNzUwMiwxLjcxMzUsLjAzNjcsLjAzODksLS4wNjg1LDEuMDI5Nl0pO3N0YXRpYyNzPW5ldyBGbG9hdDMyQXJyYXkoWy45ODY5OTI5LC0uMTQ3MDU0MywuMTU5OTYyNywuNDMyMzA1MywuNTE4MzYwMywuMDQ5MjkxMiwtLjAwODUyODcsLjA0MDA0MjgsLjk2ODQ4NjddKTtzdGF0aWMjbz1uZXcgRmxvYXQzMkFycmF5KFszLjI0MDQ1NDIsLTEuNTM3MTM4NSwtLjQ5ODUzMTQsLS45NjkyNjYsMS44NzYwMTA4LC4wNDE1NTYsLjA1NTY0MzQsLS4yMDQwMjU5LDEuMDU3MjI1Ml0pO3N0YXRpYyNjPW5ldyBGbG9hdDMyQXJyYXkoWzEsMSwxXSk7c3RhdGljI2w9bmV3IEZsb2F0MzJBcnJheSgzKTtzdGF0aWMjaD1uZXcgRmxvYXQzMkFycmF5KDMpO3N0YXRpYyN1PW5ldyBGbG9hdDMyQXJyYXkoMyk7c3RhdGljI2Q9KDI0LzExNikqKjMvODtjb25zdHJ1Y3RvcihlLHQscixhKXtzdXBlcigiQ2FsUkdCIiwzKTtpZighZSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIldoaXRlUG9pbnQgbWlzc2luZyAtIHJlcXVpcmVkIGZvciBjb2xvciBzcGFjZSBDYWxSR0IiKTtjb25zdFtuLGksc109dGhpcy53aGl0ZVBvaW50PWUsW28sYyxsXT10aGlzLmJsYWNrUG9pbnQ9dHx8bmV3IEZsb2F0MzJBcnJheSgzKTtbdGhpcy5HUix0aGlzLkdHLHRoaXMuR0JdPXJ8fG5ldyBGbG9hdDMyQXJyYXkoWzEsMSwxXSk7W3RoaXMuTVhBLHRoaXMuTVlBLHRoaXMuTVpBLHRoaXMuTVhCLHRoaXMuTVlCLHRoaXMuTVpCLHRoaXMuTVhDLHRoaXMuTVlDLHRoaXMuTVpDXT1hfHxuZXcgRmxvYXQzMkFycmF5KFsxLDAsMCwwLDEsMCwwLDAsMV0pO2lmKG48MHx8czwwfHwxIT09aSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYEludmFsaWQgV2hpdGVQb2ludCBjb21wb25lbnRzIGZvciAke3RoaXMubmFtZX0sIG5vIGZhbGxiYWNrIGF2YWlsYWJsZWApO2lmKG88MHx8YzwwfHxsPDApe2luZm8oYEludmFsaWQgQmxhY2tQb2ludCBmb3IgJHt0aGlzLm5hbWV9IFske299LCAke2N9LCAke2x9XSwgZmFsbGluZyBiYWNrIHRvIGRlZmF1bHQuYCk7dGhpcy5ibGFja1BvaW50PW5ldyBGbG9hdDMyQXJyYXkoMyl9aWYodGhpcy5HUjwwfHx0aGlzLkdHPDB8fHRoaXMuR0I8MCl7aW5mbyhgSW52YWxpZCBHYW1tYSBbJHt0aGlzLkdSfSwgJHt0aGlzLkdHfSwgJHt0aGlzLkdCfV0gZm9yICR7dGhpcy5uYW1lfSwgZmFsbGluZyBiYWNrIHRvIGRlZmF1bHQuYCk7dGhpcy5HUj10aGlzLkdHPXRoaXMuR0I9MX19I2YoZSx0LHIpe3JbMF09ZVswXSp0WzBdK2VbMV0qdFsxXStlWzJdKnRbMl07clsxXT1lWzNdKnRbMF0rZVs0XSp0WzFdK2VbNV0qdFsyXTtyWzJdPWVbNl0qdFswXStlWzddKnRbMV0rZVs4XSp0WzJdfSNnKGUsdCxyKXtyWzBdPTEqdFswXS9lWzBdO3JbMV09MSp0WzFdL2VbMV07clsyXT0xKnRbMl0vZVsyXX0jcChlLHQscil7clswXT0uOTUwNDcqdFswXS9lWzBdO3JbMV09MSp0WzFdL2VbMV07clsyXT0xLjA4ODgzKnRbMl0vZVsyXX0jbShlKXtyZXR1cm4gZTw9LjAwMzEzMDg/TWF0aENsYW1wKDEyLjkyKmUsMCwxKTplPj0uOTk1NTQ1MjU/MTpNYXRoQ2xhbXAoMS4wNTUqZSoqKDEvMi40KS0uMDU1LDAsMSl9I2IoZSl7cmV0dXJuIGU8MD8tdGhpcy4jYigtZSk6ZT44PygoZSsxNikvMTE2KSoqMzplKkNhbFJHQkNTLiNkfSN5KGUsdCxyKXtpZigwPT09ZVswXSYmMD09PWVbMV0mJjA9PT1lWzJdKXtyWzBdPXRbMF07clsxXT10WzFdO3JbMl09dFsyXTtyZXR1cm59Y29uc3QgYT10aGlzLiNiKDApLG49KDEtYSkvKDEtdGhpcy4jYihlWzBdKSksaT0xLW4scz0oMS1hKS8oMS10aGlzLiNiKGVbMV0pKSxvPTEtcyxjPSgxLWEpLygxLXRoaXMuI2IoZVsyXSkpLGw9MS1jO3JbMF09dFswXSpuK2k7clsxXT10WzFdKnMrbztyWzJdPXRbMl0qYytsfSN3KGUsdCxyKXtpZigxPT09ZVswXSYmMT09PWVbMl0pe3JbMF09dFswXTtyWzFdPXRbMV07clsyXT10WzJdO3JldHVybn1jb25zdCBhPXI7dGhpcy4jZihDYWxSR0JDUy4jaSx0LGEpO2NvbnN0IG49Q2FsUkdCQ1MuI2w7dGhpcy4jZyhlLGEsbik7dGhpcy4jZihDYWxSR0JDUy4jcyxuLHIpfSN4KGUsdCxyKXtjb25zdCBhPXI7dGhpcy4jZihDYWxSR0JDUy4jaSx0LGEpO2NvbnN0IG49Q2FsUkdCQ1MuI2w7dGhpcy4jcChlLGEsbik7dGhpcy4jZihDYWxSR0JDUy4jcyxuLHIpfSNuKGUsdCxyLGEsbil7Y29uc3QgaT1NYXRoQ2xhbXAoZVt0XSpuLDAsMSkscz1NYXRoQ2xhbXAoZVt0KzFdKm4sMCwxKSxvPU1hdGhDbGFtcChlW3QrMl0qbiwwLDEpLGM9MT09PWk/MTppKip0aGlzLkdSLGw9MT09PXM/MTpzKip0aGlzLkdHLGg9MT09PW8/MTpvKip0aGlzLkdCLHU9dGhpcy5NWEEqYyt0aGlzLk1YQipsK3RoaXMuTVhDKmgsZD10aGlzLk1ZQSpjK3RoaXMuTVlCKmwrdGhpcy5NWUMqaCxmPXRoaXMuTVpBKmMrdGhpcy5NWkIqbCt0aGlzLk1aQypoLGc9Q2FsUkdCQ1MuI2g7Z1swXT11O2dbMV09ZDtnWzJdPWY7Y29uc3QgcD1DYWxSR0JDUy4jdTt0aGlzLiN3KHRoaXMud2hpdGVQb2ludCxnLHApO2NvbnN0IG09Q2FsUkdCQ1MuI2g7dGhpcy4jeSh0aGlzLmJsYWNrUG9pbnQscCxtKTtjb25zdCBiPUNhbFJHQkNTLiN1O3RoaXMuI3goQ2FsUkdCQ1MuI2MsbSxiKTtjb25zdCB5PUNhbFJHQkNTLiNoO3RoaXMuI2YoQ2FsUkdCQ1MuI28sYix5KTtyW2FdPTI1NSp0aGlzLiNtKHlbMF0pO3JbYSsxXT0yNTUqdGhpcy4jbSh5WzFdKTtyW2ErMl09MjU1KnRoaXMuI20oeVsyXSl9Z2V0UmdiSXRlbShlLHQscixhKXt0aGlzLiNuKGUsdCxyLGEsMSl9Z2V0UmdiQnVmZmVyKGUsdCxyLGEsbixpLHMpe2NvbnN0IG89MS8oKDE8PGkpLTEpO2ZvcihsZXQgaT0wO2k8cjsrK2kpe3RoaXMuI24oZSx0LGEsbixvKTt0Kz0zO24rPTMrc319Z2V0T3V0cHV0TGVuZ3RoKGUsdCl7cmV0dXJuIGUqKDMrdCkvM3wwfX1jbGFzcyBMYWJDUyBleHRlbmRzIENvbG9yU3BhY2V7Y29uc3RydWN0b3IoZSx0LHIpe3N1cGVyKCJMYWIiLDMpO2lmKCFlKXRocm93IG5ldyBGb3JtYXRFcnJvcigiV2hpdGVQb2ludCBtaXNzaW5nIC0gcmVxdWlyZWQgZm9yIGNvbG9yIHNwYWNlIExhYiIpO1t0aGlzLlhXLHRoaXMuWVcsdGhpcy5aV109ZTtbdGhpcy5hbWluLHRoaXMuYW1heCx0aGlzLmJtaW4sdGhpcy5ibWF4XT1yfHxbLTEwMCwxMDAsLTEwMCwxMDBdO1t0aGlzLlhCLHRoaXMuWUIsdGhpcy5aQl09dHx8WzAsMCwwXTtpZih0aGlzLlhXPDB8fHRoaXMuWlc8MHx8MSE9PXRoaXMuWVcpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIFdoaXRlUG9pbnQgY29tcG9uZW50cywgbm8gZmFsbGJhY2sgYXZhaWxhYmxlIik7aWYodGhpcy5YQjwwfHx0aGlzLllCPDB8fHRoaXMuWkI8MCl7aW5mbygiSW52YWxpZCBCbGFja1BvaW50LCBmYWxsaW5nIGJhY2sgdG8gZGVmYXVsdCIpO3RoaXMuWEI9dGhpcy5ZQj10aGlzLlpCPTB9aWYodGhpcy5hbWluPnRoaXMuYW1heHx8dGhpcy5ibWluPnRoaXMuYm1heCl7aW5mbygiSW52YWxpZCBSYW5nZSwgZmFsbGluZyBiYWNrIHRvIGRlZmF1bHRzIik7dGhpcy5hbWluPS0xMDA7dGhpcy5hbWF4PTEwMDt0aGlzLmJtaW49LTEwMDt0aGlzLmJtYXg9MTAwfX0jUyhlKXtyZXR1cm4gZT49Ni8yOT9lKiozOjEwOC84NDEqKGUtNC8yOSl9I0EoZSx0LHIsYSl7cmV0dXJuIHIrZSooYS1yKS90fSNuKGUsdCxyLGEsbil7bGV0IGk9ZVt0XSxzPWVbdCsxXSxvPWVbdCsyXTtpZighMSE9PXIpe2k9dGhpcy4jQShpLHIsMCwxMDApO3M9dGhpcy4jQShzLHIsdGhpcy5hbWluLHRoaXMuYW1heCk7bz10aGlzLiNBKG8scix0aGlzLmJtaW4sdGhpcy5ibWF4KX1zPnRoaXMuYW1heD9zPXRoaXMuYW1heDpzPHRoaXMuYW1pbiYmKHM9dGhpcy5hbWluKTtvPnRoaXMuYm1heD9vPXRoaXMuYm1heDpvPHRoaXMuYm1pbiYmKG89dGhpcy5ibWluKTtjb25zdCBjPShpKzE2KS8xMTYsbD1jK3MvNTAwLGg9Yy1vLzIwMCx1PXRoaXMuWFcqdGhpcy4jUyhsKSxkPXRoaXMuWVcqdGhpcy4jUyhjKSxmPXRoaXMuWlcqdGhpcy4jUyhoKTtsZXQgZyxwLG07aWYodGhpcy5aVzwxKXtnPTMuMTMzOSp1Ky0xLjYxNypkKy0uNDkwNipmO3A9LS45Nzg1KnUrMS45MTYqZCsuMDMzMypmO209LjA3Mip1Ky0uMjI5KmQrMS40MDU3KmZ9ZWxzZXtnPTMuMjQwNip1Ky0xLjUzNzIqZCstLjQ5ODYqZjtwPS0uOTY4OSp1KzEuODc1OCpkKy4wNDE1KmY7bT0uMDU1Nyp1Ky0uMjA0KmQrMS4wNTcqZn1hW25dPTI1NSpNYXRoLnNxcnQoZyk7YVtuKzFdPTI1NSpNYXRoLnNxcnQocCk7YVtuKzJdPTI1NSpNYXRoLnNxcnQobSl9Z2V0UmdiSXRlbShlLHQscixhKXt0aGlzLiNuKGUsdCwhMSxyLGEpfWdldFJnYkJ1ZmZlcihlLHQscixhLG4saSxzKXtjb25zdCBvPSgxPDxpKS0xO2ZvcihsZXQgaT0wO2k8cjtpKyspe3RoaXMuI24oZSx0LG8sYSxuKTt0Kz0zO24rPTMrc319Z2V0T3V0cHV0TGVuZ3RoKGUsdCl7cmV0dXJuIGUqKDMrdCkvM3wwfWlzRGVmYXVsdERlY29kZShlLHQpe3JldHVybiEwfWdldCB1c2VzWmVyb1RvT25lUmFuZ2UoKXtyZXR1cm4gc2hhZG93KHRoaXMsInVzZXNaZXJvVG9PbmVSYW5nZSIsITEpfX1mdW5jdGlvbiBmZXRjaFN5bmMoZSl7Y29uc3QgdD1uZXcgWE1MSHR0cFJlcXVlc3Q7dC5vcGVuKCJHRVQiLGUsITEpO3QucmVzcG9uc2VUeXBlPSJhcnJheWJ1ZmZlciI7dC5zZW5kKG51bGwpO3JldHVybiB0LnJlc3BvbnNlfWNsYXNzIEljY0NvbG9yU3BhY2UgZXh0ZW5kcyBDb2xvclNwYWNleyNrOyNDO3N0YXRpYyN2PSEwO3N0YXRpYyNGPW51bGw7c3RhdGljI0k9bnVsbDtjb25zdHJ1Y3RvcihlLHQscil7aWYoIUljY0NvbG9yU3BhY2UuaXNVc2FibGUpdGhyb3cgbmV3IEVycm9yKCJObyBJQ0MgY29sb3Igc3BhY2Ugc3VwcG9ydCIpO3N1cGVyKHQscik7bGV0IGE7c3dpdGNoKHIpe2Nhc2UgMTphPUFyLkdyYXk4O3RoaXMuI0M9KGUsdCxyKT0+ZnVuY3Rpb24gcWNtc19jb252ZXJ0X29uZShlLHQscil7eXIucWNtc19jb252ZXJ0X29uZShlLHQscil9KHRoaXMuI2ssMjU1KmVbdF0scik7YnJlYWs7Y2FzZSAzOmE9QXIuUkdCODt0aGlzLiNDPShlLHQscik9PmZ1bmN0aW9uIHFjbXNfY29udmVydF90aHJlZShlLHQscixhLG4pe3lyLnFjbXNfY29udmVydF90aHJlZShlLHQscixhLG4pfSh0aGlzLiNrLDI1NSplW3RdLDI1NSplW3QrMV0sMjU1KmVbdCsyXSxyKTticmVhaztjYXNlIDQ6YT1Bci5DTVlLO3RoaXMuI0M9KGUsdCxyKT0+ZnVuY3Rpb24gcWNtc19jb252ZXJ0X2ZvdXIoZSx0LHIsYSxuLGkpe3lyLnFjbXNfY29udmVydF9mb3VyKGUsdCxyLGEsbixpKX0odGhpcy4jaywyNTUqZVt0XSwyNTUqZVt0KzFdLDI1NSplW3QrMl0sMjU1KmVbdCszXSxyKTticmVhaztkZWZhdWx0OnRocm93IG5ldyBFcnJvcihgVW5zdXBwb3J0ZWQgbnVtYmVyIG9mIGNvbXBvbmVudHM6ICR7cn1gKX10aGlzLiNrPWZ1bmN0aW9uIHFjbXNfdHJhbnNmb3JtZXJfZnJvbV9tZW1vcnkoZSx0LHIpe2NvbnN0IGE9cGFzc0FycmF5OFRvV2FzbTAoZSx5ci5fX3diaW5kZ2VuX21hbGxvYyksbj1TcjtyZXR1cm4geXIucWNtc190cmFuc2Zvcm1lcl9mcm9tX21lbW9yeShhLG4sdCxyKT4+PjB9KGUsYSxrci5QZXJjZXB0dWFsKTtpZighdGhpcy4jayl0aHJvdyBuZXcgRXJyb3IoIkZhaWxlZCB0byBjcmVhdGUgSUNDIGNvbG9yIHNwYWNlIik7SWNjQ29sb3JTcGFjZS4jSXx8PW5ldyBGaW5hbGl6YXRpb25SZWdpc3RyeShlPT57IWZ1bmN0aW9uIHFjbXNfZHJvcF90cmFuc2Zvcm1lcihlKXt5ci5xY21zX2Ryb3BfdHJhbnNmb3JtZXIoZSl9KGUpfSk7SWNjQ29sb3JTcGFjZS4jSS5yZWdpc3Rlcih0aGlzLHRoaXMuI2spfWdldFJnYkhleChlLHQpe3RoaXMuI0MoZSx0LCEwKTtyZXR1cm4gUUNNUy5fY3NzQ29sb3J9Z2V0UmdiSXRlbShlLHQscixhKXtRQ01TLl9kZXN0QnVmZmVyPXI7UUNNUy5fZGVzdE9mZnNldD1hO1FDTVMuX2Rlc3RMZW5ndGg9Mzt0aGlzLiNDKGUsdCwhMSk7UUNNUy5fZGVzdEJ1ZmZlcj1udWxsfWdldFJnYkJ1ZmZlcihlLHQscixhLG4saSxzKXtlPWUuc3ViYXJyYXkodCx0K3IqdGhpcy5udW1Db21wcyk7aWYoOCE9PWkpe2NvbnN0IHQ9MjU1LygoMTw8aSktMSk7Zm9yKGxldCByPTAsYT1lLmxlbmd0aDtyPGE7cisrKWVbcl0qPXR9UUNNUy5fbXVzdEFkZEFscGhhPXMmJmEuYnVmZmVyPT09ZS5idWZmZXI7UUNNUy5fZGVzdEJ1ZmZlcj1hO1FDTVMuX2Rlc3RPZmZzZXQ9bjtRQ01TLl9kZXN0TGVuZ3RoPXIqKDMrcyk7IWZ1bmN0aW9uIHFjbXNfY29udmVydF9hcnJheShlLHQpe2NvbnN0IHI9cGFzc0FycmF5OFRvV2FzbTAodCx5ci5fX3diaW5kZ2VuX21hbGxvYyksYT1Tcjt5ci5xY21zX2NvbnZlcnRfYXJyYXkoZSxyLGEpfSh0aGlzLiNrLGUpO1FDTVMuX211c3RBZGRBbHBoYT0hMTtRQ01TLl9kZXN0QnVmZmVyPW51bGx9Z2V0T3V0cHV0TGVuZ3RoKGUsdCl7cmV0dXJuIGUvdGhpcy5udW1Db21wcyooMyt0KXwwfXN0YXRpYyBzZXRPcHRpb25zKHt1c2VXYXNtOmUsdXNlV29ya2VyRmV0Y2g6dCx3YXNtVXJsOnJ9KXtpZih0KXt0aGlzLiN2PWU7dGhpcy4jRj1yfWVsc2UgdGhpcy4jdj0hMX1zdGF0aWMgZ2V0IGlzVXNhYmxlKCl7bGV0IGU9ITE7aWYodGhpcy4jdilpZih0aGlzLiNGKXRyeXt0aGlzLl9tb2R1bGU9ZnVuY3Rpb24gaW5pdFN5bmMoZSl7aWYodm9pZCAwIT09eXIpcmV0dXJuIHlyO3ZvaWQgMCE9PWUmJihPYmplY3QuZ2V0UHJvdG90eXBlT2YoZSk9PT1PYmplY3QucHJvdG90eXBlPyh7bW9kdWxlOmV9PWUpOmNvbnNvbGUud2FybigidXNpbmcgZGVwcmVjYXRlZCBwYXJhbWV0ZXJzIGZvciBgaW5pdFN5bmMoKWA7IHBhc3MgYSBzaW5nbGUgb2JqZWN0IGluc3RlYWQiKSk7Y29uc3QgdD1fX3diZ19nZXRfaW1wb3J0cygpO2UgaW5zdGFuY2VvZiBXZWJBc3NlbWJseS5Nb2R1bGV8fChlPW5ldyBXZWJBc3NlbWJseS5Nb2R1bGUoZSkpO3JldHVybiBfX3diZ19maW5hbGl6ZV9pbml0KG5ldyBXZWJBc3NlbWJseS5JbnN0YW5jZShlLHQpLGUpfSh7bW9kdWxlOmZldGNoU3luYyhgJHt0aGlzLiNGfXFjbXNfYmcud2FzbWApfSk7ZT0hIXRoaXMuX21vZHVsZTtRQ01TLl9tZW1vcnk9dGhpcy5fbW9kdWxlLm1lbW9yeTtRQ01TLl9tYWtlSGV4Q29sb3I9VXRpbC5tYWtlSGV4Q29sb3J9Y2F0Y2goZSl7d2FybihgSUNDQmFzZWQgY29sb3Igc3BhY2U6ICIke2V9Ii5gKX1lbHNlIHdhcm4oIk5vIElDQyBjb2xvciBzcGFjZSBzdXBwb3J0IGR1ZSB0byBtaXNzaW5nIGB3YXNtVXJsYCBBUEkgb3B0aW9uIik7cmV0dXJuIHNoYWRvdyh0aGlzLCJpc1VzYWJsZSIsZSl9fWNsYXNzIENteWtJQ0NCYXNlZENTIGV4dGVuZHMgSWNjQ29sb3JTcGFjZXtzdGF0aWMjVDtjb25zdHJ1Y3Rvcigpe3N1cGVyKG5ldyBVaW50OEFycmF5KGZldGNoU3luYyhgJHtDbXlrSUNDQmFzZWRDUy4jVH1DR0FUUzAwMUNvbXBhdC12Mi1taWNyby5pY2NgKSksIkRldmljZUNNWUsiLDQpfXN0YXRpYyBzZXRPcHRpb25zKHtpY2NVcmw6ZX0pe3RoaXMuI1Q9ZX1zdGF0aWMgZ2V0IGlzVXNhYmxlKCl7bGV0IGU9ITE7SWNjQ29sb3JTcGFjZS5pc1VzYWJsZSYmKHRoaXMuI1Q/ZT0hMDp3YXJuKCJObyBDTVlLIElDQyBwcm9maWxlIHN1cHBvcnQgZHVlIHRvIG1pc3NpbmcgYGljY1VybGAgQVBJIG9wdGlvbiIpKTtyZXR1cm4gc2hhZG93KHRoaXMsImlzVXNhYmxlIixlKX19Y2xhc3MgU3RyZWFtIGV4dGVuZHMgQmFzZVN0cmVhbXtjb25zdHJ1Y3RvcihlLHQscixhKXtzdXBlcigpO3RoaXMuYnl0ZXM9ZSBpbnN0YW5jZW9mIFVpbnQ4QXJyYXk/ZTpuZXcgVWludDhBcnJheShlKTt0aGlzLnN0YXJ0PXR8fDA7dGhpcy5wb3M9dGhpcy5zdGFydDt0aGlzLmVuZD10K3J8fHRoaXMuYnl0ZXMubGVuZ3RoO3RoaXMuZGljdD1hfWdldCBsZW5ndGgoKXtyZXR1cm4gdGhpcy5lbmQtdGhpcy5zdGFydH1nZXQgaXNFbXB0eSgpe3JldHVybiAwPT09dGhpcy5sZW5ndGh9Z2V0Qnl0ZSgpe3JldHVybiB0aGlzLnBvcz49dGhpcy5lbmQ/LTE6dGhpcy5ieXRlc1t0aGlzLnBvcysrXX1nZXRCeXRlcyhlKXtjb25zdCB0PXRoaXMuYnl0ZXMscj10aGlzLnBvcyxhPXRoaXMuZW5kO2lmKCFlKXJldHVybiB0LnN1YmFycmF5KHIsYSk7bGV0IG49citlO24+YSYmKG49YSk7dGhpcy5wb3M9bjtyZXR1cm4gdC5zdWJhcnJheShyLG4pfWdldEJ5dGVSYW5nZShlLHQpe2U8MCYmKGU9MCk7dD50aGlzLmVuZCYmKHQ9dGhpcy5lbmQpO3JldHVybiB0aGlzLmJ5dGVzLnN1YmFycmF5KGUsdCl9cmVzZXQoKXt0aGlzLnBvcz10aGlzLnN0YXJ0fW1vdmVTdGFydCgpe3RoaXMuc3RhcnQ9dGhpcy5wb3N9bWFrZVN1YlN0cmVhbShlLHQscj1udWxsKXtyZXR1cm4gbmV3IFN0cmVhbSh0aGlzLmJ5dGVzLmJ1ZmZlcixlLHQscil9fWNsYXNzIFN0cmluZ1N0cmVhbSBleHRlbmRzIFN0cmVhbXtjb25zdHJ1Y3RvcihlKXtzdXBlcihzdHJpbmdUb0J5dGVzKGUpKX19Y2xhc3MgTnVsbFN0cmVhbSBleHRlbmRzIFN0cmVhbXtjb25zdHJ1Y3Rvcigpe3N1cGVyKG5ldyBVaW50OEFycmF5KDApKX19Y2xhc3MgQ2h1bmtlZFN0cmVhbSBleHRlbmRzIFN0cmVhbXtjb25zdHJ1Y3RvcihlLHQscil7c3VwZXIobmV3IFVpbnQ4QXJyYXkoZSksMCxlLG51bGwpO3RoaXMuY2h1bmtTaXplPXQ7dGhpcy5fbG9hZGVkQ2h1bmtzPW5ldyBTZXQ7dGhpcy5udW1DaHVua3M9TWF0aC5jZWlsKGUvdCk7dGhpcy5tYW5hZ2VyPXI7dGhpcy5wcm9ncmVzc2l2ZURhdGFMZW5ndGg9MDt0aGlzLmxhc3RTdWNjZXNzZnVsRW5zdXJlQnl0ZUNodW5rPS0xfWdldE1pc3NpbmdDaHVua3MoKXtjb25zdCBlPVtdO2ZvcihsZXQgdD0wLHI9dGhpcy5udW1DaHVua3M7dDxyOysrdCl0aGlzLl9sb2FkZWRDaHVua3MuaGFzKHQpfHxlLnB1c2godCk7cmV0dXJuIGV9Z2V0IG51bUNodW5rc0xvYWRlZCgpe3JldHVybiB0aGlzLl9sb2FkZWRDaHVua3Muc2l6ZX1nZXQgaXNEYXRhTG9hZGVkKCl7cmV0dXJuIHRoaXMubnVtQ2h1bmtzTG9hZGVkPT09dGhpcy5udW1DaHVua3N9b25SZWNlaXZlRGF0YShlLHQpe2NvbnN0IHI9dGhpcy5jaHVua1NpemU7aWYoZSVyIT09MCl0aHJvdyBuZXcgRXJyb3IoYEJhZCBiZWdpbiBvZmZzZXQ6ICR7ZX1gKTtjb25zdCBhPWUrdC5ieXRlTGVuZ3RoO2lmKGElciE9PTAmJmEhPT10aGlzLmJ5dGVzLmxlbmd0aCl0aHJvdyBuZXcgRXJyb3IoYEJhZCBlbmQgb2Zmc2V0OiAke2F9YCk7dGhpcy5ieXRlcy5zZXQobmV3IFVpbnQ4QXJyYXkodCksZSk7Y29uc3Qgbj1NYXRoLmZsb29yKGUvciksaT1NYXRoLmZsb29yKChhLTEpL3IpKzE7Zm9yKGxldCBlPW47ZTxpOysrZSl0aGlzLl9sb2FkZWRDaHVua3MuYWRkKGUpfW9uUmVjZWl2ZVByb2dyZXNzaXZlRGF0YShlKXtsZXQgdD10aGlzLnByb2dyZXNzaXZlRGF0YUxlbmd0aDtjb25zdCByPU1hdGguZmxvb3IodC90aGlzLmNodW5rU2l6ZSk7dGhpcy5ieXRlcy5zZXQobmV3IFVpbnQ4QXJyYXkoZSksdCk7dCs9ZS5ieXRlTGVuZ3RoO3RoaXMucHJvZ3Jlc3NpdmVEYXRhTGVuZ3RoPXQ7Y29uc3QgYT10Pj10aGlzLmVuZD90aGlzLm51bUNodW5rczpNYXRoLmZsb29yKHQvdGhpcy5jaHVua1NpemUpO2ZvcihsZXQgZT1yO2U8YTsrK2UpdGhpcy5fbG9hZGVkQ2h1bmtzLmFkZChlKX1lbnN1cmVCeXRlKGUpe2lmKGU8dGhpcy5wcm9ncmVzc2l2ZURhdGFMZW5ndGgpcmV0dXJuO2NvbnN0IHQ9TWF0aC5mbG9vcihlL3RoaXMuY2h1bmtTaXplKTtpZighKHQ+dGhpcy5udW1DaHVua3MpJiZ0IT09dGhpcy5sYXN0U3VjY2Vzc2Z1bEVuc3VyZUJ5dGVDaHVuayl7aWYoIXRoaXMuX2xvYWRlZENodW5rcy5oYXModCkpdGhyb3cgbmV3IE1pc3NpbmdEYXRhRXhjZXB0aW9uKGUsZSsxKTt0aGlzLmxhc3RTdWNjZXNzZnVsRW5zdXJlQnl0ZUNodW5rPXR9fWVuc3VyZVJhbmdlKGUsdCl7aWYoZT49dClyZXR1cm47aWYodDw9dGhpcy5wcm9ncmVzc2l2ZURhdGFMZW5ndGgpcmV0dXJuO2NvbnN0IHI9TWF0aC5mbG9vcihlL3RoaXMuY2h1bmtTaXplKTtpZihyPnRoaXMubnVtQ2h1bmtzKXJldHVybjtjb25zdCBhPU1hdGgubWluKE1hdGguZmxvb3IoKHQtMSkvdGhpcy5jaHVua1NpemUpKzEsdGhpcy5udW1DaHVua3MpO2ZvcihsZXQgbj1yO248YTsrK24paWYoIXRoaXMuX2xvYWRlZENodW5rcy5oYXMobikpdGhyb3cgbmV3IE1pc3NpbmdEYXRhRXhjZXB0aW9uKGUsdCl9bmV4dEVtcHR5Q2h1bmsoZSl7Y29uc3QgdD10aGlzLm51bUNodW5rcztmb3IobGV0IHI9MDtyPHQ7KytyKXtjb25zdCBhPShlK3IpJXQ7aWYoIXRoaXMuX2xvYWRlZENodW5rcy5oYXMoYSkpcmV0dXJuIGF9cmV0dXJuIG51bGx9aGFzQ2h1bmsoZSl7cmV0dXJuIHRoaXMuX2xvYWRlZENodW5rcy5oYXMoZSl9Z2V0Qnl0ZSgpe2NvbnN0IGU9dGhpcy5wb3M7aWYoZT49dGhpcy5lbmQpcmV0dXJuLTE7ZT49dGhpcy5wcm9ncmVzc2l2ZURhdGFMZW5ndGgmJnRoaXMuZW5zdXJlQnl0ZShlKTtyZXR1cm4gdGhpcy5ieXRlc1t0aGlzLnBvcysrXX1nZXRCeXRlcyhlKXtjb25zdCB0PXRoaXMuYnl0ZXMscj10aGlzLnBvcyxhPXRoaXMuZW5kO2lmKCFlKXthPnRoaXMucHJvZ3Jlc3NpdmVEYXRhTGVuZ3RoJiZ0aGlzLmVuc3VyZVJhbmdlKHIsYSk7cmV0dXJuIHQuc3ViYXJyYXkocixhKX1sZXQgbj1yK2U7bj5hJiYobj1hKTtuPnRoaXMucHJvZ3Jlc3NpdmVEYXRhTGVuZ3RoJiZ0aGlzLmVuc3VyZVJhbmdlKHIsbik7dGhpcy5wb3M9bjtyZXR1cm4gdC5zdWJhcnJheShyLG4pfWdldEJ5dGVSYW5nZShlLHQpe2U8MCYmKGU9MCk7dD50aGlzLmVuZCYmKHQ9dGhpcy5lbmQpO3Q+dGhpcy5wcm9ncmVzc2l2ZURhdGFMZW5ndGgmJnRoaXMuZW5zdXJlUmFuZ2UoZSx0KTtyZXR1cm4gdGhpcy5ieXRlcy5zdWJhcnJheShlLHQpfW1ha2VTdWJTdHJlYW0oZSx0LHI9bnVsbCl7dD9lK3Q+dGhpcy5wcm9ncmVzc2l2ZURhdGFMZW5ndGgmJnRoaXMuZW5zdXJlUmFuZ2UoZSxlK3QpOmU+PXRoaXMucHJvZ3Jlc3NpdmVEYXRhTGVuZ3RoJiZ0aGlzLmVuc3VyZUJ5dGUoZSk7ZnVuY3Rpb24gQ2h1bmtlZFN0cmVhbVN1YnN0cmVhbSgpe31DaHVua2VkU3RyZWFtU3Vic3RyZWFtLnByb3RvdHlwZT1PYmplY3QuY3JlYXRlKHRoaXMpO0NodW5rZWRTdHJlYW1TdWJzdHJlYW0ucHJvdG90eXBlLmdldE1pc3NpbmdDaHVua3M9ZnVuY3Rpb24oKXtjb25zdCBlPXRoaXMuY2h1bmtTaXplLHQ9TWF0aC5mbG9vcih0aGlzLnN0YXJ0L2UpLHI9TWF0aC5mbG9vcigodGhpcy5lbmQtMSkvZSkrMSxhPVtdO2ZvcihsZXQgZT10O2U8cjsrK2UpdGhpcy5fbG9hZGVkQ2h1bmtzLmhhcyhlKXx8YS5wdXNoKGUpO3JldHVybiBhfTtPYmplY3QuZGVmaW5lUHJvcGVydHkoQ2h1bmtlZFN0cmVhbVN1YnN0cmVhbS5wcm90b3R5cGUsImlzRGF0YUxvYWRlZCIse2dldCgpe3JldHVybiB0aGlzLm51bUNodW5rc0xvYWRlZD09PXRoaXMubnVtQ2h1bmtzfHwwPT09dGhpcy5nZXRNaXNzaW5nQ2h1bmtzKCkubGVuZ3RofSxjb25maWd1cmFibGU6ITB9KTtjb25zdCBhPW5ldyBDaHVua2VkU3RyZWFtU3Vic3RyZWFtO2EucG9zPWEuc3RhcnQ9ZTthLmVuZD1lK3R8fHRoaXMuZW5kO2EuZGljdD1yO3JldHVybiBhfWdldEJhc2VTdHJlYW1zKCl7cmV0dXJuW3RoaXNdfX1jbGFzcyBDaHVua2VkU3RyZWFtTWFuYWdlcntjb25zdHJ1Y3RvcihlLHQpe3RoaXMubGVuZ3RoPXQubGVuZ3RoO3RoaXMuY2h1bmtTaXplPXQucmFuZ2VDaHVua1NpemU7dGhpcy5zdHJlYW09bmV3IENodW5rZWRTdHJlYW0odGhpcy5sZW5ndGgsdGhpcy5jaHVua1NpemUsdGhpcyk7dGhpcy5wZGZOZXR3b3JrU3RyZWFtPWU7dGhpcy5kaXNhYmxlQXV0b0ZldGNoPXQuZGlzYWJsZUF1dG9GZXRjaDt0aGlzLm1zZ0hhbmRsZXI9dC5tc2dIYW5kbGVyO3RoaXMuY3VyclJlcXVlc3RJZD0wO3RoaXMuX2NodW5rc05lZWRlZEJ5UmVxdWVzdD1uZXcgTWFwO3RoaXMuX3JlcXVlc3RzQnlDaHVuaz1uZXcgTWFwO3RoaXMuX3Byb21pc2VzQnlSZXF1ZXN0PW5ldyBNYXA7dGhpcy5wcm9ncmVzc2l2ZURhdGFMZW5ndGg9MDt0aGlzLmFib3J0ZWQ9ITE7dGhpcy5fbG9hZGVkU3RyZWFtQ2FwYWJpbGl0eT1Qcm9taXNlLndpdGhSZXNvbHZlcnMoKX1zZW5kUmVxdWVzdChlLHQpe2NvbnN0IHI9dGhpcy5wZGZOZXR3b3JrU3RyZWFtLmdldFJhbmdlUmVhZGVyKGUsdCk7ci5pc1N0cmVhbWluZ1N1cHBvcnRlZHx8KHIub25Qcm9ncmVzcz10aGlzLm9uUHJvZ3Jlc3MuYmluZCh0aGlzKSk7bGV0IGE9W10sbj0wO3JldHVybiBuZXcgUHJvbWlzZSgoZSx0KT0+e2NvbnN0IHJlYWRDaHVuaz0oe3ZhbHVlOmksZG9uZTpzfSk9Pnt0cnl7aWYocyl7Y29uc3QgdD1hcnJheUJ1ZmZlcnNUb0J5dGVzKGEpO2E9bnVsbDtlKHQpO3JldHVybn1uKz1pLmJ5dGVMZW5ndGg7ci5pc1N0cmVhbWluZ1N1cHBvcnRlZCYmdGhpcy5vblByb2dyZXNzKHtsb2FkZWQ6bn0pO2EucHVzaChpKTtyLnJlYWQoKS50aGVuKHJlYWRDaHVuayx0KX1jYXRjaChlKXt0KGUpfX07ci5yZWFkKCkudGhlbihyZWFkQ2h1bmssdCl9KS50aGVuKHQ9Pnt0aGlzLmFib3J0ZWR8fHRoaXMub25SZWNlaXZlRGF0YSh7Y2h1bms6dCxiZWdpbjplfSl9KX1yZXF1ZXN0QWxsQ2h1bmtzKGU9ITEpe2lmKCFlKXtjb25zdCBlPXRoaXMuc3RyZWFtLmdldE1pc3NpbmdDaHVua3MoKTt0aGlzLl9yZXF1ZXN0Q2h1bmtzKGUpfXJldHVybiB0aGlzLl9sb2FkZWRTdHJlYW1DYXBhYmlsaXR5LnByb21pc2V9X3JlcXVlc3RDaHVua3MoZSl7Y29uc3QgdD10aGlzLmN1cnJSZXF1ZXN0SWQrKyxyPW5ldyBTZXQ7dGhpcy5fY2h1bmtzTmVlZGVkQnlSZXF1ZXN0LnNldCh0LHIpO2Zvcihjb25zdCB0IG9mIGUpdGhpcy5zdHJlYW0uaGFzQ2h1bmsodCl8fHIuYWRkKHQpO2lmKDA9PT1yLnNpemUpcmV0dXJuIFByb21pc2UucmVzb2x2ZSgpO2NvbnN0IGE9UHJvbWlzZS53aXRoUmVzb2x2ZXJzKCk7dGhpcy5fcHJvbWlzZXNCeVJlcXVlc3Quc2V0KHQsYSk7Y29uc3Qgbj1bXTtmb3IoY29uc3QgZSBvZiByKXtsZXQgcj10aGlzLl9yZXF1ZXN0c0J5Q2h1bmsuZ2V0KGUpO2lmKCFyKXtyPVtdO3RoaXMuX3JlcXVlc3RzQnlDaHVuay5zZXQoZSxyKTtuLnB1c2goZSl9ci5wdXNoKHQpfWlmKG4ubGVuZ3RoPjApe2NvbnN0IGU9dGhpcy5ncm91cENodW5rcyhuKTtmb3IoY29uc3QgdCBvZiBlKXtjb25zdCBlPXQuYmVnaW5DaHVuayp0aGlzLmNodW5rU2l6ZSxyPU1hdGgubWluKHQuZW5kQ2h1bmsqdGhpcy5jaHVua1NpemUsdGhpcy5sZW5ndGgpO3RoaXMuc2VuZFJlcXVlc3QoZSxyKS5jYXRjaChhLnJlamVjdCl9fXJldHVybiBhLnByb21pc2UuY2F0Y2goZT0+e2lmKCF0aGlzLmFib3J0ZWQpdGhyb3cgZX0pfWdldFN0cmVhbSgpe3JldHVybiB0aGlzLnN0cmVhbX1yZXF1ZXN0UmFuZ2UoZSx0KXt0PU1hdGgubWluKHQsdGhpcy5sZW5ndGgpO2NvbnN0IHI9dGhpcy5nZXRCZWdpbkNodW5rKGUpLGE9dGhpcy5nZXRFbmRDaHVuayh0KSxuPVtdO2ZvcihsZXQgZT1yO2U8YTsrK2Upbi5wdXNoKGUpO3JldHVybiB0aGlzLl9yZXF1ZXN0Q2h1bmtzKG4pfXJlcXVlc3RSYW5nZXMoZT1bXSl7Y29uc3QgdD1bXTtmb3IoY29uc3QgciBvZiBlKXtjb25zdCBlPXRoaXMuZ2V0QmVnaW5DaHVuayhyLmJlZ2luKSxhPXRoaXMuZ2V0RW5kQ2h1bmsoci5lbmQpO2ZvcihsZXQgcj1lO3I8YTsrK3IpdC5pbmNsdWRlcyhyKXx8dC5wdXNoKHIpfXQuc29ydCgoZSx0KT0+ZS10KTtyZXR1cm4gdGhpcy5fcmVxdWVzdENodW5rcyh0KX1ncm91cENodW5rcyhlKXtjb25zdCB0PVtdO2xldCByPS0xLGE9LTE7Zm9yKGxldCBuPTAsaT1lLmxlbmd0aDtuPGk7KytuKXtjb25zdCBpPWVbbl07cjwwJiYocj1pKTtpZihhPj0wJiZhKzEhPT1pKXt0LnB1c2goe2JlZ2luQ2h1bms6cixlbmRDaHVuazphKzF9KTtyPWl9bisxPT09ZS5sZW5ndGgmJnQucHVzaCh7YmVnaW5DaHVuazpyLGVuZENodW5rOmkrMX0pO2E9aX1yZXR1cm4gdH1vblByb2dyZXNzKGUpe3RoaXMubXNnSGFuZGxlci5zZW5kKCJEb2NQcm9ncmVzcyIse2xvYWRlZDp0aGlzLnN0cmVhbS5udW1DaHVua3NMb2FkZWQqdGhpcy5jaHVua1NpemUrZS5sb2FkZWQsdG90YWw6dGhpcy5sZW5ndGh9KX1vblJlY2VpdmVEYXRhKGUpe2NvbnN0IHQ9ZS5jaHVuayxyPXZvaWQgMD09PWUuYmVnaW4sYT1yP3RoaXMucHJvZ3Jlc3NpdmVEYXRhTGVuZ3RoOmUuYmVnaW4sbj1hK3QuYnl0ZUxlbmd0aCxpPU1hdGguZmxvb3IoYS90aGlzLmNodW5rU2l6ZSkscz1uPHRoaXMubGVuZ3RoP01hdGguZmxvb3Iobi90aGlzLmNodW5rU2l6ZSk6TWF0aC5jZWlsKG4vdGhpcy5jaHVua1NpemUpO2lmKHIpe3RoaXMuc3RyZWFtLm9uUmVjZWl2ZVByb2dyZXNzaXZlRGF0YSh0KTt0aGlzLnByb2dyZXNzaXZlRGF0YUxlbmd0aD1ufWVsc2UgdGhpcy5zdHJlYW0ub25SZWNlaXZlRGF0YShhLHQpO3RoaXMuc3RyZWFtLmlzRGF0YUxvYWRlZCYmdGhpcy5fbG9hZGVkU3RyZWFtQ2FwYWJpbGl0eS5yZXNvbHZlKHRoaXMuc3RyZWFtKTtjb25zdCBvPVtdO2ZvcihsZXQgZT1pO2U8czsrK2Upe2NvbnN0IHQ9dGhpcy5fcmVxdWVzdHNCeUNodW5rLmdldChlKTtpZih0KXt0aGlzLl9yZXF1ZXN0c0J5Q2h1bmsuZGVsZXRlKGUpO2Zvcihjb25zdCByIG9mIHQpe2NvbnN0IHQ9dGhpcy5fY2h1bmtzTmVlZGVkQnlSZXF1ZXN0LmdldChyKTt0LmhhcyhlKSYmdC5kZWxldGUoZSk7dC5zaXplPjB8fG8ucHVzaChyKX19fWlmKCF0aGlzLmRpc2FibGVBdXRvRmV0Y2gmJjA9PT10aGlzLl9yZXF1ZXN0c0J5Q2h1bmsuc2l6ZSl7bGV0IGU7aWYoMT09PXRoaXMuc3RyZWFtLm51bUNodW5rc0xvYWRlZCl7Y29uc3QgdD10aGlzLnN0cmVhbS5udW1DaHVua3MtMTt0aGlzLnN0cmVhbS5oYXNDaHVuayh0KXx8KGU9dCl9ZWxzZSBlPXRoaXMuc3RyZWFtLm5leHRFbXB0eUNodW5rKHMpO051bWJlci5pc0ludGVnZXIoZSkmJnRoaXMuX3JlcXVlc3RDaHVua3MoW2VdKX1mb3IoY29uc3QgZSBvZiBvKXtjb25zdCB0PXRoaXMuX3Byb21pc2VzQnlSZXF1ZXN0LmdldChlKTt0aGlzLl9wcm9taXNlc0J5UmVxdWVzdC5kZWxldGUoZSk7dC5yZXNvbHZlKCl9dGhpcy5tc2dIYW5kbGVyLnNlbmQoIkRvY1Byb2dyZXNzIix7bG9hZGVkOnRoaXMuc3RyZWFtLm51bUNodW5rc0xvYWRlZCp0aGlzLmNodW5rU2l6ZSx0b3RhbDp0aGlzLmxlbmd0aH0pfW9uRXJyb3IoZSl7dGhpcy5fbG9hZGVkU3RyZWFtQ2FwYWJpbGl0eS5yZWplY3QoZSl9Z2V0QmVnaW5DaHVuayhlKXtyZXR1cm4gTWF0aC5mbG9vcihlL3RoaXMuY2h1bmtTaXplKX1nZXRFbmRDaHVuayhlKXtyZXR1cm4gTWF0aC5mbG9vcigoZS0xKS90aGlzLmNodW5rU2l6ZSkrMX1hYm9ydChlKXt0aGlzLmFib3J0ZWQ9ITA7dGhpcy5wZGZOZXR3b3JrU3RyZWFtPy5jYW5jZWxBbGxSZXF1ZXN0cyhlKTtmb3IoY29uc3QgdCBvZiB0aGlzLl9wcm9taXNlc0J5UmVxdWVzdC52YWx1ZXMoKSl0LnJlamVjdChlKX19ZnVuY3Rpb24gY29udmVydFRvUkdCQShlKXtzd2l0Y2goZS5raW5kKXtjYXNlIHY6cmV0dXJuIGNvbnZlcnRCbGFja0FuZFdoaXRlVG9SR0JBKGUpO2Nhc2UgVDpyZXR1cm4gZnVuY3Rpb24gY29udmVydFJHQlRvUkdCQSh7c3JjOmUsc3JjUG9zOnQ9MCxkZXN0OnIsZGVzdFBvczphPTAsd2lkdGg6bixoZWlnaHQ6aX0pe2xldCBzPTA7Y29uc3Qgbz1uKmkqMyxjPW8+PjIsbD1uZXcgVWludDMyQXJyYXkoZS5idWZmZXIsdCxjKTtpZihGZWF0dXJlVGVzdC5pc0xpdHRsZUVuZGlhbil7Zm9yKDtzPGMtMjtzKz0zLGErPTQpe2NvbnN0IGU9bFtzXSx0PWxbcysxXSxuPWxbcysyXTtyW2FdPTQyNzgxOTAwODB8ZTtyW2ErMV09ZT4+PjI0fHQ8PDh8NDI3ODE5MDA4MDtyW2ErMl09dD4+PjE2fG48PDE2fDQyNzgxOTAwODA7clthKzNdPW4+Pj44fDQyNzgxOTAwODB9Zm9yKGxldCBuPTQqcyxpPXQrbztuPGk7bis9MylyW2ErK109ZVtuXXxlW24rMV08PDh8ZVtuKzJdPDwxNnw0Mjc4MTkwMDgwfWVsc2V7Zm9yKDtzPGMtMjtzKz0zLGErPTQpe2NvbnN0IGU9bFtzXSx0PWxbcysxXSxuPWxbcysyXTtyW2FdPTI1NXxlO3JbYSsxXT1lPDwyNHx0Pj4+OHwyNTU7clthKzJdPXQ8PDE2fG4+Pj4xNnwyNTU7clthKzNdPW48PDh8MjU1fWZvcihsZXQgbj00KnMsaT10K287bjxpO24rPTMpclthKytdPWVbbl08PDI0fGVbbisxXTw8MTZ8ZVtuKzJdPDw4fDI1NX1yZXR1cm57c3JjUG9zOnQrbyxkZXN0UG9zOmF9fShlKX1yZXR1cm4gbnVsbH1mdW5jdGlvbiBjb252ZXJ0QmxhY2tBbmRXaGl0ZVRvUkdCQSh7c3JjOmUsc3JjUG9zOnQ9MCxkZXN0OnIsd2lkdGg6YSxoZWlnaHQ6bixub25CbGFja0NvbG9yOmk9NDI5NDk2NzI5NSxpbnZlcnNlRGVjb2RlOnM9ITF9KXtjb25zdCBvPUZlYXR1cmVUZXN0LmlzTGl0dGxlRW5kaWFuPzQyNzgxOTAwODA6MjU1LFtjLGxdPXM/W2ksb106W28saV0saD1hPj4zLHU9NyZhLGQ9ZS5sZW5ndGg7cj1uZXcgVWludDMyQXJyYXkoci5idWZmZXIpO2xldCBmPTA7Zm9yKGxldCBhPTA7YTxuO2ErKyl7Zm9yKGNvbnN0IGE9dCtoO3Q8YTt0Kyspe2NvbnN0IGE9dDxkP2VbdF06MjU1O3JbZisrXT0xMjgmYT9sOmM7cltmKytdPTY0JmE/bDpjO3JbZisrXT0zMiZhP2w6YztyW2YrK109MTYmYT9sOmM7cltmKytdPTgmYT9sOmM7cltmKytdPTQmYT9sOmM7cltmKytdPTImYT9sOmM7cltmKytdPTEmYT9sOmN9aWYoMD09PXUpY29udGludWU7Y29uc3QgYT10PGQ/ZVt0KytdOjI1NTtmb3IobGV0IGU9MDtlPHU7ZSsrKXJbZisrXT1hJjE8PDctZT9sOmN9cmV0dXJue3NyY1Bvczp0LGRlc3RQb3M6Zn19Y2xhc3MgSW1hZ2VSZXNpemVye3N0YXRpYyNPPTIwNDg7c3RhdGljI009RmVhdHVyZVRlc3QuaXNJbWFnZURlY29kZXJTdXBwb3J0ZWQ7Y29uc3RydWN0b3IoZSx0KXt0aGlzLl9pbWdEYXRhPWU7dGhpcy5faXNNYXNrPXR9c3RhdGljIGdldCBjYW5Vc2VJbWFnZURlY29kZXIoKXtyZXR1cm4gc2hhZG93KHRoaXMsImNhblVzZUltYWdlRGVjb2RlciIsdGhpcy4jTT9JbWFnZURlY29kZXIuaXNUeXBlU3VwcG9ydGVkKCJpbWFnZS9ibXAiKTpQcm9taXNlLnJlc29sdmUoITEpKX1zdGF0aWMgbmVlZHNUb0JlUmVzaXplZChlLHQpe2lmKGU8PXRoaXMuI08mJnQ8PXRoaXMuI08pcmV0dXJuITE7Y29uc3R7TUFYX0RJTTpyfT10aGlzO2lmKGU+cnx8dD5yKXJldHVybiEwO2NvbnN0IGE9ZSp0O2lmKHRoaXMuX2hhc01heEFyZWEpcmV0dXJuIGE+dGhpcy5NQVhfQVJFQTtpZihhPHRoaXMuI08qKjIpcmV0dXJuITE7aWYodGhpcy5fYXJlR29vZERpbXMoZSx0KSl7dGhpcy4jTz1NYXRoLm1heCh0aGlzLiNPLE1hdGguZmxvb3IoTWF0aC5zcXJ0KGUqdCkpKTtyZXR1cm4hMX10aGlzLiNPPXRoaXMuX2d1ZXNzTWF4KHRoaXMuI08sciwxMjgsMCk7cmV0dXJuIGE+KHRoaXMuTUFYX0FSRUE9dGhpcy4jTyoqMil9c3RhdGljIGdldFJlZHVjZVBvd2VyRm9ySlBYKGUsdCxyKXtjb25zdCBhPWUqdCxuPTIqKjMwLyg0KnIpO2lmKCF0aGlzLm5lZWRzVG9CZVJlc2l6ZWQoZSx0KSlyZXR1cm4gYT5uP01hdGguY2VpbChNYXRoLmxvZzIoYS9uKSk6MDtjb25zdHtNQVhfRElNOmksTUFYX0FSRUE6c309dGhpcyxvPU1hdGgubWF4KGUvaSx0L2ksTWF0aC5zcXJ0KGEvTWF0aC5taW4obixzKSkpO3JldHVybiBNYXRoLmNlaWwoTWF0aC5sb2cyKG8pKX1zdGF0aWMgZ2V0IE1BWF9ESU0oKXtyZXR1cm4gc2hhZG93KHRoaXMsIk1BWF9ESU0iLHRoaXMuX2d1ZXNzTWF4KDIwNDgsNjU1MzcsMCwxKSl9c3RhdGljIGdldCBNQVhfQVJFQSgpe3RoaXMuX2hhc01heEFyZWE9ITA7cmV0dXJuIHNoYWRvdyh0aGlzLCJNQVhfQVJFQSIsdGhpcy5fZ3Vlc3NNYXgodGhpcy4jTyx0aGlzLk1BWF9ESU0sMTI4LDApKioyKX1zdGF0aWMgc2V0IE1BWF9BUkVBKGUpe2lmKGU+PTApe3RoaXMuX2hhc01heEFyZWE9ITA7c2hhZG93KHRoaXMsIk1BWF9BUkVBIixlKX19c3RhdGljIHNldE9wdGlvbnMoe2NhbnZhc01heEFyZWFJbkJ5dGVzOmU9LTEsaXNJbWFnZURlY29kZXJTdXBwb3J0ZWQ6dD0hMX0pe3RoaXMuX2hhc01heEFyZWF8fCh0aGlzLk1BWF9BUkVBPWU+PjIpO3RoaXMuI009dH1zdGF0aWMgX2FyZUdvb2REaW1zKGUsdCl7dHJ5e2NvbnN0IHI9bmV3IE9mZnNjcmVlbkNhbnZhcyhlLHQpLGE9ci5nZXRDb250ZXh0KCIyZCIpO2EuZmlsbFJlY3QoMCwwLDEsMSk7Y29uc3Qgbj1hLmdldEltYWdlRGF0YSgwLDAsMSwxKS5kYXRhWzNdO3Iud2lkdGg9ci5oZWlnaHQ9MTtyZXR1cm4gMCE9PW59Y2F0Y2h7cmV0dXJuITF9fXN0YXRpYyBfZ3Vlc3NNYXgoZSx0LHIsYSl7Zm9yKDtlK3IrMTx0Oyl7Y29uc3Qgcj1NYXRoLmZsb29yKChlK3QpLzIpLG49YXx8cjt0aGlzLl9hcmVHb29kRGltcyhyLG4pP2U9cjp0PXJ9cmV0dXJuIGV9c3RhdGljIGFzeW5jIGNyZWF0ZUltYWdlKGUsdD0hMSl7cmV0dXJuIG5ldyBJbWFnZVJlc2l6ZXIoZSx0KS5fY3JlYXRlSW1hZ2UoKX1hc3luYyBfY3JlYXRlSW1hZ2UoKXtjb25zdHtfaW1nRGF0YTplfT10aGlzLHt3aWR0aDp0LGhlaWdodDpyfT1lO2lmKHQqcio0PmRyKXtjb25zdCBlPXRoaXMuI0QoKTtpZihlKXJldHVybiBlfWNvbnN0IGE9dGhpcy5fZW5jb2RlQk1QKCk7bGV0IG4saTtpZihhd2FpdCBJbWFnZVJlc2l6ZXIuY2FuVXNlSW1hZ2VEZWNvZGVyKXtuPW5ldyBJbWFnZURlY29kZXIoe2RhdGE6YSx0eXBlOiJpbWFnZS9ibXAiLHByZWZlckFuaW1hdGlvbjohMSx0cmFuc2ZlcjpbYS5idWZmZXJdfSk7aT1uLmRlY29kZSgpLmNhdGNoKGU9Pnt3YXJuKGBCTVAgaW1hZ2UgZGVjb2RpbmcgZmFpbGVkOiAke2V9YCk7cmV0dXJuIGNyZWF0ZUltYWdlQml0bWFwKG5ldyBCbG9iKFt0aGlzLl9lbmNvZGVCTVAoKS5idWZmZXJdLHt0eXBlOiJpbWFnZS9ibXAifSkpfSkuZmluYWxseSgoKT0+e24uY2xvc2UoKX0pfWVsc2UgaT1jcmVhdGVJbWFnZUJpdG1hcChuZXcgQmxvYihbYS5idWZmZXJdLHt0eXBlOiJpbWFnZS9ibXAifSkpO2NvbnN0e01BWF9BUkVBOnMsTUFYX0RJTTpvfT1JbWFnZVJlc2l6ZXIsYz1NYXRoLm1heCh0L28sci9vLE1hdGguc3FydCh0KnIvcykpLGw9TWF0aC5tYXgoYywyKSxoPU1hdGgucm91bmQoMTAqKGMrMS4yNSkpLzEwL2wsdT1NYXRoLmZsb29yKE1hdGgubG9nMihoKSksZD1uZXcgQXJyYXkodSsyKS5maWxsKDIpO2RbMF09bDtkLnNwbGljZSgtMSwxLGgvKDE8PHUpKTtsZXQgZj10LGc9cjtjb25zdCBwPWF3YWl0IGk7bGV0IG09cC5pbWFnZXx8cDtmb3IoY29uc3QgZSBvZiBkKXtjb25zdCB0PWYscj1nO2Y9TWF0aC5mbG9vcihmL2UpLTE7Zz1NYXRoLmZsb29yKGcvZSktMTtjb25zdCBhPW5ldyBPZmZzY3JlZW5DYW52YXMoZixnKTthLmdldENvbnRleHQoIjJkIikuZHJhd0ltYWdlKG0sMCwwLHQsciwwLDAsZixnKTttLmNsb3NlKCk7bT1hLnRyYW5zZmVyVG9JbWFnZUJpdG1hcCgpfWUuZGF0YT1udWxsO2UuYml0bWFwPW07ZS53aWR0aD1mO2UuaGVpZ2h0PWc7cmV0dXJuIGV9I0QoKXtjb25zdHtfaW1nRGF0YTplfT10aGlzLHtkYXRhOnQsd2lkdGg6cixoZWlnaHQ6YSxraW5kOm59PWUsaT1yKmEqNCxzPU1hdGguY2VpbChNYXRoLmxvZzIoaS9kcikpLG89cj4+cyxjPWE+PnM7bGV0IGwsaD1hO3RyeXtsPW5ldyBVaW50OEFycmF5KGkpfWNhdGNoe2xldCBlPU1hdGguZmxvb3IoTWF0aC5sb2cyKGkrMSkpO2Zvcig7Oyl0cnl7bD1uZXcgVWludDhBcnJheSgyKiplLTEpO2JyZWFrfWNhdGNoe2UtPTF9aD1NYXRoLmZsb29yKCgyKiplLTEpLyg0KnIpKTtjb25zdCB0PXIqaCo0O3Q8bC5sZW5ndGgmJihsPW5ldyBVaW50OEFycmF5KHQpKX1jb25zdCB1PW5ldyBVaW50MzJBcnJheShsLmJ1ZmZlciksZD1uZXcgVWludDMyQXJyYXkobypjKTtsZXQgZj0wLGc9MDtjb25zdCBwPU1hdGguY2VpbChhL2gpLG09YSVoPT09MD9hOmElaDtmb3IobGV0IGU9MDtlPHA7ZSsrKXtjb25zdCBhPWU8cC0xP2g6bTsoe3NyY1BvczpmfT1jb252ZXJ0VG9SR0JBKHtraW5kOm4sc3JjOnQsZGVzdDp1LHdpZHRoOnIsaGVpZ2h0OmEsaW52ZXJzZURlY29kZTp0aGlzLl9pc01hc2ssc3JjUG9zOmZ9KSk7Zm9yKGxldCBlPTAsdD1hPj5zO2U8dDtlKyspe2NvbnN0IHQ9dS5zdWJhcnJheSgoZTw8cykqcik7Zm9yKGxldCBlPTA7ZTxvO2UrKylkW2crK109dFtlPDxzXX19aWYoSW1hZ2VSZXNpemVyLm5lZWRzVG9CZVJlc2l6ZWQobyxjKSl7ZS5kYXRhPWQ7ZS53aWR0aD1vO2UuaGVpZ2h0PWM7ZS5raW5kPU87cmV0dXJuIG51bGx9Y29uc3QgYj1uZXcgT2Zmc2NyZWVuQ2FudmFzKG8sYyk7Yi5nZXRDb250ZXh0KCIyZCIse3dpbGxSZWFkRnJlcXVlbnRseTohMH0pLnB1dEltYWdlRGF0YShuZXcgSW1hZ2VEYXRhKG5ldyBVaW50OENsYW1wZWRBcnJheShkLmJ1ZmZlciksbyxjKSwwLDApO2UuZGF0YT1udWxsO2UuYml0bWFwPWIudHJhbnNmZXJUb0ltYWdlQml0bWFwKCk7ZS53aWR0aD1vO2UuaGVpZ2h0PWM7cmV0dXJuIGV9X2VuY29kZUJNUCgpe2NvbnN0e3dpZHRoOmUsaGVpZ2h0OnQsa2luZDpyfT10aGlzLl9pbWdEYXRhO2xldCBhLG49dGhpcy5faW1nRGF0YS5kYXRhLGk9bmV3IFVpbnQ4QXJyYXkoMCkscz1pLG89MDtzd2l0Y2gocil7Y2FzZSB2OnthPTE7aT1uZXcgVWludDhBcnJheSh0aGlzLl9pc01hc2s/WzI1NSwyNTUsMjU1LDI1NSwwLDAsMCwwXTpbMCwwLDAsMCwyNTUsMjU1LDI1NSwyNTVdKTtjb25zdCByPWUrNz4+MyxzPXIrMyYtNDtpZihyIT09cyl7Y29uc3QgZT1uZXcgVWludDhBcnJheShzKnQpO2xldCBhPTA7Zm9yKGxldCBpPTAsbz10KnI7aTxvO2krPXIsYSs9cyllLnNldChuLnN1YmFycmF5KGksaStyKSxhKTtuPWV9YnJlYWt9Y2FzZSBUOmE9MjQ7aWYoMyZlKXtjb25zdCByPTMqZSxhPXIrMyYtNCxpPWEtcixzPW5ldyBVaW50OEFycmF5KGEqdCk7bGV0IG89MDtmb3IobGV0IGU9MCxhPXQqcjtlPGE7ZSs9cil7Y29uc3QgdD1uLnN1YmFycmF5KGUsZStyKTtmb3IobGV0IGU9MDtlPHI7ZSs9Myl7c1tvKytdPXRbZSsyXTtzW28rK109dFtlKzFdO3NbbysrXT10W2VdfW8rPWl9bj1zfWVsc2UgZm9yKGxldCBlPTAsdD1uLmxlbmd0aDtlPHQ7ZSs9Myl7Y29uc3QgdD1uW2VdO25bZV09bltlKzJdO25bZSsyXT10fWJyZWFrO2Nhc2UgTzphPTMyO289MztzPW5ldyBVaW50OEFycmF5KDY4KTtjb25zdCByPW5ldyBEYXRhVmlldyhzLmJ1ZmZlcik7aWYoRmVhdHVyZVRlc3QuaXNMaXR0bGVFbmRpYW4pe3Iuc2V0VWludDMyKDAsMjU1LCEwKTtyLnNldFVpbnQzMig0LDY1MjgwLCEwKTtyLnNldFVpbnQzMig4LDE2NzExNjgwLCEwKTtyLnNldFVpbnQzMigxMiw0Mjc4MTkwMDgwLCEwKX1lbHNle3Iuc2V0VWludDMyKDAsNDI3ODE5MDA4MCwhMCk7ci5zZXRVaW50MzIoNCwxNjcxMTY4MCwhMCk7ci5zZXRVaW50MzIoOCw2NTI4MCwhMCk7ci5zZXRVaW50MzIoMTIsMjU1LCEwKX1icmVhaztkZWZhdWx0OnRocm93IG5ldyBFcnJvcigiaW52YWxpZCBmb3JtYXQiKX1sZXQgYz0wO2NvbnN0IGw9NDArcy5sZW5ndGgsaD0xNCtsK2kubGVuZ3RoK24ubGVuZ3RoLHU9bmV3IFVpbnQ4QXJyYXkoaCksZD1uZXcgRGF0YVZpZXcodS5idWZmZXIpO2Quc2V0VWludDE2KGMsMTk3NzgsITApO2MrPTI7ZC5zZXRVaW50MzIoYyxoLCEwKTtjKz00O2Quc2V0VWludDMyKGMsMCwhMCk7Yys9NDtkLnNldFVpbnQzMihjLDE0K2wraS5sZW5ndGgsITApO2MrPTQ7ZC5zZXRVaW50MzIoYyxsLCEwKTtjKz00O2Quc2V0SW50MzIoYyxlLCEwKTtjKz00O2Quc2V0SW50MzIoYywtdCwhMCk7Yys9NDtkLnNldFVpbnQxNihjLDEsITApO2MrPTI7ZC5zZXRVaW50MTYoYyxhLCEwKTtjKz0yO2Quc2V0VWludDMyKGMsbywhMCk7Yys9NDtkLnNldFVpbnQzMihjLDAsITApO2MrPTQ7ZC5zZXRJbnQzMihjLDAsITApO2MrPTQ7ZC5zZXRJbnQzMihjLDAsITApO2MrPTQ7ZC5zZXRVaW50MzIoYyxpLmxlbmd0aC80LCEwKTtjKz00O2Quc2V0VWludDMyKGMsMCwhMCk7Yys9NDt1LnNldChzLGMpO2MrPXMubGVuZ3RoO3Uuc2V0KGksYyk7Yys9aS5sZW5ndGg7dS5zZXQobixjKTtyZXR1cm4gdX19Y29uc3QgQ3I9bmV3IFVpbnQ4QXJyYXkoMCk7Y2xhc3MgRGVjb2RlU3RyZWFtIGV4dGVuZHMgQmFzZVN0cmVhbXtjb25zdHJ1Y3RvcihlKXtzdXBlcigpO3RoaXMuX3Jhd01pbkJ1ZmZlckxlbmd0aD1lfHwwO3RoaXMucG9zPTA7dGhpcy5idWZmZXJMZW5ndGg9MDt0aGlzLmVvZj0hMTt0aGlzLmJ1ZmZlcj1Dcjt0aGlzLm1pbkJ1ZmZlckxlbmd0aD01MTI7aWYoZSlmb3IoO3RoaXMubWluQnVmZmVyTGVuZ3RoPGU7KXRoaXMubWluQnVmZmVyTGVuZ3RoKj0yfWdldCBpc0VtcHR5KCl7Zm9yKDshdGhpcy5lb2YmJjA9PT10aGlzLmJ1ZmZlckxlbmd0aDspdGhpcy5yZWFkQmxvY2soKTtyZXR1cm4gMD09PXRoaXMuYnVmZmVyTGVuZ3RofWVuc3VyZUJ1ZmZlcihlKXtjb25zdCB0PXRoaXMuYnVmZmVyO2lmKGU8PXQuYnl0ZUxlbmd0aClyZXR1cm4gdDtsZXQgcj10aGlzLm1pbkJ1ZmZlckxlbmd0aDtmb3IoO3I8ZTspcio9Mjtjb25zdCBhPW5ldyBVaW50OEFycmF5KHIpO2Euc2V0KHQpO3JldHVybiB0aGlzLmJ1ZmZlcj1hfWdldEJ5dGUoKXtjb25zdCBlPXRoaXMucG9zO2Zvcig7dGhpcy5idWZmZXJMZW5ndGg8PWU7KXtpZih0aGlzLmVvZilyZXR1cm4tMTt0aGlzLnJlYWRCbG9jaygpfXJldHVybiB0aGlzLmJ1ZmZlclt0aGlzLnBvcysrXX1nZXRCeXRlcyhlLHQ9bnVsbCl7Y29uc3Qgcj10aGlzLnBvcztsZXQgYTtpZihlKXt0aGlzLmVuc3VyZUJ1ZmZlcihyK2UpO2E9citlO2Zvcig7IXRoaXMuZW9mJiZ0aGlzLmJ1ZmZlckxlbmd0aDxhOyl0aGlzLnJlYWRCbG9jayh0KTtjb25zdCBuPXRoaXMuYnVmZmVyTGVuZ3RoO2E+biYmKGE9bil9ZWxzZXtmb3IoOyF0aGlzLmVvZjspdGhpcy5yZWFkQmxvY2sodCk7YT10aGlzLmJ1ZmZlckxlbmd0aH10aGlzLnBvcz1hO3JldHVybiB0aGlzLmJ1ZmZlci5zdWJhcnJheShyLGEpfWFzeW5jIGdldEltYWdlRGF0YShlLHQpe2lmKCF0aGlzLmNhbkFzeW5jRGVjb2RlSW1hZ2VGcm9tQnVmZmVyKXJldHVybiB0aGlzLmlzQXN5bmNEZWNvZGVyP3RoaXMuZGVjb2RlSW1hZ2UobnVsbCx0KTp0aGlzLmdldEJ5dGVzKGUsdCk7Y29uc3Qgcj1hd2FpdCB0aGlzLnN0cmVhbS5hc3luY0dldEJ5dGVzKCk7cmV0dXJuIHRoaXMuZGVjb2RlSW1hZ2Uocix0KX1yZXNldCgpe3RoaXMucG9zPTB9bWFrZVN1YlN0cmVhbShlLHQscj1udWxsKXtpZih2b2lkIDA9PT10KWZvcig7IXRoaXMuZW9mOyl0aGlzLnJlYWRCbG9jaygpO2Vsc2V7Y29uc3Qgcj1lK3Q7Zm9yKDt0aGlzLmJ1ZmZlckxlbmd0aDw9ciYmIXRoaXMuZW9mOyl0aGlzLnJlYWRCbG9jaygpfXJldHVybiBuZXcgU3RyZWFtKHRoaXMuYnVmZmVyLGUsdCxyKX1nZXRCYXNlU3RyZWFtcygpe3JldHVybiB0aGlzLnN0cj90aGlzLnN0ci5nZXRCYXNlU3RyZWFtcygpOm51bGx9fWNsYXNzIFN0cmVhbXNTZXF1ZW5jZVN0cmVhbSBleHRlbmRzIERlY29kZVN0cmVhbXtjb25zdHJ1Y3RvcihlLHQ9bnVsbCl7ZT1lLmZpbHRlcihlPT5lIGluc3RhbmNlb2YgQmFzZVN0cmVhbSk7bGV0IHI9MDtmb3IoY29uc3QgdCBvZiBlKXIrPXQgaW5zdGFuY2VvZiBEZWNvZGVTdHJlYW0/dC5fcmF3TWluQnVmZmVyTGVuZ3RoOnQubGVuZ3RoO3N1cGVyKHIpO3RoaXMuc3RyZWFtcz1lO3RoaXMuX29uRXJyb3I9dH1yZWFkQmxvY2soKXtjb25zdCBlPXRoaXMuc3RyZWFtcztpZigwPT09ZS5sZW5ndGgpe3RoaXMuZW9mPSEwO3JldHVybn1jb25zdCB0PWUuc2hpZnQoKTtsZXQgcjt0cnl7cj10LmdldEJ5dGVzKCl9Y2F0Y2goZSl7aWYodGhpcy5fb25FcnJvcil7dGhpcy5fb25FcnJvcihlLHQuZGljdD8ub2JqSWQpO3JldHVybn10aHJvdyBlfWNvbnN0IGE9dGhpcy5idWZmZXJMZW5ndGgsbj1hK3IubGVuZ3RoO3RoaXMuZW5zdXJlQnVmZmVyKG4pLnNldChyLGEpO3RoaXMuYnVmZmVyTGVuZ3RoPW59Z2V0QmFzZVN0cmVhbXMoKXtjb25zdCBlPVtdO2Zvcihjb25zdCB0IG9mIHRoaXMuc3RyZWFtcyl7Y29uc3Qgcj10LmdldEJhc2VTdHJlYW1zKCk7ciYmZS5wdXNoKC4uLnIpfXJldHVybiBlLmxlbmd0aD4wP2U6bnVsbH19Y2xhc3MgQ29sb3JTcGFjZVV0aWxze3N0YXRpYyBwYXJzZSh7Y3M6ZSx4cmVmOnQscmVzb3VyY2VzOnI9bnVsbCxwZGZGdW5jdGlvbkZhY3Rvcnk6YSxnbG9iYWxDb2xvclNwYWNlQ2FjaGU6bixsb2NhbENvbG9yU3BhY2VDYWNoZTppLGFzeW5jSWZOb3RDYWNoZWQ6cz0hMX0pe2NvbnN0IG89e3hyZWY6dCxyZXNvdXJjZXM6cixwZGZGdW5jdGlvbkZhY3Rvcnk6YSxnbG9iYWxDb2xvclNwYWNlQ2FjaGU6bixsb2NhbENvbG9yU3BhY2VDYWNoZTppfTtsZXQgYyxsLGg7aWYoZSBpbnN0YW5jZW9mIFJlZil7bD1lO2NvbnN0IHI9bi5nZXRCeVJlZihsKXx8aS5nZXRCeVJlZihsKTtpZihyKXJldHVybiByO2U9dC5mZXRjaChlKX1pZihlIGluc3RhbmNlb2YgTmFtZSl7Yz1lLm5hbWU7Y29uc3QgdD1pLmdldEJ5TmFtZShjKTtpZih0KXJldHVybiB0fXRyeXtoPXRoaXMuI0IoZSxvKX1jYXRjaChlKXtpZihzJiYhKGUgaW5zdGFuY2VvZiBNaXNzaW5nRGF0YUV4Y2VwdGlvbikpcmV0dXJuIFByb21pc2UucmVqZWN0KGUpO3Rocm93IGV9aWYoY3x8bCl7aS5zZXQoYyxsLGgpO2wmJm4uc2V0KG51bGwsbCxoKX1yZXR1cm4gcz9Qcm9taXNlLnJlc29sdmUoaCk6aH1zdGF0aWMjUihlLHQpe2NvbnN0e2dsb2JhbENvbG9yU3BhY2VDYWNoZTpyfT10O2xldCBhO2lmKGUgaW5zdGFuY2VvZiBSZWYpe2E9ZTtjb25zdCB0PXIuZ2V0QnlSZWYoYSk7aWYodClyZXR1cm4gdH1jb25zdCBuPXRoaXMuI0IoZSx0KTthJiZyLnNldChudWxsLGEsbik7cmV0dXJuIG59c3RhdGljI0IoZSx0KXtjb25zdHt4cmVmOnIscmVzb3VyY2VzOmEscGRmRnVuY3Rpb25GYWN0b3J5Om4sZ2xvYmFsQ29sb3JTcGFjZUNhY2hlOml9PXQ7aWYoKGU9ci5mZXRjaElmUmVmKGUpKWluc3RhbmNlb2YgTmFtZSlzd2l0Y2goZS5uYW1lKXtjYXNlIkciOmNhc2UiRGV2aWNlR3JheSI6cmV0dXJuIHRoaXMuZ3JheTtjYXNlIlJHQiI6Y2FzZSJEZXZpY2VSR0IiOnJldHVybiB0aGlzLnJnYjtjYXNlIkRldmljZVJHQkEiOnJldHVybiB0aGlzLnJnYmE7Y2FzZSJDTVlLIjpjYXNlIkRldmljZUNNWUsiOnJldHVybiB0aGlzLmNteWs7Y2FzZSJQYXR0ZXJuIjpyZXR1cm4gbmV3IFBhdHRlcm5DUyhudWxsKTtkZWZhdWx0OmlmKGEgaW5zdGFuY2VvZiBEaWN0KXtjb25zdCByPWEuZ2V0KCJDb2xvclNwYWNlIik7aWYociBpbnN0YW5jZW9mIERpY3Qpe2NvbnN0IGE9ci5nZXQoZS5uYW1lKTtpZihhKXtpZihhIGluc3RhbmNlb2YgTmFtZSlyZXR1cm4gdGhpcy4jQihhLHQpO2U9YTticmVha319fXdhcm4oYFVucmVjb2duaXplZCBDb2xvclNwYWNlOiAke2UubmFtZX1gKTtyZXR1cm4gdGhpcy5ncmF5fWlmKEFycmF5LmlzQXJyYXkoZSkpe2NvbnN0IGE9ci5mZXRjaElmUmVmKGVbMF0pLm5hbWU7bGV0IHMsbyxjLGwsaCx1O3N3aXRjaChhKXtjYXNlIkciOmNhc2UiRGV2aWNlR3JheSI6cmV0dXJuIHRoaXMuZ3JheTtjYXNlIlJHQiI6Y2FzZSJEZXZpY2VSR0IiOnJldHVybiB0aGlzLnJnYjtjYXNlIkNNWUsiOmNhc2UiRGV2aWNlQ01ZSyI6cmV0dXJuIHRoaXMuY215aztjYXNlIkNhbEdyYXkiOnM9ci5mZXRjaElmUmVmKGVbMV0pO2w9cy5nZXRBcnJheSgiV2hpdGVQb2ludCIpO2g9cy5nZXRBcnJheSgiQmxhY2tQb2ludCIpO3U9cy5nZXQoIkdhbW1hIik7cmV0dXJuIG5ldyBDYWxHcmF5Q1MobCxoLHUpO2Nhc2UiQ2FsUkdCIjpzPXIuZmV0Y2hJZlJlZihlWzFdKTtsPXMuZ2V0QXJyYXkoIldoaXRlUG9pbnQiKTtoPXMuZ2V0QXJyYXkoIkJsYWNrUG9pbnQiKTt1PXMuZ2V0QXJyYXkoIkdhbW1hIik7Y29uc3QgZD1zLmdldEFycmF5KCJNYXRyaXgiKTtyZXR1cm4gbmV3IENhbFJHQkNTKGwsaCx1LGQpO2Nhc2UiSUNDQmFzZWQiOmNvbnN0IGY9ZVsxXWluc3RhbmNlb2YgUmVmO2lmKGYpe2NvbnN0IHQ9aS5nZXRCeVJlZihlWzFdKTtpZih0KXJldHVybiB0fWNvbnN0IGc9ci5mZXRjaElmUmVmKGVbMV0pLHA9Zy5kaWN0O289cC5nZXQoIk4iKTtpZihJY2NDb2xvclNwYWNlLmlzVXNhYmxlKXRyeXtjb25zdCB0PW5ldyBJY2NDb2xvclNwYWNlKGcuZ2V0Qnl0ZXMoKSwiSUNDQmFzZWQiLG8pO2YmJmkuc2V0KG51bGwsZVsxXSx0KTtyZXR1cm4gdH1jYXRjaCh0KXtpZih0IGluc3RhbmNlb2YgTWlzc2luZ0RhdGFFeGNlcHRpb24pdGhyb3cgdDt3YXJuKGBJQ0NCYXNlZCBjb2xvciBzcGFjZSAoJHtlWzFdfSk6ICIke3R9Ii5gKX1jb25zdCBtPXAuZ2V0UmF3KCJBbHRlcm5hdGUiKTtpZihtKXtjb25zdCBlPXRoaXMuI1IobSx0KTtpZihlLm51bUNvbXBzPT09bylyZXR1cm4gZTt3YXJuKCJJQ0NCYXNlZCBjb2xvciBzcGFjZTogSWdub3JpbmcgaW5jb3JyZWN0IC9BbHRlcm5hdGUgZW50cnkuIil9aWYoMT09PW8pcmV0dXJuIHRoaXMuZ3JheTtpZigzPT09bylyZXR1cm4gdGhpcy5yZ2I7aWYoND09PW8pcmV0dXJuIHRoaXMuY215azticmVhaztjYXNlIlBhdHRlcm4iOmM9ZVsxXXx8bnVsbDtjJiYoYz10aGlzLiNSKGMsdCkpO3JldHVybiBuZXcgUGF0dGVybkNTKGMpO2Nhc2UiSSI6Y2FzZSJJbmRleGVkIjpjPXRoaXMuI1IoZVsxXSx0KTtjb25zdCBiPU1hdGhDbGFtcChyLmZldGNoSWZSZWYoZVsyXSksMCwyNTUpLHk9ci5mZXRjaElmUmVmKGVbM10pO3JldHVybiBuZXcgSW5kZXhlZENTKGMsYix5KTtjYXNlIlNlcGFyYXRpb24iOmNhc2UiRGV2aWNlTiI6Y29uc3Qgdz1yLmZldGNoSWZSZWYoZVsxXSk7bz1BcnJheS5pc0FycmF5KHcpP3cubGVuZ3RoOjE7Yz10aGlzLiNSKGVbMl0sdCk7Y29uc3QgeD1uLmNyZWF0ZShlWzNdKTtyZXR1cm4gbmV3IEFsdGVybmF0ZUNTKG8sYyx4KTtjYXNlIkxhYiI6cz1yLmZldGNoSWZSZWYoZVsxXSk7bD1zLmdldEFycmF5KCJXaGl0ZVBvaW50Iik7aD1zLmdldEFycmF5KCJCbGFja1BvaW50Iik7Y29uc3QgUz1zLmdldEFycmF5KCJSYW5nZSIpO3JldHVybiBuZXcgTGFiQ1MobCxoLFMpO2RlZmF1bHQ6d2FybihgVW5pbXBsZW1lbnRlZCBDb2xvclNwYWNlIG9iamVjdDogJHthfWApO3JldHVybiB0aGlzLmdyYXl9fXdhcm4oYFVucmVjb2duaXplZCBDb2xvclNwYWNlIG9iamVjdDogJHtlfWApO3JldHVybiB0aGlzLmdyYXl9c3RhdGljIGdldCBncmF5KCl7cmV0dXJuIHNoYWRvdyh0aGlzLCJncmF5IixuZXcgRGV2aWNlR3JheUNTKX1zdGF0aWMgZ2V0IHJnYigpe3JldHVybiBzaGFkb3codGhpcywicmdiIixuZXcgRGV2aWNlUmdiQ1MpfXN0YXRpYyBnZXQgcmdiYSgpe3JldHVybiBzaGFkb3codGhpcywicmdiYSIsbmV3IERldmljZVJnYmFDUyl9c3RhdGljIGdldCBjbXlrKCl7aWYoQ215a0lDQ0Jhc2VkQ1MuaXNVc2FibGUpdHJ5e3JldHVybiBzaGFkb3codGhpcywiY215ayIsbmV3IENteWtJQ0NCYXNlZENTKX1jYXRjaHt3YXJuKCJDTVlLIGZhbGxiYWNrOiBEZXZpY2VDTVlLIil9cmV0dXJuIHNoYWRvdyh0aGlzLCJjbXlrIixuZXcgRGV2aWNlQ215a0NTKX19Y2xhc3MgSnBlZ0Vycm9yIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSl7c3VwZXIoZSwiSnBlZ0Vycm9yIil9fWNsYXNzIEROTE1hcmtlckVycm9yIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSx0KXtzdXBlcihlLCJETkxNYXJrZXJFcnJvciIpO3RoaXMuc2NhbkxpbmVzPXR9fWNsYXNzIEVPSU1hcmtlckVycm9yIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSl7c3VwZXIoZSwiRU9JTWFya2VyRXJyb3IiKX19Y29uc3QgdnI9bmV3IFVpbnQ4QXJyYXkoWzAsMSw4LDE2LDksMiwzLDEwLDE3LDI0LDMyLDI1LDE4LDExLDQsNSwxMiwxOSwyNiwzMyw0MCw0OCw0MSwzNCwyNywyMCwxMyw2LDcsMTQsMjEsMjgsMzUsNDIsNDksNTYsNTcsNTAsNDMsMzYsMjksMjIsMTUsMjMsMzAsMzcsNDQsNTEsNTgsNTksNTIsNDUsMzgsMzEsMzksNDYsNTMsNjAsNjEsNTQsNDcsNTUsNjIsNjNdKSxGcj00MDE3LElyPTc5OSxUcj0zNDA2LE9yPTIyNzYsTXI9MTU2NyxEcj0zNzg0LFJyPTU3OTMsRXI9Mjg5NjtmdW5jdGlvbiBidWlsZEh1ZmZtYW5UYWJsZShlLHQpe2xldCByLGEsbj0wLGk9MTY7Zm9yKDtpPjAmJiFlW2ktMV07KWktLTtjb25zdCBzPVt7Y2hpbGRyZW46W10saW5kZXg6MH1dO2xldCBvLGM9c1swXTtmb3Iocj0wO3I8aTtyKyspe2ZvcihhPTA7YTxlW3JdO2ErKyl7Yz1zLnBvcCgpO2MuY2hpbGRyZW5bYy5pbmRleF09dFtuXTtmb3IoO2MuaW5kZXg+MDspYz1zLnBvcCgpO2MuaW5kZXgrKztzLnB1c2goYyk7Zm9yKDtzLmxlbmd0aDw9cjspe3MucHVzaChvPXtjaGlsZHJlbjpbXSxpbmRleDowfSk7Yy5jaGlsZHJlbltjLmluZGV4XT1vLmNoaWxkcmVuO2M9b31uKyt9aWYocisxPGkpe3MucHVzaChvPXtjaGlsZHJlbjpbXSxpbmRleDowfSk7Yy5jaGlsZHJlbltjLmluZGV4XT1vLmNoaWxkcmVuO2M9b319cmV0dXJuIHNbMF0uY2hpbGRyZW59ZnVuY3Rpb24gZ2V0QmxvY2tCdWZmZXJPZmZzZXQoZSx0LHIpe3JldHVybiA2NCooKGUuYmxvY2tzUGVyTGluZSsxKSp0K3IpfWZ1bmN0aW9uIGRlY29kZVNjYW4oZSx0LHIsYSxuLGkscyxvLGMsbD0hMSl7Y29uc3QgaD1yLm1jdXNQZXJMaW5lLHU9ci5wcm9ncmVzc2l2ZSxkPXQ7bGV0IGY9MCxnPTA7ZnVuY3Rpb24gcmVhZEJpdCgpe2lmKGc+MCl7Zy0tO3JldHVybiBmPj5nJjF9Zj1lW3QrK107aWYoMjU1PT09Zil7Y29uc3QgYT1lW3QrK107aWYoYSl7aWYoMjIwPT09YSYmbCl7Y29uc3QgYT1yZWFkVWludDE2KGUsdCs9Mik7dCs9MjtpZihhPjAmJmEhPT1yLnNjYW5MaW5lcyl0aHJvdyBuZXcgRE5MTWFya2VyRXJyb3IoIkZvdW5kIEROTCBtYXJrZXIgKDB4RkZEQykgd2hpbGUgcGFyc2luZyBzY2FuIGRhdGEiLGEpfWVsc2UgaWYoMjE3PT09YSl7aWYobCl7Y29uc3QgZT15Kig4PT09ci5wcmVjaXNpb24/ODowKTtpZihlPjAmJk1hdGgucm91bmQoci5zY2FuTGluZXMvZSk+PTUpdGhyb3cgbmV3IEROTE1hcmtlckVycm9yKCJGb3VuZCBFT0kgbWFya2VyICgweEZGRDkpIHdoaWxlIHBhcnNpbmcgc2NhbiBkYXRhLCBwb3NzaWJseSBjYXVzZWQgYnkgaW5jb3JyZWN0IGBzY2FuTGluZXNgIHBhcmFtZXRlciIsZSl9dGhyb3cgbmV3IEVPSU1hcmtlckVycm9yKCJGb3VuZCBFT0kgbWFya2VyICgweEZGRDkpIHdoaWxlIHBhcnNpbmcgc2NhbiBkYXRhIil9dGhyb3cgbmV3IEpwZWdFcnJvcihgdW5leHBlY3RlZCBtYXJrZXIgJHsoZjw8OHxhKS50b1N0cmluZygxNil9YCl9fWc9NztyZXR1cm4gZj4+Pjd9ZnVuY3Rpb24gZGVjb2RlSHVmZm1hbihlKXtsZXQgdD1lO2Zvcig7Oyl7dD10W3JlYWRCaXQoKV07c3dpdGNoKHR5cGVvZiB0KXtjYXNlIm51bWJlciI6cmV0dXJuIHQ7Y2FzZSJvYmplY3QiOmNvbnRpbnVlfXRocm93IG5ldyBKcGVnRXJyb3IoImludmFsaWQgaHVmZm1hbiBzZXF1ZW5jZSIpfX1mdW5jdGlvbiByZWNlaXZlKGUpe2xldCB0PTA7Zm9yKDtlPjA7KXt0PXQ8PDF8cmVhZEJpdCgpO2UtLX1yZXR1cm4gdH1mdW5jdGlvbiByZWNlaXZlQW5kRXh0ZW5kKGUpe2lmKDE9PT1lKXJldHVybiAxPT09cmVhZEJpdCgpPzE6LTE7Y29uc3QgdD1yZWNlaXZlKGUpO3JldHVybiB0Pj0xPDxlLTE/dDp0KygtMTw8ZSkrMX1sZXQgcD0wO2xldCBtLGI9MDtsZXQgeT0wO2Z1bmN0aW9uIGRlY29kZU1jdShlLHQscixhLG4pe2NvbnN0IGk9ciVoO3k9KHIvaHwwKSplLnYrYTtjb25zdCBzPWkqZS5oK247dChlLGdldEJsb2NrQnVmZmVyT2Zmc2V0KGUseSxzKSl9ZnVuY3Rpb24gZGVjb2RlQmxvY2soZSx0LHIpe3k9ci9lLmJsb2Nrc1BlckxpbmV8MDtjb25zdCBhPXIlZS5ibG9ja3NQZXJMaW5lO3QoZSxnZXRCbG9ja0J1ZmZlck9mZnNldChlLHksYSkpfWNvbnN0IHc9YS5sZW5ndGg7bGV0IHgsUyxrLEMsdixUO1Q9dT8wPT09aT8wPT09bz9mdW5jdGlvbiBkZWNvZGVEQ0ZpcnN0KGUsdCl7Y29uc3Qgcj1kZWNvZGVIdWZmbWFuKGUuaHVmZm1hblRhYmxlREMpLGE9MD09PXI/MDpyZWNlaXZlQW5kRXh0ZW5kKHIpPDxjO2UuYmxvY2tEYXRhW3RdPWUucHJlZCs9YX06ZnVuY3Rpb24gZGVjb2RlRENTdWNjZXNzaXZlKGUsdCl7ZS5ibG9ja0RhdGFbdF18PXJlYWRCaXQoKTw8Y306MD09PW8/ZnVuY3Rpb24gZGVjb2RlQUNGaXJzdChlLHQpe2lmKHA+MCl7cC0tO3JldHVybn1sZXQgcj1pO2NvbnN0IGE9cztmb3IoO3I8PWE7KXtjb25zdCBhPWRlY29kZUh1ZmZtYW4oZS5odWZmbWFuVGFibGVBQyksbj0xNSZhLGk9YT4+NDtpZigwPT09bil7aWYoaTwxNSl7cD1yZWNlaXZlKGkpKygxPDxpKS0xO2JyZWFrfXIrPTE2O2NvbnRpbnVlfXIrPWk7Y29uc3Qgcz12cltyXTtlLmJsb2NrRGF0YVt0K3NdPXJlY2VpdmVBbmRFeHRlbmQobikqKDE8PGMpO3IrK319OmZ1bmN0aW9uIGRlY29kZUFDU3VjY2Vzc2l2ZShlLHQpe2xldCByPWk7Y29uc3QgYT1zO2xldCBuLG8sbD0wO2Zvcig7cjw9YTspe2NvbnN0IGE9dCt2cltyXSxpPWUuYmxvY2tEYXRhW2FdPDA/LTE6MTtzd2l0Y2goYil7Y2FzZSAwOm89ZGVjb2RlSHVmZm1hbihlLmh1ZmZtYW5UYWJsZUFDKTtuPTE1Jm87bD1vPj40O2lmKDA9PT1uKWlmKGw8MTUpe3A9cmVjZWl2ZShsKSsoMTw8bCk7Yj00fWVsc2V7bD0xNjtiPTF9ZWxzZXtpZigxIT09bil0aHJvdyBuZXcgSnBlZ0Vycm9yKCJpbnZhbGlkIEFDbiBlbmNvZGluZyIpO209cmVjZWl2ZUFuZEV4dGVuZChuKTtiPWw/MjozfWNvbnRpbnVlO2Nhc2UgMTpjYXNlIDI6aWYoZS5ibG9ja0RhdGFbYV0pZS5ibG9ja0RhdGFbYV0rPWkqKHJlYWRCaXQoKTw8Yyk7ZWxzZXtsLS07MD09PWwmJihiPTI9PT1iPzM6MCl9YnJlYWs7Y2FzZSAzOmlmKGUuYmxvY2tEYXRhW2FdKWUuYmxvY2tEYXRhW2FdKz1pKihyZWFkQml0KCk8PGMpO2Vsc2V7ZS5ibG9ja0RhdGFbYV09bTw8YztiPTB9YnJlYWs7Y2FzZSA0OmUuYmxvY2tEYXRhW2FdJiYoZS5ibG9ja0RhdGFbYV0rPWkqKHJlYWRCaXQoKTw8YykpfXIrK31pZig0PT09Yil7cC0tOzA9PT1wJiYoYj0wKX19OmZ1bmN0aW9uIGRlY29kZUJhc2VsaW5lKGUsdCl7Y29uc3Qgcj1kZWNvZGVIdWZmbWFuKGUuaHVmZm1hblRhYmxlREMpLGE9MD09PXI/MDpyZWNlaXZlQW5kRXh0ZW5kKHIpO2UuYmxvY2tEYXRhW3RdPWUucHJlZCs9YTtsZXQgbj0xO2Zvcig7bjw2NDspe2NvbnN0IHI9ZGVjb2RlSHVmZm1hbihlLmh1ZmZtYW5UYWJsZUFDKSxhPTE1JnIsaT1yPj40O2lmKDA9PT1hKXtpZihpPDE1KWJyZWFrO24rPTE2O2NvbnRpbnVlfW4rPWk7Y29uc3Qgcz12cltuXTtlLmJsb2NrRGF0YVt0K3NdPXJlY2VpdmVBbmRFeHRlbmQoYSk7bisrfX07bGV0IE8sTT0wO2NvbnN0IEQ9MT09PXc/YVswXS5ibG9ja3NQZXJMaW5lKmFbMF0uYmxvY2tzUGVyQ29sdW1uOmgqci5tY3VzUGVyQ29sdW1uO2xldCBSLEU7Zm9yKDtNPD1EOyl7Y29uc3Qgcj1uP01hdGgubWluKEQtTSxuKTpEO2lmKHI+MCl7Zm9yKFM9MDtTPHc7UysrKWFbU10ucHJlZD0wO3A9MDtpZigxPT09dyl7eD1hWzBdO2Zvcih2PTA7djxyO3YrKyl7ZGVjb2RlQmxvY2soeCxULE0pO00rK319ZWxzZSBmb3Iodj0wO3Y8cjt2Kyspe2ZvcihTPTA7Uzx3O1MrKyl7eD1hW1NdO1I9eC5oO0U9eC52O2ZvcihrPTA7azxFO2srKylmb3IoQz0wO0M8UjtDKyspZGVjb2RlTWN1KHgsVCxNLGssQyl9TSsrfX1nPTA7Tz1maW5kTmV4dEZpbGVNYXJrZXIoZSx0KTtpZighTylicmVhaztpZihPLmludmFsaWQpe3dhcm4oYGRlY29kZVNjYW4gLSAke3I+MD8idW5leHBlY3RlZCI6ImV4Y2Vzc2l2ZSJ9IE1DVSBkYXRhLCBjdXJyZW50IG1hcmtlciBpczogJHtPLmludmFsaWR9YCk7dD1PLm9mZnNldH1pZighKE8ubWFya2VyPj02NTQ4OCYmTy5tYXJrZXI8PTY1NDk1KSlicmVhazt0Kz0yfXJldHVybiB0LWR9ZnVuY3Rpb24gcXVhbnRpemVBbmRJbnZlcnNlKGUsdCxyKXtjb25zdCBhPWUucXVhbnRpemF0aW9uVGFibGUsbj1lLmJsb2NrRGF0YTtsZXQgaSxzLG8sYyxsLGgsdSxkLGYsZyxwLG0sYix5LHcseCxTO2lmKCFhKXRocm93IG5ldyBKcGVnRXJyb3IoIm1pc3NpbmcgcmVxdWlyZWQgUXVhbnRpemF0aW9uIFRhYmxlLiIpO2ZvcihsZXQgZT0wO2U8NjQ7ZSs9OCl7Zj1uW3QrZV07Zz1uW3QrZSsxXTtwPW5bdCtlKzJdO209blt0K2UrM107Yj1uW3QrZSs0XTt5PW5bdCtlKzVdO3c9blt0K2UrNl07eD1uW3QrZSs3XTtmKj1hW2VdO2lmKDAhPT0oZ3xwfG18Ynx5fHd8eCkpe2cqPWFbZSsxXTtwKj1hW2UrMl07bSo9YVtlKzNdO2IqPWFbZSs0XTt5Kj1hW2UrNV07dyo9YVtlKzZdO3gqPWFbZSs3XTtpPVJyKmYrMTI4Pj44O3M9UnIqYisxMjg+Pjg7bz1wO2M9dztsPUVyKihnLXgpKzEyOD4+ODtkPUVyKihnK3gpKzEyOD4+ODtoPW08PDQ7dT15PDw0O2k9aStzKzE+PjE7cz1pLXM7Uz1vKkRyK2MqTXIrMTI4Pj44O289bypNci1jKkRyKzEyOD4+ODtjPVM7bD1sK3UrMT4+MTt1PWwtdTtkPWQraCsxPj4xO2g9ZC1oO2k9aStjKzE+PjE7Yz1pLWM7cz1zK28rMT4+MTtvPXMtbztTPWwqT3IrZCpUcisyMDQ4Pj4xMjtsPWwqVHItZCpPcisyMDQ4Pj4xMjtkPVM7Uz1oKklyK3UqRnIrMjA0OD4+MTI7aD1oKkZyLXUqSXIrMjA0OD4+MTI7dT1TO3JbZV09aStkO3JbZSs3XT1pLWQ7cltlKzFdPXMrdTtyW2UrNl09cy11O3JbZSsyXT1vK2g7cltlKzVdPW8taDtyW2UrM109YytsO3JbZSs0XT1jLWx9ZWxzZXtTPVJyKmYrNTEyPj4xMDtyW2VdPVM7cltlKzFdPVM7cltlKzJdPVM7cltlKzNdPVM7cltlKzRdPVM7cltlKzVdPVM7cltlKzZdPVM7cltlKzddPVN9fWZvcihsZXQgZT0wO2U8ODsrK2Upe2Y9cltlXTtnPXJbZSs4XTtwPXJbZSsxNl07bT1yW2UrMjRdO2I9cltlKzMyXTt5PXJbZSs0MF07dz1yW2UrNDhdO3g9cltlKzU2XTtpZigwIT09KGd8cHxtfGJ8eXx3fHgpKXtpPVJyKmYrMjA0OD4+MTI7cz1ScipiKzIwNDg+PjEyO289cDtjPXc7bD1FciooZy14KSsyMDQ4Pj4xMjtkPUVyKihnK3gpKzIwNDg+PjEyO2g9bTt1PXk7aT00MTEyKyhpK3MrMT4+MSk7cz1pLXM7Uz1vKkRyK2MqTXIrMjA0OD4+MTI7bz1vKk1yLWMqRHIrMjA0OD4+MTI7Yz1TO2w9bCt1KzE+PjE7dT1sLXU7ZD1kK2grMT4+MTtoPWQtaDtpPWkrYysxPj4xO2M9aS1jO3M9cytvKzE+PjE7bz1zLW87Uz1sKk9yK2QqVHIrMjA0OD4+MTI7bD1sKlRyLWQqT3IrMjA0OD4+MTI7ZD1TO1M9aCpJcit1KkZyKzIwNDg+PjEyO2g9aCpGci11KklyKzIwNDg+PjEyO3U9UztmPWkrZDt4PWktZDtnPXMrdTt3PXMtdTtwPW8raDt5PW8taDttPWMrbDtiPWMtbDtmPDE2P2Y9MDpmPj00MDgwP2Y9MjU1OmY+Pj00O2c8MTY/Zz0wOmc+PTQwODA/Zz0yNTU6Zz4+PTQ7cDwxNj9wPTA6cD49NDA4MD9wPTI1NTpwPj49NDttPDE2P209MDptPj00MDgwP209MjU1Om0+Pj00O2I8MTY/Yj0wOmI+PTQwODA/Yj0yNTU6Yj4+PTQ7eTwxNj95PTA6eT49NDA4MD95PTI1NTp5Pj49NDt3PDE2P3c9MDp3Pj00MDgwP3c9MjU1Onc+Pj00O3g8MTY/eD0wOng+PTQwODA/eD0yNTU6eD4+PTQ7blt0K2VdPWY7blt0K2UrOF09ZztuW3QrZSsxNl09cDtuW3QrZSsyNF09bTtuW3QrZSszMl09YjtuW3QrZSs0MF09eTtuW3QrZSs0OF09dztuW3QrZSs1Nl09eH1lbHNle1M9UnIqZis4MTkyPj4xNDtTPVM8LTIwNDA/MDpTPj0yMDI0PzI1NTpTKzIwNTY+PjQ7blt0K2VdPVM7blt0K2UrOF09UztuW3QrZSsxNl09UztuW3QrZSsyNF09UztuW3QrZSszMl09UztuW3QrZSs0MF09UztuW3QrZSs0OF09UztuW3QrZSs1Nl09U319fWZ1bmN0aW9uIGJ1aWxkQ29tcG9uZW50RGF0YShlLHQpe2NvbnN0IHI9dC5ibG9ja3NQZXJMaW5lLGE9dC5ibG9ja3NQZXJDb2x1bW4sbj1uZXcgSW50MTZBcnJheSg2NCk7Zm9yKGxldCBlPTA7ZTxhO2UrKylmb3IobGV0IGE9MDthPHI7YSsrKXtxdWFudGl6ZUFuZEludmVyc2UodCxnZXRCbG9ja0J1ZmZlck9mZnNldCh0LGUsYSksbil9cmV0dXJuIHQuYmxvY2tEYXRhfWZ1bmN0aW9uIGZpbmROZXh0RmlsZU1hcmtlcihlLHQscj10KXtjb25zdCBhPWUubGVuZ3RoLTE7bGV0IG49cjx0P3I6dDtpZih0Pj1hKXJldHVybiBudWxsO2NvbnN0IGk9cmVhZFVpbnQxNihlLHQpO2lmKGk+PTY1NDcyJiZpPD02NTUzNClyZXR1cm57aW52YWxpZDpudWxsLG1hcmtlcjppLG9mZnNldDp0fTtsZXQgcz1yZWFkVWludDE2KGUsbik7Zm9yKDshKHM+PTY1NDcyJiZzPD02NTUzNCk7KXtpZigrK24+PWEpcmV0dXJuIG51bGw7cz1yZWFkVWludDE2KGUsbil9cmV0dXJue2ludmFsaWQ6aS50b1N0cmluZygxNiksbWFya2VyOnMsb2Zmc2V0Om59fWZ1bmN0aW9uIHByZXBhcmVDb21wb25lbnRzKGUpe2NvbnN0IHQ9TWF0aC5jZWlsKGUuc2FtcGxlc1BlckxpbmUvOC9lLm1heEgpLHI9TWF0aC5jZWlsKGUuc2NhbkxpbmVzLzgvZS5tYXhWKTtmb3IoY29uc3QgYSBvZiBlLmNvbXBvbmVudHMpe2NvbnN0IG49TWF0aC5jZWlsKE1hdGguY2VpbChlLnNhbXBsZXNQZXJMaW5lLzgpKmEuaC9lLm1heEgpLGk9TWF0aC5jZWlsKE1hdGguY2VpbChlLnNjYW5MaW5lcy84KSphLnYvZS5tYXhWKSxzPXQqYS5oLG89NjQqKHIqYS52KSoocysxKTthLmJsb2NrRGF0YT1uZXcgSW50MTZBcnJheShvKTthLmJsb2Nrc1BlckxpbmU9bjthLmJsb2Nrc1BlckNvbHVtbj1pfWUubWN1c1BlckxpbmU9dDtlLm1jdXNQZXJDb2x1bW49cn1mdW5jdGlvbiByZWFkRGF0YUJsb2NrKGUsdCl7Y29uc3Qgcj1yZWFkVWludDE2KGUsdCk7bGV0IGE9KHQrPTIpK3ItMjtjb25zdCBuPWZpbmROZXh0RmlsZU1hcmtlcihlLGEsdCk7aWYobj8uaW52YWxpZCl7d2FybigicmVhZERhdGFCbG9jayAtIGluY29ycmVjdCBsZW5ndGgsIGN1cnJlbnQgbWFya2VyIGlzOiAiK24uaW52YWxpZCk7YT1uLm9mZnNldH1jb25zdCBpPWUuc3ViYXJyYXkodCxhKTtyZXR1cm57YXBwRGF0YTppLG9sZE9mZnNldDp0LG5ld09mZnNldDp0K2kubGVuZ3RofX1mdW5jdGlvbiBza2lwRGF0YShlLHQpe2NvbnN0IHI9cmVhZFVpbnQxNihlLHQpLGE9KHQrPTIpK3ItMixuPWZpbmROZXh0RmlsZU1hcmtlcihlLGEsdCk7cmV0dXJuIG4/LmludmFsaWQ/bi5vZmZzZXQ6YX1jbGFzcyBKcGVnSW1hZ2V7Y29uc3RydWN0b3Ioe2RlY29kZVRyYW5zZm9ybTplPW51bGwsY29sb3JUcmFuc2Zvcm06dD0tMX09e30pe3RoaXMuX2RlY29kZVRyYW5zZm9ybT1lO3RoaXMuX2NvbG9yVHJhbnNmb3JtPXR9c3RhdGljIGNhblVzZUltYWdlRGVjb2RlcihlLHQ9LTEpe2xldCByPW51bGwsYT0wLG49bnVsbCxpPXJlYWRVaW50MTYoZSxhKTthKz0yO2lmKDY1NDk2IT09aSl0aHJvdyBuZXcgSnBlZ0Vycm9yKCJTT0kgbm90IGZvdW5kIik7aT1yZWFkVWludDE2KGUsYSk7YSs9MjtlOmZvcig7NjU0OTchPT1pOyl7c3dpdGNoKGkpe2Nhc2UgNjU1MDU6Y29uc3R7YXBwRGF0YTp0LG9sZE9mZnNldDpzLG5ld09mZnNldDpvfT1yZWFkRGF0YUJsb2NrKGUsYSk7YT1vO2lmKDY5PT09dFswXSYmMTIwPT09dFsxXSYmMTA1PT09dFsyXSYmMTAyPT09dFszXSYmMD09PXRbNF0mJjA9PT10WzVdKXtpZihyKXRocm93IG5ldyBKcGVnRXJyb3IoIkR1cGxpY2F0ZSBFWElGLWJsb2NrcyBmb3VuZC4iKTtyPXtleGlmU3RhcnQ6cys2LGV4aWZFbmQ6b319aT1yZWFkVWludDE2KGUsYSk7YSs9Mjtjb250aW51ZTtjYXNlIDY1NDcyOmNhc2UgNjU0NzM6Y2FzZSA2NTQ3NDpuPWVbYSs3XTticmVhayBlO2Nhc2UgNjU1MzU6MjU1IT09ZVthXSYmYS0tfWE9c2tpcERhdGEoZSxhKTtpPXJlYWRVaW50MTYoZSxhKTthKz0yfXJldHVybiA0PT09bnx8Mz09PW4mJjA9PT10P251bGw6cnx8e319cGFyc2UoZSx7ZG5sU2NhbkxpbmVzOnQ9bnVsbH09e30pe2xldCByLGEsbj0wLGk9bnVsbCxzPW51bGwsbz0wO2NvbnN0IGM9W10sbD1bXSxoPVtdO2xldCB1PXJlYWRVaW50MTYoZSxuKTtuKz0yO2lmKDY1NDk2IT09dSl0aHJvdyBuZXcgSnBlZ0Vycm9yKCJTT0kgbm90IGZvdW5kIik7dT1yZWFkVWludDE2KGUsbik7bis9MjtlOmZvcig7NjU0OTchPT11Oyl7bGV0IGQsZixnO3N3aXRjaCh1KXtjYXNlIDY1NTA0OmNhc2UgNjU1MDU6Y2FzZSA2NTUwNjpjYXNlIDY1NTA3OmNhc2UgNjU1MDg6Y2FzZSA2NTUwOTpjYXNlIDY1NTEwOmNhc2UgNjU1MTE6Y2FzZSA2NTUxMjpjYXNlIDY1NTEzOmNhc2UgNjU1MTQ6Y2FzZSA2NTUxNTpjYXNlIDY1NTE2OmNhc2UgNjU1MTc6Y2FzZSA2NTUxODpjYXNlIDY1NTE5OmNhc2UgNjU1MzQ6Y29uc3R7YXBwRGF0YTpwLG5ld09mZnNldDptfT1yZWFkRGF0YUJsb2NrKGUsbik7bj1tOzY1NTA0PT09dSYmNzQ9PT1wWzBdJiY3MD09PXBbMV0mJjczPT09cFsyXSYmNzA9PT1wWzNdJiYwPT09cFs0XSYmKGk9e3ZlcnNpb246e21ham9yOnBbNV0sbWlub3I6cFs2XX0sZGVuc2l0eVVuaXRzOnBbN10seERlbnNpdHk6cFs4XTw8OHxwWzldLHlEZW5zaXR5OnBbMTBdPDw4fHBbMTFdLHRodW1iV2lkdGg6cFsxMl0sdGh1bWJIZWlnaHQ6cFsxM10sdGh1bWJEYXRhOnAuc3ViYXJyYXkoMTQsMTQrMypwWzEyXSpwWzEzXSl9KTs2NTUxOD09PXUmJjY1PT09cFswXSYmMTAwPT09cFsxXSYmMTExPT09cFsyXSYmOTg9PT1wWzNdJiYxMDE9PT1wWzRdJiYocz17dmVyc2lvbjpwWzVdPDw4fHBbNl0sZmxhZ3MwOnBbN108PDh8cFs4XSxmbGFnczE6cFs5XTw8OHxwWzEwXSx0cmFuc2Zvcm1Db2RlOnBbMTFdfSk7YnJlYWs7Y2FzZSA2NTQ5OTpjb25zdCBiPXJlYWRVaW50MTYoZSxuKTtuKz0yO2NvbnN0IHk9YituLTI7bGV0IHc7Zm9yKDtuPHk7KXtjb25zdCB0PWVbbisrXSxyPW5ldyBVaW50MTZBcnJheSg2NCk7aWYodD4+NCl7aWYodD4+NCE9MSl0aHJvdyBuZXcgSnBlZ0Vycm9yKCJEUVQgLSBpbnZhbGlkIHRhYmxlIHNwZWMiKTtmb3IoZj0wO2Y8NjQ7ZisrKXt3PXZyW2ZdO3Jbd109cmVhZFVpbnQxNihlLG4pO24rPTJ9fWVsc2UgZm9yKGY9MDtmPDY0O2YrKyl7dz12cltmXTtyW3ddPWVbbisrXX1jWzE1JnRdPXJ9YnJlYWs7Y2FzZSA2NTQ3MjpjYXNlIDY1NDczOmNhc2UgNjU0NzQ6aWYocil0aHJvdyBuZXcgSnBlZ0Vycm9yKCJPbmx5IHNpbmdsZSBmcmFtZSBKUEVHcyBzdXBwb3J0ZWQiKTtuKz0yO3I9e307ci5leHRlbmRlZD02NTQ3Mz09PXU7ci5wcm9ncmVzc2l2ZT02NTQ3ND09PXU7ci5wcmVjaXNpb249ZVtuKytdO2NvbnN0IHg9cmVhZFVpbnQxNihlLG4pO24rPTI7ci5zY2FuTGluZXM9dHx8eDtyLnNhbXBsZXNQZXJMaW5lPXJlYWRVaW50MTYoZSxuKTtuKz0yO3IuY29tcG9uZW50cz1bXTtyLmNvbXBvbmVudElkcz17fTtjb25zdCBTPWVbbisrXTtsZXQgaz0wLEM9MDtmb3IoZD0wO2Q8UztkKyspe2NvbnN0IHQ9ZVtuXSxhPWVbbisxXT4+NCxpPTE1JmVbbisxXTtrPGEmJihrPWEpO0M8aSYmKEM9aSk7Y29uc3Qgcz1lW24rMl07Zz1yLmNvbXBvbmVudHMucHVzaCh7aDphLHY6aSxxdWFudGl6YXRpb25JZDpzLHF1YW50aXphdGlvblRhYmxlOm51bGx9KTtyLmNvbXBvbmVudElkc1t0XT1nLTE7bis9M31yLm1heEg9aztyLm1heFY9QztwcmVwYXJlQ29tcG9uZW50cyhyKTticmVhaztjYXNlIDY1NDc2OmNvbnN0IHY9cmVhZFVpbnQxNihlLG4pO24rPTI7Zm9yKGQ9MjtkPHY7KXtjb25zdCB0PWVbbisrXSxyPW5ldyBVaW50OEFycmF5KDE2KTtsZXQgYT0wO2ZvcihmPTA7ZjwxNjtmKyssbisrKWErPXJbZl09ZVtuXTtjb25zdCBpPW5ldyBVaW50OEFycmF5KGEpO2ZvcihmPTA7ZjxhO2YrKyxuKyspaVtmXT1lW25dO2QrPTE3K2E7KHQ+PjQ/bDpoKVsxNSZ0XT1idWlsZEh1ZmZtYW5UYWJsZShyLGkpfWJyZWFrO2Nhc2UgNjU1MDE6bis9MjthPXJlYWRVaW50MTYoZSxuKTtuKz0yO2JyZWFrO2Nhc2UgNjU0OTg6Y29uc3QgVD0xPT09KytvJiYhdDtuKz0yO2NvbnN0IE89ZVtuKytdLE09W107Zm9yKGQ9MDtkPE87ZCsrKXtjb25zdCB0PWVbbisrXSxhPXIuY29tcG9uZW50SWRzW3RdLGk9ci5jb21wb25lbnRzW2FdO2kuaW5kZXg9dDtjb25zdCBzPWVbbisrXTtpLmh1ZmZtYW5UYWJsZURDPWhbcz4+NF07aS5odWZmbWFuVGFibGVBQz1sWzE1JnNdO00ucHVzaChpKX1jb25zdCBEPWVbbisrXSxSPWVbbisrXSxFPWVbbisrXTt0cnl7bis9ZGVjb2RlU2NhbihlLG4scixNLGEsRCxSLEU+PjQsMTUmRSxUKX1jYXRjaCh0KXtpZih0IGluc3RhbmNlb2YgRE5MTWFya2VyRXJyb3Ipe3dhcm4oYCR7dC5tZXNzYWdlfSAtLSBhdHRlbXB0aW5nIHRvIHJlLXBhcnNlIHRoZSBKUEVHIGltYWdlLmApO3JldHVybiB0aGlzLnBhcnNlKGUse2RubFNjYW5MaW5lczp0LnNjYW5MaW5lc30pfWlmKHQgaW5zdGFuY2VvZiBFT0lNYXJrZXJFcnJvcil7d2FybihgJHt0Lm1lc3NhZ2V9IC0tIGlnbm9yaW5nIHRoZSByZXN0IG9mIHRoZSBpbWFnZSBkYXRhLmApO2JyZWFrIGV9dGhyb3cgdH1icmVhaztjYXNlIDY1NTAwOm4rPTQ7YnJlYWs7Y2FzZSA2NTUzNToyNTUhPT1lW25dJiZuLS07YnJlYWs7ZGVmYXVsdDpjb25zdCBOPWZpbmROZXh0RmlsZU1hcmtlcihlLG4tMixuLTMpO2lmKE4/LmludmFsaWQpe3dhcm4oIkpwZWdJbWFnZS5wYXJzZSAtIHVuZXhwZWN0ZWQgZGF0YSwgY3VycmVudCBtYXJrZXIgaXM6ICIrTi5pbnZhbGlkKTtuPU4ub2Zmc2V0O2JyZWFrfWlmKCFOfHxuPj1lLmxlbmd0aC0xKXt3YXJuKCJKcGVnSW1hZ2UucGFyc2UgLSByZWFjaGVkIHRoZSBlbmQgb2YgdGhlIGltYWdlIGRhdGEgd2l0aG91dCBmaW5kaW5nIGFuIEVPSSBtYXJrZXIgKDB4RkZEOSkuIik7YnJlYWsgZX10aHJvdyBuZXcgSnBlZ0Vycm9yKCJKcGVnSW1hZ2UucGFyc2UgLSB1bmtub3duIG1hcmtlcjogIit1LnRvU3RyaW5nKDE2KSl9dT1yZWFkVWludDE2KGUsbik7bis9Mn1pZighcil0aHJvdyBuZXcgSnBlZ0Vycm9yKCJKcGVnSW1hZ2UucGFyc2UgLSBubyBmcmFtZSBkYXRhIGZvdW5kLiIpO3RoaXMud2lkdGg9ci5zYW1wbGVzUGVyTGluZTt0aGlzLmhlaWdodD1yLnNjYW5MaW5lczt0aGlzLmpmaWY9aTt0aGlzLmFkb2JlPXM7dGhpcy5jb21wb25lbnRzPVtdO2Zvcihjb25zdCBlIG9mIHIuY29tcG9uZW50cyl7Y29uc3QgdD1jW2UucXVhbnRpemF0aW9uSWRdO3QmJihlLnF1YW50aXphdGlvblRhYmxlPXQpO3RoaXMuY29tcG9uZW50cy5wdXNoKHtpbmRleDplLmluZGV4LG91dHB1dDpidWlsZENvbXBvbmVudERhdGEoMCxlKSxzY2FsZVg6ZS5oL3IubWF4SCxzY2FsZVk6ZS52L3IubWF4VixibG9ja3NQZXJMaW5lOmUuYmxvY2tzUGVyTGluZSxibG9ja3NQZXJDb2x1bW46ZS5ibG9ja3NQZXJDb2x1bW59KX10aGlzLm51bUNvbXBvbmVudHM9dGhpcy5jb21wb25lbnRzLmxlbmd0aH1fZ2V0TGluZWFyaXplZEJsb2NrRGF0YShlLHQscj0hMSl7Y29uc3QgYT10aGlzLndpZHRoL2Usbj10aGlzLmhlaWdodC90O2xldCBpLHMsbyxjLGwsaCx1LGQsZixnLHAsbT0wO2NvbnN0IGI9dGhpcy5jb21wb25lbnRzLmxlbmd0aCx5PWUqdCpiLHc9bmV3IFVpbnQ4Q2xhbXBlZEFycmF5KHkpLHg9bmV3IFVpbnQzMkFycmF5KGUpLFM9NDI5NDk2NzI4ODtsZXQgaztmb3IodT0wO3U8Yjt1Kyspe2k9dGhpcy5jb21wb25lbnRzW3VdO3M9aS5zY2FsZVgqYTtvPWkuc2NhbGVZKm47bT11O3A9aS5vdXRwdXQ7Yz1pLmJsb2Nrc1BlckxpbmUrMTw8MztpZihzIT09ayl7Zm9yKGw9MDtsPGU7bCsrKXtkPTB8bCpzO3hbbF09KGQmUyk8PDN8NyZkfWs9c31mb3IoaD0wO2g8dDtoKyspe2Q9MHxoKm87Zz1jKihkJlMpfCg3JmQpPDwzO2ZvcihsPTA7bDxlO2wrKyl7d1ttXT1wW2creFtsXV07bSs9Yn19fWxldCBDPXRoaXMuX2RlY29kZVRyYW5zZm9ybTtyfHw0IT09Ynx8Q3x8KEM9bmV3IEludDMyQXJyYXkoWy0yNTYsMjU1LC0yNTYsMjU1LC0yNTYsMjU1LC0yNTYsMjU1XSkpO2lmKEMpZm9yKHU9MDt1PHk7KWZvcihkPTAsZj0wO2Q8YjtkKyssdSsrLGYrPTIpd1t1XT0od1t1XSpDW2ZdPj44KStDW2YrMV07cmV0dXJuIHd9Z2V0IF9pc0NvbG9yQ29udmVyc2lvbk5lZWRlZCgpe3JldHVybiB0aGlzLmFkb2JlPyEhdGhpcy5hZG9iZS50cmFuc2Zvcm1Db2RlOjM9PT10aGlzLm51bUNvbXBvbmVudHM/MCE9PXRoaXMuX2NvbG9yVHJhbnNmb3JtJiYoODIhPT10aGlzLmNvbXBvbmVudHNbMF0uaW5kZXh8fDcxIT09dGhpcy5jb21wb25lbnRzWzFdLmluZGV4fHw2NiE9PXRoaXMuY29tcG9uZW50c1syXS5pbmRleCk6MT09PXRoaXMuX2NvbG9yVHJhbnNmb3JtfV9jb252ZXJ0WWNjVG9SZ2IoZSl7bGV0IHQscixhO2ZvcihsZXQgbj0wLGk9ZS5sZW5ndGg7bjxpO24rPTMpe3Q9ZVtuXTtyPWVbbisxXTthPWVbbisyXTtlW25dPXQtMTc5LjQ1NisxLjQwMiphO2VbbisxXT10KzEzNS40NTktLjM0NCpyLS43MTQqYTtlW24rMl09dC0yMjYuODE2KzEuNzcyKnJ9cmV0dXJuIGV9X2NvbnZlcnRZY2NUb1JnYmEoZSx0KXtmb3IobGV0IHI9MCxhPTAsbj1lLmxlbmd0aDtyPG47cis9MyxhKz00KXtjb25zdCBuPWVbcl0saT1lW3IrMV0scz1lW3IrMl07dFthXT1uLTE3OS40NTYrMS40MDIqczt0W2ErMV09bisxMzUuNDU5LS4zNDQqaS0uNzE0KnM7dFthKzJdPW4tMjI2LjgxNisxLjc3MippO3RbYSszXT0yNTV9cmV0dXJuIHR9X2NvbnZlcnRZY2NrVG9SZ2IoZSl7dGhpcy5fY29udmVydFljY2tUb0NteWsoZSk7cmV0dXJuIHRoaXMuX2NvbnZlcnRDbXlrVG9SZ2IoZSl9X2NvbnZlcnRZY2NrVG9SZ2JhKGUpe3RoaXMuX2NvbnZlcnRZY2NrVG9DbXlrKGUpO3JldHVybiB0aGlzLl9jb252ZXJ0Q215a1RvUmdiYShlKX1fY29udmVydFljY2tUb0NteWsoZSl7bGV0IHQscixhO2ZvcihsZXQgbj0wLGk9ZS5sZW5ndGg7bjxpO24rPTQpe3Q9ZVtuXTtyPWVbbisxXTthPWVbbisyXTtlW25dPTQzNC40NTYtdC0xLjQwMiphO2VbbisxXT0xMTkuNTQxLXQrLjM0NCpyKy43MTQqYTtlW24rMl09NDgxLjgxNi10LTEuNzcyKnJ9cmV0dXJuIGV9X2NvbnZlcnRDbXlrVG9SZ2IoZSl7Y29uc3QgdD1lLmxlbmd0aC80O0NvbG9yU3BhY2VVdGlscy5jbXlrLmdldFJnYkJ1ZmZlcihlLDAsdCxlLDAsOCwwKTtyZXR1cm4gZS5zdWJhcnJheSgwLDMqdCl9X2NvbnZlcnRDbXlrVG9SZ2JhKGUpe0NvbG9yU3BhY2VVdGlscy5jbXlrLmdldFJnYkJ1ZmZlcihlLDAsZS5sZW5ndGgvNCxlLDAsOCwxKTtpZihDb2xvclNwYWNlVXRpbHMuY215ayBpbnN0YW5jZW9mIERldmljZUNteWtDUylmb3IobGV0IHQ9MyxyPWUubGVuZ3RoO3Q8cjt0Kz00KWVbdF09MjU1O3JldHVybiBlfWdldERhdGEoe3dpZHRoOmUsaGVpZ2h0OnQsZm9yY2VSR0JBOnI9ITEsZm9yY2VSR0I6YT0hMSxpc1NvdXJjZVBERjpuPSExfSl7aWYodGhpcy5udW1Db21wb25lbnRzPjQpdGhyb3cgbmV3IEpwZWdFcnJvcigiVW5zdXBwb3J0ZWQgY29sb3IgbW9kZSIpO2NvbnN0IGk9dGhpcy5fZ2V0TGluZWFyaXplZEJsb2NrRGF0YShlLHQsbik7aWYoMT09PXRoaXMubnVtQ29tcG9uZW50cyYmKHJ8fGEpKXtjb25zdCBlPWkubGVuZ3RoKihyPzQ6MyksdD1uZXcgVWludDhDbGFtcGVkQXJyYXkoZSk7bGV0IGE9MDtpZihyKSFmdW5jdGlvbiBncmF5VG9SR0JBKGUsdCl7aWYoRmVhdHVyZVRlc3QuaXNMaXR0bGVFbmRpYW4pZm9yKGxldCByPTAsYT1lLmxlbmd0aDtyPGE7cisrKXRbcl09NjU3OTMqZVtyXXw0Mjc4MTkwMDgwO2Vsc2UgZm9yKGxldCByPTAsYT1lLmxlbmd0aDtyPGE7cisrKXRbcl09MTY4NDMwMDgqZVtyXXwyNTV9KGksbmV3IFVpbnQzMkFycmF5KHQuYnVmZmVyKSk7ZWxzZSBmb3IoY29uc3QgZSBvZiBpKXt0W2ErK109ZTt0W2ErK109ZTt0W2ErK109ZX1yZXR1cm4gdH1pZigzPT09dGhpcy5udW1Db21wb25lbnRzJiZ0aGlzLl9pc0NvbG9yQ29udmVyc2lvbk5lZWRlZCl7aWYocil7Y29uc3QgZT1uZXcgVWludDhDbGFtcGVkQXJyYXkoaS5sZW5ndGgvMyo0KTtyZXR1cm4gdGhpcy5fY29udmVydFljY1RvUmdiYShpLGUpfXJldHVybiB0aGlzLl9jb252ZXJ0WWNjVG9SZ2IoaSl9aWYoND09PXRoaXMubnVtQ29tcG9uZW50cyl7aWYodGhpcy5faXNDb2xvckNvbnZlcnNpb25OZWVkZWQpcmV0dXJuIHI/dGhpcy5fY29udmVydFljY2tUb1JnYmEoaSk6YT90aGlzLl9jb252ZXJ0WWNja1RvUmdiKGkpOnRoaXMuX2NvbnZlcnRZY2NrVG9DbXlrKGkpO2lmKHIpcmV0dXJuIHRoaXMuX2NvbnZlcnRDbXlrVG9SZ2JhKGkpO2lmKGEpcmV0dXJuIHRoaXMuX2NvbnZlcnRDbXlrVG9SZ2IoaSl9cmV0dXJuIGl9fWNsYXNzIEpwZWdTdHJlYW0gZXh0ZW5kcyBEZWNvZGVTdHJlYW17c3RhdGljI009RmVhdHVyZVRlc3QuaXNJbWFnZURlY29kZXJTdXBwb3J0ZWQ7Y29uc3RydWN0b3IoZSx0LHIpe3N1cGVyKHQpO3RoaXMuc3RyZWFtPWU7dGhpcy5kaWN0PWUuZGljdDt0aGlzLm1heWJlTGVuZ3RoPXQ7dGhpcy5wYXJhbXM9cn1zdGF0aWMgZ2V0IGNhblVzZUltYWdlRGVjb2Rlcigpe3JldHVybiBzaGFkb3codGhpcywiY2FuVXNlSW1hZ2VEZWNvZGVyIix0aGlzLiNNP0ltYWdlRGVjb2Rlci5pc1R5cGVTdXBwb3J0ZWQoImltYWdlL2pwZWciKTpQcm9taXNlLnJlc29sdmUoITEpKX1zdGF0aWMgc2V0T3B0aW9ucyh7aXNJbWFnZURlY29kZXJTdXBwb3J0ZWQ6ZT0hMX0pe3RoaXMuI009ZX1nZXQgYnl0ZXMoKXtyZXR1cm4gc2hhZG93KHRoaXMsImJ5dGVzIix0aGlzLnN0cmVhbS5nZXRCeXRlcyh0aGlzLm1heWJlTGVuZ3RoKSl9ZW5zdXJlQnVmZmVyKGUpe31yZWFkQmxvY2soKXt0aGlzLmRlY29kZUltYWdlKCl9Z2V0IGpwZWdPcHRpb25zKCl7Y29uc3QgZT17ZGVjb2RlVHJhbnNmb3JtOnZvaWQgMCxjb2xvclRyYW5zZm9ybTp2b2lkIDB9LHQ9dGhpcy5kaWN0LmdldEFycmF5KCJEIiwiRGVjb2RlIik7aWYoKHRoaXMuZm9yY2VSR0JBfHx0aGlzLmZvcmNlUkdCKSYmQXJyYXkuaXNBcnJheSh0KSl7Y29uc3Qgcj10aGlzLmRpY3QuZ2V0KCJCUEMiLCJCaXRzUGVyQ29tcG9uZW50Iil8fDgsYT10Lmxlbmd0aCxuPW5ldyBJbnQzMkFycmF5KGEpO2xldCBpPSExO2NvbnN0IHM9KDE8PHIpLTE7Zm9yKGxldCBlPTA7ZTxhO2UrPTIpe25bZV09MjU2Kih0W2UrMV0tdFtlXSl8MDtuW2UrMV09dFtlXSpzfDA7MjU2PT09bltlXSYmMD09PW5bZSsxXXx8KGk9ITApfWkmJihlLmRlY29kZVRyYW5zZm9ybT1uKX1pZih0aGlzLnBhcmFtcyBpbnN0YW5jZW9mIERpY3Qpe2NvbnN0IHQ9dGhpcy5wYXJhbXMuZ2V0KCJDb2xvclRyYW5zZm9ybSIpO051bWJlci5pc0ludGVnZXIodCkmJihlLmNvbG9yVHJhbnNmb3JtPXQpfXJldHVybiBzaGFkb3codGhpcywianBlZ09wdGlvbnMiLGUpfSNFKGUpe2ZvcihsZXQgdD0wLHI9ZS5sZW5ndGgtMTt0PHI7dCsrKWlmKDI1NT09PWVbdF0mJjIxNj09PWVbdCsxXSl7dD4wJiYoZT1lLnN1YmFycmF5KHQpKTticmVha31yZXR1cm4gZX1kZWNvZGVJbWFnZShlKXtpZih0aGlzLmVvZilyZXR1cm4gdGhpcy5idWZmZXI7ZT10aGlzLiNFKGV8fHRoaXMuYnl0ZXMpO2NvbnN0IHQ9bmV3IEpwZWdJbWFnZSh0aGlzLmpwZWdPcHRpb25zKTt0LnBhcnNlKGUpO2NvbnN0IHI9dC5nZXREYXRhKHt3aWR0aDp0aGlzLmRyYXdXaWR0aCxoZWlnaHQ6dGhpcy5kcmF3SGVpZ2h0LGZvcmNlUkdCQTp0aGlzLmZvcmNlUkdCQSxmb3JjZVJHQjp0aGlzLmZvcmNlUkdCLGlzU291cmNlUERGOiEwfSk7dGhpcy5idWZmZXI9cjt0aGlzLmJ1ZmZlckxlbmd0aD1yLmxlbmd0aDt0aGlzLmVvZj0hMDtyZXR1cm4gdGhpcy5idWZmZXJ9Z2V0IGNhbkFzeW5jRGVjb2RlSW1hZ2VGcm9tQnVmZmVyKCl7cmV0dXJuIHRoaXMuc3RyZWFtLmlzQXN5bmN9YXN5bmMgZ2V0VHJhbnNmZXJhYmxlSW1hZ2UoKXtpZighYXdhaXQgSnBlZ1N0cmVhbS5jYW5Vc2VJbWFnZURlY29kZXIpcmV0dXJuIG51bGw7Y29uc3QgZT10aGlzLmpwZWdPcHRpb25zO2lmKGUuZGVjb2RlVHJhbnNmb3JtKXJldHVybiBudWxsO2xldCB0O3RyeXtjb25zdCByPXRoaXMuY2FuQXN5bmNEZWNvZGVJbWFnZUZyb21CdWZmZXImJmF3YWl0IHRoaXMuc3RyZWFtLmFzeW5jR2V0Qnl0ZXMoKXx8dGhpcy5ieXRlcztpZighcilyZXR1cm4gbnVsbDtsZXQgYT10aGlzLiNFKHIpO2NvbnN0IG49SnBlZ0ltYWdlLmNhblVzZUltYWdlRGVjb2RlcihhLGUuY29sb3JUcmFuc2Zvcm0pO2lmKCFuKXJldHVybiBudWxsO2lmKG4uZXhpZlN0YXJ0KXthPWEuc2xpY2UoKTthLmZpbGwoMCxuLmV4aWZTdGFydCxuLmV4aWZFbmQpfXQ9bmV3IEltYWdlRGVjb2Rlcih7ZGF0YTphLHR5cGU6ImltYWdlL2pwZWciLHByZWZlckFuaW1hdGlvbjohMX0pO3JldHVybihhd2FpdCB0LmRlY29kZSgpKS5pbWFnZX1jYXRjaChlKXt3YXJuKGBnZXRUcmFuc2ZlcmFibGVJbWFnZSAtIGZhaWxlZDogIiR7ZX0iLmApO3JldHVybiBudWxsfWZpbmFsbHl7dD8uY2xvc2UoKX19fWNvbnN0IE5yPWFzeW5jIGZ1bmN0aW9uIE9wZW5KUEVHKGU9e30pe3ZhciB0PWUscj0iLi90aGlzLnByb2dyYW0iLHF1aXRfPShlLHQpPT57dGhyb3cgdH0sYT1pbXBvcnQubWV0YS51cmw7dHJ5e25ldyBVUkwoIi4iLGEpLmhyZWZ9Y2F0Y2h7fTA7dmFyIG4saSxzLG8sYyxsLGgsdSxkPWNvbnNvbGUubG9nLmJpbmQoY29uc29sZSksZj1jb25zb2xlLmVycm9yLmJpbmQoY29uc29sZSksZz0hMSxwPSExO2Z1bmN0aW9uIHVwZGF0ZU1lbW9yeVZpZXdzKCl7dmFyIGU9by5idWZmZXI7Yz1uZXcgSW50OEFycmF5KGUpO25ldyBJbnQxNkFycmF5KGUpO2w9bmV3IFVpbnQ4QXJyYXkoZSk7bmV3IFVpbnQxNkFycmF5KGUpO2g9bmV3IEludDMyQXJyYXkoZSk7dT1uZXcgVWludDMyQXJyYXkoZSk7bmV3IEZsb2F0MzJBcnJheShlKTtuZXcgRmxvYXQ2NEFycmF5KGUpO25ldyBCaWdJbnQ2NEFycmF5KGUpO25ldyBCaWdVaW50NjRBcnJheShlKX1jbGFzcyBFeGl0U3RhdHVze25hbWU9IkV4aXRTdGF0dXMiO2NvbnN0cnVjdG9yKGUpe3RoaXMubWVzc2FnZT1gUHJvZ3JhbSB0ZXJtaW5hdGVkIHdpdGggZXhpdCgke2V9KWA7dGhpcy5zdGF0dXM9ZX19dmFyIG0sY2FsbFJ1bnRpbWVDYWxsYmFja3M9ZT0+e2Zvcig7ZS5sZW5ndGg+MDspZS5zaGlmdCgpKHQpfSxiPVtdLGFkZE9uUG9zdFJ1bj1lPT5iLnB1c2goZSkseT1bXSxhZGRPblByZVJ1bj1lPT55LnB1c2goZSksdz0hMCx4PTAsUz17fSxoYW5kbGVFeGNlcHRpb249ZT0+e2lmKGUgaW5zdGFuY2VvZiBFeGl0U3RhdHVzfHwidW53aW5kIj09ZSlyZXR1cm4gbjtxdWl0XygwLGUpfSxrZWVwUnVudGltZUFsaXZlPSgpPT53fHx4PjAsX3Byb2NfZXhpdD1lPT57bj1lO2lmKCFrZWVwUnVudGltZUFsaXZlKCkpe3Qub25FeGl0Py4oZSk7Zz0hMH1xdWl0XygwLG5ldyBFeGl0U3RhdHVzKGUpKX0sX2V4aXQ9KGUsdCk9PntuPWU7X3Byb2NfZXhpdChlKX0sY2FsbFVzZXJDYWxsYmFjaz1lPT57aWYoIWcpdHJ5e2UoKTsoKCk9PntpZigha2VlcFJ1bnRpbWVBbGl2ZSgpKXRyeXtfZXhpdChuKX1jYXRjaChlKXtoYW5kbGVFeGNlcHRpb24oZSl9fSkoKX1jYXRjaChlKXtoYW5kbGVFeGNlcHRpb24oZSl9fSxhbGlnbk1lbW9yeT0oZSx0KT0+TWF0aC5jZWlsKGUvdCkqdCxncm93TWVtb3J5PWU9Pnt2YXIgdD0oZS1vLmJ1ZmZlci5ieXRlTGVuZ3RoKzY1NTM1KS82NTUzNnwwO3RyeXtvLmdyb3codCk7dXBkYXRlTWVtb3J5Vmlld3MoKTtyZXR1cm4gMX1jYXRjaChlKXt9fSxrPXt9LGdldEVudlN0cmluZ3M9KCk9PntpZighZ2V0RW52U3RyaW5ncy5zdHJpbmdzKXt2YXIgZT17VVNFUjoid2ViX3VzZXIiLExPR05BTUU6IndlYl91c2VyIixQQVRIOiIvIixQV0Q6Ii8iLEhPTUU6Ii9ob21lL3dlYl91c2VyIixMQU5HOigib2JqZWN0Ij09dHlwZW9mIG5hdmlnYXRvciYmbmF2aWdhdG9yLmxhbmd1YWdlfHwiQyIpLnJlcGxhY2UoIi0iLCJfIikrIi5VVEYtOCIsXzpyfHwiLi90aGlzLnByb2dyYW0ifTtmb3IodmFyIHQgaW4gayl2b2lkIDA9PT1rW3RdP2RlbGV0ZSBlW3RdOmVbdF09a1t0XTt2YXIgYT1bXTtmb3IodmFyIHQgaW4gZSlhLnB1c2goYCR7dH09JHtlW3RdfWApO2dldEVudlN0cmluZ3Muc3RyaW5ncz1hfXJldHVybiBnZXRFbnZTdHJpbmdzLnN0cmluZ3N9LHN0cmluZ1RvVVRGOD0oZSx0LHIpPT4oKGUsdCxyLGEpPT57aWYoIShhPjApKXJldHVybiAwO2Zvcih2YXIgbj1yLGk9cithLTEscz0wO3M8ZS5sZW5ndGg7KytzKXt2YXIgbz1lLmNvZGVQb2ludEF0KHMpO2lmKG88PTEyNyl7aWYocj49aSlicmVhazt0W3IrK109b31lbHNlIGlmKG88PTIwNDcpe2lmKHIrMT49aSlicmVhazt0W3IrK109MTkyfG8+PjY7dFtyKytdPTEyOHw2MyZvfWVsc2UgaWYobzw9NjU1MzUpe2lmKHIrMj49aSlicmVhazt0W3IrK109MjI0fG8+PjEyO3RbcisrXT0xMjh8bz4+NiY2Mzt0W3IrK109MTI4fDYzJm99ZWxzZXtpZihyKzM+PWkpYnJlYWs7dFtyKytdPTI0MHxvPj4xODt0W3IrK109MTI4fG8+PjEyJjYzO3RbcisrXT0xMjh8bz4+NiY2Mzt0W3IrK109MTI4fDYzJm87cysrfX10W3JdPTA7cmV0dXJuIHItbn0pKGUsbCx0LHIpLGxlbmd0aEJ5dGVzVVRGOD1lPT57Zm9yKHZhciB0PTAscj0wO3I8ZS5sZW5ndGg7KytyKXt2YXIgYT1lLmNoYXJDb2RlQXQocik7aWYoYTw9MTI3KXQrKztlbHNlIGlmKGE8PTIwNDcpdCs9MjtlbHNlIGlmKGE+PTU1Mjk2JiZhPD01NzM0Myl7dCs9NDsrK3J9ZWxzZSB0Kz0zfXJldHVybiB0fSxDPVtudWxsLFtdLFtdXSx2PSJ1bmRlZmluZWQiIT10eXBlb2YgVGV4dERlY29kZXI/bmV3IFRleHREZWNvZGVyOnZvaWQgMCxVVEY4QXJyYXlUb1N0cmluZz0oZSx0PTAscixhKT0+e3ZhciBuPSgoZSx0LHIsYSk9Pnt2YXIgbj10K3I7aWYoYSlyZXR1cm4gbjtmb3IoO2VbdF0mJiEodD49bik7KSsrdDtyZXR1cm4gdH0pKGUsdCxyLGEpO2lmKG4tdD4xNiYmZS5idWZmZXImJnYpcmV0dXJuIHYuZGVjb2RlKGUuc3ViYXJyYXkodCxuKSk7Zm9yKHZhciBpPSIiO3Q8bjspe3ZhciBzPWVbdCsrXTtpZigxMjgmcyl7dmFyIG89NjMmZVt0KytdO2lmKDE5MiE9KDIyNCZzKSl7dmFyIGM9NjMmZVt0KytdO2lmKChzPTIyND09KDI0MCZzKT8oMTUmcyk8PDEyfG88PDZ8YzooNyZzKTw8MTh8bzw8MTJ8Yzw8Nnw2MyZlW3QrK10pPDY1NTM2KWkrPVN0cmluZy5mcm9tQ2hhckNvZGUocyk7ZWxzZXt2YXIgbD1zLTY1NTM2O2krPVN0cmluZy5mcm9tQ2hhckNvZGUoNTUyOTZ8bD4+MTAsNTYzMjB8MTAyMyZsKX19ZWxzZSBpKz1TdHJpbmcuZnJvbUNoYXJDb2RlKCgzMSZzKTw8NnxvKX1lbHNlIGkrPVN0cmluZy5mcm9tQ2hhckNvZGUocyl9cmV0dXJuIGl9LHByaW50Q2hhcj0oZSx0KT0+e3ZhciByPUNbZV07aWYoMD09PXR8fDEwPT09dCl7KDE9PT1lP2Q6ZikoVVRGOEFycmF5VG9TdHJpbmcocikpO3IubGVuZ3RoPTB9ZWxzZSByLnB1c2godCl9LFVURjhUb1N0cmluZz0oZSx0LHIpPT5lP1VURjhBcnJheVRvU3RyaW5nKGwsZSx0LHIpOiIiO3Qubm9FeGl0UnVudGltZSYmKHc9dC5ub0V4aXRSdW50aW1lKTt0LnByaW50JiYoZD10LnByaW50KTt0LnByaW50RXJyJiYoZj10LnByaW50RXJyKTt0Lndhc21CaW5hcnkmJnQud2FzbUJpbmFyeTt0LmFyZ3VtZW50cyYmdC5hcmd1bWVudHM7dC50aGlzUHJvZ3JhbSYmKHI9dC50aGlzUHJvZ3JhbSk7aWYodC5wcmVJbml0KXsiZnVuY3Rpb24iPT10eXBlb2YgdC5wcmVJbml0JiYodC5wcmVJbml0PVt0LnByZUluaXRdKTtmb3IoO3QucHJlSW5pdC5sZW5ndGg+MDspdC5wcmVJbml0LnNoaWZ0KCkoKX10LndyaXRlQXJyYXlUb01lbW9yeT0oZSx0KT0+e2Muc2V0KGUsdCl9O3ZhciBULE89e2s6KCk9PmZ1bmN0aW9uIGFib3J0KGUpe3Qub25BYm9ydD8uKGUpO2YoZT0iQWJvcnRlZCgiK2UrIikiKTtnPSEwO2UrPSIuIEJ1aWxkIHdpdGggLXNBU1NFUlRJT05TIGZvciBtb3JlIGluZm8uIjt2YXIgcj1uZXcgV2ViQXNzZW1ibHkuUnVudGltZUVycm9yKGUpO3M/LihyKTt0aHJvdyByfSgiIiksajooKT0+e3c9ITE7eD0wfSxsOihlLHQpPT57aWYoU1tlXSl7Y2xlYXJUaW1lb3V0KFNbZV0uaWQpO2RlbGV0ZSBTW2VdfWlmKCF0KXJldHVybiAwO3ZhciByPXNldFRpbWVvdXQoKCk9PntkZWxldGUgU1tlXTtjYWxsVXNlckNhbGxiYWNrKCgpPT5tKGUscGVyZm9ybWFuY2Uubm93KCkpKX0sdCk7U1tlXT17aWQ6cix0aW1lb3V0X21zOnR9O3JldHVybiAwfSxmOmZ1bmN0aW9uIF9jb3B5X3BpeGVsc18xKGUscil7ZT4+PTI7Y29uc3QgYT10LmltYWdlRGF0YT1uZXcgVWludDhDbGFtcGVkQXJyYXkociksbj1oLnN1YmFycmF5KGUsZStyKTthLnNldChuKX0sZTpmdW5jdGlvbiBfY29weV9waXhlbHNfMyhlLHIsYSxuKXtlPj49MjtyPj49MjthPj49Mjtjb25zdCBpPXQuaW1hZ2VEYXRhPW5ldyBVaW50OENsYW1wZWRBcnJheSgzKm4pLHM9aC5zdWJhcnJheShlLGUrbiksbz1oLnN1YmFycmF5KHIscituKSxjPWguc3ViYXJyYXkoYSxhK24pO2ZvcihsZXQgZT0wO2U8bjtlKyspe2lbMyplXT1zW2VdO2lbMyplKzFdPW9bZV07aVszKmUrMl09Y1tlXX19LGQ6ZnVuY3Rpb24gX2NvcHlfcGl4ZWxzXzQoZSxyLGEsbixpKXtlPj49MjtyPj49MjthPj49MjtuPj49Mjtjb25zdCBzPXQuaW1hZ2VEYXRhPW5ldyBVaW50OENsYW1wZWRBcnJheSg0KmkpLG89aC5zdWJhcnJheShlLGUraSksYz1oLnN1YmFycmF5KHIscitpKSxsPWguc3ViYXJyYXkoYSxhK2kpLHU9aC5zdWJhcnJheShuLG4raSk7Zm9yKGxldCBlPTA7ZTxpO2UrKyl7c1s0KmVdPW9bZV07c1s0KmUrMV09Y1tlXTtzWzQqZSsyXT1sW2VdO3NbNCplKzNdPXVbZV19fSxtOmU9Pnt2YXIgdD1sLmxlbmd0aCxyPTIxNDc0ODM2NDg7aWYoKGU+Pj49MCk+cilyZXR1cm4hMTtmb3IodmFyIGE9MTthPD00O2EqPTIpe3ZhciBuPXQqKDErLjIvYSk7bj1NYXRoLm1pbihuLGUrMTAwNjYzMjk2KTt2YXIgaT1NYXRoLm1pbihyLGFsaWduTWVtb3J5KE1hdGgubWF4KGUsbiksNjU1MzYpKTtpZihncm93TWVtb3J5KGkpKXJldHVybiEwfXJldHVybiExfSxvOihlLHQpPT57dmFyIHI9MCxhPTA7Zm9yKHZhciBuIG9mIGdldEVudlN0cmluZ3MoKSl7dmFyIGk9dCtyO3VbZSthPj4yXT1pO3IrPXN0cmluZ1RvVVRGOChuLGksMS8wKSsxO2ErPTR9cmV0dXJuIDB9LHA6KGUsdCk9Pnt2YXIgcj1nZXRFbnZTdHJpbmdzKCk7dVtlPj4yXT1yLmxlbmd0aDt2YXIgYT0wO2Zvcih2YXIgbiBvZiByKWErPWxlbmd0aEJ5dGVzVVRGOChuKSsxO3VbdD4+Ml09YTtyZXR1cm4gMH0sbjpmdW5jdGlvbiBfZmRfc2VlayhlLHQscixhKXt0PShuPXQpPC05MDA3MTk5MjU0NzQwOTkyfHxuPjkwMDcxOTkyNTQ3NDA5OTI/TmFOOk51bWJlcihuKTt2YXIgbjtyZXR1cm4gNzB9LGI6KGUsdCxyLGEpPT57Zm9yKHZhciBuPTAsaT0wO2k8cjtpKyspe3ZhciBzPXVbdD4+Ml0sbz11W3QrND4+Ml07dCs9ODtmb3IodmFyIGM9MDtjPG87YysrKXByaW50Q2hhcihlLGxbcytjXSk7bis9b311W2E+PjJdPW47cmV0dXJuIDB9LHE6ZnVuY3Rpb24gX2dyYXlfdG9fcmdiYShlLHIpe2U+Pj0yO2NvbnN0IGE9dC5pbWFnZURhdGE9bmV3IFVpbnQ4Q2xhbXBlZEFycmF5KDQqciksbj1oLnN1YmFycmF5KGUsZStyKTtmb3IobGV0IGU9MDtlPHI7ZSsrKXthWzQqZV09YVs0KmUrMV09YVs0KmUrMl09bltlXTthWzQqZSszXT0yNTV9fSxoOmZ1bmN0aW9uIF9ncmF5YV90b19yZ2JhKGUscixhKXtlPj49MjtyPj49Mjtjb25zdCBuPXQuaW1hZ2VEYXRhPW5ldyBVaW50OENsYW1wZWRBcnJheSg0KmEpLGk9aC5zdWJhcnJheShlLGUrYSkscz1oLnN1YmFycmF5KHIscithKTtmb3IobGV0IGU9MDtlPGE7ZSsrKXtuWzQqZV09bls0KmUrMV09bls0KmUrMl09aVtlXTtuWzQqZSszXT1zW2VdfX0sYzpmdW5jdGlvbiBfanNQcmludFdhcm5pbmcoZSl7Y29uc3Qgcj1VVEY4VG9TdHJpbmcoZSk7KHQud2Fybnx8Y29uc29sZS53YXJuKShgT3BlbkpQRUc6ICR7cn1gKX0saTpfcHJvY19leGl0LGc6ZnVuY3Rpb24gX3JnYl90b19yZ2JhKGUscixhLG4pe2U+Pj0yO3I+Pj0yO2E+Pj0yO2NvbnN0IGk9dC5pbWFnZURhdGE9bmV3IFVpbnQ4Q2xhbXBlZEFycmF5KDQqbikscz1oLnN1YmFycmF5KGUsZStuKSxvPWguc3ViYXJyYXkocixyK24pLGM9aC5zdWJhcnJheShhLGErbik7Zm9yKGxldCBlPTA7ZTxuO2UrKyl7aVs0KmVdPXNbZV07aVs0KmUrMV09b1tlXTtpWzQqZSsyXT1jW2VdO2lbNCplKzNdPTI1NX19LGE6ZnVuY3Rpb24gX3N0b3JlRXJyb3JNZXNzYWdlKGUpe2NvbnN0IHI9VVRGOFRvU3RyaW5nKGUpO3QuZXJyb3JNZXNzYWdlcz90LmVycm9yTWVzc2FnZXMrPSJcbiIrcjp0LmVycm9yTWVzc2FnZXM9cn19O1Q9YXdhaXQgYXN5bmMgZnVuY3Rpb24gY3JlYXRlV2FzbSgpe2Z1bmN0aW9uIHJlY2VpdmVJbnN0YW5jZShlLHIpe1Q9ZS5leHBvcnRzO289VC5yO3VwZGF0ZU1lbW9yeVZpZXdzKCk7IWZ1bmN0aW9uIGFzc2lnbldhc21FeHBvcnRzKGUpe3QuX21hbGxvYz1lLnQ7dC5fZnJlZT1lLnU7dC5fanAyX2RlY29kZT1lLnY7bT1lLnd9KFQpO3JldHVybiBUfXZhciBlPWZ1bmN0aW9uIGdldFdhc21JbXBvcnRzKCl7cmV0dXJue2E6T319KCk7cmV0dXJuIG5ldyBQcm9taXNlKChyLGEpPT57dC5pbnN0YW50aWF0ZVdhc20oZSwoZSx0KT0+e3IocmVjZWl2ZUluc3RhbmNlKGUpKX0pfSl9KCk7IWZ1bmN0aW9uIHJ1bigpeyFmdW5jdGlvbiBwcmVSdW4oKXtpZih0LnByZVJ1bil7ImZ1bmN0aW9uIj09dHlwZW9mIHQucHJlUnVuJiYodC5wcmVSdW49W3QucHJlUnVuXSk7Zm9yKDt0LnByZVJ1bi5sZW5ndGg7KWFkZE9uUHJlUnVuKHQucHJlUnVuLnNoaWZ0KCkpfWNhbGxSdW50aW1lQ2FsbGJhY2tzKHkpfSgpO2Z1bmN0aW9uIGRvUnVuKCl7dC5jYWxsZWRSdW49ITA7aWYoIWcpeyFmdW5jdGlvbiBpbml0UnVudGltZSgpe3A9ITA7VC5zKCl9KCk7aT8uKHQpO3Qub25SdW50aW1lSW5pdGlhbGl6ZWQ/LigpOyFmdW5jdGlvbiBwb3N0UnVuKCl7aWYodC5wb3N0UnVuKXsiZnVuY3Rpb24iPT10eXBlb2YgdC5wb3N0UnVuJiYodC5wb3N0UnVuPVt0LnBvc3RSdW5dKTtmb3IoO3QucG9zdFJ1bi5sZW5ndGg7KWFkZE9uUG9zdFJ1bih0LnBvc3RSdW4uc2hpZnQoKSl9Y2FsbFJ1bnRpbWVDYWxsYmFja3MoYil9KCl9fWlmKHQuc2V0U3RhdHVzKXt0LnNldFN0YXR1cygiUnVubmluZy4uLiIpO3NldFRpbWVvdXQoKCk9PntzZXRUaW1lb3V0KCgpPT50LnNldFN0YXR1cygiIiksMSk7ZG9SdW4oKX0sMSl9ZWxzZSBkb1J1bigpfSgpO3JldHVybiBwP3Q6bmV3IFByb21pc2UoKGUsdCk9PntpPWU7cz10fSl9O2NsYXNzIEpweEVycm9yIGV4dGVuZHMgZXJ7Y29uc3RydWN0b3IoZSl7c3VwZXIoZSwiSnB4RXJyb3IiKX19Y2xhc3MgSnB4SW1hZ2V7c3RhdGljI049bnVsbDtzdGF0aWMjUD1udWxsO3N0YXRpYyNfPW51bGw7c3RhdGljI3Y9ITA7c3RhdGljI0w9ITA7c3RhdGljI0Y9bnVsbDtzdGF0aWMgc2V0T3B0aW9ucyh7aGFuZGxlcjplLHVzZVdhc206dCx1c2VXb3JrZXJGZXRjaDpyLHdhc21Vcmw6YX0pe3RoaXMuI3Y9dDt0aGlzLiNMPXI7dGhpcy4jRj1hO3J8fCh0aGlzLiNQPWUpfXN0YXRpYyBhc3luYyNqKGUpe2NvbnN0IHQ9YCR7dGhpcy4jRn1vcGVuanBlZ19ub3dhc21fZmFsbGJhY2suanNgO2xldCByPW51bGw7dHJ5e3I9KGF3YWl0IGltcG9ydCgKLyp3ZWJwYWNrSWdub3JlOiB0cnVlKi8KLypAdml0ZS1pZ25vcmUqLwp0KSkuZGVmYXVsdCgpfWNhdGNoKGUpe3dhcm4oYEpweEltYWdlI2dldEpzTW9kdWxlOiAke2V9YCl9ZShyKX1zdGF0aWMgYXN5bmMjVShlLHQscil7Y29uc3QgYT0ib3BlbmpwZWcud2FzbSI7dHJ5e3RoaXMuI058fCh0aGlzLiNMP3RoaXMuI049YXdhaXQgZmV0Y2hCaW5hcnlEYXRhKGAke3RoaXMuI0Z9JHthfWApOnRoaXMuI049YXdhaXQgdGhpcy4jUC5zZW5kV2l0aFByb21pc2UoIkZldGNoQmluYXJ5RGF0YSIse3R5cGU6Indhc21GYWN0b3J5IixmaWxlbmFtZTphfSkpO3JldHVybiByKChhd2FpdCBXZWJBc3NlbWJseS5pbnN0YW50aWF0ZSh0aGlzLiNOLHQpKS5pbnN0YW5jZSl9Y2F0Y2godCl7d2FybihgSnB4SW1hZ2UjaW5zdGFudGlhdGVXYXNtOiAke3R9YCk7dGhpcy4jaihlKTtyZXR1cm4gbnVsbH1maW5hbGx5e3RoaXMuI1A9bnVsbH19c3RhdGljIGFzeW5jIGRlY29kZShlLHtudW1Db21wb25lbnRzOnQ9NCxpc0luZGV4ZWRDb2xvcm1hcDpyPSExLHNtYXNrSW5EYXRhOmE9ITEscmVkdWNlUG93ZXI6bj0wfT17fSl7aWYoIXRoaXMuI18pe2NvbnN0e3Byb21pc2U6ZSxyZXNvbHZlOnR9PVByb21pc2Uud2l0aFJlc29sdmVycygpLHI9W2VdO3RoaXMuI3Y/ci5wdXNoKE5yKHt3YXJuLGluc3RhbnRpYXRlV2FzbTp0aGlzLiNVLmJpbmQodGhpcyx0KX0pKTp0aGlzLiNqKHQpO3RoaXMuI189UHJvbWlzZS5yYWNlKHIpfWNvbnN0IGk9YXdhaXQgdGhpcy4jXztpZighaSl0aHJvdyBuZXcgSnB4RXJyb3IoIk9wZW5KUEVHIGZhaWxlZCB0byBpbml0aWFsaXplIik7bGV0IHM7dHJ5e2NvbnN0IG89ZS5sZW5ndGg7cz1pLl9tYWxsb2Mobyk7aS53cml0ZUFycmF5VG9NZW1vcnkoZSxzKTtpZihpLl9qcDJfZGVjb2RlKHMsbyx0PjA/dDowLCEhciwhIWEsbikpe2NvbnN0e2Vycm9yTWVzc2FnZXM6ZX09aTtpZihlKXtkZWxldGUgaS5lcnJvck1lc3NhZ2VzO3Rocm93IG5ldyBKcHhFcnJvcihlKX10aHJvdyBuZXcgSnB4RXJyb3IoIlVua25vd24gZXJyb3IiKX1jb25zdHtpbWFnZURhdGE6Y309aTtpLmltYWdlRGF0YT1udWxsO3JldHVybiBjfWZpbmFsbHl7cyYmaS5fZnJlZShzKX19c3RhdGljIGNsZWFudXAoKXt0aGlzLiNfPW51bGx9c3RhdGljIHBhcnNlSW1hZ2VQcm9wZXJ0aWVzKGUpe2xldCB0PWUuZ2V0Qnl0ZSgpO2Zvcig7dD49MDspe2NvbnN0IHI9dDt0PWUuZ2V0Qnl0ZSgpO2lmKDY1MzYxPT09KHI8PDh8dCkpe2Uuc2tpcCg0KTtjb25zdCB0PWUuZ2V0SW50MzIoKT4+PjAscj1lLmdldEludDMyKCk+Pj4wLGE9ZS5nZXRJbnQzMigpPj4+MCxuPWUuZ2V0SW50MzIoKT4+PjA7ZS5za2lwKDE2KTtyZXR1cm57d2lkdGg6dC1hLGhlaWdodDpyLW4sYml0c1BlckNvbXBvbmVudDo4LGNvbXBvbmVudHNDb3VudDplLmdldFVpbnQxNigpfX19dGhyb3cgbmV3IEpweEVycm9yKCJObyBzaXplIG1hcmtlciBmb3VuZCBpbiBKUFggc3RyZWFtIil9fWZ1bmN0aW9uIGFkZFN0YXRlKGUsdCxyLGEsbil7bGV0IGk9ZTtmb3IobGV0IGU9MCxyPXQubGVuZ3RoLTE7ZTxyO2UrKyl7Y29uc3Qgcj10W2VdO2k9aVtyXXx8PVtdfWlbdC5hdCgtMSldPXtjaGVja0ZuOnIsaXRlcmF0ZUZuOmEscHJvY2Vzc0ZuOm59fWNvbnN0IFByPVtdO2FkZFN0YXRlKFByLFt5ZSx4ZSxMdCx3ZV0sbnVsbCxmdW5jdGlvbiBpdGVyYXRlSW5saW5lSW1hZ2VHcm91cChlLHQpe2NvbnN0IHI9ZS5mbkFycmF5LGE9KHQtKGUuaUN1cnItMykpJTQ7c3dpdGNoKGEpe2Nhc2UgMDpyZXR1cm4gclt0XT09PXllO2Nhc2UgMTpyZXR1cm4gclt0XT09PXhlO2Nhc2UgMjpyZXR1cm4gclt0XT09PUx0O2Nhc2UgMzpyZXR1cm4gclt0XT09PXdlfXRocm93IG5ldyBFcnJvcihgaXRlcmF0ZUlubGluZUltYWdlR3JvdXAgLSBpbnZhbGlkIHBvczogJHthfWApfSxmdW5jdGlvbiBmb3VuZElubGluZUltYWdlR3JvdXAoZSx0KXtjb25zdCByPWUuZm5BcnJheSxhPWUuYXJnc0FycmF5LG49ZS5pQ3VycixpPW4tMyxzPW4tMixvPW4tMSxjPU1hdGgubWluKE1hdGguZmxvb3IoKHQtaSkvNCksMjAwKTtpZihjPDEwKXJldHVybiB0LSh0LWkpJTQ7bGV0IGw9MDtjb25zdCBoPVtdO2xldCB1PTAsZD0xLGY9MTtmb3IobGV0IGU9MDtlPGM7ZSsrKXtjb25zdCB0PWFbcysoZTw8MildLHI9YVtvKyhlPDwyKV1bMF07aWYoZCtyLndpZHRoPjFlMyl7bD1NYXRoLm1heChsLGQpO2YrPXUrMjtkPTA7dT0wfWgucHVzaCh7dHJhbnNmb3JtOnQseDpkLHk6Zix3OnIud2lkdGgsaDpyLmhlaWdodH0pO2QrPXIud2lkdGgrMjt1PU1hdGgubWF4KHUsci5oZWlnaHQpfWNvbnN0IGc9TWF0aC5tYXgobCxkKSsxLHA9Zit1KzEsbT1uZXcgVWludDhBcnJheShnKnAqNCksYj1nPDwyO2ZvcihsZXQgZT0wO2U8YztlKyspe2NvbnN0IHQ9YVtvKyhlPDwyKV1bMF0uZGF0YSxyPWhbZV0udzw8MjtsZXQgbj0wLGk9aFtlXS54K2hbZV0ueSpnPDwyO20uc2V0KHQuc3ViYXJyYXkoMCxyKSxpLWIpO2ZvcihsZXQgYT0wLHM9aFtlXS5oO2E8czthKyspe20uc2V0KHQuc3ViYXJyYXkobixuK3IpLGkpO24rPXI7aSs9Yn1tLnNldCh0LnN1YmFycmF5KG4tcixuKSxpKTtmb3IoO2k+PTA7KXt0W2ktNF09dFtpXTt0W2ktM109dFtpKzFdO3RbaS0yXT10W2krMl07dFtpLTFdPXRbaSszXTt0W2krcl09dFtpK3ItNF07dFtpK3IrMV09dFtpK3ItM107dFtpK3IrMl09dFtpK3ItMl07dFtpK3IrM109dFtpK3ItMV07aS09Yn19Y29uc3QgeT17d2lkdGg6ZyxoZWlnaHQ6cH07aWYoZS5pc09mZnNjcmVlbkNhbnZhc1N1cHBvcnRlZCl7Y29uc3QgZT1uZXcgT2Zmc2NyZWVuQ2FudmFzKGcscCk7ZS5nZXRDb250ZXh0KCIyZCIpLnB1dEltYWdlRGF0YShuZXcgSW1hZ2VEYXRhKG5ldyBVaW50OENsYW1wZWRBcnJheShtLmJ1ZmZlciksZyxwKSwwLDApO3kuYml0bWFwPWUudHJhbnNmZXJUb0ltYWdlQml0bWFwKCk7eS5kYXRhPW51bGx9ZWxzZXt5LmtpbmQ9Tzt5LmRhdGE9bX1yLnNwbGljZShpLDQqYyxqdCk7YS5zcGxpY2UoaSw0KmMsW3ksaF0pO3JldHVybiBpKzF9KTthZGRTdGF0ZShQcixbeWUseGUsTnQsd2VdLG51bGwsZnVuY3Rpb24gaXRlcmF0ZUltYWdlTWFza0dyb3VwKGUsdCl7Y29uc3Qgcj1lLmZuQXJyYXksYT0odC0oZS5pQ3Vyci0zKSklNDtzd2l0Y2goYSl7Y2FzZSAwOnJldHVybiByW3RdPT09eWU7Y2FzZSAxOnJldHVybiByW3RdPT09eGU7Y2FzZSAyOnJldHVybiByW3RdPT09TnQ7Y2FzZSAzOnJldHVybiByW3RdPT09d2V9dGhyb3cgbmV3IEVycm9yKGBpdGVyYXRlSW1hZ2VNYXNrR3JvdXAgLSBpbnZhbGlkIHBvczogJHthfWApfSxmdW5jdGlvbiBmb3VuZEltYWdlTWFza0dyb3VwKGUsdCl7Y29uc3Qgcj1lLmZuQXJyYXksYT1lLmFyZ3NBcnJheSxuPWUuaUN1cnIsaT1uLTMscz1uLTIsbz1uLTE7bGV0IGM9TWF0aC5mbG9vcigodC1pKS80KTtpZihjPDEwKXJldHVybiB0LSh0LWkpJTQ7bGV0IGwsaCx1PSExO2NvbnN0IGQ9YVtvXVswXSxmPWFbc11bMF0sZz1hW3NdWzFdLHA9YVtzXVsyXSxtPWFbc11bM107aWYoZz09PXApe3U9ITA7bD1zKzQ7bGV0IGU9bys0O2ZvcihsZXQgdD0xO3Q8Yzt0KyssbCs9NCxlKz00KXtoPWFbbF07aWYoYVtlXVswXSE9PWR8fGhbMF0hPT1mfHxoWzFdIT09Z3x8aFsyXSE9PXB8fGhbM10hPT1tKXt0PDEwP3U9ITE6Yz10O2JyZWFrfX19aWYodSl7Yz1NYXRoLm1pbihjLDFlMyk7Y29uc3QgZT1uZXcgRmxvYXQzMkFycmF5KDIqYyk7bD1zO2ZvcihsZXQgdD0wO3Q8Yzt0KyssbCs9NCl7aD1hW2xdO2VbdDw8MV09aFs0XTtlWzErKHQ8PDEpXT1oWzVdfXIuc3BsaWNlKGksNCpjLHF0KTthLnNwbGljZShpLDQqYyxbZCxmLGcscCxtLGVdKX1lbHNle2M9TWF0aC5taW4oYywxMDApO2NvbnN0IGU9W107Zm9yKGxldCB0PTA7dDxjO3QrKyl7aD1hW3MrKHQ8PDIpXTtjb25zdCByPWFbbysodDw8MildWzBdO2UucHVzaCh7ZGF0YTpyLmRhdGEsd2lkdGg6ci53aWR0aCxoZWlnaHQ6ci5oZWlnaHQsaW50ZXJwb2xhdGU6ci5pbnRlcnBvbGF0ZSxjb3VudDpyLmNvdW50LHRyYW5zZm9ybTpofSl9ci5zcGxpY2UoaSw0KmMsUHQpO2Euc3BsaWNlKGksNCpjLFtlXSl9cmV0dXJuIGkrMX0pO2FkZFN0YXRlKFByLFt5ZSx4ZSxfdCx3ZV0sZnVuY3Rpb24oZSl7Y29uc3QgdD1lLmFyZ3NBcnJheSxyPWUuaUN1cnItMjtyZXR1cm4gMD09PXRbcl1bMV0mJjA9PT10W3JdWzJdfSxmdW5jdGlvbiBpdGVyYXRlSW1hZ2VHcm91cChlLHQpe2NvbnN0IHI9ZS5mbkFycmF5LGE9ZS5hcmdzQXJyYXksbj0odC0oZS5pQ3Vyci0zKSklNDtzd2l0Y2gobil7Y2FzZSAwOnJldHVybiByW3RdPT09eWU7Y2FzZSAxOmlmKHJbdF0hPT14ZSlyZXR1cm4hMTtjb25zdCBuPWUuaUN1cnItMixpPWFbbl1bMF0scz1hW25dWzNdO3JldHVybiBhW3RdWzBdPT09aSYmMD09PWFbdF1bMV0mJjA9PT1hW3RdWzJdJiZhW3RdWzNdPT09cztjYXNlIDI6aWYoclt0XSE9PV90KXJldHVybiExO2NvbnN0IG89YVtlLmlDdXJyLTFdWzBdO3JldHVybiBhW3RdWzBdPT09bztjYXNlIDM6cmV0dXJuIHJbdF09PT13ZX10aHJvdyBuZXcgRXJyb3IoYGl0ZXJhdGVJbWFnZUdyb3VwIC0gaW52YWxpZCBwb3M6ICR7bn1gKX0sZnVuY3Rpb24oZSx0KXtjb25zdCByPWUuZm5BcnJheSxhPWUuYXJnc0FycmF5LG49ZS5pQ3VycixpPW4tMyxzPW4tMixvPWFbbi0xXVswXSxjPWFbc11bMF0sbD1hW3NdWzNdLGg9TWF0aC5taW4oTWF0aC5mbG9vcigodC1pKS80KSwxZTMpO2lmKGg8MylyZXR1cm4gdC0odC1pKSU0O2NvbnN0IHU9bmV3IEZsb2F0MzJBcnJheSgyKmgpO2xldCBkPXM7Zm9yKGxldCBlPTA7ZTxoO2UrKyxkKz00KXtjb25zdCB0PWFbZF07dVtlPDwxXT10WzRdO3VbMSsoZTw8MSldPXRbNV19Y29uc3QgZj1bbyxjLGwsdV07ci5zcGxpY2UoaSw0KmgsVXQpO2Euc3BsaWNlKGksNCpoLGYpO3JldHVybiBpKzF9KTthZGRTdGF0ZShQcixbamUsemUsSmUsWmUsVWVdLG51bGwsZnVuY3Rpb24gaXRlcmF0ZVNob3dUZXh0R3JvdXAoZSx0KXtjb25zdCByPWUuZm5BcnJheSxhPWUuYXJnc0FycmF5LG49KHQtKGUuaUN1cnItNCkpJTU7c3dpdGNoKG4pe2Nhc2UgMDpyZXR1cm4gclt0XT09PWplO2Nhc2UgMTpyZXR1cm4gclt0XT09PXplO2Nhc2UgMjpyZXR1cm4gclt0XT09PUplO2Nhc2UgMzppZihyW3RdIT09WmUpcmV0dXJuITE7Y29uc3Qgbj1lLmlDdXJyLTMsaT1hW25dWzBdLHM9YVtuXVsxXTtyZXR1cm4gYVt0XVswXT09PWkmJmFbdF1bMV09PT1zO2Nhc2UgNDpyZXR1cm4gclt0XT09PVVlfXRocm93IG5ldyBFcnJvcihgaXRlcmF0ZVNob3dUZXh0R3JvdXAgLSBpbnZhbGlkIHBvczogJHtufWApfSxmdW5jdGlvbihlLHQpe2NvbnN0IHI9ZS5mbkFycmF5LGE9ZS5hcmdzQXJyYXksbj1lLmlDdXJyLGk9bi00LHM9bi0zLG89bi0yLGM9bi0xLGw9bixoPWFbc11bMF0sdT1hW3NdWzFdO2xldCBkPU1hdGgubWluKE1hdGguZmxvb3IoKHQtaSkvNSksMWUzKTtpZihkPDMpcmV0dXJuIHQtKHQtaSklNTtsZXQgZj1pO2lmKGk+PTQmJnJbaS00XT09PXJbc10mJnJbaS0zXT09PXJbb10mJnJbaS0yXT09PXJbY10mJnJbaS0xXT09PXJbbF0mJmFbaS00XVswXT09PWgmJmFbaS00XVsxXT09PXUpe2QrKztmLT01fWxldCBnPWYrNDtmb3IobGV0IGU9MTtlPGQ7ZSsrKXtyLnNwbGljZShnLDMpO2Euc3BsaWNlKGcsMyk7Zys9Mn1yZXR1cm4gZysxfSk7YWRkU3RhdGUoUHIsW3llLHhlLEh0LHdlXSxlPT57Y29uc3QgdD1lLmFyZ3NBcnJheSxyPXRbZS5pQ3Vyci0xXVswXTtpZihyIT09VGUmJnIhPT1PZSYmciE9PUJlJiZyIT09UmUmJnIhPT1FZSYmciE9PU5lKXJldHVybiEwO2NvbnN0IGE9dFtlLmlDdXJyLTJdO3JldHVybiAxPT09YVswXSYmMD09PWFbMV0mJjA9PT1hWzJdJiYxPT09YVszXX0sKCk9PiExLChlLHQpPT57Y29uc3R7Zm5BcnJheTpyLGFyZ3NBcnJheTphfT1lLG49ZS5pQ3VycixpPW4tMyxzPW4tMixvPWFbbi0xXSxjPWFbc10sWyxbbF0saF09bztpZihoKXtVdGlsLnNjYWxlTWluTWF4KGMsaCk7Zm9yKGxldCBlPTAsdD1sLmxlbmd0aDtlPHQ7KXN3aXRjaChsW2UrK10pe2Nhc2UgJHQ6Y2FzZSBWdDpVdGlsLmFwcGx5VHJhbnNmb3JtKGwsYyxlKTtlKz0yO2JyZWFrO2Nhc2UgS3Q6VXRpbC5hcHBseVRyYW5zZm9ybVRvQmV6aWVyKGwsYyxlKTtlKz02fX1yLnNwbGljZShpLDQsSHQpO2Euc3BsaWNlKGksNCxvKTtyZXR1cm4gaSsxfSk7Y2xhc3MgTnVsbE9wdGltaXplcntjb25zdHJ1Y3RvcihlKXt0aGlzLnF1ZXVlPWV9X29wdGltaXplKCl7fXB1c2goZSx0KXt0aGlzLnF1ZXVlLmZuQXJyYXkucHVzaChlKTt0aGlzLnF1ZXVlLmFyZ3NBcnJheS5wdXNoKHQpO3RoaXMuX29wdGltaXplKCl9Zmx1c2goKXt9cmVzZXQoKXt9fWNsYXNzIFF1ZXVlT3B0aW1pemVyIGV4dGVuZHMgTnVsbE9wdGltaXplcntjb25zdHJ1Y3RvcihlKXtzdXBlcihlKTt0aGlzLnN0YXRlPW51bGw7dGhpcy5jb250ZXh0PXtpQ3VycjowLGZuQXJyYXk6ZS5mbkFycmF5LGFyZ3NBcnJheTplLmFyZ3NBcnJheSxpc09mZnNjcmVlbkNhbnZhc1N1cHBvcnRlZDpPcGVyYXRvckxpc3QuaXNPZmZzY3JlZW5DYW52YXNTdXBwb3J0ZWR9O3RoaXMubWF0Y2g9bnVsbDt0aGlzLmxhc3RQcm9jZXNzZWQ9MH1fb3B0aW1pemUoKXtjb25zdCBlPXRoaXMucXVldWUuZm5BcnJheTtsZXQgdD10aGlzLmxhc3RQcm9jZXNzZWQscj1lLmxlbmd0aCxhPXRoaXMuc3RhdGUsbj10aGlzLm1hdGNoO2lmKCFhJiYhbiYmdCsxPT09ciYmIVByW2VbdF1dKXt0aGlzLmxhc3RQcm9jZXNzZWQ9cjtyZXR1cm59Y29uc3QgaT10aGlzLmNvbnRleHQ7Zm9yKDt0PHI7KXtpZihuKXtpZigoMCxuLml0ZXJhdGVGbikoaSx0KSl7dCsrO2NvbnRpbnVlfXQ9KDAsbi5wcm9jZXNzRm4pKGksdCsxKTtyPWUubGVuZ3RoO249bnVsbDthPW51bGw7aWYodD49cilicmVha31hPShhfHxQcilbZVt0XV07aWYoYSYmIUFycmF5LmlzQXJyYXkoYSkpe2kuaUN1cnI9dDt0Kys7aWYoIWEuY2hlY2tGbnx8KDAsYS5jaGVja0ZuKShpKSl7bj1hO2E9bnVsbH1lbHNlIGE9bnVsbH1lbHNlIHQrK310aGlzLnN0YXRlPWE7dGhpcy5tYXRjaD1uO3RoaXMubGFzdFByb2Nlc3NlZD10fWZsdXNoKCl7Zm9yKDt0aGlzLm1hdGNoOyl7Y29uc3QgZT10aGlzLnF1ZXVlLmZuQXJyYXkubGVuZ3RoO3RoaXMubGFzdFByb2Nlc3NlZD0oMCx0aGlzLm1hdGNoLnByb2Nlc3NGbikodGhpcy5jb250ZXh0LGUpO3RoaXMubWF0Y2g9bnVsbDt0aGlzLnN0YXRlPW51bGw7dGhpcy5fb3B0aW1pemUoKX19cmVzZXQoKXt0aGlzLnN0YXRlPW51bGw7dGhpcy5tYXRjaD1udWxsO3RoaXMubGFzdFByb2Nlc3NlZD0wfX1jbGFzcyBPcGVyYXRvckxpc3R7c3RhdGljIENIVU5LX1NJWkU9MWUzO3N0YXRpYyBDSFVOS19TSVpFX0FCT1VUPXRoaXMuQ0hVTktfU0laRS01O3N0YXRpYyBpc09mZnNjcmVlbkNhbnZhc1N1cHBvcnRlZD0hMTtjb25zdHJ1Y3RvcihlPTAsdCl7dGhpcy5fc3RyZWFtU2luaz10O3RoaXMuZm5BcnJheT1bXTt0aGlzLmFyZ3NBcnJheT1bXTt0aGlzLm9wdGltaXplcj0hdHx8ZSZnP25ldyBOdWxsT3B0aW1pemVyKHRoaXMpOm5ldyBRdWV1ZU9wdGltaXplcih0aGlzKTt0aGlzLmRlcGVuZGVuY2llcz1uZXcgU2V0O3RoaXMuX3RvdGFsTGVuZ3RoPTA7dGhpcy53ZWlnaHQ9MDt0aGlzLl9yZXNvbHZlZD10P251bGw6UHJvbWlzZS5yZXNvbHZlKCl9c3RhdGljIHNldE9wdGlvbnMoe2lzT2Zmc2NyZWVuQ2FudmFzU3VwcG9ydGVkOmV9KXt0aGlzLmlzT2Zmc2NyZWVuQ2FudmFzU3VwcG9ydGVkPWV9Z2V0IGxlbmd0aCgpe3JldHVybiB0aGlzLmFyZ3NBcnJheS5sZW5ndGh9Z2V0IHJlYWR5KCl7cmV0dXJuIHRoaXMuX3Jlc29sdmVkfHx0aGlzLl9zdHJlYW1TaW5rLnJlYWR5fWdldCB0b3RhbExlbmd0aCgpe3JldHVybiB0aGlzLl90b3RhbExlbmd0aCt0aGlzLmxlbmd0aH1hZGRPcChlLHQpe3RoaXMub3B0aW1pemVyLnB1c2goZSx0KTt0aGlzLndlaWdodCsrO3RoaXMuX3N0cmVhbVNpbmsmJih0aGlzLndlaWdodD49T3BlcmF0b3JMaXN0LkNIVU5LX1NJWkV8fHRoaXMud2VpZ2h0Pj1PcGVyYXRvckxpc3QuQ0hVTktfU0laRV9BQk9VVCYmKGU9PT13ZXx8ZT09PVVlKSkmJnRoaXMuZmx1c2goKX1hZGRJbWFnZU9wcyhlLHQscixhPSExKXtpZihhKXt0aGlzLmFkZE9wKHllKTt0aGlzLmFkZE9wKGJlLFtbWyJTTWFzayIsITFdXV0pfXZvaWQgMCE9PXImJnRoaXMuYWRkT3AodnQsWyJPQyIscl0pO3RoaXMuYWRkT3AoZSx0KTt2b2lkIDAhPT1yJiZ0aGlzLmFkZE9wKEZ0LFtdKTthJiZ0aGlzLmFkZE9wKHdlKX1hZGREZXBlbmRlbmN5KGUpe2lmKCF0aGlzLmRlcGVuZGVuY2llcy5oYXMoZSkpe3RoaXMuZGVwZW5kZW5jaWVzLmFkZChlKTt0aGlzLmFkZE9wKGxlLFtlXSl9fWFkZERlcGVuZGVuY2llcyhlKXtmb3IoY29uc3QgdCBvZiBlKXRoaXMuYWRkRGVwZW5kZW5jeSh0KX1hZGRPcExpc3QoZSl7aWYoZSBpbnN0YW5jZW9mIE9wZXJhdG9yTGlzdCl7Zm9yKGNvbnN0IHQgb2YgZS5kZXBlbmRlbmNpZXMpdGhpcy5kZXBlbmRlbmNpZXMuYWRkKHQpO2ZvcihsZXQgdD0wLHI9ZS5sZW5ndGg7dDxyO3QrKyl0aGlzLmFkZE9wKGUuZm5BcnJheVt0XSxlLmFyZ3NBcnJheVt0XSl9ZWxzZSB3YXJuKCdhZGRPcExpc3QgLSBpZ25vcmluZyBpbnZhbGlkICJvcExpc3QiIHBhcmFtZXRlci4nKX1nZXRJUigpe3JldHVybntmbkFycmF5OnRoaXMuZm5BcnJheSxhcmdzQXJyYXk6dGhpcy5hcmdzQXJyYXksbGVuZ3RoOnRoaXMubGVuZ3RofX1nZXQgX3RyYW5zZmVycygpe2NvbnN0IGU9W10se2ZuQXJyYXk6dCxhcmdzQXJyYXk6cixsZW5ndGg6YX09dGhpcztmb3IobGV0IG49MDtuPGE7bisrKXN3aXRjaCh0W25dKXtjYXNlIEx0OmNhc2UganQ6Y2FzZSBOdDp7Y29uc3R7Yml0bWFwOnQsZGF0YTphfT1yW25dWzBdOyh0fHxhPy5idWZmZXIpJiZlLnB1c2godHx8YS5idWZmZXIpO2JyZWFrfWNhc2UgSHQ6e2NvbnN0WyxbdF0sYV09cltuXTt0JiZlLnB1c2godC5idWZmZXIsYS5idWZmZXIpO2JyZWFrfWNhc2UgT3Q6Y29uc3RbdCxhXT1yW25dO3QmJmUucHVzaCh0LmJ1ZmZlcik7YSYmZS5wdXNoKGEuYnVmZmVyKTticmVhaztjYXNlIEplOmUucHVzaChyW25dWzBdLmJ1ZmZlcil9cmV0dXJuIGV9Zmx1c2goZT0hMSx0PW51bGwpe3RoaXMub3B0aW1pemVyLmZsdXNoKCk7Y29uc3Qgcj10aGlzLmxlbmd0aDt0aGlzLl90b3RhbExlbmd0aCs9cjt0aGlzLl9zdHJlYW1TaW5rLmVucXVldWUoe2ZuQXJyYXk6dGhpcy5mbkFycmF5LGFyZ3NBcnJheTp0aGlzLmFyZ3NBcnJheSxsYXN0Q2h1bms6ZSxzZXBhcmF0ZUFubm90czp0LGxlbmd0aDpyfSwxLHRoaXMuX3RyYW5zZmVycyk7dGhpcy5kZXBlbmRlbmNpZXMuY2xlYXIoKTt0aGlzLmZuQXJyYXkubGVuZ3RoPTA7dGhpcy5hcmdzQXJyYXkubGVuZ3RoPTA7dGhpcy53ZWlnaHQ9MDt0aGlzLm9wdGltaXplci5yZXNldCgpfX1fX3dlYnBhY2tfcmVxdWlyZV9fKDExNiksX193ZWJwYWNrX3JlcXVpcmVfXyg5NDc5KSxfX3dlYnBhY2tfcmVxdWlyZV9fKDc1ODgpO2Z1bmN0aW9uIGhleFRvSW50KGUsdCl7bGV0IHI9MDtmb3IobGV0IGE9MDthPD10O2ErKylyPXI8PDh8ZVthXTtyZXR1cm4gcj4+PjB9ZnVuY3Rpb24gaGV4VG9TdHIoZSx0KXtyZXR1cm4gMT09PXQ/U3RyaW5nLmZyb21DaGFyQ29kZShlWzBdLGVbMV0pOjM9PT10P1N0cmluZy5mcm9tQ2hhckNvZGUoZVswXSxlWzFdLGVbMl0sZVszXSk6U3RyaW5nLmZyb21DaGFyQ29kZSguLi5lLnN1YmFycmF5KDAsdCsxKSl9ZnVuY3Rpb24gYWRkSGV4KGUsdCxyKXtsZXQgYT0wO2ZvcihsZXQgbj1yO24+PTA7bi0tKXthKz1lW25dK3Rbbl07ZVtuXT0yNTUmYTthPj49OH19ZnVuY3Rpb24gaW5jSGV4KGUsdCl7bGV0IHI9MTtmb3IobGV0IGE9dDthPj0wJiZyPjA7YS0tKXtyKz1lW2FdO2VbYV09MjU1JnI7cj4+PTh9fWNvbnN0IF9yPTE2O2NsYXNzIEJpbmFyeUNNYXBTdHJlYW17Y29uc3RydWN0b3IoZSl7dGhpcy5idWZmZXI9ZTt0aGlzLnBvcz0wO3RoaXMuZW5kPWUubGVuZ3RoO3RoaXMudG1wQnVmPW5ldyBVaW50OEFycmF5KDE5KX1yZWFkQnl0ZSgpe3JldHVybiB0aGlzLnBvcz49dGhpcy5lbmQ/LTE6dGhpcy5idWZmZXJbdGhpcy5wb3MrK119cmVhZE51bWJlcigpe2xldCBlLHQ9MDtkb3tjb25zdCByPXRoaXMucmVhZEJ5dGUoKTtpZihyPDApdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJ1bmV4cGVjdGVkIEVPRiBpbiBiY21hcCIpO2U9ISgxMjgmcik7dD10PDw3fDEyNyZyfXdoaWxlKCFlKTtyZXR1cm4gdH1yZWFkU2lnbmVkKCl7Y29uc3QgZT10aGlzLnJlYWROdW1iZXIoKTtyZXR1cm4gMSZlP34oZT4+PjEpOmU+Pj4xfXJlYWRIZXgoZSx0KXtlLnNldCh0aGlzLmJ1ZmZlci5zdWJhcnJheSh0aGlzLnBvcyx0aGlzLnBvcyt0KzEpKTt0aGlzLnBvcys9dCsxfXJlYWRIZXhOdW1iZXIoZSx0KXtsZXQgcjtjb25zdCBhPXRoaXMudG1wQnVmO2xldCBuPTA7ZG97Y29uc3QgZT10aGlzLnJlYWRCeXRlKCk7aWYoZTwwKXRocm93IG5ldyBGb3JtYXRFcnJvcigidW5leHBlY3RlZCBFT0YgaW4gYmNtYXAiKTtyPSEoMTI4JmUpO2FbbisrXT0xMjcmZX13aGlsZSghcik7bGV0IGk9dCxzPTAsbz0wO2Zvcig7aT49MDspe2Zvcig7bzw4JiZhLmxlbmd0aD4wOyl7c3w9YVstLW5dPDxvO28rPTd9ZVtpXT0yNTUmcztpLS07cz4+PTg7by09OH19cmVhZEhleFNpZ25lZChlLHQpe3RoaXMucmVhZEhleE51bWJlcihlLHQpO2NvbnN0IHI9MSZlW3RdPzI1NTowO2xldCBhPTA7Zm9yKGxldCBuPTA7bjw9dDtuKyspe2E9KDEmYSk8PDh8ZVtuXTtlW25dPWE+PjFecn19cmVhZFN0cmluZygpe2NvbnN0IGU9dGhpcy5yZWFkTnVtYmVyKCksdD1uZXcgQXJyYXkoZSk7Zm9yKGxldCByPTA7cjxlO3IrKyl0W3JdPXRoaXMucmVhZE51bWJlcigpO3JldHVybiBTdHJpbmcuZnJvbUNoYXJDb2RlKC4uLnQpfX1jbGFzcyBCaW5hcnlDTWFwUmVhZGVye2FzeW5jIHByb2Nlc3MoZSx0LHIpe2NvbnN0IGE9bmV3IEJpbmFyeUNNYXBTdHJlYW0oZSksbj1hLnJlYWRCeXRlKCk7dC52ZXJ0aWNhbD0hISgxJm4pO2xldCBpPW51bGw7Y29uc3Qgcz1uZXcgVWludDhBcnJheShfciksbz1uZXcgVWludDhBcnJheShfciksYz1uZXcgVWludDhBcnJheShfciksbD1uZXcgVWludDhBcnJheShfciksaD1uZXcgVWludDhBcnJheShfcik7bGV0IHUsZDtmb3IoOyhkPWEucmVhZEJ5dGUoKSk+PTA7KXtjb25zdCBlPWQ+PjU7aWYoNz09PWUpe3N3aXRjaCgzMSZkKXtjYXNlIDA6YS5yZWFkU3RyaW5nKCk7YnJlYWs7Y2FzZSAxOmk9YS5yZWFkU3RyaW5nKCl9Y29udGludWV9Y29uc3Qgcj0hISgxNiZkKSxuPTE1JmQ7aWYobisxPl9yKXRocm93IG5ldyBFcnJvcigiQmluYXJ5Q01hcFJlYWRlci5wcm9jZXNzOiBJbnZhbGlkIGRhdGFTaXplLiIpO2NvbnN0IGY9MSxnPWEucmVhZE51bWJlcigpO3N3aXRjaChlKXtjYXNlIDA6YS5yZWFkSGV4KHMsbik7YS5yZWFkSGV4TnVtYmVyKG8sbik7YWRkSGV4KG8scyxuKTt0LmFkZENvZGVzcGFjZVJhbmdlKG4rMSxoZXhUb0ludChzLG4pLGhleFRvSW50KG8sbikpO2ZvcihsZXQgZT0xO2U8ZztlKyspe2luY0hleChvLG4pO2EucmVhZEhleE51bWJlcihzLG4pO2FkZEhleChzLG8sbik7YS5yZWFkSGV4TnVtYmVyKG8sbik7YWRkSGV4KG8scyxuKTt0LmFkZENvZGVzcGFjZVJhbmdlKG4rMSxoZXhUb0ludChzLG4pLGhleFRvSW50KG8sbikpfWJyZWFrO2Nhc2UgMTphLnJlYWRIZXgocyxuKTthLnJlYWRIZXhOdW1iZXIobyxuKTthZGRIZXgobyxzLG4pO2EucmVhZE51bWJlcigpO2ZvcihsZXQgZT0xO2U8ZztlKyspe2luY0hleChvLG4pO2EucmVhZEhleE51bWJlcihzLG4pO2FkZEhleChzLG8sbik7YS5yZWFkSGV4TnVtYmVyKG8sbik7YWRkSGV4KG8scyxuKTthLnJlYWROdW1iZXIoKX1icmVhaztjYXNlIDI6YS5yZWFkSGV4KGMsbik7dT1hLnJlYWROdW1iZXIoKTt0Lm1hcE9uZShoZXhUb0ludChjLG4pLHUpO2ZvcihsZXQgZT0xO2U8ZztlKyspe2luY0hleChjLG4pO2lmKCFyKXthLnJlYWRIZXhOdW1iZXIoaCxuKTthZGRIZXgoYyxoLG4pfXU9YS5yZWFkU2lnbmVkKCkrKHUrMSk7dC5tYXBPbmUoaGV4VG9JbnQoYyxuKSx1KX1icmVhaztjYXNlIDM6YS5yZWFkSGV4KHMsbik7YS5yZWFkSGV4TnVtYmVyKG8sbik7YWRkSGV4KG8scyxuKTt1PWEucmVhZE51bWJlcigpO3QubWFwQ2lkUmFuZ2UoaGV4VG9JbnQocyxuKSxoZXhUb0ludChvLG4pLHUpO2ZvcihsZXQgZT0xO2U8ZztlKyspe2luY0hleChvLG4pO2lmKHIpcy5zZXQobyk7ZWxzZXthLnJlYWRIZXhOdW1iZXIocyxuKTthZGRIZXgocyxvLG4pfWEucmVhZEhleE51bWJlcihvLG4pO2FkZEhleChvLHMsbik7dT1hLnJlYWROdW1iZXIoKTt0Lm1hcENpZFJhbmdlKGhleFRvSW50KHMsbiksaGV4VG9JbnQobyxuKSx1KX1icmVhaztjYXNlIDQ6YS5yZWFkSGV4KGMsZik7YS5yZWFkSGV4KGwsbik7dC5tYXBPbmUoaGV4VG9JbnQoYyxmKSxoZXhUb1N0cihsLG4pKTtmb3IobGV0IGU9MTtlPGc7ZSsrKXtpbmNIZXgoYyxmKTtpZighcil7YS5yZWFkSGV4TnVtYmVyKGgsZik7YWRkSGV4KGMsaCxmKX1pbmNIZXgobCxuKTthLnJlYWRIZXhTaWduZWQoaCxuKTthZGRIZXgobCxoLG4pO3QubWFwT25lKGhleFRvSW50KGMsZiksaGV4VG9TdHIobCxuKSl9YnJlYWs7Y2FzZSA1OmEucmVhZEhleChzLGYpO2EucmVhZEhleE51bWJlcihvLGYpO2FkZEhleChvLHMsZik7YS5yZWFkSGV4KGwsbik7dC5tYXBCZlJhbmdlKGhleFRvSW50KHMsZiksaGV4VG9JbnQobyxmKSxoZXhUb1N0cihsLG4pKTtmb3IobGV0IGU9MTtlPGc7ZSsrKXtpbmNIZXgobyxmKTtpZihyKXMuc2V0KG8pO2Vsc2V7YS5yZWFkSGV4TnVtYmVyKHMsZik7YWRkSGV4KHMsbyxmKX1hLnJlYWRIZXhOdW1iZXIobyxmKTthZGRIZXgobyxzLGYpO2EucmVhZEhleChsLG4pO3QubWFwQmZSYW5nZShoZXhUb0ludChzLGYpLGhleFRvSW50KG8sZiksaGV4VG9TdHIobCxuKSl9YnJlYWs7ZGVmYXVsdDp0aHJvdyBuZXcgRXJyb3IoYEJpbmFyeUNNYXBSZWFkZXIucHJvY2VzcyAtIHVua25vd24gdHlwZTogJHtlfWApfX1yZXR1cm4gaT9yKGkpOnR9fWNsYXNzIEFzY2lpODVTdHJlYW0gZXh0ZW5kcyBEZWNvZGVTdHJlYW17Y29uc3RydWN0b3IoZSx0KXt0JiYodCo9LjgpO3N1cGVyKHQpO3RoaXMuc3RyPWU7dGhpcy5kaWN0PWUuZGljdDt0aGlzLmlucHV0PW5ldyBVaW50OEFycmF5KDUpfXJlYWRCbG9jaygpe2NvbnN0IGU9dGhpcy5zdHI7bGV0IHQ9ZS5nZXRCeXRlKCk7Zm9yKDtpc1doaXRlU3BhY2UodCk7KXQ9ZS5nZXRCeXRlKCk7aWYoLTE9PT10fHwxMjY9PT10KXt0aGlzLmVvZj0hMDtyZXR1cm59Y29uc3Qgcj10aGlzLmJ1ZmZlckxlbmd0aDtsZXQgYSxuO2lmKDEyMj09PXQpe2E9dGhpcy5lbnN1cmVCdWZmZXIocis0KTtmb3Iobj0wO248NDsrK24pYVtyK25dPTA7dGhpcy5idWZmZXJMZW5ndGgrPTR9ZWxzZXtjb25zdCBpPXRoaXMuaW5wdXQ7aVswXT10O2ZvcihuPTE7bjw1Oysrbil7dD1lLmdldEJ5dGUoKTtmb3IoO2lzV2hpdGVTcGFjZSh0KTspdD1lLmdldEJ5dGUoKTtpW25dPXQ7aWYoLTE9PT10fHwxMjY9PT10KWJyZWFrfWE9dGhpcy5lbnN1cmVCdWZmZXIocituLTEpO3RoaXMuYnVmZmVyTGVuZ3RoKz1uLTE7aWYobjw1KXtmb3IoO248NTsrK24paVtuXT0xMTc7dGhpcy5lb2Y9ITB9bGV0IHM9MDtmb3Iobj0wO248NTsrK24pcz04NSpzKyhpW25dLTMzKTtmb3Iobj0zO24+PTA7LS1uKXthW3Irbl09MjU1JnM7cz4+PTh9fX19Y2xhc3MgQXNjaWlIZXhTdHJlYW0gZXh0ZW5kcyBEZWNvZGVTdHJlYW17Y29uc3RydWN0b3IoZSx0KXt0JiYodCo9LjUpO3N1cGVyKHQpO3RoaXMuc3RyPWU7dGhpcy5kaWN0PWUuZGljdDt0aGlzLmZpcnN0RGlnaXQ9LTF9cmVhZEJsb2NrKCl7Y29uc3QgZT10aGlzLnN0ci5nZXRCeXRlcyg4ZTMpO2lmKCFlLmxlbmd0aCl7dGhpcy5lb2Y9ITA7cmV0dXJufWNvbnN0IHQ9ZS5sZW5ndGgrMT4+MSxyPXRoaXMuZW5zdXJlQnVmZmVyKHRoaXMuYnVmZmVyTGVuZ3RoK3QpO2xldCBhPXRoaXMuYnVmZmVyTGVuZ3RoLG49dGhpcy5maXJzdERpZ2l0O2Zvcihjb25zdCB0IG9mIGUpe2xldCBlO2lmKHQ+PTQ4JiZ0PD01NyllPTE1JnQ7ZWxzZXtpZighKHQ+PTY1JiZ0PD03MHx8dD49OTcmJnQ8PTEwMikpe2lmKDYyPT09dCl7dGhpcy5lb2Y9ITA7YnJlYWt9Y29udGludWV9ZT05KygxNSZ0KX1pZihuPDApbj1lO2Vsc2V7clthKytdPW48PDR8ZTtuPS0xfX1pZihuPj0wJiZ0aGlzLmVvZil7clthKytdPW48PDQ7bj0tMX10aGlzLmZpcnN0RGlnaXQ9bjt0aGlzLmJ1ZmZlckxlbmd0aD1hfX1jb25zdCBMcj0tMSxqcj1bWy0xLC0xXSxbLTEsLTFdLFs3LDhdLFs3LDddLFs2LDZdLFs2LDZdLFs2LDVdLFs2LDVdLFs0LDBdLFs0LDBdLFs0LDBdLFs0LDBdLFs0LDBdLFs0LDBdLFs0LDBdLFs0LDBdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDFdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDRdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFszLDNdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdLFsxLDJdXSxVcj1bWy0xLC0xXSxbMTIsLTJdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbMTEsMTc5Ml0sWzExLDE3OTJdLFsxMiwxOTg0XSxbMTIsMjA0OF0sWzEyLDIxMTJdLFsxMiwyMTc2XSxbMTIsMjI0MF0sWzEyLDIzMDRdLFsxMSwxODU2XSxbMTEsMTg1Nl0sWzExLDE5MjBdLFsxMSwxOTIwXSxbMTIsMjM2OF0sWzEyLDI0MzJdLFsxMiwyNDk2XSxbMTIsMjU2MF1dLHFyPVtbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFs4LDI5XSxbOCwyOV0sWzgsMzBdLFs4LDMwXSxbOCw0NV0sWzgsNDVdLFs4LDQ2XSxbOCw0Nl0sWzcsMjJdLFs3LDIyXSxbNywyMl0sWzcsMjJdLFs3LDIzXSxbNywyM10sWzcsMjNdLFs3LDIzXSxbOCw0N10sWzgsNDddLFs4LDQ4XSxbOCw0OF0sWzYsMTNdLFs2LDEzXSxbNiwxM10sWzYsMTNdLFs2LDEzXSxbNiwxM10sWzYsMTNdLFs2LDEzXSxbNywyMF0sWzcsMjBdLFs3LDIwXSxbNywyMF0sWzgsMzNdLFs4LDMzXSxbOCwzNF0sWzgsMzRdLFs4LDM1XSxbOCwzNV0sWzgsMzZdLFs4LDM2XSxbOCwzN10sWzgsMzddLFs4LDM4XSxbOCwzOF0sWzcsMTldLFs3LDE5XSxbNywxOV0sWzcsMTldLFs4LDMxXSxbOCwzMV0sWzgsMzJdLFs4LDMyXSxbNiwxXSxbNiwxXSxbNiwxXSxbNiwxXSxbNiwxXSxbNiwxXSxbNiwxXSxbNiwxXSxbNiwxMl0sWzYsMTJdLFs2LDEyXSxbNiwxMl0sWzYsMTJdLFs2LDEyXSxbNiwxMl0sWzYsMTJdLFs4LDUzXSxbOCw1M10sWzgsNTRdLFs4LDU0XSxbNywyNl0sWzcsMjZdLFs3LDI2XSxbNywyNl0sWzgsMzldLFs4LDM5XSxbOCw0MF0sWzgsNDBdLFs4LDQxXSxbOCw0MV0sWzgsNDJdLFs4LDQyXSxbOCw0M10sWzgsNDNdLFs4LDQ0XSxbOCw0NF0sWzcsMjFdLFs3LDIxXSxbNywyMV0sWzcsMjFdLFs3LDI4XSxbNywyOF0sWzcsMjhdLFs3LDI4XSxbOCw2MV0sWzgsNjFdLFs4LDYyXSxbOCw2Ml0sWzgsNjNdLFs4LDYzXSxbOCwwXSxbOCwwXSxbOCwzMjBdLFs4LDMyMF0sWzgsMzg0XSxbOCwzODRdLFs1LDEwXSxbNSwxMF0sWzUsMTBdLFs1LDEwXSxbNSwxMF0sWzUsMTBdLFs1LDEwXSxbNSwxMF0sWzUsMTBdLFs1LDEwXSxbNSwxMF0sWzUsMTBdLFs1LDEwXSxbNSwxMF0sWzUsMTBdLFs1LDEwXSxbNSwxMV0sWzUsMTFdLFs1LDExXSxbNSwxMV0sWzUsMTFdLFs1LDExXSxbNSwxMV0sWzUsMTFdLFs1LDExXSxbNSwxMV0sWzUsMTFdLFs1LDExXSxbNSwxMV0sWzUsMTFdLFs1LDExXSxbNSwxMV0sWzcsMjddLFs3LDI3XSxbNywyN10sWzcsMjddLFs4LDU5XSxbOCw1OV0sWzgsNjBdLFs4LDYwXSxbOSwxNDcyXSxbOSwxNTM2XSxbOSwxNjAwXSxbOSwxNzI4XSxbNywxOF0sWzcsMThdLFs3LDE4XSxbNywxOF0sWzcsMjRdLFs3LDI0XSxbNywyNF0sWzcsMjRdLFs4LDQ5XSxbOCw0OV0sWzgsNTBdLFs4LDUwXSxbOCw1MV0sWzgsNTFdLFs4LDUyXSxbOCw1Ml0sWzcsMjVdLFs3LDI1XSxbNywyNV0sWzcsMjVdLFs4LDU1XSxbOCw1NV0sWzgsNTZdLFs4LDU2XSxbOCw1N10sWzgsNTddLFs4LDU4XSxbOCw1OF0sWzYsMTkyXSxbNiwxOTJdLFs2LDE5Ml0sWzYsMTkyXSxbNiwxOTJdLFs2LDE5Ml0sWzYsMTkyXSxbNiwxOTJdLFs2LDE2NjRdLFs2LDE2NjRdLFs2LDE2NjRdLFs2LDE2NjRdLFs2LDE2NjRdLFs2LDE2NjRdLFs2LDE2NjRdLFs2LDE2NjRdLFs4LDQ0OF0sWzgsNDQ4XSxbOCw1MTJdLFs4LDUxMl0sWzksNzA0XSxbOSw3NjhdLFs4LDY0MF0sWzgsNjQwXSxbOCw1NzZdLFs4LDU3Nl0sWzksODMyXSxbOSw4OTZdLFs5LDk2MF0sWzksMTAyNF0sWzksMTA4OF0sWzksMTE1Ml0sWzksMTIxNl0sWzksMTI4MF0sWzksMTM0NF0sWzksMTQwOF0sWzcsMjU2XSxbNywyNTZdLFs3LDI1Nl0sWzcsMjU2XSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwyXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNCwzXSxbNSwxMjhdLFs1LDEyOF0sWzUsMTI4XSxbNSwxMjhdLFs1LDEyOF0sWzUsMTI4XSxbNSwxMjhdLFs1LDEyOF0sWzUsMTI4XSxbNSwxMjhdLFs1LDEyOF0sWzUsMTI4XSxbNSwxMjhdLFs1LDEyOF0sWzUsMTI4XSxbNSwxMjhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDhdLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs1LDldLFs2LDE2XSxbNiwxNl0sWzYsMTZdLFs2LDE2XSxbNiwxNl0sWzYsMTZdLFs2LDE2XSxbNiwxNl0sWzYsMTddLFs2LDE3XSxbNiwxN10sWzYsMTddLFs2LDE3XSxbNiwxN10sWzYsMTddLFs2LDE3XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw0XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbNiwxNF0sWzYsMTRdLFs2LDE0XSxbNiwxNF0sWzYsMTRdLFs2LDE0XSxbNiwxNF0sWzYsMTRdLFs2LDE1XSxbNiwxNV0sWzYsMTVdLFs2LDE1XSxbNiwxNV0sWzYsMTVdLFs2LDE1XSxbNiwxNV0sWzUsNjRdLFs1LDY0XSxbNSw2NF0sWzUsNjRdLFs1LDY0XSxbNSw2NF0sWzUsNjRdLFs1LDY0XSxbNSw2NF0sWzUsNjRdLFs1LDY0XSxbNSw2NF0sWzUsNjRdLFs1LDY0XSxbNSw2NF0sWzUsNjRdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDZdLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddLFs0LDddXSxYcj1bWy0xLC0xXSxbLTEsLTFdLFsxMiwtMl0sWzEyLC0yXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbLTEsLTFdLFsxMSwxNzkyXSxbMTEsMTc5Ml0sWzExLDE3OTJdLFsxMSwxNzkyXSxbMTIsMTk4NF0sWzEyLDE5ODRdLFsxMiwyMDQ4XSxbMTIsMjA0OF0sWzEyLDIxMTJdLFsxMiwyMTEyXSxbMTIsMjE3Nl0sWzEyLDIxNzZdLFsxMiwyMjQwXSxbMTIsMjI0MF0sWzEyLDIzMDRdLFsxMiwyMzA0XSxbMTEsMTg1Nl0sWzExLDE4NTZdLFsxMSwxODU2XSxbMTEsMTg1Nl0sWzExLDE5MjBdLFsxMSwxOTIwXSxbMTEsMTkyMF0sWzExLDE5MjBdLFsxMiwyMzY4XSxbMTIsMjM2OF0sWzEyLDI0MzJdLFsxMiwyNDMyXSxbMTIsMjQ5Nl0sWzEyLDI0OTZdLFsxMiwyNTYwXSxbMTIsMjU2MF0sWzEwLDE4XSxbMTAsMThdLFsxMCwxOF0sWzEwLDE4XSxbMTAsMThdLFsxMCwxOF0sWzEwLDE4XSxbMTAsMThdLFsxMiw1Ml0sWzEyLDUyXSxbMTMsNjQwXSxbMTMsNzA0XSxbMTMsNzY4XSxbMTMsODMyXSxbMTIsNTVdLFsxMiw1NV0sWzEyLDU2XSxbMTIsNTZdLFsxMywxMjgwXSxbMTMsMTM0NF0sWzEzLDE0MDhdLFsxMywxNDcyXSxbMTIsNTldLFsxMiw1OV0sWzEyLDYwXSxbMTIsNjBdLFsxMywxNTM2XSxbMTMsMTYwMF0sWzExLDI0XSxbMTEsMjRdLFsxMSwyNF0sWzExLDI0XSxbMTEsMjVdLFsxMSwyNV0sWzExLDI1XSxbMTEsMjVdLFsxMywxNjY0XSxbMTMsMTcyOF0sWzEyLDMyMF0sWzEyLDMyMF0sWzEyLDM4NF0sWzEyLDM4NF0sWzEyLDQ0OF0sWzEyLDQ0OF0sWzEzLDUxMl0sWzEzLDU3Nl0sWzEyLDUzXSxbMTIsNTNdLFsxMiw1NF0sWzEyLDU0XSxbMTMsODk2XSxbMTMsOTYwXSxbMTMsMTAyNF0sWzEzLDEwODhdLFsxMywxMTUyXSxbMTMsMTIxNl0sWzEwLDY0XSxbMTAsNjRdLFsxMCw2NF0sWzEwLDY0XSxbMTAsNjRdLFsxMCw2NF0sWzEwLDY0XSxbMTAsNjRdXSxIcj1bWzgsMTNdLFs4LDEzXSxbOCwxM10sWzgsMTNdLFs4LDEzXSxbOCwxM10sWzgsMTNdLFs4LDEzXSxbOCwxM10sWzgsMTNdLFs4LDEzXSxbOCwxM10sWzgsMTNdLFs4LDEzXSxbOCwxM10sWzgsMTNdLFsxMSwyM10sWzExLDIzXSxbMTIsNTBdLFsxMiw1MV0sWzEyLDQ0XSxbMTIsNDVdLFsxMiw0Nl0sWzEyLDQ3XSxbMTIsNTddLFsxMiw1OF0sWzEyLDYxXSxbMTIsMjU2XSxbMTAsMTZdLFsxMCwxNl0sWzEwLDE2XSxbMTAsMTZdLFsxMCwxN10sWzEwLDE3XSxbMTAsMTddLFsxMCwxN10sWzEyLDQ4XSxbMTIsNDldLFsxMiw2Ml0sWzEyLDYzXSxbMTIsMzBdLFsxMiwzMV0sWzEyLDMyXSxbMTIsMzNdLFsxMiw0MF0sWzEyLDQxXSxbMTEsMjJdLFsxMSwyMl0sWzgsMTRdLFs4LDE0XSxbOCwxNF0sWzgsMTRdLFs4LDE0XSxbOCwxNF0sWzgsMTRdLFs4LDE0XSxbOCwxNF0sWzgsMTRdLFs4LDE0XSxbOCwxNF0sWzgsMTRdLFs4LDE0XSxbOCwxNF0sWzgsMTRdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTBdLFs3LDEwXSxbNywxMF0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbNywxMV0sWzcsMTFdLFs3LDExXSxbOSwxNV0sWzksMTVdLFs5LDE1XSxbOSwxNV0sWzksMTVdLFs5LDE1XSxbOSwxNV0sWzksMTVdLFsxMiwxMjhdLFsxMiwxOTJdLFsxMiwyNl0sWzEyLDI3XSxbMTIsMjhdLFsxMiwyOV0sWzExLDE5XSxbMTEsMTldLFsxMSwyMF0sWzExLDIwXSxbMTIsMzRdLFsxMiwzNV0sWzEyLDM2XSxbMTIsMzddLFsxMiwzOF0sWzEyLDM5XSxbMTEsMjFdLFsxMSwyMV0sWzEyLDQyXSxbMTIsNDNdLFsxMCwwXSxbMTAsMF0sWzEwLDBdLFsxMCwwXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdLFs3LDEyXSxbNywxMl0sWzcsMTJdXSxXcj1bWy0xLC0xXSxbLTEsLTFdLFstMSwtMV0sWy0xLC0xXSxbNiw5XSxbNiw4XSxbNSw3XSxbNSw3XSxbNCw2XSxbNCw2XSxbNCw2XSxbNCw2XSxbNCw1XSxbNCw1XSxbNCw1XSxbNCw1XSxbMywxXSxbMywxXSxbMywxXSxbMywxXSxbMywxXSxbMywxXSxbMywxXSxbMywxXSxbMyw0XSxbMyw0XSxbMyw0XSxbMyw0XSxbMyw0XSxbMyw0XSxbMyw0XSxbMyw0XSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwzXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXSxbMiwyXV07Y2xhc3MgQ0NJVFRGYXhEZWNvZGVye2NvbnN0cnVjdG9yKGUsdD17fSl7aWYoImZ1bmN0aW9uIiE9dHlwZW9mIGU/Lm5leHQpdGhyb3cgbmV3IEVycm9yKCdDQ0lUVEZheERlY29kZXIgLSBpbnZhbGlkICJzb3VyY2UiIHBhcmFtZXRlci4nKTt0aGlzLnNvdXJjZT1lO3RoaXMuZW9mPSExO3RoaXMuZW5jb2Rpbmc9dC5LfHwwO3RoaXMuZW9saW5lPXQuRW5kT2ZMaW5lfHwhMTt0aGlzLmJ5dGVBbGlnbj10LkVuY29kZWRCeXRlQWxpZ258fCExO3RoaXMuY29sdW1ucz10LkNvbHVtbnN8fDE3Mjg7dGhpcy5yb3dzPXQuUm93c3x8MDt0aGlzLmVvYmxvY2s9dC5FbmRPZkJsb2NrPz8hMDt0aGlzLmJsYWNrPXQuQmxhY2tJczF8fCExO3RoaXMuY29kaW5nTGluZT1uZXcgVWludDMyQXJyYXkodGhpcy5jb2x1bW5zKzEpO3RoaXMucmVmTGluZT1uZXcgVWludDMyQXJyYXkodGhpcy5jb2x1bW5zKzIpO3RoaXMuY29kaW5nTGluZVswXT10aGlzLmNvbHVtbnM7dGhpcy5jb2RpbmdQb3M9MDt0aGlzLnJvdz0wO3RoaXMubmV4dExpbmUyRD10aGlzLmVuY29kaW5nPDA7dGhpcy5pbnB1dEJpdHM9MDt0aGlzLmlucHV0QnVmPTA7dGhpcy5vdXRwdXRCaXRzPTA7dGhpcy5yb3dzRG9uZT0hMTtsZXQgcjtmb3IoOzA9PT0ocj10aGlzLl9sb29rQml0cygxMikpOyl0aGlzLl9lYXRCaXRzKDEpOzE9PT1yJiZ0aGlzLl9lYXRCaXRzKDEyKTtpZih0aGlzLmVuY29kaW5nPjApe3RoaXMubmV4dExpbmUyRD0hdGhpcy5fbG9va0JpdHMoMSk7dGhpcy5fZWF0Qml0cygxKX19cmVhZE5leHRDaGFyKCl7aWYodGhpcy5lb2YpcmV0dXJuLTE7Y29uc3QgZT10aGlzLnJlZkxpbmUsdD10aGlzLmNvZGluZ0xpbmUscj10aGlzLmNvbHVtbnM7bGV0IGEsbixpLHMsbztpZigwPT09dGhpcy5vdXRwdXRCaXRzKXt0aGlzLnJvd3NEb25lJiYodGhpcy5lb2Y9ITApO2lmKHRoaXMuZW9mKXJldHVybi0xO3RoaXMuZXJyPSExO2xldCBpLG8sYztpZih0aGlzLm5leHRMaW5lMkQpe2ZvcihzPTA7dFtzXTxyOysrcyllW3NdPXRbc107ZVtzKytdPXI7ZVtzXT1yO3RbMF09MDt0aGlzLmNvZGluZ1Bvcz0wO2E9MDtuPTA7Zm9yKDt0W3RoaXMuY29kaW5nUG9zXTxyOyl7aT10aGlzLl9nZXRUd29EaW1Db2RlKCk7c3dpdGNoKGkpe2Nhc2UgMDp0aGlzLl9hZGRQaXhlbHMoZVthKzFdLG4pO2VbYSsxXTxyJiYoYSs9Mik7YnJlYWs7Y2FzZSAxOmk9bz0wO2lmKG4pe2Rve2krPWM9dGhpcy5fZ2V0QmxhY2tDb2RlKCl9d2hpbGUoYz49NjQpO2Rve28rPWM9dGhpcy5fZ2V0V2hpdGVDb2RlKCl9d2hpbGUoYz49NjQpfWVsc2V7ZG97aSs9Yz10aGlzLl9nZXRXaGl0ZUNvZGUoKX13aGlsZShjPj02NCk7ZG97bys9Yz10aGlzLl9nZXRCbGFja0NvZGUoKX13aGlsZShjPj02NCl9dGhpcy5fYWRkUGl4ZWxzKHRbdGhpcy5jb2RpbmdQb3NdK2ksbik7dFt0aGlzLmNvZGluZ1Bvc108ciYmdGhpcy5fYWRkUGl4ZWxzKHRbdGhpcy5jb2RpbmdQb3NdK28sMV5uKTtmb3IoO2VbYV08PXRbdGhpcy5jb2RpbmdQb3NdJiZlW2FdPHI7KWErPTI7YnJlYWs7Y2FzZSA3OnRoaXMuX2FkZFBpeGVscyhlW2FdKzMsbik7bl49MTtpZih0W3RoaXMuY29kaW5nUG9zXTxyKXsrK2E7Zm9yKDtlW2FdPD10W3RoaXMuY29kaW5nUG9zXSYmZVthXTxyOylhKz0yfWJyZWFrO2Nhc2UgNTp0aGlzLl9hZGRQaXhlbHMoZVthXSsyLG4pO25ePTE7aWYodFt0aGlzLmNvZGluZ1Bvc108cil7KythO2Zvcig7ZVthXTw9dFt0aGlzLmNvZGluZ1Bvc10mJmVbYV08cjspYSs9Mn1icmVhaztjYXNlIDM6dGhpcy5fYWRkUGl4ZWxzKGVbYV0rMSxuKTtuXj0xO2lmKHRbdGhpcy5jb2RpbmdQb3NdPHIpeysrYTtmb3IoO2VbYV08PXRbdGhpcy5jb2RpbmdQb3NdJiZlW2FdPHI7KWErPTJ9YnJlYWs7Y2FzZSAyOnRoaXMuX2FkZFBpeGVscyhlW2FdLG4pO25ePTE7aWYodFt0aGlzLmNvZGluZ1Bvc108cil7KythO2Zvcig7ZVthXTw9dFt0aGlzLmNvZGluZ1Bvc10mJmVbYV08cjspYSs9Mn1icmVhaztjYXNlIDg6dGhpcy5fYWRkUGl4ZWxzTmVnKGVbYV0tMyxuKTtuXj0xO2lmKHRbdGhpcy5jb2RpbmdQb3NdPHIpe2E+MD8tLWE6KythO2Zvcig7ZVthXTw9dFt0aGlzLmNvZGluZ1Bvc10mJmVbYV08cjspYSs9Mn1icmVhaztjYXNlIDY6dGhpcy5fYWRkUGl4ZWxzTmVnKGVbYV0tMixuKTtuXj0xO2lmKHRbdGhpcy5jb2RpbmdQb3NdPHIpe2E+MD8tLWE6KythO2Zvcig7ZVthXTw9dFt0aGlzLmNvZGluZ1Bvc10mJmVbYV08cjspYSs9Mn1icmVhaztjYXNlIDQ6dGhpcy5fYWRkUGl4ZWxzTmVnKGVbYV0tMSxuKTtuXj0xO2lmKHRbdGhpcy5jb2RpbmdQb3NdPHIpe2E+MD8tLWE6KythO2Zvcig7ZVthXTw9dFt0aGlzLmNvZGluZ1Bvc10mJmVbYV08cjspYSs9Mn1icmVhaztjYXNlIExyOnRoaXMuX2FkZFBpeGVscyhyLDApO3RoaXMuZW9mPSEwO2JyZWFrO2RlZmF1bHQ6aW5mbygiYmFkIDJkIGNvZGUiKTt0aGlzLl9hZGRQaXhlbHMociwwKTt0aGlzLmVycj0hMH19fWVsc2V7dFswXT0wO3RoaXMuY29kaW5nUG9zPTA7bj0wO2Zvcig7dFt0aGlzLmNvZGluZ1Bvc108cjspe2k9MDtpZihuKWRve2krPWM9dGhpcy5fZ2V0QmxhY2tDb2RlKCl9d2hpbGUoYz49NjQpO2Vsc2UgZG97aSs9Yz10aGlzLl9nZXRXaGl0ZUNvZGUoKX13aGlsZShjPj02NCk7dGhpcy5fYWRkUGl4ZWxzKHRbdGhpcy5jb2RpbmdQb3NdK2ksbik7bl49MX19bGV0IGw9ITE7dGhpcy5ieXRlQWxpZ24mJih0aGlzLmlucHV0Qml0cyY9LTgpO2lmKHRoaXMuZW9ibG9ja3x8dGhpcy5yb3chPT10aGlzLnJvd3MtMSl7aT10aGlzLl9sb29rQml0cygxMik7aWYodGhpcy5lb2xpbmUpZm9yKDtpIT09THImJjEhPT1pOyl7dGhpcy5fZWF0Qml0cygxKTtpPXRoaXMuX2xvb2tCaXRzKDEyKX1lbHNlIGZvcig7MD09PWk7KXt0aGlzLl9lYXRCaXRzKDEpO2k9dGhpcy5fbG9va0JpdHMoMTIpfWlmKDE9PT1pKXt0aGlzLl9lYXRCaXRzKDEyKTtsPSEwfWVsc2UgaT09PUxyJiYodGhpcy5lb2Y9ITApfWVsc2UgdGhpcy5yb3dzRG9uZT0hMDtpZighdGhpcy5lb2YmJnRoaXMuZW5jb2Rpbmc+MCYmIXRoaXMucm93c0RvbmUpe3RoaXMubmV4dExpbmUyRD0hdGhpcy5fbG9va0JpdHMoMSk7dGhpcy5fZWF0Qml0cygxKX1pZih0aGlzLmVvYmxvY2smJmwmJnRoaXMuYnl0ZUFsaWduKXtpPXRoaXMuX2xvb2tCaXRzKDEyKTtpZigxPT09aSl7dGhpcy5fZWF0Qml0cygxMik7aWYodGhpcy5lbmNvZGluZz4wKXt0aGlzLl9sb29rQml0cygxKTt0aGlzLl9lYXRCaXRzKDEpfWlmKHRoaXMuZW5jb2Rpbmc+PTApZm9yKHM9MDtzPDQ7KytzKXtpPXRoaXMuX2xvb2tCaXRzKDEyKTsxIT09aSYmaW5mbygiYmFkIHJ0YyBjb2RlOiAiK2kpO3RoaXMuX2VhdEJpdHMoMTIpO2lmKHRoaXMuZW5jb2Rpbmc+MCl7dGhpcy5fbG9va0JpdHMoMSk7dGhpcy5fZWF0Qml0cygxKX19dGhpcy5lb2Y9ITB9fWVsc2UgaWYodGhpcy5lcnImJnRoaXMuZW9saW5lKXtmb3IoOzspe2k9dGhpcy5fbG9va0JpdHMoMTMpO2lmKGk9PT1Mcil7dGhpcy5lb2Y9ITA7cmV0dXJuLTF9aWYoaT4+MT09MSlicmVhazt0aGlzLl9lYXRCaXRzKDEpfXRoaXMuX2VhdEJpdHMoMTIpO2lmKHRoaXMuZW5jb2Rpbmc+MCl7dGhpcy5fZWF0Qml0cygxKTt0aGlzLm5leHRMaW5lMkQ9ISgxJmkpfX10aGlzLm91dHB1dEJpdHM9dFswXT4wP3RbdGhpcy5jb2RpbmdQb3M9MF06dFt0aGlzLmNvZGluZ1Bvcz0xXTt0aGlzLnJvdysrfWlmKHRoaXMub3V0cHV0Qml0cz49OCl7bz0xJnRoaXMuY29kaW5nUG9zPzA6MjU1O3RoaXMub3V0cHV0Qml0cy09ODtpZigwPT09dGhpcy5vdXRwdXRCaXRzJiZ0W3RoaXMuY29kaW5nUG9zXTxyKXt0aGlzLmNvZGluZ1BvcysrO3RoaXMub3V0cHV0Qml0cz10W3RoaXMuY29kaW5nUG9zXS10W3RoaXMuY29kaW5nUG9zLTFdfX1lbHNle2k9ODtvPTA7ZG97aWYoIm51bWJlciIhPXR5cGVvZiB0aGlzLm91dHB1dEJpdHMpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCdJbnZhbGlkIC9DQ0lUVEZheERlY29kZSBkYXRhLCAib3V0cHV0Qml0cyIgbXVzdCBiZSBhIG51bWJlci4nKTtpZih0aGlzLm91dHB1dEJpdHM+aSl7bzw8PWk7MSZ0aGlzLmNvZGluZ1Bvc3x8KG98PTI1NT4+OC1pKTt0aGlzLm91dHB1dEJpdHMtPWk7aT0wfWVsc2V7bzw8PXRoaXMub3V0cHV0Qml0czsxJnRoaXMuY29kaW5nUG9zfHwob3w9MjU1Pj44LXRoaXMub3V0cHV0Qml0cyk7aS09dGhpcy5vdXRwdXRCaXRzO3RoaXMub3V0cHV0Qml0cz0wO2lmKHRbdGhpcy5jb2RpbmdQb3NdPHIpe3RoaXMuY29kaW5nUG9zKys7dGhpcy5vdXRwdXRCaXRzPXRbdGhpcy5jb2RpbmdQb3NdLXRbdGhpcy5jb2RpbmdQb3MtMV19ZWxzZSBpZihpPjApe288PD1pO2k9MH19fXdoaWxlKGkpfXRoaXMuYmxhY2smJihvXj0yNTUpO3JldHVybiBvfV9hZGRQaXhlbHMoZSx0KXtjb25zdCByPXRoaXMuY29kaW5nTGluZTtsZXQgYT10aGlzLmNvZGluZ1BvcztpZihlPnJbYV0pe2lmKGU+dGhpcy5jb2x1bW5zKXtpbmZvKCJyb3cgaXMgd3JvbmcgbGVuZ3RoIik7dGhpcy5lcnI9ITA7ZT10aGlzLmNvbHVtbnN9MSZhXnQmJisrYTtyW2FdPWV9dGhpcy5jb2RpbmdQb3M9YX1fYWRkUGl4ZWxzTmVnKGUsdCl7Y29uc3Qgcj10aGlzLmNvZGluZ0xpbmU7bGV0IGE9dGhpcy5jb2RpbmdQb3M7aWYoZT5yW2FdKXtpZihlPnRoaXMuY29sdW1ucyl7aW5mbygicm93IGlzIHdyb25nIGxlbmd0aCIpO3RoaXMuZXJyPSEwO2U9dGhpcy5jb2x1bW5zfTEmYV50JiYrK2E7clthXT1lfWVsc2UgaWYoZTxyW2FdKXtpZihlPDApe2luZm8oImludmFsaWQgY29kZSIpO3RoaXMuZXJyPSEwO2U9MH1mb3IoO2E+MCYmZTxyW2EtMV07KS0tYTtyW2FdPWV9dGhpcy5jb2RpbmdQb3M9YX1fZmluZFRhYmxlQ29kZShlLHQscixhKXtjb25zdCBuPWF8fDA7Zm9yKGxldCBhPWU7YTw9dDsrK2Epe2xldCBlPXRoaXMuX2xvb2tCaXRzKGEpO2lmKGU9PT1McilyZXR1cm5bITAsMSwhMV07YTx0JiYoZTw8PXQtYSk7aWYoIW58fGU+PW4pe2NvbnN0IHQ9cltlLW5dO2lmKHRbMF09PT1hKXt0aGlzLl9lYXRCaXRzKGEpO3JldHVyblshMCx0WzFdLCEwXX19fXJldHVyblshMSwwLCExXX1fZ2V0VHdvRGltQ29kZSgpe2xldCBlLHQ9MDtpZih0aGlzLmVvYmxvY2spe3Q9dGhpcy5fbG9va0JpdHMoNyk7ZT1qclt0XTtpZihlPy5bMF0+MCl7dGhpcy5fZWF0Qml0cyhlWzBdKTtyZXR1cm4gZVsxXX19ZWxzZXtjb25zdCBlPXRoaXMuX2ZpbmRUYWJsZUNvZGUoMSw3LGpyKTtpZihlWzBdJiZlWzJdKXJldHVybiBlWzFdfWluZm8oIkJhZCB0d28gZGltIGNvZGUiKTtyZXR1cm4gTHJ9X2dldFdoaXRlQ29kZSgpe2xldCBlLHQ9MDtpZih0aGlzLmVvYmxvY2spe3Q9dGhpcy5fbG9va0JpdHMoMTIpO2lmKHQ9PT1McilyZXR1cm4gMTtlPXQ+PjU/cXJbdD4+M106VXJbdF07aWYoZVswXT4wKXt0aGlzLl9lYXRCaXRzKGVbMF0pO3JldHVybiBlWzFdfX1lbHNle2xldCBlPXRoaXMuX2ZpbmRUYWJsZUNvZGUoMSw5LHFyKTtpZihlWzBdKXJldHVybiBlWzFdO2U9dGhpcy5fZmluZFRhYmxlQ29kZSgxMSwxMixVcik7aWYoZVswXSlyZXR1cm4gZVsxXX1pbmZvKCJiYWQgd2hpdGUgY29kZSIpO3RoaXMuX2VhdEJpdHMoMSk7cmV0dXJuIDF9X2dldEJsYWNrQ29kZSgpe2xldCBlLHQ7aWYodGhpcy5lb2Jsb2NrKXtlPXRoaXMuX2xvb2tCaXRzKDEzKTtpZihlPT09THIpcmV0dXJuIDE7dD1lPj43PyEoZT4+OSkmJmU+Pjc/SHJbKGU+PjEpLTY0XTpXcltlPj43XTpYcltlXTtpZih0WzBdPjApe3RoaXMuX2VhdEJpdHModFswXSk7cmV0dXJuIHRbMV19fWVsc2V7bGV0IGU9dGhpcy5fZmluZFRhYmxlQ29kZSgyLDYsV3IpO2lmKGVbMF0pcmV0dXJuIGVbMV07ZT10aGlzLl9maW5kVGFibGVDb2RlKDcsMTIsSHIsNjQpO2lmKGVbMF0pcmV0dXJuIGVbMV07ZT10aGlzLl9maW5kVGFibGVDb2RlKDEwLDEzLFhyKTtpZihlWzBdKXJldHVybiBlWzFdfWluZm8oImJhZCBibGFjayBjb2RlIik7dGhpcy5fZWF0Qml0cygxKTtyZXR1cm4gMX1fbG9va0JpdHMoZSl7bGV0IHQ7Zm9yKDt0aGlzLmlucHV0Qml0czxlOyl7aWYoLTE9PT0odD10aGlzLnNvdXJjZS5uZXh0KCkpKXJldHVybiAwPT09dGhpcy5pbnB1dEJpdHM/THI6dGhpcy5pbnB1dEJ1Zjw8ZS10aGlzLmlucHV0Qml0cyY2NTUzNT4+MTYtZTt0aGlzLmlucHV0QnVmPXRoaXMuaW5wdXRCdWY8PDh8dDt0aGlzLmlucHV0Qml0cys9OH1yZXR1cm4gdGhpcy5pbnB1dEJ1Zj4+dGhpcy5pbnB1dEJpdHMtZSY2NTUzNT4+MTYtZX1fZWF0Qml0cyhlKXsodGhpcy5pbnB1dEJpdHMtPWUpPDAmJih0aGlzLmlucHV0Qml0cz0wKX19Y2xhc3MgQ0NJVFRGYXhTdHJlYW0gZXh0ZW5kcyBEZWNvZGVTdHJlYW17Y29uc3RydWN0b3IoZSx0LHIpe3N1cGVyKHQpO3RoaXMuc3RyPWU7dGhpcy5kaWN0PWUuZGljdDtyIGluc3RhbmNlb2YgRGljdHx8KHI9RGljdC5lbXB0eSk7Y29uc3QgYT17bmV4dDooKT0+ZS5nZXRCeXRlKCl9O3RoaXMuY2NpdHRGYXhEZWNvZGVyPW5ldyBDQ0lUVEZheERlY29kZXIoYSx7SzpyLmdldCgiSyIpLEVuZE9mTGluZTpyLmdldCgiRW5kT2ZMaW5lIiksRW5jb2RlZEJ5dGVBbGlnbjpyLmdldCgiRW5jb2RlZEJ5dGVBbGlnbiIpLENvbHVtbnM6ci5nZXQoIkNvbHVtbnMiKSxSb3dzOnIuZ2V0KCJSb3dzIiksRW5kT2ZCbG9jazpyLmdldCgiRW5kT2ZCbG9jayIpLEJsYWNrSXMxOnIuZ2V0KCJCbGFja0lzMSIpfSl9cmVhZEJsb2NrKCl7Zm9yKDshdGhpcy5lb2Y7KXtjb25zdCBlPXRoaXMuY2NpdHRGYXhEZWNvZGVyLnJlYWROZXh0Q2hhcigpO2lmKC0xPT09ZSl7dGhpcy5lb2Y9ITA7cmV0dXJufXRoaXMuZW5zdXJlQnVmZmVyKHRoaXMuYnVmZmVyTGVuZ3RoKzEpO3RoaXMuYnVmZmVyW3RoaXMuYnVmZmVyTGVuZ3RoKytdPWV9fX1jb25zdCB6cj1uZXcgSW50MzJBcnJheShbMTYsMTcsMTgsMCw4LDcsOSw2LDEwLDUsMTEsNCwxMiwzLDEzLDIsMTQsMSwxNV0pLEdyPW5ldyBJbnQzMkFycmF5KFszLDQsNSw2LDcsOCw5LDEwLDY1NTQ3LDY1NTQ5LDY1NTUxLDY1NTUzLDEzMTA5MSwxMzEwOTUsMTMxMDk5LDEzMTEwMywxOTY2NDMsMTk2NjUxLDE5NjY1OSwxOTY2NjcsMjYyMjExLDI2MjIyNywyNjIyNDMsMjYyMjU5LDMyNzgxMSwzMjc4NDMsMzI3ODc1LDMyNzkwNywyNTgsMjU4LDI1OF0pLCRyPW5ldyBJbnQzMkFycmF5KFsxLDIsMyw0LDY1NTQxLDY1NTQzLDEzMTA4MSwxMzEwODUsMTk2NjI1LDE5NjYzMywyNjIxNzcsMjYyMTkzLDMyNzc0NSwzMjc3NzcsMzkzMzQ1LDM5MzQwOSw0NTkwMDksNDU5MTM3LDUyNDgwMSw1MjUwNTcsNTkwODQ5LDU5MTM2MSw2NTc0MDksNjU4NDMzLDcyNDk5Myw3MjcwNDEsNzk0NjI1LDc5ODcyMSw4NjgzNTMsODc2NTQ1XSksVnI9W25ldyBJbnQzMkFycmF5KFs0NTkwMDgsNTI0MzY4LDUyNDMwNCw1MjQ1NjgsNDU5MDI0LDUyNDQwMCw1MjQzMzYsNTkwMDE2LDQ1OTAxNiw1MjQzODQsNTI0MzIwLDU4OTk4NCw1MjQyODgsNTI0NDE2LDUyNDM1Miw1OTAwNDgsNDU5MDEyLDUyNDM3Niw1MjQzMTIsNTg5OTY4LDQ1OTAyOCw1MjQ0MDgsNTI0MzQ0LDU5MDAzMiw0NTkwMjAsNTI0MzkyLDUyNDMyOCw1OWU0LDUyNDI5Niw1MjQ0MjQsNTI0MzYwLDU5MDA2NCw0NTkwMTAsNTI0MzcyLDUyNDMwOCw1MjQ1NzIsNDU5MDI2LDUyNDQwNCw1MjQzNDAsNTkwMDI0LDQ1OTAxOCw1MjQzODgsNTI0MzI0LDU4OTk5Miw1MjQyOTIsNTI0NDIwLDUyNDM1Niw1OTAwNTYsNDU5MDE0LDUyNDM4MCw1MjQzMTYsNTg5OTc2LDQ1OTAzMCw1MjQ0MTIsNTI0MzQ4LDU5MDA0MCw0NTkwMjIsNTI0Mzk2LDUyNDMzMiw1OTAwMDgsNTI0MzAwLDUyNDQyOCw1MjQzNjQsNTkwMDcyLDQ1OTAwOSw1MjQzNzAsNTI0MzA2LDUyNDU3MCw0NTkwMjUsNTI0NDAyLDUyNDMzOCw1OTAwMjAsNDU5MDE3LDUyNDM4Niw1MjQzMjIsNTg5OTg4LDUyNDI5MCw1MjQ0MTgsNTI0MzU0LDU5MDA1Miw0NTkwMTMsNTI0Mzc4LDUyNDMxNCw1ODk5NzIsNDU5MDI5LDUyNDQxMCw1MjQzNDYsNTkwMDM2LDQ1OTAyMSw1MjQzOTQsNTI0MzMwLDU5MDAwNCw1MjQyOTgsNTI0NDI2LDUyNDM2Miw1OTAwNjgsNDU5MDExLDUyNDM3NCw1MjQzMTAsNTI0NTc0LDQ1OTAyNyw1MjQ0MDYsNTI0MzQyLDU5MDAyOCw0NTkwMTksNTI0MzkwLDUyNDMyNiw1ODk5OTYsNTI0Mjk0LDUyNDQyMiw1MjQzNTgsNTkwMDYwLDQ1OTAxNSw1MjQzODIsNTI0MzE4LDU4OTk4MCw0NTkwMzEsNTI0NDE0LDUyNDM1MCw1OTAwNDQsNDU5MDIzLDUyNDM5OCw1MjQzMzQsNTkwMDEyLDUyNDMwMiw1MjQ0MzAsNTI0MzY2LDU5MDA3Niw0NTkwMDgsNTI0MzY5LDUyNDMwNSw1MjQ1NjksNDU5MDI0LDUyNDQwMSw1MjQzMzcsNTkwMDE4LDQ1OTAxNiw1MjQzODUsNTI0MzIxLDU4OTk4Niw1MjQyODksNTI0NDE3LDUyNDM1Myw1OTAwNTAsNDU5MDEyLDUyNDM3Nyw1MjQzMTMsNTg5OTcwLDQ1OTAyOCw1MjQ0MDksNTI0MzQ1LDU5MDAzNCw0NTkwMjAsNTI0MzkzLDUyNDMyOSw1OTAwMDIsNTI0Mjk3LDUyNDQyNSw1MjQzNjEsNTkwMDY2LDQ1OTAxMCw1MjQzNzMsNTI0MzA5LDUyNDU3Myw0NTkwMjYsNTI0NDA1LDUyNDM0MSw1OTAwMjYsNDU5MDE4LDUyNDM4OSw1MjQzMjUsNTg5OTk0LDUyNDI5Myw1MjQ0MjEsNTI0MzU3LDU5MDA1OCw0NTkwMTQsNTI0MzgxLDUyNDMxNyw1ODk5NzgsNDU5MDMwLDUyNDQxMyw1MjQzNDksNTkwMDQyLDQ1OTAyMiw1MjQzOTcsNTI0MzMzLDU5MDAxMCw1MjQzMDEsNTI0NDI5LDUyNDM2NSw1OTAwNzQsNDU5MDA5LDUyNDM3MSw1MjQzMDcsNTI0NTcxLDQ1OTAyNSw1MjQ0MDMsNTI0MzM5LDU5MDAyMiw0NTkwMTcsNTI0Mzg3LDUyNDMyMyw1ODk5OTAsNTI0MjkxLDUyNDQxOSw1MjQzNTUsNTkwMDU0LDQ1OTAxMyw1MjQzNzksNTI0MzE1LDU4OTk3NCw0NTkwMjksNTI0NDExLDUyNDM0Nyw1OTAwMzgsNDU5MDIxLDUyNDM5NSw1MjQzMzEsNTkwMDA2LDUyNDI5OSw1MjQ0MjcsNTI0MzYzLDU5MDA3MCw0NTkwMTEsNTI0Mzc1LDUyNDMxMSw1MjQ1NzUsNDU5MDI3LDUyNDQwNyw1MjQzNDMsNTkwMDMwLDQ1OTAxOSw1MjQzOTEsNTI0MzI3LDU4OTk5OCw1MjQyOTUsNTI0NDIzLDUyNDM1OSw1OTAwNjIsNDU5MDE1LDUyNDM4Myw1MjQzMTksNTg5OTgyLDQ1OTAzMSw1MjQ0MTUsNTI0MzUxLDU5MDA0Niw0NTkwMjMsNTI0Mzk5LDUyNDMzNSw1OTAwMTQsNTI0MzAzLDUyNDQzMSw1MjQzNjcsNTkwMDc4LDQ1OTAwOCw1MjQzNjgsNTI0MzA0LDUyNDU2OCw0NTkwMjQsNTI0NDAwLDUyNDMzNiw1OTAwMTcsNDU5MDE2LDUyNDM4NCw1MjQzMjAsNTg5OTg1LDUyNDI4OCw1MjQ0MTYsNTI0MzUyLDU5MDA0OSw0NTkwMTIsNTI0Mzc2LDUyNDMxMiw1ODk5NjksNDU5MDI4LDUyNDQwOCw1MjQzNDQsNTkwMDMzLDQ1OTAyMCw1MjQzOTIsNTI0MzI4LDU5MDAwMSw1MjQyOTYsNTI0NDI0LDUyNDM2MCw1OTAwNjUsNDU5MDEwLDUyNDM3Miw1MjQzMDgsNTI0NTcyLDQ1OTAyNiw1MjQ0MDQsNTI0MzQwLDU5MDAyNSw0NTkwMTgsNTI0Mzg4LDUyNDMyNCw1ODk5OTMsNTI0MjkyLDUyNDQyMCw1MjQzNTYsNTkwMDU3LDQ1OTAxNCw1MjQzODAsNTI0MzE2LDU4OTk3Nyw0NTkwMzAsNTI0NDEyLDUyNDM0OCw1OTAwNDEsNDU5MDIyLDUyNDM5Niw1MjQzMzIsNTkwMDA5LDUyNDMwMCw1MjQ0MjgsNTI0MzY0LDU5MDA3Myw0NTkwMDksNTI0MzcwLDUyNDMwNiw1MjQ1NzAsNDU5MDI1LDUyNDQwMiw1MjQzMzgsNTkwMDIxLDQ1OTAxNyw1MjQzODYsNTI0MzIyLDU4OTk4OSw1MjQyOTAsNTI0NDE4LDUyNDM1NCw1OTAwNTMsNDU5MDEzLDUyNDM3OCw1MjQzMTQsNTg5OTczLDQ1OTAyOSw1MjQ0MTAsNTI0MzQ2LDU5MDAzNyw0NTkwMjEsNTI0Mzk0LDUyNDMzMCw1OTAwMDUsNTI0Mjk4LDUyNDQyNiw1MjQzNjIsNTkwMDY5LDQ1OTAxMSw1MjQzNzQsNTI0MzEwLDUyNDU3NCw0NTkwMjcsNTI0NDA2LDUyNDM0Miw1OTAwMjksNDU5MDE5LDUyNDM5MCw1MjQzMjYsNTg5OTk3LDUyNDI5NCw1MjQ0MjIsNTI0MzU4LDU5MDA2MSw0NTkwMTUsNTI0MzgyLDUyNDMxOCw1ODk5ODEsNDU5MDMxLDUyNDQxNCw1MjQzNTAsNTkwMDQ1LDQ1OTAyMyw1MjQzOTgsNTI0MzM0LDU5MDAxMyw1MjQzMDIsNTI0NDMwLDUyNDM2Niw1OTAwNzcsNDU5MDA4LDUyNDM2OSw1MjQzMDUsNTI0NTY5LDQ1OTAyNCw1MjQ0MDEsNTI0MzM3LDU5MDAxOSw0NTkwMTYsNTI0Mzg1LDUyNDMyMSw1ODk5ODcsNTI0Mjg5LDUyNDQxNyw1MjQzNTMsNTkwMDUxLDQ1OTAxMiw1MjQzNzcsNTI0MzEzLDU4OTk3MSw0NTkwMjgsNTI0NDA5LDUyNDM0NSw1OTAwMzUsNDU5MDIwLDUyNDM5Myw1MjQzMjksNTkwMDAzLDUyNDI5Nyw1MjQ0MjUsNTI0MzYxLDU5MDA2Nyw0NTkwMTAsNTI0MzczLDUyNDMwOSw1MjQ1NzMsNDU5MDI2LDUyNDQwNSw1MjQzNDEsNTkwMDI3LDQ1OTAxOCw1MjQzODksNTI0MzI1LDU4OTk5NSw1MjQyOTMsNTI0NDIxLDUyNDM1Nyw1OTAwNTksNDU5MDE0LDUyNDM4MSw1MjQzMTcsNTg5OTc5LDQ1OTAzMCw1MjQ0MTMsNTI0MzQ5LDU5MDA0Myw0NTkwMjIsNTI0Mzk3LDUyNDMzMyw1OTAwMTEsNTI0MzAxLDUyNDQyOSw1MjQzNjUsNTkwMDc1LDQ1OTAwOSw1MjQzNzEsNTI0MzA3LDUyNDU3MSw0NTkwMjUsNTI0NDAzLDUyNDMzOSw1OTAwMjMsNDU5MDE3LDUyNDM4Nyw1MjQzMjMsNTg5OTkxLDUyNDI5MSw1MjQ0MTksNTI0MzU1LDU5MDA1NSw0NTkwMTMsNTI0Mzc5LDUyNDMxNSw1ODk5NzUsNDU5MDI5LDUyNDQxMSw1MjQzNDcsNTkwMDM5LDQ1OTAyMSw1MjQzOTUsNTI0MzMxLDU5MDAwNyw1MjQyOTksNTI0NDI3LDUyNDM2Myw1OTAwNzEsNDU5MDExLDUyNDM3NSw1MjQzMTEsNTI0NTc1LDQ1OTAyNyw1MjQ0MDcsNTI0MzQzLDU5MDAzMSw0NTkwMTksNTI0MzkxLDUyNDMyNyw1ODk5OTksNTI0Mjk1LDUyNDQyMyw1MjQzNTksNTkwMDYzLDQ1OTAxNSw1MjQzODMsNTI0MzE5LDU4OTk4Myw0NTkwMzEsNTI0NDE1LDUyNDM1MSw1OTAwNDcsNDU5MDIzLDUyNDM5OSw1MjQzMzUsNTkwMDE1LDUyNDMwMyw1MjQ0MzEsNTI0MzY3LDU5MDA3OV0pLDldLEtyPVtuZXcgSW50MzJBcnJheShbMzI3NjgwLDMyNzY5NiwzMjc2ODgsMzI3NzA0LDMyNzY4NCwzMjc3MDAsMzI3NjkyLDMyNzcwOCwzMjc2ODIsMzI3Njk4LDMyNzY5MCwzMjc3MDYsMzI3Njg2LDMyNzcwMiwzMjc2OTQsMCwzMjc2ODEsMzI3Njk3LDMyNzY4OSwzMjc3MDUsMzI3Njg1LDMyNzcwMSwzMjc2OTMsMzI3NzA5LDMyNzY4MywzMjc2OTksMzI3NjkxLDMyNzcwNywzMjc2ODcsMzI3NzAzLDMyNzY5NSwwXSksNV07Y2xhc3MgRmxhdGVTdHJlYW0gZXh0ZW5kcyBEZWNvZGVTdHJlYW17Y29uc3RydWN0b3IoZSx0KXtzdXBlcih0KTt0aGlzLnN0cj1lO3RoaXMuZGljdD1lLmRpY3Q7Y29uc3Qgcj1lLmdldEJ5dGUoKSxhPWUuZ2V0Qnl0ZSgpO2lmKC0xPT09cnx8LTE9PT1hKXRocm93IG5ldyBGb3JtYXRFcnJvcihgSW52YWxpZCBoZWFkZXIgaW4gZmxhdGUgc3RyZWFtOiAke3J9LCAke2F9YCk7aWYoOCE9KDE1JnIpKXRocm93IG5ldyBGb3JtYXRFcnJvcihgVW5rbm93biBjb21wcmVzc2lvbiBtZXRob2QgaW4gZmxhdGUgc3RyZWFtOiAke3J9LCAke2F9YCk7aWYoKChyPDw4KSthKSUzMSE9MCl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYEJhZCBGQ0hFQ0sgaW4gZmxhdGUgc3RyZWFtOiAke3J9LCAke2F9YCk7aWYoMzImYSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYEZESUNUIGJpdCBzZXQgaW4gZmxhdGUgc3RyZWFtOiAke3J9LCAke2F9YCk7dGhpcy5jb2RlU2l6ZT0wO3RoaXMuY29kZUJ1Zj0wfWFzeW5jIGdldEltYWdlRGF0YShlLHQpe2NvbnN0IHI9YXdhaXQgdGhpcy5hc3luY0dldEJ5dGVzKCk7cmV0dXJuIHI/ci5sZW5ndGg8PWU/cjpyLnN1YmFycmF5KDAsZSk6dGhpcy5nZXRCeXRlcyhlKX1hc3luYyBhc3luY0dldEJ5dGVzKCl7dGhpcy5zdHIucmVzZXQoKTtjb25zdCBlPXRoaXMuc3RyLmdldEJ5dGVzKCk7dHJ5e2NvbnN0e3JlYWRhYmxlOnQsd3JpdGFibGU6cn09bmV3IERlY29tcHJlc3Npb25TdHJlYW0oImRlZmxhdGUiKSxhPXIuZ2V0V3JpdGVyKCk7YXdhaXQgYS5yZWFkeTthLndyaXRlKGUpLnRoZW4oYXN5bmMoKT0+e2F3YWl0IGEucmVhZHk7YXdhaXQgYS5jbG9zZSgpfSkuY2F0Y2goKCk9Pnt9KTtjb25zdCBuPVtdO2xldCBpPTA7Zm9yIGF3YWl0KGNvbnN0IGUgb2YgdCl7bi5wdXNoKGUpO2krPWUuYnl0ZUxlbmd0aH1jb25zdCBzPW5ldyBVaW50OEFycmF5KGkpO2xldCBvPTA7Zm9yKGNvbnN0IGUgb2Ygbil7cy5zZXQoZSxvKTtvKz1lLmJ5dGVMZW5ndGh9cmV0dXJuIHN9Y2F0Y2h7dGhpcy5zdHI9bmV3IFN0cmVhbShlLDIsZS5sZW5ndGgsdGhpcy5zdHIuZGljdCk7dGhpcy5yZXNldCgpO3JldHVybiBudWxsfX1nZXQgaXNBc3luYygpe3JldHVybiEwfWdldEJpdHMoZSl7Y29uc3QgdD10aGlzLnN0cjtsZXQgcixhPXRoaXMuY29kZVNpemUsbj10aGlzLmNvZGVCdWY7Zm9yKDthPGU7KXtpZigtMT09PShyPXQuZ2V0Qnl0ZSgpKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkJhZCBlbmNvZGluZyBpbiBmbGF0ZSBzdHJlYW0iKTtufD1yPDxhO2ErPTh9cj1uJigxPDxlKS0xO3RoaXMuY29kZUJ1Zj1uPj5lO3RoaXMuY29kZVNpemU9YS09ZTtyZXR1cm4gcn1nZXRDb2RlKGUpe2NvbnN0IHQ9dGhpcy5zdHIscj1lWzBdLGE9ZVsxXTtsZXQgbixpPXRoaXMuY29kZVNpemUscz10aGlzLmNvZGVCdWY7Zm9yKDtpPGEmJi0xIT09KG49dC5nZXRCeXRlKCkpOyl7c3w9bjw8aTtpKz04fWNvbnN0IG89cltzJigxPDxhKS0xXSxjPW8+PjE2LGw9NjU1MzUmbztpZihjPDF8fGk8Yyl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkJhZCBlbmNvZGluZyBpbiBmbGF0ZSBzdHJlYW0iKTt0aGlzLmNvZGVCdWY9cz4+Yzt0aGlzLmNvZGVTaXplPWktYztyZXR1cm4gbH1nZW5lcmF0ZUh1ZmZtYW5UYWJsZShlKXtjb25zdCB0PWUubGVuZ3RoO2xldCByLGE9MDtmb3Iocj0wO3I8dDsrK3IpZVtyXT5hJiYoYT1lW3JdKTtjb25zdCBuPTE8PGEsaT1uZXcgSW50MzJBcnJheShuKTtmb3IobGV0IHM9MSxvPTAsYz0yO3M8PWE7KytzLG88PD0xLGM8PD0xKWZvcihsZXQgYT0wO2E8dDsrK2EpaWYoZVthXT09PXMpe2xldCBlPTAsdD1vO2ZvcihyPTA7cjxzOysrcil7ZT1lPDwxfDEmdDt0Pj49MX1mb3Iocj1lO3I8bjtyKz1jKWlbcl09czw8MTZ8YTsrK299cmV0dXJuW2ksYV19I3EoZSl7aW5mbyhlKTt0aGlzLmVvZj0hMH1yZWFkQmxvY2soKXtsZXQgZSx0LHI7Y29uc3QgYT10aGlzLnN0cjt0cnl7dD10aGlzLmdldEJpdHMoMyl9Y2F0Y2goZSl7dGhpcy4jcShlLm1lc3NhZ2UpO3JldHVybn0xJnQmJih0aGlzLmVvZj0hMCk7dD4+PTE7aWYoMD09PXQpe2xldCB0O2lmKC0xPT09KHQ9YS5nZXRCeXRlKCkpKXt0aGlzLiNxKCJCYWQgYmxvY2sgaGVhZGVyIGluIGZsYXRlIHN0cmVhbSIpO3JldHVybn1sZXQgcj10O2lmKC0xPT09KHQ9YS5nZXRCeXRlKCkpKXt0aGlzLiNxKCJCYWQgYmxvY2sgaGVhZGVyIGluIGZsYXRlIHN0cmVhbSIpO3JldHVybn1yfD10PDw4O2lmKC0xPT09KHQ9YS5nZXRCeXRlKCkpKXt0aGlzLiNxKCJCYWQgYmxvY2sgaGVhZGVyIGluIGZsYXRlIHN0cmVhbSIpO3JldHVybn1sZXQgbj10O2lmKC0xPT09KHQ9YS5nZXRCeXRlKCkpKXt0aGlzLiNxKCJCYWQgYmxvY2sgaGVhZGVyIGluIGZsYXRlIHN0cmVhbSIpO3JldHVybn1ufD10PDw4O2lmKG4hPT0oNjU1MzUmfnIpJiYoMCE9PXJ8fDAhPT1uKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkJhZCB1bmNvbXByZXNzZWQgYmxvY2sgbGVuZ3RoIGluIGZsYXRlIHN0cmVhbSIpO3RoaXMuY29kZUJ1Zj0wO3RoaXMuY29kZVNpemU9MDtjb25zdCBpPXRoaXMuYnVmZmVyTGVuZ3RoLHM9aStyO2U9dGhpcy5lbnN1cmVCdWZmZXIocyk7dGhpcy5idWZmZXJMZW5ndGg9cztpZigwPT09ciktMT09PWEucGVla0J5dGUoKSYmKHRoaXMuZW9mPSEwKTtlbHNle2NvbnN0IHQ9YS5nZXRCeXRlcyhyKTtlLnNldCh0LGkpO3QubGVuZ3RoPHImJih0aGlzLmVvZj0hMCl9cmV0dXJufWxldCBuLGk7aWYoMT09PXQpe249VnI7aT1Lcn1lbHNle2lmKDIhPT10KXRocm93IG5ldyBGb3JtYXRFcnJvcigiVW5rbm93biBibG9jayB0eXBlIGluIGZsYXRlIHN0cmVhbSIpO3tjb25zdCBlPXRoaXMuZ2V0Qml0cyg1KSsyNTcsdD10aGlzLmdldEJpdHMoNSkrMSxhPXRoaXMuZ2V0Qml0cyg0KSs0LHM9bmV3IFVpbnQ4QXJyYXkoenIubGVuZ3RoKTtsZXQgbztmb3Iobz0wO288YTsrK28pc1t6cltvXV09dGhpcy5nZXRCaXRzKDMpO2NvbnN0IGM9dGhpcy5nZW5lcmF0ZUh1ZmZtYW5UYWJsZShzKTtyPTA7bz0wO2NvbnN0IGw9ZSt0LGg9bmV3IFVpbnQ4QXJyYXkobCk7bGV0IHUsZCxmO2Zvcig7bzxsOyl7Y29uc3QgZT10aGlzLmdldENvZGUoYyk7aWYoMTY9PT1lKXt1PTI7ZD0zO2Y9cn1lbHNlIGlmKDE3PT09ZSl7dT0zO2Q9MztmPXI9MH1lbHNle2lmKDE4IT09ZSl7aFtvKytdPXI9ZTtjb250aW51ZX11PTc7ZD0xMTtmPXI9MH1sZXQgdD10aGlzLmdldEJpdHModSkrZDtmb3IoO3QtLSA+MDspaFtvKytdPWZ9bj10aGlzLmdlbmVyYXRlSHVmZm1hblRhYmxlKGguc3ViYXJyYXkoMCxlKSk7aT10aGlzLmdlbmVyYXRlSHVmZm1hblRhYmxlKGguc3ViYXJyYXkoZSxsKSl9fWU9dGhpcy5idWZmZXI7bGV0IHM9ZT9lLmxlbmd0aDowLG89dGhpcy5idWZmZXJMZW5ndGg7Zm9yKDs7KXtsZXQgdD10aGlzLmdldENvZGUobik7aWYodDwyNTYpe2lmKG8rMT49cyl7ZT10aGlzLmVuc3VyZUJ1ZmZlcihvKzEpO3M9ZS5sZW5ndGh9ZVtvKytdPXQ7Y29udGludWV9aWYoMjU2PT09dCl7dGhpcy5idWZmZXJMZW5ndGg9bztyZXR1cm59dC09MjU3O3Q9R3JbdF07bGV0IGE9dD4+MTY7YT4wJiYoYT10aGlzLmdldEJpdHMoYSkpO3I9KDY1NTM1JnQpK2E7dD10aGlzLmdldENvZGUoaSk7dD0kclt0XTthPXQ+PjE2O2E+MCYmKGE9dGhpcy5nZXRCaXRzKGEpKTtjb25zdCBjPSg2NTUzNSZ0KSthO2lmKG8rcj49cyl7ZT10aGlzLmVuc3VyZUJ1ZmZlcihvK3IpO3M9ZS5sZW5ndGh9Zm9yKGxldCB0PTA7dDxyOysrdCwrK28pZVtvXT1lW28tY119fX1jb25zdCBKcj1be3FlOjIyMDE3LG5tcHM6MSxubHBzOjEsc3dpdGNoRmxhZzoxfSx7cWU6MTMzMTMsbm1wczoyLG5scHM6Nixzd2l0Y2hGbGFnOjB9LHtxZTo2MTQ1LG5tcHM6MyxubHBzOjksc3dpdGNoRmxhZzowfSx7cWU6Mjc1MyxubXBzOjQsbmxwczoxMixzd2l0Y2hGbGFnOjB9LHtxZToxMzEzLG5tcHM6NSxubHBzOjI5LHN3aXRjaEZsYWc6MH0se3FlOjU0NSxubXBzOjM4LG5scHM6MzMsc3dpdGNoRmxhZzowfSx7cWU6MjIwMTcsbm1wczo3LG5scHM6Nixzd2l0Y2hGbGFnOjF9LHtxZToyMTUwNSxubXBzOjgsbmxwczoxNCxzd2l0Y2hGbGFnOjB9LHtxZToxODQzMyxubXBzOjksbmxwczoxNCxzd2l0Y2hGbGFnOjB9LHtxZToxNDMzNyxubXBzOjEwLG5scHM6MTQsc3dpdGNoRmxhZzowfSx7cWU6MTIyODksbm1wczoxMSxubHBzOjE3LHN3aXRjaEZsYWc6MH0se3FlOjkyMTcsbm1wczoxMixubHBzOjE4LHN3aXRjaEZsYWc6MH0se3FlOjcxNjksbm1wczoxMyxubHBzOjIwLHN3aXRjaEZsYWc6MH0se3FlOjU2MzMsbm1wczoyOSxubHBzOjIxLHN3aXRjaEZsYWc6MH0se3FlOjIyMDE3LG5tcHM6MTUsbmxwczoxNCxzd2l0Y2hGbGFnOjF9LHtxZToyMTUwNSxubXBzOjE2LG5scHM6MTQsc3dpdGNoRmxhZzowfSx7cWU6MjA3Mzcsbm1wczoxNyxubHBzOjE1LHN3aXRjaEZsYWc6MH0se3FlOjE4NDMzLG5tcHM6MTgsbmxwczoxNixzd2l0Y2hGbGFnOjB9LHtxZToxNDMzNyxubXBzOjE5LG5scHM6MTcsc3dpdGNoRmxhZzowfSx7cWU6MTMzMTMsbm1wczoyMCxubHBzOjE4LHN3aXRjaEZsYWc6MH0se3FlOjEyMjg5LG5tcHM6MjEsbmxwczoxOSxzd2l0Y2hGbGFnOjB9LHtxZToxMDI0MSxubXBzOjIyLG5scHM6MTksc3dpdGNoRmxhZzowfSx7cWU6OTIxNyxubXBzOjIzLG5scHM6MjAsc3dpdGNoRmxhZzowfSx7cWU6ODcwNSxubXBzOjI0LG5scHM6MjEsc3dpdGNoRmxhZzowfSx7cWU6NzE2OSxubXBzOjI1LG5scHM6MjIsc3dpdGNoRmxhZzowfSx7cWU6NjE0NSxubXBzOjI2LG5scHM6MjMsc3dpdGNoRmxhZzowfSx7cWU6NTYzMyxubXBzOjI3LG5scHM6MjQsc3dpdGNoRmxhZzowfSx7cWU6NTEyMSxubXBzOjI4LG5scHM6MjUsc3dpdGNoRmxhZzowfSx7cWU6NDYwOSxubXBzOjI5LG5scHM6MjYsc3dpdGNoRmxhZzowfSx7cWU6NDM1MyxubXBzOjMwLG5scHM6Mjcsc3dpdGNoRmxhZzowfSx7cWU6Mjc1MyxubXBzOjMxLG5scHM6Mjgsc3dpdGNoRmxhZzowfSx7cWU6MjQ5NyxubXBzOjMyLG5scHM6Mjksc3dpdGNoRmxhZzowfSx7cWU6MjIwOSxubXBzOjMzLG5scHM6MzAsc3dpdGNoRmxhZzowfSx7cWU6MTMxMyxubXBzOjM0LG5scHM6MzEsc3dpdGNoRmxhZzowfSx7cWU6MTA4OSxubXBzOjM1LG5scHM6MzIsc3dpdGNoRmxhZzowfSx7cWU6NjczLG5tcHM6MzYsbmxwczozMyxzd2l0Y2hGbGFnOjB9LHtxZTo1NDUsbm1wczozNyxubHBzOjM0LHN3aXRjaEZsYWc6MH0se3FlOjMyMSxubXBzOjM4LG5scHM6MzUsc3dpdGNoRmxhZzowfSx7cWU6MjczLG5tcHM6MzksbmxwczozNixzd2l0Y2hGbGFnOjB9LHtxZToxMzMsbm1wczo0MCxubHBzOjM3LHN3aXRjaEZsYWc6MH0se3FlOjczLG5tcHM6NDEsbmxwczozOCxzd2l0Y2hGbGFnOjB9LHtxZTozNyxubXBzOjQyLG5scHM6Mzksc3dpdGNoRmxhZzowfSx7cWU6MjEsbm1wczo0MyxubHBzOjQwLHN3aXRjaEZsYWc6MH0se3FlOjksbm1wczo0NCxubHBzOjQxLHN3aXRjaEZsYWc6MH0se3FlOjUsbm1wczo0NSxubHBzOjQyLHN3aXRjaEZsYWc6MH0se3FlOjEsbm1wczo0NSxubHBzOjQzLHN3aXRjaEZsYWc6MH0se3FlOjIyMDE3LG5tcHM6NDYsbmxwczo0Nixzd2l0Y2hGbGFnOjB9XTtjbGFzcyBBcml0aG1ldGljRGVjb2Rlcntjb25zdHJ1Y3RvcihlLHQscil7dGhpcy5kYXRhPWU7dGhpcy5icD10O3RoaXMuZGF0YUVuZD1yO3RoaXMuY2hpZ2g9ZVt0XTt0aGlzLmNsb3c9MDt0aGlzLmJ5dGVJbigpO3RoaXMuY2hpZ2g9dGhpcy5jaGlnaDw8NyY2NTUzNXx0aGlzLmNsb3c+PjkmMTI3O3RoaXMuY2xvdz10aGlzLmNsb3c8PDcmNjU1MzU7dGhpcy5jdC09Nzt0aGlzLmE9MzI3Njh9Ynl0ZUluKCl7Y29uc3QgZT10aGlzLmRhdGE7bGV0IHQ9dGhpcy5icDtpZigyNTU9PT1lW3RdKWlmKGVbdCsxXT4xNDMpe3RoaXMuY2xvdys9NjUyODA7dGhpcy5jdD04fWVsc2V7dCsrO3RoaXMuY2xvdys9ZVt0XTw8OTt0aGlzLmN0PTc7dGhpcy5icD10fWVsc2V7dCsrO3RoaXMuY2xvdys9dDx0aGlzLmRhdGFFbmQ/ZVt0XTw8ODo2NTI4MDt0aGlzLmN0PTg7dGhpcy5icD10fWlmKHRoaXMuY2xvdz42NTUzNSl7dGhpcy5jaGlnaCs9dGhpcy5jbG93Pj4xNjt0aGlzLmNsb3cmPTY1NTM1fX1yZWFkQml0KGUsdCl7bGV0IHI9ZVt0XT4+MSxhPTEmZVt0XTtjb25zdCBuPUpyW3JdLGk9bi5xZTtsZXQgcyxvPXRoaXMuYS1pO2lmKHRoaXMuY2hpZ2g8aSlpZihvPGkpe289aTtzPWE7cj1uLm5tcHN9ZWxzZXtvPWk7cz0xXmE7MT09PW4uc3dpdGNoRmxhZyYmKGE9cyk7cj1uLm5scHN9ZWxzZXt0aGlzLmNoaWdoLT1pO2lmKDMyNzY4Jm8pe3RoaXMuYT1vO3JldHVybiBhfWlmKG88aSl7cz0xXmE7MT09PW4uc3dpdGNoRmxhZyYmKGE9cyk7cj1uLm5scHN9ZWxzZXtzPWE7cj1uLm5tcHN9fWRvezA9PT10aGlzLmN0JiZ0aGlzLmJ5dGVJbigpO288PD0xO3RoaXMuY2hpZ2g9dGhpcy5jaGlnaDw8MSY2NTUzNXx0aGlzLmNsb3c+PjE1JjE7dGhpcy5jbG93PXRoaXMuY2xvdzw8MSY2NTUzNTt0aGlzLmN0LS19d2hpbGUoISgzMjc2OCZvKSk7dGhpcy5hPW87ZVt0XT1yPDwxfGE7cmV0dXJuIHN9fWNsYXNzIEpiaWcyRXJyb3IgZXh0ZW5kcyBlcntjb25zdHJ1Y3RvcihlKXtzdXBlcihlLCJKYmlnMkVycm9yIil9fWNsYXNzIENvbnRleHRDYWNoZXtnZXRDb250ZXh0cyhlKXtyZXR1cm4gZSBpbiB0aGlzP3RoaXNbZV06dGhpc1tlXT1uZXcgSW50OEFycmF5KDY1NTM2KX19Y2xhc3MgRGVjb2RpbmdDb250ZXh0e2NvbnN0cnVjdG9yKGUsdCxyKXt0aGlzLmRhdGE9ZTt0aGlzLnN0YXJ0PXQ7dGhpcy5lbmQ9cn1nZXQgZGVjb2Rlcigpe3JldHVybiBzaGFkb3codGhpcywiZGVjb2RlciIsbmV3IEFyaXRobWV0aWNEZWNvZGVyKHRoaXMuZGF0YSx0aGlzLnN0YXJ0LHRoaXMuZW5kKSl9Z2V0IGNvbnRleHRDYWNoZSgpe3JldHVybiBzaGFkb3codGhpcywiY29udGV4dENhY2hlIixuZXcgQ29udGV4dENhY2hlKX19ZnVuY3Rpb24gZGVjb2RlSW50ZWdlcihlLHQscil7Y29uc3QgYT1lLmdldENvbnRleHRzKHQpO2xldCBuPTE7ZnVuY3Rpb24gcmVhZEJpdHMoZSl7bGV0IHQ9MDtmb3IobGV0IGk9MDtpPGU7aSsrKXtjb25zdCBlPXIucmVhZEJpdChhLG4pO249bjwyNTY/bjw8MXxlOjUxMSYobjw8MXxlKXwyNTY7dD10PDwxfGV9cmV0dXJuIHQ+Pj4wfWNvbnN0IGk9cmVhZEJpdHMoMSkscz1yZWFkQml0cygxKT9yZWFkQml0cygxKT9yZWFkQml0cygxKT9yZWFkQml0cygxKT9yZWFkQml0cygxKT9yZWFkQml0cygzMikrNDQzNjpyZWFkQml0cygxMikrMzQwOnJlYWRCaXRzKDgpKzg0OnJlYWRCaXRzKDYpKzIwOnJlYWRCaXRzKDQpKzQ6cmVhZEJpdHMoMik7bGV0IG87MD09PWk/bz1zOnM+MCYmKG89LXMpO3JldHVybiBvPj0tMjE0NzQ4MzY0OCYmbzw9ZHI/bzpudWxsfWZ1bmN0aW9uIGRlY29kZUlBSUQoZSx0LHIpe2NvbnN0IGE9ZS5nZXRDb250ZXh0cygiSUFJRCIpO2xldCBuPTE7Zm9yKGxldCBlPTA7ZTxyO2UrKyl7bj1uPDwxfHQucmVhZEJpdChhLG4pfXJldHVybiByPDMxP24mKDE8PHIpLTE6MjE0NzQ4MzY0NyZufWNvbnN0IFlyPVsiU3ltYm9sRGljdGlvbmFyeSIsbnVsbCxudWxsLG51bGwsIkludGVybWVkaWF0ZVRleHRSZWdpb24iLG51bGwsIkltbWVkaWF0ZVRleHRSZWdpb24iLCJJbW1lZGlhdGVMb3NzbGVzc1RleHRSZWdpb24iLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCwiUGF0dGVybkRpY3Rpb25hcnkiLG51bGwsbnVsbCxudWxsLCJJbnRlcm1lZGlhdGVIYWxmdG9uZVJlZ2lvbiIsbnVsbCwiSW1tZWRpYXRlSGFsZnRvbmVSZWdpb24iLCJJbW1lZGlhdGVMb3NzbGVzc0hhbGZ0b25lUmVnaW9uIixudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCwiSW50ZXJtZWRpYXRlR2VuZXJpY1JlZ2lvbiIsbnVsbCwiSW1tZWRpYXRlR2VuZXJpY1JlZ2lvbiIsIkltbWVkaWF0ZUxvc3NsZXNzR2VuZXJpY1JlZ2lvbiIsIkludGVybWVkaWF0ZUdlbmVyaWNSZWZpbmVtZW50UmVnaW9uIixudWxsLCJJbW1lZGlhdGVHZW5lcmljUmVmaW5lbWVudFJlZ2lvbiIsIkltbWVkaWF0ZUxvc3NsZXNzR2VuZXJpY1JlZmluZW1lbnRSZWdpb24iLG51bGwsbnVsbCxudWxsLG51bGwsIlBhZ2VJbmZvcm1hdGlvbiIsIkVuZE9mUGFnZSIsIkVuZE9mU3RyaXBlIiwiRW5kT2ZGaWxlIiwiUHJvZmlsZXMiLCJUYWJsZXMiLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCwiRXh0ZW5zaW9uIl0sWnI9W1t7eDotMSx5Oi0yfSx7eDowLHk6LTJ9LHt4OjEseTotMn0se3g6LTIseTotMX0se3g6LTEseTotMX0se3g6MCx5Oi0xfSx7eDoxLHk6LTF9LHt4OjIseTotMX0se3g6LTQseTowfSx7eDotMyx5OjB9LHt4Oi0yLHk6MH0se3g6LTEseTowfV0sW3t4Oi0xLHk6LTJ9LHt4OjAseTotMn0se3g6MSx5Oi0yfSx7eDoyLHk6LTJ9LHt4Oi0yLHk6LTF9LHt4Oi0xLHk6LTF9LHt4OjAseTotMX0se3g6MSx5Oi0xfSx7eDoyLHk6LTF9LHt4Oi0zLHk6MH0se3g6LTIseTowfSx7eDotMSx5OjB9XSxbe3g6LTEseTotMn0se3g6MCx5Oi0yfSx7eDoxLHk6LTJ9LHt4Oi0yLHk6LTF9LHt4Oi0xLHk6LTF9LHt4OjAseTotMX0se3g6MSx5Oi0xfSx7eDotMix5OjB9LHt4Oi0xLHk6MH1dLFt7eDotMyx5Oi0xfSx7eDotMix5Oi0xfSx7eDotMSx5Oi0xfSx7eDowLHk6LTF9LHt4OjEseTotMX0se3g6LTQseTowfSx7eDotMyx5OjB9LHt4Oi0yLHk6MH0se3g6LTEseTowfV1dLFFyPVt7Y29kaW5nOlt7eDowLHk6LTF9LHt4OjEseTotMX0se3g6LTEseTowfV0scmVmZXJlbmNlOlt7eDowLHk6LTF9LHt4OjEseTotMX0se3g6LTEseTowfSx7eDowLHk6MH0se3g6MSx5OjB9LHt4Oi0xLHk6MX0se3g6MCx5OjF9LHt4OjEseToxfV19LHtjb2Rpbmc6W3t4Oi0xLHk6LTF9LHt4OjAseTotMX0se3g6MSx5Oi0xfSx7eDotMSx5OjB9XSxyZWZlcmVuY2U6W3t4OjAseTotMX0se3g6LTEseTowfSx7eDowLHk6MH0se3g6MSx5OjB9LHt4OjAseToxfSx7eDoxLHk6MX1dfV0sZWE9WzM5NzE3LDE5NDEsMjI5LDQwNV0sdGE9WzMyLDhdO2Z1bmN0aW9uIGRlY29kZUJpdG1hcChlLHQscixhLG4saSxzLG8pe2lmKGUpe3JldHVybiBkZWNvZGVNTVJCaXRtYXAobmV3IFJlYWRlcihvLmRhdGEsby5zdGFydCxvLmVuZCksdCxyLCExKX1pZigwPT09YSYmIWkmJiFuJiY0PT09cy5sZW5ndGgmJjM9PT1zWzBdLngmJi0xPT09c1swXS55JiYtMz09PXNbMV0ueCYmLTE9PT1zWzFdLnkmJjI9PT1zWzJdLngmJi0yPT09c1syXS55JiYtMj09PXNbM10ueCYmLTI9PT1zWzNdLnkpcmV0dXJuIGZ1bmN0aW9uIGRlY29kZUJpdG1hcFRlbXBsYXRlMChlLHQscil7Y29uc3QgYT1yLmRlY29kZXIsbj1yLmNvbnRleHRDYWNoZS5nZXRDb250ZXh0cygiR0IiKSxpPVtdO2xldCBzLG8sYyxsLGgsdSxkO2ZvcihvPTA7bzx0O28rKyl7aD1pW29dPW5ldyBVaW50OEFycmF5KGUpO3U9bzwxP2g6aVtvLTFdO2Q9bzwyP2g6aVtvLTJdO3M9ZFswXTw8MTN8ZFsxXTw8MTJ8ZFsyXTw8MTF8dVswXTw8N3x1WzFdPDw2fHVbMl08PDV8dVszXTw8NDtmb3IoYz0wO2M8ZTtjKyspe2hbY109bD1hLnJlYWRCaXQobixzKTtzPSgzMTczNSZzKTw8MXwoYyszPGU/ZFtjKzNdPDwxMTowKXwoYys0PGU/dVtjKzRdPDw0OjApfGx9fXJldHVybiBpfSh0LHIsbyk7Y29uc3QgYz0hIWksbD1aclthXS5jb25jYXQocyk7bC5zb3J0KChlLHQpPT5lLnktdC55fHxlLngtdC54KTtjb25zdCBoPWwubGVuZ3RoLHU9bmV3IEludDhBcnJheShoKSxkPW5ldyBJbnQ4QXJyYXkoaCksZj1bXTtsZXQgZyxwLG09MCxiPTAseT0wLHc9MDtmb3IocD0wO3A8aDtwKyspe3VbcF09bFtwXS54O2RbcF09bFtwXS55O2I9TWF0aC5taW4oYixsW3BdLngpO3k9TWF0aC5tYXgoeSxsW3BdLngpO3c9TWF0aC5taW4odyxsW3BdLnkpO3A8aC0xJiZsW3BdLnk9PT1sW3ArMV0ueSYmbFtwXS54PT09bFtwKzFdLngtMT9tfD0xPDxoLTEtcDpmLnB1c2gocCl9Y29uc3QgeD1mLmxlbmd0aCxTPW5ldyBJbnQ4QXJyYXkoeCksaz1uZXcgSW50OEFycmF5KHgpLEM9bmV3IFVpbnQxNkFycmF5KHgpO2ZvcihnPTA7Zzx4O2crKyl7cD1mW2ddO1NbZ109bFtwXS54O2tbZ109bFtwXS55O0NbZ109MTw8aC0xLXB9Y29uc3Qgdj0tYixUPS13LE89dC15LE09ZWFbYV07bGV0IEQ9bmV3IFVpbnQ4QXJyYXkodCk7Y29uc3QgUj1bXSxFPW8uZGVjb2RlcixOPW8uY29udGV4dENhY2hlLmdldENvbnRleHRzKCJHQiIpO2xldCBfLEwsaixVLHEsWD0wLEg9MDtmb3IobGV0IGU9MDtlPHI7ZSsrKXtpZihuKXtYXj1FLnJlYWRCaXQoTixNKTtpZihYKXtSLnB1c2goRCk7Y29udGludWV9fUQ9bmV3IFVpbnQ4QXJyYXkoRCk7Ui5wdXNoKEQpO2ZvcihfPTA7Xzx0O18rKyl7aWYoYyYmaVtlXVtfXSl7RFtfXT0wO2NvbnRpbnVlfWlmKF8+PXYmJl88TyYmZT49VCl7SD1IPDwxJm07Zm9yKHA9MDtwPHg7cCsrKXtMPWUra1twXTtqPV8rU1twXTtVPVJbTF1bal07aWYoVSl7VT1DW3BdO0h8PVV9fX1lbHNle0g9MDtxPWgtMTtmb3IocD0wO3A8aDtwKysscS0tKXtqPV8rdVtwXTtpZihqPj0wJiZqPHQpe0w9ZStkW3BdO2lmKEw+PTApe1U9UltMXVtqXTtVJiYoSHw9VTw8cSl9fX19Y29uc3Qgcj1FLnJlYWRCaXQoTixIKTtEW19dPXJ9fXJldHVybiBSfWZ1bmN0aW9uIGRlY29kZVJlZmluZW1lbnQoZSx0LHIsYSxuLGkscyxvLGMpe2xldCBsPVFyW3JdLmNvZGluZzswPT09ciYmKGw9bC5jb25jYXQoW29bMF1dKSk7Y29uc3QgaD1sLmxlbmd0aCx1PW5ldyBJbnQzMkFycmF5KGgpLGQ9bmV3IEludDMyQXJyYXkoaCk7bGV0IGY7Zm9yKGY9MDtmPGg7ZisrKXt1W2ZdPWxbZl0ueDtkW2ZdPWxbZl0ueX1sZXQgZz1RcltyXS5yZWZlcmVuY2U7MD09PXImJihnPWcuY29uY2F0KFtvWzFdXSkpO2NvbnN0IHA9Zy5sZW5ndGgsbT1uZXcgSW50MzJBcnJheShwKSxiPW5ldyBJbnQzMkFycmF5KHApO2ZvcihmPTA7ZjxwO2YrKyl7bVtmXT1nW2ZdLng7YltmXT1nW2ZdLnl9Y29uc3QgeT1hWzBdLmxlbmd0aCx3PWEubGVuZ3RoLHg9dGFbcl0sUz1bXSxrPWMuZGVjb2RlcixDPWMuY29udGV4dENhY2hlLmdldENvbnRleHRzKCJHUiIpO2xldCB2PTA7Zm9yKGxldCByPTA7cjx0O3IrKyl7aWYocyl7dl49ay5yZWFkQml0KEMseCk7aWYodil0aHJvdyBuZXcgSmJpZzJFcnJvcigicHJlZGljdGlvbiBpcyBub3Qgc3VwcG9ydGVkIil9Y29uc3QgdD1uZXcgVWludDhBcnJheShlKTtTLnB1c2godCk7Zm9yKGxldCBzPTA7czxlO3MrKyl7bGV0IG8sYyxsPTA7Zm9yKGY9MDtmPGg7ZisrKXtvPXIrZFtmXTtjPXMrdVtmXTtvPDB8fGM8MHx8Yz49ZT9sPDw9MTpsPWw8PDF8U1tvXVtjXX1mb3IoZj0wO2Y8cDtmKyspe289citiW2ZdLWk7Yz1zK21bZl0tbjtvPDB8fG8+PXd8fGM8MHx8Yz49eT9sPDw9MTpsPWw8PDF8YVtvXVtjXX1jb25zdCBnPWsucmVhZEJpdChDLGwpO3Rbc109Z319cmV0dXJuIFN9ZnVuY3Rpb24gZGVjb2RlVGV4dFJlZ2lvbihlLHQscixhLG4saSxzLG8sYyxsLGgsdSxkLGYsZyxwLG0sYix5KXtpZihlJiZ0KXRocm93IG5ldyBKYmlnMkVycm9yKCJyZWZpbmVtZW50IHdpdGggSHVmZm1hbiBpcyBub3Qgc3VwcG9ydGVkIik7Y29uc3Qgdz1bXTtsZXQgeCxTO2Zvcih4PTA7eDxhO3grKyl7Uz1uZXcgVWludDhBcnJheShyKTtuJiZTLmZpbGwobik7dy5wdXNoKFMpfWNvbnN0IGs9bS5kZWNvZGVyLEM9bS5jb250ZXh0Q2FjaGU7bGV0IHY9ZT8tZi50YWJsZURlbHRhVC5kZWNvZGUoeSk6LWRlY29kZUludGVnZXIoQywiSUFEVCIsayksVD0wO3g9MDtmb3IoO3g8aTspe3YrPWU/Zi50YWJsZURlbHRhVC5kZWNvZGUoeSk6ZGVjb2RlSW50ZWdlcihDLCJJQURUIixrKTtUKz1lP2YudGFibGVGaXJzdFMuZGVjb2RlKHkpOmRlY29kZUludGVnZXIoQywiSUFGUyIsayk7bGV0IGE9VDtmb3IoOzspe2xldCBuPTA7cz4xJiYobj1lP3kucmVhZEJpdHMoYik6ZGVjb2RlSW50ZWdlcihDLCJJQUlUIixrKSk7Y29uc3QgaT1zKnYrbixUPWU/Zi5zeW1ib2xJRFRhYmxlLmRlY29kZSh5KTpkZWNvZGVJQUlEKEMsayxjKSxPPXQmJihlP3kucmVhZEJpdCgpOmRlY29kZUludGVnZXIoQywiSUFSSSIsaykpO2xldCBNPW9bVF0sRD1NWzBdLmxlbmd0aCxSPU0ubGVuZ3RoO2lmKE8pe2NvbnN0IGU9ZGVjb2RlSW50ZWdlcihDLCJJQVJEVyIsayksdD1kZWNvZGVJbnRlZ2VyKEMsIklBUkRIIixrKTtEKz1lO1IrPXQ7TT1kZWNvZGVSZWZpbmVtZW50KEQsUixnLE0sKGU+PjEpK2RlY29kZUludGVnZXIoQywiSUFSRFgiLGspLCh0Pj4xKStkZWNvZGVJbnRlZ2VyKEMsIklBUkRZIixrKSwhMSxwLG0pfWxldCBFPTA7bD8xJnU/RT1SLTE6YSs9Ui0xOnU+MT9hKz1ELTE6RT1ELTE7Y29uc3QgTj1pLSgxJnU/MDpSLTEpLF89YS0oMiZ1P0QtMTowKTtsZXQgTCxqLFU7aWYobClmb3IoTD0wO0w8UjtMKyspe1M9d1tfK0xdO2lmKCFTKWNvbnRpbnVlO1U9TVtMXTtjb25zdCBlPU1hdGgubWluKHItTixEKTtzd2l0Y2goZCl7Y2FzZSAwOmZvcihqPTA7ajxlO2orKylTW04ral18PVVbal07YnJlYWs7Y2FzZSAyOmZvcihqPTA7ajxlO2orKylTW04ral1ePVVbal07YnJlYWs7ZGVmYXVsdDp0aHJvdyBuZXcgSmJpZzJFcnJvcihgb3BlcmF0b3IgJHtkfSBpcyBub3Qgc3VwcG9ydGVkYCl9fWVsc2UgZm9yKGo9MDtqPFI7aisrKXtTPXdbTitqXTtpZihTKXtVPU1bal07c3dpdGNoKGQpe2Nhc2UgMDpmb3IoTD0wO0w8RDtMKyspU1tfK0xdfD1VW0xdO2JyZWFrO2Nhc2UgMjpmb3IoTD0wO0w8RDtMKyspU1tfK0xdXj1VW0xdO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoYG9wZXJhdG9yICR7ZH0gaXMgbm90IHN1cHBvcnRlZGApfX19eCsrO2NvbnN0IHE9ZT9mLnRhYmxlRGVsdGFTLmRlY29kZSh5KTpkZWNvZGVJbnRlZ2VyKEMsIklBRFMiLGspO2lmKG51bGw9PT1xKWJyZWFrO2ErPUUrcStofX1yZXR1cm4gd31mdW5jdGlvbiByZWFkU2VnbWVudEhlYWRlcihlLHQpe2NvbnN0IHI9e307ci5udW1iZXI9cmVhZFVpbnQzMihlLHQpO2NvbnN0IGE9ZVt0KzRdLG49NjMmYTtpZighWXJbbl0pdGhyb3cgbmV3IEpiaWcyRXJyb3IoImludmFsaWQgc2VnbWVudCB0eXBlOiAiK24pO3IudHlwZT1uO3IudHlwZU5hbWU9WXJbbl07ci5kZWZlcnJlZE5vblJldGFpbj0hISgxMjgmYSk7Y29uc3QgaT0hISg2NCZhKSxzPWVbdCs1XTtsZXQgbz1zPj41Jjc7Y29uc3QgYz1bMzEmc107bGV0IGw9dCs2O2lmKDc9PT1zKXtvPTUzNjg3MDkxMSZyZWFkVWludDMyKGUsbC0xKTtsKz0zO2xldCB0PW8rNz4+MztjWzBdPWVbbCsrXTtmb3IoOy0tdD4wOyljLnB1c2goZVtsKytdKX1lbHNlIGlmKDU9PT1zfHw2PT09cyl0aHJvdyBuZXcgSmJpZzJFcnJvcigiaW52YWxpZCByZWZlcnJlZC10byBmbGFncyIpO3IucmV0YWluQml0cz1jO2xldCBoPTQ7ci5udW1iZXI8PTI1Nj9oPTE6ci5udW1iZXI8PTY1NTM2JiYoaD0yKTtjb25zdCB1PVtdO2xldCBkLGY7Zm9yKGQ9MDtkPG87ZCsrKXtsZXQgdDt0PTE9PT1oP2VbbF06Mj09PWg/cmVhZFVpbnQxNihlLGwpOnJlYWRVaW50MzIoZSxsKTt1LnB1c2godCk7bCs9aH1yLnJlZmVycmVkVG89dTtpZihpKXtyLnBhZ2VBc3NvY2lhdGlvbj1yZWFkVWludDMyKGUsbCk7bCs9NH1lbHNlIHIucGFnZUFzc29jaWF0aW9uPWVbbCsrXTtyLmxlbmd0aD1yZWFkVWludDMyKGUsbCk7bCs9NDtpZig0Mjk0OTY3Mjk1PT09ci5sZW5ndGgpe2lmKDM4IT09bil0aHJvdyBuZXcgSmJpZzJFcnJvcigiaW52YWxpZCB1bmtub3duIHNlZ21lbnQgbGVuZ3RoIik7e2NvbnN0IHQ9cmVhZFJlZ2lvblNlZ21lbnRJbmZvcm1hdGlvbihlLGwpLGE9ISEoMSZlW2wrcmFdKSxuPTYsaT1uZXcgVWludDhBcnJheShuKTtpZighYSl7aVswXT0yNTU7aVsxXT0xNzJ9aVsyXT10LmhlaWdodD4+PjI0JjI1NTtpWzNdPXQuaGVpZ2h0Pj4xNiYyNTU7aVs0XT10LmhlaWdodD4+OCYyNTU7aVs1XT0yNTUmdC5oZWlnaHQ7Zm9yKGQ9bCxmPWUubGVuZ3RoO2Q8ZjtkKyspe2xldCB0PTA7Zm9yKDt0PG4mJmlbdF09PT1lW2QrdF07KXQrKztpZih0PT09bil7ci5sZW5ndGg9ZCtuO2JyZWFrfX1pZig0Mjk0OTY3Mjk1PT09ci5sZW5ndGgpdGhyb3cgbmV3IEpiaWcyRXJyb3IoInNlZ21lbnQgZW5kIHdhcyBub3QgZm91bmQiKX19ci5oZWFkZXJFbmQ9bDtyZXR1cm4gcn1mdW5jdGlvbiByZWFkU2VnbWVudHMoZSx0LHIsYSl7Y29uc3Qgbj1bXTtsZXQgaT1yO2Zvcig7aTxhOyl7Y29uc3Qgcj1yZWFkU2VnbWVudEhlYWRlcih0LGkpO2k9ci5oZWFkZXJFbmQ7Y29uc3QgYT17aGVhZGVyOnIsZGF0YTp0fTtpZighZS5yYW5kb21BY2Nlc3Mpe2Euc3RhcnQ9aTtpKz1yLmxlbmd0aDthLmVuZD1pfW4ucHVzaChhKTtpZig1MT09PXIudHlwZSlicmVha31pZihlLnJhbmRvbUFjY2Vzcylmb3IobGV0IGU9MCx0PW4ubGVuZ3RoO2U8dDtlKyspe25bZV0uc3RhcnQ9aTtpKz1uW2VdLmhlYWRlci5sZW5ndGg7bltlXS5lbmQ9aX1yZXR1cm4gbn1mdW5jdGlvbiByZWFkUmVnaW9uU2VnbWVudEluZm9ybWF0aW9uKGUsdCl7cmV0dXJue3dpZHRoOnJlYWRVaW50MzIoZSx0KSxoZWlnaHQ6cmVhZFVpbnQzMihlLHQrNCkseDpyZWFkVWludDMyKGUsdCs4KSx5OnJlYWRVaW50MzIoZSx0KzEyKSxjb21iaW5hdGlvbk9wZXJhdG9yOjcmZVt0KzE2XX19Y29uc3QgcmE9MTc7ZnVuY3Rpb24gcHJvY2Vzc1NlZ21lbnQoZSx0KXtjb25zdCByPWUuaGVhZGVyLGE9ZS5kYXRhLG49ZS5lbmQ7bGV0IGkscyxvLGMsbD1lLnN0YXJ0O3N3aXRjaChyLnR5cGUpe2Nhc2UgMDpjb25zdCBlPXt9LHQ9cmVhZFVpbnQxNihhLGwpO2UuaHVmZm1hbj0hISgxJnQpO2UucmVmaW5lbWVudD0hISgyJnQpO2UuaHVmZm1hbkRIU2VsZWN0b3I9dD4+MiYzO2UuaHVmZm1hbkRXU2VsZWN0b3I9dD4+NCYzO2UuYml0bWFwU2l6ZVNlbGVjdG9yPXQ+PjYmMTtlLmFnZ3JlZ2F0aW9uSW5zdGFuY2VzU2VsZWN0b3I9dD4+NyYxO2UuYml0bWFwQ29kaW5nQ29udGV4dFVzZWQ9ISEoMjU2JnQpO2UuYml0bWFwQ29kaW5nQ29udGV4dFJldGFpbmVkPSEhKDUxMiZ0KTtlLnRlbXBsYXRlPXQ+PjEwJjM7ZS5yZWZpbmVtZW50VGVtcGxhdGU9dD4+MTImMTtsKz0yO2lmKCFlLmh1ZmZtYW4pe2M9MD09PWUudGVtcGxhdGU/NDoxO3M9W107Zm9yKG89MDtvPGM7bysrKXtzLnB1c2goe3g6cmVhZEludDgoYSxsKSx5OnJlYWRJbnQ4KGEsbCsxKX0pO2wrPTJ9ZS5hdD1zfWlmKGUucmVmaW5lbWVudCYmIWUucmVmaW5lbWVudFRlbXBsYXRlKXtzPVtdO2ZvcihvPTA7bzwyO28rKyl7cy5wdXNoKHt4OnJlYWRJbnQ4KGEsbCkseTpyZWFkSW50OChhLGwrMSl9KTtsKz0yfWUucmVmaW5lbWVudEF0PXN9ZS5udW1iZXJPZkV4cG9ydGVkU3ltYm9scz1yZWFkVWludDMyKGEsbCk7bCs9NDtlLm51bWJlck9mTmV3U3ltYm9scz1yZWFkVWludDMyKGEsbCk7bCs9NDtpPVtlLHIubnVtYmVyLHIucmVmZXJyZWRUbyxhLGwsbl07YnJlYWs7Y2FzZSA2OmNhc2UgNzpjb25zdCBoPXt9O2guaW5mbz1yZWFkUmVnaW9uU2VnbWVudEluZm9ybWF0aW9uKGEsbCk7bCs9cmE7Y29uc3QgdT1yZWFkVWludDE2KGEsbCk7bCs9MjtoLmh1ZmZtYW49ISEoMSZ1KTtoLnJlZmluZW1lbnQ9ISEoMiZ1KTtoLmxvZ1N0cmlwU2l6ZT11Pj4yJjM7aC5zdHJpcFNpemU9MTw8aC5sb2dTdHJpcFNpemU7aC5yZWZlcmVuY2VDb3JuZXI9dT4+NCYzO2gudHJhbnNwb3NlZD0hISg2NCZ1KTtoLmNvbWJpbmF0aW9uT3BlcmF0b3I9dT4+NyYzO2guZGVmYXVsdFBpeGVsVmFsdWU9dT4+OSYxO2guZHNPZmZzZXQ9dTw8MTc+PjI3O2gucmVmaW5lbWVudFRlbXBsYXRlPXU+PjE1JjE7aWYoaC5odWZmbWFuKXtjb25zdCBlPXJlYWRVaW50MTYoYSxsKTtsKz0yO2guaHVmZm1hbkZTPTMmZTtoLmh1ZmZtYW5EUz1lPj4yJjM7aC5odWZmbWFuRFQ9ZT4+NCYzO2guaHVmZm1hblJlZmluZW1lbnREVz1lPj42JjM7aC5odWZmbWFuUmVmaW5lbWVudERIPWU+PjgmMztoLmh1ZmZtYW5SZWZpbmVtZW50RFg9ZT4+MTAmMztoLmh1ZmZtYW5SZWZpbmVtZW50RFk9ZT4+MTImMztoLmh1ZmZtYW5SZWZpbmVtZW50U2l6ZVNlbGVjdG9yPSEhKDE2Mzg0JmUpfWlmKGgucmVmaW5lbWVudCYmIWgucmVmaW5lbWVudFRlbXBsYXRlKXtzPVtdO2ZvcihvPTA7bzwyO28rKyl7cy5wdXNoKHt4OnJlYWRJbnQ4KGEsbCkseTpyZWFkSW50OChhLGwrMSl9KTtsKz0yfWgucmVmaW5lbWVudEF0PXN9aC5udW1iZXJPZlN5bWJvbEluc3RhbmNlcz1yZWFkVWludDMyKGEsbCk7bCs9NDtpPVtoLHIucmVmZXJyZWRUbyxhLGwsbl07YnJlYWs7Y2FzZSAxNjpjb25zdCBkPXt9LGY9YVtsKytdO2QubW1yPSEhKDEmZik7ZC50ZW1wbGF0ZT1mPj4xJjM7ZC5wYXR0ZXJuV2lkdGg9YVtsKytdO2QucGF0dGVybkhlaWdodD1hW2wrK107ZC5tYXhQYXR0ZXJuSW5kZXg9cmVhZFVpbnQzMihhLGwpO2wrPTQ7aT1bZCxyLm51bWJlcixhLGwsbl07YnJlYWs7Y2FzZSAyMjpjYXNlIDIzOmNvbnN0IGc9e307Zy5pbmZvPXJlYWRSZWdpb25TZWdtZW50SW5mb3JtYXRpb24oYSxsKTtsKz1yYTtjb25zdCBwPWFbbCsrXTtnLm1tcj0hISgxJnApO2cudGVtcGxhdGU9cD4+MSYzO2cuZW5hYmxlU2tpcD0hISg4JnApO2cuY29tYmluYXRpb25PcGVyYXRvcj1wPj40Jjc7Zy5kZWZhdWx0UGl4ZWxWYWx1ZT1wPj43JjE7Zy5ncmlkV2lkdGg9cmVhZFVpbnQzMihhLGwpO2wrPTQ7Zy5ncmlkSGVpZ2h0PXJlYWRVaW50MzIoYSxsKTtsKz00O2cuZ3JpZE9mZnNldFg9NDI5NDk2NzI5NSZyZWFkVWludDMyKGEsbCk7bCs9NDtnLmdyaWRPZmZzZXRZPTQyOTQ5NjcyOTUmcmVhZFVpbnQzMihhLGwpO2wrPTQ7Zy5ncmlkVmVjdG9yWD1yZWFkVWludDE2KGEsbCk7bCs9MjtnLmdyaWRWZWN0b3JZPXJlYWRVaW50MTYoYSxsKTtsKz0yO2k9W2csci5yZWZlcnJlZFRvLGEsbCxuXTticmVhaztjYXNlIDM4OmNhc2UgMzk6Y29uc3QgbT17fTttLmluZm89cmVhZFJlZ2lvblNlZ21lbnRJbmZvcm1hdGlvbihhLGwpO2wrPXJhO2NvbnN0IGI9YVtsKytdO20ubW1yPSEhKDEmYik7bS50ZW1wbGF0ZT1iPj4xJjM7bS5wcmVkaWN0aW9uPSEhKDgmYik7aWYoIW0ubW1yKXtjPTA9PT1tLnRlbXBsYXRlPzQ6MTtzPVtdO2ZvcihvPTA7bzxjO28rKyl7cy5wdXNoKHt4OnJlYWRJbnQ4KGEsbCkseTpyZWFkSW50OChhLGwrMSl9KTtsKz0yfW0uYXQ9c31pPVttLGEsbCxuXTticmVhaztjYXNlIDQ4OmNvbnN0IHk9e3dpZHRoOnJlYWRVaW50MzIoYSxsKSxoZWlnaHQ6cmVhZFVpbnQzMihhLGwrNCkscmVzb2x1dGlvblg6cmVhZFVpbnQzMihhLGwrOCkscmVzb2x1dGlvblk6cmVhZFVpbnQzMihhLGwrMTIpfTs0Mjk0OTY3Mjk1PT09eS5oZWlnaHQmJmRlbGV0ZSB5LmhlaWdodDtjb25zdCB3PWFbbCsxNl07cmVhZFVpbnQxNihhLGwrMTcpO3kubG9zc2xlc3M9ISEoMSZ3KTt5LnJlZmluZW1lbnQ9ISEoMiZ3KTt5LmRlZmF1bHRQaXhlbFZhbHVlPXc+PjImMTt5LmNvbWJpbmF0aW9uT3BlcmF0b3I9dz4+MyYzO3kucmVxdWlyZXNCdWZmZXI9ISEoMzImdyk7eS5jb21iaW5hdGlvbk9wZXJhdG9yT3ZlcnJpZGU9ISEoNjQmdyk7aT1beV07YnJlYWs7Y2FzZSA0OTpjYXNlIDUwOmNhc2UgNTE6Y2FzZSA2MjpicmVhaztjYXNlIDUzOmk9W3IubnVtYmVyLGEsbCxuXTticmVhaztkZWZhdWx0OnRocm93IG5ldyBKYmlnMkVycm9yKGBzZWdtZW50IHR5cGUgJHtyLnR5cGVOYW1lfSgke3IudHlwZX0pIGlzIG5vdCBpbXBsZW1lbnRlZGApfWNvbnN0IGg9Im9uIityLnR5cGVOYW1lO2ggaW4gdCYmdFtoXS5hcHBseSh0LGkpfWZ1bmN0aW9uIHByb2Nlc3NTZWdtZW50cyhlLHQpe2ZvcihsZXQgcj0wLGE9ZS5sZW5ndGg7cjxhO3IrKylwcm9jZXNzU2VnbWVudChlW3JdLHQpfWNsYXNzIFNpbXBsZVNlZ21lbnRWaXNpdG9ye29uUGFnZUluZm9ybWF0aW9uKGUpe3RoaXMuY3VycmVudFBhZ2VJbmZvPWU7Y29uc3QgdD1lLndpZHRoKzc+PjMscj1uZXcgVWludDhDbGFtcGVkQXJyYXkodCplLmhlaWdodCk7ZS5kZWZhdWx0UGl4ZWxWYWx1ZSYmci5maWxsKDI1NSk7dGhpcy5idWZmZXI9cn1kcmF3Qml0bWFwKGUsdCl7Y29uc3Qgcj10aGlzLmN1cnJlbnRQYWdlSW5mbyxhPWUud2lkdGgsbj1lLmhlaWdodCxpPXIud2lkdGgrNz4+MyxzPXIuY29tYmluYXRpb25PcGVyYXRvck92ZXJyaWRlP2UuY29tYmluYXRpb25PcGVyYXRvcjpyLmNvbWJpbmF0aW9uT3BlcmF0b3Isbz10aGlzLmJ1ZmZlcixjPTEyOD4+KDcmZS54KTtsZXQgbCxoLHUsZCxmPWUueSppKyhlLng+PjMpO3N3aXRjaChzKXtjYXNlIDA6Zm9yKGw9MDtsPG47bCsrKXt1PWM7ZD1mO2ZvcihoPTA7aDxhO2grKyl7dFtsXVtoXSYmKG9bZF18PXUpO3U+Pj0xO2lmKCF1KXt1PTEyODtkKyt9fWYrPWl9YnJlYWs7Y2FzZSAyOmZvcihsPTA7bDxuO2wrKyl7dT1jO2Q9Zjtmb3IoaD0wO2g8YTtoKyspe3RbbF1baF0mJihvW2RdXj11KTt1Pj49MTtpZighdSl7dT0xMjg7ZCsrfX1mKz1pfWJyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoYG9wZXJhdG9yICR7c30gaXMgbm90IHN1cHBvcnRlZGApfX1vbkltbWVkaWF0ZUdlbmVyaWNSZWdpb24oZSx0LHIsYSl7Y29uc3Qgbj1lLmluZm8saT1uZXcgRGVjb2RpbmdDb250ZXh0KHQscixhKSxzPWRlY29kZUJpdG1hcChlLm1tcixuLndpZHRoLG4uaGVpZ2h0LGUudGVtcGxhdGUsZS5wcmVkaWN0aW9uLG51bGwsZS5hdCxpKTt0aGlzLmRyYXdCaXRtYXAobixzKX1vbkltbWVkaWF0ZUxvc3NsZXNzR2VuZXJpY1JlZ2lvbigpe3RoaXMub25JbW1lZGlhdGVHZW5lcmljUmVnaW9uKC4uLmFyZ3VtZW50cyl9b25TeW1ib2xEaWN0aW9uYXJ5KGUsdCxyLGEsbixpKXtsZXQgcyxvO2lmKGUuaHVmZm1hbil7cz1mdW5jdGlvbiBnZXRTeW1ib2xEaWN0aW9uYXJ5SHVmZm1hblRhYmxlcyhlLHQscil7bGV0IGEsbixpLHMsbz0wO3N3aXRjaChlLmh1ZmZtYW5ESFNlbGVjdG9yKXtjYXNlIDA6Y2FzZSAxOmE9Z2V0U3RhbmRhcmRUYWJsZShlLmh1ZmZtYW5ESFNlbGVjdG9yKzQpO2JyZWFrO2Nhc2UgMzphPWdldEN1c3RvbUh1ZmZtYW5UYWJsZShvLHQscik7bysrO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoImludmFsaWQgSHVmZm1hbiBESCBzZWxlY3RvciIpfXN3aXRjaChlLmh1ZmZtYW5EV1NlbGVjdG9yKXtjYXNlIDA6Y2FzZSAxOm49Z2V0U3RhbmRhcmRUYWJsZShlLmh1ZmZtYW5EV1NlbGVjdG9yKzIpO2JyZWFrO2Nhc2UgMzpuPWdldEN1c3RvbUh1ZmZtYW5UYWJsZShvLHQscik7bysrO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoImludmFsaWQgSHVmZm1hbiBEVyBzZWxlY3RvciIpfWlmKGUuYml0bWFwU2l6ZVNlbGVjdG9yKXtpPWdldEN1c3RvbUh1ZmZtYW5UYWJsZShvLHQscik7bysrfWVsc2UgaT1nZXRTdGFuZGFyZFRhYmxlKDEpO3M9ZS5hZ2dyZWdhdGlvbkluc3RhbmNlc1NlbGVjdG9yP2dldEN1c3RvbUh1ZmZtYW5UYWJsZShvLHQscik6Z2V0U3RhbmRhcmRUYWJsZSgxKTtyZXR1cm57dGFibGVEZWx0YUhlaWdodDphLHRhYmxlRGVsdGFXaWR0aDpuLHRhYmxlQml0bWFwU2l6ZTppLHRhYmxlQWdncmVnYXRlSW5zdGFuY2VzOnN9fShlLHIsdGhpcy5jdXN0b21UYWJsZXMpO289bmV3IFJlYWRlcihhLG4saSl9bGV0IGM9dGhpcy5zeW1ib2xzO2N8fCh0aGlzLnN5bWJvbHM9Yz17fSk7Y29uc3QgbD1bXTtmb3IoY29uc3QgZSBvZiByKXtjb25zdCB0PWNbZV07dCYmbC5wdXNoKC4uLnQpfWNvbnN0IGg9bmV3IERlY29kaW5nQ29udGV4dChhLG4saSk7Y1t0XT1mdW5jdGlvbiBkZWNvZGVTeW1ib2xEaWN0aW9uYXJ5KGUsdCxyLGEsbixpLHMsbyxjLGwsaCx1KXtpZihlJiZ0KXRocm93IG5ldyBKYmlnMkVycm9yKCJzeW1ib2wgcmVmaW5lbWVudCB3aXRoIEh1ZmZtYW4gaXMgbm90IHN1cHBvcnRlZCIpO2NvbnN0IGQ9W107bGV0IGY9MCxnPWxvZzIoci5sZW5ndGgrYSk7Y29uc3QgcD1oLmRlY29kZXIsbT1oLmNvbnRleHRDYWNoZTtsZXQgYix5O2lmKGUpe2I9Z2V0U3RhbmRhcmRUYWJsZSgxKTt5PVtdO2c9TWF0aC5tYXgoZywxKX1mb3IoO2QubGVuZ3RoPGE7KXtmKz1lP2kudGFibGVEZWx0YUhlaWdodC5kZWNvZGUodSk6ZGVjb2RlSW50ZWdlcihtLCJJQURIIixwKTtsZXQgYT0wLG49MDtjb25zdCBiPWU/eS5sZW5ndGg6MDtmb3IoOzspe2NvbnN0IGI9ZT9pLnRhYmxlRGVsdGFXaWR0aC5kZWNvZGUodSk6ZGVjb2RlSW50ZWdlcihtLCJJQURXIixwKTtpZihudWxsPT09YilicmVhazthKz1iO24rPWE7bGV0IHc7aWYodCl7Y29uc3Qgbj1kZWNvZGVJbnRlZ2VyKG0sIklBQUkiLHApO2lmKG4+MSl3PWRlY29kZVRleHRSZWdpb24oZSx0LGEsZiwwLG4sMSxyLmNvbmNhdChkKSxnLDAsMCwxLDAsaSxjLGwsaCwwLHUpO2Vsc2V7Y29uc3QgZT1kZWNvZGVJQUlEKG0scCxnKSx0PWRlY29kZUludGVnZXIobSwiSUFSRFgiLHApLG49ZGVjb2RlSW50ZWdlcihtLCJJQVJEWSIscCk7dz1kZWNvZGVSZWZpbmVtZW50KGEsZixjLGU8ci5sZW5ndGg/cltlXTpkW2Utci5sZW5ndGhdLHQsbiwhMSxsLGgpfWQucHVzaCh3KX1lbHNlIGlmKGUpeS5wdXNoKGEpO2Vsc2V7dz1kZWNvZGVCaXRtYXAoITEsYSxmLHMsITEsbnVsbCxvLGgpO2QucHVzaCh3KX19aWYoZSYmIXQpe2NvbnN0IGU9aS50YWJsZUJpdG1hcFNpemUuZGVjb2RlKHUpO3UuYnl0ZUFsaWduKCk7bGV0IHQ7aWYoMD09PWUpdD1yZWFkVW5jb21wcmVzc2VkQml0bWFwKHUsbixmKTtlbHNle2NvbnN0IHI9dS5lbmQsYT11LnBvc2l0aW9uK2U7dS5lbmQ9YTt0PWRlY29kZU1NUkJpdG1hcCh1LG4sZiwhMSk7dS5lbmQ9cjt1LnBvc2l0aW9uPWF9Y29uc3Qgcj15Lmxlbmd0aDtpZihiPT09ci0xKWQucHVzaCh0KTtlbHNle2xldCBlLGEsbixpLHMsbz0wO2ZvcihlPWI7ZTxyO2UrKyl7aT15W2VdO249bytpO3M9W107Zm9yKGE9MDthPGY7YSsrKXMucHVzaCh0W2FdLnN1YmFycmF5KG8sbikpO2QucHVzaChzKTtvPW59fX19Y29uc3Qgdz1bXSx4PVtdO2xldCBTLGssQz0hMTtjb25zdCB2PXIubGVuZ3RoK2E7Zm9yKDt4Lmxlbmd0aDx2Oyl7bGV0IHQ9ZT9iLmRlY29kZSh1KTpkZWNvZGVJbnRlZ2VyKG0sIklBRVgiLHApO2Zvcig7dC0tOyl4LnB1c2goQyk7Qz0hQ31mb3IoUz0wLGs9ci5sZW5ndGg7UzxrO1MrKyl4W1NdJiZ3LnB1c2gocltTXSk7Zm9yKGxldCBlPTA7ZTxhO1MrKyxlKyspeFtTXSYmdy5wdXNoKGRbZV0pO3JldHVybiB3fShlLmh1ZmZtYW4sZS5yZWZpbmVtZW50LGwsZS5udW1iZXJPZk5ld1N5bWJvbHMsZS5udW1iZXJPZkV4cG9ydGVkU3ltYm9scyxzLGUudGVtcGxhdGUsZS5hdCxlLnJlZmluZW1lbnRUZW1wbGF0ZSxlLnJlZmluZW1lbnRBdCxoLG8pfW9uSW1tZWRpYXRlVGV4dFJlZ2lvbihlLHQscixhLG4pe2NvbnN0IGk9ZS5pbmZvO2xldCBzLG87Y29uc3QgYz10aGlzLnN5bWJvbHMsbD1bXTtmb3IoY29uc3QgZSBvZiB0KXtjb25zdCB0PWNbZV07dCYmbC5wdXNoKC4uLnQpfWNvbnN0IGg9bG9nMihsLmxlbmd0aCk7aWYoZS5odWZmbWFuKXtvPW5ldyBSZWFkZXIocixhLG4pO3M9ZnVuY3Rpb24gZ2V0VGV4dFJlZ2lvbkh1ZmZtYW5UYWJsZXMoZSx0LHIsYSxuKXtjb25zdCBpPVtdO2ZvcihsZXQgZT0wO2U8PTM0O2UrKyl7Y29uc3QgdD1uLnJlYWRCaXRzKDQpO2kucHVzaChuZXcgSHVmZm1hbkxpbmUoW2UsdCwwLDBdKSl9Y29uc3Qgcz1uZXcgSHVmZm1hblRhYmxlKGksITEpO2kubGVuZ3RoPTA7Zm9yKGxldCBlPTA7ZTxhOyl7Y29uc3QgdD1zLmRlY29kZShuKTtpZih0Pj0zMil7bGV0IHIsYSxzO3N3aXRjaCh0KXtjYXNlIDMyOmlmKDA9PT1lKXRocm93IG5ldyBKYmlnMkVycm9yKCJubyBwcmV2aW91cyB2YWx1ZSBpbiBzeW1ib2wgSUQgdGFibGUiKTthPW4ucmVhZEJpdHMoMikrMztyPWlbZS0xXS5wcmVmaXhMZW5ndGg7YnJlYWs7Y2FzZSAzMzphPW4ucmVhZEJpdHMoMykrMztyPTA7YnJlYWs7Y2FzZSAzNDphPW4ucmVhZEJpdHMoNykrMTE7cj0wO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoImludmFsaWQgY29kZSBsZW5ndGggaW4gc3ltYm9sIElEIHRhYmxlIil9Zm9yKHM9MDtzPGE7cysrKXtpLnB1c2gobmV3IEh1ZmZtYW5MaW5lKFtlLHIsMCwwXSkpO2UrK319ZWxzZXtpLnB1c2gobmV3IEh1ZmZtYW5MaW5lKFtlLHQsMCwwXSkpO2UrK319bi5ieXRlQWxpZ24oKTtjb25zdCBvPW5ldyBIdWZmbWFuVGFibGUoaSwhMSk7bGV0IGMsbCxoLHU9MDtzd2l0Y2goZS5odWZmbWFuRlMpe2Nhc2UgMDpjYXNlIDE6Yz1nZXRTdGFuZGFyZFRhYmxlKGUuaHVmZm1hbkZTKzYpO2JyZWFrO2Nhc2UgMzpjPWdldEN1c3RvbUh1ZmZtYW5UYWJsZSh1LHQscik7dSsrO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoImludmFsaWQgSHVmZm1hbiBGUyBzZWxlY3RvciIpfXN3aXRjaChlLmh1ZmZtYW5EUyl7Y2FzZSAwOmNhc2UgMTpjYXNlIDI6bD1nZXRTdGFuZGFyZFRhYmxlKGUuaHVmZm1hbkRTKzgpO2JyZWFrO2Nhc2UgMzpsPWdldEN1c3RvbUh1ZmZtYW5UYWJsZSh1LHQscik7dSsrO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoImludmFsaWQgSHVmZm1hbiBEUyBzZWxlY3RvciIpfXN3aXRjaChlLmh1ZmZtYW5EVCl7Y2FzZSAwOmNhc2UgMTpjYXNlIDI6aD1nZXRTdGFuZGFyZFRhYmxlKGUuaHVmZm1hbkRUKzExKTticmVhaztjYXNlIDM6aD1nZXRDdXN0b21IdWZmbWFuVGFibGUodSx0LHIpO3UrKzticmVhaztkZWZhdWx0OnRocm93IG5ldyBKYmlnMkVycm9yKCJpbnZhbGlkIEh1ZmZtYW4gRFQgc2VsZWN0b3IiKX1pZihlLnJlZmluZW1lbnQpdGhyb3cgbmV3IEpiaWcyRXJyb3IoInJlZmluZW1lbnQgd2l0aCBIdWZmbWFuIGlzIG5vdCBzdXBwb3J0ZWQiKTtyZXR1cm57c3ltYm9sSURUYWJsZTpvLHRhYmxlRmlyc3RTOmMsdGFibGVEZWx0YVM6bCx0YWJsZURlbHRhVDpofX0oZSx0LHRoaXMuY3VzdG9tVGFibGVzLGwubGVuZ3RoLG8pfWNvbnN0IHU9bmV3IERlY29kaW5nQ29udGV4dChyLGEsbiksZD1kZWNvZGVUZXh0UmVnaW9uKGUuaHVmZm1hbixlLnJlZmluZW1lbnQsaS53aWR0aCxpLmhlaWdodCxlLmRlZmF1bHRQaXhlbFZhbHVlLGUubnVtYmVyT2ZTeW1ib2xJbnN0YW5jZXMsZS5zdHJpcFNpemUsbCxoLGUudHJhbnNwb3NlZCxlLmRzT2Zmc2V0LGUucmVmZXJlbmNlQ29ybmVyLGUuY29tYmluYXRpb25PcGVyYXRvcixzLGUucmVmaW5lbWVudFRlbXBsYXRlLGUucmVmaW5lbWVudEF0LHUsZS5sb2dTdHJpcFNpemUsbyk7dGhpcy5kcmF3Qml0bWFwKGksZCl9b25JbW1lZGlhdGVMb3NzbGVzc1RleHRSZWdpb24oKXt0aGlzLm9uSW1tZWRpYXRlVGV4dFJlZ2lvbiguLi5hcmd1bWVudHMpfW9uUGF0dGVybkRpY3Rpb25hcnkoZSx0LHIsYSxuKXtsZXQgaT10aGlzLnBhdHRlcm5zO2l8fCh0aGlzLnBhdHRlcm5zPWk9e30pO2NvbnN0IHM9bmV3IERlY29kaW5nQ29udGV4dChyLGEsbik7aVt0XT1mdW5jdGlvbiBkZWNvZGVQYXR0ZXJuRGljdGlvbmFyeShlLHQscixhLG4saSl7Y29uc3Qgcz1bXTtpZighZSl7cy5wdXNoKHt4Oi10LHk6MH0pOzA9PT1uJiZzLnB1c2goe3g6LTMseTotMX0se3g6Mix5Oi0yfSx7eDotMix5Oi0yfSl9Y29uc3Qgbz1kZWNvZGVCaXRtYXAoZSwoYSsxKSp0LHIsbiwhMSxudWxsLHMsaSksYz1bXTtmb3IobGV0IGU9MDtlPD1hO2UrKyl7Y29uc3QgYT1bXSxuPXQqZSxpPW4rdDtmb3IobGV0IGU9MDtlPHI7ZSsrKWEucHVzaChvW2VdLnN1YmFycmF5KG4saSkpO2MucHVzaChhKX1yZXR1cm4gY30oZS5tbXIsZS5wYXR0ZXJuV2lkdGgsZS5wYXR0ZXJuSGVpZ2h0LGUubWF4UGF0dGVybkluZGV4LGUudGVtcGxhdGUscyl9b25JbW1lZGlhdGVIYWxmdG9uZVJlZ2lvbihlLHQscixhLG4pe2NvbnN0IGk9dGhpcy5wYXR0ZXJuc1t0WzBdXSxzPWUuaW5mbyxvPW5ldyBEZWNvZGluZ0NvbnRleHQocixhLG4pLGM9ZnVuY3Rpb24gZGVjb2RlSGFsZnRvbmVSZWdpb24oZSx0LHIsYSxuLGkscyxvLGMsbCxoLHUsZCxmLGcpe2lmKHMpdGhyb3cgbmV3IEpiaWcyRXJyb3IoInNraXAgaXMgbm90IHN1cHBvcnRlZCIpO2lmKDAhPT1vKXRocm93IG5ldyBKYmlnMkVycm9yKGBvcGVyYXRvciAiJHtvfSIgaXMgbm90IHN1cHBvcnRlZCBpbiBoYWxmdG9uZSByZWdpb25gKTtjb25zdCBwPVtdO2xldCBtLGIseTtmb3IobT0wO208bjttKyspe3k9bmV3IFVpbnQ4QXJyYXkoYSk7aSYmeS5maWxsKGkpO3AucHVzaCh5KX1jb25zdCB3PXQubGVuZ3RoLHg9dFswXSxTPXhbMF0ubGVuZ3RoLGs9eC5sZW5ndGgsQz1sb2cyKHcpLHY9W107aWYoIWUpe3YucHVzaCh7eDpyPD0xPzM6Mix5Oi0xfSk7MD09PXImJnYucHVzaCh7eDotMyx5Oi0xfSx7eDoyLHk6LTJ9LHt4Oi0yLHk6LTJ9KX1jb25zdCBUPVtdO2xldCBPLE0sRCxSLEUsTixfLEwsaixVLHE7ZSYmKE89bmV3IFJlYWRlcihnLmRhdGEsZy5zdGFydCxnLmVuZCkpO2ZvcihtPUMtMTttPj0wO20tLSl7TT1lP2RlY29kZU1NUkJpdG1hcChPLGMsbCwhMCk6ZGVjb2RlQml0bWFwKCExLGMsbCxyLCExLG51bGwsdixnKTtUW21dPU19Zm9yKEQ9MDtEPGw7RCsrKWZvcihSPTA7UjxjO1IrKyl7RT0wO049MDtmb3IoYj1DLTE7Yj49MDtiLS0pe0VePVRbYl1bRF1bUl07Tnw9RTw8Yn1fPXRbTl07TD1oK0QqZitSKmQ+Pjg7aj11K0QqZC1SKmY+Pjg7aWYoTD49MCYmTCtTPD1hJiZqPj0wJiZqK2s8PW4pZm9yKG09MDttPGs7bSsrKXtxPXBbaittXTtVPV9bbV07Zm9yKGI9MDtiPFM7YisrKXFbTCtiXXw9VVtiXX1lbHNle2xldCBlLHQ7Zm9yKG09MDttPGs7bSsrKXt0PWorbTtpZighKHQ8MHx8dD49bikpe3E9cFt0XTtVPV9bbV07Zm9yKGI9MDtiPFM7YisrKXtlPUwrYjtlPj0wJiZlPGEmJihxW2VdfD1VW2JdKX19fX19cmV0dXJuIHB9KGUubW1yLGksZS50ZW1wbGF0ZSxzLndpZHRoLHMuaGVpZ2h0LGUuZGVmYXVsdFBpeGVsVmFsdWUsZS5lbmFibGVTa2lwLGUuY29tYmluYXRpb25PcGVyYXRvcixlLmdyaWRXaWR0aCxlLmdyaWRIZWlnaHQsZS5ncmlkT2Zmc2V0WCxlLmdyaWRPZmZzZXRZLGUuZ3JpZFZlY3RvclgsZS5ncmlkVmVjdG9yWSxvKTt0aGlzLmRyYXdCaXRtYXAocyxjKX1vbkltbWVkaWF0ZUxvc3NsZXNzSGFsZnRvbmVSZWdpb24oKXt0aGlzLm9uSW1tZWRpYXRlSGFsZnRvbmVSZWdpb24oLi4uYXJndW1lbnRzKX1vblRhYmxlcyhlLHQscixhKXtsZXQgbj10aGlzLmN1c3RvbVRhYmxlcztufHwodGhpcy5jdXN0b21UYWJsZXM9bj17fSk7bltlXT1mdW5jdGlvbiBkZWNvZGVUYWJsZXNTZWdtZW50KGUsdCxyKXtjb25zdCBhPWVbdF0sbj00Mjk0OTY3Mjk1JnJlYWRVaW50MzIoZSx0KzEpLGk9NDI5NDk2NzI5NSZyZWFkVWludDMyKGUsdCs1KSxzPW5ldyBSZWFkZXIoZSx0Kzksciksbz0xKyhhPj4xJjcpLGM9MSsoYT4+NCY3KSxsPVtdO2xldCBoLHUsZD1uO2Rve2g9cy5yZWFkQml0cyhvKTt1PXMucmVhZEJpdHMoYyk7bC5wdXNoKG5ldyBIdWZmbWFuTGluZShbZCxoLHUsMF0pKTtkKz0xPDx1fXdoaWxlKGQ8aSk7aD1zLnJlYWRCaXRzKG8pO2wucHVzaChuZXcgSHVmZm1hbkxpbmUoW24tMSxoLDMyLDAsImxvd2VyIl0pKTtoPXMucmVhZEJpdHMobyk7bC5wdXNoKG5ldyBIdWZmbWFuTGluZShbaSxoLDMyLDBdKSk7aWYoMSZhKXtoPXMucmVhZEJpdHMobyk7bC5wdXNoKG5ldyBIdWZmbWFuTGluZShbaCwwXSkpfXJldHVybiBuZXcgSHVmZm1hblRhYmxlKGwsITEpfSh0LHIsYSl9fWNsYXNzIEh1ZmZtYW5MaW5le2NvbnN0cnVjdG9yKGUpe2lmKDI9PT1lLmxlbmd0aCl7dGhpcy5pc09PQj0hMDt0aGlzLnJhbmdlTG93PTA7dGhpcy5wcmVmaXhMZW5ndGg9ZVswXTt0aGlzLnJhbmdlTGVuZ3RoPTA7dGhpcy5wcmVmaXhDb2RlPWVbMV07dGhpcy5pc0xvd2VyUmFuZ2U9ITF9ZWxzZXt0aGlzLmlzT09CPSExO3RoaXMucmFuZ2VMb3c9ZVswXTt0aGlzLnByZWZpeExlbmd0aD1lWzFdO3RoaXMucmFuZ2VMZW5ndGg9ZVsyXTt0aGlzLnByZWZpeENvZGU9ZVszXTt0aGlzLmlzTG93ZXJSYW5nZT0ibG93ZXIiPT09ZVs0XX19fWNsYXNzIEh1ZmZtYW5UcmVlTm9kZXtjb25zdHJ1Y3RvcihlKXt0aGlzLmNoaWxkcmVuPVtdO2lmKGUpe3RoaXMuaXNMZWFmPSEwO3RoaXMucmFuZ2VMZW5ndGg9ZS5yYW5nZUxlbmd0aDt0aGlzLnJhbmdlTG93PWUucmFuZ2VMb3c7dGhpcy5pc0xvd2VyUmFuZ2U9ZS5pc0xvd2VyUmFuZ2U7dGhpcy5pc09PQj1lLmlzT09CfWVsc2UgdGhpcy5pc0xlYWY9ITF9YnVpbGRUcmVlKGUsdCl7Y29uc3Qgcj1lLnByZWZpeENvZGU+PnQmMTtpZih0PD0wKXRoaXMuY2hpbGRyZW5bcl09bmV3IEh1ZmZtYW5UcmVlTm9kZShlKTtlbHNle2xldCBhPXRoaXMuY2hpbGRyZW5bcl07YXx8KHRoaXMuY2hpbGRyZW5bcl09YT1uZXcgSHVmZm1hblRyZWVOb2RlKG51bGwpKTthLmJ1aWxkVHJlZShlLHQtMSl9fWRlY29kZU5vZGUoZSl7aWYodGhpcy5pc0xlYWYpe2lmKHRoaXMuaXNPT0IpcmV0dXJuIG51bGw7Y29uc3QgdD1lLnJlYWRCaXRzKHRoaXMucmFuZ2VMZW5ndGgpO3JldHVybiB0aGlzLnJhbmdlTG93Kyh0aGlzLmlzTG93ZXJSYW5nZT8tdDp0KX1jb25zdCB0PXRoaXMuY2hpbGRyZW5bZS5yZWFkQml0KCldO2lmKCF0KXRocm93IG5ldyBKYmlnMkVycm9yKCJpbnZhbGlkIEh1ZmZtYW4gZGF0YSIpO3JldHVybiB0LmRlY29kZU5vZGUoZSl9fWNsYXNzIEh1ZmZtYW5UYWJsZXtjb25zdHJ1Y3RvcihlLHQpe3R8fHRoaXMuYXNzaWduUHJlZml4Q29kZXMoZSk7dGhpcy5yb290Tm9kZT1uZXcgSHVmZm1hblRyZWVOb2RlKG51bGwpO2ZvcihsZXQgdD0wLHI9ZS5sZW5ndGg7dDxyO3QrKyl7Y29uc3Qgcj1lW3RdO3IucHJlZml4TGVuZ3RoPjAmJnRoaXMucm9vdE5vZGUuYnVpbGRUcmVlKHIsci5wcmVmaXhMZW5ndGgtMSl9fWRlY29kZShlKXtyZXR1cm4gdGhpcy5yb290Tm9kZS5kZWNvZGVOb2RlKGUpfWFzc2lnblByZWZpeENvZGVzKGUpe2NvbnN0IHQ9ZS5sZW5ndGg7bGV0IHI9MDtmb3IobGV0IGE9MDthPHQ7YSsrKXI9TWF0aC5tYXgocixlW2FdLnByZWZpeExlbmd0aCk7Y29uc3QgYT1uZXcgVWludDMyQXJyYXkocisxKTtmb3IobGV0IHI9MDtyPHQ7cisrKWFbZVtyXS5wcmVmaXhMZW5ndGhdKys7bGV0IG4saSxzLG89MSxjPTA7YVswXT0wO2Zvcig7bzw9cjspe2M9YythW28tMV08PDE7bj1jO2k9MDtmb3IoO2k8dDspe3M9ZVtpXTtpZihzLnByZWZpeExlbmd0aD09PW8pe3MucHJlZml4Q29kZT1uO24rK31pKyt9bysrfX19Y29uc3QgYWE9e307ZnVuY3Rpb24gZ2V0U3RhbmRhcmRUYWJsZShlKXtsZXQgdCxyPWFhW2VdO2lmKHIpcmV0dXJuIHI7c3dpdGNoKGUpe2Nhc2UgMTp0PVtbMCwxLDQsMF0sWzE2LDIsOCwyXSxbMjcyLDMsMTYsNl0sWzY1ODA4LDMsMzIsN11dO2JyZWFrO2Nhc2UgMjp0PVtbMCwxLDAsMF0sWzEsMiwwLDJdLFsyLDMsMCw2XSxbMyw0LDMsMTRdLFsxMSw1LDYsMzBdLFs3NSw2LDMyLDYyXSxbNiw2M11dO2JyZWFrO2Nhc2UgMzp0PVtbLTI1Niw4LDgsMjU0XSxbMCwxLDAsMF0sWzEsMiwwLDJdLFsyLDMsMCw2XSxbMyw0LDMsMTRdLFsxMSw1LDYsMzBdLFstMjU3LDgsMzIsMjU1LCJsb3dlciJdLFs3NSw3LDMyLDEyNl0sWzYsNjJdXTticmVhaztjYXNlIDQ6dD1bWzEsMSwwLDBdLFsyLDIsMCwyXSxbMywzLDAsNl0sWzQsNCwzLDE0XSxbMTIsNSw2LDMwXSxbNzYsNSwzMiwzMV1dO2JyZWFrO2Nhc2UgNTp0PVtbLTI1NSw3LDgsMTI2XSxbMSwxLDAsMF0sWzIsMiwwLDJdLFszLDMsMCw2XSxbNCw0LDMsMTRdLFsxMiw1LDYsMzBdLFstMjU2LDcsMzIsMTI3LCJsb3dlciJdLFs3Niw2LDMyLDYyXV07YnJlYWs7Y2FzZSA2OnQ9W1stMjA0OCw1LDEwLDI4XSxbLTEwMjQsNCw5LDhdLFstNTEyLDQsOCw5XSxbLTI1Niw0LDcsMTBdLFstMTI4LDUsNiwyOV0sWy02NCw1LDUsMzBdLFstMzIsNCw1LDExXSxbMCwyLDcsMF0sWzEyOCwzLDcsMl0sWzI1NiwzLDgsM10sWzUxMiw0LDksMTJdLFsxMDI0LDQsMTAsMTNdLFstMjA0OSw2LDMyLDYyLCJsb3dlciJdLFsyMDQ4LDYsMzIsNjNdXTticmVhaztjYXNlIDc6dD1bWy0xMDI0LDQsOSw4XSxbLTUxMiwzLDgsMF0sWy0yNTYsNCw3LDldLFstMTI4LDUsNiwyNl0sWy02NCw1LDUsMjddLFstMzIsNCw1LDEwXSxbMCw0LDUsMTFdLFszMiw1LDUsMjhdLFs2NCw1LDYsMjldLFsxMjgsNCw3LDEyXSxbMjU2LDMsOCwxXSxbNTEyLDMsOSwyXSxbMTAyNCwzLDEwLDNdLFstMTAyNSw1LDMyLDMwLCJsb3dlciJdLFsyMDQ4LDUsMzIsMzFdXTticmVhaztjYXNlIDg6dD1bWy0xNSw4LDMsMjUyXSxbLTcsOSwxLDUwOF0sWy01LDgsMSwyNTNdLFstMyw5LDAsNTA5XSxbLTIsNywwLDEyNF0sWy0xLDQsMCwxMF0sWzAsMiwxLDBdLFsyLDUsMCwyNl0sWzMsNiwwLDU4XSxbNCwzLDQsNF0sWzIwLDYsMSw1OV0sWzIyLDQsNCwxMV0sWzM4LDQsNSwxMl0sWzcwLDUsNiwyN10sWzEzNCw1LDcsMjhdLFsyNjIsNiw3LDYwXSxbMzkwLDcsOCwxMjVdLFs2NDYsNiwxMCw2MV0sWy0xNiw5LDMyLDUxMCwibG93ZXIiXSxbMTY3MCw5LDMyLDUxMV0sWzIsMV1dO2JyZWFrO2Nhc2UgOTp0PVtbLTMxLDgsNCwyNTJdLFstMTUsOSwyLDUwOF0sWy0xMSw4LDIsMjUzXSxbLTcsOSwxLDUwOV0sWy01LDcsMSwxMjRdLFstMyw0LDEsMTBdLFstMSwzLDEsMl0sWzEsMywxLDNdLFszLDUsMSwyNl0sWzUsNiwxLDU4XSxbNywzLDUsNF0sWzM5LDYsMiw1OV0sWzQzLDQsNSwxMV0sWzc1LDQsNiwxMl0sWzEzOSw1LDcsMjddLFsyNjcsNSw4LDI4XSxbNTIzLDYsOCw2MF0sWzc3OSw3LDksMTI1XSxbMTI5MSw2LDExLDYxXSxbLTMyLDksMzIsNTEwLCJsb3dlciJdLFszMzM5LDksMzIsNTExXSxbMiwwXV07YnJlYWs7Y2FzZSAxMDp0PVtbLTIxLDcsNCwxMjJdLFstNSw4LDAsMjUyXSxbLTQsNywwLDEyM10sWy0zLDUsMCwyNF0sWy0yLDIsMiwwXSxbMiw1LDAsMjVdLFszLDYsMCw1NF0sWzQsNywwLDEyNF0sWzUsOCwwLDI1M10sWzYsMiw2LDFdLFs3MCw1LDUsMjZdLFsxMDIsNiw1LDU1XSxbMTM0LDYsNiw1Nl0sWzE5OCw2LDcsNTddLFszMjYsNiw4LDU4XSxbNTgyLDYsOSw1OV0sWzEwOTQsNiwxMCw2MF0sWzIxMTgsNywxMSwxMjVdLFstMjIsOCwzMiwyNTQsImxvd2VyIl0sWzQxNjYsOCwzMiwyNTVdLFsyLDJdXTticmVhaztjYXNlIDExOnQ9W1sxLDEsMCwwXSxbMiwyLDEsMl0sWzQsNCwwLDEyXSxbNSw0LDEsMTNdLFs3LDUsMSwyOF0sWzksNSwyLDI5XSxbMTMsNiwyLDYwXSxbMTcsNywyLDEyMl0sWzIxLDcsMywxMjNdLFsyOSw3LDQsMTI0XSxbNDUsNyw1LDEyNV0sWzc3LDcsNiwxMjZdLFsxNDEsNywzMiwxMjddXTticmVhaztjYXNlIDEyOnQ9W1sxLDEsMCwwXSxbMiwyLDAsMl0sWzMsMywxLDZdLFs1LDUsMCwyOF0sWzYsNSwxLDI5XSxbOCw2LDEsNjBdLFsxMCw3LDAsMTIyXSxbMTEsNywxLDEyM10sWzEzLDcsMiwxMjRdLFsxNyw3LDMsMTI1XSxbMjUsNyw0LDEyNl0sWzQxLDgsNSwyNTRdLFs3Myw4LDMyLDI1NV1dO2JyZWFrO2Nhc2UgMTM6dD1bWzEsMSwwLDBdLFsyLDMsMCw0XSxbMyw0LDAsMTJdLFs0LDUsMCwyOF0sWzUsNCwxLDEzXSxbNywzLDMsNV0sWzE1LDYsMSw1OF0sWzE3LDYsMiw1OV0sWzIxLDYsMyw2MF0sWzI5LDYsNCw2MV0sWzQ1LDYsNSw2Ml0sWzc3LDcsNiwxMjZdLFsxNDEsNywzMiwxMjddXTticmVhaztjYXNlIDE0OnQ9W1stMiwzLDAsNF0sWy0xLDMsMCw1XSxbMCwxLDAsMF0sWzEsMywwLDZdLFsyLDMsMCw3XV07YnJlYWs7Y2FzZSAxNTp0PVtbLTI0LDcsNCwxMjRdLFstOCw2LDIsNjBdLFstNCw1LDEsMjhdLFstMiw0LDAsMTJdLFstMSwzLDAsNF0sWzAsMSwwLDBdLFsxLDMsMCw1XSxbMiw0LDAsMTNdLFszLDUsMSwyOV0sWzUsNiwyLDYxXSxbOSw3LDQsMTI1XSxbLTI1LDcsMzIsMTI2LCJsb3dlciJdLFsyNSw3LDMyLDEyN11dO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEpiaWcyRXJyb3IoYHN0YW5kYXJkIHRhYmxlIEIuJHtlfSBkb2VzIG5vdCBleGlzdGApfWZvcihsZXQgZT0wLHI9dC5sZW5ndGg7ZTxyO2UrKyl0W2VdPW5ldyBIdWZmbWFuTGluZSh0W2VdKTtyPW5ldyBIdWZmbWFuVGFibGUodCwhMCk7YWFbZV09cjtyZXR1cm4gcn1jbGFzcyBSZWFkZXJ7Y29uc3RydWN0b3IoZSx0LHIpe3RoaXMuZGF0YT1lO3RoaXMuc3RhcnQ9dDt0aGlzLmVuZD1yO3RoaXMucG9zaXRpb249dDt0aGlzLnNoaWZ0PS0xO3RoaXMuY3VycmVudEJ5dGU9MH1yZWFkQml0KCl7aWYodGhpcy5zaGlmdDwwKXtpZih0aGlzLnBvc2l0aW9uPj10aGlzLmVuZCl0aHJvdyBuZXcgSmJpZzJFcnJvcigiZW5kIG9mIGRhdGEgd2hpbGUgcmVhZGluZyBiaXQiKTt0aGlzLmN1cnJlbnRCeXRlPXRoaXMuZGF0YVt0aGlzLnBvc2l0aW9uKytdO3RoaXMuc2hpZnQ9N31jb25zdCBlPXRoaXMuY3VycmVudEJ5dGU+PnRoaXMuc2hpZnQmMTt0aGlzLnNoaWZ0LS07cmV0dXJuIGV9cmVhZEJpdHMoZSl7bGV0IHQscj0wO2Zvcih0PWUtMTt0Pj0wO3QtLSlyfD10aGlzLnJlYWRCaXQoKTw8dDtyZXR1cm4gcn1ieXRlQWxpZ24oKXt0aGlzLnNoaWZ0PS0xfW5leHQoKXtyZXR1cm4gdGhpcy5wb3NpdGlvbj49dGhpcy5lbmQ/LTE6dGhpcy5kYXRhW3RoaXMucG9zaXRpb24rK119fWZ1bmN0aW9uIGdldEN1c3RvbUh1ZmZtYW5UYWJsZShlLHQscil7bGV0IGE9MDtmb3IobGV0IG49MCxpPXQubGVuZ3RoO248aTtuKyspe2NvbnN0IGk9clt0W25dXTtpZihpKXtpZihlPT09YSlyZXR1cm4gaTthKyt9fXRocm93IG5ldyBKYmlnMkVycm9yKCJjYW4ndCBmaW5kIGN1c3RvbSBIdWZmbWFuIHRhYmxlIil9ZnVuY3Rpb24gcmVhZFVuY29tcHJlc3NlZEJpdG1hcChlLHQscil7Y29uc3QgYT1bXTtmb3IobGV0IG49MDtuPHI7bisrKXtjb25zdCByPW5ldyBVaW50OEFycmF5KHQpO2EucHVzaChyKTtmb3IobGV0IGE9MDthPHQ7YSsrKXJbYV09ZS5yZWFkQml0KCk7ZS5ieXRlQWxpZ24oKX1yZXR1cm4gYX1mdW5jdGlvbiBkZWNvZGVNTVJCaXRtYXAoZSx0LHIsYSl7Y29uc3Qgbj1uZXcgQ0NJVFRGYXhEZWNvZGVyKGUse0s6LTEsQ29sdW1uczp0LFJvd3M6cixCbGFja0lzMTohMCxFbmRPZkJsb2NrOmF9KSxpPVtdO2xldCBzLG89ITE7Zm9yKGxldCBlPTA7ZTxyO2UrKyl7Y29uc3QgZT1uZXcgVWludDhBcnJheSh0KTtpLnB1c2goZSk7bGV0IHI9LTE7Zm9yKGxldCBhPTA7YTx0O2ErKyl7aWYocjwwKXtzPW4ucmVhZE5leHRDaGFyKCk7aWYoLTE9PT1zKXtzPTA7bz0hMH1yPTd9ZVthXT1zPj5yJjE7ci0tfX1pZihhJiYhbyl7Y29uc3QgZT01O2ZvcihsZXQgdD0wO3Q8ZSYmLTEhPT1uLnJlYWROZXh0Q2hhcigpO3QrKyk7fXJldHVybiBpfWNsYXNzIEpiaWcySW1hZ2V7cGFyc2VDaHVua3MoZSl7cmV0dXJuIGZ1bmN0aW9uIHBhcnNlSmJpZzJDaHVua3MoZSl7Y29uc3QgdD1uZXcgU2ltcGxlU2VnbWVudFZpc2l0b3I7Zm9yKGxldCByPTAsYT1lLmxlbmd0aDtyPGE7cisrKXtjb25zdCBhPWVbcl07cHJvY2Vzc1NlZ21lbnRzKHJlYWRTZWdtZW50cyh7fSxhLmRhdGEsYS5zdGFydCxhLmVuZCksdCl9cmV0dXJuIHQuYnVmZmVyfShlKX1wYXJzZShlKXt0aHJvdyBuZXcgRXJyb3IoIk5vdCBpbXBsZW1lbnRlZDogSmJpZzJJbWFnZS5wYXJzZSIpfX1jbGFzcyBKYmlnMlN0cmVhbSBleHRlbmRzIERlY29kZVN0cmVhbXtjb25zdHJ1Y3RvcihlLHQscil7c3VwZXIodCk7dGhpcy5zdHJlYW09ZTt0aGlzLmRpY3Q9ZS5kaWN0O3RoaXMubWF5YmVMZW5ndGg9dDt0aGlzLnBhcmFtcz1yfWdldCBieXRlcygpe3JldHVybiBzaGFkb3codGhpcywiYnl0ZXMiLHRoaXMuc3RyZWFtLmdldEJ5dGVzKHRoaXMubWF5YmVMZW5ndGgpKX1lbnN1cmVCdWZmZXIoZSl7fXJlYWRCbG9jaygpe3RoaXMuZGVjb2RlSW1hZ2UoKX1kZWNvZGVJbWFnZShlKXtpZih0aGlzLmVvZilyZXR1cm4gdGhpcy5idWZmZXI7ZXx8PXRoaXMuYnl0ZXM7Y29uc3QgdD1uZXcgSmJpZzJJbWFnZSxyPVtdO2lmKHRoaXMucGFyYW1zIGluc3RhbmNlb2YgRGljdCl7Y29uc3QgZT10aGlzLnBhcmFtcy5nZXQoIkpCSUcyR2xvYmFscyIpO2lmKGUgaW5zdGFuY2VvZiBCYXNlU3RyZWFtKXtjb25zdCB0PWUuZ2V0Qnl0ZXMoKTtyLnB1c2goe2RhdGE6dCxzdGFydDowLGVuZDp0Lmxlbmd0aH0pfX1yLnB1c2goe2RhdGE6ZSxzdGFydDowLGVuZDplLmxlbmd0aH0pO2NvbnN0IGE9dC5wYXJzZUNodW5rcyhyKSxuPWEubGVuZ3RoO2ZvcihsZXQgZT0wO2U8bjtlKyspYVtlXV49MjU1O3RoaXMuYnVmZmVyPWE7dGhpcy5idWZmZXJMZW5ndGg9bjt0aGlzLmVvZj0hMDtyZXR1cm4gdGhpcy5idWZmZXJ9Z2V0IGNhbkFzeW5jRGVjb2RlSW1hZ2VGcm9tQnVmZmVyKCl7cmV0dXJuIHRoaXMuc3RyZWFtLmlzQXN5bmN9fWNsYXNzIEpweFN0cmVhbSBleHRlbmRzIERlY29kZVN0cmVhbXtjb25zdHJ1Y3RvcihlLHQscil7c3VwZXIodCk7dGhpcy5zdHJlYW09ZTt0aGlzLmRpY3Q9ZS5kaWN0O3RoaXMubWF5YmVMZW5ndGg9dDt0aGlzLnBhcmFtcz1yfWdldCBieXRlcygpe3JldHVybiBzaGFkb3codGhpcywiYnl0ZXMiLHRoaXMuc3RyZWFtLmdldEJ5dGVzKHRoaXMubWF5YmVMZW5ndGgpKX1lbnN1cmVCdWZmZXIoZSl7fXJlYWRCbG9jayhlKXt1bnJlYWNoYWJsZSgiSnB4U3RyZWFtLnJlYWRCbG9jayIpfWdldCBpc0FzeW5jRGVjb2Rlcigpe3JldHVybiEwfWFzeW5jIGRlY29kZUltYWdlKGUsdCl7aWYodGhpcy5lb2YpcmV0dXJuIHRoaXMuYnVmZmVyO2V8fD10aGlzLmJ5dGVzO3RoaXMuYnVmZmVyPWF3YWl0IEpweEltYWdlLmRlY29kZShlLHQpO3RoaXMuYnVmZmVyTGVuZ3RoPXRoaXMuYnVmZmVyLmxlbmd0aDt0aGlzLmVvZj0hMDtyZXR1cm4gdGhpcy5idWZmZXJ9Z2V0IGNhbkFzeW5jRGVjb2RlSW1hZ2VGcm9tQnVmZmVyKCl7cmV0dXJuIHRoaXMuc3RyZWFtLmlzQXN5bmN9fWNsYXNzIExaV1N0cmVhbSBleHRlbmRzIERlY29kZVN0cmVhbXtjb25zdHJ1Y3RvcihlLHQscil7c3VwZXIodCk7dGhpcy5zdHI9ZTt0aGlzLmRpY3Q9ZS5kaWN0O3RoaXMuY2FjaGVkRGF0YT0wO3RoaXMuYml0c0NhY2hlZD0wO2NvbnN0IGE9NDA5NixuPXtlYXJseUNoYW5nZTpyLGNvZGVMZW5ndGg6OSxuZXh0Q29kZToyNTgsZGljdGlvbmFyeVZhbHVlczpuZXcgVWludDhBcnJheShhKSxkaWN0aW9uYXJ5TGVuZ3RoczpuZXcgVWludDE2QXJyYXkoYSksZGljdGlvbmFyeVByZXZDb2RlczpuZXcgVWludDE2QXJyYXkoYSksY3VycmVudFNlcXVlbmNlOm5ldyBVaW50OEFycmF5KGEpLGN1cnJlbnRTZXF1ZW5jZUxlbmd0aDowfTtmb3IobGV0IGU9MDtlPDI1NjsrK2Upe24uZGljdGlvbmFyeVZhbHVlc1tlXT1lO24uZGljdGlvbmFyeUxlbmd0aHNbZV09MX10aGlzLmx6d1N0YXRlPW59cmVhZEJpdHMoZSl7bGV0IHQ9dGhpcy5iaXRzQ2FjaGVkLHI9dGhpcy5jYWNoZWREYXRhO2Zvcig7dDxlOyl7Y29uc3QgZT10aGlzLnN0ci5nZXRCeXRlKCk7aWYoLTE9PT1lKXt0aGlzLmVvZj0hMDtyZXR1cm4gbnVsbH1yPXI8PDh8ZTt0Kz04fXRoaXMuYml0c0NhY2hlZD10LT1lO3RoaXMuY2FjaGVkRGF0YT1yO3RoaXMubGFzdENvZGU9bnVsbDtyZXR1cm4gcj4+PnQmKDE8PGUpLTF9cmVhZEJsb2NrKCl7bGV0IGUsdCxyLGE9MTAyNDtjb25zdCBuPXRoaXMubHp3U3RhdGU7aWYoIW4pcmV0dXJuO2NvbnN0IGk9bi5lYXJseUNoYW5nZTtsZXQgcz1uLm5leHRDb2RlO2NvbnN0IG89bi5kaWN0aW9uYXJ5VmFsdWVzLGM9bi5kaWN0aW9uYXJ5TGVuZ3RocyxsPW4uZGljdGlvbmFyeVByZXZDb2RlcztsZXQgaD1uLmNvZGVMZW5ndGgsdT1uLnByZXZDb2RlO2NvbnN0IGQ9bi5jdXJyZW50U2VxdWVuY2U7bGV0IGY9bi5jdXJyZW50U2VxdWVuY2VMZW5ndGgsZz0wLHA9dGhpcy5idWZmZXJMZW5ndGgsbT10aGlzLmVuc3VyZUJ1ZmZlcih0aGlzLmJ1ZmZlckxlbmd0aCthKTtmb3IoZT0wO2U8NTEyO2UrKyl7Y29uc3QgZT10aGlzLnJlYWRCaXRzKGgpLG49Zj4wO2lmKGU8MjU2KXtkWzBdPWU7Zj0xfWVsc2V7aWYoIShlPj0yNTgpKXtpZigyNTY9PT1lKXtoPTk7cz0yNTg7Zj0wO2NvbnRpbnVlfXRoaXMuZW9mPSEwO2RlbGV0ZSB0aGlzLmx6d1N0YXRlO2JyZWFrfWlmKGU8cyl7Zj1jW2VdO2Zvcih0PWYtMSxyPWU7dD49MDt0LS0pe2RbdF09b1tyXTtyPWxbcl19fWVsc2UgZFtmKytdPWRbMF19aWYobil7bFtzXT11O2Nbc109Y1t1XSsxO29bc109ZFswXTtzKys7aD1zK2kmcytpLTE/aDowfE1hdGgubWluKE1hdGgubG9nKHMraSkvLjY5MzE0NzE4MDU1OTk0NTMrMSwxMil9dT1lO2crPWY7aWYoYTxnKXtkb3thKz01MTJ9d2hpbGUoYTxnKTttPXRoaXMuZW5zdXJlQnVmZmVyKHRoaXMuYnVmZmVyTGVuZ3RoK2EpfWZvcih0PTA7dDxmO3QrKyltW3ArK109ZFt0XX1uLm5leHRDb2RlPXM7bi5jb2RlTGVuZ3RoPWg7bi5wcmV2Q29kZT11O24uY3VycmVudFNlcXVlbmNlTGVuZ3RoPWY7dGhpcy5idWZmZXJMZW5ndGg9cH19Y2xhc3MgUHJlZGljdG9yU3RyZWFtIGV4dGVuZHMgRGVjb2RlU3RyZWFte2NvbnN0cnVjdG9yKGUsdCxyKXtzdXBlcih0KTtpZighKHIgaW5zdGFuY2VvZiBEaWN0KSlyZXR1cm4gZTtjb25zdCBhPXRoaXMucHJlZGljdG9yPXIuZ2V0KCJQcmVkaWN0b3IiKXx8MTtpZihhPD0xKXJldHVybiBlO2lmKDIhPT1hJiYoYTwxMHx8YT4xNSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKGBVbnN1cHBvcnRlZCBwcmVkaWN0b3I6ICR7YX1gKTt0aGlzLnJlYWRCbG9jaz0yPT09YT90aGlzLnJlYWRCbG9ja1RpZmY6dGhpcy5yZWFkQmxvY2tQbmc7dGhpcy5zdHI9ZTt0aGlzLmRpY3Q9ZS5kaWN0O2NvbnN0IG49dGhpcy5jb2xvcnM9ci5nZXQoIkNvbG9ycyIpfHwxLGk9dGhpcy5iaXRzPXIuZ2V0KCJCUEMiLCJCaXRzUGVyQ29tcG9uZW50Iil8fDgscz10aGlzLmNvbHVtbnM9ci5nZXQoIkNvbHVtbnMiKXx8MTt0aGlzLnBpeEJ5dGVzPW4qaSs3Pj4zO3RoaXMucm93Qnl0ZXM9cypuKmkrNz4+MztyZXR1cm4gdGhpc31yZWFkQmxvY2tUaWZmKCl7Y29uc3QgZT10aGlzLnJvd0J5dGVzLHQ9dGhpcy5idWZmZXJMZW5ndGgscj10aGlzLmVuc3VyZUJ1ZmZlcih0K2UpLGE9dGhpcy5iaXRzLG49dGhpcy5jb2xvcnMsaT10aGlzLnN0ci5nZXRCeXRlcyhlKTt0aGlzLmVvZj0haS5sZW5ndGg7aWYodGhpcy5lb2YpcmV0dXJuO2xldCBzLG89MCxjPTAsbD0wLGg9MCx1PXQ7aWYoMT09PWEmJjE9PT1uKWZvcihzPTA7czxlOysrcyl7bGV0IGU9aVtzXV5vO2VePWU+PjE7ZV49ZT4+MjtlXj1lPj40O289KDEmZSk8PDc7clt1KytdPWV9ZWxzZSBpZig4PT09YSl7Zm9yKHM9MDtzPG47KytzKXJbdSsrXT1pW3NdO2Zvcig7czxlOysrcyl7clt1XT1yW3Utbl0raVtzXTt1Kyt9fWVsc2UgaWYoMTY9PT1hKXtjb25zdCB0PTIqbjtmb3Iocz0wO3M8dDsrK3Mpclt1KytdPWlbc107Zm9yKDtzPGU7cys9Mil7Y29uc3QgZT0oKDI1NSZpW3NdKTw8OCkrKDI1NSZpW3MrMV0pKygoMjU1JnJbdS10XSk8PDgpKygyNTUmclt1LXQrMV0pO3JbdSsrXT1lPj44JjI1NTtyW3UrK109MjU1JmV9fWVsc2V7Y29uc3QgZT1uZXcgVWludDhBcnJheShuKzEpLHU9KDE8PGEpLTE7bGV0IGQ9MCxmPXQ7Y29uc3QgZz10aGlzLmNvbHVtbnM7Zm9yKHM9MDtzPGc7KytzKWZvcihsZXQgdD0wO3Q8bjsrK3Qpe2lmKGw8YSl7bz1vPDw4fDI1NSZpW2QrK107bCs9OH1lW3RdPWVbdF0rKG8+PmwtYSkmdTtsLT1hO2M9Yzw8YXxlW3RdO2grPWE7aWYoaD49OCl7cltmKytdPWM+PmgtOCYyNTU7aC09OH19aD4wJiYocltmKytdPShjPDw4LWgpKyhvJigxPDw4LWgpLTEpKX10aGlzLmJ1ZmZlckxlbmd0aCs9ZX1yZWFkQmxvY2tQbmcoKXtjb25zdCBlPXRoaXMucm93Qnl0ZXMsdD10aGlzLnBpeEJ5dGVzLHI9dGhpcy5zdHIuZ2V0Qnl0ZSgpLGE9dGhpcy5zdHIuZ2V0Qnl0ZXMoZSk7dGhpcy5lb2Y9IWEubGVuZ3RoO2lmKHRoaXMuZW9mKXJldHVybjtjb25zdCBuPXRoaXMuYnVmZmVyTGVuZ3RoLGk9dGhpcy5lbnN1cmVCdWZmZXIobitlKTtsZXQgcz1pLnN1YmFycmF5KG4tZSxuKTswPT09cy5sZW5ndGgmJihzPW5ldyBVaW50OEFycmF5KGUpKTtsZXQgbyxjLGwsaD1uO3N3aXRjaChyKXtjYXNlIDA6Zm9yKG89MDtvPGU7KytvKWlbaCsrXT1hW29dO2JyZWFrO2Nhc2UgMTpmb3Iobz0wO288dDsrK28paVtoKytdPWFbb107Zm9yKDtvPGU7KytvKXtpW2hdPWlbaC10XSthW29dJjI1NTtoKyt9YnJlYWs7Y2FzZSAyOmZvcihvPTA7bzxlOysrbylpW2grK109c1tvXSthW29dJjI1NTticmVhaztjYXNlIDM6Zm9yKG89MDtvPHQ7KytvKWlbaCsrXT0oc1tvXT4+MSkrYVtvXTtmb3IoO288ZTsrK28pe2lbaF09KHNbb10raVtoLXRdPj4xKSthW29dJjI1NTtoKyt9YnJlYWs7Y2FzZSA0OmZvcihvPTA7bzx0Oysrbyl7Yz1zW29dO2w9YVtvXTtpW2grK109YytsfWZvcig7bzxlOysrbyl7Yz1zW29dO2NvbnN0IGU9c1tvLXRdLHI9aVtoLXRdLG49citjLWU7bGV0IHU9bi1yO3U8MCYmKHU9LXUpO2xldCBkPW4tYztkPDAmJihkPS1kKTtsZXQgZj1uLWU7ZjwwJiYoZj0tZik7bD1hW29dO2lbaCsrXT11PD1kJiZ1PD1mP3IrbDpkPD1mP2MrbDplK2x9YnJlYWs7ZGVmYXVsdDp0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYFVuc3VwcG9ydGVkIHByZWRpY3RvcjogJHtyfWApfXRoaXMuYnVmZmVyTGVuZ3RoKz1lfX1jbGFzcyBSdW5MZW5ndGhTdHJlYW0gZXh0ZW5kcyBEZWNvZGVTdHJlYW17Y29uc3RydWN0b3IoZSx0KXtzdXBlcih0KTt0aGlzLnN0cj1lO3RoaXMuZGljdD1lLmRpY3R9cmVhZEJsb2NrKCl7Y29uc3QgZT10aGlzLnN0ci5nZXRCeXRlcygyKTtpZighZXx8ZS5sZW5ndGg8Mnx8MTI4PT09ZVswXSl7dGhpcy5lb2Y9ITA7cmV0dXJufWxldCB0LHI9dGhpcy5idWZmZXJMZW5ndGgsYT1lWzBdO2lmKGE8MTI4KXt0PXRoaXMuZW5zdXJlQnVmZmVyKHIrYSsxKTt0W3IrK109ZVsxXTtpZihhPjApe2NvbnN0IGU9dGhpcy5zdHIuZ2V0Qnl0ZXMoYSk7dC5zZXQoZSxyKTtyKz1hfX1lbHNle2E9MjU3LWE7dD10aGlzLmVuc3VyZUJ1ZmZlcihyK2ErMSk7dC5maWxsKGVbMV0scixyK2EpO3IrPWF9dGhpcy5idWZmZXJMZW5ndGg9cn19Y2xhc3MgUGFyc2Vye2NvbnN0cnVjdG9yKHtsZXhlcjplLHhyZWY6dCxhbGxvd1N0cmVhbXM6cj0hMSxyZWNvdmVyeU1vZGU6YT0hMX0pe3RoaXMubGV4ZXI9ZTt0aGlzLnhyZWY9dDt0aGlzLmFsbG93U3RyZWFtcz1yO3RoaXMucmVjb3ZlcnlNb2RlPWE7dGhpcy5pbWFnZUNhY2hlPU9iamVjdC5jcmVhdGUobnVsbCk7dGhpcy5faW1hZ2VJZD0wO3RoaXMucmVmaWxsKCl9cmVmaWxsKCl7dGhpcy5idWYxPXRoaXMubGV4ZXIuZ2V0T2JqKCk7dGhpcy5idWYyPXRoaXMubGV4ZXIuZ2V0T2JqKCl9c2hpZnQoKXtpZih0aGlzLmJ1ZjIgaW5zdGFuY2VvZiBDbWQmJiJJRCI9PT10aGlzLmJ1ZjIuY21kKXt0aGlzLmJ1ZjE9dGhpcy5idWYyO3RoaXMuYnVmMj1udWxsfWVsc2V7dGhpcy5idWYxPXRoaXMuYnVmMjt0aGlzLmJ1ZjI9dGhpcy5sZXhlci5nZXRPYmooKX19dHJ5U2hpZnQoKXt0cnl7dGhpcy5zaGlmdCgpO3JldHVybiEwfWNhdGNoKGUpe2lmKGUgaW5zdGFuY2VvZiBNaXNzaW5nRGF0YUV4Y2VwdGlvbil0aHJvdyBlO3JldHVybiExfX1nZXRPYmooZT1udWxsKXtjb25zdCB0PXRoaXMuYnVmMTt0aGlzLnNoaWZ0KCk7aWYodCBpbnN0YW5jZW9mIENtZClzd2l0Y2godC5jbWQpe2Nhc2UiQkkiOnJldHVybiB0aGlzLm1ha2VJbmxpbmVJbWFnZShlKTtjYXNlIlsiOmNvbnN0IHI9W107Zm9yKDshaXNDbWQodGhpcy5idWYxLCJdIikmJnRoaXMuYnVmMSE9PXNyOylyLnB1c2godGhpcy5nZXRPYmooZSkpO2lmKHRoaXMuYnVmMT09PXNyKXtpZih0aGlzLnJlY292ZXJ5TW9kZSlyZXR1cm4gcjt0aHJvdyBuZXcgUGFyc2VyRU9GRXhjZXB0aW9uKCJFbmQgb2YgZmlsZSBpbnNpZGUgYXJyYXkuIil9dGhpcy5zaGlmdCgpO3JldHVybiByO2Nhc2UiPDwiOmNvbnN0IGE9bmV3IERpY3QodGhpcy54cmVmKTtmb3IoOyFpc0NtZCh0aGlzLmJ1ZjEsIj4+IikmJnRoaXMuYnVmMSE9PXNyOyl7aWYoISh0aGlzLmJ1ZjEgaW5zdGFuY2VvZiBOYW1lKSl7aW5mbygiTWFsZm9ybWVkIGRpY3Rpb25hcnk6IGtleSBtdXN0IGJlIGEgbmFtZSBvYmplY3QiKTt0aGlzLnNoaWZ0KCk7Y29udGludWV9Y29uc3QgdD10aGlzLmJ1ZjEubmFtZTt0aGlzLnNoaWZ0KCk7aWYodGhpcy5idWYxPT09c3IpYnJlYWs7YS5zZXQodCx0aGlzLmdldE9iaihlKSl9aWYodGhpcy5idWYxPT09c3Ipe2lmKHRoaXMucmVjb3ZlcnlNb2RlKXJldHVybiBhO3Rocm93IG5ldyBQYXJzZXJFT0ZFeGNlcHRpb24oIkVuZCBvZiBmaWxlIGluc2lkZSBkaWN0aW9uYXJ5LiIpfWlmKGlzQ21kKHRoaXMuYnVmMiwic3RyZWFtIikpcmV0dXJuIHRoaXMuYWxsb3dTdHJlYW1zP3RoaXMubWFrZVN0cmVhbShhLGUpOmE7dGhpcy5zaGlmdCgpO3JldHVybiBhO2RlZmF1bHQ6cmV0dXJuIHR9aWYoTnVtYmVyLmlzSW50ZWdlcih0KSl7aWYoTnVtYmVyLmlzSW50ZWdlcih0aGlzLmJ1ZjEpJiZpc0NtZCh0aGlzLmJ1ZjIsIlIiKSl7Y29uc3QgZT1SZWYuZ2V0KHQsdGhpcy5idWYxKTt0aGlzLnNoaWZ0KCk7dGhpcy5zaGlmdCgpO3JldHVybiBlfXJldHVybiB0fXJldHVybiJzdHJpbmciPT10eXBlb2YgdCYmZT9lLmRlY3J5cHRTdHJpbmcodCk6dH1maW5kRGVmYXVsdElubGluZVN0cmVhbUVuZChlKXtjb25zdHtrbm93bkNvbW1hbmRzOnR9PXRoaXMubGV4ZXIscj1lLnBvcztsZXQgYSxuLGk9MDtmb3IoOy0xIT09KGE9ZS5nZXRCeXRlKCkpOylpZigwPT09aSlpPTY5PT09YT8xOjA7ZWxzZSBpZigxPT09aSlpPTczPT09YT8yOjA7ZWxzZSBpZigzMj09PWF8fDEwPT09YXx8MTM9PT1hKXtuPWUucG9zO2NvbnN0IHI9ZS5wZWVrQnl0ZXMoMTUpLHM9ci5sZW5ndGg7aWYoMD09PXMpYnJlYWs7Zm9yKGxldCBlPTA7ZTxzO2UrKyl7YT1yW2VdO2lmKCgwIT09YXx8MD09PXJbZSsxXSkmJigxMCE9PWEmJjEzIT09YSYmKGE8MzJ8fGE+MTI3KSkpe2k9MDticmVha319aWYoMiE9PWkpY29udGludWU7aWYoIXQpe3dhcm4oImZpbmREZWZhdWx0SW5saW5lU3RyZWFtRW5kIC0gYGxleGVyLmtub3duQ29tbWFuZHNgIGlzIHVuZGVmaW5lZC4iKTtjb250aW51ZX1jb25zdCBvPW5ldyBMZXhlcihuZXcgU3RyZWFtKGUucGVla0J5dGVzKDc1KSksdCk7by5faGV4U3RyaW5nV2Fybj0oKT0+e307bGV0IGM9MDtmb3IoOzspe2NvbnN0IGU9by5nZXRPYmooKTtpZihlPT09c3Ipe2k9MDticmVha31pZihlIGluc3RhbmNlb2YgQ21kKXtjb25zdCByPXRbZS5jbWRdO2lmKCFyKXtpPTA7YnJlYWt9aWYoci52YXJpYWJsZUFyZ3M/Yzw9ci5udW1BcmdzOmM9PT1yLm51bUFyZ3MpYnJlYWs7Yz0wO2NvbnRpbnVlfWMrK31pZigyPT09aSlicmVha31lbHNlIGk9MDtpZigtMT09PWEpe3dhcm4oImZpbmREZWZhdWx0SW5saW5lU3RyZWFtRW5kOiBSZWFjaGVkIHRoZSBlbmQgb2YgdGhlIHN0cmVhbSB3aXRob3V0IGZpbmRpbmcgYSB2YWxpZCBFSSBtYXJrZXIiKTtpZihuKXt3YXJuKCcuLi4gdHJ5aW5nIHRvIHJlY292ZXIgYnkgdXNpbmcgdGhlIGxhc3QgIkVJIiBvY2N1cnJlbmNlLicpO2Uuc2tpcCgtKGUucG9zLW4pKX19bGV0IHM9NDtlLnNraXAoLXMpO2E9ZS5wZWVrQnl0ZSgpO2Uuc2tpcChzKTtpc1doaXRlU3BhY2UoYSl8fHMtLTtyZXR1cm4gZS5wb3Mtcy1yfWZpbmREQ1REZWNvZGVJbmxpbmVTdHJlYW1FbmQoZSl7Y29uc3QgdD1lLnBvcztsZXQgcixhLG49ITE7Zm9yKDstMSE9PShyPWUuZ2V0Qnl0ZSgpKTspaWYoMjU1PT09cil7c3dpdGNoKGUuZ2V0Qnl0ZSgpKXtjYXNlIDA6YnJlYWs7Y2FzZSAyNTU6ZS5za2lwKC0xKTticmVhaztjYXNlIDIxNzpuPSEwO2JyZWFrO2Nhc2UgMTkyOmNhc2UgMTkzOmNhc2UgMTk0OmNhc2UgMTk1OmNhc2UgMTk3OmNhc2UgMTk4OmNhc2UgMTk5OmNhc2UgMjAxOmNhc2UgMjAyOmNhc2UgMjAzOmNhc2UgMjA1OmNhc2UgMjA2OmNhc2UgMjA3OmNhc2UgMTk2OmNhc2UgMjA0OmNhc2UgMjE4OmNhc2UgMjE5OmNhc2UgMjIwOmNhc2UgMjIxOmNhc2UgMjIyOmNhc2UgMjIzOmNhc2UgMjI0OmNhc2UgMjI1OmNhc2UgMjI2OmNhc2UgMjI3OmNhc2UgMjI4OmNhc2UgMjI5OmNhc2UgMjMwOmNhc2UgMjMxOmNhc2UgMjMyOmNhc2UgMjMzOmNhc2UgMjM0OmNhc2UgMjM1OmNhc2UgMjM2OmNhc2UgMjM3OmNhc2UgMjM4OmNhc2UgMjM5OmNhc2UgMjU0OmE9ZS5nZXRVaW50MTYoKTthPjI/ZS5za2lwKGEtMik6ZS5za2lwKC0yKX1pZihuKWJyZWFrfWNvbnN0IGk9ZS5wb3MtdDtpZigtMT09PXIpe3dhcm4oIklubGluZSBEQ1REZWNvZGUgaW1hZ2Ugc3RyZWFtOiBFT0kgbWFya2VyIG5vdCBmb3VuZCwgc2VhcmNoaW5nIGZvciAvRUkvIGluc3RlYWQuIik7ZS5za2lwKC1pKTtyZXR1cm4gdGhpcy5maW5kRGVmYXVsdElubGluZVN0cmVhbUVuZChlKX10aGlzLmlubGluZVN0cmVhbVNraXBFSShlKTtyZXR1cm4gaX1maW5kQVNDSUk4NURlY29kZUlubGluZVN0cmVhbUVuZChlKXtjb25zdCB0PWUucG9zO2xldCByO2Zvcig7LTEhPT0ocj1lLmdldEJ5dGUoKSk7KWlmKDEyNj09PXIpe2NvbnN0IHQ9ZS5wb3M7cj1lLnBlZWtCeXRlKCk7Zm9yKDtpc1doaXRlU3BhY2Uocik7KXtlLnNraXAoKTtyPWUucGVla0J5dGUoKX1pZig2Mj09PXIpe2Uuc2tpcCgpO2JyZWFrfWlmKGUucG9zPnQpe2NvbnN0IHQ9ZS5wZWVrQnl0ZXMoMik7aWYoNjk9PT10WzBdJiY3Mz09PXRbMV0pYnJlYWt9fWNvbnN0IGE9ZS5wb3MtdDtpZigtMT09PXIpe3dhcm4oIklubGluZSBBU0NJSTg1RGVjb2RlIGltYWdlIHN0cmVhbTogRU9EIG1hcmtlciBub3QgZm91bmQsIHNlYXJjaGluZyBmb3IgL0VJLyBpbnN0ZWFkLiIpO2Uuc2tpcCgtYSk7cmV0dXJuIHRoaXMuZmluZERlZmF1bHRJbmxpbmVTdHJlYW1FbmQoZSl9dGhpcy5pbmxpbmVTdHJlYW1Ta2lwRUkoZSk7cmV0dXJuIGF9ZmluZEFTQ0lJSGV4RGVjb2RlSW5saW5lU3RyZWFtRW5kKGUpe2NvbnN0IHQ9ZS5wb3M7bGV0IHI7Zm9yKDstMSE9PShyPWUuZ2V0Qnl0ZSgpKSYmNjIhPT1yOyk7Y29uc3QgYT1lLnBvcy10O2lmKC0xPT09cil7d2FybigiSW5saW5lIEFTQ0lJSGV4RGVjb2RlIGltYWdlIHN0cmVhbTogRU9EIG1hcmtlciBub3QgZm91bmQsIHNlYXJjaGluZyBmb3IgL0VJLyBpbnN0ZWFkLiIpO2Uuc2tpcCgtYSk7cmV0dXJuIHRoaXMuZmluZERlZmF1bHRJbmxpbmVTdHJlYW1FbmQoZSl9dGhpcy5pbmxpbmVTdHJlYW1Ta2lwRUkoZSk7cmV0dXJuIGF9aW5saW5lU3RyZWFtU2tpcEVJKGUpe2xldCB0LHI9MDtmb3IoOy0xIT09KHQ9ZS5nZXRCeXRlKCkpOylpZigwPT09cilyPTY5PT09dD8xOjA7ZWxzZSBpZigxPT09cilyPTczPT09dD8yOjA7ZWxzZSBpZigyPT09cilicmVha31tYWtlSW5saW5lSW1hZ2UoZSl7Y29uc3QgdD10aGlzLmxleGVyLHI9dC5zdHJlYW0sYT1PYmplY3QuY3JlYXRlKG51bGwpO2xldCBuO2Zvcig7IWlzQ21kKHRoaXMuYnVmMSwiSUQiKSYmdGhpcy5idWYxIT09c3I7KXtpZighKHRoaXMuYnVmMSBpbnN0YW5jZW9mIE5hbWUpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiRGljdGlvbmFyeSBrZXkgbXVzdCBiZSBhIG5hbWUgb2JqZWN0Iik7Y29uc3QgdD10aGlzLmJ1ZjEubmFtZTt0aGlzLnNoaWZ0KCk7aWYodGhpcy5idWYxPT09c3IpYnJlYWs7YVt0XT10aGlzLmdldE9iaihlKX0tMSE9PXQuYmVnaW5JbmxpbmVJbWFnZVBvcyYmKG49ci5wb3MtdC5iZWdpbklubGluZUltYWdlUG9zKTtjb25zdCBpPXRoaXMueHJlZi5mZXRjaElmUmVmKGEuRnx8YS5GaWx0ZXIpO2xldCBzO2lmKGkgaW5zdGFuY2VvZiBOYW1lKXM9aS5uYW1lO2Vsc2UgaWYoQXJyYXkuaXNBcnJheShpKSl7Y29uc3QgZT10aGlzLnhyZWYuZmV0Y2hJZlJlZihpWzBdKTtlIGluc3RhbmNlb2YgTmFtZSYmKHM9ZS5uYW1lKX1jb25zdCBvPXIucG9zO2xldCBjLGw7c3dpdGNoKHMpe2Nhc2UiRENUIjpjYXNlIkRDVERlY29kZSI6Yz10aGlzLmZpbmREQ1REZWNvZGVJbmxpbmVTdHJlYW1FbmQocik7YnJlYWs7Y2FzZSJBODUiOmNhc2UiQVNDSUk4NURlY29kZSI6Yz10aGlzLmZpbmRBU0NJSTg1RGVjb2RlSW5saW5lU3RyZWFtRW5kKHIpO2JyZWFrO2Nhc2UiQUh4IjpjYXNlIkFTQ0lJSGV4RGVjb2RlIjpjPXRoaXMuZmluZEFTQ0lJSGV4RGVjb2RlSW5saW5lU3RyZWFtRW5kKHIpO2JyZWFrO2RlZmF1bHQ6Yz10aGlzLmZpbmREZWZhdWx0SW5saW5lU3RyZWFtRW5kKHIpfWlmKGM8MWUzJiZuPjApe2NvbnN0IGU9ci5wb3M7ci5wb3M9dC5iZWdpbklubGluZUltYWdlUG9zO2w9ZnVuY3Rpb24gZ2V0SW5saW5lSW1hZ2VDYWNoZUtleShlKXtjb25zdCB0PVtdLHI9ZS5sZW5ndGg7bGV0IGE9MDtmb3IoO2E8ci0xOyl0LnB1c2goZVthKytdPDw4fGVbYSsrXSk7YTxyJiZ0LnB1c2goZVthXSk7cmV0dXJuIHIrIl8iK1N0cmluZy5mcm9tQ2hhckNvZGUuYXBwbHkobnVsbCx0KX0oci5nZXRCeXRlcyhuK2MpKTtyLnBvcz1lO2NvbnN0IGE9dGhpcy5pbWFnZUNhY2hlW2xdO2lmKHZvaWQgMCE9PWEpe3RoaXMuYnVmMj1DbWQuZ2V0KCJFSSIpO3RoaXMuc2hpZnQoKTthLnJlc2V0KCk7cmV0dXJuIGF9fWNvbnN0IGg9bmV3IERpY3QodGhpcy54cmVmKTtmb3IoY29uc3QgZSBpbiBhKWguc2V0KGUsYVtlXSk7bGV0IHU9ci5tYWtlU3ViU3RyZWFtKG8sYyxoKTtlJiYodT1lLmNyZWF0ZVN0cmVhbSh1LGMpKTt1PXRoaXMuZmlsdGVyKHUsaCxjKTt1LmRpY3Q9aDtpZih2b2lkIDAhPT1sKXt1LmNhY2hlS2V5PSJpbmxpbmVfaW1nXyIrICsrdGhpcy5faW1hZ2VJZDt0aGlzLmltYWdlQ2FjaGVbbF09dX10aGlzLmJ1ZjI9Q21kLmdldCgiRUkiKTt0aGlzLnNoaWZ0KCk7cmV0dXJuIHV9I1goZSl7Y29uc3R7c3RyZWFtOnR9PXRoaXMubGV4ZXI7dC5wb3M9ZTtjb25zdCByPW5ldyBVaW50OEFycmF5KFsxMDEsMTEwLDEwMF0pLGE9ci5sZW5ndGgsbj1bbmV3IFVpbnQ4QXJyYXkoWzExNSwxMTYsMTE0LDEwMSw5NywxMDldKSxuZXcgVWludDhBcnJheShbMTE1LDExNiwxMDEsOTcsMTA5XSksbmV3IFVpbnQ4QXJyYXkoWzExNSwxMTYsMTE0LDEwMSw5N10pXSxpPTktYTtmb3IoO3QucG9zPHQuZW5kOyl7Y29uc3Qgcz10LnBlZWtCeXRlcygyMDQ4KSxvPXMubGVuZ3RoLTk7aWYobzw9MClicmVhaztsZXQgYz0wO2Zvcig7YzxvOyl7bGV0IG89MDtmb3IoO288YSYmc1tjK29dPT09cltvXTspbysrO2lmKG8+PWEpe2xldCBhPSExO2Zvcihjb25zdCBlIG9mIG4pe2NvbnN0IHQ9ZS5sZW5ndGg7bGV0IG49MDtmb3IoO248dCYmc1tjK28rbl09PT1lW25dOyluKys7aWYobj49aSl7YT0hMDticmVha31pZihuPj10KXtpZihpc1doaXRlU3BhY2Uoc1tjK28rbl0pKXtpbmZvKGBGb3VuZCAiJHtieXRlc1RvU3RyaW5nKFsuLi5yLC4uLmVdKX0iIHdoZW4gc2VhcmNoaW5nIGZvciBlbmRzdHJlYW0gY29tbWFuZC5gKTthPSEwfWJyZWFrfX1pZihhKXt0LnBvcys9YztyZXR1cm4gdC5wb3MtZX19YysrfXQucG9zKz1vfXJldHVybi0xfW1ha2VTdHJlYW0oZSx0KXtjb25zdCByPXRoaXMubGV4ZXI7bGV0IGE9ci5zdHJlYW07ci5za2lwVG9OZXh0TGluZSgpO2NvbnN0IG49YS5wb3MtMTtsZXQgaT1lLmdldCgiTGVuZ3RoIik7aWYoIU51bWJlci5pc0ludGVnZXIoaSkpe2luZm8oYEJhZCBsZW5ndGggIiR7aSYmaS50b1N0cmluZygpfSIgaW4gc3RyZWFtLmApO2k9MH1hLnBvcz1uK2k7ci5uZXh0Q2hhcigpO2lmKHRoaXMudHJ5U2hpZnQoKSYmaXNDbWQodGhpcy5idWYyLCJlbmRzdHJlYW0iKSl0aGlzLnNoaWZ0KCk7ZWxzZXtpPXRoaXMuI1gobik7aWYoaTwwKXRocm93IG5ldyBGb3JtYXRFcnJvcigiTWlzc2luZyBlbmRzdHJlYW0gY29tbWFuZC4iKTtyLm5leHRDaGFyKCk7dGhpcy5zaGlmdCgpO3RoaXMuc2hpZnQoKX10aGlzLnNoaWZ0KCk7YT1hLm1ha2VTdWJTdHJlYW0obixpLGUpO3QmJihhPXQuY3JlYXRlU3RyZWFtKGEsaSkpO2E9dGhpcy5maWx0ZXIoYSxlLGkpO2EuZGljdD1lO3JldHVybiBhfWZpbHRlcihlLHQscil7bGV0IGE9dC5nZXQoIkYiLCJGaWx0ZXIiKSxuPXQuZ2V0KCJEUCIsIkRlY29kZVBhcm1zIik7aWYoYSBpbnN0YW5jZW9mIE5hbWUpe0FycmF5LmlzQXJyYXkobikmJndhcm4oIi9EZWNvZGVQYXJtcyBzaG91bGQgbm90IGJlIGFuIEFycmF5LCB3aGVuIC9GaWx0ZXIgaXMgYSBOYW1lLiIpO3JldHVybiB0aGlzLm1ha2VGaWx0ZXIoZSxhLm5hbWUscixuKX1sZXQgaT1yO2lmKEFycmF5LmlzQXJyYXkoYSkpe2NvbnN0IHQ9YSxyPW47Zm9yKGxldCBzPTAsbz10Lmxlbmd0aDtzPG87KytzKXthPXRoaXMueHJlZi5mZXRjaElmUmVmKHRbc10pO2lmKCEoYSBpbnN0YW5jZW9mIE5hbWUpKXRocm93IG5ldyBGb3JtYXRFcnJvcihgQmFkIGZpbHRlciBuYW1lICIke2F9ImApO249bnVsbDtBcnJheS5pc0FycmF5KHIpJiZzIGluIHImJihuPXRoaXMueHJlZi5mZXRjaElmUmVmKHJbc10pKTtlPXRoaXMubWFrZUZpbHRlcihlLGEubmFtZSxpLG4pO2k9bnVsbH19cmV0dXJuIGV9bWFrZUZpbHRlcihlLHQscixhKXtpZigwPT09cil7d2FybihgRW1wdHkgIiR7dH0iIHN0cmVhbS5gKTtyZXR1cm4gbmV3IE51bGxTdHJlYW19dHJ5e3N3aXRjaCh0KXtjYXNlIkZsIjpjYXNlIkZsYXRlRGVjb2RlIjpyZXR1cm4gYT9uZXcgUHJlZGljdG9yU3RyZWFtKG5ldyBGbGF0ZVN0cmVhbShlLHIpLHIsYSk6bmV3IEZsYXRlU3RyZWFtKGUscik7Y2FzZSJMWlciOmNhc2UiTFpXRGVjb2RlIjpsZXQgdD0xO2lmKGEpe2EuaGFzKCJFYXJseUNoYW5nZSIpJiYodD1hLmdldCgiRWFybHlDaGFuZ2UiKSk7cmV0dXJuIG5ldyBQcmVkaWN0b3JTdHJlYW0obmV3IExaV1N0cmVhbShlLHIsdCkscixhKX1yZXR1cm4gbmV3IExaV1N0cmVhbShlLHIsdCk7Y2FzZSJEQ1QiOmNhc2UiRENURGVjb2RlIjpyZXR1cm4gbmV3IEpwZWdTdHJlYW0oZSxyLGEpO2Nhc2UiSlBYIjpjYXNlIkpQWERlY29kZSI6cmV0dXJuIG5ldyBKcHhTdHJlYW0oZSxyLGEpO2Nhc2UiQTg1IjpjYXNlIkFTQ0lJODVEZWNvZGUiOnJldHVybiBuZXcgQXNjaWk4NVN0cmVhbShlLHIpO2Nhc2UiQUh4IjpjYXNlIkFTQ0lJSGV4RGVjb2RlIjpyZXR1cm4gbmV3IEFzY2lpSGV4U3RyZWFtKGUscik7Y2FzZSJDQ0YiOmNhc2UiQ0NJVFRGYXhEZWNvZGUiOnJldHVybiBuZXcgQ0NJVFRGYXhTdHJlYW0oZSxyLGEpO2Nhc2UiUkwiOmNhc2UiUnVuTGVuZ3RoRGVjb2RlIjpyZXR1cm4gbmV3IFJ1bkxlbmd0aFN0cmVhbShlLHIpO2Nhc2UiSkJJRzJEZWNvZGUiOnJldHVybiBuZXcgSmJpZzJTdHJlYW0oZSxyLGEpfXdhcm4oYEZpbHRlciAiJHt0fSIgaXMgbm90IHN1cHBvcnRlZC5gKTtyZXR1cm4gZX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgTWlzc2luZ0RhdGFFeGNlcHRpb24pdGhyb3cgZTt3YXJuKGBJbnZhbGlkIHN0cmVhbTogIiR7ZX0iYCk7cmV0dXJuIG5ldyBOdWxsU3RyZWFtfX19Y29uc3QgbmE9WzEsMCwwLDAsMCwwLDAsMCwwLDEsMSwwLDEsMSwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwxLDAsMCwwLDAsMiwwLDAsMiwyLDAsMCwwLDAsMCwyLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDIsMCwyLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMiwwLDIsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDIsMCwyLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDBdO2Z1bmN0aW9uIHRvSGV4RGlnaXQoZSl7cmV0dXJuIGU+PTQ4JiZlPD01Nz8xNSZlOmU+PTY1JiZlPD03MHx8ZT49OTcmJmU8PTEwMj85KygxNSZlKTotMX1jbGFzcyBMZXhlcntjb25zdHJ1Y3RvcihlLHQ9bnVsbCl7dGhpcy5zdHJlYW09ZTt0aGlzLm5leHRDaGFyKCk7dGhpcy5zdHJCdWY9W107dGhpcy5rbm93bkNvbW1hbmRzPXQ7dGhpcy5faGV4U3RyaW5nTnVtV2Fybj0wO3RoaXMuYmVnaW5JbmxpbmVJbWFnZVBvcz0tMX1uZXh0Q2hhcigpe3JldHVybiB0aGlzLmN1cnJlbnRDaGFyPXRoaXMuc3RyZWFtLmdldEJ5dGUoKX1wZWVrQ2hhcigpe3JldHVybiB0aGlzLnN0cmVhbS5wZWVrQnl0ZSgpfWdldE51bWJlcigpe2xldCBlPXRoaXMuY3VycmVudENoYXIsdD0hMSxyPTAsYT0xO2lmKDQ1PT09ZSl7YT0tMTtlPXRoaXMubmV4dENoYXIoKTs0NT09PWUmJihlPXRoaXMubmV4dENoYXIoKSl9ZWxzZSA0Mz09PWUmJihlPXRoaXMubmV4dENoYXIoKSk7aWYoMTA9PT1lfHwxMz09PWUpZG97ZT10aGlzLm5leHRDaGFyKCl9d2hpbGUoMTA9PT1lfHwxMz09PWUpO2lmKDQ2PT09ZSl7cj0xMDtlPXRoaXMubmV4dENoYXIoKX1pZihlPDQ4fHxlPjU3KXtjb25zdCB0PWBJbnZhbGlkIG51bWJlcjogJHtTdHJpbmcuZnJvbUNoYXJDb2RlKGUpfSAoY2hhckNvZGUgJHtlfSlgO2lmKGlzV2hpdGVTcGFjZShlKXx8NDA9PT1lfHw2MD09PWV8fC0xPT09ZSl7aW5mbyhgTGV4ZXIuZ2V0TnVtYmVyIC0gIiR7dH0iLmApO3JldHVybiAwfXRocm93IG5ldyBGb3JtYXRFcnJvcih0KX1sZXQgbj1lLTQ4LGk9MCxzPTE7Zm9yKDsoZT10aGlzLm5leHRDaGFyKCkpPj0wOylpZihlPj00OCYmZTw9NTcpe2NvbnN0IGE9ZS00ODtpZih0KWk9MTAqaSthO2Vsc2V7MCE9PXImJihyKj0xMCk7bj0xMCpuK2F9fWVsc2UgaWYoNDY9PT1lKXtpZigwIT09cilicmVhaztyPTF9ZWxzZSBpZig0NT09PWUpd2FybigiQmFkbHkgZm9ybWF0dGVkIG51bWJlcjogbWludXMgc2lnbiBpbiB0aGUgbWlkZGxlIik7ZWxzZXtpZig2OSE9PWUmJjEwMSE9PWUpYnJlYWs7ZT10aGlzLnBlZWtDaGFyKCk7aWYoNDM9PT1lfHw0NT09PWUpe3M9NDU9PT1lPy0xOjE7dGhpcy5uZXh0Q2hhcigpfWVsc2UgaWYoZTw0OHx8ZT41NylicmVhazt0PSEwfTAhPT1yJiYobi89cik7dCYmKG4qPTEwKioocyppKSk7cmV0dXJuIGEqbn1nZXRTdHJpbmcoKXtsZXQgZT0xLHQ9ITE7Y29uc3Qgcj10aGlzLnN0ckJ1ZjtyLmxlbmd0aD0wO2xldCBhPXRoaXMubmV4dENoYXIoKTtmb3IoOzspe2xldCBuPSExO3N3aXRjaCgwfGEpe2Nhc2UtMTp3YXJuKCJVbnRlcm1pbmF0ZWQgc3RyaW5nIik7dD0hMDticmVhaztjYXNlIDQwOisrZTtyLnB1c2goIigiKTticmVhaztjYXNlIDQxOmlmKDA9PT0tLWUpe3RoaXMubmV4dENoYXIoKTt0PSEwfWVsc2Ugci5wdXNoKCIpIik7YnJlYWs7Y2FzZSA5MjphPXRoaXMubmV4dENoYXIoKTtzd2l0Y2goYSl7Y2FzZS0xOndhcm4oIlVudGVybWluYXRlZCBzdHJpbmciKTt0PSEwO2JyZWFrO2Nhc2UgMTEwOnIucHVzaCgiXG4iKTticmVhaztjYXNlIDExNDpyLnB1c2goIlxyIik7YnJlYWs7Y2FzZSAxMTY6ci5wdXNoKCJcdCIpO2JyZWFrO2Nhc2UgOTg6ci5wdXNoKCJcYiIpO2JyZWFrO2Nhc2UgMTAyOnIucHVzaCgiXGYiKTticmVhaztjYXNlIDkyOmNhc2UgNDA6Y2FzZSA0MTpyLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShhKSk7YnJlYWs7Y2FzZSA0ODpjYXNlIDQ5OmNhc2UgNTA6Y2FzZSA1MTpjYXNlIDUyOmNhc2UgNTM6Y2FzZSA1NDpjYXNlIDU1OmxldCBlPTE1JmE7YT10aGlzLm5leHRDaGFyKCk7bj0hMDtpZihhPj00OCYmYTw9NTUpe2U9KGU8PDMpKygxNSZhKTthPXRoaXMubmV4dENoYXIoKTtpZihhPj00OCYmYTw9NTUpe249ITE7ZT0oZTw8MykrKDE1JmEpfX1yLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShlKSk7YnJlYWs7Y2FzZSAxMzoxMD09PXRoaXMucGVla0NoYXIoKSYmdGhpcy5uZXh0Q2hhcigpO2JyZWFrO2Nhc2UgMTA6YnJlYWs7ZGVmYXVsdDpyLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShhKSl9YnJlYWs7ZGVmYXVsdDpyLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShhKSl9aWYodClicmVhaztufHwoYT10aGlzLm5leHRDaGFyKCkpfXJldHVybiByLmpvaW4oIiIpfWdldE5hbWUoKXtsZXQgZSx0O2NvbnN0IHI9dGhpcy5zdHJCdWY7ci5sZW5ndGg9MDtmb3IoOyhlPXRoaXMubmV4dENoYXIoKSk+PTAmJiFuYVtlXTspaWYoMzU9PT1lKXtlPXRoaXMubmV4dENoYXIoKTtpZihuYVtlXSl7d2FybigiTGV4ZXJfZ2V0TmFtZTogTlVNQkVSIFNJR04gKCMpIHNob3VsZCBiZSBmb2xsb3dlZCBieSBhIGhleGFkZWNpbWFsIG51bWJlci4iKTtyLnB1c2goIiMiKTticmVha31jb25zdCBhPXRvSGV4RGlnaXQoZSk7aWYoLTEhPT1hKXt0PWU7ZT10aGlzLm5leHRDaGFyKCk7Y29uc3Qgbj10b0hleERpZ2l0KGUpO2lmKC0xPT09bil7d2FybihgTGV4ZXJfZ2V0TmFtZTogSWxsZWdhbCBkaWdpdCAoJHtTdHJpbmcuZnJvbUNoYXJDb2RlKGUpfSkgaW4gaGV4YWRlY2ltYWwgbnVtYmVyLmApO3IucHVzaCgiIyIsU3RyaW5nLmZyb21DaGFyQ29kZSh0KSk7aWYobmFbZV0pYnJlYWs7ci5wdXNoKFN0cmluZy5mcm9tQ2hhckNvZGUoZSkpO2NvbnRpbnVlfXIucHVzaChTdHJpbmcuZnJvbUNoYXJDb2RlKGE8PDR8bikpfWVsc2Ugci5wdXNoKCIjIixTdHJpbmcuZnJvbUNoYXJDb2RlKGUpKX1lbHNlIHIucHVzaChTdHJpbmcuZnJvbUNoYXJDb2RlKGUpKTtyLmxlbmd0aD4xMjcmJndhcm4oYE5hbWUgdG9rZW4gaXMgbG9uZ2VyIHRoYW4gYWxsb3dlZCBieSB0aGUgc3BlYzogJHtyLmxlbmd0aH1gKTtyZXR1cm4gTmFtZS5nZXQoci5qb2luKCIiKSl9X2hleFN0cmluZ1dhcm4oZSl7NSE9PXRoaXMuX2hleFN0cmluZ051bVdhcm4rKz90aGlzLl9oZXhTdHJpbmdOdW1XYXJuPjV8fHdhcm4oYGdldEhleFN0cmluZyAtIGlnbm9yaW5nIGludmFsaWQgY2hhcmFjdGVyOiAke2V9YCk6d2FybigiZ2V0SGV4U3RyaW5nIC0gaWdub3JpbmcgYWRkaXRpb25hbCBpbnZhbGlkIGNoYXJhY3RlcnMuIil9Z2V0SGV4U3RyaW5nKCl7Y29uc3QgZT10aGlzLnN0ckJ1ZjtlLmxlbmd0aD0wO2xldCB0PXRoaXMuY3VycmVudENoYXIscj0tMSxhPS0xO3RoaXMuX2hleFN0cmluZ051bVdhcm49MDtmb3IoOzspe2lmKHQ8MCl7d2FybigiVW50ZXJtaW5hdGVkIGhleCBzdHJpbmciKTticmVha31pZig2Mj09PXQpe3RoaXMubmV4dENoYXIoKTticmVha31pZigxIT09bmFbdF0pe2E9dG9IZXhEaWdpdCh0KTtpZigtMT09PWEpdGhpcy5faGV4U3RyaW5nV2Fybih0KTtlbHNlIGlmKC0xPT09cilyPWE7ZWxzZXtlLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShyPDw0fGEpKTtyPS0xfXQ9dGhpcy5uZXh0Q2hhcigpfWVsc2UgdD10aGlzLm5leHRDaGFyKCl9LTEhPT1yJiZlLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShyPDw0KSk7cmV0dXJuIGUuam9pbigiIil9Z2V0T2JqKCl7bGV0IGU9ITEsdD10aGlzLmN1cnJlbnRDaGFyO2Zvcig7Oyl7aWYodDwwKXJldHVybiBzcjtpZihlKTEwIT09dCYmMTMhPT10fHwoZT0hMSk7ZWxzZSBpZigzNz09PXQpZT0hMDtlbHNlIGlmKDEhPT1uYVt0XSlicmVhazt0PXRoaXMubmV4dENoYXIoKX1zd2l0Y2goMHx0KXtjYXNlIDQ4OmNhc2UgNDk6Y2FzZSA1MDpjYXNlIDUxOmNhc2UgNTI6Y2FzZSA1MzpjYXNlIDU0OmNhc2UgNTU6Y2FzZSA1NjpjYXNlIDU3OmNhc2UgNDM6Y2FzZSA0NTpjYXNlIDQ2OnJldHVybiB0aGlzLmdldE51bWJlcigpO2Nhc2UgNDA6cmV0dXJuIHRoaXMuZ2V0U3RyaW5nKCk7Y2FzZSA0NzpyZXR1cm4gdGhpcy5nZXROYW1lKCk7Y2FzZSA5MTp0aGlzLm5leHRDaGFyKCk7cmV0dXJuIENtZC5nZXQoIlsiKTtjYXNlIDkzOnRoaXMubmV4dENoYXIoKTtyZXR1cm4gQ21kLmdldCgiXSIpO2Nhc2UgNjA6dD10aGlzLm5leHRDaGFyKCk7aWYoNjA9PT10KXt0aGlzLm5leHRDaGFyKCk7cmV0dXJuIENtZC5nZXQoIjw8Iil9cmV0dXJuIHRoaXMuZ2V0SGV4U3RyaW5nKCk7Y2FzZSA2Mjp0PXRoaXMubmV4dENoYXIoKTtpZig2Mj09PXQpe3RoaXMubmV4dENoYXIoKTtyZXR1cm4gQ21kLmdldCgiPj4iKX1yZXR1cm4gQ21kLmdldCgiPiIpO2Nhc2UgMTIzOnRoaXMubmV4dENoYXIoKTtyZXR1cm4gQ21kLmdldCgieyIpO2Nhc2UgMTI1OnRoaXMubmV4dENoYXIoKTtyZXR1cm4gQ21kLmdldCgifSIpO2Nhc2UgNDE6dGhpcy5uZXh0Q2hhcigpO3Rocm93IG5ldyBGb3JtYXRFcnJvcihgSWxsZWdhbCBjaGFyYWN0ZXI6ICR7dH1gKX1sZXQgcj1TdHJpbmcuZnJvbUNoYXJDb2RlKHQpO2lmKHQ8MzJ8fHQ+MTI3KXtjb25zdCBlPXRoaXMucGVla0NoYXIoKTtpZihlPj0zMiYmZTw9MTI3KXt0aGlzLm5leHRDaGFyKCk7cmV0dXJuIENtZC5nZXQocil9fWNvbnN0IGE9dGhpcy5rbm93bkNvbW1hbmRzO2xldCBuPXZvaWQgMCE9PWE/LltyXTtmb3IoOyh0PXRoaXMubmV4dENoYXIoKSk+PTAmJiFuYVt0XTspe2NvbnN0IGU9citTdHJpbmcuZnJvbUNoYXJDb2RlKHQpO2lmKG4mJnZvaWQgMD09PWFbZV0pYnJlYWs7aWYoMTI4PT09ci5sZW5ndGgpdGhyb3cgbmV3IEZvcm1hdEVycm9yKGBDb21tYW5kIHRva2VuIHRvbyBsb25nOiAke3IubGVuZ3RofWApO3I9ZTtuPXZvaWQgMCE9PWE/LltyXX1pZigidHJ1ZSI9PT1yKXJldHVybiEwO2lmKCJmYWxzZSI9PT1yKXJldHVybiExO2lmKCJudWxsIj09PXIpcmV0dXJuIG51bGw7IkJJIj09PXImJih0aGlzLmJlZ2luSW5saW5lSW1hZ2VQb3M9dGhpcy5zdHJlYW0ucG9zKTtyZXR1cm4gQ21kLmdldChyKX1za2lwVG9OZXh0TGluZSgpe2xldCBlPXRoaXMuY3VycmVudENoYXI7Zm9yKDtlPj0wOyl7aWYoMTM9PT1lKXtlPXRoaXMubmV4dENoYXIoKTsxMD09PWUmJnRoaXMubmV4dENoYXIoKTticmVha31pZigxMD09PWUpe3RoaXMubmV4dENoYXIoKTticmVha31lPXRoaXMubmV4dENoYXIoKX19fWNsYXNzIExpbmVhcml6YXRpb257c3RhdGljIGNyZWF0ZShlKXtmdW5jdGlvbiBnZXRJbnQoZSx0LHI9ITEpe2NvbnN0IGE9ZS5nZXQodCk7aWYoTnVtYmVyLmlzSW50ZWdlcihhKSYmKHI/YT49MDphPjApKXJldHVybiBhO3Rocm93IG5ldyBFcnJvcihgVGhlICIke3R9IiBwYXJhbWV0ZXIgaW4gdGhlIGxpbmVhcml6YXRpb24gZGljdGlvbmFyeSBpcyBpbnZhbGlkLmApfWNvbnN0IHQ9bmV3IFBhcnNlcih7bGV4ZXI6bmV3IExleGVyKGUpLHhyZWY6bnVsbH0pLHI9dC5nZXRPYmooKSxhPXQuZ2V0T2JqKCksbj10LmdldE9iaigpLGk9dC5nZXRPYmooKTtsZXQgcyxvO2lmKCEoTnVtYmVyLmlzSW50ZWdlcihyKSYmTnVtYmVyLmlzSW50ZWdlcihhKSYmaXNDbWQobiwib2JqIikmJmkgaW5zdGFuY2VvZiBEaWN0JiYibnVtYmVyIj09dHlwZW9mKHM9aS5nZXQoIkxpbmVhcml6ZWQiKSkmJnM+MCkpcmV0dXJuIG51bGw7aWYoKG89Z2V0SW50KGksIkwiKSkhPT1lLmxlbmd0aCl0aHJvdyBuZXcgRXJyb3IoJ1RoZSAiTCIgcGFyYW1ldGVyIGluIHRoZSBsaW5lYXJpemF0aW9uIGRpY3Rpb25hcnkgZG9lcyBub3QgZXF1YWwgdGhlIHN0cmVhbSBsZW5ndGguJyk7cmV0dXJue2xlbmd0aDpvLGhpbnRzOmZ1bmN0aW9uIGdldEhpbnRzKGUpe2NvbnN0IHQ9ZS5nZXQoIkgiKTtsZXQgcjtpZihBcnJheS5pc0FycmF5KHQpJiYoMj09PShyPXQubGVuZ3RoKXx8ND09PXIpKXtmb3IobGV0IGU9MDtlPHI7ZSsrKXtjb25zdCByPXRbZV07aWYoIShOdW1iZXIuaXNJbnRlZ2VyKHIpJiZyPjApKXRocm93IG5ldyBFcnJvcihgSGludCAoJHtlfSkgaW4gdGhlIGxpbmVhcml6YXRpb24gZGljdGlvbmFyeSBpcyBpbnZhbGlkLmApfXJldHVybiB0fXRocm93IG5ldyBFcnJvcigiSGludCBhcnJheSBpbiB0aGUgbGluZWFyaXphdGlvbiBkaWN0aW9uYXJ5IGlzIGludmFsaWQuIil9KGkpLG9iamVjdE51bWJlckZpcnN0OmdldEludChpLCJPIiksZW5kRmlyc3Q6Z2V0SW50KGksIkUiKSxudW1QYWdlczpnZXRJbnQoaSwiTiIpLG1haW5YUmVmRW50cmllc09mZnNldDpnZXRJbnQoaSwiVCIpLHBhZ2VGaXJzdDppLmhhcygiUCIpP2dldEludChpLCJQIiwhMCk6MH19fWNvbnN0IGlhPVsiQWRvYmUtR0IxLVVDUzIiLCJBZG9iZS1DTlMxLVVDUzIiLCJBZG9iZS1KYXBhbjEtVUNTMiIsIkFkb2JlLUtvcmVhMS1VQ1MyIiwiNzgtRVVDLUgiLCI3OC1FVUMtViIsIjc4LUgiLCI3OC1SS1NKLUgiLCI3OC1SS1NKLVYiLCI3OC1WIiwiNzhtcy1SS1NKLUgiLCI3OG1zLVJLU0otViIsIjgzcHYtUktTSi1IIiwiOTBtcy1SS1NKLUgiLCI5MG1zLVJLU0otViIsIjkwbXNwLVJLU0otSCIsIjkwbXNwLVJLU0otViIsIjkwcHYtUktTSi1IIiwiOTBwdi1SS1NKLVYiLCJBZGQtSCIsIkFkZC1SS1NKLUgiLCJBZGQtUktTSi1WIiwiQWRkLVYiLCJBZG9iZS1DTlMxLTAiLCJBZG9iZS1DTlMxLTEiLCJBZG9iZS1DTlMxLTIiLCJBZG9iZS1DTlMxLTMiLCJBZG9iZS1DTlMxLTQiLCJBZG9iZS1DTlMxLTUiLCJBZG9iZS1DTlMxLTYiLCJBZG9iZS1HQjEtMCIsIkFkb2JlLUdCMS0xIiwiQWRvYmUtR0IxLTIiLCJBZG9iZS1HQjEtMyIsIkFkb2JlLUdCMS00IiwiQWRvYmUtR0IxLTUiLCJBZG9iZS1KYXBhbjEtMCIsIkFkb2JlLUphcGFuMS0xIiwiQWRvYmUtSmFwYW4xLTIiLCJBZG9iZS1KYXBhbjEtMyIsIkFkb2JlLUphcGFuMS00IiwiQWRvYmUtSmFwYW4xLTUiLCJBZG9iZS1KYXBhbjEtNiIsIkFkb2JlLUtvcmVhMS0wIiwiQWRvYmUtS29yZWExLTEiLCJBZG9iZS1Lb3JlYTEtMiIsIkI1LUgiLCJCNS1WIiwiQjVwYy1IIiwiQjVwYy1WIiwiQ05TLUVVQy1IIiwiQ05TLUVVQy1WIiwiQ05TMS1IIiwiQ05TMS1WIiwiQ05TMi1IIiwiQ05TMi1WIiwiRVRISy1CNS1IIiwiRVRISy1CNS1WIiwiRVRlbi1CNS1IIiwiRVRlbi1CNS1WIiwiRVRlbm1zLUI1LUgiLCJFVGVubXMtQjUtViIsIkVVQy1IIiwiRVVDLVYiLCJFeHQtSCIsIkV4dC1SS1NKLUgiLCJFeHQtUktTSi1WIiwiRXh0LVYiLCJHQi1FVUMtSCIsIkdCLUVVQy1WIiwiR0ItSCIsIkdCLVYiLCJHQkstRVVDLUgiLCJHQkstRVVDLVYiLCJHQksySy1IIiwiR0JLMkstViIsIkdCS3AtRVVDLUgiLCJHQktwLUVVQy1WIiwiR0JULUVVQy1IIiwiR0JULUVVQy1WIiwiR0JULUgiLCJHQlQtViIsIkdCVHBjLUVVQy1IIiwiR0JUcGMtRVVDLVYiLCJHQnBjLUVVQy1IIiwiR0JwYy1FVUMtViIsIkgiLCJIS2RsYS1CNS1IIiwiSEtkbGEtQjUtViIsIkhLZGxiLUI1LUgiLCJIS2RsYi1CNS1WIiwiSEtnY2NzLUI1LUgiLCJIS2djY3MtQjUtViIsIkhLbTMxNC1CNS1IIiwiSEttMzE0LUI1LVYiLCJIS200NzEtQjUtSCIsIkhLbTQ3MS1CNS1WIiwiSEtzY3MtQjUtSCIsIkhLc2NzLUI1LVYiLCJIYW5rYWt1IiwiSGlyYWdhbmEiLCJLU0MtRVVDLUgiLCJLU0MtRVVDLVYiLCJLU0MtSCIsIktTQy1Kb2hhYi1IIiwiS1NDLUpvaGFiLVYiLCJLU0MtViIsIktTQ21zLVVIQy1IIiwiS1NDbXMtVUhDLUhXLUgiLCJLU0Ntcy1VSEMtSFctViIsIktTQ21zLVVIQy1WIiwiS1NDcGMtRVVDLUgiLCJLU0NwYy1FVUMtViIsIkthdGFrYW5hIiwiTldQLUgiLCJOV1AtViIsIlJLU0otSCIsIlJLU0otViIsIlJvbWFuIiwiVW5pQ05TLVVDUzItSCIsIlVuaUNOUy1VQ1MyLVYiLCJVbmlDTlMtVVRGMTYtSCIsIlVuaUNOUy1VVEYxNi1WIiwiVW5pQ05TLVVURjMyLUgiLCJVbmlDTlMtVVRGMzItViIsIlVuaUNOUy1VVEY4LUgiLCJVbmlDTlMtVVRGOC1WIiwiVW5pR0ItVUNTMi1IIiwiVW5pR0ItVUNTMi1WIiwiVW5pR0ItVVRGMTYtSCIsIlVuaUdCLVVURjE2LVYiLCJVbmlHQi1VVEYzMi1IIiwiVW5pR0ItVVRGMzItViIsIlVuaUdCLVVURjgtSCIsIlVuaUdCLVVURjgtViIsIlVuaUpJUy1VQ1MyLUgiLCJVbmlKSVMtVUNTMi1IVy1IIiwiVW5pSklTLVVDUzItSFctViIsIlVuaUpJUy1VQ1MyLVYiLCJVbmlKSVMtVVRGMTYtSCIsIlVuaUpJUy1VVEYxNi1WIiwiVW5pSklTLVVURjMyLUgiLCJVbmlKSVMtVVRGMzItViIsIlVuaUpJUy1VVEY4LUgiLCJVbmlKSVMtVVRGOC1WIiwiVW5pSklTMjAwNC1VVEYxNi1IIiwiVW5pSklTMjAwNC1VVEYxNi1WIiwiVW5pSklTMjAwNC1VVEYzMi1IIiwiVW5pSklTMjAwNC1VVEYzMi1WIiwiVW5pSklTMjAwNC1VVEY4LUgiLCJVbmlKSVMyMDA0LVVURjgtViIsIlVuaUpJU1Byby1VQ1MyLUhXLVYiLCJVbmlKSVNQcm8tVUNTMi1WIiwiVW5pSklTUHJvLVVURjgtViIsIlVuaUpJU1gwMjEzLVVURjMyLUgiLCJVbmlKSVNYMDIxMy1VVEYzMi1WIiwiVW5pSklTWDAyMTMyMDA0LVVURjMyLUgiLCJVbmlKSVNYMDIxMzIwMDQtVVRGMzItViIsIlVuaUtTLVVDUzItSCIsIlVuaUtTLVVDUzItViIsIlVuaUtTLVVURjE2LUgiLCJVbmlLUy1VVEYxNi1WIiwiVW5pS1MtVVRGMzItSCIsIlVuaUtTLVVURjMyLVYiLCJVbmlLUy1VVEY4LUgiLCJVbmlLUy1VVEY4LVYiLCJWIiwiV1AtU3ltYm9sIl0sc2E9MioqMjQtMTtjbGFzcyBDTWFwe2NvbnN0cnVjdG9yKGU9ITEpe3RoaXMuY29kZXNwYWNlUmFuZ2VzPVtbXSxbXSxbXSxbXV07dGhpcy5udW1Db2Rlc3BhY2VSYW5nZXM9MDt0aGlzLl9tYXA9W107dGhpcy5uYW1lPSIiO3RoaXMudmVydGljYWw9ITE7dGhpcy51c2VDTWFwPW51bGw7dGhpcy5idWlsdEluQ01hcD1lfWFkZENvZGVzcGFjZVJhbmdlKGUsdCxyKXt0aGlzLmNvZGVzcGFjZVJhbmdlc1tlLTFdLnB1c2godCxyKTt0aGlzLm51bUNvZGVzcGFjZVJhbmdlcysrfW1hcENpZFJhbmdlKGUsdCxyKXtpZih0LWU+c2EpdGhyb3cgbmV3IEVycm9yKCJtYXBDaWRSYW5nZSAtIGlnbm9yaW5nIGRhdGEgYWJvdmUgTUFYX01BUF9SQU5HRS4iKTtmb3IoO2U8PXQ7KXRoaXMuX21hcFtlKytdPXIrK31tYXBCZlJhbmdlKGUsdCxyKXtpZih0LWU+c2EpdGhyb3cgbmV3IEVycm9yKCJtYXBCZlJhbmdlIC0gaWdub3JpbmcgZGF0YSBhYm92ZSBNQVhfTUFQX1JBTkdFLiIpO2NvbnN0IGE9ci5sZW5ndGgtMTtmb3IoO2U8PXQ7KXt0aGlzLl9tYXBbZSsrXT1yO2NvbnN0IHQ9ci5jaGFyQ29kZUF0KGEpKzE7dD4yNTU/cj1yLnN1YnN0cmluZygwLGEtMSkrU3RyaW5nLmZyb21DaGFyQ29kZShyLmNoYXJDb2RlQXQoYS0xKSsxKSsiXDAiOnI9ci5zdWJzdHJpbmcoMCxhKStTdHJpbmcuZnJvbUNoYXJDb2RlKHQpfX1tYXBCZlJhbmdlVG9BcnJheShlLHQscil7aWYodC1lPnNhKXRocm93IG5ldyBFcnJvcigibWFwQmZSYW5nZVRvQXJyYXkgLSBpZ25vcmluZyBkYXRhIGFib3ZlIE1BWF9NQVBfUkFOR0UuIik7Y29uc3QgYT1yLmxlbmd0aDtsZXQgbj0wO2Zvcig7ZTw9dCYmbjxhOyl7dGhpcy5fbWFwW2VdPXJbbisrXTsrK2V9fW1hcE9uZShlLHQpe3RoaXMuX21hcFtlXT10fWxvb2t1cChlKXtyZXR1cm4gdGhpcy5fbWFwW2VdfWNvbnRhaW5zKGUpe3JldHVybiB2b2lkIDAhPT10aGlzLl9tYXBbZV19Zm9yRWFjaChlKXtjb25zdCB0PXRoaXMuX21hcCxyPXQubGVuZ3RoO2lmKHI8PTY1NTM2KWZvcihsZXQgYT0wO2E8cjthKyspdm9pZCAwIT09dFthXSYmZShhLHRbYV0pO2Vsc2UgZm9yKGNvbnN0IHIgaW4gdCllKHIsdFtyXSl9Y2hhckNvZGVPZihlKXtjb25zdCB0PXRoaXMuX21hcDtpZih0Lmxlbmd0aDw9NjU1MzYpcmV0dXJuIHQuaW5kZXhPZihlKTtmb3IoY29uc3QgciBpbiB0KWlmKHRbcl09PT1lKXJldHVybiAwfHI7cmV0dXJuLTF9Z2V0TWFwKCl7cmV0dXJuIHRoaXMuX21hcH1yZWFkQ2hhckNvZGUoZSx0LHIpe2xldCBhPTA7Y29uc3Qgbj10aGlzLmNvZGVzcGFjZVJhbmdlcztmb3IobGV0IGk9MCxzPW4ubGVuZ3RoO2k8cztpKyspe2E9KGE8PDh8ZS5jaGFyQ29kZUF0KHQraSkpPj4+MDtjb25zdCBzPW5baV07Zm9yKGxldCBlPTAsdD1zLmxlbmd0aDtlPHQ7KXtjb25zdCB0PXNbZSsrXSxuPXNbZSsrXTtpZihhPj10JiZhPD1uKXtyLmNoYXJjb2RlPWE7ci5sZW5ndGg9aSsxO3JldHVybn19fXIuY2hhcmNvZGU9MDtyLmxlbmd0aD0xfWdldENoYXJDb2RlTGVuZ3RoKGUpe2NvbnN0IHQ9dGhpcy5jb2Rlc3BhY2VSYW5nZXM7Zm9yKGxldCByPTAsYT10Lmxlbmd0aDtyPGE7cisrKXtjb25zdCBhPXRbcl07Zm9yKGxldCB0PTAsbj1hLmxlbmd0aDt0PG47KXtjb25zdCBuPWFbdCsrXSxpPWFbdCsrXTtpZihlPj1uJiZlPD1pKXJldHVybiByKzF9fXJldHVybiAxfWdldCBsZW5ndGgoKXtyZXR1cm4gdGhpcy5fbWFwLmxlbmd0aH1nZXQgaXNJZGVudGl0eUNNYXAoKXtpZigiSWRlbnRpdHktSCIhPT10aGlzLm5hbWUmJiJJZGVudGl0eS1WIiE9PXRoaXMubmFtZSlyZXR1cm4hMTtpZig2NTUzNiE9PXRoaXMuX21hcC5sZW5ndGgpcmV0dXJuITE7Zm9yKGxldCBlPTA7ZTw2NTUzNjtlKyspaWYodGhpcy5fbWFwW2VdIT09ZSlyZXR1cm4hMTtyZXR1cm4hMH19Y2xhc3MgSWRlbnRpdHlDTWFwIGV4dGVuZHMgQ01hcHtjb25zdHJ1Y3RvcihlLHQpe3N1cGVyKCk7dGhpcy52ZXJ0aWNhbD1lO3RoaXMuYWRkQ29kZXNwYWNlUmFuZ2UodCwwLDY1NTM1KX1tYXBDaWRSYW5nZShlLHQscil7dW5yZWFjaGFibGUoInNob3VsZCBub3QgY2FsbCBtYXBDaWRSYW5nZSIpfW1hcEJmUmFuZ2UoZSx0LHIpe3VucmVhY2hhYmxlKCJzaG91bGQgbm90IGNhbGwgbWFwQmZSYW5nZSIpfW1hcEJmUmFuZ2VUb0FycmF5KGUsdCxyKXt1bnJlYWNoYWJsZSgic2hvdWxkIG5vdCBjYWxsIG1hcEJmUmFuZ2VUb0FycmF5Iil9bWFwT25lKGUsdCl7dW5yZWFjaGFibGUoInNob3VsZCBub3QgY2FsbCBtYXBDaWRPbmUiKX1sb29rdXAoZSl7cmV0dXJuIE51bWJlci5pc0ludGVnZXIoZSkmJmU8PTY1NTM1P2U6dm9pZCAwfWNvbnRhaW5zKGUpe3JldHVybiBOdW1iZXIuaXNJbnRlZ2VyKGUpJiZlPD02NTUzNX1mb3JFYWNoKGUpe2ZvcihsZXQgdD0wO3Q8PTY1NTM1O3QrKyllKHQsdCl9Y2hhckNvZGVPZihlKXtyZXR1cm4gTnVtYmVyLmlzSW50ZWdlcihlKSYmZTw9NjU1MzU/ZTotMX1nZXRNYXAoKXtjb25zdCBlPW5ldyBBcnJheSg2NTUzNik7Zm9yKGxldCB0PTA7dDw9NjU1MzU7dCsrKWVbdF09dDtyZXR1cm4gZX1nZXQgbGVuZ3RoKCl7cmV0dXJuIDY1NTM2fWdldCBpc0lkZW50aXR5Q01hcCgpe3VucmVhY2hhYmxlKCJzaG91bGQgbm90IGFjY2VzcyAuaXNJZGVudGl0eUNNYXAiKX19ZnVuY3Rpb24gc3RyVG9JbnQoZSl7bGV0IHQ9MDtmb3IobGV0IHI9MDtyPGUubGVuZ3RoO3IrKyl0PXQ8PDh8ZS5jaGFyQ29kZUF0KHIpO3JldHVybiB0Pj4+MH1mdW5jdGlvbiBleHBlY3RTdHJpbmcoZSl7aWYoInN0cmluZyIhPXR5cGVvZiBlKXRocm93IG5ldyBGb3JtYXRFcnJvcigiTWFsZm9ybWVkIENNYXA6IGV4cGVjdGVkIHN0cmluZy4iKX1mdW5jdGlvbiBleHBlY3RJbnQoZSl7aWYoIU51bWJlci5pc0ludGVnZXIoZSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJNYWxmb3JtZWQgQ01hcDogZXhwZWN0ZWQgaW50LiIpfWZ1bmN0aW9uIHBhcnNlQmZDaGFyKGUsdCl7Zm9yKDs7KXtsZXQgcj10LmdldE9iaigpO2lmKHI9PT1zcilicmVhaztpZihpc0NtZChyLCJlbmRiZmNoYXIiKSlyZXR1cm47ZXhwZWN0U3RyaW5nKHIpO2NvbnN0IGE9c3RyVG9JbnQocik7cj10LmdldE9iaigpO2V4cGVjdFN0cmluZyhyKTtjb25zdCBuPXI7ZS5tYXBPbmUoYSxuKX19ZnVuY3Rpb24gcGFyc2VCZlJhbmdlKGUsdCl7Zm9yKDs7KXtsZXQgcj10LmdldE9iaigpO2lmKHI9PT1zcilicmVhaztpZihpc0NtZChyLCJlbmRiZnJhbmdlIikpcmV0dXJuO2V4cGVjdFN0cmluZyhyKTtjb25zdCBhPXN0clRvSW50KHIpO3I9dC5nZXRPYmooKTtleHBlY3RTdHJpbmcocik7Y29uc3Qgbj1zdHJUb0ludChyKTtyPXQuZ2V0T2JqKCk7aWYoTnVtYmVyLmlzSW50ZWdlcihyKXx8InN0cmluZyI9PXR5cGVvZiByKXtjb25zdCB0PU51bWJlci5pc0ludGVnZXIocik/U3RyaW5nLmZyb21DaGFyQ29kZShyKTpyO2UubWFwQmZSYW5nZShhLG4sdCl9ZWxzZXtpZighaXNDbWQociwiWyIpKWJyZWFrO3tyPXQuZ2V0T2JqKCk7Y29uc3QgaT1bXTtmb3IoOyFpc0NtZChyLCJdIikmJnIhPT1zcjspe2kucHVzaChyKTtyPXQuZ2V0T2JqKCl9ZS5tYXBCZlJhbmdlVG9BcnJheShhLG4saSl9fX10aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkludmFsaWQgYmYgcmFuZ2UuIil9ZnVuY3Rpb24gcGFyc2VDaWRDaGFyKGUsdCl7Zm9yKDs7KXtsZXQgcj10LmdldE9iaigpO2lmKHI9PT1zcilicmVhaztpZihpc0NtZChyLCJlbmRjaWRjaGFyIikpcmV0dXJuO2V4cGVjdFN0cmluZyhyKTtjb25zdCBhPXN0clRvSW50KHIpO3I9dC5nZXRPYmooKTtleHBlY3RJbnQocik7Y29uc3Qgbj1yO2UubWFwT25lKGEsbil9fWZ1bmN0aW9uIHBhcnNlQ2lkUmFuZ2UoZSx0KXtmb3IoOzspe2xldCByPXQuZ2V0T2JqKCk7aWYocj09PXNyKWJyZWFrO2lmKGlzQ21kKHIsImVuZGNpZHJhbmdlIikpcmV0dXJuO2V4cGVjdFN0cmluZyhyKTtjb25zdCBhPXN0clRvSW50KHIpO3I9dC5nZXRPYmooKTtleHBlY3RTdHJpbmcocik7Y29uc3Qgbj1zdHJUb0ludChyKTtyPXQuZ2V0T2JqKCk7ZXhwZWN0SW50KHIpO2NvbnN0IGk9cjtlLm1hcENpZFJhbmdlKGEsbixpKX19ZnVuY3Rpb24gcGFyc2VDb2Rlc3BhY2VSYW5nZShlLHQpe2Zvcig7Oyl7bGV0IHI9dC5nZXRPYmooKTtpZihyPT09c3IpYnJlYWs7aWYoaXNDbWQociwiZW5kY29kZXNwYWNlcmFuZ2UiKSlyZXR1cm47aWYoInN0cmluZyIhPXR5cGVvZiByKWJyZWFrO2NvbnN0IGE9c3RyVG9JbnQocik7cj10LmdldE9iaigpO2lmKCJzdHJpbmciIT10eXBlb2YgcilicmVhaztjb25zdCBuPXN0clRvSW50KHIpO2UuYWRkQ29kZXNwYWNlUmFuZ2Uoci5sZW5ndGgsYSxuKX10aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkludmFsaWQgY29kZXNwYWNlIHJhbmdlLiIpfWZ1bmN0aW9uIHBhcnNlV01vZGUoZSx0KXtjb25zdCByPXQuZ2V0T2JqKCk7TnVtYmVyLmlzSW50ZWdlcihyKSYmKGUudmVydGljYWw9ISFyKX1mdW5jdGlvbiBwYXJzZUNNYXBOYW1lKGUsdCl7Y29uc3Qgcj10LmdldE9iaigpO3IgaW5zdGFuY2VvZiBOYW1lJiYoZS5uYW1lPXIubmFtZSl9YXN5bmMgZnVuY3Rpb24gcGFyc2VDTWFwKGUsdCxyLGEpe2xldCBuLGk7ZTpmb3IoOzspdHJ5e2NvbnN0IHI9dC5nZXRPYmooKTtpZihyPT09c3IpYnJlYWs7aWYociBpbnN0YW5jZW9mIE5hbWUpeyJXTW9kZSI9PT1yLm5hbWU/cGFyc2VXTW9kZShlLHQpOiJDTWFwTmFtZSI9PT1yLm5hbWUmJnBhcnNlQ01hcE5hbWUoZSx0KTtuPXJ9ZWxzZSBpZihyIGluc3RhbmNlb2YgQ21kKXN3aXRjaChyLmNtZCl7Y2FzZSJlbmRjbWFwIjpicmVhayBlO2Nhc2UidXNlY21hcCI6biBpbnN0YW5jZW9mIE5hbWUmJihpPW4ubmFtZSk7YnJlYWs7Y2FzZSJiZWdpbmNvZGVzcGFjZXJhbmdlIjpwYXJzZUNvZGVzcGFjZVJhbmdlKGUsdCk7YnJlYWs7Y2FzZSJiZWdpbmJmY2hhciI6cGFyc2VCZkNoYXIoZSx0KTticmVhaztjYXNlImJlZ2luY2lkY2hhciI6cGFyc2VDaWRDaGFyKGUsdCk7YnJlYWs7Y2FzZSJiZWdpbmJmcmFuZ2UiOnBhcnNlQmZSYW5nZShlLHQpO2JyZWFrO2Nhc2UiYmVnaW5jaWRyYW5nZSI6cGFyc2VDaWRSYW5nZShlLHQpfX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgTWlzc2luZ0RhdGFFeGNlcHRpb24pdGhyb3cgZTt3YXJuKCJJbnZhbGlkIGNNYXAgZGF0YTogIitlKTtjb250aW51ZX0hYSYmaSYmKGE9aSk7cmV0dXJuIGE/ZXh0ZW5kQ01hcChlLHIsYSk6ZX1hc3luYyBmdW5jdGlvbiBleHRlbmRDTWFwKGUsdCxyKXtlLnVzZUNNYXA9YXdhaXQgY3JlYXRlQnVpbHRJbkNNYXAocix0KTtpZigwPT09ZS5udW1Db2Rlc3BhY2VSYW5nZXMpe2NvbnN0IHQ9ZS51c2VDTWFwLmNvZGVzcGFjZVJhbmdlcztmb3IobGV0IHI9MDtyPHQubGVuZ3RoO3IrKyllLmNvZGVzcGFjZVJhbmdlc1tyXT10W3JdLnNsaWNlKCk7ZS5udW1Db2Rlc3BhY2VSYW5nZXM9ZS51c2VDTWFwLm51bUNvZGVzcGFjZVJhbmdlc31lLnVzZUNNYXAuZm9yRWFjaChmdW5jdGlvbih0LHIpe2UuY29udGFpbnModCl8fGUubWFwT25lKHQscil9KTtyZXR1cm4gZX1hc3luYyBmdW5jdGlvbiBjcmVhdGVCdWlsdEluQ01hcChlLHQpe2lmKCJJZGVudGl0eS1IIj09PWUpcmV0dXJuIG5ldyBJZGVudGl0eUNNYXAoITEsMik7aWYoIklkZW50aXR5LVYiPT09ZSlyZXR1cm4gbmV3IElkZW50aXR5Q01hcCghMCwyKTtpZighaWEuaW5jbHVkZXMoZSkpdGhyb3cgbmV3IEVycm9yKCJVbmtub3duIENNYXAgbmFtZTogIitlKTtpZighdCl0aHJvdyBuZXcgRXJyb3IoIkJ1aWx0LWluIENNYXAgcGFyYW1ldGVycyBhcmUgbm90IHByb3ZpZGVkLiIpO2NvbnN0e2NNYXBEYXRhOnIsaXNDb21wcmVzc2VkOmF9PWF3YWl0IHQoZSksbj1uZXcgQ01hcCghMCk7aWYoYSlyZXR1cm4obmV3IEJpbmFyeUNNYXBSZWFkZXIpLnByb2Nlc3MocixuLGU9PmV4dGVuZENNYXAobix0LGUpKTtjb25zdCBpPW5ldyBMZXhlcihuZXcgU3RyZWFtKHIpKTtyZXR1cm4gcGFyc2VDTWFwKG4saSx0LG51bGwpfWNsYXNzIENNYXBGYWN0b3J5e3N0YXRpYyBhc3luYyBjcmVhdGUoe2VuY29kaW5nOmUsZmV0Y2hCdWlsdEluQ01hcDp0LHVzZUNNYXA6cn0pe2lmKGUgaW5zdGFuY2VvZiBOYW1lKXJldHVybiBjcmVhdGVCdWlsdEluQ01hcChlLm5hbWUsdCk7aWYoZSBpbnN0YW5jZW9mIEJhc2VTdHJlYW0pe2NvbnN0IGE9YXdhaXQgcGFyc2VDTWFwKG5ldyBDTWFwLG5ldyBMZXhlcihlKSx0LHIpO3JldHVybiBhLmlzSWRlbnRpdHlDTWFwP2NyZWF0ZUJ1aWx0SW5DTWFwKGEubmFtZSx0KTphfXRocm93IG5ldyBFcnJvcigiRW5jb2RpbmcgcmVxdWlyZWQuIil9fWNvbnN0IG9hPVsiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwic3BhY2UiLCJleGNsYW1zbWFsbCIsIkh1bmdhcnVtbGF1dHNtYWxsIiwiIiwiZG9sbGFyb2xkc3R5bGUiLCJkb2xsYXJzdXBlcmlvciIsImFtcGVyc2FuZHNtYWxsIiwiQWN1dGVzbWFsbCIsInBhcmVubGVmdHN1cGVyaW9yIiwicGFyZW5yaWdodHN1cGVyaW9yIiwidHdvZG90ZW5sZWFkZXIiLCJvbmVkb3RlbmxlYWRlciIsImNvbW1hIiwiaHlwaGVuIiwicGVyaW9kIiwiZnJhY3Rpb24iLCJ6ZXJvb2xkc3R5bGUiLCJvbmVvbGRzdHlsZSIsInR3b29sZHN0eWxlIiwidGhyZWVvbGRzdHlsZSIsImZvdXJvbGRzdHlsZSIsImZpdmVvbGRzdHlsZSIsInNpeG9sZHN0eWxlIiwic2V2ZW5vbGRzdHlsZSIsImVpZ2h0b2xkc3R5bGUiLCJuaW5lb2xkc3R5bGUiLCJjb2xvbiIsInNlbWljb2xvbiIsImNvbW1hc3VwZXJpb3IiLCJ0aHJlZXF1YXJ0ZXJzZW1kYXNoIiwicGVyaW9kc3VwZXJpb3IiLCJxdWVzdGlvbnNtYWxsIiwiIiwiYXN1cGVyaW9yIiwiYnN1cGVyaW9yIiwiY2VudHN1cGVyaW9yIiwiZHN1cGVyaW9yIiwiZXN1cGVyaW9yIiwiIiwiIiwiIiwiaXN1cGVyaW9yIiwiIiwiIiwibHN1cGVyaW9yIiwibXN1cGVyaW9yIiwibnN1cGVyaW9yIiwib3N1cGVyaW9yIiwiIiwiIiwicnN1cGVyaW9yIiwic3N1cGVyaW9yIiwidHN1cGVyaW9yIiwiIiwiZmYiLCJmaSIsImZsIiwiZmZpIiwiZmZsIiwicGFyZW5sZWZ0aW5mZXJpb3IiLCIiLCJwYXJlbnJpZ2h0aW5mZXJpb3IiLCJDaXJjdW1mbGV4c21hbGwiLCJoeXBoZW5zdXBlcmlvciIsIkdyYXZlc21hbGwiLCJBc21hbGwiLCJCc21hbGwiLCJDc21hbGwiLCJEc21hbGwiLCJFc21hbGwiLCJGc21hbGwiLCJHc21hbGwiLCJIc21hbGwiLCJJc21hbGwiLCJKc21hbGwiLCJLc21hbGwiLCJMc21hbGwiLCJNc21hbGwiLCJOc21hbGwiLCJPc21hbGwiLCJQc21hbGwiLCJRc21hbGwiLCJSc21hbGwiLCJTc21hbGwiLCJUc21hbGwiLCJVc21hbGwiLCJWc21hbGwiLCJXc21hbGwiLCJYc21hbGwiLCJZc21hbGwiLCJac21hbGwiLCJjb2xvbm1vbmV0YXJ5Iiwib25lZml0dGVkIiwicnVwaWFoIiwiVGlsZGVzbWFsbCIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsImV4Y2xhbWRvd25zbWFsbCIsImNlbnRvbGRzdHlsZSIsIkxzbGFzaHNtYWxsIiwiIiwiIiwiU2Nhcm9uc21hbGwiLCJaY2Fyb25zbWFsbCIsIkRpZXJlc2lzc21hbGwiLCJCcmV2ZXNtYWxsIiwiQ2Fyb25zbWFsbCIsIiIsIkRvdGFjY2VudHNtYWxsIiwiIiwiIiwiTWFjcm9uc21hbGwiLCIiLCIiLCJmaWd1cmVkYXNoIiwiaHlwaGVuaW5mZXJpb3IiLCIiLCIiLCJPZ29uZWtzbWFsbCIsIlJpbmdzbWFsbCIsIkNlZGlsbGFzbWFsbCIsIiIsIiIsIiIsIm9uZXF1YXJ0ZXIiLCJvbmVoYWxmIiwidGhyZWVxdWFydGVycyIsInF1ZXN0aW9uZG93bnNtYWxsIiwib25lZWlnaHRoIiwidGhyZWVlaWdodGhzIiwiZml2ZWVpZ2h0aHMiLCJzZXZlbmVpZ2h0aHMiLCJvbmV0aGlyZCIsInR3b3RoaXJkcyIsIiIsIiIsInplcm9zdXBlcmlvciIsIm9uZXN1cGVyaW9yIiwidHdvc3VwZXJpb3IiLCJ0aHJlZXN1cGVyaW9yIiwiZm91cnN1cGVyaW9yIiwiZml2ZXN1cGVyaW9yIiwic2l4c3VwZXJpb3IiLCJzZXZlbnN1cGVyaW9yIiwiZWlnaHRzdXBlcmlvciIsIm5pbmVzdXBlcmlvciIsInplcm9pbmZlcmlvciIsIm9uZWluZmVyaW9yIiwidHdvaW5mZXJpb3IiLCJ0aHJlZWluZmVyaW9yIiwiZm91cmluZmVyaW9yIiwiZml2ZWluZmVyaW9yIiwic2l4aW5mZXJpb3IiLCJzZXZlbmluZmVyaW9yIiwiZWlnaHRpbmZlcmlvciIsIm5pbmVpbmZlcmlvciIsImNlbnRpbmZlcmlvciIsImRvbGxhcmluZmVyaW9yIiwicGVyaW9kaW5mZXJpb3IiLCJjb21tYWluZmVyaW9yIiwiQWdyYXZlc21hbGwiLCJBYWN1dGVzbWFsbCIsIkFjaXJjdW1mbGV4c21hbGwiLCJBdGlsZGVzbWFsbCIsIkFkaWVyZXNpc3NtYWxsIiwiQXJpbmdzbWFsbCIsIkFFc21hbGwiLCJDY2VkaWxsYXNtYWxsIiwiRWdyYXZlc21hbGwiLCJFYWN1dGVzbWFsbCIsIkVjaXJjdW1mbGV4c21hbGwiLCJFZGllcmVzaXNzbWFsbCIsIklncmF2ZXNtYWxsIiwiSWFjdXRlc21hbGwiLCJJY2lyY3VtZmxleHNtYWxsIiwiSWRpZXJlc2lzc21hbGwiLCJFdGhzbWFsbCIsIk50aWxkZXNtYWxsIiwiT2dyYXZlc21hbGwiLCJPYWN1dGVzbWFsbCIsIk9jaXJjdW1mbGV4c21hbGwiLCJPdGlsZGVzbWFsbCIsIk9kaWVyZXNpc3NtYWxsIiwiT0VzbWFsbCIsIk9zbGFzaHNtYWxsIiwiVWdyYXZlc21hbGwiLCJVYWN1dGVzbWFsbCIsIlVjaXJjdW1mbGV4c21hbGwiLCJVZGllcmVzaXNzbWFsbCIsIllhY3V0ZXNtYWxsIiwiVGhvcm5zbWFsbCIsIllkaWVyZXNpc3NtYWxsIl0sY2E9WyIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCJzcGFjZSIsImV4Y2xhbXNtYWxsIiwiSHVuZ2FydW1sYXV0c21hbGwiLCJjZW50b2xkc3R5bGUiLCJkb2xsYXJvbGRzdHlsZSIsImRvbGxhcnN1cGVyaW9yIiwiYW1wZXJzYW5kc21hbGwiLCJBY3V0ZXNtYWxsIiwicGFyZW5sZWZ0c3VwZXJpb3IiLCJwYXJlbnJpZ2h0c3VwZXJpb3IiLCJ0d29kb3RlbmxlYWRlciIsIm9uZWRvdGVubGVhZGVyIiwiY29tbWEiLCJoeXBoZW4iLCJwZXJpb2QiLCJmcmFjdGlvbiIsInplcm9vbGRzdHlsZSIsIm9uZW9sZHN0eWxlIiwidHdvb2xkc3R5bGUiLCJ0aHJlZW9sZHN0eWxlIiwiZm91cm9sZHN0eWxlIiwiZml2ZW9sZHN0eWxlIiwic2l4b2xkc3R5bGUiLCJzZXZlbm9sZHN0eWxlIiwiZWlnaHRvbGRzdHlsZSIsIm5pbmVvbGRzdHlsZSIsImNvbG9uIiwic2VtaWNvbG9uIiwiIiwidGhyZWVxdWFydGVyc2VtZGFzaCIsIiIsInF1ZXN0aW9uc21hbGwiLCIiLCIiLCIiLCIiLCJFdGhzbWFsbCIsIiIsIiIsIm9uZXF1YXJ0ZXIiLCJvbmVoYWxmIiwidGhyZWVxdWFydGVycyIsIm9uZWVpZ2h0aCIsInRocmVlZWlnaHRocyIsImZpdmVlaWdodGhzIiwic2V2ZW5laWdodGhzIiwib25ldGhpcmQiLCJ0d290aGlyZHMiLCIiLCIiLCIiLCIiLCIiLCIiLCJmZiIsImZpIiwiZmwiLCJmZmkiLCJmZmwiLCJwYXJlbmxlZnRpbmZlcmlvciIsIiIsInBhcmVucmlnaHRpbmZlcmlvciIsIkNpcmN1bWZsZXhzbWFsbCIsImh5cGhlbmluZmVyaW9yIiwiR3JhdmVzbWFsbCIsIkFzbWFsbCIsIkJzbWFsbCIsIkNzbWFsbCIsIkRzbWFsbCIsIkVzbWFsbCIsIkZzbWFsbCIsIkdzbWFsbCIsIkhzbWFsbCIsIklzbWFsbCIsIkpzbWFsbCIsIktzbWFsbCIsIkxzbWFsbCIsIk1zbWFsbCIsIk5zbWFsbCIsIk9zbWFsbCIsIlBzbWFsbCIsIlFzbWFsbCIsIlJzbWFsbCIsIlNzbWFsbCIsIlRzbWFsbCIsIlVzbWFsbCIsIlZzbWFsbCIsIldzbWFsbCIsIlhzbWFsbCIsIllzbWFsbCIsIlpzbWFsbCIsImNvbG9ubW9uZXRhcnkiLCJvbmVmaXR0ZWQiLCJydXBpYWgiLCJUaWxkZXNtYWxsIiwiIiwiIiwiYXN1cGVyaW9yIiwiY2VudHN1cGVyaW9yIiwiIiwiIiwiIiwiIiwiQWFjdXRlc21hbGwiLCJBZ3JhdmVzbWFsbCIsIkFjaXJjdW1mbGV4c21hbGwiLCJBZGllcmVzaXNzbWFsbCIsIkF0aWxkZXNtYWxsIiwiQXJpbmdzbWFsbCIsIkNjZWRpbGxhc21hbGwiLCJFYWN1dGVzbWFsbCIsIkVncmF2ZXNtYWxsIiwiRWNpcmN1bWZsZXhzbWFsbCIsIkVkaWVyZXNpc3NtYWxsIiwiSWFjdXRlc21hbGwiLCJJZ3JhdmVzbWFsbCIsIkljaXJjdW1mbGV4c21hbGwiLCJJZGllcmVzaXNzbWFsbCIsIk50aWxkZXNtYWxsIiwiT2FjdXRlc21hbGwiLCJPZ3JhdmVzbWFsbCIsIk9jaXJjdW1mbGV4c21hbGwiLCJPZGllcmVzaXNzbWFsbCIsIk90aWxkZXNtYWxsIiwiVWFjdXRlc21hbGwiLCJVZ3JhdmVzbWFsbCIsIlVjaXJjdW1mbGV4c21hbGwiLCJVZGllcmVzaXNzbWFsbCIsIiIsImVpZ2h0c3VwZXJpb3IiLCJmb3VyaW5mZXJpb3IiLCJ0aHJlZWluZmVyaW9yIiwic2l4aW5mZXJpb3IiLCJlaWdodGluZmVyaW9yIiwic2V2ZW5pbmZlcmlvciIsIlNjYXJvbnNtYWxsIiwiIiwiY2VudGluZmVyaW9yIiwidHdvaW5mZXJpb3IiLCIiLCJEaWVyZXNpc3NtYWxsIiwiIiwiQ2Fyb25zbWFsbCIsIm9zdXBlcmlvciIsImZpdmVpbmZlcmlvciIsIiIsImNvbW1haW5mZXJpb3IiLCJwZXJpb2RpbmZlcmlvciIsIllhY3V0ZXNtYWxsIiwiIiwiZG9sbGFyaW5mZXJpb3IiLCIiLCIiLCJUaG9ybnNtYWxsIiwiIiwibmluZWluZmVyaW9yIiwiemVyb2luZmVyaW9yIiwiWmNhcm9uc21hbGwiLCJBRXNtYWxsIiwiT3NsYXNoc21hbGwiLCJxdWVzdGlvbmRvd25zbWFsbCIsIm9uZWluZmVyaW9yIiwiTHNsYXNoc21hbGwiLCIiLCIiLCIiLCIiLCIiLCIiLCJDZWRpbGxhc21hbGwiLCIiLCIiLCIiLCIiLCIiLCJPRXNtYWxsIiwiZmlndXJlZGFzaCIsImh5cGhlbnN1cGVyaW9yIiwiIiwiIiwiIiwiIiwiZXhjbGFtZG93bnNtYWxsIiwiIiwiWWRpZXJlc2lzc21hbGwiLCIiLCJvbmVzdXBlcmlvciIsInR3b3N1cGVyaW9yIiwidGhyZWVzdXBlcmlvciIsImZvdXJzdXBlcmlvciIsImZpdmVzdXBlcmlvciIsInNpeHN1cGVyaW9yIiwic2V2ZW5zdXBlcmlvciIsIm5pbmVzdXBlcmlvciIsInplcm9zdXBlcmlvciIsIiIsImVzdXBlcmlvciIsInJzdXBlcmlvciIsInRzdXBlcmlvciIsIiIsIiIsImlzdXBlcmlvciIsInNzdXBlcmlvciIsImRzdXBlcmlvciIsIiIsIiIsIiIsIiIsIiIsImxzdXBlcmlvciIsIk9nb25la3NtYWxsIiwiQnJldmVzbWFsbCIsIk1hY3JvbnNtYWxsIiwiYnN1cGVyaW9yIiwibnN1cGVyaW9yIiwibXN1cGVyaW9yIiwiY29tbWFzdXBlcmlvciIsInBlcmlvZHN1cGVyaW9yIiwiRG90YWNjZW50c21hbGwiLCJSaW5nc21hbGwiLCIiLCIiLCIiLCIiXSxsYT1bIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsInNwYWNlIiwiZXhjbGFtIiwicXVvdGVkYmwiLCJudW1iZXJzaWduIiwiZG9sbGFyIiwicGVyY2VudCIsImFtcGVyc2FuZCIsInF1b3Rlc2luZ2xlIiwicGFyZW5sZWZ0IiwicGFyZW5yaWdodCIsImFzdGVyaXNrIiwicGx1cyIsImNvbW1hIiwiaHlwaGVuIiwicGVyaW9kIiwic2xhc2giLCJ6ZXJvIiwib25lIiwidHdvIiwidGhyZWUiLCJmb3VyIiwiZml2ZSIsInNpeCIsInNldmVuIiwiZWlnaHQiLCJuaW5lIiwiY29sb24iLCJzZW1pY29sb24iLCJsZXNzIiwiZXF1YWwiLCJncmVhdGVyIiwicXVlc3Rpb24iLCJhdCIsIkEiLCJCIiwiQyIsIkQiLCJFIiwiRiIsIkciLCJIIiwiSSIsIkoiLCJLIiwiTCIsIk0iLCJOIiwiTyIsIlAiLCJRIiwiUiIsIlMiLCJUIiwiVSIsIlYiLCJXIiwiWCIsIlkiLCJaIiwiYnJhY2tldGxlZnQiLCJiYWNrc2xhc2giLCJicmFja2V0cmlnaHQiLCJhc2NpaWNpcmN1bSIsInVuZGVyc2NvcmUiLCJncmF2ZSIsImEiLCJiIiwiYyIsImQiLCJlIiwiZiIsImciLCJoIiwiaSIsImoiLCJrIiwibCIsIm0iLCJuIiwibyIsInAiLCJxIiwiciIsInMiLCJ0IiwidSIsInYiLCJ3IiwieCIsInkiLCJ6IiwiYnJhY2VsZWZ0IiwiYmFyIiwiYnJhY2VyaWdodCIsImFzY2lpdGlsZGUiLCIiLCJBZGllcmVzaXMiLCJBcmluZyIsIkNjZWRpbGxhIiwiRWFjdXRlIiwiTnRpbGRlIiwiT2RpZXJlc2lzIiwiVWRpZXJlc2lzIiwiYWFjdXRlIiwiYWdyYXZlIiwiYWNpcmN1bWZsZXgiLCJhZGllcmVzaXMiLCJhdGlsZGUiLCJhcmluZyIsImNjZWRpbGxhIiwiZWFjdXRlIiwiZWdyYXZlIiwiZWNpcmN1bWZsZXgiLCJlZGllcmVzaXMiLCJpYWN1dGUiLCJpZ3JhdmUiLCJpY2lyY3VtZmxleCIsImlkaWVyZXNpcyIsIm50aWxkZSIsIm9hY3V0ZSIsIm9ncmF2ZSIsIm9jaXJjdW1mbGV4Iiwib2RpZXJlc2lzIiwib3RpbGRlIiwidWFjdXRlIiwidWdyYXZlIiwidWNpcmN1bWZsZXgiLCJ1ZGllcmVzaXMiLCJkYWdnZXIiLCJkZWdyZWUiLCJjZW50Iiwic3RlcmxpbmciLCJzZWN0aW9uIiwiYnVsbGV0IiwicGFyYWdyYXBoIiwiZ2VybWFuZGJscyIsInJlZ2lzdGVyZWQiLCJjb3B5cmlnaHQiLCJ0cmFkZW1hcmsiLCJhY3V0ZSIsImRpZXJlc2lzIiwibm90ZXF1YWwiLCJBRSIsIk9zbGFzaCIsImluZmluaXR5IiwicGx1c21pbnVzIiwibGVzc2VxdWFsIiwiZ3JlYXRlcmVxdWFsIiwieWVuIiwibXUiLCJwYXJ0aWFsZGlmZiIsInN1bW1hdGlvbiIsInByb2R1Y3QiLCJwaSIsImludGVncmFsIiwib3JkZmVtaW5pbmUiLCJvcmRtYXNjdWxpbmUiLCJPbWVnYSIsImFlIiwib3NsYXNoIiwicXVlc3Rpb25kb3duIiwiZXhjbGFtZG93biIsImxvZ2ljYWxub3QiLCJyYWRpY2FsIiwiZmxvcmluIiwiYXBwcm94ZXF1YWwiLCJEZWx0YSIsImd1aWxsZW1vdGxlZnQiLCJndWlsbGVtb3RyaWdodCIsImVsbGlwc2lzIiwic3BhY2UiLCJBZ3JhdmUiLCJBdGlsZGUiLCJPdGlsZGUiLCJPRSIsIm9lIiwiZW5kYXNoIiwiZW1kYXNoIiwicXVvdGVkYmxsZWZ0IiwicXVvdGVkYmxyaWdodCIsInF1b3RlbGVmdCIsInF1b3RlcmlnaHQiLCJkaXZpZGUiLCJsb3plbmdlIiwieWRpZXJlc2lzIiwiWWRpZXJlc2lzIiwiZnJhY3Rpb24iLCJjdXJyZW5jeSIsImd1aWxzaW5nbGxlZnQiLCJndWlsc2luZ2xyaWdodCIsImZpIiwiZmwiLCJkYWdnZXJkYmwiLCJwZXJpb2RjZW50ZXJlZCIsInF1b3Rlc2luZ2xiYXNlIiwicXVvdGVkYmxiYXNlIiwicGVydGhvdXNhbmQiLCJBY2lyY3VtZmxleCIsIkVjaXJjdW1mbGV4IiwiQWFjdXRlIiwiRWRpZXJlc2lzIiwiRWdyYXZlIiwiSWFjdXRlIiwiSWNpcmN1bWZsZXgiLCJJZGllcmVzaXMiLCJJZ3JhdmUiLCJPYWN1dGUiLCJPY2lyY3VtZmxleCIsImFwcGxlIiwiT2dyYXZlIiwiVWFjdXRlIiwiVWNpcmN1bWZsZXgiLCJVZ3JhdmUiLCJkb3RsZXNzaSIsImNpcmN1bWZsZXgiLCJ0aWxkZSIsIm1hY3JvbiIsImJyZXZlIiwiZG90YWNjZW50IiwicmluZyIsImNlZGlsbGEiLCJodW5nYXJ1bWxhdXQiLCJvZ29uZWsiLCJjYXJvbiJdLGhhPVsiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwic3BhY2UiLCJleGNsYW0iLCJxdW90ZWRibCIsIm51bWJlcnNpZ24iLCJkb2xsYXIiLCJwZXJjZW50IiwiYW1wZXJzYW5kIiwicXVvdGVyaWdodCIsInBhcmVubGVmdCIsInBhcmVucmlnaHQiLCJhc3RlcmlzayIsInBsdXMiLCJjb21tYSIsImh5cGhlbiIsInBlcmlvZCIsInNsYXNoIiwiemVybyIsIm9uZSIsInR3byIsInRocmVlIiwiZm91ciIsImZpdmUiLCJzaXgiLCJzZXZlbiIsImVpZ2h0IiwibmluZSIsImNvbG9uIiwic2VtaWNvbG9uIiwibGVzcyIsImVxdWFsIiwiZ3JlYXRlciIsInF1ZXN0aW9uIiwiYXQiLCJBIiwiQiIsIkMiLCJEIiwiRSIsIkYiLCJHIiwiSCIsIkkiLCJKIiwiSyIsIkwiLCJNIiwiTiIsIk8iLCJQIiwiUSIsIlIiLCJTIiwiVCIsIlUiLCJWIiwiVyIsIlgiLCJZIiwiWiIsImJyYWNrZXRsZWZ0IiwiYmFja3NsYXNoIiwiYnJhY2tldHJpZ2h0IiwiYXNjaWljaXJjdW0iLCJ1bmRlcnNjb3JlIiwicXVvdGVsZWZ0IiwiYSIsImIiLCJjIiwiZCIsImUiLCJmIiwiZyIsImgiLCJpIiwiaiIsImsiLCJsIiwibSIsIm4iLCJvIiwicCIsInEiLCJyIiwicyIsInQiLCJ1IiwidiIsInciLCJ4IiwieSIsInoiLCJicmFjZWxlZnQiLCJiYXIiLCJicmFjZXJpZ2h0IiwiYXNjaWl0aWxkZSIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsImV4Y2xhbWRvd24iLCJjZW50Iiwic3RlcmxpbmciLCJmcmFjdGlvbiIsInllbiIsImZsb3JpbiIsInNlY3Rpb24iLCJjdXJyZW5jeSIsInF1b3Rlc2luZ2xlIiwicXVvdGVkYmxsZWZ0IiwiZ3VpbGxlbW90bGVmdCIsImd1aWxzaW5nbGxlZnQiLCJndWlsc2luZ2xyaWdodCIsImZpIiwiZmwiLCIiLCJlbmRhc2giLCJkYWdnZXIiLCJkYWdnZXJkYmwiLCJwZXJpb2RjZW50ZXJlZCIsIiIsInBhcmFncmFwaCIsImJ1bGxldCIsInF1b3Rlc2luZ2xiYXNlIiwicXVvdGVkYmxiYXNlIiwicXVvdGVkYmxyaWdodCIsImd1aWxsZW1vdHJpZ2h0IiwiZWxsaXBzaXMiLCJwZXJ0aG91c2FuZCIsIiIsInF1ZXN0aW9uZG93biIsIiIsImdyYXZlIiwiYWN1dGUiLCJjaXJjdW1mbGV4IiwidGlsZGUiLCJtYWNyb24iLCJicmV2ZSIsImRvdGFjY2VudCIsImRpZXJlc2lzIiwiIiwicmluZyIsImNlZGlsbGEiLCIiLCJodW5nYXJ1bWxhdXQiLCJvZ29uZWsiLCJjYXJvbiIsImVtZGFzaCIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIkFFIiwiIiwib3JkZmVtaW5pbmUiLCIiLCIiLCIiLCIiLCJMc2xhc2giLCJPc2xhc2giLCJPRSIsIm9yZG1hc2N1bGluZSIsIiIsIiIsIiIsIiIsIiIsImFlIiwiIiwiIiwiIiwiZG90bGVzc2kiLCIiLCIiLCJsc2xhc2giLCJvc2xhc2giLCJvZSIsImdlcm1hbmRibHMiLCIiLCIiLCIiLCIiXSx1YT1bIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsInNwYWNlIiwiZXhjbGFtIiwicXVvdGVkYmwiLCJudW1iZXJzaWduIiwiZG9sbGFyIiwicGVyY2VudCIsImFtcGVyc2FuZCIsInF1b3Rlc2luZ2xlIiwicGFyZW5sZWZ0IiwicGFyZW5yaWdodCIsImFzdGVyaXNrIiwicGx1cyIsImNvbW1hIiwiaHlwaGVuIiwicGVyaW9kIiwic2xhc2giLCJ6ZXJvIiwib25lIiwidHdvIiwidGhyZWUiLCJmb3VyIiwiZml2ZSIsInNpeCIsInNldmVuIiwiZWlnaHQiLCJuaW5lIiwiY29sb24iLCJzZW1pY29sb24iLCJsZXNzIiwiZXF1YWwiLCJncmVhdGVyIiwicXVlc3Rpb24iLCJhdCIsIkEiLCJCIiwiQyIsIkQiLCJFIiwiRiIsIkciLCJIIiwiSSIsIkoiLCJLIiwiTCIsIk0iLCJOIiwiTyIsIlAiLCJRIiwiUiIsIlMiLCJUIiwiVSIsIlYiLCJXIiwiWCIsIlkiLCJaIiwiYnJhY2tldGxlZnQiLCJiYWNrc2xhc2giLCJicmFja2V0cmlnaHQiLCJhc2NpaWNpcmN1bSIsInVuZGVyc2NvcmUiLCJncmF2ZSIsImEiLCJiIiwiYyIsImQiLCJlIiwiZiIsImciLCJoIiwiaSIsImoiLCJrIiwibCIsIm0iLCJuIiwibyIsInAiLCJxIiwiciIsInMiLCJ0IiwidSIsInYiLCJ3IiwieCIsInkiLCJ6IiwiYnJhY2VsZWZ0IiwiYmFyIiwiYnJhY2VyaWdodCIsImFzY2lpdGlsZGUiLCJidWxsZXQiLCJFdXJvIiwiYnVsbGV0IiwicXVvdGVzaW5nbGJhc2UiLCJmbG9yaW4iLCJxdW90ZWRibGJhc2UiLCJlbGxpcHNpcyIsImRhZ2dlciIsImRhZ2dlcmRibCIsImNpcmN1bWZsZXgiLCJwZXJ0aG91c2FuZCIsIlNjYXJvbiIsImd1aWxzaW5nbGxlZnQiLCJPRSIsImJ1bGxldCIsIlpjYXJvbiIsImJ1bGxldCIsImJ1bGxldCIsInF1b3RlbGVmdCIsInF1b3RlcmlnaHQiLCJxdW90ZWRibGxlZnQiLCJxdW90ZWRibHJpZ2h0IiwiYnVsbGV0IiwiZW5kYXNoIiwiZW1kYXNoIiwidGlsZGUiLCJ0cmFkZW1hcmsiLCJzY2Fyb24iLCJndWlsc2luZ2xyaWdodCIsIm9lIiwiYnVsbGV0IiwiemNhcm9uIiwiWWRpZXJlc2lzIiwic3BhY2UiLCJleGNsYW1kb3duIiwiY2VudCIsInN0ZXJsaW5nIiwiY3VycmVuY3kiLCJ5ZW4iLCJicm9rZW5iYXIiLCJzZWN0aW9uIiwiZGllcmVzaXMiLCJjb3B5cmlnaHQiLCJvcmRmZW1pbmluZSIsImd1aWxsZW1vdGxlZnQiLCJsb2dpY2Fsbm90IiwiaHlwaGVuIiwicmVnaXN0ZXJlZCIsIm1hY3JvbiIsImRlZ3JlZSIsInBsdXNtaW51cyIsInR3b3N1cGVyaW9yIiwidGhyZWVzdXBlcmlvciIsImFjdXRlIiwibXUiLCJwYXJhZ3JhcGgiLCJwZXJpb2RjZW50ZXJlZCIsImNlZGlsbGEiLCJvbmVzdXBlcmlvciIsIm9yZG1hc2N1bGluZSIsImd1aWxsZW1vdHJpZ2h0Iiwib25lcXVhcnRlciIsIm9uZWhhbGYiLCJ0aHJlZXF1YXJ0ZXJzIiwicXVlc3Rpb25kb3duIiwiQWdyYXZlIiwiQWFjdXRlIiwiQWNpcmN1bWZsZXgiLCJBdGlsZGUiLCJBZGllcmVzaXMiLCJBcmluZyIsIkFFIiwiQ2NlZGlsbGEiLCJFZ3JhdmUiLCJFYWN1dGUiLCJFY2lyY3VtZmxleCIsIkVkaWVyZXNpcyIsIklncmF2ZSIsIklhY3V0ZSIsIkljaXJjdW1mbGV4IiwiSWRpZXJlc2lzIiwiRXRoIiwiTnRpbGRlIiwiT2dyYXZlIiwiT2FjdXRlIiwiT2NpcmN1bWZsZXgiLCJPdGlsZGUiLCJPZGllcmVzaXMiLCJtdWx0aXBseSIsIk9zbGFzaCIsIlVncmF2ZSIsIlVhY3V0ZSIsIlVjaXJjdW1mbGV4IiwiVWRpZXJlc2lzIiwiWWFjdXRlIiwiVGhvcm4iLCJnZXJtYW5kYmxzIiwiYWdyYXZlIiwiYWFjdXRlIiwiYWNpcmN1bWZsZXgiLCJhdGlsZGUiLCJhZGllcmVzaXMiLCJhcmluZyIsImFlIiwiY2NlZGlsbGEiLCJlZ3JhdmUiLCJlYWN1dGUiLCJlY2lyY3VtZmxleCIsImVkaWVyZXNpcyIsImlncmF2ZSIsImlhY3V0ZSIsImljaXJjdW1mbGV4IiwiaWRpZXJlc2lzIiwiZXRoIiwibnRpbGRlIiwib2dyYXZlIiwib2FjdXRlIiwib2NpcmN1bWZsZXgiLCJvdGlsZGUiLCJvZGllcmVzaXMiLCJkaXZpZGUiLCJvc2xhc2giLCJ1Z3JhdmUiLCJ1YWN1dGUiLCJ1Y2lyY3VtZmxleCIsInVkaWVyZXNpcyIsInlhY3V0ZSIsInRob3JuIiwieWRpZXJlc2lzIl0sZGE9WyIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCIiLCJzcGFjZSIsImV4Y2xhbSIsInVuaXZlcnNhbCIsIm51bWJlcnNpZ24iLCJleGlzdGVudGlhbCIsInBlcmNlbnQiLCJhbXBlcnNhbmQiLCJzdWNodGhhdCIsInBhcmVubGVmdCIsInBhcmVucmlnaHQiLCJhc3Rlcmlza21hdGgiLCJwbHVzIiwiY29tbWEiLCJtaW51cyIsInBlcmlvZCIsInNsYXNoIiwiemVybyIsIm9uZSIsInR3byIsInRocmVlIiwiZm91ciIsImZpdmUiLCJzaXgiLCJzZXZlbiIsImVpZ2h0IiwibmluZSIsImNvbG9uIiwic2VtaWNvbG9uIiwibGVzcyIsImVxdWFsIiwiZ3JlYXRlciIsInF1ZXN0aW9uIiwiY29uZ3J1ZW50IiwiQWxwaGEiLCJCZXRhIiwiQ2hpIiwiRGVsdGEiLCJFcHNpbG9uIiwiUGhpIiwiR2FtbWEiLCJFdGEiLCJJb3RhIiwidGhldGExIiwiS2FwcGEiLCJMYW1iZGEiLCJNdSIsIk51IiwiT21pY3JvbiIsIlBpIiwiVGhldGEiLCJSaG8iLCJTaWdtYSIsIlRhdSIsIlVwc2lsb24iLCJzaWdtYTEiLCJPbWVnYSIsIlhpIiwiUHNpIiwiWmV0YSIsImJyYWNrZXRsZWZ0IiwidGhlcmVmb3JlIiwiYnJhY2tldHJpZ2h0IiwicGVycGVuZGljdWxhciIsInVuZGVyc2NvcmUiLCJyYWRpY2FsZXgiLCJhbHBoYSIsImJldGEiLCJjaGkiLCJkZWx0YSIsImVwc2lsb24iLCJwaGkiLCJnYW1tYSIsImV0YSIsImlvdGEiLCJwaGkxIiwia2FwcGEiLCJsYW1iZGEiLCJtdSIsIm51Iiwib21pY3JvbiIsInBpIiwidGhldGEiLCJyaG8iLCJzaWdtYSIsInRhdSIsInVwc2lsb24iLCJvbWVnYTEiLCJvbWVnYSIsInhpIiwicHNpIiwiemV0YSIsImJyYWNlbGVmdCIsImJhciIsImJyYWNlcmlnaHQiLCJzaW1pbGFyIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiIiwiRXVybyIsIlVwc2lsb24xIiwibWludXRlIiwibGVzc2VxdWFsIiwiZnJhY3Rpb24iLCJpbmZpbml0eSIsImZsb3JpbiIsImNsdWIiLCJkaWFtb25kIiwiaGVhcnQiLCJzcGFkZSIsImFycm93Ym90aCIsImFycm93bGVmdCIsImFycm93dXAiLCJhcnJvd3JpZ2h0IiwiYXJyb3dkb3duIiwiZGVncmVlIiwicGx1c21pbnVzIiwic2Vjb25kIiwiZ3JlYXRlcmVxdWFsIiwibXVsdGlwbHkiLCJwcm9wb3J0aW9uYWwiLCJwYXJ0aWFsZGlmZiIsImJ1bGxldCIsImRpdmlkZSIsIm5vdGVxdWFsIiwiZXF1aXZhbGVuY2UiLCJhcHByb3hlcXVhbCIsImVsbGlwc2lzIiwiYXJyb3d2ZXJ0ZXgiLCJhcnJvd2hvcml6ZXgiLCJjYXJyaWFnZXJldHVybiIsImFsZXBoIiwiSWZyYWt0dXIiLCJSZnJha3R1ciIsIndlaWVyc3RyYXNzIiwiY2lyY2xlbXVsdGlwbHkiLCJjaXJjbGVwbHVzIiwiZW1wdHlzZXQiLCJpbnRlcnNlY3Rpb24iLCJ1bmlvbiIsInByb3BlcnN1cGVyc2V0IiwicmVmbGV4c3VwZXJzZXQiLCJub3RzdWJzZXQiLCJwcm9wZXJzdWJzZXQiLCJyZWZsZXhzdWJzZXQiLCJlbGVtZW50Iiwibm90ZWxlbWVudCIsImFuZ2xlIiwiZ3JhZGllbnQiLCJyZWdpc3RlcnNlcmlmIiwiY29weXJpZ2h0c2VyaWYiLCJ0cmFkZW1hcmtzZXJpZiIsInByb2R1Y3QiLCJyYWRpY2FsIiwiZG90bWF0aCIsImxvZ2ljYWxub3QiLCJsb2dpY2FsYW5kIiwibG9naWNhbG9yIiwiYXJyb3dkYmxib3RoIiwiYXJyb3dkYmxsZWZ0IiwiYXJyb3dkYmx1cCIsImFycm93ZGJscmlnaHQiLCJhcnJvd2RibGRvd24iLCJsb3plbmdlIiwiYW5nbGVsZWZ0IiwicmVnaXN0ZXJzYW5zIiwiY29weXJpZ2h0c2FucyIsInRyYWRlbWFya3NhbnMiLCJzdW1tYXRpb24iLCJwYXJlbmxlZnR0cCIsInBhcmVubGVmdGV4IiwicGFyZW5sZWZ0YnQiLCJicmFja2V0bGVmdHRwIiwiYnJhY2tldGxlZnRleCIsImJyYWNrZXRsZWZ0YnQiLCJicmFjZWxlZnR0cCIsImJyYWNlbGVmdG1pZCIsImJyYWNlbGVmdGJ0IiwiYnJhY2VleCIsIiIsImFuZ2xlcmlnaHQiLCJpbnRlZ3JhbCIsImludGVncmFsdHAiLCJpbnRlZ3JhbGV4IiwiaW50ZWdyYWxidCIsInBhcmVucmlnaHR0cCIsInBhcmVucmlnaHRleCIsInBhcmVucmlnaHRidCIsImJyYWNrZXRyaWdodHRwIiwiYnJhY2tldHJpZ2h0ZXgiLCJicmFja2V0cmlnaHRidCIsImJyYWNlcmlnaHR0cCIsImJyYWNlcmlnaHRtaWQiLCJicmFjZXJpZ2h0YnQiLCIiXSxmYT1bIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsInNwYWNlIiwiYTEiLCJhMiIsImEyMDIiLCJhMyIsImE0IiwiYTUiLCJhMTE5IiwiYTExOCIsImExMTciLCJhMTEiLCJhMTIiLCJhMTMiLCJhMTQiLCJhMTUiLCJhMTYiLCJhMTA1IiwiYTE3IiwiYTE4IiwiYTE5IiwiYTIwIiwiYTIxIiwiYTIyIiwiYTIzIiwiYTI0IiwiYTI1IiwiYTI2IiwiYTI3IiwiYTI4IiwiYTYiLCJhNyIsImE4IiwiYTkiLCJhMTAiLCJhMjkiLCJhMzAiLCJhMzEiLCJhMzIiLCJhMzMiLCJhMzQiLCJhMzUiLCJhMzYiLCJhMzciLCJhMzgiLCJhMzkiLCJhNDAiLCJhNDEiLCJhNDIiLCJhNDMiLCJhNDQiLCJhNDUiLCJhNDYiLCJhNDciLCJhNDgiLCJhNDkiLCJhNTAiLCJhNTEiLCJhNTIiLCJhNTMiLCJhNTQiLCJhNTUiLCJhNTYiLCJhNTciLCJhNTgiLCJhNTkiLCJhNjAiLCJhNjEiLCJhNjIiLCJhNjMiLCJhNjQiLCJhNjUiLCJhNjYiLCJhNjciLCJhNjgiLCJhNjkiLCJhNzAiLCJhNzEiLCJhNzIiLCJhNzMiLCJhNzQiLCJhMjAzIiwiYTc1IiwiYTIwNCIsImE3NiIsImE3NyIsImE3OCIsImE3OSIsImE4MSIsImE4MiIsImE4MyIsImE4NCIsImE5NyIsImE5OCIsImE5OSIsImExMDAiLCIiLCJhODkiLCJhOTAiLCJhOTMiLCJhOTQiLCJhOTEiLCJhOTIiLCJhMjA1IiwiYTg1IiwiYTIwNiIsImE4NiIsImE4NyIsImE4OCIsImE5NSIsImE5NiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsIiIsImExMDEiLCJhMTAyIiwiYTEwMyIsImExMDQiLCJhMTA2IiwiYTEwNyIsImExMDgiLCJhMTEyIiwiYTExMSIsImExMTAiLCJhMTA5IiwiYTEyMCIsImExMjEiLCJhMTIyIiwiYTEyMyIsImExMjQiLCJhMTI1IiwiYTEyNiIsImExMjciLCJhMTI4IiwiYTEyOSIsImExMzAiLCJhMTMxIiwiYTEzMiIsImExMzMiLCJhMTM0IiwiYTEzNSIsImExMzYiLCJhMTM3IiwiYTEzOCIsImExMzkiLCJhMTQwIiwiYTE0MSIsImExNDIiLCJhMTQzIiwiYTE0NCIsImExNDUiLCJhMTQ2IiwiYTE0NyIsImExNDgiLCJhMTQ5IiwiYTE1MCIsImExNTEiLCJhMTUyIiwiYTE1MyIsImExNTQiLCJhMTU1IiwiYTE1NiIsImExNTciLCJhMTU4IiwiYTE1OSIsImExNjAiLCJhMTYxIiwiYTE2MyIsImExNjQiLCJhMTk2IiwiYTE2NSIsImExOTIiLCJhMTY2IiwiYTE2NyIsImExNjgiLCJhMTY5IiwiYTE3MCIsImExNzEiLCJhMTcyIiwiYTE3MyIsImExNjIiLCJhMTc0IiwiYTE3NSIsImExNzYiLCJhMTc3IiwiYTE3OCIsImExNzkiLCJhMTkzIiwiYTE4MCIsImExOTkiLCJhMTgxIiwiYTIwMCIsImExODIiLCIiLCJhMjAxIiwiYTE4MyIsImExODQiLCJhMTk3IiwiYTE4NSIsImExOTQiLCJhMTk4IiwiYTE4NiIsImExOTUiLCJhMTg3IiwiYTE4OCIsImExODkiLCJhMTkwIiwiYTE5MSIsIiJdO2Z1bmN0aW9uIGdldEVuY29kaW5nKGUpe3N3aXRjaChlKXtjYXNlIldpbkFuc2lFbmNvZGluZyI6cmV0dXJuIHVhO2Nhc2UiU3RhbmRhcmRFbmNvZGluZyI6cmV0dXJuIGhhO2Nhc2UiTWFjUm9tYW5FbmNvZGluZyI6cmV0dXJuIGxhO2Nhc2UiU3ltYm9sU2V0RW5jb2RpbmciOnJldHVybiBkYTtjYXNlIlphcGZEaW5nYmF0c0VuY29kaW5nIjpyZXR1cm4gZmE7Y2FzZSJFeHBlcnRFbmNvZGluZyI6cmV0dXJuIG9hO2Nhc2UiTWFjRXhwZXJ0RW5jb2RpbmciOnJldHVybiBjYTtkZWZhdWx0OnJldHVybiBudWxsfX1jb25zdCBnYT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5BPTY1O2UuQUU9MTk4O2UuQUVhY3V0ZT01MDg7ZS5BRW1hY3Jvbj00ODI7ZS5BRXNtYWxsPTYzNDYyO2UuQWFjdXRlPTE5MztlLkFhY3V0ZXNtYWxsPTYzNDU3O2UuQWJyZXZlPTI1ODtlLkFicmV2ZWFjdXRlPTc4NTQ7ZS5BYnJldmVjeXJpbGxpYz0xMjMyO2UuQWJyZXZlZG90YmVsb3c9Nzg2MjtlLkFicmV2ZWdyYXZlPTc4NTY7ZS5BYnJldmVob29rYWJvdmU9Nzg1ODtlLkFicmV2ZXRpbGRlPTc4NjA7ZS5BY2Fyb249NDYxO2UuQWNpcmNsZT05Mzk4O2UuQWNpcmN1bWZsZXg9MTk0O2UuQWNpcmN1bWZsZXhhY3V0ZT03ODQ0O2UuQWNpcmN1bWZsZXhkb3RiZWxvdz03ODUyO2UuQWNpcmN1bWZsZXhncmF2ZT03ODQ2O2UuQWNpcmN1bWZsZXhob29rYWJvdmU9Nzg0ODtlLkFjaXJjdW1mbGV4c21hbGw9NjM0NTg7ZS5BY2lyY3VtZmxleHRpbGRlPTc4NTA7ZS5BY3V0ZT02MzE3NztlLkFjdXRlc21hbGw9NjM0MTI7ZS5BY3lyaWxsaWM9MTA0MDtlLkFkYmxncmF2ZT01MTI7ZS5BZGllcmVzaXM9MTk2O2UuQWRpZXJlc2lzY3lyaWxsaWM9MTIzNDtlLkFkaWVyZXNpc21hY3Jvbj00Nzg7ZS5BZGllcmVzaXNzbWFsbD02MzQ2MDtlLkFkb3RiZWxvdz03ODQwO2UuQWRvdG1hY3Jvbj00ODA7ZS5BZ3JhdmU9MTkyO2UuQWdyYXZlc21hbGw9NjM0NTY7ZS5BaG9va2Fib3ZlPTc4NDI7ZS5BaWVjeXJpbGxpYz0xMjM2O2UuQWludmVydGVkYnJldmU9NTE0O2UuQWxwaGE9OTEzO2UuQWxwaGF0b25vcz05MDI7ZS5BbWFjcm9uPTI1NjtlLkFtb25vc3BhY2U9NjUzMTM7ZS5Bb2dvbmVrPTI2MDtlLkFyaW5nPTE5NztlLkFyaW5nYWN1dGU9NTA2O2UuQXJpbmdiZWxvdz03NjgwO2UuQXJpbmdzbWFsbD02MzQ2MTtlLkFzbWFsbD02MzMyOTtlLkF0aWxkZT0xOTU7ZS5BdGlsZGVzbWFsbD02MzQ1OTtlLkF5YmFybWVuaWFuPTEzMjk7ZS5CPTY2O2UuQmNpcmNsZT05Mzk5O2UuQmRvdGFjY2VudD03NjgyO2UuQmRvdGJlbG93PTc2ODQ7ZS5CZWN5cmlsbGljPTEwNDE7ZS5CZW5hcm1lbmlhbj0xMzMwO2UuQmV0YT05MTQ7ZS5CaG9vaz0zODU7ZS5CbGluZWJlbG93PTc2ODY7ZS5CbW9ub3NwYWNlPTY1MzE0O2UuQnJldmVzbWFsbD02MzIyMDtlLkJzbWFsbD02MzMzMDtlLkJ0b3BiYXI9Mzg2O2UuQz02NztlLkNhYXJtZW5pYW49MTM0MjtlLkNhY3V0ZT0yNjI7ZS5DYXJvbj02MzE3ODtlLkNhcm9uc21hbGw9NjMyMjE7ZS5DY2Fyb249MjY4O2UuQ2NlZGlsbGE9MTk5O2UuQ2NlZGlsbGFhY3V0ZT03Njg4O2UuQ2NlZGlsbGFzbWFsbD02MzQ2MztlLkNjaXJjbGU9OTQwMDtlLkNjaXJjdW1mbGV4PTI2NDtlLkNkb3Q9MjY2O2UuQ2RvdGFjY2VudD0yNjY7ZS5DZWRpbGxhc21hbGw9NjM0MTY7ZS5DaGFhcm1lbmlhbj0xMzUzO2UuQ2hlYWJraGFzaWFuY3lyaWxsaWM9MTIxMjtlLkNoZWN5cmlsbGljPTEwNjM7ZS5DaGVkZXNjZW5kZXJhYmtoYXNpYW5jeXJpbGxpYz0xMjE0O2UuQ2hlZGVzY2VuZGVyY3lyaWxsaWM9MTIwNjtlLkNoZWRpZXJlc2lzY3lyaWxsaWM9MTI2ODtlLkNoZWhhcm1lbmlhbj0xMzQ3O2UuQ2hla2hha2Fzc2lhbmN5cmlsbGljPTEyMjc7ZS5DaGV2ZXJ0aWNhbHN0cm9rZWN5cmlsbGljPTEyMDg7ZS5DaGk9OTM1O2UuQ2hvb2s9MzkxO2UuQ2lyY3VtZmxleHNtYWxsPTYzMjIyO2UuQ21vbm9zcGFjZT02NTMxNTtlLkNvYXJtZW5pYW49MTM2MTtlLkNzbWFsbD02MzMzMTtlLkQ9Njg7ZS5EWj00OTc7ZS5EWmNhcm9uPTQ1MjtlLkRhYXJtZW5pYW49MTMzMjtlLkRhZnJpY2FuPTM5MztlLkRjYXJvbj0yNzA7ZS5EY2VkaWxsYT03Njk2O2UuRGNpcmNsZT05NDAxO2UuRGNpcmN1bWZsZXhiZWxvdz03Njk4O2UuRGNyb2F0PTI3MjtlLkRkb3RhY2NlbnQ9NzY5MDtlLkRkb3RiZWxvdz03NjkyO2UuRGVjeXJpbGxpYz0xMDQ0O2UuRGVpY29wdGljPTEwMDY7ZS5EZWx0YT04NzEwO2UuRGVsdGFncmVlaz05MTY7ZS5EaG9vaz0zOTQ7ZS5EaWVyZXNpcz02MzE3OTtlLkRpZXJlc2lzQWN1dGU9NjMxODA7ZS5EaWVyZXNpc0dyYXZlPTYzMTgxO2UuRGllcmVzaXNzbWFsbD02MzQwMDtlLkRpZ2FtbWFncmVlaz05ODg7ZS5EamVjeXJpbGxpYz0xMDI2O2UuRGxpbmViZWxvdz03Njk0O2UuRG1vbm9zcGFjZT02NTMxNjtlLkRvdGFjY2VudHNtYWxsPTYzMjIzO2UuRHNsYXNoPTI3MjtlLkRzbWFsbD02MzMzMjtlLkR0b3BiYXI9Mzk1O2UuRHo9NDk4O2UuRHpjYXJvbj00NTM7ZS5EemVhYmtoYXNpYW5jeXJpbGxpYz0xMjQ4O2UuRHplY3lyaWxsaWM9MTAyOTtlLkR6aGVjeXJpbGxpYz0xMDM5O2UuRT02OTtlLkVhY3V0ZT0yMDE7ZS5FYWN1dGVzbWFsbD02MzQ2NTtlLkVicmV2ZT0yNzY7ZS5FY2Fyb249MjgyO2UuRWNlZGlsbGFicmV2ZT03NzA4O2UuRWNoYXJtZW5pYW49MTMzMztlLkVjaXJjbGU9OTQwMjtlLkVjaXJjdW1mbGV4PTIwMjtlLkVjaXJjdW1mbGV4YWN1dGU9Nzg3MDtlLkVjaXJjdW1mbGV4YmVsb3c9NzcwNDtlLkVjaXJjdW1mbGV4ZG90YmVsb3c9Nzg3ODtlLkVjaXJjdW1mbGV4Z3JhdmU9Nzg3MjtlLkVjaXJjdW1mbGV4aG9va2Fib3ZlPTc4NzQ7ZS5FY2lyY3VtZmxleHNtYWxsPTYzNDY2O2UuRWNpcmN1bWZsZXh0aWxkZT03ODc2O2UuRWN5cmlsbGljPTEwMjg7ZS5FZGJsZ3JhdmU9NTE2O2UuRWRpZXJlc2lzPTIwMztlLkVkaWVyZXNpc3NtYWxsPTYzNDY3O2UuRWRvdD0yNzg7ZS5FZG90YWNjZW50PTI3ODtlLkVkb3RiZWxvdz03ODY0O2UuRWZjeXJpbGxpYz0xMDYwO2UuRWdyYXZlPTIwMDtlLkVncmF2ZXNtYWxsPTYzNDY0O2UuRWhhcm1lbmlhbj0xMzM1O2UuRWhvb2thYm92ZT03ODY2O2UuRWlnaHRyb21hbj04NTUxO2UuRWludmVydGVkYnJldmU9NTE4O2UuRWlvdGlmaWVkY3lyaWxsaWM9MTEyNDtlLkVsY3lyaWxsaWM9MTA1MTtlLkVsZXZlbnJvbWFuPTg1NTQ7ZS5FbWFjcm9uPTI3NDtlLkVtYWNyb25hY3V0ZT03NzAyO2UuRW1hY3JvbmdyYXZlPTc3MDA7ZS5FbWN5cmlsbGljPTEwNTI7ZS5FbW9ub3NwYWNlPTY1MzE3O2UuRW5jeXJpbGxpYz0xMDUzO2UuRW5kZXNjZW5kZXJjeXJpbGxpYz0xMTg2O2UuRW5nPTMzMDtlLkVuZ2hlY3lyaWxsaWM9MTE4ODtlLkVuaG9va2N5cmlsbGljPTEyMjM7ZS5Fb2dvbmVrPTI4MDtlLkVvcGVuPTQwMDtlLkVwc2lsb249OTE3O2UuRXBzaWxvbnRvbm9zPTkwNDtlLkVyY3lyaWxsaWM9MTA1NjtlLkVyZXZlcnNlZD0zOTg7ZS5FcmV2ZXJzZWRjeXJpbGxpYz0xMDY5O2UuRXNjeXJpbGxpYz0xMDU3O2UuRXNkZXNjZW5kZXJjeXJpbGxpYz0xMTk0O2UuRXNoPTQyNTtlLkVzbWFsbD02MzMzMztlLkV0YT05MTk7ZS5FdGFybWVuaWFuPTEzMzY7ZS5FdGF0b25vcz05MDU7ZS5FdGg9MjA4O2UuRXRoc21hbGw9NjM0NzI7ZS5FdGlsZGU9Nzg2ODtlLkV0aWxkZWJlbG93PTc3MDY7ZS5FdXJvPTgzNjQ7ZS5Femg9NDM5O2UuRXpoY2Fyb249NDk0O2UuRXpocmV2ZXJzZWQ9NDQwO2UuRj03MDtlLkZjaXJjbGU9OTQwMztlLkZkb3RhY2NlbnQ9NzcxMDtlLkZlaGFybWVuaWFuPTEzNjY7ZS5GZWljb3B0aWM9OTk2O2UuRmhvb2s9NDAxO2UuRml0YWN5cmlsbGljPTExMzg7ZS5GaXZlcm9tYW49ODU0ODtlLkZtb25vc3BhY2U9NjUzMTg7ZS5Gb3Vycm9tYW49ODU0NztlLkZzbWFsbD02MzMzNDtlLkc9NzE7ZS5HQnNxdWFyZT0xMzE5MTtlLkdhY3V0ZT01MDA7ZS5HYW1tYT05MTU7ZS5HYW1tYWFmcmljYW49NDA0O2UuR2FuZ2lhY29wdGljPTEwMDI7ZS5HYnJldmU9Mjg2O2UuR2Nhcm9uPTQ4NjtlLkdjZWRpbGxhPTI5MDtlLkdjaXJjbGU9OTQwNDtlLkdjaXJjdW1mbGV4PTI4NDtlLkdjb21tYWFjY2VudD0yOTA7ZS5HZG90PTI4ODtlLkdkb3RhY2NlbnQ9Mjg4O2UuR2VjeXJpbGxpYz0xMDQzO2UuR2hhZGFybWVuaWFuPTEzNDY7ZS5HaGVtaWRkbGVob29rY3lyaWxsaWM9MTE3MjtlLkdoZXN0cm9rZWN5cmlsbGljPTExNzA7ZS5HaGV1cHR1cm5jeXJpbGxpYz0xMTY4O2UuR2hvb2s9NDAzO2UuR2ltYXJtZW5pYW49MTMzMTtlLkdqZWN5cmlsbGljPTEwMjc7ZS5HbWFjcm9uPTc3MTI7ZS5HbW9ub3NwYWNlPTY1MzE5O2UuR3JhdmU9NjMxODI7ZS5HcmF2ZXNtYWxsPTYzMzI4O2UuR3NtYWxsPTYzMzM1O2UuR3NtYWxsaG9vaz02Njc7ZS5Hc3Ryb2tlPTQ4NDtlLkg9NzI7ZS5IMTg1MzM9OTY3OTtlLkgxODU0Mz05NjQyO2UuSDE4NTUxPTk2NDM7ZS5IMjIwNzM9OTYzMztlLkhQc3F1YXJlPTEzMjU5O2UuSGFhYmtoYXNpYW5jeXJpbGxpYz0xMTkyO2UuSGFkZXNjZW5kZXJjeXJpbGxpYz0xMjAyO2UuSGFyZHNpZ25jeXJpbGxpYz0xMDY2O2UuSGJhcj0yOTQ7ZS5IYnJldmViZWxvdz03NzIyO2UuSGNlZGlsbGE9NzcyMDtlLkhjaXJjbGU9OTQwNTtlLkhjaXJjdW1mbGV4PTI5MjtlLkhkaWVyZXNpcz03NzE4O2UuSGRvdGFjY2VudD03NzE0O2UuSGRvdGJlbG93PTc3MTY7ZS5IbW9ub3NwYWNlPTY1MzIwO2UuSG9hcm1lbmlhbj0xMzQ0O2UuSG9yaWNvcHRpYz0xZTM7ZS5Ic21hbGw9NjMzMzY7ZS5IdW5nYXJ1bWxhdXQ9NjMxODM7ZS5IdW5nYXJ1bWxhdXRzbWFsbD02MzIyNDtlLkh6c3F1YXJlPTEzMjAwO2UuST03MztlLklBY3lyaWxsaWM9MTA3MTtlLklKPTMwNjtlLklVY3lyaWxsaWM9MTA3MDtlLklhY3V0ZT0yMDU7ZS5JYWN1dGVzbWFsbD02MzQ2OTtlLklicmV2ZT0zMDA7ZS5JY2Fyb249NDYzO2UuSWNpcmNsZT05NDA2O2UuSWNpcmN1bWZsZXg9MjA2O2UuSWNpcmN1bWZsZXhzbWFsbD02MzQ3MDtlLkljeXJpbGxpYz0xMDMwO2UuSWRibGdyYXZlPTUyMDtlLklkaWVyZXNpcz0yMDc7ZS5JZGllcmVzaXNhY3V0ZT03NzI2O2UuSWRpZXJlc2lzY3lyaWxsaWM9MTI1MjtlLklkaWVyZXNpc3NtYWxsPTYzNDcxO2UuSWRvdD0zMDQ7ZS5JZG90YWNjZW50PTMwNDtlLklkb3RiZWxvdz03ODgyO2UuSWVicmV2ZWN5cmlsbGljPTEyMzg7ZS5JZWN5cmlsbGljPTEwNDU7ZS5JZnJha3R1cj04NDY1O2UuSWdyYXZlPTIwNDtlLklncmF2ZXNtYWxsPTYzNDY4O2UuSWhvb2thYm92ZT03ODgwO2UuSWljeXJpbGxpYz0xMDQ4O2UuSWludmVydGVkYnJldmU9NTIyO2UuSWlzaG9ydGN5cmlsbGljPTEwNDk7ZS5JbWFjcm9uPTI5ODtlLkltYWNyb25jeXJpbGxpYz0xMjUwO2UuSW1vbm9zcGFjZT02NTMyMTtlLkluaWFybWVuaWFuPTEzMzk7ZS5Jb2N5cmlsbGljPTEwMjU7ZS5Jb2dvbmVrPTMwMjtlLklvdGE9OTIxO2UuSW90YWFmcmljYW49NDA2O2UuSW90YWRpZXJlc2lzPTkzODtlLklvdGF0b25vcz05MDY7ZS5Jc21hbGw9NjMzMzc7ZS5Jc3Ryb2tlPTQwNztlLkl0aWxkZT0yOTY7ZS5JdGlsZGViZWxvdz03NzI0O2UuSXpoaXRzYWN5cmlsbGljPTExNDA7ZS5JemhpdHNhZGJsZ3JhdmVjeXJpbGxpYz0xMTQyO2UuSj03NDtlLkphYXJtZW5pYW49MTM0NTtlLkpjaXJjbGU9OTQwNztlLkpjaXJjdW1mbGV4PTMwODtlLkplY3lyaWxsaWM9MTAzMjtlLkpoZWhhcm1lbmlhbj0xMzU1O2UuSm1vbm9zcGFjZT02NTMyMjtlLkpzbWFsbD02MzMzODtlLks9NzU7ZS5LQnNxdWFyZT0xMzE4OTtlLktLc3F1YXJlPTEzMjYxO2UuS2FiYXNoa2lyY3lyaWxsaWM9MTE4NDtlLkthY3V0ZT03NzI4O2UuS2FjeXJpbGxpYz0xMDUwO2UuS2FkZXNjZW5kZXJjeXJpbGxpYz0xMTc4O2UuS2Fob29rY3lyaWxsaWM9MTIxOTtlLkthcHBhPTkyMjtlLkthc3Ryb2tlY3lyaWxsaWM9MTE4MjtlLkthdmVydGljYWxzdHJva2VjeXJpbGxpYz0xMTgwO2UuS2Nhcm9uPTQ4ODtlLktjZWRpbGxhPTMxMDtlLktjaXJjbGU9OTQwODtlLktjb21tYWFjY2VudD0zMTA7ZS5LZG90YmVsb3c9NzczMDtlLktlaGFybWVuaWFuPTEzNjQ7ZS5LZW5hcm1lbmlhbj0xMzQzO2UuS2hhY3lyaWxsaWM9MTA2MTtlLktoZWljb3B0aWM9OTk4O2UuS2hvb2s9NDA4O2UuS2plY3lyaWxsaWM9MTAzNjtlLktsaW5lYmVsb3c9NzczMjtlLkttb25vc3BhY2U9NjUzMjM7ZS5Lb3BwYWN5cmlsbGljPTExNTI7ZS5Lb3BwYWdyZWVrPTk5MDtlLktzaWN5cmlsbGljPTExMzQ7ZS5Lc21hbGw9NjMzMzk7ZS5MPTc2O2UuTEo9NDU1O2UuTEw9NjMxNjc7ZS5MYWN1dGU9MzEzO2UuTGFtYmRhPTkyMztlLkxjYXJvbj0zMTc7ZS5MY2VkaWxsYT0zMTU7ZS5MY2lyY2xlPTk0MDk7ZS5MY2lyY3VtZmxleGJlbG93PTc3NDA7ZS5MY29tbWFhY2NlbnQ9MzE1O2UuTGRvdD0zMTk7ZS5MZG90YWNjZW50PTMxOTtlLkxkb3RiZWxvdz03NzM0O2UuTGRvdGJlbG93bWFjcm9uPTc3MzY7ZS5MaXduYXJtZW5pYW49MTM0MDtlLkxqPTQ1NjtlLkxqZWN5cmlsbGljPTEwMzM7ZS5MbGluZWJlbG93PTc3Mzg7ZS5MbW9ub3NwYWNlPTY1MzI0O2UuTHNsYXNoPTMyMTtlLkxzbGFzaHNtYWxsPTYzMjI1O2UuTHNtYWxsPTYzMzQwO2UuTT03NztlLk1Cc3F1YXJlPTEzMTkwO2UuTWFjcm9uPTYzMTg0O2UuTWFjcm9uc21hbGw9NjM0MDc7ZS5NYWN1dGU9Nzc0MjtlLk1jaXJjbGU9OTQxMDtlLk1kb3RhY2NlbnQ9Nzc0NDtlLk1kb3RiZWxvdz03NzQ2O2UuTWVuYXJtZW5pYW49MTM0ODtlLk1tb25vc3BhY2U9NjUzMjU7ZS5Nc21hbGw9NjMzNDE7ZS5NdHVybmVkPTQxMjtlLk11PTkyNDtlLk49Nzg7ZS5OSj00NTg7ZS5OYWN1dGU9MzIzO2UuTmNhcm9uPTMyNztlLk5jZWRpbGxhPTMyNTtlLk5jaXJjbGU9OTQxMTtlLk5jaXJjdW1mbGV4YmVsb3c9Nzc1NDtlLk5jb21tYWFjY2VudD0zMjU7ZS5OZG90YWNjZW50PTc3NDg7ZS5OZG90YmVsb3c9Nzc1MDtlLk5ob29rbGVmdD00MTM7ZS5OaW5lcm9tYW49ODU1MjtlLk5qPTQ1OTtlLk5qZWN5cmlsbGljPTEwMzQ7ZS5ObGluZWJlbG93PTc3NTI7ZS5ObW9ub3NwYWNlPTY1MzI2O2UuTm93YXJtZW5pYW49MTM1MDtlLk5zbWFsbD02MzM0MjtlLk50aWxkZT0yMDk7ZS5OdGlsZGVzbWFsbD02MzQ3MztlLk51PTkyNTtlLk89Nzk7ZS5PRT0zMzg7ZS5PRXNtYWxsPTYzMjI2O2UuT2FjdXRlPTIxMTtlLk9hY3V0ZXNtYWxsPTYzNDc1O2UuT2JhcnJlZGN5cmlsbGljPTEyNTY7ZS5PYmFycmVkZGllcmVzaXNjeXJpbGxpYz0xMjU4O2UuT2JyZXZlPTMzNDtlLk9jYXJvbj00NjU7ZS5PY2VudGVyZWR0aWxkZT00MTU7ZS5PY2lyY2xlPTk0MTI7ZS5PY2lyY3VtZmxleD0yMTI7ZS5PY2lyY3VtZmxleGFjdXRlPTc4ODg7ZS5PY2lyY3VtZmxleGRvdGJlbG93PTc4OTY7ZS5PY2lyY3VtZmxleGdyYXZlPTc4OTA7ZS5PY2lyY3VtZmxleGhvb2thYm92ZT03ODkyO2UuT2NpcmN1bWZsZXhzbWFsbD02MzQ3NjtlLk9jaXJjdW1mbGV4dGlsZGU9Nzg5NDtlLk9jeXJpbGxpYz0xMDU0O2UuT2RibGFjdXRlPTMzNjtlLk9kYmxncmF2ZT01MjQ7ZS5PZGllcmVzaXM9MjE0O2UuT2RpZXJlc2lzY3lyaWxsaWM9MTI1NDtlLk9kaWVyZXNpc3NtYWxsPTYzNDc4O2UuT2RvdGJlbG93PTc4ODQ7ZS5PZ29uZWtzbWFsbD02MzIyNztlLk9ncmF2ZT0yMTA7ZS5PZ3JhdmVzbWFsbD02MzQ3NDtlLk9oYXJtZW5pYW49MTM2NTtlLk9obT04NDg2O2UuT2hvb2thYm92ZT03ODg2O2UuT2hvcm49NDE2O2UuT2hvcm5hY3V0ZT03ODk4O2UuT2hvcm5kb3RiZWxvdz03OTA2O2UuT2hvcm5ncmF2ZT03OTAwO2UuT2hvcm5ob29rYWJvdmU9NzkwMjtlLk9ob3JudGlsZGU9NzkwNDtlLk9odW5nYXJ1bWxhdXQ9MzM2O2UuT2k9NDE4O2UuT2ludmVydGVkYnJldmU9NTI2O2UuT21hY3Jvbj0zMzI7ZS5PbWFjcm9uYWN1dGU9Nzc2MjtlLk9tYWNyb25ncmF2ZT03NzYwO2UuT21lZ2E9ODQ4NjtlLk9tZWdhY3lyaWxsaWM9MTEyMDtlLk9tZWdhZ3JlZWs9OTM3O2UuT21lZ2Fyb3VuZGN5cmlsbGljPTExNDY7ZS5PbWVnYXRpdGxvY3lyaWxsaWM9MTE0ODtlLk9tZWdhdG9ub3M9OTExO2UuT21pY3Jvbj05Mjc7ZS5PbWljcm9udG9ub3M9OTA4O2UuT21vbm9zcGFjZT02NTMyNztlLk9uZXJvbWFuPTg1NDQ7ZS5Pb2dvbmVrPTQ5MDtlLk9vZ29uZWttYWNyb249NDkyO2UuT29wZW49MzkwO2UuT3NsYXNoPTIxNjtlLk9zbGFzaGFjdXRlPTUxMDtlLk9zbGFzaHNtYWxsPTYzNDgwO2UuT3NtYWxsPTYzMzQzO2UuT3N0cm9rZWFjdXRlPTUxMDtlLk90Y3lyaWxsaWM9MTE1MDtlLk90aWxkZT0yMTM7ZS5PdGlsZGVhY3V0ZT03NzU2O2UuT3RpbGRlZGllcmVzaXM9Nzc1ODtlLk90aWxkZXNtYWxsPTYzNDc3O2UuUD04MDtlLlBhY3V0ZT03NzY0O2UuUGNpcmNsZT05NDEzO2UuUGRvdGFjY2VudD03NzY2O2UuUGVjeXJpbGxpYz0xMDU1O2UuUGVoYXJtZW5pYW49MTM1NDtlLlBlbWlkZGxlaG9va2N5cmlsbGljPTExOTA7ZS5QaGk9OTM0O2UuUGhvb2s9NDIwO2UuUGk9OTI4O2UuUGl3cmFybWVuaWFuPTEzNjM7ZS5QbW9ub3NwYWNlPTY1MzI4O2UuUHNpPTkzNjtlLlBzaWN5cmlsbGljPTExMzY7ZS5Qc21hbGw9NjMzNDQ7ZS5RPTgxO2UuUWNpcmNsZT05NDE0O2UuUW1vbm9zcGFjZT02NTMyOTtlLlFzbWFsbD02MzM0NTtlLlI9ODI7ZS5SYWFybWVuaWFuPTEzNTY7ZS5SYWN1dGU9MzQwO2UuUmNhcm9uPTM0NDtlLlJjZWRpbGxhPTM0MjtlLlJjaXJjbGU9OTQxNTtlLlJjb21tYWFjY2VudD0zNDI7ZS5SZGJsZ3JhdmU9NTI4O2UuUmRvdGFjY2VudD03NzY4O2UuUmRvdGJlbG93PTc3NzA7ZS5SZG90YmVsb3dtYWNyb249Nzc3MjtlLlJlaGFybWVuaWFuPTEzNjA7ZS5SZnJha3R1cj04NDc2O2UuUmhvPTkyOTtlLlJpbmdzbWFsbD02MzIyODtlLlJpbnZlcnRlZGJyZXZlPTUzMDtlLlJsaW5lYmVsb3c9Nzc3NDtlLlJtb25vc3BhY2U9NjUzMzA7ZS5Sc21hbGw9NjMzNDY7ZS5Sc21hbGxpbnZlcnRlZD02NDE7ZS5Sc21hbGxpbnZlcnRlZHN1cGVyaW9yPTY5NDtlLlM9ODM7ZS5TRjAxMDAwMD05NDg0O2UuU0YwMjAwMDA9OTQ5MjtlLlNGMDMwMDAwPTk0ODg7ZS5TRjA0MDAwMD05NDk2O2UuU0YwNTAwMDA9OTUzMjtlLlNGMDYwMDAwPTk1MTY7ZS5TRjA3MDAwMD05NTI0O2UuU0YwODAwMDA9OTUwMDtlLlNGMDkwMDAwPTk1MDg7ZS5TRjEwMDAwMD05NDcyO2UuU0YxMTAwMDA9OTQ3NDtlLlNGMTkwMDAwPTk1Njk7ZS5TRjIwMDAwMD05NTcwO2UuU0YyMTAwMDA9OTU1ODtlLlNGMjIwMDAwPTk1NTc7ZS5TRjIzMDAwMD05NTcxO2UuU0YyNDAwMDA9OTU1MztlLlNGMjUwMDAwPTk1NTk7ZS5TRjI2MDAwMD05NTY1O2UuU0YyNzAwMDA9OTU2NDtlLlNGMjgwMDAwPTk1NjM7ZS5TRjM2MDAwMD05NTY2O2UuU0YzNzAwMDA9OTU2NztlLlNGMzgwMDAwPTk1NjI7ZS5TRjM5MDAwMD05NTU2O2UuU0Y0MDAwMDA9OTU3NztlLlNGNDEwMDAwPTk1NzQ7ZS5TRjQyMDAwMD05NTY4O2UuU0Y0MzAwMDA9OTU1MjtlLlNGNDQwMDAwPTk1ODA7ZS5TRjQ1MDAwMD05NTc1O2UuU0Y0NjAwMDA9OTU3NjtlLlNGNDcwMDAwPTk1NzI7ZS5TRjQ4MDAwMD05NTczO2UuU0Y0OTAwMDA9OTU2MTtlLlNGNTAwMDAwPTk1NjA7ZS5TRjUxMDAwMD05NTU0O2UuU0Y1MjAwMDA9OTU1NTtlLlNGNTMwMDAwPTk1Nzk7ZS5TRjU0MDAwMD05NTc4O2UuU2FjdXRlPTM0NjtlLlNhY3V0ZWRvdGFjY2VudD03NzgwO2UuU2FtcGlncmVlaz05OTI7ZS5TY2Fyb249MzUyO2UuU2Nhcm9uZG90YWNjZW50PTc3ODI7ZS5TY2Fyb25zbWFsbD02MzIyOTtlLlNjZWRpbGxhPTM1MDtlLlNjaHdhPTM5OTtlLlNjaHdhY3lyaWxsaWM9MTI0MDtlLlNjaHdhZGllcmVzaXNjeXJpbGxpYz0xMjQyO2UuU2NpcmNsZT05NDE2O2UuU2NpcmN1bWZsZXg9MzQ4O2UuU2NvbW1hYWNjZW50PTUzNjtlLlNkb3RhY2NlbnQ9Nzc3NjtlLlNkb3RiZWxvdz03Nzc4O2UuU2RvdGJlbG93ZG90YWNjZW50PTc3ODQ7ZS5TZWhhcm1lbmlhbj0xMzU3O2UuU2V2ZW5yb21hbj04NTUwO2UuU2hhYXJtZW5pYW49MTM1MTtlLlNoYWN5cmlsbGljPTEwNjQ7ZS5TaGNoYWN5cmlsbGljPTEwNjU7ZS5TaGVpY29wdGljPTk5NDtlLlNoaGFjeXJpbGxpYz0xMjEwO2UuU2hpbWFjb3B0aWM9MTAwNDtlLlNpZ21hPTkzMTtlLlNpeHJvbWFuPTg1NDk7ZS5TbW9ub3NwYWNlPTY1MzMxO2UuU29mdHNpZ25jeXJpbGxpYz0xMDY4O2UuU3NtYWxsPTYzMzQ3O2UuU3RpZ21hZ3JlZWs9OTg2O2UuVD04NDtlLlRhdT05MzI7ZS5UYmFyPTM1ODtlLlRjYXJvbj0zNTY7ZS5UY2VkaWxsYT0zNTQ7ZS5UY2lyY2xlPTk0MTc7ZS5UY2lyY3VtZmxleGJlbG93PTc3OTI7ZS5UY29tbWFhY2NlbnQ9MzU0O2UuVGRvdGFjY2VudD03Nzg2O2UuVGRvdGJlbG93PTc3ODg7ZS5UZWN5cmlsbGljPTEwNTg7ZS5UZWRlc2NlbmRlcmN5cmlsbGljPTExOTY7ZS5UZW5yb21hbj04NTUzO2UuVGV0c2VjeXJpbGxpYz0xMjA0O2UuVGhldGE9OTIwO2UuVGhvb2s9NDI4O2UuVGhvcm49MjIyO2UuVGhvcm5zbWFsbD02MzQ4NjtlLlRocmVlcm9tYW49ODU0NjtlLlRpbGRlc21hbGw9NjMyMzA7ZS5UaXduYXJtZW5pYW49MTM1OTtlLlRsaW5lYmVsb3c9Nzc5MDtlLlRtb25vc3BhY2U9NjUzMzI7ZS5Ub2FybWVuaWFuPTEzMzc7ZS5Ub25lZml2ZT00NDQ7ZS5Ub25lc2l4PTM4ODtlLlRvbmV0d289NDIzO2UuVHJldHJvZmxleGhvb2s9NDMwO2UuVHNlY3lyaWxsaWM9MTA2MjtlLlRzaGVjeXJpbGxpYz0xMDM1O2UuVHNtYWxsPTYzMzQ4O2UuVHdlbHZlcm9tYW49ODU1NTtlLlR3b3JvbWFuPTg1NDU7ZS5VPTg1O2UuVWFjdXRlPTIxODtlLlVhY3V0ZXNtYWxsPTYzNDgyO2UuVWJyZXZlPTM2NDtlLlVjYXJvbj00Njc7ZS5VY2lyY2xlPTk0MTg7ZS5VY2lyY3VtZmxleD0yMTk7ZS5VY2lyY3VtZmxleGJlbG93PTc3OTg7ZS5VY2lyY3VtZmxleHNtYWxsPTYzNDgzO2UuVWN5cmlsbGljPTEwNTk7ZS5VZGJsYWN1dGU9MzY4O2UuVWRibGdyYXZlPTUzMjtlLlVkaWVyZXNpcz0yMjA7ZS5VZGllcmVzaXNhY3V0ZT00NzE7ZS5VZGllcmVzaXNiZWxvdz03Nzk0O2UuVWRpZXJlc2lzY2Fyb249NDczO2UuVWRpZXJlc2lzY3lyaWxsaWM9MTI2NDtlLlVkaWVyZXNpc2dyYXZlPTQ3NTtlLlVkaWVyZXNpc21hY3Jvbj00Njk7ZS5VZGllcmVzaXNzbWFsbD02MzQ4NDtlLlVkb3RiZWxvdz03OTA4O2UuVWdyYXZlPTIxNztlLlVncmF2ZXNtYWxsPTYzNDgxO2UuVWhvb2thYm92ZT03OTEwO2UuVWhvcm49NDMxO2UuVWhvcm5hY3V0ZT03OTEyO2UuVWhvcm5kb3RiZWxvdz03OTIwO2UuVWhvcm5ncmF2ZT03OTE0O2UuVWhvcm5ob29rYWJvdmU9NzkxNjtlLlVob3JudGlsZGU9NzkxODtlLlVodW5nYXJ1bWxhdXQ9MzY4O2UuVWh1bmdhcnVtbGF1dGN5cmlsbGljPTEyNjY7ZS5VaW52ZXJ0ZWRicmV2ZT01MzQ7ZS5Va2N5cmlsbGljPTExNDQ7ZS5VbWFjcm9uPTM2MjtlLlVtYWNyb25jeXJpbGxpYz0xMjYyO2UuVW1hY3JvbmRpZXJlc2lzPTc4MDI7ZS5VbW9ub3NwYWNlPTY1MzMzO2UuVW9nb25laz0zNzA7ZS5VcHNpbG9uPTkzMztlLlVwc2lsb24xPTk3ODtlLlVwc2lsb25hY3V0ZWhvb2tzeW1ib2xncmVlaz05Nzk7ZS5VcHNpbG9uYWZyaWNhbj00MzM7ZS5VcHNpbG9uZGllcmVzaXM9OTM5O2UuVXBzaWxvbmRpZXJlc2lzaG9va3N5bWJvbGdyZWVrPTk4MDtlLlVwc2lsb25ob29rc3ltYm9sPTk3ODtlLlVwc2lsb250b25vcz05MTA7ZS5VcmluZz0zNjY7ZS5Vc2hvcnRjeXJpbGxpYz0xMDM4O2UuVXNtYWxsPTYzMzQ5O2UuVXN0cmFpZ2h0Y3lyaWxsaWM9MTE5ODtlLlVzdHJhaWdodHN0cm9rZWN5cmlsbGljPTEyMDA7ZS5VdGlsZGU9MzYwO2UuVXRpbGRlYWN1dGU9NzgwMDtlLlV0aWxkZWJlbG93PTc3OTY7ZS5WPTg2O2UuVmNpcmNsZT05NDE5O2UuVmRvdGJlbG93PTc4MDY7ZS5WZWN5cmlsbGljPTEwNDI7ZS5WZXdhcm1lbmlhbj0xMzU4O2UuVmhvb2s9NDM0O2UuVm1vbm9zcGFjZT02NTMzNDtlLlZvYXJtZW5pYW49MTM1MjtlLlZzbWFsbD02MzM1MDtlLlZ0aWxkZT03ODA0O2UuVz04NztlLldhY3V0ZT03ODEwO2UuV2NpcmNsZT05NDIwO2UuV2NpcmN1bWZsZXg9MzcyO2UuV2RpZXJlc2lzPTc4MTI7ZS5XZG90YWNjZW50PTc4MTQ7ZS5XZG90YmVsb3c9NzgxNjtlLldncmF2ZT03ODA4O2UuV21vbm9zcGFjZT02NTMzNTtlLldzbWFsbD02MzM1MTtlLlg9ODg7ZS5YY2lyY2xlPTk0MjE7ZS5YZGllcmVzaXM9NzgyMDtlLlhkb3RhY2NlbnQ9NzgxODtlLlhlaGFybWVuaWFuPTEzNDE7ZS5YaT05MjY7ZS5YbW9ub3NwYWNlPTY1MzM2O2UuWHNtYWxsPTYzMzUyO2UuWT04OTtlLllhY3V0ZT0yMjE7ZS5ZYWN1dGVzbWFsbD02MzQ4NTtlLllhdGN5cmlsbGljPTExMjI7ZS5ZY2lyY2xlPTk0MjI7ZS5ZY2lyY3VtZmxleD0zNzQ7ZS5ZZGllcmVzaXM9Mzc2O2UuWWRpZXJlc2lzc21hbGw9NjM0ODc7ZS5ZZG90YWNjZW50PTc4MjI7ZS5ZZG90YmVsb3c9NzkyNDtlLlllcmljeXJpbGxpYz0xMDY3O2UuWWVydWRpZXJlc2lzY3lyaWxsaWM9MTI3MjtlLllncmF2ZT03OTIyO2UuWWhvb2s9NDM1O2UuWWhvb2thYm92ZT03OTI2O2UuWWlhcm1lbmlhbj0xMzQ5O2UuWWljeXJpbGxpYz0xMDMxO2UuWWl3bmFybWVuaWFuPTEzNjI7ZS5ZbW9ub3NwYWNlPTY1MzM3O2UuWXNtYWxsPTYzMzUzO2UuWXRpbGRlPTc5Mjg7ZS5ZdXNiaWdjeXJpbGxpYz0xMTMwO2UuWXVzYmlnaW90aWZpZWRjeXJpbGxpYz0xMTMyO2UuWXVzbGl0dGxlY3lyaWxsaWM9MTEyNjtlLll1c2xpdHRsZWlvdGlmaWVkY3lyaWxsaWM9MTEyODtlLlo9OTA7ZS5aYWFybWVuaWFuPTEzMzQ7ZS5aYWN1dGU9Mzc3O2UuWmNhcm9uPTM4MTtlLlpjYXJvbnNtYWxsPTYzMjMxO2UuWmNpcmNsZT05NDIzO2UuWmNpcmN1bWZsZXg9NzgyNDtlLlpkb3Q9Mzc5O2UuWmRvdGFjY2VudD0zNzk7ZS5aZG90YmVsb3c9NzgyNjtlLlplY3lyaWxsaWM9MTA0NztlLlplZGVzY2VuZGVyY3lyaWxsaWM9MTE3NjtlLlplZGllcmVzaXNjeXJpbGxpYz0xMjQ2O2UuWmV0YT05MTg7ZS5aaGVhcm1lbmlhbj0xMzM4O2UuWmhlYnJldmVjeXJpbGxpYz0xMjE3O2UuWmhlY3lyaWxsaWM9MTA0NjtlLlpoZWRlc2NlbmRlcmN5cmlsbGljPTExNzQ7ZS5aaGVkaWVyZXNpc2N5cmlsbGljPTEyNDQ7ZS5abGluZWJlbG93PTc4Mjg7ZS5abW9ub3NwYWNlPTY1MzM4O2UuWnNtYWxsPTYzMzU0O2UuWnN0cm9rZT00Mzc7ZS5hPTk3O2UuYWFiZW5nYWxpPTI0Mzg7ZS5hYWN1dGU9MjI1O2UuYWFkZXZhPTIzMTA7ZS5hYWd1amFyYXRpPTI2OTQ7ZS5hYWd1cm11a2hpPTI1NjY7ZS5hYW1hdHJhZ3VybXVraGk9MjYyMjtlLmFhcnVzcXVhcmU9MTMwNTk7ZS5hYXZvd2Vsc2lnbmJlbmdhbGk9MjQ5NDtlLmFhdm93ZWxzaWduZGV2YT0yMzY2O2UuYWF2b3dlbHNpZ25ndWphcmF0aT0yNzUwO2UuYWJicmV2aWF0aW9ubWFya2FybWVuaWFuPTEzNzU7ZS5hYmJyZXZpYXRpb25zaWduZGV2YT0yNDE2O2UuYWJlbmdhbGk9MjQzNztlLmFib3BvbW9mbz0xMjU3MDtlLmFicmV2ZT0yNTk7ZS5hYnJldmVhY3V0ZT03ODU1O2UuYWJyZXZlY3lyaWxsaWM9MTIzMztlLmFicmV2ZWRvdGJlbG93PTc4NjM7ZS5hYnJldmVncmF2ZT03ODU3O2UuYWJyZXZlaG9va2Fib3ZlPTc4NTk7ZS5hYnJldmV0aWxkZT03ODYxO2UuYWNhcm9uPTQ2MjtlLmFjaXJjbGU9OTQyNDtlLmFjaXJjdW1mbGV4PTIyNjtlLmFjaXJjdW1mbGV4YWN1dGU9Nzg0NTtlLmFjaXJjdW1mbGV4ZG90YmVsb3c9Nzg1MztlLmFjaXJjdW1mbGV4Z3JhdmU9Nzg0NztlLmFjaXJjdW1mbGV4aG9va2Fib3ZlPTc4NDk7ZS5hY2lyY3VtZmxleHRpbGRlPTc4NTE7ZS5hY3V0ZT0xODA7ZS5hY3V0ZWJlbG93Y21iPTc5MTtlLmFjdXRlY21iPTc2OTtlLmFjdXRlY29tYj03Njk7ZS5hY3V0ZWRldmE9MjM4ODtlLmFjdXRlbG93bW9kPTcxOTtlLmFjdXRldG9uZWNtYj04MzM7ZS5hY3lyaWxsaWM9MTA3MjtlLmFkYmxncmF2ZT01MTM7ZS5hZGRha2d1cm11a2hpPTI2NzM7ZS5hZGV2YT0yMzA5O2UuYWRpZXJlc2lzPTIyODtlLmFkaWVyZXNpc2N5cmlsbGljPTEyMzU7ZS5hZGllcmVzaXNtYWNyb249NDc5O2UuYWRvdGJlbG93PTc4NDE7ZS5hZG90bWFjcm9uPTQ4MTtlLmFlPTIzMDtlLmFlYWN1dGU9NTA5O2UuYWVrb3JlYW49MTI2MjQ7ZS5hZW1hY3Jvbj00ODM7ZS5hZmlpMDAyMDg9ODIxMztlLmFmaWkwODk0MT04MzU2O2UuYWZpaTEwMDE3PTEwNDA7ZS5hZmlpMTAwMTg9MTA0MTtlLmFmaWkxMDAxOT0xMDQyO2UuYWZpaTEwMDIwPTEwNDM7ZS5hZmlpMTAwMjE9MTA0NDtlLmFmaWkxMDAyMj0xMDQ1O2UuYWZpaTEwMDIzPTEwMjU7ZS5hZmlpMTAwMjQ9MTA0NjtlLmFmaWkxMDAyNT0xMDQ3O2UuYWZpaTEwMDI2PTEwNDg7ZS5hZmlpMTAwMjc9MTA0OTtlLmFmaWkxMDAyOD0xMDUwO2UuYWZpaTEwMDI5PTEwNTE7ZS5hZmlpMTAwMzA9MTA1MjtlLmFmaWkxMDAzMT0xMDUzO2UuYWZpaTEwMDMyPTEwNTQ7ZS5hZmlpMTAwMzM9MTA1NTtlLmFmaWkxMDAzND0xMDU2O2UuYWZpaTEwMDM1PTEwNTc7ZS5hZmlpMTAwMzY9MTA1ODtlLmFmaWkxMDAzNz0xMDU5O2UuYWZpaTEwMDM4PTEwNjA7ZS5hZmlpMTAwMzk9MTA2MTtlLmFmaWkxMDA0MD0xMDYyO2UuYWZpaTEwMDQxPTEwNjM7ZS5hZmlpMTAwNDI9MTA2NDtlLmFmaWkxMDA0Mz0xMDY1O2UuYWZpaTEwMDQ0PTEwNjY7ZS5hZmlpMTAwNDU9MTA2NztlLmFmaWkxMDA0Nj0xMDY4O2UuYWZpaTEwMDQ3PTEwNjk7ZS5hZmlpMTAwNDg9MTA3MDtlLmFmaWkxMDA0OT0xMDcxO2UuYWZpaTEwMDUwPTExNjg7ZS5hZmlpMTAwNTE9MTAyNjtlLmFmaWkxMDA1Mj0xMDI3O2UuYWZpaTEwMDUzPTEwMjg7ZS5hZmlpMTAwNTQ9MTAyOTtlLmFmaWkxMDA1NT0xMDMwO2UuYWZpaTEwMDU2PTEwMzE7ZS5hZmlpMTAwNTc9MTAzMjtlLmFmaWkxMDA1OD0xMDMzO2UuYWZpaTEwMDU5PTEwMzQ7ZS5hZmlpMTAwNjA9MTAzNTtlLmFmaWkxMDA2MT0xMDM2O2UuYWZpaTEwMDYyPTEwMzg7ZS5hZmlpMTAwNjM9NjMxNzI7ZS5hZmlpMTAwNjQ9NjMxNzM7ZS5hZmlpMTAwNjU9MTA3MjtlLmFmaWkxMDA2Nj0xMDczO2UuYWZpaTEwMDY3PTEwNzQ7ZS5hZmlpMTAwNjg9MTA3NTtlLmFmaWkxMDA2OT0xMDc2O2UuYWZpaTEwMDcwPTEwNzc7ZS5hZmlpMTAwNzE9MTEwNTtlLmFmaWkxMDA3Mj0xMDc4O2UuYWZpaTEwMDczPTEwNzk7ZS5hZmlpMTAwNzQ9MTA4MDtlLmFmaWkxMDA3NT0xMDgxO2UuYWZpaTEwMDc2PTEwODI7ZS5hZmlpMTAwNzc9MTA4MztlLmFmaWkxMDA3OD0xMDg0O2UuYWZpaTEwMDc5PTEwODU7ZS5hZmlpMTAwODA9MTA4NjtlLmFmaWkxMDA4MT0xMDg3O2UuYWZpaTEwMDgyPTEwODg7ZS5hZmlpMTAwODM9MTA4OTtlLmFmaWkxMDA4ND0xMDkwO2UuYWZpaTEwMDg1PTEwOTE7ZS5hZmlpMTAwODY9MTA5MjtlLmFmaWkxMDA4Nz0xMDkzO2UuYWZpaTEwMDg4PTEwOTQ7ZS5hZmlpMTAwODk9MTA5NTtlLmFmaWkxMDA5MD0xMDk2O2UuYWZpaTEwMDkxPTEwOTc7ZS5hZmlpMTAwOTI9MTA5ODtlLmFmaWkxMDA5Mz0xMDk5O2UuYWZpaTEwMDk0PTExMDA7ZS5hZmlpMTAwOTU9MTEwMTtlLmFmaWkxMDA5Nj0xMTAyO2UuYWZpaTEwMDk3PTExMDM7ZS5hZmlpMTAwOTg9MTE2OTtlLmFmaWkxMDA5OT0xMTA2O2UuYWZpaTEwMTAwPTExMDc7ZS5hZmlpMTAxMDE9MTEwODtlLmFmaWkxMDEwMj0xMTA5O2UuYWZpaTEwMTAzPTExMTA7ZS5hZmlpMTAxMDQ9MTExMTtlLmFmaWkxMDEwNT0xMTEyO2UuYWZpaTEwMTA2PTExMTM7ZS5hZmlpMTAxMDc9MTExNDtlLmFmaWkxMDEwOD0xMTE1O2UuYWZpaTEwMTA5PTExMTY7ZS5hZmlpMTAxMTA9MTExODtlLmFmaWkxMDE0NT0xMDM5O2UuYWZpaTEwMTQ2PTExMjI7ZS5hZmlpMTAxNDc9MTEzODtlLmFmaWkxMDE0OD0xMTQwO2UuYWZpaTEwMTkyPTYzMTc0O2UuYWZpaTEwMTkzPTExMTk7ZS5hZmlpMTAxOTQ9MTEyMztlLmFmaWkxMDE5NT0xMTM5O2UuYWZpaTEwMTk2PTExNDE7ZS5hZmlpMTA4MzE9NjMxNzU7ZS5hZmlpMTA4MzI9NjMxNzY7ZS5hZmlpMTA4NDY9MTI0MTtlLmFmaWkyOTk9ODIwNjtlLmFmaWkzMDA9ODIwNztlLmFmaWkzMDE9ODIwNTtlLmFmaWk1NzM4MT0xNjQyO2UuYWZpaTU3Mzg4PTE1NDg7ZS5hZmlpNTczOTI9MTYzMjtlLmFmaWk1NzM5Mz0xNjMzO2UuYWZpaTU3Mzk0PTE2MzQ7ZS5hZmlpNTczOTU9MTYzNTtlLmFmaWk1NzM5Nj0xNjM2O2UuYWZpaTU3Mzk3PTE2Mzc7ZS5hZmlpNTczOTg9MTYzODtlLmFmaWk1NzM5OT0xNjM5O2UuYWZpaTU3NDAwPTE2NDA7ZS5hZmlpNTc0MDE9MTY0MTtlLmFmaWk1NzQwMz0xNTYzO2UuYWZpaTU3NDA3PTE1Njc7ZS5hZmlpNTc0MDk9MTU2OTtlLmFmaWk1NzQxMD0xNTcwO2UuYWZpaTU3NDExPTE1NzE7ZS5hZmlpNTc0MTI9MTU3MjtlLmFmaWk1NzQxMz0xNTczO2UuYWZpaTU3NDE0PTE1NzQ7ZS5hZmlpNTc0MTU9MTU3NTtlLmFmaWk1NzQxNj0xNTc2O2UuYWZpaTU3NDE3PTE1Nzc7ZS5hZmlpNTc0MTg9MTU3ODtlLmFmaWk1NzQxOT0xNTc5O2UuYWZpaTU3NDIwPTE1ODA7ZS5hZmlpNTc0MjE9MTU4MTtlLmFmaWk1NzQyMj0xNTgyO2UuYWZpaTU3NDIzPTE1ODM7ZS5hZmlpNTc0MjQ9MTU4NDtlLmFmaWk1NzQyNT0xNTg1O2UuYWZpaTU3NDI2PTE1ODY7ZS5hZmlpNTc0Mjc9MTU4NztlLmFmaWk1NzQyOD0xNTg4O2UuYWZpaTU3NDI5PTE1ODk7ZS5hZmlpNTc0MzA9MTU5MDtlLmFmaWk1NzQzMT0xNTkxO2UuYWZpaTU3NDMyPTE1OTI7ZS5hZmlpNTc0MzM9MTU5MztlLmFmaWk1NzQzND0xNTk0O2UuYWZpaTU3NDQwPTE2MDA7ZS5hZmlpNTc0NDE9MTYwMTtlLmFmaWk1NzQ0Mj0xNjAyO2UuYWZpaTU3NDQzPTE2MDM7ZS5hZmlpNTc0NDQ9MTYwNDtlLmFmaWk1NzQ0NT0xNjA1O2UuYWZpaTU3NDQ2PTE2MDY7ZS5hZmlpNTc0NDg9MTYwODtlLmFmaWk1NzQ0OT0xNjA5O2UuYWZpaTU3NDUwPTE2MTA7ZS5hZmlpNTc0NTE9MTYxMTtlLmFmaWk1NzQ1Mj0xNjEyO2UuYWZpaTU3NDUzPTE2MTM7ZS5hZmlpNTc0NTQ9MTYxNDtlLmFmaWk1NzQ1NT0xNjE1O2UuYWZpaTU3NDU2PTE2MTY7ZS5hZmlpNTc0NTc9MTYxNztlLmFmaWk1NzQ1OD0xNjE4O2UuYWZpaTU3NDcwPTE2MDc7ZS5hZmlpNTc1MDU9MTcwMDtlLmFmaWk1NzUwNj0xNjYyO2UuYWZpaTU3NTA3PTE2NzA7ZS5hZmlpNTc1MDg9MTY4ODtlLmFmaWk1NzUwOT0xNzExO2UuYWZpaTU3NTExPTE2NTc7ZS5hZmlpNTc1MTI9MTY3MjtlLmFmaWk1NzUxMz0xNjgxO2UuYWZpaTU3NTE0PTE3MjI7ZS5hZmlpNTc1MTk9MTc0NjtlLmFmaWk1NzUzND0xNzQ5O2UuYWZpaTU3NjM2PTgzNjI7ZS5hZmlpNTc2NDU9MTQ3MDtlLmFmaWk1NzY1OD0xNDc1O2UuYWZpaTU3NjY0PTE0ODg7ZS5hZmlpNTc2NjU9MTQ4OTtlLmFmaWk1NzY2Nj0xNDkwO2UuYWZpaTU3NjY3PTE0OTE7ZS5hZmlpNTc2Njg9MTQ5MjtlLmFmaWk1NzY2OT0xNDkzO2UuYWZpaTU3NjcwPTE0OTQ7ZS5hZmlpNTc2NzE9MTQ5NTtlLmFmaWk1NzY3Mj0xNDk2O2UuYWZpaTU3NjczPTE0OTc7ZS5hZmlpNTc2NzQ9MTQ5ODtlLmFmaWk1NzY3NT0xNDk5O2UuYWZpaTU3Njc2PTE1MDA7ZS5hZmlpNTc2Nzc9MTUwMTtlLmFmaWk1NzY3OD0xNTAyO2UuYWZpaTU3Njc5PTE1MDM7ZS5hZmlpNTc2ODA9MTUwNDtlLmFmaWk1NzY4MT0xNTA1O2UuYWZpaTU3NjgyPTE1MDY7ZS5hZmlpNTc2ODM9MTUwNztlLmFmaWk1NzY4ND0xNTA4O2UuYWZpaTU3Njg1PTE1MDk7ZS5hZmlpNTc2ODY9MTUxMDtlLmFmaWk1NzY4Nz0xNTExO2UuYWZpaTU3Njg4PTE1MTI7ZS5hZmlpNTc2ODk9MTUxMztlLmFmaWk1NzY5MD0xNTE0O2UuYWZpaTU3Njk0PTY0Mjk4O2UuYWZpaTU3Njk1PTY0Mjk5O2UuYWZpaTU3NzAwPTY0MzMxO2UuYWZpaTU3NzA1PTY0Mjg3O2UuYWZpaTU3NzE2PTE1MjA7ZS5hZmlpNTc3MTc9MTUyMTtlLmFmaWk1NzcxOD0xNTIyO2UuYWZpaTU3NzIzPTY0MzA5O2UuYWZpaTU3NzkzPTE0NjA7ZS5hZmlpNTc3OTQ9MTQ2MTtlLmFmaWk1Nzc5NT0xNDYyO2UuYWZpaTU3Nzk2PTE0Njc7ZS5hZmlpNTc3OTc9MTQ2NDtlLmFmaWk1Nzc5OD0xNDYzO2UuYWZpaTU3Nzk5PTE0NTY7ZS5hZmlpNTc4MDA9MTQ1ODtlLmFmaWk1NzgwMT0xNDU3O2UuYWZpaTU3ODAyPTE0NTk7ZS5hZmlpNTc4MDM9MTQ3NDtlLmFmaWk1NzgwND0xNDczO2UuYWZpaTU3ODA2PTE0NjU7ZS5hZmlpNTc4MDc9MTQ2ODtlLmFmaWk1NzgzOT0xNDY5O2UuYWZpaTU3ODQxPTE0NzE7ZS5hZmlpNTc4NDI9MTQ3MjtlLmFmaWk1NzkyOT03MDA7ZS5hZmlpNjEyNDg9ODQ1MztlLmFmaWk2MTI4OT04NDY3O2UuYWZpaTYxMzUyPTg0NzA7ZS5hZmlpNjE1NzM9ODIzNjtlLmFmaWk2MTU3ND04MjM3O2UuYWZpaTYxNTc1PTgyMzg7ZS5hZmlpNjE2NjQ9ODIwNDtlLmFmaWk2MzE2Nz0xNjQ1O2UuYWZpaTY0OTM3PTcwMTtlLmFncmF2ZT0yMjQ7ZS5hZ3VqYXJhdGk9MjY5MztlLmFndXJtdWtoaT0yNTY1O2UuYWhpcmFnYW5hPTEyMzU0O2UuYWhvb2thYm92ZT03ODQzO2UuYWliZW5nYWxpPTI0NDg7ZS5haWJvcG9tb2ZvPTEyNTc0O2UuYWlkZXZhPTIzMjA7ZS5haWVjeXJpbGxpYz0xMjM3O2UuYWlndWphcmF0aT0yNzA0O2UuYWlndXJtdWtoaT0yNTc2O2UuYWltYXRyYWd1cm11a2hpPTI2MzI7ZS5haW5hcmFiaWM9MTU5MztlLmFpbmZpbmFsYXJhYmljPTY1MjI2O2UuYWluaW5pdGlhbGFyYWJpYz02NTIyNztlLmFpbm1lZGlhbGFyYWJpYz02NTIyODtlLmFpbnZlcnRlZGJyZXZlPTUxNTtlLmFpdm93ZWxzaWduYmVuZ2FsaT0yNTA0O2UuYWl2b3dlbHNpZ25kZXZhPTIzNzY7ZS5haXZvd2Vsc2lnbmd1amFyYXRpPTI3NjA7ZS5ha2F0YWthbmE9MTI0NTA7ZS5ha2F0YWthbmFoYWxmd2lkdGg9NjUzOTM7ZS5ha29yZWFuPTEyNjIzO2UuYWxlZj0xNDg4O2UuYWxlZmFyYWJpYz0xNTc1O2UuYWxlZmRhZ2VzaGhlYnJldz02NDMwNDtlLmFsZWZmaW5hbGFyYWJpYz02NTE2NjtlLmFsZWZoYW16YWFib3ZlYXJhYmljPTE1NzE7ZS5hbGVmaGFtemFhYm92ZWZpbmFsYXJhYmljPTY1MTU2O2UuYWxlZmhhbXphYmVsb3dhcmFiaWM9MTU3MztlLmFsZWZoYW16YWJlbG93ZmluYWxhcmFiaWM9NjUxNjA7ZS5hbGVmaGVicmV3PTE0ODg7ZS5hbGVmbGFtZWRoZWJyZXc9NjQzMzU7ZS5hbGVmbWFkZGFhYm92ZWFyYWJpYz0xNTcwO2UuYWxlZm1hZGRhYWJvdmVmaW5hbGFyYWJpYz02NTE1NDtlLmFsZWZtYWtzdXJhYXJhYmljPTE2MDk7ZS5hbGVmbWFrc3VyYWZpbmFsYXJhYmljPTY1MjY0O2UuYWxlZm1ha3N1cmFpbml0aWFsYXJhYmljPTY1MjY3O2UuYWxlZm1ha3N1cmFtZWRpYWxhcmFiaWM9NjUyNjg7ZS5hbGVmcGF0YWhoZWJyZXc9NjQzMDI7ZS5hbGVmcWFtYXRzaGVicmV3PTY0MzAzO2UuYWxlcGg9ODUwMTtlLmFsbGVxdWFsPTg3ODA7ZS5hbHBoYT05NDU7ZS5hbHBoYXRvbm9zPTk0MDtlLmFtYWNyb249MjU3O2UuYW1vbm9zcGFjZT02NTM0NTtlLmFtcGVyc2FuZD0zODtlLmFtcGVyc2FuZG1vbm9zcGFjZT02NTI4NjtlLmFtcGVyc2FuZHNtYWxsPTYzMjcwO2UuYW1zcXVhcmU9MTMyNTA7ZS5hbmJvcG9tb2ZvPTEyNTc4O2UuYW5nYm9wb21vZm89MTI1ODA7ZS5hbmdicmFja2V0bGVmdD0xMjI5NjtlLmFuZ2JyYWNrZXRyaWdodD0xMjI5NztlLmFuZ2toYW5raHV0aGFpPTM2NzQ7ZS5hbmdsZT04NzM2O2UuYW5nbGVicmFja2V0bGVmdD0xMjI5NjtlLmFuZ2xlYnJhY2tldGxlZnR2ZXJ0aWNhbD02NTA4NztlLmFuZ2xlYnJhY2tldHJpZ2h0PTEyMjk3O2UuYW5nbGVicmFja2V0cmlnaHR2ZXJ0aWNhbD02NTA4ODtlLmFuZ2xlbGVmdD05MDAxO2UuYW5nbGVyaWdodD05MDAyO2UuYW5nc3Ryb209ODQ5MTtlLmFub3RlbGVpYT05MDM7ZS5hbnVkYXR0YWRldmE9MjM4NjtlLmFudXN2YXJhYmVuZ2FsaT0yNDM0O2UuYW51c3ZhcmFkZXZhPTIzMDY7ZS5hbnVzdmFyYWd1amFyYXRpPTI2OTA7ZS5hb2dvbmVrPTI2MTtlLmFwYWF0b3NxdWFyZT0xMzA1NjtlLmFwYXJlbj05MzcyO2UuYXBvc3Ryb3BoZWFybWVuaWFuPTEzNzA7ZS5hcG9zdHJvcGhlbW9kPTcwMDtlLmFwcGxlPTYzNzQzO2UuYXBwcm9hY2hlcz04Nzg0O2UuYXBwcm94ZXF1YWw9ODc3NjtlLmFwcHJveGVxdWFsb3JpbWFnZT04Nzg2O2UuYXBwcm94aW1hdGVseWVxdWFsPTg3NzM7ZS5hcmFlYWVrb3JlYW49MTI2ODY7ZS5hcmFlYWtvcmVhbj0xMjY4NTtlLmFyYz04OTc4O2UuYXJpZ2h0aGFsZnJpbmc9NzgzNDtlLmFyaW5nPTIyOTtlLmFyaW5nYWN1dGU9NTA3O2UuYXJpbmdiZWxvdz03NjgxO2UuYXJyb3dib3RoPTg1OTY7ZS5hcnJvd2Rhc2hkb3duPTg2NzU7ZS5hcnJvd2Rhc2hsZWZ0PTg2NzI7ZS5hcnJvd2Rhc2hyaWdodD04Njc0O2UuYXJyb3dkYXNodXA9ODY3MztlLmFycm93ZGJsYm90aD04NjYwO2UuYXJyb3dkYmxkb3duPTg2NTk7ZS5hcnJvd2RibGxlZnQ9ODY1NjtlLmFycm93ZGJscmlnaHQ9ODY1ODtlLmFycm93ZGJsdXA9ODY1NztlLmFycm93ZG93bj04NTk1O2UuYXJyb3dkb3dubGVmdD04NjAxO2UuYXJyb3dkb3ducmlnaHQ9ODYwMDtlLmFycm93ZG93bndoaXRlPTg2ODE7ZS5hcnJvd2hlYWRkb3dubW9kPTcwOTtlLmFycm93aGVhZGxlZnRtb2Q9NzA2O2UuYXJyb3doZWFkcmlnaHRtb2Q9NzA3O2UuYXJyb3doZWFkdXBtb2Q9NzA4O2UuYXJyb3dob3JpemV4PTYzNzE5O2UuYXJyb3dsZWZ0PTg1OTI7ZS5hcnJvd2xlZnRkYmw9ODY1NjtlLmFycm93bGVmdGRibHN0cm9rZT04NjUzO2UuYXJyb3dsZWZ0b3ZlcnJpZ2h0PTg2NDY7ZS5hcnJvd2xlZnR3aGl0ZT04Njc4O2UuYXJyb3dyaWdodD04NTk0O2UuYXJyb3dyaWdodGRibHN0cm9rZT04NjU1O2UuYXJyb3dyaWdodGhlYXZ5PTEwMTQyO2UuYXJyb3dyaWdodG92ZXJsZWZ0PTg2NDQ7ZS5hcnJvd3JpZ2h0d2hpdGU9ODY4MDtlLmFycm93dGFibGVmdD04Njc2O2UuYXJyb3d0YWJyaWdodD04Njc3O2UuYXJyb3d1cD04NTkzO2UuYXJyb3d1cGRuPTg1OTc7ZS5hcnJvd3VwZG5ic2U9ODYxNjtlLmFycm93dXBkb3duYmFzZT04NjE2O2UuYXJyb3d1cGxlZnQ9ODU5ODtlLmFycm93dXBsZWZ0b2Zkb3duPTg2NDU7ZS5hcnJvd3VwcmlnaHQ9ODU5OTtlLmFycm93dXB3aGl0ZT04Njc5O2UuYXJyb3d2ZXJ0ZXg9NjM3MTg7ZS5hc2NpaWNpcmN1bT05NDtlLmFzY2lpY2lyY3VtbW9ub3NwYWNlPTY1MzQyO2UuYXNjaWl0aWxkZT0xMjY7ZS5hc2NpaXRpbGRlbW9ub3NwYWNlPTY1Mzc0O2UuYXNjcmlwdD01OTM7ZS5hc2NyaXB0dHVybmVkPTU5NDtlLmFzbWFsbGhpcmFnYW5hPTEyMzUzO2UuYXNtYWxsa2F0YWthbmE9MTI0NDk7ZS5hc21hbGxrYXRha2FuYWhhbGZ3aWR0aD02NTM4MztlLmFzdGVyaXNrPTQyO2UuYXN0ZXJpc2thbHRvbmVhcmFiaWM9MTY0NTtlLmFzdGVyaXNrYXJhYmljPTE2NDU7ZS5hc3Rlcmlza21hdGg9ODcyNztlLmFzdGVyaXNrbW9ub3NwYWNlPTY1MjkwO2UuYXN0ZXJpc2tzbWFsbD02NTEyMTtlLmFzdGVyaXNtPTgyNTg7ZS5hc3VwZXJpb3I9NjMyMDk7ZS5hc3ltcHRvdGljYWxseWVxdWFsPTg3NzE7ZS5hdD02NDtlLmF0aWxkZT0yMjc7ZS5hdG1vbm9zcGFjZT02NTMxMjtlLmF0c21hbGw9NjUxMzE7ZS5hdHVybmVkPTU5MjtlLmF1YmVuZ2FsaT0yNDUyO2UuYXVib3BvbW9mbz0xMjU3NjtlLmF1ZGV2YT0yMzI0O2UuYXVndWphcmF0aT0yNzA4O2UuYXVndXJtdWtoaT0yNTgwO2UuYXVsZW5ndGhtYXJrYmVuZ2FsaT0yNTE5O2UuYXVtYXRyYWd1cm11a2hpPTI2MzY7ZS5hdXZvd2Vsc2lnbmJlbmdhbGk9MjUwODtlLmF1dm93ZWxzaWduZGV2YT0yMzgwO2UuYXV2b3dlbHNpZ25ndWphcmF0aT0yNzY0O2UuYXZhZ3JhaGFkZXZhPTIzNjU7ZS5heWJhcm1lbmlhbj0xMzc3O2UuYXlpbj0xNTA2O2UuYXlpbmFsdG9uZWhlYnJldz02NDI4ODtlLmF5aW5oZWJyZXc9MTUwNjtlLmI9OTg7ZS5iYWJlbmdhbGk9MjQ3NjtlLmJhY2tzbGFzaD05MjtlLmJhY2tzbGFzaG1vbm9zcGFjZT02NTM0MDtlLmJhZGV2YT0yMzQ4O2UuYmFndWphcmF0aT0yNzMyO2UuYmFndXJtdWtoaT0yNjA0O2UuYmFoaXJhZ2FuYT0xMjQwMDtlLmJhaHR0aGFpPTM2NDc7ZS5iYWthdGFrYW5hPTEyNDk2O2UuYmFyPTEyNDtlLmJhcm1vbm9zcGFjZT02NTM3MjtlLmJib3BvbW9mbz0xMjU0OTtlLmJjaXJjbGU9OTQyNTtlLmJkb3RhY2NlbnQ9NzY4MztlLmJkb3RiZWxvdz03Njg1O2UuYmVhbWVkc2l4dGVlbnRobm90ZXM9OTgzNjtlLmJlY2F1c2U9ODc1NztlLmJlY3lyaWxsaWM9MTA3MztlLmJlaGFyYWJpYz0xNTc2O2UuYmVoZmluYWxhcmFiaWM9NjUxNjg7ZS5iZWhpbml0aWFsYXJhYmljPTY1MTY5O2UuYmVoaXJhZ2FuYT0xMjQwOTtlLmJlaG1lZGlhbGFyYWJpYz02NTE3MDtlLmJlaG1lZW1pbml0aWFsYXJhYmljPTY0NjcxO2UuYmVobWVlbWlzb2xhdGVkYXJhYmljPTY0NTIwO2UuYmVobm9vbmZpbmFsYXJhYmljPTY0NjIxO2UuYmVrYXRha2FuYT0xMjUwNTtlLmJlbmFybWVuaWFuPTEzNzg7ZS5iZXQ9MTQ4OTtlLmJldGE9OTQ2O2UuYmV0YXN5bWJvbGdyZWVrPTk3NjtlLmJldGRhZ2VzaD02NDMwNTtlLmJldGRhZ2VzaGhlYnJldz02NDMwNTtlLmJldGhlYnJldz0xNDg5O2UuYmV0cmFmZWhlYnJldz02NDMzMjtlLmJoYWJlbmdhbGk9MjQ3NztlLmJoYWRldmE9MjM0OTtlLmJoYWd1amFyYXRpPTI3MzM7ZS5iaGFndXJtdWtoaT0yNjA1O2UuYmhvb2s9NTk1O2UuYmloaXJhZ2FuYT0xMjQwMztlLmJpa2F0YWthbmE9MTI0OTk7ZS5iaWxhYmlhbGNsaWNrPTY2NDtlLmJpbmRpZ3VybXVraGk9MjU2MjtlLmJpcnVzcXVhcmU9MTMxMDU7ZS5ibGFja2NpcmNsZT05Njc5O2UuYmxhY2tkaWFtb25kPTk2NzA7ZS5ibGFja2Rvd25wb2ludGluZ3RyaWFuZ2xlPTk2NjA7ZS5ibGFja2xlZnRwb2ludGluZ3BvaW50ZXI9OTY2ODtlLmJsYWNrbGVmdHBvaW50aW5ndHJpYW5nbGU9OTY2NDtlLmJsYWNrbGVudGljdWxhcmJyYWNrZXRsZWZ0PTEyMzA0O2UuYmxhY2tsZW50aWN1bGFyYnJhY2tldGxlZnR2ZXJ0aWNhbD02NTA4MztlLmJsYWNrbGVudGljdWxhcmJyYWNrZXRyaWdodD0xMjMwNTtlLmJsYWNrbGVudGljdWxhcmJyYWNrZXRyaWdodHZlcnRpY2FsPTY1MDg0O2UuYmxhY2tsb3dlcmxlZnR0cmlhbmdsZT05Njk5O2UuYmxhY2tsb3dlcnJpZ2h0dHJpYW5nbGU9OTY5ODtlLmJsYWNrcmVjdGFuZ2xlPTk2NDQ7ZS5ibGFja3JpZ2h0cG9pbnRpbmdwb2ludGVyPTk2NTg7ZS5ibGFja3JpZ2h0cG9pbnRpbmd0cmlhbmdsZT05NjU0O2UuYmxhY2tzbWFsbHNxdWFyZT05NjQyO2UuYmxhY2tzbWlsaW5nZmFjZT05Nzg3O2UuYmxhY2tzcXVhcmU9OTYzMjtlLmJsYWNrc3Rhcj05NzMzO2UuYmxhY2t1cHBlcmxlZnR0cmlhbmdsZT05NzAwO2UuYmxhY2t1cHBlcnJpZ2h0dHJpYW5nbGU9OTcwMTtlLmJsYWNrdXBwb2ludGluZ3NtYWxsdHJpYW5nbGU9OTY1MjtlLmJsYWNrdXBwb2ludGluZ3RyaWFuZ2xlPTk2NTA7ZS5ibGFuaz05MjUxO2UuYmxpbmViZWxvdz03Njg3O2UuYmxvY2s9OTYwODtlLmJtb25vc3BhY2U9NjUzNDY7ZS5ib2JhaW1haXRoYWk9MzYxMDtlLmJvaGlyYWdhbmE9MTI0MTI7ZS5ib2thdGFrYW5hPTEyNTA4O2UuYnBhcmVuPTkzNzM7ZS5icXNxdWFyZT0xMzI1MTtlLmJyYWNlZXg9NjM3MzI7ZS5icmFjZWxlZnQ9MTIzO2UuYnJhY2VsZWZ0YnQ9NjM3MzE7ZS5icmFjZWxlZnRtaWQ9NjM3MzA7ZS5icmFjZWxlZnRtb25vc3BhY2U9NjUzNzE7ZS5icmFjZWxlZnRzbWFsbD02NTExNTtlLmJyYWNlbGVmdHRwPTYzNzI5O2UuYnJhY2VsZWZ0dmVydGljYWw9NjUwNzk7ZS5icmFjZXJpZ2h0PTEyNTtlLmJyYWNlcmlnaHRidD02Mzc0MjtlLmJyYWNlcmlnaHRtaWQ9NjM3NDE7ZS5icmFjZXJpZ2h0bW9ub3NwYWNlPTY1MzczO2UuYnJhY2VyaWdodHNtYWxsPTY1MTE2O2UuYnJhY2VyaWdodHRwPTYzNzQwO2UuYnJhY2VyaWdodHZlcnRpY2FsPTY1MDgwO2UuYnJhY2tldGxlZnQ9OTE7ZS5icmFja2V0bGVmdGJ0PTYzNzI4O2UuYnJhY2tldGxlZnRleD02MzcyNztlLmJyYWNrZXRsZWZ0bW9ub3NwYWNlPTY1MzM5O2UuYnJhY2tldGxlZnR0cD02MzcyNjtlLmJyYWNrZXRyaWdodD05MztlLmJyYWNrZXRyaWdodGJ0PTYzNzM5O2UuYnJhY2tldHJpZ2h0ZXg9NjM3Mzg7ZS5icmFja2V0cmlnaHRtb25vc3BhY2U9NjUzNDE7ZS5icmFja2V0cmlnaHR0cD02MzczNztlLmJyZXZlPTcyODtlLmJyZXZlYmVsb3djbWI9ODE0O2UuYnJldmVjbWI9Nzc0O2UuYnJldmVpbnZlcnRlZGJlbG93Y21iPTgxNTtlLmJyZXZlaW52ZXJ0ZWRjbWI9Nzg1O2UuYnJldmVpbnZlcnRlZGRvdWJsZWNtYj04NjU7ZS5icmlkZ2ViZWxvd2NtYj04MTA7ZS5icmlkZ2VpbnZlcnRlZGJlbG93Y21iPTgyNjtlLmJyb2tlbmJhcj0xNjY7ZS5ic3Ryb2tlPTM4NDtlLmJzdXBlcmlvcj02MzIxMDtlLmJ0b3BiYXI9Mzg3O2UuYnVoaXJhZ2FuYT0xMjQwNjtlLmJ1a2F0YWthbmE9MTI1MDI7ZS5idWxsZXQ9ODIyNjtlLmJ1bGxldGludmVyc2U9OTY4ODtlLmJ1bGxldG9wZXJhdG9yPTg3Mjk7ZS5idWxsc2V5ZT05Njc4O2UuYz05OTtlLmNhYXJtZW5pYW49MTM5MDtlLmNhYmVuZ2FsaT0yNDU4O2UuY2FjdXRlPTI2MztlLmNhZGV2YT0yMzMwO2UuY2FndWphcmF0aT0yNzE0O2UuY2FndXJtdWtoaT0yNTg2O2UuY2Fsc3F1YXJlPTEzMTkyO2UuY2FuZHJhYmluZHViZW5nYWxpPTI0MzM7ZS5jYW5kcmFiaW5kdWNtYj03ODQ7ZS5jYW5kcmFiaW5kdWRldmE9MjMwNTtlLmNhbmRyYWJpbmR1Z3VqYXJhdGk9MjY4OTtlLmNhcHNsb2NrPTg2ODI7ZS5jYXJlb2Y9ODQ1MztlLmNhcm9uPTcxMTtlLmNhcm9uYmVsb3djbWI9ODEyO2UuY2Fyb25jbWI9NzgwO2UuY2FycmlhZ2VyZXR1cm49ODYyOTtlLmNib3BvbW9mbz0xMjU2ODtlLmNjYXJvbj0yNjk7ZS5jY2VkaWxsYT0yMzE7ZS5jY2VkaWxsYWFjdXRlPTc2ODk7ZS5jY2lyY2xlPTk0MjY7ZS5jY2lyY3VtZmxleD0yNjU7ZS5jY3VybD01OTc7ZS5jZG90PTI2NztlLmNkb3RhY2NlbnQ9MjY3O2UuY2RzcXVhcmU9MTMyNTM7ZS5jZWRpbGxhPTE4NDtlLmNlZGlsbGFjbWI9ODA3O2UuY2VudD0xNjI7ZS5jZW50aWdyYWRlPTg0NTE7ZS5jZW50aW5mZXJpb3I9NjMxOTk7ZS5jZW50bW9ub3NwYWNlPTY1NTA0O2UuY2VudG9sZHN0eWxlPTYzMzk0O2UuY2VudHN1cGVyaW9yPTYzMjAwO2UuY2hhYXJtZW5pYW49MTQwMTtlLmNoYWJlbmdhbGk9MjQ1OTtlLmNoYWRldmE9MjMzMTtlLmNoYWd1amFyYXRpPTI3MTU7ZS5jaGFndXJtdWtoaT0yNTg3O2UuY2hib3BvbW9mbz0xMjU2NDtlLmNoZWFia2hhc2lhbmN5cmlsbGljPTEyMTM7ZS5jaGVja21hcms9MTAwMDM7ZS5jaGVjeXJpbGxpYz0xMDk1O2UuY2hlZGVzY2VuZGVyYWJraGFzaWFuY3lyaWxsaWM9MTIxNTtlLmNoZWRlc2NlbmRlcmN5cmlsbGljPTEyMDc7ZS5jaGVkaWVyZXNpc2N5cmlsbGljPTEyNjk7ZS5jaGVoYXJtZW5pYW49MTM5NTtlLmNoZWtoYWthc3NpYW5jeXJpbGxpYz0xMjI4O2UuY2hldmVydGljYWxzdHJva2VjeXJpbGxpYz0xMjA5O2UuY2hpPTk2NztlLmNoaWV1Y2hhY2lyY2xla29yZWFuPTEyOTE5O2UuY2hpZXVjaGFwYXJlbmtvcmVhbj0xMjgyMztlLmNoaWV1Y2hjaXJjbGVrb3JlYW49MTI5MDU7ZS5jaGlldWNoa29yZWFuPTEyNjE4O2UuY2hpZXVjaHBhcmVua29yZWFuPTEyODA5O2UuY2hvY2hhbmd0aGFpPTM1OTQ7ZS5jaG9jaGFudGhhaT0zNTkyO2UuY2hvY2hpbmd0aGFpPTM1OTM7ZS5jaG9jaG9ldGhhaT0zNTk2O2UuY2hvb2s9MzkyO2UuY2lldWNhY2lyY2xla29yZWFuPTEyOTE4O2UuY2lldWNhcGFyZW5rb3JlYW49MTI4MjI7ZS5jaWV1Y2NpcmNsZWtvcmVhbj0xMjkwNDtlLmNpZXVja29yZWFuPTEyNjE2O2UuY2lldWNwYXJlbmtvcmVhbj0xMjgwODtlLmNpZXVjdXBhcmVua29yZWFuPTEyODI4O2UuY2lyY2xlPTk2NzU7ZS5jaXJjbGVjb3B5cnQ9MTY5O2UuY2lyY2xlbXVsdGlwbHk9ODg1NTtlLmNpcmNsZW90PTg4NTc7ZS5jaXJjbGVwbHVzPTg4NTM7ZS5jaXJjbGVwb3N0YWxtYXJrPTEyMzQyO2UuY2lyY2xld2l0aGxlZnRoYWxmYmxhY2s9OTY4MDtlLmNpcmNsZXdpdGhyaWdodGhhbGZibGFjaz05NjgxO2UuY2lyY3VtZmxleD03MTA7ZS5jaXJjdW1mbGV4YmVsb3djbWI9ODEzO2UuY2lyY3VtZmxleGNtYj03NzA7ZS5jbGVhcj04OTk5O2UuY2xpY2thbHZlb2xhcj00NTA7ZS5jbGlja2RlbnRhbD00NDg7ZS5jbGlja2xhdGVyYWw9NDQ5O2UuY2xpY2tyZXRyb2ZsZXg9NDUxO2UuY2x1Yj05ODI3O2UuY2x1YnN1aXRibGFjaz05ODI3O2UuY2x1YnN1aXR3aGl0ZT05ODMxO2UuY21jdWJlZHNxdWFyZT0xMzIyMDtlLmNtb25vc3BhY2U9NjUzNDc7ZS5jbXNxdWFyZWRzcXVhcmU9MTMyMTY7ZS5jb2FybWVuaWFuPTE0MDk7ZS5jb2xvbj01ODtlLmNvbG9ubW9uZXRhcnk9ODM1MztlLmNvbG9ubW9ub3NwYWNlPTY1MzA2O2UuY29sb25zaWduPTgzNTM7ZS5jb2xvbnNtYWxsPTY1MTA5O2UuY29sb250cmlhbmd1bGFyaGFsZm1vZD03MjE7ZS5jb2xvbnRyaWFuZ3VsYXJtb2Q9NzIwO2UuY29tbWE9NDQ7ZS5jb21tYWFib3ZlY21iPTc4NztlLmNvbW1hYWJvdmVyaWdodGNtYj03ODk7ZS5jb21tYWFjY2VudD02MzE3MTtlLmNvbW1hYXJhYmljPTE1NDg7ZS5jb21tYWFybWVuaWFuPTEzNzM7ZS5jb21tYWluZmVyaW9yPTYzMjAxO2UuY29tbWFtb25vc3BhY2U9NjUyOTI7ZS5jb21tYXJldmVyc2VkYWJvdmVjbWI9Nzg4O2UuY29tbWFyZXZlcnNlZG1vZD03MDE7ZS5jb21tYXNtYWxsPTY1MTA0O2UuY29tbWFzdXBlcmlvcj02MzIwMjtlLmNvbW1hdHVybmVkYWJvdmVjbWI9Nzg2O2UuY29tbWF0dXJuZWRtb2Q9Njk5O2UuY29tcGFzcz05Nzg4O2UuY29uZ3J1ZW50PTg3NzM7ZS5jb250b3VyaW50ZWdyYWw9ODc1MDtlLmNvbnRyb2w9ODk2MztlLmNvbnRyb2xBQ0s9NjtlLmNvbnRyb2xCRUw9NztlLmNvbnRyb2xCUz04O2UuY29udHJvbENBTj0yNDtlLmNvbnRyb2xDUj0xMztlLmNvbnRyb2xEQzE9MTc7ZS5jb250cm9sREMyPTE4O2UuY29udHJvbERDMz0xOTtlLmNvbnRyb2xEQzQ9MjA7ZS5jb250cm9sREVMPTEyNztlLmNvbnRyb2xETEU9MTY7ZS5jb250cm9sRU09MjU7ZS5jb250cm9sRU5RPTU7ZS5jb250cm9sRU9UPTQ7ZS5jb250cm9sRVNDPTI3O2UuY29udHJvbEVUQj0yMztlLmNvbnRyb2xFVFg9MztlLmNvbnRyb2xGRj0xMjtlLmNvbnRyb2xGUz0yODtlLmNvbnRyb2xHUz0yOTtlLmNvbnRyb2xIVD05O2UuY29udHJvbExGPTEwO2UuY29udHJvbE5BSz0yMTtlLmNvbnRyb2xOVUxMPTA7ZS5jb250cm9sUlM9MzA7ZS5jb250cm9sU0k9MTU7ZS5jb250cm9sU089MTQ7ZS5jb250cm9sU09UPTI7ZS5jb250cm9sU1RYPTE7ZS5jb250cm9sU1VCPTI2O2UuY29udHJvbFNZTj0yMjtlLmNvbnRyb2xVUz0zMTtlLmNvbnRyb2xWVD0xMTtlLmNvcHlyaWdodD0xNjk7ZS5jb3B5cmlnaHRzYW5zPTYzNzIxO2UuY29weXJpZ2h0c2VyaWY9NjMxOTM7ZS5jb3JuZXJicmFja2V0bGVmdD0xMjMwMDtlLmNvcm5lcmJyYWNrZXRsZWZ0aGFsZndpZHRoPTY1Mzc4O2UuY29ybmVyYnJhY2tldGxlZnR2ZXJ0aWNhbD02NTA4OTtlLmNvcm5lcmJyYWNrZXRyaWdodD0xMjMwMTtlLmNvcm5lcmJyYWNrZXRyaWdodGhhbGZ3aWR0aD02NTM3OTtlLmNvcm5lcmJyYWNrZXRyaWdodHZlcnRpY2FsPTY1MDkwO2UuY29ycG9yYXRpb25zcXVhcmU9MTMxODM7ZS5jb3NxdWFyZT0xMzI1NTtlLmNvdmVya2dzcXVhcmU9MTMyNTQ7ZS5jcGFyZW49OTM3NDtlLmNydXplaXJvPTgzNTQ7ZS5jc3RyZXRjaGVkPTY2MztlLmN1cmx5YW5kPTg5MTE7ZS5jdXJseW9yPTg5MTA7ZS5jdXJyZW5jeT0xNjQ7ZS5jeXJCcmV2ZT02MzE4NTtlLmN5ckZsZXg9NjMxODY7ZS5jeXJicmV2ZT02MzE4ODtlLmN5cmZsZXg9NjMxODk7ZS5kPTEwMDtlLmRhYXJtZW5pYW49MTM4MDtlLmRhYmVuZ2FsaT0yNDcwO2UuZGFkYXJhYmljPTE1OTA7ZS5kYWRldmE9MjM0MjtlLmRhZGZpbmFsYXJhYmljPTY1MjE0O2UuZGFkaW5pdGlhbGFyYWJpYz02NTIxNTtlLmRhZG1lZGlhbGFyYWJpYz02NTIxNjtlLmRhZ2VzaD0xNDY4O2UuZGFnZXNoaGVicmV3PTE0Njg7ZS5kYWdnZXI9ODIyNDtlLmRhZ2dlcmRibD04MjI1O2UuZGFndWphcmF0aT0yNzI2O2UuZGFndXJtdWtoaT0yNTk4O2UuZGFoaXJhZ2FuYT0xMjM4NDtlLmRha2F0YWthbmE9MTI0ODA7ZS5kYWxhcmFiaWM9MTU4MztlLmRhbGV0PTE0OTE7ZS5kYWxldGRhZ2VzaD02NDMwNztlLmRhbGV0ZGFnZXNoaGVicmV3PTY0MzA3O2UuZGFsZXRoZWJyZXc9MTQ5MTtlLmRhbGZpbmFsYXJhYmljPTY1MTk0O2UuZGFtbWFhcmFiaWM9MTYxNTtlLmRhbW1hbG93YXJhYmljPTE2MTU7ZS5kYW1tYXRhbmFsdG9uZWFyYWJpYz0xNjEyO2UuZGFtbWF0YW5hcmFiaWM9MTYxMjtlLmRhbmRhPTI0MDQ7ZS5kYXJnYWhlYnJldz0xNDQ3O2UuZGFyZ2FsZWZ0aGVicmV3PTE0NDc7ZS5kYXNpYXBuZXVtYXRhY3lyaWxsaWNjbWI9MTE1NztlLmRibEdyYXZlPTYzMTg3O2UuZGJsYW5nbGVicmFja2V0bGVmdD0xMjI5ODtlLmRibGFuZ2xlYnJhY2tldGxlZnR2ZXJ0aWNhbD02NTA4NTtlLmRibGFuZ2xlYnJhY2tldHJpZ2h0PTEyMjk5O2UuZGJsYW5nbGVicmFja2V0cmlnaHR2ZXJ0aWNhbD02NTA4NjtlLmRibGFyY2hpbnZlcnRlZGJlbG93Y21iPTgxMTtlLmRibGFycm93bGVmdD04NjYwO2UuZGJsYXJyb3dyaWdodD04NjU4O2UuZGJsZGFuZGE9MjQwNTtlLmRibGdyYXZlPTYzMTkwO2UuZGJsZ3JhdmVjbWI9NzgzO2UuZGJsaW50ZWdyYWw9ODc0ODtlLmRibGxvd2xpbmU9ODIxNTtlLmRibGxvd2xpbmVjbWI9ODE5O2UuZGJsb3ZlcmxpbmVjbWI9ODMxO2UuZGJscHJpbWVtb2Q9Njk4O2UuZGJsdmVydGljYWxiYXI9ODIxNDtlLmRibHZlcnRpY2FsbGluZWFib3ZlY21iPTc4MjtlLmRib3BvbW9mbz0xMjU1MztlLmRic3F1YXJlPTEzMjU2O2UuZGNhcm9uPTI3MTtlLmRjZWRpbGxhPTc2OTc7ZS5kY2lyY2xlPTk0Mjc7ZS5kY2lyY3VtZmxleGJlbG93PTc2OTk7ZS5kY3JvYXQ9MjczO2UuZGRhYmVuZ2FsaT0yNDY1O2UuZGRhZGV2YT0yMzM3O2UuZGRhZ3VqYXJhdGk9MjcyMTtlLmRkYWd1cm11a2hpPTI1OTM7ZS5kZGFsYXJhYmljPTE2NzI7ZS5kZGFsZmluYWxhcmFiaWM9NjQzOTM7ZS5kZGRoYWRldmE9MjM5NjtlLmRkaGFiZW5nYWxpPTI0NjY7ZS5kZGhhZGV2YT0yMzM4O2UuZGRoYWd1amFyYXRpPTI3MjI7ZS5kZGhhZ3VybXVraGk9MjU5NDtlLmRkb3RhY2NlbnQ9NzY5MTtlLmRkb3RiZWxvdz03NjkzO2UuZGVjaW1hbHNlcGFyYXRvcmFyYWJpYz0xNjQzO2UuZGVjaW1hbHNlcGFyYXRvcnBlcnNpYW49MTY0MztlLmRlY3lyaWxsaWM9MTA3NjtlLmRlZ3JlZT0xNzY7ZS5kZWhpaGVicmV3PTE0NTM7ZS5kZWhpcmFnYW5hPTEyMzkxO2UuZGVpY29wdGljPTEwMDc7ZS5kZWthdGFrYW5hPTEyNDg3O2UuZGVsZXRlbGVmdD05MDAzO2UuZGVsZXRlcmlnaHQ9ODk5ODtlLmRlbHRhPTk0ODtlLmRlbHRhdHVybmVkPTM5NztlLmRlbm9taW5hdG9ybWludXNvbmVudW1lcmF0b3JiZW5nYWxpPTI1NTI7ZS5kZXpoPTY3NjtlLmRoYWJlbmdhbGk9MjQ3MTtlLmRoYWRldmE9MjM0MztlLmRoYWd1amFyYXRpPTI3Mjc7ZS5kaGFndXJtdWtoaT0yNTk5O2UuZGhvb2s9NTk5O2UuZGlhbHl0aWthdG9ub3M9OTAxO2UuZGlhbHl0aWthdG9ub3NjbWI9ODM2O2UuZGlhbW9uZD05ODMwO2UuZGlhbW9uZHN1aXR3aGl0ZT05ODI2O2UuZGllcmVzaXM9MTY4O2UuZGllcmVzaXNhY3V0ZT02MzE5MTtlLmRpZXJlc2lzYmVsb3djbWI9ODA0O2UuZGllcmVzaXNjbWI9Nzc2O2UuZGllcmVzaXNncmF2ZT02MzE5MjtlLmRpZXJlc2lzdG9ub3M9OTAxO2UuZGloaXJhZ2FuYT0xMjM4NjtlLmRpa2F0YWthbmE9MTI0ODI7ZS5kaXR0b21hcms9MTIyOTE7ZS5kaXZpZGU9MjQ3O2UuZGl2aWRlcz04NzM5O2UuZGl2aXNpb25zbGFzaD04NzI1O2UuZGplY3lyaWxsaWM9MTEwNjtlLmRrc2hhZGU9OTYxOTtlLmRsaW5lYmVsb3c9NzY5NTtlLmRsc3F1YXJlPTEzMjA3O2UuZG1hY3Jvbj0yNzM7ZS5kbW9ub3NwYWNlPTY1MzQ4O2UuZG5ibG9jaz05NjA0O2UuZG9jaGFkYXRoYWk9MzU5ODtlLmRvZGVrdGhhaT0zNjA0O2UuZG9oaXJhZ2FuYT0xMjM5MztlLmRva2F0YWthbmE9MTI0ODk7ZS5kb2xsYXI9MzY7ZS5kb2xsYXJpbmZlcmlvcj02MzIwMztlLmRvbGxhcm1vbm9zcGFjZT02NTI4NDtlLmRvbGxhcm9sZHN0eWxlPTYzMjY4O2UuZG9sbGFyc21hbGw9NjUxMjk7ZS5kb2xsYXJzdXBlcmlvcj02MzIwNDtlLmRvbmc9ODM2MztlLmRvcnVzcXVhcmU9MTMwOTQ7ZS5kb3RhY2NlbnQ9NzI5O2UuZG90YWNjZW50Y21iPTc3NTtlLmRvdGJlbG93Y21iPTgwMztlLmRvdGJlbG93Y29tYj04MDM7ZS5kb3RrYXRha2FuYT0xMjUzOTtlLmRvdGxlc3NpPTMwNTtlLmRvdGxlc3NqPTYzMTY2O2UuZG90bGVzc2pzdHJva2Vob29rPTY0NDtlLmRvdG1hdGg9ODkwMTtlLmRvdHRlZGNpcmNsZT05Njc2O2UuZG91YmxleW9kcGF0YWg9NjQyODc7ZS5kb3VibGV5b2RwYXRhaGhlYnJldz02NDI4NztlLmRvd250YWNrYmVsb3djbWI9Nzk4O2UuZG93bnRhY2ttb2Q9NzI1O2UuZHBhcmVuPTkzNzU7ZS5kc3VwZXJpb3I9NjMyMTE7ZS5kdGFpbD01OTg7ZS5kdG9wYmFyPTM5NjtlLmR1aGlyYWdhbmE9MTIzODk7ZS5kdWthdGFrYW5hPTEyNDg1O2UuZHo9NDk5O2UuZHphbHRvbmU9Njc1O2UuZHpjYXJvbj00NTQ7ZS5kemN1cmw9Njc3O2UuZHplYWJraGFzaWFuY3lyaWxsaWM9MTI0OTtlLmR6ZWN5cmlsbGljPTExMDk7ZS5kemhlY3lyaWxsaWM9MTExOTtlLmU9MTAxO2UuZWFjdXRlPTIzMztlLmVhcnRoPTk3OTM7ZS5lYmVuZ2FsaT0yNDQ3O2UuZWJvcG9tb2ZvPTEyNTcyO2UuZWJyZXZlPTI3NztlLmVjYW5kcmFkZXZhPTIzMTc7ZS5lY2FuZHJhZ3VqYXJhdGk9MjcwMTtlLmVjYW5kcmF2b3dlbHNpZ25kZXZhPTIzNzM7ZS5lY2FuZHJhdm93ZWxzaWduZ3VqYXJhdGk9Mjc1NztlLmVjYXJvbj0yODM7ZS5lY2VkaWxsYWJyZXZlPTc3MDk7ZS5lY2hhcm1lbmlhbj0xMzgxO2UuZWNoeWl3bmFybWVuaWFuPTE0MTU7ZS5lY2lyY2xlPTk0Mjg7ZS5lY2lyY3VtZmxleD0yMzQ7ZS5lY2lyY3VtZmxleGFjdXRlPTc4NzE7ZS5lY2lyY3VtZmxleGJlbG93PTc3MDU7ZS5lY2lyY3VtZmxleGRvdGJlbG93PTc4Nzk7ZS5lY2lyY3VtZmxleGdyYXZlPTc4NzM7ZS5lY2lyY3VtZmxleGhvb2thYm92ZT03ODc1O2UuZWNpcmN1bWZsZXh0aWxkZT03ODc3O2UuZWN5cmlsbGljPTExMDg7ZS5lZGJsZ3JhdmU9NTE3O2UuZWRldmE9MjMxOTtlLmVkaWVyZXNpcz0yMzU7ZS5lZG90PTI3OTtlLmVkb3RhY2NlbnQ9Mjc5O2UuZWRvdGJlbG93PTc4NjU7ZS5lZWd1cm11a2hpPTI1NzU7ZS5lZW1hdHJhZ3VybXVraGk9MjYzMTtlLmVmY3lyaWxsaWM9MTA5MjtlLmVncmF2ZT0yMzI7ZS5lZ3VqYXJhdGk9MjcwMztlLmVoYXJtZW5pYW49MTM4MztlLmVoYm9wb21vZm89MTI1NzM7ZS5laGlyYWdhbmE9MTIzNjA7ZS5laG9va2Fib3ZlPTc4Njc7ZS5laWJvcG9tb2ZvPTEyNTc1O2UuZWlnaHQ9NTY7ZS5laWdodGFyYWJpYz0xNjQwO2UuZWlnaHRiZW5nYWxpPTI1NDI7ZS5laWdodGNpcmNsZT05MzE5O2UuZWlnaHRjaXJjbGVpbnZlcnNlc2Fuc3NlcmlmPTEwMTI5O2UuZWlnaHRkZXZhPTI0MTQ7ZS5laWdodGVlbmNpcmNsZT05MzI5O2UuZWlnaHRlZW5wYXJlbj05MzQ5O2UuZWlnaHRlZW5wZXJpb2Q9OTM2OTtlLmVpZ2h0Z3VqYXJhdGk9Mjc5ODtlLmVpZ2h0Z3VybXVraGk9MjY3MDtlLmVpZ2h0aGFja2FyYWJpYz0xNjQwO2UuZWlnaHRoYW5nemhvdT0xMjMyODtlLmVpZ2h0aG5vdGViZWFtZWQ9OTgzNTtlLmVpZ2h0aWRlb2dyYXBoaWNwYXJlbj0xMjgzOTtlLmVpZ2h0aW5mZXJpb3I9ODMyODtlLmVpZ2h0bW9ub3NwYWNlPTY1MzA0O2UuZWlnaHRvbGRzdHlsZT02MzI4ODtlLmVpZ2h0cGFyZW49OTMzOTtlLmVpZ2h0cGVyaW9kPTkzNTk7ZS5laWdodHBlcnNpYW49MTc4NDtlLmVpZ2h0cm9tYW49ODU2NztlLmVpZ2h0c3VwZXJpb3I9ODMxMjtlLmVpZ2h0dGhhaT0zNjcyO2UuZWludmVydGVkYnJldmU9NTE5O2UuZWlvdGlmaWVkY3lyaWxsaWM9MTEyNTtlLmVrYXRha2FuYT0xMjQ1NjtlLmVrYXRha2FuYWhhbGZ3aWR0aD02NTM5NjtlLmVrb25rYXJndXJtdWtoaT0yNjc2O2UuZWtvcmVhbj0xMjYyODtlLmVsY3lyaWxsaWM9MTA4MztlLmVsZW1lbnQ9ODcxMjtlLmVsZXZlbmNpcmNsZT05MzIyO2UuZWxldmVucGFyZW49OTM0MjtlLmVsZXZlbnBlcmlvZD05MzYyO2UuZWxldmVucm9tYW49ODU3MDtlLmVsbGlwc2lzPTgyMzA7ZS5lbGxpcHNpc3ZlcnRpY2FsPTg5NDI7ZS5lbWFjcm9uPTI3NTtlLmVtYWNyb25hY3V0ZT03NzAzO2UuZW1hY3JvbmdyYXZlPTc3MDE7ZS5lbWN5cmlsbGljPTEwODQ7ZS5lbWRhc2g9ODIxMjtlLmVtZGFzaHZlcnRpY2FsPTY1MDczO2UuZW1vbm9zcGFjZT02NTM0OTtlLmVtcGhhc2lzbWFya2FybWVuaWFuPTEzNzE7ZS5lbXB0eXNldD04NzA5O2UuZW5ib3BvbW9mbz0xMjU3OTtlLmVuY3lyaWxsaWM9MTA4NTtlLmVuZGFzaD04MjExO2UuZW5kYXNodmVydGljYWw9NjUwNzQ7ZS5lbmRlc2NlbmRlcmN5cmlsbGljPTExODc7ZS5lbmc9MzMxO2UuZW5nYm9wb21vZm89MTI1ODE7ZS5lbmdoZWN5cmlsbGljPTExODk7ZS5lbmhvb2tjeXJpbGxpYz0xMjI0O2UuZW5zcGFjZT04MTk0O2UuZW9nb25laz0yODE7ZS5lb2tvcmVhbj0xMjYyNztlLmVvcGVuPTYwMztlLmVvcGVuY2xvc2VkPTY2NjtlLmVvcGVucmV2ZXJzZWQ9NjA0O2UuZW9wZW5yZXZlcnNlZGNsb3NlZD02MDY7ZS5lb3BlbnJldmVyc2VkaG9vaz02MDU7ZS5lcGFyZW49OTM3NjtlLmVwc2lsb249OTQ5O2UuZXBzaWxvbnRvbm9zPTk0MTtlLmVxdWFsPTYxO2UuZXF1YWxtb25vc3BhY2U9NjUzMDk7ZS5lcXVhbHNtYWxsPTY1MTI2O2UuZXF1YWxzdXBlcmlvcj04MzE2O2UuZXF1aXZhbGVuY2U9ODgwMTtlLmVyYm9wb21vZm89MTI1ODI7ZS5lcmN5cmlsbGljPTEwODg7ZS5lcmV2ZXJzZWQ9NjAwO2UuZXJldmVyc2VkY3lyaWxsaWM9MTEwMTtlLmVzY3lyaWxsaWM9MTA4OTtlLmVzZGVzY2VuZGVyY3lyaWxsaWM9MTE5NTtlLmVzaD02NDM7ZS5lc2hjdXJsPTY0NjtlLmVzaG9ydGRldmE9MjMxODtlLmVzaG9ydHZvd2Vsc2lnbmRldmE9MjM3NDtlLmVzaHJldmVyc2VkbG9vcD00MjY7ZS5lc2hzcXVhdHJldmVyc2VkPTY0NTtlLmVzbWFsbGhpcmFnYW5hPTEyMzU5O2UuZXNtYWxsa2F0YWthbmE9MTI0NTU7ZS5lc21hbGxrYXRha2FuYWhhbGZ3aWR0aD02NTM4NjtlLmVzdGltYXRlZD04NDk0O2UuZXN1cGVyaW9yPTYzMjEyO2UuZXRhPTk1MTtlLmV0YXJtZW5pYW49MTM4NDtlLmV0YXRvbm9zPTk0MjtlLmV0aD0yNDA7ZS5ldGlsZGU9Nzg2OTtlLmV0aWxkZWJlbG93PTc3MDc7ZS5ldG5haHRhZm91a2hoZWJyZXc9MTQyNTtlLmV0bmFodGFmb3VraGxlZnRoZWJyZXc9MTQyNTtlLmV0bmFodGFoZWJyZXc9MTQyNTtlLmV0bmFodGFsZWZ0aGVicmV3PTE0MjU7ZS5ldHVybmVkPTQ3NztlLmV1a29yZWFuPTEyNjQxO2UuZXVybz04MzY0O2UuZXZvd2Vsc2lnbmJlbmdhbGk9MjUwMztlLmV2b3dlbHNpZ25kZXZhPTIzNzU7ZS5ldm93ZWxzaWduZ3VqYXJhdGk9Mjc1OTtlLmV4Y2xhbT0zMztlLmV4Y2xhbWFybWVuaWFuPTEzNzI7ZS5leGNsYW1kYmw9ODI1MjtlLmV4Y2xhbWRvd249MTYxO2UuZXhjbGFtZG93bnNtYWxsPTYzMzkzO2UuZXhjbGFtbW9ub3NwYWNlPTY1MjgxO2UuZXhjbGFtc21hbGw9NjMyNjU7ZS5leGlzdGVudGlhbD04NzA3O2UuZXpoPTY1ODtlLmV6aGNhcm9uPTQ5NTtlLmV6aGN1cmw9NjU5O2UuZXpocmV2ZXJzZWQ9NDQxO2UuZXpodGFpbD00NDI7ZS5mPTEwMjtlLmZhZGV2YT0yMzk4O2UuZmFndXJtdWtoaT0yNjU0O2UuZmFocmVuaGVpdD04NDU3O2UuZmF0aGFhcmFiaWM9MTYxNDtlLmZhdGhhbG93YXJhYmljPTE2MTQ7ZS5mYXRoYXRhbmFyYWJpYz0xNjExO2UuZmJvcG9tb2ZvPTEyNTUyO2UuZmNpcmNsZT05NDI5O2UuZmRvdGFjY2VudD03NzExO2UuZmVoYXJhYmljPTE2MDE7ZS5mZWhhcm1lbmlhbj0xNDE0O2UuZmVoZmluYWxhcmFiaWM9NjUyMzQ7ZS5mZWhpbml0aWFsYXJhYmljPTY1MjM1O2UuZmVobWVkaWFsYXJhYmljPTY1MjM2O2UuZmVpY29wdGljPTk5NztlLmZlbWFsZT05NzkyO2UuZmY9NjQyNTY7ZS5mX2Y9NjQyNTY7ZS5mZmk9NjQyNTk7ZS5mX2ZfaT02NDI1OTtlLmZmbD02NDI2MDtlLmZfZl9sPTY0MjYwO2UuZmk9NjQyNTc7ZS5mX2k9NjQyNTc7ZS5maWZ0ZWVuY2lyY2xlPTkzMjY7ZS5maWZ0ZWVucGFyZW49OTM0NjtlLmZpZnRlZW5wZXJpb2Q9OTM2NjtlLmZpZ3VyZWRhc2g9ODIxMDtlLmZpbGxlZGJveD05NjMyO2UuZmlsbGVkcmVjdD05NjQ0O2UuZmluYWxrYWY9MTQ5ODtlLmZpbmFsa2FmZGFnZXNoPTY0MzE0O2UuZmluYWxrYWZkYWdlc2hoZWJyZXc9NjQzMTQ7ZS5maW5hbGthZmhlYnJldz0xNDk4O2UuZmluYWxtZW09MTUwMTtlLmZpbmFsbWVtaGVicmV3PTE1MDE7ZS5maW5hbG51bj0xNTAzO2UuZmluYWxudW5oZWJyZXc9MTUwMztlLmZpbmFscGU9MTUwNztlLmZpbmFscGVoZWJyZXc9MTUwNztlLmZpbmFsdHNhZGk9MTUwOTtlLmZpbmFsdHNhZGloZWJyZXc9MTUwOTtlLmZpcnN0dG9uZWNoaW5lc2U9NzEzO2UuZmlzaGV5ZT05NjczO2UuZml0YWN5cmlsbGljPTExMzk7ZS5maXZlPTUzO2UuZml2ZWFyYWJpYz0xNjM3O2UuZml2ZWJlbmdhbGk9MjUzOTtlLmZpdmVjaXJjbGU9OTMxNjtlLmZpdmVjaXJjbGVpbnZlcnNlc2Fuc3NlcmlmPTEwMTI2O2UuZml2ZWRldmE9MjQxMTtlLmZpdmVlaWdodGhzPTg1NDE7ZS5maXZlZ3VqYXJhdGk9Mjc5NTtlLmZpdmVndXJtdWtoaT0yNjY3O2UuZml2ZWhhY2thcmFiaWM9MTYzNztlLmZpdmVoYW5nemhvdT0xMjMyNTtlLmZpdmVpZGVvZ3JhcGhpY3BhcmVuPTEyODM2O2UuZml2ZWluZmVyaW9yPTgzMjU7ZS5maXZlbW9ub3NwYWNlPTY1MzAxO2UuZml2ZW9sZHN0eWxlPTYzMjg1O2UuZml2ZXBhcmVuPTkzMzY7ZS5maXZlcGVyaW9kPTkzNTY7ZS5maXZlcGVyc2lhbj0xNzgxO2UuZml2ZXJvbWFuPTg1NjQ7ZS5maXZlc3VwZXJpb3I9ODMwOTtlLmZpdmV0aGFpPTM2Njk7ZS5mbD02NDI1ODtlLmZfbD02NDI1ODtlLmZsb3Jpbj00MDI7ZS5mbW9ub3NwYWNlPTY1MzUwO2UuZm1zcXVhcmU9MTMyMDk7ZS5mb2ZhbnRoYWk9MzYxNTtlLmZvZmF0aGFpPTM2MTM7ZS5mb25nbWFudGhhaT0zNjYzO2UuZm9yYWxsPTg3MDQ7ZS5mb3VyPTUyO2UuZm91cmFyYWJpYz0xNjM2O2UuZm91cmJlbmdhbGk9MjUzODtlLmZvdXJjaXJjbGU9OTMxNTtlLmZvdXJjaXJjbGVpbnZlcnNlc2Fuc3NlcmlmPTEwMTI1O2UuZm91cmRldmE9MjQxMDtlLmZvdXJndWphcmF0aT0yNzk0O2UuZm91cmd1cm11a2hpPTI2NjY7ZS5mb3VyaGFja2FyYWJpYz0xNjM2O2UuZm91cmhhbmd6aG91PTEyMzI0O2UuZm91cmlkZW9ncmFwaGljcGFyZW49MTI4MzU7ZS5mb3VyaW5mZXJpb3I9ODMyNDtlLmZvdXJtb25vc3BhY2U9NjUzMDA7ZS5mb3VybnVtZXJhdG9yYmVuZ2FsaT0yNTUxO2UuZm91cm9sZHN0eWxlPTYzMjg0O2UuZm91cnBhcmVuPTkzMzU7ZS5mb3VycGVyaW9kPTkzNTU7ZS5mb3VycGVyc2lhbj0xNzgwO2UuZm91cnJvbWFuPTg1NjM7ZS5mb3Vyc3VwZXJpb3I9ODMwODtlLmZvdXJ0ZWVuY2lyY2xlPTkzMjU7ZS5mb3VydGVlbnBhcmVuPTkzNDU7ZS5mb3VydGVlbnBlcmlvZD05MzY1O2UuZm91cnRoYWk9MzY2ODtlLmZvdXJ0aHRvbmVjaGluZXNlPTcxNTtlLmZwYXJlbj05Mzc3O2UuZnJhY3Rpb249ODI2MDtlLmZyYW5jPTgzNTU7ZS5nPTEwMztlLmdhYmVuZ2FsaT0yNDU1O2UuZ2FjdXRlPTUwMTtlLmdhZGV2YT0yMzI3O2UuZ2FmYXJhYmljPTE3MTE7ZS5nYWZmaW5hbGFyYWJpYz02NDQwMztlLmdhZmluaXRpYWxhcmFiaWM9NjQ0MDQ7ZS5nYWZtZWRpYWxhcmFiaWM9NjQ0MDU7ZS5nYWd1amFyYXRpPTI3MTE7ZS5nYWd1cm11a2hpPTI1ODM7ZS5nYWhpcmFnYW5hPTEyMzY0O2UuZ2FrYXRha2FuYT0xMjQ2MDtlLmdhbW1hPTk0NztlLmdhbW1hbGF0aW5zbWFsbD02MTE7ZS5nYW1tYXN1cGVyaW9yPTczNjtlLmdhbmdpYWNvcHRpYz0xMDAzO2UuZ2JvcG9tb2ZvPTEyNTU3O2UuZ2JyZXZlPTI4NztlLmdjYXJvbj00ODc7ZS5nY2VkaWxsYT0yOTE7ZS5nY2lyY2xlPTk0MzA7ZS5nY2lyY3VtZmxleD0yODU7ZS5nY29tbWFhY2NlbnQ9MjkxO2UuZ2RvdD0yODk7ZS5nZG90YWNjZW50PTI4OTtlLmdlY3lyaWxsaWM9MTA3NTtlLmdlaGlyYWdhbmE9MTIzNzA7ZS5nZWthdGFrYW5hPTEyNDY2O2UuZ2VvbWV0cmljYWxseWVxdWFsPTg3ODU7ZS5nZXJlc2hhY2NlbnRoZWJyZXc9MTQzNjtlLmdlcmVzaGhlYnJldz0xNTIzO2UuZ2VyZXNobXVxZGFtaGVicmV3PTE0Mzc7ZS5nZXJtYW5kYmxzPTIyMztlLmdlcnNoYXlpbWFjY2VudGhlYnJldz0xNDM4O2UuZ2Vyc2hheWltaGVicmV3PTE1MjQ7ZS5nZXRhbWFyaz0xMjMwNztlLmdoYWJlbmdhbGk9MjQ1NjtlLmdoYWRhcm1lbmlhbj0xMzk0O2UuZ2hhZGV2YT0yMzI4O2UuZ2hhZ3VqYXJhdGk9MjcxMjtlLmdoYWd1cm11a2hpPTI1ODQ7ZS5naGFpbmFyYWJpYz0xNTk0O2UuZ2hhaW5maW5hbGFyYWJpYz02NTIzMDtlLmdoYWluaW5pdGlhbGFyYWJpYz02NTIzMTtlLmdoYWlubWVkaWFsYXJhYmljPTY1MjMyO2UuZ2hlbWlkZGxlaG9va2N5cmlsbGljPTExNzM7ZS5naGVzdHJva2VjeXJpbGxpYz0xMTcxO2UuZ2hldXB0dXJuY3lyaWxsaWM9MTE2OTtlLmdoaGFkZXZhPTIzOTQ7ZS5naGhhZ3VybXVraGk9MjY1MDtlLmdob29rPTYwODtlLmdoenNxdWFyZT0xMzIwMztlLmdpaGlyYWdhbmE9MTIzNjY7ZS5naWthdGFrYW5hPTEyNDYyO2UuZ2ltYXJtZW5pYW49MTM3OTtlLmdpbWVsPTE0OTA7ZS5naW1lbGRhZ2VzaD02NDMwNjtlLmdpbWVsZGFnZXNoaGVicmV3PTY0MzA2O2UuZ2ltZWxoZWJyZXc9MTQ5MDtlLmdqZWN5cmlsbGljPTExMDc7ZS5nbG90dGFsaW52ZXJ0ZWRzdHJva2U9NDQ2O2UuZ2xvdHRhbHN0b3A9NjYwO2UuZ2xvdHRhbHN0b3BpbnZlcnRlZD02NjI7ZS5nbG90dGFsc3RvcG1vZD03MDQ7ZS5nbG90dGFsc3RvcHJldmVyc2VkPTY2MTtlLmdsb3R0YWxzdG9wcmV2ZXJzZWRtb2Q9NzA1O2UuZ2xvdHRhbHN0b3ByZXZlcnNlZHN1cGVyaW9yPTc0MDtlLmdsb3R0YWxzdG9wc3Ryb2tlPTY3MztlLmdsb3R0YWxzdG9wc3Ryb2tlcmV2ZXJzZWQ9Njc0O2UuZ21hY3Jvbj03NzEzO2UuZ21vbm9zcGFjZT02NTM1MTtlLmdvaGlyYWdhbmE9MTIzNzI7ZS5nb2thdGFrYW5hPTEyNDY4O2UuZ3BhcmVuPTkzNzg7ZS5ncGFzcXVhcmU9MTMyMjg7ZS5ncmFkaWVudD04NzExO2UuZ3JhdmU9OTY7ZS5ncmF2ZWJlbG93Y21iPTc5MDtlLmdyYXZlY21iPTc2ODtlLmdyYXZlY29tYj03Njg7ZS5ncmF2ZWRldmE9MjM4NztlLmdyYXZlbG93bW9kPTcxODtlLmdyYXZlbW9ub3NwYWNlPTY1MzQ0O2UuZ3JhdmV0b25lY21iPTgzMjtlLmdyZWF0ZXI9NjI7ZS5ncmVhdGVyZXF1YWw9ODgwNTtlLmdyZWF0ZXJlcXVhbG9ybGVzcz04OTIzO2UuZ3JlYXRlcm1vbm9zcGFjZT02NTMxMDtlLmdyZWF0ZXJvcmVxdWl2YWxlbnQ9ODgxOTtlLmdyZWF0ZXJvcmxlc3M9ODgyMztlLmdyZWF0ZXJvdmVyZXF1YWw9ODgwNztlLmdyZWF0ZXJzbWFsbD02NTEyNTtlLmdzY3JpcHQ9NjA5O2UuZ3N0cm9rZT00ODU7ZS5ndWhpcmFnYW5hPTEyMzY4O2UuZ3VpbGxlbW90bGVmdD0xNzE7ZS5ndWlsbGVtb3RyaWdodD0xODc7ZS5ndWlsc2luZ2xsZWZ0PTgyNDk7ZS5ndWlsc2luZ2xyaWdodD04MjUwO2UuZ3VrYXRha2FuYT0xMjQ2NDtlLmd1cmFtdXNxdWFyZT0xMzA4MDtlLmd5c3F1YXJlPTEzMjU3O2UuaD0xMDQ7ZS5oYWFia2hhc2lhbmN5cmlsbGljPTExOTM7ZS5oYWFsdG9uZWFyYWJpYz0xNzI5O2UuaGFiZW5nYWxpPTI0ODk7ZS5oYWRlc2NlbmRlcmN5cmlsbGljPTEyMDM7ZS5oYWRldmE9MjM2MTtlLmhhZ3VqYXJhdGk9Mjc0NTtlLmhhZ3VybXVraGk9MjYxNztlLmhhaGFyYWJpYz0xNTgxO2UuaGFoZmluYWxhcmFiaWM9NjUxODY7ZS5oYWhpbml0aWFsYXJhYmljPTY1MTg3O2UuaGFoaXJhZ2FuYT0xMjM5OTtlLmhhaG1lZGlhbGFyYWJpYz02NTE4ODtlLmhhaXR1c3F1YXJlPTEzMDk4O2UuaGFrYXRha2FuYT0xMjQ5NTtlLmhha2F0YWthbmFoYWxmd2lkdGg9NjU0MTg7ZS5oYWxhbnRndXJtdWtoaT0yNjM3O2UuaGFtemFhcmFiaWM9MTU2OTtlLmhhbXphbG93YXJhYmljPTE1Njk7ZS5oYW5ndWxmaWxsZXI9MTI2NDQ7ZS5oYXJkc2lnbmN5cmlsbGljPTEwOTg7ZS5oYXJwb29ubGVmdGJhcmJ1cD04NjM2O2UuaGFycG9vbnJpZ2h0YmFyYnVwPTg2NDA7ZS5oYXNxdWFyZT0xMzI1ODtlLmhhdGFmcGF0YWg9MTQ1ODtlLmhhdGFmcGF0YWgxNj0xNDU4O2UuaGF0YWZwYXRhaDIzPTE0NTg7ZS5oYXRhZnBhdGFoMmY9MTQ1ODtlLmhhdGFmcGF0YWhoZWJyZXc9MTQ1ODtlLmhhdGFmcGF0YWhuYXJyb3doZWJyZXc9MTQ1ODtlLmhhdGFmcGF0YWhxdWFydGVyaGVicmV3PTE0NTg7ZS5oYXRhZnBhdGFod2lkZWhlYnJldz0xNDU4O2UuaGF0YWZxYW1hdHM9MTQ1OTtlLmhhdGFmcWFtYXRzMWI9MTQ1OTtlLmhhdGFmcWFtYXRzMjg9MTQ1OTtlLmhhdGFmcWFtYXRzMzQ9MTQ1OTtlLmhhdGFmcWFtYXRzaGVicmV3PTE0NTk7ZS5oYXRhZnFhbWF0c25hcnJvd2hlYnJldz0xNDU5O2UuaGF0YWZxYW1hdHNxdWFydGVyaGVicmV3PTE0NTk7ZS5oYXRhZnFhbWF0c3dpZGVoZWJyZXc9MTQ1OTtlLmhhdGFmc2Vnb2w9MTQ1NztlLmhhdGFmc2Vnb2wxNz0xNDU3O2UuaGF0YWZzZWdvbDI0PTE0NTc7ZS5oYXRhZnNlZ29sMzA9MTQ1NztlLmhhdGFmc2Vnb2xoZWJyZXc9MTQ1NztlLmhhdGFmc2Vnb2xuYXJyb3doZWJyZXc9MTQ1NztlLmhhdGFmc2Vnb2xxdWFydGVyaGVicmV3PTE0NTc7ZS5oYXRhZnNlZ29sd2lkZWhlYnJldz0xNDU3O2UuaGJhcj0yOTU7ZS5oYm9wb21vZm89MTI1NTk7ZS5oYnJldmViZWxvdz03NzIzO2UuaGNlZGlsbGE9NzcyMTtlLmhjaXJjbGU9OTQzMTtlLmhjaXJjdW1mbGV4PTI5MztlLmhkaWVyZXNpcz03NzE5O2UuaGRvdGFjY2VudD03NzE1O2UuaGRvdGJlbG93PTc3MTc7ZS5oZT0xNDkyO2UuaGVhcnQ9OTgyOTtlLmhlYXJ0c3VpdGJsYWNrPTk4Mjk7ZS5oZWFydHN1aXR3aGl0ZT05ODI1O2UuaGVkYWdlc2g9NjQzMDg7ZS5oZWRhZ2VzaGhlYnJldz02NDMwODtlLmhlaGFsdG9uZWFyYWJpYz0xNzI5O2UuaGVoYXJhYmljPTE2MDc7ZS5oZWhlYnJldz0xNDkyO2UuaGVoZmluYWxhbHRvbmVhcmFiaWM9NjQ0MjM7ZS5oZWhmaW5hbGFsdHR3b2FyYWJpYz02NTI1ODtlLmhlaGZpbmFsYXJhYmljPTY1MjU4O2UuaGVoaGFtemFhYm92ZWZpbmFsYXJhYmljPTY0NDIxO2UuaGVoaGFtemFhYm92ZWlzb2xhdGVkYXJhYmljPTY0NDIwO2UuaGVoaW5pdGlhbGFsdG9uZWFyYWJpYz02NDQyNDtlLmhlaGluaXRpYWxhcmFiaWM9NjUyNTk7ZS5oZWhpcmFnYW5hPTEyNDA4O2UuaGVobWVkaWFsYWx0b25lYXJhYmljPTY0NDI1O2UuaGVobWVkaWFsYXJhYmljPTY1MjYwO2UuaGVpc2VpZXJhc3F1YXJlPTEzMTc5O2UuaGVrYXRha2FuYT0xMjUwNDtlLmhla2F0YWthbmFoYWxmd2lkdGg9NjU0MjE7ZS5oZWt1dGFhcnVzcXVhcmU9MTMxMTA7ZS5oZW5naG9vaz02MTU7ZS5oZXJ1dHVzcXVhcmU9MTMxMTM7ZS5oZXQ9MTQ5NTtlLmhldGhlYnJldz0xNDk1O2UuaGhvb2s9NjE0O2UuaGhvb2tzdXBlcmlvcj02ODk7ZS5oaWV1aGFjaXJjbGVrb3JlYW49MTI5MjM7ZS5oaWV1aGFwYXJlbmtvcmVhbj0xMjgyNztlLmhpZXVoY2lyY2xla29yZWFuPTEyOTA5O2UuaGlldWhrb3JlYW49MTI2MjI7ZS5oaWV1aHBhcmVua29yZWFuPTEyODEzO2UuaGloaXJhZ2FuYT0xMjQwMjtlLmhpa2F0YWthbmE9MTI0OTg7ZS5oaWthdGFrYW5haGFsZndpZHRoPTY1NDE5O2UuaGlyaXE9MTQ2MDtlLmhpcmlxMTQ9MTQ2MDtlLmhpcmlxMjE9MTQ2MDtlLmhpcmlxMmQ9MTQ2MDtlLmhpcmlxaGVicmV3PTE0NjA7ZS5oaXJpcW5hcnJvd2hlYnJldz0xNDYwO2UuaGlyaXFxdWFydGVyaGVicmV3PTE0NjA7ZS5oaXJpcXdpZGVoZWJyZXc9MTQ2MDtlLmhsaW5lYmVsb3c9NzgzMDtlLmhtb25vc3BhY2U9NjUzNTI7ZS5ob2FybWVuaWFuPTEzOTI7ZS5ob2hpcHRoYWk9MzYyNztlLmhvaGlyYWdhbmE9MTI0MTE7ZS5ob2thdGFrYW5hPTEyNTA3O2UuaG9rYXRha2FuYWhhbGZ3aWR0aD02NTQyMjtlLmhvbGFtPTE0NjU7ZS5ob2xhbTE5PTE0NjU7ZS5ob2xhbTI2PTE0NjU7ZS5ob2xhbTMyPTE0NjU7ZS5ob2xhbWhlYnJldz0xNDY1O2UuaG9sYW1uYXJyb3doZWJyZXc9MTQ2NTtlLmhvbGFtcXVhcnRlcmhlYnJldz0xNDY1O2UuaG9sYW13aWRlaGVicmV3PTE0NjU7ZS5ob25va2h1a3RoYWk9MzYzMDtlLmhvb2thYm92ZWNvbWI9Nzc3O2UuaG9va2NtYj03Nzc7ZS5ob29rcGFsYXRhbGl6ZWRiZWxvd2NtYj04MDE7ZS5ob29rcmV0cm9mbGV4YmVsb3djbWI9ODAyO2UuaG9vbnNxdWFyZT0xMzEyMjtlLmhvcmljb3B0aWM9MTAwMTtlLmhvcml6b250YWxiYXI9ODIxMztlLmhvcm5jbWI9Nzk1O2UuaG90c3ByaW5ncz05ODMyO2UuaG91c2U9ODk2MjtlLmhwYXJlbj05Mzc5O2UuaHN1cGVyaW9yPTY4ODtlLmh0dXJuZWQ9NjEzO2UuaHVoaXJhZ2FuYT0xMjQwNTtlLmh1aWl0b3NxdWFyZT0xMzEwNztlLmh1a2F0YWthbmE9MTI1MDE7ZS5odWthdGFrYW5haGFsZndpZHRoPTY1NDIwO2UuaHVuZ2FydW1sYXV0PTczMztlLmh1bmdhcnVtbGF1dGNtYj03Nzk7ZS5odj00MDU7ZS5oeXBoZW49NDU7ZS5oeXBoZW5pbmZlcmlvcj02MzIwNTtlLmh5cGhlbm1vbm9zcGFjZT02NTI5MztlLmh5cGhlbnNtYWxsPTY1MTIzO2UuaHlwaGVuc3VwZXJpb3I9NjMyMDY7ZS5oeXBoZW50d289ODIwODtlLmk9MTA1O2UuaWFjdXRlPTIzNztlLmlhY3lyaWxsaWM9MTEwMztlLmliZW5nYWxpPTI0Mzk7ZS5pYm9wb21vZm89MTI1ODM7ZS5pYnJldmU9MzAxO2UuaWNhcm9uPTQ2NDtlLmljaXJjbGU9OTQzMjtlLmljaXJjdW1mbGV4PTIzODtlLmljeXJpbGxpYz0xMTEwO2UuaWRibGdyYXZlPTUyMTtlLmlkZW9ncmFwaGVhcnRoY2lyY2xlPTEyOTQzO2UuaWRlb2dyYXBoZmlyZWNpcmNsZT0xMjkzOTtlLmlkZW9ncmFwaGljYWxsaWFuY2VwYXJlbj0xMjg2MztlLmlkZW9ncmFwaGljY2FsbHBhcmVuPTEyODU4O2UuaWRlb2dyYXBoaWNjZW50cmVjaXJjbGU9MTI5NjU7ZS5pZGVvZ3JhcGhpY2Nsb3NlPTEyMjk0O2UuaWRlb2dyYXBoaWNjb21tYT0xMjI4OTtlLmlkZW9ncmFwaGljY29tbWFsZWZ0PTY1MzgwO2UuaWRlb2dyYXBoaWNjb25ncmF0dWxhdGlvbnBhcmVuPTEyODU1O2UuaWRlb2dyYXBoaWNjb3JyZWN0Y2lyY2xlPTEyOTYzO2UuaWRlb2dyYXBoaWNlYXJ0aHBhcmVuPTEyODQ3O2UuaWRlb2dyYXBoaWNlbnRlcnByaXNlcGFyZW49MTI4NjE7ZS5pZGVvZ3JhcGhpY2V4Y2VsbGVudGNpcmNsZT0xMjk1NztlLmlkZW9ncmFwaGljZmVzdGl2YWxwYXJlbj0xMjg2NDtlLmlkZW9ncmFwaGljZmluYW5jaWFsY2lyY2xlPTEyOTUwO2UuaWRlb2dyYXBoaWNmaW5hbmNpYWxwYXJlbj0xMjg1NDtlLmlkZW9ncmFwaGljZmlyZXBhcmVuPTEyODQzO2UuaWRlb2dyYXBoaWNoYXZlcGFyZW49MTI4NTA7ZS5pZGVvZ3JhcGhpY2hpZ2hjaXJjbGU9MTI5NjQ7ZS5pZGVvZ3JhcGhpY2l0ZXJhdGlvbm1hcms9MTIyOTM7ZS5pZGVvZ3JhcGhpY2xhYm9yY2lyY2xlPTEyOTUyO2UuaWRlb2dyYXBoaWNsYWJvcnBhcmVuPTEyODU2O2UuaWRlb2dyYXBoaWNsZWZ0Y2lyY2xlPTEyOTY3O2UuaWRlb2dyYXBoaWNsb3djaXJjbGU9MTI5NjY7ZS5pZGVvZ3JhcGhpY21lZGljaW5lY2lyY2xlPTEyOTY5O2UuaWRlb2dyYXBoaWNtZXRhbHBhcmVuPTEyODQ2O2UuaWRlb2dyYXBoaWNtb29ucGFyZW49MTI4NDI7ZS5pZGVvZ3JhcGhpY25hbWVwYXJlbj0xMjg1MjtlLmlkZW9ncmFwaGljcGVyaW9kPTEyMjkwO2UuaWRlb2dyYXBoaWNwcmludGNpcmNsZT0xMjk1ODtlLmlkZW9ncmFwaGljcmVhY2hwYXJlbj0xMjg2NztlLmlkZW9ncmFwaGljcmVwcmVzZW50cGFyZW49MTI4NTc7ZS5pZGVvZ3JhcGhpY3Jlc291cmNlcGFyZW49MTI4NjI7ZS5pZGVvZ3JhcGhpY3JpZ2h0Y2lyY2xlPTEyOTY4O2UuaWRlb2dyYXBoaWNzZWNyZXRjaXJjbGU9MTI5NTM7ZS5pZGVvZ3JhcGhpY3NlbGZwYXJlbj0xMjg2NjtlLmlkZW9ncmFwaGljc29jaWV0eXBhcmVuPTEyODUxO2UuaWRlb2dyYXBoaWNzcGFjZT0xMjI4ODtlLmlkZW9ncmFwaGljc3BlY2lhbHBhcmVuPTEyODUzO2UuaWRlb2dyYXBoaWNzdG9ja3BhcmVuPTEyODQ5O2UuaWRlb2dyYXBoaWNzdHVkeXBhcmVuPTEyODU5O2UuaWRlb2dyYXBoaWNzdW5wYXJlbj0xMjg0ODtlLmlkZW9ncmFwaGljc3VwZXJ2aXNlcGFyZW49MTI4NjA7ZS5pZGVvZ3JhcGhpY3dhdGVycGFyZW49MTI4NDQ7ZS5pZGVvZ3JhcGhpY3dvb2RwYXJlbj0xMjg0NTtlLmlkZW9ncmFwaGljemVybz0xMjI5NTtlLmlkZW9ncmFwaG1ldGFsY2lyY2xlPTEyOTQyO2UuaWRlb2dyYXBobW9vbmNpcmNsZT0xMjkzODtlLmlkZW9ncmFwaG5hbWVjaXJjbGU9MTI5NDg7ZS5pZGVvZ3JhcGhzdW5jaXJjbGU9MTI5NDQ7ZS5pZGVvZ3JhcGh3YXRlcmNpcmNsZT0xMjk0MDtlLmlkZW9ncmFwaHdvb2RjaXJjbGU9MTI5NDE7ZS5pZGV2YT0yMzExO2UuaWRpZXJlc2lzPTIzOTtlLmlkaWVyZXNpc2FjdXRlPTc3Mjc7ZS5pZGllcmVzaXNjeXJpbGxpYz0xMjUzO2UuaWRvdGJlbG93PTc4ODM7ZS5pZWJyZXZlY3lyaWxsaWM9MTIzOTtlLmllY3lyaWxsaWM9MTA3NztlLmlldW5nYWNpcmNsZWtvcmVhbj0xMjkxNztlLmlldW5nYXBhcmVua29yZWFuPTEyODIxO2UuaWV1bmdjaXJjbGVrb3JlYW49MTI5MDM7ZS5pZXVuZ2tvcmVhbj0xMjYxNTtlLmlldW5ncGFyZW5rb3JlYW49MTI4MDc7ZS5pZ3JhdmU9MjM2O2UuaWd1amFyYXRpPTI2OTU7ZS5pZ3VybXVraGk9MjU2NztlLmloaXJhZ2FuYT0xMjM1NjtlLmlob29rYWJvdmU9Nzg4MTtlLmlpYmVuZ2FsaT0yNDQwO2UuaWljeXJpbGxpYz0xMDgwO2UuaWlkZXZhPTIzMTI7ZS5paWd1amFyYXRpPTI2OTY7ZS5paWd1cm11a2hpPTI1Njg7ZS5paW1hdHJhZ3VybXVraGk9MjYyNDtlLmlpbnZlcnRlZGJyZXZlPTUyMztlLmlpc2hvcnRjeXJpbGxpYz0xMDgxO2UuaWl2b3dlbHNpZ25iZW5nYWxpPTI0OTY7ZS5paXZvd2Vsc2lnbmRldmE9MjM2ODtlLmlpdm93ZWxzaWduZ3VqYXJhdGk9Mjc1MjtlLmlqPTMwNztlLmlrYXRha2FuYT0xMjQ1MjtlLmlrYXRha2FuYWhhbGZ3aWR0aD02NTM5NDtlLmlrb3JlYW49MTI2NDM7ZS5pbGRlPTczMjtlLmlsdXloZWJyZXc9MTQ1MjtlLmltYWNyb249Mjk5O2UuaW1hY3JvbmN5cmlsbGljPTEyNTE7ZS5pbWFnZW9yYXBwcm94aW1hdGVseWVxdWFsPTg3ODc7ZS5pbWF0cmFndXJtdWtoaT0yNjIzO2UuaW1vbm9zcGFjZT02NTM1MztlLmluY3JlbWVudD04NzEwO2UuaW5maW5pdHk9ODczNDtlLmluaWFybWVuaWFuPTEzODc7ZS5pbnRlZ3JhbD04NzQ3O2UuaW50ZWdyYWxib3R0b209ODk5MztlLmludGVncmFsYnQ9ODk5MztlLmludGVncmFsZXg9NjM3MzM7ZS5pbnRlZ3JhbHRvcD04OTkyO2UuaW50ZWdyYWx0cD04OTkyO2UuaW50ZXJzZWN0aW9uPTg3NDU7ZS5pbnRpc3F1YXJlPTEzMDYxO2UuaW52YnVsbGV0PTk2ODg7ZS5pbnZjaXJjbGU9OTY4OTtlLmludnNtaWxlZmFjZT05Nzg3O2UuaW9jeXJpbGxpYz0xMTA1O2UuaW9nb25laz0zMDM7ZS5pb3RhPTk1MztlLmlvdGFkaWVyZXNpcz05NzA7ZS5pb3RhZGllcmVzaXN0b25vcz05MTI7ZS5pb3RhbGF0aW49NjE3O2UuaW90YXRvbm9zPTk0MztlLmlwYXJlbj05MzgwO2UuaXJpZ3VybXVraGk9MjY3NDtlLmlzbWFsbGhpcmFnYW5hPTEyMzU1O2UuaXNtYWxsa2F0YWthbmE9MTI0NTE7ZS5pc21hbGxrYXRha2FuYWhhbGZ3aWR0aD02NTM4NDtlLmlzc2hhcmJlbmdhbGk9MjU1NDtlLmlzdHJva2U9NjE2O2UuaXN1cGVyaW9yPTYzMjEzO2UuaXRlcmF0aW9uaGlyYWdhbmE9MTI0NDU7ZS5pdGVyYXRpb25rYXRha2FuYT0xMjU0MTtlLml0aWxkZT0yOTc7ZS5pdGlsZGViZWxvdz03NzI1O2UuaXVib3BvbW9mbz0xMjU4NTtlLml1Y3lyaWxsaWM9MTEwMjtlLml2b3dlbHNpZ25iZW5nYWxpPTI0OTU7ZS5pdm93ZWxzaWduZGV2YT0yMzY3O2UuaXZvd2Vsc2lnbmd1amFyYXRpPTI3NTE7ZS5pemhpdHNhY3lyaWxsaWM9MTE0MTtlLml6aGl0c2FkYmxncmF2ZWN5cmlsbGljPTExNDM7ZS5qPTEwNjtlLmphYXJtZW5pYW49MTM5MztlLmphYmVuZ2FsaT0yNDYwO2UuamFkZXZhPTIzMzI7ZS5qYWd1amFyYXRpPTI3MTY7ZS5qYWd1cm11a2hpPTI1ODg7ZS5qYm9wb21vZm89MTI1NjA7ZS5qY2Fyb249NDk2O2UuamNpcmNsZT05NDMzO2UuamNpcmN1bWZsZXg9MzA5O2UuamNyb3NzZWR0YWlsPTY2OTtlLmpkb3RsZXNzc3Ryb2tlPTYwNztlLmplY3lyaWxsaWM9MTExMjtlLmplZW1hcmFiaWM9MTU4MDtlLmplZW1maW5hbGFyYWJpYz02NTE4MjtlLmplZW1pbml0aWFsYXJhYmljPTY1MTgzO2UuamVlbW1lZGlhbGFyYWJpYz02NTE4NDtlLmplaGFyYWJpYz0xNjg4O2UuamVoZmluYWxhcmFiaWM9NjQzOTU7ZS5qaGFiZW5nYWxpPTI0NjE7ZS5qaGFkZXZhPTIzMzM7ZS5qaGFndWphcmF0aT0yNzE3O2UuamhhZ3VybXVraGk9MjU4OTtlLmpoZWhhcm1lbmlhbj0xNDAzO2UuamlzPTEyMjkyO2Uuam1vbm9zcGFjZT02NTM1NDtlLmpwYXJlbj05MzgxO2UuanN1cGVyaW9yPTY5MDtlLms9MTA3O2Uua2FiYXNoa2lyY3lyaWxsaWM9MTE4NTtlLmthYmVuZ2FsaT0yNDUzO2Uua2FjdXRlPTc3Mjk7ZS5rYWN5cmlsbGljPTEwODI7ZS5rYWRlc2NlbmRlcmN5cmlsbGljPTExNzk7ZS5rYWRldmE9MjMyNTtlLmthZj0xNDk5O2Uua2FmYXJhYmljPTE2MDM7ZS5rYWZkYWdlc2g9NjQzMTU7ZS5rYWZkYWdlc2hoZWJyZXc9NjQzMTU7ZS5rYWZmaW5hbGFyYWJpYz02NTI0MjtlLmthZmhlYnJldz0xNDk5O2Uua2FmaW5pdGlhbGFyYWJpYz02NTI0MztlLmthZm1lZGlhbGFyYWJpYz02NTI0NDtlLmthZnJhZmVoZWJyZXc9NjQzMzM7ZS5rYWd1amFyYXRpPTI3MDk7ZS5rYWd1cm11a2hpPTI1ODE7ZS5rYWhpcmFnYW5hPTEyMzYzO2Uua2Fob29rY3lyaWxsaWM9MTIyMDtlLmtha2F0YWthbmE9MTI0NTk7ZS5rYWthdGFrYW5haGFsZndpZHRoPTY1Mzk4O2Uua2FwcGE9OTU0O2Uua2FwcGFzeW1ib2xncmVlaz0xMDA4O2Uua2FweWVvdW5taWV1bWtvcmVhbj0xMjY1NztlLmthcHllb3VucGhpZXVwaGtvcmVhbj0xMjY3NjtlLmthcHllb3VucGlldXBrb3JlYW49MTI2NjQ7ZS5rYXB5ZW91bnNzYW5ncGlldXBrb3JlYW49MTI2NjU7ZS5rYXJvcmlpc3F1YXJlPTEzMDY5O2Uua2FzaGlkYWF1dG9hcmFiaWM9MTYwMDtlLmthc2hpZGFhdXRvbm9zaWRlYmVhcmluZ2FyYWJpYz0xNjAwO2Uua2FzbWFsbGthdGFrYW5hPTEyNTMzO2Uua2FzcXVhcmU9MTMxODg7ZS5rYXNyYWFyYWJpYz0xNjE2O2Uua2FzcmF0YW5hcmFiaWM9MTYxMztlLmthc3Ryb2tlY3lyaWxsaWM9MTE4MztlLmthdGFoaXJhcHJvbG9uZ21hcmtoYWxmd2lkdGg9NjUzOTI7ZS5rYXZlcnRpY2Fsc3Ryb2tlY3lyaWxsaWM9MTE4MTtlLmtib3BvbW9mbz0xMjU1ODtlLmtjYWxzcXVhcmU9MTMxOTM7ZS5rY2Fyb249NDg5O2Uua2NlZGlsbGE9MzExO2Uua2NpcmNsZT05NDM0O2Uua2NvbW1hYWNjZW50PTMxMTtlLmtkb3RiZWxvdz03NzMxO2Uua2VoYXJtZW5pYW49MTQxMjtlLmtlaGlyYWdhbmE9MTIzNjk7ZS5rZWthdGFrYW5hPTEyNDY1O2Uua2VrYXRha2FuYWhhbGZ3aWR0aD02NTQwMTtlLmtlbmFybWVuaWFuPTEzOTE7ZS5rZXNtYWxsa2F0YWthbmE9MTI1MzQ7ZS5rZ3JlZW5sYW5kaWM9MzEyO2Uua2hhYmVuZ2FsaT0yNDU0O2Uua2hhY3lyaWxsaWM9MTA5MztlLmtoYWRldmE9MjMyNjtlLmtoYWd1amFyYXRpPTI3MTA7ZS5raGFndXJtdWtoaT0yNTgyO2Uua2hhaGFyYWJpYz0xNTgyO2Uua2hhaGZpbmFsYXJhYmljPTY1MTkwO2Uua2hhaGluaXRpYWxhcmFiaWM9NjUxOTE7ZS5raGFobWVkaWFsYXJhYmljPTY1MTkyO2Uua2hlaWNvcHRpYz05OTk7ZS5raGhhZGV2YT0yMzkzO2Uua2hoYWd1cm11a2hpPTI2NDk7ZS5raGlldWtoYWNpcmNsZWtvcmVhbj0xMjkyMDtlLmtoaWV1a2hhcGFyZW5rb3JlYW49MTI4MjQ7ZS5raGlldWtoY2lyY2xla29yZWFuPTEyOTA2O2Uua2hpZXVraGtvcmVhbj0xMjYxOTtlLmtoaWV1a2hwYXJlbmtvcmVhbj0xMjgxMDtlLmtob2toYWl0aGFpPTM1ODY7ZS5raG9raG9udGhhaT0zNTg5O2Uua2hva2h1YXR0aGFpPTM1ODc7ZS5raG9raHdhaXRoYWk9MzU4ODtlLmtob211dHRoYWk9MzY3NTtlLmtob29rPTQwOTtlLmtob3Jha2hhbmd0aGFpPTM1OTA7ZS5raHpzcXVhcmU9MTMyMDE7ZS5raWhpcmFnYW5hPTEyMzY1O2Uua2lrYXRha2FuYT0xMjQ2MTtlLmtpa2F0YWthbmFoYWxmd2lkdGg9NjUzOTk7ZS5raXJvZ3VyYW11c3F1YXJlPTEzMDc3O2Uua2lyb21lZXRvcnVzcXVhcmU9MTMwNzg7ZS5raXJvc3F1YXJlPTEzMDc2O2Uua2l5ZW9rYWNpcmNsZWtvcmVhbj0xMjkxMDtlLmtpeWVva2FwYXJlbmtvcmVhbj0xMjgxNDtlLmtpeWVva2NpcmNsZWtvcmVhbj0xMjg5NjtlLmtpeWVva2tvcmVhbj0xMjU5MztlLmtpeWVva3BhcmVua29yZWFuPTEyODAwO2Uua2l5ZW9rc2lvc2tvcmVhbj0xMjU5NTtlLmtqZWN5cmlsbGljPTExMTY7ZS5rbGluZWJlbG93PTc3MzM7ZS5rbHNxdWFyZT0xMzIwODtlLmttY3ViZWRzcXVhcmU9MTMyMjI7ZS5rbW9ub3NwYWNlPTY1MzU1O2Uua21zcXVhcmVkc3F1YXJlPTEzMjE4O2Uua29oaXJhZ2FuYT0xMjM3MTtlLmtvaG1zcXVhcmU9MTMyNDg7ZS5rb2thaXRoYWk9MzU4NTtlLmtva2F0YWthbmE9MTI0Njc7ZS5rb2thdGFrYW5haGFsZndpZHRoPTY1NDAyO2Uua29vcG9zcXVhcmU9MTMwODY7ZS5rb3BwYWN5cmlsbGljPTExNTM7ZS5rb3JlYW5zdGFuZGFyZHN5bWJvbD0xMjkyNztlLmtvcm9uaXNjbWI9ODM1O2Uua3BhcmVuPTkzODI7ZS5rcGFzcXVhcmU9MTMyMjY7ZS5rc2ljeXJpbGxpYz0xMTM1O2Uua3RzcXVhcmU9MTMyNjM7ZS5rdHVybmVkPTY3MDtlLmt1aGlyYWdhbmE9MTIzNjc7ZS5rdWthdGFrYW5hPTEyNDYzO2Uua3VrYXRha2FuYWhhbGZ3aWR0aD02NTQwMDtlLmt2c3F1YXJlPTEzMjQwO2Uua3dzcXVhcmU9MTMyNDY7ZS5sPTEwODtlLmxhYmVuZ2FsaT0yNDgyO2UubGFjdXRlPTMxNDtlLmxhZGV2YT0yMzU0O2UubGFndWphcmF0aT0yNzM4O2UubGFndXJtdWtoaT0yNjEwO2UubGFra2hhbmd5YW90aGFpPTM2NTM7ZS5sYW1hbGVmZmluYWxhcmFiaWM9NjUyNzY7ZS5sYW1hbGVmaGFtemFhYm92ZWZpbmFsYXJhYmljPTY1MjcyO2UubGFtYWxlZmhhbXphYWJvdmVpc29sYXRlZGFyYWJpYz02NTI3MTtlLmxhbWFsZWZoYW16YWJlbG93ZmluYWxhcmFiaWM9NjUyNzQ7ZS5sYW1hbGVmaGFtemFiZWxvd2lzb2xhdGVkYXJhYmljPTY1MjczO2UubGFtYWxlZmlzb2xhdGVkYXJhYmljPTY1Mjc1O2UubGFtYWxlZm1hZGRhYWJvdmVmaW5hbGFyYWJpYz02NTI3MDtlLmxhbWFsZWZtYWRkYWFib3ZlaXNvbGF0ZWRhcmFiaWM9NjUyNjk7ZS5sYW1hcmFiaWM9MTYwNDtlLmxhbWJkYT05NTU7ZS5sYW1iZGFzdHJva2U9NDExO2UubGFtZWQ9MTUwMDtlLmxhbWVkZGFnZXNoPTY0MzE2O2UubGFtZWRkYWdlc2hoZWJyZXc9NjQzMTY7ZS5sYW1lZGhlYnJldz0xNTAwO2UubGFtZmluYWxhcmFiaWM9NjUyNDY7ZS5sYW1oYWhpbml0aWFsYXJhYmljPTY0NzE0O2UubGFtaW5pdGlhbGFyYWJpYz02NTI0NztlLmxhbWplZW1pbml0aWFsYXJhYmljPTY0NzEzO2UubGFta2hhaGluaXRpYWxhcmFiaWM9NjQ3MTU7ZS5sYW1sYW1oZWhpc29sYXRlZGFyYWJpYz02NTAxMDtlLmxhbW1lZGlhbGFyYWJpYz02NTI0ODtlLmxhbW1lZW1oYWhpbml0aWFsYXJhYmljPTY0OTA0O2UubGFtbWVlbWluaXRpYWxhcmFiaWM9NjQ3MTY7ZS5sYXJnZWNpcmNsZT05NzExO2UubGJhcj00MTA7ZS5sYmVsdD02MjA7ZS5sYm9wb21vZm89MTI1NTY7ZS5sY2Fyb249MzE4O2UubGNlZGlsbGE9MzE2O2UubGNpcmNsZT05NDM1O2UubGNpcmN1bWZsZXhiZWxvdz03NzQxO2UubGNvbW1hYWNjZW50PTMxNjtlLmxkb3Q9MzIwO2UubGRvdGFjY2VudD0zMjA7ZS5sZG90YmVsb3c9NzczNTtlLmxkb3RiZWxvd21hY3Jvbj03NzM3O2UubGVmdGFuZ2xlYWJvdmVjbWI9Nzk0O2UubGVmdHRhY2tiZWxvd2NtYj03OTI7ZS5sZXNzPTYwO2UubGVzc2VxdWFsPTg4MDQ7ZS5sZXNzZXF1YWxvcmdyZWF0ZXI9ODkyMjtlLmxlc3Ntb25vc3BhY2U9NjUzMDg7ZS5sZXNzb3JlcXVpdmFsZW50PTg4MTg7ZS5sZXNzb3JncmVhdGVyPTg4MjI7ZS5sZXNzb3ZlcmVxdWFsPTg4MDY7ZS5sZXNzc21hbGw9NjUxMjQ7ZS5sZXpoPTYyMjtlLmxmYmxvY2s9OTYxMjtlLmxob29rcmV0cm9mbGV4PTYyMTtlLmxpcmE9ODM1NjtlLmxpd25hcm1lbmlhbj0xMzg4O2UubGo9NDU3O2UubGplY3lyaWxsaWM9MTExMztlLmxsPTYzMTY4O2UubGxhZGV2YT0yMzU1O2UubGxhZ3VqYXJhdGk9MjczOTtlLmxsaW5lYmVsb3c9NzczOTtlLmxsbGFkZXZhPTIzNTY7ZS5sbHZvY2FsaWNiZW5nYWxpPTI1Mjk7ZS5sbHZvY2FsaWNkZXZhPTI0MDE7ZS5sbHZvY2FsaWN2b3dlbHNpZ25iZW5nYWxpPTI1MzE7ZS5sbHZvY2FsaWN2b3dlbHNpZ25kZXZhPTI0MDM7ZS5sbWlkZGxldGlsZGU9NjE5O2UubG1vbm9zcGFjZT02NTM1NjtlLmxtc3F1YXJlPTEzMjY0O2UubG9jaHVsYXRoYWk9MzYyODtlLmxvZ2ljYWxhbmQ9ODc0MztlLmxvZ2ljYWxub3Q9MTcyO2UubG9naWNhbG5vdHJldmVyc2VkPTg5NzY7ZS5sb2dpY2Fsb3I9ODc0NDtlLmxvbGluZ3RoYWk9MzYyMTtlLmxvbmdzPTM4MztlLmxvd2xpbmVjZW50ZXJsaW5lPTY1MTAyO2UubG93bGluZWNtYj04MTg7ZS5sb3dsaW5lZGFzaGVkPTY1MTAxO2UubG96ZW5nZT05Njc0O2UubHBhcmVuPTkzODM7ZS5sc2xhc2g9MzIyO2UubHNxdWFyZT04NDY3O2UubHN1cGVyaW9yPTYzMjE0O2UubHRzaGFkZT05NjE3O2UubHV0aGFpPTM2MjI7ZS5sdm9jYWxpY2JlbmdhbGk9MjQ0NDtlLmx2b2NhbGljZGV2YT0yMzE2O2UubHZvY2FsaWN2b3dlbHNpZ25iZW5nYWxpPTI1MzA7ZS5sdm9jYWxpY3Zvd2Vsc2lnbmRldmE9MjQwMjtlLmx4c3F1YXJlPTEzMjY3O2UubT0xMDk7ZS5tYWJlbmdhbGk9MjQ3ODtlLm1hY3Jvbj0xNzU7ZS5tYWNyb25iZWxvd2NtYj04MTc7ZS5tYWNyb25jbWI9NzcyO2UubWFjcm9ubG93bW9kPTcxNztlLm1hY3Jvbm1vbm9zcGFjZT02NTUwNztlLm1hY3V0ZT03NzQzO2UubWFkZXZhPTIzNTA7ZS5tYWd1amFyYXRpPTI3MzQ7ZS5tYWd1cm11a2hpPTI2MDY7ZS5tYWhhcGFraGhlYnJldz0xNDQ0O2UubWFoYXBha2hsZWZ0aGVicmV3PTE0NDQ7ZS5tYWhpcmFnYW5hPTEyNDE0O2UubWFpY2hhdHRhd2Fsb3dsZWZ0dGhhaT02MzYzNztlLm1haWNoYXR0YXdhbG93cmlnaHR0aGFpPTYzNjM2O2UubWFpY2hhdHRhd2F0aGFpPTM2NTk7ZS5tYWljaGF0dGF3YXVwcGVybGVmdHRoYWk9NjM2MzU7ZS5tYWlla2xvd2xlZnR0aGFpPTYzNjI4O2UubWFpZWtsb3dyaWdodHRoYWk9NjM2Mjc7ZS5tYWlla3RoYWk9MzY1NjtlLm1haWVrdXBwZXJsZWZ0dGhhaT02MzYyNjtlLm1haWhhbmFrYXRsZWZ0dGhhaT02MzYyMDtlLm1haWhhbmFrYXR0aGFpPTM2MzM7ZS5tYWl0YWlraHVsZWZ0dGhhaT02MzYyNTtlLm1haXRhaWtodXRoYWk9MzY1NTtlLm1haXRob2xvd2xlZnR0aGFpPTYzNjMxO2UubWFpdGhvbG93cmlnaHR0aGFpPTYzNjMwO2UubWFpdGhvdGhhaT0zNjU3O2UubWFpdGhvdXBwZXJsZWZ0dGhhaT02MzYyOTtlLm1haXRyaWxvd2xlZnR0aGFpPTYzNjM0O2UubWFpdHJpbG93cmlnaHR0aGFpPTYzNjMzO2UubWFpdHJpdGhhaT0zNjU4O2UubWFpdHJpdXBwZXJsZWZ0dGhhaT02MzYzMjtlLm1haXlhbW9rdGhhaT0zNjU0O2UubWFrYXRha2FuYT0xMjUxMDtlLm1ha2F0YWthbmFoYWxmd2lkdGg9NjU0MjM7ZS5tYWxlPTk3OTQ7ZS5tYW5zeW9uc3F1YXJlPTEzMTI3O2UubWFxYWZoZWJyZXc9MTQ3MDtlLm1hcnM9OTc5NDtlLm1hc29yYWNpcmNsZWhlYnJldz0xNDU1O2UubWFzcXVhcmU9MTMxODc7ZS5tYm9wb21vZm89MTI1NTE7ZS5tYnNxdWFyZT0xMzI2ODtlLm1jaXJjbGU9OTQzNjtlLm1jdWJlZHNxdWFyZT0xMzIyMTtlLm1kb3RhY2NlbnQ9Nzc0NTtlLm1kb3RiZWxvdz03NzQ3O2UubWVlbWFyYWJpYz0xNjA1O2UubWVlbWZpbmFsYXJhYmljPTY1MjUwO2UubWVlbWluaXRpYWxhcmFiaWM9NjUyNTE7ZS5tZWVtbWVkaWFsYXJhYmljPTY1MjUyO2UubWVlbW1lZW1pbml0aWFsYXJhYmljPTY0NzIxO2UubWVlbW1lZW1pc29sYXRlZGFyYWJpYz02NDU4NDtlLm1lZXRvcnVzcXVhcmU9MTMxMzM7ZS5tZWhpcmFnYW5hPTEyNDE3O2UubWVpemllcmFzcXVhcmU9MTMxODI7ZS5tZWthdGFrYW5hPTEyNTEzO2UubWVrYXRha2FuYWhhbGZ3aWR0aD02NTQyNjtlLm1lbT0xNTAyO2UubWVtZGFnZXNoPTY0MzE4O2UubWVtZGFnZXNoaGVicmV3PTY0MzE4O2UubWVtaGVicmV3PTE1MDI7ZS5tZW5hcm1lbmlhbj0xMzk2O2UubWVya2hhaGVicmV3PTE0NDU7ZS5tZXJraGFrZWZ1bGFoZWJyZXc9MTQ0NjtlLm1lcmtoYWtlZnVsYWxlZnRoZWJyZXc9MTQ0NjtlLm1lcmtoYWxlZnRoZWJyZXc9MTQ0NTtlLm1ob29rPTYyNTtlLm1oenNxdWFyZT0xMzIwMjtlLm1pZGRsZWRvdGthdGFrYW5haGFsZndpZHRoPTY1MzgxO2UubWlkZG90PTE4MztlLm1pZXVtYWNpcmNsZWtvcmVhbj0xMjkxNDtlLm1pZXVtYXBhcmVua29yZWFuPTEyODE4O2UubWlldW1jaXJjbGVrb3JlYW49MTI5MDA7ZS5taWV1bWtvcmVhbj0xMjYwOTtlLm1pZXVtcGFuc2lvc2tvcmVhbj0xMjY1NjtlLm1pZXVtcGFyZW5rb3JlYW49MTI4MDQ7ZS5taWV1bXBpZXVwa29yZWFuPTEyNjU0O2UubWlldW1zaW9za29yZWFuPTEyNjU1O2UubWloaXJhZ2FuYT0xMjQxNTtlLm1pa2F0YWthbmE9MTI1MTE7ZS5taWthdGFrYW5haGFsZndpZHRoPTY1NDI0O2UubWludXM9ODcyMjtlLm1pbnVzYmVsb3djbWI9ODAwO2UubWludXNjaXJjbGU9ODg1NDtlLm1pbnVzbW9kPTcyNztlLm1pbnVzcGx1cz04NzIzO2UubWludXRlPTgyNDI7ZS5taXJpYmFhcnVzcXVhcmU9MTMxMzA7ZS5taXJpc3F1YXJlPTEzMTI5O2UubWxvbmdsZWd0dXJuZWQ9NjI0O2UubWxzcXVhcmU9MTMyMDY7ZS5tbWN1YmVkc3F1YXJlPTEzMjE5O2UubW1vbm9zcGFjZT02NTM1NztlLm1tc3F1YXJlZHNxdWFyZT0xMzIxNTtlLm1vaGlyYWdhbmE9MTI0MTg7ZS5tb2htc3F1YXJlPTEzMjQ5O2UubW9rYXRha2FuYT0xMjUxNDtlLm1va2F0YWthbmFoYWxmd2lkdGg9NjU0Mjc7ZS5tb2xzcXVhcmU9MTMyNzA7ZS5tb21hdGhhaT0zNjE3O2UubW92ZXJzc3F1YXJlPTEzMjIzO2UubW92ZXJzc3F1YXJlZHNxdWFyZT0xMzIyNDtlLm1wYXJlbj05Mzg0O2UubXBhc3F1YXJlPTEzMjI3O2UubXNzcXVhcmU9MTMyMzU7ZS5tc3VwZXJpb3I9NjMyMTU7ZS5tdHVybmVkPTYyMztlLm11PTE4MTtlLm11MT0xODE7ZS5tdWFzcXVhcmU9MTMxODY7ZS5tdWNoZ3JlYXRlcj04ODExO2UubXVjaGxlc3M9ODgxMDtlLm11ZnNxdWFyZT0xMzE5NjtlLm11Z3JlZWs9OTU2O2UubXVnc3F1YXJlPTEzMTk3O2UubXVoaXJhZ2FuYT0xMjQxNjtlLm11a2F0YWthbmE9MTI1MTI7ZS5tdWthdGFrYW5haGFsZndpZHRoPTY1NDI1O2UubXVsc3F1YXJlPTEzMjA1O2UubXVsdGlwbHk9MjE1O2UubXVtc3F1YXJlPTEzMjExO2UubXVuYWhoZWJyZXc9MTQ0MztlLm11bmFobGVmdGhlYnJldz0xNDQzO2UubXVzaWNhbG5vdGU9OTgzNDtlLm11c2ljYWxub3RlZGJsPTk4MzU7ZS5tdXNpY2ZsYXRzaWduPTk4Mzc7ZS5tdXNpY3NoYXJwc2lnbj05ODM5O2UubXVzc3F1YXJlPTEzMjM0O2UubXV2c3F1YXJlPTEzMjM4O2UubXV3c3F1YXJlPTEzMjQ0O2UubXZtZWdhc3F1YXJlPTEzMjQxO2UubXZzcXVhcmU9MTMyMzk7ZS5td21lZ2FzcXVhcmU9MTMyNDc7ZS5td3NxdWFyZT0xMzI0NTtlLm49MTEwO2UubmFiZW5nYWxpPTI0NzI7ZS5uYWJsYT04NzExO2UubmFjdXRlPTMyNDtlLm5hZGV2YT0yMzQ0O2UubmFndWphcmF0aT0yNzI4O2UubmFndXJtdWtoaT0yNjAwO2UubmFoaXJhZ2FuYT0xMjM5NDtlLm5ha2F0YWthbmE9MTI0OTA7ZS5uYWthdGFrYW5haGFsZndpZHRoPTY1NDEzO2UubmFwb3N0cm9waGU9MzI5O2UubmFzcXVhcmU9MTMxODU7ZS5uYm9wb21vZm89MTI1NTU7ZS5uYnNwYWNlPTE2MDtlLm5jYXJvbj0zMjg7ZS5uY2VkaWxsYT0zMjY7ZS5uY2lyY2xlPTk0Mzc7ZS5uY2lyY3VtZmxleGJlbG93PTc3NTU7ZS5uY29tbWFhY2NlbnQ9MzI2O2UubmRvdGFjY2VudD03NzQ5O2UubmRvdGJlbG93PTc3NTE7ZS5uZWhpcmFnYW5hPTEyMzk3O2UubmVrYXRha2FuYT0xMjQ5MztlLm5la2F0YWthbmFoYWxmd2lkdGg9NjU0MTY7ZS5uZXdzaGVxZWxzaWduPTgzNjI7ZS5uZnNxdWFyZT0xMzE5NTtlLm5nYWJlbmdhbGk9MjQ1NztlLm5nYWRldmE9MjMyOTtlLm5nYWd1amFyYXRpPTI3MTM7ZS5uZ2FndXJtdWtoaT0yNTg1O2Uubmdvbmd1dGhhaT0zNTkxO2UubmhpcmFnYW5hPTEyNDM1O2Uubmhvb2tsZWZ0PTYyNjtlLm5ob29rcmV0cm9mbGV4PTYyNztlLm5pZXVuYWNpcmNsZWtvcmVhbj0xMjkxMTtlLm5pZXVuYXBhcmVua29yZWFuPTEyODE1O2UubmlldW5jaWV1Y2tvcmVhbj0xMjU5NztlLm5pZXVuY2lyY2xla29yZWFuPTEyODk3O2UubmlldW5oaWV1aGtvcmVhbj0xMjU5ODtlLm5pZXVua29yZWFuPTEyNTk2O2UubmlldW5wYW5zaW9za29yZWFuPTEyNjQ4O2UubmlldW5wYXJlbmtvcmVhbj0xMjgwMTtlLm5pZXVuc2lvc2tvcmVhbj0xMjY0NztlLm5pZXVudGlrZXV0a29yZWFuPTEyNjQ2O2UubmloaXJhZ2FuYT0xMjM5NTtlLm5pa2F0YWthbmE9MTI0OTE7ZS5uaWthdGFrYW5haGFsZndpZHRoPTY1NDE0O2UubmlraGFoaXRsZWZ0dGhhaT02MzY0MTtlLm5pa2hhaGl0dGhhaT0zNjYxO2UubmluZT01NztlLm5pbmVhcmFiaWM9MTY0MTtlLm5pbmViZW5nYWxpPTI1NDM7ZS5uaW5lY2lyY2xlPTkzMjA7ZS5uaW5lY2lyY2xlaW52ZXJzZXNhbnNzZXJpZj0xMDEzMDtlLm5pbmVkZXZhPTI0MTU7ZS5uaW5lZ3VqYXJhdGk9Mjc5OTtlLm5pbmVndXJtdWtoaT0yNjcxO2UubmluZWhhY2thcmFiaWM9MTY0MTtlLm5pbmVoYW5nemhvdT0xMjMyOTtlLm5pbmVpZGVvZ3JhcGhpY3BhcmVuPTEyODQwO2UubmluZWluZmVyaW9yPTgzMjk7ZS5uaW5lbW9ub3NwYWNlPTY1MzA1O2UubmluZW9sZHN0eWxlPTYzMjg5O2UubmluZXBhcmVuPTkzNDA7ZS5uaW5lcGVyaW9kPTkzNjA7ZS5uaW5lcGVyc2lhbj0xNzg1O2UubmluZXJvbWFuPTg1Njg7ZS5uaW5lc3VwZXJpb3I9ODMxMztlLm5pbmV0ZWVuY2lyY2xlPTkzMzA7ZS5uaW5ldGVlbnBhcmVuPTkzNTA7ZS5uaW5ldGVlbnBlcmlvZD05MzcwO2UubmluZXRoYWk9MzY3MztlLm5qPTQ2MDtlLm5qZWN5cmlsbGljPTExMTQ7ZS5ua2F0YWthbmE9MTI1MzE7ZS5ua2F0YWthbmFoYWxmd2lkdGg9NjU0Mzc7ZS5ubGVncmlnaHRsb25nPTQxNDtlLm5saW5lYmVsb3c9Nzc1MztlLm5tb25vc3BhY2U9NjUzNTg7ZS5ubXNxdWFyZT0xMzIxMDtlLm5uYWJlbmdhbGk9MjQ2NztlLm5uYWRldmE9MjMzOTtlLm5uYWd1amFyYXRpPTI3MjM7ZS5ubmFndXJtdWtoaT0yNTk1O2Uubm5uYWRldmE9MjM0NTtlLm5vaGlyYWdhbmE9MTIzOTg7ZS5ub2thdGFrYW5hPTEyNDk0O2Uubm9rYXRha2FuYWhhbGZ3aWR0aD02NTQxNztlLm5vbmJyZWFraW5nc3BhY2U9MTYwO2Uubm9uZW50aGFpPTM2MDM7ZS5ub251dGhhaT0zNjA5O2Uubm9vbmFyYWJpYz0xNjA2O2Uubm9vbmZpbmFsYXJhYmljPTY1MjU0O2Uubm9vbmdodW5uYWFyYWJpYz0xNzIyO2Uubm9vbmdodW5uYWZpbmFsYXJhYmljPTY0NDE1O2Uubm9vbmluaXRpYWxhcmFiaWM9NjUyNTU7ZS5ub29uamVlbWluaXRpYWxhcmFiaWM9NjQ3MjI7ZS5ub29uamVlbWlzb2xhdGVkYXJhYmljPTY0NTg3O2Uubm9vbm1lZGlhbGFyYWJpYz02NTI1NjtlLm5vb25tZWVtaW5pdGlhbGFyYWJpYz02NDcyNTtlLm5vb25tZWVtaXNvbGF0ZWRhcmFiaWM9NjQ1OTA7ZS5ub29ubm9vbmZpbmFsYXJhYmljPTY0NjUzO2Uubm90Y29udGFpbnM9ODcxNjtlLm5vdGVsZW1lbnQ9ODcxMztlLm5vdGVsZW1lbnRvZj04NzEzO2Uubm90ZXF1YWw9ODgwMDtlLm5vdGdyZWF0ZXI9ODgxNTtlLm5vdGdyZWF0ZXJub3JlcXVhbD04ODE3O2Uubm90Z3JlYXRlcm5vcmxlc3M9ODgyNTtlLm5vdGlkZW50aWNhbD04ODAyO2Uubm90bGVzcz04ODE0O2Uubm90bGVzc25vcmVxdWFsPTg4MTY7ZS5ub3RwYXJhbGxlbD04NzQyO2Uubm90cHJlY2VkZXM9ODgzMjtlLm5vdHN1YnNldD04ODM2O2Uubm90c3VjY2VlZHM9ODgzMztlLm5vdHN1cGVyc2V0PTg4Mzc7ZS5ub3dhcm1lbmlhbj0xMzk4O2UubnBhcmVuPTkzODU7ZS5uc3NxdWFyZT0xMzIzMztlLm5zdXBlcmlvcj04MzE5O2UubnRpbGRlPTI0MTtlLm51PTk1NztlLm51aGlyYWdhbmE9MTIzOTY7ZS5udWthdGFrYW5hPTEyNDkyO2UubnVrYXRha2FuYWhhbGZ3aWR0aD02NTQxNTtlLm51a3RhYmVuZ2FsaT0yNDkyO2UubnVrdGFkZXZhPTIzNjQ7ZS5udWt0YWd1amFyYXRpPTI3NDg7ZS5udWt0YWd1cm11a2hpPTI2MjA7ZS5udW1iZXJzaWduPTM1O2UubnVtYmVyc2lnbm1vbm9zcGFjZT02NTI4MztlLm51bWJlcnNpZ25zbWFsbD02NTExOTtlLm51bWVyYWxzaWduZ3JlZWs9ODg0O2UubnVtZXJhbHNpZ25sb3dlcmdyZWVrPTg4NTtlLm51bWVybz04NDcwO2UubnVuPTE1MDQ7ZS5udW5kYWdlc2g9NjQzMjA7ZS5udW5kYWdlc2hoZWJyZXc9NjQzMjA7ZS5udW5oZWJyZXc9MTUwNDtlLm52c3F1YXJlPTEzMjM3O2UubndzcXVhcmU9MTMyNDM7ZS5ueWFiZW5nYWxpPTI0NjI7ZS5ueWFkZXZhPTIzMzQ7ZS5ueWFndWphcmF0aT0yNzE4O2UubnlhZ3VybXVraGk9MjU5MDtlLm89MTExO2Uub2FjdXRlPTI0MztlLm9hbmd0aGFpPTM2Mjk7ZS5vYmFycmVkPTYyOTtlLm9iYXJyZWRjeXJpbGxpYz0xMjU3O2Uub2JhcnJlZGRpZXJlc2lzY3lyaWxsaWM9MTI1OTtlLm9iZW5nYWxpPTI0NTE7ZS5vYm9wb21vZm89MTI1NzE7ZS5vYnJldmU9MzM1O2Uub2NhbmRyYWRldmE9MjMyMTtlLm9jYW5kcmFndWphcmF0aT0yNzA1O2Uub2NhbmRyYXZvd2Vsc2lnbmRldmE9MjM3NztlLm9jYW5kcmF2b3dlbHNpZ25ndWphcmF0aT0yNzYxO2Uub2Nhcm9uPTQ2NjtlLm9jaXJjbGU9OTQzODtlLm9jaXJjdW1mbGV4PTI0NDtlLm9jaXJjdW1mbGV4YWN1dGU9Nzg4OTtlLm9jaXJjdW1mbGV4ZG90YmVsb3c9Nzg5NztlLm9jaXJjdW1mbGV4Z3JhdmU9Nzg5MTtlLm9jaXJjdW1mbGV4aG9va2Fib3ZlPTc4OTM7ZS5vY2lyY3VtZmxleHRpbGRlPTc4OTU7ZS5vY3lyaWxsaWM9MTA4NjtlLm9kYmxhY3V0ZT0zMzc7ZS5vZGJsZ3JhdmU9NTI1O2Uub2RldmE9MjMyMztlLm9kaWVyZXNpcz0yNDY7ZS5vZGllcmVzaXNjeXJpbGxpYz0xMjU1O2Uub2RvdGJlbG93PTc4ODU7ZS5vZT0zMzk7ZS5vZWtvcmVhbj0xMjYzNDtlLm9nb25laz03MzE7ZS5vZ29uZWtjbWI9ODA4O2Uub2dyYXZlPTI0MjtlLm9ndWphcmF0aT0yNzA3O2Uub2hhcm1lbmlhbj0xNDEzO2Uub2hpcmFnYW5hPTEyMzYyO2Uub2hvb2thYm92ZT03ODg3O2Uub2hvcm49NDE3O2Uub2hvcm5hY3V0ZT03ODk5O2Uub2hvcm5kb3RiZWxvdz03OTA3O2Uub2hvcm5ncmF2ZT03OTAxO2Uub2hvcm5ob29rYWJvdmU9NzkwMztlLm9ob3JudGlsZGU9NzkwNTtlLm9odW5nYXJ1bWxhdXQ9MzM3O2Uub2k9NDE5O2Uub2ludmVydGVkYnJldmU9NTI3O2Uub2thdGFrYW5hPTEyNDU4O2Uub2thdGFrYW5haGFsZndpZHRoPTY1Mzk3O2Uub2tvcmVhbj0xMjYzMTtlLm9sZWhlYnJldz0xNDUxO2Uub21hY3Jvbj0zMzM7ZS5vbWFjcm9uYWN1dGU9Nzc2MztlLm9tYWNyb25ncmF2ZT03NzYxO2Uub21kZXZhPTIzODQ7ZS5vbWVnYT05Njk7ZS5vbWVnYTE9OTgyO2Uub21lZ2FjeXJpbGxpYz0xMTIxO2Uub21lZ2FsYXRpbmNsb3NlZD02MzE7ZS5vbWVnYXJvdW5kY3lyaWxsaWM9MTE0NztlLm9tZWdhdGl0bG9jeXJpbGxpYz0xMTQ5O2Uub21lZ2F0b25vcz05NzQ7ZS5vbWd1amFyYXRpPTI3Njg7ZS5vbWljcm9uPTk1OTtlLm9taWNyb250b25vcz05NzI7ZS5vbW9ub3NwYWNlPTY1MzU5O2Uub25lPTQ5O2Uub25lYXJhYmljPTE2MzM7ZS5vbmViZW5nYWxpPTI1MzU7ZS5vbmVjaXJjbGU9OTMxMjtlLm9uZWNpcmNsZWludmVyc2VzYW5zc2VyaWY9MTAxMjI7ZS5vbmVkZXZhPTI0MDc7ZS5vbmVkb3RlbmxlYWRlcj04MjI4O2Uub25lZWlnaHRoPTg1Mzk7ZS5vbmVmaXR0ZWQ9NjMxOTY7ZS5vbmVndWphcmF0aT0yNzkxO2Uub25lZ3VybXVraGk9MjY2MztlLm9uZWhhY2thcmFiaWM9MTYzMztlLm9uZWhhbGY9MTg5O2Uub25laGFuZ3pob3U9MTIzMjE7ZS5vbmVpZGVvZ3JhcGhpY3BhcmVuPTEyODMyO2Uub25laW5mZXJpb3I9ODMyMTtlLm9uZW1vbm9zcGFjZT02NTI5NztlLm9uZW51bWVyYXRvcmJlbmdhbGk9MjU0ODtlLm9uZW9sZHN0eWxlPTYzMjgxO2Uub25lcGFyZW49OTMzMjtlLm9uZXBlcmlvZD05MzUyO2Uub25lcGVyc2lhbj0xNzc3O2Uub25lcXVhcnRlcj0xODg7ZS5vbmVyb21hbj04NTYwO2Uub25lc3VwZXJpb3I9MTg1O2Uub25ldGhhaT0zNjY1O2Uub25ldGhpcmQ9ODUzMTtlLm9vZ29uZWs9NDkxO2Uub29nb25la21hY3Jvbj00OTM7ZS5vb2d1cm11a2hpPTI1Nzk7ZS5vb21hdHJhZ3VybXVraGk9MjYzNTtlLm9vcGVuPTU5NjtlLm9wYXJlbj05Mzg2O2Uub3BlbmJ1bGxldD05NzAyO2Uub3B0aW9uPTg5OTc7ZS5vcmRmZW1pbmluZT0xNzA7ZS5vcmRtYXNjdWxpbmU9MTg2O2Uub3J0aG9nb25hbD04NzM1O2Uub3Nob3J0ZGV2YT0yMzIyO2Uub3Nob3J0dm93ZWxzaWduZGV2YT0yMzc4O2Uub3NsYXNoPTI0ODtlLm9zbGFzaGFjdXRlPTUxMTtlLm9zbWFsbGhpcmFnYW5hPTEyMzYxO2Uub3NtYWxsa2F0YWthbmE9MTI0NTc7ZS5vc21hbGxrYXRha2FuYWhhbGZ3aWR0aD02NTM4NztlLm9zdHJva2VhY3V0ZT01MTE7ZS5vc3VwZXJpb3I9NjMyMTY7ZS5vdGN5cmlsbGljPTExNTE7ZS5vdGlsZGU9MjQ1O2Uub3RpbGRlYWN1dGU9Nzc1NztlLm90aWxkZWRpZXJlc2lzPTc3NTk7ZS5vdWJvcG9tb2ZvPTEyNTc3O2Uub3ZlcmxpbmU9ODI1NDtlLm92ZXJsaW5lY2VudGVybGluZT02NTA5ODtlLm92ZXJsaW5lY21iPTc3MztlLm92ZXJsaW5lZGFzaGVkPTY1MDk3O2Uub3ZlcmxpbmVkYmx3YXZ5PTY1MTAwO2Uub3ZlcmxpbmV3YXZ5PTY1MDk5O2Uub3ZlcnNjb3JlPTE3NTtlLm92b3dlbHNpZ25iZW5nYWxpPTI1MDc7ZS5vdm93ZWxzaWduZGV2YT0yMzc5O2Uub3Zvd2Vsc2lnbmd1amFyYXRpPTI3NjM7ZS5wPTExMjtlLnBhYW1wc3NxdWFyZT0xMzE4NDtlLnBhYXNlbnRvc3F1YXJlPTEzMDk5O2UucGFiZW5nYWxpPTI0NzQ7ZS5wYWN1dGU9Nzc2NTtlLnBhZGV2YT0yMzQ2O2UucGFnZWRvd249ODY3MTtlLnBhZ2V1cD04NjcwO2UucGFndWphcmF0aT0yNzMwO2UucGFndXJtdWtoaT0yNjAyO2UucGFoaXJhZ2FuYT0xMjQwMTtlLnBhaXlhbm5vaXRoYWk9MzYzMTtlLnBha2F0YWthbmE9MTI0OTc7ZS5wYWxhdGFsaXphdGlvbmN5cmlsbGljY21iPTExNTY7ZS5wYWxvY2hrYWN5cmlsbGljPTEyMTY7ZS5wYW5zaW9za29yZWFuPTEyNjcxO2UucGFyYWdyYXBoPTE4MjtlLnBhcmFsbGVsPTg3NDE7ZS5wYXJlbmxlZnQ9NDA7ZS5wYXJlbmxlZnRhbHRvbmVhcmFiaWM9NjQ4MzA7ZS5wYXJlbmxlZnRidD02MzcyNTtlLnBhcmVubGVmdGV4PTYzNzI0O2UucGFyZW5sZWZ0aW5mZXJpb3I9ODMzMztlLnBhcmVubGVmdG1vbm9zcGFjZT02NTI4ODtlLnBhcmVubGVmdHNtYWxsPTY1MTEzO2UucGFyZW5sZWZ0c3VwZXJpb3I9ODMxNztlLnBhcmVubGVmdHRwPTYzNzIzO2UucGFyZW5sZWZ0dmVydGljYWw9NjUwNzc7ZS5wYXJlbnJpZ2h0PTQxO2UucGFyZW5yaWdodGFsdG9uZWFyYWJpYz02NDgzMTtlLnBhcmVucmlnaHRidD02MzczNjtlLnBhcmVucmlnaHRleD02MzczNTtlLnBhcmVucmlnaHRpbmZlcmlvcj04MzM0O2UucGFyZW5yaWdodG1vbm9zcGFjZT02NTI4OTtlLnBhcmVucmlnaHRzbWFsbD02NTExNDtlLnBhcmVucmlnaHRzdXBlcmlvcj04MzE4O2UucGFyZW5yaWdodHRwPTYzNzM0O2UucGFyZW5yaWdodHZlcnRpY2FsPTY1MDc4O2UucGFydGlhbGRpZmY9ODcwNjtlLnBhc2VxaGVicmV3PTE0NzI7ZS5wYXNodGFoZWJyZXc9MTQzMztlLnBhc3F1YXJlPTEzMjI1O2UucGF0YWg9MTQ2MztlLnBhdGFoMTE9MTQ2MztlLnBhdGFoMWQ9MTQ2MztlLnBhdGFoMmE9MTQ2MztlLnBhdGFoaGVicmV3PTE0NjM7ZS5wYXRhaG5hcnJvd2hlYnJldz0xNDYzO2UucGF0YWhxdWFydGVyaGVicmV3PTE0NjM7ZS5wYXRhaHdpZGVoZWJyZXc9MTQ2MztlLnBhemVyaGVicmV3PTE0NDE7ZS5wYm9wb21vZm89MTI1NTA7ZS5wY2lyY2xlPTk0Mzk7ZS5wZG90YWNjZW50PTc3Njc7ZS5wZT0xNTA4O2UucGVjeXJpbGxpYz0xMDg3O2UucGVkYWdlc2g9NjQzMjQ7ZS5wZWRhZ2VzaGhlYnJldz02NDMyNDtlLnBlZXppc3F1YXJlPTEzMTE1O2UucGVmaW5hbGRhZ2VzaGhlYnJldz02NDMyMztlLnBlaGFyYWJpYz0xNjYyO2UucGVoYXJtZW5pYW49MTQwMjtlLnBlaGVicmV3PTE1MDg7ZS5wZWhmaW5hbGFyYWJpYz02NDM0MztlLnBlaGluaXRpYWxhcmFiaWM9NjQzNDQ7ZS5wZWhpcmFnYW5hPTEyNDEwO2UucGVobWVkaWFsYXJhYmljPTY0MzQ1O2UucGVrYXRha2FuYT0xMjUwNjtlLnBlbWlkZGxlaG9va2N5cmlsbGljPTExOTE7ZS5wZXJhZmVoZWJyZXc9NjQzMzQ7ZS5wZXJjZW50PTM3O2UucGVyY2VudGFyYWJpYz0xNjQyO2UucGVyY2VudG1vbm9zcGFjZT02NTI4NTtlLnBlcmNlbnRzbWFsbD02NTEzMDtlLnBlcmlvZD00NjtlLnBlcmlvZGFybWVuaWFuPTE0MTc7ZS5wZXJpb2RjZW50ZXJlZD0xODM7ZS5wZXJpb2RoYWxmd2lkdGg9NjUzNzc7ZS5wZXJpb2RpbmZlcmlvcj02MzIwNztlLnBlcmlvZG1vbm9zcGFjZT02NTI5NDtlLnBlcmlvZHNtYWxsPTY1MTA2O2UucGVyaW9kc3VwZXJpb3I9NjMyMDg7ZS5wZXJpc3BvbWVuaWdyZWVrY21iPTgzNDtlLnBlcnBlbmRpY3VsYXI9ODg2OTtlLnBlcnRob3VzYW5kPTgyNDA7ZS5wZXNldGE9ODM1OTtlLnBmc3F1YXJlPTEzMTk0O2UucGhhYmVuZ2FsaT0yNDc1O2UucGhhZGV2YT0yMzQ3O2UucGhhZ3VqYXJhdGk9MjczMTtlLnBoYWd1cm11a2hpPTI2MDM7ZS5waGk9OTY2O2UucGhpMT05ODE7ZS5waGlldXBoYWNpcmNsZWtvcmVhbj0xMjkyMjtlLnBoaWV1cGhhcGFyZW5rb3JlYW49MTI4MjY7ZS5waGlldXBoY2lyY2xla29yZWFuPTEyOTA4O2UucGhpZXVwaGtvcmVhbj0xMjYyMTtlLnBoaWV1cGhwYXJlbmtvcmVhbj0xMjgxMjtlLnBoaWxhdGluPTYzMjtlLnBoaW50aHV0aGFpPTM2NDI7ZS5waGlzeW1ib2xncmVlaz05ODE7ZS5waG9vaz00MjE7ZS5waG9waGFudGhhaT0zNjE0O2UucGhvcGh1bmd0aGFpPTM2MTI7ZS5waG9zYW1waGFvdGhhaT0zNjE2O2UucGk9OTYwO2UucGlldXBhY2lyY2xla29yZWFuPTEyOTE1O2UucGlldXBhcGFyZW5rb3JlYW49MTI4MTk7ZS5waWV1cGNpZXVja29yZWFuPTEyNjYyO2UucGlldXBjaXJjbGVrb3JlYW49MTI5MDE7ZS5waWV1cGtpeWVva2tvcmVhbj0xMjY1ODtlLnBpZXVwa29yZWFuPTEyNjEwO2UucGlldXBwYXJlbmtvcmVhbj0xMjgwNTtlLnBpZXVwc2lvc2tpeWVva2tvcmVhbj0xMjY2MDtlLnBpZXVwc2lvc2tvcmVhbj0xMjYxMjtlLnBpZXVwc2lvc3Rpa2V1dGtvcmVhbj0xMjY2MTtlLnBpZXVwdGhpZXV0aGtvcmVhbj0xMjY2MztlLnBpZXVwdGlrZXV0a29yZWFuPTEyNjU5O2UucGloaXJhZ2FuYT0xMjQwNDtlLnBpa2F0YWthbmE9MTI1MDA7ZS5waXN5bWJvbGdyZWVrPTk4MjtlLnBpd3Jhcm1lbmlhbj0xNDExO2UucGxhbmNrb3ZlcjJwaT04NDYzO2UucGxhbmNrb3ZlcjJwaTE9ODQ2MztlLnBsdXM9NDM7ZS5wbHVzYmVsb3djbWI9Nzk5O2UucGx1c2NpcmNsZT04ODUzO2UucGx1c21pbnVzPTE3NztlLnBsdXNtb2Q9NzI2O2UucGx1c21vbm9zcGFjZT02NTI5MTtlLnBsdXNzbWFsbD02NTEyMjtlLnBsdXNzdXBlcmlvcj04MzE0O2UucG1vbm9zcGFjZT02NTM2MDtlLnBtc3F1YXJlPTEzMjcyO2UucG9oaXJhZ2FuYT0xMjQxMztlLnBvaW50aW5naW5kZXhkb3dud2hpdGU9OTc1OTtlLnBvaW50aW5naW5kZXhsZWZ0d2hpdGU9OTc1NjtlLnBvaW50aW5naW5kZXhyaWdodHdoaXRlPTk3NTg7ZS5wb2ludGluZ2luZGV4dXB3aGl0ZT05NzU3O2UucG9rYXRha2FuYT0xMjUwOTtlLnBvcGxhdGhhaT0zNjExO2UucG9zdGFsbWFyaz0xMjMwNjtlLnBvc3RhbG1hcmtmYWNlPTEyMzIwO2UucHBhcmVuPTkzODc7ZS5wcmVjZWRlcz04ODI2O2UucHJlc2NyaXB0aW9uPTg0Nzg7ZS5wcmltZW1vZD02OTc7ZS5wcmltZXJldmVyc2VkPTgyNDU7ZS5wcm9kdWN0PTg3MTk7ZS5wcm9qZWN0aXZlPTg5NjU7ZS5wcm9sb25nZWRrYW5hPTEyNTQwO2UucHJvcGVsbG9yPTg5ODQ7ZS5wcm9wZXJzdWJzZXQ9ODgzNDtlLnByb3BlcnN1cGVyc2V0PTg4MzU7ZS5wcm9wb3J0aW9uPTg3NTk7ZS5wcm9wb3J0aW9uYWw9ODczMztlLnBzaT05Njg7ZS5wc2ljeXJpbGxpYz0xMTM3O2UucHNpbGlwbmV1bWF0YWN5cmlsbGljY21iPTExNTg7ZS5wc3NxdWFyZT0xMzIzMjtlLnB1aGlyYWdhbmE9MTI0MDc7ZS5wdWthdGFrYW5hPTEyNTAzO2UucHZzcXVhcmU9MTMyMzY7ZS5wd3NxdWFyZT0xMzI0MjtlLnE9MTEzO2UucWFkZXZhPTIzOTI7ZS5xYWRtYWhlYnJldz0xNDQ4O2UucWFmYXJhYmljPTE2MDI7ZS5xYWZmaW5hbGFyYWJpYz02NTIzODtlLnFhZmluaXRpYWxhcmFiaWM9NjUyMzk7ZS5xYWZtZWRpYWxhcmFiaWM9NjUyNDA7ZS5xYW1hdHM9MTQ2NDtlLnFhbWF0czEwPTE0NjQ7ZS5xYW1hdHMxYT0xNDY0O2UucWFtYXRzMWM9MTQ2NDtlLnFhbWF0czI3PTE0NjQ7ZS5xYW1hdHMyOT0xNDY0O2UucWFtYXRzMzM9MTQ2NDtlLnFhbWF0c2RlPTE0NjQ7ZS5xYW1hdHNoZWJyZXc9MTQ2NDtlLnFhbWF0c25hcnJvd2hlYnJldz0xNDY0O2UucWFtYXRzcWF0YW5oZWJyZXc9MTQ2NDtlLnFhbWF0c3FhdGFubmFycm93aGVicmV3PTE0NjQ7ZS5xYW1hdHNxYXRhbnF1YXJ0ZXJoZWJyZXc9MTQ2NDtlLnFhbWF0c3FhdGFud2lkZWhlYnJldz0xNDY0O2UucWFtYXRzcXVhcnRlcmhlYnJldz0xNDY0O2UucWFtYXRzd2lkZWhlYnJldz0xNDY0O2UucWFybmV5cGFyYWhlYnJldz0xNDM5O2UucWJvcG9tb2ZvPTEyNTYxO2UucWNpcmNsZT05NDQwO2UucWhvb2s9NjcyO2UucW1vbm9zcGFjZT02NTM2MTtlLnFvZj0xNTExO2UucW9mZGFnZXNoPTY0MzI3O2UucW9mZGFnZXNoaGVicmV3PTY0MzI3O2UucW9maGVicmV3PTE1MTE7ZS5xcGFyZW49OTM4ODtlLnF1YXJ0ZXJub3RlPTk4MzM7ZS5xdWJ1dHM9MTQ2NztlLnF1YnV0czE4PTE0Njc7ZS5xdWJ1dHMyNT0xNDY3O2UucXVidXRzMzE9MTQ2NztlLnF1YnV0c2hlYnJldz0xNDY3O2UucXVidXRzbmFycm93aGVicmV3PTE0Njc7ZS5xdWJ1dHNxdWFydGVyaGVicmV3PTE0Njc7ZS5xdWJ1dHN3aWRlaGVicmV3PTE0Njc7ZS5xdWVzdGlvbj02MztlLnF1ZXN0aW9uYXJhYmljPTE1Njc7ZS5xdWVzdGlvbmFybWVuaWFuPTEzNzQ7ZS5xdWVzdGlvbmRvd249MTkxO2UucXVlc3Rpb25kb3duc21hbGw9NjM0MjM7ZS5xdWVzdGlvbmdyZWVrPTg5NDtlLnF1ZXN0aW9ubW9ub3NwYWNlPTY1MzExO2UucXVlc3Rpb25zbWFsbD02MzI5NTtlLnF1b3RlZGJsPTM0O2UucXVvdGVkYmxiYXNlPTgyMjI7ZS5xdW90ZWRibGxlZnQ9ODIyMDtlLnF1b3RlZGJsbW9ub3NwYWNlPTY1MjgyO2UucXVvdGVkYmxwcmltZT0xMjMxODtlLnF1b3RlZGJscHJpbWVyZXZlcnNlZD0xMjMxNztlLnF1b3RlZGJscmlnaHQ9ODIyMTtlLnF1b3RlbGVmdD04MjE2O2UucXVvdGVsZWZ0cmV2ZXJzZWQ9ODIxOTtlLnF1b3RlcmV2ZXJzZWQ9ODIxOTtlLnF1b3RlcmlnaHQ9ODIxNztlLnF1b3RlcmlnaHRuPTMyOTtlLnF1b3Rlc2luZ2xiYXNlPTgyMTg7ZS5xdW90ZXNpbmdsZT0zOTtlLnF1b3Rlc2luZ2xlbW9ub3NwYWNlPTY1Mjg3O2Uucj0xMTQ7ZS5yYWFybWVuaWFuPTE0MDQ7ZS5yYWJlbmdhbGk9MjQ4MDtlLnJhY3V0ZT0zNDE7ZS5yYWRldmE9MjM1MjtlLnJhZGljYWw9ODczMDtlLnJhZGljYWxleD02MzcxNztlLnJhZG92ZXJzc3F1YXJlPTEzMjMwO2UucmFkb3ZlcnNzcXVhcmVkc3F1YXJlPTEzMjMxO2UucmFkc3F1YXJlPTEzMjI5O2UucmFmZT0xNDcxO2UucmFmZWhlYnJldz0xNDcxO2UucmFndWphcmF0aT0yNzM2O2UucmFndXJtdWtoaT0yNjA4O2UucmFoaXJhZ2FuYT0xMjQyNTtlLnJha2F0YWthbmE9MTI1MjE7ZS5yYWthdGFrYW5haGFsZndpZHRoPTY1NDMxO2UucmFsb3dlcmRpYWdvbmFsYmVuZ2FsaT0yNTQ1O2UucmFtaWRkbGVkaWFnb25hbGJlbmdhbGk9MjU0NDtlLnJhbXNob3JuPTYxMjtlLnJhdGlvPTg3NTg7ZS5yYm9wb21vZm89MTI1NjY7ZS5yY2Fyb249MzQ1O2UucmNlZGlsbGE9MzQzO2UucmNpcmNsZT05NDQxO2UucmNvbW1hYWNjZW50PTM0MztlLnJkYmxncmF2ZT01Mjk7ZS5yZG90YWNjZW50PTc3Njk7ZS5yZG90YmVsb3c9Nzc3MTtlLnJkb3RiZWxvd21hY3Jvbj03NzczO2UucmVmZXJlbmNlbWFyaz04MjUxO2UucmVmbGV4c3Vic2V0PTg4Mzg7ZS5yZWZsZXhzdXBlcnNldD04ODM5O2UucmVnaXN0ZXJlZD0xNzQ7ZS5yZWdpc3RlcnNhbnM9NjM3MjA7ZS5yZWdpc3RlcnNlcmlmPTYzMTk0O2UucmVoYXJhYmljPTE1ODU7ZS5yZWhhcm1lbmlhbj0xNDA4O2UucmVoZmluYWxhcmFiaWM9NjUxOTg7ZS5yZWhpcmFnYW5hPTEyNDI4O2UucmVrYXRha2FuYT0xMjUyNDtlLnJla2F0YWthbmFoYWxmd2lkdGg9NjU0MzQ7ZS5yZXNoPTE1MTI7ZS5yZXNoZGFnZXNoaGVicmV3PTY0MzI4O2UucmVzaGhlYnJldz0xNTEyO2UucmV2ZXJzZWR0aWxkZT04NzY1O2UucmV2aWFoZWJyZXc9MTQzMTtlLnJldmlhbXVncmFzaGhlYnJldz0xNDMxO2UucmV2bG9naWNhbG5vdD04OTc2O2UucmZpc2hob29rPTYzODtlLnJmaXNoaG9va3JldmVyc2VkPTYzOTtlLnJoYWJlbmdhbGk9MjUyNTtlLnJoYWRldmE9MjM5NztlLnJobz05NjE7ZS5yaG9vaz02Mzc7ZS5yaG9va3R1cm5lZD02MzU7ZS5yaG9va3R1cm5lZHN1cGVyaW9yPTY5MztlLnJob3N5bWJvbGdyZWVrPTEwMDk7ZS5yaG90aWNob29rbW9kPTczNDtlLnJpZXVsYWNpcmNsZWtvcmVhbj0xMjkxMztlLnJpZXVsYXBhcmVua29yZWFuPTEyODE3O2UucmlldWxjaXJjbGVrb3JlYW49MTI4OTk7ZS5yaWV1bGhpZXVoa29yZWFuPTEyNjA4O2UucmlldWxraXllb2trb3JlYW49MTI2MDI7ZS5yaWV1bGtpeWVva3Npb3Nrb3JlYW49MTI2NDk7ZS5yaWV1bGtvcmVhbj0xMjYwMTtlLnJpZXVsbWlldW1rb3JlYW49MTI2MDM7ZS5yaWV1bHBhbnNpb3Nrb3JlYW49MTI2NTI7ZS5yaWV1bHBhcmVua29yZWFuPTEyODAzO2UucmlldWxwaGlldXBoa29yZWFuPTEyNjA3O2UucmlldWxwaWV1cGtvcmVhbj0xMjYwNDtlLnJpZXVscGlldXBzaW9za29yZWFuPTEyNjUxO2UucmlldWxzaW9za29yZWFuPTEyNjA1O2UucmlldWx0aGlldXRoa29yZWFuPTEyNjA2O2UucmlldWx0aWtldXRrb3JlYW49MTI2NTA7ZS5yaWV1bHllb3JpbmhpZXVoa29yZWFuPTEyNjUzO2UucmlnaHRhbmdsZT04NzM1O2UucmlnaHR0YWNrYmVsb3djbWI9NzkzO2UucmlnaHR0cmlhbmdsZT04ODk1O2UucmloaXJhZ2FuYT0xMjQyNjtlLnJpa2F0YWthbmE9MTI1MjI7ZS5yaWthdGFrYW5haGFsZndpZHRoPTY1NDMyO2UucmluZz03MzA7ZS5yaW5nYmVsb3djbWI9ODA1O2UucmluZ2NtYj03Nzg7ZS5yaW5naGFsZmxlZnQ9NzAzO2UucmluZ2hhbGZsZWZ0YXJtZW5pYW49MTM2OTtlLnJpbmdoYWxmbGVmdGJlbG93Y21iPTc5NjtlLnJpbmdoYWxmbGVmdGNlbnRlcmVkPTcyMztlLnJpbmdoYWxmcmlnaHQ9NzAyO2UucmluZ2hhbGZyaWdodGJlbG93Y21iPTgyNTtlLnJpbmdoYWxmcmlnaHRjZW50ZXJlZD03MjI7ZS5yaW52ZXJ0ZWRicmV2ZT01MzE7ZS5yaXR0b3J1c3F1YXJlPTEzMTM3O2UucmxpbmViZWxvdz03Nzc1O2UucmxvbmdsZWc9NjM2O2UucmxvbmdsZWd0dXJuZWQ9NjM0O2Uucm1vbm9zcGFjZT02NTM2MjtlLnJvaGlyYWdhbmE9MTI0Mjk7ZS5yb2thdGFrYW5hPTEyNTI1O2Uucm9rYXRha2FuYWhhbGZ3aWR0aD02NTQzNTtlLnJvcnVhdGhhaT0zNjE5O2UucnBhcmVuPTkzODk7ZS5ycmFiZW5nYWxpPTI1MjQ7ZS5ycmFkZXZhPTIzNTM7ZS5ycmFndXJtdWtoaT0yNjUyO2UucnJlaGFyYWJpYz0xNjgxO2UucnJlaGZpbmFsYXJhYmljPTY0Mzk3O2UucnJ2b2NhbGljYmVuZ2FsaT0yNTI4O2UucnJ2b2NhbGljZGV2YT0yNDAwO2UucnJ2b2NhbGljZ3VqYXJhdGk9Mjc4NDtlLnJydm9jYWxpY3Zvd2Vsc2lnbmJlbmdhbGk9MjUwMDtlLnJydm9jYWxpY3Zvd2Vsc2lnbmRldmE9MjM3MjtlLnJydm9jYWxpY3Zvd2Vsc2lnbmd1amFyYXRpPTI3NTY7ZS5yc3VwZXJpb3I9NjMyMTc7ZS5ydGJsb2NrPTk2MTY7ZS5ydHVybmVkPTYzMztlLnJ0dXJuZWRzdXBlcmlvcj02OTI7ZS5ydWhpcmFnYW5hPTEyNDI3O2UucnVrYXRha2FuYT0xMjUyMztlLnJ1a2F0YWthbmFoYWxmd2lkdGg9NjU0MzM7ZS5ydXBlZW1hcmtiZW5nYWxpPTI1NDY7ZS5ydXBlZXNpZ25iZW5nYWxpPTI1NDc7ZS5ydXBpYWg9NjMxOTc7ZS5ydXRoYWk9MzYyMDtlLnJ2b2NhbGljYmVuZ2FsaT0yNDQzO2UucnZvY2FsaWNkZXZhPTIzMTU7ZS5ydm9jYWxpY2d1amFyYXRpPTI2OTk7ZS5ydm9jYWxpY3Zvd2Vsc2lnbmJlbmdhbGk9MjQ5OTtlLnJ2b2NhbGljdm93ZWxzaWduZGV2YT0yMzcxO2UucnZvY2FsaWN2b3dlbHNpZ25ndWphcmF0aT0yNzU1O2Uucz0xMTU7ZS5zYWJlbmdhbGk9MjQ4ODtlLnNhY3V0ZT0zNDc7ZS5zYWN1dGVkb3RhY2NlbnQ9Nzc4MTtlLnNhZGFyYWJpYz0xNTg5O2Uuc2FkZXZhPTIzNjA7ZS5zYWRmaW5hbGFyYWJpYz02NTIxMDtlLnNhZGluaXRpYWxhcmFiaWM9NjUyMTE7ZS5zYWRtZWRpYWxhcmFiaWM9NjUyMTI7ZS5zYWd1amFyYXRpPTI3NDQ7ZS5zYWd1cm11a2hpPTI2MTY7ZS5zYWhpcmFnYW5hPTEyMzczO2Uuc2FrYXRha2FuYT0xMjQ2OTtlLnNha2F0YWthbmFoYWxmd2lkdGg9NjU0MDM7ZS5zYWxsYWxsYWhvdWFsYXloZXdhc2FsbGFtYXJhYmljPTY1MDE4O2Uuc2FtZWtoPTE1MDU7ZS5zYW1la2hkYWdlc2g9NjQzMjE7ZS5zYW1la2hkYWdlc2hoZWJyZXc9NjQzMjE7ZS5zYW1la2hoZWJyZXc9MTUwNTtlLnNhcmFhYXRoYWk9MzYzNDtlLnNhcmFhZXRoYWk9MzY0OTtlLnNhcmFhaW1haW1hbGFpdGhhaT0zNjUyO2Uuc2FyYWFpbWFpbXVhbnRoYWk9MzY1MTtlLnNhcmFhbXRoYWk9MzYzNTtlLnNhcmFhdGhhaT0zNjMyO2Uuc2FyYWV0aGFpPTM2NDg7ZS5zYXJhaWlsZWZ0dGhhaT02MzYyMjtlLnNhcmFpaXRoYWk9MzYzNztlLnNhcmFpbGVmdHRoYWk9NjM2MjE7ZS5zYXJhaXRoYWk9MzYzNjtlLnNhcmFvdGhhaT0zNjUwO2Uuc2FyYXVlZWxlZnR0aGFpPTYzNjI0O2Uuc2FyYXVlZXRoYWk9MzYzOTtlLnNhcmF1ZWxlZnR0aGFpPTYzNjIzO2Uuc2FyYXVldGhhaT0zNjM4O2Uuc2FyYXV0aGFpPTM2NDA7ZS5zYXJhdXV0aGFpPTM2NDE7ZS5zYm9wb21vZm89MTI1Njk7ZS5zY2Fyb249MzUzO2Uuc2Nhcm9uZG90YWNjZW50PTc3ODM7ZS5zY2VkaWxsYT0zNTE7ZS5zY2h3YT02MDE7ZS5zY2h3YWN5cmlsbGljPTEyNDE7ZS5zY2h3YWRpZXJlc2lzY3lyaWxsaWM9MTI0MztlLnNjaHdhaG9vaz02MDI7ZS5zY2lyY2xlPTk0NDI7ZS5zY2lyY3VtZmxleD0zNDk7ZS5zY29tbWFhY2NlbnQ9NTM3O2Uuc2RvdGFjY2VudD03Nzc3O2Uuc2RvdGJlbG93PTc3Nzk7ZS5zZG90YmVsb3dkb3RhY2NlbnQ9Nzc4NTtlLnNlYWd1bGxiZWxvd2NtYj04Mjg7ZS5zZWNvbmQ9ODI0MztlLnNlY29uZHRvbmVjaGluZXNlPTcxNDtlLnNlY3Rpb249MTY3O2Uuc2VlbmFyYWJpYz0xNTg3O2Uuc2VlbmZpbmFsYXJhYmljPTY1MjAyO2Uuc2VlbmluaXRpYWxhcmFiaWM9NjUyMDM7ZS5zZWVubWVkaWFsYXJhYmljPTY1MjA0O2Uuc2Vnb2w9MTQ2MjtlLnNlZ29sMTM9MTQ2MjtlLnNlZ29sMWY9MTQ2MjtlLnNlZ29sMmM9MTQ2MjtlLnNlZ29saGVicmV3PTE0NjI7ZS5zZWdvbG5hcnJvd2hlYnJldz0xNDYyO2Uuc2Vnb2xxdWFydGVyaGVicmV3PTE0NjI7ZS5zZWdvbHRhaGVicmV3PTE0MjY7ZS5zZWdvbHdpZGVoZWJyZXc9MTQ2MjtlLnNlaGFybWVuaWFuPTE0MDU7ZS5zZWhpcmFnYW5hPTEyMzc5O2Uuc2VrYXRha2FuYT0xMjQ3NTtlLnNla2F0YWthbmFoYWxmd2lkdGg9NjU0MDY7ZS5zZW1pY29sb249NTk7ZS5zZW1pY29sb25hcmFiaWM9MTU2MztlLnNlbWljb2xvbm1vbm9zcGFjZT02NTMwNztlLnNlbWljb2xvbnNtYWxsPTY1MTA4O2Uuc2VtaXZvaWNlZG1hcmtrYW5hPTEyNDQ0O2Uuc2VtaXZvaWNlZG1hcmtrYW5haGFsZndpZHRoPTY1NDM5O2Uuc2VudGlzcXVhcmU9MTMwOTA7ZS5zZW50b3NxdWFyZT0xMzA5MTtlLnNldmVuPTU1O2Uuc2V2ZW5hcmFiaWM9MTYzOTtlLnNldmVuYmVuZ2FsaT0yNTQxO2Uuc2V2ZW5jaXJjbGU9OTMxODtlLnNldmVuY2lyY2xlaW52ZXJzZXNhbnNzZXJpZj0xMDEyODtlLnNldmVuZGV2YT0yNDEzO2Uuc2V2ZW5laWdodGhzPTg1NDI7ZS5zZXZlbmd1amFyYXRpPTI3OTc7ZS5zZXZlbmd1cm11a2hpPTI2Njk7ZS5zZXZlbmhhY2thcmFiaWM9MTYzOTtlLnNldmVuaGFuZ3pob3U9MTIzMjc7ZS5zZXZlbmlkZW9ncmFwaGljcGFyZW49MTI4Mzg7ZS5zZXZlbmluZmVyaW9yPTgzMjc7ZS5zZXZlbm1vbm9zcGFjZT02NTMwMztlLnNldmVub2xkc3R5bGU9NjMyODc7ZS5zZXZlbnBhcmVuPTkzMzg7ZS5zZXZlbnBlcmlvZD05MzU4O2Uuc2V2ZW5wZXJzaWFuPTE3ODM7ZS5zZXZlbnJvbWFuPTg1NjY7ZS5zZXZlbnN1cGVyaW9yPTgzMTE7ZS5zZXZlbnRlZW5jaXJjbGU9OTMyODtlLnNldmVudGVlbnBhcmVuPTkzNDg7ZS5zZXZlbnRlZW5wZXJpb2Q9OTM2ODtlLnNldmVudGhhaT0zNjcxO2Uuc2Z0aHlwaGVuPTE3MztlLnNoYWFybWVuaWFuPTEzOTk7ZS5zaGFiZW5nYWxpPTI0ODY7ZS5zaGFjeXJpbGxpYz0xMDk2O2Uuc2hhZGRhYXJhYmljPTE2MTc7ZS5zaGFkZGFkYW1tYWFyYWJpYz02NDYwOTtlLnNoYWRkYWRhbW1hdGFuYXJhYmljPTY0NjA2O2Uuc2hhZGRhZmF0aGFhcmFiaWM9NjQ2MDg7ZS5zaGFkZGFrYXNyYWFyYWJpYz02NDYxMDtlLnNoYWRkYWthc3JhdGFuYXJhYmljPTY0NjA3O2Uuc2hhZGU9OTYxODtlLnNoYWRlZGFyaz05NjE5O2Uuc2hhZGVsaWdodD05NjE3O2Uuc2hhZGVtZWRpdW09OTYxODtlLnNoYWRldmE9MjM1ODtlLnNoYWd1amFyYXRpPTI3NDI7ZS5zaGFndXJtdWtoaT0yNjE0O2Uuc2hhbHNoZWxldGhlYnJldz0xNDI3O2Uuc2hib3BvbW9mbz0xMjU2NTtlLnNoY2hhY3lyaWxsaWM9MTA5NztlLnNoZWVuYXJhYmljPTE1ODg7ZS5zaGVlbmZpbmFsYXJhYmljPTY1MjA2O2Uuc2hlZW5pbml0aWFsYXJhYmljPTY1MjA3O2Uuc2hlZW5tZWRpYWxhcmFiaWM9NjUyMDg7ZS5zaGVpY29wdGljPTk5NTtlLnNoZXFlbD04MzYyO2Uuc2hlcWVsaGVicmV3PTgzNjI7ZS5zaGV2YT0xNDU2O2Uuc2hldmExMTU9MTQ1NjtlLnNoZXZhMTU9MTQ1NjtlLnNoZXZhMjI9MTQ1NjtlLnNoZXZhMmU9MTQ1NjtlLnNoZXZhaGVicmV3PTE0NTY7ZS5zaGV2YW5hcnJvd2hlYnJldz0xNDU2O2Uuc2hldmFxdWFydGVyaGVicmV3PTE0NTY7ZS5zaGV2YXdpZGVoZWJyZXc9MTQ1NjtlLnNoaGFjeXJpbGxpYz0xMjExO2Uuc2hpbWFjb3B0aWM9MTAwNTtlLnNoaW49MTUxMztlLnNoaW5kYWdlc2g9NjQzMjk7ZS5zaGluZGFnZXNoaGVicmV3PTY0MzI5O2Uuc2hpbmRhZ2VzaHNoaW5kb3Q9NjQzMDA7ZS5zaGluZGFnZXNoc2hpbmRvdGhlYnJldz02NDMwMDtlLnNoaW5kYWdlc2hzaW5kb3Q9NjQzMDE7ZS5zaGluZGFnZXNoc2luZG90aGVicmV3PTY0MzAxO2Uuc2hpbmRvdGhlYnJldz0xNDczO2Uuc2hpbmhlYnJldz0xNTEzO2Uuc2hpbnNoaW5kb3Q9NjQyOTg7ZS5zaGluc2hpbmRvdGhlYnJldz02NDI5ODtlLnNoaW5zaW5kb3Q9NjQyOTk7ZS5zaGluc2luZG90aGVicmV3PTY0Mjk5O2Uuc2hvb2s9NjQyO2Uuc2lnbWE9OTYzO2Uuc2lnbWExPTk2MjtlLnNpZ21hZmluYWw9OTYyO2Uuc2lnbWFsdW5hdGVzeW1ib2xncmVlaz0xMDEwO2Uuc2loaXJhZ2FuYT0xMjM3NTtlLnNpa2F0YWthbmE9MTI0NzE7ZS5zaWthdGFrYW5haGFsZndpZHRoPTY1NDA0O2Uuc2lsdXFoZWJyZXc9MTQ2OTtlLnNpbHVxbGVmdGhlYnJldz0xNDY5O2Uuc2ltaWxhcj04NzY0O2Uuc2luZG90aGVicmV3PTE0NzQ7ZS5zaW9zYWNpcmNsZWtvcmVhbj0xMjkxNjtlLnNpb3NhcGFyZW5rb3JlYW49MTI4MjA7ZS5zaW9zY2lldWNrb3JlYW49MTI2NzA7ZS5zaW9zY2lyY2xla29yZWFuPTEyOTAyO2Uuc2lvc2tpeWVva2tvcmVhbj0xMjY2NjtlLnNpb3Nrb3JlYW49MTI2MTM7ZS5zaW9zbmlldW5rb3JlYW49MTI2Njc7ZS5zaW9zcGFyZW5rb3JlYW49MTI4MDY7ZS5zaW9zcGlldXBrb3JlYW49MTI2Njk7ZS5zaW9zdGlrZXV0a29yZWFuPTEyNjY4O2Uuc2l4PTU0O2Uuc2l4YXJhYmljPTE2Mzg7ZS5zaXhiZW5nYWxpPTI1NDA7ZS5zaXhjaXJjbGU9OTMxNztlLnNpeGNpcmNsZWludmVyc2VzYW5zc2VyaWY9MTAxMjc7ZS5zaXhkZXZhPTI0MTI7ZS5zaXhndWphcmF0aT0yNzk2O2Uuc2l4Z3VybXVraGk9MjY2ODtlLnNpeGhhY2thcmFiaWM9MTYzODtlLnNpeGhhbmd6aG91PTEyMzI2O2Uuc2l4aWRlb2dyYXBoaWNwYXJlbj0xMjgzNztlLnNpeGluZmVyaW9yPTgzMjY7ZS5zaXhtb25vc3BhY2U9NjUzMDI7ZS5zaXhvbGRzdHlsZT02MzI4NjtlLnNpeHBhcmVuPTkzMzc7ZS5zaXhwZXJpb2Q9OTM1NztlLnNpeHBlcnNpYW49MTc4MjtlLnNpeHJvbWFuPTg1NjU7ZS5zaXhzdXBlcmlvcj04MzEwO2Uuc2l4dGVlbmNpcmNsZT05MzI3O2Uuc2l4dGVlbmN1cnJlbmN5ZGVub21pbmF0b3JiZW5nYWxpPTI1NTM7ZS5zaXh0ZWVucGFyZW49OTM0NztlLnNpeHRlZW5wZXJpb2Q9OTM2NztlLnNpeHRoYWk9MzY3MDtlLnNsYXNoPTQ3O2Uuc2xhc2htb25vc3BhY2U9NjUyOTU7ZS5zbG9uZz0zODM7ZS5zbG9uZ2RvdGFjY2VudD03ODM1O2Uuc21pbGVmYWNlPTk3ODY7ZS5zbW9ub3NwYWNlPTY1MzYzO2Uuc29mcGFzdXFoZWJyZXc9MTQ3NTtlLnNvZnRoeXBoZW49MTczO2Uuc29mdHNpZ25jeXJpbGxpYz0xMTAwO2Uuc29oaXJhZ2FuYT0xMjM4MTtlLnNva2F0YWthbmE9MTI0Nzc7ZS5zb2thdGFrYW5haGFsZndpZHRoPTY1NDA3O2Uuc29saWR1c2xvbmdvdmVybGF5Y21iPTgyNDtlLnNvbGlkdXNzaG9ydG92ZXJsYXljbWI9ODIzO2Uuc29ydXNpdGhhaT0zNjI1O2Uuc29zYWxhdGhhaT0zNjI0O2Uuc29zb3RoYWk9MzU5NTtlLnNvc3VhdGhhaT0zNjI2O2Uuc3BhY2U9MzI7ZS5zcGFjZWhhY2thcmFiaWM9MzI7ZS5zcGFkZT05ODI0O2Uuc3BhZGVzdWl0YmxhY2s9OTgyNDtlLnNwYWRlc3VpdHdoaXRlPTk4Mjg7ZS5zcGFyZW49OTM5MDtlLnNxdWFyZWJlbG93Y21iPTgyNztlLnNxdWFyZWNjPTEzMjUyO2Uuc3F1YXJlY209MTMyMTM7ZS5zcXVhcmVkaWFnb25hbGNyb3NzaGF0Y2hmaWxsPTk2NDE7ZS5zcXVhcmVob3Jpem9udGFsZmlsbD05NjM2O2Uuc3F1YXJla2c9MTMxOTk7ZS5zcXVhcmVrbT0xMzIxNDtlLnNxdWFyZWttY2FwaXRhbD0xMzI2MjtlLnNxdWFyZWxuPTEzMjY1O2Uuc3F1YXJlbG9nPTEzMjY2O2Uuc3F1YXJlbWc9MTMxOTg7ZS5zcXVhcmVtaWw9MTMyNjk7ZS5zcXVhcmVtbT0xMzIxMjtlLnNxdWFyZW1zcXVhcmVkPTEzMjE3O2Uuc3F1YXJlb3J0aG9nb25hbGNyb3NzaGF0Y2hmaWxsPTk2Mzg7ZS5zcXVhcmV1cHBlcmxlZnR0b2xvd2VycmlnaHRmaWxsPTk2Mzk7ZS5zcXVhcmV1cHBlcnJpZ2h0dG9sb3dlcmxlZnRmaWxsPTk2NDA7ZS5zcXVhcmV2ZXJ0aWNhbGZpbGw9OTYzNztlLnNxdWFyZXdoaXRld2l0aHNtYWxsYmxhY2s9OTYzNTtlLnNyc3F1YXJlPTEzMjc1O2Uuc3NhYmVuZ2FsaT0yNDg3O2Uuc3NhZGV2YT0yMzU5O2Uuc3NhZ3VqYXJhdGk9Mjc0MztlLnNzYW5nY2lldWNrb3JlYW49MTI2MTc7ZS5zc2FuZ2hpZXVoa29yZWFuPTEyNjc3O2Uuc3NhbmdpZXVuZ2tvcmVhbj0xMjY3MjtlLnNzYW5na2l5ZW9ra29yZWFuPTEyNTk0O2Uuc3NhbmduaWV1bmtvcmVhbj0xMjY0NTtlLnNzYW5ncGlldXBrb3JlYW49MTI2MTE7ZS5zc2FuZ3Npb3Nrb3JlYW49MTI2MTQ7ZS5zc2FuZ3Rpa2V1dGtvcmVhbj0xMjYwMDtlLnNzdXBlcmlvcj02MzIxODtlLnN0ZXJsaW5nPTE2MztlLnN0ZXJsaW5nbW9ub3NwYWNlPTY1NTA1O2Uuc3Ryb2tlbG9uZ292ZXJsYXljbWI9ODIyO2Uuc3Ryb2tlc2hvcnRvdmVybGF5Y21iPTgyMTtlLnN1YnNldD04ODM0O2Uuc3Vic2V0bm90ZXF1YWw9ODg0MjtlLnN1YnNldG9yZXF1YWw9ODgzODtlLnN1Y2NlZWRzPTg4Mjc7ZS5zdWNodGhhdD04NzE1O2Uuc3VoaXJhZ2FuYT0xMjM3NztlLnN1a2F0YWthbmE9MTI0NzM7ZS5zdWthdGFrYW5haGFsZndpZHRoPTY1NDA1O2Uuc3VrdW5hcmFiaWM9MTYxODtlLnN1bW1hdGlvbj04NzIxO2Uuc3VuPTk3ODg7ZS5zdXBlcnNldD04ODM1O2Uuc3VwZXJzZXRub3RlcXVhbD04ODQzO2Uuc3VwZXJzZXRvcmVxdWFsPTg4Mzk7ZS5zdnNxdWFyZT0xMzI3NjtlLnN5b3V3YWVyYXNxdWFyZT0xMzE4MDtlLnQ9MTE2O2UudGFiZW5nYWxpPTI0Njg7ZS50YWNrZG93bj04ODY4O2UudGFja2xlZnQ9ODg2NztlLnRhZGV2YT0yMzQwO2UudGFndWphcmF0aT0yNzI0O2UudGFndXJtdWtoaT0yNTk2O2UudGFoYXJhYmljPTE1OTE7ZS50YWhmaW5hbGFyYWJpYz02NTIxODtlLnRhaGluaXRpYWxhcmFiaWM9NjUyMTk7ZS50YWhpcmFnYW5hPTEyMzgzO2UudGFobWVkaWFsYXJhYmljPTY1MjIwO2UudGFpc3lvdWVyYXNxdWFyZT0xMzE4MTtlLnRha2F0YWthbmE9MTI0Nzk7ZS50YWthdGFrYW5haGFsZndpZHRoPTY1NDA4O2UudGF0d2VlbGFyYWJpYz0xNjAwO2UudGF1PTk2NDtlLnRhdj0xNTE0O2UudGF2ZGFnZXM9NjQzMzA7ZS50YXZkYWdlc2g9NjQzMzA7ZS50YXZkYWdlc2hoZWJyZXc9NjQzMzA7ZS50YXZoZWJyZXc9MTUxNDtlLnRiYXI9MzU5O2UudGJvcG9tb2ZvPTEyNTU0O2UudGNhcm9uPTM1NztlLnRjY3VybD02ODA7ZS50Y2VkaWxsYT0zNTU7ZS50Y2hlaGFyYWJpYz0xNjcwO2UudGNoZWhmaW5hbGFyYWJpYz02NDM3OTtlLnRjaGVoaW5pdGlhbGFyYWJpYz02NDM4MDtlLnRjaGVobWVkaWFsYXJhYmljPTY0MzgxO2UudGNpcmNsZT05NDQzO2UudGNpcmN1bWZsZXhiZWxvdz03NzkzO2UudGNvbW1hYWNjZW50PTM1NTtlLnRkaWVyZXNpcz03ODMxO2UudGRvdGFjY2VudD03Nzg3O2UudGRvdGJlbG93PTc3ODk7ZS50ZWN5cmlsbGljPTEwOTA7ZS50ZWRlc2NlbmRlcmN5cmlsbGljPTExOTc7ZS50ZWhhcmFiaWM9MTU3ODtlLnRlaGZpbmFsYXJhYmljPTY1MTc0O2UudGVoaGFoaW5pdGlhbGFyYWJpYz02NDY3NDtlLnRlaGhhaGlzb2xhdGVkYXJhYmljPTY0NTI0O2UudGVoaW5pdGlhbGFyYWJpYz02NTE3NTtlLnRlaGlyYWdhbmE9MTIzOTA7ZS50ZWhqZWVtaW5pdGlhbGFyYWJpYz02NDY3MztlLnRlaGplZW1pc29sYXRlZGFyYWJpYz02NDUyMztlLnRlaG1hcmJ1dGFhcmFiaWM9MTU3NztlLnRlaG1hcmJ1dGFmaW5hbGFyYWJpYz02NTE3MjtlLnRlaG1lZGlhbGFyYWJpYz02NTE3NjtlLnRlaG1lZW1pbml0aWFsYXJhYmljPTY0Njc2O2UudGVobWVlbWlzb2xhdGVkYXJhYmljPTY0NTI2O2UudGVobm9vbmZpbmFsYXJhYmljPTY0NjI3O2UudGVrYXRha2FuYT0xMjQ4NjtlLnRla2F0YWthbmFoYWxmd2lkdGg9NjU0MTE7ZS50ZWxlcGhvbmU9ODQ4MTtlLnRlbGVwaG9uZWJsYWNrPTk3NDI7ZS50ZWxpc2hhZ2Vkb2xhaGVicmV3PTE0NDA7ZS50ZWxpc2hhcWV0YW5haGVicmV3PTE0NDk7ZS50ZW5jaXJjbGU9OTMyMTtlLnRlbmlkZW9ncmFwaGljcGFyZW49MTI4NDE7ZS50ZW5wYXJlbj05MzQxO2UudGVucGVyaW9kPTkzNjE7ZS50ZW5yb21hbj04NTY5O2UudGVzaD02Nzk7ZS50ZXQ9MTQ5NjtlLnRldGRhZ2VzaD02NDMxMjtlLnRldGRhZ2VzaGhlYnJldz02NDMxMjtlLnRldGhlYnJldz0xNDk2O2UudGV0c2VjeXJpbGxpYz0xMjA1O2UudGV2aXJoZWJyZXc9MTQzNTtlLnRldmlybGVmdGhlYnJldz0xNDM1O2UudGhhYmVuZ2FsaT0yNDY5O2UudGhhZGV2YT0yMzQxO2UudGhhZ3VqYXJhdGk9MjcyNTtlLnRoYWd1cm11a2hpPTI1OTc7ZS50aGFsYXJhYmljPTE1ODQ7ZS50aGFsZmluYWxhcmFiaWM9NjUxOTY7ZS50aGFudGhha2hhdGxvd2xlZnR0aGFpPTYzNjQwO2UudGhhbnRoYWtoYXRsb3dyaWdodHRoYWk9NjM2Mzk7ZS50aGFudGhha2hhdHRoYWk9MzY2MDtlLnRoYW50aGFraGF0dXBwZXJsZWZ0dGhhaT02MzYzODtlLnRoZWhhcmFiaWM9MTU3OTtlLnRoZWhmaW5hbGFyYWJpYz02NTE3ODtlLnRoZWhpbml0aWFsYXJhYmljPTY1MTc5O2UudGhlaG1lZGlhbGFyYWJpYz02NTE4MDtlLnRoZXJlZXhpc3RzPTg3MDc7ZS50aGVyZWZvcmU9ODc1NjtlLnRoZXRhPTk1MjtlLnRoZXRhMT05Nzc7ZS50aGV0YXN5bWJvbGdyZWVrPTk3NztlLnRoaWV1dGhhY2lyY2xla29yZWFuPTEyOTIxO2UudGhpZXV0aGFwYXJlbmtvcmVhbj0xMjgyNTtlLnRoaWV1dGhjaXJjbGVrb3JlYW49MTI5MDc7ZS50aGlldXRoa29yZWFuPTEyNjIwO2UudGhpZXV0aHBhcmVua29yZWFuPTEyODExO2UudGhpcnRlZW5jaXJjbGU9OTMyNDtlLnRoaXJ0ZWVucGFyZW49OTM0NDtlLnRoaXJ0ZWVucGVyaW9kPTkzNjQ7ZS50aG9uYW5nbW9udGhvdGhhaT0zNjAxO2UudGhvb2s9NDI5O2UudGhvcGh1dGhhb3RoYWk9MzYwMjtlLnRob3JuPTI1NDtlLnRob3RoYWhhbnRoYWk9MzYwNztlLnRob3RoYW50aGFpPTM2MDA7ZS50aG90aG9uZ3RoYWk9MzYwODtlLnRob3RodW5ndGhhaT0zNjA2O2UudGhvdXNhbmRjeXJpbGxpYz0xMTU0O2UudGhvdXNhbmRzc2VwYXJhdG9yYXJhYmljPTE2NDQ7ZS50aG91c2FuZHNzZXBhcmF0b3JwZXJzaWFuPTE2NDQ7ZS50aHJlZT01MTtlLnRocmVlYXJhYmljPTE2MzU7ZS50aHJlZWJlbmdhbGk9MjUzNztlLnRocmVlY2lyY2xlPTkzMTQ7ZS50aHJlZWNpcmNsZWludmVyc2VzYW5zc2VyaWY9MTAxMjQ7ZS50aHJlZWRldmE9MjQwOTtlLnRocmVlZWlnaHRocz04NTQwO2UudGhyZWVndWphcmF0aT0yNzkzO2UudGhyZWVndXJtdWtoaT0yNjY1O2UudGhyZWVoYWNrYXJhYmljPTE2MzU7ZS50aHJlZWhhbmd6aG91PTEyMzIzO2UudGhyZWVpZGVvZ3JhcGhpY3BhcmVuPTEyODM0O2UudGhyZWVpbmZlcmlvcj04MzIzO2UudGhyZWVtb25vc3BhY2U9NjUyOTk7ZS50aHJlZW51bWVyYXRvcmJlbmdhbGk9MjU1MDtlLnRocmVlb2xkc3R5bGU9NjMyODM7ZS50aHJlZXBhcmVuPTkzMzQ7ZS50aHJlZXBlcmlvZD05MzU0O2UudGhyZWVwZXJzaWFuPTE3Nzk7ZS50aHJlZXF1YXJ0ZXJzPTE5MDtlLnRocmVlcXVhcnRlcnNlbWRhc2g9NjMxOTg7ZS50aHJlZXJvbWFuPTg1NjI7ZS50aHJlZXN1cGVyaW9yPTE3OTtlLnRocmVldGhhaT0zNjY3O2UudGh6c3F1YXJlPTEzMjA0O2UudGloaXJhZ2FuYT0xMjM4NTtlLnRpa2F0YWthbmE9MTI0ODE7ZS50aWthdGFrYW5haGFsZndpZHRoPTY1NDA5O2UudGlrZXV0YWNpcmNsZWtvcmVhbj0xMjkxMjtlLnRpa2V1dGFwYXJlbmtvcmVhbj0xMjgxNjtlLnRpa2V1dGNpcmNsZWtvcmVhbj0xMjg5ODtlLnRpa2V1dGtvcmVhbj0xMjU5OTtlLnRpa2V1dHBhcmVua29yZWFuPTEyODAyO2UudGlsZGU9NzMyO2UudGlsZGViZWxvd2NtYj04MTY7ZS50aWxkZWNtYj03NzE7ZS50aWxkZWNvbWI9NzcxO2UudGlsZGVkb3VibGVjbWI9ODY0O2UudGlsZGVvcGVyYXRvcj04NzY0O2UudGlsZGVvdmVybGF5Y21iPTgyMDtlLnRpbGRldmVydGljYWxjbWI9ODMwO2UudGltZXNjaXJjbGU9ODg1NTtlLnRpcGVoYWhlYnJldz0xNDMwO2UudGlwZWhhbGVmdGhlYnJldz0xNDMwO2UudGlwcGlndXJtdWtoaT0yNjcyO2UudGl0bG9jeXJpbGxpY2NtYj0xMTU1O2UudGl3bmFybWVuaWFuPTE0MDc7ZS50bGluZWJlbG93PTc3OTE7ZS50bW9ub3NwYWNlPTY1MzY0O2UudG9hcm1lbmlhbj0xMzg1O2UudG9oaXJhZ2FuYT0xMjM5MjtlLnRva2F0YWthbmE9MTI0ODg7ZS50b2thdGFrYW5haGFsZndpZHRoPTY1NDEyO2UudG9uZWJhcmV4dHJhaGlnaG1vZD03NDE7ZS50b25lYmFyZXh0cmFsb3dtb2Q9NzQ1O2UudG9uZWJhcmhpZ2htb2Q9NzQyO2UudG9uZWJhcmxvd21vZD03NDQ7ZS50b25lYmFybWlkbW9kPTc0MztlLnRvbmVmaXZlPTQ0NTtlLnRvbmVzaXg9Mzg5O2UudG9uZXR3bz00MjQ7ZS50b25vcz05MDA7ZS50b25zcXVhcmU9MTMwOTU7ZS50b3BhdGFrdGhhaT0zNTk5O2UudG9ydG9pc2VzaGVsbGJyYWNrZXRsZWZ0PTEyMzA4O2UudG9ydG9pc2VzaGVsbGJyYWNrZXRsZWZ0c21hbGw9NjUxMTc7ZS50b3J0b2lzZXNoZWxsYnJhY2tldGxlZnR2ZXJ0aWNhbD02NTA4MTtlLnRvcnRvaXNlc2hlbGxicmFja2V0cmlnaHQ9MTIzMDk7ZS50b3J0b2lzZXNoZWxsYnJhY2tldHJpZ2h0c21hbGw9NjUxMTg7ZS50b3J0b2lzZXNoZWxsYnJhY2tldHJpZ2h0dmVydGljYWw9NjUwODI7ZS50b3Rhb3RoYWk9MzYwNTtlLnRwYWxhdGFsaG9vaz00Mjc7ZS50cGFyZW49OTM5MTtlLnRyYWRlbWFyaz04NDgyO2UudHJhZGVtYXJrc2Fucz02MzcyMjtlLnRyYWRlbWFya3NlcmlmPTYzMTk1O2UudHJldHJvZmxleGhvb2s9NjQ4O2UudHJpYWdkbj05NjYwO2UudHJpYWdsZj05NjY4O2UudHJpYWdydD05NjU4O2UudHJpYWd1cD05NjUwO2UudHM9Njc4O2UudHNhZGk9MTUxMDtlLnRzYWRpZGFnZXNoPTY0MzI2O2UudHNhZGlkYWdlc2hoZWJyZXc9NjQzMjY7ZS50c2FkaWhlYnJldz0xNTEwO2UudHNlY3lyaWxsaWM9MTA5NDtlLnRzZXJlPTE0NjE7ZS50c2VyZTEyPTE0NjE7ZS50c2VyZTFlPTE0NjE7ZS50c2VyZTJiPTE0NjE7ZS50c2VyZWhlYnJldz0xNDYxO2UudHNlcmVuYXJyb3doZWJyZXc9MTQ2MTtlLnRzZXJlcXVhcnRlcmhlYnJldz0xNDYxO2UudHNlcmV3aWRlaGVicmV3PTE0NjE7ZS50c2hlY3lyaWxsaWM9MTExNTtlLnRzdXBlcmlvcj02MzIxOTtlLnR0YWJlbmdhbGk9MjQ2MztlLnR0YWRldmE9MjMzNTtlLnR0YWd1amFyYXRpPTI3MTk7ZS50dGFndXJtdWtoaT0yNTkxO2UudHRlaGFyYWJpYz0xNjU3O2UudHRlaGZpbmFsYXJhYmljPTY0MzU5O2UudHRlaGluaXRpYWxhcmFiaWM9NjQzNjA7ZS50dGVobWVkaWFsYXJhYmljPTY0MzYxO2UudHRoYWJlbmdhbGk9MjQ2NDtlLnR0aGFkZXZhPTIzMzY7ZS50dGhhZ3VqYXJhdGk9MjcyMDtlLnR0aGFndXJtdWtoaT0yNTkyO2UudHR1cm5lZD02NDc7ZS50dWhpcmFnYW5hPTEyMzg4O2UudHVrYXRha2FuYT0xMjQ4NDtlLnR1a2F0YWthbmFoYWxmd2lkdGg9NjU0MTA7ZS50dXNtYWxsaGlyYWdhbmE9MTIzODc7ZS50dXNtYWxsa2F0YWthbmE9MTI0ODM7ZS50dXNtYWxsa2F0YWthbmFoYWxmd2lkdGg9NjUzOTE7ZS50d2VsdmVjaXJjbGU9OTMyMztlLnR3ZWx2ZXBhcmVuPTkzNDM7ZS50d2VsdmVwZXJpb2Q9OTM2MztlLnR3ZWx2ZXJvbWFuPTg1NzE7ZS50d2VudHljaXJjbGU9OTMzMTtlLnR3ZW50eWhhbmd6aG91PTIxMzE2O2UudHdlbnR5cGFyZW49OTM1MTtlLnR3ZW50eXBlcmlvZD05MzcxO2UudHdvPTUwO2UudHdvYXJhYmljPTE2MzQ7ZS50d29iZW5nYWxpPTI1MzY7ZS50d29jaXJjbGU9OTMxMztlLnR3b2NpcmNsZWludmVyc2VzYW5zc2VyaWY9MTAxMjM7ZS50d29kZXZhPTI0MDg7ZS50d29kb3RlbmxlYWRlcj04MjI5O2UudHdvZG90bGVhZGVyPTgyMjk7ZS50d29kb3RsZWFkZXJ2ZXJ0aWNhbD02NTA3MjtlLnR3b2d1amFyYXRpPTI3OTI7ZS50d29ndXJtdWtoaT0yNjY0O2UudHdvaGFja2FyYWJpYz0xNjM0O2UudHdvaGFuZ3pob3U9MTIzMjI7ZS50d29pZGVvZ3JhcGhpY3BhcmVuPTEyODMzO2UudHdvaW5mZXJpb3I9ODMyMjtlLnR3b21vbm9zcGFjZT02NTI5ODtlLnR3b251bWVyYXRvcmJlbmdhbGk9MjU0OTtlLnR3b29sZHN0eWxlPTYzMjgyO2UudHdvcGFyZW49OTMzMztlLnR3b3BlcmlvZD05MzUzO2UudHdvcGVyc2lhbj0xNzc4O2UudHdvcm9tYW49ODU2MTtlLnR3b3N0cm9rZT00NDM7ZS50d29zdXBlcmlvcj0xNzg7ZS50d290aGFpPTM2NjY7ZS50d290aGlyZHM9ODUzMjtlLnU9MTE3O2UudWFjdXRlPTI1MDtlLnViYXI9NjQ5O2UudWJlbmdhbGk9MjQ0MTtlLnVib3BvbW9mbz0xMjU4NDtlLnVicmV2ZT0zNjU7ZS51Y2Fyb249NDY4O2UudWNpcmNsZT05NDQ0O2UudWNpcmN1bWZsZXg9MjUxO2UudWNpcmN1bWZsZXhiZWxvdz03Nzk5O2UudWN5cmlsbGljPTEwOTE7ZS51ZGF0dGFkZXZhPTIzODU7ZS51ZGJsYWN1dGU9MzY5O2UudWRibGdyYXZlPTUzMztlLnVkZXZhPTIzMTM7ZS51ZGllcmVzaXM9MjUyO2UudWRpZXJlc2lzYWN1dGU9NDcyO2UudWRpZXJlc2lzYmVsb3c9Nzc5NTtlLnVkaWVyZXNpc2Nhcm9uPTQ3NDtlLnVkaWVyZXNpc2N5cmlsbGljPTEyNjU7ZS51ZGllcmVzaXNncmF2ZT00NzY7ZS51ZGllcmVzaXNtYWNyb249NDcwO2UudWRvdGJlbG93PTc5MDk7ZS51Z3JhdmU9MjQ5O2UudWd1amFyYXRpPTI2OTc7ZS51Z3VybXVraGk9MjU2OTtlLnVoaXJhZ2FuYT0xMjM1ODtlLnVob29rYWJvdmU9NzkxMTtlLnVob3JuPTQzMjtlLnVob3JuYWN1dGU9NzkxMztlLnVob3JuZG90YmVsb3c9NzkyMTtlLnVob3JuZ3JhdmU9NzkxNTtlLnVob3JuaG9va2Fib3ZlPTc5MTc7ZS51aG9ybnRpbGRlPTc5MTk7ZS51aHVuZ2FydW1sYXV0PTM2OTtlLnVodW5nYXJ1bWxhdXRjeXJpbGxpYz0xMjY3O2UudWludmVydGVkYnJldmU9NTM1O2UudWthdGFrYW5hPTEyNDU0O2UudWthdGFrYW5haGFsZndpZHRoPTY1Mzk1O2UudWtjeXJpbGxpYz0xMTQ1O2UudWtvcmVhbj0xMjYzNjtlLnVtYWNyb249MzYzO2UudW1hY3JvbmN5cmlsbGljPTEyNjM7ZS51bWFjcm9uZGllcmVzaXM9NzgwMztlLnVtYXRyYWd1cm11a2hpPTI2MjU7ZS51bW9ub3NwYWNlPTY1MzY1O2UudW5kZXJzY29yZT05NTtlLnVuZGVyc2NvcmVkYmw9ODIxNTtlLnVuZGVyc2NvcmVtb25vc3BhY2U9NjUzNDM7ZS51bmRlcnNjb3JldmVydGljYWw9NjUwNzU7ZS51bmRlcnNjb3Jld2F2eT02NTEwMztlLnVuaW9uPTg3NDY7ZS51bml2ZXJzYWw9ODcwNDtlLnVvZ29uZWs9MzcxO2UudXBhcmVuPTkzOTI7ZS51cGJsb2NrPTk2MDA7ZS51cHBlcmRvdGhlYnJldz0xNDc2O2UudXBzaWxvbj05NjU7ZS51cHNpbG9uZGllcmVzaXM9OTcxO2UudXBzaWxvbmRpZXJlc2lzdG9ub3M9OTQ0O2UudXBzaWxvbmxhdGluPTY1MDtlLnVwc2lsb250b25vcz05NzM7ZS51cHRhY2tiZWxvd2NtYj03OTc7ZS51cHRhY2ttb2Q9NzI0O2UudXJhZ3VybXVraGk9MjY3NTtlLnVyaW5nPTM2NztlLnVzaG9ydGN5cmlsbGljPTExMTg7ZS51c21hbGxoaXJhZ2FuYT0xMjM1NztlLnVzbWFsbGthdGFrYW5hPTEyNDUzO2UudXNtYWxsa2F0YWthbmFoYWxmd2lkdGg9NjUzODU7ZS51c3RyYWlnaHRjeXJpbGxpYz0xMTk5O2UudXN0cmFpZ2h0c3Ryb2tlY3lyaWxsaWM9MTIwMTtlLnV0aWxkZT0zNjE7ZS51dGlsZGVhY3V0ZT03ODAxO2UudXRpbGRlYmVsb3c9Nzc5NztlLnV1YmVuZ2FsaT0yNDQyO2UudXVkZXZhPTIzMTQ7ZS51dWd1amFyYXRpPTI2OTg7ZS51dWd1cm11a2hpPTI1NzA7ZS51dW1hdHJhZ3VybXVraGk9MjYyNjtlLnV1dm93ZWxzaWduYmVuZ2FsaT0yNDk4O2UudXV2b3dlbHNpZ25kZXZhPTIzNzA7ZS51dXZvd2Vsc2lnbmd1amFyYXRpPTI3NTQ7ZS51dm93ZWxzaWduYmVuZ2FsaT0yNDk3O2UudXZvd2Vsc2lnbmRldmE9MjM2OTtlLnV2b3dlbHNpZ25ndWphcmF0aT0yNzUzO2Uudj0xMTg7ZS52YWRldmE9MjM1NztlLnZhZ3VqYXJhdGk9Mjc0MTtlLnZhZ3VybXVraGk9MjYxMztlLnZha2F0YWthbmE9MTI1MzU7ZS52YXY9MTQ5MztlLnZhdmRhZ2VzaD02NDMwOTtlLnZhdmRhZ2VzaDY1PTY0MzA5O2UudmF2ZGFnZXNoaGVicmV3PTY0MzA5O2UudmF2aGVicmV3PTE0OTM7ZS52YXZob2xhbT02NDMzMTtlLnZhdmhvbGFtaGVicmV3PTY0MzMxO2UudmF2dmF2aGVicmV3PTE1MjA7ZS52YXZ5b2RoZWJyZXc9MTUyMTtlLnZjaXJjbGU9OTQ0NTtlLnZkb3RiZWxvdz03ODA3O2UudmVjeXJpbGxpYz0xMDc0O2UudmVoYXJhYmljPTE3MDA7ZS52ZWhmaW5hbGFyYWJpYz02NDM2MztlLnZlaGluaXRpYWxhcmFiaWM9NjQzNjQ7ZS52ZWhtZWRpYWxhcmFiaWM9NjQzNjU7ZS52ZWthdGFrYW5hPTEyNTM3O2UudmVudXM9OTc5MjtlLnZlcnRpY2FsYmFyPTEyNDtlLnZlcnRpY2FsbGluZWFib3ZlY21iPTc4MTtlLnZlcnRpY2FsbGluZWJlbG93Y21iPTgwOTtlLnZlcnRpY2FsbGluZWxvd21vZD03MTY7ZS52ZXJ0aWNhbGxpbmVtb2Q9NzEyO2UudmV3YXJtZW5pYW49MTQwNjtlLnZob29rPTY1MTtlLnZpa2F0YWthbmE9MTI1MzY7ZS52aXJhbWFiZW5nYWxpPTI1MDk7ZS52aXJhbWFkZXZhPTIzODE7ZS52aXJhbWFndWphcmF0aT0yNzY1O2UudmlzYXJnYWJlbmdhbGk9MjQzNTtlLnZpc2FyZ2FkZXZhPTIzMDc7ZS52aXNhcmdhZ3VqYXJhdGk9MjY5MTtlLnZtb25vc3BhY2U9NjUzNjY7ZS52b2FybWVuaWFuPTE0MDA7ZS52b2ljZWRpdGVyYXRpb25oaXJhZ2FuYT0xMjQ0NjtlLnZvaWNlZGl0ZXJhdGlvbmthdGFrYW5hPTEyNTQyO2Uudm9pY2VkbWFya2thbmE9MTI0NDM7ZS52b2ljZWRtYXJra2FuYWhhbGZ3aWR0aD02NTQzODtlLnZva2F0YWthbmE9MTI1Mzg7ZS52cGFyZW49OTM5MztlLnZ0aWxkZT03ODA1O2UudnR1cm5lZD02NTI7ZS52dWhpcmFnYW5hPTEyNDM2O2UudnVrYXRha2FuYT0xMjUzMjtlLnc9MTE5O2Uud2FjdXRlPTc4MTE7ZS53YWVrb3JlYW49MTI2MzM7ZS53YWhpcmFnYW5hPTEyNDMxO2Uud2FrYXRha2FuYT0xMjUyNztlLndha2F0YWthbmFoYWxmd2lkdGg9NjU0MzY7ZS53YWtvcmVhbj0xMjYzMjtlLndhc21hbGxoaXJhZ2FuYT0xMjQzMDtlLndhc21hbGxrYXRha2FuYT0xMjUyNjtlLndhdHRvc3F1YXJlPTEzMTQzO2Uud2F2ZWRhc2g9MTIzMTY7ZS53YXZ5dW5kZXJzY29yZXZlcnRpY2FsPTY1MDc2O2Uud2F3YXJhYmljPTE2MDg7ZS53YXdmaW5hbGFyYWJpYz02NTI2MjtlLndhd2hhbXphYWJvdmVhcmFiaWM9MTU3MjtlLndhd2hhbXphYWJvdmVmaW5hbGFyYWJpYz02NTE1ODtlLndic3F1YXJlPTEzMjc3O2Uud2NpcmNsZT05NDQ2O2Uud2NpcmN1bWZsZXg9MzczO2Uud2RpZXJlc2lzPTc4MTM7ZS53ZG90YWNjZW50PTc4MTU7ZS53ZG90YmVsb3c9NzgxNztlLndlaGlyYWdhbmE9MTI0MzM7ZS53ZWllcnN0cmFzcz04NDcyO2Uud2VrYXRha2FuYT0xMjUyOTtlLndla29yZWFuPTEyNjM4O2Uud2Vva29yZWFuPTEyNjM3O2Uud2dyYXZlPTc4MDk7ZS53aGl0ZWJ1bGxldD05NzAyO2Uud2hpdGVjaXJjbGU9OTY3NTtlLndoaXRlY2lyY2xlaW52ZXJzZT05Njg5O2Uud2hpdGVjb3JuZXJicmFja2V0bGVmdD0xMjMwMjtlLndoaXRlY29ybmVyYnJhY2tldGxlZnR2ZXJ0aWNhbD02NTA5MTtlLndoaXRlY29ybmVyYnJhY2tldHJpZ2h0PTEyMzAzO2Uud2hpdGVjb3JuZXJicmFja2V0cmlnaHR2ZXJ0aWNhbD02NTA5MjtlLndoaXRlZGlhbW9uZD05NjcxO2Uud2hpdGVkaWFtb25kY29udGFpbmluZ2JsYWNrc21hbGxkaWFtb25kPTk2NzI7ZS53aGl0ZWRvd25wb2ludGluZ3NtYWxsdHJpYW5nbGU9OTY2MztlLndoaXRlZG93bnBvaW50aW5ndHJpYW5nbGU9OTY2MTtlLndoaXRlbGVmdHBvaW50aW5nc21hbGx0cmlhbmdsZT05NjY3O2Uud2hpdGVsZWZ0cG9pbnRpbmd0cmlhbmdsZT05NjY1O2Uud2hpdGVsZW50aWN1bGFyYnJhY2tldGxlZnQ9MTIzMTA7ZS53aGl0ZWxlbnRpY3VsYXJicmFja2V0cmlnaHQ9MTIzMTE7ZS53aGl0ZXJpZ2h0cG9pbnRpbmdzbWFsbHRyaWFuZ2xlPTk2NTc7ZS53aGl0ZXJpZ2h0cG9pbnRpbmd0cmlhbmdsZT05NjU1O2Uud2hpdGVzbWFsbHNxdWFyZT05NjQzO2Uud2hpdGVzbWlsaW5nZmFjZT05Nzg2O2Uud2hpdGVzcXVhcmU9OTYzMztlLndoaXRlc3Rhcj05NzM0O2Uud2hpdGV0ZWxlcGhvbmU9OTc0MztlLndoaXRldG9ydG9pc2VzaGVsbGJyYWNrZXRsZWZ0PTEyMzEyO2Uud2hpdGV0b3J0b2lzZXNoZWxsYnJhY2tldHJpZ2h0PTEyMzEzO2Uud2hpdGV1cHBvaW50aW5nc21hbGx0cmlhbmdsZT05NjUzO2Uud2hpdGV1cHBvaW50aW5ndHJpYW5nbGU9OTY1MTtlLndpaGlyYWdhbmE9MTI0MzI7ZS53aWthdGFrYW5hPTEyNTI4O2Uud2lrb3JlYW49MTI2Mzk7ZS53bW9ub3NwYWNlPTY1MzY3O2Uud29oaXJhZ2FuYT0xMjQzNDtlLndva2F0YWthbmE9MTI1MzA7ZS53b2thdGFrYW5haGFsZndpZHRoPTY1MzgyO2Uud29uPTgzNjE7ZS53b25tb25vc3BhY2U9NjU1MTA7ZS53b3dhZW50aGFpPTM2MjM7ZS53cGFyZW49OTM5NDtlLndyaW5nPTc4MzI7ZS53c3VwZXJpb3I9Njk1O2Uud3R1cm5lZD02NTM7ZS53eW5uPTQ0NztlLng9MTIwO2UueGFib3ZlY21iPTgyOTtlLnhib3BvbW9mbz0xMjU2MjtlLnhjaXJjbGU9OTQ0NztlLnhkaWVyZXNpcz03ODIxO2UueGRvdGFjY2VudD03ODE5O2UueGVoYXJtZW5pYW49MTM4OTtlLnhpPTk1ODtlLnhtb25vc3BhY2U9NjUzNjg7ZS54cGFyZW49OTM5NTtlLnhzdXBlcmlvcj03Mzk7ZS55PTEyMTtlLnlhYWRvc3F1YXJlPTEzMTM0O2UueWFiZW5nYWxpPTI0Nzk7ZS55YWN1dGU9MjUzO2UueWFkZXZhPTIzNTE7ZS55YWVrb3JlYW49MTI2MjY7ZS55YWd1amFyYXRpPTI3MzU7ZS55YWd1cm11a2hpPTI2MDc7ZS55YWhpcmFnYW5hPTEyNDIwO2UueWFrYXRha2FuYT0xMjUxNjtlLnlha2F0YWthbmFoYWxmd2lkdGg9NjU0Mjg7ZS55YWtvcmVhbj0xMjYyNTtlLnlhbWFra2FudGhhaT0zNjYyO2UueWFzbWFsbGhpcmFnYW5hPTEyNDE5O2UueWFzbWFsbGthdGFrYW5hPTEyNTE1O2UueWFzbWFsbGthdGFrYW5haGFsZndpZHRoPTY1Mzg4O2UueWF0Y3lyaWxsaWM9MTEyMztlLnljaXJjbGU9OTQ0ODtlLnljaXJjdW1mbGV4PTM3NTtlLnlkaWVyZXNpcz0yNTU7ZS55ZG90YWNjZW50PTc4MjM7ZS55ZG90YmVsb3c9NzkyNTtlLnllaGFyYWJpYz0xNjEwO2UueWVoYmFycmVlYXJhYmljPTE3NDY7ZS55ZWhiYXJyZWVmaW5hbGFyYWJpYz02NDQzMTtlLnllaGZpbmFsYXJhYmljPTY1MjY2O2UueWVoaGFtemFhYm92ZWFyYWJpYz0xNTc0O2UueWVoaGFtemFhYm92ZWZpbmFsYXJhYmljPTY1MTYyO2UueWVoaGFtemFhYm92ZWluaXRpYWxhcmFiaWM9NjUxNjM7ZS55ZWhoYW16YWFib3ZlbWVkaWFsYXJhYmljPTY1MTY0O2UueWVoaW5pdGlhbGFyYWJpYz02NTI2NztlLnllaG1lZGlhbGFyYWJpYz02NTI2ODtlLnllaG1lZW1pbml0aWFsYXJhYmljPTY0NzMzO2UueWVobWVlbWlzb2xhdGVkYXJhYmljPTY0NjAwO2UueWVobm9vbmZpbmFsYXJhYmljPTY0NjYwO2UueWVodGhyZWVkb3RzYmVsb3dhcmFiaWM9MTc0NTtlLnlla29yZWFuPTEyNjMwO2UueWVuPTE2NTtlLnllbm1vbm9zcGFjZT02NTUwOTtlLnllb2tvcmVhbj0xMjYyOTtlLnllb3JpbmhpZXVoa29yZWFuPTEyNjc4O2UueWVyYWhiZW55b21vaGVicmV3PTE0NTA7ZS55ZXJhaGJlbnlvbW9sZWZ0aGVicmV3PTE0NTA7ZS55ZXJpY3lyaWxsaWM9MTA5OTtlLnllcnVkaWVyZXNpc2N5cmlsbGljPTEyNzM7ZS55ZXNpZXVuZ2tvcmVhbj0xMjY3MztlLnllc2lldW5ncGFuc2lvc2tvcmVhbj0xMjY3NTtlLnllc2lldW5nc2lvc2tvcmVhbj0xMjY3NDtlLnlldGl2aGVicmV3PTE0MzQ7ZS55Z3JhdmU9NzkyMztlLnlob29rPTQzNjtlLnlob29rYWJvdmU9NzkyNztlLnlpYXJtZW5pYW49MTM5NztlLnlpY3lyaWxsaWM9MTExMTtlLnlpa29yZWFuPTEyNjQyO2UueWlueWFuZz05Nzc1O2UueWl3bmFybWVuaWFuPTE0MTA7ZS55bW9ub3NwYWNlPTY1MzY5O2UueW9kPTE0OTc7ZS55b2RkYWdlc2g9NjQzMTM7ZS55b2RkYWdlc2hoZWJyZXc9NjQzMTM7ZS55b2RoZWJyZXc9MTQ5NztlLnlvZHlvZGhlYnJldz0xNTIyO2UueW9keW9kcGF0YWhoZWJyZXc9NjQyODc7ZS55b2hpcmFnYW5hPTEyNDI0O2UueW9pa29yZWFuPTEyNjgxO2UueW9rYXRha2FuYT0xMjUyMDtlLnlva2F0YWthbmFoYWxmd2lkdGg9NjU0MzA7ZS55b2tvcmVhbj0xMjYzNTtlLnlvc21hbGxoaXJhZ2FuYT0xMjQyMztlLnlvc21hbGxrYXRha2FuYT0xMjUxOTtlLnlvc21hbGxrYXRha2FuYWhhbGZ3aWR0aD02NTM5MDtlLnlvdGdyZWVrPTEwMTE7ZS55b3lhZWtvcmVhbj0xMjY4MDtlLnlveWFrb3JlYW49MTI2Nzk7ZS55b3lha3RoYWk9MzYxODtlLnlveWluZ3RoYWk9MzU5NztlLnlwYXJlbj05Mzk2O2UueXBvZ2VncmFtbWVuaT04OTA7ZS55cG9nZWdyYW1tZW5pZ3JlZWtjbWI9ODM3O2UueXI9NDIyO2UueXJpbmc9NzgzMztlLnlzdXBlcmlvcj02OTY7ZS55dGlsZGU9NzkyOTtlLnl0dXJuZWQ9NjU0O2UueXVoaXJhZ2FuYT0xMjQyMjtlLnl1aWtvcmVhbj0xMjY4NDtlLnl1a2F0YWthbmE9MTI1MTg7ZS55dWthdGFrYW5haGFsZndpZHRoPTY1NDI5O2UueXVrb3JlYW49MTI2NDA7ZS55dXNiaWdjeXJpbGxpYz0xMTMxO2UueXVzYmlnaW90aWZpZWRjeXJpbGxpYz0xMTMzO2UueXVzbGl0dGxlY3lyaWxsaWM9MTEyNztlLnl1c2xpdHRsZWlvdGlmaWVkY3lyaWxsaWM9MTEyOTtlLnl1c21hbGxoaXJhZ2FuYT0xMjQyMTtlLnl1c21hbGxrYXRha2FuYT0xMjUxNztlLnl1c21hbGxrYXRha2FuYWhhbGZ3aWR0aD02NTM4OTtlLnl1eWVrb3JlYW49MTI2ODM7ZS55dXllb2tvcmVhbj0xMjY4MjtlLnl5YWJlbmdhbGk9MjUyNztlLnl5YWRldmE9MjM5OTtlLno9MTIyO2UuemFhcm1lbmlhbj0xMzgyO2UuemFjdXRlPTM3ODtlLnphZGV2YT0yMzk1O2UuemFndXJtdWtoaT0yNjUxO2UuemFoYXJhYmljPTE1OTI7ZS56YWhmaW5hbGFyYWJpYz02NTIyMjtlLnphaGluaXRpYWxhcmFiaWM9NjUyMjM7ZS56YWhpcmFnYW5hPTEyMzc0O2UuemFobWVkaWFsYXJhYmljPTY1MjI0O2UuemFpbmFyYWJpYz0xNTg2O2UuemFpbmZpbmFsYXJhYmljPTY1MjAwO2UuemFrYXRha2FuYT0xMjQ3MDtlLnphcWVmZ2Fkb2xoZWJyZXc9MTQyOTtlLnphcWVmcWF0YW5oZWJyZXc9MTQyODtlLnphcnFhaGVicmV3PTE0MzI7ZS56YXlpbj0xNDk0O2UuemF5aW5kYWdlc2g9NjQzMTA7ZS56YXlpbmRhZ2VzaGhlYnJldz02NDMxMDtlLnpheWluaGVicmV3PTE0OTQ7ZS56Ym9wb21vZm89MTI1Njc7ZS56Y2Fyb249MzgyO2UuemNpcmNsZT05NDQ5O2UuemNpcmN1bWZsZXg9NzgyNTtlLnpjdXJsPTY1NztlLnpkb3Q9MzgwO2UuemRvdGFjY2VudD0zODA7ZS56ZG90YmVsb3c9NzgyNztlLnplY3lyaWxsaWM9MTA3OTtlLnplZGVzY2VuZGVyY3lyaWxsaWM9MTE3NztlLnplZGllcmVzaXNjeXJpbGxpYz0xMjQ3O2UuemVoaXJhZ2FuYT0xMjM4MDtlLnpla2F0YWthbmE9MTI0NzY7ZS56ZXJvPTQ4O2UuemVyb2FyYWJpYz0xNjMyO2UuemVyb2JlbmdhbGk9MjUzNDtlLnplcm9kZXZhPTI0MDY7ZS56ZXJvZ3VqYXJhdGk9Mjc5MDtlLnplcm9ndXJtdWtoaT0yNjYyO2UuemVyb2hhY2thcmFiaWM9MTYzMjtlLnplcm9pbmZlcmlvcj04MzIwO2UuemVyb21vbm9zcGFjZT02NTI5NjtlLnplcm9vbGRzdHlsZT02MzI4MDtlLnplcm9wZXJzaWFuPTE3NzY7ZS56ZXJvc3VwZXJpb3I9ODMwNDtlLnplcm90aGFpPTM2NjQ7ZS56ZXJvd2lkdGhqb2luZXI9NjUyNzk7ZS56ZXJvd2lkdGhub25qb2luZXI9ODIwNDtlLnplcm93aWR0aHNwYWNlPTgyMDM7ZS56ZXRhPTk1MDtlLnpoYm9wb21vZm89MTI1NjM7ZS56aGVhcm1lbmlhbj0xMzg2O2UuemhlYnJldmVjeXJpbGxpYz0xMjE4O2UuemhlY3lyaWxsaWM9MTA3ODtlLnpoZWRlc2NlbmRlcmN5cmlsbGljPTExNzU7ZS56aGVkaWVyZXNpc2N5cmlsbGljPTEyNDU7ZS56aWhpcmFnYW5hPTEyMzc2O2UuemlrYXRha2FuYT0xMjQ3MjtlLnppbm9yaGVicmV3PTE0NTQ7ZS56bGluZWJlbG93PTc4Mjk7ZS56bW9ub3NwYWNlPTY1MzcwO2Uuem9oaXJhZ2FuYT0xMjM4MjtlLnpva2F0YWthbmE9MTI0Nzg7ZS56cGFyZW49OTM5NztlLnpyZXRyb2ZsZXhob29rPTY1NjtlLnpzdHJva2U9NDM4O2UuenVoaXJhZ2FuYT0xMjM3ODtlLnp1a2F0YWthbmE9MTI0NzQ7ZVsiLm5vdGRlZiJdPTA7ZS5hbmdicmFja2V0bGVmdGJpZz05MDAxO2UuYW5nYnJhY2tldGxlZnRCaWc9OTAwMTtlLmFuZ2JyYWNrZXRsZWZ0YmlnZz05MDAxO2UuYW5nYnJhY2tldGxlZnRCaWdnPTkwMDE7ZS5hbmdicmFja2V0cmlnaHRCaWc9OTAwMjtlLmFuZ2JyYWNrZXRyaWdodGJpZz05MDAyO2UuYW5nYnJhY2tldHJpZ2h0QmlnZz05MDAyO2UuYW5nYnJhY2tldHJpZ2h0YmlnZz05MDAyO2UuYXJyb3dob29rbGVmdD04NjE4O2UuYXJyb3dob29rcmlnaHQ9ODYxNztlLmFycm93bGVmdHRvcGhhbGY9ODYzNjtlLmFycm93bGVmdGJvdGhhbGY9ODYzNztlLmFycm93bm9ydGhlYXN0PTg1OTk7ZS5hcnJvd25vcnRod2VzdD04NTk4O2UuYXJyb3dyaWdodHRvcGhhbGY9ODY0MDtlLmFycm93cmlnaHRib3RoYWxmPTg2NDE7ZS5hcnJvd3NvdXRoZWFzdD04NjAwO2UuYXJyb3dzb3V0aHdlc3Q9ODYwMTtlLmJhY2tzbGFzaGJpZz04NzI2O2UuYmFja3NsYXNoQmlnPTg3MjY7ZS5iYWNrc2xhc2hCaWdnPTg3MjY7ZS5iYWNrc2xhc2hiaWdnPTg3MjY7ZS5iYXJkYmw9ODIxNDtlLmJyYWNlaHRpcGRvd25sZWZ0PTY1MDc5O2UuYnJhY2VodGlwZG93bnJpZ2h0PTY1MDc5O2UuYnJhY2VodGlwdXBsZWZ0PTY1MDgwO2UuYnJhY2VodGlwdXByaWdodD02NTA4MDtlLmJyYWNlbGVmdEJpZz0xMjM7ZS5icmFjZWxlZnRiaWc9MTIzO2UuYnJhY2VsZWZ0YmlnZz0xMjM7ZS5icmFjZWxlZnRCaWdnPTEyMztlLmJyYWNlcmlnaHRCaWc9MTI1O2UuYnJhY2VyaWdodGJpZz0xMjU7ZS5icmFjZXJpZ2h0YmlnZz0xMjU7ZS5icmFjZXJpZ2h0QmlnZz0xMjU7ZS5icmFja2V0bGVmdGJpZz05MTtlLmJyYWNrZXRsZWZ0QmlnPTkxO2UuYnJhY2tldGxlZnRiaWdnPTkxO2UuYnJhY2tldGxlZnRCaWdnPTkxO2UuYnJhY2tldHJpZ2h0QmlnPTkzO2UuYnJhY2tldHJpZ2h0YmlnPTkzO2UuYnJhY2tldHJpZ2h0YmlnZz05MztlLmJyYWNrZXRyaWdodEJpZ2c9OTM7ZS5jZWlsaW5nbGVmdGJpZz04OTY4O2UuY2VpbGluZ2xlZnRCaWc9ODk2ODtlLmNlaWxpbmdsZWZ0QmlnZz04OTY4O2UuY2VpbGluZ2xlZnRiaWdnPTg5Njg7ZS5jZWlsaW5ncmlnaHRiaWc9ODk2OTtlLmNlaWxpbmdyaWdodEJpZz04OTY5O2UuY2VpbGluZ3JpZ2h0YmlnZz04OTY5O2UuY2VpbGluZ3JpZ2h0QmlnZz04OTY5O2UuY2lyY2xlZG90ZGlzcGxheT04ODU3O2UuY2lyY2xlZG90dGV4dD04ODU3O2UuY2lyY2xlbXVsdGlwbHlkaXNwbGF5PTg4NTU7ZS5jaXJjbGVtdWx0aXBseXRleHQ9ODg1NTtlLmNpcmNsZXBsdXNkaXNwbGF5PTg4NTM7ZS5jaXJjbGVwbHVzdGV4dD04ODUzO2UuY29udGludGVncmFsZGlzcGxheT04NzUwO2UuY29udGludGVncmFsdGV4dD04NzUwO2UuY29wcm9kdWN0ZGlzcGxheT04NzIwO2UuY29wcm9kdWN0dGV4dD04NzIwO2UuZmxvb3JsZWZ0QmlnPTg5NzA7ZS5mbG9vcmxlZnRiaWc9ODk3MDtlLmZsb29ybGVmdGJpZ2c9ODk3MDtlLmZsb29ybGVmdEJpZ2c9ODk3MDtlLmZsb29ycmlnaHRiaWc9ODk3MTtlLmZsb29ycmlnaHRCaWc9ODk3MTtlLmZsb29ycmlnaHRCaWdnPTg5NzE7ZS5mbG9vcnJpZ2h0YmlnZz04OTcxO2UuaGF0d2lkZT03NzA7ZS5oYXR3aWRlcj03NzA7ZS5oYXR3aWRlc3Q9NzcwO2UuaW50ZXJjYWw9NzQ4ODtlLmludGVncmFsZGlzcGxheT04NzQ3O2UuaW50ZWdyYWx0ZXh0PTg3NDc7ZS5pbnRlcnNlY3Rpb25kaXNwbGF5PTg4OTg7ZS5pbnRlcnNlY3Rpb250ZXh0PTg4OTg7ZS5sb2dpY2FsYW5kZGlzcGxheT04NzQzO2UubG9naWNhbGFuZHRleHQ9ODc0MztlLmxvZ2ljYWxvcmRpc3BsYXk9ODc0NDtlLmxvZ2ljYWxvcnRleHQ9ODc0NDtlLnBhcmVubGVmdEJpZz00MDtlLnBhcmVubGVmdGJpZz00MDtlLnBhcmVubGVmdEJpZ2c9NDA7ZS5wYXJlbmxlZnRiaWdnPTQwO2UucGFyZW5yaWdodEJpZz00MTtlLnBhcmVucmlnaHRiaWc9NDE7ZS5wYXJlbnJpZ2h0QmlnZz00MTtlLnBhcmVucmlnaHRiaWdnPTQxO2UucHJpbWU9ODI0MjtlLnByb2R1Y3RkaXNwbGF5PTg3MTk7ZS5wcm9kdWN0dGV4dD04NzE5O2UucmFkaWNhbGJpZz04NzMwO2UucmFkaWNhbEJpZz04NzMwO2UucmFkaWNhbEJpZ2c9ODczMDtlLnJhZGljYWxiaWdnPTg3MzA7ZS5yYWRpY2FsYnQ9ODczMDtlLnJhZGljYWx0cD04NzMwO2UucmFkaWNhbHZlcnRleD04NzMwO2Uuc2xhc2hiaWc9NDc7ZS5zbGFzaEJpZz00NztlLnNsYXNoQmlnZz00NztlLnNsYXNoYmlnZz00NztlLnN1bW1hdGlvbmRpc3BsYXk9ODcyMTtlLnN1bW1hdGlvbnRleHQ9ODcyMTtlLnRpbGRld2lkZT03MzI7ZS50aWxkZXdpZGVyPTczMjtlLnRpbGRld2lkZXN0PTczMjtlLnVuaW9uZGlzcGxheT04ODk5O2UudW5pb25tdWx0aWRpc3BsYXk9ODg0NjtlLnVuaW9ubXVsdGl0ZXh0PTg4NDY7ZS51bmlvbnNxZGlzcGxheT04ODUyO2UudW5pb25zcXRleHQ9ODg1MjtlLnVuaW9udGV4dD04ODk5O2UudmV4dGVuZGRvdWJsZT04NzQxO2UudmV4dGVuZHNpbmdsZT04NzM5fSkscGE9Z2V0TG9va3VwVGFibGVGYWN0b3J5KGZ1bmN0aW9uKGUpe2Uuc3BhY2U9MzI7ZS5hMT05OTg1O2UuYTI9OTk4NjtlLmEyMDI9OTk4NztlLmEzPTk5ODg7ZS5hND05NzQyO2UuYTU9OTk5MDtlLmExMTk9OTk5MTtlLmExMTg9OTk5MjtlLmExMTc9OTk5MztlLmExMT05NzU1O2UuYTEyPTk3NTg7ZS5hMTM9OTk5NjtlLmExND05OTk3O2UuYTE1PTk5OTg7ZS5hMTY9OTk5OTtlLmExMDU9MWU0O2UuYTE3PTEwMDAxO2UuYTE4PTEwMDAyO2UuYTE5PTEwMDAzO2UuYTIwPTEwMDA0O2UuYTIxPTEwMDA1O2UuYTIyPTEwMDA2O2UuYTIzPTEwMDA3O2UuYTI0PTEwMDA4O2UuYTI1PTEwMDA5O2UuYTI2PTEwMDEwO2UuYTI3PTEwMDExO2UuYTI4PTEwMDEyO2UuYTY9MTAwMTM7ZS5hNz0xMDAxNDtlLmE4PTEwMDE1O2UuYTk9MTAwMTY7ZS5hMTA9MTAwMTc7ZS5hMjk9MTAwMTg7ZS5hMzA9MTAwMTk7ZS5hMzE9MTAwMjA7ZS5hMzI9MTAwMjE7ZS5hMzM9MTAwMjI7ZS5hMzQ9MTAwMjM7ZS5hMzU9OTczMztlLmEzNj0xMDAyNTtlLmEzNz0xMDAyNjtlLmEzOD0xMDAyNztlLmEzOT0xMDAyODtlLmE0MD0xMDAyOTtlLmE0MT0xMDAzMDtlLmE0Mj0xMDAzMTtlLmE0Mz0xMDAzMjtlLmE0ND0xMDAzMztlLmE0NT0xMDAzNDtlLmE0Nj0xMDAzNTtlLmE0Nz0xMDAzNjtlLmE0OD0xMDAzNztlLmE0OT0xMDAzODtlLmE1MD0xMDAzOTtlLmE1MT0xMDA0MDtlLmE1Mj0xMDA0MTtlLmE1Mz0xMDA0MjtlLmE1ND0xMDA0MztlLmE1NT0xMDA0NDtlLmE1Nj0xMDA0NTtlLmE1Nz0xMDA0NjtlLmE1OD0xMDA0NztlLmE1OT0xMDA0ODtlLmE2MD0xMDA0OTtlLmE2MT0xMDA1MDtlLmE2Mj0xMDA1MTtlLmE2Mz0xMDA1MjtlLmE2ND0xMDA1MztlLmE2NT0xMDA1NDtlLmE2Nj0xMDA1NTtlLmE2Nz0xMDA1NjtlLmE2OD0xMDA1NztlLmE2OT0xMDA1ODtlLmE3MD0xMDA1OTtlLmE3MT05Njc5O2UuYTcyPTEwMDYxO2UuYTczPTk2MzI7ZS5hNzQ9MTAwNjM7ZS5hMjAzPTEwMDY0O2UuYTc1PTEwMDY1O2UuYTIwND0xMDA2NjtlLmE3Nj05NjUwO2UuYTc3PTk2NjA7ZS5hNzg9OTY3MDtlLmE3OT0xMDA3MDtlLmE4MT05Njg3O2UuYTgyPTEwMDcyO2UuYTgzPTEwMDczO2UuYTg0PTEwMDc0O2UuYTk3PTEwMDc1O2UuYTk4PTEwMDc2O2UuYTk5PTEwMDc3O2UuYTEwMD0xMDA3ODtlLmExMDE9MTAwODE7ZS5hMTAyPTEwMDgyO2UuYTEwMz0xMDA4MztlLmExMDQ9MTAwODQ7ZS5hMTA2PTEwMDg1O2UuYTEwNz0xMDA4NjtlLmExMDg9MTAwODc7ZS5hMTEyPTk4Mjc7ZS5hMTExPTk4MzA7ZS5hMTEwPTk4Mjk7ZS5hMTA5PTk4MjQ7ZS5hMTIwPTkzMTI7ZS5hMTIxPTkzMTM7ZS5hMTIyPTkzMTQ7ZS5hMTIzPTkzMTU7ZS5hMTI0PTkzMTY7ZS5hMTI1PTkzMTc7ZS5hMTI2PTkzMTg7ZS5hMTI3PTkzMTk7ZS5hMTI4PTkzMjA7ZS5hMTI5PTkzMjE7ZS5hMTMwPTEwMTAyO2UuYTEzMT0xMDEwMztlLmExMzI9MTAxMDQ7ZS5hMTMzPTEwMTA1O2UuYTEzND0xMDEwNjtlLmExMzU9MTAxMDc7ZS5hMTM2PTEwMTA4O2UuYTEzNz0xMDEwOTtlLmExMzg9MTAxMTA7ZS5hMTM5PTEwMTExO2UuYTE0MD0xMDExMjtlLmExNDE9MTAxMTM7ZS5hMTQyPTEwMTE0O2UuYTE0Mz0xMDExNTtlLmExNDQ9MTAxMTY7ZS5hMTQ1PTEwMTE3O2UuYTE0Nj0xMDExODtlLmExNDc9MTAxMTk7ZS5hMTQ4PTEwMTIwO2UuYTE0OT0xMDEyMTtlLmExNTA9MTAxMjI7ZS5hMTUxPTEwMTIzO2UuYTE1Mj0xMDEyNDtlLmExNTM9MTAxMjU7ZS5hMTU0PTEwMTI2O2UuYTE1NT0xMDEyNztlLmExNTY9MTAxMjg7ZS5hMTU3PTEwMTI5O2UuYTE1OD0xMDEzMDtlLmExNTk9MTAxMzE7ZS5hMTYwPTEwMTMyO2UuYTE2MT04NTk0O2UuYTE2Mz04NTk2O2UuYTE2ND04NTk3O2UuYTE5Nj0xMDEzNjtlLmExNjU9MTAxMzc7ZS5hMTkyPTEwMTM4O2UuYTE2Nj0xMDEzOTtlLmExNjc9MTAxNDA7ZS5hMTY4PTEwMTQxO2UuYTE2OT0xMDE0MjtlLmExNzA9MTAxNDM7ZS5hMTcxPTEwMTQ0O2UuYTE3Mj0xMDE0NTtlLmExNzM9MTAxNDY7ZS5hMTYyPTEwMTQ3O2UuYTE3ND0xMDE0ODtlLmExNzU9MTAxNDk7ZS5hMTc2PTEwMTUwO2UuYTE3Nz0xMDE1MTtlLmExNzg9MTAxNTI7ZS5hMTc5PTEwMTUzO2UuYTE5Mz0xMDE1NDtlLmExODA9MTAxNTU7ZS5hMTk5PTEwMTU2O2UuYTE4MT0xMDE1NztlLmEyMDA9MTAxNTg7ZS5hMTgyPTEwMTU5O2UuYTIwMT0xMDE2MTtlLmExODM9MTAxNjI7ZS5hMTg0PTEwMTYzO2UuYTE5Nz0xMDE2NDtlLmExODU9MTAxNjU7ZS5hMTk0PTEwMTY2O2UuYTE5OD0xMDE2NztlLmExODY9MTAxNjg7ZS5hMTk1PTEwMTY5O2UuYTE4Nz0xMDE3MDtlLmExODg9MTAxNzE7ZS5hMTg5PTEwMTcyO2UuYTE5MD0xMDE3MztlLmExOTE9MTAxNzQ7ZS5hODk9MTAwODg7ZS5hOTA9MTAwODk7ZS5hOTM9MTAwOTA7ZS5hOTQ9MTAwOTE7ZS5hOTE9MTAwOTI7ZS5hOTI9MTAwOTM7ZS5hMjA1PTEwMDk0O2UuYTg1PTEwMDk1O2UuYTIwNj0xMDA5NjtlLmE4Nj0xMDA5NztlLmE4Nz0xMDA5ODtlLmE4OD0xMDA5OTtlLmE5NT0xMDEwMDtlLmE5Nj0xMDEwMTtlWyIubm90ZGVmIl09MH0pLG1hPWdldExvb2t1cFRhYmxlRmFjdG9yeShmdW5jdGlvbihlKXtlWzYzNzIxXT0xNjk7ZVs2MzE5M109MTY5O2VbNjM3MjBdPTE3NDtlWzYzMTk0XT0xNzQ7ZVs2MzcyMl09ODQ4MjtlWzYzMTk1XT04NDgyO2VbNjM3MjldPTkxMjc7ZVs2MzczMF09OTEyODtlWzYzNzMxXT05MTI5O2VbNjM3NDBdPTkxMzE7ZVs2Mzc0MV09OTEzMjtlWzYzNzQyXT05MTMzO2VbNjM3MjZdPTkxMjE7ZVs2MzcyN109OTEyMjtlWzYzNzI4XT05MTIzO2VbNjM3MzddPTkxMjQ7ZVs2MzczOF09OTEyNTtlWzYzNzM5XT05MTI2O2VbNjM3MjNdPTkxMTU7ZVs2MzcyNF09OTExNjtlWzYzNzI1XT05MTE3O2VbNjM3MzRdPTkxMTg7ZVs2MzczNV09OTExOTtlWzYzNzM2XT05MTIwfSk7ZnVuY3Rpb24gZ2V0VW5pY29kZUZvckdseXBoKGUsdCl7bGV0IHI9dFtlXTtpZih2b2lkIDAhPT1yKXJldHVybiByO2lmKCFlKXJldHVybi0xO2lmKCJ1Ij09PWVbMF0pe2NvbnN0IHQ9ZS5sZW5ndGg7bGV0IGE7aWYoNz09PXQmJiJuIj09PWVbMV0mJiJpIj09PWVbMl0pYT1lLnN1YnN0cmluZygzKTtlbHNle2lmKCEodD49NSYmdDw9NykpcmV0dXJuLTE7YT1lLnN1YnN0cmluZygxKX1pZihhPT09YS50b1VwcGVyQ2FzZSgpKXtyPXBhcnNlSW50KGEsMTYpO2lmKHI+PTApcmV0dXJuIHJ9fXJldHVybi0xfWNvbnN0IGJhPVtbMCwxMjddLFsxMjgsMjU1XSxbMjU2LDM4M10sWzM4NCw1OTFdLFs1OTIsNjg3LDc0MjQsNzU1MSw3NTUyLDc2MTVdLFs2ODgsNzY3LDQyNzUyLDQyNzgzXSxbNzY4LDg3OSw3NjE2LDc2NzldLFs4ODAsMTAyM10sWzExMzkyLDExNTE5XSxbMTAyNCwxMjc5LDEyODAsMTMyNywxMTc0NCwxMTc3NSw0MjU2MCw0MjY1NV0sWzEzMjgsMTQyM10sWzE0MjQsMTUzNV0sWzQyMjQwLDQyNTU5XSxbMTUzNiwxNzkxLDE4NzIsMTkxOV0sWzE5ODQsMjA0N10sWzIzMDQsMjQzMV0sWzI0MzIsMjU1OV0sWzI1NjAsMjY4N10sWzI2ODgsMjgxNV0sWzI4MTYsMjk0M10sWzI5NDQsMzA3MV0sWzMwNzIsMzE5OV0sWzMyMDAsMzMyN10sWzMzMjgsMzQ1NV0sWzM1ODQsMzcxMV0sWzM3MTIsMzgzOV0sWzQyNTYsNDM1MSwxMTUyMCwxMTU2N10sWzY5MTIsNzAzOV0sWzQzNTIsNDYwN10sWzc2ODAsNzkzNSwxMTM2MCwxMTM5MSw0Mjc4NCw0MzAwN10sWzc5MzYsODE5MV0sWzgxOTIsODMwMywxMTc3NiwxMTkwM10sWzgzMDQsODM1MV0sWzgzNTIsODM5OV0sWzg0MDAsODQ0N10sWzg0NDgsODUyN10sWzg1MjgsODU5MV0sWzg1OTIsODcwMywxMDIyNCwxMDIzOSwxMDQ5NiwxMDYyMywxMTAwOCwxMTI2M10sWzg3MDQsODk1OSwxMDc1MiwxMTAwNywxMDE3NiwxMDIyMywxMDYyNCwxMDc1MV0sWzg5NjAsOTIxNV0sWzkyMTYsOTI3OV0sWzkyODAsOTMxMV0sWzkzMTIsOTQ3MV0sWzk0NzIsOTU5OV0sWzk2MDAsOTYzMV0sWzk2MzIsOTcyN10sWzk3MjgsOTk4M10sWzk5ODQsMTAxNzVdLFsxMjI4OCwxMjM1MV0sWzEyMzUyLDEyNDQ3XSxbMTI0NDgsMTI1NDMsMTI3ODQsMTI3OTldLFsxMjU0NCwxMjU5MSwxMjcwNCwxMjczNV0sWzEyNTkyLDEyNjg3XSxbNDMwNzIsNDMxMzVdLFsxMjgwMCwxMzA1NV0sWzEzMDU2LDEzMzExXSxbNDQwMzIsNTUyMTVdLFs1NTI5Niw1NzM0M10sWzY3ODQwLDY3ODcxXSxbMTk5NjgsNDA5NTksMTE5MDQsMTIwMzEsMTIwMzIsMTIyNTUsMTIyNzIsMTIyODcsMTMzMTIsMTk5MDMsMTMxMDcyLDE3Mzc5MSwxMjY4OCwxMjcwM10sWzU3MzQ0LDYzNzQzXSxbMTI3MzYsMTI3ODMsNjM3NDQsNjQyNTUsMTk0NTYwLDE5NTEwM10sWzY0MjU2LDY0MzM1XSxbNjQzMzYsNjUwMjNdLFs2NTA1Niw2NTA3MV0sWzY1MDQwLDY1MDU1XSxbNjUxMDQsNjUxMzVdLFs2NTEzNiw2NTI3OV0sWzY1MjgwLDY1NTE5XSxbNjU1MjAsNjU1MzVdLFszODQwLDQwOTVdLFsxNzkyLDE4NzFdLFsxOTIwLDE5ODNdLFszNDU2LDM1ODNdLFs0MDk2LDQyNTVdLFs0NjA4LDQ5OTEsNDk5Miw1MDIzLDExNjQ4LDExNzQzXSxbNTAyNCw1MTE5XSxbNTEyMCw1NzU5XSxbNTc2MCw1NzkxXSxbNTc5Miw1ODg3XSxbNjAxNiw2MTQzXSxbNjE0NCw2MzE5XSxbMTAyNDAsMTA0OTVdLFs0MDk2MCw0MjEyN10sWzU4ODgsNTkxOSw1OTIwLDU5NTEsNTk1Miw1OTgzLDU5ODQsNjAxNV0sWzY2MzA0LDY2MzUxXSxbNjYzNTIsNjYzODNdLFs2NjU2MCw2NjYzOV0sWzExODc4NCwxMTkwMzksMTE5MDQwLDExOTI5NSwxMTkyOTYsMTE5Mzc1XSxbMTE5ODA4LDEyMDgzMV0sWzEwNDQ0ODAsMTA0ODU3M10sWzY1MDI0LDY1MDM5LDkxNzc2MCw5MTc5OTldLFs5MTc1MDQsOTE3NjMxXSxbNjQwMCw2NDc5XSxbNjQ4MCw2NTI3XSxbNjUyOCw2NjIzXSxbNjY1Niw2Njg3XSxbMTEyNjQsMTEzNTldLFsxMTU2OCwxMTY0N10sWzE5OTA0LDE5OTY3XSxbNDMwMDgsNDMwNTVdLFs2NTUzNiw2NTY2Myw2NTY2NCw2NTc5MSw2NTc5Miw2NTg1NV0sWzY1ODU2LDY1OTM1XSxbNjY0MzIsNjY0NjNdLFs2NjQ2NCw2NjUyN10sWzY2NjQwLDY2Njg3XSxbNjY2ODgsNjY3MzVdLFs2NzU4NCw2NzY0N10sWzY4MDk2LDY4MTkxXSxbMTE5NTUyLDExOTY0N10sWzczNzI4LDc0NzUxLDc0NzUyLDc0ODc5XSxbMTE5NjQ4LDExOTY3OV0sWzcwNDAsNzEwM10sWzcxNjgsNzI0N10sWzcyNDgsNzI5NV0sWzQzMTM2LDQzMjMxXSxbNDMyNjQsNDMzMTFdLFs0MzMxMiw0MzM1OV0sWzQzNTIwLDQzNjE1XSxbNjU5MzYsNjU5OTldLFs2NmUzLDY2MDQ3XSxbNjYyMDgsNjYyNzEsNjYxNzYsNjYyMDcsNjc4NzIsNjc5MDNdLFsxMjcwMjQsMTI3MTM1LDEyNjk3NiwxMjcwMjNdXTtmdW5jdGlvbiBnZXRVbmljb2RlUmFuZ2VGb3IoZSx0PS0xKXtpZigtMSE9PXQpe2NvbnN0IHI9YmFbdF07Zm9yKGxldCBhPTAsbj1yLmxlbmd0aDthPG47YSs9MilpZihlPj1yW2FdJiZlPD1yW2ErMV0pcmV0dXJuIHR9Zm9yKGxldCB0PTAscj1iYS5sZW5ndGg7dDxyO3QrKyl7Y29uc3Qgcj1iYVt0XTtmb3IobGV0IGE9MCxuPXIubGVuZ3RoO2E8bjthKz0yKWlmKGU+PXJbYV0mJmU8PXJbYSsxXSlyZXR1cm4gdH1yZXR1cm4tMX1jb25zdCB5YT1uZXcgUmVnRXhwKCJeKFxccyl8KFxccHtNbn0pfChcXHB7Q2Z9KSQiLCJ1Iiksd2E9bmV3IE1hcDtjb25zdCB4YT0hMCxTYT0xLEFhPTIsa2E9NCxDYT0zMix2YT1bIi5ub3RkZWYiLCIubnVsbCIsIm5vbm1hcmtpbmdyZXR1cm4iLCJzcGFjZSIsImV4Y2xhbSIsInF1b3RlZGJsIiwibnVtYmVyc2lnbiIsImRvbGxhciIsInBlcmNlbnQiLCJhbXBlcnNhbmQiLCJxdW90ZXNpbmdsZSIsInBhcmVubGVmdCIsInBhcmVucmlnaHQiLCJhc3RlcmlzayIsInBsdXMiLCJjb21tYSIsImh5cGhlbiIsInBlcmlvZCIsInNsYXNoIiwiemVybyIsIm9uZSIsInR3byIsInRocmVlIiwiZm91ciIsImZpdmUiLCJzaXgiLCJzZXZlbiIsImVpZ2h0IiwibmluZSIsImNvbG9uIiwic2VtaWNvbG9uIiwibGVzcyIsImVxdWFsIiwiZ3JlYXRlciIsInF1ZXN0aW9uIiwiYXQiLCJBIiwiQiIsIkMiLCJEIiwiRSIsIkYiLCJHIiwiSCIsIkkiLCJKIiwiSyIsIkwiLCJNIiwiTiIsIk8iLCJQIiwiUSIsIlIiLCJTIiwiVCIsIlUiLCJWIiwiVyIsIlgiLCJZIiwiWiIsImJyYWNrZXRsZWZ0IiwiYmFja3NsYXNoIiwiYnJhY2tldHJpZ2h0IiwiYXNjaWljaXJjdW0iLCJ1bmRlcnNjb3JlIiwiZ3JhdmUiLCJhIiwiYiIsImMiLCJkIiwiZSIsImYiLCJnIiwiaCIsImkiLCJqIiwiayIsImwiLCJtIiwibiIsIm8iLCJwIiwicSIsInIiLCJzIiwidCIsInUiLCJ2IiwidyIsIngiLCJ5IiwieiIsImJyYWNlbGVmdCIsImJhciIsImJyYWNlcmlnaHQiLCJhc2NpaXRpbGRlIiwiQWRpZXJlc2lzIiwiQXJpbmciLCJDY2VkaWxsYSIsIkVhY3V0ZSIsIk50aWxkZSIsIk9kaWVyZXNpcyIsIlVkaWVyZXNpcyIsImFhY3V0ZSIsImFncmF2ZSIsImFjaXJjdW1mbGV4IiwiYWRpZXJlc2lzIiwiYXRpbGRlIiwiYXJpbmciLCJjY2VkaWxsYSIsImVhY3V0ZSIsImVncmF2ZSIsImVjaXJjdW1mbGV4IiwiZWRpZXJlc2lzIiwiaWFjdXRlIiwiaWdyYXZlIiwiaWNpcmN1bWZsZXgiLCJpZGllcmVzaXMiLCJudGlsZGUiLCJvYWN1dGUiLCJvZ3JhdmUiLCJvY2lyY3VtZmxleCIsIm9kaWVyZXNpcyIsIm90aWxkZSIsInVhY3V0ZSIsInVncmF2ZSIsInVjaXJjdW1mbGV4IiwidWRpZXJlc2lzIiwiZGFnZ2VyIiwiZGVncmVlIiwiY2VudCIsInN0ZXJsaW5nIiwic2VjdGlvbiIsImJ1bGxldCIsInBhcmFncmFwaCIsImdlcm1hbmRibHMiLCJyZWdpc3RlcmVkIiwiY29weXJpZ2h0IiwidHJhZGVtYXJrIiwiYWN1dGUiLCJkaWVyZXNpcyIsIm5vdGVxdWFsIiwiQUUiLCJPc2xhc2giLCJpbmZpbml0eSIsInBsdXNtaW51cyIsImxlc3NlcXVhbCIsImdyZWF0ZXJlcXVhbCIsInllbiIsIm11IiwicGFydGlhbGRpZmYiLCJzdW1tYXRpb24iLCJwcm9kdWN0IiwicGkiLCJpbnRlZ3JhbCIsIm9yZGZlbWluaW5lIiwib3JkbWFzY3VsaW5lIiwiT21lZ2EiLCJhZSIsIm9zbGFzaCIsInF1ZXN0aW9uZG93biIsImV4Y2xhbWRvd24iLCJsb2dpY2Fsbm90IiwicmFkaWNhbCIsImZsb3JpbiIsImFwcHJveGVxdWFsIiwiRGVsdGEiLCJndWlsbGVtb3RsZWZ0IiwiZ3VpbGxlbW90cmlnaHQiLCJlbGxpcHNpcyIsIm5vbmJyZWFraW5nc3BhY2UiLCJBZ3JhdmUiLCJBdGlsZGUiLCJPdGlsZGUiLCJPRSIsIm9lIiwiZW5kYXNoIiwiZW1kYXNoIiwicXVvdGVkYmxsZWZ0IiwicXVvdGVkYmxyaWdodCIsInF1b3RlbGVmdCIsInF1b3RlcmlnaHQiLCJkaXZpZGUiLCJsb3plbmdlIiwieWRpZXJlc2lzIiwiWWRpZXJlc2lzIiwiZnJhY3Rpb24iLCJjdXJyZW5jeSIsImd1aWxzaW5nbGxlZnQiLCJndWlsc2luZ2xyaWdodCIsImZpIiwiZmwiLCJkYWdnZXJkYmwiLCJwZXJpb2RjZW50ZXJlZCIsInF1b3Rlc2luZ2xiYXNlIiwicXVvdGVkYmxiYXNlIiwicGVydGhvdXNhbmQiLCJBY2lyY3VtZmxleCIsIkVjaXJjdW1mbGV4IiwiQWFjdXRlIiwiRWRpZXJlc2lzIiwiRWdyYXZlIiwiSWFjdXRlIiwiSWNpcmN1bWZsZXgiLCJJZGllcmVzaXMiLCJJZ3JhdmUiLCJPYWN1dGUiLCJPY2lyY3VtZmxleCIsImFwcGxlIiwiT2dyYXZlIiwiVWFjdXRlIiwiVWNpcmN1bWZsZXgiLCJVZ3JhdmUiLCJkb3RsZXNzaSIsImNpcmN1bWZsZXgiLCJ0aWxkZSIsIm1hY3JvbiIsImJyZXZlIiwiZG90YWNjZW50IiwicmluZyIsImNlZGlsbGEiLCJodW5nYXJ1bWxhdXQiLCJvZ29uZWsiLCJjYXJvbiIsIkxzbGFzaCIsImxzbGFzaCIsIlNjYXJvbiIsInNjYXJvbiIsIlpjYXJvbiIsInpjYXJvbiIsImJyb2tlbmJhciIsIkV0aCIsImV0aCIsIllhY3V0ZSIsInlhY3V0ZSIsIlRob3JuIiwidGhvcm4iLCJtaW51cyIsIm11bHRpcGx5Iiwib25lc3VwZXJpb3IiLCJ0d29zdXBlcmlvciIsInRocmVlc3VwZXJpb3IiLCJvbmVoYWxmIiwib25lcXVhcnRlciIsInRocmVlcXVhcnRlcnMiLCJmcmFuYyIsIkdicmV2ZSIsImdicmV2ZSIsIklkb3RhY2NlbnQiLCJTY2VkaWxsYSIsInNjZWRpbGxhIiwiQ2FjdXRlIiwiY2FjdXRlIiwiQ2Nhcm9uIiwiY2Nhcm9uIiwiZGNyb2F0Il07ZnVuY3Rpb24gcmVjb3ZlckdseXBoTmFtZShlLHQpe2lmKHZvaWQgMCE9PXRbZV0pcmV0dXJuIGU7Y29uc3Qgcj1nZXRVbmljb2RlRm9yR2x5cGgoZSx0KTtpZigtMSE9PXIpZm9yKGNvbnN0IGUgaW4gdClpZih0W2VdPT09cilyZXR1cm4gZTtpbmZvKCJVbmFibGUgdG8gcmVjb3ZlciBhIHN0YW5kYXJkIGdseXBoIG5hbWUgZm9yOiAiK2UpO3JldHVybiBlfWZ1bmN0aW9uIHR5cGUxRm9udEdseXBoTWFwcGluZyhlLHQscil7Y29uc3QgYT1PYmplY3QuY3JlYXRlKG51bGwpO2xldCBuLGkscztjb25zdCBvPSEhKGUuZmxhZ3Mma2EpO2lmKGUuaXNJbnRlcm5hbEZvbnQpe3M9dDtmb3IoaT0wO2k8cy5sZW5ndGg7aSsrKXtuPXIuaW5kZXhPZihzW2ldKTthW2ldPW4+PTA/bjowfX1lbHNlIGlmKGUuYmFzZUVuY29kaW5nTmFtZSl7cz1nZXRFbmNvZGluZyhlLmJhc2VFbmNvZGluZ05hbWUpO2ZvcihpPTA7aTxzLmxlbmd0aDtpKyspe249ci5pbmRleE9mKHNbaV0pO2FbaV09bj49MD9uOjB9fWVsc2UgaWYobylmb3IoaSBpbiB0KWFbaV09dFtpXTtlbHNle3M9aGE7Zm9yKGk9MDtpPHMubGVuZ3RoO2krKyl7bj1yLmluZGV4T2Yoc1tpXSk7YVtpXT1uPj0wP246MH19Y29uc3QgYz1lLmRpZmZlcmVuY2VzO2xldCBsO2lmKGMpZm9yKGkgaW4gYyl7Y29uc3QgZT1jW2ldO249ci5pbmRleE9mKGUpO2lmKC0xPT09bil7bHx8KGw9Z2EoKSk7Y29uc3QgdD1yZWNvdmVyR2x5cGhOYW1lKGUsbCk7dCE9PWUmJihuPXIuaW5kZXhPZih0KSl9YVtpXT1uPj0wP246MH1yZXR1cm4gYX1mdW5jdGlvbiBub3JtYWxpemVGb250TmFtZShlKXtyZXR1cm4gZS5yZXBsYWNlQWxsKC9bLF9dL2csIi0iKS5yZXBsYWNlQWxsKC9ccy9nLCIiKX1jb25zdCBGYT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZT0+e2VbODIxMV09NjUwNzQ7ZVs4MjEyXT02NTA3MztlWzgyMjldPTY1MDcyO2VbODIzMF09NjUwNDk7ZVsxMjI4OV09NjUwNDE7ZVsxMjI5MF09NjUwNDI7ZVsxMjI5Nl09NjUwODc7ZVsxMjI5N109NjUwODg7ZVsxMjI5OF09NjUwODU7ZVsxMjI5OV09NjUwODY7ZVsxMjMwMF09NjUwODk7ZVsxMjMwMV09NjUwOTA7ZVsxMjMwMl09NjUwOTE7ZVsxMjMwM109NjUwOTI7ZVsxMjMwNF09NjUwODM7ZVsxMjMwNV09NjUwODQ7ZVsxMjMwOF09NjUwODE7ZVsxMjMwOV09NjUwODI7ZVsxMjMxMF09NjUwNDc7ZVsxMjMxMV09NjUwNDg7ZVs2NTEwM109NjUwNzY7ZVs2NTI4MV09NjUwNDU7ZVs2NTI4OF09NjUwNzc7ZVs2NTI4OV09NjUwNzg7ZVs2NTI5Ml09NjUwNDA7ZVs2NTMwNl09NjUwNDM7ZVs2NTMwN109NjUwNDQ7ZVs2NTMxMV09NjUwNDY7ZVs2NTMzOV09NjUwOTU7ZVs2NTM0MV09NjUwOTY7ZVs2NTM0M109NjUwNzU7ZVs2NTM3MV09NjUwNzk7ZVs2NTM3M109NjUwODB9KTtfX3dlYnBhY2tfcmVxdWlyZV9fKDE4MDYpO2NvbnN0IElhPVsiLm5vdGRlZiIsInNwYWNlIiwiZXhjbGFtIiwicXVvdGVkYmwiLCJudW1iZXJzaWduIiwiZG9sbGFyIiwicGVyY2VudCIsImFtcGVyc2FuZCIsInF1b3RlcmlnaHQiLCJwYXJlbmxlZnQiLCJwYXJlbnJpZ2h0IiwiYXN0ZXJpc2siLCJwbHVzIiwiY29tbWEiLCJoeXBoZW4iLCJwZXJpb2QiLCJzbGFzaCIsInplcm8iLCJvbmUiLCJ0d28iLCJ0aHJlZSIsImZvdXIiLCJmaXZlIiwic2l4Iiwic2V2ZW4iLCJlaWdodCIsIm5pbmUiLCJjb2xvbiIsInNlbWljb2xvbiIsImxlc3MiLCJlcXVhbCIsImdyZWF0ZXIiLCJxdWVzdGlvbiIsImF0IiwiQSIsIkIiLCJDIiwiRCIsIkUiLCJGIiwiRyIsIkgiLCJJIiwiSiIsIksiLCJMIiwiTSIsIk4iLCJPIiwiUCIsIlEiLCJSIiwiUyIsIlQiLCJVIiwiViIsIlciLCJYIiwiWSIsIloiLCJicmFja2V0bGVmdCIsImJhY2tzbGFzaCIsImJyYWNrZXRyaWdodCIsImFzY2lpY2lyY3VtIiwidW5kZXJzY29yZSIsInF1b3RlbGVmdCIsImEiLCJiIiwiYyIsImQiLCJlIiwiZiIsImciLCJoIiwiaSIsImoiLCJrIiwibCIsIm0iLCJuIiwibyIsInAiLCJxIiwiciIsInMiLCJ0IiwidSIsInYiLCJ3IiwieCIsInkiLCJ6IiwiYnJhY2VsZWZ0IiwiYmFyIiwiYnJhY2VyaWdodCIsImFzY2lpdGlsZGUiLCJleGNsYW1kb3duIiwiY2VudCIsInN0ZXJsaW5nIiwiZnJhY3Rpb24iLCJ5ZW4iLCJmbG9yaW4iLCJzZWN0aW9uIiwiY3VycmVuY3kiLCJxdW90ZXNpbmdsZSIsInF1b3RlZGJsbGVmdCIsImd1aWxsZW1vdGxlZnQiLCJndWlsc2luZ2xsZWZ0IiwiZ3VpbHNpbmdscmlnaHQiLCJmaSIsImZsIiwiZW5kYXNoIiwiZGFnZ2VyIiwiZGFnZ2VyZGJsIiwicGVyaW9kY2VudGVyZWQiLCJwYXJhZ3JhcGgiLCJidWxsZXQiLCJxdW90ZXNpbmdsYmFzZSIsInF1b3RlZGJsYmFzZSIsInF1b3RlZGJscmlnaHQiLCJndWlsbGVtb3RyaWdodCIsImVsbGlwc2lzIiwicGVydGhvdXNhbmQiLCJxdWVzdGlvbmRvd24iLCJncmF2ZSIsImFjdXRlIiwiY2lyY3VtZmxleCIsInRpbGRlIiwibWFjcm9uIiwiYnJldmUiLCJkb3RhY2NlbnQiLCJkaWVyZXNpcyIsInJpbmciLCJjZWRpbGxhIiwiaHVuZ2FydW1sYXV0Iiwib2dvbmVrIiwiY2Fyb24iLCJlbWRhc2giLCJBRSIsIm9yZGZlbWluaW5lIiwiTHNsYXNoIiwiT3NsYXNoIiwiT0UiLCJvcmRtYXNjdWxpbmUiLCJhZSIsImRvdGxlc3NpIiwibHNsYXNoIiwib3NsYXNoIiwib2UiLCJnZXJtYW5kYmxzIiwib25lc3VwZXJpb3IiLCJsb2dpY2Fsbm90IiwibXUiLCJ0cmFkZW1hcmsiLCJFdGgiLCJvbmVoYWxmIiwicGx1c21pbnVzIiwiVGhvcm4iLCJvbmVxdWFydGVyIiwiZGl2aWRlIiwiYnJva2VuYmFyIiwiZGVncmVlIiwidGhvcm4iLCJ0aHJlZXF1YXJ0ZXJzIiwidHdvc3VwZXJpb3IiLCJyZWdpc3RlcmVkIiwibWludXMiLCJldGgiLCJtdWx0aXBseSIsInRocmVlc3VwZXJpb3IiLCJjb3B5cmlnaHQiLCJBYWN1dGUiLCJBY2lyY3VtZmxleCIsIkFkaWVyZXNpcyIsIkFncmF2ZSIsIkFyaW5nIiwiQXRpbGRlIiwiQ2NlZGlsbGEiLCJFYWN1dGUiLCJFY2lyY3VtZmxleCIsIkVkaWVyZXNpcyIsIkVncmF2ZSIsIklhY3V0ZSIsIkljaXJjdW1mbGV4IiwiSWRpZXJlc2lzIiwiSWdyYXZlIiwiTnRpbGRlIiwiT2FjdXRlIiwiT2NpcmN1bWZsZXgiLCJPZGllcmVzaXMiLCJPZ3JhdmUiLCJPdGlsZGUiLCJTY2Fyb24iLCJVYWN1dGUiLCJVY2lyY3VtZmxleCIsIlVkaWVyZXNpcyIsIlVncmF2ZSIsIllhY3V0ZSIsIllkaWVyZXNpcyIsIlpjYXJvbiIsImFhY3V0ZSIsImFjaXJjdW1mbGV4IiwiYWRpZXJlc2lzIiwiYWdyYXZlIiwiYXJpbmciLCJhdGlsZGUiLCJjY2VkaWxsYSIsImVhY3V0ZSIsImVjaXJjdW1mbGV4IiwiZWRpZXJlc2lzIiwiZWdyYXZlIiwiaWFjdXRlIiwiaWNpcmN1bWZsZXgiLCJpZGllcmVzaXMiLCJpZ3JhdmUiLCJudGlsZGUiLCJvYWN1dGUiLCJvY2lyY3VtZmxleCIsIm9kaWVyZXNpcyIsIm9ncmF2ZSIsIm90aWxkZSIsInNjYXJvbiIsInVhY3V0ZSIsInVjaXJjdW1mbGV4IiwidWRpZXJlc2lzIiwidWdyYXZlIiwieWFjdXRlIiwieWRpZXJlc2lzIiwiemNhcm9uIl0sVGE9WyIubm90ZGVmIiwic3BhY2UiLCJleGNsYW1zbWFsbCIsIkh1bmdhcnVtbGF1dHNtYWxsIiwiZG9sbGFyb2xkc3R5bGUiLCJkb2xsYXJzdXBlcmlvciIsImFtcGVyc2FuZHNtYWxsIiwiQWN1dGVzbWFsbCIsInBhcmVubGVmdHN1cGVyaW9yIiwicGFyZW5yaWdodHN1cGVyaW9yIiwidHdvZG90ZW5sZWFkZXIiLCJvbmVkb3RlbmxlYWRlciIsImNvbW1hIiwiaHlwaGVuIiwicGVyaW9kIiwiZnJhY3Rpb24iLCJ6ZXJvb2xkc3R5bGUiLCJvbmVvbGRzdHlsZSIsInR3b29sZHN0eWxlIiwidGhyZWVvbGRzdHlsZSIsImZvdXJvbGRzdHlsZSIsImZpdmVvbGRzdHlsZSIsInNpeG9sZHN0eWxlIiwic2V2ZW5vbGRzdHlsZSIsImVpZ2h0b2xkc3R5bGUiLCJuaW5lb2xkc3R5bGUiLCJjb2xvbiIsInNlbWljb2xvbiIsImNvbW1hc3VwZXJpb3IiLCJ0aHJlZXF1YXJ0ZXJzZW1kYXNoIiwicGVyaW9kc3VwZXJpb3IiLCJxdWVzdGlvbnNtYWxsIiwiYXN1cGVyaW9yIiwiYnN1cGVyaW9yIiwiY2VudHN1cGVyaW9yIiwiZHN1cGVyaW9yIiwiZXN1cGVyaW9yIiwiaXN1cGVyaW9yIiwibHN1cGVyaW9yIiwibXN1cGVyaW9yIiwibnN1cGVyaW9yIiwib3N1cGVyaW9yIiwicnN1cGVyaW9yIiwic3N1cGVyaW9yIiwidHN1cGVyaW9yIiwiZmYiLCJmaSIsImZsIiwiZmZpIiwiZmZsIiwicGFyZW5sZWZ0aW5mZXJpb3IiLCJwYXJlbnJpZ2h0aW5mZXJpb3IiLCJDaXJjdW1mbGV4c21hbGwiLCJoeXBoZW5zdXBlcmlvciIsIkdyYXZlc21hbGwiLCJBc21hbGwiLCJCc21hbGwiLCJDc21hbGwiLCJEc21hbGwiLCJFc21hbGwiLCJGc21hbGwiLCJHc21hbGwiLCJIc21hbGwiLCJJc21hbGwiLCJKc21hbGwiLCJLc21hbGwiLCJMc21hbGwiLCJNc21hbGwiLCJOc21hbGwiLCJPc21hbGwiLCJQc21hbGwiLCJRc21hbGwiLCJSc21hbGwiLCJTc21hbGwiLCJUc21hbGwiLCJVc21hbGwiLCJWc21hbGwiLCJXc21hbGwiLCJYc21hbGwiLCJZc21hbGwiLCJac21hbGwiLCJjb2xvbm1vbmV0YXJ5Iiwib25lZml0dGVkIiwicnVwaWFoIiwiVGlsZGVzbWFsbCIsImV4Y2xhbWRvd25zbWFsbCIsImNlbnRvbGRzdHlsZSIsIkxzbGFzaHNtYWxsIiwiU2Nhcm9uc21hbGwiLCJaY2Fyb25zbWFsbCIsIkRpZXJlc2lzc21hbGwiLCJCcmV2ZXNtYWxsIiwiQ2Fyb25zbWFsbCIsIkRvdGFjY2VudHNtYWxsIiwiTWFjcm9uc21hbGwiLCJmaWd1cmVkYXNoIiwiaHlwaGVuaW5mZXJpb3IiLCJPZ29uZWtzbWFsbCIsIlJpbmdzbWFsbCIsIkNlZGlsbGFzbWFsbCIsIm9uZXF1YXJ0ZXIiLCJvbmVoYWxmIiwidGhyZWVxdWFydGVycyIsInF1ZXN0aW9uZG93bnNtYWxsIiwib25lZWlnaHRoIiwidGhyZWVlaWdodGhzIiwiZml2ZWVpZ2h0aHMiLCJzZXZlbmVpZ2h0aHMiLCJvbmV0aGlyZCIsInR3b3RoaXJkcyIsInplcm9zdXBlcmlvciIsIm9uZXN1cGVyaW9yIiwidHdvc3VwZXJpb3IiLCJ0aHJlZXN1cGVyaW9yIiwiZm91cnN1cGVyaW9yIiwiZml2ZXN1cGVyaW9yIiwic2l4c3VwZXJpb3IiLCJzZXZlbnN1cGVyaW9yIiwiZWlnaHRzdXBlcmlvciIsIm5pbmVzdXBlcmlvciIsInplcm9pbmZlcmlvciIsIm9uZWluZmVyaW9yIiwidHdvaW5mZXJpb3IiLCJ0aHJlZWluZmVyaW9yIiwiZm91cmluZmVyaW9yIiwiZml2ZWluZmVyaW9yIiwic2l4aW5mZXJpb3IiLCJzZXZlbmluZmVyaW9yIiwiZWlnaHRpbmZlcmlvciIsIm5pbmVpbmZlcmlvciIsImNlbnRpbmZlcmlvciIsImRvbGxhcmluZmVyaW9yIiwicGVyaW9kaW5mZXJpb3IiLCJjb21tYWluZmVyaW9yIiwiQWdyYXZlc21hbGwiLCJBYWN1dGVzbWFsbCIsIkFjaXJjdW1mbGV4c21hbGwiLCJBdGlsZGVzbWFsbCIsIkFkaWVyZXNpc3NtYWxsIiwiQXJpbmdzbWFsbCIsIkFFc21hbGwiLCJDY2VkaWxsYXNtYWxsIiwiRWdyYXZlc21hbGwiLCJFYWN1dGVzbWFsbCIsIkVjaXJjdW1mbGV4c21hbGwiLCJFZGllcmVzaXNzbWFsbCIsIklncmF2ZXNtYWxsIiwiSWFjdXRlc21hbGwiLCJJY2lyY3VtZmxleHNtYWxsIiwiSWRpZXJlc2lzc21hbGwiLCJFdGhzbWFsbCIsIk50aWxkZXNtYWxsIiwiT2dyYXZlc21hbGwiLCJPYWN1dGVzbWFsbCIsIk9jaXJjdW1mbGV4c21hbGwiLCJPdGlsZGVzbWFsbCIsIk9kaWVyZXNpc3NtYWxsIiwiT0VzbWFsbCIsIk9zbGFzaHNtYWxsIiwiVWdyYXZlc21hbGwiLCJVYWN1dGVzbWFsbCIsIlVjaXJjdW1mbGV4c21hbGwiLCJVZGllcmVzaXNzbWFsbCIsIllhY3V0ZXNtYWxsIiwiVGhvcm5zbWFsbCIsIllkaWVyZXNpc3NtYWxsIl0sT2E9WyIubm90ZGVmIiwic3BhY2UiLCJkb2xsYXJvbGRzdHlsZSIsImRvbGxhcnN1cGVyaW9yIiwicGFyZW5sZWZ0c3VwZXJpb3IiLCJwYXJlbnJpZ2h0c3VwZXJpb3IiLCJ0d29kb3RlbmxlYWRlciIsIm9uZWRvdGVubGVhZGVyIiwiY29tbWEiLCJoeXBoZW4iLCJwZXJpb2QiLCJmcmFjdGlvbiIsInplcm9vbGRzdHlsZSIsIm9uZW9sZHN0eWxlIiwidHdvb2xkc3R5bGUiLCJ0aHJlZW9sZHN0eWxlIiwiZm91cm9sZHN0eWxlIiwiZml2ZW9sZHN0eWxlIiwic2l4b2xkc3R5bGUiLCJzZXZlbm9sZHN0eWxlIiwiZWlnaHRvbGRzdHlsZSIsIm5pbmVvbGRzdHlsZSIsImNvbG9uIiwic2VtaWNvbG9uIiwiY29tbWFzdXBlcmlvciIsInRocmVlcXVhcnRlcnNlbWRhc2giLCJwZXJpb2RzdXBlcmlvciIsImFzdXBlcmlvciIsImJzdXBlcmlvciIsImNlbnRzdXBlcmlvciIsImRzdXBlcmlvciIsImVzdXBlcmlvciIsImlzdXBlcmlvciIsImxzdXBlcmlvciIsIm1zdXBlcmlvciIsIm5zdXBlcmlvciIsIm9zdXBlcmlvciIsInJzdXBlcmlvciIsInNzdXBlcmlvciIsInRzdXBlcmlvciIsImZmIiwiZmkiLCJmbCIsImZmaSIsImZmbCIsInBhcmVubGVmdGluZmVyaW9yIiwicGFyZW5yaWdodGluZmVyaW9yIiwiaHlwaGVuc3VwZXJpb3IiLCJjb2xvbm1vbmV0YXJ5Iiwib25lZml0dGVkIiwicnVwaWFoIiwiY2VudG9sZHN0eWxlIiwiZmlndXJlZGFzaCIsImh5cGhlbmluZmVyaW9yIiwib25lcXVhcnRlciIsIm9uZWhhbGYiLCJ0aHJlZXF1YXJ0ZXJzIiwib25lZWlnaHRoIiwidGhyZWVlaWdodGhzIiwiZml2ZWVpZ2h0aHMiLCJzZXZlbmVpZ2h0aHMiLCJvbmV0aGlyZCIsInR3b3RoaXJkcyIsInplcm9zdXBlcmlvciIsIm9uZXN1cGVyaW9yIiwidHdvc3VwZXJpb3IiLCJ0aHJlZXN1cGVyaW9yIiwiZm91cnN1cGVyaW9yIiwiZml2ZXN1cGVyaW9yIiwic2l4c3VwZXJpb3IiLCJzZXZlbnN1cGVyaW9yIiwiZWlnaHRzdXBlcmlvciIsIm5pbmVzdXBlcmlvciIsInplcm9pbmZlcmlvciIsIm9uZWluZmVyaW9yIiwidHdvaW5mZXJpb3IiLCJ0aHJlZWluZmVyaW9yIiwiZm91cmluZmVyaW9yIiwiZml2ZWluZmVyaW9yIiwic2l4aW5mZXJpb3IiLCJzZXZlbmluZmVyaW9yIiwiZWlnaHRpbmZlcmlvciIsIm5pbmVpbmZlcmlvciIsImNlbnRpbmZlcmlvciIsImRvbGxhcmluZmVyaW9yIiwicGVyaW9kaW5mZXJpb3IiLCJjb21tYWluZmVyaW9yIl0sTWE9WyIubm90ZGVmIiwic3BhY2UiLCJleGNsYW0iLCJxdW90ZWRibCIsIm51bWJlcnNpZ24iLCJkb2xsYXIiLCJwZXJjZW50IiwiYW1wZXJzYW5kIiwicXVvdGVyaWdodCIsInBhcmVubGVmdCIsInBhcmVucmlnaHQiLCJhc3RlcmlzayIsInBsdXMiLCJjb21tYSIsImh5cGhlbiIsInBlcmlvZCIsInNsYXNoIiwiemVybyIsIm9uZSIsInR3byIsInRocmVlIiwiZm91ciIsImZpdmUiLCJzaXgiLCJzZXZlbiIsImVpZ2h0IiwibmluZSIsImNvbG9uIiwic2VtaWNvbG9uIiwibGVzcyIsImVxdWFsIiwiZ3JlYXRlciIsInF1ZXN0aW9uIiwiYXQiLCJBIiwiQiIsIkMiLCJEIiwiRSIsIkYiLCJHIiwiSCIsIkkiLCJKIiwiSyIsIkwiLCJNIiwiTiIsIk8iLCJQIiwiUSIsIlIiLCJTIiwiVCIsIlUiLCJWIiwiVyIsIlgiLCJZIiwiWiIsImJyYWNrZXRsZWZ0IiwiYmFja3NsYXNoIiwiYnJhY2tldHJpZ2h0IiwiYXNjaWljaXJjdW0iLCJ1bmRlcnNjb3JlIiwicXVvdGVsZWZ0IiwiYSIsImIiLCJjIiwiZCIsImUiLCJmIiwiZyIsImgiLCJpIiwiaiIsImsiLCJsIiwibSIsIm4iLCJvIiwicCIsInEiLCJyIiwicyIsInQiLCJ1IiwidiIsInciLCJ4IiwieSIsInoiLCJicmFjZWxlZnQiLCJiYXIiLCJicmFjZXJpZ2h0IiwiYXNjaWl0aWxkZSIsImV4Y2xhbWRvd24iLCJjZW50Iiwic3RlcmxpbmciLCJmcmFjdGlvbiIsInllbiIsImZsb3JpbiIsInNlY3Rpb24iLCJjdXJyZW5jeSIsInF1b3Rlc2luZ2xlIiwicXVvdGVkYmxsZWZ0IiwiZ3VpbGxlbW90bGVmdCIsImd1aWxzaW5nbGxlZnQiLCJndWlsc2luZ2xyaWdodCIsImZpIiwiZmwiLCJlbmRhc2giLCJkYWdnZXIiLCJkYWdnZXJkYmwiLCJwZXJpb2RjZW50ZXJlZCIsInBhcmFncmFwaCIsImJ1bGxldCIsInF1b3Rlc2luZ2xiYXNlIiwicXVvdGVkYmxiYXNlIiwicXVvdGVkYmxyaWdodCIsImd1aWxsZW1vdHJpZ2h0IiwiZWxsaXBzaXMiLCJwZXJ0aG91c2FuZCIsInF1ZXN0aW9uZG93biIsImdyYXZlIiwiYWN1dGUiLCJjaXJjdW1mbGV4IiwidGlsZGUiLCJtYWNyb24iLCJicmV2ZSIsImRvdGFjY2VudCIsImRpZXJlc2lzIiwicmluZyIsImNlZGlsbGEiLCJodW5nYXJ1bWxhdXQiLCJvZ29uZWsiLCJjYXJvbiIsImVtZGFzaCIsIkFFIiwib3JkZmVtaW5pbmUiLCJMc2xhc2giLCJPc2xhc2giLCJPRSIsIm9yZG1hc2N1bGluZSIsImFlIiwiZG90bGVzc2kiLCJsc2xhc2giLCJvc2xhc2giLCJvZSIsImdlcm1hbmRibHMiLCJvbmVzdXBlcmlvciIsImxvZ2ljYWxub3QiLCJtdSIsInRyYWRlbWFyayIsIkV0aCIsIm9uZWhhbGYiLCJwbHVzbWludXMiLCJUaG9ybiIsIm9uZXF1YXJ0ZXIiLCJkaXZpZGUiLCJicm9rZW5iYXIiLCJkZWdyZWUiLCJ0aG9ybiIsInRocmVlcXVhcnRlcnMiLCJ0d29zdXBlcmlvciIsInJlZ2lzdGVyZWQiLCJtaW51cyIsImV0aCIsIm11bHRpcGx5IiwidGhyZWVzdXBlcmlvciIsImNvcHlyaWdodCIsIkFhY3V0ZSIsIkFjaXJjdW1mbGV4IiwiQWRpZXJlc2lzIiwiQWdyYXZlIiwiQXJpbmciLCJBdGlsZGUiLCJDY2VkaWxsYSIsIkVhY3V0ZSIsIkVjaXJjdW1mbGV4IiwiRWRpZXJlc2lzIiwiRWdyYXZlIiwiSWFjdXRlIiwiSWNpcmN1bWZsZXgiLCJJZGllcmVzaXMiLCJJZ3JhdmUiLCJOdGlsZGUiLCJPYWN1dGUiLCJPY2lyY3VtZmxleCIsIk9kaWVyZXNpcyIsIk9ncmF2ZSIsIk90aWxkZSIsIlNjYXJvbiIsIlVhY3V0ZSIsIlVjaXJjdW1mbGV4IiwiVWRpZXJlc2lzIiwiVWdyYXZlIiwiWWFjdXRlIiwiWWRpZXJlc2lzIiwiWmNhcm9uIiwiYWFjdXRlIiwiYWNpcmN1bWZsZXgiLCJhZGllcmVzaXMiLCJhZ3JhdmUiLCJhcmluZyIsImF0aWxkZSIsImNjZWRpbGxhIiwiZWFjdXRlIiwiZWNpcmN1bWZsZXgiLCJlZGllcmVzaXMiLCJlZ3JhdmUiLCJpYWN1dGUiLCJpY2lyY3VtZmxleCIsImlkaWVyZXNpcyIsImlncmF2ZSIsIm50aWxkZSIsIm9hY3V0ZSIsIm9jaXJjdW1mbGV4Iiwib2RpZXJlc2lzIiwib2dyYXZlIiwib3RpbGRlIiwic2Nhcm9uIiwidWFjdXRlIiwidWNpcmN1bWZsZXgiLCJ1ZGllcmVzaXMiLCJ1Z3JhdmUiLCJ5YWN1dGUiLCJ5ZGllcmVzaXMiLCJ6Y2Fyb24iLCJleGNsYW1zbWFsbCIsIkh1bmdhcnVtbGF1dHNtYWxsIiwiZG9sbGFyb2xkc3R5bGUiLCJkb2xsYXJzdXBlcmlvciIsImFtcGVyc2FuZHNtYWxsIiwiQWN1dGVzbWFsbCIsInBhcmVubGVmdHN1cGVyaW9yIiwicGFyZW5yaWdodHN1cGVyaW9yIiwidHdvZG90ZW5sZWFkZXIiLCJvbmVkb3RlbmxlYWRlciIsInplcm9vbGRzdHlsZSIsIm9uZW9sZHN0eWxlIiwidHdvb2xkc3R5bGUiLCJ0aHJlZW9sZHN0eWxlIiwiZm91cm9sZHN0eWxlIiwiZml2ZW9sZHN0eWxlIiwic2l4b2xkc3R5bGUiLCJzZXZlbm9sZHN0eWxlIiwiZWlnaHRvbGRzdHlsZSIsIm5pbmVvbGRzdHlsZSIsImNvbW1hc3VwZXJpb3IiLCJ0aHJlZXF1YXJ0ZXJzZW1kYXNoIiwicGVyaW9kc3VwZXJpb3IiLCJxdWVzdGlvbnNtYWxsIiwiYXN1cGVyaW9yIiwiYnN1cGVyaW9yIiwiY2VudHN1cGVyaW9yIiwiZHN1cGVyaW9yIiwiZXN1cGVyaW9yIiwiaXN1cGVyaW9yIiwibHN1cGVyaW9yIiwibXN1cGVyaW9yIiwibnN1cGVyaW9yIiwib3N1cGVyaW9yIiwicnN1cGVyaW9yIiwic3N1cGVyaW9yIiwidHN1cGVyaW9yIiwiZmYiLCJmZmkiLCJmZmwiLCJwYXJlbmxlZnRpbmZlcmlvciIsInBhcmVucmlnaHRpbmZlcmlvciIsIkNpcmN1bWZsZXhzbWFsbCIsImh5cGhlbnN1cGVyaW9yIiwiR3JhdmVzbWFsbCIsIkFzbWFsbCIsIkJzbWFsbCIsIkNzbWFsbCIsIkRzbWFsbCIsIkVzbWFsbCIsIkZzbWFsbCIsIkdzbWFsbCIsIkhzbWFsbCIsIklzbWFsbCIsIkpzbWFsbCIsIktzbWFsbCIsIkxzbWFsbCIsIk1zbWFsbCIsIk5zbWFsbCIsIk9zbWFsbCIsIlBzbWFsbCIsIlFzbWFsbCIsIlJzbWFsbCIsIlNzbWFsbCIsIlRzbWFsbCIsIlVzbWFsbCIsIlZzbWFsbCIsIldzbWFsbCIsIlhzbWFsbCIsIllzbWFsbCIsIlpzbWFsbCIsImNvbG9ubW9uZXRhcnkiLCJvbmVmaXR0ZWQiLCJydXBpYWgiLCJUaWxkZXNtYWxsIiwiZXhjbGFtZG93bnNtYWxsIiwiY2VudG9sZHN0eWxlIiwiTHNsYXNoc21hbGwiLCJTY2Fyb25zbWFsbCIsIlpjYXJvbnNtYWxsIiwiRGllcmVzaXNzbWFsbCIsIkJyZXZlc21hbGwiLCJDYXJvbnNtYWxsIiwiRG90YWNjZW50c21hbGwiLCJNYWNyb25zbWFsbCIsImZpZ3VyZWRhc2giLCJoeXBoZW5pbmZlcmlvciIsIk9nb25la3NtYWxsIiwiUmluZ3NtYWxsIiwiQ2VkaWxsYXNtYWxsIiwicXVlc3Rpb25kb3duc21hbGwiLCJvbmVlaWdodGgiLCJ0aHJlZWVpZ2h0aHMiLCJmaXZlZWlnaHRocyIsInNldmVuZWlnaHRocyIsIm9uZXRoaXJkIiwidHdvdGhpcmRzIiwiemVyb3N1cGVyaW9yIiwiZm91cnN1cGVyaW9yIiwiZml2ZXN1cGVyaW9yIiwic2l4c3VwZXJpb3IiLCJzZXZlbnN1cGVyaW9yIiwiZWlnaHRzdXBlcmlvciIsIm5pbmVzdXBlcmlvciIsInplcm9pbmZlcmlvciIsIm9uZWluZmVyaW9yIiwidHdvaW5mZXJpb3IiLCJ0aHJlZWluZmVyaW9yIiwiZm91cmluZmVyaW9yIiwiZml2ZWluZmVyaW9yIiwic2l4aW5mZXJpb3IiLCJzZXZlbmluZmVyaW9yIiwiZWlnaHRpbmZlcmlvciIsIm5pbmVpbmZlcmlvciIsImNlbnRpbmZlcmlvciIsImRvbGxhcmluZmVyaW9yIiwicGVyaW9kaW5mZXJpb3IiLCJjb21tYWluZmVyaW9yIiwiQWdyYXZlc21hbGwiLCJBYWN1dGVzbWFsbCIsIkFjaXJjdW1mbGV4c21hbGwiLCJBdGlsZGVzbWFsbCIsIkFkaWVyZXNpc3NtYWxsIiwiQXJpbmdzbWFsbCIsIkFFc21hbGwiLCJDY2VkaWxsYXNtYWxsIiwiRWdyYXZlc21hbGwiLCJFYWN1dGVzbWFsbCIsIkVjaXJjdW1mbGV4c21hbGwiLCJFZGllcmVzaXNzbWFsbCIsIklncmF2ZXNtYWxsIiwiSWFjdXRlc21hbGwiLCJJY2lyY3VtZmxleHNtYWxsIiwiSWRpZXJlc2lzc21hbGwiLCJFdGhzbWFsbCIsIk50aWxkZXNtYWxsIiwiT2dyYXZlc21hbGwiLCJPYWN1dGVzbWFsbCIsIk9jaXJjdW1mbGV4c21hbGwiLCJPdGlsZGVzbWFsbCIsIk9kaWVyZXNpc3NtYWxsIiwiT0VzbWFsbCIsIk9zbGFzaHNtYWxsIiwiVWdyYXZlc21hbGwiLCJVYWN1dGVzbWFsbCIsIlVjaXJjdW1mbGV4c21hbGwiLCJVZGllcmVzaXNzbWFsbCIsIllhY3V0ZXNtYWxsIiwiVGhvcm5zbWFsbCIsIllkaWVyZXNpc3NtYWxsIiwiMDAxLjAwMCIsIjAwMS4wMDEiLCIwMDEuMDAyIiwiMDAxLjAwMyIsIkJsYWNrIiwiQm9sZCIsIkJvb2siLCJMaWdodCIsIk1lZGl1bSIsIlJlZ3VsYXIiLCJSb21hbiIsIlNlbWlib2xkIl0sRGE9MzkxLEJhPVtudWxsLHtpZDoiaHN0ZW0iLG1pbjoyLHN0YWNrQ2xlYXJpbmc6ITAsc3RlbTohMH0sbnVsbCx7aWQ6InZzdGVtIixtaW46MixzdGFja0NsZWFyaW5nOiEwLHN0ZW06ITB9LHtpZDoidm1vdmV0byIsbWluOjEsc3RhY2tDbGVhcmluZzohMH0se2lkOiJybGluZXRvIixtaW46MixyZXNldFN0YWNrOiEwfSx7aWQ6ImhsaW5ldG8iLG1pbjoxLHJlc2V0U3RhY2s6ITB9LHtpZDoidmxpbmV0byIsbWluOjEscmVzZXRTdGFjazohMH0se2lkOiJycmN1cnZldG8iLG1pbjo2LHJlc2V0U3RhY2s6ITB9LG51bGwse2lkOiJjYWxsc3ViciIsbWluOjEsdW5kZWZTdGFjazohMH0se2lkOiJyZXR1cm4iLG1pbjowLHVuZGVmU3RhY2s6ITB9LG51bGwsbnVsbCx7aWQ6ImVuZGNoYXIiLG1pbjowLHN0YWNrQ2xlYXJpbmc6ITB9LG51bGwsbnVsbCxudWxsLHtpZDoiaHN0ZW1obSIsbWluOjIsc3RhY2tDbGVhcmluZzohMCxzdGVtOiEwfSx7aWQ6ImhpbnRtYXNrIixtaW46MCxzdGFja0NsZWFyaW5nOiEwfSx7aWQ6ImNudHJtYXNrIixtaW46MCxzdGFja0NsZWFyaW5nOiEwfSx7aWQ6InJtb3ZldG8iLG1pbjoyLHN0YWNrQ2xlYXJpbmc6ITB9LHtpZDoiaG1vdmV0byIsbWluOjEsc3RhY2tDbGVhcmluZzohMH0se2lkOiJ2c3RlbWhtIixtaW46MixzdGFja0NsZWFyaW5nOiEwLHN0ZW06ITB9LHtpZDoicmN1cnZlbGluZSIsbWluOjgscmVzZXRTdGFjazohMH0se2lkOiJybGluZWN1cnZlIixtaW46OCxyZXNldFN0YWNrOiEwfSx7aWQ6InZ2Y3VydmV0byIsbWluOjQscmVzZXRTdGFjazohMH0se2lkOiJoaGN1cnZldG8iLG1pbjo0LHJlc2V0U3RhY2s6ITB9LG51bGwse2lkOiJjYWxsZ3N1YnIiLG1pbjoxLHVuZGVmU3RhY2s6ITB9LHtpZDoidmhjdXJ2ZXRvIixtaW46NCxyZXNldFN0YWNrOiEwfSx7aWQ6Imh2Y3VydmV0byIsbWluOjQscmVzZXRTdGFjazohMH1dLFJhPVtudWxsLG51bGwsbnVsbCx7aWQ6ImFuZCIsbWluOjIsc3RhY2tEZWx0YTotMX0se2lkOiJvciIsbWluOjIsc3RhY2tEZWx0YTotMX0se2lkOiJub3QiLG1pbjoxLHN0YWNrRGVsdGE6MH0sbnVsbCxudWxsLG51bGwse2lkOiJhYnMiLG1pbjoxLHN0YWNrRGVsdGE6MH0se2lkOiJhZGQiLG1pbjoyLHN0YWNrRGVsdGE6LTEsc3RhY2tGbihlLHQpe2VbdC0yXT1lW3QtMl0rZVt0LTFdfX0se2lkOiJzdWIiLG1pbjoyLHN0YWNrRGVsdGE6LTEsc3RhY2tGbihlLHQpe2VbdC0yXT1lW3QtMl0tZVt0LTFdfX0se2lkOiJkaXYiLG1pbjoyLHN0YWNrRGVsdGE6LTEsc3RhY2tGbihlLHQpe2VbdC0yXT1lW3QtMl0vZVt0LTFdfX0sbnVsbCx7aWQ6Im5lZyIsbWluOjEsc3RhY2tEZWx0YTowLHN0YWNrRm4oZSx0KXtlW3QtMV09LWVbdC0xXX19LHtpZDoiZXEiLG1pbjoyLHN0YWNrRGVsdGE6LTF9LG51bGwsbnVsbCx7aWQ6ImRyb3AiLG1pbjoxLHN0YWNrRGVsdGE6LTF9LG51bGwse2lkOiJwdXQiLG1pbjoyLHN0YWNrRGVsdGE6LTJ9LHtpZDoiZ2V0IixtaW46MSxzdGFja0RlbHRhOjB9LHtpZDoiaWZlbHNlIixtaW46NCxzdGFja0RlbHRhOi0zfSx7aWQ6InJhbmRvbSIsbWluOjAsc3RhY2tEZWx0YToxfSx7aWQ6Im11bCIsbWluOjIsc3RhY2tEZWx0YTotMSxzdGFja0ZuKGUsdCl7ZVt0LTJdPWVbdC0yXSplW3QtMV19fSxudWxsLHtpZDoic3FydCIsbWluOjEsc3RhY2tEZWx0YTowfSx7aWQ6ImR1cCIsbWluOjEsc3RhY2tEZWx0YToxfSx7aWQ6ImV4Y2giLG1pbjoyLHN0YWNrRGVsdGE6MH0se2lkOiJpbmRleCIsbWluOjIsc3RhY2tEZWx0YTowfSx7aWQ6InJvbGwiLG1pbjozLHN0YWNrRGVsdGE6LTJ9LG51bGwsbnVsbCxudWxsLHtpZDoiaGZsZXgiLG1pbjo3LHJlc2V0U3RhY2s6ITB9LHtpZDoiZmxleCIsbWluOjEzLHJlc2V0U3RhY2s6ITB9LHtpZDoiaGZsZXgxIixtaW46OSxyZXNldFN0YWNrOiEwfSx7aWQ6ImZsZXgxIixtaW46MTEscmVzZXRTdGFjazohMH1dO2NsYXNzIENGRlBhcnNlcntjb25zdHJ1Y3RvcihlLHQscil7dGhpcy5ieXRlcz1lLmdldEJ5dGVzKCk7dGhpcy5wcm9wZXJ0aWVzPXQ7dGhpcy5zZWFjQW5hbHlzaXNFbmFibGVkPSEhcn1wYXJzZSgpe2NvbnN0IGU9dGhpcy5wcm9wZXJ0aWVzLHQ9bmV3IENGRjt0aGlzLmNmZj10O2NvbnN0IHI9dGhpcy5wYXJzZUhlYWRlcigpLGE9dGhpcy5wYXJzZUluZGV4KHIuZW5kUG9zKSxuPXRoaXMucGFyc2VJbmRleChhLmVuZFBvcyksaT10aGlzLnBhcnNlSW5kZXgobi5lbmRQb3MpLHM9dGhpcy5wYXJzZUluZGV4KGkuZW5kUG9zKSxvPXRoaXMucGFyc2VEaWN0KG4ub2JqLmdldCgwKSksYz10aGlzLmNyZWF0ZURpY3QoQ0ZGVG9wRGljdCxvLHQuc3RyaW5ncyk7dC5oZWFkZXI9ci5vYmo7dC5uYW1lcz10aGlzLnBhcnNlTmFtZUluZGV4KGEub2JqKTt0LnN0cmluZ3M9dGhpcy5wYXJzZVN0cmluZ0luZGV4KGkub2JqKTt0LnRvcERpY3Q9Yzt0Lmdsb2JhbFN1YnJJbmRleD1zLm9iajt0aGlzLnBhcnNlUHJpdmF0ZURpY3QodC50b3BEaWN0KTt0LmlzQ0lERm9udD1jLmhhc05hbWUoIlJPUyIpO2NvbnN0IGw9Yy5nZXRCeU5hbWUoIkNoYXJTdHJpbmdzIiksaD10aGlzLnBhcnNlSW5kZXgobCkub2JqLHU9Yy5nZXRCeU5hbWUoIkZvbnRNYXRyaXgiKTt1JiYoZS5mb250TWF0cml4PXUpO2NvbnN0IGQ9Yy5nZXRCeU5hbWUoIkZvbnRCQm94Iik7aWYoZCl7ZS5hc2NlbnQ9TWF0aC5tYXgoZFszXSxkWzFdKTtlLmRlc2NlbnQ9TWF0aC5taW4oZFsxXSxkWzNdKTtlLmFzY2VudFNjYWxlZD0hMH1sZXQgZixnO2lmKHQuaXNDSURGb250KXtjb25zdCBlPXRoaXMucGFyc2VJbmRleChjLmdldEJ5TmFtZSgiRkRBcnJheSIpKS5vYmo7Zm9yKGxldCByPTAsYT1lLmNvdW50O3I8YTsrK3Ipe2NvbnN0IGE9ZS5nZXQociksbj10aGlzLmNyZWF0ZURpY3QoQ0ZGVG9wRGljdCx0aGlzLnBhcnNlRGljdChhKSx0LnN0cmluZ3MpO3RoaXMucGFyc2VQcml2YXRlRGljdChuKTt0LmZkQXJyYXkucHVzaChuKX1nPW51bGw7Zj10aGlzLnBhcnNlQ2hhcnNldHMoYy5nZXRCeU5hbWUoImNoYXJzZXQiKSxoLmNvdW50LHQuc3RyaW5ncywhMCk7dC5mZFNlbGVjdD10aGlzLnBhcnNlRkRTZWxlY3QoYy5nZXRCeU5hbWUoIkZEU2VsZWN0IiksaC5jb3VudCl9ZWxzZXtmPXRoaXMucGFyc2VDaGFyc2V0cyhjLmdldEJ5TmFtZSgiY2hhcnNldCIpLGguY291bnQsdC5zdHJpbmdzLCExKTtnPXRoaXMucGFyc2VFbmNvZGluZyhjLmdldEJ5TmFtZSgiRW5jb2RpbmciKSxlLHQuc3RyaW5ncyxmLmNoYXJzZXQpfXQuY2hhcnNldD1mO3QuZW5jb2Rpbmc9Zztjb25zdCBwPXRoaXMucGFyc2VDaGFyU3RyaW5ncyh7Y2hhclN0cmluZ3M6aCxsb2NhbFN1YnJJbmRleDpjLnByaXZhdGVEaWN0LnN1YnJzSW5kZXgsZ2xvYmFsU3VickluZGV4OnMub2JqLGZkU2VsZWN0OnQuZmRTZWxlY3QsZmRBcnJheTp0LmZkQXJyYXkscHJpdmF0ZURpY3Q6Yy5wcml2YXRlRGljdH0pO3QuY2hhclN0cmluZ3M9cC5jaGFyU3RyaW5nczt0LnNlYWNzPXAuc2VhY3M7dC53aWR0aHM9cC53aWR0aHM7cmV0dXJuIHR9cGFyc2VIZWFkZXIoKXtsZXQgZT10aGlzLmJ5dGVzO2NvbnN0IHQ9ZS5sZW5ndGg7bGV0IHI9MDtmb3IoO3I8dCYmMSE9PWVbcl07KSsrcjtpZihyPj10KXRocm93IG5ldyBGb3JtYXRFcnJvcigiSW52YWxpZCBDRkYgaGVhZGVyIik7aWYoMCE9PXIpe2luZm8oImNmZiBkYXRhIGlzIHNoaWZ0ZWQiKTtlPWUuc3ViYXJyYXkocik7dGhpcy5ieXRlcz1lfWNvbnN0IGE9ZVswXSxuPWVbMV0saT1lWzJdLHM9ZVszXTtyZXR1cm57b2JqOm5ldyBDRkZIZWFkZXIoYSxuLGkscyksZW5kUG9zOml9fXBhcnNlRGljdChlKXtsZXQgdD0wO2Z1bmN0aW9uIHBhcnNlT3BlcmFuZCgpe2xldCByPWVbdCsrXTtpZigzMD09PXIpcmV0dXJuIGZ1bmN0aW9uIHBhcnNlRmxvYXRPcGVyYW5kKCl7bGV0IHI9IiI7Y29uc3QgYT0xNSxuPVsiMCIsIjEiLCIyIiwiMyIsIjQiLCI1IiwiNiIsIjciLCI4IiwiOSIsIi4iLCJFIiwiRS0iLG51bGwsIi0iXSxpPWUubGVuZ3RoO2Zvcig7dDxpOyl7Y29uc3QgaT1lW3QrK10scz1pPj40LG89MTUmaTtpZihzPT09YSlicmVhaztyKz1uW3NdO2lmKG89PT1hKWJyZWFrO3IrPW5bb119cmV0dXJuIHBhcnNlRmxvYXQocil9KCk7aWYoMjg9PT1yKXtyPXJlYWRJbnQxNihlLHQpO3QrPTI7cmV0dXJuIHJ9aWYoMjk9PT1yKXtyPWVbdCsrXTtyPXI8PDh8ZVt0KytdO3I9cjw8OHxlW3QrK107cj1yPDw4fGVbdCsrXTtyZXR1cm4gcn1pZihyPj0zMiYmcjw9MjQ2KXJldHVybiByLTEzOTtpZihyPj0yNDcmJnI8PTI1MClyZXR1cm4gMjU2KihyLTI0NykrZVt0KytdKzEwODtpZihyPj0yNTEmJnI8PTI1NClyZXR1cm4tMjU2KihyLTI1MSktZVt0KytdLTEwODt3YXJuKCdDRkZQYXJzZXJfcGFyc2VEaWN0OiAiJytyKyciIGlzIGEgcmVzZXJ2ZWQgY29tbWFuZC4nKTtyZXR1cm4gTmFOfWxldCByPVtdO2NvbnN0IGE9W107dD0wO2NvbnN0IG49ZS5sZW5ndGg7Zm9yKDt0PG47KXtsZXQgbj1lW3RdO2lmKG48PTIxKXsxMj09PW4mJihuPW48PDh8ZVsrK3RdKTthLnB1c2goW24scl0pO3I9W107Kyt0fWVsc2Ugci5wdXNoKHBhcnNlT3BlcmFuZCgpKX1yZXR1cm4gYX1wYXJzZUluZGV4KGUpe2NvbnN0IHQ9bmV3IENGRkluZGV4LHI9dGhpcy5ieXRlcyxhPXJbZSsrXTw8OHxyW2UrK10sbj1bXTtsZXQgaSxzLG89ZTtpZigwIT09YSl7Y29uc3QgdD1yW2UrK10sYz1lKyhhKzEpKnQtMTtmb3IoaT0wLHM9YSsxO2k8czsrK2kpe2xldCBhPTA7Zm9yKGxldCBuPTA7bjx0Oysrbil7YTw8PTg7YSs9cltlKytdfW4ucHVzaChjK2EpfW89blthXX1mb3IoaT0wLHM9bi5sZW5ndGgtMTtpPHM7KytpKXtjb25zdCBlPW5baV0sYT1uW2krMV07dC5hZGQoci5zdWJhcnJheShlLGEpKX1yZXR1cm57b2JqOnQsZW5kUG9zOm99fXBhcnNlTmFtZUluZGV4KGUpe2NvbnN0IHQ9W107Zm9yKGxldCByPTAsYT1lLmNvdW50O3I8YTsrK3Ipe2NvbnN0IGE9ZS5nZXQocik7dC5wdXNoKGJ5dGVzVG9TdHJpbmcoYSkpfXJldHVybiB0fXBhcnNlU3RyaW5nSW5kZXgoZSl7Y29uc3QgdD1uZXcgQ0ZGU3RyaW5ncztmb3IobGV0IHI9MCxhPWUuY291bnQ7cjxhOysrcil7Y29uc3QgYT1lLmdldChyKTt0LmFkZChieXRlc1RvU3RyaW5nKGEpKX1yZXR1cm4gdH1jcmVhdGVEaWN0KGUsdCxyKXtjb25zdCBhPW5ldyBlKHIpO2Zvcihjb25zdFtlLHJdb2YgdClhLnNldEJ5S2V5KGUscik7cmV0dXJuIGF9cGFyc2VDaGFyU3RyaW5nKGUsdCxyLGEpe2lmKCF0fHxlLmNhbGxEZXB0aD4xMClyZXR1cm4hMTtsZXQgbj1lLnN0YWNrU2l6ZTtjb25zdCBpPWUuc3RhY2s7bGV0IHM9dC5sZW5ndGg7Zm9yKGxldCBvPTA7bzxzOyl7Y29uc3QgYz10W28rK107bGV0IGw9bnVsbDtpZigxMj09PWMpe2NvbnN0IGU9dFtvKytdO2lmKDA9PT1lKXt0W28tMl09MTM5O3Rbby0xXT0yMjtuPTB9ZWxzZSBsPVJhW2VdfWVsc2UgaWYoMjg9PT1jKXtpW25dPXJlYWRJbnQxNih0LG8pO28rPTI7bisrfWVsc2UgaWYoMTQ9PT1jKXtpZihuPj00KXtuLT00O2lmKHRoaXMuc2VhY0FuYWx5c2lzRW5hYmxlZCl7ZS5zZWFjPWkuc2xpY2UobixuKzQpO3JldHVybiExfX1sPUJhW2NdfWVsc2UgaWYoYz49MzImJmM8PTI0Nil7aVtuXT1jLTEzOTtuKyt9ZWxzZSBpZihjPj0yNDcmJmM8PTI1NCl7aVtuXT1jPDI1MT8oYy0yNDc8PDgpK3Rbb10rMTA4Oi0oYy0yNTE8PDgpLXRbb10tMTA4O28rKztuKyt9ZWxzZSBpZigyNTU9PT1jKXtpW25dPSh0W29dPDwyNHx0W28rMV08PDE2fHRbbysyXTw8OHx0W28rM10pLzY1NTM2O28rPTQ7bisrfWVsc2UgaWYoMTk9PT1jfHwyMD09PWMpe2UuaGludHMrPW4+PjE7aWYoMD09PWUuaGludHMpe3QuY29weVdpdGhpbihvLTEsbywtMSk7by09MTtzLT0xO2NvbnRpbnVlfW8rPWUuaGludHMrNz4+MztuJT0yO2w9QmFbY119ZWxzZXtpZigxMD09PWN8fDI5PT09Yyl7Y29uc3QgdD0xMD09PWM/cjphO2lmKCF0KXtsPUJhW2NdO3dhcm4oIk1pc3Npbmcgc3VicnNJbmRleCBmb3IgIitsLmlkKTtyZXR1cm4hMX1sZXQgcz0zMjc2ODt0LmNvdW50PDEyNDA/cz0xMDc6dC5jb3VudDwzMzkwMCYmKHM9MTEzMSk7Y29uc3Qgbz1pWy0tbl0rcztpZihvPDB8fG8+PXQuY291bnR8fGlzTmFOKG8pKXtsPUJhW2NdO3dhcm4oIk91dCBvZiBib3VuZHMgc3VickluZGV4IGZvciAiK2wuaWQpO3JldHVybiExfWUuc3RhY2tTaXplPW47ZS5jYWxsRGVwdGgrKztpZighdGhpcy5wYXJzZUNoYXJTdHJpbmcoZSx0LmdldChvKSxyLGEpKXJldHVybiExO2UuY2FsbERlcHRoLS07bj1lLnN0YWNrU2l6ZTtjb250aW51ZX1pZigxMT09PWMpe2Uuc3RhY2tTaXplPW47cmV0dXJuITB9aWYoMD09PWMmJm89PT10Lmxlbmd0aCl7dFtvLTFdPTE0O2w9QmFbMTRdfWVsc2V7aWYoOT09PWMpe3QuY29weVdpdGhpbihvLTEsbywtMSk7by09MTtzLT0xO2NvbnRpbnVlfWw9QmFbY119fWlmKGwpe2lmKGwuc3RlbSl7ZS5oaW50cys9bj4+MTtpZigzPT09Y3x8MjM9PT1jKWUuaGFzVlN0ZW1zPSEwO2Vsc2UgaWYoZS5oYXNWU3RlbXMmJigxPT09Y3x8MTg9PT1jKSl7d2FybigiQ0ZGIHN0ZW0gaGludHMgYXJlIGluIHdyb25nIG9yZGVyIik7dFtvLTFdPTE9PT1jPzM6MjN9fWlmKCJtaW4iaW4gbCYmIWUudW5kZWZTdGFjayYmbjxsLm1pbil7d2FybigiTm90IGVub3VnaCBwYXJhbWV0ZXJzIGZvciAiK2wuaWQrIjsgYWN0dWFsOiAiK24rIiwgZXhwZWN0ZWQ6ICIrbC5taW4pO2lmKDA9PT1uKXt0W28tMV09MTQ7cmV0dXJuITB9cmV0dXJuITF9aWYoZS5maXJzdFN0YWNrQ2xlYXJpbmcmJmwuc3RhY2tDbGVhcmluZyl7ZS5maXJzdFN0YWNrQ2xlYXJpbmc9ITE7bi09bC5taW47bj49MiYmbC5zdGVtP24lPTI6bj4xJiZ3YXJuKCJGb3VuZCB0b28gbWFueSBwYXJhbWV0ZXJzIGZvciBzdGFjay1jbGVhcmluZyBjb21tYW5kIik7bj4wJiYoZS53aWR0aD1pW24tMV0pfWlmKCJzdGFja0RlbHRhImluIGwpeyJzdGFja0ZuImluIGwmJmwuc3RhY2tGbihpLG4pO24rPWwuc3RhY2tEZWx0YX1lbHNlIGlmKGwuc3RhY2tDbGVhcmluZyluPTA7ZWxzZSBpZihsLnJlc2V0U3RhY2spe249MDtlLnVuZGVmU3RhY2s9ITF9ZWxzZSBpZihsLnVuZGVmU3RhY2spe249MDtlLnVuZGVmU3RhY2s9ITA7ZS5maXJzdFN0YWNrQ2xlYXJpbmc9ITF9fX1zPHQubGVuZ3RoJiZ0LmZpbGwoMTQscyk7ZS5zdGFja1NpemU9bjtyZXR1cm4hMH1wYXJzZUNoYXJTdHJpbmdzKHtjaGFyU3RyaW5nczplLGxvY2FsU3VickluZGV4OnQsZ2xvYmFsU3VickluZGV4OnIsZmRTZWxlY3Q6YSxmZEFycmF5Om4scHJpdmF0ZURpY3Q6aX0pe2NvbnN0IHM9W10sbz1bXSxjPWUuY291bnQ7Zm9yKGxldCBsPTA7bDxjO2wrKyl7Y29uc3QgYz1lLmdldChsKSxoPXtjYWxsRGVwdGg6MCxzdGFja1NpemU6MCxzdGFjazpbXSx1bmRlZlN0YWNrOiEwLGhpbnRzOjAsZmlyc3RTdGFja0NsZWFyaW5nOiEwLHNlYWM6bnVsbCx3aWR0aDpudWxsLGhhc1ZTdGVtczohMX07bGV0IHU9ITAsZD1udWxsLGY9aTtpZihhJiZuLmxlbmd0aCl7Y29uc3QgZT1hLmdldEZESW5kZXgobCk7aWYoLTE9PT1lKXt3YXJuKCJHbHlwaCBpbmRleCBpcyBub3QgaW4gZmQgc2VsZWN0LiIpO3U9ITF9aWYoZT49bi5sZW5ndGgpe3dhcm4oIkludmFsaWQgZmQgaW5kZXggZm9yIGdseXBoIGluZGV4LiIpO3U9ITF9aWYodSl7Zj1uW2VdLnByaXZhdGVEaWN0O2Q9Zi5zdWJyc0luZGV4fX1lbHNlIHQmJihkPXQpO3UmJih1PXRoaXMucGFyc2VDaGFyU3RyaW5nKGgsYyxkLHIpKTtpZihudWxsIT09aC53aWR0aCl7Y29uc3QgZT1mLmdldEJ5TmFtZSgibm9taW5hbFdpZHRoWCIpO29bbF09ZStoLndpZHRofWVsc2V7Y29uc3QgZT1mLmdldEJ5TmFtZSgiZGVmYXVsdFdpZHRoWCIpO29bbF09ZX1udWxsIT09aC5zZWFjJiYoc1tsXT1oLnNlYWMpO3V8fGUuc2V0KGwsbmV3IFVpbnQ4QXJyYXkoWzE0XSkpfXJldHVybntjaGFyU3RyaW5nczplLHNlYWNzOnMsd2lkdGhzOm99fWVtcHR5UHJpdmF0ZURpY3Rpb25hcnkoZSl7Y29uc3QgdD10aGlzLmNyZWF0ZURpY3QoQ0ZGUHJpdmF0ZURpY3QsW10sZS5zdHJpbmdzKTtlLnNldEJ5S2V5KDE4LFswLDBdKTtlLnByaXZhdGVEaWN0PXR9cGFyc2VQcml2YXRlRGljdChlKXtpZighZS5oYXNOYW1lKCJQcml2YXRlIikpe3RoaXMuZW1wdHlQcml2YXRlRGljdGlvbmFyeShlKTtyZXR1cm59Y29uc3QgdD1lLmdldEJ5TmFtZSgiUHJpdmF0ZSIpO2lmKCFBcnJheS5pc0FycmF5KHQpfHwyIT09dC5sZW5ndGgpe2UucmVtb3ZlQnlOYW1lKCJQcml2YXRlIik7cmV0dXJufWNvbnN0IHI9dFswXSxhPXRbMV07aWYoMD09PXJ8fGE+PXRoaXMuYnl0ZXMubGVuZ3RoKXt0aGlzLmVtcHR5UHJpdmF0ZURpY3Rpb25hcnkoZSk7cmV0dXJufWNvbnN0IG49YStyLGk9dGhpcy5ieXRlcy5zdWJhcnJheShhLG4pLHM9dGhpcy5wYXJzZURpY3QoaSksbz10aGlzLmNyZWF0ZURpY3QoQ0ZGUHJpdmF0ZURpY3QscyxlLnN0cmluZ3MpO2UucHJpdmF0ZURpY3Q9bzswPT09by5nZXRCeU5hbWUoIkV4cGFuc2lvbkZhY3RvciIpJiZvLnNldEJ5TmFtZSgiRXhwYW5zaW9uRmFjdG9yIiwuMDYpO2lmKCFvLmdldEJ5TmFtZSgiU3VicnMiKSlyZXR1cm47Y29uc3QgYz1vLmdldEJ5TmFtZSgiU3VicnMiKSxsPWErYztpZigwPT09Y3x8bD49dGhpcy5ieXRlcy5sZW5ndGgpe3RoaXMuZW1wdHlQcml2YXRlRGljdGlvbmFyeShlKTtyZXR1cm59Y29uc3QgaD10aGlzLnBhcnNlSW5kZXgobCk7by5zdWJyc0luZGV4PWgub2JqfXBhcnNlQ2hhcnNldHMoZSx0LHIsYSl7aWYoMD09PWUpcmV0dXJuIG5ldyBDRkZDaGFyc2V0KCEwLFBhLklTT19BRE9CRSxJYSk7aWYoMT09PWUpcmV0dXJuIG5ldyBDRkZDaGFyc2V0KCEwLFBhLkVYUEVSVCxUYSk7aWYoMj09PWUpcmV0dXJuIG5ldyBDRkZDaGFyc2V0KCEwLFBhLkVYUEVSVF9TVUJTRVQsT2EpO2NvbnN0IG49dGhpcy5ieXRlcyxpPWUscz1uW2UrK10sbz1bYT8wOiIubm90ZGVmIl07bGV0IGMsbCxoO3QtPTE7c3dpdGNoKHMpe2Nhc2UgMDpmb3IoaD0wO2g8dDtoKyspe2M9bltlKytdPDw4fG5bZSsrXTtvLnB1c2goYT9jOnIuZ2V0KGMpKX1icmVhaztjYXNlIDE6Zm9yKDtvLmxlbmd0aDw9dDspe2M9bltlKytdPDw4fG5bZSsrXTtsPW5bZSsrXTtmb3IoaD0wO2g8PWw7aCsrKW8ucHVzaChhP2MrKzpyLmdldChjKyspKX1icmVhaztjYXNlIDI6Zm9yKDtvLmxlbmd0aDw9dDspe2M9bltlKytdPDw4fG5bZSsrXTtsPW5bZSsrXTw8OHxuW2UrK107Zm9yKGg9MDtoPD1sO2grKylvLnB1c2goYT9jKys6ci5nZXQoYysrKSl9YnJlYWs7ZGVmYXVsdDp0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlVua25vd24gY2hhcnNldCBmb3JtYXQiKX1jb25zdCB1PWUsZD1uLnN1YmFycmF5KGksdSk7cmV0dXJuIG5ldyBDRkZDaGFyc2V0KCExLHMsbyxkKX1wYXJzZUVuY29kaW5nKGUsdCxyLGEpe2NvbnN0IG49T2JqZWN0LmNyZWF0ZShudWxsKSxpPXRoaXMuYnl0ZXM7bGV0IHMsbyxjLGw9ITEsaD1udWxsO2lmKDA9PT1lfHwxPT09ZSl7bD0hMDtzPWU7Y29uc3QgdD1lP29hOmhhO2ZvcihvPTAsYz1hLmxlbmd0aDtvPGM7bysrKXtjb25zdCBlPXQuaW5kZXhPZihhW29dKTstMSE9PWUmJihuW2VdPW8pfX1lbHNle2NvbnN0IHQ9ZTtzPWlbZSsrXTtzd2l0Y2goMTI3JnMpe2Nhc2UgMDpjb25zdCB0PWlbZSsrXTtmb3Iobz0xO288PXQ7bysrKW5baVtlKytdXT1vO2JyZWFrO2Nhc2UgMTpjb25zdCByPWlbZSsrXTtsZXQgYT0xO2ZvcihvPTA7bzxyO28rKyl7Y29uc3QgdD1pW2UrK10scj1pW2UrK107Zm9yKGxldCBlPXQ7ZTw9dCtyO2UrKyluW2VdPWErK31icmVhaztkZWZhdWx0OnRocm93IG5ldyBGb3JtYXRFcnJvcihgVW5rbm93biBlbmNvZGluZyBmb3JtYXQ6ICR7c30gaW4gQ0ZGYCl9Y29uc3QgYz1lO2lmKDEyOCZzKXtpW3RdJj0xMjc7IWZ1bmN0aW9uIHJlYWRTdXBwbGVtZW50KCl7Y29uc3QgdD1pW2UrK107Zm9yKG89MDtvPHQ7bysrKXtjb25zdCB0PWlbZSsrXSxzPShpW2UrK108PDgpKygyNTUmaVtlKytdKTtuW3RdPWEuaW5kZXhPZihyLmdldChzKSl9fSgpfWg9aS5zdWJhcnJheSh0LGMpfXMmPTEyNztyZXR1cm4gbmV3IENGRkVuY29kaW5nKGwscyxuLGgpfXBhcnNlRkRTZWxlY3QoZSx0KXtjb25zdCByPXRoaXMuYnl0ZXMsYT1yW2UrK10sbj1bXTtsZXQgaTtzd2l0Y2goYSl7Y2FzZSAwOmZvcihpPTA7aTx0OysraSl7Y29uc3QgdD1yW2UrK107bi5wdXNoKHQpfWJyZWFrO2Nhc2UgMzpjb25zdCBzPXJbZSsrXTw8OHxyW2UrK107Zm9yKGk9MDtpPHM7KytpKXtsZXQgdD1yW2UrK108PDh8cltlKytdO2lmKDA9PT1pJiYwIT09dCl7d2FybigicGFyc2VGRFNlbGVjdDogVGhlIGZpcnN0IHJhbmdlIG11c3QgaGF2ZSBhIGZpcnN0IEdJRCBvZiAwIC0tIHRyeWluZyB0byByZWNvdmVyLiIpO3Q9MH1jb25zdCBhPXJbZSsrXSxzPXJbZV08PDh8cltlKzFdO2ZvcihsZXQgZT10O2U8czsrK2Upbi5wdXNoKGEpfWUrPTI7YnJlYWs7ZGVmYXVsdDp0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYHBhcnNlRkRTZWxlY3Q6IFVua25vd24gZm9ybWF0ICIke2F9Ii5gKX1pZihuLmxlbmd0aCE9PXQpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJwYXJzZUZEU2VsZWN0OiBJbnZhbGlkIGZvbnQgZGF0YS4iKTtyZXR1cm4gbmV3IENGRkZEU2VsZWN0KGEsbil9fWNsYXNzIENGRntjb25zdHJ1Y3Rvcigpe3RoaXMuaGVhZGVyPW51bGw7dGhpcy5uYW1lcz1bXTt0aGlzLnRvcERpY3Q9bnVsbDt0aGlzLnN0cmluZ3M9bmV3IENGRlN0cmluZ3M7dGhpcy5nbG9iYWxTdWJySW5kZXg9bnVsbDt0aGlzLmVuY29kaW5nPW51bGw7dGhpcy5jaGFyc2V0PW51bGw7dGhpcy5jaGFyU3RyaW5ncz1udWxsO3RoaXMuZmRBcnJheT1bXTt0aGlzLmZkU2VsZWN0PW51bGw7dGhpcy5pc0NJREZvbnQ9ITF9ZHVwbGljYXRlRmlyc3RHbHlwaCgpe2lmKHRoaXMuY2hhclN0cmluZ3MuY291bnQ+PTY1NTM1KXt3YXJuKCJOb3QgZW5vdWdoIHNwYWNlIGluIGNoYXJzdHJpbmdzIHRvIGR1cGxpY2F0ZSBmaXJzdCBnbHlwaC4iKTtyZXR1cm59Y29uc3QgZT10aGlzLmNoYXJTdHJpbmdzLmdldCgwKTt0aGlzLmNoYXJTdHJpbmdzLmFkZChlKTt0aGlzLmlzQ0lERm9udCYmdGhpcy5mZFNlbGVjdC5mZFNlbGVjdC5wdXNoKHRoaXMuZmRTZWxlY3QuZmRTZWxlY3RbMF0pfWhhc0dseXBoSWQoZSl7aWYoZTwwfHxlPj10aGlzLmNoYXJTdHJpbmdzLmNvdW50KXJldHVybiExO3JldHVybiB0aGlzLmNoYXJTdHJpbmdzLmdldChlKS5sZW5ndGg+MH19Y2xhc3MgQ0ZGSGVhZGVye2NvbnN0cnVjdG9yKGUsdCxyLGEpe3RoaXMubWFqb3I9ZTt0aGlzLm1pbm9yPXQ7dGhpcy5oZHJTaXplPXI7dGhpcy5vZmZTaXplPWF9fWNsYXNzIENGRlN0cmluZ3N7Y29uc3RydWN0b3IoKXt0aGlzLnN0cmluZ3M9W119Z2V0KGUpe3JldHVybiBlPj0wJiZlPD0zOTA/TWFbZV06ZS1EYTw9dGhpcy5zdHJpbmdzLmxlbmd0aD90aGlzLnN0cmluZ3NbZS1EYV06TWFbMF19Z2V0U0lEKGUpe2xldCB0PU1hLmluZGV4T2YoZSk7aWYoLTEhPT10KXJldHVybiB0O3Q9dGhpcy5zdHJpbmdzLmluZGV4T2YoZSk7cmV0dXJuLTEhPT10P3QrRGE6LTF9YWRkKGUpe3RoaXMuc3RyaW5ncy5wdXNoKGUpfWdldCBjb3VudCgpe3JldHVybiB0aGlzLnN0cmluZ3MubGVuZ3RofX1jbGFzcyBDRkZJbmRleHtjb25zdHJ1Y3Rvcigpe3RoaXMub2JqZWN0cz1bXTt0aGlzLmxlbmd0aD0wfWFkZChlKXt0aGlzLmxlbmd0aCs9ZS5sZW5ndGg7dGhpcy5vYmplY3RzLnB1c2goZSl9c2V0KGUsdCl7dGhpcy5sZW5ndGgrPXQubGVuZ3RoLXRoaXMub2JqZWN0c1tlXS5sZW5ndGg7dGhpcy5vYmplY3RzW2VdPXR9Z2V0KGUpe3JldHVybiB0aGlzLm9iamVjdHNbZV19Z2V0IGNvdW50KCl7cmV0dXJuIHRoaXMub2JqZWN0cy5sZW5ndGh9fWNsYXNzIENGRkRpY3R7Y29uc3RydWN0b3IoZSx0KXt0aGlzLmtleVRvTmFtZU1hcD1lLmtleVRvTmFtZU1hcDt0aGlzLm5hbWVUb0tleU1hcD1lLm5hbWVUb0tleU1hcDt0aGlzLmRlZmF1bHRzPWUuZGVmYXVsdHM7dGhpcy50eXBlcz1lLnR5cGVzO3RoaXMub3Bjb2Rlcz1lLm9wY29kZXM7dGhpcy5vcmRlcj1lLm9yZGVyO3RoaXMuc3RyaW5ncz10O3RoaXMudmFsdWVzPU9iamVjdC5jcmVhdGUobnVsbCl9c2V0QnlLZXkoZSx0KXtpZighKGUgaW4gdGhpcy5rZXlUb05hbWVNYXApKXJldHVybiExO2lmKDA9PT10Lmxlbmd0aClyZXR1cm4hMDtmb3IoY29uc3QgciBvZiB0KWlmKGlzTmFOKHIpKXt3YXJuKGBJbnZhbGlkIENGRkRpY3QgdmFsdWU6ICIke3R9IiBmb3Iga2V5ICIke2V9Ii5gKTtyZXR1cm4hMH1jb25zdCByPXRoaXMudHlwZXNbZV07Im51bSIhPT1yJiYic2lkIiE9PXImJiJvZmZzZXQiIT09cnx8KHQ9dFswXSk7dGhpcy52YWx1ZXNbZV09dDtyZXR1cm4hMH1zZXRCeU5hbWUoZSx0KXtpZighKGUgaW4gdGhpcy5uYW1lVG9LZXlNYXApKXRocm93IG5ldyBGb3JtYXRFcnJvcihgSW52YWxpZCBkaWN0aW9uYXJ5IG5hbWUgIiR7ZX0iYCk7dGhpcy52YWx1ZXNbdGhpcy5uYW1lVG9LZXlNYXBbZV1dPXR9aGFzTmFtZShlKXtyZXR1cm4gdGhpcy5uYW1lVG9LZXlNYXBbZV1pbiB0aGlzLnZhbHVlc31nZXRCeU5hbWUoZSl7aWYoIShlIGluIHRoaXMubmFtZVRvS2V5TWFwKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYEludmFsaWQgZGljdGlvbmFyeSBuYW1lICR7ZX0iYCk7Y29uc3QgdD10aGlzLm5hbWVUb0tleU1hcFtlXTtyZXR1cm4gdCBpbiB0aGlzLnZhbHVlcz90aGlzLnZhbHVlc1t0XTp0aGlzLmRlZmF1bHRzW3RdfXJlbW92ZUJ5TmFtZShlKXtkZWxldGUgdGhpcy52YWx1ZXNbdGhpcy5uYW1lVG9LZXlNYXBbZV1dfXN0YXRpYyBjcmVhdGVUYWJsZXMoZSl7Y29uc3QgdD17a2V5VG9OYW1lTWFwOnt9LG5hbWVUb0tleU1hcDp7fSxkZWZhdWx0czp7fSx0eXBlczp7fSxvcGNvZGVzOnt9LG9yZGVyOltdfTtmb3IoY29uc3QgciBvZiBlKXtjb25zdCBlPUFycmF5LmlzQXJyYXkoclswXSk/KHJbMF1bMF08PDgpK3JbMF1bMV06clswXTt0LmtleVRvTmFtZU1hcFtlXT1yWzFdO3QubmFtZVRvS2V5TWFwW3JbMV1dPWU7dC50eXBlc1tlXT1yWzJdO3QuZGVmYXVsdHNbZV09clszXTt0Lm9wY29kZXNbZV09QXJyYXkuaXNBcnJheShyWzBdKT9yWzBdOltyWzBdXTt0Lm9yZGVyLnB1c2goZSl9cmV0dXJuIHR9fWNvbnN0IEVhPVtbWzEyLDMwXSwiUk9TIixbInNpZCIsInNpZCIsIm51bSJdLG51bGxdLFtbMTIsMjBdLCJTeW50aGV0aWNCYXNlIiwibnVtIixudWxsXSxbMCwidmVyc2lvbiIsInNpZCIsbnVsbF0sWzEsIk5vdGljZSIsInNpZCIsbnVsbF0sW1sxMiwwXSwiQ29weXJpZ2h0Iiwic2lkIixudWxsXSxbMiwiRnVsbE5hbWUiLCJzaWQiLG51bGxdLFszLCJGYW1pbHlOYW1lIiwic2lkIixudWxsXSxbNCwiV2VpZ2h0Iiwic2lkIixudWxsXSxbWzEyLDFdLCJpc0ZpeGVkUGl0Y2giLCJudW0iLDBdLFtbMTIsMl0sIkl0YWxpY0FuZ2xlIiwibnVtIiwwXSxbWzEyLDNdLCJVbmRlcmxpbmVQb3NpdGlvbiIsIm51bSIsLTEwMF0sW1sxMiw0XSwiVW5kZXJsaW5lVGhpY2tuZXNzIiwibnVtIiw1MF0sW1sxMiw1XSwiUGFpbnRUeXBlIiwibnVtIiwwXSxbWzEyLDZdLCJDaGFyc3RyaW5nVHlwZSIsIm51bSIsMl0sW1sxMiw3XSwiRm9udE1hdHJpeCIsWyJudW0iLCJudW0iLCJudW0iLCJudW0iLCJudW0iLCJudW0iXSxbLjAwMSwwLDAsLjAwMSwwLDBdXSxbMTMsIlVuaXF1ZUlEIiwibnVtIixudWxsXSxbNSwiRm9udEJCb3giLFsibnVtIiwibnVtIiwibnVtIiwibnVtIl0sWzAsMCwwLDBdXSxbWzEyLDhdLCJTdHJva2VXaWR0aCIsIm51bSIsMF0sWzE0LCJYVUlEIiwiYXJyYXkiLG51bGxdLFsxNSwiY2hhcnNldCIsIm9mZnNldCIsMF0sWzE2LCJFbmNvZGluZyIsIm9mZnNldCIsMF0sWzE3LCJDaGFyU3RyaW5ncyIsIm9mZnNldCIsMF0sWzE4LCJQcml2YXRlIixbIm9mZnNldCIsIm9mZnNldCJdLG51bGxdLFtbMTIsMjFdLCJQb3N0U2NyaXB0Iiwic2lkIixudWxsXSxbWzEyLDIyXSwiQmFzZUZvbnROYW1lIiwic2lkIixudWxsXSxbWzEyLDIzXSwiQmFzZUZvbnRCbGVuZCIsImRlbHRhIixudWxsXSxbWzEyLDMxXSwiQ0lERm9udFZlcnNpb24iLCJudW0iLDBdLFtbMTIsMzJdLCJDSURGb250UmV2aXNpb24iLCJudW0iLDBdLFtbMTIsMzNdLCJDSURGb250VHlwZSIsIm51bSIsMF0sW1sxMiwzNF0sIkNJRENvdW50IiwibnVtIiw4NzIwXSxbWzEyLDM1XSwiVUlEQmFzZSIsIm51bSIsbnVsbF0sW1sxMiwzN10sIkZEU2VsZWN0Iiwib2Zmc2V0IixudWxsXSxbWzEyLDM2XSwiRkRBcnJheSIsIm9mZnNldCIsbnVsbF0sW1sxMiwzOF0sIkZvbnROYW1lIiwic2lkIixudWxsXV07Y2xhc3MgQ0ZGVG9wRGljdCBleHRlbmRzIENGRkRpY3R7c3RhdGljIGdldCB0YWJsZXMoKXtyZXR1cm4gc2hhZG93KHRoaXMsInRhYmxlcyIsdGhpcy5jcmVhdGVUYWJsZXMoRWEpKX1jb25zdHJ1Y3RvcihlKXtzdXBlcihDRkZUb3BEaWN0LnRhYmxlcyxlKTt0aGlzLnByaXZhdGVEaWN0PW51bGx9fWNvbnN0IE5hPVtbNiwiQmx1ZVZhbHVlcyIsImRlbHRhIixudWxsXSxbNywiT3RoZXJCbHVlcyIsImRlbHRhIixudWxsXSxbOCwiRmFtaWx5Qmx1ZXMiLCJkZWx0YSIsbnVsbF0sWzksIkZhbWlseU90aGVyQmx1ZXMiLCJkZWx0YSIsbnVsbF0sW1sxMiw5XSwiQmx1ZVNjYWxlIiwibnVtIiwuMDM5NjI1XSxbWzEyLDEwXSwiQmx1ZVNoaWZ0IiwibnVtIiw3XSxbWzEyLDExXSwiQmx1ZUZ1enoiLCJudW0iLDFdLFsxMCwiU3RkSFciLCJudW0iLG51bGxdLFsxMSwiU3RkVlciLCJudW0iLG51bGxdLFtbMTIsMTJdLCJTdGVtU25hcEgiLCJkZWx0YSIsbnVsbF0sW1sxMiwxM10sIlN0ZW1TbmFwViIsImRlbHRhIixudWxsXSxbWzEyLDE0XSwiRm9yY2VCb2xkIiwibnVtIiwwXSxbWzEyLDE3XSwiTGFuZ3VhZ2VHcm91cCIsIm51bSIsMF0sW1sxMiwxOF0sIkV4cGFuc2lvbkZhY3RvciIsIm51bSIsLjA2XSxbWzEyLDE5XSwiaW5pdGlhbFJhbmRvbVNlZWQiLCJudW0iLDBdLFsyMCwiZGVmYXVsdFdpZHRoWCIsIm51bSIsMF0sWzIxLCJub21pbmFsV2lkdGhYIiwibnVtIiwwXSxbMTksIlN1YnJzIiwib2Zmc2V0IixudWxsXV07Y2xhc3MgQ0ZGUHJpdmF0ZURpY3QgZXh0ZW5kcyBDRkZEaWN0e3N0YXRpYyBnZXQgdGFibGVzKCl7cmV0dXJuIHNoYWRvdyh0aGlzLCJ0YWJsZXMiLHRoaXMuY3JlYXRlVGFibGVzKE5hKSl9Y29uc3RydWN0b3IoZSl7c3VwZXIoQ0ZGUHJpdmF0ZURpY3QudGFibGVzLGUpO3RoaXMuc3VicnNJbmRleD1udWxsfX1jb25zdCBQYT17SVNPX0FET0JFOjAsRVhQRVJUOjEsRVhQRVJUX1NVQlNFVDoyfTtjbGFzcyBDRkZDaGFyc2V0e2NvbnN0cnVjdG9yKGUsdCxyLGEpe3RoaXMucHJlZGVmaW5lZD1lO3RoaXMuZm9ybWF0PXQ7dGhpcy5jaGFyc2V0PXI7dGhpcy5yYXc9YX19Y2xhc3MgQ0ZGRW5jb2Rpbmd7Y29uc3RydWN0b3IoZSx0LHIsYSl7dGhpcy5wcmVkZWZpbmVkPWU7dGhpcy5mb3JtYXQ9dDt0aGlzLmVuY29kaW5nPXI7dGhpcy5yYXc9YX19Y2xhc3MgQ0ZGRkRTZWxlY3R7Y29uc3RydWN0b3IoZSx0KXt0aGlzLmZvcm1hdD1lO3RoaXMuZmRTZWxlY3Q9dH1nZXRGREluZGV4KGUpe3JldHVybiBlPDB8fGU+PXRoaXMuZmRTZWxlY3QubGVuZ3RoPy0xOnRoaXMuZmRTZWxlY3RbZV19fWNsYXNzIENGRk9mZnNldFRyYWNrZXJ7Y29uc3RydWN0b3IoKXt0aGlzLm9mZnNldHM9T2JqZWN0LmNyZWF0ZShudWxsKX1pc1RyYWNraW5nKGUpe3JldHVybiBlIGluIHRoaXMub2Zmc2V0c310cmFjayhlLHQpe2lmKGUgaW4gdGhpcy5vZmZzZXRzKXRocm93IG5ldyBGb3JtYXRFcnJvcihgQWxyZWFkeSB0cmFja2luZyBsb2NhdGlvbiBvZiAke2V9YCk7dGhpcy5vZmZzZXRzW2VdPXR9b2Zmc2V0KGUpe2Zvcihjb25zdCB0IGluIHRoaXMub2Zmc2V0cyl0aGlzLm9mZnNldHNbdF0rPWV9c2V0RW50cnlMb2NhdGlvbihlLHQscil7aWYoIShlIGluIHRoaXMub2Zmc2V0cykpdGhyb3cgbmV3IEZvcm1hdEVycm9yKGBOb3QgdHJhY2tpbmcgbG9jYXRpb24gb2YgJHtlfWApO2NvbnN0IGE9ci5kYXRhLG49dGhpcy5vZmZzZXRzW2VdO2ZvcihsZXQgZT0wLHI9dC5sZW5ndGg7ZTxyOysrZSl7Y29uc3Qgcj01KmUrbixpPXIrMSxzPXIrMixvPXIrMyxjPXIrNDtpZigyOSE9PWFbcl18fDAhPT1hW2ldfHwwIT09YVtzXXx8MCE9PWFbb118fDAhPT1hW2NdKXRocm93IG5ldyBGb3JtYXRFcnJvcigid3JpdGluZyB0byBhbiBvZmZzZXQgdGhhdCBpcyBub3QgZW1wdHkiKTtjb25zdCBsPXRbZV07YVtyXT0yOTthW2ldPWw+PjI0JjI1NTthW3NdPWw+PjE2JjI1NTthW29dPWw+PjgmMjU1O2FbY109MjU1Jmx9fX1jbGFzcyBDRkZDb21waWxlcntjb25zdHJ1Y3RvcihlKXt0aGlzLmNmZj1lfWNvbXBpbGUoKXtjb25zdCBlPXRoaXMuY2ZmLHQ9e2RhdGE6W10sbGVuZ3RoOjAsYWRkKGUpe3RyeXt0aGlzLmRhdGEucHVzaCguLi5lKX1jYXRjaHt0aGlzLmRhdGE9dGhpcy5kYXRhLmNvbmNhdChlKX10aGlzLmxlbmd0aD10aGlzLmRhdGEubGVuZ3RofX0scj10aGlzLmNvbXBpbGVIZWFkZXIoZS5oZWFkZXIpO3QuYWRkKHIpO2NvbnN0IGE9dGhpcy5jb21waWxlTmFtZUluZGV4KGUubmFtZXMpO3QuYWRkKGEpO2lmKGUuaXNDSURGb250JiZlLnRvcERpY3QuaGFzTmFtZSgiRm9udE1hdHJpeCIpKXtjb25zdCB0PWUudG9wRGljdC5nZXRCeU5hbWUoIkZvbnRNYXRyaXgiKTtlLnRvcERpY3QucmVtb3ZlQnlOYW1lKCJGb250TWF0cml4Iik7Zm9yKGNvbnN0IHIgb2YgZS5mZEFycmF5KXtsZXQgZT10LnNsaWNlKDApO3IuaGFzTmFtZSgiRm9udE1hdHJpeCIpJiYoZT1VdGlsLnRyYW5zZm9ybShlLHIuZ2V0QnlOYW1lKCJGb250TWF0cml4IikpKTtyLnNldEJ5TmFtZSgiRm9udE1hdHJpeCIsZSl9fWNvbnN0IG49ZS50b3BEaWN0LmdldEJ5TmFtZSgiWFVJRCIpO24/Lmxlbmd0aD4xNiYmZS50b3BEaWN0LnJlbW92ZUJ5TmFtZSgiWFVJRCIpO2UudG9wRGljdC5zZXRCeU5hbWUoImNoYXJzZXQiLDApO2xldCBpPXRoaXMuY29tcGlsZVRvcERpY3RzKFtlLnRvcERpY3RdLHQubGVuZ3RoLGUuaXNDSURGb250KTt0LmFkZChpLm91dHB1dCk7Y29uc3Qgcz1pLnRyYWNrZXJzWzBdLG89dGhpcy5jb21waWxlU3RyaW5nSW5kZXgoZS5zdHJpbmdzLnN0cmluZ3MpO3QuYWRkKG8pO2NvbnN0IGM9dGhpcy5jb21waWxlSW5kZXgoZS5nbG9iYWxTdWJySW5kZXgpO3QuYWRkKGMpO2lmKGUuZW5jb2RpbmcmJmUudG9wRGljdC5oYXNOYW1lKCJFbmNvZGluZyIpKWlmKGUuZW5jb2RpbmcucHJlZGVmaW5lZClzLnNldEVudHJ5TG9jYXRpb24oIkVuY29kaW5nIixbZS5lbmNvZGluZy5mb3JtYXRdLHQpO2Vsc2V7Y29uc3Qgcj10aGlzLmNvbXBpbGVFbmNvZGluZyhlLmVuY29kaW5nKTtzLnNldEVudHJ5TG9jYXRpb24oIkVuY29kaW5nIixbdC5sZW5ndGhdLHQpO3QuYWRkKHIpfWNvbnN0IGw9dGhpcy5jb21waWxlQ2hhcnNldChlLmNoYXJzZXQsZS5jaGFyU3RyaW5ncy5jb3VudCxlLnN0cmluZ3MsZS5pc0NJREZvbnQpO3Muc2V0RW50cnlMb2NhdGlvbigiY2hhcnNldCIsW3QubGVuZ3RoXSx0KTt0LmFkZChsKTtjb25zdCBoPXRoaXMuY29tcGlsZUNoYXJTdHJpbmdzKGUuY2hhclN0cmluZ3MpO3Muc2V0RW50cnlMb2NhdGlvbigiQ2hhclN0cmluZ3MiLFt0Lmxlbmd0aF0sdCk7dC5hZGQoaCk7aWYoZS5pc0NJREZvbnQpe3Muc2V0RW50cnlMb2NhdGlvbigiRkRTZWxlY3QiLFt0Lmxlbmd0aF0sdCk7Y29uc3Qgcj10aGlzLmNvbXBpbGVGRFNlbGVjdChlLmZkU2VsZWN0KTt0LmFkZChyKTtpPXRoaXMuY29tcGlsZVRvcERpY3RzKGUuZmRBcnJheSx0Lmxlbmd0aCwhMCk7cy5zZXRFbnRyeUxvY2F0aW9uKCJGREFycmF5IixbdC5sZW5ndGhdLHQpO3QuYWRkKGkub3V0cHV0KTtjb25zdCBhPWkudHJhY2tlcnM7dGhpcy5jb21waWxlUHJpdmF0ZURpY3RzKGUuZmRBcnJheSxhLHQpfXRoaXMuY29tcGlsZVByaXZhdGVEaWN0cyhbZS50b3BEaWN0XSxbc10sdCk7dC5hZGQoWzBdKTtyZXR1cm4gdC5kYXRhfWVuY29kZU51bWJlcihlKXtyZXR1cm4gTnVtYmVyLmlzSW50ZWdlcihlKT90aGlzLmVuY29kZUludGVnZXIoZSk6dGhpcy5lbmNvZGVGbG9hdChlKX1zdGF0aWMgZ2V0IEVuY29kZUZsb2F0UmVnRXhwKCl7cmV0dXJuIHNoYWRvdyh0aGlzLCJFbmNvZGVGbG9hdFJlZ0V4cCIsL1wuKFxkKj8pKD86OXs1LDIwfXwwezUsMjB9KVxkezAsMn0oPzplKC4rKXwkKS8pfWVuY29kZUZsb2F0KGUpe2xldCB0PWUudG9TdHJpbmcoKTtjb25zdCByPUNGRkNvbXBpbGVyLkVuY29kZUZsb2F0UmVnRXhwLmV4ZWModCk7aWYocil7Y29uc3QgYT1wYXJzZUZsb2F0KCIxZSIrKChyWzJdPytyWzJdOjApK3JbMV0ubGVuZ3RoKSk7dD0oTWF0aC5yb3VuZChlKmEpL2EpLnRvU3RyaW5nKCl9bGV0IGEsbixpPSIiO2ZvcihhPTAsbj10Lmxlbmd0aDthPG47KythKXtjb25zdCBlPXRbYV07aSs9ImUiPT09ZT8iLSI9PT10WysrYV0/ImMiOiJiIjoiLiI9PT1lPyJhIjoiLSI9PT1lPyJlIjplfWkrPTEmaS5sZW5ndGg/ImYiOiJmZiI7Y29uc3Qgcz1bMzBdO2ZvcihhPTAsbj1pLmxlbmd0aDthPG47YSs9MilzLnB1c2gocGFyc2VJbnQoaS5zdWJzdHJpbmcoYSxhKzIpLDE2KSk7cmV0dXJuIHN9ZW5jb2RlSW50ZWdlcihlKXtsZXQgdDt0PWU+PS0xMDcmJmU8PTEwNz9bZSsxMzldOmU+PTEwOCYmZTw9MTEzMT9bMjQ3KygoZS09MTA4KT4+OCksMjU1JmVdOmU+PS0xMTMxJiZlPD0tMTA4P1syNTErKChlPS1lLTEwOCk+PjgpLDI1NSZlXTplPj0tMzI3NjgmJmU8PTMyNzY3P1syOCxlPj44JjI1NSwyNTUmZV06WzI5LGU+PjI0JjI1NSxlPj4xNiYyNTUsZT4+OCYyNTUsMjU1JmVdO3JldHVybiB0fWNvbXBpbGVIZWFkZXIoZSl7cmV0dXJuW2UubWFqb3IsZS5taW5vciw0LGUub2ZmU2l6ZV19Y29tcGlsZU5hbWVJbmRleChlKXtjb25zdCB0PW5ldyBDRkZJbmRleDtmb3IoY29uc3QgciBvZiBlKXtjb25zdCBlPU1hdGgubWluKHIubGVuZ3RoLDEyNyk7bGV0IGE9bmV3IEFycmF5KGUpO2ZvcihsZXQgdD0wO3Q8ZTt0Kyspe2xldCBlPXJbdF07KGU8IiEifHxlPiJ+Inx8IlsiPT09ZXx8Il0iPT09ZXx8IigiPT09ZXx8IikiPT09ZXx8InsiPT09ZXx8In0iPT09ZXx8IjwiPT09ZXx8Ij4iPT09ZXx8Ii8iPT09ZXx8IiUiPT09ZSkmJihlPSJfIik7YVt0XT1lfWE9YS5qb2luKCIiKTsiIj09PWEmJihhPSJCYWRfRm9udF9OYW1lIik7dC5hZGQoc3RyaW5nVG9CeXRlcyhhKSl9cmV0dXJuIHRoaXMuY29tcGlsZUluZGV4KHQpfWNvbXBpbGVUb3BEaWN0cyhlLHQscil7Y29uc3QgYT1bXTtsZXQgbj1uZXcgQ0ZGSW5kZXg7Zm9yKGNvbnN0IGkgb2YgZSl7aWYocil7aS5yZW1vdmVCeU5hbWUoIkNJREZvbnRWZXJzaW9uIik7aS5yZW1vdmVCeU5hbWUoIkNJREZvbnRSZXZpc2lvbiIpO2kucmVtb3ZlQnlOYW1lKCJDSURGb250VHlwZSIpO2kucmVtb3ZlQnlOYW1lKCJDSURDb3VudCIpO2kucmVtb3ZlQnlOYW1lKCJVSURCYXNlIil9Y29uc3QgZT1uZXcgQ0ZGT2Zmc2V0VHJhY2tlcixzPXRoaXMuY29tcGlsZURpY3QoaSxlKTthLnB1c2goZSk7bi5hZGQocyk7ZS5vZmZzZXQodCl9bj10aGlzLmNvbXBpbGVJbmRleChuLGEpO3JldHVybnt0cmFja2VyczphLG91dHB1dDpufX1jb21waWxlUHJpdmF0ZURpY3RzKGUsdCxyKXtmb3IobGV0IGE9MCxuPWUubGVuZ3RoO2E8bjsrK2Epe2NvbnN0IG49ZVthXSxpPW4ucHJpdmF0ZURpY3Q7aWYoIWl8fCFuLmhhc05hbWUoIlByaXZhdGUiKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlRoZXJlIG11c3QgYmUgYSBwcml2YXRlIGRpY3Rpb25hcnkuIik7Y29uc3Qgcz1uZXcgQ0ZGT2Zmc2V0VHJhY2tlcixvPXRoaXMuY29tcGlsZURpY3QoaSxzKTtsZXQgYz1yLmxlbmd0aDtzLm9mZnNldChjKTtvLmxlbmd0aHx8KGM9MCk7dFthXS5zZXRFbnRyeUxvY2F0aW9uKCJQcml2YXRlIixbby5sZW5ndGgsY10scik7ci5hZGQobyk7aWYoaS5zdWJyc0luZGV4JiZpLmhhc05hbWUoIlN1YnJzIikpe2NvbnN0IGU9dGhpcy5jb21waWxlSW5kZXgoaS5zdWJyc0luZGV4KTtzLnNldEVudHJ5TG9jYXRpb24oIlN1YnJzIixbby5sZW5ndGhdLHIpO3IuYWRkKGUpfX19Y29tcGlsZURpY3QoZSx0KXtjb25zdCByPVtdO2Zvcihjb25zdCBhIG9mIGUub3JkZXIpe2lmKCEoYSBpbiBlLnZhbHVlcykpY29udGludWU7bGV0IG49ZS52YWx1ZXNbYV0saT1lLnR5cGVzW2FdO0FycmF5LmlzQXJyYXkoaSl8fChpPVtpXSk7QXJyYXkuaXNBcnJheShuKXx8KG49W25dKTtpZigwIT09bi5sZW5ndGgpe2ZvcihsZXQgcz0wLG89aS5sZW5ndGg7czxvOysrcyl7Y29uc3Qgbz1pW3NdLGM9bltzXTtzd2l0Y2gobyl7Y2FzZSJudW0iOmNhc2Uic2lkIjpyLnB1c2goLi4udGhpcy5lbmNvZGVOdW1iZXIoYykpO2JyZWFrO2Nhc2Uib2Zmc2V0Ijpjb25zdCBpPWUua2V5VG9OYW1lTWFwW2FdO3QuaXNUcmFja2luZyhpKXx8dC50cmFjayhpLHIubGVuZ3RoKTtyLnB1c2goMjksMCwwLDAsMCk7YnJlYWs7Y2FzZSJhcnJheSI6Y2FzZSJkZWx0YSI6ci5wdXNoKC4uLnRoaXMuZW5jb2RlTnVtYmVyKGMpKTtmb3IobGV0IGU9MSx0PW4ubGVuZ3RoO2U8dDsrK2Upci5wdXNoKC4uLnRoaXMuZW5jb2RlTnVtYmVyKG5bZV0pKTticmVhaztkZWZhdWx0OnRocm93IG5ldyBGb3JtYXRFcnJvcihgVW5rbm93biBkYXRhIHR5cGUgb2YgJHtvfWApfX1yLnB1c2goLi4uZS5vcGNvZGVzW2FdKX19cmV0dXJuIHJ9Y29tcGlsZVN0cmluZ0luZGV4KGUpe2NvbnN0IHQ9bmV3IENGRkluZGV4O2Zvcihjb25zdCByIG9mIGUpdC5hZGQoc3RyaW5nVG9CeXRlcyhyKSk7cmV0dXJuIHRoaXMuY29tcGlsZUluZGV4KHQpfWNvbXBpbGVDaGFyU3RyaW5ncyhlKXtjb25zdCB0PW5ldyBDRkZJbmRleDtmb3IobGV0IHI9MDtyPGUuY291bnQ7cisrKXtjb25zdCBhPWUuZ2V0KHIpOzAhPT1hLmxlbmd0aD90LmFkZChhKTp0LmFkZChuZXcgVWludDhBcnJheShbMTM5LDE0XSkpfXJldHVybiB0aGlzLmNvbXBpbGVJbmRleCh0KX1jb21waWxlQ2hhcnNldChlLHQscixhKXtsZXQgbjtjb25zdCBpPXQtMTtpZihhKXtjb25zdCBlPWktMTtuPW5ldyBVaW50OEFycmF5KFsyLDAsMSxlPj44JjI1NSwyNTUmZV0pfWVsc2V7bj1uZXcgVWludDhBcnJheSgxKzIqaSk7blswXT0wO2xldCB0PTA7Y29uc3QgYT1lLmNoYXJzZXQubGVuZ3RoO2xldCBzPSExO2ZvcihsZXQgaT0xO2k8bi5sZW5ndGg7aSs9Mil7bGV0IG89MDtpZih0PGEpe2NvbnN0IGE9ZS5jaGFyc2V0W3QrK107bz1yLmdldFNJRChhKTtpZigtMT09PW8pe289MDtpZighcyl7cz0hMDt3YXJuKGBDb3VsZG4ndCBmaW5kICR7YX0gaW4gQ0ZGIHN0cmluZ3NgKX19fW5baV09bz4+OCYyNTU7bltpKzFdPTI1NSZvfX1yZXR1cm4gdGhpcy5jb21waWxlVHlwZWRBcnJheShuKX1jb21waWxlRW5jb2RpbmcoZSl7cmV0dXJuIHRoaXMuY29tcGlsZVR5cGVkQXJyYXkoZS5yYXcpfWNvbXBpbGVGRFNlbGVjdChlKXtjb25zdCB0PWUuZm9ybWF0O2xldCByLGE7c3dpdGNoKHQpe2Nhc2UgMDpyPW5ldyBVaW50OEFycmF5KDErZS5mZFNlbGVjdC5sZW5ndGgpO3JbMF09dDtmb3IoYT0wO2E8ZS5mZFNlbGVjdC5sZW5ndGg7YSsrKXJbYSsxXT1lLmZkU2VsZWN0W2FdO2JyZWFrO2Nhc2UgMzpjb25zdCBuPTA7bGV0IGk9ZS5mZFNlbGVjdFswXTtjb25zdCBzPVt0LDAsMCxuPj44JjI1NSwyNTUmbixpXTtmb3IoYT0xO2E8ZS5mZFNlbGVjdC5sZW5ndGg7YSsrKXtjb25zdCB0PWUuZmRTZWxlY3RbYV07aWYodCE9PWkpe3MucHVzaChhPj44JjI1NSwyNTUmYSx0KTtpPXR9fWNvbnN0IG89KHMubGVuZ3RoLTMpLzM7c1sxXT1vPj44JjI1NTtzWzJdPTI1NSZvO3MucHVzaChhPj44JjI1NSwyNTUmYSk7cj1uZXcgVWludDhBcnJheShzKX1yZXR1cm4gdGhpcy5jb21waWxlVHlwZWRBcnJheShyKX1jb21waWxlVHlwZWRBcnJheShlKXtyZXR1cm4gQXJyYXkuZnJvbShlKX1jb21waWxlSW5kZXgoZSx0PVtdKXtjb25zdCByPWUub2JqZWN0cyxhPXIubGVuZ3RoO2lmKDA9PT1hKXJldHVyblswLDBdO2NvbnN0IG49W2E+PjgmMjU1LDI1NSZhXTtsZXQgaSxzLG89MTtmb3IoaT0wO2k8YTsrK2kpbys9cltpXS5sZW5ndGg7cz1vPDI1Nj8xOm88NjU1MzY/MjpvPDE2Nzc3MjE2PzM6NDtuLnB1c2gocyk7bGV0IGM9MTtmb3IoaT0wO2k8YSsxO2krKyl7MT09PXM/bi5wdXNoKDI1NSZjKToyPT09cz9uLnB1c2goYz4+OCYyNTUsMjU1JmMpOjM9PT1zP24ucHVzaChjPj4xNiYyNTUsYz4+OCYyNTUsMjU1JmMpOm4ucHVzaChjPj4+MjQmMjU1LGM+PjE2JjI1NSxjPj44JjI1NSwyNTUmYyk7cltpXSYmKGMrPXJbaV0ubGVuZ3RoKX1mb3IoaT0wO2k8YTtpKyspe3RbaV0mJnRbaV0ub2Zmc2V0KG4ubGVuZ3RoKTtuLnB1c2goLi4ucltpXSl9cmV0dXJuIG59fWNvbnN0IF9hPWdldExvb2t1cFRhYmxlRmFjdG9yeShmdW5jdGlvbihlKXtlWyJUaW1lcy1Sb21hbiJdPSJUaW1lcy1Sb21hbiI7ZS5IZWx2ZXRpY2E9IkhlbHZldGljYSI7ZS5Db3VyaWVyPSJDb3VyaWVyIjtlLlN5bWJvbD0iU3ltYm9sIjtlWyJUaW1lcy1Cb2xkIl09IlRpbWVzLUJvbGQiO2VbIkhlbHZldGljYS1Cb2xkIl09IkhlbHZldGljYS1Cb2xkIjtlWyJDb3VyaWVyLUJvbGQiXT0iQ291cmllci1Cb2xkIjtlLlphcGZEaW5nYmF0cz0iWmFwZkRpbmdiYXRzIjtlWyJUaW1lcy1JdGFsaWMiXT0iVGltZXMtSXRhbGljIjtlWyJIZWx2ZXRpY2EtT2JsaXF1ZSJdPSJIZWx2ZXRpY2EtT2JsaXF1ZSI7ZVsiQ291cmllci1PYmxpcXVlIl09IkNvdXJpZXItT2JsaXF1ZSI7ZVsiVGltZXMtQm9sZEl0YWxpYyJdPSJUaW1lcy1Cb2xkSXRhbGljIjtlWyJIZWx2ZXRpY2EtQm9sZE9ibGlxdWUiXT0iSGVsdmV0aWNhLUJvbGRPYmxpcXVlIjtlWyJDb3VyaWVyLUJvbGRPYmxpcXVlIl09IkNvdXJpZXItQm9sZE9ibGlxdWUiO2UuQXJpYWxOYXJyb3c9IkhlbHZldGljYSI7ZVsiQXJpYWxOYXJyb3ctQm9sZCJdPSJIZWx2ZXRpY2EtQm9sZCI7ZVsiQXJpYWxOYXJyb3ctQm9sZEl0YWxpYyJdPSJIZWx2ZXRpY2EtQm9sZE9ibGlxdWUiO2VbIkFyaWFsTmFycm93LUl0YWxpYyJdPSJIZWx2ZXRpY2EtT2JsaXF1ZSI7ZS5BcmlhbEJsYWNrPSJIZWx2ZXRpY2EiO2VbIkFyaWFsQmxhY2stQm9sZCJdPSJIZWx2ZXRpY2EtQm9sZCI7ZVsiQXJpYWxCbGFjay1Cb2xkSXRhbGljIl09IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSI7ZVsiQXJpYWxCbGFjay1JdGFsaWMiXT0iSGVsdmV0aWNhLU9ibGlxdWUiO2VbIkFyaWFsLUJsYWNrIl09IkhlbHZldGljYSI7ZVsiQXJpYWwtQmxhY2stQm9sZCJdPSJIZWx2ZXRpY2EtQm9sZCI7ZVsiQXJpYWwtQmxhY2stQm9sZEl0YWxpYyJdPSJIZWx2ZXRpY2EtQm9sZE9ibGlxdWUiO2VbIkFyaWFsLUJsYWNrLUl0YWxpYyJdPSJIZWx2ZXRpY2EtT2JsaXF1ZSI7ZS5BcmlhbD0iSGVsdmV0aWNhIjtlWyJBcmlhbC1Cb2xkIl09IkhlbHZldGljYS1Cb2xkIjtlWyJBcmlhbC1Cb2xkSXRhbGljIl09IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSI7ZVsiQXJpYWwtSXRhbGljIl09IkhlbHZldGljYS1PYmxpcXVlIjtlLkFyaWFsTVQ9IkhlbHZldGljYSI7ZVsiQXJpYWwtQm9sZEl0YWxpY01UIl09IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSI7ZVsiQXJpYWwtQm9sZE1UIl09IkhlbHZldGljYS1Cb2xkIjtlWyJBcmlhbC1JdGFsaWNNVCJdPSJIZWx2ZXRpY2EtT2JsaXF1ZSI7ZVsiQXJpYWwtQm9sZEl0YWxpY01ULUJvbGRJdGFsaWMiXT0iSGVsdmV0aWNhLUJvbGRPYmxpcXVlIjtlWyJBcmlhbC1Cb2xkTVQtQm9sZCJdPSJIZWx2ZXRpY2EtQm9sZCI7ZVsiQXJpYWwtSXRhbGljTVQtSXRhbGljIl09IkhlbHZldGljYS1PYmxpcXVlIjtlLkFyaWFsVW5pY29kZU1TPSJIZWx2ZXRpY2EiO2VbIkFyaWFsVW5pY29kZU1TLUJvbGQiXT0iSGVsdmV0aWNhLUJvbGQiO2VbIkFyaWFsVW5pY29kZU1TLUJvbGRJdGFsaWMiXT0iSGVsdmV0aWNhLUJvbGRPYmxpcXVlIjtlWyJBcmlhbFVuaWNvZGVNUy1JdGFsaWMiXT0iSGVsdmV0aWNhLU9ibGlxdWUiO2VbIkNvdXJpZXItQm9sZEl0YWxpYyJdPSJDb3VyaWVyLUJvbGRPYmxpcXVlIjtlWyJDb3VyaWVyLUl0YWxpYyJdPSJDb3VyaWVyLU9ibGlxdWUiO2UuQ291cmllck5ldz0iQ291cmllciI7ZVsiQ291cmllck5ldy1Cb2xkIl09IkNvdXJpZXItQm9sZCI7ZVsiQ291cmllck5ldy1Cb2xkSXRhbGljIl09IkNvdXJpZXItQm9sZE9ibGlxdWUiO2VbIkNvdXJpZXJOZXctSXRhbGljIl09IkNvdXJpZXItT2JsaXF1ZSI7ZVsiQ291cmllck5ld1BTLUJvbGRJdGFsaWNNVCJdPSJDb3VyaWVyLUJvbGRPYmxpcXVlIjtlWyJDb3VyaWVyTmV3UFMtQm9sZE1UIl09IkNvdXJpZXItQm9sZCI7ZVsiQ291cmllck5ld1BTLUl0YWxpY01UIl09IkNvdXJpZXItT2JsaXF1ZSI7ZS5Db3VyaWVyTmV3UFNNVD0iQ291cmllciI7ZVsiSGVsdmV0aWNhLUJvbGRJdGFsaWMiXT0iSGVsdmV0aWNhLUJvbGRPYmxpcXVlIjtlWyJIZWx2ZXRpY2EtSXRhbGljIl09IkhlbHZldGljYS1PYmxpcXVlIjtlWyJIZWx2ZXRpY2FMVFN0ZC1Cb2xkIl09IkhlbHZldGljYS1Cb2xkIjtlWyJTeW1ib2wtQm9sZCJdPSJTeW1ib2wiO2VbIlN5bWJvbC1Cb2xkSXRhbGljIl09IlN5bWJvbCI7ZVsiU3ltYm9sLUl0YWxpYyJdPSJTeW1ib2wiO2UuVGltZXNOZXdSb21hbj0iVGltZXMtUm9tYW4iO2VbIlRpbWVzTmV3Um9tYW4tQm9sZCJdPSJUaW1lcy1Cb2xkIjtlWyJUaW1lc05ld1JvbWFuLUJvbGRJdGFsaWMiXT0iVGltZXMtQm9sZEl0YWxpYyI7ZVsiVGltZXNOZXdSb21hbi1JdGFsaWMiXT0iVGltZXMtSXRhbGljIjtlLlRpbWVzTmV3Um9tYW5QUz0iVGltZXMtUm9tYW4iO2VbIlRpbWVzTmV3Um9tYW5QUy1Cb2xkIl09IlRpbWVzLUJvbGQiO2VbIlRpbWVzTmV3Um9tYW5QUy1Cb2xkSXRhbGljIl09IlRpbWVzLUJvbGRJdGFsaWMiO2VbIlRpbWVzTmV3Um9tYW5QUy1Cb2xkSXRhbGljTVQiXT0iVGltZXMtQm9sZEl0YWxpYyI7ZVsiVGltZXNOZXdSb21hblBTLUJvbGRNVCJdPSJUaW1lcy1Cb2xkIjtlWyJUaW1lc05ld1JvbWFuUFMtSXRhbGljIl09IlRpbWVzLUl0YWxpYyI7ZVsiVGltZXNOZXdSb21hblBTLUl0YWxpY01UIl09IlRpbWVzLUl0YWxpYyI7ZS5UaW1lc05ld1JvbWFuUFNNVD0iVGltZXMtUm9tYW4iO2VbIlRpbWVzTmV3Um9tYW5QU01ULUJvbGQiXT0iVGltZXMtQm9sZCI7ZVsiVGltZXNOZXdSb21hblBTTVQtQm9sZEl0YWxpYyJdPSJUaW1lcy1Cb2xkSXRhbGljIjtlWyJUaW1lc05ld1JvbWFuUFNNVC1JdGFsaWMiXT0iVGltZXMtSXRhbGljIn0pLExhPWdldExvb2t1cFRhYmxlRmFjdG9yeShmdW5jdGlvbihlKXtlLkNvdXJpZXI9IkZveGl0Rml4ZWQucGZiIjtlWyJDb3VyaWVyLUJvbGQiXT0iRm94aXRGaXhlZEJvbGQucGZiIjtlWyJDb3VyaWVyLUJvbGRPYmxpcXVlIl09IkZveGl0Rml4ZWRCb2xkSXRhbGljLnBmYiI7ZVsiQ291cmllci1PYmxpcXVlIl09IkZveGl0Rml4ZWRJdGFsaWMucGZiIjtlLkhlbHZldGljYT0iTGliZXJhdGlvblNhbnMtUmVndWxhci50dGYiO2VbIkhlbHZldGljYS1Cb2xkIl09IkxpYmVyYXRpb25TYW5zLUJvbGQudHRmIjtlWyJIZWx2ZXRpY2EtQm9sZE9ibGlxdWUiXT0iTGliZXJhdGlvblNhbnMtQm9sZEl0YWxpYy50dGYiO2VbIkhlbHZldGljYS1PYmxpcXVlIl09IkxpYmVyYXRpb25TYW5zLUl0YWxpYy50dGYiO2VbIlRpbWVzLVJvbWFuIl09IkZveGl0U2VyaWYucGZiIjtlWyJUaW1lcy1Cb2xkIl09IkZveGl0U2VyaWZCb2xkLnBmYiI7ZVsiVGltZXMtQm9sZEl0YWxpYyJdPSJGb3hpdFNlcmlmQm9sZEl0YWxpYy5wZmIiO2VbIlRpbWVzLUl0YWxpYyJdPSJGb3hpdFNlcmlmSXRhbGljLnBmYiI7ZS5TeW1ib2w9IkZveGl0U3ltYm9sLnBmYiI7ZS5aYXBmRGluZ2JhdHM9IkZveGl0RGluZ2JhdHMucGZiIjtlWyJMaWJlcmF0aW9uU2Fucy1SZWd1bGFyIl09IkxpYmVyYXRpb25TYW5zLVJlZ3VsYXIudHRmIjtlWyJMaWJlcmF0aW9uU2Fucy1Cb2xkIl09IkxpYmVyYXRpb25TYW5zLUJvbGQudHRmIjtlWyJMaWJlcmF0aW9uU2Fucy1JdGFsaWMiXT0iTGliZXJhdGlvblNhbnMtSXRhbGljLnR0ZiI7ZVsiTGliZXJhdGlvblNhbnMtQm9sZEl0YWxpYyJdPSJMaWJlcmF0aW9uU2Fucy1Cb2xkSXRhbGljLnR0ZiJ9KSxqYT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5DYWxpYnJpPSJIZWx2ZXRpY2EiO2VbIkNhbGlicmktQm9sZCJdPSJIZWx2ZXRpY2EtQm9sZCI7ZVsiQ2FsaWJyaS1Cb2xkSXRhbGljIl09IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSI7ZVsiQ2FsaWJyaS1JdGFsaWMiXT0iSGVsdmV0aWNhLU9ibGlxdWUiO2UuQ2VudHVyeUdvdGhpYz0iSGVsdmV0aWNhIjtlWyJDZW50dXJ5R290aGljLUJvbGQiXT0iSGVsdmV0aWNhLUJvbGQiO2VbIkNlbnR1cnlHb3RoaWMtQm9sZEl0YWxpYyJdPSJIZWx2ZXRpY2EtQm9sZE9ibGlxdWUiO2VbIkNlbnR1cnlHb3RoaWMtSXRhbGljIl09IkhlbHZldGljYS1PYmxpcXVlIjtlLkNvbWljU2Fuc01TPSJDb21pYyBTYW5zIE1TIjtlWyJDb21pY1NhbnNNUy1Cb2xkIl09IkNvbWljIFNhbnMgTVMtQm9sZCI7ZVsiQ29taWNTYW5zTVMtQm9sZEl0YWxpYyJdPSJDb21pYyBTYW5zIE1TLUJvbGRJdGFsaWMiO2VbIkNvbWljU2Fuc01TLUl0YWxpYyJdPSJDb21pYyBTYW5zIE1TLUl0YWxpYyI7ZS5HaWxsU2Fuc01UPSJIZWx2ZXRpY2EiO2VbIkdpbGxTYW5zTVQtQm9sZCJdPSJIZWx2ZXRpY2EtQm9sZCI7ZVsiR2lsbFNhbnNNVC1Cb2xkSXRhbGljIl09IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSI7ZVsiR2lsbFNhbnNNVC1JdGFsaWMiXT0iSGVsdmV0aWNhLU9ibGlxdWUiO2UuSW1wYWN0PSJIZWx2ZXRpY2EiO2VbIkl0Y1N5bWJvbC1Cb2xkIl09IkhlbHZldGljYS1Cb2xkIjtlWyJJdGNTeW1ib2wtQm9sZEl0YWxpYyJdPSJIZWx2ZXRpY2EtQm9sZE9ibGlxdWUiO2VbIkl0Y1N5bWJvbC1Cb29rIl09IkhlbHZldGljYSI7ZVsiSXRjU3ltYm9sLUJvb2tJdGFsaWMiXT0iSGVsdmV0aWNhLU9ibGlxdWUiO2VbIkl0Y1N5bWJvbC1NZWRpdW0iXT0iSGVsdmV0aWNhIjtlWyJJdGNTeW1ib2wtTWVkaXVtSXRhbGljIl09IkhlbHZldGljYS1PYmxpcXVlIjtlLkx1Y2lkYUNvbnNvbGU9IkNvdXJpZXIiO2VbIkx1Y2lkYUNvbnNvbGUtQm9sZCJdPSJDb3VyaWVyLUJvbGQiO2VbIkx1Y2lkYUNvbnNvbGUtQm9sZEl0YWxpYyJdPSJDb3VyaWVyLUJvbGRPYmxpcXVlIjtlWyJMdWNpZGFDb25zb2xlLUl0YWxpYyJdPSJDb3VyaWVyLU9ibGlxdWUiO2VbIkx1Y2lkYVNhbnMtRGVtaSJdPSJIZWx2ZXRpY2EtQm9sZCI7ZVsiTVMtR290aGljIl09Ik1TIEdvdGhpYyI7ZVsiTVMtR290aGljLUJvbGQiXT0iTVMgR290aGljLUJvbGQiO2VbIk1TLUdvdGhpYy1Cb2xkSXRhbGljIl09Ik1TIEdvdGhpYy1Cb2xkSXRhbGljIjtlWyJNUy1Hb3RoaWMtSXRhbGljIl09Ik1TIEdvdGhpYy1JdGFsaWMiO2VbIk1TLU1pbmNobyJdPSJNUyBNaW5jaG8iO2VbIk1TLU1pbmNoby1Cb2xkIl09Ik1TIE1pbmNoby1Cb2xkIjtlWyJNUy1NaW5jaG8tQm9sZEl0YWxpYyJdPSJNUyBNaW5jaG8tQm9sZEl0YWxpYyI7ZVsiTVMtTWluY2hvLUl0YWxpYyJdPSJNUyBNaW5jaG8tSXRhbGljIjtlWyJNUy1QR290aGljIl09Ik1TIFBHb3RoaWMiO2VbIk1TLVBHb3RoaWMtQm9sZCJdPSJNUyBQR290aGljLUJvbGQiO2VbIk1TLVBHb3RoaWMtQm9sZEl0YWxpYyJdPSJNUyBQR290aGljLUJvbGRJdGFsaWMiO2VbIk1TLVBHb3RoaWMtSXRhbGljIl09Ik1TIFBHb3RoaWMtSXRhbGljIjtlWyJNUy1QTWluY2hvIl09Ik1TIFBNaW5jaG8iO2VbIk1TLVBNaW5jaG8tQm9sZCJdPSJNUyBQTWluY2hvLUJvbGQiO2VbIk1TLVBNaW5jaG8tQm9sZEl0YWxpYyJdPSJNUyBQTWluY2hvLUJvbGRJdGFsaWMiO2VbIk1TLVBNaW5jaG8tSXRhbGljIl09Ik1TIFBNaW5jaG8tSXRhbGljIjtlLk51cHRpYWxTY3JpcHQ9IlRpbWVzLUl0YWxpYyI7ZS5TZWdvZVVJU3ltYm9sPSJIZWx2ZXRpY2EifSksVWE9Z2V0TG9va3VwVGFibGVGYWN0b3J5KGZ1bmN0aW9uKGUpe2VbIkFkb2JlIEplbnNvbiJdPSEwO2VbIkFkb2JlIFRleHQiXT0hMDtlLkFsYmVydHVzPSEwO2UuQWxkdXM9ITA7ZS5BbGV4YW5kcmlhPSEwO2UuQWxnZXJpYW49ITA7ZVsiQW1lcmljYW4gVHlwZXdyaXRlciJdPSEwO2UuQW50aXF1YT0hMDtlLkFwZXg9ITA7ZS5Bcm5vPSEwO2UuQXN0ZXI9ITA7ZS5BdXJvcmE9ITA7ZS5CYXNrZXJ2aWxsZT0hMDtlLkJlbGw9ITA7ZS5CZW1ibz0hMDtlWyJCZW1ibyBTY2hvb2xib29rIl09ITA7ZS5CZW5ndWlhdD0hMDtlWyJCZXJrZWxleSBPbGQgU3R5bGUiXT0hMDtlWyJCZXJuaGFyZCBNb2Rlcm4iXT0hMDtlWyJCZXJ0aG9sZCBDaXR5Il09ITA7ZS5Cb2Rvbmk9ITA7ZVsiQmF1ZXIgQm9kb25pIl09ITA7ZVsiQm9vayBBbnRpcXVhIl09ITA7ZS5Cb29rbWFuPSEwO2VbIkJvcmRlYXV4IFJvbWFuIl09ITA7ZVsiQ2FsaWZvcm5pYW4gRkIiXT0hMDtlLkNhbGlzdG89ITA7ZS5DYWx2ZXJ0PSEwO2UuQ2FwaXRhbHM9ITA7ZS5DYW1icmlhPSEwO2UuQ2FydGllcj0hMDtlLkNhc2xvbj0hMDtlLkNhdHVsbD0hMDtlLkNlbnRhdXI9ITA7ZVsiQ2VudHVyeSBPbGQgU3R5bGUiXT0hMDtlWyJDZW50dXJ5IFNjaG9vbGJvb2siXT0hMDtlLkNoYXBhcnJhbD0hMDtlWyJDaGFyaXMgU0lMIl09ITA7ZS5DaGVsdGVuaGFtPSEwO2VbIkNob2xsYSBTbGFiIl09ITA7ZS5DbGFyZW5kb249ITA7ZS5DbGVhcmZhY2U9ITA7ZS5Db2NoaW49ITA7ZS5Db2xvbm5hPSEwO2VbIkNvbXB1dGVyIE1vZGVybiJdPSEwO2VbIkNvbmNyZXRlIFJvbWFuIl09ITA7ZS5Db25zdGFudGlhPSEwO2VbIkNvb3BlciBCbGFjayJdPSEwO2UuQ29yb25hPSEwO2UuRWNvdHlwZT0hMDtlLkVneXB0aWVubmU9ITA7ZS5FbGVwaGFudD0hMDtlLkV4Y2Vsc2lvcj0hMDtlLkZhaXJmaWVsZD0hMDtlWyJGRiBTY2FsYSJdPSEwO2UuRm9sa2FyZD0hMDtlLkZvb3RsaWdodD0hMDtlLkZyZWVTZXJpZj0hMDtlWyJGcml6IFF1YWRyYXRhIl09ITA7ZS5HYXJhbW9uZD0hMDtlLkdlbnRpdW09ITA7ZS5HZW9yZ2lhPSEwO2UuR2xvdWNlc3Rlcj0hMDtlWyJHb3VkeSBPbGQgU3R5bGUiXT0hMDtlWyJHb3VkeSBTY2hvb2xib29rIl09ITA7ZVsiR291ZHkgUHJvIEZvbnQiXT0hMDtlLkdyYW5qb249ITA7ZVsiR3VhcmRpYW4gRWd5cHRpYW4iXT0hMDtlLkhlYXRoZXI9ITA7ZS5IZXJjdWxlcz0hMDtlWyJIaWdoIFRvd2VyIFRleHQiXT0hMDtlLkhpcm9zaGlnZT0hMDtlWyJIb2VmbGVyIFRleHQiXT0hMDtlWyJIdW1hbmEgU2VyaWYiXT0hMDtlLkltcHJpbnQ9ITA7ZVsiSW9uaWMgTm8uIDUiXT0hMDtlLkphbnNvbj0hMDtlLkpvYW5uYT0hMDtlLktvcmlubmE9ITA7ZS5MZXhpY29uPSEwO2UuTGliZXJhdGlvblNlcmlmPSEwO2VbIkxpYmVyYXRpb24gU2VyaWYiXT0hMDtlWyJMaW51eCBMaWJlcnRpbmUiXT0hMDtlLkxpdGVyYXR1cm5heWE9ITA7ZS5MdWNpZGE9ITA7ZVsiTHVjaWRhIEJyaWdodCJdPSEwO2UuTWVsaW9yPSEwO2UuTWVtcGhpcz0hMDtlLk1pbGxlcj0hMDtlLk1pbmlvbj0hMDtlLk1vZGVybj0hMDtlWyJNb25hIExpc2EiXT0hMDtlWyJNcnMgRWF2ZXMiXT0hMDtlWyJNUyBTZXJpZiJdPSEwO2VbIk11c2VvIFNsYWIiXT0hMDtlWyJOZXcgWW9yayJdPSEwO2VbIk5pbWJ1cyBSb21hbiJdPSEwO2VbIk5QUyBSYXdsaW5zb24gUm9hZHdheSJdPSEwO2UuTnVwdGlhbFNjcmlwdD0hMDtlLlBhbGF0aW5vPSEwO2UuUGVycGV0dWE9ITA7ZS5QbGFudGluPSEwO2VbIlBsYW50aW4gU2Nob29sYm9vayJdPSEwO2UuUGxheWJpbGw9ITA7ZVsiUG9vciBSaWNoYXJkIl09ITA7ZVsiUmF3bGluc29uIFJvYWR3YXkiXT0hMDtlLlJlbmF1bHQ9ITA7ZS5SZXF1aWVtPSEwO2UuUm9ja3dlbGw9ITA7ZS5Sb21hbj0hMDtlWyJSb3RpcyBTZXJpZiJdPSEwO2UuU2Fib249ITA7ZS5TY2FsYT0hMDtlLlNlYWd1bGw9ITA7ZS5TaXN0aW5hPSEwO2UuU291dmVuaXI9ITA7ZS5TVElYPSEwO2VbIlN0b25lIEluZm9ybWFsIl09ITA7ZVsiU3RvbmUgU2VyaWYiXT0hMDtlLlN5bGZhZW49ITA7ZS5UaW1lcz0hMDtlLlRyYWphbj0hMDtlWyJUcmluaXTDqSJdPSEwO2VbIlRydW1wIE1lZGlhZXZhbCJdPSEwO2UuVXRvcGlhPSEwO2VbIlZhbGUgVHlwZSJdPSEwO2VbIkJpdHN0cmVhbSBWZXJhIl09ITA7ZVsiVmVyYSBTZXJpZiJdPSEwO2UuVmVyc2FpbGxlcz0hMDtlLldhbnRlZD0hMDtlLldlaXNzPSEwO2VbIldpZGUgTGF0aW4iXT0hMDtlLldpbmRzb3I9ITA7ZS5YSVRTPSEwfSkscWE9Z2V0TG9va3VwVGFibGVGYWN0b3J5KGZ1bmN0aW9uKGUpe2UuRGluZ2JhdHM9ITA7ZS5TeW1ib2w9ITA7ZS5aYXBmRGluZ2JhdHM9ITA7ZS5XaW5nZGluZ3M9ITA7ZVsiV2luZ2RpbmdzLUJvbGQiXT0hMDtlWyJXaW5nZGluZ3MtUmVndWxhciJdPSEwfSksWGE9Z2V0TG9va3VwVGFibGVGYWN0b3J5KGZ1bmN0aW9uKGUpe2VbMl09MTA7ZVszXT0zMjtlWzRdPTMzO2VbNV09MzQ7ZVs2XT0zNTtlWzddPTM2O2VbOF09Mzc7ZVs5XT0zODtlWzEwXT0zOTtlWzExXT00MDtlWzEyXT00MTtlWzEzXT00MjtlWzE0XT00MztlWzE1XT00NDtlWzE2XT00NTtlWzE3XT00NjtlWzE4XT00NztlWzE5XT00ODtlWzIwXT00OTtlWzIxXT01MDtlWzIyXT01MTtlWzIzXT01MjtlWzI0XT01MztlWzI1XT01NDtlWzI2XT01NTtlWzI3XT01NjtlWzI4XT01NztlWzI5XT01ODtlWzMwXT04OTQ7ZVszMV09NjA7ZVszMl09NjE7ZVszM109NjI7ZVszNF09NjM7ZVszNV09NjQ7ZVszNl09NjU7ZVszN109NjY7ZVszOF09Njc7ZVszOV09Njg7ZVs0MF09Njk7ZVs0MV09NzA7ZVs0Ml09NzE7ZVs0M109NzI7ZVs0NF09NzM7ZVs0NV09NzQ7ZVs0Nl09NzU7ZVs0N109NzY7ZVs0OF09Nzc7ZVs0OV09Nzg7ZVs1MF09Nzk7ZVs1MV09ODA7ZVs1Ml09ODE7ZVs1M109ODI7ZVs1NF09ODM7ZVs1NV09ODQ7ZVs1Nl09ODU7ZVs1N109ODY7ZVs1OF09ODc7ZVs1OV09ODg7ZVs2MF09ODk7ZVs2MV09OTA7ZVs2Ml09OTE7ZVs2M109OTI7ZVs2NF09OTM7ZVs2NV09OTQ7ZVs2Nl09OTU7ZVs2N109OTY7ZVs2OF09OTc7ZVs2OV09OTg7ZVs3MF09OTk7ZVs3MV09MTAwO2VbNzJdPTEwMTtlWzczXT0xMDI7ZVs3NF09MTAzO2VbNzVdPTEwNDtlWzc2XT0xMDU7ZVs3N109MTA2O2VbNzhdPTEwNztlWzc5XT0xMDg7ZVs4MF09MTA5O2VbODFdPTExMDtlWzgyXT0xMTE7ZVs4M109MTEyO2VbODRdPTExMztlWzg1XT0xMTQ7ZVs4Nl09MTE1O2VbODddPTExNjtlWzg4XT0xMTc7ZVs4OV09MTE4O2VbOTBdPTExOTtlWzkxXT0xMjA7ZVs5Ml09MTIxO2VbOTNdPTEyMjtlWzk0XT0xMjM7ZVs5NV09MTI0O2VbOTZdPTEyNTtlWzk3XT0xMjY7ZVs5OF09MTk2O2VbOTldPTE5NztlWzEwMF09MTk5O2VbMTAxXT0yMDE7ZVsxMDJdPTIwOTtlWzEwM109MjE0O2VbMTA0XT0yMjA7ZVsxMDVdPTIyNTtlWzEwNl09MjI0O2VbMTA3XT0yMjY7ZVsxMDhdPTIyODtlWzEwOV09MjI3O2VbMTEwXT0yMjk7ZVsxMTFdPTIzMTtlWzExMl09MjMzO2VbMTEzXT0yMzI7ZVsxMTRdPTIzNDtlWzExNV09MjM1O2VbMTE2XT0yMzc7ZVsxMTddPTIzNjtlWzExOF09MjM4O2VbMTE5XT0yMzk7ZVsxMjBdPTI0MTtlWzEyMV09MjQzO2VbMTIyXT0yNDI7ZVsxMjNdPTI0NDtlWzEyNF09MjQ2O2VbMTI1XT0yNDU7ZVsxMjZdPTI1MDtlWzEyN109MjQ5O2VbMTI4XT0yNTE7ZVsxMjldPTI1MjtlWzEzMF09ODIyNDtlWzEzMV09MTc2O2VbMTMyXT0xNjI7ZVsxMzNdPTE2MztlWzEzNF09MTY3O2VbMTM1XT04MjI2O2VbMTM2XT0xODI7ZVsxMzddPTIyMztlWzEzOF09MTc0O2VbMTM5XT0xNjk7ZVsxNDBdPTg0ODI7ZVsxNDFdPTE4MDtlWzE0Ml09MTY4O2VbMTQzXT04ODAwO2VbMTQ0XT0xOTg7ZVsxNDVdPTIxNjtlWzE0Nl09ODczNDtlWzE0N109MTc3O2VbMTQ4XT04ODA0O2VbMTQ5XT04ODA1O2VbMTUwXT0xNjU7ZVsxNTFdPTE4MTtlWzE1Ml09ODcwNjtlWzE1M109ODcyMTtlWzE1NF09ODcxOTtlWzE1Nl09ODc0NztlWzE1N109MTcwO2VbMTU4XT0xODY7ZVsxNTldPTg0ODY7ZVsxNjBdPTIzMDtlWzE2MV09MjQ4O2VbMTYyXT0xOTE7ZVsxNjNdPTE2MTtlWzE2NF09MTcyO2VbMTY1XT04NzMwO2VbMTY2XT00MDI7ZVsxNjddPTg3NzY7ZVsxNjhdPTg3MTA7ZVsxNjldPTE3MTtlWzE3MF09MTg3O2VbMTcxXT04MjMwO2VbMTc5XT04MjIwO2VbMTgwXT04MjIxO2VbMTgxXT04MjE2O2VbMTgyXT04MjE3O2VbMjAwXT0xOTM7ZVsyMDNdPTIwNTtlWzIwN109MjExO2VbMjEwXT0yMTg7ZVsyMjNdPTcxMTtlWzIyNF09MzIxO2VbMjI1XT0zMjI7ZVsyMjZdPTM1MjtlWzIyN109MzUzO2VbMjI4XT0zODE7ZVsyMjldPTM4MjtlWzIzM109MjIxO2VbMjM0XT0yNTM7ZVsyNTJdPTI2MztlWzI1M109MjY4O2VbMjU0XT0yNjk7ZVsyNThdPTI1ODtlWzI2MF09MjYwO2VbMjYxXT0yNjE7ZVsyNjVdPTI4MDtlWzI2Nl09MjgxO2VbMjY3XT0yODI7ZVsyNjhdPTI4MztlWzI2OV09MzEzO2VbMjc1XT0zMjM7ZVsyNzZdPTMyNDtlWzI3OF09MzI4O2VbMjgzXT0zNDQ7ZVsyODRdPTM0NTtlWzI4NV09MzQ2O2VbMjg2XT0zNDc7ZVsyOTJdPTM2NztlWzI5NV09Mzc3O2VbMjk2XT0zNzg7ZVsyOThdPTM4MDtlWzMwNV09OTYzO2VbMzA2XT05NjQ7ZVszMDddPTk2NjtlWzMwOF09ODIxNTtlWzMwOV09ODI1MjtlWzMxMF09ODMxOTtlWzMxMV09ODM1OTtlWzMxMl09ODU5MjtlWzMxM109ODU5MztlWzMzN109OTU1MjtlWzQ5M109MTAzOTtlWzQ5NF09MTA0MDtlWzU3MF09MTA0MDtlWzU3MV09MTA0MTtlWzU3Ml09MTA0MjtlWzU3M109MTA0MztlWzU3NF09MTA0NDtlWzU3NV09MTA0NTtlWzU3Nl09MTA0NjtlWzU3N109MTA0NztlWzU3OF09MTA0ODtlWzU3OV09MTA0OTtlWzU4MF09MTA1MDtlWzU4MV09MTA1MTtlWzU4Ml09MTA1MjtlWzU4M109MTA1MztlWzU4NF09MTA1NDtlWzU4NV09MTA1NTtlWzU4Nl09MTA1NjtlWzU4N109MTA1NztlWzU4OF09MTA1ODtlWzU4OV09MTA1OTtlWzU5MF09MTA2MDtlWzU5MV09MTA2MTtlWzU5Ml09MTA2MjtlWzU5M109MTA2MztlWzU5NF09MTA2NDtlWzU5NV09MTA2NTtlWzU5Nl09MTA2NjtlWzU5N109MTA2NztlWzU5OF09MTA2ODtlWzU5OV09MTA2OTtlWzYwMF09MTA3MDtlWzY3Ml09MTQ4ODtlWzY3M109MTQ4OTtlWzY3NF09MTQ5MDtlWzY3NV09MTQ5MTtlWzY3Nl09MTQ5MjtlWzY3N109MTQ5MztlWzY3OF09MTQ5NDtlWzY3OV09MTQ5NTtlWzY4MF09MTQ5NjtlWzY4MV09MTQ5NztlWzY4Ml09MTQ5ODtlWzY4M109MTQ5OTtlWzY4NF09MTUwMDtlWzY4NV09MTUwMTtlWzY4Nl09MTUwMjtlWzY4N109MTUwMztlWzY4OF09MTUwNDtlWzY4OV09MTUwNTtlWzY5MF09MTUwNjtlWzY5MV09MTUwNztlWzY5Ml09MTUwODtlWzY5M109MTUwOTtlWzY5NF09MTUxMDtlWzY5NV09MTUxMTtlWzY5Nl09MTUxMjtlWzY5N109MTUxMztlWzY5OF09MTUxNDtlWzcwNV09MTUyNDtlWzcwNl09ODM2MjtlWzcxMF09NjQyODg7ZVs3MTFdPTY0Mjk4O2VbNzU5XT0xNjE3O2VbNzYxXT0xNzc2O2VbNzYzXT0xNzc4O2VbNzc1XT0xNjUyO2VbNzc3XT0xNzY0O2VbNzc4XT0xNzgwO2VbNzc5XT0xNzgxO2VbNzgwXT0xNzgyO2VbNzgyXT03NzE7ZVs3ODNdPTY0NzI2O2VbNzg2XT04MzYzO2VbNzg4XT04NTMyO2VbNzkwXT03Njg7ZVs3OTFdPTc2OTtlWzc5Ml09NzY4O2VbNzk1XT04MDM7ZVs3OTddPTY0MzM2O2VbNzk4XT02NDMzNztlWzc5OV09NjQzNDI7ZVs4MDBdPTY0MzQzO2VbODAxXT02NDM0NDtlWzgwMl09NjQzNDU7ZVs4MDNdPTY0MzYyO2VbODA0XT02NDM2MztlWzgwNV09NjQzNjQ7ZVsyNDI0XT03ODIxO2VbMjQyNV09NzgyMjtlWzI0MjZdPTc4MjM7ZVsyNDI3XT03ODI0O2VbMjQyOF09NzgyNTtlWzI0MjldPTc4MjY7ZVsyNDMwXT03ODI3O2VbMjQzM109NzY4MjtlWzI2NzhdPTgwNDU7ZVsyNjc5XT04MDQ2O2VbMjgzMF09MTU1MjtlWzI4MzhdPTY4NjtlWzI4NDBdPTc1MTtlWzI4NDJdPTc1MztlWzI4NDNdPTc1NDtlWzI4NDRdPTc1NTtlWzI4NDZdPTc1NztlWzI4NTZdPTc2NztlWzI4NTddPTg0ODtlWzI4NThdPTg0OTtlWzI4NjJdPTg1MztlWzI4NjNdPTg1NDtlWzI4NjRdPTg1NTtlWzI4NjVdPTg2MTtlWzI4NjZdPTg2MjtlWzI5MDZdPTc0NjA7ZVsyOTA4XT03NDYyO2VbMjkwOV09NzQ2MztlWzI5MTBdPTc0NjQ7ZVsyOTEyXT03NDY2O2VbMjkxM109NzQ2NztlWzI5MTRdPTc0Njg7ZVsyOTE2XT03NDcwO2VbMjkxN109NzQ3MTtlWzI5MThdPTc0NzI7ZVsyOTIwXT03NDc0O2VbMjkyMV09NzQ3NTtlWzI5MjJdPTc0NzY7ZVsyOTI0XT03NDc4O2VbMjkyNV09NzQ3OTtlWzI5MjZdPTc0ODA7ZVsyOTI4XT03NDgyO2VbMjkyOV09NzQ4MztlWzI5MzBdPTc0ODQ7ZVsyOTMyXT03NDg2O2VbMjkzM109NzQ4NztlWzI5MzRdPTc0ODg7ZVsyOTM2XT03NDkwO2VbMjkzN109NzQ5MTtlWzI5MzhdPTc0OTI7ZVsyOTQwXT03NDk0O2VbMjk0MV09NzQ5NTtlWzI5NDJdPTc0OTY7ZVsyOTQ0XT03NDk4O2VbMjk0Nl09NzUwMDtlWzI5NDhdPTc1MDI7ZVsyOTUwXT03NTA0O2VbMjk1MV09NzUwNTtlWzI5NTJdPTc1MDY7ZVsyOTU0XT03NTA4O2VbMjk1NV09NzUwOTtlWzI5NTZdPTc1MTA7ZVsyOTU4XT03NTEyO2VbMjk1OV09NzUxMztlWzI5NjBdPTc1MTQ7ZVsyOTYyXT03NTE2O2VbMjk2M109NzUxNztlWzI5NjRdPTc1MTg7ZVsyOTY2XT03NTIwO2VbMjk2N109NzUyMTtlWzI5NjhdPTc1MjI7ZVsyOTcwXT03NTI0O2VbMjk3MV09NzUyNTtlWzI5NzJdPTc1MjY7ZVsyOTc0XT03NTI4O2VbMjk3NV09NzUyOTtlWzI5NzZdPTc1MzA7ZVsyOTc4XT0xNTM3O2VbMjk3OV09MTUzODtlWzI5ODBdPTE1Mzk7ZVsyOTgyXT0xNTQ5O2VbMjk4M109MTU1MTtlWzI5ODRdPTE1NTI7ZVsyOTg2XT0xNTU0O2VbMjk4N109MTU1NTtlWzI5ODhdPTE1NTY7ZVsyOTkwXT0xNjIzO2VbMjk5MV09MTYyNDtlWzI5OTVdPTE3NzU7ZVsyOTk5XT0xNzkxO2VbMzAwMl09NjQyOTA7ZVszMDAzXT02NDI5MTtlWzMwMDRdPTY0MjkyO2VbMzAwNl09NjQyOTQ7ZVszMDA3XT02NDI5NTtlWzMwMDhdPTY0Mjk2O2VbMzAxMV09MTkwMDtlWzMwMTRdPTgyMjM7ZVszMDE1XT04MjQ0O2VbMzAxN109NzUzMjtlWzMwMThdPTc1MzM7ZVszMDE5XT03NTM0O2VbMzA3NV09NzU5MDtlWzMwNzZdPTc1OTE7ZVszMDc5XT03NTk0O2VbMzA4MF09NzU5NTtlWzMwODNdPTc1OTg7ZVszMDg0XT03NTk5O2VbMzA4N109NzYwMjtlWzMwODhdPTc2MDM7ZVszMDkxXT03NjA2O2VbMzA5Ml09NzYwNztlWzMwOTVdPTc2MTA7ZVszMDk2XT03NjExO2VbMzA5OV09NzYxNDtlWzMxMDBdPTc2MTU7ZVszMTAzXT03NjE4O2VbMzEwNF09NzYxOTtlWzMxMDddPTgzMzc7ZVszMTA4XT04MzM4O2VbMzExNl09MTg4NDtlWzMxMTldPTE4ODU7ZVszMTIwXT0xODg1O2VbMzEyM109MTg4NjtlWzMxMjRdPTE4ODY7ZVszMTI3XT0xODg3O2VbMzEyOF09MTg4NztlWzMxMzFdPTE4ODg7ZVszMTMyXT0xODg4O2VbMzEzNV09MTg4OTtlWzMxMzZdPTE4ODk7ZVszMTM5XT0xODkwO2VbMzE0MF09MTg5MDtlWzMxNDNdPTE4OTE7ZVszMTQ0XT0xODkxO2VbMzE0N109MTg5MjtlWzMxNDhdPTE4OTI7ZVszMTUzXT01ODA7ZVszMTU0XT01ODE7ZVszMTU3XT01ODQ7ZVszMTU4XT01ODU7ZVszMTYxXT01ODg7ZVszMTYyXT01ODk7ZVszMTY1XT04OTE7ZVszMTY2XT04OTI7ZVszMTY5XT0xMjc0O2VbMzE3MF09MTI3NTtlWzMxNzNdPTEyNzg7ZVszMTc0XT0xMjc5O2VbMzE4MV09NzYyMjtlWzMxODJdPTc2MjM7ZVszMjgyXT0xMTc5OTtlWzMzMTZdPTU3ODtlWzMzNzldPTQyNzg1O2VbMzM5M109MTE1OTtlWzM0MTZdPTgzNzd9KSxIYT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZVsyMjddPTMyMjtlWzI2NF09MjYxO2VbMjkxXT0zNDZ9KSxXYT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZVsxXT0zMjtlWzRdPTY1O2VbNV09MTkyO2VbNl09MTkzO2VbOV09MTk2O2VbMTddPTY2O2VbMThdPTY3O2VbMjFdPTI2ODtlWzI0XT02ODtlWzI4XT02OTtlWzI5XT0yMDA7ZVszMF09MjAxO2VbMzJdPTI4MjtlWzM4XT03MDtlWzM5XT03MTtlWzQ0XT03MjtlWzQ3XT03MztlWzQ4XT0yMDQ7ZVs0OV09MjA1O2VbNThdPTc0O2VbNjBdPTc1O2VbNjJdPTc2O2VbNjhdPTc3O2VbNjldPTc4O2VbNzVdPTc5O2VbNzZdPTIxMDtlWzgwXT0yMTQ7ZVs4N109ODA7ZVs4OV09ODE7ZVs5MF09ODI7ZVs5Ml09MzQ0O2VbOTRdPTgzO2VbOTddPTM1MjtlWzEwMF09ODQ7ZVsxMDRdPTg1O2VbMTA5XT0yMjA7ZVsxMTVdPTg2O2VbMTE2XT04NztlWzEyMV09ODg7ZVsxMjJdPTg5O2VbMTI0XT0yMjE7ZVsxMjddPTkwO2VbMTI5XT0zODE7ZVsyNThdPTk3O2VbMjU5XT0yMjQ7ZVsyNjBdPTIyNTtlWzI2M109MjI4O2VbMjY4XT0yNjE7ZVsyNzFdPTk4O2VbMjcyXT05OTtlWzI3M109MjYzO2VbMjc1XT0yNjk7ZVsyODJdPTEwMDtlWzI4Nl09MTAxO2VbMjg3XT0yMzI7ZVsyODhdPTIzMztlWzI5MF09MjgzO2VbMjk1XT0yODE7ZVsyOTZdPTEwMjtlWzMzNl09MTAzO2VbMzQ2XT0xMDQ7ZVszNDldPTEwNTtlWzM1MF09MjM2O2VbMzUxXT0yMzc7ZVszNjFdPTEwNjtlWzM2NF09MTA3O2VbMzY3XT0xMDg7ZVszNzFdPTMyMjtlWzM3M109MTA5O2VbMzc0XT0xMTA7ZVszODFdPTExMTtlWzM4Ml09MjQyO2VbMzgzXT0yNDM7ZVszODZdPTI0NjtlWzM5M109MTEyO2VbMzk1XT0xMTM7ZVszOTZdPTExNDtlWzM5OF09MzQ1O2VbNDAwXT0xMTU7ZVs0MDFdPTM0NztlWzQwM109MzUzO2VbNDEwXT0xMTY7ZVs0MzddPTExNztlWzQ0Ml09MjUyO2VbNDQ4XT0xMTg7ZVs0NDldPTExOTtlWzQ1NF09MTIwO2VbNDU1XT0xMjE7ZVs0NTddPTI1MztlWzQ2MF09MTIyO2VbNDYyXT0zODI7ZVs0NjNdPTM4MDtlWzg1M109NDQ7ZVs4NTVdPTU4O2VbODU2XT00NjtlWzg3Nl09NDc7ZVs4NzhdPTQ1O2VbODgyXT00NTtlWzg5NF09NDA7ZVs4OTVdPTQxO2VbODk2XT05MTtlWzg5N109OTM7ZVs5MjNdPTY0O2VbOTQwXT0xNjM7ZVsxMDA0XT00ODtlWzEwMDVdPTQ5O2VbMTAwNl09NTA7ZVsxMDA3XT01MTtlWzEwMDhdPTUyO2VbMTAwOV09NTM7ZVsxMDEwXT01NDtlWzEwMTFdPTU1O2VbMTAxMl09NTY7ZVsxMDEzXT01NztlWzEwODFdPTM3O2VbMTA4NV09NDM7ZVsxMDg2XT00NX0pO2Z1bmN0aW9uIGdldFN0YW5kYXJkRm9udE5hbWUoZSl7Y29uc3QgdD1ub3JtYWxpemVGb250TmFtZShlKTtyZXR1cm4gX2EoKVt0XX1mdW5jdGlvbiBpc0tub3duRm9udE5hbWUoZSl7Y29uc3QgdD1ub3JtYWxpemVGb250TmFtZShlKTtyZXR1cm4hIShfYSgpW3RdfHxqYSgpW3RdfHxVYSgpW3RdfHxxYSgpW3RdKX1jbGFzcyBUb1VuaWNvZGVNYXB7Y29uc3RydWN0b3IoZT1bXSl7dGhpcy5fbWFwPWV9Z2V0IGxlbmd0aCgpe3JldHVybiB0aGlzLl9tYXAubGVuZ3RofWZvckVhY2goZSl7Zm9yKGNvbnN0IHQgaW4gdGhpcy5fbWFwKWUodCx0aGlzLl9tYXBbdF0uY29kZVBvaW50QXQoMCkpfWhhcyhlKXtyZXR1cm4gdm9pZCAwIT09dGhpcy5fbWFwW2VdfWdldChlKXtyZXR1cm4gdGhpcy5fbWFwW2VdfWNoYXJDb2RlT2YoZSl7Y29uc3QgdD10aGlzLl9tYXA7aWYodC5sZW5ndGg8PTY1NTM2KXJldHVybiB0LmluZGV4T2YoZSk7Zm9yKGNvbnN0IHIgaW4gdClpZih0W3JdPT09ZSlyZXR1cm4gMHxyO3JldHVybi0xfWFtZW5kKGUpe2Zvcihjb25zdCB0IGluIGUpdGhpcy5fbWFwW3RdPWVbdF19fWNsYXNzIElkZW50aXR5VG9Vbmljb2RlTWFwe2NvbnN0cnVjdG9yKGUsdCl7dGhpcy5maXJzdENoYXI9ZTt0aGlzLmxhc3RDaGFyPXR9Z2V0IGxlbmd0aCgpe3JldHVybiB0aGlzLmxhc3RDaGFyKzEtdGhpcy5maXJzdENoYXJ9Zm9yRWFjaChlKXtmb3IobGV0IHQ9dGhpcy5maXJzdENoYXIscj10aGlzLmxhc3RDaGFyO3Q8PXI7dCsrKWUodCx0KX1oYXMoZSl7cmV0dXJuIHRoaXMuZmlyc3RDaGFyPD1lJiZlPD10aGlzLmxhc3RDaGFyfWdldChlKXtpZih0aGlzLmZpcnN0Q2hhcjw9ZSYmZTw9dGhpcy5sYXN0Q2hhcilyZXR1cm4gU3RyaW5nLmZyb21DaGFyQ29kZShlKX1jaGFyQ29kZU9mKGUpe3JldHVybiBOdW1iZXIuaXNJbnRlZ2VyKGUpJiZlPj10aGlzLmZpcnN0Q2hhciYmZTw9dGhpcy5sYXN0Q2hhcj9lOi0xfWFtZW5kKGUpe3VucmVhY2hhYmxlKCJTaG91bGQgbm90IGNhbGwgYW1lbmQoKSIpfX1jbGFzcyBDRkZGb250e2NvbnN0cnVjdG9yKGUsdCl7dGhpcy5wcm9wZXJ0aWVzPXQ7Y29uc3Qgcj1uZXcgQ0ZGUGFyc2VyKGUsdCx4YSk7dGhpcy5jZmY9ci5wYXJzZSgpO3RoaXMuY2ZmLmR1cGxpY2F0ZUZpcnN0R2x5cGgoKTtjb25zdCBhPW5ldyBDRkZDb21waWxlcih0aGlzLmNmZik7dGhpcy5zZWFjcz10aGlzLmNmZi5zZWFjczt0cnl7dGhpcy5kYXRhPWEuY29tcGlsZSgpfWNhdGNoe3dhcm4oIkZhaWxlZCB0byBjb21waWxlIGZvbnQgIit0LmxvYWRlZE5hbWUpO3RoaXMuZGF0YT1lfXRoaXMuX2NyZWF0ZUJ1aWx0SW5FbmNvZGluZygpfWdldCBudW1HbHlwaHMoKXtyZXR1cm4gdGhpcy5jZmYuY2hhclN0cmluZ3MuY291bnR9Z2V0Q2hhcnNldCgpe3JldHVybiB0aGlzLmNmZi5jaGFyc2V0LmNoYXJzZXR9Z2V0R2x5cGhNYXBwaW5nKCl7Y29uc3QgZT10aGlzLmNmZix0PXRoaXMucHJvcGVydGllcyx7Y2lkVG9HaWRNYXA6cixjTWFwOmF9PXQsbj1lLmNoYXJzZXQuY2hhcnNldDtsZXQgaSxzO2lmKHQuY29tcG9zaXRlKXtsZXQgdCxvO2lmKHI/Lmxlbmd0aD4wKXt0PU9iamVjdC5jcmVhdGUobnVsbCk7Zm9yKGxldCBlPTAsYT1yLmxlbmd0aDtlPGE7ZSsrKXtjb25zdCBhPXJbZV07dm9pZCAwIT09YSYmKHRbYV09ZSl9fWk9T2JqZWN0LmNyZWF0ZShudWxsKTtpZihlLmlzQ0lERm9udClmb3Iocz0wO3M8bi5sZW5ndGg7cysrKXtjb25zdCBlPW5bc107bz1hLmNoYXJDb2RlT2YoZSk7dm9pZCAwIT09dD8uW29dJiYobz10W29dKTtpW29dPXN9ZWxzZSBmb3Iocz0wO3M8ZS5jaGFyU3RyaW5ncy5jb3VudDtzKyspe289YS5jaGFyQ29kZU9mKHMpO2lbb109c31yZXR1cm4gaX1sZXQgbz1lLmVuY29kaW5nP2UuZW5jb2RpbmcuZW5jb2Rpbmc6bnVsbDt0LmlzSW50ZXJuYWxGb250JiYobz10LmRlZmF1bHRFbmNvZGluZyk7aT10eXBlMUZvbnRHbHlwaE1hcHBpbmcodCxvLG4pO3JldHVybiBpfWhhc0dseXBoSWQoZSl7cmV0dXJuIHRoaXMuY2ZmLmhhc0dseXBoSWQoZSl9X2NyZWF0ZUJ1aWx0SW5FbmNvZGluZygpe2NvbnN0e2NoYXJzZXQ6ZSxlbmNvZGluZzp0fT10aGlzLmNmZjtpZighZXx8IXQpcmV0dXJuO2NvbnN0IHI9ZS5jaGFyc2V0LGE9dC5lbmNvZGluZyxuPVtdO2Zvcihjb25zdCBlIGluIGEpe2NvbnN0IHQ9YVtlXTtpZih0Pj0wKXtjb25zdCBhPXJbdF07YSYmKG5bZV09YSl9fW4ubGVuZ3RoPjAmJih0aGlzLnByb3BlcnRpZXMuYnVpbHRJbkVuY29kaW5nPW4pfX1mdW5jdGlvbiBnZXRGbG9hdDIxNChlLHQpe3JldHVybiByZWFkSW50MTYoZSx0KS8xNjM4NH1mdW5jdGlvbiBnZXRTdWJyb3V0aW5lQmlhcyhlKXtjb25zdCB0PWUubGVuZ3RoO2xldCByPTMyNzY4O3Q8MTI0MD9yPTEwNzp0PDMzOTAwJiYocj0xMTMxKTtyZXR1cm4gcn1mdW5jdGlvbiBwYXJzZUNtYXAoZSx0LHIpe2NvbnN0IGE9MT09PXJlYWRVaW50MTYoZSx0KzIpP3JlYWRVaW50MzIoZSx0KzgpOnJlYWRVaW50MzIoZSx0KzE2KSxuPXJlYWRVaW50MTYoZSx0K2EpO2xldCBpLHMsbztpZig0PT09bil7cmVhZFVpbnQxNihlLHQrYSsyKTtjb25zdCByPXJlYWRVaW50MTYoZSx0K2ErNik+PjE7cz10K2ErMTQ7aT1bXTtmb3Iobz0wO288cjtvKysscys9MilpW29dPXtlbmQ6cmVhZFVpbnQxNihlLHMpfTtzKz0yO2ZvcihvPTA7bzxyO28rKyxzKz0yKWlbb10uc3RhcnQ9cmVhZFVpbnQxNihlLHMpO2ZvcihvPTA7bzxyO28rKyxzKz0yKWlbb10uaWREZWx0YT1yZWFkVWludDE2KGUscyk7Zm9yKG89MDtvPHI7bysrLHMrPTIpe2xldCB0PXJlYWRVaW50MTYoZSxzKTtpZigwIT09dCl7aVtvXS5pZHM9W107Zm9yKGxldCByPTAsYT1pW29dLmVuZC1pW29dLnN0YXJ0KzE7cjxhO3IrKyl7aVtvXS5pZHNbcl09cmVhZFVpbnQxNihlLHMrdCk7dCs9Mn19fXJldHVybiBpfWlmKDEyPT09bil7Y29uc3Qgcj1yZWFkVWludDMyKGUsdCthKzEyKTtzPXQrYSsxNjtpPVtdO2ZvcihvPTA7bzxyO28rKyl7dD1yZWFkVWludDMyKGUscyk7aS5wdXNoKHtzdGFydDp0LGVuZDpyZWFkVWludDMyKGUscys0KSxpZERlbHRhOnJlYWRVaW50MzIoZSxzKzgpLXR9KTtzKz0xMn1yZXR1cm4gaX10aHJvdyBuZXcgRm9ybWF0RXJyb3IoYHVuc3VwcG9ydGVkIGNtYXA6ICR7bn1gKX1mdW5jdGlvbiBwYXJzZUNmZihlLHQscixhKXtjb25zdCBuPW5ldyBDRkZQYXJzZXIobmV3IFN0cmVhbShlLHQsci10KSx7fSxhKS5wYXJzZSgpO3JldHVybntnbHlwaHM6bi5jaGFyU3RyaW5ncy5vYmplY3RzLHN1YnJzOm4udG9wRGljdC5wcml2YXRlRGljdD8uc3VicnNJbmRleD8ub2JqZWN0cyxnc3VicnM6bi5nbG9iYWxTdWJySW5kZXg/Lm9iamVjdHMsaXNDRkZDSURGb250Om4uaXNDSURGb250LGZkU2VsZWN0Om4uZmRTZWxlY3QsZmRBcnJheTpuLmZkQXJyYXl9fWZ1bmN0aW9uIGxvb2t1cENtYXAoZSx0KXtjb25zdCByPXQuY29kZVBvaW50QXQoMCk7bGV0IGE9MCxuPTAsaT1lLmxlbmd0aC0xO2Zvcig7bjxpOyl7Y29uc3QgdD1uK2krMT4+MTtyPGVbdF0uc3RhcnQ/aT10LTE6bj10fWVbbl0uc3RhcnQ8PXImJnI8PWVbbl0uZW5kJiYoYT1lW25dLmlkRGVsdGErKGVbbl0uaWRzP2Vbbl0uaWRzW3ItZVtuXS5zdGFydF06cikmNjU1MzUpO3JldHVybntjaGFyQ29kZTpyLGdseXBoSWQ6YX19ZnVuY3Rpb24gY29tcGlsZUdseWYoZSx0LHIpe2Z1bmN0aW9uIG1vdmVUbyhlLHIpe3MmJnQuYWRkKCJMIixzKTtzPVtlLHJdO3QuYWRkKCJNIixbZSxyXSl9ZnVuY3Rpb24gbGluZVRvKGUscil7dC5hZGQoIkwiLFtlLHJdKX1mdW5jdGlvbiBxdWFkcmF0aWNDdXJ2ZVRvKGUscixhLG4pe3QuYWRkKCJRIixbZSxyLGEsbl0pfWxldCBhPTA7Y29uc3Qgbj1yZWFkSW50MTYoZSxhKTtsZXQgaSxzPW51bGwsbz0wLGM9MDthKz0xMDtpZihuPDApZG97aT1yZWFkVWludDE2KGUsYSk7Y29uc3Qgbj1yZWFkVWludDE2KGUsYSsyKTthKz00O2xldCBzLGw7aWYoMSZpKXtpZigyJmkpe3M9cmVhZEludDE2KGUsYSk7bD1yZWFkSW50MTYoZSxhKzIpfWVsc2V7cz1yZWFkVWludDE2KGUsYSk7bD1yZWFkVWludDE2KGUsYSsyKX1hKz00fWVsc2UgaWYoMiZpKXtzPXJlYWRJbnQ4KGUsYSsrKTtsPXJlYWRJbnQ4KGUsYSsrKX1lbHNle3M9ZVthKytdO2w9ZVthKytdfWlmKDImaSl7bz1zO2M9bH1lbHNle289MDtjPTB9bGV0IGg9MSx1PTEsZD0wLGY9MDtpZig4Jmkpe2g9dT1nZXRGbG9hdDIxNChlLGEpO2ErPTJ9ZWxzZSBpZig2NCZpKXtoPWdldEZsb2F0MjE0KGUsYSk7dT1nZXRGbG9hdDIxNChlLGErMik7YSs9NH1lbHNlIGlmKDEyOCZpKXtoPWdldEZsb2F0MjE0KGUsYSk7ZD1nZXRGbG9hdDIxNChlLGErMik7Zj1nZXRGbG9hdDIxNChlLGErNCk7dT1nZXRGbG9hdDIxNChlLGErNik7YSs9OH1jb25zdCBnPXIuZ2x5cGhzW25dO2lmKGcpe3Quc2F2ZSgpO3QudHJhbnNmb3JtKFtoLGQsZix1LG8sY10pO2NvbXBpbGVHbHlmKGcsdCxyKTt0LnJlc3RvcmUoKX19d2hpbGUoMzImaSk7ZWxzZXtjb25zdCB0PVtdO2xldCByLHM7Zm9yKHI9MDtyPG47cisrKXt0LnB1c2gocmVhZFVpbnQxNihlLGEpKTthKz0yfWErPTIrcmVhZFVpbnQxNihlLGEpO2NvbnN0IGw9dC5hdCgtMSkrMSxoPVtdO2Zvcig7aC5sZW5ndGg8bDspe2k9ZVthKytdO2xldCB0PTE7OCZpJiYodCs9ZVthKytdKTtmb3IoO3QtLSA+MDspaC5wdXNoKHtmbGFnczppfSl9Zm9yKHI9MDtyPGw7cisrKXtzd2l0Y2goMTgmaFtyXS5mbGFncyl7Y2FzZSAwOm8rPXJlYWRJbnQxNihlLGEpO2ErPTI7YnJlYWs7Y2FzZSAyOm8tPWVbYSsrXTticmVhaztjYXNlIDE4Om8rPWVbYSsrXX1oW3JdLng9b31mb3Iocj0wO3I8bDtyKyspe3N3aXRjaCgzNiZoW3JdLmZsYWdzKXtjYXNlIDA6Yys9cmVhZEludDE2KGUsYSk7YSs9MjticmVhaztjYXNlIDQ6Yy09ZVthKytdO2JyZWFrO2Nhc2UgMzY6Yys9ZVthKytdfWhbcl0ueT1jfWxldCB1PTA7Zm9yKGE9MDthPG47YSsrKXtjb25zdCBlPXRbYV0sbj1oLnNsaWNlKHUsZSsxKTtpZigxJm5bMF0uZmxhZ3Mpbi5wdXNoKG5bMF0pO2Vsc2UgaWYoMSZuLmF0KC0xKS5mbGFncyluLnVuc2hpZnQobi5hdCgtMSkpO2Vsc2V7Y29uc3QgZT17ZmxhZ3M6MSx4OihuWzBdLngrbi5hdCgtMSkueCkvMix5OihuWzBdLnkrbi5hdCgtMSkueSkvMn07bi51bnNoaWZ0KGUpO24ucHVzaChlKX1tb3ZlVG8oblswXS54LG5bMF0ueSk7Zm9yKHI9MSxzPW4ubGVuZ3RoO3I8cztyKyspaWYoMSZuW3JdLmZsYWdzKWxpbmVUbyhuW3JdLngsbltyXS55KTtlbHNlIGlmKDEmbltyKzFdLmZsYWdzKXtxdWFkcmF0aWNDdXJ2ZVRvKG5bcl0ueCxuW3JdLnksbltyKzFdLngsbltyKzFdLnkpO3IrK31lbHNlIHF1YWRyYXRpY0N1cnZlVG8obltyXS54LG5bcl0ueSwobltyXS54K25bcisxXS54KS8yLChuW3JdLnkrbltyKzFdLnkpLzIpO3U9ZSsxfX19ZnVuY3Rpb24gY29tcGlsZUNoYXJTdHJpbmcoZSx0LHIsYSl7ZnVuY3Rpb24gbW92ZVRvKGUscil7YyYmdC5hZGQoIkwiLGMpO2M9W2Uscl07dC5hZGQoIk0iLFtlLHJdKX1mdW5jdGlvbiBsaW5lVG8oZSxyKXt0LmFkZCgiTCIsW2Uscl0pfWZ1bmN0aW9uIGJlemllckN1cnZlVG8oZSxyLGEsbixpLHMpe3QuYWRkKCJDIixbZSxyLGEsbixpLHNdKX1jb25zdCBuPVtdO2xldCBpPTAscz0wLG89MCxjPW51bGw7IWZ1bmN0aW9uIHBhcnNlKGUpe2xldCBjPTA7Zm9yKDtjPGUubGVuZ3RoOyl7bGV0IGwsaCx1LGQsZixnLHAsbSxiLHk9ITEsdz1lW2MrK107c3dpdGNoKHcpe2Nhc2UgMTpjYXNlIDM6Y2FzZSAxODpjYXNlIDIzOm8rPW4ubGVuZ3RoPj4xO3k9ITA7YnJlYWs7Y2FzZSA0OnMrPW4ucG9wKCk7bW92ZVRvKGkscyk7eT0hMDticmVhaztjYXNlIDU6Zm9yKDtuLmxlbmd0aD4wOyl7aSs9bi5zaGlmdCgpO3MrPW4uc2hpZnQoKTtsaW5lVG8oaSxzKX1icmVhaztjYXNlIDY6Zm9yKDtuLmxlbmd0aD4wOyl7aSs9bi5zaGlmdCgpO2xpbmVUbyhpLHMpO2lmKDA9PT1uLmxlbmd0aClicmVhaztzKz1uLnNoaWZ0KCk7bGluZVRvKGkscyl9YnJlYWs7Y2FzZSA3OmZvcig7bi5sZW5ndGg+MDspe3MrPW4uc2hpZnQoKTtsaW5lVG8oaSxzKTtpZigwPT09bi5sZW5ndGgpYnJlYWs7aSs9bi5zaGlmdCgpO2xpbmVUbyhpLHMpfWJyZWFrO2Nhc2UgODpmb3IoO24ubGVuZ3RoPjA7KXtsPWkrbi5zaGlmdCgpO3U9cytuLnNoaWZ0KCk7aD1sK24uc2hpZnQoKTtkPXUrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7cz1kK24uc2hpZnQoKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKX1icmVhaztjYXNlIDEwOm09bi5wb3AoKTtiPW51bGw7aWYoci5pc0NGRkNJREZvbnQpe2NvbnN0IGU9ci5mZFNlbGVjdC5nZXRGREluZGV4KGEpO2lmKGU+PTAmJmU8ci5mZEFycmF5Lmxlbmd0aCl7Y29uc3QgdD1yLmZkQXJyYXlbZV07bGV0IGE7dC5wcml2YXRlRGljdD8uc3VicnNJbmRleCYmKGE9dC5wcml2YXRlRGljdC5zdWJyc0luZGV4Lm9iamVjdHMpO2lmKGEpe20rPWdldFN1YnJvdXRpbmVCaWFzKGEpO2I9YVttXX19ZWxzZSB3YXJuKCJJbnZhbGlkIGZkIGluZGV4IGZvciBnbHlwaCBpbmRleC4iKX1lbHNlIGI9ci5zdWJyc1ttK3Iuc3VicnNCaWFzXTtiJiZwYXJzZShiKTticmVhaztjYXNlIDExOnJldHVybjtjYXNlIDEyOnc9ZVtjKytdO3N3aXRjaCh3KXtjYXNlIDM0Omw9aStuLnNoaWZ0KCk7aD1sK24uc2hpZnQoKTtmPXMrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7YmV6aWVyQ3VydmVUbyhsLHMsaCxmLGksZik7bD1pK24uc2hpZnQoKTtoPWwrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7YmV6aWVyQ3VydmVUbyhsLGYsaCxzLGkscyk7YnJlYWs7Y2FzZSAzNTpsPWkrbi5zaGlmdCgpO3U9cytuLnNoaWZ0KCk7aD1sK24uc2hpZnQoKTtkPXUrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7cz1kK24uc2hpZnQoKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKTtsPWkrbi5zaGlmdCgpO3U9cytuLnNoaWZ0KCk7aD1sK24uc2hpZnQoKTtkPXUrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7cz1kK24uc2hpZnQoKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKTtuLnBvcCgpO2JyZWFrO2Nhc2UgMzY6bD1pK24uc2hpZnQoKTtmPXMrbi5zaGlmdCgpO2g9bCtuLnNoaWZ0KCk7Zz1mK24uc2hpZnQoKTtpPWgrbi5zaGlmdCgpO2JlemllckN1cnZlVG8obCxmLGgsZyxpLGcpO2w9aStuLnNoaWZ0KCk7aD1sK24uc2hpZnQoKTtwPWcrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7YmV6aWVyQ3VydmVUbyhsLGcsaCxwLGkscyk7YnJlYWs7Y2FzZSAzNzpjb25zdCBlPWksdD1zO2w9aStuLnNoaWZ0KCk7dT1zK24uc2hpZnQoKTtoPWwrbi5zaGlmdCgpO2Q9dStuLnNoaWZ0KCk7aT1oK24uc2hpZnQoKTtzPWQrbi5zaGlmdCgpO2JlemllckN1cnZlVG8obCx1LGgsZCxpLHMpO2w9aStuLnNoaWZ0KCk7dT1zK24uc2hpZnQoKTtoPWwrbi5zaGlmdCgpO2Q9dStuLnNoaWZ0KCk7aT1oO3M9ZDtNYXRoLmFicyhpLWUpPk1hdGguYWJzKHMtdCk/aSs9bi5zaGlmdCgpOnMrPW4uc2hpZnQoKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKTticmVhaztkZWZhdWx0OnRocm93IG5ldyBGb3JtYXRFcnJvcihgdW5rbm93biBvcGVyYXRvcjogMTIgJHt3fWApfWJyZWFrO2Nhc2UgMTQ6aWYobi5sZW5ndGg+PTQpe2NvbnN0IGU9bi5wb3AoKSxhPW4ucG9wKCk7cz1uLnBvcCgpO2k9bi5wb3AoKTt0LnNhdmUoKTt0LnRyYW5zbGF0ZShpLHMpO2xldCBvPWxvb2t1cENtYXAoci5jbWFwLFN0cmluZy5mcm9tQ2hhckNvZGUoci5nbHlwaE5hbWVNYXBbaGFbZV1dKSk7Y29tcGlsZUNoYXJTdHJpbmcoci5nbHlwaHNbby5nbHlwaElkXSx0LHIsby5nbHlwaElkKTt0LnJlc3RvcmUoKTtvPWxvb2t1cENtYXAoci5jbWFwLFN0cmluZy5mcm9tQ2hhckNvZGUoci5nbHlwaE5hbWVNYXBbaGFbYV1dKSk7Y29tcGlsZUNoYXJTdHJpbmcoci5nbHlwaHNbby5nbHlwaElkXSx0LHIsby5nbHlwaElkKX1yZXR1cm47Y2FzZSAxOTpjYXNlIDIwOm8rPW4ubGVuZ3RoPj4xO2MrPW8rNz4+Mzt5PSEwO2JyZWFrO2Nhc2UgMjE6cys9bi5wb3AoKTtpKz1uLnBvcCgpO21vdmVUbyhpLHMpO3k9ITA7YnJlYWs7Y2FzZSAyMjppKz1uLnBvcCgpO21vdmVUbyhpLHMpO3k9ITA7YnJlYWs7Y2FzZSAyNDpmb3IoO24ubGVuZ3RoPjI7KXtsPWkrbi5zaGlmdCgpO3U9cytuLnNoaWZ0KCk7aD1sK24uc2hpZnQoKTtkPXUrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7cz1kK24uc2hpZnQoKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKX1pKz1uLnNoaWZ0KCk7cys9bi5zaGlmdCgpO2xpbmVUbyhpLHMpO2JyZWFrO2Nhc2UgMjU6Zm9yKDtuLmxlbmd0aD42Oyl7aSs9bi5zaGlmdCgpO3MrPW4uc2hpZnQoKTtsaW5lVG8oaSxzKX1sPWkrbi5zaGlmdCgpO3U9cytuLnNoaWZ0KCk7aD1sK24uc2hpZnQoKTtkPXUrbi5zaGlmdCgpO2k9aCtuLnNoaWZ0KCk7cz1kK24uc2hpZnQoKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKTticmVhaztjYXNlIDI2Om4ubGVuZ3RoJTImJihpKz1uLnNoaWZ0KCkpO2Zvcig7bi5sZW5ndGg+MDspe2w9aTt1PXMrbi5zaGlmdCgpO2g9bCtuLnNoaWZ0KCk7ZD11K24uc2hpZnQoKTtpPWg7cz1kK24uc2hpZnQoKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKX1icmVhaztjYXNlIDI3Om4ubGVuZ3RoJTImJihzKz1uLnNoaWZ0KCkpO2Zvcig7bi5sZW5ndGg+MDspe2w9aStuLnNoaWZ0KCk7dT1zO2g9bCtuLnNoaWZ0KCk7ZD11K24uc2hpZnQoKTtpPWgrbi5zaGlmdCgpO3M9ZDtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKX1icmVhaztjYXNlIDI4Om4ucHVzaChyZWFkSW50MTYoZSxjKSk7Yys9MjticmVhaztjYXNlIDI5Om09bi5wb3AoKStyLmdzdWJyc0JpYXM7Yj1yLmdzdWJyc1ttXTtiJiZwYXJzZShiKTticmVhaztjYXNlIDMwOmZvcig7bi5sZW5ndGg+MDspe2w9aTt1PXMrbi5zaGlmdCgpO2g9bCtuLnNoaWZ0KCk7ZD11K24uc2hpZnQoKTtpPWgrbi5zaGlmdCgpO3M9ZCsoMT09PW4ubGVuZ3RoP24uc2hpZnQoKTowKTtiZXppZXJDdXJ2ZVRvKGwsdSxoLGQsaSxzKTtpZigwPT09bi5sZW5ndGgpYnJlYWs7bD1pK24uc2hpZnQoKTt1PXM7aD1sK24uc2hpZnQoKTtkPXUrbi5zaGlmdCgpO3M9ZCtuLnNoaWZ0KCk7aT1oKygxPT09bi5sZW5ndGg/bi5zaGlmdCgpOjApO2JlemllckN1cnZlVG8obCx1LGgsZCxpLHMpfWJyZWFrO2Nhc2UgMzE6Zm9yKDtuLmxlbmd0aD4wOyl7bD1pK24uc2hpZnQoKTt1PXM7aD1sK24uc2hpZnQoKTtkPXUrbi5zaGlmdCgpO3M9ZCtuLnNoaWZ0KCk7aT1oKygxPT09bi5sZW5ndGg/bi5zaGlmdCgpOjApO2JlemllckN1cnZlVG8obCx1LGgsZCxpLHMpO2lmKDA9PT1uLmxlbmd0aClicmVhaztsPWk7dT1zK24uc2hpZnQoKTtoPWwrbi5zaGlmdCgpO2Q9dStuLnNoaWZ0KCk7aT1oK24uc2hpZnQoKTtzPWQrKDE9PT1uLmxlbmd0aD9uLnNoaWZ0KCk6MCk7YmV6aWVyQ3VydmVUbyhsLHUsaCxkLGkscyl9YnJlYWs7ZGVmYXVsdDppZih3PDMyKXRocm93IG5ldyBGb3JtYXRFcnJvcihgdW5rbm93biBvcGVyYXRvcjogJHt3fWApO2lmKHc8MjQ3KW4ucHVzaCh3LTEzOSk7ZWxzZSBpZih3PDI1MSluLnB1c2goMjU2Kih3LTI0NykrZVtjKytdKzEwOCk7ZWxzZSBpZih3PDI1NSluLnB1c2goMjU2Ki0ody0yNTEpLWVbYysrXS0xMDgpO2Vsc2V7bi5wdXNoKChlW2NdPDwyNHxlW2MrMV08PDE2fGVbYysyXTw8OHxlW2MrM10pLzY1NTM2KTtjKz00fX15JiYobi5sZW5ndGg9MCl9fShlKX1jbGFzcyBDb21tYW5kc3tjbWRzPVtdO3RyYW5zZm9ybVN0YWNrPVtdO2N1cnJlbnRUcmFuc2Zvcm09WzEsMCwwLDEsMCwwXTthZGQoZSx0KXtpZih0KXtjb25zdHtjdXJyZW50VHJhbnNmb3JtOnJ9PXRoaXM7Zm9yKGxldCBlPTAsYT10Lmxlbmd0aDtlPGE7ZSs9MilVdGlsLmFwcGx5VHJhbnNmb3JtKHQscixlKTt0aGlzLmNtZHMucHVzaChgJHtlfSR7dC5qb2luKCIgIil9YCl9ZWxzZSB0aGlzLmNtZHMucHVzaChlKX10cmFuc2Zvcm0oZSl7dGhpcy5jdXJyZW50VHJhbnNmb3JtPVV0aWwudHJhbnNmb3JtKHRoaXMuY3VycmVudFRyYW5zZm9ybSxlKX10cmFuc2xhdGUoZSx0KXt0aGlzLnRyYW5zZm9ybShbMSwwLDAsMSxlLHRdKX1zYXZlKCl7dGhpcy50cmFuc2Zvcm1TdGFjay5wdXNoKHRoaXMuY3VycmVudFRyYW5zZm9ybS5zbGljZSgpKX1yZXN0b3JlKCl7dGhpcy5jdXJyZW50VHJhbnNmb3JtPXRoaXMudHJhbnNmb3JtU3RhY2sucG9wKCl8fFsxLDAsMCwxLDAsMF19Z2V0U1ZHKCl7cmV0dXJuIHRoaXMuY21kcy5qb2luKCIiKX19Y2xhc3MgQ29tcGlsZWRGb250e2NvbnN0cnVjdG9yKGUpe3RoaXMuZm9udE1hdHJpeD1lO3RoaXMuY29tcGlsZWRHbHlwaHM9T2JqZWN0LmNyZWF0ZShudWxsKTt0aGlzLmNvbXBpbGVkQ2hhckNvZGVUb0dseXBoSWQ9T2JqZWN0LmNyZWF0ZShudWxsKX1nZXRQYXRoSnMoZSl7Y29uc3R7Y2hhckNvZGU6dCxnbHlwaElkOnJ9PWxvb2t1cENtYXAodGhpcy5jbWFwLGUpO2xldCBhLG49dGhpcy5jb21waWxlZEdseXBoc1tyXTtpZih2b2lkIDA9PT1uKXt0cnl7bj10aGlzLmNvbXBpbGVHbHlwaCh0aGlzLmdseXBoc1tyXSxyKX1jYXRjaChlKXtuPSIiO2E9ZX10aGlzLmNvbXBpbGVkR2x5cGhzW3JdPW59dGhpcy5jb21waWxlZENoYXJDb2RlVG9HbHlwaElkW3RdPz89cjtpZihhKXRocm93IGE7cmV0dXJuIG59Y29tcGlsZUdseXBoKGUsdCl7aWYoIWU/Lmxlbmd0aHx8MTQ9PT1lWzBdKXJldHVybiIiO2xldCByPXRoaXMuZm9udE1hdHJpeDtpZih0aGlzLmlzQ0ZGQ0lERm9udCl7Y29uc3QgZT10aGlzLmZkU2VsZWN0LmdldEZESW5kZXgodCk7aWYoZT49MCYmZTx0aGlzLmZkQXJyYXkubGVuZ3RoKXtyPXRoaXMuZmRBcnJheVtlXS5nZXRCeU5hbWUoIkZvbnRNYXRyaXgiKXx8YX1lbHNlIHdhcm4oIkludmFsaWQgZmQgaW5kZXggZm9yIGdseXBoIGluZGV4LiIpfWFzc2VydChpc051bWJlckFycmF5KHIsNiksIkV4cGVjdGVkIGEgdmFsaWQgZm9udE1hdHJpeC4iKTtjb25zdCBuPW5ldyBDb21tYW5kcztuLnRyYW5zZm9ybShyLnNsaWNlKCkpO3RoaXMuY29tcGlsZUdseXBoSW1wbChlLG4sdCk7bi5hZGQoIloiKTtyZXR1cm4gbi5nZXRTVkcoKX1jb21waWxlR2x5cGhJbXBsKCl7dW5yZWFjaGFibGUoIkNoaWxkcmVuIGNsYXNzZXMgc2hvdWxkIGltcGxlbWVudCB0aGlzLiIpfWhhc0J1aWx0UGF0aChlKXtjb25zdHtjaGFyQ29kZTp0LGdseXBoSWQ6cn09bG9va3VwQ21hcCh0aGlzLmNtYXAsZSk7cmV0dXJuIHZvaWQgMCE9PXRoaXMuY29tcGlsZWRHbHlwaHNbcl0mJnZvaWQgMCE9PXRoaXMuY29tcGlsZWRDaGFyQ29kZVRvR2x5cGhJZFt0XX19Y2xhc3MgVHJ1ZVR5cGVDb21waWxlZCBleHRlbmRzIENvbXBpbGVkRm9udHtjb25zdHJ1Y3RvcihlLHQscil7c3VwZXIocnx8WzQ4OGUtNiwwLDAsNDg4ZS02LDAsMF0pO3RoaXMuZ2x5cGhzPWU7dGhpcy5jbWFwPXR9Y29tcGlsZUdseXBoSW1wbChlLHQpe2NvbXBpbGVHbHlmKGUsdCx0aGlzKX19Y2xhc3MgVHlwZTJDb21waWxlZCBleHRlbmRzIENvbXBpbGVkRm9udHtjb25zdHJ1Y3RvcihlLHQscil7c3VwZXIocnx8Wy4wMDEsMCwwLC4wMDEsMCwwXSk7dGhpcy5nbHlwaHM9ZS5nbHlwaHM7dGhpcy5nc3VicnM9ZS5nc3VicnN8fFtdO3RoaXMuc3VicnM9ZS5zdWJyc3x8W107dGhpcy5jbWFwPXQ7dGhpcy5nbHlwaE5hbWVNYXA9Z2EoKTt0aGlzLmdzdWJyc0JpYXM9Z2V0U3Vicm91dGluZUJpYXModGhpcy5nc3VicnMpO3RoaXMuc3VicnNCaWFzPWdldFN1YnJvdXRpbmVCaWFzKHRoaXMuc3VicnMpO3RoaXMuaXNDRkZDSURGb250PWUuaXNDRkZDSURGb250O3RoaXMuZmRTZWxlY3Q9ZS5mZFNlbGVjdDt0aGlzLmZkQXJyYXk9ZS5mZEFycmF5fWNvbXBpbGVHbHlwaEltcGwoZSx0LHIpe2NvbXBpbGVDaGFyU3RyaW5nKGUsdCx0aGlzLHIpfX1jbGFzcyBGb250UmVuZGVyZXJGYWN0b3J5e3N0YXRpYyBjcmVhdGUoZSx0KXtjb25zdCByPW5ldyBVaW50OEFycmF5KGUuZGF0YSk7bGV0IGEsbixpLHMsbyxjO2NvbnN0IGw9cmVhZFVpbnQxNihyLDQpO2ZvcihsZXQgZT0wLGg9MTI7ZTxsO2UrKyxoKz0xNil7Y29uc3QgZT1ieXRlc1RvU3RyaW5nKHIuc3ViYXJyYXkoaCxoKzQpKSxsPXJlYWRVaW50MzIocixoKzgpLHU9cmVhZFVpbnQzMihyLGgrMTIpO3N3aXRjaChlKXtjYXNlImNtYXAiOmE9cGFyc2VDbWFwKHIsbCk7YnJlYWs7Y2FzZSJnbHlmIjpuPXIuc3ViYXJyYXkobCxsK3UpO2JyZWFrO2Nhc2UibG9jYSI6aT1yLnN1YmFycmF5KGwsbCt1KTticmVhaztjYXNlImhlYWQiOmM9cmVhZFVpbnQxNihyLGwrMTgpO289cmVhZFVpbnQxNihyLGwrNTApO2JyZWFrO2Nhc2UiQ0ZGICI6cz1wYXJzZUNmZihyLGwsbCt1LHQpfX1pZihuKXtjb25zdCB0PWM/WzEvYywwLDAsMS9jLDAsMF06ZS5mb250TWF0cml4O3JldHVybiBuZXcgVHJ1ZVR5cGVDb21waWxlZChmdW5jdGlvbiBwYXJzZUdseWZUYWJsZShlLHQscil7bGV0IGEsbjtpZihyKXthPTQ7bj1yZWFkVWludDMyfWVsc2V7YT0yO249KGUsdCk9PjIqcmVhZFVpbnQxNihlLHQpfWNvbnN0IGk9W107bGV0IHM9bih0LDApO2ZvcihsZXQgcj1hO3I8dC5sZW5ndGg7cis9YSl7Y29uc3QgYT1uKHQscik7aS5wdXNoKGUuc3ViYXJyYXkocyxhKSk7cz1hfXJldHVybiBpfShuLGksbyksYSx0KX1yZXR1cm4gbmV3IFR5cGUyQ29tcGlsZWQocyxhLGUuZm9udE1hdHJpeCl9fWNvbnN0IHphPWdldExvb2t1cFRhYmxlRmFjdG9yeShmdW5jdGlvbihlKXtlLkNvdXJpZXI9NjAwO2VbIkNvdXJpZXItQm9sZCJdPTYwMDtlWyJDb3VyaWVyLUJvbGRPYmxpcXVlIl09NjAwO2VbIkNvdXJpZXItT2JsaXF1ZSJdPTYwMDtlLkhlbHZldGljYT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5zcGFjZT0yNzg7ZS5leGNsYW09Mjc4O2UucXVvdGVkYmw9MzU1O2UubnVtYmVyc2lnbj01NTY7ZS5kb2xsYXI9NTU2O2UucGVyY2VudD04ODk7ZS5hbXBlcnNhbmQ9NjY3O2UucXVvdGVyaWdodD0yMjI7ZS5wYXJlbmxlZnQ9MzMzO2UucGFyZW5yaWdodD0zMzM7ZS5hc3Rlcmlzaz0zODk7ZS5wbHVzPTU4NDtlLmNvbW1hPTI3ODtlLmh5cGhlbj0zMzM7ZS5wZXJpb2Q9Mjc4O2Uuc2xhc2g9Mjc4O2UuemVybz01NTY7ZS5vbmU9NTU2O2UudHdvPTU1NjtlLnRocmVlPTU1NjtlLmZvdXI9NTU2O2UuZml2ZT01NTY7ZS5zaXg9NTU2O2Uuc2V2ZW49NTU2O2UuZWlnaHQ9NTU2O2UubmluZT01NTY7ZS5jb2xvbj0yNzg7ZS5zZW1pY29sb249Mjc4O2UubGVzcz01ODQ7ZS5lcXVhbD01ODQ7ZS5ncmVhdGVyPTU4NDtlLnF1ZXN0aW9uPTU1NjtlLmF0PTEwMTU7ZS5BPTY2NztlLkI9NjY3O2UuQz03MjI7ZS5EPTcyMjtlLkU9NjY3O2UuRj02MTE7ZS5HPTc3ODtlLkg9NzIyO2UuST0yNzg7ZS5KPTUwMDtlLks9NjY3O2UuTD01NTY7ZS5NPTgzMztlLk49NzIyO2UuTz03Nzg7ZS5QPTY2NztlLlE9Nzc4O2UuUj03MjI7ZS5TPTY2NztlLlQ9NjExO2UuVT03MjI7ZS5WPTY2NztlLlc9OTQ0O2UuWD02Njc7ZS5ZPTY2NztlLlo9NjExO2UuYnJhY2tldGxlZnQ9Mjc4O2UuYmFja3NsYXNoPTI3ODtlLmJyYWNrZXRyaWdodD0yNzg7ZS5hc2NpaWNpcmN1bT00Njk7ZS51bmRlcnNjb3JlPTU1NjtlLnF1b3RlbGVmdD0yMjI7ZS5hPTU1NjtlLmI9NTU2O2UuYz01MDA7ZS5kPTU1NjtlLmU9NTU2O2UuZj0yNzg7ZS5nPTU1NjtlLmg9NTU2O2UuaT0yMjI7ZS5qPTIyMjtlLms9NTAwO2UubD0yMjI7ZS5tPTgzMztlLm49NTU2O2Uubz01NTY7ZS5wPTU1NjtlLnE9NTU2O2Uucj0zMzM7ZS5zPTUwMDtlLnQ9Mjc4O2UudT01NTY7ZS52PTUwMDtlLnc9NzIyO2UueD01MDA7ZS55PTUwMDtlLno9NTAwO2UuYnJhY2VsZWZ0PTMzNDtlLmJhcj0yNjA7ZS5icmFjZXJpZ2h0PTMzNDtlLmFzY2lpdGlsZGU9NTg0O2UuZXhjbGFtZG93bj0zMzM7ZS5jZW50PTU1NjtlLnN0ZXJsaW5nPTU1NjtlLmZyYWN0aW9uPTE2NztlLnllbj01NTY7ZS5mbG9yaW49NTU2O2Uuc2VjdGlvbj01NTY7ZS5jdXJyZW5jeT01NTY7ZS5xdW90ZXNpbmdsZT0xOTE7ZS5xdW90ZWRibGxlZnQ9MzMzO2UuZ3VpbGxlbW90bGVmdD01NTY7ZS5ndWlsc2luZ2xsZWZ0PTMzMztlLmd1aWxzaW5nbHJpZ2h0PTMzMztlLmZpPTUwMDtlLmZsPTUwMDtlLmVuZGFzaD01NTY7ZS5kYWdnZXI9NTU2O2UuZGFnZ2VyZGJsPTU1NjtlLnBlcmlvZGNlbnRlcmVkPTI3ODtlLnBhcmFncmFwaD01Mzc7ZS5idWxsZXQ9MzUwO2UucXVvdGVzaW5nbGJhc2U9MjIyO2UucXVvdGVkYmxiYXNlPTMzMztlLnF1b3RlZGJscmlnaHQ9MzMzO2UuZ3VpbGxlbW90cmlnaHQ9NTU2O2UuZWxsaXBzaXM9MWUzO2UucGVydGhvdXNhbmQ9MWUzO2UucXVlc3Rpb25kb3duPTYxMTtlLmdyYXZlPTMzMztlLmFjdXRlPTMzMztlLmNpcmN1bWZsZXg9MzMzO2UudGlsZGU9MzMzO2UubWFjcm9uPTMzMztlLmJyZXZlPTMzMztlLmRvdGFjY2VudD0zMzM7ZS5kaWVyZXNpcz0zMzM7ZS5yaW5nPTMzMztlLmNlZGlsbGE9MzMzO2UuaHVuZ2FydW1sYXV0PTMzMztlLm9nb25laz0zMzM7ZS5jYXJvbj0zMzM7ZS5lbWRhc2g9MWUzO2UuQUU9MWUzO2Uub3JkZmVtaW5pbmU9MzcwO2UuTHNsYXNoPTU1NjtlLk9zbGFzaD03Nzg7ZS5PRT0xZTM7ZS5vcmRtYXNjdWxpbmU9MzY1O2UuYWU9ODg5O2UuZG90bGVzc2k9Mjc4O2UubHNsYXNoPTIyMjtlLm9zbGFzaD02MTE7ZS5vZT05NDQ7ZS5nZXJtYW5kYmxzPTYxMTtlLklkaWVyZXNpcz0yNzg7ZS5lYWN1dGU9NTU2O2UuYWJyZXZlPTU1NjtlLnVodW5nYXJ1bWxhdXQ9NTU2O2UuZWNhcm9uPTU1NjtlLllkaWVyZXNpcz02Njc7ZS5kaXZpZGU9NTg0O2UuWWFjdXRlPTY2NztlLkFjaXJjdW1mbGV4PTY2NztlLmFhY3V0ZT01NTY7ZS5VY2lyY3VtZmxleD03MjI7ZS55YWN1dGU9NTAwO2Uuc2NvbW1hYWNjZW50PTUwMDtlLmVjaXJjdW1mbGV4PTU1NjtlLlVyaW5nPTcyMjtlLlVkaWVyZXNpcz03MjI7ZS5hb2dvbmVrPTU1NjtlLlVhY3V0ZT03MjI7ZS51b2dvbmVrPTU1NjtlLkVkaWVyZXNpcz02Njc7ZS5EY3JvYXQ9NzIyO2UuY29tbWFhY2NlbnQ9MjUwO2UuY29weXJpZ2h0PTczNztlLkVtYWNyb249NjY3O2UuY2Nhcm9uPTUwMDtlLmFyaW5nPTU1NjtlLk5jb21tYWFjY2VudD03MjI7ZS5sYWN1dGU9MjIyO2UuYWdyYXZlPTU1NjtlLlRjb21tYWFjY2VudD02MTE7ZS5DYWN1dGU9NzIyO2UuYXRpbGRlPTU1NjtlLkVkb3RhY2NlbnQ9NjY3O2Uuc2Nhcm9uPTUwMDtlLnNjZWRpbGxhPTUwMDtlLmlhY3V0ZT0yNzg7ZS5sb3plbmdlPTQ3MTtlLlJjYXJvbj03MjI7ZS5HY29tbWFhY2NlbnQ9Nzc4O2UudWNpcmN1bWZsZXg9NTU2O2UuYWNpcmN1bWZsZXg9NTU2O2UuQW1hY3Jvbj02Njc7ZS5yY2Fyb249MzMzO2UuY2NlZGlsbGE9NTAwO2UuWmRvdGFjY2VudD02MTE7ZS5UaG9ybj02Njc7ZS5PbWFjcm9uPTc3ODtlLlJhY3V0ZT03MjI7ZS5TYWN1dGU9NjY3O2UuZGNhcm9uPTY0MztlLlVtYWNyb249NzIyO2UudXJpbmc9NTU2O2UudGhyZWVzdXBlcmlvcj0zMzM7ZS5PZ3JhdmU9Nzc4O2UuQWdyYXZlPTY2NztlLkFicmV2ZT02Njc7ZS5tdWx0aXBseT01ODQ7ZS51YWN1dGU9NTU2O2UuVGNhcm9uPTYxMTtlLnBhcnRpYWxkaWZmPTQ3NjtlLnlkaWVyZXNpcz01MDA7ZS5OYWN1dGU9NzIyO2UuaWNpcmN1bWZsZXg9Mjc4O2UuRWNpcmN1bWZsZXg9NjY3O2UuYWRpZXJlc2lzPTU1NjtlLmVkaWVyZXNpcz01NTY7ZS5jYWN1dGU9NTAwO2UubmFjdXRlPTU1NjtlLnVtYWNyb249NTU2O2UuTmNhcm9uPTcyMjtlLklhY3V0ZT0yNzg7ZS5wbHVzbWludXM9NTg0O2UuYnJva2VuYmFyPTI2MDtlLnJlZ2lzdGVyZWQ9NzM3O2UuR2JyZXZlPTc3ODtlLklkb3RhY2NlbnQ9Mjc4O2Uuc3VtbWF0aW9uPTYwMDtlLkVncmF2ZT02Njc7ZS5yYWN1dGU9MzMzO2Uub21hY3Jvbj01NTY7ZS5aYWN1dGU9NjExO2UuWmNhcm9uPTYxMTtlLmdyZWF0ZXJlcXVhbD01NDk7ZS5FdGg9NzIyO2UuQ2NlZGlsbGE9NzIyO2UubGNvbW1hYWNjZW50PTIyMjtlLnRjYXJvbj0zMTc7ZS5lb2dvbmVrPTU1NjtlLlVvZ29uZWs9NzIyO2UuQWFjdXRlPTY2NztlLkFkaWVyZXNpcz02Njc7ZS5lZ3JhdmU9NTU2O2UuemFjdXRlPTUwMDtlLmlvZ29uZWs9MjIyO2UuT2FjdXRlPTc3ODtlLm9hY3V0ZT01NTY7ZS5hbWFjcm9uPTU1NjtlLnNhY3V0ZT01MDA7ZS5pZGllcmVzaXM9Mjc4O2UuT2NpcmN1bWZsZXg9Nzc4O2UuVWdyYXZlPTcyMjtlLkRlbHRhPTYxMjtlLnRob3JuPTU1NjtlLnR3b3N1cGVyaW9yPTMzMztlLk9kaWVyZXNpcz03Nzg7ZS5tdT01NTY7ZS5pZ3JhdmU9Mjc4O2Uub2h1bmdhcnVtbGF1dD01NTY7ZS5Fb2dvbmVrPTY2NztlLmRjcm9hdD01NTY7ZS50aHJlZXF1YXJ0ZXJzPTgzNDtlLlNjZWRpbGxhPTY2NztlLmxjYXJvbj0yOTk7ZS5LY29tbWFhY2NlbnQ9NjY3O2UuTGFjdXRlPTU1NjtlLnRyYWRlbWFyaz0xZTM7ZS5lZG90YWNjZW50PTU1NjtlLklncmF2ZT0yNzg7ZS5JbWFjcm9uPTI3ODtlLkxjYXJvbj01NTY7ZS5vbmVoYWxmPTgzNDtlLmxlc3NlcXVhbD01NDk7ZS5vY2lyY3VtZmxleD01NTY7ZS5udGlsZGU9NTU2O2UuVWh1bmdhcnVtbGF1dD03MjI7ZS5FYWN1dGU9NjY3O2UuZW1hY3Jvbj01NTY7ZS5nYnJldmU9NTU2O2Uub25lcXVhcnRlcj04MzQ7ZS5TY2Fyb249NjY3O2UuU2NvbW1hYWNjZW50PTY2NztlLk9odW5nYXJ1bWxhdXQ9Nzc4O2UuZGVncmVlPTQwMDtlLm9ncmF2ZT01NTY7ZS5DY2Fyb249NzIyO2UudWdyYXZlPTU1NjtlLnJhZGljYWw9NDUzO2UuRGNhcm9uPTcyMjtlLnJjb21tYWFjY2VudD0zMzM7ZS5OdGlsZGU9NzIyO2Uub3RpbGRlPTU1NjtlLlJjb21tYWFjY2VudD03MjI7ZS5MY29tbWFhY2NlbnQ9NTU2O2UuQXRpbGRlPTY2NztlLkFvZ29uZWs9NjY3O2UuQXJpbmc9NjY3O2UuT3RpbGRlPTc3ODtlLnpkb3RhY2NlbnQ9NTAwO2UuRWNhcm9uPTY2NztlLklvZ29uZWs9Mjc4O2Uua2NvbW1hYWNjZW50PTUwMDtlLm1pbnVzPTU4NDtlLkljaXJjdW1mbGV4PTI3ODtlLm5jYXJvbj01NTY7ZS50Y29tbWFhY2NlbnQ9Mjc4O2UubG9naWNhbG5vdD01ODQ7ZS5vZGllcmVzaXM9NTU2O2UudWRpZXJlc2lzPTU1NjtlLm5vdGVxdWFsPTU0OTtlLmdjb21tYWFjY2VudD01NTY7ZS5ldGg9NTU2O2UuemNhcm9uPTUwMDtlLm5jb21tYWFjY2VudD01NTY7ZS5vbmVzdXBlcmlvcj0zMzM7ZS5pbWFjcm9uPTI3ODtlLkV1cm89NTU2fSk7ZVsiSGVsdmV0aWNhLUJvbGQiXT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5zcGFjZT0yNzg7ZS5leGNsYW09MzMzO2UucXVvdGVkYmw9NDc0O2UubnVtYmVyc2lnbj01NTY7ZS5kb2xsYXI9NTU2O2UucGVyY2VudD04ODk7ZS5hbXBlcnNhbmQ9NzIyO2UucXVvdGVyaWdodD0yNzg7ZS5wYXJlbmxlZnQ9MzMzO2UucGFyZW5yaWdodD0zMzM7ZS5hc3Rlcmlzaz0zODk7ZS5wbHVzPTU4NDtlLmNvbW1hPTI3ODtlLmh5cGhlbj0zMzM7ZS5wZXJpb2Q9Mjc4O2Uuc2xhc2g9Mjc4O2UuemVybz01NTY7ZS5vbmU9NTU2O2UudHdvPTU1NjtlLnRocmVlPTU1NjtlLmZvdXI9NTU2O2UuZml2ZT01NTY7ZS5zaXg9NTU2O2Uuc2V2ZW49NTU2O2UuZWlnaHQ9NTU2O2UubmluZT01NTY7ZS5jb2xvbj0zMzM7ZS5zZW1pY29sb249MzMzO2UubGVzcz01ODQ7ZS5lcXVhbD01ODQ7ZS5ncmVhdGVyPTU4NDtlLnF1ZXN0aW9uPTYxMTtlLmF0PTk3NTtlLkE9NzIyO2UuQj03MjI7ZS5DPTcyMjtlLkQ9NzIyO2UuRT02Njc7ZS5GPTYxMTtlLkc9Nzc4O2UuSD03MjI7ZS5JPTI3ODtlLko9NTU2O2UuSz03MjI7ZS5MPTYxMTtlLk09ODMzO2UuTj03MjI7ZS5PPTc3ODtlLlA9NjY3O2UuUT03Nzg7ZS5SPTcyMjtlLlM9NjY3O2UuVD02MTE7ZS5VPTcyMjtlLlY9NjY3O2UuVz05NDQ7ZS5YPTY2NztlLlk9NjY3O2UuWj02MTE7ZS5icmFja2V0bGVmdD0zMzM7ZS5iYWNrc2xhc2g9Mjc4O2UuYnJhY2tldHJpZ2h0PTMzMztlLmFzY2lpY2lyY3VtPTU4NDtlLnVuZGVyc2NvcmU9NTU2O2UucXVvdGVsZWZ0PTI3ODtlLmE9NTU2O2UuYj02MTE7ZS5jPTU1NjtlLmQ9NjExO2UuZT01NTY7ZS5mPTMzMztlLmc9NjExO2UuaD02MTE7ZS5pPTI3ODtlLmo9Mjc4O2Uuaz01NTY7ZS5sPTI3ODtlLm09ODg5O2Uubj02MTE7ZS5vPTYxMTtlLnA9NjExO2UucT02MTE7ZS5yPTM4OTtlLnM9NTU2O2UudD0zMzM7ZS51PTYxMTtlLnY9NTU2O2Uudz03Nzg7ZS54PTU1NjtlLnk9NTU2O2Uuej01MDA7ZS5icmFjZWxlZnQ9Mzg5O2UuYmFyPTI4MDtlLmJyYWNlcmlnaHQ9Mzg5O2UuYXNjaWl0aWxkZT01ODQ7ZS5leGNsYW1kb3duPTMzMztlLmNlbnQ9NTU2O2Uuc3Rlcmxpbmc9NTU2O2UuZnJhY3Rpb249MTY3O2UueWVuPTU1NjtlLmZsb3Jpbj01NTY7ZS5zZWN0aW9uPTU1NjtlLmN1cnJlbmN5PTU1NjtlLnF1b3Rlc2luZ2xlPTIzODtlLnF1b3RlZGJsbGVmdD01MDA7ZS5ndWlsbGVtb3RsZWZ0PTU1NjtlLmd1aWxzaW5nbGxlZnQ9MzMzO2UuZ3VpbHNpbmdscmlnaHQ9MzMzO2UuZmk9NjExO2UuZmw9NjExO2UuZW5kYXNoPTU1NjtlLmRhZ2dlcj01NTY7ZS5kYWdnZXJkYmw9NTU2O2UucGVyaW9kY2VudGVyZWQ9Mjc4O2UucGFyYWdyYXBoPTU1NjtlLmJ1bGxldD0zNTA7ZS5xdW90ZXNpbmdsYmFzZT0yNzg7ZS5xdW90ZWRibGJhc2U9NTAwO2UucXVvdGVkYmxyaWdodD01MDA7ZS5ndWlsbGVtb3RyaWdodD01NTY7ZS5lbGxpcHNpcz0xZTM7ZS5wZXJ0aG91c2FuZD0xZTM7ZS5xdWVzdGlvbmRvd249NjExO2UuZ3JhdmU9MzMzO2UuYWN1dGU9MzMzO2UuY2lyY3VtZmxleD0zMzM7ZS50aWxkZT0zMzM7ZS5tYWNyb249MzMzO2UuYnJldmU9MzMzO2UuZG90YWNjZW50PTMzMztlLmRpZXJlc2lzPTMzMztlLnJpbmc9MzMzO2UuY2VkaWxsYT0zMzM7ZS5odW5nYXJ1bWxhdXQ9MzMzO2Uub2dvbmVrPTMzMztlLmNhcm9uPTMzMztlLmVtZGFzaD0xZTM7ZS5BRT0xZTM7ZS5vcmRmZW1pbmluZT0zNzA7ZS5Mc2xhc2g9NjExO2UuT3NsYXNoPTc3ODtlLk9FPTFlMztlLm9yZG1hc2N1bGluZT0zNjU7ZS5hZT04ODk7ZS5kb3RsZXNzaT0yNzg7ZS5sc2xhc2g9Mjc4O2Uub3NsYXNoPTYxMTtlLm9lPTk0NDtlLmdlcm1hbmRibHM9NjExO2UuSWRpZXJlc2lzPTI3ODtlLmVhY3V0ZT01NTY7ZS5hYnJldmU9NTU2O2UudWh1bmdhcnVtbGF1dD02MTE7ZS5lY2Fyb249NTU2O2UuWWRpZXJlc2lzPTY2NztlLmRpdmlkZT01ODQ7ZS5ZYWN1dGU9NjY3O2UuQWNpcmN1bWZsZXg9NzIyO2UuYWFjdXRlPTU1NjtlLlVjaXJjdW1mbGV4PTcyMjtlLnlhY3V0ZT01NTY7ZS5zY29tbWFhY2NlbnQ9NTU2O2UuZWNpcmN1bWZsZXg9NTU2O2UuVXJpbmc9NzIyO2UuVWRpZXJlc2lzPTcyMjtlLmFvZ29uZWs9NTU2O2UuVWFjdXRlPTcyMjtlLnVvZ29uZWs9NjExO2UuRWRpZXJlc2lzPTY2NztlLkRjcm9hdD03MjI7ZS5jb21tYWFjY2VudD0yNTA7ZS5jb3B5cmlnaHQ9NzM3O2UuRW1hY3Jvbj02Njc7ZS5jY2Fyb249NTU2O2UuYXJpbmc9NTU2O2UuTmNvbW1hYWNjZW50PTcyMjtlLmxhY3V0ZT0yNzg7ZS5hZ3JhdmU9NTU2O2UuVGNvbW1hYWNjZW50PTYxMTtlLkNhY3V0ZT03MjI7ZS5hdGlsZGU9NTU2O2UuRWRvdGFjY2VudD02Njc7ZS5zY2Fyb249NTU2O2Uuc2NlZGlsbGE9NTU2O2UuaWFjdXRlPTI3ODtlLmxvemVuZ2U9NDk0O2UuUmNhcm9uPTcyMjtlLkdjb21tYWFjY2VudD03Nzg7ZS51Y2lyY3VtZmxleD02MTE7ZS5hY2lyY3VtZmxleD01NTY7ZS5BbWFjcm9uPTcyMjtlLnJjYXJvbj0zODk7ZS5jY2VkaWxsYT01NTY7ZS5aZG90YWNjZW50PTYxMTtlLlRob3JuPTY2NztlLk9tYWNyb249Nzc4O2UuUmFjdXRlPTcyMjtlLlNhY3V0ZT02Njc7ZS5kY2Fyb249NzQzO2UuVW1hY3Jvbj03MjI7ZS51cmluZz02MTE7ZS50aHJlZXN1cGVyaW9yPTMzMztlLk9ncmF2ZT03Nzg7ZS5BZ3JhdmU9NzIyO2UuQWJyZXZlPTcyMjtlLm11bHRpcGx5PTU4NDtlLnVhY3V0ZT02MTE7ZS5UY2Fyb249NjExO2UucGFydGlhbGRpZmY9NDk0O2UueWRpZXJlc2lzPTU1NjtlLk5hY3V0ZT03MjI7ZS5pY2lyY3VtZmxleD0yNzg7ZS5FY2lyY3VtZmxleD02Njc7ZS5hZGllcmVzaXM9NTU2O2UuZWRpZXJlc2lzPTU1NjtlLmNhY3V0ZT01NTY7ZS5uYWN1dGU9NjExO2UudW1hY3Jvbj02MTE7ZS5OY2Fyb249NzIyO2UuSWFjdXRlPTI3ODtlLnBsdXNtaW51cz01ODQ7ZS5icm9rZW5iYXI9MjgwO2UucmVnaXN0ZXJlZD03Mzc7ZS5HYnJldmU9Nzc4O2UuSWRvdGFjY2VudD0yNzg7ZS5zdW1tYXRpb249NjAwO2UuRWdyYXZlPTY2NztlLnJhY3V0ZT0zODk7ZS5vbWFjcm9uPTYxMTtlLlphY3V0ZT02MTE7ZS5aY2Fyb249NjExO2UuZ3JlYXRlcmVxdWFsPTU0OTtlLkV0aD03MjI7ZS5DY2VkaWxsYT03MjI7ZS5sY29tbWFhY2NlbnQ9Mjc4O2UudGNhcm9uPTM4OTtlLmVvZ29uZWs9NTU2O2UuVW9nb25laz03MjI7ZS5BYWN1dGU9NzIyO2UuQWRpZXJlc2lzPTcyMjtlLmVncmF2ZT01NTY7ZS56YWN1dGU9NTAwO2UuaW9nb25laz0yNzg7ZS5PYWN1dGU9Nzc4O2Uub2FjdXRlPTYxMTtlLmFtYWNyb249NTU2O2Uuc2FjdXRlPTU1NjtlLmlkaWVyZXNpcz0yNzg7ZS5PY2lyY3VtZmxleD03Nzg7ZS5VZ3JhdmU9NzIyO2UuRGVsdGE9NjEyO2UudGhvcm49NjExO2UudHdvc3VwZXJpb3I9MzMzO2UuT2RpZXJlc2lzPTc3ODtlLm11PTYxMTtlLmlncmF2ZT0yNzg7ZS5vaHVuZ2FydW1sYXV0PTYxMTtlLkVvZ29uZWs9NjY3O2UuZGNyb2F0PTYxMTtlLnRocmVlcXVhcnRlcnM9ODM0O2UuU2NlZGlsbGE9NjY3O2UubGNhcm9uPTQwMDtlLktjb21tYWFjY2VudD03MjI7ZS5MYWN1dGU9NjExO2UudHJhZGVtYXJrPTFlMztlLmVkb3RhY2NlbnQ9NTU2O2UuSWdyYXZlPTI3ODtlLkltYWNyb249Mjc4O2UuTGNhcm9uPTYxMTtlLm9uZWhhbGY9ODM0O2UubGVzc2VxdWFsPTU0OTtlLm9jaXJjdW1mbGV4PTYxMTtlLm50aWxkZT02MTE7ZS5VaHVuZ2FydW1sYXV0PTcyMjtlLkVhY3V0ZT02Njc7ZS5lbWFjcm9uPTU1NjtlLmdicmV2ZT02MTE7ZS5vbmVxdWFydGVyPTgzNDtlLlNjYXJvbj02Njc7ZS5TY29tbWFhY2NlbnQ9NjY3O2UuT2h1bmdhcnVtbGF1dD03Nzg7ZS5kZWdyZWU9NDAwO2Uub2dyYXZlPTYxMTtlLkNjYXJvbj03MjI7ZS51Z3JhdmU9NjExO2UucmFkaWNhbD01NDk7ZS5EY2Fyb249NzIyO2UucmNvbW1hYWNjZW50PTM4OTtlLk50aWxkZT03MjI7ZS5vdGlsZGU9NjExO2UuUmNvbW1hYWNjZW50PTcyMjtlLkxjb21tYWFjY2VudD02MTE7ZS5BdGlsZGU9NzIyO2UuQW9nb25laz03MjI7ZS5BcmluZz03MjI7ZS5PdGlsZGU9Nzc4O2UuemRvdGFjY2VudD01MDA7ZS5FY2Fyb249NjY3O2UuSW9nb25laz0yNzg7ZS5rY29tbWFhY2NlbnQ9NTU2O2UubWludXM9NTg0O2UuSWNpcmN1bWZsZXg9Mjc4O2UubmNhcm9uPTYxMTtlLnRjb21tYWFjY2VudD0zMzM7ZS5sb2dpY2Fsbm90PTU4NDtlLm9kaWVyZXNpcz02MTE7ZS51ZGllcmVzaXM9NjExO2Uubm90ZXF1YWw9NTQ5O2UuZ2NvbW1hYWNjZW50PTYxMTtlLmV0aD02MTE7ZS56Y2Fyb249NTAwO2UubmNvbW1hYWNjZW50PTYxMTtlLm9uZXN1cGVyaW9yPTMzMztlLmltYWNyb249Mjc4O2UuRXVybz01NTZ9KTtlWyJIZWx2ZXRpY2EtQm9sZE9ibGlxdWUiXT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5zcGFjZT0yNzg7ZS5leGNsYW09MzMzO2UucXVvdGVkYmw9NDc0O2UubnVtYmVyc2lnbj01NTY7ZS5kb2xsYXI9NTU2O2UucGVyY2VudD04ODk7ZS5hbXBlcnNhbmQ9NzIyO2UucXVvdGVyaWdodD0yNzg7ZS5wYXJlbmxlZnQ9MzMzO2UucGFyZW5yaWdodD0zMzM7ZS5hc3Rlcmlzaz0zODk7ZS5wbHVzPTU4NDtlLmNvbW1hPTI3ODtlLmh5cGhlbj0zMzM7ZS5wZXJpb2Q9Mjc4O2Uuc2xhc2g9Mjc4O2UuemVybz01NTY7ZS5vbmU9NTU2O2UudHdvPTU1NjtlLnRocmVlPTU1NjtlLmZvdXI9NTU2O2UuZml2ZT01NTY7ZS5zaXg9NTU2O2Uuc2V2ZW49NTU2O2UuZWlnaHQ9NTU2O2UubmluZT01NTY7ZS5jb2xvbj0zMzM7ZS5zZW1pY29sb249MzMzO2UubGVzcz01ODQ7ZS5lcXVhbD01ODQ7ZS5ncmVhdGVyPTU4NDtlLnF1ZXN0aW9uPTYxMTtlLmF0PTk3NTtlLkE9NzIyO2UuQj03MjI7ZS5DPTcyMjtlLkQ9NzIyO2UuRT02Njc7ZS5GPTYxMTtlLkc9Nzc4O2UuSD03MjI7ZS5JPTI3ODtlLko9NTU2O2UuSz03MjI7ZS5MPTYxMTtlLk09ODMzO2UuTj03MjI7ZS5PPTc3ODtlLlA9NjY3O2UuUT03Nzg7ZS5SPTcyMjtlLlM9NjY3O2UuVD02MTE7ZS5VPTcyMjtlLlY9NjY3O2UuVz05NDQ7ZS5YPTY2NztlLlk9NjY3O2UuWj02MTE7ZS5icmFja2V0bGVmdD0zMzM7ZS5iYWNrc2xhc2g9Mjc4O2UuYnJhY2tldHJpZ2h0PTMzMztlLmFzY2lpY2lyY3VtPTU4NDtlLnVuZGVyc2NvcmU9NTU2O2UucXVvdGVsZWZ0PTI3ODtlLmE9NTU2O2UuYj02MTE7ZS5jPTU1NjtlLmQ9NjExO2UuZT01NTY7ZS5mPTMzMztlLmc9NjExO2UuaD02MTE7ZS5pPTI3ODtlLmo9Mjc4O2Uuaz01NTY7ZS5sPTI3ODtlLm09ODg5O2Uubj02MTE7ZS5vPTYxMTtlLnA9NjExO2UucT02MTE7ZS5yPTM4OTtlLnM9NTU2O2UudD0zMzM7ZS51PTYxMTtlLnY9NTU2O2Uudz03Nzg7ZS54PTU1NjtlLnk9NTU2O2Uuej01MDA7ZS5icmFjZWxlZnQ9Mzg5O2UuYmFyPTI4MDtlLmJyYWNlcmlnaHQ9Mzg5O2UuYXNjaWl0aWxkZT01ODQ7ZS5leGNsYW1kb3duPTMzMztlLmNlbnQ9NTU2O2Uuc3Rlcmxpbmc9NTU2O2UuZnJhY3Rpb249MTY3O2UueWVuPTU1NjtlLmZsb3Jpbj01NTY7ZS5zZWN0aW9uPTU1NjtlLmN1cnJlbmN5PTU1NjtlLnF1b3Rlc2luZ2xlPTIzODtlLnF1b3RlZGJsbGVmdD01MDA7ZS5ndWlsbGVtb3RsZWZ0PTU1NjtlLmd1aWxzaW5nbGxlZnQ9MzMzO2UuZ3VpbHNpbmdscmlnaHQ9MzMzO2UuZmk9NjExO2UuZmw9NjExO2UuZW5kYXNoPTU1NjtlLmRhZ2dlcj01NTY7ZS5kYWdnZXJkYmw9NTU2O2UucGVyaW9kY2VudGVyZWQ9Mjc4O2UucGFyYWdyYXBoPTU1NjtlLmJ1bGxldD0zNTA7ZS5xdW90ZXNpbmdsYmFzZT0yNzg7ZS5xdW90ZWRibGJhc2U9NTAwO2UucXVvdGVkYmxyaWdodD01MDA7ZS5ndWlsbGVtb3RyaWdodD01NTY7ZS5lbGxpcHNpcz0xZTM7ZS5wZXJ0aG91c2FuZD0xZTM7ZS5xdWVzdGlvbmRvd249NjExO2UuZ3JhdmU9MzMzO2UuYWN1dGU9MzMzO2UuY2lyY3VtZmxleD0zMzM7ZS50aWxkZT0zMzM7ZS5tYWNyb249MzMzO2UuYnJldmU9MzMzO2UuZG90YWNjZW50PTMzMztlLmRpZXJlc2lzPTMzMztlLnJpbmc9MzMzO2UuY2VkaWxsYT0zMzM7ZS5odW5nYXJ1bWxhdXQ9MzMzO2Uub2dvbmVrPTMzMztlLmNhcm9uPTMzMztlLmVtZGFzaD0xZTM7ZS5BRT0xZTM7ZS5vcmRmZW1pbmluZT0zNzA7ZS5Mc2xhc2g9NjExO2UuT3NsYXNoPTc3ODtlLk9FPTFlMztlLm9yZG1hc2N1bGluZT0zNjU7ZS5hZT04ODk7ZS5kb3RsZXNzaT0yNzg7ZS5sc2xhc2g9Mjc4O2Uub3NsYXNoPTYxMTtlLm9lPTk0NDtlLmdlcm1hbmRibHM9NjExO2UuSWRpZXJlc2lzPTI3ODtlLmVhY3V0ZT01NTY7ZS5hYnJldmU9NTU2O2UudWh1bmdhcnVtbGF1dD02MTE7ZS5lY2Fyb249NTU2O2UuWWRpZXJlc2lzPTY2NztlLmRpdmlkZT01ODQ7ZS5ZYWN1dGU9NjY3O2UuQWNpcmN1bWZsZXg9NzIyO2UuYWFjdXRlPTU1NjtlLlVjaXJjdW1mbGV4PTcyMjtlLnlhY3V0ZT01NTY7ZS5zY29tbWFhY2NlbnQ9NTU2O2UuZWNpcmN1bWZsZXg9NTU2O2UuVXJpbmc9NzIyO2UuVWRpZXJlc2lzPTcyMjtlLmFvZ29uZWs9NTU2O2UuVWFjdXRlPTcyMjtlLnVvZ29uZWs9NjExO2UuRWRpZXJlc2lzPTY2NztlLkRjcm9hdD03MjI7ZS5jb21tYWFjY2VudD0yNTA7ZS5jb3B5cmlnaHQ9NzM3O2UuRW1hY3Jvbj02Njc7ZS5jY2Fyb249NTU2O2UuYXJpbmc9NTU2O2UuTmNvbW1hYWNjZW50PTcyMjtlLmxhY3V0ZT0yNzg7ZS5hZ3JhdmU9NTU2O2UuVGNvbW1hYWNjZW50PTYxMTtlLkNhY3V0ZT03MjI7ZS5hdGlsZGU9NTU2O2UuRWRvdGFjY2VudD02Njc7ZS5zY2Fyb249NTU2O2Uuc2NlZGlsbGE9NTU2O2UuaWFjdXRlPTI3ODtlLmxvemVuZ2U9NDk0O2UuUmNhcm9uPTcyMjtlLkdjb21tYWFjY2VudD03Nzg7ZS51Y2lyY3VtZmxleD02MTE7ZS5hY2lyY3VtZmxleD01NTY7ZS5BbWFjcm9uPTcyMjtlLnJjYXJvbj0zODk7ZS5jY2VkaWxsYT01NTY7ZS5aZG90YWNjZW50PTYxMTtlLlRob3JuPTY2NztlLk9tYWNyb249Nzc4O2UuUmFjdXRlPTcyMjtlLlNhY3V0ZT02Njc7ZS5kY2Fyb249NzQzO2UuVW1hY3Jvbj03MjI7ZS51cmluZz02MTE7ZS50aHJlZXN1cGVyaW9yPTMzMztlLk9ncmF2ZT03Nzg7ZS5BZ3JhdmU9NzIyO2UuQWJyZXZlPTcyMjtlLm11bHRpcGx5PTU4NDtlLnVhY3V0ZT02MTE7ZS5UY2Fyb249NjExO2UucGFydGlhbGRpZmY9NDk0O2UueWRpZXJlc2lzPTU1NjtlLk5hY3V0ZT03MjI7ZS5pY2lyY3VtZmxleD0yNzg7ZS5FY2lyY3VtZmxleD02Njc7ZS5hZGllcmVzaXM9NTU2O2UuZWRpZXJlc2lzPTU1NjtlLmNhY3V0ZT01NTY7ZS5uYWN1dGU9NjExO2UudW1hY3Jvbj02MTE7ZS5OY2Fyb249NzIyO2UuSWFjdXRlPTI3ODtlLnBsdXNtaW51cz01ODQ7ZS5icm9rZW5iYXI9MjgwO2UucmVnaXN0ZXJlZD03Mzc7ZS5HYnJldmU9Nzc4O2UuSWRvdGFjY2VudD0yNzg7ZS5zdW1tYXRpb249NjAwO2UuRWdyYXZlPTY2NztlLnJhY3V0ZT0zODk7ZS5vbWFjcm9uPTYxMTtlLlphY3V0ZT02MTE7ZS5aY2Fyb249NjExO2UuZ3JlYXRlcmVxdWFsPTU0OTtlLkV0aD03MjI7ZS5DY2VkaWxsYT03MjI7ZS5sY29tbWFhY2NlbnQ9Mjc4O2UudGNhcm9uPTM4OTtlLmVvZ29uZWs9NTU2O2UuVW9nb25laz03MjI7ZS5BYWN1dGU9NzIyO2UuQWRpZXJlc2lzPTcyMjtlLmVncmF2ZT01NTY7ZS56YWN1dGU9NTAwO2UuaW9nb25laz0yNzg7ZS5PYWN1dGU9Nzc4O2Uub2FjdXRlPTYxMTtlLmFtYWNyb249NTU2O2Uuc2FjdXRlPTU1NjtlLmlkaWVyZXNpcz0yNzg7ZS5PY2lyY3VtZmxleD03Nzg7ZS5VZ3JhdmU9NzIyO2UuRGVsdGE9NjEyO2UudGhvcm49NjExO2UudHdvc3VwZXJpb3I9MzMzO2UuT2RpZXJlc2lzPTc3ODtlLm11PTYxMTtlLmlncmF2ZT0yNzg7ZS5vaHVuZ2FydW1sYXV0PTYxMTtlLkVvZ29uZWs9NjY3O2UuZGNyb2F0PTYxMTtlLnRocmVlcXVhcnRlcnM9ODM0O2UuU2NlZGlsbGE9NjY3O2UubGNhcm9uPTQwMDtlLktjb21tYWFjY2VudD03MjI7ZS5MYWN1dGU9NjExO2UudHJhZGVtYXJrPTFlMztlLmVkb3RhY2NlbnQ9NTU2O2UuSWdyYXZlPTI3ODtlLkltYWNyb249Mjc4O2UuTGNhcm9uPTYxMTtlLm9uZWhhbGY9ODM0O2UubGVzc2VxdWFsPTU0OTtlLm9jaXJjdW1mbGV4PTYxMTtlLm50aWxkZT02MTE7ZS5VaHVuZ2FydW1sYXV0PTcyMjtlLkVhY3V0ZT02Njc7ZS5lbWFjcm9uPTU1NjtlLmdicmV2ZT02MTE7ZS5vbmVxdWFydGVyPTgzNDtlLlNjYXJvbj02Njc7ZS5TY29tbWFhY2NlbnQ9NjY3O2UuT2h1bmdhcnVtbGF1dD03Nzg7ZS5kZWdyZWU9NDAwO2Uub2dyYXZlPTYxMTtlLkNjYXJvbj03MjI7ZS51Z3JhdmU9NjExO2UucmFkaWNhbD01NDk7ZS5EY2Fyb249NzIyO2UucmNvbW1hYWNjZW50PTM4OTtlLk50aWxkZT03MjI7ZS5vdGlsZGU9NjExO2UuUmNvbW1hYWNjZW50PTcyMjtlLkxjb21tYWFjY2VudD02MTE7ZS5BdGlsZGU9NzIyO2UuQW9nb25laz03MjI7ZS5BcmluZz03MjI7ZS5PdGlsZGU9Nzc4O2UuemRvdGFjY2VudD01MDA7ZS5FY2Fyb249NjY3O2UuSW9nb25laz0yNzg7ZS5rY29tbWFhY2NlbnQ9NTU2O2UubWludXM9NTg0O2UuSWNpcmN1bWZsZXg9Mjc4O2UubmNhcm9uPTYxMTtlLnRjb21tYWFjY2VudD0zMzM7ZS5sb2dpY2Fsbm90PTU4NDtlLm9kaWVyZXNpcz02MTE7ZS51ZGllcmVzaXM9NjExO2Uubm90ZXF1YWw9NTQ5O2UuZ2NvbW1hYWNjZW50PTYxMTtlLmV0aD02MTE7ZS56Y2Fyb249NTAwO2UubmNvbW1hYWNjZW50PTYxMTtlLm9uZXN1cGVyaW9yPTMzMztlLmltYWNyb249Mjc4O2UuRXVybz01NTZ9KTtlWyJIZWx2ZXRpY2EtT2JsaXF1ZSJdPWdldExvb2t1cFRhYmxlRmFjdG9yeShmdW5jdGlvbihlKXtlLnNwYWNlPTI3ODtlLmV4Y2xhbT0yNzg7ZS5xdW90ZWRibD0zNTU7ZS5udW1iZXJzaWduPTU1NjtlLmRvbGxhcj01NTY7ZS5wZXJjZW50PTg4OTtlLmFtcGVyc2FuZD02Njc7ZS5xdW90ZXJpZ2h0PTIyMjtlLnBhcmVubGVmdD0zMzM7ZS5wYXJlbnJpZ2h0PTMzMztlLmFzdGVyaXNrPTM4OTtlLnBsdXM9NTg0O2UuY29tbWE9Mjc4O2UuaHlwaGVuPTMzMztlLnBlcmlvZD0yNzg7ZS5zbGFzaD0yNzg7ZS56ZXJvPTU1NjtlLm9uZT01NTY7ZS50d289NTU2O2UudGhyZWU9NTU2O2UuZm91cj01NTY7ZS5maXZlPTU1NjtlLnNpeD01NTY7ZS5zZXZlbj01NTY7ZS5laWdodD01NTY7ZS5uaW5lPTU1NjtlLmNvbG9uPTI3ODtlLnNlbWljb2xvbj0yNzg7ZS5sZXNzPTU4NDtlLmVxdWFsPTU4NDtlLmdyZWF0ZXI9NTg0O2UucXVlc3Rpb249NTU2O2UuYXQ9MTAxNTtlLkE9NjY3O2UuQj02Njc7ZS5DPTcyMjtlLkQ9NzIyO2UuRT02Njc7ZS5GPTYxMTtlLkc9Nzc4O2UuSD03MjI7ZS5JPTI3ODtlLko9NTAwO2UuSz02Njc7ZS5MPTU1NjtlLk09ODMzO2UuTj03MjI7ZS5PPTc3ODtlLlA9NjY3O2UuUT03Nzg7ZS5SPTcyMjtlLlM9NjY3O2UuVD02MTE7ZS5VPTcyMjtlLlY9NjY3O2UuVz05NDQ7ZS5YPTY2NztlLlk9NjY3O2UuWj02MTE7ZS5icmFja2V0bGVmdD0yNzg7ZS5iYWNrc2xhc2g9Mjc4O2UuYnJhY2tldHJpZ2h0PTI3ODtlLmFzY2lpY2lyY3VtPTQ2OTtlLnVuZGVyc2NvcmU9NTU2O2UucXVvdGVsZWZ0PTIyMjtlLmE9NTU2O2UuYj01NTY7ZS5jPTUwMDtlLmQ9NTU2O2UuZT01NTY7ZS5mPTI3ODtlLmc9NTU2O2UuaD01NTY7ZS5pPTIyMjtlLmo9MjIyO2Uuaz01MDA7ZS5sPTIyMjtlLm09ODMzO2Uubj01NTY7ZS5vPTU1NjtlLnA9NTU2O2UucT01NTY7ZS5yPTMzMztlLnM9NTAwO2UudD0yNzg7ZS51PTU1NjtlLnY9NTAwO2Uudz03MjI7ZS54PTUwMDtlLnk9NTAwO2Uuej01MDA7ZS5icmFjZWxlZnQ9MzM0O2UuYmFyPTI2MDtlLmJyYWNlcmlnaHQ9MzM0O2UuYXNjaWl0aWxkZT01ODQ7ZS5leGNsYW1kb3duPTMzMztlLmNlbnQ9NTU2O2Uuc3Rlcmxpbmc9NTU2O2UuZnJhY3Rpb249MTY3O2UueWVuPTU1NjtlLmZsb3Jpbj01NTY7ZS5zZWN0aW9uPTU1NjtlLmN1cnJlbmN5PTU1NjtlLnF1b3Rlc2luZ2xlPTE5MTtlLnF1b3RlZGJsbGVmdD0zMzM7ZS5ndWlsbGVtb3RsZWZ0PTU1NjtlLmd1aWxzaW5nbGxlZnQ9MzMzO2UuZ3VpbHNpbmdscmlnaHQ9MzMzO2UuZmk9NTAwO2UuZmw9NTAwO2UuZW5kYXNoPTU1NjtlLmRhZ2dlcj01NTY7ZS5kYWdnZXJkYmw9NTU2O2UucGVyaW9kY2VudGVyZWQ9Mjc4O2UucGFyYWdyYXBoPTUzNztlLmJ1bGxldD0zNTA7ZS5xdW90ZXNpbmdsYmFzZT0yMjI7ZS5xdW90ZWRibGJhc2U9MzMzO2UucXVvdGVkYmxyaWdodD0zMzM7ZS5ndWlsbGVtb3RyaWdodD01NTY7ZS5lbGxpcHNpcz0xZTM7ZS5wZXJ0aG91c2FuZD0xZTM7ZS5xdWVzdGlvbmRvd249NjExO2UuZ3JhdmU9MzMzO2UuYWN1dGU9MzMzO2UuY2lyY3VtZmxleD0zMzM7ZS50aWxkZT0zMzM7ZS5tYWNyb249MzMzO2UuYnJldmU9MzMzO2UuZG90YWNjZW50PTMzMztlLmRpZXJlc2lzPTMzMztlLnJpbmc9MzMzO2UuY2VkaWxsYT0zMzM7ZS5odW5nYXJ1bWxhdXQ9MzMzO2Uub2dvbmVrPTMzMztlLmNhcm9uPTMzMztlLmVtZGFzaD0xZTM7ZS5BRT0xZTM7ZS5vcmRmZW1pbmluZT0zNzA7ZS5Mc2xhc2g9NTU2O2UuT3NsYXNoPTc3ODtlLk9FPTFlMztlLm9yZG1hc2N1bGluZT0zNjU7ZS5hZT04ODk7ZS5kb3RsZXNzaT0yNzg7ZS5sc2xhc2g9MjIyO2Uub3NsYXNoPTYxMTtlLm9lPTk0NDtlLmdlcm1hbmRibHM9NjExO2UuSWRpZXJlc2lzPTI3ODtlLmVhY3V0ZT01NTY7ZS5hYnJldmU9NTU2O2UudWh1bmdhcnVtbGF1dD01NTY7ZS5lY2Fyb249NTU2O2UuWWRpZXJlc2lzPTY2NztlLmRpdmlkZT01ODQ7ZS5ZYWN1dGU9NjY3O2UuQWNpcmN1bWZsZXg9NjY3O2UuYWFjdXRlPTU1NjtlLlVjaXJjdW1mbGV4PTcyMjtlLnlhY3V0ZT01MDA7ZS5zY29tbWFhY2NlbnQ9NTAwO2UuZWNpcmN1bWZsZXg9NTU2O2UuVXJpbmc9NzIyO2UuVWRpZXJlc2lzPTcyMjtlLmFvZ29uZWs9NTU2O2UuVWFjdXRlPTcyMjtlLnVvZ29uZWs9NTU2O2UuRWRpZXJlc2lzPTY2NztlLkRjcm9hdD03MjI7ZS5jb21tYWFjY2VudD0yNTA7ZS5jb3B5cmlnaHQ9NzM3O2UuRW1hY3Jvbj02Njc7ZS5jY2Fyb249NTAwO2UuYXJpbmc9NTU2O2UuTmNvbW1hYWNjZW50PTcyMjtlLmxhY3V0ZT0yMjI7ZS5hZ3JhdmU9NTU2O2UuVGNvbW1hYWNjZW50PTYxMTtlLkNhY3V0ZT03MjI7ZS5hdGlsZGU9NTU2O2UuRWRvdGFjY2VudD02Njc7ZS5zY2Fyb249NTAwO2Uuc2NlZGlsbGE9NTAwO2UuaWFjdXRlPTI3ODtlLmxvemVuZ2U9NDcxO2UuUmNhcm9uPTcyMjtlLkdjb21tYWFjY2VudD03Nzg7ZS51Y2lyY3VtZmxleD01NTY7ZS5hY2lyY3VtZmxleD01NTY7ZS5BbWFjcm9uPTY2NztlLnJjYXJvbj0zMzM7ZS5jY2VkaWxsYT01MDA7ZS5aZG90YWNjZW50PTYxMTtlLlRob3JuPTY2NztlLk9tYWNyb249Nzc4O2UuUmFjdXRlPTcyMjtlLlNhY3V0ZT02Njc7ZS5kY2Fyb249NjQzO2UuVW1hY3Jvbj03MjI7ZS51cmluZz01NTY7ZS50aHJlZXN1cGVyaW9yPTMzMztlLk9ncmF2ZT03Nzg7ZS5BZ3JhdmU9NjY3O2UuQWJyZXZlPTY2NztlLm11bHRpcGx5PTU4NDtlLnVhY3V0ZT01NTY7ZS5UY2Fyb249NjExO2UucGFydGlhbGRpZmY9NDc2O2UueWRpZXJlc2lzPTUwMDtlLk5hY3V0ZT03MjI7ZS5pY2lyY3VtZmxleD0yNzg7ZS5FY2lyY3VtZmxleD02Njc7ZS5hZGllcmVzaXM9NTU2O2UuZWRpZXJlc2lzPTU1NjtlLmNhY3V0ZT01MDA7ZS5uYWN1dGU9NTU2O2UudW1hY3Jvbj01NTY7ZS5OY2Fyb249NzIyO2UuSWFjdXRlPTI3ODtlLnBsdXNtaW51cz01ODQ7ZS5icm9rZW5iYXI9MjYwO2UucmVnaXN0ZXJlZD03Mzc7ZS5HYnJldmU9Nzc4O2UuSWRvdGFjY2VudD0yNzg7ZS5zdW1tYXRpb249NjAwO2UuRWdyYXZlPTY2NztlLnJhY3V0ZT0zMzM7ZS5vbWFjcm9uPTU1NjtlLlphY3V0ZT02MTE7ZS5aY2Fyb249NjExO2UuZ3JlYXRlcmVxdWFsPTU0OTtlLkV0aD03MjI7ZS5DY2VkaWxsYT03MjI7ZS5sY29tbWFhY2NlbnQ9MjIyO2UudGNhcm9uPTMxNztlLmVvZ29uZWs9NTU2O2UuVW9nb25laz03MjI7ZS5BYWN1dGU9NjY3O2UuQWRpZXJlc2lzPTY2NztlLmVncmF2ZT01NTY7ZS56YWN1dGU9NTAwO2UuaW9nb25laz0yMjI7ZS5PYWN1dGU9Nzc4O2Uub2FjdXRlPTU1NjtlLmFtYWNyb249NTU2O2Uuc2FjdXRlPTUwMDtlLmlkaWVyZXNpcz0yNzg7ZS5PY2lyY3VtZmxleD03Nzg7ZS5VZ3JhdmU9NzIyO2UuRGVsdGE9NjEyO2UudGhvcm49NTU2O2UudHdvc3VwZXJpb3I9MzMzO2UuT2RpZXJlc2lzPTc3ODtlLm11PTU1NjtlLmlncmF2ZT0yNzg7ZS5vaHVuZ2FydW1sYXV0PTU1NjtlLkVvZ29uZWs9NjY3O2UuZGNyb2F0PTU1NjtlLnRocmVlcXVhcnRlcnM9ODM0O2UuU2NlZGlsbGE9NjY3O2UubGNhcm9uPTI5OTtlLktjb21tYWFjY2VudD02Njc7ZS5MYWN1dGU9NTU2O2UudHJhZGVtYXJrPTFlMztlLmVkb3RhY2NlbnQ9NTU2O2UuSWdyYXZlPTI3ODtlLkltYWNyb249Mjc4O2UuTGNhcm9uPTU1NjtlLm9uZWhhbGY9ODM0O2UubGVzc2VxdWFsPTU0OTtlLm9jaXJjdW1mbGV4PTU1NjtlLm50aWxkZT01NTY7ZS5VaHVuZ2FydW1sYXV0PTcyMjtlLkVhY3V0ZT02Njc7ZS5lbWFjcm9uPTU1NjtlLmdicmV2ZT01NTY7ZS5vbmVxdWFydGVyPTgzNDtlLlNjYXJvbj02Njc7ZS5TY29tbWFhY2NlbnQ9NjY3O2UuT2h1bmdhcnVtbGF1dD03Nzg7ZS5kZWdyZWU9NDAwO2Uub2dyYXZlPTU1NjtlLkNjYXJvbj03MjI7ZS51Z3JhdmU9NTU2O2UucmFkaWNhbD00NTM7ZS5EY2Fyb249NzIyO2UucmNvbW1hYWNjZW50PTMzMztlLk50aWxkZT03MjI7ZS5vdGlsZGU9NTU2O2UuUmNvbW1hYWNjZW50PTcyMjtlLkxjb21tYWFjY2VudD01NTY7ZS5BdGlsZGU9NjY3O2UuQW9nb25laz02Njc7ZS5BcmluZz02Njc7ZS5PdGlsZGU9Nzc4O2UuemRvdGFjY2VudD01MDA7ZS5FY2Fyb249NjY3O2UuSW9nb25laz0yNzg7ZS5rY29tbWFhY2NlbnQ9NTAwO2UubWludXM9NTg0O2UuSWNpcmN1bWZsZXg9Mjc4O2UubmNhcm9uPTU1NjtlLnRjb21tYWFjY2VudD0yNzg7ZS5sb2dpY2Fsbm90PTU4NDtlLm9kaWVyZXNpcz01NTY7ZS51ZGllcmVzaXM9NTU2O2Uubm90ZXF1YWw9NTQ5O2UuZ2NvbW1hYWNjZW50PTU1NjtlLmV0aD01NTY7ZS56Y2Fyb249NTAwO2UubmNvbW1hYWNjZW50PTU1NjtlLm9uZXN1cGVyaW9yPTMzMztlLmltYWNyb249Mjc4O2UuRXVybz01NTZ9KTtlLlN5bWJvbD1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5zcGFjZT0yNTA7ZS5leGNsYW09MzMzO2UudW5pdmVyc2FsPTcxMztlLm51bWJlcnNpZ249NTAwO2UuZXhpc3RlbnRpYWw9NTQ5O2UucGVyY2VudD04MzM7ZS5hbXBlcnNhbmQ9Nzc4O2Uuc3VjaHRoYXQ9NDM5O2UucGFyZW5sZWZ0PTMzMztlLnBhcmVucmlnaHQ9MzMzO2UuYXN0ZXJpc2ttYXRoPTUwMDtlLnBsdXM9NTQ5O2UuY29tbWE9MjUwO2UubWludXM9NTQ5O2UucGVyaW9kPTI1MDtlLnNsYXNoPTI3ODtlLnplcm89NTAwO2Uub25lPTUwMDtlLnR3bz01MDA7ZS50aHJlZT01MDA7ZS5mb3VyPTUwMDtlLmZpdmU9NTAwO2Uuc2l4PTUwMDtlLnNldmVuPTUwMDtlLmVpZ2h0PTUwMDtlLm5pbmU9NTAwO2UuY29sb249Mjc4O2Uuc2VtaWNvbG9uPTI3ODtlLmxlc3M9NTQ5O2UuZXF1YWw9NTQ5O2UuZ3JlYXRlcj01NDk7ZS5xdWVzdGlvbj00NDQ7ZS5jb25ncnVlbnQ9NTQ5O2UuQWxwaGE9NzIyO2UuQmV0YT02Njc7ZS5DaGk9NzIyO2UuRGVsdGE9NjEyO2UuRXBzaWxvbj02MTE7ZS5QaGk9NzYzO2UuR2FtbWE9NjAzO2UuRXRhPTcyMjtlLklvdGE9MzMzO2UudGhldGExPTYzMTtlLkthcHBhPTcyMjtlLkxhbWJkYT02ODY7ZS5NdT04ODk7ZS5OdT03MjI7ZS5PbWljcm9uPTcyMjtlLlBpPTc2ODtlLlRoZXRhPTc0MTtlLlJobz01NTY7ZS5TaWdtYT01OTI7ZS5UYXU9NjExO2UuVXBzaWxvbj02OTA7ZS5zaWdtYTE9NDM5O2UuT21lZ2E9NzY4O2UuWGk9NjQ1O2UuUHNpPTc5NTtlLlpldGE9NjExO2UuYnJhY2tldGxlZnQ9MzMzO2UudGhlcmVmb3JlPTg2MztlLmJyYWNrZXRyaWdodD0zMzM7ZS5wZXJwZW5kaWN1bGFyPTY1ODtlLnVuZGVyc2NvcmU9NTAwO2UucmFkaWNhbGV4PTUwMDtlLmFscGhhPTYzMTtlLmJldGE9NTQ5O2UuY2hpPTU0OTtlLmRlbHRhPTQ5NDtlLmVwc2lsb249NDM5O2UucGhpPTUyMTtlLmdhbW1hPTQxMTtlLmV0YT02MDM7ZS5pb3RhPTMyOTtlLnBoaTE9NjAzO2Uua2FwcGE9NTQ5O2UubGFtYmRhPTU0OTtlLm11PTU3NjtlLm51PTUyMTtlLm9taWNyb249NTQ5O2UucGk9NTQ5O2UudGhldGE9NTIxO2UucmhvPTU0OTtlLnNpZ21hPTYwMztlLnRhdT00Mzk7ZS51cHNpbG9uPTU3NjtlLm9tZWdhMT03MTM7ZS5vbWVnYT02ODY7ZS54aT00OTM7ZS5wc2k9Njg2O2UuemV0YT00OTQ7ZS5icmFjZWxlZnQ9NDgwO2UuYmFyPTIwMDtlLmJyYWNlcmlnaHQ9NDgwO2Uuc2ltaWxhcj01NDk7ZS5FdXJvPTc1MDtlLlVwc2lsb24xPTYyMDtlLm1pbnV0ZT0yNDc7ZS5sZXNzZXF1YWw9NTQ5O2UuZnJhY3Rpb249MTY3O2UuaW5maW5pdHk9NzEzO2UuZmxvcmluPTUwMDtlLmNsdWI9NzUzO2UuZGlhbW9uZD03NTM7ZS5oZWFydD03NTM7ZS5zcGFkZT03NTM7ZS5hcnJvd2JvdGg9MTA0MjtlLmFycm93bGVmdD05ODc7ZS5hcnJvd3VwPTYwMztlLmFycm93cmlnaHQ9OTg3O2UuYXJyb3dkb3duPTYwMztlLmRlZ3JlZT00MDA7ZS5wbHVzbWludXM9NTQ5O2Uuc2Vjb25kPTQxMTtlLmdyZWF0ZXJlcXVhbD01NDk7ZS5tdWx0aXBseT01NDk7ZS5wcm9wb3J0aW9uYWw9NzEzO2UucGFydGlhbGRpZmY9NDk0O2UuYnVsbGV0PTQ2MDtlLmRpdmlkZT01NDk7ZS5ub3RlcXVhbD01NDk7ZS5lcXVpdmFsZW5jZT01NDk7ZS5hcHByb3hlcXVhbD01NDk7ZS5lbGxpcHNpcz0xZTM7ZS5hcnJvd3ZlcnRleD02MDM7ZS5hcnJvd2hvcml6ZXg9MWUzO2UuY2FycmlhZ2VyZXR1cm49NjU4O2UuYWxlcGg9ODIzO2UuSWZyYWt0dXI9Njg2O2UuUmZyYWt0dXI9Nzk1O2Uud2VpZXJzdHJhc3M9OTg3O2UuY2lyY2xlbXVsdGlwbHk9NzY4O2UuY2lyY2xlcGx1cz03Njg7ZS5lbXB0eXNldD04MjM7ZS5pbnRlcnNlY3Rpb249NzY4O2UudW5pb249NzY4O2UucHJvcGVyc3VwZXJzZXQ9NzEzO2UucmVmbGV4c3VwZXJzZXQ9NzEzO2Uubm90c3Vic2V0PTcxMztlLnByb3BlcnN1YnNldD03MTM7ZS5yZWZsZXhzdWJzZXQ9NzEzO2UuZWxlbWVudD03MTM7ZS5ub3RlbGVtZW50PTcxMztlLmFuZ2xlPTc2ODtlLmdyYWRpZW50PTcxMztlLnJlZ2lzdGVyc2VyaWY9NzkwO2UuY29weXJpZ2h0c2VyaWY9NzkwO2UudHJhZGVtYXJrc2VyaWY9ODkwO2UucHJvZHVjdD04MjM7ZS5yYWRpY2FsPTU0OTtlLmRvdG1hdGg9MjUwO2UubG9naWNhbG5vdD03MTM7ZS5sb2dpY2FsYW5kPTYwMztlLmxvZ2ljYWxvcj02MDM7ZS5hcnJvd2RibGJvdGg9MTA0MjtlLmFycm93ZGJsbGVmdD05ODc7ZS5hcnJvd2RibHVwPTYwMztlLmFycm93ZGJscmlnaHQ9OTg3O2UuYXJyb3dkYmxkb3duPTYwMztlLmxvemVuZ2U9NDk0O2UuYW5nbGVsZWZ0PTMyOTtlLnJlZ2lzdGVyc2Fucz03OTA7ZS5jb3B5cmlnaHRzYW5zPTc5MDtlLnRyYWRlbWFya3NhbnM9Nzg2O2Uuc3VtbWF0aW9uPTcxMztlLnBhcmVubGVmdHRwPTM4NDtlLnBhcmVubGVmdGV4PTM4NDtlLnBhcmVubGVmdGJ0PTM4NDtlLmJyYWNrZXRsZWZ0dHA9Mzg0O2UuYnJhY2tldGxlZnRleD0zODQ7ZS5icmFja2V0bGVmdGJ0PTM4NDtlLmJyYWNlbGVmdHRwPTQ5NDtlLmJyYWNlbGVmdG1pZD00OTQ7ZS5icmFjZWxlZnRidD00OTQ7ZS5icmFjZWV4PTQ5NDtlLmFuZ2xlcmlnaHQ9MzI5O2UuaW50ZWdyYWw9Mjc0O2UuaW50ZWdyYWx0cD02ODY7ZS5pbnRlZ3JhbGV4PTY4NjtlLmludGVncmFsYnQ9Njg2O2UucGFyZW5yaWdodHRwPTM4NDtlLnBhcmVucmlnaHRleD0zODQ7ZS5wYXJlbnJpZ2h0YnQ9Mzg0O2UuYnJhY2tldHJpZ2h0dHA9Mzg0O2UuYnJhY2tldHJpZ2h0ZXg9Mzg0O2UuYnJhY2tldHJpZ2h0YnQ9Mzg0O2UuYnJhY2VyaWdodHRwPTQ5NDtlLmJyYWNlcmlnaHRtaWQ9NDk0O2UuYnJhY2VyaWdodGJ0PTQ5NDtlLmFwcGxlPTc5MH0pO2VbIlRpbWVzLVJvbWFuIl09Z2V0TG9va3VwVGFibGVGYWN0b3J5KGZ1bmN0aW9uKGUpe2Uuc3BhY2U9MjUwO2UuZXhjbGFtPTMzMztlLnF1b3RlZGJsPTQwODtlLm51bWJlcnNpZ249NTAwO2UuZG9sbGFyPTUwMDtlLnBlcmNlbnQ9ODMzO2UuYW1wZXJzYW5kPTc3ODtlLnF1b3RlcmlnaHQ9MzMzO2UucGFyZW5sZWZ0PTMzMztlLnBhcmVucmlnaHQ9MzMzO2UuYXN0ZXJpc2s9NTAwO2UucGx1cz01NjQ7ZS5jb21tYT0yNTA7ZS5oeXBoZW49MzMzO2UucGVyaW9kPTI1MDtlLnNsYXNoPTI3ODtlLnplcm89NTAwO2Uub25lPTUwMDtlLnR3bz01MDA7ZS50aHJlZT01MDA7ZS5mb3VyPTUwMDtlLmZpdmU9NTAwO2Uuc2l4PTUwMDtlLnNldmVuPTUwMDtlLmVpZ2h0PTUwMDtlLm5pbmU9NTAwO2UuY29sb249Mjc4O2Uuc2VtaWNvbG9uPTI3ODtlLmxlc3M9NTY0O2UuZXF1YWw9NTY0O2UuZ3JlYXRlcj01NjQ7ZS5xdWVzdGlvbj00NDQ7ZS5hdD05MjE7ZS5BPTcyMjtlLkI9NjY3O2UuQz02Njc7ZS5EPTcyMjtlLkU9NjExO2UuRj01NTY7ZS5HPTcyMjtlLkg9NzIyO2UuST0zMzM7ZS5KPTM4OTtlLks9NzIyO2UuTD02MTE7ZS5NPTg4OTtlLk49NzIyO2UuTz03MjI7ZS5QPTU1NjtlLlE9NzIyO2UuUj02Njc7ZS5TPTU1NjtlLlQ9NjExO2UuVT03MjI7ZS5WPTcyMjtlLlc9OTQ0O2UuWD03MjI7ZS5ZPTcyMjtlLlo9NjExO2UuYnJhY2tldGxlZnQ9MzMzO2UuYmFja3NsYXNoPTI3ODtlLmJyYWNrZXRyaWdodD0zMzM7ZS5hc2NpaWNpcmN1bT00Njk7ZS51bmRlcnNjb3JlPTUwMDtlLnF1b3RlbGVmdD0zMzM7ZS5hPTQ0NDtlLmI9NTAwO2UuYz00NDQ7ZS5kPTUwMDtlLmU9NDQ0O2UuZj0zMzM7ZS5nPTUwMDtlLmg9NTAwO2UuaT0yNzg7ZS5qPTI3ODtlLms9NTAwO2UubD0yNzg7ZS5tPTc3ODtlLm49NTAwO2Uubz01MDA7ZS5wPTUwMDtlLnE9NTAwO2Uucj0zMzM7ZS5zPTM4OTtlLnQ9Mjc4O2UudT01MDA7ZS52PTUwMDtlLnc9NzIyO2UueD01MDA7ZS55PTUwMDtlLno9NDQ0O2UuYnJhY2VsZWZ0PTQ4MDtlLmJhcj0yMDA7ZS5icmFjZXJpZ2h0PTQ4MDtlLmFzY2lpdGlsZGU9NTQxO2UuZXhjbGFtZG93bj0zMzM7ZS5jZW50PTUwMDtlLnN0ZXJsaW5nPTUwMDtlLmZyYWN0aW9uPTE2NztlLnllbj01MDA7ZS5mbG9yaW49NTAwO2Uuc2VjdGlvbj01MDA7ZS5jdXJyZW5jeT01MDA7ZS5xdW90ZXNpbmdsZT0xODA7ZS5xdW90ZWRibGxlZnQ9NDQ0O2UuZ3VpbGxlbW90bGVmdD01MDA7ZS5ndWlsc2luZ2xsZWZ0PTMzMztlLmd1aWxzaW5nbHJpZ2h0PTMzMztlLmZpPTU1NjtlLmZsPTU1NjtlLmVuZGFzaD01MDA7ZS5kYWdnZXI9NTAwO2UuZGFnZ2VyZGJsPTUwMDtlLnBlcmlvZGNlbnRlcmVkPTI1MDtlLnBhcmFncmFwaD00NTM7ZS5idWxsZXQ9MzUwO2UucXVvdGVzaW5nbGJhc2U9MzMzO2UucXVvdGVkYmxiYXNlPTQ0NDtlLnF1b3RlZGJscmlnaHQ9NDQ0O2UuZ3VpbGxlbW90cmlnaHQ9NTAwO2UuZWxsaXBzaXM9MWUzO2UucGVydGhvdXNhbmQ9MWUzO2UucXVlc3Rpb25kb3duPTQ0NDtlLmdyYXZlPTMzMztlLmFjdXRlPTMzMztlLmNpcmN1bWZsZXg9MzMzO2UudGlsZGU9MzMzO2UubWFjcm9uPTMzMztlLmJyZXZlPTMzMztlLmRvdGFjY2VudD0zMzM7ZS5kaWVyZXNpcz0zMzM7ZS5yaW5nPTMzMztlLmNlZGlsbGE9MzMzO2UuaHVuZ2FydW1sYXV0PTMzMztlLm9nb25laz0zMzM7ZS5jYXJvbj0zMzM7ZS5lbWRhc2g9MWUzO2UuQUU9ODg5O2Uub3JkZmVtaW5pbmU9Mjc2O2UuTHNsYXNoPTYxMTtlLk9zbGFzaD03MjI7ZS5PRT04ODk7ZS5vcmRtYXNjdWxpbmU9MzEwO2UuYWU9NjY3O2UuZG90bGVzc2k9Mjc4O2UubHNsYXNoPTI3ODtlLm9zbGFzaD01MDA7ZS5vZT03MjI7ZS5nZXJtYW5kYmxzPTUwMDtlLklkaWVyZXNpcz0zMzM7ZS5lYWN1dGU9NDQ0O2UuYWJyZXZlPTQ0NDtlLnVodW5nYXJ1bWxhdXQ9NTAwO2UuZWNhcm9uPTQ0NDtlLllkaWVyZXNpcz03MjI7ZS5kaXZpZGU9NTY0O2UuWWFjdXRlPTcyMjtlLkFjaXJjdW1mbGV4PTcyMjtlLmFhY3V0ZT00NDQ7ZS5VY2lyY3VtZmxleD03MjI7ZS55YWN1dGU9NTAwO2Uuc2NvbW1hYWNjZW50PTM4OTtlLmVjaXJjdW1mbGV4PTQ0NDtlLlVyaW5nPTcyMjtlLlVkaWVyZXNpcz03MjI7ZS5hb2dvbmVrPTQ0NDtlLlVhY3V0ZT03MjI7ZS51b2dvbmVrPTUwMDtlLkVkaWVyZXNpcz02MTE7ZS5EY3JvYXQ9NzIyO2UuY29tbWFhY2NlbnQ9MjUwO2UuY29weXJpZ2h0PTc2MDtlLkVtYWNyb249NjExO2UuY2Nhcm9uPTQ0NDtlLmFyaW5nPTQ0NDtlLk5jb21tYWFjY2VudD03MjI7ZS5sYWN1dGU9Mjc4O2UuYWdyYXZlPTQ0NDtlLlRjb21tYWFjY2VudD02MTE7ZS5DYWN1dGU9NjY3O2UuYXRpbGRlPTQ0NDtlLkVkb3RhY2NlbnQ9NjExO2Uuc2Nhcm9uPTM4OTtlLnNjZWRpbGxhPTM4OTtlLmlhY3V0ZT0yNzg7ZS5sb3plbmdlPTQ3MTtlLlJjYXJvbj02Njc7ZS5HY29tbWFhY2NlbnQ9NzIyO2UudWNpcmN1bWZsZXg9NTAwO2UuYWNpcmN1bWZsZXg9NDQ0O2UuQW1hY3Jvbj03MjI7ZS5yY2Fyb249MzMzO2UuY2NlZGlsbGE9NDQ0O2UuWmRvdGFjY2VudD02MTE7ZS5UaG9ybj01NTY7ZS5PbWFjcm9uPTcyMjtlLlJhY3V0ZT02Njc7ZS5TYWN1dGU9NTU2O2UuZGNhcm9uPTU4ODtlLlVtYWNyb249NzIyO2UudXJpbmc9NTAwO2UudGhyZWVzdXBlcmlvcj0zMDA7ZS5PZ3JhdmU9NzIyO2UuQWdyYXZlPTcyMjtlLkFicmV2ZT03MjI7ZS5tdWx0aXBseT01NjQ7ZS51YWN1dGU9NTAwO2UuVGNhcm9uPTYxMTtlLnBhcnRpYWxkaWZmPTQ3NjtlLnlkaWVyZXNpcz01MDA7ZS5OYWN1dGU9NzIyO2UuaWNpcmN1bWZsZXg9Mjc4O2UuRWNpcmN1bWZsZXg9NjExO2UuYWRpZXJlc2lzPTQ0NDtlLmVkaWVyZXNpcz00NDQ7ZS5jYWN1dGU9NDQ0O2UubmFjdXRlPTUwMDtlLnVtYWNyb249NTAwO2UuTmNhcm9uPTcyMjtlLklhY3V0ZT0zMzM7ZS5wbHVzbWludXM9NTY0O2UuYnJva2VuYmFyPTIwMDtlLnJlZ2lzdGVyZWQ9NzYwO2UuR2JyZXZlPTcyMjtlLklkb3RhY2NlbnQ9MzMzO2Uuc3VtbWF0aW9uPTYwMDtlLkVncmF2ZT02MTE7ZS5yYWN1dGU9MzMzO2Uub21hY3Jvbj01MDA7ZS5aYWN1dGU9NjExO2UuWmNhcm9uPTYxMTtlLmdyZWF0ZXJlcXVhbD01NDk7ZS5FdGg9NzIyO2UuQ2NlZGlsbGE9NjY3O2UubGNvbW1hYWNjZW50PTI3ODtlLnRjYXJvbj0zMjY7ZS5lb2dvbmVrPTQ0NDtlLlVvZ29uZWs9NzIyO2UuQWFjdXRlPTcyMjtlLkFkaWVyZXNpcz03MjI7ZS5lZ3JhdmU9NDQ0O2UuemFjdXRlPTQ0NDtlLmlvZ29uZWs9Mjc4O2UuT2FjdXRlPTcyMjtlLm9hY3V0ZT01MDA7ZS5hbWFjcm9uPTQ0NDtlLnNhY3V0ZT0zODk7ZS5pZGllcmVzaXM9Mjc4O2UuT2NpcmN1bWZsZXg9NzIyO2UuVWdyYXZlPTcyMjtlLkRlbHRhPTYxMjtlLnRob3JuPTUwMDtlLnR3b3N1cGVyaW9yPTMwMDtlLk9kaWVyZXNpcz03MjI7ZS5tdT01MDA7ZS5pZ3JhdmU9Mjc4O2Uub2h1bmdhcnVtbGF1dD01MDA7ZS5Fb2dvbmVrPTYxMTtlLmRjcm9hdD01MDA7ZS50aHJlZXF1YXJ0ZXJzPTc1MDtlLlNjZWRpbGxhPTU1NjtlLmxjYXJvbj0zNDQ7ZS5LY29tbWFhY2NlbnQ9NzIyO2UuTGFjdXRlPTYxMTtlLnRyYWRlbWFyaz05ODA7ZS5lZG90YWNjZW50PTQ0NDtlLklncmF2ZT0zMzM7ZS5JbWFjcm9uPTMzMztlLkxjYXJvbj02MTE7ZS5vbmVoYWxmPTc1MDtlLmxlc3NlcXVhbD01NDk7ZS5vY2lyY3VtZmxleD01MDA7ZS5udGlsZGU9NTAwO2UuVWh1bmdhcnVtbGF1dD03MjI7ZS5FYWN1dGU9NjExO2UuZW1hY3Jvbj00NDQ7ZS5nYnJldmU9NTAwO2Uub25lcXVhcnRlcj03NTA7ZS5TY2Fyb249NTU2O2UuU2NvbW1hYWNjZW50PTU1NjtlLk9odW5nYXJ1bWxhdXQ9NzIyO2UuZGVncmVlPTQwMDtlLm9ncmF2ZT01MDA7ZS5DY2Fyb249NjY3O2UudWdyYXZlPTUwMDtlLnJhZGljYWw9NDUzO2UuRGNhcm9uPTcyMjtlLnJjb21tYWFjY2VudD0zMzM7ZS5OdGlsZGU9NzIyO2Uub3RpbGRlPTUwMDtlLlJjb21tYWFjY2VudD02Njc7ZS5MY29tbWFhY2NlbnQ9NjExO2UuQXRpbGRlPTcyMjtlLkFvZ29uZWs9NzIyO2UuQXJpbmc9NzIyO2UuT3RpbGRlPTcyMjtlLnpkb3RhY2NlbnQ9NDQ0O2UuRWNhcm9uPTYxMTtlLklvZ29uZWs9MzMzO2Uua2NvbW1hYWNjZW50PTUwMDtlLm1pbnVzPTU2NDtlLkljaXJjdW1mbGV4PTMzMztlLm5jYXJvbj01MDA7ZS50Y29tbWFhY2NlbnQ9Mjc4O2UubG9naWNhbG5vdD01NjQ7ZS5vZGllcmVzaXM9NTAwO2UudWRpZXJlc2lzPTUwMDtlLm5vdGVxdWFsPTU0OTtlLmdjb21tYWFjY2VudD01MDA7ZS5ldGg9NTAwO2UuemNhcm9uPTQ0NDtlLm5jb21tYWFjY2VudD01MDA7ZS5vbmVzdXBlcmlvcj0zMDA7ZS5pbWFjcm9uPTI3ODtlLkV1cm89NTAwfSk7ZVsiVGltZXMtQm9sZCJdPWdldExvb2t1cFRhYmxlRmFjdG9yeShmdW5jdGlvbihlKXtlLnNwYWNlPTI1MDtlLmV4Y2xhbT0zMzM7ZS5xdW90ZWRibD01NTU7ZS5udW1iZXJzaWduPTUwMDtlLmRvbGxhcj01MDA7ZS5wZXJjZW50PTFlMztlLmFtcGVyc2FuZD04MzM7ZS5xdW90ZXJpZ2h0PTMzMztlLnBhcmVubGVmdD0zMzM7ZS5wYXJlbnJpZ2h0PTMzMztlLmFzdGVyaXNrPTUwMDtlLnBsdXM9NTcwO2UuY29tbWE9MjUwO2UuaHlwaGVuPTMzMztlLnBlcmlvZD0yNTA7ZS5zbGFzaD0yNzg7ZS56ZXJvPTUwMDtlLm9uZT01MDA7ZS50d289NTAwO2UudGhyZWU9NTAwO2UuZm91cj01MDA7ZS5maXZlPTUwMDtlLnNpeD01MDA7ZS5zZXZlbj01MDA7ZS5laWdodD01MDA7ZS5uaW5lPTUwMDtlLmNvbG9uPTMzMztlLnNlbWljb2xvbj0zMzM7ZS5sZXNzPTU3MDtlLmVxdWFsPTU3MDtlLmdyZWF0ZXI9NTcwO2UucXVlc3Rpb249NTAwO2UuYXQ9OTMwO2UuQT03MjI7ZS5CPTY2NztlLkM9NzIyO2UuRD03MjI7ZS5FPTY2NztlLkY9NjExO2UuRz03Nzg7ZS5IPTc3ODtlLkk9Mzg5O2UuSj01MDA7ZS5LPTc3ODtlLkw9NjY3O2UuTT05NDQ7ZS5OPTcyMjtlLk89Nzc4O2UuUD02MTE7ZS5RPTc3ODtlLlI9NzIyO2UuUz01NTY7ZS5UPTY2NztlLlU9NzIyO2UuVj03MjI7ZS5XPTFlMztlLlg9NzIyO2UuWT03MjI7ZS5aPTY2NztlLmJyYWNrZXRsZWZ0PTMzMztlLmJhY2tzbGFzaD0yNzg7ZS5icmFja2V0cmlnaHQ9MzMzO2UuYXNjaWljaXJjdW09NTgxO2UudW5kZXJzY29yZT01MDA7ZS5xdW90ZWxlZnQ9MzMzO2UuYT01MDA7ZS5iPTU1NjtlLmM9NDQ0O2UuZD01NTY7ZS5lPTQ0NDtlLmY9MzMzO2UuZz01MDA7ZS5oPTU1NjtlLmk9Mjc4O2Uuaj0zMzM7ZS5rPTU1NjtlLmw9Mjc4O2UubT04MzM7ZS5uPTU1NjtlLm89NTAwO2UucD01NTY7ZS5xPTU1NjtlLnI9NDQ0O2Uucz0zODk7ZS50PTMzMztlLnU9NTU2O2Uudj01MDA7ZS53PTcyMjtlLng9NTAwO2UueT01MDA7ZS56PTQ0NDtlLmJyYWNlbGVmdD0zOTQ7ZS5iYXI9MjIwO2UuYnJhY2VyaWdodD0zOTQ7ZS5hc2NpaXRpbGRlPTUyMDtlLmV4Y2xhbWRvd249MzMzO2UuY2VudD01MDA7ZS5zdGVybGluZz01MDA7ZS5mcmFjdGlvbj0xNjc7ZS55ZW49NTAwO2UuZmxvcmluPTUwMDtlLnNlY3Rpb249NTAwO2UuY3VycmVuY3k9NTAwO2UucXVvdGVzaW5nbGU9Mjc4O2UucXVvdGVkYmxsZWZ0PTUwMDtlLmd1aWxsZW1vdGxlZnQ9NTAwO2UuZ3VpbHNpbmdsbGVmdD0zMzM7ZS5ndWlsc2luZ2xyaWdodD0zMzM7ZS5maT01NTY7ZS5mbD01NTY7ZS5lbmRhc2g9NTAwO2UuZGFnZ2VyPTUwMDtlLmRhZ2dlcmRibD01MDA7ZS5wZXJpb2RjZW50ZXJlZD0yNTA7ZS5wYXJhZ3JhcGg9NTQwO2UuYnVsbGV0PTM1MDtlLnF1b3Rlc2luZ2xiYXNlPTMzMztlLnF1b3RlZGJsYmFzZT01MDA7ZS5xdW90ZWRibHJpZ2h0PTUwMDtlLmd1aWxsZW1vdHJpZ2h0PTUwMDtlLmVsbGlwc2lzPTFlMztlLnBlcnRob3VzYW5kPTFlMztlLnF1ZXN0aW9uZG93bj01MDA7ZS5ncmF2ZT0zMzM7ZS5hY3V0ZT0zMzM7ZS5jaXJjdW1mbGV4PTMzMztlLnRpbGRlPTMzMztlLm1hY3Jvbj0zMzM7ZS5icmV2ZT0zMzM7ZS5kb3RhY2NlbnQ9MzMzO2UuZGllcmVzaXM9MzMzO2UucmluZz0zMzM7ZS5jZWRpbGxhPTMzMztlLmh1bmdhcnVtbGF1dD0zMzM7ZS5vZ29uZWs9MzMzO2UuY2Fyb249MzMzO2UuZW1kYXNoPTFlMztlLkFFPTFlMztlLm9yZGZlbWluaW5lPTMwMDtlLkxzbGFzaD02Njc7ZS5Pc2xhc2g9Nzc4O2UuT0U9MWUzO2Uub3JkbWFzY3VsaW5lPTMzMDtlLmFlPTcyMjtlLmRvdGxlc3NpPTI3ODtlLmxzbGFzaD0yNzg7ZS5vc2xhc2g9NTAwO2Uub2U9NzIyO2UuZ2VybWFuZGJscz01NTY7ZS5JZGllcmVzaXM9Mzg5O2UuZWFjdXRlPTQ0NDtlLmFicmV2ZT01MDA7ZS51aHVuZ2FydW1sYXV0PTU1NjtlLmVjYXJvbj00NDQ7ZS5ZZGllcmVzaXM9NzIyO2UuZGl2aWRlPTU3MDtlLllhY3V0ZT03MjI7ZS5BY2lyY3VtZmxleD03MjI7ZS5hYWN1dGU9NTAwO2UuVWNpcmN1bWZsZXg9NzIyO2UueWFjdXRlPTUwMDtlLnNjb21tYWFjY2VudD0zODk7ZS5lY2lyY3VtZmxleD00NDQ7ZS5VcmluZz03MjI7ZS5VZGllcmVzaXM9NzIyO2UuYW9nb25laz01MDA7ZS5VYWN1dGU9NzIyO2UudW9nb25laz01NTY7ZS5FZGllcmVzaXM9NjY3O2UuRGNyb2F0PTcyMjtlLmNvbW1hYWNjZW50PTI1MDtlLmNvcHlyaWdodD03NDc7ZS5FbWFjcm9uPTY2NztlLmNjYXJvbj00NDQ7ZS5hcmluZz01MDA7ZS5OY29tbWFhY2NlbnQ9NzIyO2UubGFjdXRlPTI3ODtlLmFncmF2ZT01MDA7ZS5UY29tbWFhY2NlbnQ9NjY3O2UuQ2FjdXRlPTcyMjtlLmF0aWxkZT01MDA7ZS5FZG90YWNjZW50PTY2NztlLnNjYXJvbj0zODk7ZS5zY2VkaWxsYT0zODk7ZS5pYWN1dGU9Mjc4O2UubG96ZW5nZT00OTQ7ZS5SY2Fyb249NzIyO2UuR2NvbW1hYWNjZW50PTc3ODtlLnVjaXJjdW1mbGV4PTU1NjtlLmFjaXJjdW1mbGV4PTUwMDtlLkFtYWNyb249NzIyO2UucmNhcm9uPTQ0NDtlLmNjZWRpbGxhPTQ0NDtlLlpkb3RhY2NlbnQ9NjY3O2UuVGhvcm49NjExO2UuT21hY3Jvbj03Nzg7ZS5SYWN1dGU9NzIyO2UuU2FjdXRlPTU1NjtlLmRjYXJvbj02NzI7ZS5VbWFjcm9uPTcyMjtlLnVyaW5nPTU1NjtlLnRocmVlc3VwZXJpb3I9MzAwO2UuT2dyYXZlPTc3ODtlLkFncmF2ZT03MjI7ZS5BYnJldmU9NzIyO2UubXVsdGlwbHk9NTcwO2UudWFjdXRlPTU1NjtlLlRjYXJvbj02Njc7ZS5wYXJ0aWFsZGlmZj00OTQ7ZS55ZGllcmVzaXM9NTAwO2UuTmFjdXRlPTcyMjtlLmljaXJjdW1mbGV4PTI3ODtlLkVjaXJjdW1mbGV4PTY2NztlLmFkaWVyZXNpcz01MDA7ZS5lZGllcmVzaXM9NDQ0O2UuY2FjdXRlPTQ0NDtlLm5hY3V0ZT01NTY7ZS51bWFjcm9uPTU1NjtlLk5jYXJvbj03MjI7ZS5JYWN1dGU9Mzg5O2UucGx1c21pbnVzPTU3MDtlLmJyb2tlbmJhcj0yMjA7ZS5yZWdpc3RlcmVkPTc0NztlLkdicmV2ZT03Nzg7ZS5JZG90YWNjZW50PTM4OTtlLnN1bW1hdGlvbj02MDA7ZS5FZ3JhdmU9NjY3O2UucmFjdXRlPTQ0NDtlLm9tYWNyb249NTAwO2UuWmFjdXRlPTY2NztlLlpjYXJvbj02Njc7ZS5ncmVhdGVyZXF1YWw9NTQ5O2UuRXRoPTcyMjtlLkNjZWRpbGxhPTcyMjtlLmxjb21tYWFjY2VudD0yNzg7ZS50Y2Fyb249NDE2O2UuZW9nb25laz00NDQ7ZS5Vb2dvbmVrPTcyMjtlLkFhY3V0ZT03MjI7ZS5BZGllcmVzaXM9NzIyO2UuZWdyYXZlPTQ0NDtlLnphY3V0ZT00NDQ7ZS5pb2dvbmVrPTI3ODtlLk9hY3V0ZT03Nzg7ZS5vYWN1dGU9NTAwO2UuYW1hY3Jvbj01MDA7ZS5zYWN1dGU9Mzg5O2UuaWRpZXJlc2lzPTI3ODtlLk9jaXJjdW1mbGV4PTc3ODtlLlVncmF2ZT03MjI7ZS5EZWx0YT02MTI7ZS50aG9ybj01NTY7ZS50d29zdXBlcmlvcj0zMDA7ZS5PZGllcmVzaXM9Nzc4O2UubXU9NTU2O2UuaWdyYXZlPTI3ODtlLm9odW5nYXJ1bWxhdXQ9NTAwO2UuRW9nb25laz02Njc7ZS5kY3JvYXQ9NTU2O2UudGhyZWVxdWFydGVycz03NTA7ZS5TY2VkaWxsYT01NTY7ZS5sY2Fyb249Mzk0O2UuS2NvbW1hYWNjZW50PTc3ODtlLkxhY3V0ZT02Njc7ZS50cmFkZW1hcms9MWUzO2UuZWRvdGFjY2VudD00NDQ7ZS5JZ3JhdmU9Mzg5O2UuSW1hY3Jvbj0zODk7ZS5MY2Fyb249NjY3O2Uub25laGFsZj03NTA7ZS5sZXNzZXF1YWw9NTQ5O2Uub2NpcmN1bWZsZXg9NTAwO2UubnRpbGRlPTU1NjtlLlVodW5nYXJ1bWxhdXQ9NzIyO2UuRWFjdXRlPTY2NztlLmVtYWNyb249NDQ0O2UuZ2JyZXZlPTUwMDtlLm9uZXF1YXJ0ZXI9NzUwO2UuU2Nhcm9uPTU1NjtlLlNjb21tYWFjY2VudD01NTY7ZS5PaHVuZ2FydW1sYXV0PTc3ODtlLmRlZ3JlZT00MDA7ZS5vZ3JhdmU9NTAwO2UuQ2Nhcm9uPTcyMjtlLnVncmF2ZT01NTY7ZS5yYWRpY2FsPTU0OTtlLkRjYXJvbj03MjI7ZS5yY29tbWFhY2NlbnQ9NDQ0O2UuTnRpbGRlPTcyMjtlLm90aWxkZT01MDA7ZS5SY29tbWFhY2NlbnQ9NzIyO2UuTGNvbW1hYWNjZW50PTY2NztlLkF0aWxkZT03MjI7ZS5Bb2dvbmVrPTcyMjtlLkFyaW5nPTcyMjtlLk90aWxkZT03Nzg7ZS56ZG90YWNjZW50PTQ0NDtlLkVjYXJvbj02Njc7ZS5Jb2dvbmVrPTM4OTtlLmtjb21tYWFjY2VudD01NTY7ZS5taW51cz01NzA7ZS5JY2lyY3VtZmxleD0zODk7ZS5uY2Fyb249NTU2O2UudGNvbW1hYWNjZW50PTMzMztlLmxvZ2ljYWxub3Q9NTcwO2Uub2RpZXJlc2lzPTUwMDtlLnVkaWVyZXNpcz01NTY7ZS5ub3RlcXVhbD01NDk7ZS5nY29tbWFhY2NlbnQ9NTAwO2UuZXRoPTUwMDtlLnpjYXJvbj00NDQ7ZS5uY29tbWFhY2NlbnQ9NTU2O2Uub25lc3VwZXJpb3I9MzAwO2UuaW1hY3Jvbj0yNzg7ZS5FdXJvPTUwMH0pO2VbIlRpbWVzLUJvbGRJdGFsaWMiXT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5zcGFjZT0yNTA7ZS5leGNsYW09Mzg5O2UucXVvdGVkYmw9NTU1O2UubnVtYmVyc2lnbj01MDA7ZS5kb2xsYXI9NTAwO2UucGVyY2VudD04MzM7ZS5hbXBlcnNhbmQ9Nzc4O2UucXVvdGVyaWdodD0zMzM7ZS5wYXJlbmxlZnQ9MzMzO2UucGFyZW5yaWdodD0zMzM7ZS5hc3Rlcmlzaz01MDA7ZS5wbHVzPTU3MDtlLmNvbW1hPTI1MDtlLmh5cGhlbj0zMzM7ZS5wZXJpb2Q9MjUwO2Uuc2xhc2g9Mjc4O2UuemVybz01MDA7ZS5vbmU9NTAwO2UudHdvPTUwMDtlLnRocmVlPTUwMDtlLmZvdXI9NTAwO2UuZml2ZT01MDA7ZS5zaXg9NTAwO2Uuc2V2ZW49NTAwO2UuZWlnaHQ9NTAwO2UubmluZT01MDA7ZS5jb2xvbj0zMzM7ZS5zZW1pY29sb249MzMzO2UubGVzcz01NzA7ZS5lcXVhbD01NzA7ZS5ncmVhdGVyPTU3MDtlLnF1ZXN0aW9uPTUwMDtlLmF0PTgzMjtlLkE9NjY3O2UuQj02Njc7ZS5DPTY2NztlLkQ9NzIyO2UuRT02Njc7ZS5GPTY2NztlLkc9NzIyO2UuSD03Nzg7ZS5JPTM4OTtlLko9NTAwO2UuSz02Njc7ZS5MPTYxMTtlLk09ODg5O2UuTj03MjI7ZS5PPTcyMjtlLlA9NjExO2UuUT03MjI7ZS5SPTY2NztlLlM9NTU2O2UuVD02MTE7ZS5VPTcyMjtlLlY9NjY3O2UuVz04ODk7ZS5YPTY2NztlLlk9NjExO2UuWj02MTE7ZS5icmFja2V0bGVmdD0zMzM7ZS5iYWNrc2xhc2g9Mjc4O2UuYnJhY2tldHJpZ2h0PTMzMztlLmFzY2lpY2lyY3VtPTU3MDtlLnVuZGVyc2NvcmU9NTAwO2UucXVvdGVsZWZ0PTMzMztlLmE9NTAwO2UuYj01MDA7ZS5jPTQ0NDtlLmQ9NTAwO2UuZT00NDQ7ZS5mPTMzMztlLmc9NTAwO2UuaD01NTY7ZS5pPTI3ODtlLmo9Mjc4O2Uuaz01MDA7ZS5sPTI3ODtlLm09Nzc4O2Uubj01NTY7ZS5vPTUwMDtlLnA9NTAwO2UucT01MDA7ZS5yPTM4OTtlLnM9Mzg5O2UudD0yNzg7ZS51PTU1NjtlLnY9NDQ0O2Uudz02Njc7ZS54PTUwMDtlLnk9NDQ0O2Uuej0zODk7ZS5icmFjZWxlZnQ9MzQ4O2UuYmFyPTIyMDtlLmJyYWNlcmlnaHQ9MzQ4O2UuYXNjaWl0aWxkZT01NzA7ZS5leGNsYW1kb3duPTM4OTtlLmNlbnQ9NTAwO2Uuc3Rlcmxpbmc9NTAwO2UuZnJhY3Rpb249MTY3O2UueWVuPTUwMDtlLmZsb3Jpbj01MDA7ZS5zZWN0aW9uPTUwMDtlLmN1cnJlbmN5PTUwMDtlLnF1b3Rlc2luZ2xlPTI3ODtlLnF1b3RlZGJsbGVmdD01MDA7ZS5ndWlsbGVtb3RsZWZ0PTUwMDtlLmd1aWxzaW5nbGxlZnQ9MzMzO2UuZ3VpbHNpbmdscmlnaHQ9MzMzO2UuZmk9NTU2O2UuZmw9NTU2O2UuZW5kYXNoPTUwMDtlLmRhZ2dlcj01MDA7ZS5kYWdnZXJkYmw9NTAwO2UucGVyaW9kY2VudGVyZWQ9MjUwO2UucGFyYWdyYXBoPTUwMDtlLmJ1bGxldD0zNTA7ZS5xdW90ZXNpbmdsYmFzZT0zMzM7ZS5xdW90ZWRibGJhc2U9NTAwO2UucXVvdGVkYmxyaWdodD01MDA7ZS5ndWlsbGVtb3RyaWdodD01MDA7ZS5lbGxpcHNpcz0xZTM7ZS5wZXJ0aG91c2FuZD0xZTM7ZS5xdWVzdGlvbmRvd249NTAwO2UuZ3JhdmU9MzMzO2UuYWN1dGU9MzMzO2UuY2lyY3VtZmxleD0zMzM7ZS50aWxkZT0zMzM7ZS5tYWNyb249MzMzO2UuYnJldmU9MzMzO2UuZG90YWNjZW50PTMzMztlLmRpZXJlc2lzPTMzMztlLnJpbmc9MzMzO2UuY2VkaWxsYT0zMzM7ZS5odW5nYXJ1bWxhdXQ9MzMzO2Uub2dvbmVrPTMzMztlLmNhcm9uPTMzMztlLmVtZGFzaD0xZTM7ZS5BRT05NDQ7ZS5vcmRmZW1pbmluZT0yNjY7ZS5Mc2xhc2g9NjExO2UuT3NsYXNoPTcyMjtlLk9FPTk0NDtlLm9yZG1hc2N1bGluZT0zMDA7ZS5hZT03MjI7ZS5kb3RsZXNzaT0yNzg7ZS5sc2xhc2g9Mjc4O2Uub3NsYXNoPTUwMDtlLm9lPTcyMjtlLmdlcm1hbmRibHM9NTAwO2UuSWRpZXJlc2lzPTM4OTtlLmVhY3V0ZT00NDQ7ZS5hYnJldmU9NTAwO2UudWh1bmdhcnVtbGF1dD01NTY7ZS5lY2Fyb249NDQ0O2UuWWRpZXJlc2lzPTYxMTtlLmRpdmlkZT01NzA7ZS5ZYWN1dGU9NjExO2UuQWNpcmN1bWZsZXg9NjY3O2UuYWFjdXRlPTUwMDtlLlVjaXJjdW1mbGV4PTcyMjtlLnlhY3V0ZT00NDQ7ZS5zY29tbWFhY2NlbnQ9Mzg5O2UuZWNpcmN1bWZsZXg9NDQ0O2UuVXJpbmc9NzIyO2UuVWRpZXJlc2lzPTcyMjtlLmFvZ29uZWs9NTAwO2UuVWFjdXRlPTcyMjtlLnVvZ29uZWs9NTU2O2UuRWRpZXJlc2lzPTY2NztlLkRjcm9hdD03MjI7ZS5jb21tYWFjY2VudD0yNTA7ZS5jb3B5cmlnaHQ9NzQ3O2UuRW1hY3Jvbj02Njc7ZS5jY2Fyb249NDQ0O2UuYXJpbmc9NTAwO2UuTmNvbW1hYWNjZW50PTcyMjtlLmxhY3V0ZT0yNzg7ZS5hZ3JhdmU9NTAwO2UuVGNvbW1hYWNjZW50PTYxMTtlLkNhY3V0ZT02Njc7ZS5hdGlsZGU9NTAwO2UuRWRvdGFjY2VudD02Njc7ZS5zY2Fyb249Mzg5O2Uuc2NlZGlsbGE9Mzg5O2UuaWFjdXRlPTI3ODtlLmxvemVuZ2U9NDk0O2UuUmNhcm9uPTY2NztlLkdjb21tYWFjY2VudD03MjI7ZS51Y2lyY3VtZmxleD01NTY7ZS5hY2lyY3VtZmxleD01MDA7ZS5BbWFjcm9uPTY2NztlLnJjYXJvbj0zODk7ZS5jY2VkaWxsYT00NDQ7ZS5aZG90YWNjZW50PTYxMTtlLlRob3JuPTYxMTtlLk9tYWNyb249NzIyO2UuUmFjdXRlPTY2NztlLlNhY3V0ZT01NTY7ZS5kY2Fyb249NjA4O2UuVW1hY3Jvbj03MjI7ZS51cmluZz01NTY7ZS50aHJlZXN1cGVyaW9yPTMwMDtlLk9ncmF2ZT03MjI7ZS5BZ3JhdmU9NjY3O2UuQWJyZXZlPTY2NztlLm11bHRpcGx5PTU3MDtlLnVhY3V0ZT01NTY7ZS5UY2Fyb249NjExO2UucGFydGlhbGRpZmY9NDk0O2UueWRpZXJlc2lzPTQ0NDtlLk5hY3V0ZT03MjI7ZS5pY2lyY3VtZmxleD0yNzg7ZS5FY2lyY3VtZmxleD02Njc7ZS5hZGllcmVzaXM9NTAwO2UuZWRpZXJlc2lzPTQ0NDtlLmNhY3V0ZT00NDQ7ZS5uYWN1dGU9NTU2O2UudW1hY3Jvbj01NTY7ZS5OY2Fyb249NzIyO2UuSWFjdXRlPTM4OTtlLnBsdXNtaW51cz01NzA7ZS5icm9rZW5iYXI9MjIwO2UucmVnaXN0ZXJlZD03NDc7ZS5HYnJldmU9NzIyO2UuSWRvdGFjY2VudD0zODk7ZS5zdW1tYXRpb249NjAwO2UuRWdyYXZlPTY2NztlLnJhY3V0ZT0zODk7ZS5vbWFjcm9uPTUwMDtlLlphY3V0ZT02MTE7ZS5aY2Fyb249NjExO2UuZ3JlYXRlcmVxdWFsPTU0OTtlLkV0aD03MjI7ZS5DY2VkaWxsYT02Njc7ZS5sY29tbWFhY2NlbnQ9Mjc4O2UudGNhcm9uPTM2NjtlLmVvZ29uZWs9NDQ0O2UuVW9nb25laz03MjI7ZS5BYWN1dGU9NjY3O2UuQWRpZXJlc2lzPTY2NztlLmVncmF2ZT00NDQ7ZS56YWN1dGU9Mzg5O2UuaW9nb25laz0yNzg7ZS5PYWN1dGU9NzIyO2Uub2FjdXRlPTUwMDtlLmFtYWNyb249NTAwO2Uuc2FjdXRlPTM4OTtlLmlkaWVyZXNpcz0yNzg7ZS5PY2lyY3VtZmxleD03MjI7ZS5VZ3JhdmU9NzIyO2UuRGVsdGE9NjEyO2UudGhvcm49NTAwO2UudHdvc3VwZXJpb3I9MzAwO2UuT2RpZXJlc2lzPTcyMjtlLm11PTU3NjtlLmlncmF2ZT0yNzg7ZS5vaHVuZ2FydW1sYXV0PTUwMDtlLkVvZ29uZWs9NjY3O2UuZGNyb2F0PTUwMDtlLnRocmVlcXVhcnRlcnM9NzUwO2UuU2NlZGlsbGE9NTU2O2UubGNhcm9uPTM4MjtlLktjb21tYWFjY2VudD02Njc7ZS5MYWN1dGU9NjExO2UudHJhZGVtYXJrPTFlMztlLmVkb3RhY2NlbnQ9NDQ0O2UuSWdyYXZlPTM4OTtlLkltYWNyb249Mzg5O2UuTGNhcm9uPTYxMTtlLm9uZWhhbGY9NzUwO2UubGVzc2VxdWFsPTU0OTtlLm9jaXJjdW1mbGV4PTUwMDtlLm50aWxkZT01NTY7ZS5VaHVuZ2FydW1sYXV0PTcyMjtlLkVhY3V0ZT02Njc7ZS5lbWFjcm9uPTQ0NDtlLmdicmV2ZT01MDA7ZS5vbmVxdWFydGVyPTc1MDtlLlNjYXJvbj01NTY7ZS5TY29tbWFhY2NlbnQ9NTU2O2UuT2h1bmdhcnVtbGF1dD03MjI7ZS5kZWdyZWU9NDAwO2Uub2dyYXZlPTUwMDtlLkNjYXJvbj02Njc7ZS51Z3JhdmU9NTU2O2UucmFkaWNhbD01NDk7ZS5EY2Fyb249NzIyO2UucmNvbW1hYWNjZW50PTM4OTtlLk50aWxkZT03MjI7ZS5vdGlsZGU9NTAwO2UuUmNvbW1hYWNjZW50PTY2NztlLkxjb21tYWFjY2VudD02MTE7ZS5BdGlsZGU9NjY3O2UuQW9nb25laz02Njc7ZS5BcmluZz02Njc7ZS5PdGlsZGU9NzIyO2UuemRvdGFjY2VudD0zODk7ZS5FY2Fyb249NjY3O2UuSW9nb25laz0zODk7ZS5rY29tbWFhY2NlbnQ9NTAwO2UubWludXM9NjA2O2UuSWNpcmN1bWZsZXg9Mzg5O2UubmNhcm9uPTU1NjtlLnRjb21tYWFjY2VudD0yNzg7ZS5sb2dpY2Fsbm90PTYwNjtlLm9kaWVyZXNpcz01MDA7ZS51ZGllcmVzaXM9NTU2O2Uubm90ZXF1YWw9NTQ5O2UuZ2NvbW1hYWNjZW50PTUwMDtlLmV0aD01MDA7ZS56Y2Fyb249Mzg5O2UubmNvbW1hYWNjZW50PTU1NjtlLm9uZXN1cGVyaW9yPTMwMDtlLmltYWNyb249Mjc4O2UuRXVybz01MDB9KTtlWyJUaW1lcy1JdGFsaWMiXT1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5zcGFjZT0yNTA7ZS5leGNsYW09MzMzO2UucXVvdGVkYmw9NDIwO2UubnVtYmVyc2lnbj01MDA7ZS5kb2xsYXI9NTAwO2UucGVyY2VudD04MzM7ZS5hbXBlcnNhbmQ9Nzc4O2UucXVvdGVyaWdodD0zMzM7ZS5wYXJlbmxlZnQ9MzMzO2UucGFyZW5yaWdodD0zMzM7ZS5hc3Rlcmlzaz01MDA7ZS5wbHVzPTY3NTtlLmNvbW1hPTI1MDtlLmh5cGhlbj0zMzM7ZS5wZXJpb2Q9MjUwO2Uuc2xhc2g9Mjc4O2UuemVybz01MDA7ZS5vbmU9NTAwO2UudHdvPTUwMDtlLnRocmVlPTUwMDtlLmZvdXI9NTAwO2UuZml2ZT01MDA7ZS5zaXg9NTAwO2Uuc2V2ZW49NTAwO2UuZWlnaHQ9NTAwO2UubmluZT01MDA7ZS5jb2xvbj0zMzM7ZS5zZW1pY29sb249MzMzO2UubGVzcz02NzU7ZS5lcXVhbD02NzU7ZS5ncmVhdGVyPTY3NTtlLnF1ZXN0aW9uPTUwMDtlLmF0PTkyMDtlLkE9NjExO2UuQj02MTE7ZS5DPTY2NztlLkQ9NzIyO2UuRT02MTE7ZS5GPTYxMTtlLkc9NzIyO2UuSD03MjI7ZS5JPTMzMztlLko9NDQ0O2UuSz02Njc7ZS5MPTU1NjtlLk09ODMzO2UuTj02Njc7ZS5PPTcyMjtlLlA9NjExO2UuUT03MjI7ZS5SPTYxMTtlLlM9NTAwO2UuVD01NTY7ZS5VPTcyMjtlLlY9NjExO2UuVz04MzM7ZS5YPTYxMTtlLlk9NTU2O2UuWj01NTY7ZS5icmFja2V0bGVmdD0zODk7ZS5iYWNrc2xhc2g9Mjc4O2UuYnJhY2tldHJpZ2h0PTM4OTtlLmFzY2lpY2lyY3VtPTQyMjtlLnVuZGVyc2NvcmU9NTAwO2UucXVvdGVsZWZ0PTMzMztlLmE9NTAwO2UuYj01MDA7ZS5jPTQ0NDtlLmQ9NTAwO2UuZT00NDQ7ZS5mPTI3ODtlLmc9NTAwO2UuaD01MDA7ZS5pPTI3ODtlLmo9Mjc4O2Uuaz00NDQ7ZS5sPTI3ODtlLm09NzIyO2Uubj01MDA7ZS5vPTUwMDtlLnA9NTAwO2UucT01MDA7ZS5yPTM4OTtlLnM9Mzg5O2UudD0yNzg7ZS51PTUwMDtlLnY9NDQ0O2Uudz02Njc7ZS54PTQ0NDtlLnk9NDQ0O2Uuej0zODk7ZS5icmFjZWxlZnQ9NDAwO2UuYmFyPTI3NTtlLmJyYWNlcmlnaHQ9NDAwO2UuYXNjaWl0aWxkZT01NDE7ZS5leGNsYW1kb3duPTM4OTtlLmNlbnQ9NTAwO2Uuc3Rlcmxpbmc9NTAwO2UuZnJhY3Rpb249MTY3O2UueWVuPTUwMDtlLmZsb3Jpbj01MDA7ZS5zZWN0aW9uPTUwMDtlLmN1cnJlbmN5PTUwMDtlLnF1b3Rlc2luZ2xlPTIxNDtlLnF1b3RlZGJsbGVmdD01NTY7ZS5ndWlsbGVtb3RsZWZ0PTUwMDtlLmd1aWxzaW5nbGxlZnQ9MzMzO2UuZ3VpbHNpbmdscmlnaHQ9MzMzO2UuZmk9NTAwO2UuZmw9NTAwO2UuZW5kYXNoPTUwMDtlLmRhZ2dlcj01MDA7ZS5kYWdnZXJkYmw9NTAwO2UucGVyaW9kY2VudGVyZWQ9MjUwO2UucGFyYWdyYXBoPTUyMztlLmJ1bGxldD0zNTA7ZS5xdW90ZXNpbmdsYmFzZT0zMzM7ZS5xdW90ZWRibGJhc2U9NTU2O2UucXVvdGVkYmxyaWdodD01NTY7ZS5ndWlsbGVtb3RyaWdodD01MDA7ZS5lbGxpcHNpcz04ODk7ZS5wZXJ0aG91c2FuZD0xZTM7ZS5xdWVzdGlvbmRvd249NTAwO2UuZ3JhdmU9MzMzO2UuYWN1dGU9MzMzO2UuY2lyY3VtZmxleD0zMzM7ZS50aWxkZT0zMzM7ZS5tYWNyb249MzMzO2UuYnJldmU9MzMzO2UuZG90YWNjZW50PTMzMztlLmRpZXJlc2lzPTMzMztlLnJpbmc9MzMzO2UuY2VkaWxsYT0zMzM7ZS5odW5nYXJ1bWxhdXQ9MzMzO2Uub2dvbmVrPTMzMztlLmNhcm9uPTMzMztlLmVtZGFzaD04ODk7ZS5BRT04ODk7ZS5vcmRmZW1pbmluZT0yNzY7ZS5Mc2xhc2g9NTU2O2UuT3NsYXNoPTcyMjtlLk9FPTk0NDtlLm9yZG1hc2N1bGluZT0zMTA7ZS5hZT02Njc7ZS5kb3RsZXNzaT0yNzg7ZS5sc2xhc2g9Mjc4O2Uub3NsYXNoPTUwMDtlLm9lPTY2NztlLmdlcm1hbmRibHM9NTAwO2UuSWRpZXJlc2lzPTMzMztlLmVhY3V0ZT00NDQ7ZS5hYnJldmU9NTAwO2UudWh1bmdhcnVtbGF1dD01MDA7ZS5lY2Fyb249NDQ0O2UuWWRpZXJlc2lzPTU1NjtlLmRpdmlkZT02NzU7ZS5ZYWN1dGU9NTU2O2UuQWNpcmN1bWZsZXg9NjExO2UuYWFjdXRlPTUwMDtlLlVjaXJjdW1mbGV4PTcyMjtlLnlhY3V0ZT00NDQ7ZS5zY29tbWFhY2NlbnQ9Mzg5O2UuZWNpcmN1bWZsZXg9NDQ0O2UuVXJpbmc9NzIyO2UuVWRpZXJlc2lzPTcyMjtlLmFvZ29uZWs9NTAwO2UuVWFjdXRlPTcyMjtlLnVvZ29uZWs9NTAwO2UuRWRpZXJlc2lzPTYxMTtlLkRjcm9hdD03MjI7ZS5jb21tYWFjY2VudD0yNTA7ZS5jb3B5cmlnaHQ9NzYwO2UuRW1hY3Jvbj02MTE7ZS5jY2Fyb249NDQ0O2UuYXJpbmc9NTAwO2UuTmNvbW1hYWNjZW50PTY2NztlLmxhY3V0ZT0yNzg7ZS5hZ3JhdmU9NTAwO2UuVGNvbW1hYWNjZW50PTU1NjtlLkNhY3V0ZT02Njc7ZS5hdGlsZGU9NTAwO2UuRWRvdGFjY2VudD02MTE7ZS5zY2Fyb249Mzg5O2Uuc2NlZGlsbGE9Mzg5O2UuaWFjdXRlPTI3ODtlLmxvemVuZ2U9NDcxO2UuUmNhcm9uPTYxMTtlLkdjb21tYWFjY2VudD03MjI7ZS51Y2lyY3VtZmxleD01MDA7ZS5hY2lyY3VtZmxleD01MDA7ZS5BbWFjcm9uPTYxMTtlLnJjYXJvbj0zODk7ZS5jY2VkaWxsYT00NDQ7ZS5aZG90YWNjZW50PTU1NjtlLlRob3JuPTYxMTtlLk9tYWNyb249NzIyO2UuUmFjdXRlPTYxMTtlLlNhY3V0ZT01MDA7ZS5kY2Fyb249NTQ0O2UuVW1hY3Jvbj03MjI7ZS51cmluZz01MDA7ZS50aHJlZXN1cGVyaW9yPTMwMDtlLk9ncmF2ZT03MjI7ZS5BZ3JhdmU9NjExO2UuQWJyZXZlPTYxMTtlLm11bHRpcGx5PTY3NTtlLnVhY3V0ZT01MDA7ZS5UY2Fyb249NTU2O2UucGFydGlhbGRpZmY9NDc2O2UueWRpZXJlc2lzPTQ0NDtlLk5hY3V0ZT02Njc7ZS5pY2lyY3VtZmxleD0yNzg7ZS5FY2lyY3VtZmxleD02MTE7ZS5hZGllcmVzaXM9NTAwO2UuZWRpZXJlc2lzPTQ0NDtlLmNhY3V0ZT00NDQ7ZS5uYWN1dGU9NTAwO2UudW1hY3Jvbj01MDA7ZS5OY2Fyb249NjY3O2UuSWFjdXRlPTMzMztlLnBsdXNtaW51cz02NzU7ZS5icm9rZW5iYXI9Mjc1O2UucmVnaXN0ZXJlZD03NjA7ZS5HYnJldmU9NzIyO2UuSWRvdGFjY2VudD0zMzM7ZS5zdW1tYXRpb249NjAwO2UuRWdyYXZlPTYxMTtlLnJhY3V0ZT0zODk7ZS5vbWFjcm9uPTUwMDtlLlphY3V0ZT01NTY7ZS5aY2Fyb249NTU2O2UuZ3JlYXRlcmVxdWFsPTU0OTtlLkV0aD03MjI7ZS5DY2VkaWxsYT02Njc7ZS5sY29tbWFhY2NlbnQ9Mjc4O2UudGNhcm9uPTMwMDtlLmVvZ29uZWs9NDQ0O2UuVW9nb25laz03MjI7ZS5BYWN1dGU9NjExO2UuQWRpZXJlc2lzPTYxMTtlLmVncmF2ZT00NDQ7ZS56YWN1dGU9Mzg5O2UuaW9nb25laz0yNzg7ZS5PYWN1dGU9NzIyO2Uub2FjdXRlPTUwMDtlLmFtYWNyb249NTAwO2Uuc2FjdXRlPTM4OTtlLmlkaWVyZXNpcz0yNzg7ZS5PY2lyY3VtZmxleD03MjI7ZS5VZ3JhdmU9NzIyO2UuRGVsdGE9NjEyO2UudGhvcm49NTAwO2UudHdvc3VwZXJpb3I9MzAwO2UuT2RpZXJlc2lzPTcyMjtlLm11PTUwMDtlLmlncmF2ZT0yNzg7ZS5vaHVuZ2FydW1sYXV0PTUwMDtlLkVvZ29uZWs9NjExO2UuZGNyb2F0PTUwMDtlLnRocmVlcXVhcnRlcnM9NzUwO2UuU2NlZGlsbGE9NTAwO2UubGNhcm9uPTMwMDtlLktjb21tYWFjY2VudD02Njc7ZS5MYWN1dGU9NTU2O2UudHJhZGVtYXJrPTk4MDtlLmVkb3RhY2NlbnQ9NDQ0O2UuSWdyYXZlPTMzMztlLkltYWNyb249MzMzO2UuTGNhcm9uPTYxMTtlLm9uZWhhbGY9NzUwO2UubGVzc2VxdWFsPTU0OTtlLm9jaXJjdW1mbGV4PTUwMDtlLm50aWxkZT01MDA7ZS5VaHVuZ2FydW1sYXV0PTcyMjtlLkVhY3V0ZT02MTE7ZS5lbWFjcm9uPTQ0NDtlLmdicmV2ZT01MDA7ZS5vbmVxdWFydGVyPTc1MDtlLlNjYXJvbj01MDA7ZS5TY29tbWFhY2NlbnQ9NTAwO2UuT2h1bmdhcnVtbGF1dD03MjI7ZS5kZWdyZWU9NDAwO2Uub2dyYXZlPTUwMDtlLkNjYXJvbj02Njc7ZS51Z3JhdmU9NTAwO2UucmFkaWNhbD00NTM7ZS5EY2Fyb249NzIyO2UucmNvbW1hYWNjZW50PTM4OTtlLk50aWxkZT02Njc7ZS5vdGlsZGU9NTAwO2UuUmNvbW1hYWNjZW50PTYxMTtlLkxjb21tYWFjY2VudD01NTY7ZS5BdGlsZGU9NjExO2UuQW9nb25laz02MTE7ZS5BcmluZz02MTE7ZS5PdGlsZGU9NzIyO2UuemRvdGFjY2VudD0zODk7ZS5FY2Fyb249NjExO2UuSW9nb25laz0zMzM7ZS5rY29tbWFhY2NlbnQ9NDQ0O2UubWludXM9Njc1O2UuSWNpcmN1bWZsZXg9MzMzO2UubmNhcm9uPTUwMDtlLnRjb21tYWFjY2VudD0yNzg7ZS5sb2dpY2Fsbm90PTY3NTtlLm9kaWVyZXNpcz01MDA7ZS51ZGllcmVzaXM9NTAwO2Uubm90ZXF1YWw9NTQ5O2UuZ2NvbW1hYWNjZW50PTUwMDtlLmV0aD01MDA7ZS56Y2Fyb249Mzg5O2UubmNvbW1hYWNjZW50PTUwMDtlLm9uZXN1cGVyaW9yPTMwMDtlLmltYWNyb249Mjc4O2UuRXVybz01MDB9KTtlLlphcGZEaW5nYmF0cz1nZXRMb29rdXBUYWJsZUZhY3RvcnkoZnVuY3Rpb24oZSl7ZS5zcGFjZT0yNzg7ZS5hMT05NzQ7ZS5hMj05NjE7ZS5hMjAyPTk3NDtlLmEzPTk4MDtlLmE0PTcxOTtlLmE1PTc4OTtlLmExMTk9NzkwO2UuYTExOD03OTE7ZS5hMTE3PTY5MDtlLmExMT05NjA7ZS5hMTI9OTM5O2UuYTEzPTU0OTtlLmExND04NTU7ZS5hMTU9OTExO2UuYTE2PTkzMztlLmExMDU9OTExO2UuYTE3PTk0NTtlLmExOD05NzQ7ZS5hMTk9NzU1O2UuYTIwPTg0NjtlLmEyMT03NjI7ZS5hMjI9NzYxO2UuYTIzPTU3MTtlLmEyND02Nzc7ZS5hMjU9NzYzO2UuYTI2PTc2MDtlLmEyNz03NTk7ZS5hMjg9NzU0O2UuYTY9NDk0O2UuYTc9NTUyO2UuYTg9NTM3O2UuYTk9NTc3O2UuYTEwPTY5MjtlLmEyOT03ODY7ZS5hMzA9Nzg4O2UuYTMxPTc4ODtlLmEzMj03OTA7ZS5hMzM9NzkzO2UuYTM0PTc5NDtlLmEzNT04MTY7ZS5hMzY9ODIzO2UuYTM3PTc4OTtlLmEzOD04NDE7ZS5hMzk9ODIzO2UuYTQwPTgzMztlLmE0MT04MTY7ZS5hNDI9ODMxO2UuYTQzPTkyMztlLmE0ND03NDQ7ZS5hNDU9NzIzO2UuYTQ2PTc0OTtlLmE0Nz03OTA7ZS5hNDg9NzkyO2UuYTQ5PTY5NTtlLmE1MD03NzY7ZS5hNTE9NzY4O2UuYTUyPTc5MjtlLmE1Mz03NTk7ZS5hNTQ9NzA3O2UuYTU1PTcwODtlLmE1Nj02ODI7ZS5hNTc9NzAxO2UuYTU4PTgyNjtlLmE1OT04MTU7ZS5hNjA9Nzg5O2UuYTYxPTc4OTtlLmE2Mj03MDc7ZS5hNjM9Njg3O2UuYTY0PTY5NjtlLmE2NT02ODk7ZS5hNjY9Nzg2O2UuYTY3PTc4NztlLmE2OD03MTM7ZS5hNjk9NzkxO2UuYTcwPTc4NTtlLmE3MT03OTE7ZS5hNzI9ODczO2UuYTczPTc2MTtlLmE3ND03NjI7ZS5hMjAzPTc2MjtlLmE3NT03NTk7ZS5hMjA0PTc1OTtlLmE3Nj04OTI7ZS5hNzc9ODkyO2UuYTc4PTc4ODtlLmE3OT03ODQ7ZS5hODE9NDM4O2UuYTgyPTEzODtlLmE4Mz0yNzc7ZS5hODQ9NDE1O2UuYTk3PTM5MjtlLmE5OD0zOTI7ZS5hOTk9NjY4O2UuYTEwMD02Njg7ZS5hODk9MzkwO2UuYTkwPTM5MDtlLmE5Mz0zMTc7ZS5hOTQ9MzE3O2UuYTkxPTI3NjtlLmE5Mj0yNzY7ZS5hMjA1PTUwOTtlLmE4NT01MDk7ZS5hMjA2PTQxMDtlLmE4Nj00MTA7ZS5hODc9MjM0O2UuYTg4PTIzNDtlLmE5NT0zMzQ7ZS5hOTY9MzM0O2UuYTEwMT03MzI7ZS5hMTAyPTU0NDtlLmExMDM9NTQ0O2UuYTEwND05MTA7ZS5hMTA2PTY2NztlLmExMDc9NzYwO2UuYTEwOD03NjA7ZS5hMTEyPTc3NjtlLmExMTE9NTk1O2UuYTExMD02OTQ7ZS5hMTA5PTYyNjtlLmExMjA9Nzg4O2UuYTEyMT03ODg7ZS5hMTIyPTc4ODtlLmExMjM9Nzg4O2UuYTEyND03ODg7ZS5hMTI1PTc4ODtlLmExMjY9Nzg4O2UuYTEyNz03ODg7ZS5hMTI4PTc4ODtlLmExMjk9Nzg4O2UuYTEzMD03ODg7ZS5hMTMxPTc4ODtlLmExMzI9Nzg4O2UuYTEzMz03ODg7ZS5hMTM0PTc4ODtlLmExMzU9Nzg4O2UuYTEzNj03ODg7ZS5hMTM3PTc4ODtlLmExMzg9Nzg4O2UuYTEzOT03ODg7ZS5hMTQwPTc4ODtlLmExNDE9Nzg4O2UuYTE0Mj03ODg7ZS5hMTQzPTc4ODtlLmExNDQ9Nzg4O2UuYTE0NT03ODg7ZS5hMTQ2PTc4ODtlLmExNDc9Nzg4O2UuYTE0OD03ODg7ZS5hMTQ5PTc4ODtlLmExNTA9Nzg4O2UuYTE1MT03ODg7ZS5hMTUyPTc4ODtlLmExNTM9Nzg4O2UuYTE1ND03ODg7ZS5hMTU1PTc4ODtlLmExNTY9Nzg4O2UuYTE1Nz03ODg7ZS5hMTU4PTc4ODtlLmExNTk9Nzg4O2UuYTE2MD04OTQ7ZS5hMTYxPTgzODtlLmExNjM9MTAxNjtlLmExNjQ9NDU4O2UuYTE5Nj03NDg7ZS5hMTY1PTkyNDtlLmExOTI9NzQ4O2UuYTE2Nj05MTg7ZS5hMTY3PTkyNztlLmExNjg9OTI4O2UuYTE2OT05Mjg7ZS5hMTcwPTgzNDtlLmExNzE9ODczO2UuYTE3Mj04Mjg7ZS5hMTczPTkyNDtlLmExNjI9OTI0O2UuYTE3ND05MTc7ZS5hMTc1PTkzMDtlLmExNzY9OTMxO2UuYTE3Nz00NjM7ZS5hMTc4PTg4MztlLmExNzk9ODM2O2UuYTE5Mz04MzY7ZS5hMTgwPTg2NztlLmExOTk9ODY3O2UuYTE4MT02OTY7ZS5hMjAwPTY5NjtlLmExODI9ODc0O2UuYTIwMT04NzQ7ZS5hMTgzPTc2MDtlLmExODQ9OTQ2O2UuYTE5Nz03NzE7ZS5hMTg1PTg2NTtlLmExOTQ9NzcxO2UuYTE5OD04ODg7ZS5hMTg2PTk2NztlLmExOTU9ODg4O2UuYTE4Nz04MzE7ZS5hMTg4PTg3MztlLmExODk9OTI3O2UuYTE5MD05NzA7ZS5hMTkxPTkxOH0pfSksR2E9Z2V0TG9va3VwVGFibGVGYWN0b3J5KGZ1bmN0aW9uKGUpe2UuQ291cmllcj17YXNjZW50OjYyOSxkZXNjZW50Oi0xNTcsY2FwSGVpZ2h0OjU2Mix4SGVpZ2h0Oi00MjZ9O2VbIkNvdXJpZXItQm9sZCJdPXthc2NlbnQ6NjI5LGRlc2NlbnQ6LTE1NyxjYXBIZWlnaHQ6NTYyLHhIZWlnaHQ6NDM5fTtlWyJDb3VyaWVyLU9ibGlxdWUiXT17YXNjZW50OjYyOSxkZXNjZW50Oi0xNTcsY2FwSGVpZ2h0OjU2Mix4SGVpZ2h0OjQyNn07ZVsiQ291cmllci1Cb2xkT2JsaXF1ZSJdPXthc2NlbnQ6NjI5LGRlc2NlbnQ6LTE1NyxjYXBIZWlnaHQ6NTYyLHhIZWlnaHQ6NDI2fTtlLkhlbHZldGljYT17YXNjZW50OjcxOCxkZXNjZW50Oi0yMDcsY2FwSGVpZ2h0OjcxOCx4SGVpZ2h0OjUyM307ZVsiSGVsdmV0aWNhLUJvbGQiXT17YXNjZW50OjcxOCxkZXNjZW50Oi0yMDcsY2FwSGVpZ2h0OjcxOCx4SGVpZ2h0OjUzMn07ZVsiSGVsdmV0aWNhLU9ibGlxdWUiXT17YXNjZW50OjcxOCxkZXNjZW50Oi0yMDcsY2FwSGVpZ2h0OjcxOCx4SGVpZ2h0OjUyM307ZVsiSGVsdmV0aWNhLUJvbGRPYmxpcXVlIl09e2FzY2VudDo3MTgsZGVzY2VudDotMjA3LGNhcEhlaWdodDo3MTgseEhlaWdodDo1MzJ9O2VbIlRpbWVzLVJvbWFuIl09e2FzY2VudDo2ODMsZGVzY2VudDotMjE3LGNhcEhlaWdodDo2NjIseEhlaWdodDo0NTB9O2VbIlRpbWVzLUJvbGQiXT17YXNjZW50OjY4MyxkZXNjZW50Oi0yMTcsY2FwSGVpZ2h0OjY3Nix4SGVpZ2h0OjQ2MX07ZVsiVGltZXMtSXRhbGljIl09e2FzY2VudDo2ODMsZGVzY2VudDotMjE3LGNhcEhlaWdodDo2NTMseEhlaWdodDo0NDF9O2VbIlRpbWVzLUJvbGRJdGFsaWMiXT17YXNjZW50OjY4MyxkZXNjZW50Oi0yMTcsY2FwSGVpZ2h0OjY2OSx4SGVpZ2h0OjQ2Mn07ZS5TeW1ib2w9e2FzY2VudDpNYXRoLk5hTixkZXNjZW50Ok1hdGguTmFOLGNhcEhlaWdodDpNYXRoLk5hTix4SGVpZ2h0Ok1hdGguTmFOfTtlLlphcGZEaW5nYmF0cz17YXNjZW50Ok1hdGguTmFOLGRlc2NlbnQ6TWF0aC5OYU4sY2FwSGVpZ2h0Ok1hdGguTmFOLHhIZWlnaHQ6TWF0aC5OYU59fSk7Y2xhc3MgR2x5ZlRhYmxle2NvbnN0cnVjdG9yKHtnbHlmVGFibGU6ZSxpc0dseXBoTG9jYXRpb25zTG9uZzp0LGxvY2FUYWJsZTpyLG51bUdseXBoczphfSl7dGhpcy5nbHlwaHM9W107Y29uc3Qgbj1uZXcgRGF0YVZpZXcoci5idWZmZXIsci5ieXRlT2Zmc2V0LHIuYnl0ZUxlbmd0aCksaT1uZXcgRGF0YVZpZXcoZS5idWZmZXIsZS5ieXRlT2Zmc2V0LGUuYnl0ZUxlbmd0aCkscz10PzQ6MjtsZXQgbz10P24uZ2V0VWludDMyKDApOjIqbi5nZXRVaW50MTYoMCksYz0wO2ZvcihsZXQgZT0wO2U8YTtlKyspe2MrPXM7Y29uc3QgZT10P24uZ2V0VWludDMyKGMpOjIqbi5nZXRVaW50MTYoYyk7aWYoZT09PW8pe3RoaXMuZ2x5cGhzLnB1c2gobmV3IEdseXBoKHt9KSk7Y29udGludWV9Y29uc3Qgcj1HbHlwaC5wYXJzZShvLGkpO3RoaXMuZ2x5cGhzLnB1c2gocik7bz1lfX1nZXRTaXplKCl7cmV0dXJuIE1hdGguc3VtUHJlY2lzZSh0aGlzLmdseXBocy5tYXAoZT0+ZS5nZXRTaXplKCkrMyYtNCkpfXdyaXRlKCl7Y29uc3QgZT10aGlzLmdldFNpemUoKSx0PW5ldyBEYXRhVmlldyhuZXcgQXJyYXlCdWZmZXIoZSkpLHI9ZT4xMzEwNzAsYT1yPzQ6MixuPW5ldyBEYXRhVmlldyhuZXcgQXJyYXlCdWZmZXIoKHRoaXMuZ2x5cGhzLmxlbmd0aCsxKSphKSk7cj9uLnNldFVpbnQzMigwLDApOm4uc2V0VWludDE2KDAsMCk7bGV0IGk9MCxzPTA7Zm9yKGNvbnN0IGUgb2YgdGhpcy5nbHlwaHMpe2krPWUud3JpdGUoaSx0KTtpPWkrMyYtNDtzKz1hO3I/bi5zZXRVaW50MzIocyxpKTpuLnNldFVpbnQxNihzLGk+PjEpfXJldHVybntpc0xvY2F0aW9uTG9uZzpyLGxvY2E6bmV3IFVpbnQ4QXJyYXkobi5idWZmZXIpLGdseWY6bmV3IFVpbnQ4QXJyYXkodC5idWZmZXIpfX1zY2FsZShlKXtmb3IobGV0IHQ9MCxyPXRoaXMuZ2x5cGhzLmxlbmd0aDt0PHI7dCsrKXRoaXMuZ2x5cGhzW3RdLnNjYWxlKGVbdF0pfX1jbGFzcyBHbHlwaHtjb25zdHJ1Y3Rvcih7aGVhZGVyOmU9bnVsbCxzaW1wbGU6dD1udWxsLGNvbXBvc2l0ZXM6cj1udWxsfSl7dGhpcy5oZWFkZXI9ZTt0aGlzLnNpbXBsZT10O3RoaXMuY29tcG9zaXRlcz1yfXN0YXRpYyBwYXJzZShlLHQpe2NvbnN0W3IsYV09R2x5cGhIZWFkZXIucGFyc2UoZSx0KTtlKz1yO2lmKGEubnVtYmVyT2ZDb250b3VyczwwKXtjb25zdCByPVtdO2Zvcig7Oyl7Y29uc3RbYSxuXT1Db21wb3NpdGVHbHlwaC5wYXJzZShlLHQpO2UrPWE7ci5wdXNoKG4pO2lmKCEoMzImbi5mbGFncykpYnJlYWt9cmV0dXJuIG5ldyBHbHlwaCh7aGVhZGVyOmEsY29tcG9zaXRlczpyfSl9Y29uc3Qgbj1TaW1wbGVHbHlwaC5wYXJzZShlLHQsYS5udW1iZXJPZkNvbnRvdXJzKTtyZXR1cm4gbmV3IEdseXBoKHtoZWFkZXI6YSxzaW1wbGU6bn0pfWdldFNpemUoKXtpZighdGhpcy5oZWFkZXIpcmV0dXJuIDA7Y29uc3QgZT10aGlzLnNpbXBsZT90aGlzLnNpbXBsZS5nZXRTaXplKCk6TWF0aC5zdW1QcmVjaXNlKHRoaXMuY29tcG9zaXRlcy5tYXAoZT0+ZS5nZXRTaXplKCkpKTtyZXR1cm4gdGhpcy5oZWFkZXIuZ2V0U2l6ZSgpK2V9d3JpdGUoZSx0KXtpZighdGhpcy5oZWFkZXIpcmV0dXJuIDA7Y29uc3Qgcj1lO2UrPXRoaXMuaGVhZGVyLndyaXRlKGUsdCk7aWYodGhpcy5zaW1wbGUpZSs9dGhpcy5zaW1wbGUud3JpdGUoZSx0KTtlbHNlIGZvcihjb25zdCByIG9mIHRoaXMuY29tcG9zaXRlcyllKz1yLndyaXRlKGUsdCk7cmV0dXJuIGUtcn1zY2FsZShlKXtpZighdGhpcy5oZWFkZXIpcmV0dXJuO2NvbnN0IHQ9KHRoaXMuaGVhZGVyLnhNaW4rdGhpcy5oZWFkZXIueE1heCkvMjt0aGlzLmhlYWRlci5zY2FsZSh0LGUpO2lmKHRoaXMuc2ltcGxlKXRoaXMuc2ltcGxlLnNjYWxlKHQsZSk7ZWxzZSBmb3IoY29uc3QgciBvZiB0aGlzLmNvbXBvc2l0ZXMpci5zY2FsZSh0LGUpfX1jbGFzcyBHbHlwaEhlYWRlcntjb25zdHJ1Y3Rvcih7bnVtYmVyT2ZDb250b3VyczplLHhNaW46dCx5TWluOnIseE1heDphLHlNYXg6bn0pe3RoaXMubnVtYmVyT2ZDb250b3Vycz1lO3RoaXMueE1pbj10O3RoaXMueU1pbj1yO3RoaXMueE1heD1hO3RoaXMueU1heD1ufXN0YXRpYyBwYXJzZShlLHQpe3JldHVyblsxMCxuZXcgR2x5cGhIZWFkZXIoe251bWJlck9mQ29udG91cnM6dC5nZXRJbnQxNihlKSx4TWluOnQuZ2V0SW50MTYoZSsyKSx5TWluOnQuZ2V0SW50MTYoZSs0KSx4TWF4OnQuZ2V0SW50MTYoZSs2KSx5TWF4OnQuZ2V0SW50MTYoZSs4KX0pXX1nZXRTaXplKCl7cmV0dXJuIDEwfXdyaXRlKGUsdCl7dC5zZXRJbnQxNihlLHRoaXMubnVtYmVyT2ZDb250b3Vycyk7dC5zZXRJbnQxNihlKzIsdGhpcy54TWluKTt0LnNldEludDE2KGUrNCx0aGlzLnlNaW4pO3Quc2V0SW50MTYoZSs2LHRoaXMueE1heCk7dC5zZXRJbnQxNihlKzgsdGhpcy55TWF4KTtyZXR1cm4gMTB9c2NhbGUoZSx0KXt0aGlzLnhNaW49TWF0aC5yb3VuZChlKyh0aGlzLnhNaW4tZSkqdCk7dGhpcy54TWF4PU1hdGgucm91bmQoZSsodGhpcy54TWF4LWUpKnQpfX1jbGFzcyBDb250b3Vye2NvbnN0cnVjdG9yKHtmbGFnczplLHhDb29yZGluYXRlczp0LHlDb29yZGluYXRlczpyfSl7dGhpcy54Q29vcmRpbmF0ZXM9dDt0aGlzLnlDb29yZGluYXRlcz1yO3RoaXMuZmxhZ3M9ZX19Y2xhc3MgU2ltcGxlR2x5cGh7Y29uc3RydWN0b3Ioe2NvbnRvdXJzOmUsaW5zdHJ1Y3Rpb25zOnR9KXt0aGlzLmNvbnRvdXJzPWU7dGhpcy5pbnN0cnVjdGlvbnM9dH1zdGF0aWMgcGFyc2UoZSx0LHIpe2NvbnN0IGE9W107Zm9yKGxldCBuPTA7bjxyO24rKyl7Y29uc3Qgcj10LmdldFVpbnQxNihlKTtlKz0yO2EucHVzaChyKX1jb25zdCBuPWFbci0xXSsxLGk9dC5nZXRVaW50MTYoZSk7ZSs9Mjtjb25zdCBzPW5ldyBVaW50OEFycmF5KHQpLnNsaWNlKGUsZStpKTtlKz1pO2NvbnN0IG89W107Zm9yKGxldCByPTA7cjxuO2UrKyxyKyspe2xldCBhPXQuZ2V0VWludDgoZSk7by5wdXNoKGEpO2lmKDgmYSl7Y29uc3Qgbj10LmdldFVpbnQ4KCsrZSk7YV49ODtmb3IobGV0IGU9MDtlPG47ZSsrKW8ucHVzaChhKTtyKz1ufX1jb25zdCBjPVtdO2xldCBsPVtdLGg9W10sdT1bXTtjb25zdCBkPVtdO2xldCBmPTAsZz0wO2ZvcihsZXQgcj0wO3I8bjtyKyspe2NvbnN0IG49b1tyXTtpZigyJm4pe2NvbnN0IHI9dC5nZXRVaW50OChlKyspO2crPTE2Jm4/cjotcjtsLnB1c2goZyl9ZWxzZSBpZigxNiZuKWwucHVzaChnKTtlbHNle2crPXQuZ2V0SW50MTYoZSk7ZSs9MjtsLnB1c2goZyl9aWYoYVtmXT09PXIpe2YrKztjLnB1c2gobCk7bD1bXX19Zz0wO2Y9MDtmb3IobGV0IHI9MDtyPG47cisrKXtjb25zdCBuPW9bcl07aWYoNCZuKXtjb25zdCByPXQuZ2V0VWludDgoZSsrKTtnKz0zMiZuP3I6LXI7aC5wdXNoKGcpfWVsc2UgaWYoMzImbiloLnB1c2goZyk7ZWxzZXtnKz10LmdldEludDE2KGUpO2UrPTI7aC5wdXNoKGcpfXUucHVzaCgxJm58NjQmbik7aWYoYVtmXT09PXIpe2w9Y1tmXTtmKys7ZC5wdXNoKG5ldyBDb250b3VyKHtmbGFnczp1LHhDb29yZGluYXRlczpsLHlDb29yZGluYXRlczpofSkpO2g9W107dT1bXX19cmV0dXJuIG5ldyBTaW1wbGVHbHlwaCh7Y29udG91cnM6ZCxpbnN0cnVjdGlvbnM6c30pfWdldFNpemUoKXtsZXQgZT0yKnRoaXMuY29udG91cnMubGVuZ3RoKzIrdGhpcy5pbnN0cnVjdGlvbnMubGVuZ3RoLHQ9MCxyPTA7Zm9yKGNvbnN0IGEgb2YgdGhpcy5jb250b3Vycyl7ZSs9YS5mbGFncy5sZW5ndGg7Zm9yKGxldCBuPTAsaT1hLnhDb29yZGluYXRlcy5sZW5ndGg7bjxpO24rKyl7Y29uc3QgaT1hLnhDb29yZGluYXRlc1tuXSxzPWEueUNvb3JkaW5hdGVzW25dO2xldCBvPU1hdGguYWJzKGktdCk7bz4yNTU/ZSs9MjpvPjAmJihlKz0xKTt0PWk7bz1NYXRoLmFicyhzLXIpO28+MjU1P2UrPTI6bz4wJiYoZSs9MSk7cj1zfX1yZXR1cm4gZX13cml0ZShlLHQpe2NvbnN0IHI9ZSxhPVtdLG49W10saT1bXTtsZXQgcz0wLG89MDtmb3IoY29uc3QgciBvZiB0aGlzLmNvbnRvdXJzKXtmb3IobGV0IGU9MCx0PXIueENvb3JkaW5hdGVzLmxlbmd0aDtlPHQ7ZSsrKXtsZXQgdD1yLmZsYWdzW2VdO2NvbnN0IGM9ci54Q29vcmRpbmF0ZXNbZV07bGV0IGw9Yy1zO2lmKDA9PT1sKXt0fD0xNjthLnB1c2goMCl9ZWxzZXtjb25zdCBlPU1hdGguYWJzKGwpO2lmKGU8PTI1NSl7dHw9bD49MD8xODoyO2EucHVzaChlKX1lbHNlIGEucHVzaChsKX1zPWM7Y29uc3QgaD1yLnlDb29yZGluYXRlc1tlXTtsPWgtbztpZigwPT09bCl7dHw9MzI7bi5wdXNoKDApfWVsc2V7Y29uc3QgZT1NYXRoLmFicyhsKTtpZihlPD0yNTUpe3R8PWw+PTA/MzY6NDtuLnB1c2goZSl9ZWxzZSBuLnB1c2gobCl9bz1oO2kucHVzaCh0KX10LnNldFVpbnQxNihlLGEubGVuZ3RoLTEpO2UrPTJ9dC5zZXRVaW50MTYoZSx0aGlzLmluc3RydWN0aW9ucy5sZW5ndGgpO2UrPTI7aWYodGhpcy5pbnN0cnVjdGlvbnMubGVuZ3RoKXtuZXcgVWludDhBcnJheSh0LmJ1ZmZlciwwLHQuYnVmZmVyLmJ5dGVMZW5ndGgpLnNldCh0aGlzLmluc3RydWN0aW9ucyxlKTtlKz10aGlzLmluc3RydWN0aW9ucy5sZW5ndGh9Zm9yKGNvbnN0IHIgb2YgaSl0LnNldFVpbnQ4KGUrKyxyKTtmb3IobGV0IHI9MCxuPWEubGVuZ3RoO3I8bjtyKyspe2NvbnN0IG49YVtyXSxzPWlbcl07aWYoMiZzKXQuc2V0VWludDgoZSsrLG4pO2Vsc2UgaWYoISgxNiZzKSl7dC5zZXRJbnQxNihlLG4pO2UrPTJ9fWZvcihsZXQgcj0wLGE9bi5sZW5ndGg7cjxhO3IrKyl7Y29uc3QgYT1uW3JdLHM9aVtyXTtpZig0JnMpdC5zZXRVaW50OChlKyssYSk7ZWxzZSBpZighKDMyJnMpKXt0LnNldEludDE2KGUsYSk7ZSs9Mn19cmV0dXJuIGUtcn1zY2FsZShlLHQpe2Zvcihjb25zdCByIG9mIHRoaXMuY29udG91cnMpaWYoMCE9PXIueENvb3JkaW5hdGVzLmxlbmd0aClmb3IobGV0IGE9MCxuPXIueENvb3JkaW5hdGVzLmxlbmd0aDthPG47YSsrKXIueENvb3JkaW5hdGVzW2FdPU1hdGgucm91bmQoZSsoci54Q29vcmRpbmF0ZXNbYV0tZSkqdCl9fWNsYXNzIENvbXBvc2l0ZUdseXBoe2NvbnN0cnVjdG9yKHtmbGFnczplLGdseXBoSW5kZXg6dCxhcmd1bWVudDE6cixhcmd1bWVudDI6YSx0cmFuc2Y6bixpbnN0cnVjdGlvbnM6aX0pe3RoaXMuZmxhZ3M9ZTt0aGlzLmdseXBoSW5kZXg9dDt0aGlzLmFyZ3VtZW50MT1yO3RoaXMuYXJndW1lbnQyPWE7dGhpcy50cmFuc2Y9bjt0aGlzLmluc3RydWN0aW9ucz1pfXN0YXRpYyBwYXJzZShlLHQpe2NvbnN0IHI9ZSxhPVtdO2xldCBuPXQuZ2V0VWludDE2KGUpO2NvbnN0IGk9dC5nZXRVaW50MTYoZSsyKTtlKz00O2xldCBzLG87aWYoMSZuKXtpZigyJm4pe3M9dC5nZXRJbnQxNihlKTtvPXQuZ2V0SW50MTYoZSsyKX1lbHNle3M9dC5nZXRVaW50MTYoZSk7bz10LmdldFVpbnQxNihlKzIpfWUrPTQ7bl49MX1lbHNle2lmKDImbil7cz10LmdldEludDgoZSk7bz10LmdldEludDgoZSsxKX1lbHNle3M9dC5nZXRVaW50OChlKTtvPXQuZ2V0VWludDgoZSsxKX1lKz0yfWlmKDgmbil7YS5wdXNoKHQuZ2V0VWludDE2KGUpKTtlKz0yfWVsc2UgaWYoNjQmbil7YS5wdXNoKHQuZ2V0VWludDE2KGUpLHQuZ2V0VWludDE2KGUrMikpO2UrPTR9ZWxzZSBpZigxMjgmbil7YS5wdXNoKHQuZ2V0VWludDE2KGUpLHQuZ2V0VWludDE2KGUrMiksdC5nZXRVaW50MTYoZSs0KSx0LmdldFVpbnQxNihlKzYpKTtlKz04fWxldCBjPW51bGw7aWYoMjU2Jm4pe2NvbnN0IHI9dC5nZXRVaW50MTYoZSk7ZSs9MjtjPW5ldyBVaW50OEFycmF5KHQpLnNsaWNlKGUsZStyKTtlKz1yfXJldHVybltlLXIsbmV3IENvbXBvc2l0ZUdseXBoKHtmbGFnczpuLGdseXBoSW5kZXg6aSxhcmd1bWVudDE6cyxhcmd1bWVudDI6byx0cmFuc2Y6YSxpbnN0cnVjdGlvbnM6Y30pXX1nZXRTaXplKCl7bGV0IGU9NCsyKnRoaXMudHJhbnNmLmxlbmd0aDsyNTYmdGhpcy5mbGFncyYmKGUrPTIrdGhpcy5pbnN0cnVjdGlvbnMubGVuZ3RoKTtlKz0yOzImdGhpcy5mbGFncz90aGlzLmFyZ3VtZW50MT49LTEyOCYmdGhpcy5hcmd1bWVudDE8PTEyNyYmdGhpcy5hcmd1bWVudDI+PS0xMjgmJnRoaXMuYXJndW1lbnQyPD0xMjd8fChlKz0yKTp0aGlzLmFyZ3VtZW50MT49MCYmdGhpcy5hcmd1bWVudDE8PTI1NSYmdGhpcy5hcmd1bWVudDI+PTAmJnRoaXMuYXJndW1lbnQyPD0yNTV8fChlKz0yKTtyZXR1cm4gZX13cml0ZShlLHQpe2NvbnN0IHI9ZTsyJnRoaXMuZmxhZ3M/dGhpcy5hcmd1bWVudDE+PS0xMjgmJnRoaXMuYXJndW1lbnQxPD0xMjcmJnRoaXMuYXJndW1lbnQyPj0tMTI4JiZ0aGlzLmFyZ3VtZW50Mjw9MTI3fHwodGhpcy5mbGFnc3w9MSk6dGhpcy5hcmd1bWVudDE+PTAmJnRoaXMuYXJndW1lbnQxPD0yNTUmJnRoaXMuYXJndW1lbnQyPj0wJiZ0aGlzLmFyZ3VtZW50Mjw9MjU1fHwodGhpcy5mbGFnc3w9MSk7dC5zZXRVaW50MTYoZSx0aGlzLmZsYWdzKTt0LnNldFVpbnQxNihlKzIsdGhpcy5nbHlwaEluZGV4KTtlKz00O2lmKDEmdGhpcy5mbGFncyl7aWYoMiZ0aGlzLmZsYWdzKXt0LnNldEludDE2KGUsdGhpcy5hcmd1bWVudDEpO3Quc2V0SW50MTYoZSsyLHRoaXMuYXJndW1lbnQyKX1lbHNle3Quc2V0VWludDE2KGUsdGhpcy5hcmd1bWVudDEpO3Quc2V0VWludDE2KGUrMix0aGlzLmFyZ3VtZW50Mil9ZSs9NH1lbHNle3Quc2V0VWludDgoZSx0aGlzLmFyZ3VtZW50MSk7dC5zZXRVaW50OChlKzEsdGhpcy5hcmd1bWVudDIpO2UrPTJ9aWYoMjU2JnRoaXMuZmxhZ3Mpe3Quc2V0VWludDE2KGUsdGhpcy5pbnN0cnVjdGlvbnMubGVuZ3RoKTtlKz0yO2lmKHRoaXMuaW5zdHJ1Y3Rpb25zLmxlbmd0aCl7bmV3IFVpbnQ4QXJyYXkodC5idWZmZXIsMCx0LmJ1ZmZlci5ieXRlTGVuZ3RoKS5zZXQodGhpcy5pbnN0cnVjdGlvbnMsZSk7ZSs9dGhpcy5pbnN0cnVjdGlvbnMubGVuZ3RofX1yZXR1cm4gZS1yfXNjYWxlKGUsdCl7fX1mdW5jdGlvbiB3cml0ZUludDE2KGUsdCxyKXtlW3RdPXI+PjgmMjU1O2VbdCsxXT0yNTUmcn1mdW5jdGlvbiB3cml0ZUludDMyKGUsdCxyKXtlW3RdPXI+PjI0JjI1NTtlW3QrMV09cj4+MTYmMjU1O2VbdCsyXT1yPj44JjI1NTtlW3QrM109MjU1JnJ9ZnVuY3Rpb24gd3JpdGVEYXRhKGUsdCxyKXtpZihyIGluc3RhbmNlb2YgVWludDhBcnJheSllLnNldChyLHQpO2Vsc2UgaWYoInN0cmluZyI9PXR5cGVvZiByKWZvcihsZXQgYT0wLG49ci5sZW5ndGg7YTxuO2ErKyllW3QrK109MjU1JnIuY2hhckNvZGVBdChhKTtlbHNlIGZvcihjb25zdCBhIG9mIHIpZVt0KytdPTI1NSZhfWNsYXNzIE9wZW5UeXBlRmlsZUJ1aWxkZXJ7Y29uc3RydWN0b3IoZSl7dGhpcy5zZm50PWU7dGhpcy50YWJsZXM9T2JqZWN0LmNyZWF0ZShudWxsKX1zdGF0aWMgZ2V0U2VhcmNoUGFyYW1zKGUsdCl7bGV0IHI9MSxhPTA7Zm9yKDsocl5lKT5yOyl7cjw8PTE7YSsrfWNvbnN0IG49cip0O3JldHVybntyYW5nZTpuLGVudHJ5OmEscmFuZ2VTaGlmdDp0KmUtbn19dG9BcnJheSgpe2xldCBlPXRoaXMuc2ZudDtjb25zdCB0PXRoaXMudGFibGVzLHI9T2JqZWN0LmtleXModCk7ci5zb3J0KCk7Y29uc3QgYT1yLmxlbmd0aDtsZXQgbixpLHMsbyxjLGw9MTIrMTYqYTtjb25zdCBoPVtsXTtmb3Iobj0wO248YTtuKyspe289dFtyW25dXTtsKz0oby5sZW5ndGgrMyYtNCk+Pj4wO2gucHVzaChsKX1jb25zdCB1PW5ldyBVaW50OEFycmF5KGwpO2ZvcihuPTA7bjxhO24rKyl7bz10W3Jbbl1dO3dyaXRlRGF0YSh1LGhbbl0sbyl9InRydWUiPT09ZSYmKGU9c3RyaW5nMzIoNjU1MzYpKTt1WzBdPTI1NSZlLmNoYXJDb2RlQXQoMCk7dVsxXT0yNTUmZS5jaGFyQ29kZUF0KDEpO3VbMl09MjU1JmUuY2hhckNvZGVBdCgyKTt1WzNdPTI1NSZlLmNoYXJDb2RlQXQoMyk7d3JpdGVJbnQxNih1LDQsYSk7Y29uc3QgZD1PcGVuVHlwZUZpbGVCdWlsZGVyLmdldFNlYXJjaFBhcmFtcyhhLDE2KTt3cml0ZUludDE2KHUsNixkLnJhbmdlKTt3cml0ZUludDE2KHUsOCxkLmVudHJ5KTt3cml0ZUludDE2KHUsMTAsZC5yYW5nZVNoaWZ0KTtsPTEyO2ZvcihuPTA7bjxhO24rKyl7Yz1yW25dO3VbbF09MjU1JmMuY2hhckNvZGVBdCgwKTt1W2wrMV09MjU1JmMuY2hhckNvZGVBdCgxKTt1W2wrMl09MjU1JmMuY2hhckNvZGVBdCgyKTt1W2wrM109MjU1JmMuY2hhckNvZGVBdCgzKTtsZXQgZT0wO2ZvcihpPWhbbl0scz1oW24rMV07aTxzO2krPTQpe2U9ZStyZWFkVWludDMyKHUsaSk+Pj4wfXdyaXRlSW50MzIodSxsKzQsZSk7d3JpdGVJbnQzMih1LGwrOCxoW25dKTt3cml0ZUludDMyKHUsbCsxMix0W2NdLmxlbmd0aCk7bCs9MTZ9cmV0dXJuIHV9YWRkVGFibGUoZSx0KXtpZihlIGluIHRoaXMudGFibGVzKXRocm93IG5ldyBFcnJvcigiVGFibGUgIitlKyIgYWxyZWFkeSBleGlzdHMiKTt0aGlzLnRhYmxlc1tlXT10fX1jb25zdCAkYT1bNF0sVmE9WzVdLEthPVs2XSxKYT1bN10sWWE9WzhdLFphPVsxMiwzNV0sUWE9WzE0XSxlbj1bMjFdLHRuPVsyMl0scm49WzMwXSxhbj1bMzFdO2NsYXNzIFR5cGUxQ2hhclN0cmluZ3tjb25zdHJ1Y3Rvcigpe3RoaXMud2lkdGg9MDt0aGlzLmxzYj0wO3RoaXMuZmxleGluZz0hMTt0aGlzLm91dHB1dD1bXTt0aGlzLnN0YWNrPVtdfWNvbnZlcnQoZSx0LHIpe2NvbnN0IGE9ZS5sZW5ndGg7bGV0IG4saSxzLG89ITE7Zm9yKGxldCBjPTA7YzxhO2MrKyl7bGV0IGE9ZVtjXTtpZihhPDMyKXsxMj09PWEmJihhPShhPDw4KStlWysrY10pO3N3aXRjaChhKXtjYXNlIDE6Y2FzZSAzOmNhc2UgOTpjYXNlIDMwNzI6Y2FzZSAzMDczOmNhc2UgMzA3NDpjYXNlIDMxMDU6dGhpcy5zdGFjaz1bXTticmVhaztjYXNlIDQ6aWYodGhpcy5mbGV4aW5nKXtpZih0aGlzLnN0YWNrLmxlbmd0aDwxKXtvPSEwO2JyZWFrfWNvbnN0IGU9dGhpcy5zdGFjay5wb3AoKTt0aGlzLnN0YWNrLnB1c2goMCxlKTticmVha31vPXRoaXMuZXhlY3V0ZUNvbW1hbmQoMSwkYSk7YnJlYWs7Y2FzZSA1Om89dGhpcy5leGVjdXRlQ29tbWFuZCgyLFZhKTticmVhaztjYXNlIDY6bz10aGlzLmV4ZWN1dGVDb21tYW5kKDEsS2EpO2JyZWFrO2Nhc2UgNzpvPXRoaXMuZXhlY3V0ZUNvbW1hbmQoMSxKYSk7YnJlYWs7Y2FzZSA4Om89dGhpcy5leGVjdXRlQ29tbWFuZCg2LFlhKTticmVhaztjYXNlIDEwOmlmKHRoaXMuc3RhY2subGVuZ3RoPDEpe289ITA7YnJlYWt9cz10aGlzLnN0YWNrLnBvcCgpO2lmKCF0W3NdKXtvPSEwO2JyZWFrfW89dGhpcy5jb252ZXJ0KHRbc10sdCxyKTticmVhaztjYXNlIDExOnJldHVybiBvO2Nhc2UgMTM6aWYodGhpcy5zdGFjay5sZW5ndGg8Mil7bz0hMDticmVha31uPXRoaXMuc3RhY2sucG9wKCk7aT10aGlzLnN0YWNrLnBvcCgpO3RoaXMubHNiPWk7dGhpcy53aWR0aD1uO3RoaXMuc3RhY2sucHVzaChuLGkpO289dGhpcy5leGVjdXRlQ29tbWFuZCgyLHRuKTticmVhaztjYXNlIDE0OnRoaXMub3V0cHV0LnB1c2goUWFbMF0pO2JyZWFrO2Nhc2UgMjE6aWYodGhpcy5mbGV4aW5nKWJyZWFrO289dGhpcy5leGVjdXRlQ29tbWFuZCgyLGVuKTticmVhaztjYXNlIDIyOmlmKHRoaXMuZmxleGluZyl7dGhpcy5zdGFjay5wdXNoKDApO2JyZWFrfW89dGhpcy5leGVjdXRlQ29tbWFuZCgxLHRuKTticmVhaztjYXNlIDMwOm89dGhpcy5leGVjdXRlQ29tbWFuZCg0LHJuKTticmVhaztjYXNlIDMxOm89dGhpcy5leGVjdXRlQ29tbWFuZCg0LGFuKTticmVhaztjYXNlIDMwNzg6aWYocil7Y29uc3QgZT10aGlzLnN0YWNrLmF0KC01KTt0aGlzLnNlYWM9dGhpcy5zdGFjay5zcGxpY2UoLTQsNCk7dGhpcy5zZWFjWzBdKz10aGlzLmxzYi1lO289dGhpcy5leGVjdXRlQ29tbWFuZCgwLFFhKX1lbHNlIG89dGhpcy5leGVjdXRlQ29tbWFuZCg0LFFhKTticmVhaztjYXNlIDMwNzk6aWYodGhpcy5zdGFjay5sZW5ndGg8NCl7bz0hMDticmVha310aGlzLnN0YWNrLnBvcCgpO249dGhpcy5zdGFjay5wb3AoKTtjb25zdCBlPXRoaXMuc3RhY2sucG9wKCk7aT10aGlzLnN0YWNrLnBvcCgpO3RoaXMubHNiPWk7dGhpcy53aWR0aD1uO3RoaXMuc3RhY2sucHVzaChuLGksZSk7bz10aGlzLmV4ZWN1dGVDb21tYW5kKDMsZW4pO2JyZWFrO2Nhc2UgMzA4NDppZih0aGlzLnN0YWNrLmxlbmd0aDwyKXtvPSEwO2JyZWFrfWNvbnN0IGM9dGhpcy5zdGFjay5wb3AoKSxsPXRoaXMuc3RhY2sucG9wKCk7dGhpcy5zdGFjay5wdXNoKGwvYyk7YnJlYWs7Y2FzZSAzMDg4OmlmKHRoaXMuc3RhY2subGVuZ3RoPDIpe289ITA7YnJlYWt9cz10aGlzLnN0YWNrLnBvcCgpO2NvbnN0IGg9dGhpcy5zdGFjay5wb3AoKTtpZigwPT09cyYmMz09PWgpe2NvbnN0IGU9dGhpcy5zdGFjay5zcGxpY2UoLTE3LDE3KTt0aGlzLnN0YWNrLnB1c2goZVsyXStlWzBdLGVbM10rZVsxXSxlWzRdLGVbNV0sZVs2XSxlWzddLGVbOF0sZVs5XSxlWzEwXSxlWzExXSxlWzEyXSxlWzEzXSxlWzE0XSk7bz10aGlzLmV4ZWN1dGVDb21tYW5kKDEzLFphLCEwKTt0aGlzLmZsZXhpbmc9ITE7dGhpcy5zdGFjay5wdXNoKGVbMTVdLGVbMTZdKX1lbHNlIDE9PT1zJiYwPT09aCYmKHRoaXMuZmxleGluZz0hMCk7YnJlYWs7Y2FzZSAzMDg5OmJyZWFrO2RlZmF1bHQ6d2FybignVW5rbm93biB0eXBlIDEgY2hhcnN0cmluZyBjb21tYW5kIG9mICInK2ErJyInKX1pZihvKWJyZWFrfWVsc2V7YTw9MjQ2P2EtPTEzOTphPWE8PTI1MD8yNTYqKGEtMjQ3KStlWysrY10rMTA4OmE8PTI1ND8tMjU2KihhLTI1MSktZVsrK2NdLTEwODooMjU1JmVbKytjXSk8PDI0fCgyNTUmZVsrK2NdKTw8MTZ8KDI1NSZlWysrY10pPDw4fDI1NSZlWysrY107dGhpcy5zdGFjay5wdXNoKGEpfX1yZXR1cm4gb31leGVjdXRlQ29tbWFuZChlLHQscil7Y29uc3QgYT10aGlzLnN0YWNrLmxlbmd0aDtpZihlPmEpcmV0dXJuITA7Y29uc3Qgbj1hLWU7Zm9yKGxldCBlPW47ZTxhO2UrKyl7bGV0IHQ9dGhpcy5zdGFja1tlXTtpZihOdW1iZXIuaXNJbnRlZ2VyKHQpKXRoaXMub3V0cHV0LnB1c2goMjgsdD4+OCYyNTUsMjU1JnQpO2Vsc2V7dD02NTUzNip0fDA7dGhpcy5vdXRwdXQucHVzaCgyNTUsdD4+MjQmMjU1LHQ+PjE2JjI1NSx0Pj44JjI1NSwyNTUmdCl9fXRoaXMub3V0cHV0LnB1c2goLi4udCk7cj90aGlzLnN0YWNrLnNwbGljZShuLGUpOnRoaXMuc3RhY2subGVuZ3RoPTA7cmV0dXJuITF9fWZ1bmN0aW9uIGlzSGV4RGlnaXQoZSl7cmV0dXJuIGU+PTQ4JiZlPD01N3x8ZT49NjUmJmU8PTcwfHxlPj05NyYmZTw9MTAyfWZ1bmN0aW9uIGRlY3J5cHQoZSx0LHIpe2lmKHI+PWUubGVuZ3RoKXJldHVybiBuZXcgVWludDhBcnJheSgwKTtsZXQgYSxuLGk9MHx0O2ZvcihhPTA7YTxyO2ErKylpPTUyODQ1KihlW2FdK2kpKzIyNzE5JjY1NTM1O2NvbnN0IHM9ZS5sZW5ndGgtcixvPW5ldyBVaW50OEFycmF5KHMpO2ZvcihhPXIsbj0wO248czthKyssbisrKXtjb25zdCB0PWVbYV07b1tuXT10Xmk+Pjg7aT01Mjg0NSoodCtpKSsyMjcxOSY2NTUzNX1yZXR1cm4gb31mdW5jdGlvbiBpc1NwZWNpYWwoZSl7cmV0dXJuIDQ3PT09ZXx8OTE9PT1lfHw5Mz09PWV8fDEyMz09PWV8fDEyNT09PWV8fDQwPT09ZXx8NDE9PT1lfWNsYXNzIFR5cGUxUGFyc2Vye2NvbnN0cnVjdG9yKGUsdCxyKXtpZih0KXtjb25zdCB0PWUuZ2V0Qnl0ZXMoKSxyPSEoKGlzSGV4RGlnaXQodFswXSl8fGlzV2hpdGVTcGFjZSh0WzBdKSkmJmlzSGV4RGlnaXQodFsxXSkmJmlzSGV4RGlnaXQodFsyXSkmJmlzSGV4RGlnaXQodFszXSkmJmlzSGV4RGlnaXQodFs0XSkmJmlzSGV4RGlnaXQodFs1XSkmJmlzSGV4RGlnaXQodFs2XSkmJmlzSGV4RGlnaXQodFs3XSkpO2U9bmV3IFN0cmVhbShyP2RlY3J5cHQodCw1NTY2NSw0KTpmdW5jdGlvbiBkZWNyeXB0QXNjaWkoZSx0LHIpe2xldCBhPTB8dDtjb25zdCBuPWUubGVuZ3RoLGk9bmV3IFVpbnQ4QXJyYXkobj4+PjEpO2xldCBzLG87Zm9yKHM9MCxvPTA7czxuO3MrKyl7Y29uc3QgdD1lW3NdO2lmKCFpc0hleERpZ2l0KHQpKWNvbnRpbnVlO3MrKztsZXQgcjtmb3IoO3M8biYmIWlzSGV4RGlnaXQocj1lW3NdKTspcysrO2lmKHM8bil7Y29uc3QgZT1wYXJzZUludChTdHJpbmcuZnJvbUNoYXJDb2RlKHQsciksMTYpO2lbbysrXT1lXmE+Pjg7YT01Mjg0NSooZSthKSsyMjcxOSY2NTUzNX19cmV0dXJuIGkuc2xpY2UocixvKX0odCw1NTY2NSw0KSl9dGhpcy5zZWFjQW5hbHlzaXNFbmFibGVkPSEhcjt0aGlzLnN0cmVhbT1lO3RoaXMubmV4dENoYXIoKX1yZWFkTnVtYmVyQXJyYXkoKXt0aGlzLmdldFRva2VuKCk7Y29uc3QgZT1bXTtmb3IoOzspe2NvbnN0IHQ9dGhpcy5nZXRUb2tlbigpO2lmKG51bGw9PT10fHwiXSI9PT10fHwifSI9PT10KWJyZWFrO2UucHVzaChwYXJzZUZsb2F0KHR8fDApKX1yZXR1cm4gZX1yZWFkTnVtYmVyKCl7Y29uc3QgZT10aGlzLmdldFRva2VuKCk7cmV0dXJuIHBhcnNlRmxvYXQoZXx8MCl9cmVhZEludCgpe2NvbnN0IGU9dGhpcy5nZXRUb2tlbigpO3JldHVybiAwfHBhcnNlSW50KGV8fDAsMTApfXJlYWRCb29sZWFuKCl7cmV0dXJuInRydWUiPT09dGhpcy5nZXRUb2tlbigpPzE6MH1uZXh0Q2hhcigpe3JldHVybiB0aGlzLmN1cnJlbnRDaGFyPXRoaXMuc3RyZWFtLmdldEJ5dGUoKX1wcmV2Q2hhcigpe3RoaXMuc3RyZWFtLnNraXAoLTIpO3JldHVybiB0aGlzLmN1cnJlbnRDaGFyPXRoaXMuc3RyZWFtLmdldEJ5dGUoKX1nZXRUb2tlbigpe2xldCBlPSExLHQ9dGhpcy5jdXJyZW50Q2hhcjtmb3IoOzspe2lmKC0xPT09dClyZXR1cm4gbnVsbDtpZihlKTEwIT09dCYmMTMhPT10fHwoZT0hMSk7ZWxzZSBpZigzNz09PXQpZT0hMDtlbHNlIGlmKCFpc1doaXRlU3BhY2UodCkpYnJlYWs7dD10aGlzLm5leHRDaGFyKCl9aWYoaXNTcGVjaWFsKHQpKXt0aGlzLm5leHRDaGFyKCk7cmV0dXJuIFN0cmluZy5mcm9tQ2hhckNvZGUodCl9bGV0IHI9IiI7ZG97cis9U3RyaW5nLmZyb21DaGFyQ29kZSh0KTt0PXRoaXMubmV4dENoYXIoKX13aGlsZSh0Pj0wJiYhaXNXaGl0ZVNwYWNlKHQpJiYhaXNTcGVjaWFsKHQpKTtyZXR1cm4gcn1yZWFkQ2hhclN0cmluZ3MoZSx0KXtyZXR1cm4tMT09PXQ/ZTpkZWNyeXB0KGUsNDMzMCx0KX1leHRyYWN0Rm9udFByb2dyYW0oZSl7Y29uc3QgdD10aGlzLnN0cmVhbSxyPVtdLGE9W10sbj1PYmplY3QuY3JlYXRlKG51bGwpO24ubGVuSVY9NDtjb25zdCBpPXtzdWJyczpbXSxjaGFyc3RyaW5nczpbXSxwcm9wZXJ0aWVzOntwcml2YXRlRGF0YTpufX07bGV0IHMsbyxjLGw7Zm9yKDtudWxsIT09KHM9dGhpcy5nZXRUb2tlbigpKTspaWYoIi8iPT09cyl7cz10aGlzLmdldFRva2VuKCk7c3dpdGNoKHMpe2Nhc2UiQ2hhclN0cmluZ3MiOnRoaXMuZ2V0VG9rZW4oKTt0aGlzLmdldFRva2VuKCk7dGhpcy5nZXRUb2tlbigpO3RoaXMuZ2V0VG9rZW4oKTtmb3IoOzspe3M9dGhpcy5nZXRUb2tlbigpO2lmKG51bGw9PT1zfHwiZW5kIj09PXMpYnJlYWs7aWYoIi8iIT09cyljb250aW51ZTtjb25zdCBlPXRoaXMuZ2V0VG9rZW4oKTtvPXRoaXMucmVhZEludCgpO3RoaXMuZ2V0VG9rZW4oKTtjPW8+MD90LmdldEJ5dGVzKG8pOm5ldyBVaW50OEFycmF5KDApO2w9aS5wcm9wZXJ0aWVzLnByaXZhdGVEYXRhLmxlbklWO2NvbnN0IHI9dGhpcy5yZWFkQ2hhclN0cmluZ3MoYyxsKTt0aGlzLm5leHRDaGFyKCk7cz10aGlzLmdldFRva2VuKCk7Im5vYWNjZXNzIj09PXM/dGhpcy5nZXRUb2tlbigpOiIvIj09PXMmJnRoaXMucHJldkNoYXIoKTthLnB1c2goe2dseXBoOmUsZW5jb2RlZDpyfSl9YnJlYWs7Y2FzZSJTdWJycyI6dGhpcy5yZWFkSW50KCk7dGhpcy5nZXRUb2tlbigpO2Zvcig7ImR1cCI9PT10aGlzLmdldFRva2VuKCk7KXtjb25zdCBlPXRoaXMucmVhZEludCgpO289dGhpcy5yZWFkSW50KCk7dGhpcy5nZXRUb2tlbigpO2M9bz4wP3QuZ2V0Qnl0ZXMobyk6bmV3IFVpbnQ4QXJyYXkoMCk7bD1pLnByb3BlcnRpZXMucHJpdmF0ZURhdGEubGVuSVY7Y29uc3QgYT10aGlzLnJlYWRDaGFyU3RyaW5ncyhjLGwpO3RoaXMubmV4dENoYXIoKTtzPXRoaXMuZ2V0VG9rZW4oKTsibm9hY2Nlc3MiPT09cyYmdGhpcy5nZXRUb2tlbigpO3JbZV09YX1icmVhaztjYXNlIkJsdWVWYWx1ZXMiOmNhc2UiT3RoZXJCbHVlcyI6Y2FzZSJGYW1pbHlCbHVlcyI6Y2FzZSJGYW1pbHlPdGhlckJsdWVzIjpjb25zdCBlPXRoaXMucmVhZE51bWJlckFycmF5KCk7ZS5sZW5ndGg+MCYmZS5sZW5ndGgsMDticmVhaztjYXNlIlN0ZW1TbmFwSCI6Y2FzZSJTdGVtU25hcFYiOmkucHJvcGVydGllcy5wcml2YXRlRGF0YVtzXT10aGlzLnJlYWROdW1iZXJBcnJheSgpO2JyZWFrO2Nhc2UiU3RkSFciOmNhc2UiU3RkVlciOmkucHJvcGVydGllcy5wcml2YXRlRGF0YVtzXT10aGlzLnJlYWROdW1iZXJBcnJheSgpWzBdO2JyZWFrO2Nhc2UiQmx1ZVNoaWZ0IjpjYXNlImxlbklWIjpjYXNlIkJsdWVGdXp6IjpjYXNlIkJsdWVTY2FsZSI6Y2FzZSJMYW5ndWFnZUdyb3VwIjppLnByb3BlcnRpZXMucHJpdmF0ZURhdGFbc109dGhpcy5yZWFkTnVtYmVyKCk7YnJlYWs7Y2FzZSJFeHBhbnNpb25GYWN0b3IiOmkucHJvcGVydGllcy5wcml2YXRlRGF0YVtzXT10aGlzLnJlYWROdW1iZXIoKXx8LjA2O2JyZWFrO2Nhc2UiRm9yY2VCb2xkIjppLnByb3BlcnRpZXMucHJpdmF0ZURhdGFbc109dGhpcy5yZWFkQm9vbGVhbigpfX1mb3IoY29uc3R7ZW5jb2RlZDp0LGdseXBoOm59b2YgYSl7Y29uc3QgYT1uZXcgVHlwZTFDaGFyU3RyaW5nLHM9YS5jb252ZXJ0KHQscix0aGlzLnNlYWNBbmFseXNpc0VuYWJsZWQpO2xldCBvPWEub3V0cHV0O3MmJihvPVsxNF0pO2NvbnN0IGM9e2dseXBoTmFtZTpuLGNoYXJzdHJpbmc6byx3aWR0aDphLndpZHRoLGxzYjphLmxzYixzZWFjOmEuc2VhY307Ii5ub3RkZWYiPT09bj9pLmNoYXJzdHJpbmdzLnVuc2hpZnQoYyk6aS5jaGFyc3RyaW5ncy5wdXNoKGMpO2lmKGUuYnVpbHRJbkVuY29kaW5nKXtjb25zdCB0PWUuYnVpbHRJbkVuY29kaW5nLmluZGV4T2Yobik7dD4tMSYmdm9pZCAwPT09ZS53aWR0aHNbdF0mJnQ+PWUuZmlyc3RDaGFyJiZ0PD1lLmxhc3RDaGFyJiYoZS53aWR0aHNbdF09YS53aWR0aCl9fXJldHVybiBpfWV4dHJhY3RGb250SGVhZGVyKGUpe2xldCB0O2Zvcig7bnVsbCE9PSh0PXRoaXMuZ2V0VG9rZW4oKSk7KWlmKCIvIj09PXQpe3Q9dGhpcy5nZXRUb2tlbigpO3N3aXRjaCh0KXtjYXNlIkZvbnRNYXRyaXgiOmNvbnN0IHI9dGhpcy5yZWFkTnVtYmVyQXJyYXkoKTtlLmZvbnRNYXRyaXg9cjticmVhaztjYXNlIkVuY29kaW5nIjpjb25zdCBhPXRoaXMuZ2V0VG9rZW4oKTtsZXQgbjtpZigvXlxkKyQvLnRlc3QoYSkpe249W107Y29uc3QgZT0wfHBhcnNlSW50KGEsMTApO3RoaXMuZ2V0VG9rZW4oKTtmb3IobGV0IHI9MDtyPGU7cisrKXt0PXRoaXMuZ2V0VG9rZW4oKTtmb3IoOyJkdXAiIT09dCYmImRlZiIhPT10Oyl7dD10aGlzLmdldFRva2VuKCk7aWYobnVsbD09PXQpcmV0dXJufWlmKCJkZWYiPT09dClicmVhaztjb25zdCBlPXRoaXMucmVhZEludCgpO3RoaXMuZ2V0VG9rZW4oKTtjb25zdCByPXRoaXMuZ2V0VG9rZW4oKTtuW2VdPXI7dGhpcy5nZXRUb2tlbigpfX1lbHNlIG49Z2V0RW5jb2RpbmcoYSk7ZS5idWlsdEluRW5jb2Rpbmc9bjticmVhaztjYXNlIkZvbnRCQm94Ijpjb25zdCBpPXRoaXMucmVhZE51bWJlckFycmF5KCk7ZS5hc2NlbnQ9TWF0aC5tYXgoaVszXSxpWzFdKTtlLmRlc2NlbnQ9TWF0aC5taW4oaVsxXSxpWzNdKTtlLmFzY2VudFNjYWxlZD0hMH19fX1mdW5jdGlvbiBmaW5kQmxvY2soZSx0LHIpe2NvbnN0IGE9ZS5sZW5ndGgsbj10Lmxlbmd0aCxpPWEtbjtsZXQgcz1yLG89ITE7Zm9yKDtzPGk7KXtsZXQgcj0wO2Zvcig7cjxuJiZlW3Mrcl09PT10W3JdOylyKys7aWYocj49bil7cys9cjtmb3IoO3M8YSYmaXNXaGl0ZVNwYWNlKGVbc10pOylzKys7bz0hMDticmVha31zKyt9cmV0dXJue2ZvdW5kOm8sbGVuZ3RoOnN9fWNsYXNzIFR5cGUxRm9udHtjb25zdHJ1Y3RvcihlLHQscil7bGV0IGE9ci5sZW5ndGgxLG49ci5sZW5ndGgyLGk9dC5wZWVrQnl0ZXMoNik7Y29uc3Qgcz0xMjg9PT1pWzBdJiYxPT09aVsxXTtpZihzKXt0LnNraXAoNik7YT1pWzVdPDwyNHxpWzRdPDwxNnxpWzNdPDw4fGlbMl19Y29uc3Qgbz1mdW5jdGlvbiBnZXRIZWFkZXJCbG9jayhlLHQpe2NvbnN0IHI9WzEwMSwxMDEsMTIwLDEwMSw5OV0sYT1lLnBvcztsZXQgbixpLHMsbzt0cnl7bj1lLmdldEJ5dGVzKHQpO2k9bi5sZW5ndGh9Y2F0Y2h7fWlmKGk9PT10KXtzPWZpbmRCbG9jayhuLHIsdC0yKnIubGVuZ3RoKTtpZihzLmZvdW5kJiZzLmxlbmd0aD09PXQpcmV0dXJue3N0cmVhbTpuZXcgU3RyZWFtKG4pLGxlbmd0aDp0fX13YXJuKCdJbnZhbGlkICJMZW5ndGgxIiBwcm9wZXJ0eSBpbiBUeXBlMSBmb250IC0tIHRyeWluZyB0byByZWNvdmVyLicpO2UucG9zPWE7Zm9yKDs7KXtzPWZpbmRCbG9jayhlLnBlZWtCeXRlcygyMDQ4KSxyLDApO2lmKDA9PT1zLmxlbmd0aClicmVhaztlLnBvcys9cy5sZW5ndGg7aWYocy5mb3VuZCl7bz1lLnBvcy1hO2JyZWFrfX1lLnBvcz1hO2lmKG8pcmV0dXJue3N0cmVhbTpuZXcgU3RyZWFtKGUuZ2V0Qnl0ZXMobykpLGxlbmd0aDpvfTt3YXJuKCdVbmFibGUgdG8gcmVjb3ZlciAiTGVuZ3RoMSIgcHJvcGVydHkgaW4gVHlwZTEgZm9udCAtLSB1c2luZyBhcyBpcy4nKTtyZXR1cm57c3RyZWFtOm5ldyBTdHJlYW0oZS5nZXRCeXRlcyh0KSksbGVuZ3RoOnR9fSh0LGEpO25ldyBUeXBlMVBhcnNlcihvLnN0cmVhbSwhMSx4YSkuZXh0cmFjdEZvbnRIZWFkZXIocik7aWYocyl7aT10LmdldEJ5dGVzKDYpO249aVs1XTw8MjR8aVs0XTw8MTZ8aVszXTw8OHxpWzJdfWNvbnN0IGM9ZnVuY3Rpb24gZ2V0RWV4ZWNCbG9jayhlLHQpe2NvbnN0IHI9ZS5nZXRCeXRlcygpO2lmKDA9PT1yLmxlbmd0aCl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoImdldEVleGVjQmxvY2sgLSBubyBmb250IHByb2dyYW0gZm91bmQuIik7cmV0dXJue3N0cmVhbTpuZXcgU3RyZWFtKHIpLGxlbmd0aDpyLmxlbmd0aH19KHQpLGw9bmV3IFR5cGUxUGFyc2VyKGMuc3RyZWFtLCEwLHhhKS5leHRyYWN0Rm9udFByb2dyYW0ocik7Zm9yKGNvbnN0IGUgaW4gbC5wcm9wZXJ0aWVzKXJbZV09bC5wcm9wZXJ0aWVzW2VdO2NvbnN0IGg9bC5jaGFyc3RyaW5ncyx1PXRoaXMuZ2V0VHlwZTJDaGFyc3RyaW5ncyhoKSxkPXRoaXMuZ2V0VHlwZTJTdWJycyhsLnN1YnJzKTt0aGlzLmNoYXJzdHJpbmdzPWg7dGhpcy5kYXRhPXRoaXMud3JhcChlLHUsdGhpcy5jaGFyc3RyaW5ncyxkLHIpO3RoaXMuc2VhY3M9dGhpcy5nZXRTZWFjcyhsLmNoYXJzdHJpbmdzKX1nZXQgbnVtR2x5cGhzKCl7cmV0dXJuIHRoaXMuY2hhcnN0cmluZ3MubGVuZ3RoKzF9Z2V0Q2hhcnNldCgpe2NvbnN0IGU9WyIubm90ZGVmIl07Zm9yKGNvbnN0e2dseXBoTmFtZTp0fW9mIHRoaXMuY2hhcnN0cmluZ3MpZS5wdXNoKHQpO3JldHVybiBlfWdldEdseXBoTWFwcGluZyhlKXtjb25zdCB0PXRoaXMuY2hhcnN0cmluZ3M7aWYoZS5jb21wb3NpdGUpe2NvbnN0IHI9T2JqZWN0LmNyZWF0ZShudWxsKTtmb3IobGV0IGE9MCxuPXQubGVuZ3RoO2E8bjthKyspe3JbZS5jTWFwLmNoYXJDb2RlT2YoYSldPWErMX1yZXR1cm4gcn1jb25zdCByPVsiLm5vdGRlZiJdO2xldCBhLG47Zm9yKG49MDtuPHQubGVuZ3RoO24rKylyLnB1c2godFtuXS5nbHlwaE5hbWUpO2NvbnN0IGk9ZS5idWlsdEluRW5jb2Rpbmc7aWYoaSl7YT1PYmplY3QuY3JlYXRlKG51bGwpO2Zvcihjb25zdCBlIGluIGkpe249ci5pbmRleE9mKGlbZV0pO24+PTAmJihhW2VdPW4pfX1yZXR1cm4gdHlwZTFGb250R2x5cGhNYXBwaW5nKGUsYSxyKX1oYXNHbHlwaElkKGUpe2lmKGU8MHx8ZT49dGhpcy5udW1HbHlwaHMpcmV0dXJuITE7aWYoMD09PWUpcmV0dXJuITA7cmV0dXJuIHRoaXMuY2hhcnN0cmluZ3NbZS0xXS5jaGFyc3RyaW5nLmxlbmd0aD4wfWdldFNlYWNzKGUpe2NvbnN0IHQ9W107Zm9yKGxldCByPTAsYT1lLmxlbmd0aDtyPGE7cisrKXtjb25zdCBhPWVbcl07YS5zZWFjJiYodFtyKzFdPWEuc2VhYyl9cmV0dXJuIHR9Z2V0VHlwZTJDaGFyc3RyaW5ncyhlKXtjb25zdCB0PVtdO2Zvcihjb25zdCByIG9mIGUpdC5wdXNoKHIuY2hhcnN0cmluZyk7cmV0dXJuIHR9Z2V0VHlwZTJTdWJycyhlKXtsZXQgdD0wO2NvbnN0IHI9ZS5sZW5ndGg7dD1yPDExMzM/MTA3OnI8MzM3Njk/MTEzMTozMjc2ODtjb25zdCBhPVtdO2xldCBuO2ZvcihuPTA7bjx0O24rKylhLnB1c2goWzExXSk7Zm9yKG49MDtuPHI7bisrKWEucHVzaChlW25dKTtyZXR1cm4gYX13cmFwKGUsdCxyLGEsbil7Y29uc3QgaT1uZXcgQ0ZGO2kuaGVhZGVyPW5ldyBDRkZIZWFkZXIoMSwwLDQsNCk7aS5uYW1lcz1bZV07Y29uc3Qgcz1uZXcgQ0ZGVG9wRGljdDtzLnNldEJ5TmFtZSgidmVyc2lvbiIsMzkxKTtzLnNldEJ5TmFtZSgiTm90aWNlIiwzOTIpO3Muc2V0QnlOYW1lKCJGdWxsTmFtZSIsMzkzKTtzLnNldEJ5TmFtZSgiRmFtaWx5TmFtZSIsMzk0KTtzLnNldEJ5TmFtZSgiV2VpZ2h0IiwzOTUpO3Muc2V0QnlOYW1lKCJFbmNvZGluZyIsbnVsbCk7cy5zZXRCeU5hbWUoIkZvbnRNYXRyaXgiLG4uZm9udE1hdHJpeCk7cy5zZXRCeU5hbWUoIkZvbnRCQm94IixuLmJib3gpO3Muc2V0QnlOYW1lKCJjaGFyc2V0IixudWxsKTtzLnNldEJ5TmFtZSgiQ2hhclN0cmluZ3MiLG51bGwpO3Muc2V0QnlOYW1lKCJQcml2YXRlIixudWxsKTtpLnRvcERpY3Q9cztjb25zdCBvPW5ldyBDRkZTdHJpbmdzO28uYWRkKCJWZXJzaW9uIDAuMTEiKTtvLmFkZCgiU2VlIG9yaWdpbmFsIG5vdGljZSIpO28uYWRkKGUpO28uYWRkKGUpO28uYWRkKCJNZWRpdW0iKTtpLnN0cmluZ3M9bztpLmdsb2JhbFN1YnJJbmRleD1uZXcgQ0ZGSW5kZXg7Y29uc3QgYz10Lmxlbmd0aCxsPVsiLm5vdGRlZiJdO2xldCBoLHU7Zm9yKGg9MDtoPGM7aCsrKXtjb25zdCBlPXJbaF0uZ2x5cGhOYW1lOy0xPT09TWEuaW5kZXhPZihlKSYmby5hZGQoZSk7bC5wdXNoKGUpfWkuY2hhcnNldD1uZXcgQ0ZGQ2hhcnNldCghMSwwLGwpO2NvbnN0IGQ9bmV3IENGRkluZGV4O2QuYWRkKFsxMzksMTRdKTtmb3IoaD0wO2g8YztoKyspZC5hZGQodFtoXSk7aS5jaGFyU3RyaW5ncz1kO2NvbnN0IGY9bmV3IENGRlByaXZhdGVEaWN0O2Yuc2V0QnlOYW1lKCJTdWJycyIsbnVsbCk7Y29uc3QgZz1bIkJsdWVWYWx1ZXMiLCJPdGhlckJsdWVzIiwiRmFtaWx5Qmx1ZXMiLCJGYW1pbHlPdGhlckJsdWVzIiwiU3RlbVNuYXBIIiwiU3RlbVNuYXBWIiwiQmx1ZVNoaWZ0IiwiQmx1ZUZ1enoiLCJCbHVlU2NhbGUiLCJMYW5ndWFnZUdyb3VwIiwiRXhwYW5zaW9uRmFjdG9yIiwiRm9yY2VCb2xkIiwiU3RkSFciLCJTdGRWVyJdO2ZvcihoPTAsdT1nLmxlbmd0aDtoPHU7aCsrKXtjb25zdCBlPWdbaF07aWYoIShlIGluIG4ucHJpdmF0ZURhdGEpKWNvbnRpbnVlO2NvbnN0IHQ9bi5wcml2YXRlRGF0YVtlXTtpZihBcnJheS5pc0FycmF5KHQpKWZvcihsZXQgZT10Lmxlbmd0aC0xO2U+MDtlLS0pdFtlXS09dFtlLTFdO2Yuc2V0QnlOYW1lKGUsdCl9aS50b3BEaWN0LnByaXZhdGVEaWN0PWY7Y29uc3QgcD1uZXcgQ0ZGSW5kZXg7Zm9yKGg9MCx1PWEubGVuZ3RoO2g8dTtoKyspcC5hZGQoYVtoXSk7Zi5zdWJyc0luZGV4PXA7cmV0dXJuIG5ldyBDRkZDb21waWxlcihpKS5jb21waWxlKCl9fWNvbnN0IG5uPVtbNTczNDQsNjM3NDNdLFsxMDQ4NTc2LDExMTQxMDldXSxzbj0xZTMsb249WyJhc2NlbnQiLCJiYm94IiwiYmxhY2siLCJib2xkIiwiY2hhclByb2NPcGVyYXRvckxpc3QiLCJjc3NGb250SW5mbyIsImRhdGEiLCJkZWZhdWx0Vk1ldHJpY3MiLCJkZWZhdWx0V2lkdGgiLCJkZXNjZW50IiwiZGlzYWJsZUZvbnRGYWNlIiwiZmFsbGJhY2tOYW1lIiwiZm9udEV4dHJhUHJvcGVydGllcyIsImZvbnRNYXRyaXgiLCJpc0ludmFsaWRQREZqc0ZvbnQiLCJpc1R5cGUzRm9udCIsIml0YWxpYyIsImxvYWRlZE5hbWUiLCJtaW1ldHlwZSIsIm1pc3NpbmdGaWxlIiwibmFtZSIsInJlbWVhc3VyZSIsInN5c3RlbUZvbnRJbmZvIiwidmVydGljYWwiXSxjbj1bImNNYXAiLCJjb21wb3NpdGUiLCJkZWZhdWx0RW5jb2RpbmciLCJkaWZmZXJlbmNlcyIsImlzTW9ub3NwYWNlIiwiaXNTZXJpZkZvbnQiLCJpc1N5bWJvbGljRm9udCIsInNlYWNNYXAiLCJzdWJ0eXBlIiwidG9Gb250Q2hhciIsInRvVW5pY29kZSIsInR5cGUiLCJ2bWV0cmljcyIsIndpZHRocyJdO2Z1bmN0aW9uIGFkanVzdFdpZHRocyhlKXtpZighZS5mb250TWF0cml4KXJldHVybjtpZihlLmZvbnRNYXRyaXhbMF09PT1hWzBdKXJldHVybjtjb25zdCB0PS4wMDEvZS5mb250TWF0cml4WzBdLHI9ZS53aWR0aHM7Zm9yKGNvbnN0IGUgaW4gcilyW2VdKj10O2UuZGVmYXVsdFdpZHRoKj10fWZ1bmN0aW9uIGFtZW5kRmFsbGJhY2tUb1VuaWNvZGUoZSl7aWYoIWUuZmFsbGJhY2tUb1VuaWNvZGUpcmV0dXJuO2lmKGUudG9Vbmljb2RlIGluc3RhbmNlb2YgSWRlbnRpdHlUb1VuaWNvZGVNYXApcmV0dXJuO2NvbnN0IHQ9W107Zm9yKGNvbnN0IHIgaW4gZS5mYWxsYmFja1RvVW5pY29kZSllLnRvVW5pY29kZS5oYXMocil8fCh0W3JdPWUuZmFsbGJhY2tUb1VuaWNvZGVbcl0pO3QubGVuZ3RoPjAmJmUudG9Vbmljb2RlLmFtZW5kKHQpfWNsYXNzIGZvbnRzX0dseXBoe2NvbnN0cnVjdG9yKGUsdCxyLGEsbixpLHMsbyxjKXt0aGlzLm9yaWdpbmFsQ2hhckNvZGU9ZTt0aGlzLmZvbnRDaGFyPXQ7dGhpcy51bmljb2RlPXI7dGhpcy5hY2NlbnQ9YTt0aGlzLndpZHRoPW47dGhpcy52bWV0cmljPWk7dGhpcy5vcGVyYXRvckxpc3RJZD1zO3RoaXMuaXNTcGFjZT1vO3RoaXMuaXNJbkZvbnQ9Y31nZXQgY2F0ZWdvcnkoKXtyZXR1cm4gc2hhZG93KHRoaXMsImNhdGVnb3J5IixmdW5jdGlvbiBnZXRDaGFyVW5pY29kZUNhdGVnb3J5KGUpe2NvbnN0IHQ9d2EuZ2V0KGUpO2lmKHQpcmV0dXJuIHQ7Y29uc3Qgcj1lLm1hdGNoKHlhKSxhPXtpc1doaXRlc3BhY2U6ISFyPy5bMV0saXNaZXJvV2lkdGhEaWFjcml0aWM6ISFyPy5bMl0saXNJbnZpc2libGVGb3JtYXRNYXJrOiEhcj8uWzNdfTt3YS5zZXQoZSxhKTtyZXR1cm4gYX0odGhpcy51bmljb2RlKSwhMCl9fWZ1bmN0aW9uIGludDE2KGUsdCl7cmV0dXJuKGU8PDgpK3R9ZnVuY3Rpb24gd3JpdGVTaWduZWRJbnQxNihlLHQscil7ZVt0KzFdPXI7ZVt0XT1yPj4+OH1mdW5jdGlvbiBzaWduZWRJbnQxNihlLHQpe2NvbnN0IHI9KGU8PDgpK3Q7cmV0dXJuIDMyNzY4JnI/ci02NTUzNjpyfWZ1bmN0aW9uIHN0cmluZzE2KGUpe3JldHVybiBTdHJpbmcuZnJvbUNoYXJDb2RlKGU+PjgmMjU1LDI1NSZlKX1mdW5jdGlvbiBzYWZlU3RyaW5nMTYoZSl7ZT4zMjc2Nz9lPTMyNzY3OmU8LTMyNzY4JiYoZT0tMzI3NjgpO3JldHVybiBTdHJpbmcuZnJvbUNoYXJDb2RlKGU+PjgmMjU1LDI1NSZlKX1mdW5jdGlvbiBpc1RydWVUeXBlQ29sbGVjdGlvbkZpbGUoZSl7cmV0dXJuInR0Y2YiPT09Ynl0ZXNUb1N0cmluZyhlLnBlZWtCeXRlcyg0KSl9ZnVuY3Rpb24gZ2V0Rm9udEZpbGVUeXBlKGUse3R5cGU6dCxzdWJ0eXBlOnIsY29tcG9zaXRlOmF9KXtsZXQgbixpO2lmKGZ1bmN0aW9uIGlzVHJ1ZVR5cGVGaWxlKGUpe2NvbnN0IHQ9ZS5wZWVrQnl0ZXMoNCk7cmV0dXJuIDY1NTM2PT09cmVhZFVpbnQzMih0LDApfHwidHJ1ZSI9PT1ieXRlc1RvU3RyaW5nKHQpfShlKXx8aXNUcnVlVHlwZUNvbGxlY3Rpb25GaWxlKGUpKW49YT8iQ0lERm9udFR5cGUyIjoiVHJ1ZVR5cGUiO2Vsc2UgaWYoZnVuY3Rpb24gaXNPcGVuVHlwZUZpbGUoZSl7cmV0dXJuIk9UVE8iPT09Ynl0ZXNUb1N0cmluZyhlLnBlZWtCeXRlcyg0KSl9KGUpKW49YT8iQ0lERm9udFR5cGUyIjoiT3BlblR5cGUiO2Vsc2UgaWYoZnVuY3Rpb24gaXNUeXBlMUZpbGUoZSl7Y29uc3QgdD1lLnBlZWtCeXRlcygyKTtyZXR1cm4gMzc9PT10WzBdJiYzMz09PXRbMV18fDEyOD09PXRbMF0mJjE9PT10WzFdfShlKSluPWE/IkNJREZvbnRUeXBlMCI6Ik1NVHlwZTEiPT09dD8iTU1UeXBlMSI6IlR5cGUxIjtlbHNlIGlmKGZ1bmN0aW9uIGlzQ0ZGRmlsZShlKXtjb25zdCB0PWUucGVla0J5dGVzKDQpO3JldHVybiB0WzBdPj0xJiZ0WzNdPj0xJiZ0WzNdPD00fShlKSlpZihhKXtuPSJDSURGb250VHlwZTAiO2k9IkNJREZvbnRUeXBlMEMifWVsc2V7bj0iTU1UeXBlMSI9PT10PyJNTVR5cGUxIjoiVHlwZTEiO2k9IlR5cGUxQyJ9ZWxzZXt3YXJuKCJnZXRGb250RmlsZVR5cGU6IFVuYWJsZSB0byBkZXRlY3QgY29ycmVjdCBmb250IGZpbGUgVHlwZS9TdWJ0eXBlLiIpO249dDtpPXJ9cmV0dXJuW24saV19ZnVuY3Rpb24gYXBwbHlTdGFuZGFyZEZvbnRHbHlwaE1hcChlLHQpe2Zvcihjb25zdCByIGluIHQpZVsrcl09dFtyXX1mdW5jdGlvbiBidWlsZFRvRm9udENoYXIoZSx0LHIpe2NvbnN0IGE9W107bGV0IG47Zm9yKGxldCByPTAsaT1lLmxlbmd0aDtyPGk7cisrKXtuPWdldFVuaWNvZGVGb3JHbHlwaChlW3JdLHQpOy0xIT09biYmKGFbcl09bil9Zm9yKGNvbnN0IGUgaW4gcil7bj1nZXRVbmljb2RlRm9yR2x5cGgocltlXSx0KTstMSE9PW4mJihhWytlXT1uKX1yZXR1cm4gYX1mdW5jdGlvbiBpc01hY05hbWVSZWNvcmQoZSl7cmV0dXJuIDE9PT1lLnBsYXRmb3JtJiYwPT09ZS5lbmNvZGluZyYmMD09PWUubGFuZ3VhZ2V9ZnVuY3Rpb24gaXNXaW5OYW1lUmVjb3JkKGUpe3JldHVybiAzPT09ZS5wbGF0Zm9ybSYmMT09PWUuZW5jb2RpbmcmJjEwMzM9PT1lLmxhbmd1YWdlfWZ1bmN0aW9uIGNvbnZlcnRDaWRTdHJpbmcoZSx0LHI9ITEpe3N3aXRjaCh0Lmxlbmd0aCl7Y2FzZSAxOnJldHVybiB0LmNoYXJDb2RlQXQoMCk7Y2FzZSAyOnJldHVybiB0LmNoYXJDb2RlQXQoMCk8PDh8dC5jaGFyQ29kZUF0KDEpfWNvbnN0IGE9YFVuc3VwcG9ydGVkIENJRCBzdHJpbmcgKGNoYXJDb2RlICR7ZX0pOiAiJHt0fSIuYDtpZihyKXRocm93IG5ldyBGb3JtYXRFcnJvcihhKTt3YXJuKGEpO3JldHVybiB0fWZ1bmN0aW9uIGFkanVzdE1hcHBpbmcoZSx0LHIsYSl7Y29uc3Qgbj1PYmplY3QuY3JlYXRlKG51bGwpLGk9bmV3IE1hcCxzPVtdLG89bmV3IFNldDtsZXQgYz0wO2xldCBsPW5uW2NdWzBdLGg9bm5bY11bMV07Y29uc3QgaXNJblByaXZhdGVBcmVhPWU9Pm5uWzBdWzBdPD1lJiZlPD1ublswXVsxXXx8bm5bMV1bMF08PWUmJmU8PW5uWzFdWzFdO2xldCB1PW51bGw7Zm9yKGNvbnN0IGQgaW4gZSl7bGV0IGY9ZVtkXTtpZighdChmKSljb250aW51ZTtpZihsPmgpe2MrKztpZihjPj1ubi5sZW5ndGgpe3dhcm4oIlJhbiBvdXQgb2Ygc3BhY2UgaW4gZm9udCBwcml2YXRlIHVzZSBhcmVhLiIpO2JyZWFrfWw9bm5bY11bMF07aD1ubltjXVsxXX1jb25zdCBnPWwrKzswPT09ZiYmKGY9cik7bGV0IHA9YS5nZXQoZCk7aWYoInN0cmluZyI9PXR5cGVvZiBwKWlmKDE9PT1wLmxlbmd0aClwPXAuY29kZVBvaW50QXQoMCk7ZWxzZXtpZighdSl7dT1uZXcgTWFwO2ZvcihsZXQgZT02NDI1NjtlPD02NDMzNTtlKyspe2NvbnN0IHQ9U3RyaW5nLmZyb21DaGFyQ29kZShlKS5ub3JtYWxpemUoIk5GS0QiKTt0Lmxlbmd0aD4xJiZ1LnNldCh0LGUpfX1wPXUuZ2V0KHApfHxwLmNvZGVQb2ludEF0KDApfWlmKHAmJiFpc0luUHJpdmF0ZUFyZWEocCkmJiFvLmhhcyhmKSl7aS5zZXQocCxmKTtvLmFkZChmKX1uW2ddPWY7c1tkXT1nfXJldHVybnt0b0ZvbnRDaGFyOnMsY2hhckNvZGVUb0dseXBoSWQ6bix0b1VuaWNvZGVFeHRyYU1hcDppLG5leHRBdmFpbGFibGVGb250Q2hhckNvZGU6bH19ZnVuY3Rpb24gY3JlYXRlQ21hcFRhYmxlKGUsdCxyKXtjb25zdCBhPWZ1bmN0aW9uIGdldFJhbmdlcyhlLHQscil7Y29uc3QgYT1bXTtmb3IoY29uc3QgdCBpbiBlKWVbdF0+PXJ8fGEucHVzaCh7Zm9udENoYXJDb2RlOjB8dCxnbHlwaElkOmVbdF19KTtpZih0KWZvcihjb25zdFtlLG5db2YgdCluPj1yfHxhLnB1c2goe2ZvbnRDaGFyQ29kZTplLGdseXBoSWQ6bn0pOzA9PT1hLmxlbmd0aCYmYS5wdXNoKHtmb250Q2hhckNvZGU6MCxnbHlwaElkOjB9KTthLnNvcnQoKGUsdCk9PmUuZm9udENoYXJDb2RlLXQuZm9udENoYXJDb2RlKTtjb25zdCBuPVtdLGk9YS5sZW5ndGg7Zm9yKGxldCBlPTA7ZTxpOyl7Y29uc3QgdD1hW2VdLmZvbnRDaGFyQ29kZSxyPVthW2VdLmdseXBoSWRdOysrZTtsZXQgcz10O2Zvcig7ZTxpJiZzKzE9PT1hW2VdLmZvbnRDaGFyQ29kZTspe3IucHVzaChhW2VdLmdseXBoSWQpOysrczsrK2U7aWYoNjU1MzU9PT1zKWJyZWFrfW4ucHVzaChbdCxzLHJdKX1yZXR1cm4gbn0oZSx0LHIpLG49YS5hdCgtMSlbMV0+NjU1MzU/MjoxO2xldCBpLHMsbyxjLGw9IlwwXDAiK3N0cmluZzE2KG4pKyJcMANcMAEiK3N0cmluZzMyKDQrOCpuKTtmb3IoaT1hLmxlbmd0aC0xO2k+PTAmJiEoYVtpXVswXTw9NjU1MzUpOy0taSk7Y29uc3QgaD1pKzE7YVtpXVswXTw2NTUzNSYmNjU1MzU9PT1hW2ldWzFdJiYoYVtpXVsxXT02NTUzNCk7Y29uc3QgdT1hW2ldWzFdPDY1NTM1PzE6MCxkPWgrdSxmPU9wZW5UeXBlRmlsZUJ1aWxkZXIuZ2V0U2VhcmNoUGFyYW1zKGQsMik7bGV0IGcscCxtLGIseT0iIix3PSIiLHg9IiIsUz0iIixrPSIiLEM9MDtmb3IoaT0wLHM9aDtpPHM7aSsrKXtnPWFbaV07cD1nWzBdO209Z1sxXTt5Kz1zdHJpbmcxNihwKTt3Kz1zdHJpbmcxNihtKTtiPWdbMl07bGV0IGU9ITA7Zm9yKG89MSxjPWIubGVuZ3RoO288YzsrK28paWYoYltvXSE9PWJbby0xXSsxKXtlPSExO2JyZWFrfWlmKGUpe3grPXN0cmluZzE2KGJbMF0tcCY2NTUzNSk7Uys9c3RyaW5nMTYoMCl9ZWxzZXtjb25zdCBlPTIqKGQtaSkrMipDO0MrPW0tcCsxO3grPXN0cmluZzE2KDApO1MrPXN0cmluZzE2KGUpO2ZvcihvPTAsYz1iLmxlbmd0aDtvPGM7KytvKWsrPXN0cmluZzE2KGJbb10pfX1pZih1PjApe3crPSLDv8O/Ijt5Kz0iw7/DvyI7eCs9IlwwASI7Uys9IlwwXDAifWNvbnN0IHY9IlwwXDAiK3N0cmluZzE2KDIqZCkrc3RyaW5nMTYoZi5yYW5nZSkrc3RyaW5nMTYoZi5lbnRyeSkrc3RyaW5nMTYoZi5yYW5nZVNoaWZ0KSt3KyJcMFwwIit5K3grUytrO2xldCBUPSIiLE89IiI7aWYobj4xKXtsKz0iXDADXDBcbiIrc3RyaW5nMzIoNCs4Km4rNCt2Lmxlbmd0aCk7VD0iIjtmb3IoaT0wLHM9YS5sZW5ndGg7aTxzO2krKyl7Zz1hW2ldO3A9Z1swXTtiPWdbMl07bGV0IGU9YlswXTtmb3Iobz0xLGM9Yi5sZW5ndGg7bzxjOysrbylpZihiW29dIT09YltvLTFdKzEpe209Z1swXStvLTE7VCs9c3RyaW5nMzIocCkrc3RyaW5nMzIobSkrc3RyaW5nMzIoZSk7cD1tKzE7ZT1iW29dfVQrPXN0cmluZzMyKHApK3N0cmluZzMyKGdbMV0pK3N0cmluZzMyKGUpfU89IlwwXGZcMFwwIitzdHJpbmczMihULmxlbmd0aCsxNikrIlwwXDBcMFwwIitzdHJpbmczMihULmxlbmd0aC8xMil9cmV0dXJuIGwrIlwwBCIrc3RyaW5nMTYodi5sZW5ndGgrNCkrditPK1R9ZnVuY3Rpb24gY3JlYXRlT1MyVGFibGUoZSx0LHIpe3J8fD17dW5pdHNQZXJFbTowLHlNYXg6MCx5TWluOjAsYXNjZW50OjAsZGVzY2VudDowfTtsZXQgYT0wLG49MCxpPTAscz0wLG89bnVsbCxjPTAsbD0tMTtpZih0KXtmb3IobGV0IGUgaW4gdCl7ZXw9MDsobz5lfHwhbykmJihvPWUpO2M8ZSYmKGM9ZSk7bD1nZXRVbmljb2RlUmFuZ2VGb3IoZSxsKTtpZihsPDMyKWF8PTE8PGw7ZWxzZSBpZihsPDY0KW58PTE8PGwtMzI7ZWxzZSBpZihsPDk2KWl8PTE8PGwtNjQ7ZWxzZXtpZighKGw8MTIzKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlVuaWNvZGUgcmFuZ2VzIEJpdHMgPiAxMjMgYXJlIHJlc2VydmVkIGZvciBpbnRlcm5hbCB1c2FnZSIpO3N8PTE8PGwtOTZ9fWM+NjU1MzUmJihjPTY1NTM1KX1lbHNle289MDtjPTI1NX1jb25zdCBoPWUuYmJveHx8WzAsMCwwLDBdLHU9ci51bml0c1BlckVtfHwoZS5mb250TWF0cml4PzEvTWF0aC5tYXgoLi4uZS5mb250TWF0cml4LnNsaWNlKDAsNCkubWFwKE1hdGguYWJzKSk6MWUzKSxkPWUuYXNjZW50U2NhbGVkPzE6dS9zbixmPXIuYXNjZW50fHxNYXRoLnJvdW5kKGQqKGUuYXNjZW50fHxoWzNdKSk7bGV0IGc9ci5kZXNjZW50fHxNYXRoLnJvdW5kKGQqKGUuZGVzY2VudHx8aFsxXSkpO2c+MCYmZS5kZXNjZW50PjAmJmhbMV08MCYmKGc9LWcpO2NvbnN0IHA9ci55TWF4fHxmLG09LXIueU1pbnx8LWc7cmV0dXJuIlwwAwIkAcO0XDAFXDBcMALCigLCu1wwXDBcMMKMAsKKAsK7XDBcMAHDn1x4MDAxAQJcMFwwXDBcMAYiK1N0cmluZy5mcm9tQ2hhckNvZGUoZS5maXhlZFBpdGNoPzk6MCkrIlwwXDBcMFwwXDBcMCIrc3RyaW5nMzIoYSkrc3RyaW5nMzIobikrc3RyaW5nMzIoaSkrc3RyaW5nMzIocykrIioyMSoiK3N0cmluZzE2KGUuaXRhbGljQW5nbGU/MTowKStzdHJpbmcxNihvfHxlLmZpcnN0Q2hhcikrc3RyaW5nMTYoY3x8ZS5sYXN0Q2hhcikrc3RyaW5nMTYoZikrc3RyaW5nMTYoZykrIlwwZCIrc3RyaW5nMTYocCkrc3RyaW5nMTYobSkrIlwwXDBcMFwwXDBcMFwwXDAiK3N0cmluZzE2KGUueEhlaWdodCkrc3RyaW5nMTYoZS5jYXBIZWlnaHQpK3N0cmluZzE2KDApK3N0cmluZzE2KG98fGUuZmlyc3RDaGFyKSsiXDADIn1mdW5jdGlvbiBjcmVhdGVQb3N0VGFibGUoZSl7cmV0dXJuIlwwA1wwXDAiK3N0cmluZzMyKE1hdGguZmxvb3IoNjU1MzYqZS5pdGFsaWNBbmdsZSkpKyJcMFwwXDBcMCIrc3RyaW5nMzIoZS5maXhlZFBpdGNoPzE6MCkrIlwwXDBcMFwwXDBcMFwwXDBcMFwwXDBcMFwwXDBcMFwwIn1mdW5jdGlvbiBjcmVhdGVQb3N0c2NyaXB0TmFtZShlKXtyZXR1cm4gZS5yZXBsYWNlQWxsKC9bXlx4MjEtXHg3RV18W1tcXSgpe308Pi8lXS9nLCIiKS5zbGljZSgwLDYzKX1mdW5jdGlvbiBjcmVhdGVOYW1lVGFibGUoZSx0KXt0fHwodD1bW10sW11dKTtjb25zdCByPVt0WzBdWzBdfHwiT3JpZ2luYWwgbGljZW5jZSIsdFswXVsxXXx8ZSx0WzBdWzJdfHwiVW5rbm93biIsdFswXVszXXx8InVuaXF1ZUlEIix0WzBdWzRdfHxlLHRbMF1bNV18fCJWZXJzaW9uIDAuMTEiLHRbMF1bNl18fGNyZWF0ZVBvc3RzY3JpcHROYW1lKGUpLHRbMF1bN118fCJVbmtub3duIix0WzBdWzhdfHwiVW5rbm93biIsdFswXVs5XXx8IlVua25vd24iXSxhPVtdO2xldCBuLGkscyxvLGM7Zm9yKG49MCxpPXIubGVuZ3RoO248aTtuKyspe2M9dFsxXVtuXXx8cltuXTtjb25zdCBlPVtdO2ZvcihzPTAsbz1jLmxlbmd0aDtzPG87cysrKWUucHVzaChzdHJpbmcxNihjLmNoYXJDb2RlQXQocykpKTthLnB1c2goZS5qb2luKCIiKSl9Y29uc3QgbD1bcixhXSxoPVsiXDABIiwiXDADIl0sdT1bIlwwXDAiLCJcMAEiXSxkPVsiXDBcMCIsIgRcdCJdLGY9ci5sZW5ndGgqaC5sZW5ndGg7bGV0IGc9IlwwXDAiK3N0cmluZzE2KGYpK3N0cmluZzE2KDEyKmYrNikscD0wO2ZvcihuPTAsaT1oLmxlbmd0aDtuPGk7bisrKXtjb25zdCBlPWxbbl07Zm9yKHM9MCxvPWUubGVuZ3RoO3M8bztzKyspe2M9ZVtzXTtnKz1oW25dK3Vbbl0rZFtuXStzdHJpbmcxNihzKStzdHJpbmcxNihjLmxlbmd0aCkrc3RyaW5nMTYocCk7cCs9Yy5sZW5ndGh9fWcrPXIuam9pbigiIikrYS5qb2luKCIiKTtyZXR1cm4gZ31jbGFzcyBGb250e2NvbnN0cnVjdG9yKGUsdCxyLGEpe3RoaXMubmFtZT1lO3RoaXMucHNOYW1lPW51bGw7dGhpcy5taW1ldHlwZT1udWxsO3RoaXMuZGlzYWJsZUZvbnRGYWNlPWEuZGlzYWJsZUZvbnRGYWNlO3RoaXMuZm9udEV4dHJhUHJvcGVydGllcz1hLmZvbnRFeHRyYVByb3BlcnRpZXM7dGhpcy5sb2FkZWROYW1lPXIubG9hZGVkTmFtZTt0aGlzLmlzVHlwZTNGb250PXIuaXNUeXBlM0ZvbnQ7dGhpcy5taXNzaW5nRmlsZT0hMTt0aGlzLmNzc0ZvbnRJbmZvPXIuY3NzRm9udEluZm87dGhpcy5fY2hhcnNDYWNoZT1PYmplY3QuY3JlYXRlKG51bGwpO3RoaXMuX2dseXBoQ2FjaGU9T2JqZWN0LmNyZWF0ZShudWxsKTtsZXQgbj0hIShyLmZsYWdzJkFhKTtpZighbiYmIXIuaXNTaW11bGF0ZWRGbGFncyl7Y29uc3QgdD1fYSgpLHI9amEoKSxhPVVhKCk7Zm9yKGNvbnN0IGkgb2YgZS5zcGxpdCgiKyIpKXtsZXQgZT1pLnJlcGxhY2VBbGwoL1ssX10vZywiLSIpO2U9dFtlXXx8cltlXXx8ZTtlPWUuc3BsaXQoIi0iLDEpWzBdO2lmKGFbZV0pe249ITA7YnJlYWt9fX10aGlzLmlzU2VyaWZGb250PW47dGhpcy5pc1N5bWJvbGljRm9udD0hIShyLmZsYWdzJmthKTt0aGlzLmlzTW9ub3NwYWNlPSEhKHIuZmxhZ3MmU2EpO2xldHt0eXBlOmksc3VidHlwZTpzfT1yO3RoaXMudHlwZT1pO3RoaXMuc3VidHlwZT1zO3RoaXMuc3lzdGVtRm9udEluZm89ci5zeXN0ZW1Gb250SW5mbztjb25zdCBvPWUubWF0Y2goL15JbnZhbGlkUERGanNGb250XyguKilfXGQrJC8pO3RoaXMuaXNJbnZhbGlkUERGanNGb250PSEhbzt0aGlzLmlzSW52YWxpZFBERmpzRm9udD90aGlzLmZhbGxiYWNrTmFtZT1vWzFdOnRoaXMuaXNNb25vc3BhY2U/dGhpcy5mYWxsYmFja05hbWU9Im1vbm9zcGFjZSI6dGhpcy5pc1NlcmlmRm9udD90aGlzLmZhbGxiYWNrTmFtZT0ic2VyaWYiOnRoaXMuZmFsbGJhY2tOYW1lPSJzYW5zLXNlcmlmIjtpZih0aGlzLnN5c3RlbUZvbnRJbmZvPy5ndWVzc0ZhbGxiYWNrKXt0aGlzLnN5c3RlbUZvbnRJbmZvLmd1ZXNzRmFsbGJhY2s9ITE7dGhpcy5zeXN0ZW1Gb250SW5mby5jc3MrPWAsJHt0aGlzLmZhbGxiYWNrTmFtZX1gfXRoaXMuZGlmZmVyZW5jZXM9ci5kaWZmZXJlbmNlczt0aGlzLndpZHRocz1yLndpZHRoczt0aGlzLmRlZmF1bHRXaWR0aD1yLmRlZmF1bHRXaWR0aDt0aGlzLmNvbXBvc2l0ZT1yLmNvbXBvc2l0ZTt0aGlzLmNNYXA9ci5jTWFwO3RoaXMuY2FwSGVpZ2h0PXIuY2FwSGVpZ2h0L3NuO3RoaXMuYXNjZW50PXIuYXNjZW50L3NuO3RoaXMuZGVzY2VudD1yLmRlc2NlbnQvc247dGhpcy5saW5lSGVpZ2h0PXRoaXMuYXNjZW50LXRoaXMuZGVzY2VudDt0aGlzLmZvbnRNYXRyaXg9ci5mb250TWF0cml4O3RoaXMuYmJveD1yLmJib3g7dGhpcy5kZWZhdWx0RW5jb2Rpbmc9ci5kZWZhdWx0RW5jb2Rpbmc7dGhpcy50b1VuaWNvZGU9ci50b1VuaWNvZGU7dGhpcy50b0ZvbnRDaGFyPVtdO2lmKCJUeXBlMyI9PT1yLnR5cGUpe2ZvcihsZXQgZT0wO2U8MjU2O2UrKyl0aGlzLnRvRm9udENoYXJbZV09dGhpcy5kaWZmZXJlbmNlc1tlXXx8ci5kZWZhdWx0RW5jb2RpbmdbZV07cmV0dXJufXRoaXMuY2lkRW5jb2Rpbmc9ci5jaWRFbmNvZGluZ3x8IiI7dGhpcy52ZXJ0aWNhbD0hIXIudmVydGljYWw7aWYodGhpcy52ZXJ0aWNhbCl7dGhpcy52bWV0cmljcz1yLnZtZXRyaWNzO3RoaXMuZGVmYXVsdFZNZXRyaWNzPXIuZGVmYXVsdFZNZXRyaWNzfWlmKCF0fHx0LmlzRW1wdHkpe3QmJndhcm4oJ0ZvbnQgZmlsZSBpcyBlbXB0eSBpbiAiJytlKyciICgnK3RoaXMubG9hZGVkTmFtZSsiKSIpO3RoaXMuZmFsbGJhY2tUb1N5c3RlbUZvbnQocik7cmV0dXJufVtpLHNdPWdldEZvbnRGaWxlVHlwZSh0LHIpO2k9PT10aGlzLnR5cGUmJnM9PT10aGlzLnN1YnR5cGV8fGluZm8oYEluY29uc2lzdGVudCBmb250IGZpbGUgVHlwZS9TdWJUeXBlLCBleHBlY3RlZDogJHt0aGlzLnR5cGV9LyR7dGhpcy5zdWJ0eXBlfSBidXQgZm91bmQ6ICR7aX0vJHtzfS5gKTtsZXQgYzt0cnl7c3dpdGNoKGkpe2Nhc2UiTU1UeXBlMSI6aW5mbygiTU1UeXBlMSBmb250ICgiK2UrIiksIGZhbGxpbmcgYmFjayB0byBUeXBlMS4iKTtjYXNlIlR5cGUxIjpjYXNlIkNJREZvbnRUeXBlMCI6dGhpcy5taW1ldHlwZT0iZm9udC9vcGVudHlwZSI7Y29uc3QgYT0iVHlwZTFDIj09PXN8fCJDSURGb250VHlwZTBDIj09PXM/bmV3IENGRkZvbnQodCxyKTpuZXcgVHlwZTFGb250KGUsdCxyKTthZGp1c3RXaWR0aHMocik7Yz10aGlzLmNvbnZlcnQoZSxhLHIpO2JyZWFrO2Nhc2UiT3BlblR5cGUiOmNhc2UiVHJ1ZVR5cGUiOmNhc2UiQ0lERm9udFR5cGUyIjp0aGlzLm1pbWV0eXBlPSJmb250L29wZW50eXBlIjtjPXRoaXMuY2hlY2tBbmRSZXBhaXIoZSx0LHIpO2FkanVzdFdpZHRocyhyKTt0aGlzLmlzT3BlblR5cGUmJihpPSJPcGVuVHlwZSIpO2JyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEZvcm1hdEVycm9yKGBGb250ICR7aX0gaXMgbm90IHN1cHBvcnRlZGApfX1jYXRjaChlKXt3YXJuKGUpO3RoaXMuZmFsbGJhY2tUb1N5c3RlbUZvbnQocik7cmV0dXJufWFtZW5kRmFsbGJhY2tUb1VuaWNvZGUocik7dGhpcy5kYXRhPWM7dGhpcy50eXBlPWk7dGhpcy5zdWJ0eXBlPXM7dGhpcy5mb250TWF0cml4PXIuZm9udE1hdHJpeDt0aGlzLndpZHRocz1yLndpZHRoczt0aGlzLmRlZmF1bHRXaWR0aD1yLmRlZmF1bHRXaWR0aDt0aGlzLnRvVW5pY29kZT1yLnRvVW5pY29kZTt0aGlzLnNlYWNNYXA9ci5zZWFjTWFwfWdldCByZW5kZXJlcigpe3JldHVybiBzaGFkb3codGhpcywicmVuZGVyZXIiLEZvbnRSZW5kZXJlckZhY3RvcnkuY3JlYXRlKHRoaXMseGEpKX1leHBvcnREYXRhKCl7Y29uc3QgZT1PYmplY3QuY3JlYXRlKG51bGwpO2Zvcihjb25zdCB0IG9mIG9uKXtjb25zdCByPXRoaXNbdF07dm9pZCAwIT09ciYmKGVbdF09cil9aWYoIXRoaXMuZm9udEV4dHJhUHJvcGVydGllcylyZXR1cm57ZGF0YTplfTtjb25zdCB0PU9iamVjdC5jcmVhdGUobnVsbCk7Zm9yKGNvbnN0IGUgb2YgY24pe2NvbnN0IHI9dGhpc1tlXTt2b2lkIDAhPT1yJiYodFtlXT1yKX1yZXR1cm57ZGF0YTplLGV4dHJhOnR9fWZhbGxiYWNrVG9TeXN0ZW1Gb250KGUpe3RoaXMubWlzc2luZ0ZpbGU9ITA7Y29uc3R7bmFtZTp0LHR5cGU6cn09dGhpcztsZXQgYT1ub3JtYWxpemVGb250TmFtZSh0KTtjb25zdCBuPV9hKCksaT1qYSgpLHM9ISFuW2FdLG89ISghaVthXXx8IW5baVthXV0pO2E9blthXXx8aVthXXx8YTtjb25zdCBjPUdhKClbYV07aWYoYyl7aXNOYU4odGhpcy5hc2NlbnQpJiYodGhpcy5hc2NlbnQ9Yy5hc2NlbnQvc24pO2lzTmFOKHRoaXMuZGVzY2VudCkmJih0aGlzLmRlc2NlbnQ9Yy5kZXNjZW50L3NuKTtpc05hTih0aGlzLmNhcEhlaWdodCkmJih0aGlzLmNhcEhlaWdodD1jLmNhcEhlaWdodC9zbil9dGhpcy5ib2xkPS9ib2xkL2dpLnRlc3QoYSk7dGhpcy5pdGFsaWM9L29ibGlxdWV8aXRhbGljL2dpLnRlc3QoYSk7dGhpcy5ibGFjaz0vQmxhY2svZy50ZXN0KHQpO2NvbnN0IGw9L05hcnJvdy9nLnRlc3QodCk7dGhpcy5yZW1lYXN1cmU9KCFzfHxsKSYmT2JqZWN0LmtleXModGhpcy53aWR0aHMpLmxlbmd0aD4wO2lmKChzfHxvKSYmIkNJREZvbnRUeXBlMiI9PT1yJiZ0aGlzLmNpZEVuY29kaW5nLnN0YXJ0c1dpdGgoIklkZW50aXR5LSIpKXtjb25zdCByPWUuY2lkVG9HaWRNYXAsYT1bXTthcHBseVN0YW5kYXJkRm9udEdseXBoTWFwKGEsWGEoKSk7L0FyaWFsLT9CbGFjay9pLnRlc3QodCk/YXBwbHlTdGFuZGFyZEZvbnRHbHlwaE1hcChhLEhhKCkpOi9DYWxpYnJpL2kudGVzdCh0KSYmYXBwbHlTdGFuZGFyZEZvbnRHbHlwaE1hcChhLFdhKCkpO2lmKHIpe2Zvcihjb25zdCBlIGluIGEpe2NvbnN0IHQ9YVtlXTt2b2lkIDAhPT1yW3RdJiYoYVsrZV09clt0XSl9ci5sZW5ndGghPT10aGlzLnRvVW5pY29kZS5sZW5ndGgmJmUuaGFzSW5jbHVkZWRUb1VuaWNvZGVNYXAmJnRoaXMudG9Vbmljb2RlIGluc3RhbmNlb2YgSWRlbnRpdHlUb1VuaWNvZGVNYXAmJnRoaXMudG9Vbmljb2RlLmZvckVhY2goZnVuY3Rpb24oZSx0KXtjb25zdCBuPWFbZV07dm9pZCAwPT09cltuXSYmKGFbK2VdPXQpfSl9dGhpcy50b1VuaWNvZGUgaW5zdGFuY2VvZiBJZGVudGl0eVRvVW5pY29kZU1hcHx8dGhpcy50b1VuaWNvZGUuZm9yRWFjaChmdW5jdGlvbihlLHQpe2FbK2VdPXR9KTt0aGlzLnRvRm9udENoYXI9YTt0aGlzLnRvVW5pY29kZT1uZXcgVG9Vbmljb2RlTWFwKGEpfWVsc2UgaWYoL1N5bWJvbC9pLnRlc3QoYSkpdGhpcy50b0ZvbnRDaGFyPWJ1aWxkVG9Gb250Q2hhcihkYSxnYSgpLHRoaXMuZGlmZmVyZW5jZXMpO2Vsc2UgaWYoL0RpbmdiYXRzL2kudGVzdChhKSl0aGlzLnRvRm9udENoYXI9YnVpbGRUb0ZvbnRDaGFyKGZhLHBhKCksdGhpcy5kaWZmZXJlbmNlcyk7ZWxzZSBpZihzfHxvKXtjb25zdCBlPWJ1aWxkVG9Gb250Q2hhcih0aGlzLmRlZmF1bHRFbmNvZGluZyxnYSgpLHRoaXMuZGlmZmVyZW5jZXMpOyJDSURGb250VHlwZTIiIT09cnx8dGhpcy5jaWRFbmNvZGluZy5zdGFydHNXaXRoKCJJZGVudGl0eS0iKXx8dGhpcy50b1VuaWNvZGUgaW5zdGFuY2VvZiBJZGVudGl0eVRvVW5pY29kZU1hcHx8dGhpcy50b1VuaWNvZGUuZm9yRWFjaChmdW5jdGlvbih0LHIpe2VbK3RdPXJ9KTt0aGlzLnRvRm9udENoYXI9ZX1lbHNle2NvbnN0IGU9Z2EoKSxyPVtdO3RoaXMudG9Vbmljb2RlLmZvckVhY2goKHQsYSk9PntpZighdGhpcy5jb21wb3NpdGUpe2NvbnN0IHI9Z2V0VW5pY29kZUZvckdseXBoKHRoaXMuZGlmZmVyZW5jZXNbdF18fHRoaXMuZGVmYXVsdEVuY29kaW5nW3RdLGUpOy0xIT09ciYmKGE9cil9clsrdF09YX0pO3RoaXMuY29tcG9zaXRlJiZ0aGlzLnRvVW5pY29kZSBpbnN0YW5jZW9mIElkZW50aXR5VG9Vbmljb2RlTWFwJiYvVGFob21hfFZlcmRhbmEvaS50ZXN0KHQpJiZhcHBseVN0YW5kYXJkRm9udEdseXBoTWFwKHIsWGEoKSk7dGhpcy50b0ZvbnRDaGFyPXJ9YW1lbmRGYWxsYmFja1RvVW5pY29kZShlKTt0aGlzLmxvYWRlZE5hbWU9YS5zcGxpdCgiLSIsMSlbMF19Y2hlY2tBbmRSZXBhaXIoZSx0LHIpe2NvbnN0IGE9WyJPUy8yIiwiY21hcCIsImhlYWQiLCJoaGVhIiwiaG10eCIsIm1heHAiLCJuYW1lIiwicG9zdCIsImxvY2EiLCJnbHlmIiwiZnBnbSIsInByZXAiLCJjdnQgIiwiQ0ZGICJdO2Z1bmN0aW9uIHJlYWRUYWJsZXMoZSx0KXtjb25zdCByPU9iamVjdC5jcmVhdGUobnVsbCk7clsiT1MvMiJdPW51bGw7ci5jbWFwPW51bGw7ci5oZWFkPW51bGw7ci5oaGVhPW51bGw7ci5obXR4PW51bGw7ci5tYXhwPW51bGw7ci5uYW1lPW51bGw7ci5wb3N0PW51bGw7Zm9yKGxldCBuPTA7bjx0O24rKyl7Y29uc3QgdD1yZWFkVGFibGVFbnRyeShlKTthLmluY2x1ZGVzKHQudGFnKSYmKDAhPT10Lmxlbmd0aCYmKHJbdC50YWddPXQpKX1yZXR1cm4gcn1mdW5jdGlvbiByZWFkVGFibGVFbnRyeShlKXtjb25zdCB0PWUuZ2V0U3RyaW5nKDQpLHI9ZS5nZXRJbnQzMigpPj4+MCxhPWUuZ2V0SW50MzIoKT4+PjAsbj1lLmdldEludDMyKCk+Pj4wLGk9ZS5wb3M7ZS5wb3M9ZS5zdGFydHx8MDtlLnNraXAoYSk7Y29uc3Qgcz1lLmdldEJ5dGVzKG4pO2UucG9zPWk7aWYoImhlYWQiPT09dCl7c1s4XT1zWzldPXNbMTBdPXNbMTFdPTA7c1sxN118PTMyfXJldHVybnt0YWc6dCxjaGVja3N1bTpyLGxlbmd0aDpuLG9mZnNldDphLGRhdGE6c319ZnVuY3Rpb24gcmVhZE9wZW5UeXBlSGVhZGVyKGUpe3JldHVybnt2ZXJzaW9uOmUuZ2V0U3RyaW5nKDQpLG51bVRhYmxlczplLmdldFVpbnQxNigpLHNlYXJjaFJhbmdlOmUuZ2V0VWludDE2KCksZW50cnlTZWxlY3RvcjplLmdldFVpbnQxNigpLHJhbmdlU2hpZnQ6ZS5nZXRVaW50MTYoKX19ZnVuY3Rpb24gc2FuaXRpemVHbHlwaChlLHQscixhLG4saSl7Y29uc3Qgcz17bGVuZ3RoOjAsc2l6ZU9mSW5zdHJ1Y3Rpb25zOjB9O2lmKHQ8MHx8dD49ZS5sZW5ndGh8fHI+ZS5sZW5ndGh8fHItdDw9MTIpcmV0dXJuIHM7Y29uc3Qgbz1lLnN1YmFycmF5KHQsciksYz1zaWduZWRJbnQxNihvWzJdLG9bM10pLGw9c2lnbmVkSW50MTYob1s0XSxvWzVdKSxoPXNpZ25lZEludDE2KG9bNl0sb1s3XSksdT1zaWduZWRJbnQxNihvWzhdLG9bOV0pO2lmKGM+aCl7d3JpdGVTaWduZWRJbnQxNihvLDIsaCk7d3JpdGVTaWduZWRJbnQxNihvLDYsYyl9aWYobD51KXt3cml0ZVNpZ25lZEludDE2KG8sNCx1KTt3cml0ZVNpZ25lZEludDE2KG8sOCxsKX1jb25zdCBkPXNpZ25lZEludDE2KG9bMF0sb1sxXSk7aWYoZDwwKXtpZihkPC0xKXJldHVybiBzO2Euc2V0KG8sbik7cy5sZW5ndGg9by5sZW5ndGg7cmV0dXJuIHN9bGV0IGYsZz0xMCxwPTA7Zm9yKGY9MDtmPGQ7ZisrKXtwPShvW2ddPDw4fG9bZysxXSkrMTtnKz0yfWNvbnN0IG09ZyxiPW9bZ108PDh8b1tnKzFdO3Muc2l6ZU9mSW5zdHJ1Y3Rpb25zPWI7Zys9MitiO2NvbnN0IHk9ZztsZXQgdz0wO2ZvcihmPTA7ZjxwO2YrKyl7Y29uc3QgZT1vW2crK107MTkyJmUmJihvW2ctMV09NjMmZSk7bGV0IHQ9MjsyJmU/dD0xOjE2JmUmJih0PTApO2xldCByPTI7NCZlP3I9MTozMiZlJiYocj0wKTtjb25zdCBhPXQrcjt3Kz1hO2lmKDgmZSl7Y29uc3QgZT1vW2crK107MD09PWUmJihvW2ctMV1ePTgpO2YrPWU7dys9ZSphfX1pZigwPT09dylyZXR1cm4gcztsZXQgeD1nK3c7aWYoeD5vLmxlbmd0aClyZXR1cm4gcztpZighaSYmYj4wKXthLnNldChvLnN1YmFycmF5KDAsbSksbik7YS5zZXQoWzAsMF0sbittKTthLnNldChvLnN1YmFycmF5KHkseCksbittKzIpO3gtPWI7by5sZW5ndGgteD4zJiYoeD14KzMmLTQpO3MubGVuZ3RoPXg7cmV0dXJuIHN9aWYoby5sZW5ndGgteD4zKXt4PXgrMyYtNDthLnNldChvLnN1YmFycmF5KDAseCksbik7cy5sZW5ndGg9eDtyZXR1cm4gc31hLnNldChvLG4pO3MubGVuZ3RoPW8ubGVuZ3RoO3JldHVybiBzfWZ1bmN0aW9uIHJlYWROYW1lVGFibGUoZSl7Y29uc3Qgcj0odC5zdGFydHx8MCkrZS5vZmZzZXQ7dC5wb3M9cjtjb25zdCBhPVtbXSxbXV0sbj1bXSxpPWUubGVuZ3RoLHM9citpO2lmKDAhPT10LmdldFVpbnQxNigpfHxpPDYpcmV0dXJuW2Esbl07Y29uc3Qgbz10LmdldFVpbnQxNigpLGM9dC5nZXRVaW50MTYoKTtsZXQgbCxoO2ZvcihsPTA7bDxvJiZ0LnBvcysxMjw9cztsKyspe2NvbnN0IGU9e3BsYXRmb3JtOnQuZ2V0VWludDE2KCksZW5jb2Rpbmc6dC5nZXRVaW50MTYoKSxsYW5ndWFnZTp0LmdldFVpbnQxNigpLG5hbWU6dC5nZXRVaW50MTYoKSxsZW5ndGg6dC5nZXRVaW50MTYoKSxvZmZzZXQ6dC5nZXRVaW50MTYoKX07KGlzTWFjTmFtZVJlY29yZChlKXx8aXNXaW5OYW1lUmVjb3JkKGUpKSYmbi5wdXNoKGUpfWZvcihsPTAsaD1uLmxlbmd0aDtsPGg7bCsrKXtjb25zdCBlPW5bbF07aWYoZS5sZW5ndGg8PTApY29udGludWU7Y29uc3QgaT1yK2MrZS5vZmZzZXQ7aWYoaStlLmxlbmd0aD5zKWNvbnRpbnVlO3QucG9zPWk7Y29uc3Qgbz1lLm5hbWU7aWYoZS5lbmNvZGluZyl7bGV0IHI9IiI7Zm9yKGxldCBhPTAsbj1lLmxlbmd0aDthPG47YSs9MilyKz1TdHJpbmcuZnJvbUNoYXJDb2RlKHQuZ2V0VWludDE2KCkpO2FbMV1bb109cn1lbHNlIGFbMF1bb109dC5nZXRTdHJpbmcoZS5sZW5ndGgpfXJldHVyblthLG5dfWNvbnN0IG49WzAsMCwwLDAsMCwwLDAsMCwtMiwtMiwtMiwtMiwwLDAsLTIsLTUsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsMCwwLC0xLDAsLTEsLTEsLTEsLTEsMSwtMSwtOTk5LDAsMSwwLC0xLC0yLDAsLTEsLTIsLTEsLTEsMCwtMSwtMSwwLDAsLTk5OSwtOTk5LC0xLC0xLC0xLC0xLC0yLC05OTksLTIsLTIsLTk5OSwwLC0yLC0yLDAsMCwtMiwwLC0yLDAsMCwwLC0yLC0xLC0xLDEsMSwwLDAsLTEsLTEsLTEsLTEsLTEsLTEsLTEsMCwwLC0xLDAsLTEsLTEsMCwtOTk5LC0xLC0xLC0xLC0xLC0xLC0xLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLC0yLC05OTksLTk5OSwtOTk5LC05OTksLTk5OSwtMSwtMSwtMiwtMiwwLDAsMCwwLC0xLC0xLC05OTksLTIsLTIsMCwwLC0xLC0yLC0yLDAsMCwwLC0xLC0xLC0xLC0yXTtmdW5jdGlvbiBzYW5pdGl6ZVRUUHJvZ3JhbShlLHQpe2xldCByLGEsaSxzLG8sYz1lLmRhdGEsbD0wLGg9MCx1PTA7Y29uc3QgZD1bXSxmPVtdLGc9W107bGV0IHA9dC50b29Db21wbGV4VG9Gb2xsb3dGdW5jdGlvbnMsbT0hMSxiPTAseT0wO2ZvcihsZXQgZT1jLmxlbmd0aDtsPGU7KXtjb25zdCBlPWNbbCsrXTtpZig2ND09PWUpe2E9Y1tsKytdO2lmKG18fHkpbCs9YTtlbHNlIGZvcihyPTA7cjxhO3IrKylkLnB1c2goY1tsKytdKX1lbHNlIGlmKDY1PT09ZSl7YT1jW2wrK107aWYobXx8eSlsKz0yKmE7ZWxzZSBmb3Iocj0wO3I8YTtyKyspe2k9Y1tsKytdO2QucHVzaChpPDw4fGNbbCsrXSl9fWVsc2UgaWYoMTc2PT0oMjQ4JmUpKXthPWUtMTc2KzE7aWYobXx8eSlsKz1hO2Vsc2UgZm9yKHI9MDtyPGE7cisrKWQucHVzaChjW2wrK10pfWVsc2UgaWYoMTg0PT0oMjQ4JmUpKXthPWUtMTg0KzE7aWYobXx8eSlsKz0yKmE7ZWxzZSBmb3Iocj0wO3I8YTtyKyspe2k9Y1tsKytdO2QucHVzaChzaWduZWRJbnQxNihpLGNbbCsrXSkpfX1lbHNlIGlmKDQzIT09ZXx8cClpZig0NCE9PWV8fHApe2lmKDQ1PT09ZSlpZihtKXttPSExO2g9bH1lbHNle289Zi5wb3AoKTtpZighbyl7d2FybigiVFQ6IEVOREYgYmFkIHN0YWNrIik7dC5oaW50c1ZhbGlkPSExO3JldHVybn1zPWcucG9wKCk7Yz1vLmRhdGE7bD1vLmk7dC5mdW5jdGlvbnNTdGFja0RlbHRhc1tzXT1kLmxlbmd0aC1vLnN0YWNrVG9wfWVsc2UgaWYoMTM3PT09ZSl7aWYobXx8eSl7d2FybigiVFQ6IG5lc3RlZCBJREVGcyBub3QgYWxsb3dlZCIpO3A9ITB9bT0hMDt1PWx9ZWxzZSBpZig4OD09PWUpKytiO2Vsc2UgaWYoMjc9PT1lKXk9YjtlbHNlIGlmKDg5PT09ZSl7eT09PWImJih5PTApOy0tYn1lbHNlIGlmKDI4PT09ZSYmIW0mJiF5KXtjb25zdCBlPWQuYXQoLTEpO2U+MCYmKGwrPWUtMSl9fWVsc2V7aWYobXx8eSl7d2FybigiVFQ6IG5lc3RlZCBGREVGcyBub3QgYWxsb3dlZCIpO3A9ITB9bT0hMDt1PWw7cz1kLnBvcCgpO3QuZnVuY3Rpb25zRGVmaW5lZFtzXT17ZGF0YTpjLGk6bH19ZWxzZSBpZighbSYmIXkpe3M9ZC5hdCgtMSk7aWYoaXNOYU4ocykpaW5mbygiVFQ6IENBTEwgZW1wdHkgc3RhY2sgKG9yIGludmFsaWQgZW50cnkpLiIpO2Vsc2V7dC5mdW5jdGlvbnNVc2VkW3NdPSEwO2lmKHMgaW4gdC5mdW5jdGlvbnNTdGFja0RlbHRhcyl7Y29uc3QgZT1kLmxlbmd0aCt0LmZ1bmN0aW9uc1N0YWNrRGVsdGFzW3NdO2lmKGU8MCl7d2FybigiVFQ6IENBTEwgaW52YWxpZCBmdW5jdGlvbnMgc3RhY2sgZGVsdGEuIik7dC5oaW50c1ZhbGlkPSExO3JldHVybn1kLmxlbmd0aD1lfWVsc2UgaWYocyBpbiB0LmZ1bmN0aW9uc0RlZmluZWQmJiFnLmluY2x1ZGVzKHMpKXtmLnB1c2goe2RhdGE6YyxpOmwsc3RhY2tUb3A6ZC5sZW5ndGgtMX0pO2cucHVzaChzKTtvPXQuZnVuY3Rpb25zRGVmaW5lZFtzXTtpZighbyl7d2FybigiVFQ6IENBTEwgbm9uLWV4aXN0ZW50IGZ1bmN0aW9uIik7dC5oaW50c1ZhbGlkPSExO3JldHVybn1jPW8uZGF0YTtsPW8uaX19fWlmKCFtJiYheSl7bGV0IHQ9MDtlPD0xNDI/dD1uW2VdOmU+PTE5MiYmZTw9MjIzP3Q9LTE6ZT49MjI0JiYodD0tMik7aWYoZT49MTEzJiZlPD0xMTcpe2E9ZC5wb3AoKTtpc05hTihhKXx8KHQ9MiotYSl9Zm9yKDt0PDAmJmQubGVuZ3RoPjA7KXtkLnBvcCgpO3QrK31mb3IoO3Q+MDspe2QucHVzaChOYU4pO3QtLX19fXQudG9vQ29tcGxleFRvRm9sbG93RnVuY3Rpb25zPXA7Y29uc3Qgdz1bY107bD5jLmxlbmd0aCYmdy5wdXNoKG5ldyBVaW50OEFycmF5KGwtYy5sZW5ndGgpKTtpZih1Pmgpe3dhcm4oIlRUOiBjb21wbGVtZW50aW5nIGEgbWlzc2luZyBmdW5jdGlvbiB0YWlsIik7dy5wdXNoKG5ldyBVaW50OEFycmF5KFszNCw0NV0pKX0hZnVuY3Rpb24gZm9sZFRUVGFibGUoZSx0KXtpZih0Lmxlbmd0aD4xKXtsZXQgcixhLG49MDtmb3Iocj0wLGE9dC5sZW5ndGg7cjxhO3IrKyluKz10W3JdLmxlbmd0aDtuPW4rMyYtNDtjb25zdCBpPW5ldyBVaW50OEFycmF5KG4pO2xldCBzPTA7Zm9yKHI9MCxhPXQubGVuZ3RoO3I8YTtyKyspe2kuc2V0KHRbcl0scyk7cys9dFtyXS5sZW5ndGh9ZS5kYXRhPWk7ZS5sZW5ndGg9bn19KGUsdyl9bGV0IGkscyxvLGM7aWYoaXNUcnVlVHlwZUNvbGxlY3Rpb25GaWxlKHQ9bmV3IFN0cmVhbShuZXcgVWludDhBcnJheSh0LmdldEJ5dGVzKCkpKSkpe2NvbnN0IGU9ZnVuY3Rpb24gcmVhZFRydWVUeXBlQ29sbGVjdGlvbkRhdGEoZSx0KXtjb25zdHtudW1Gb250czpyLG9mZnNldFRhYmxlOmF9PWZ1bmN0aW9uIHJlYWRUcnVlVHlwZUNvbGxlY3Rpb25IZWFkZXIoZSl7Y29uc3QgdD1lLmdldFN0cmluZyg0KTthc3NlcnQoInR0Y2YiPT09dCwiTXVzdCBiZSBhIFRydWVUeXBlIENvbGxlY3Rpb24gZm9udC4iKTtjb25zdCByPWUuZ2V0VWludDE2KCksYT1lLmdldFVpbnQxNigpLG49ZS5nZXRJbnQzMigpPj4+MCxpPVtdO2ZvcihsZXQgdD0wO3Q8bjt0KyspaS5wdXNoKGUuZ2V0SW50MzIoKT4+PjApO2NvbnN0IHM9e3R0Y1RhZzp0LG1ham9yVmVyc2lvbjpyLG1pbm9yVmVyc2lvbjphLG51bUZvbnRzOm4sb2Zmc2V0VGFibGU6aX07c3dpdGNoKHIpe2Nhc2UgMTpyZXR1cm4gcztjYXNlIDI6cy5kc2lnVGFnPWUuZ2V0SW50MzIoKT4+PjA7cy5kc2lnTGVuZ3RoPWUuZ2V0SW50MzIoKT4+PjA7cy5kc2lnT2Zmc2V0PWUuZ2V0SW50MzIoKT4+PjA7cmV0dXJuIHN9dGhyb3cgbmV3IEZvcm1hdEVycm9yKGBJbnZhbGlkIFRydWVUeXBlIENvbGxlY3Rpb24gbWFqb3JWZXJzaW9uOiAke3J9LmApfShlKSxuPXQuc3BsaXQoIisiKTtsZXQgaTtmb3IobGV0IHM9MDtzPHI7cysrKXtlLnBvcz0oZS5zdGFydHx8MCkrYVtzXTtjb25zdCByPXJlYWRPcGVuVHlwZUhlYWRlcihlKSxvPXJlYWRUYWJsZXMoZSxyLm51bVRhYmxlcyk7aWYoIW8ubmFtZSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoJ1RydWVUeXBlIENvbGxlY3Rpb24gZm9udCBtdXN0IGNvbnRhaW4gYSAibmFtZSIgdGFibGUuJyk7Y29uc3RbY109cmVhZE5hbWVUYWJsZShvLm5hbWUpO2ZvcihsZXQgZT0wLGE9Yy5sZW5ndGg7ZTxhO2UrKylmb3IobGV0IGE9MCxzPWNbZV0ubGVuZ3RoO2E8czthKyspe2NvbnN0IHM9Y1tlXVthXT8ucmVwbGFjZUFsbCgvXHMvZywiIik7aWYocyl7aWYocz09PXQpcmV0dXJue2hlYWRlcjpyLHRhYmxlczpvfTtpZighKG4ubGVuZ3RoPDIpKWZvcihjb25zdCBlIG9mIG4pcz09PWUmJihpPXtuYW1lOmUsaGVhZGVyOnIsdGFibGVzOm99KX19fWlmKGkpe3dhcm4oYFRydWVUeXBlIENvbGxlY3Rpb24gZG9lcyBub3QgY29udGFpbiAiJHt0fSIgZm9udCwgZmFsbGluZyBiYWNrIHRvICIke2kubmFtZX0iIGZvbnQgaW5zdGVhZC5gKTtyZXR1cm57aGVhZGVyOmkuaGVhZGVyLHRhYmxlczppLnRhYmxlc319dGhyb3cgbmV3IEZvcm1hdEVycm9yKGBUcnVlVHlwZSBDb2xsZWN0aW9uIGRvZXMgbm90IGNvbnRhaW4gIiR7dH0iIGZvbnQuYCl9KHQsdGhpcy5uYW1lKTtpPWUuaGVhZGVyO3M9ZS50YWJsZXN9ZWxzZXtpPXJlYWRPcGVuVHlwZUhlYWRlcih0KTtzPXJlYWRUYWJsZXModCxpLm51bVRhYmxlcyl9Y29uc3QgbD0hc1siQ0ZGICJdO2lmKGwpe2lmKCFzLmxvY2EpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCdSZXF1aXJlZCAibG9jYSIgdGFibGUgaXMgbm90IGZvdW5kJyk7aWYoIXMuZ2x5Zil7d2FybignUmVxdWlyZWQgImdseWYiIHRhYmxlIGlzIG5vdCBmb3VuZCAtLSB0cnlpbmcgdG8gcmVjb3Zlci4nKTtzLmdseWY9e3RhZzoiZ2x5ZiIsZGF0YTpuZXcgVWludDhBcnJheSgwKX19dGhpcy5pc09wZW5UeXBlPSExfWVsc2V7Y29uc3QgdD1yLmNvbXBvc2l0ZSYmKHIuY2lkVG9HaWRNYXA/Lmxlbmd0aD4wfHwhKHIuY01hcCBpbnN0YW5jZW9mIElkZW50aXR5Q01hcCkpO2lmKCJPVFRPIj09PWkudmVyc2lvbiYmIXR8fCFzLmhlYWR8fCFzLmhoZWF8fCFzLm1heHB8fCFzLnBvc3Qpe2M9bmV3IFN0cmVhbShzWyJDRkYgIl0uZGF0YSk7bz1uZXcgQ0ZGRm9udChjLHIpO3JldHVybiB0aGlzLmNvbnZlcnQoZSxvLHIpfWRlbGV0ZSBzLmdseWY7ZGVsZXRlIHMubG9jYTtkZWxldGUgcy5mcGdtO2RlbGV0ZSBzLnByZXA7ZGVsZXRlIHNbImN2dCAiXTt0aGlzLmlzT3BlblR5cGU9ITB9aWYoIXMubWF4cCl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoJ1JlcXVpcmVkICJtYXhwIiB0YWJsZSBpcyBub3QgZm91bmQnKTt0LnBvcz0odC5zdGFydHx8MCkrcy5tYXhwLm9mZnNldDtsZXQgaD10LmdldEludDMyKCk7Y29uc3QgdT10LmdldFVpbnQxNigpO2lmKDY1NTM2IT09aCYmMjA0ODAhPT1oKXtpZig2PT09cy5tYXhwLmxlbmd0aCloPTIwNDgwO2Vsc2V7aWYoIShzLm1heHAubGVuZ3RoPj0zMikpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCcibWF4cCIgdGFibGUgaGFzIGEgd3JvbmcgdmVyc2lvbiBudW1iZXInKTtoPTY1NTM2fSFmdW5jdGlvbiB3cml0ZVVpbnQzMihlLHQscil7ZVt0KzNdPTI1NSZyO2VbdCsyXT1yPj4+ODtlW3QrMV09cj4+PjE2O2VbdF09cj4+PjI0fShzLm1heHAuZGF0YSwwLGgpfWlmKHIuc2NhbGVGYWN0b3JzPy5sZW5ndGg9PT11JiZsKXtjb25zdHtzY2FsZUZhY3RvcnM6ZX09cix0PWludDE2KHMuaGVhZC5kYXRhWzUwXSxzLmhlYWQuZGF0YVs1MV0pLGE9bmV3IEdseWZUYWJsZSh7Z2x5ZlRhYmxlOnMuZ2x5Zi5kYXRhLGlzR2x5cGhMb2NhdGlvbnNMb25nOnQsbG9jYVRhYmxlOnMubG9jYS5kYXRhLG51bUdseXBoczp1fSk7YS5zY2FsZShlKTtjb25zdHtnbHlmOm4sbG9jYTppLGlzTG9jYXRpb25Mb25nOm99PWEud3JpdGUoKTtzLmdseWYuZGF0YT1uO3MubG9jYS5kYXRhPWk7aWYobyE9PSEhdCl7cy5oZWFkLmRhdGFbNTBdPTA7cy5oZWFkLmRhdGFbNTFdPW8/MTowfWNvbnN0IGM9cy5obXR4LmRhdGE7Zm9yKGxldCB0PTA7dDx1O3QrKyl7Y29uc3Qgcj00KnQsYT1NYXRoLnJvdW5kKGVbdF0qaW50MTYoY1tyXSxjW3IrMV0pKTtjW3JdPWE+PjgmMjU1O2NbcisxXT0yNTUmYTt3cml0ZVNpZ25lZEludDE2KGMscisyLE1hdGgucm91bmQoZVt0XSpzaWduZWRJbnQxNihjW3IrMl0sY1tyKzNdKSkpfX1sZXQgZD11KzEsZj0hMDtpZihkPjY1NTM1KXtmPSExO2Q9dTt3YXJuKCJOb3QgZW5vdWdoIHNwYWNlIGluIGdseWZzIHRvIGR1cGxpY2F0ZSBmaXJzdCBnbHlwaC4iKX1sZXQgZz0wLHA9MDtpZihoPj02NTUzNiYmcy5tYXhwLmxlbmd0aD49MzIpe3QucG9zKz04O2lmKHQuZ2V0VWludDE2KCk+Mil7cy5tYXhwLmRhdGFbMTRdPTA7cy5tYXhwLmRhdGFbMTVdPTJ9dC5wb3MrPTQ7Zz10LmdldFVpbnQxNigpO3QucG9zKz00O3A9dC5nZXRVaW50MTYoKX1zLm1heHAuZGF0YVs0XT1kPj44O3MubWF4cC5kYXRhWzVdPTI1NSZkO2NvbnN0IG09ZnVuY3Rpb24gc2FuaXRpemVUVFByb2dyYW1zKGUsdCxyLGEpe2NvbnN0IG49e2Z1bmN0aW9uc0RlZmluZWQ6W10sZnVuY3Rpb25zVXNlZDpbXSxmdW5jdGlvbnNTdGFja0RlbHRhczpbXSx0b29Db21wbGV4VG9Gb2xsb3dGdW5jdGlvbnM6ITEsaGludHNWYWxpZDohMH07ZSYmc2FuaXRpemVUVFByb2dyYW0oZSxuKTt0JiZzYW5pdGl6ZVRUUHJvZ3JhbSh0LG4pO2UmJmZ1bmN0aW9uIGNoZWNrSW52YWxpZEZ1bmN0aW9ucyhlLHQpe2lmKCFlLnRvb0NvbXBsZXhUb0ZvbGxvd0Z1bmN0aW9ucylpZihlLmZ1bmN0aW9uc0RlZmluZWQubGVuZ3RoPnQpe3dhcm4oIlRUOiBtb3JlIGZ1bmN0aW9ucyBkZWZpbmVkIHRoYW4gZXhwZWN0ZWQiKTtlLmhpbnRzVmFsaWQ9ITF9ZWxzZSBmb3IobGV0IHI9MCxhPWUuZnVuY3Rpb25zVXNlZC5sZW5ndGg7cjxhO3IrKyl7aWYocj50KXt3YXJuKCJUVDogaW52YWxpZCBmdW5jdGlvbiBpZDogIityKTtlLmhpbnRzVmFsaWQ9ITE7cmV0dXJufWlmKGUuZnVuY3Rpb25zVXNlZFtyXSYmIWUuZnVuY3Rpb25zRGVmaW5lZFtyXSl7d2FybigiVFQ6IHVuZGVmaW5lZCBmdW5jdGlvbjogIityKTtlLmhpbnRzVmFsaWQ9ITE7cmV0dXJufX19KG4sYSk7aWYociYmMSZyLmxlbmd0aCl7Y29uc3QgZT1uZXcgVWludDhBcnJheShyLmxlbmd0aCsxKTtlLnNldChyLmRhdGEpO3IuZGF0YT1lfXJldHVybiBuLmhpbnRzVmFsaWR9KHMuZnBnbSxzLnByZXAsc1siY3Z0ICJdLGcpO2lmKCFtKXtkZWxldGUgcy5mcGdtO2RlbGV0ZSBzLnByZXA7ZGVsZXRlIHNbImN2dCAiXX0hZnVuY3Rpb24gc2FuaXRpemVNZXRyaWNzKGUsdCxyLGEsbixpKXtpZighdCl7ciYmKHIuZGF0YT1udWxsKTtyZXR1cm59ZS5wb3M9KGUuc3RhcnR8fDApK3Qub2Zmc2V0O2UucG9zKz00O2UucG9zKz0yO2UucG9zKz0yO2UucG9zKz0yO2UucG9zKz0yO2UucG9zKz0yO2UucG9zKz0yO2UucG9zKz0yO2UucG9zKz0yO2UucG9zKz0yO2NvbnN0IHM9ZS5nZXRVaW50MTYoKTtlLnBvcys9ODtlLnBvcys9MjtsZXQgbz1lLmdldFVpbnQxNigpO2lmKDAhPT1zKXtpZighKDImaW50MTYoYS5kYXRhWzQ0XSxhLmRhdGFbNDVdKSkpe3QuZGF0YVsyMl09MDt0LmRhdGFbMjNdPTB9fWlmKG8+bil7aW5mbyhgVGhlIG51bU9mTWV0cmljcyAoJHtvfSkgc2hvdWxkIG5vdCBiZSBncmVhdGVyIHRoYW4gdGhlIG51bUdseXBocyAoJHtufSkuYCk7bz1uO3QuZGF0YVszNF09KDY1MjgwJm8pPj44O3QuZGF0YVszNV09MjU1Jm99Y29uc3QgYz1uLW8tKHIubGVuZ3RoLTQqbz4+MSk7aWYoYz4wKXtjb25zdCBlPW5ldyBVaW50OEFycmF5KHIubGVuZ3RoKzIqYyk7ZS5zZXQoci5kYXRhKTtpZihpKXtlW3IubGVuZ3RoXT1yLmRhdGFbMl07ZVtyLmxlbmd0aCsxXT1yLmRhdGFbM119ci5kYXRhPWV9fSh0LHMuaGhlYSxzLmhtdHgscy5oZWFkLGQsZik7aWYoIXMuaGVhZCl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoJ1JlcXVpcmVkICJoZWFkIiB0YWJsZSBpcyBub3QgZm91bmQnKTshZnVuY3Rpb24gc2FuaXRpemVIZWFkKGUsdCxyKXtjb25zdCBhPWUuZGF0YSxuPWZ1bmN0aW9uIGludDMyKGUsdCxyLGEpe3JldHVybihlPDwyNCkrKHQ8PDE2KSsocjw8OCkrYX0oYVswXSxhWzFdLGFbMl0sYVszXSk7aWYobj4+MTYhPTEpe2luZm8oIkF0dGVtcHRpbmcgdG8gZml4IGludmFsaWQgdmVyc2lvbiBpbiBoZWFkIHRhYmxlOiAiK24pO2FbMF09MDthWzFdPTE7YVsyXT0wO2FbM109MH1jb25zdCBpPWludDE2KGFbNTBdLGFbNTFdKTtpZihpPDB8fGk+MSl7aW5mbygiQXR0ZW1wdGluZyB0byBmaXggaW52YWxpZCBpbmRleFRvTG9jRm9ybWF0IGluIGhlYWQgdGFibGU6ICIraSk7Y29uc3QgZT10KzE7aWYocj09PWU8PDEpe2FbNTBdPTA7YVs1MV09MH1lbHNle2lmKHIhPT1lPDwyKXRocm93IG5ldyBGb3JtYXRFcnJvcigiQ291bGQgbm90IGZpeCBpbmRleFRvTG9jRm9ybWF0OiAiK2kpO2FbNTBdPTA7YVs1MV09MX19fShzLmhlYWQsdSxsP3MubG9jYS5sZW5ndGg6MCk7bGV0IGI9T2JqZWN0LmNyZWF0ZShudWxsKTtpZihsKXtjb25zdCBlPWludDE2KHMuaGVhZC5kYXRhWzUwXSxzLmhlYWQuZGF0YVs1MV0pLHQ9ZnVuY3Rpb24gc2FuaXRpemVHbHlwaExvY2F0aW9ucyhlLHQscixhLG4saSxzKXtsZXQgbyxjLGw7aWYoYSl7bz00O2M9ZnVuY3Rpb24gZm9udEl0ZW1EZWNvZGVMb25nKGUsdCl7cmV0dXJuIGVbdF08PDI0fGVbdCsxXTw8MTZ8ZVt0KzJdPDw4fGVbdCszXX07bD1mdW5jdGlvbiBmb250SXRlbUVuY29kZUxvbmcoZSx0LHIpe2VbdF09cj4+PjI0JjI1NTtlW3QrMV09cj4+MTYmMjU1O2VbdCsyXT1yPj44JjI1NTtlW3QrM109MjU1JnJ9fWVsc2V7bz0yO2M9ZnVuY3Rpb24gZm9udEl0ZW1EZWNvZGUoZSx0KXtyZXR1cm4gZVt0XTw8OXxlW3QrMV08PDF9O2w9ZnVuY3Rpb24gZm9udEl0ZW1FbmNvZGUoZSx0LHIpe2VbdF09cj4+OSYyNTU7ZVt0KzFdPXI+PjEmMjU1fX1jb25zdCBoPWk/cisxOnIsdT1vKigxK2gpLGQ9bmV3IFVpbnQ4QXJyYXkodSk7ZC5zZXQoZS5kYXRhLnN1YmFycmF5KDAsdSkpO2UuZGF0YT1kO2NvbnN0IGY9dC5kYXRhLGc9Zi5sZW5ndGgscD1uZXcgVWludDhBcnJheShnKTtsZXQgbSxiO2NvbnN0IHk9W107Zm9yKG09MCxiPTA7bTxyKzE7bSsrLGIrPW8pe2xldCBlPWMoZCxiKTtlPmcmJihlPWcpO3kucHVzaCh7aW5kZXg6bSxvZmZzZXQ6ZSxlbmRPZmZzZXQ6MH0pfXkuc29ydCgoZSx0KT0+ZS5vZmZzZXQtdC5vZmZzZXQpO2ZvcihtPTA7bTxyO20rKyl5W21dLmVuZE9mZnNldD15W20rMV0ub2Zmc2V0O3kuc29ydCgoZSx0KT0+ZS5pbmRleC10LmluZGV4KTtmb3IobT0wO208cjttKyspe2NvbnN0e29mZnNldDplLGVuZE9mZnNldDp0fT15W21dO2lmKDAhPT1lfHwwIT09dClicmVhaztjb25zdCByPXlbbSsxXS5vZmZzZXQ7aWYoMCE9PXIpe3lbbV0uZW5kT2Zmc2V0PXI7YnJlYWt9fWNvbnN0IHc9eS5hdCgtMik7MCE9PXcub2Zmc2V0JiYwPT09dy5lbmRPZmZzZXQmJih3LmVuZE9mZnNldD1nKTtjb25zdCB4PU9iamVjdC5jcmVhdGUobnVsbCk7bGV0IFM9MDtsKGQsMCxTKTtmb3IobT0wLGI9bzttPHI7bSsrLGIrPW8pe2NvbnN0IGU9c2FuaXRpemVHbHlwaChmLHlbbV0ub2Zmc2V0LHlbbV0uZW5kT2Zmc2V0LHAsUyxuKSx0PWUubGVuZ3RoOzA9PT10JiYoeFttXT0hMCk7ZS5zaXplT2ZJbnN0cnVjdGlvbnM+cyYmKHM9ZS5zaXplT2ZJbnN0cnVjdGlvbnMpO1MrPXQ7bChkLGIsUyl9aWYoMD09PVMpe2NvbnN0IGU9bmV3IFVpbnQ4QXJyYXkoWzAsMSwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCw0OSwwXSk7Zm9yKG09MCxiPW87bTxoO20rKyxiKz1vKWwoZCxiLGUubGVuZ3RoKTt0LmRhdGE9ZX1lbHNlIGlmKGkpe2NvbnN0IHI9YyhkLG8pO2lmKHAubGVuZ3RoPnIrUyl0LmRhdGE9cC5zdWJhcnJheSgwLHIrUyk7ZWxzZXt0LmRhdGE9bmV3IFVpbnQ4QXJyYXkocitTKTt0LmRhdGEuc2V0KHAuc3ViYXJyYXkoMCxTKSl9dC5kYXRhLnNldChwLnN1YmFycmF5KDAsciksUyk7bChlLmRhdGEsZC5sZW5ndGgtbyxTK3IpfWVsc2UgdC5kYXRhPXAuc3ViYXJyYXkoMCxTKTtyZXR1cm57bWlzc2luZ0dseXBoczp4LG1heFNpemVPZkluc3RydWN0aW9uczpzfX0ocy5sb2NhLHMuZ2x5Zix1LGUsbSxmLHApO2I9dC5taXNzaW5nR2x5cGhzO2lmKGg+PTY1NTM2JiZzLm1heHAubGVuZ3RoPj0zMil7cy5tYXhwLmRhdGFbMjZdPXQubWF4U2l6ZU9mSW5zdHJ1Y3Rpb25zPj44O3MubWF4cC5kYXRhWzI3XT0yNTUmdC5tYXhTaXplT2ZJbnN0cnVjdGlvbnN9fWlmKCFzLmhoZWEpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCdSZXF1aXJlZCAiaGhlYSIgdGFibGUgaXMgbm90IGZvdW5kJyk7aWYoMD09PXMuaGhlYS5kYXRhWzEwXSYmMD09PXMuaGhlYS5kYXRhWzExXSl7cy5oaGVhLmRhdGFbMTBdPTI1NTtzLmhoZWEuZGF0YVsxMV09MjU1fWNvbnN0IHk9e3VuaXRzUGVyRW06aW50MTYocy5oZWFkLmRhdGFbMThdLHMuaGVhZC5kYXRhWzE5XSkseU1heDpzaWduZWRJbnQxNihzLmhlYWQuZGF0YVs0Ml0scy5oZWFkLmRhdGFbNDNdKSx5TWluOnNpZ25lZEludDE2KHMuaGVhZC5kYXRhWzM4XSxzLmhlYWQuZGF0YVszOV0pLGFzY2VudDpzaWduZWRJbnQxNihzLmhoZWEuZGF0YVs0XSxzLmhoZWEuZGF0YVs1XSksZGVzY2VudDpzaWduZWRJbnQxNihzLmhoZWEuZGF0YVs2XSxzLmhoZWEuZGF0YVs3XSksbGluZUdhcDpzaWduZWRJbnQxNihzLmhoZWEuZGF0YVs4XSxzLmhoZWEuZGF0YVs5XSl9O3RoaXMuYXNjZW50PXkuYXNjZW50L3kudW5pdHNQZXJFbTt0aGlzLmRlc2NlbnQ9eS5kZXNjZW50L3kudW5pdHNQZXJFbTt0aGlzLmxpbmVHYXA9eS5saW5lR2FwL3kudW5pdHNQZXJFbTtpZih0aGlzLmNzc0ZvbnRJbmZvPy5saW5lSGVpZ2h0KXt0aGlzLmxpbmVIZWlnaHQ9dGhpcy5jc3NGb250SW5mby5tZXRyaWNzLmxpbmVIZWlnaHQ7dGhpcy5saW5lR2FwPXRoaXMuY3NzRm9udEluZm8ubWV0cmljcy5saW5lR2FwfWVsc2UgdGhpcy5saW5lSGVpZ2h0PXRoaXMuYXNjZW50LXRoaXMuZGVzY2VudCt0aGlzLmxpbmVHYXA7cy5wb3N0JiZmdW5jdGlvbiByZWFkUG9zdFNjcmlwdFRhYmxlKGUscixhKXtjb25zdCBuPSh0LnN0YXJ0fHwwKStlLm9mZnNldDt0LnBvcz1uO2NvbnN0IGk9bitlLmxlbmd0aCxzPXQuZ2V0SW50MzIoKTt0LnNraXAoMjgpO2xldCBvLGMsbD0hMDtzd2l0Y2gocyl7Y2FzZSA2NTUzNjpvPXZhO2JyZWFrO2Nhc2UgMTMxMDcyOmNvbnN0IGU9dC5nZXRVaW50MTYoKTtpZihlIT09YSl7bD0hMTticmVha31jb25zdCBuPVtdO2ZvcihjPTA7YzxlOysrYyl7Y29uc3QgZT10LmdldFVpbnQxNigpO2lmKGU+PTMyNzY4KXtsPSExO2JyZWFrfW4ucHVzaChlKX1pZighbClicmVhaztjb25zdCBoPVtdLHU9W107Zm9yKDt0LnBvczxpOyl7Y29uc3QgZT10LmdldEJ5dGUoKTt1Lmxlbmd0aD1lO2ZvcihjPTA7YzxlOysrYyl1W2NdPVN0cmluZy5mcm9tQ2hhckNvZGUodC5nZXRCeXRlKCkpO2gucHVzaCh1LmpvaW4oIiIpKX1vPVtdO2ZvcihjPTA7YzxlOysrYyl7Y29uc3QgZT1uW2NdO2U8MjU4P28ucHVzaCh2YVtlXSk6by5wdXNoKGhbZS0yNThdKX1icmVhaztjYXNlIDE5NjYwODpicmVhaztkZWZhdWx0Ondhcm4oIlVua25vd24vdW5zdXBwb3J0ZWQgcG9zdCB0YWJsZSB2ZXJzaW9uICIrcyk7bD0hMTtyLmRlZmF1bHRFbmNvZGluZyYmKG89ci5kZWZhdWx0RW5jb2RpbmcpfXIuZ2x5cGhOYW1lcz1vO3JldHVybiBsfShzLnBvc3Qscix1KTtzLnBvc3Q9e3RhZzoicG9zdCIsZGF0YTpjcmVhdGVQb3N0VGFibGUocil9O2NvbnN0IHc9T2JqZWN0LmNyZWF0ZShudWxsKTtmdW5jdGlvbiBoYXNHbHlwaChlKXtyZXR1cm4hYltlXX1pZihyLmNvbXBvc2l0ZSl7Y29uc3QgZT1yLmNpZFRvR2lkTWFwfHxbXSx0PTA9PT1lLmxlbmd0aDtyLmNNYXAuZm9yRWFjaChmdW5jdGlvbihyLGEpeyJzdHJpbmciPT10eXBlb2YgYSYmKGE9Y29udmVydENpZFN0cmluZyhyLGEsITApKTtpZihhPjY1NTM1KXRocm93IG5ldyBGb3JtYXRFcnJvcigiTWF4IHNpemUgb2YgQ0lEIGlzIDY1LDUzNSIpO2xldCBuPS0xO3Q/bj1hOnZvaWQgMCE9PWVbYV0mJihuPWVbYV0pO24+PTAmJm48dSYmaGFzR2x5cGgobikmJih3W3JdPW4pfSl9ZWxzZXtjb25zdCBlPWZ1bmN0aW9uIHJlYWRDbWFwVGFibGUoZSx0LHIsYSl7aWYoIWUpe3dhcm4oIk5vIGNtYXAgdGFibGUgYXZhaWxhYmxlLiIpO3JldHVybntwbGF0Zm9ybUlkOi0xLGVuY29kaW5nSWQ6LTEsbWFwcGluZ3M6W10saGFzU2hvcnRDbWFwOiExfX1sZXQgbixpPSh0LnN0YXJ0fHwwKStlLm9mZnNldDt0LnBvcz1pO3Quc2tpcCgyKTtjb25zdCBzPXQuZ2V0VWludDE2KCk7bGV0IG8sYz0hMTtmb3IobGV0IGU9MDtlPHM7ZSsrKXtjb25zdCBuPXQuZ2V0VWludDE2KCksaT10LmdldFVpbnQxNigpLGw9dC5nZXRJbnQzMigpPj4+MDtsZXQgaD0hMTtpZihvPy5wbGF0Zm9ybUlkIT09bnx8bz8uZW5jb2RpbmdJZCE9PWkpe2lmKDAhPT1ufHwwIT09aSYmMSE9PWkmJjMhPT1pKWlmKDE9PT1uJiYwPT09aSloPSEwO2Vsc2UgaWYoMyE9PW58fDEhPT1pfHwhYSYmbyl7aWYociYmMz09PW4mJjA9PT1pKXtoPSEwO2xldCByPSEwO2lmKGU8cy0xKXtjb25zdCBlPXQucGVla0J5dGVzKDIpO2ludDE2KGVbMF0sZVsxXSk8biYmKHI9ITEpfXImJihjPSEwKX19ZWxzZXtoPSEwO3J8fChjPSEwKX1lbHNlIGg9ITA7aCYmKG89e3BsYXRmb3JtSWQ6bixlbmNvZGluZ0lkOmksb2Zmc2V0Omx9KTtpZihjKWJyZWFrfX1vJiYodC5wb3M9aStvLm9mZnNldCk7aWYoIW98fC0xPT09dC5wZWVrQnl0ZSgpKXt3YXJuKCJDb3VsZCBub3QgZmluZCBhIHByZWZlcnJlZCBjbWFwIHRhYmxlLiIpO3JldHVybntwbGF0Zm9ybUlkOi0xLGVuY29kaW5nSWQ6LTEsbWFwcGluZ3M6W10saGFzU2hvcnRDbWFwOiExfX1jb25zdCBsPXQuZ2V0VWludDE2KCk7bGV0IGg9ITE7Y29uc3QgdT1bXTtsZXQgZCxmO2lmKDA9PT1sKXt0LnNraXAoNCk7Zm9yKGQ9MDtkPDI1NjtkKyspe2NvbnN0IGU9dC5nZXRCeXRlKCk7ZSYmdS5wdXNoKHtjaGFyQ29kZTpkLGdseXBoSWQ6ZX0pfWg9ITB9ZWxzZSBpZigyPT09bCl7dC5za2lwKDQpO2NvbnN0IGU9W107bGV0IHI9MDtmb3IobGV0IGE9MDthPDI1NjthKyspe2NvbnN0IGE9dC5nZXRVaW50MTYoKT4+MztlLnB1c2goYSk7cj1NYXRoLm1heChhLHIpfWNvbnN0IGE9W107Zm9yKGxldCBlPTA7ZTw9cjtlKyspYS5wdXNoKHtmaXJzdENvZGU6dC5nZXRVaW50MTYoKSxlbnRyeUNvdW50OnQuZ2V0VWludDE2KCksaWREZWx0YTpzaWduZWRJbnQxNih0LmdldEJ5dGUoKSx0LmdldEJ5dGUoKSksaWRSYW5nZVBvczp0LnBvcyt0LmdldFVpbnQxNigpfSk7Zm9yKGxldCByPTA7cjwyNTY7cisrKWlmKDA9PT1lW3JdKXt0LnBvcz1hWzBdLmlkUmFuZ2VQb3MrMipyO2Y9dC5nZXRVaW50MTYoKTt1LnB1c2goe2NoYXJDb2RlOnIsZ2x5cGhJZDpmfSl9ZWxzZXtjb25zdCBuPWFbZVtyXV07Zm9yKGQ9MDtkPG4uZW50cnlDb3VudDtkKyspe2NvbnN0IGU9KHI8PDgpK2Qrbi5maXJzdENvZGU7dC5wb3M9bi5pZFJhbmdlUG9zKzIqZDtmPXQuZ2V0VWludDE2KCk7MCE9PWYmJihmPShmK24uaWREZWx0YSklNjU1MzYpO3UucHVzaCh7Y2hhckNvZGU6ZSxnbHlwaElkOmZ9KX19fWVsc2UgaWYoND09PWwpe3Quc2tpcCg0KTtjb25zdCBlPXQuZ2V0VWludDE2KCk+PjE7dC5za2lwKDYpO2NvbnN0IHI9W107bGV0IGE7Zm9yKGE9MDthPGU7YSsrKXIucHVzaCh7ZW5kOnQuZ2V0VWludDE2KCl9KTt0LnNraXAoMik7Zm9yKGE9MDthPGU7YSsrKXJbYV0uc3RhcnQ9dC5nZXRVaW50MTYoKTtmb3IoYT0wO2E8ZTthKyspclthXS5kZWx0YT10LmdldFVpbnQxNigpO2xldCBzLG89MDtmb3IoYT0wO2E8ZTthKyspe249clthXTtjb25zdCBpPXQuZ2V0VWludDE2KCk7aWYoaSl7cz0oaT4+MSktKGUtYSk7bi5vZmZzZXRJbmRleD1zO289TWF0aC5tYXgobyxzK24uZW5kLW4uc3RhcnQrMSl9ZWxzZSBuLm9mZnNldEluZGV4PS0xfWNvbnN0IGM9W107Zm9yKGQ9MDtkPG87ZCsrKWMucHVzaCh0LmdldFVpbnQxNigpKTtmb3IoYT0wO2E8ZTthKyspe249clthXTtpPW4uc3RhcnQ7Y29uc3QgZT1uLmVuZCx0PW4uZGVsdGE7cz1uLm9mZnNldEluZGV4O2ZvcihkPWk7ZDw9ZTtkKyspaWYoNjU1MzUhPT1kKXtmPXM8MD9kOmNbcytkLWldO2Y9Zit0JjY1NTM1O3UucHVzaCh7Y2hhckNvZGU6ZCxnbHlwaElkOmZ9KX19fWVsc2UgaWYoNj09PWwpe3Quc2tpcCg0KTtjb25zdCBlPXQuZ2V0VWludDE2KCkscj10LmdldFVpbnQxNigpO2ZvcihkPTA7ZDxyO2QrKyl7Zj10LmdldFVpbnQxNigpO2NvbnN0IHI9ZStkO3UucHVzaCh7Y2hhckNvZGU6cixnbHlwaElkOmZ9KX19ZWxzZXtpZigxMiE9PWwpe3dhcm4oImNtYXAgdGFibGUgaGFzIHVuc3VwcG9ydGVkIGZvcm1hdDogIitsKTtyZXR1cm57cGxhdGZvcm1JZDotMSxlbmNvZGluZ0lkOi0xLG1hcHBpbmdzOltdLGhhc1Nob3J0Q21hcDohMX19e3Quc2tpcCgxMCk7Y29uc3QgZT10LmdldEludDMyKCk+Pj4wO2ZvcihkPTA7ZDxlO2QrKyl7Y29uc3QgZT10LmdldEludDMyKCk+Pj4wLHI9dC5nZXRJbnQzMigpPj4+MDtsZXQgYT10LmdldEludDMyKCk+Pj4wO2ZvcihsZXQgdD1lO3Q8PXI7dCsrKXUucHVzaCh7Y2hhckNvZGU6dCxnbHlwaElkOmErK30pfX19dS5zb3J0KChlLHQpPT5lLmNoYXJDb2RlLXQuY2hhckNvZGUpO2NvbnN0IGc9W10scD1uZXcgU2V0O2Zvcihjb25zdCBlIG9mIHUpe2NvbnN0e2NoYXJDb2RlOnR9PWU7aWYoIXAuaGFzKHQpKXtwLmFkZCh0KTtnLnB1c2goZSl9fXJldHVybntwbGF0Zm9ybUlkOm8ucGxhdGZvcm1JZCxlbmNvZGluZ0lkOm8uZW5jb2RpbmdJZCxtYXBwaW5nczpnLGhhc1Nob3J0Q21hcDpofX0ocy5jbWFwLHQsdGhpcy5pc1N5bWJvbGljRm9udCxyLmhhc0VuY29kaW5nKSxhPWUucGxhdGZvcm1JZCxuPWUuZW5jb2RpbmdJZCxpPWUubWFwcGluZ3M7bGV0IG89W10sYz0hMTshci5oYXNFbmNvZGluZ3x8Ik1hY1JvbWFuRW5jb2RpbmciIT09ci5iYXNlRW5jb2RpbmdOYW1lJiYiV2luQW5zaUVuY29kaW5nIiE9PXIuYmFzZUVuY29kaW5nTmFtZXx8KG89Z2V0RW5jb2Rpbmcoci5iYXNlRW5jb2RpbmdOYW1lKSk7aWYoci5oYXNFbmNvZGluZyYmIXRoaXMuaXNTeW1ib2xpY0ZvbnQmJigzPT09YSYmMT09PW58fDE9PT1hJiYwPT09bikpe2NvbnN0IGU9Z2EoKTtmb3IobGV0IHQ9MDt0PDI1Njt0Kyspe2xldCBzO3M9dm9pZCAwIT09dGhpcy5kaWZmZXJlbmNlc1t0XT90aGlzLmRpZmZlcmVuY2VzW3RdOm8ubGVuZ3RoJiYiIiE9PW9bdF0/b1t0XTpoYVt0XTtpZighcyljb250aW51ZTtjb25zdCBjPXJlY292ZXJHbHlwaE5hbWUocyxlKTtsZXQgbDszPT09YSYmMT09PW4/bD1lW2NdOjE9PT1hJiYwPT09biYmKGw9bGEuaW5kZXhPZihjKSk7aWYodm9pZCAwPT09bCl7aWYoIXIuZ2x5cGhOYW1lcyYmci5oYXNJbmNsdWRlZFRvVW5pY29kZU1hcCYmISh0aGlzLnRvVW5pY29kZSBpbnN0YW5jZW9mIElkZW50aXR5VG9Vbmljb2RlTWFwKSl7Y29uc3QgZT10aGlzLnRvVW5pY29kZS5nZXQodCk7ZSYmKGw9ZS5jb2RlUG9pbnRBdCgwKSl9aWYodm9pZCAwPT09bCljb250aW51ZX1mb3IoY29uc3QgZSBvZiBpKWlmKGUuY2hhckNvZGU9PT1sKXt3W3RdPWUuZ2x5cGhJZDticmVha319fWVsc2UgaWYoMD09PWEpe2Zvcihjb25zdCBlIG9mIGkpd1tlLmNoYXJDb2RlXT1lLmdseXBoSWQ7Yz0hMH1lbHNlIGlmKDM9PT1hJiYwPT09bilmb3IoY29uc3QgZSBvZiBpKXtsZXQgdD1lLmNoYXJDb2RlO3Q+PTYxNDQwJiZ0PD02MTY5NSYmKHQmPTI1NSk7d1t0XT1lLmdseXBoSWR9ZWxzZSBmb3IoY29uc3QgZSBvZiBpKXdbZS5jaGFyQ29kZV09ZS5nbHlwaElkO2lmKHIuZ2x5cGhOYW1lcyYmKG8ubGVuZ3RofHx0aGlzLmRpZmZlcmVuY2VzLmxlbmd0aCkpZm9yKGxldCBlPTA7ZTwyNTY7KytlKXtpZighYyYmdm9pZCAwIT09d1tlXSljb250aW51ZTtjb25zdCB0PXRoaXMuZGlmZmVyZW5jZXNbZV18fG9bZV07aWYoIXQpY29udGludWU7Y29uc3QgYT1yLmdseXBoTmFtZXMuaW5kZXhPZih0KTthPjAmJmhhc0dseXBoKGEpJiYod1tlXT1hKX19MD09PXcubGVuZ3RoJiYod1swXT0wKTtsZXQgeD1kLTE7Znx8KHg9MCk7aWYoIXIuY3NzRm9udEluZm8pe2NvbnN0IGU9YWRqdXN0TWFwcGluZyh3LGhhc0dseXBoLHgsdGhpcy50b1VuaWNvZGUpO3RoaXMudG9Gb250Q2hhcj1lLnRvRm9udENoYXI7cy5jbWFwPXt0YWc6ImNtYXAiLGRhdGE6Y3JlYXRlQ21hcFRhYmxlKGUuY2hhckNvZGVUb0dseXBoSWQsZS50b1VuaWNvZGVFeHRyYU1hcCxkKX07c1siT1MvMiJdJiZmdW5jdGlvbiB2YWxpZGF0ZU9TMlRhYmxlKGUsdCl7dC5wb3M9KHQuc3RhcnR8fDApK2Uub2Zmc2V0O2NvbnN0IHI9dC5nZXRVaW50MTYoKTt0LnNraXAoNjApO2NvbnN0IGE9dC5nZXRVaW50MTYoKTtpZihyPDQmJjc2OCZhKXJldHVybiExO2lmKHQuZ2V0VWludDE2KCk+dC5nZXRVaW50MTYoKSlyZXR1cm4hMTt0LnNraXAoNik7aWYoMD09PXQuZ2V0VWludDE2KCkpcmV0dXJuITE7ZS5kYXRhWzhdPWUuZGF0YVs5XT0wO3JldHVybiEwfShzWyJPUy8yIl0sdCl8fChzWyJPUy8yIl09e3RhZzoiT1MvMiIsZGF0YTpjcmVhdGVPUzJUYWJsZShyLGUuY2hhckNvZGVUb0dseXBoSWQseSl9KX1pZighbCl0cnl7Yz1uZXcgU3RyZWFtKHNbIkNGRiAiXS5kYXRhKTtvPW5ldyBDRkZQYXJzZXIoYyxyLHhhKS5wYXJzZSgpO28uZHVwbGljYXRlRmlyc3RHbHlwaCgpO2NvbnN0IGU9bmV3IENGRkNvbXBpbGVyKG8pO3NbIkNGRiAiXS5kYXRhPWUuY29tcGlsZSgpfWNhdGNoe3dhcm4oIkZhaWxlZCB0byBjb21waWxlIGZvbnQgIityLmxvYWRlZE5hbWUpfWlmKHMubmFtZSl7Y29uc3RbdCxhXT1yZWFkTmFtZVRhYmxlKHMubmFtZSk7cy5uYW1lLmRhdGE9Y3JlYXRlTmFtZVRhYmxlKGUsdCk7dGhpcy5wc05hbWU9dFswXVs2XXx8bnVsbDtyLmNvbXBvc2l0ZXx8ZnVuY3Rpb24gYWRqdXN0VHJ1ZVR5cGVUb1VuaWNvZGUoZSx0LHIpe2lmKGUuaXNJbnRlcm5hbEZvbnQpcmV0dXJuO2lmKGUuaGFzSW5jbHVkZWRUb1VuaWNvZGVNYXApcmV0dXJuO2lmKGUuaGFzRW5jb2RpbmcpcmV0dXJuO2lmKGUudG9Vbmljb2RlIGluc3RhbmNlb2YgSWRlbnRpdHlUb1VuaWNvZGVNYXApcmV0dXJuO2lmKCF0KXJldHVybjtpZigwPT09ci5sZW5ndGgpcmV0dXJuO2lmKGUuZGVmYXVsdEVuY29kaW5nPT09dWEpcmV0dXJuO2Zvcihjb25zdCBlIG9mIHIpaWYoIWlzV2luTmFtZVJlY29yZChlKSlyZXR1cm47Y29uc3QgYT11YSxuPVtdLGk9Z2EoKTtmb3IoY29uc3QgZSBpbiBhKXtjb25zdCB0PWFbZV07aWYoIiI9PT10KWNvbnRpbnVlO2NvbnN0IHI9aVt0XTt2b2lkIDAhPT1yJiYobltlXT1TdHJpbmcuZnJvbUNoYXJDb2RlKHIpKX1uLmxlbmd0aD4wJiZlLnRvVW5pY29kZS5hbWVuZChuKX0ocix0aGlzLmlzU3ltYm9saWNGb250LGEpfWVsc2Ugcy5uYW1lPXt0YWc6Im5hbWUiLGRhdGE6Y3JlYXRlTmFtZVRhYmxlKHRoaXMubmFtZSl9O2NvbnN0IFM9bmV3IE9wZW5UeXBlRmlsZUJ1aWxkZXIoaS52ZXJzaW9uKTtmb3IoY29uc3QgZSBpbiBzKVMuYWRkVGFibGUoZSxzW2VdLmRhdGEpO3JldHVybiBTLnRvQXJyYXkoKX1jb252ZXJ0KGUsdCxyKXtyLmZpeGVkUGl0Y2g9ITE7ci5idWlsdEluRW5jb2RpbmcmJmZ1bmN0aW9uIGFkanVzdFR5cGUxVG9Vbmljb2RlKGUsdCl7aWYoZS5pc0ludGVybmFsRm9udClyZXR1cm47aWYoZS5oYXNJbmNsdWRlZFRvVW5pY29kZU1hcClyZXR1cm47aWYodD09PWUuZGVmYXVsdEVuY29kaW5nKXJldHVybjtpZihlLnRvVW5pY29kZSBpbnN0YW5jZW9mIElkZW50aXR5VG9Vbmljb2RlTWFwKXJldHVybjtjb25zdCByPVtdLGE9Z2EoKTtmb3IoY29uc3QgbiBpbiB0KXtpZihlLmhhc0VuY29kaW5nJiYoZS5iYXNlRW5jb2RpbmdOYW1lfHx2b2lkIDAhPT1lLmRpZmZlcmVuY2VzW25dKSljb250aW51ZTtjb25zdCBpPWdldFVuaWNvZGVGb3JHbHlwaCh0W25dLGEpOy0xIT09aSYmKHJbbl09U3RyaW5nLmZyb21DaGFyQ29kZShpKSl9ci5sZW5ndGg+MCYmZS50b1VuaWNvZGUuYW1lbmQocil9KHIsci5idWlsdEluRW5jb2RpbmcpO2xldCBuPTE7dCBpbnN0YW5jZW9mIENGRkZvbnQmJihuPXQubnVtR2x5cGhzLTEpO2NvbnN0IGk9dC5nZXRHbHlwaE1hcHBpbmcocik7bGV0IHM9bnVsbCxvPWksYz1udWxsO2lmKCFyLmNzc0ZvbnRJbmZvKXtzPWFkanVzdE1hcHBpbmcoaSx0Lmhhc0dseXBoSWQuYmluZCh0KSxuLHRoaXMudG9Vbmljb2RlKTt0aGlzLnRvRm9udENoYXI9cy50b0ZvbnRDaGFyO289cy5jaGFyQ29kZVRvR2x5cGhJZDtjPXMudG9Vbmljb2RlRXh0cmFNYXB9Y29uc3QgbD10Lm51bUdseXBocztmdW5jdGlvbiBnZXRDaGFyQ29kZXMoZSx0KXtsZXQgcj1udWxsO2Zvcihjb25zdCBhIGluIGUpdD09PWVbYV0mJihyfHw9W10pLnB1c2goMHxhKTtyZXR1cm4gcn1mdW5jdGlvbiBjcmVhdGVDaGFyQ29kZShlLHQpe2Zvcihjb25zdCByIGluIGUpaWYodD09PWVbcl0pcmV0dXJuIDB8cjtzLmNoYXJDb2RlVG9HbHlwaElkW3MubmV4dEF2YWlsYWJsZUZvbnRDaGFyQ29kZV09dDtyZXR1cm4gcy5uZXh0QXZhaWxhYmxlRm9udENoYXJDb2RlKyt9Y29uc3QgaD10LnNlYWNzO2lmKHMmJmg/Lmxlbmd0aCl7Y29uc3QgZT1yLmZvbnRNYXRyaXh8fGEsbj10LmdldENoYXJzZXQoKSxvPU9iamVjdC5jcmVhdGUobnVsbCk7Zm9yKGxldCB0IGluIGgpe3R8PTA7Y29uc3Qgcj1oW3RdLGE9aGFbclsyXV0sYz1oYVtyWzNdXSxsPW4uaW5kZXhPZihhKSx1PW4uaW5kZXhPZihjKTtpZihsPDB8fHU8MCljb250aW51ZTtjb25zdCBkPXt4OnJbMF0qZVswXStyWzFdKmVbMl0rZVs0XSx5OnJbMF0qZVsxXStyWzFdKmVbM10rZVs1XX0sZj1nZXRDaGFyQ29kZXMoaSx0KTtpZihmKWZvcihjb25zdCBlIG9mIGYpe2NvbnN0IHQ9cy5jaGFyQ29kZVRvR2x5cGhJZCxyPWNyZWF0ZUNoYXJDb2RlKHQsbCksYT1jcmVhdGVDaGFyQ29kZSh0LHUpO29bZV09e2Jhc2VGb250Q2hhckNvZGU6cixhY2NlbnRGb250Q2hhckNvZGU6YSxhY2NlbnRPZmZzZXQ6ZH19fXIuc2VhY01hcD1vfWNvbnN0IHU9ci5mb250TWF0cml4PzEvTWF0aC5tYXgoLi4uci5mb250TWF0cml4LnNsaWNlKDAsNCkubWFwKE1hdGguYWJzKSk6MWUzLGQ9bmV3IE9wZW5UeXBlRmlsZUJ1aWxkZXIoIk9UVE8iKTtkLmFkZFRhYmxlKCJDRkYgIix0LmRhdGEpO2QuYWRkVGFibGUoIk9TLzIiLGNyZWF0ZU9TMlRhYmxlKHIsbykpO2QuYWRkVGFibGUoImNtYXAiLGNyZWF0ZUNtYXBUYWJsZShvLGMsbCkpO2QuYWRkVGFibGUoImhlYWQiLCJcMAFcMFwwXDBcMBBcMFwwXDBcMFwwXw88w7VcMFwwIitzYWZlU3RyaW5nMTYodSkrIlwwXDBcMFwwwp5cdn4nXDBcMFwwXDDCnlx2fidcMFwwIitzYWZlU3RyaW5nMTYoci5kZXNjZW50KSsiD8O/IitzYWZlU3RyaW5nMTYoci5hc2NlbnQpK3N0cmluZzE2KHIuaXRhbGljQW5nbGU/MjowKSsiXDARXDBcMFwwXDBcMFwwIik7ZC5hZGRUYWJsZSgiaGhlYSIsIlwwAVwwXDAiK3NhZmVTdHJpbmcxNihyLmFzY2VudCkrc2FmZVN0cmluZzE2KHIuZGVzY2VudCkrIlwwXDDDv8O/XDBcMFwwXDBcMFwwIitzYWZlU3RyaW5nMTYoci5jYXBIZWlnaHQpK3NhZmVTdHJpbmcxNihNYXRoLnRhbihyLml0YWxpY0FuZ2xlKSpyLnhIZWlnaHQpKyJcMFwwXDBcMFwwXDBcMFwwXDBcMFwwXDAiK3N0cmluZzE2KGwpKTtkLmFkZFRhYmxlKCJobXR4IixmdW5jdGlvbiBmb250RmllbGRzSG10eCgpe2NvbnN0IGU9dC5jaGFyc3RyaW5ncyxyPXQuY2ZmP3QuY2ZmLndpZHRoczpudWxsO2xldCBhPSJcMFwwXDBcMCI7Zm9yKGxldCB0PTEsbj1sO3Q8bjt0Kyspe2xldCBuPTA7aWYoZSl7Y29uc3Qgcj1lW3QtMV07bj0id2lkdGgiaW4gcj9yLndpZHRoOjB9ZWxzZSByJiYobj1NYXRoLmNlaWwoclt0XXx8MCkpO2ErPXN0cmluZzE2KG4pK3N0cmluZzE2KDApfXJldHVybiBhfSgpKTtkLmFkZFRhYmxlKCJtYXhwIiwiXDBcMFBcMCIrc3RyaW5nMTYobCkpO2QuYWRkVGFibGUoIm5hbWUiLGNyZWF0ZU5hbWVUYWJsZShlKSk7ZC5hZGRUYWJsZSgicG9zdCIsY3JlYXRlUG9zdFRhYmxlKHIpKTtyZXR1cm4gZC50b0FycmF5KCl9Z2V0IF9zcGFjZVdpZHRoKCl7Y29uc3QgZT1bInNwYWNlIiwibWludXMiLCJvbmUiLCJpIiwiSSJdO2xldCB0O2Zvcihjb25zdCByIG9mIGUpe2lmKHIgaW4gdGhpcy53aWR0aHMpe3Q9dGhpcy53aWR0aHNbcl07YnJlYWt9Y29uc3QgZT1nYSgpW3JdO2xldCBhPTA7aWYodGhpcy5jb21wb3NpdGUmJnRoaXMuY01hcC5jb250YWlucyhlKSl7YT10aGlzLmNNYXAubG9va3VwKGUpOyJzdHJpbmciPT10eXBlb2YgYSYmKGE9Y29udmVydENpZFN0cmluZyhlLGEpKX0hYSYmdGhpcy50b1VuaWNvZGUmJihhPXRoaXMudG9Vbmljb2RlLmNoYXJDb2RlT2YoZSkpO2E8PTAmJihhPWUpO3Q9dGhpcy53aWR0aHNbYV07aWYodClicmVha31yZXR1cm4gc2hhZG93KHRoaXMsIl9zcGFjZVdpZHRoIix0fHx0aGlzLmRlZmF1bHRXaWR0aCl9X2NoYXJUb0dseXBoKGUsdD0hMSl7bGV0IHIsYSxuLGk9dGhpcy5fZ2x5cGhDYWNoZVtlXTtpZihpPy5pc1NwYWNlPT09dClyZXR1cm4gaTtsZXQgcz1lO2lmKHRoaXMuY01hcD8uY29udGFpbnMoZSkpe3M9dGhpcy5jTWFwLmxvb2t1cChlKTsic3RyaW5nIj09dHlwZW9mIHMmJihzPWNvbnZlcnRDaWRTdHJpbmcoZSxzKSl9YT10aGlzLndpZHRoc1tzXTsibnVtYmVyIiE9dHlwZW9mIGEmJihhPXRoaXMuZGVmYXVsdFdpZHRoKTtjb25zdCBvPXRoaXMudm1ldHJpY3M/LltzXTtsZXQgYz10aGlzLnRvVW5pY29kZS5nZXQoZSl8fGU7Im51bWJlciI9PXR5cGVvZiBjJiYoYz1TdHJpbmcuZnJvbUNoYXJDb2RlKGMpKTtsZXQgbD12b2lkIDAhPT10aGlzLnRvRm9udENoYXJbZV07cj10aGlzLnRvRm9udENoYXJbZV18fGU7aWYodGhpcy5taXNzaW5nRmlsZSl7Y29uc3QgdD10aGlzLmRpZmZlcmVuY2VzW2VdfHx0aGlzLmRlZmF1bHRFbmNvZGluZ1tlXTtpZigoIi5ub3RkZWYiPT09dHx8IiI9PT10KSYmIlR5cGUxIj09PXRoaXMudHlwZSl7cj0zMjtpZigiIj09PXQpe2F8fD10aGlzLl9zcGFjZVdpZHRoO2M9U3RyaW5nLmZyb21DaGFyQ29kZShyKX19cj1mdW5jdGlvbiBtYXBTcGVjaWFsVW5pY29kZVZhbHVlcyhlKXtyZXR1cm4gZT49NjU1MjAmJmU8PTY1NTM1PzA6ZT49NjI5NzYmJmU8PTYzNzQzP21hKClbZV18fGU6MTczPT09ZT80NTplfShyKX10aGlzLmlzVHlwZTNGb250JiYobj1yKTtsZXQgaD1udWxsO2lmKHRoaXMuc2VhY01hcD8uW2VdKXtsPSEwO2NvbnN0IHQ9dGhpcy5zZWFjTWFwW2VdO3I9dC5iYXNlRm9udENoYXJDb2RlO2g9e2ZvbnRDaGFyOlN0cmluZy5mcm9tQ29kZVBvaW50KHQuYWNjZW50Rm9udENoYXJDb2RlKSxvZmZzZXQ6dC5hY2NlbnRPZmZzZXR9fWxldCB1PSIiOyJudW1iZXIiPT10eXBlb2YgciYmKHI8PTExMTQxMTE/dT1TdHJpbmcuZnJvbUNvZGVQb2ludChyKTp3YXJuKGBjaGFyVG9HbHlwaCAtIGludmFsaWQgZm9udENoYXJDb2RlOiAke3J9YCkpO2lmKHRoaXMubWlzc2luZ0ZpbGUmJnRoaXMudmVydGljYWwmJjE9PT11Lmxlbmd0aCl7Y29uc3QgZT1GYSgpW3UuY2hhckNvZGVBdCgwKV07ZSYmKHU9Yz1TdHJpbmcuZnJvbUNoYXJDb2RlKGUpKX1pPW5ldyBmb250c19HbHlwaChlLHUsYyxoLGEsbyxuLHQsbCk7cmV0dXJuIHRoaXMuX2dseXBoQ2FjaGVbZV09aX1jaGFyc1RvR2x5cGhzKGUpe2xldCB0PXRoaXMuX2NoYXJzQ2FjaGVbZV07aWYodClyZXR1cm4gdDt0PVtdO2lmKHRoaXMuY01hcCl7Y29uc3Qgcj1PYmplY3QuY3JlYXRlKG51bGwpLGE9ZS5sZW5ndGg7bGV0IG49MDtmb3IoO248YTspe3RoaXMuY01hcC5yZWFkQ2hhckNvZGUoZSxuLHIpO2NvbnN0e2NoYXJjb2RlOmEsbGVuZ3RoOml9PXI7bis9aTtjb25zdCBzPXRoaXMuX2NoYXJUb0dseXBoKGEsMT09PWkmJjMyPT09ZS5jaGFyQ29kZUF0KG4tMSkpO3QucHVzaChzKX19ZWxzZSBmb3IobGV0IHI9MCxhPWUubGVuZ3RoO3I8YTsrK3Ipe2NvbnN0IGE9ZS5jaGFyQ29kZUF0KHIpLG49dGhpcy5fY2hhclRvR2x5cGgoYSwzMj09PWEpO3QucHVzaChuKX1yZXR1cm4gdGhpcy5fY2hhcnNDYWNoZVtlXT10fWdldENoYXJQb3NpdGlvbnMoZSl7Y29uc3QgdD1bXTtpZih0aGlzLmNNYXApe2NvbnN0IHI9T2JqZWN0LmNyZWF0ZShudWxsKTtsZXQgYT0wO2Zvcig7YTxlLmxlbmd0aDspe3RoaXMuY01hcC5yZWFkQ2hhckNvZGUoZSxhLHIpO2NvbnN0IG49ci5sZW5ndGg7dC5wdXNoKFthLGErbl0pO2ErPW59fWVsc2UgZm9yKGxldCByPTAsYT1lLmxlbmd0aDtyPGE7KytyKXQucHVzaChbcixyKzFdKTtyZXR1cm4gdH1nZXQgZ2x5cGhDYWNoZVZhbHVlcygpe3JldHVybiBPYmplY3QudmFsdWVzKHRoaXMuX2dseXBoQ2FjaGUpfWVuY29kZVN0cmluZyhlKXtjb25zdCB0PVtdLHI9W10saGFzQ3VycmVudEJ1ZkVycm9ycz0oKT0+dC5sZW5ndGglMj09MSxhPXRoaXMudG9Vbmljb2RlIGluc3RhbmNlb2YgSWRlbnRpdHlUb1VuaWNvZGVNYXA/ZT0+dGhpcy50b1VuaWNvZGUuY2hhckNvZGVPZihlKTplPT50aGlzLnRvVW5pY29kZS5jaGFyQ29kZU9mKFN0cmluZy5mcm9tQ29kZVBvaW50KGUpKTtmb3IobGV0IG49MCxpPWUubGVuZ3RoO248aTtuKyspe2NvbnN0IGk9ZS5jb2RlUG9pbnRBdChuKTtpPjU1Mjk1JiYoaTw1NzM0NHx8aT42NTUzMykmJm4rKztpZih0aGlzLnRvVW5pY29kZSl7Y29uc3QgZT1hKGkpO2lmKC0xIT09ZSl7aWYoaGFzQ3VycmVudEJ1ZkVycm9ycygpKXt0LnB1c2goci5qb2luKCIiKSk7ci5sZW5ndGg9MH1mb3IobGV0IHQ9KHRoaXMuY01hcD90aGlzLmNNYXAuZ2V0Q2hhckNvZGVMZW5ndGgoZSk6MSktMTt0Pj0wO3QtLSlyLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShlPj44KnQmMjU1KSk7Y29udGludWV9fWlmKCFoYXNDdXJyZW50QnVmRXJyb3JzKCkpe3QucHVzaChyLmpvaW4oIiIpKTtyLmxlbmd0aD0wfXIucHVzaChTdHJpbmcuZnJvbUNvZGVQb2ludChpKSl9dC5wdXNoKHIuam9pbigiIikpO3JldHVybiB0fX1jbGFzcyBFcnJvckZvbnR7Y29uc3RydWN0b3IoZSl7dGhpcy5lcnJvcj1lO3RoaXMubG9hZGVkTmFtZT0iZ19mb250X2Vycm9yIjt0aGlzLm1pc3NpbmdGaWxlPSEwfWNoYXJzVG9HbHlwaHMoKXtyZXR1cm5bXX1lbmNvZGVTdHJpbmcoZSl7cmV0dXJuW2VdfWV4cG9ydERhdGEoKXtyZXR1cm57ZXJyb3I6dGhpcy5lcnJvcn19fWNvbnN0IGxuPTIsaG49Myx1bj00LGRuPTUsZm49Nixnbj03O2NsYXNzIFBhdHRlcm57Y29uc3RydWN0b3IoKXt1bnJlYWNoYWJsZSgiQ2Fubm90IGluaXRpYWxpemUgUGF0dGVybi4iKX1zdGF0aWMgcGFyc2VTaGFkaW5nKGUsdCxyLGEsbixpKXtjb25zdCBzPWUgaW5zdGFuY2VvZiBCYXNlU3RyZWFtP2UuZGljdDplLG89cy5nZXQoIlNoYWRpbmdUeXBlIik7dHJ5e3N3aXRjaChvKXtjYXNlIGxuOmNhc2UgaG46cmV0dXJuIG5ldyBSYWRpYWxBeGlhbFNoYWRpbmcocyx0LHIsYSxuLGkpO2Nhc2UgdW46Y2FzZSBkbjpjYXNlIGZuOmNhc2UgZ246cmV0dXJuIG5ldyBNZXNoU2hhZGluZyhlLHQscixhLG4saSk7ZGVmYXVsdDp0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlVuc3VwcG9ydGVkIFNoYWRpbmdUeXBlOiAiK28pfX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgTWlzc2luZ0RhdGFFeGNlcHRpb24pdGhyb3cgZTt3YXJuKGUpO3JldHVybiBuZXcgRHVtbXlTaGFkaW5nfX19Y2xhc3MgQmFzZVNoYWRpbmd7c3RhdGljIFNNQUxMX05VTUJFUj0xZS02O2dldElSKCl7dW5yZWFjaGFibGUoIkFic3RyYWN0IG1ldGhvZCBgZ2V0SVJgIGNhbGxlZC4iKX19Y2xhc3MgUmFkaWFsQXhpYWxTaGFkaW5nIGV4dGVuZHMgQmFzZVNoYWRpbmd7Y29uc3RydWN0b3IoZSx0LHIsYSxuLGkpe3N1cGVyKCk7dGhpcy5zaGFkaW5nVHlwZT1lLmdldCgiU2hhZGluZ1R5cGUiKTtsZXQgcz0wO3RoaXMuc2hhZGluZ1R5cGU9PT1sbj9zPTQ6dGhpcy5zaGFkaW5nVHlwZT09PWhuJiYocz02KTt0aGlzLmNvb3Jkc0Fycj1lLmdldEFycmF5KCJDb29yZHMiKTtpZighaXNOdW1iZXJBcnJheSh0aGlzLmNvb3Jkc0FycixzKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlJhZGlhbEF4aWFsU2hhZGluZzogSW52YWxpZCAvQ29vcmRzIGFycmF5LiIpO2NvbnN0IG89Q29sb3JTcGFjZVV0aWxzLnBhcnNlKHtjczplLmdldFJhdygiQ1MiKXx8ZS5nZXRSYXcoIkNvbG9yU3BhY2UiKSx4cmVmOnQscmVzb3VyY2VzOnIscGRmRnVuY3Rpb25GYWN0b3J5OmEsZ2xvYmFsQ29sb3JTcGFjZUNhY2hlOm4sbG9jYWxDb2xvclNwYWNlQ2FjaGU6aX0pO3RoaXMuYmJveD1sb29rdXBOb3JtYWxSZWN0KGUuZ2V0QXJyYXkoIkJCb3giKSxudWxsKTtsZXQgYz0wLGw9MTtjb25zdCBoPWUuZ2V0QXJyYXkoIkRvbWFpbiIpO2lzTnVtYmVyQXJyYXkoaCwyKSYmKFtjLGxdPWgpO2xldCB1PSExLGQ9ITE7Y29uc3QgZj1lLmdldEFycmF5KCJFeHRlbmQiKTsoZnVuY3Rpb24gaXNCb29sZWFuQXJyYXkoZSx0KXtyZXR1cm4gQXJyYXkuaXNBcnJheShlKSYmKG51bGw9PT10fHxlLmxlbmd0aD09PXQpJiZlLmV2ZXJ5KGU9PiJib29sZWFuIj09dHlwZW9mIGUpfSkoZiwyKSYmKFt1LGRdPWYpO2lmKCEodGhpcy5zaGFkaW5nVHlwZSE9PWhufHx1JiZkKSl7Y29uc3RbZSx0LHIsYSxuLGldPXRoaXMuY29vcmRzQXJyLHM9TWF0aC5oeXBvdChlLWEsdC1uKTtyPD1pK3MmJmk8PXIrcyYmd2FybigiVW5zdXBwb3J0ZWQgcmFkaWFsIGdyYWRpZW50LiIpfXRoaXMuZXh0ZW5kU3RhcnQ9dTt0aGlzLmV4dGVuZEVuZD1kO2NvbnN0IGc9ZS5nZXRSYXcoIkZ1bmN0aW9uIikscD1hLmNyZWF0ZShnLCEwKSxtPShsLWMpLzg0MCxiPXRoaXMuY29sb3JTdG9wcz1bXTtpZihjPj1sfHxtPD0wKXtpbmZvKCJCYWQgc2hhZGluZyBkb21haW4uIik7cmV0dXJufWNvbnN0IHk9bmV3IEZsb2F0MzJBcnJheShvLm51bUNvbXBzKSx3PW5ldyBGbG9hdDMyQXJyYXkoMSk7bGV0IHg9MDt3WzBdPWM7cCh3LDAseSwwKTtjb25zdCBTPW5ldyBVaW50OENsYW1wZWRBcnJheSgzKTtvLmdldFJnYih5LDAsUyk7bGV0W2ssQyx2XT1TO2IucHVzaChbMCxVdGlsLm1ha2VIZXhDb2xvcihrLEMsdildKTtsZXQgVD0xO3dbMF09YyttO3AodywwLHksMCk7by5nZXRSZ2IoeSwwLFMpO2xldFtPLE0sRF09UyxSPU8taysxLEU9TS1DKzEsTj1ELXYrMSxfPU8tay0xLEw9TS1DLTEsaj1ELXYtMTtmb3IobGV0IGU9MjtlPDg0MDtlKyspe3dbMF09YytlKm07cCh3LDAseSwwKTtvLmdldFJnYih5LDAsUyk7Y29uc3RbdCxyLGFdPVMsbj1lLXg7Uj1NYXRoLm1pbihSLCh0LWsrMSkvbik7RT1NYXRoLm1pbihFLChyLUMrMSkvbik7Tj1NYXRoLm1pbihOLChhLXYrMSkvbik7Xz1NYXRoLm1heChfLCh0LWstMSkvbik7TD1NYXRoLm1heChMLChyLUMtMSkvbik7aj1NYXRoLm1heChqLChhLXYtMSkvbik7aWYoIShfPD1SJiZMPD1FJiZqPD1OKSl7Y29uc3QgZT1VdGlsLm1ha2VIZXhDb2xvcihPLE0sRCk7Yi5wdXNoKFtULzg0MCxlXSk7Uj10LU8rMTtFPXItTSsxO049YS1EKzE7Xz10LU8tMTtMPXItTS0xO2o9YS1ELTE7eD1UO2s9TztDPU07dj1EfVQ9ZTtPPXQ7TT1yO0Q9YX1iLnB1c2goWzEsVXRpbC5tYWtlSGV4Q29sb3IoTyxNLEQpXSk7bGV0IFU9InRyYW5zcGFyZW50IjtlLmhhcygiQmFja2dyb3VuZCIpJiYoVT1vLmdldFJnYkhleChlLmdldCgiQmFja2dyb3VuZCIpLDApKTtpZighdSl7Yi51bnNoaWZ0KFswLFVdKTtiWzFdWzBdKz1CYXNlU2hhZGluZy5TTUFMTF9OVU1CRVJ9aWYoIWQpe2IuYXQoLTEpWzBdLT1CYXNlU2hhZGluZy5TTUFMTF9OVU1CRVI7Yi5wdXNoKFsxLFVdKX10aGlzLmNvbG9yU3RvcHM9Yn1nZXRJUigpe2NvbnN0e2Nvb3Jkc0FycjplLHNoYWRpbmdUeXBlOnR9PXRoaXM7bGV0IHIsYSxuLGkscztpZih0PT09bG4pe2E9W2VbMF0sZVsxXV07bj1bZVsyXSxlWzNdXTtpPW51bGw7cz1udWxsO3I9ImF4aWFsIn1lbHNlIGlmKHQ9PT1obil7YT1bZVswXSxlWzFdXTtuPVtlWzNdLGVbNF1dO2k9ZVsyXTtzPWVbNV07cj0icmFkaWFsIn1lbHNlIHVucmVhY2hhYmxlKGBnZXRQYXR0ZXJuIHR5cGUgdW5rbm93bjogJHt0fWApO3JldHVyblsiUmFkaWFsQXhpYWwiLHIsdGhpcy5iYm94LHRoaXMuY29sb3JTdG9wcyxhLG4saSxzXX19Y2xhc3MgTWVzaFN0cmVhbVJlYWRlcntjb25zdHJ1Y3RvcihlLHQpe3RoaXMuc3RyZWFtPWU7dGhpcy5jb250ZXh0PXQ7dGhpcy5idWZmZXI9MDt0aGlzLmJ1ZmZlckxlbmd0aD0wO2NvbnN0IHI9dC5udW1Db21wczt0aGlzLnRtcENvbXBzQnVmPW5ldyBGbG9hdDMyQXJyYXkocik7Y29uc3QgYT10LmNvbG9yU3BhY2UubnVtQ29tcHM7dGhpcy50bXBDc0NvbXBzQnVmPXQuY29sb3JGbj9uZXcgRmxvYXQzMkFycmF5KGEpOnRoaXMudG1wQ29tcHNCdWZ9Z2V0IGhhc0RhdGEoKXtpZih0aGlzLnN0cmVhbS5lbmQpcmV0dXJuIHRoaXMuc3RyZWFtLnBvczx0aGlzLnN0cmVhbS5lbmQ7aWYodGhpcy5idWZmZXJMZW5ndGg+MClyZXR1cm4hMDtjb25zdCBlPXRoaXMuc3RyZWFtLmdldEJ5dGUoKTtpZihlPDApcmV0dXJuITE7dGhpcy5idWZmZXI9ZTt0aGlzLmJ1ZmZlckxlbmd0aD04O3JldHVybiEwfXJlYWRCaXRzKGUpe2NvbnN0e3N0cmVhbTp0fT10aGlzO2xldHtidWZmZXI6cixidWZmZXJMZW5ndGg6YX09dGhpcztpZigzMj09PWUpe2lmKDA9PT1hKXJldHVybiB0LmdldEludDMyKCk+Pj4wO3I9cjw8MjR8dC5nZXRCeXRlKCk8PDE2fHQuZ2V0Qnl0ZSgpPDw4fHQuZ2V0Qnl0ZSgpO2NvbnN0IGU9dC5nZXRCeXRlKCk7dGhpcy5idWZmZXI9ZSYoMTw8YSktMTtyZXR1cm4ocjw8OC1hfCgyNTUmZSk+PmEpPj4+MH1pZig4PT09ZSYmMD09PWEpcmV0dXJuIHQuZ2V0Qnl0ZSgpO2Zvcig7YTxlOyl7cj1yPDw4fHQuZ2V0Qnl0ZSgpO2ErPTh9YS09ZTt0aGlzLmJ1ZmZlckxlbmd0aD1hO3RoaXMuYnVmZmVyPXImKDE8PGEpLTE7cmV0dXJuIHI+PmF9YWxpZ24oKXt0aGlzLmJ1ZmZlcj0wO3RoaXMuYnVmZmVyTGVuZ3RoPTB9cmVhZEZsYWcoKXtyZXR1cm4gdGhpcy5yZWFkQml0cyh0aGlzLmNvbnRleHQuYml0c1BlckZsYWcpfXJlYWRDb29yZGluYXRlKCl7Y29uc3R7Yml0c1BlckNvb3JkaW5hdGU6ZSxkZWNvZGU6dH09dGhpcy5jb250ZXh0LHI9dGhpcy5yZWFkQml0cyhlKSxhPXRoaXMucmVhZEJpdHMoZSksbj1lPDMyPzEvKCgxPDxlKS0xKToyLjMyODMwNjQzNjUzODY5NjNlLTEwO3JldHVybltyKm4qKHRbMV0tdFswXSkrdFswXSxhKm4qKHRbM10tdFsyXSkrdFsyXV19cmVhZENvbXBvbmVudHMoKXtjb25zdHtiaXRzUGVyQ29tcG9uZW50OmUsY29sb3JGbjp0LGNvbG9yU3BhY2U6cixkZWNvZGU6YSxudW1Db21wczpufT10aGlzLmNvbnRleHQsaT1lPDMyPzEvKCgxPDxlKS0xKToyLjMyODMwNjQzNjUzODY5NjNlLTEwLHM9dGhpcy50bXBDb21wc0J1Zjtmb3IobGV0IHQ9MCxyPTQ7dDxuO3QrKyxyKz0yKXtjb25zdCBuPXRoaXMucmVhZEJpdHMoZSk7c1t0XT1uKmkqKGFbcisxXS1hW3JdKSthW3JdfWNvbnN0IG89dGhpcy50bXBDc0NvbXBzQnVmO3Q/LihzLDAsbywwKTtyZXR1cm4gci5nZXRSZ2IobywwKX19bGV0IHBuPU9iamVjdC5jcmVhdGUobnVsbCk7ZnVuY3Rpb24gZ2V0QihlKXtyZXR1cm4gcG5bZV18fD1mdW5jdGlvbiBidWlsZEIoZSl7Y29uc3QgdD1bXTtmb3IobGV0IHI9MDtyPD1lO3IrKyl7Y29uc3QgYT1yL2Usbj0xLWE7dC5wdXNoKG5ldyBGbG9hdDMyQXJyYXkoW24qKjMsMyphKm4qKjIsMyphKioyKm4sYSoqM10pKX1yZXR1cm4gdH0oZSl9Y2xhc3MgTWVzaFNoYWRpbmcgZXh0ZW5kcyBCYXNlU2hhZGluZ3tzdGF0aWMgTUlOX1NQTElUX1BBVENIX0NIVU5LU19BTU9VTlQ9MztzdGF0aWMgTUFYX1NQTElUX1BBVENIX0NIVU5LU19BTU9VTlQ9MjA7c3RhdGljIFRSSUFOR0xFX0RFTlNJVFk9MjA7Y29uc3RydWN0b3IoZSx0LHIsYSxuLGkpe3N1cGVyKCk7aWYoIShlIGluc3RhbmNlb2YgQmFzZVN0cmVhbSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJNZXNoIGRhdGEgaXMgbm90IGEgc3RyZWFtIik7Y29uc3Qgcz1lLmRpY3Q7dGhpcy5zaGFkaW5nVHlwZT1zLmdldCgiU2hhZGluZ1R5cGUiKTt0aGlzLmJib3g9bG9va3VwTm9ybWFsUmVjdChzLmdldEFycmF5KCJCQm94IiksbnVsbCk7Y29uc3Qgbz1Db2xvclNwYWNlVXRpbHMucGFyc2Uoe2NzOnMuZ2V0UmF3KCJDUyIpfHxzLmdldFJhdygiQ29sb3JTcGFjZSIpLHhyZWY6dCxyZXNvdXJjZXM6cixwZGZGdW5jdGlvbkZhY3Rvcnk6YSxnbG9iYWxDb2xvclNwYWNlQ2FjaGU6bixsb2NhbENvbG9yU3BhY2VDYWNoZTppfSk7dGhpcy5iYWNrZ3JvdW5kPXMuaGFzKCJCYWNrZ3JvdW5kIik/by5nZXRSZ2Iocy5nZXQoIkJhY2tncm91bmQiKSwwKTpudWxsO2NvbnN0IGM9cy5nZXRSYXcoIkZ1bmN0aW9uIiksbD1jP2EuY3JlYXRlKGMsITApOm51bGw7dGhpcy5jb29yZHM9W107dGhpcy5jb2xvcnM9W107dGhpcy5maWd1cmVzPVtdO2NvbnN0IGg9e2JpdHNQZXJDb29yZGluYXRlOnMuZ2V0KCJCaXRzUGVyQ29vcmRpbmF0ZSIpLGJpdHNQZXJDb21wb25lbnQ6cy5nZXQoIkJpdHNQZXJDb21wb25lbnQiKSxiaXRzUGVyRmxhZzpzLmdldCgiQml0c1BlckZsYWciKSxkZWNvZGU6cy5nZXRBcnJheSgiRGVjb2RlIiksY29sb3JGbjpsLGNvbG9yU3BhY2U6byxudW1Db21wczpsPzE6by5udW1Db21wc30sdT1uZXcgTWVzaFN0cmVhbVJlYWRlcihlLGgpO2xldCBkPSExO3N3aXRjaCh0aGlzLnNoYWRpbmdUeXBlKXtjYXNlIHVuOnRoaXMuX2RlY29kZVR5cGU0U2hhZGluZyh1KTticmVhaztjYXNlIGRuOmNvbnN0IGU9MHxzLmdldCgiVmVydGljZXNQZXJSb3ciKTtpZihlPDIpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIFZlcnRpY2VzUGVyUm93Iik7dGhpcy5fZGVjb2RlVHlwZTVTaGFkaW5nKHUsZSk7YnJlYWs7Y2FzZSBmbjp0aGlzLl9kZWNvZGVUeXBlNlNoYWRpbmcodSk7ZD0hMDticmVhaztjYXNlIGduOnRoaXMuX2RlY29kZVR5cGU3U2hhZGluZyh1KTtkPSEwO2JyZWFrO2RlZmF1bHQ6dW5yZWFjaGFibGUoIlVuc3VwcG9ydGVkIG1lc2ggdHlwZS4iKX1pZihkKXt0aGlzLl91cGRhdGVCb3VuZHMoKTtmb3IobGV0IGU9MCx0PXRoaXMuZmlndXJlcy5sZW5ndGg7ZTx0O2UrKyl0aGlzLl9idWlsZEZpZ3VyZUZyb21QYXRjaChlKX10aGlzLl91cGRhdGVCb3VuZHMoKTt0aGlzLl9wYWNrRGF0YSgpfV9kZWNvZGVUeXBlNFNoYWRpbmcoZSl7Y29uc3QgdD10aGlzLmNvb3JkcyxyPXRoaXMuY29sb3JzLGE9W10sbj1bXTtsZXQgaT0wO2Zvcig7ZS5oYXNEYXRhOyl7Y29uc3Qgcz1lLnJlYWRGbGFnKCksbz1lLnJlYWRDb29yZGluYXRlKCksYz1lLnJlYWRDb21wb25lbnRzKCk7aWYoMD09PWkpe2lmKCEoMDw9cyYmczw9MikpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJVbmtub3duIHR5cGU0IGZsYWciKTtzd2l0Y2gocyl7Y2FzZSAwOmk9MzticmVhaztjYXNlIDE6bi5wdXNoKG4uYXQoLTIpLG4uYXQoLTEpKTtpPTE7YnJlYWs7Y2FzZSAyOm4ucHVzaChuLmF0KC0zKSxuLmF0KC0xKSk7aT0xfWEucHVzaChzKX1uLnB1c2godC5sZW5ndGgpO3QucHVzaChvKTtyLnB1c2goYyk7aS0tO2UuYWxpZ24oKX10aGlzLmZpZ3VyZXMucHVzaCh7dHlwZToidHJpYW5nbGVzIixjb29yZHM6bmV3IEludDMyQXJyYXkobiksY29sb3JzOm5ldyBJbnQzMkFycmF5KG4pfSl9X2RlY29kZVR5cGU1U2hhZGluZyhlLHQpe2NvbnN0IHI9dGhpcy5jb29yZHMsYT10aGlzLmNvbG9ycyxuPVtdO2Zvcig7ZS5oYXNEYXRhOyl7Y29uc3QgdD1lLnJlYWRDb29yZGluYXRlKCksaT1lLnJlYWRDb21wb25lbnRzKCk7bi5wdXNoKHIubGVuZ3RoKTtyLnB1c2godCk7YS5wdXNoKGkpfXRoaXMuZmlndXJlcy5wdXNoKHt0eXBlOiJsYXR0aWNlIixjb29yZHM6bmV3IEludDMyQXJyYXkobiksY29sb3JzOm5ldyBJbnQzMkFycmF5KG4pLHZlcnRpY2VzUGVyUm93OnR9KX1fZGVjb2RlVHlwZTZTaGFkaW5nKGUpe2NvbnN0IHQ9dGhpcy5jb29yZHMscj10aGlzLmNvbG9ycyxhPW5ldyBJbnQzMkFycmF5KDE2KSxuPW5ldyBJbnQzMkFycmF5KDQpO2Zvcig7ZS5oYXNEYXRhOyl7Y29uc3QgaT1lLnJlYWRGbGFnKCk7aWYoISgwPD1pJiZpPD0zKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlVua25vd24gdHlwZTYgZmxhZyIpO2NvbnN0IHM9dC5sZW5ndGg7Zm9yKGxldCByPTAsYT0wIT09aT84OjEyO3I8YTtyKyspdC5wdXNoKGUucmVhZENvb3JkaW5hdGUoKSk7Y29uc3Qgbz1yLmxlbmd0aDtmb3IobGV0IHQ9MCxhPTAhPT1pPzI6NDt0PGE7dCsrKXIucHVzaChlLnJlYWRDb21wb25lbnRzKCkpO2xldCBjLGwsaCx1O3N3aXRjaChpKXtjYXNlIDA6YVsxMl09cyszO2FbMTNdPXMrNDthWzE0XT1zKzU7YVsxNV09cys2O2FbOF09cysyO2FbMTFdPXMrNzthWzRdPXMrMTthWzddPXMrODthWzBdPXM7YVsxXT1zKzExO2FbMl09cysxMDthWzNdPXMrOTtuWzJdPW8rMTtuWzNdPW8rMjtuWzBdPW87blsxXT1vKzM7YnJlYWs7Y2FzZSAxOmM9YVsxMl07bD1hWzEzXTtoPWFbMTRdO3U9YVsxNV07YVsxMl09dTthWzEzXT1zKzA7YVsxNF09cysxO2FbMTVdPXMrMjthWzhdPWg7YVsxMV09cyszO2FbNF09bDthWzddPXMrNDthWzBdPWM7YVsxXT1zKzc7YVsyXT1zKzY7YVszXT1zKzU7Yz1uWzJdO2w9blszXTtuWzJdPWw7blszXT1vO25bMF09YztuWzFdPW8rMTticmVhaztjYXNlIDI6Yz1hWzE1XTtsPWFbMTFdO2FbMTJdPWFbM107YVsxM109cyswO2FbMTRdPXMrMTthWzE1XT1zKzI7YVs4XT1hWzddO2FbMTFdPXMrMzthWzRdPWw7YVs3XT1zKzQ7YVswXT1jO2FbMV09cys3O2FbMl09cys2O2FbM109cys1O2M9blszXTtuWzJdPW5bMV07blszXT1vO25bMF09YztuWzFdPW8rMTticmVhaztjYXNlIDM6YVsxMl09YVswXTthWzEzXT1zKzA7YVsxNF09cysxO2FbMTVdPXMrMjthWzhdPWFbMV07YVsxMV09cyszO2FbNF09YVsyXTthWzddPXMrNDthWzBdPWFbM107YVsxXT1zKzc7YVsyXT1zKzY7YVszXT1zKzU7blsyXT1uWzBdO25bM109bztuWzBdPW5bMV07blsxXT1vKzF9YVs1XT10Lmxlbmd0aDt0LnB1c2goWygtNCp0W2FbMF1dWzBdLXRbYVsxNV1dWzBdKzYqKHRbYVs0XV1bMF0rdFthWzFdXVswXSktMioodFthWzEyXV1bMF0rdFthWzNdXVswXSkrMyoodFthWzEzXV1bMF0rdFthWzddXVswXSkpLzksKC00KnRbYVswXV1bMV0tdFthWzE1XV1bMV0rNioodFthWzRdXVsxXSt0W2FbMV1dWzFdKS0yKih0W2FbMTJdXVsxXSt0W2FbM11dWzFdKSszKih0W2FbMTNdXVsxXSt0W2FbN11dWzFdKSkvOV0pO2FbNl09dC5sZW5ndGg7dC5wdXNoKFsoLTQqdFthWzNdXVswXS10W2FbMTJdXVswXSs2Kih0W2FbMl1dWzBdK3RbYVs3XV1bMF0pLTIqKHRbYVswXV1bMF0rdFthWzE1XV1bMF0pKzMqKHRbYVs0XV1bMF0rdFthWzE0XV1bMF0pKS85LCgtNCp0W2FbM11dWzFdLXRbYVsxMl1dWzFdKzYqKHRbYVsyXV1bMV0rdFthWzddXVsxXSktMioodFthWzBdXVsxXSt0W2FbMTVdXVsxXSkrMyoodFthWzRdXVsxXSt0W2FbMTRdXVsxXSkpLzldKTthWzldPXQubGVuZ3RoO3QucHVzaChbKC00KnRbYVsxMl1dWzBdLXRbYVszXV1bMF0rNioodFthWzhdXVswXSt0W2FbMTNdXVswXSktMioodFthWzBdXVswXSt0W2FbMTVdXVswXSkrMyoodFthWzExXV1bMF0rdFthWzFdXVswXSkpLzksKC00KnRbYVsxMl1dWzFdLXRbYVszXV1bMV0rNioodFthWzhdXVsxXSt0W2FbMTNdXVsxXSktMioodFthWzBdXVsxXSt0W2FbMTVdXVsxXSkrMyoodFthWzExXV1bMV0rdFthWzFdXVsxXSkpLzldKTthWzEwXT10Lmxlbmd0aDt0LnB1c2goWygtNCp0W2FbMTVdXVswXS10W2FbMF1dWzBdKzYqKHRbYVsxMV1dWzBdK3RbYVsxNF1dWzBdKS0yKih0W2FbMTJdXVswXSt0W2FbM11dWzBdKSszKih0W2FbMl1dWzBdK3RbYVs4XV1bMF0pKS85LCgtNCp0W2FbMTVdXVsxXS10W2FbMF1dWzFdKzYqKHRbYVsxMV1dWzFdK3RbYVsxNF1dWzFdKS0yKih0W2FbMTJdXVsxXSt0W2FbM11dWzFdKSszKih0W2FbMl1dWzFdK3RbYVs4XV1bMV0pKS85XSk7dGhpcy5maWd1cmVzLnB1c2goe3R5cGU6InBhdGNoIixjb29yZHM6bmV3IEludDMyQXJyYXkoYSksY29sb3JzOm5ldyBJbnQzMkFycmF5KG4pfSl9fV9kZWNvZGVUeXBlN1NoYWRpbmcoZSl7Y29uc3QgdD10aGlzLmNvb3JkcyxyPXRoaXMuY29sb3JzLGE9bmV3IEludDMyQXJyYXkoMTYpLG49bmV3IEludDMyQXJyYXkoNCk7Zm9yKDtlLmhhc0RhdGE7KXtjb25zdCBpPWUucmVhZEZsYWcoKTtpZighKDA8PWkmJmk8PTMpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiVW5rbm93biB0eXBlNyBmbGFnIik7Y29uc3Qgcz10Lmxlbmd0aDtmb3IobGV0IHI9MCxhPTAhPT1pPzEyOjE2O3I8YTtyKyspdC5wdXNoKGUucmVhZENvb3JkaW5hdGUoKSk7Y29uc3Qgbz1yLmxlbmd0aDtmb3IobGV0IHQ9MCxhPTAhPT1pPzI6NDt0PGE7dCsrKXIucHVzaChlLnJlYWRDb21wb25lbnRzKCkpO2xldCBjLGwsaCx1O3N3aXRjaChpKXtjYXNlIDA6YVsxMl09cyszO2FbMTNdPXMrNDthWzE0XT1zKzU7YVsxNV09cys2O2FbOF09cysyO2FbOV09cysxMzthWzEwXT1zKzE0O2FbMTFdPXMrNzthWzRdPXMrMTthWzVdPXMrMTI7YVs2XT1zKzE1O2FbN109cys4O2FbMF09czthWzFdPXMrMTE7YVsyXT1zKzEwO2FbM109cys5O25bMl09bysxO25bM109bysyO25bMF09bztuWzFdPW8rMzticmVhaztjYXNlIDE6Yz1hWzEyXTtsPWFbMTNdO2g9YVsxNF07dT1hWzE1XTthWzEyXT11O2FbMTNdPXMrMDthWzE0XT1zKzE7YVsxNV09cysyO2FbOF09aDthWzldPXMrOTthWzEwXT1zKzEwO2FbMTFdPXMrMzthWzRdPWw7YVs1XT1zKzg7YVs2XT1zKzExO2FbN109cys0O2FbMF09YzthWzFdPXMrNzthWzJdPXMrNjthWzNdPXMrNTtjPW5bMl07bD1uWzNdO25bMl09bDtuWzNdPW87blswXT1jO25bMV09bysxO2JyZWFrO2Nhc2UgMjpjPWFbMTVdO2w9YVsxMV07YVsxMl09YVszXTthWzEzXT1zKzA7YVsxNF09cysxO2FbMTVdPXMrMjthWzhdPWFbN107YVs5XT1zKzk7YVsxMF09cysxMDthWzExXT1zKzM7YVs0XT1sO2FbNV09cys4O2FbNl09cysxMTthWzddPXMrNDthWzBdPWM7YVsxXT1zKzc7YVsyXT1zKzY7YVszXT1zKzU7Yz1uWzNdO25bMl09blsxXTtuWzNdPW87blswXT1jO25bMV09bysxO2JyZWFrO2Nhc2UgMzphWzEyXT1hWzBdO2FbMTNdPXMrMDthWzE0XT1zKzE7YVsxNV09cysyO2FbOF09YVsxXTthWzldPXMrOTthWzEwXT1zKzEwO2FbMTFdPXMrMzthWzRdPWFbMl07YVs1XT1zKzg7YVs2XT1zKzExO2FbN109cys0O2FbMF09YVszXTthWzFdPXMrNzthWzJdPXMrNjthWzNdPXMrNTtuWzJdPW5bMF07blszXT1vO25bMF09blsxXTtuWzFdPW8rMX10aGlzLmZpZ3VyZXMucHVzaCh7dHlwZToicGF0Y2giLGNvb3JkczpuZXcgSW50MzJBcnJheShhKSxjb2xvcnM6bmV3IEludDMyQXJyYXkobil9KX19X2J1aWxkRmlndXJlRnJvbVBhdGNoKGUpe2NvbnN0IHQ9dGhpcy5maWd1cmVzW2VdO2Fzc2VydCgicGF0Y2giPT09dC50eXBlLCJVbmV4cGVjdGVkIHBhdGNoIG1lc2ggZmlndXJlIik7Y29uc3Qgcj10aGlzLmNvb3JkcyxhPXRoaXMuY29sb3JzLG49dC5jb29yZHMsaT10LmNvbG9ycyxzPU1hdGgubWluKHJbblswXV1bMF0scltuWzNdXVswXSxyW25bMTJdXVswXSxyW25bMTVdXVswXSksbz1NYXRoLm1pbihyW25bMF1dWzFdLHJbblszXV1bMV0scltuWzEyXV1bMV0scltuWzE1XV1bMV0pLGM9TWF0aC5tYXgocltuWzBdXVswXSxyW25bM11dWzBdLHJbblsxMl1dWzBdLHJbblsxNV1dWzBdKSxsPU1hdGgubWF4KHJbblswXV1bMV0scltuWzNdXVsxXSxyW25bMTJdXVsxXSxyW25bMTVdXVsxXSk7bGV0IGg9TWF0aC5jZWlsKChjLXMpKk1lc2hTaGFkaW5nLlRSSUFOR0xFX0RFTlNJVFkvKHRoaXMuYm91bmRzWzJdLXRoaXMuYm91bmRzWzBdKSk7aD1NYXRoQ2xhbXAoaCxNZXNoU2hhZGluZy5NSU5fU1BMSVRfUEFUQ0hfQ0hVTktTX0FNT1VOVCxNZXNoU2hhZGluZy5NQVhfU1BMSVRfUEFUQ0hfQ0hVTktTX0FNT1VOVCk7bGV0IHU9TWF0aC5jZWlsKChsLW8pKk1lc2hTaGFkaW5nLlRSSUFOR0xFX0RFTlNJVFkvKHRoaXMuYm91bmRzWzNdLXRoaXMuYm91bmRzWzFdKSk7dT1NYXRoQ2xhbXAodSxNZXNoU2hhZGluZy5NSU5fU1BMSVRfUEFUQ0hfQ0hVTktTX0FNT1VOVCxNZXNoU2hhZGluZy5NQVhfU1BMSVRfUEFUQ0hfQ0hVTktTX0FNT1VOVCk7Y29uc3QgZD1oKzEsZj1uZXcgSW50MzJBcnJheSgodSsxKSpkKSxnPW5ldyBJbnQzMkFycmF5KCh1KzEpKmQpO2xldCBwPTA7Y29uc3QgbT1uZXcgVWludDhBcnJheSgzKSxiPW5ldyBVaW50OEFycmF5KDMpLHk9YVtpWzBdXSx3PWFbaVsxXV0seD1hW2lbMl1dLFM9YVtpWzNdXSxrPWdldEIodSksQz1nZXRCKGgpO2ZvcihsZXQgZT0wO2U8PXU7ZSsrKXttWzBdPSh5WzBdKih1LWUpK3hbMF0qZSkvdXwwO21bMV09KHlbMV0qKHUtZSkreFsxXSplKS91fDA7bVsyXT0oeVsyXSoodS1lKSt4WzJdKmUpL3V8MDtiWzBdPSh3WzBdKih1LWUpK1NbMF0qZSkvdXwwO2JbMV09KHdbMV0qKHUtZSkrU1sxXSplKS91fDA7YlsyXT0od1syXSoodS1lKStTWzJdKmUpL3V8MDtmb3IobGV0IHQ9MDt0PD1oO3QrKyxwKyspe2lmKCEoMCE9PWUmJmUhPT11fHwwIT09dCYmdCE9PWgpKWNvbnRpbnVlO2xldCBpPTAscz0wLG89MDtmb3IobGV0IGE9MDthPD0zO2ErKylmb3IobGV0IGM9MDtjPD0zO2MrKyxvKyspe2NvbnN0IGw9a1tlXVthXSpDW3RdW2NdO2krPXJbbltvXV1bMF0qbDtzKz1yW25bb11dWzFdKmx9ZltwXT1yLmxlbmd0aDtyLnB1c2goW2ksc10pO2dbcF09YS5sZW5ndGg7Y29uc3QgYz1uZXcgVWludDhBcnJheSgzKTtjWzBdPShtWzBdKihoLXQpK2JbMF0qdCkvaHwwO2NbMV09KG1bMV0qKGgtdCkrYlsxXSp0KS9ofDA7Y1syXT0obVsyXSooaC10KStiWzJdKnQpL2h8MDthLnB1c2goYyl9fWZbMF09blswXTtnWzBdPWlbMF07ZltoXT1uWzNdO2dbaF09aVsxXTtmW2QqdV09blsxMl07Z1tkKnVdPWlbMl07ZltkKnUraF09blsxNV07Z1tkKnUraF09aVszXTt0aGlzLmZpZ3VyZXNbZV09e3R5cGU6ImxhdHRpY2UiLGNvb3JkczpmLGNvbG9yczpnLHZlcnRpY2VzUGVyUm93OmR9fV91cGRhdGVCb3VuZHMoKXtsZXQgZT10aGlzLmNvb3Jkc1swXVswXSx0PXRoaXMuY29vcmRzWzBdWzFdLHI9ZSxhPXQ7Zm9yKGxldCBuPTEsaT10aGlzLmNvb3Jkcy5sZW5ndGg7bjxpO24rKyl7Y29uc3QgaT10aGlzLmNvb3Jkc1tuXVswXSxzPXRoaXMuY29vcmRzW25dWzFdO2U9ZT5pP2k6ZTt0PXQ+cz9zOnQ7cj1yPGk/aTpyO2E9YTxzP3M6YX10aGlzLmJvdW5kcz1bZSx0LHIsYV19X3BhY2tEYXRhKCl7bGV0IGUsdCxyLGE7Y29uc3Qgbj10aGlzLmNvb3JkcyxpPW5ldyBGbG9hdDMyQXJyYXkoMipuLmxlbmd0aCk7Zm9yKGU9MCxyPTAsdD1uLmxlbmd0aDtlPHQ7ZSsrKXtjb25zdCB0PW5bZV07aVtyKytdPXRbMF07aVtyKytdPXRbMV19dGhpcy5jb29yZHM9aTtjb25zdCBzPXRoaXMuY29sb3JzLG89bmV3IFVpbnQ4QXJyYXkoMypzLmxlbmd0aCk7Zm9yKGU9MCxyPTAsdD1zLmxlbmd0aDtlPHQ7ZSsrKXtjb25zdCB0PXNbZV07b1tyKytdPXRbMF07b1tyKytdPXRbMV07b1tyKytdPXRbMl19dGhpcy5jb2xvcnM9bztjb25zdCBjPXRoaXMuZmlndXJlcztmb3IoZT0wLHQ9Yy5sZW5ndGg7ZTx0O2UrKyl7Y29uc3QgdD1jW2VdLG49dC5jb29yZHMsaT10LmNvbG9ycztmb3Iocj0wLGE9bi5sZW5ndGg7cjxhO3IrKyl7bltyXSo9MjtpW3JdKj0zfX19Z2V0SVIoKXtjb25zdHtib3VuZHM6ZX09dGhpcztpZihlWzJdLWVbMF09PT0wfHxlWzNdLWVbMV09PT0wKXRocm93IG5ldyBGb3JtYXRFcnJvcihgSW52YWxpZCBNZXNoU2hhZGluZyBib3VuZHM6IFske2V9XS5gKTtyZXR1cm5bIk1lc2giLHRoaXMuc2hhZGluZ1R5cGUsdGhpcy5jb29yZHMsdGhpcy5jb2xvcnMsdGhpcy5maWd1cmVzLGUsdGhpcy5iYm94LHRoaXMuYmFja2dyb3VuZF19fWNsYXNzIER1bW15U2hhZGluZyBleHRlbmRzIEJhc2VTaGFkaW5ne2dldElSKCl7cmV0dXJuWyJEdW1teSJdfX1mdW5jdGlvbiBnZXRUaWxpbmdQYXR0ZXJuSVIoZSx0LHIpe2NvbnN0IGE9bG9va3VwTWF0cml4KHQuZ2V0QXJyYXkoIk1hdHJpeCIpLGZyKSxuPWxvb2t1cE5vcm1hbFJlY3QodC5nZXRBcnJheSgiQkJveCIpLG51bGwpO2lmKCFufHxuWzJdLW5bMF09PT0wfHxuWzNdLW5bMV09PT0wKXRocm93IG5ldyBGb3JtYXRFcnJvcigiSW52YWxpZCBnZXRUaWxpbmdQYXR0ZXJuSVIgL0JCb3ggYXJyYXkuIik7Y29uc3QgaT10LmdldCgiWFN0ZXAiKTtpZigibnVtYmVyIiE9dHlwZW9mIGkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIGdldFRpbGluZ1BhdHRlcm5JUiAvWFN0ZXAgdmFsdWUuIik7Y29uc3Qgcz10LmdldCgiWVN0ZXAiKTtpZigibnVtYmVyIiE9dHlwZW9mIHMpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIGdldFRpbGluZ1BhdHRlcm5JUiAvWVN0ZXAgdmFsdWUuIik7Y29uc3Qgbz10LmdldCgiUGFpbnRUeXBlIik7aWYoIU51bWJlci5pc0ludGVnZXIobykpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIGdldFRpbGluZ1BhdHRlcm5JUiAvUGFpbnRUeXBlIHZhbHVlLiIpO2NvbnN0IGM9dC5nZXQoIlRpbGluZ1R5cGUiKTtpZighTnVtYmVyLmlzSW50ZWdlcihjKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkludmFsaWQgZ2V0VGlsaW5nUGF0dGVybklSIC9UaWxpbmdUeXBlIHZhbHVlLiIpO3JldHVyblsiVGlsaW5nUGF0dGVybiIscixlLGEsbixpLHMsbyxjXX1jb25zdCBtbj1bMS4zODc3LDEsMSwxLC45NzgwMSwuOTI0ODIsLjg5NTUyLC45MTEzMywuODE5ODgsLjk3NTY2LC45ODE1MiwuOTM1NDgsLjkzNTQ4LDEuMjc5OCwuODUyODQsLjkyNzk0LDEsLjk2MTM0LDEuNTQ2NTcsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC44Mjg0NSwuODI4NDUsLjg1Mjg0LC44NTI4NCwuODUyODQsLjc1ODU5LC45MjEzOCwuODM5MDgsLjc3NjIsLjczMjkzLC44NzI4OSwuNzMxMzMsLjc1MTQsLjgxOTIxLC44NzM1NiwuOTU5NTgsLjU5NTI2LC43NTcyNywuNjkyMjUsMS4wNDkyNCwuOTEyMSwuODY5NDMsLjc5Nzk1LC44ODE5OCwuNzc5NTgsLjcwODY0LC44MTA1NSwuOTAzOTksLjg4NjUzLC45NjAxNywuODI1NzcsLjc3ODkyLC43ODI1NywuOTc1MDcsMS41NDY1NywuOTc1MDcsLjg1Mjg0LC44OTU1MiwuOTAxNzYsLjg4NzYyLC44Nzg1LC43NTI0MSwuODc4NSwuOTA1MTgsLjk1MDE1LC43NzYxOCwuODc4NSwuODg0MDEsLjkxOTE2LC44NjMwNCwuODg0MDEsLjkxNDg4LC44Nzg1LC44ODAxLC44Nzg1LC44Nzg1LC45MTM0MywuNzE3MywxLjA0MTA2LC44Nzg1LC44NTA3NSwuOTU3OTQsLjgyNjE2LC44NTE2MiwuNzk0OTIsLjg4MzMxLDEuNjk4MDgsLjg4MzMxLC44NTI4NCwuOTc4MDEsLjg5NTUyLC45MTEzMywuODk1NTIsLjkxMTMzLDEuNzgwMSwuODk1NTIsMS4yNDQ4NywxLjEzMjU0LDEuMTI0MDEsLjk2ODM5LC44NTI4NCwuNjg3ODcsLjcwNjQ1LC44NTU5MiwuOTA3NDcsMS4wMTQ2NiwxLjAwODgsLjkwMzIzLDEsMS4wNzQ2MywxLC45MTA1NiwuNzU4MDYsMS4xOTExOCwuOTY4MzksLjc4ODY0LC44Mjg0NSwuODQxMzMsLjc1ODU5LC44MzkwOCwuODM5MDgsLjgzOTA4LC44MzkwOCwuODM5MDgsLjgzOTA4LC43NzUzOSwuNzMyOTMsLjczMTMzLC43MzEzMywuNzMxMzMsLjczMTMzLC45NTk1OCwuOTU5NTgsLjk1OTU4LC45NTk1OCwuODg1MDYsLjkxMjEsLjg2OTQzLC44Njk0MywuODY5NDMsLjg2OTQzLC44Njk0MywuODUyODQsLjg3NTA4LC45MDM5OSwuOTAzOTksLjkwMzk5LC45MDM5OSwuNzc4OTIsLjc5Nzk1LC45MDgwNywuODg3NjIsLjg4NzYyLC44ODc2MiwuODg3NjIsLjg4NzYyLC44ODc2MiwuODcxNSwuNzUyNDEsLjkwNTE4LC45MDUxOCwuOTA1MTgsLjkwNTE4LC44ODQwMSwuODg0MDEsLjg4NDAxLC44ODQwMSwuODc4NSwuODc4NSwuODgwMSwuODgwMSwuODgwMSwuODgwMSwuODgwMSwuOTA3NDcsLjg5MDQ5LC44Nzg1LC44Nzg1LC44Nzg1LC44Nzg1LC44NTE2MiwuODc4NSwuODUxNjIsLjgzOTA4LC44ODc2MiwuODM5MDgsLjg4NzYyLC44MzkwOCwuODg3NjIsLjczMjkzLC43NTI0MSwuNzMyOTMsLjc1MjQxLC43MzI5MywuNzUyNDEsLjczMjkzLC43NTI0MSwuODcyODksLjgzMDE2LC44ODUwNiwuOTMxMjUsLjczMTMzLC45MDUxOCwuNzMxMzMsLjkwNTE4LC43MzEzMywuOTA1MTgsLjczMTMzLC45MDUxOCwuNzMxMzMsLjkwNTE4LC44MTkyMSwuNzc2MTgsLjgxOTIxLC43NzYxOCwuODE5MjEsLjc3NjE4LDEsMSwuODczNTYsLjg3ODUsLjkxMDc1LC44OTYwOCwuOTU5NTgsLjg4NDAxLC45NTk1OCwuODg0MDEsLjk1OTU4LC44ODQwMSwuOTU5NTgsLjg4NDAxLC45NTk1OCwuODg0MDEsLjc2MjI5LC45MDE2NywuNTk1MjYsLjkxOTE2LDEsMSwuODYzMDQsLjY5MjI1LC44ODQwMSwxLDEsLjcwNDI0LC43OTQ2OCwuOTE5MjYsLjg4MTc1LC43MDgyMywuOTQ5MDMsLjkxMjEsLjg3ODUsMSwxLC45MTIxLC44Nzg1LC44NzgwMiwuODg2NTYsLjg3ODUsLjg2OTQzLC44ODAxLC44Njk0MywuODgwMSwuODY5NDMsLjg4MDEsLjg3NDAyLC44OTI5MSwuNzc5NTgsLjkxMzQzLDEsMSwuNzc5NTgsLjkxMzQzLC43MDg2NCwuNzE3MywuNzA4NjQsLjcxNzMsLjcwODY0LC43MTczLC43MDg2NCwuNzE3MywxLDEsLjgxMDU1LC43NTg0MSwuODEwNTUsMS4wNjQ1MiwuOTAzOTksLjg3ODUsLjkwMzk5LC44Nzg1LC45MDM5OSwuODc4NSwuOTAzOTksLjg3ODUsLjkwMzk5LC44Nzg1LC45MDM5OSwuODc4NSwuOTYwMTcsLjk1Nzk0LC43Nzg5MiwuODUxNjIsLjc3ODkyLC43ODI1NywuNzk0OTIsLjc4MjU3LC43OTQ5MiwuNzgyNTcsLjc5NDkyLC45Mjk3LC41Njg5MiwuODM5MDgsLjg4NzYyLC43NzUzOSwuODcxNSwuODc1MDgsLjg5MDQ5LDEsMSwuODEwNTUsMS4wNDEwNiwxLjIwNTI4LDEuMjA1MjgsMSwxLjE1NTQzLC43MDY3NCwuOTgzODcsLjk0NzIxLDEuMzM0MzEsMS40NTg5NCwuOTUxNjEsMS4wNjMwMywuODM5MDgsLjgwMzUyLC41NzE4NCwuNjk2NSwuNTYyODksLjgyMDAxLC41NjAyOSwuODEyMzUsMS4wMjk4OCwuODM5MDgsLjc3NjIsLjY4MTU2LC44MDM2NywuNzMxMzMsLjc4MjU3LC44NzM1NiwuODY5NDMsLjk1OTU4LC43NTcyNywuODkwMTksMS4wNDkyNCwuOTEyMSwuNzY0OCwuODY5NDMsLjg3MzU2LC43OTc5NSwuNzgyNzUsLjgxMDU1LC43Nzg5MiwuOTc2MiwuODI1NzcsLjk5ODE5LC44NDg5NiwuOTU5NTgsLjc3ODkyLC45NjEwOCwxLjAxNDA3LC44OTA0OSwxLjAyOTg4LC45NDIxMSwuOTYxMDgsLjg5MzYsLjg0MDIxLC44Nzg0MiwuOTYzOTksLjc5MTA5LC44OTA0OSwxLjAwODEzLDEuMDI5ODgsLjg2MDc3LC44NzQ0NSwuOTIwOTksLjg0NzIzLC44NjUxMywuODgwMSwuNzU2MzgsLjg1NzE0LC43ODIxNiwuNzk1ODYsLjg3OTY1LC45NDIxMSwuOTc3NDcsLjc4Mjg3LC45NzkyNiwuODQ5NzEsMS4wMjk4OCwuOTQyMTEsLjg4MDEsLjk0MjExLC44NDk3MSwuNzMxMzMsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjkwMjY0LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC45MDUxOCwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuOTA1NDgsMSwxLDEsMSwxLDEsLjk2MDE3LC45NTc5NCwuOTYwMTcsLjk1Nzk0LC45NjAxNywuOTU3OTQsLjc3ODkyLC44NTE2MiwxLDEsLjg5NTUyLC45MDUyNywxLC45MDM2MywuOTI3OTQsLjkyNzk0LC45Mjc5NCwuOTI3OTQsLjg3MDEyLC44NzAxMiwuODcwMTIsLjg5NTUyLC44OTU1MiwxLjQyMjU5LC43MTE0MywxLjA2MTUyLDEsMSwxLjAzMzcyLDEuMDMzNzIsLjk3MTcxLDEuNDk1NiwyLjI4MDcsLjkzODM1LC44MzQwNiwuOTExMzMsLjg0MTA3LC45MTEzMywxLDEsMSwuNzIwMjEsMSwxLjIzMTA4LC44MzQ4OSwuODg1MjUsLjg4NTI1LC44MTQ5OSwuOTA1MjcsMS44MTA1NSwuOTA1MjcsMS44MTA1NSwxLjMxMDA2LDEuNTM3MTEsLjk0NDM0LDEuMDg2OTYsMSwuOTUwMTgsLjc3MTkyLC44NTI4NCwuOTA3NDcsMS4xNzUzNCwuNjk4MjUsLjk3MTYsMS4zNzA3NywuOTA3NDcsLjkwNzQ3LC44NTM1NiwuOTA3NDcsLjkwNzQ3LDEuNDQ5NDcsLjg1Mjg0LC44OTQxLC44OTQxLC43MDU3MiwuOCwuNzA1NzIsLjcwNTcyLC43MDU3MiwuNzA1NzIsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC45OTg2MiwuOTk4NjIsMSwxLDEsMSwxLDEuMDgwMDQsLjkxMDI3LDEsMSwxLC45OTg2MiwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuOTA3MjcsLjkwNzI3LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxXSxibj17bGluZUhlaWdodDoxLjIyMDcsbGluZUdhcDouMjIwN30seW49WzEuMzg3NywxLDEsMSwuOTc4MDEsLjkyNDgyLC44OTU1MiwuOTExMzMsLjgxOTg4LC45NzU2NiwuOTgxNTIsLjkzNTQ4LC45MzU0OCwxLjI3OTgsLjg1Mjg0LC45Mjc5NCwxLC45NjEzNCwxLjU2MjM5LC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuODI4NDUsLjgyODQ1LC44NTI4NCwuODUyODQsLjg1Mjg0LC43NTg1OSwuOTIxMzgsLjgzOTA4LC43NzYyLC43MTgwNSwuODcyODksLjczMTMzLC43NTE0LC44MTkyMSwuODczNTYsLjk1OTU4LC41OTUyNiwuNzU3MjcsLjY5MjI1LDEuMDQ5MjQsLjkwODcyLC44NTkzOCwuNzk3OTUsLjg3MDY4LC43Nzk1OCwuNjk3NjYsLjgxMDU1LC45MDM5OSwuODg2NTMsLjk2MDY4LC44MjU3NywuNzc4OTIsLjc4MjU3LC45NzUwNywxLjUyOSwuOTc1MDcsLjg1Mjg0LC44OTU1MiwuOTAxNzYsLjk0OTA4LC44NjQxMSwuNzQwMTIsLjg2NDExLC44ODMyMywuOTUwMTUsLjg2NDExLC44NjMzMSwuODg0MDEsLjkxOTE2LC44NjMwNCwuODg0MDEsLjkwMzksLjg2MzMxLC44NjMzMSwuODY0MTEsLjg2NDExLC45MDQ2NCwuNzA4NTIsMS4wNDEwNiwuODYzMzEsLjg0MzcyLC45NTc5NCwuODI2MTYsLjg0NTQ4LC43OTQ5MiwuODgzMzEsMS42OTgwOCwuODgzMzEsLjg1Mjg0LC45NzgwMSwuODk1NTIsLjkxMTMzLC44OTU1MiwuOTExMzMsMS43ODAxLC44OTU1MiwxLjI0NDg3LDEuMTMyNTQsMS4xOTEyOSwuOTY4MzksLjg1Mjg0LC42ODc4NywuNzA2NDUsLjg1NTkyLC45MDc0NywxLjAxNDY2LDEuMDA4OCwuOTAzMjMsMSwxLjA3NDYzLDEsLjkxMDU2LC43NTgwNiwxLjE5MTE4LC45NjgzOSwuNzg4NjQsLjgyODQ1LC44NDEzMywuNzU4NTksLjgzOTA4LC44MzkwOCwuODM5MDgsLjgzOTA4LC44MzkwOCwuODM5MDgsLjc3NTM5LC43MTgwNSwuNzMxMzMsLjczMTMzLC43MzEzMywuNzMxMzMsLjk1OTU4LC45NTk1OCwuOTU5NTgsLjk1OTU4LC44ODUwNiwuOTA4NzIsLjg1OTM4LC44NTkzOCwuODU5MzgsLjg1OTM4LC44NTkzOCwuODUyODQsLjg3MDY4LC45MDM5OSwuOTAzOTksLjkwMzk5LC45MDM5OSwuNzc4OTIsLjc5Nzk1LC45MDgwNywuOTQ5MDgsLjk0OTA4LC45NDkwOCwuOTQ5MDgsLjk0OTA4LC45NDkwOCwuODU4ODcsLjc0MDEyLC44ODMyMywuODgzMjMsLjg4MzIzLC44ODMyMywuODg0MDEsLjg4NDAxLC44ODQwMSwuODg0MDEsLjg3ODUsLjg2MzMxLC44NjMzMSwuODYzMzEsLjg2MzMxLC44NjMzMSwuODYzMzEsLjkwNzQ3LC44OTA0OSwuODYzMzEsLjg2MzMxLC44NjMzMSwuODYzMzEsLjg0NTQ4LC44NjQxMSwuODQ1NDgsLjgzOTA4LC45NDkwOCwuODM5MDgsLjk0OTA4LC44MzkwOCwuOTQ5MDgsLjcxODA1LC43NDAxMiwuNzE4MDUsLjc0MDEyLC43MTgwNSwuNzQwMTIsLjcxODA1LC43NDAxMiwuODcyODksLjc5NTM4LC44ODUwNiwuOTI3MjYsLjczMTMzLC44ODMyMywuNzMxMzMsLjg4MzIzLC43MzEzMywuODgzMjMsLjczMTMzLC44ODMyMywuNzMxMzMsLjg4MzIzLC44MTkyMSwuODY0MTEsLjgxOTIxLC44NjQxMSwuODE5MjEsLjg2NDExLDEsMSwuODczNTYsLjg2MzMxLC45MTA3NSwuODc3NywuOTU5NTgsLjg4NDAxLC45NTk1OCwuODg0MDEsLjk1OTU4LC44ODQwMSwuOTU5NTgsLjg4NDAxLC45NTk1OCwuODg0MDEsLjc2NDY3LC45MDE2NywuNTk1MjYsLjkxOTE2LDEsMSwuODYzMDQsLjY5MjI1LC44ODQwMSwxLDEsLjcwNDI0LC43NzMxMiwuOTE5MjYsLjg4MTc1LC43MDgyMywuOTQ5MDMsLjkwODcyLC44NjMzMSwxLDEsLjkwODcyLC44NjMzMSwuODY5MDYsLjg4MTE2LC44NjMzMSwuODU5MzgsLjg2MzMxLC44NTkzOCwuODYzMzEsLjg1OTM4LC44NjMzMSwuODc0MDIsLjg2NTQ5LC43Nzk1OCwuOTA0NjQsMSwxLC43Nzk1OCwuOTA0NjQsLjY5NzY2LC43MDg1MiwuNjk3NjYsLjcwODUyLC42OTc2NiwuNzA4NTIsLjY5NzY2LC43MDg1MiwxLDEsLjgxMDU1LC43NTg0MSwuODEwNTUsMS4wNjQ1MiwuOTAzOTksLjg2MzMxLC45MDM5OSwuODYzMzEsLjkwMzk5LC44NjMzMSwuOTAzOTksLjg2MzMxLC45MDM5OSwuODYzMzEsLjkwMzk5LC44NjMzMSwuOTYwNjgsLjk1Nzk0LC43Nzg5MiwuODQ1NDgsLjc3ODkyLC43ODI1NywuNzk0OTIsLjc4MjU3LC43OTQ5MiwuNzgyNTcsLjc5NDkyLC45Mjk3LC41Njg5MiwuODM5MDgsLjk0OTA4LC43NzUzOSwuODU4ODcsLjg3MDY4LC44OTA0OSwxLDEsLjgxMDU1LDEuMDQxMDYsMS4yMDUyOCwxLjIwNTI4LDEsMS4xNTU0MywuNzAwODgsLjk4Mzg3LC45NDcyMSwxLjMzNDMxLDEuNDU4OTQsLjk1MTYxLDEuNDgzODcsLjgzOTA4LC44MDM1MiwuNTcxMTgsLjY5NjUsLjU2MzQ3LC43OTE3OSwuNTU4NTMsLjgwMzQ2LDEuMDI5ODgsLjgzOTA4LC43NzYyLC42NzE3NCwuODYwMzYsLjczMTMzLC43ODI1NywuODczNTYsLjg2NDQxLC45NTk1OCwuNzU3MjcsLjg5MDE5LDEuMDQ5MjQsLjkwODcyLC43NDg4OSwuODU5MzgsLjg3ODkxLC43OTc5NSwuNzk1NywuODEwNTUsLjc3ODkyLC45NzQ0NywuODI1NzcsLjk3NDY2LC44NzE3OSwuOTU5NTgsLjc3ODkyLC45NDI1MiwuOTU2MTIsLjg3NTMsMS4wMjk4OCwuOTI3MzMsLjk0MjUyLC44NzQxMSwuODQwMjEsLjg3MjgsLjk1NjEyLC43NDA4MSwuODc1MywxLjAyMTg5LDEuMDI5ODgsLjg0ODE0LC44NzQ0NSwuOTE4MjIsLjg0NzIzLC44NTY2OCwuODYzMzEsLjgxMzQ0LC44NzU4MSwuNzY0MjIsLjgyMDQ2LC45NjA1NywuOTI3MzMsLjk5Mzc1LC43ODAyMiwuOTU0NTIsLjg2MDE1LDEuMDI5ODgsLjkyNzMzLC44NjMzMSwuOTI3MzMsLjg2MDE1LC43MzEzMywxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuOTA2MzEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjg4MzIzLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC44NTE3NCwxLDEsMSwxLDEsMSwuOTYwNjgsLjk1Nzk0LC45NjA2OCwuOTU3OTQsLjk2MDY4LC45NTc5NCwuNzc4OTIsLjg0NTQ4LDEsMSwuODk1NTIsLjkwNTI3LDEsLjkwMzYzLC45Mjc5NCwuOTI3OTQsLjkyNzk0LC44OTgwNywuODcwMTIsLjg3MDEyLC44NzAxMiwuODk1NTIsLjg5NTUyLDEuNDIyNTksLjcxMDk0LDEuMDYxNTIsMSwxLDEuMDMzNzIsMS4wMzM3MiwuOTcxNzEsMS40OTU2LDIuMjgwNywuOTI5NzIsLjgzNDA2LC45MTEzMywuODMzMjYsLjkxMTMzLDEsMSwxLC43MjAyMSwxLDEuMjMxMDgsLjgzNDg5LC44ODUyNSwuODg1MjUsLjgxNDk5LC45MDYxNiwxLjgxMDU1LC45MDUyNywxLjgxMDU1LDEuMzEwNywxLjUzNzExLC45NDQzNCwxLjA4Njk2LDEsLjk1MDE4LC43NzE5MiwuODUyODQsLjkwNzQ3LDEuMTc1MzQsLjY5ODI1LC45NzE2LDEuMzcwNzcsLjkwNzQ3LC45MDc0NywuODUzNTYsLjkwNzQ3LC45MDc0NywxLjQ0OTQ3LC44NTI4NCwuODk0MSwuODk0MSwuNzA1NzIsLjgsLjcwNTcyLC43MDU3MiwuNzA1NzIsLjcwNTcyLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuOTk4NjIsLjk5ODYyLDEsMSwxLDEsMSwxLjA4MDA0LC45MTAyNywxLDEsMSwuOTk4NjIsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjkwNzI3LC45MDcyNywxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMV0sd249e2xpbmVIZWlnaHQ6MS4yMjA3LGxpbmVHYXA6LjIyMDd9LHhuPVsxLjM4NzcsMSwxLDEsMS4xNzIyMywxLjEyOTMsLjg5NTUyLC45MTEzMywuODAzOTUsMS4wMjI2OSwxLjE1NjAxLC45MTA1NiwuOTEwNTYsMS4yNzk4LC44NTI4NCwuODk4MDcsMSwuOTA4NjEsMS4zOTU0MywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjk2MzA5LC45NjMwOSwuODUyODQsLjg1Mjg0LC44NTI4NCwuODMzMTksLjg4MDcxLC44Njc1LC44MTU1MiwuNzIzNDYsLjg1MTkzLC43MzIwNiwuNzUyMiwuODExMDUsLjg2Mjc1LC45MDY4NSwuNjM3NywuNzc4OTIsLjc1NTkzLDEuMDI2MzgsLjg5MjQ5LC44NDExOCwuNzc0NTIsLjg1Mzc0LC43NTE4NiwuNjc3ODksLjc5Nzc2LC44ODg0NCwuODUwNjYsLjk0MzA5LC43NzgxOCwuNzMwNiwuNzY2NTksMS4xMDM2OSwxLjM4MzEzLDEuMTAzNjksMS4wNjEzOSwuODk1NTIsLjg3MzksLjkyNDUsLjkyNDUsLjgzMjAzLC45MjQ1LC44NTg2NSwxLjA5ODQyLC45MjQ1LC45MjQ1LDEuMDMyOTcsMS4wNzY5MiwuOTA5MTgsMS4wMzI5NywuOTQ5NTksLjkyNDUsLjkyMjc0LC45MjQ1LC45MjQ1LDEuMDI5MzMsLjc3ODMyLDEuMjA1NjIsLjkyNDUsLjg5MTYsLjk4OTg2LC44NjYyMSwuODk0NTMsLjc5MDA0LC45NDE1MiwxLjc3MjU2LC45NDE1MiwuODUyODQsLjk3ODAxLC44OTU1MiwuOTExMzMsLjg5NTUyLC45MTEzMywxLjkxNzI5LC44OTU1MiwxLjE3ODg5LDEuMTMyNTQsMS4xNjM1OSwuOTIwOTgsLjg1Mjg0LC42ODc4NywuNzEzNTMsLjg0NzM3LC45MDc0NywxLjAwODgsMS4wMDQ0LC44NzY4MywxLDEuMDkwOTEsMSwuOTIyMjksLjczOSwxLjE1NjQyLC45MjA5OCwuNzYyODgsLjgwNTA0LC44MDk3MiwuNzU4NTksLjg2NzUsLjg2NzUsLjg2NzUsLjg2NzUsLjg2NzUsLjg2NzUsLjc2MzE4LC43MjM0NiwuNzMyMDYsLjczMjA2LC43MzIwNiwuNzMyMDYsLjkwNjg1LC45MDY4NSwuOTA2ODUsLjkwNjg1LC44NjQ3NywuODkyNDksLjg0MTE4LC44NDExOCwuODQxMTgsLjg0MTE4LC44NDExOCwuODUyODQsLjg0NTU3LC44ODg0NCwuODg4NDQsLjg4ODQ0LC44ODg0NCwuNzMwNiwuNzc0NTIsLjg2MzMxLC45MjQ1LC45MjQ1LC45MjQ1LC45MjQ1LC45MjQ1LC45MjQ1LC44NDg0MywuODMyMDMsLjg1ODY1LC44NTg2NSwuODU4NjUsLjg1ODY1LC44MjYwMSwuODI2MDEsLjgyNjAxLC44MjYwMSwuOTQ0NjksLjkyNDUsLjkyMjc0LC45MjI3NCwuOTIyNzQsLjkyMjc0LC45MjI3NCwuOTA3NDcsLjg2NjUxLC45MjQ1LC45MjQ1LC45MjQ1LC45MjQ1LC44OTQ1MywuOTI0NSwuODk0NTMsLjg2NzUsLjkyNDUsLjg2NzUsLjkyNDUsLjg2NzUsLjkyNDUsLjcyMzQ2LC44MzIwMywuNzIzNDYsLjgzMjAzLC43MjM0NiwuODMyMDMsLjcyMzQ2LC44MzIwMywuODUxOTMsLjg4NzUsLjg2NDc3LC45OTAzNCwuNzMyMDYsLjg1ODY1LC43MzIwNiwuODU4NjUsLjczMjA2LC44NTg2NSwuNzMyMDYsLjg1ODY1LC43MzIwNiwuODU4NjUsLjgxMTA1LC45MjQ1LC44MTEwNSwuOTI0NSwuODExMDUsLjkyNDUsMSwxLC44NjI3NSwuOTI0NSwuOTA4NzIsLjkzNTkxLC45MDY4NSwuODI2MDEsLjkwNjg1LC44MjYwMSwuOTA2ODUsLjgyNjAxLC45MDY4NSwxLjAzMjk3LC45MDY4NSwuODI2MDEsLjc3ODk2LDEuMDU2MTEsLjYzNzcsMS4wNzY5MiwxLDEsLjkwOTE4LC43NTU5MywxLjAzMjk3LDEsMSwuNzYwMzIsLjkzNzUsLjk4MTU2LC45MzQwNywuNzcyNjEsMS4xMTQyOSwuODkyNDksLjkyNDUsMSwxLC44OTI0OSwuOTI0NSwuOTI1MzQsLjg2Njk4LC45MjQ1LC44NDExOCwuOTIyNzQsLjg0MTE4LC45MjI3NCwuODQxMTgsLjkyMjc0LC44NjY3LC44NjI5MSwuNzUxODYsMS4wMjkzMywxLDEsLjc1MTg2LDEuMDI5MzMsLjY3Nzg5LC43NzgzMiwuNjc3ODksLjc3ODMyLC42Nzc4OSwuNzc4MzIsLjY3Nzg5LC43NzgzMiwxLDEsLjc5Nzc2LC45NzY1NSwuNzk3NzYsMS4yMzAyMywuODg4NDQsLjkyNDUsLjg4ODQ0LC45MjQ1LC44ODg0NCwuOTI0NSwuODg4NDQsLjkyNDUsLjg4ODQ0LC45MjQ1LC44ODg0NCwuOTI0NSwuOTQzMDksLjk4OTg2LC43MzA2LC44OTQ1MywuNzMwNiwuNzY2NTksLjc5MDA0LC43NjY1OSwuNzkwMDQsLjc2NjU5LC43OTAwNCwxLjA5MjMxLC41NDg3MywuODY3NSwuOTI0NSwuNzYzMTgsLjg0ODQzLC44NDU1NywuODY2NTEsMSwxLC43OTc3NiwxLjIwNTYyLDEuMTg2MjIsMS4xODYyMiwxLDEuMTQzNywuNjcwMDksLjk2MzM0LC45MzY5NSwxLjM1MTkxLDEuNDA5MDksLjk1MTYxLDEuNDgzODcsLjg2NzUsLjkwODYxLC42MTkyLC43MzYzLC42NDgyNCwuODI0MTEsLjU2MzIxLC44NTY5NiwxLjIzNTE2LC44Njc1LC44MTU1MiwuNzI4NiwuODQxMzQsLjczMjA2LC43NjY1OSwuODYyNzUsLjg0MzY5LC45MDY4NSwuNzc4OTIsLjg1ODcxLDEuMDI2MzgsLjg5MjQ5LC43NTgyOCwuODQxMTgsLjg1OTg0LC43NzQ1MiwuNzY0NjYsLjc5Nzc2LC43MzA2LC45MDc4MiwuNzc4MTgsLjkwMywuODcyOTEsLjkwNjg1LC43MzA2LC45OTA1OCwxLjAzNjY3LC45NDYzNSwxLjIzNTE2LC45ODQ5LC45OTA1OCwuOTIzOTMsLjg5MTYsLjk0MiwxLjAzNjY3LC43NTAyNiwuOTQ2MzUsMS4wMjk3LDEuMjM1MTYsLjkwOTE4LC45NDA0OCwuOTgyMTcsLjg5NzQ2LC44NDE1MywuOTIyNzQsLjgyNTA3LC44ODgzMiwuODQ0MzgsLjg4MTc4LDEuMDM1MjUsLjk4NDksMS4wMDIyNSwuNzgwODYsLjk3MjQ4LC44OTQwNCwxLjIzNTE2LC45ODQ5LC45MjI3NCwuOTg0OSwuODk0MDQsLjczMjA2LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC44OTY5MywxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuODU4NjUsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjkwOTMzLDEsMSwxLDEsMSwxLC45NDMwOSwuOTg5ODYsLjk0MzA5LC45ODk4NiwuOTQzMDksLjk4OTg2LC43MzA2LC44OTQ1MywxLDEsLjg5NTUyLC45MDUyNywxLC45MDE4NiwxLjEyMzA4LDEuMTIzMDgsMS4xMjMwOCwxLjEyMzA4LDEuMjU2NiwxLjI1NjYsMS4yNTY2LC44OTU1MiwuODk1NTIsMS40MjI1OSwuNjg5OTQsMS4wMzgwOSwxLDEsMS4wMTc2LDEuMDE3NiwxLjExNTIzLDEuNDk1NiwyLjAxNDYyLC45Nzg1OCwuODI2MTYsLjkxMTMzLC44MzQzNywuOTExMzMsMSwxLDEsLjcwNTA4LDEsMS4yMzEwOCwuNzk4MDEsLjg0NDI2LC44NDQyNiwuNzc0LC45MDU3MiwxLjgxMDU1LC45MDc0OSwxLjgxMDU1LDEuMjg4MDksMS41NTQ2OSwuOTQ0MzQsMS4wNzgwNiwxLC45NzA5NCwuNzU4OSwuODUyODQsLjkwNzQ3LDEuMTk2NTgsLjY5ODI1LC45NzYyMiwxLjMzNTEyLC45MDc0NywuOTA3NDcsLjg1Mjg0LC45MDc0NywuOTA3NDcsMS40NDk0NywuODUyODQsLjg5NDEsLjg5NDEsLjcwNTcyLC44LC43MDU3MiwuNzA1NzIsLjcwNTcyLC43MDU3MiwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjk5ODYyLC45OTg2MiwxLDEsMSwxLDEsMS4wMzM2LC45MTAyNywxLDEsMSwuOTk4NjIsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMS4wNTg1OSwxLjA1ODU5LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxXSxTbj17bGluZUhlaWdodDoxLjIyMDcsbGluZUdhcDouMjIwN30sQW49WzEuMzg3NywxLDEsMSwxLjE3MjIzLDEuMTI5MywuODk1NTIsLjkxMTMzLC44MDM5NSwxLjAyMjY5LDEuMTU2MDEsLjkxMDU2LC45MTA1NiwxLjI3OTgsLjg1Mjg0LC44OTgwNywxLC45MDg2MSwxLjM5MDE2LC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTExMzMsLjkxMTMzLC45MTEzMywuOTYzMDksLjk2MzA5LC44NTI4NCwuODUyODQsLjg1Mjg0LC44MzMxOSwuODgwNzEsLjg2NzUsLjgxNTUyLC43MzgzNCwuODUxOTMsLjczMjA2LC43NTIyLC44MTEwNSwuODYyNzUsLjkwNjg1LC42Mzc3LC43Nzg5MiwuNzU1OTMsMS4wMjYzOCwuODkzODUsLjg1MTIyLC43NzQ1MiwuODY1MDMsLjc1MTg2LC42ODg4NywuNzk3NzYsLjg4ODQ0LC44NTA2NiwuOTQyNTgsLjc3ODE4LC43MzA2LC43NjY1OSwxLjEwMzY5LDEuMzkwMTYsMS4xMDM2OSwxLjA2MTM5LC44OTU1MiwuODczOSwuODYxMjgsLjk0NDY5LC44NDU3LC45NDQ2OSwuODk0NjQsMS4wOTg0MiwuODQ2MzYsLjk0NDY5LDEuMDMyOTcsMS4wNzY5MiwuOTA5MTgsMS4wMzI5NywuOTU4OTcsLjk0NDY5LC45NDgyLC45NDQ2OSwuOTQ0NjksMS4wNDY5MiwuNzgyMjMsMS4yMDU2MiwuOTQ0NjksLjkwMzMyLC45ODk4NiwuODY2MjEsLjkwNTI3LC43OTAwNCwuOTQxNTIsMS43NzI1NiwuOTQxNTIsLjg1Mjg0LC45NzgwMSwuODk1NTIsLjkxMTMzLC44OTU1MiwuOTExMzMsMS45MTcyOSwuODk1NTIsMS4xNzg4OSwxLjEzMjU0LDEuMDg3MDcsLjkyMDk4LC44NTI4NCwuNjg3ODcsLjcxMzUzLC44NDczNywuOTA3NDcsMS4wMDg4LDEuMDA0NCwuODc2ODMsMSwxLjA5MDkxLDEsLjkyMjI5LC43MzksMS4xNTY0MiwuOTIwOTgsLjc2Mjg4LC44MDUwNCwuODA5NzIsLjc1ODU5LC44Njc1LC44Njc1LC44Njc1LC44Njc1LC44Njc1LC44Njc1LC43NjMxOCwuNzM4MzQsLjczMjA2LC43MzIwNiwuNzMyMDYsLjczMjA2LC45MDY4NSwuOTA2ODUsLjkwNjg1LC45MDY4NSwuODY0NzcsLjg5Mzg1LC44NTEyMiwuODUxMjIsLjg1MTIyLC44NTEyMiwuODUxMjIsLjg1Mjg0LC44NTMxMSwuODg4NDQsLjg4ODQ0LC44ODg0NCwuODg4NDQsLjczMDYsLjc3NDUyLC44NjMzMSwuODYxMjgsLjg2MTI4LC44NjEyOCwuODYxMjgsLjg2MTI4LC44NjEyOCwuODY5MywuODQ1NywuODk0NjQsLjg5NDY0LC44OTQ2NCwuODk0NjQsLjgyNjAxLC44MjYwMSwuODI2MDEsLjgyNjAxLC45NDQ2OSwuOTQ0NjksLjk0ODIsLjk0ODIsLjk0ODIsLjk0ODIsLjk0ODIsLjkwNzQ3LC44NjY1MSwuOTQ0NjksLjk0NDY5LC45NDQ2OSwuOTQ0NjksLjkwNTI3LC45NDQ2OSwuOTA1MjcsLjg2NzUsLjg2MTI4LC44Njc1LC44NjEyOCwuODY3NSwuODYxMjgsLjczODM0LC44NDU3LC43MzgzNCwuODQ1NywuNzM4MzQsLjg0NTcsLjczODM0LC44NDU3LC44NTE5MywuOTI0NTQsLjg2NDc3LC45OTIxLC43MzIwNiwuODk0NjQsLjczMjA2LC44OTQ2NCwuNzMyMDYsLjg5NDY0LC43MzIwNiwuODk0NjQsLjczMjA2LC44OTQ2NCwuODExMDUsLjg0NjM2LC44MTEwNSwuODQ2MzYsLjgxMTA1LC44NDYzNiwxLDEsLjg2Mjc1LC45NDQ2OSwuOTA4NzIsLjk1Nzg2LC45MDY4NSwuODI2MDEsLjkwNjg1LC44MjYwMSwuOTA2ODUsLjgyNjAxLC45MDY4NSwxLjAzMjk3LC45MDY4NSwuODI2MDEsLjc3NzQxLDEuMDU2MTEsLjYzNzcsMS4wNzY5MiwxLDEsLjkwOTE4LC43NTU5MywxLjAzMjk3LDEsMSwuNzYwMzIsLjkwNDUyLC45ODE1NiwxLjExODQyLC43NzI2MSwxLjExNDI5LC44OTM4NSwuOTQ0NjksMSwxLC44OTM4NSwuOTQ0NjksLjk1ODc3LC44NjkwMSwuOTQ0NjksLjg1MTIyLC45NDgyLC44NTEyMiwuOTQ4MiwuODUxMjIsLjk0ODIsLjg2NjcsLjkwMDE2LC43NTE4NiwxLjA0NjkyLDEsMSwuNzUxODYsMS4wNDY5MiwuNjg4ODcsLjc4MjIzLC42ODg4NywuNzgyMjMsLjY4ODg3LC43ODIyMywuNjg4ODcsLjc4MjIzLDEsMSwuNzk3NzYsLjkyMTg4LC43OTc3NiwxLjIzMDIzLC44ODg0NCwuOTQ0NjksLjg4ODQ0LC45NDQ2OSwuODg4NDQsLjk0NDY5LC44ODg0NCwuOTQ0NjksLjg4ODQ0LC45NDQ2OSwuODg4NDQsLjk0NDY5LC45NDI1OCwuOTg5ODYsLjczMDYsLjkwNTI3LC43MzA2LC43NjY1OSwuNzkwMDQsLjc2NjU5LC43OTAwNCwuNzY2NTksLjc5MDA0LDEuMDkyMzEsLjU0ODczLC44Njc1LC44NjEyOCwuNzYzMTgsLjg2OTMsLjg1MzExLC44NjY1MSwxLDEsLjc5Nzc2LDEuMjA1NjIsMS4xODYyMiwxLjE4NjIyLDEsMS4xNDM3LC42Nzc0MiwuOTYzMzQsLjkzNjk1LDEuMzUxOTEsMS40MDkwOSwuOTUxNjEsMS40ODM4NywuODY2ODYsLjkwODYxLC42MjI2NywuNzQzNTksLjY1NjQ5LC44NTQ5OCwuNTY5NjMsLjg4MjU0LDEuMjM1MTYsLjg2NzUsLjgxNTUyLC43NTQ0MywuODQ1MDMsLjczMjA2LC43NjY1OSwuODYyNzUsLjg1MTIyLC45MDY4NSwuNzc4OTIsLjg1NzQ2LDEuMDI2MzgsLjg5Mzg1LC43NTY1NywuODUxMjIsLjg2Mjc1LC43NzQ1MiwuNzQxNzEsLjc5Nzc2LC43MzA2LC45NTE2NSwuNzc4MTgsLjg5NzcyLC44ODgzMSwuOTA2ODUsLjczMDYsLjk4MTQyLDEuMDIxOTEsLjk2NTc2LDEuMjM1MTYsLjk5MDE4LC45ODE0MiwuOTIzNiwuODkyNTgsLjk0MDM1LDEuMDIxOTEsLjc4ODQ4LC45NjU3NiwuOTU2MSwxLjIzNTE2LC45MDkxOCwuOTI1NzgsLjk1NDI0LC44OTc0NiwuODM5NjksLjk0ODIsLjgwMTEzLC44OTQ0MiwuODUyMDgsLjg2MTU1LC45ODAyMiwuOTkwMTgsMS4wMDQ1MiwuODEyMDksLjk5MjQ3LC44OTE4MSwxLjIzNTE2LC45OTAxOCwuOTQ4MiwuOTkwMTgsLjg5MTgxLC43MzIwNiwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuODg4NDQsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjg5NDY0LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC45Njc2NiwxLDEsMSwxLDEsMSwuOTQyNTgsLjk4OTg2LC45NDI1OCwuOTg5ODYsLjk0MjU4LC45ODk4NiwuNzMwNiwuOTA1MjcsMSwxLC44OTU1MiwuOTA1MjcsMSwuOTAxODYsMS4xMjMwOCwxLjEyMzA4LDEuMTIzMDgsMS4xMjMwOCwxLjI1NjYsMS4yNTY2LDEuMjU2NiwuODk1NTIsLjg5NTUyLDEuNDIyNTksLjY5MDQzLDEuMDM4MDksMSwxLDEuMDE3NiwxLjAxNzYsMS4xMTUyMywxLjQ5NTYsMi4wMTQ2MiwuOTkzMzEsLjgyNjE2LC45MTEzMywuODQyODYsLjkxMTMzLDEsMSwxLC43MDUwOCwxLDEuMjMxMDgsLjc5ODAxLC44NDQyNiwuODQ0MjYsLjc3NCwuOTA1MjcsMS44MTA1NSwuOTA1MjcsMS44MTA1NSwxLjI4ODA5LDEuNTU0NjksLjk0NDM0LDEuMDc4MDYsMSwuOTcwOTQsLjc1ODksLjg1Mjg0LC45MDc0NywxLjE5NjU4LC42OTgyNSwuOTc2MjIsMS4zMzUxMiwuOTA3NDcsLjkwNzQ3LC44NTM1NiwuOTA3NDcsLjkwNzQ3LDEuNDQ5NDcsLjg1Mjg0LC44OTQxLC44OTQxLC43MDU3MiwuOCwuNzA1NzIsLjcwNTcyLC43MDU3MiwuNzA1NzIsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC45OTg2MiwuOTk4NjIsMSwxLDEsMSwxLDEuMDMzNiwuOTEwMjcsMSwxLDEsLjk5ODYyLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuMDU4NTksMS4wNTg1OSwxLDEsMSwxLjA3MTg1LC45OTQxMywuOTYzMzQsMS4wODA2NSwxLDEsMSwxLDEsMSwxLDEsMSwxLDFdLGtuPXtsaW5lSGVpZ2h0OjEuMjIwNyxsaW5lR2FwOi4yMjA3fSxDbj1bLjc2MTE2LDEsMSwxLjAwMDYsLjk5OTk4LC45OTk3NCwuOTk5NzMsLjk5OTczLC45OTk4MiwuOTk5NzcsMS4wMDA4NywuOTk5OTgsLjk5OTk4LC45OTk1OSwxLjAwMDAzLDEuMDAwNiwuOTk5OTgsMS4wMDA2LDEuMDAwNiwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTk4LDEsMS4wMDAwMywxLjAwMDAzLDEuMDAwMDMsMS4wMDAyNiwuOTk5OSwuOTk5NzcsLjk5OTc3LC45OTk3NywuOTk5NzcsMS4wMDAwMSwxLjAwMDI2LDEuMDAwMjIsLjk5OTc3LDEuMDAwNiwuOTk5NzMsLjk5OTc3LDEuMDAwMjYsLjk5OTk5LC45OTk3NywxLjAwMDIyLDEuMDAwMDEsMS4wMDAyMiwuOTk5NzcsMS4wMDAwMSwxLjAwMDI2LC45OTk3NywxLjAwMDAxLDEuMDAwMTYsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjYsLjk5OTk4LDEuMDAwNiwuOTk5OTgsMS4wMDAwMywuOTk5NzMsLjk5OTk4LC45OTk3MywxLjAwMDI2LC45OTk3MywxLjAwMDI2LC45OTk3MywuOTk5OTgsMS4wMDAyNiwxLjAwMDI2LDEuMDAwNiwxLjAwMDYsLjk5OTczLDEuMDAwNiwuOTk5ODIsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwuOTk5NTksLjk5OTczLC45OTk5OCwxLjAwMDI2LC45OTk3MywxLjAwMDIyLC45OTk3MywuOTk5NzMsMSwuOTk5NTksMS4wMDA3NywuOTk5NTksMS4wMDAwMywuOTk5OTgsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLDEuMDAwNzcsLjk5OTczLC45OTk5OCwxLjAwMDI1LC45OTk2OCwuOTk5NzMsMS4wMDAwMywxLjAwMDI1LC42MDI5OSwxLjAwMDI0LDEuMDY0MDksMSwxLC45OTk5OCwxLC45OTk3MywxLjAwMDYsLjk5OTk4LDEsLjk5OTM2LC45OTk3MywxLjAwMDAyLDEuMDAwMDIsMS4wMDAwMiwxLjAwMDI2LC45OTk3NywuOTk5NzcsLjk5OTc3LC45OTk3NywuOTk5NzcsLjk5OTc3LDEsLjk5OTc3LDEuMDAwMDEsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMDEsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LC45OTk3NywuOTk5NzcsMS4wMDAyMiwxLjAwMDIyLDEuMDAwMjIsMS4wMDAyMiwxLjAwMDIyLDEuMDAwMDMsMS4wMDAyMiwuOTk5NzcsLjk5OTc3LC45OTk3NywuOTk5NzcsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjYsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTgyLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsMS4wNjQwOSwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsLjk5OTczLDEuMDAwMjYsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LDEuMDMzNzQsLjk5OTc3LDEuMDAwMjYsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAyMiwxLjAwMDI2LDEuMDAwMjIsMS4wMDAyNiwxLjAwMDIyLDEuMDAwMjYsMS4wMDAyMiwxLjAwMDI2LC45OTk3NywxLjAwMDI2LC45OTk3NywxLjAwMDI2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDQyLC45OTk3MywuOTk5NzMsMS4wMDA2LC45OTk3NywuOTk5NzMsLjk5OTczLDEuMDAwMjYsMS4wMDA2LDEuMDAwMjYsMS4wMDA2LDEuMDAwMjYsMS4wMzgyOCwxLjAwMDI2LC45OTk5OSwxLjAwMDI2LDEuMDAwNiwuOTk5NzcsMS4wMDAyNiwuOTk5NzcsMS4wMDAyNiwuOTk5NzcsMS4wMDAyNiwuOTk5MywuOTk5OCwxLjAwMDI2LDEuMDAwMjIsMS4wMDAyNiwxLjAwMDIyLDEuMDAwMjYsMS4wMDAyMiwxLjAwMDI2LDEsMS4wMDAxNiwuOTk5NzcsLjk5OTU5LC45OTk3NywuOTk5NTksLjk5OTc3LC45OTk1OSwxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDI2LC45OTk5OCwxLjAwMDI2LC44MTIxLDEuMDAwMjYsLjk5OTk4LC45OTk3NywxLjAwMDI2LC45OTk3NywxLjAwMDI2LC45OTk3NywxLjAwMDI2LC45OTk3NywxLjAwMDI2LC45OTk3NywxLjAwMDI2LC45OTk3NywxLjAwMDI2LDEuMDAwMTYsMS4wMDAyMiwxLjAwMDAxLC45OTk3MywxLjAwMDAxLDEuMDAwMjYsMSwxLjAwMDI2LDEsMS4wMDAyNiwxLDEuMDAwNiwuOTk5NzMsLjk5OTc3LC45OTk3MywxLC45OTk4MiwxLjAwMDIyLDEuMDAwMjYsMS4wMDAwMSwuOTk5NzMsMS4wMDAyNiwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LDEuMDAwMzQsLjk5OTc3LDEsLjk5OTk3LDEuMDAwMjYsMS4wMDA3OCwxLjAwMDM2LC45OTk3MywxLjAwMDEzLDEuMDAwNiwuOTk5NzcsLjk5OTc3LC45OTk4OCwuODUxNDgsMS4wMDAwMSwxLjAwMDI2LC45OTk3NywxLjAwMDIyLDEuMDAwNiwuOTk5NzcsMS4wMDAwMSwuOTk5OTksLjk5OTc3LDEuMDAwNjksMS4wMDAyMiwuOTk5NzcsMS4wMDAwMSwuOTk5ODQsMS4wMDAyNiwxLjAwMDAxLDEuMDAwMjQsMS4wMDAwMSwuOTk5OSwxLDEuMDAwNiwxLjAwMDAxLDEuMDAwNDEsLjk5OTYyLDEuMDAwMjYsMS4wMDA2LC45OTk5NSwxLjAwMDQxLC45OTk0MiwuOTk5NzMsLjk5OTI3LDEuMDAwODIsLjk5OTAyLDEuMDAwMjYsMS4wMDA4NywxLjAwMDYsMS4wMDA2OSwuOTk5NzMsLjk5ODY3LC45OTk3MywuOTk5MywxLjAwMDI2LDEuMDAwNDksMS4wMDA1NiwxLC45OTk4OCwuOTk5MzUsLjk5OTk1LC45OTk1NCwxLjAwMDU1LC45OTk0NSwxLjAwMDMyLDEuMDAwNiwuOTk5OTUsMS4wMDAyNiwuOTk5OTUsMS4wMDAzMiwxLjAwMDAxLDEuMDAwMDgsLjk5OTcxLDEuMDAwMTksLjk5OTQsMS4wMDAwMSwxLjAwMDYsMS4wMDA0NCwuOTk5NzMsMS4wMDAyMywxLjAwMDQ3LDEsLjk5OTQyLC45OTU2MSwuOTk5ODksMS4wMDAzNSwuOTk5NzcsMS4wMDAzNSwuOTk5NzcsMS4wMDAxOSwuOTk5NDQsMS4wMDAwMSwxLjAwMDIxLC45OTkyNiwxLjAwMDM1LDEuMDAwMzUsLjk5OTQyLDEuMDAwNDgsLjk5OTk5LC45OTk3NywxLjAwMDIyLDEuMDAwMzUsMS4wMDAwMSwuOTk5NzcsMS4wMDAyNiwuOTk5ODksMS4wMDA1NywxLjAwMDAxLC45OTkzNiwxLjAwMDUyLDEuMDAwMTIsLjk5OTk2LDEuMDAwNDMsMSwxLjAwMDM1LC45OTk0LC45OTk3NiwxLjAwMDM1LC45OTk3MywxLjAwMDUyLDEuMDAwNDEsMS4wMDExOSwxLjAwMDM3LC45OTk3MywxLjAwMDAyLC45OTk4NiwxLjAwMDQxLDEuMDAwNDEsLjk5OTAyLC45OTk2LDEuMDAwMzQsLjk5OTk5LDEuMDAwMjYsLjk5OTk5LDEuMDAwMjYsLjk5OTczLDEuMDAwNTIsLjk5OTczLDEsLjk5OTczLDEuMDAwNDEsMS4wMDA3NSwuOTk5NCwxLjAwMDMsLjk5OTk5LDEsMS4wMDA0MSwuOTk5NTUsMSwuOTk5MTUsLjk5OTczLC45OTk3MywxLjAwMDI2LDEuMDAxMTksLjk5OTU1LC45OTk3MywxLjAwMDYsLjk5OTExLDEuMDAwNiwxLjAwMDI2LC45OTk3MiwxLjAwMDI2LC45OTkwMiwxLjAwMDQxLC45OTk3MywuOTk5OTksMSwxLDEuMDAwMzgsMS4wMDA1LDEuMDAwMTYsMS4wMDAyMiwxLjAwMDE2LDEuMDAwMjIsMS4wMDAxNiwxLjAwMDIyLDEuMDAwMDEsLjk5OTczLDEsMSwuOTk5NzMsMSwxLC45OTk1NSwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMSwxLDEsLjk5OTczLC45OTk3MywuOTk5NzIsMSwxLDEuMDAxMDYsLjk5OTk5LC45OTk5OCwuOTk5OTgsLjk5OTk5LC45OTk5OCwxLjY2NDc1LDEsLjk5OTczLC45OTk3MywxLjAwMDIzLC45OTk3MywuOTk5NzEsMS4wMDA0NywxLjAwMDIzLDEsLjk5OTkxLC45OTk4NCwxLjAwMDAyLDEuMDAwMDIsMS4wMDAwMiwxLjAwMDAyLDEsMSwxLDEsMSwxLDEsLjk5OTcyLDEsMS4yMDk4NSwxLjM5NzEzLDEuMDAwMDMsMS4wMDAzMSwxLjAwMDE1LDEsLjk5NTYxLDEuMDAwMjcsMS4wMDAzMSwxLjAwMDMxLC45OTkxNSwxLjAwMDMxLDEuMDAwMzEsLjk5OTk5LDEuMDAwMDMsLjk5OTk5LC45OTk5OSwxLjQxMTQ0LDEuNiwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDA1NzksMS40MDU3OSwxLjM2NjI1LC45OTk5OSwxLC45OTg2MSwuOTk4NjEsMSwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LC45OTk3MiwuOTk5OTksLjk5OTk5LC45OTk5OSwuOTk5OTksMS40MDQ4MywxLC45OTk3NywxLjAwMDU0LDEsMSwuOTk5NTMsLjk5OTYyLDEuMDAwNDIsLjk5OTUsMSwxLDEsMSwxLDEsMSwxLC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwxLDEsMSwxLDEsMSwxLDEsMSwxLDFdLHZuPXtsaW5lSGVpZ2h0OjEuMixsaW5lR2FwOi4yfSxGbj1bLjc2MTE2LDEsMSwxLjAwMDYsLjk5OTk4LC45OTk3NCwuOTk5NzMsLjk5OTczLC45OTk4MiwuOTk5NzcsMS4wMDA4NywuOTk5OTgsLjk5OTk4LC45OTk1OSwxLjAwMDAzLDEuMDAwNiwuOTk5OTgsMS4wMDA2LDEuMDAwNiwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTk4LDEsMS4wMDAwMywxLjAwMDAzLDEuMDAwMDMsMS4wMDAyNiwuOTk5OSwuOTk5NzcsLjk5OTc3LC45OTk3NywuOTk5NzcsMS4wMDAwMSwxLjAwMDI2LDEuMDAwMjIsLjk5OTc3LDEuMDAwNiwuOTk5NzMsLjk5OTc3LDEuMDAwMjYsLjk5OTk5LC45OTk3NywxLjAwMDIyLDEuMDAwMDEsMS4wMDAyMiwuOTk5NzcsMS4wMDAwMSwxLjAwMDI2LC45OTk3NywxLjAwMDAxLDEuMDAwMTYsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjYsLjk5OTk4LDEuMDAwNiwuOTk5OTgsMS4wMDAwMywuOTk5NzMsLjk5OTk4LC45OTk3MywxLjAwMDI2LC45OTk3MywxLjAwMDI2LC45OTk3MywuOTk5OTgsMS4wMDAyNiwxLjAwMDI2LDEuMDAwNiwxLjAwMDYsLjk5OTczLDEuMDAwNiwuOTk5ODIsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwuOTk5NTksLjk5OTczLC45OTk5OCwxLjAwMDI2LC45OTk3MywxLjAwMDIyLC45OTk3MywuOTk5NzMsMSwuOTk5NTksMS4wMDA3NywuOTk5NTksMS4wMDAwMywuOTk5OTgsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLDEuMDAwNzcsLjk5OTczLC45OTk5OCwxLjAwMDI1LC45OTk2OCwuOTk5NzMsMS4wMDAwMywxLjAwMDI1LC42MDI5OSwxLjAwMDI0LDEuMDY0MDksMSwxLC45OTk5OCwxLC45OTk3MywxLjAwMDYsLjk5OTk4LDEsLjk5OTM2LC45OTk3MywxLjAwMDAyLDEuMDAwMDIsMS4wMDAwMiwxLjAwMDI2LC45OTk3NywuOTk5NzcsLjk5OTc3LC45OTk3NywuOTk5NzcsLjk5OTc3LDEsLjk5OTc3LDEuMDAwMDEsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMDEsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LC45OTk3NywuOTk5NzcsMS4wMDAyMiwxLjAwMDIyLDEuMDAwMjIsMS4wMDAyMiwxLjAwMDIyLDEuMDAwMDMsMS4wMDAyMiwuOTk5NzcsLjk5OTc3LC45OTk3NywuOTk5NzcsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjYsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTgyLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsMS4wNjQwOSwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsLjk5OTczLDEuMDAwMjYsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LDEuMDA0NCwuOTk5NzcsMS4wMDAyNiwxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDIyLDEuMDAwMjYsMS4wMDAyMiwxLjAwMDI2LDEuMDAwMjIsMS4wMDAyNiwxLjAwMDIyLDEuMDAwMjYsLjk5OTc3LDEuMDAwMjYsLjk5OTc3LDEuMDAwMjYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LC45OTk3MSwuOTk5NzMsLjk5OTczLDEuMDAwNiwuOTk5NzcsLjk5OTczLC45OTk3MywxLjAwMDI2LDEuMDAwNiwxLjAwMDI2LDEuMDAwNiwxLjAwMDI2LDEuMDEwMTEsMS4wMDAyNiwuOTk5OTksMS4wMDAyNiwxLjAwMDYsLjk5OTc3LDEuMDAwMjYsLjk5OTc3LDEuMDAwMjYsLjk5OTc3LDEuMDAwMjYsLjk5OTMsLjk5OTgsMS4wMDAyNiwxLjAwMDIyLDEuMDAwMjYsMS4wMDAyMiwxLjAwMDI2LDEuMDAwMjIsMS4wMDAyNiwxLDEuMDAwMTYsLjk5OTc3LC45OTk1OSwuOTk5NzcsLjk5OTU5LC45OTk3NywuOTk5NTksMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAyNiwuOTk5OTgsMS4wMDAyNiwuODEyMSwxLjAwMDI2LC45OTk5OCwuOTk5NzcsMS4wMDAyNiwuOTk5NzcsMS4wMDAyNiwuOTk5NzcsMS4wMDAyNiwuOTk5NzcsMS4wMDAyNiwuOTk5NzcsMS4wMDAyNiwuOTk5NzcsMS4wMDAyNiwxLjAwMDE2LDEuMDAwMjIsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwxLjAwMDI2LDEsMS4wMDAyNiwxLDEuMDAwMjYsMSwxLjAwMDYsLjk5OTczLC45OTk3NywuOTk5NzMsMSwuOTk5ODIsMS4wMDAyMiwxLjAwMDI2LDEuMDAwMDEsLjk5OTczLDEuMDAwMjYsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTc3LDEsMSwxLjAwMDI2LC45OTk2OSwuOTk5NzIsLjk5OTgxLC45OTk4LDEuMDAwNiwuOTk5NzcsLjk5OTc3LDEuMDAwMjIsLjkxMTU1LDEuMDAwMDEsMS4wMDAyNiwuOTk5NzcsMS4wMDAyMiwxLjAwMDYsLjk5OTc3LDEuMDAwMDEsLjk5OTk5LC45OTk3NywuOTk5NjYsMS4wMDAyMiwxLjAwMDMyLDEuMDAwMDEsLjk5OTQ0LDEuMDAwMjYsMS4wMDAwMSwuOTk5NjgsMS4wMDAwMSwxLjAwMDQ3LDEsMS4wMDA2LDEuMDAwMDEsLjk5OTgxLDEuMDAxMDEsMS4wMDAyNiwxLjAwMDYsLjk5OTQ4LC45OTk4MSwxLjAwMDY0LC45OTk3MywuOTk5NDIsMS4wMDEwMSwxLjAwMDYxLDEuMDAwMjYsMS4wMDA2OSwxLjAwMDYsMS4wMDAxNCwuOTk5NzMsMS4wMTMyMiwuOTk5NzMsMS4wMDA2NSwxLjAwMDI2LDEuMDAwMTIsLjk5OTIzLDEsMS4wMDA2NCwxLjAwMDc2LC45OTk0OCwxLjAwMDU1LDEuMDAwNjMsMS4wMDAwNywuOTk5NDMsMS4wMDA2LC45OTk0OCwxLjAwMDI2LC45OTk0OCwuOTk5NDMsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjksMS4wMDAzOCwxLjAwMDM1LDEuMDAwMDEsMS4wMDA2LDEuMDAwNiwuOTk5NzMsLjk5OTc4LDEuMDAwMDEsMS4wMDA1NywuOTk5ODksLjk5OTY3LC45OTk2NCwuOTk5NjcsLjk5OTc3LC45OTk5OSwuOTk5NzcsMS4wMDAzOCwuOTk5NzcsMS4wMDAwMSwuOTk5NzMsMS4wMDA2NiwuOTk5NjcsLjk5OTY3LDEuMDAwNDEsLjk5OTk4LC45OTk5OSwuOTk5NzcsMS4wMDAyMiwuOTk5NjcsMS4wMDAwMSwuOTk5NzcsMS4wMDAyNiwuOTk5NjQsMS4wMDAzMSwxLjAwMDAxLC45OTk5OSwuOTk5OTksMSwxLjAwMDIzLDEsMSwuOTk5OTksMS4wMDAzNSwxLjAwMDAxLC45OTk5OSwuOTk5NzMsLjk5OTc3LC45OTk5OSwxLjAwMDU4LC45OTk3MywuOTk5NzMsLjk5OTU1LC45OTk1LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDMyLC45OTk4OSwxLjAwMDM0LC45OTk5OSwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwuOTk5NzMsLjQ1OTk4LC45OTk3MywxLjAwMDI2LC45OTk3MywxLjAwMDAxLC45OTk5OSwuOTk5ODIsLjk5OTk0LC45OTk5NiwxLDEuMDAwNDIsMS4wMDA0NCwxLjAwMDI5LDEuMDAwMjMsLjk5OTczLC45OTk3MywxLjAwMDI2LC45OTk0OSwxLjAwMDAyLC45OTk3MywxLjAwMDYsMS4wMDA2LDEuMDAwNiwuOTk5NzUsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMzIsLjk4Njg1LC45OTk3MywxLjAwMDI2LDEsMSwuOTk5NjYsMS4wMDA0NCwxLjAwMDE2LDEuMDAwMjIsMS4wMDAxNiwxLjAwMDIyLDEuMDAwMTYsMS4wMDAyMiwxLjAwMDAxLC45OTk3MywxLDEsLjk5OTczLDEsMSwuOTk5NTUsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEsMSwxLC45OTk3MywuOTk5NzMsLjk5OTcyLDEsMSwxLjAwMTA2LC45OTk5OSwuOTk5OTgsLjk5OTk4LC45OTk5OSwuOTk5OTgsMS42NjQ3NSwxLC45OTk3MywuOTk5NzMsMSwuOTk5NzMsLjk5OTcxLC45OTk3OCwxLDEsLjk5OTkxLC45OTk4NCwxLjAwMDAyLDEuMDAwMDIsMS4wMDAwMiwxLjAwMDAyLDEuMDAwOTgsMSwxLDEsMS4wMDA0OSwxLDEsLjk5OTcyLDEsMS4yMDk4NSwxLjM5NzEzLDEuMDAwMDMsMS4wMDAzMSwxLjAwMDE1LDEsLjk5NTYxLDEuMDAwMjcsMS4wMDAzMSwxLjAwMDMxLC45OTkxNSwxLjAwMDMxLDEuMDAwMzEsLjk5OTk5LDEuMDAwMDMsLjk5OTk5LC45OTk5OSwxLjQxMTQ0LDEuNiwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDA1NzksMS40MDU3OSwxLjM2NjI1LC45OTk5OSwxLC45OTg2MSwuOTk4NjEsMSwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LC45OTk3MiwuOTk5OTksLjk5OTk5LC45OTk5OSwuOTk5OTksMS40MDQ4MywxLC45OTk3NywxLjAwMDU0LDEsMSwuOTk5NTMsLjk5OTYyLDEuMDAwNDIsLjk5OTUsMSwxLDEsMSwxLDEsMSwxLC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwxLDEsMSwxLDEsMSwxLDEsMSwxLDFdLEluPXtsaW5lSGVpZ2h0OjEuMzUsbGluZUdhcDouMn0sVG49Wy43NjExNiwxLDEsMS4wMDA2LDEuMDAwNiwxLjAwMDA2LC45OTk3MywuOTk5NzMsLjk5OTgyLDEuMDAwMDEsMS4wMDA0MywuOTk5OTgsLjk5OTk4LC45OTk1OSwxLjAwMDAzLDEuMDAwNiwuOTk5OTgsMS4wMDA2LDEuMDAwNiwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsMS4wMDA2LDEsMS4wMDAwMywxLjAwMDAzLDEuMDAwMDMsLjk5OTczLC45OTk4NywxLjAwMDAxLDEuMDAwMDEsLjk5OTc3LC45OTk3NywxLjAwMDAxLDEuMDAwMjYsMS4wMDAyMiwuOTk5NzcsMS4wMDA2LDEsMS4wMDAwMSwuOTk5NzMsLjk5OTk5LC45OTk3NywxLjAwMDIyLDEuMDAwMDEsMS4wMDAyMiwuOTk5NzcsMS4wMDAwMSwxLjAwMDI2LC45OTk3NywxLjAwMDAxLDEuMDAwMTYsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsLjk5OTQ5LC45OTk3MywuOTk5OTgsLjk5OTczLC45OTk3MywxLC45OTk3MywuOTk5NzMsMS4wMDA2LC45OTk3MywuOTk5NzMsLjk5OTI0LC45OTkyNCwxLC45OTkyNCwuOTk5OTksLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk5OCwxLDEuMDAwNiwuOTk5NzMsMSwuOTk5NzcsMSwxLDEsMS4wMDAwNSwxLjAwMDksMS4wMDAwNSwxLjAwMDAzLC45OTk5OCwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsMS4wMDA5LC45OTk3MywuOTk5OTgsMS4wMDAyNSwuOTk5NjgsLjk5OTczLDEuMDAwMDMsMS4wMDAyNSwuNjAyOTksMS4wMDAyNCwxLjA2NDA5LDEsMSwuOTk5OTgsMSwuOTk5OCwxLjAwMDYsLjk5OTk4LDEsLjk5OTM2LC45OTk3MywxLjAwMDAyLDEuMDAwMDIsMS4wMDAwMiwxLjAwMDI2LDEuMDAwMDEsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMDEsMS4wMDAwMSwxLjAwMDAxLDEsLjk5OTc3LDEuMDAwMDEsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMDEsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LC45OTk3NywuOTk5NzcsMS4wMDAyMiwxLjAwMDIyLDEuMDAwMjIsMS4wMDAyMiwxLjAwMDIyLDEuMDAwMDMsMS4wMDAyMiwuOTk5NzcsLjk5OTc3LC45OTk3NywuOTk5NzcsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjYsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTgyLDEsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsMS4wNjQwOSwxLjAwMDI2LC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywxLC45OTk3MywxLDEuMDAwMDEsLjk5OTczLDEuMDAwMDEsLjk5OTczLDEuMDAwMDEsLjk5OTczLC45OTk3NywxLC45OTk3NywxLC45OTk3NywxLC45OTk3NywxLC45OTk3NywxLjAyODgsLjk5OTc3LC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDIyLC45OTk3MywxLjAwMDIyLC45OTk3MywxLjAwMDIyLC45OTk3MywxLjAwMDIyLC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LC45OTkyNCwxLjAwMDYsMS4wMDA2LC45OTk0NiwxLjAwMDM0LDEsLjk5OTI0LDEuMDAwMDEsMSwxLC45OTk3MywuOTk5MjQsLjk5OTczLC45OTkyNCwuOTk5NzMsMS4wNjMxMSwuOTk5NzMsMS4wMDAyNCwuOTk5NzMsLjk5OTI0LC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLDEuMDAwNDEsLjk5OTgsLjk5OTczLDEuMDAwMjIsLjk5OTczLDEuMDAwMjIsLjk5OTczLDEuMDAwMjIsLjk5OTczLDEsMS4wMDAxNiwuOTk5NzcsLjk5OTk4LC45OTk3NywuOTk5OTgsLjk5OTc3LC45OTk5OCwxLjAwMDAxLDEsMS4wMDAwMSwxLDEuMDAwMDEsMSwxLjAwMDAxLDEsMS4wMDAyNiwxLjAwMDYsMS4wMDAyNiwuODk1NDcsMS4wMDAyNiwxLjAwMDYsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsMS4wMDAxNiwuOTk5NzcsMS4wMDAwMSwxLDEuMDAwMDEsMS4wMDAyNiwxLDEuMDAwMjYsMSwxLjAwMDI2LDEsLjk5OTI0LC45OTk3MywxLjAwMDAxLC45OTk3MywxLC45OTk4MiwxLjAwMDIyLDEuMDAwMjYsMS4wMDAwMSwxLDEuMDAwMjYsMS4wMDA2LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsMS4wMDAwMSwxLDEuMDAwNTQsLjk5OTc3LDEuMDAwODQsMS4wMDAwNywuOTk5NzMsMS4wMDAxMywuOTk5MjQsMS4wMDAwMSwxLjAwMDAxLC45OTk0NSwuOTEyMjEsMS4wMDAwMSwxLjAwMDI2LC45OTk3NywxLjAwMDIyLDEuMDAwNiwxLjAwMDAxLDEuMDAwMDEsLjk5OTk5LC45OTk3NywuOTk5MzMsMS4wMDAyMiwxLjAwMDU0LDEuMDAwMDEsMS4wMDA2NSwxLjAwMDI2LDEuMDAwMDEsMS4wMDAxLDEuMDAwMDEsMS4wMDA1MiwxLDEuMDAwNiwxLjAwMDAxLC45OTk0NSwuOTk4OTcsLjk5OTY4LC45OTkyNCwxLjAwMDM2LC45OTk0NSwuOTk5NDksMSwxLjAwMDYsLjk5ODk3LC45OTkxOCwuOTk5NjgsLjk5OTExLC45OTkyNCwxLC45OTk2MiwxLjAxNDg3LDEsMS4wMDA1LC45OTk3MywxLjAwMDEyLDEuMDAwNDMsMSwuOTk5OTUsLjk5OTk0LDEuMDAwMzYsLjk5OTQ3LDEuMDAwMTksMS4wMDA2MywxLjAwMDI1LC45OTkyNCwxLjAwMDM2LC45OTk3MywxLjAwMDM2LDEuMDAwMjUsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMjcsMS4wMDAxLDEuMDAwNjgsMS4wMDAwMSwxLjAwMDYsMS4wMDA2LDEsMS4wMDAwOCwuOTk5NTcsLjk5OTcyLC45OTk0LC45OTk1NCwuOTk5NzUsMS4wMDA1MSwxLjAwMDAxLDEuMDAwMTksMS4wMDAwMSwxLjAwMDEsLjk5OTg2LDEuMDAwMDEsMS4wMDAwMSwxLjAwMDM4LC45OTk1NCwuOTk5NTQsLjk5OTQsMS4wMDA2NiwuOTk5OTksLjk5OTc3LDEuMDAwMjIsMS4wMDA1NCwxLjAwMDAxLC45OTk3NywxLjAwMDI2LC45OTk3NSwxLjAwMDEsMS4wMDAwMSwuOTk5OTMsLjk5OTUsLjk5OTU1LDEuMDAwMTYsLjk5OTc4LC45OTk3NCwxLjAwMDE5LDEuMDAwMjIsLjk5OTU1LDEuMDAwNTMsLjk5OTczLDEuMDAwODksMS4wMDAwNSwuOTk5NjcsMS4wMDA0OCwuOTk5NzMsMS4wMDAwMiwxLjAwMDM0LC45OTk3MywuOTk5NzMsLjk5OTY0LDEuMDAwMDYsMS4wMDA2NiwuOTk5NDcsLjk5OTczLC45ODg5NCwuOTk5NzMsMSwuNDQ4OTgsMSwuOTk5NDYsMSwxLjAwMDM5LDEuMDAwODIsLjk5OTkxLC45OTk5MSwuOTk5ODUsMS4wMDAyMiwxLjAwMDIzLDEuMDAwNjEsMS4wMDAwNiwuOTk5NjYsLjk5OTczLC45OTk3MywuOTk5NzMsMS4wMDAxOSwxLjAwMDgsMSwuOTk5MjQsLjk5OTI0LC45OTkyNCwuOTk5ODMsMS4wMDA0NCwuOTk5NzMsLjk5OTY0LC45ODMzMiwxLC45OTk3MywxLDEsLjk5OTYyLC45OTg5NSwxLjAwMDE2LC45OTk3NywxLjAwMDE2LC45OTk3NywxLjAwMDE2LC45OTk3NywxLjAwMDAxLDEsMSwxLC45OTk3MywxLDEsLjk5OTU1LC45OTkyNCwuOTk5MjQsLjk5OTI0LC45OTkyNCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5NzMsLjk5OTczLC45OTk3MiwxLDEsMS4wMDI2NywuOTk5OTksLjk5OTk4LC45OTk5OCwxLC45OTk5OCwxLjY2NDc1LDEsLjk5OTczLC45OTk3MywxLjAwMDIzLC45OTk3MywxLjAwNDIzLC45OTkyNSwuOTk5OTksMSwuOTk5OTEsLjk5OTg0LDEuMDAwMDIsMS4wMDAwMiwxLjAwMDAyLDEuMDAwMDIsMS4wMDA0OSwxLDEuMDAyNDUsMSwxLDEsMSwuOTYzMjksMSwxLjIwOTg1LDEuMzk3MTMsMS4wMDAwMywuODI1NCwxLjAwMDE1LDEsMS4wMDAzNSwxLjAwMDI3LDEuMDAwMzEsMS4wMDAzMSwxLjAwMDAzLDEuMDAwMzEsMS4wMDAzMSwuOTk5OTksMS4wMDAwMywuOTk5OTksLjk5OTk5LDEuNDExNDQsMS42LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MDU3OSwxLjQwNTc5LDEuMzY2MjUsLjk5OTk5LDEsLjk5ODYxLC45OTg2MSwxLDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LDEuMDAwMjYsLjk1MzE3LC45OTk5OSwuOTk5OTksLjk5OTk5LC45OTk5OSwxLjQwNDgzLDEsLjk5OTc3LDEuMDAwNTQsMSwxLC45OTk1MywuOTk5NjIsMS4wMDA0MiwuOTk5NSwxLDEsMSwxLDEsMSwxLDEsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LDEsMSwxLDEsMSwxLDEsMSwxLDEsMV0sT249e2xpbmVIZWlnaHQ6MS4zNSxsaW5lR2FwOi4yfSxNbj1bLjc2MTE2LDEsMSwxLjAwMDYsMS4wMDA2LDEuMDAwMDYsLjk5OTczLC45OTk3MywuOTk5ODIsMS4wMDAwMSwxLjAwMDQzLC45OTk5OCwuOTk5OTgsLjk5OTU5LDEuMDAwMDMsMS4wMDA2LC45OTk5OCwxLjAwMDYsMS4wMDA2LC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywxLjAwMDYsMSwxLjAwMDAzLDEuMDAwMDMsMS4wMDAwMywuOTk5NzMsLjk5OTg3LDEuMDAwMDEsMS4wMDAwMSwuOTk5NzcsLjk5OTc3LDEuMDAwMDEsMS4wMDAyNiwxLjAwMDIyLC45OTk3NywxLjAwMDYsMSwxLjAwMDAxLC45OTk3MywuOTk5OTksLjk5OTc3LDEuMDAwMjIsMS4wMDAwMSwxLjAwMDIyLC45OTk3NywxLjAwMDAxLDEuMDAwMjYsLjk5OTc3LDEuMDAwMDEsMS4wMDAxNiwxLjAwMDAxLDEuMDAwMDEsMS4wMDAyNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwuOTk5NDksLjk5OTczLC45OTk5OCwuOTk5NzMsLjk5OTczLDEsLjk5OTczLC45OTk3MywxLjAwMDYsLjk5OTczLC45OTk3MywuOTk5MjQsLjk5OTI0LDEsLjk5OTI0LC45OTk5OSwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTk4LDEsMS4wMDA2LC45OTk3MywxLC45OTk3NywxLDEsMSwxLjAwMDA1LDEuMDAwOSwxLjAwMDA1LDEuMDAwMDMsLjk5OTk4LC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywxLjAwMDksLjk5OTczLC45OTk5OCwxLjAwMDI1LC45OTk2OCwuOTk5NzMsMS4wMDAwMywxLjAwMDI1LC42MDI5OSwxLjAwMDI0LDEuMDY0MDksMSwxLC45OTk5OCwxLC45OTk4LDEuMDAwNiwuOTk5OTgsMSwuOTk5MzYsLjk5OTczLDEuMDAwMDIsMS4wMDAwMiwxLjAwMDAyLDEuMDAwMjYsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMDEsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMDEsMSwuOTk5NzcsMS4wMDAwMSwxLjAwMDAxLDEuMDAwMDEsMS4wMDAwMSwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsLjk5OTc3LC45OTk3NywxLjAwMDIyLDEuMDAwMjIsMS4wMDAyMiwxLjAwMDIyLDEuMDAwMjIsMS4wMDAwMywxLjAwMDIyLC45OTk3NywuOTk5NzcsLjk5OTc3LC45OTk3NywxLjAwMDAxLDEuMDAwMDEsMS4wMDAyNiwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5ODIsMSwuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLC45OTk3MywxLjA2NDA5LDEuMDAwMjYsLjk5OTczLC45OTk3MywuOTk5NzMsLjk5OTczLDEsLjk5OTczLDEsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsMS4wMDAwMSwuOTk5NzMsLjk5OTc3LDEsLjk5OTc3LDEsLjk5OTc3LDEsLjk5OTc3LDEsLjk5OTc3LDEuMDQ1OTYsLjk5OTc3LC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDAxLC45OTk3MywxLjAwMDIyLC45OTk3MywxLjAwMDIyLC45OTk3MywxLjAwMDIyLC45OTk3MywxLjAwMDIyLC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LDEuMDAwNiwxLjAwMDYsMS4wMDA2LC45OTkyNCwxLjAwMDYsMS4wMDA2LDEuMDAwMTksMS4wMDAzNCwxLC45OTkyNCwxLjAwMDAxLDEsMSwuOTk5NzMsLjk5OTI0LC45OTk3MywuOTk5MjQsLjk5OTczLDEuMDI1NzIsLjk5OTczLDEuMDAwMDUsLjk5OTczLC45OTkyNCwuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5OTksLjk5OTgsLjk5OTczLDEuMDAwMjIsLjk5OTczLDEuMDAwMjIsLjk5OTczLDEuMDAwMjIsLjk5OTczLDEsMS4wMDAxNiwuOTk5NzcsLjk5OTk4LC45OTk3NywuOTk5OTgsLjk5OTc3LC45OTk5OCwxLjAwMDAxLDEsMS4wMDAwMSwxLDEuMDAwMDEsMSwxLjAwMDAxLDEsMS4wMDAyNiwxLjAwMDYsMS4wMDAyNiwuODQ1MzMsMS4wMDAyNiwxLjAwMDYsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsLjk5OTc3LC45OTk3MywuOTk5NzcsLjk5OTczLC45OTk3NywuOTk5NzMsMS4wMDAxNiwuOTk5NzcsMS4wMDAwMSwxLDEuMDAwMDEsMS4wMDAyNiwxLDEuMDAwMjYsMSwxLjAwMDI2LDEsLjk5OTI0LC45OTk3MywxLjAwMDAxLC45OTk3MywxLC45OTk4MiwxLjAwMDIyLDEuMDAwMjYsMS4wMDAwMSwxLDEuMDAwMjYsMS4wMDA2LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk5OCwuOTk5OTgsLjk5OTI4LDEsLjk5OTc3LDEuMDAwMTMsMS4wMDA1NSwuOTk5NDcsLjk5OTQ1LC45OTk0MSwuOTk5MjQsMS4wMDAwMSwxLjAwMDAxLDEuMDAwNCwuOTE2MjEsMS4wMDAwMSwxLjAwMDI2LC45OTk3NywxLjAwMDIyLDEuMDAwNiwxLjAwMDAxLDEuMDAwMDUsLjk5OTk5LC45OTk3NywxLjAwMDE1LDEuMDAwMjIsLjk5OTc3LDEuMDAwMDEsLjk5OTczLDEuMDAwMjYsMS4wMDAwMSwxLjAwMDE5LDEuMDAwMDEsLjk5OTQ2LDEsMS4wMDA2LDEuMDAwMDEsLjk5OTc4LDEuMDAwNDUsLjk5OTczLC45OTkyNCwxLjAwMDIzLC45OTk3OCwuOTk5NjYsMSwxLjAwMDY1LDEuMDAwNDUsMS4wMDAxOSwuOTk5NzMsLjk5OTczLC45OTkyNCwxLDEsLjk2NDk5LDEsMS4wMDA1NSwuOTk5NzMsMS4wMDAwOCwxLjAwMDI3LDEsLjk5OTcsLjk5OTk1LDEuMDAwMjMsLjk5OTMzLDEuMDAwMTksMS4wMDAxNSwxLjAwMDMxLC45OTkyNCwxLjAwMDIzLC45OTk3MywxLjAwMDIzLDEuMDAwMzEsMS4wMDAwMSwuOTk5MjgsMS4wMDAyOSwxLjAwMDkyLDEuMDAwMzUsMS4wMDAwMSwxLjAwMDYsMS4wMDA2LDEsLjk5OTg4LC45OTk3NSwxLDEuMDAwODIsLjk5NTYxLC45OTk2LDEuMDAwMzUsMS4wMDAwMSwuOTk5NjIsMS4wMDAwMSwxLjAwMDkyLC45OTk2NCwxLjAwMDAxLC45OTk2MywuOTk5OTksMS4wMDAzNSwxLjAwMDM1LDEuMDAwODIsLjk5OTYyLC45OTk5OSwuOTk5NzcsMS4wMDAyMiwxLjAwMDM1LDEuMDAwMDEsLjk5OTc3LDEuMDAwMjYsLjk5OTYsLjk5OTY3LDEuMDAwMDEsMS4wMDAzNCwxLjAwMDc0LDEuMDAwNTQsMS4wMDA1MywxLjAwMDYzLC45OTk3MSwuOTk5NjIsMS4wMDAzNSwuOTk5NzUsLjk5OTc3LC45OTk3MywxLjAwMDQzLC45OTk1MywxLjAwMDcsLjk5OTE1LC45OTk3MywxLjAwMDA4LC45OTg5MiwxLjAwMDczLDEuMDAwNzMsMS4wMDExNCwuOTk5MTUsMS4wMDA3MywuOTk5NTUsLjk5OTczLDEuMDAwOTIsLjk5OTczLDEsLjk5OTk4LDEsMS4wMDAzLDEsMS4wMDA0MywxLjAwMDAxLC45OTk2OSwxLjAwMDMsMSwxLjAwMDM1LDEuMDAwMDEsLjk5OTUsMSwxLjAwMDkyLC45OTk3MywuOTk5NzMsLjk5OTczLDEuMDAwNywuOTk5NSwxLC45OTkyNCwxLjAwMDYsLjk5OTI0LC45OTk3MiwxLjAwMDYyLC45OTk3MywxLjAwMTE0LDEuMDAwNzMsMSwuOTk5NTUsMSwxLDEuMDAwNDcsLjk5OTY4LDEuMDAwMTYsLjk5OTc3LDEuMDAwMTYsLjk5OTc3LDEuMDAwMTYsLjk5OTc3LDEuMDAwMDEsMSwxLDEsLjk5OTczLDEsMSwuOTk5NTUsLjk5OTI0LC45OTkyNCwuOTk5MjQsLjk5OTI0LC45OTk5OCwuOTk5OTgsLjk5OTk4LC45OTk3MywuOTk5NzMsLjk5OTcyLDEsMSwxLjAwMjY3LC45OTk5OSwuOTk5OTgsLjk5OTk4LDEsLjk5OTk4LDEuNjY0NzUsMSwuOTk5NzMsLjk5OTczLDEuMDAwMjMsLjk5OTczLC45OTk3MSwuOTk5MjUsMS4wMDAyMywxLC45OTk5MSwuOTk5ODQsMS4wMDAwMiwxLjAwMDAyLDEuMDAwMDIsMS4wMDAwMiwxLDEsMSwxLDEsMSwxLC45NjMyOSwxLDEuMjA5ODUsMS4zOTcxMywxLjAwMDAzLC44MjU0LDEuMDAwMTUsMSwxLjAwMDM1LDEuMDAwMjcsMS4wMDAzMSwxLjAwMDMxLC45OTkxNSwxLjAwMDMxLDEuMDAwMzEsLjk5OTk5LDEuMDAwMDMsLjk5OTk5LC45OTk5OSwxLjQxMTQ0LDEuNiwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDExNDQsMS40MTE0NCwxLjQxMTQ0LDEuNDA1NzksMS40MDU3OSwxLjM2NjI1LC45OTk5OSwxLC45OTg2MSwuOTk4NjEsMSwxLjAwMDI2LDEuMDAwMjYsMS4wMDAyNiwxLjAwMDI2LC45NTMxNywuOTk5OTksLjk5OTk5LC45OTk5OSwuOTk5OTksMS40MDQ4MywxLC45OTk3NywxLjAwMDU0LDEsMSwuOTk5NTMsLjk5OTYyLDEuMDAwNDIsLjk5OTUsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxXSxEbj17bGluZUhlaWdodDoxLjIsbGluZUdhcDouMn0sQm49WzM2NSwwLDMzMywyNzgsMzMzLDQ3NCw1NTYsNTU2LDg4OSw3MjIsMjM4LDMzMywzMzMsMzg5LDU4NCwyNzgsMzMzLDI3OCwyNzgsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDMzMywzMzMsNTg0LDU4NCw1ODQsNjExLDk3NSw3MjIsNzIyLDcyMiw3MjIsNjY3LDYxMSw3NzgsNzIyLDI3OCw1NTYsNzIyLDYxMSw4MzMsNzIyLDc3OCw2NjcsNzc4LDcyMiw2NjcsNjExLDcyMiw2NjcsOTQ0LDY2Nyw2NjcsNjExLDMzMywyNzgsMzMzLDU4NCw1NTYsMzMzLDU1Niw2MTEsNTU2LDYxMSw1NTYsMzMzLDYxMSw2MTEsMjc4LDI3OCw1NTYsMjc4LDg4OSw2MTEsNjExLDYxMSw2MTEsMzg5LDU1NiwzMzMsNjExLDU1Niw3NzgsNTU2LDU1Niw1MDAsMzg5LDI4MCwzODksNTg0LDMzMyw1NTYsNTU2LDU1Niw1NTYsMjgwLDU1NiwzMzMsNzM3LDM3MCw1NTYsNTg0LDczNyw1NTIsNDAwLDU0OSwzMzMsMzMzLDMzMyw1NzYsNTU2LDI3OCwzMzMsMzMzLDM2NSw1NTYsODM0LDgzNCw4MzQsNjExLDcyMiw3MjIsNzIyLDcyMiw3MjIsNzIyLDFlMyw3MjIsNjY3LDY2Nyw2NjcsNjY3LDI3OCwyNzgsMjc4LDI3OCw3MjIsNzIyLDc3OCw3NzgsNzc4LDc3OCw3NzgsNTg0LDc3OCw3MjIsNzIyLDcyMiw3MjIsNjY3LDY2Nyw2MTEsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsODg5LDU1Niw1NTYsNTU2LDU1Niw1NTYsMjc4LDI3OCwyNzgsMjc4LDYxMSw2MTEsNjExLDYxMSw2MTEsNjExLDYxMSw1NDksNjExLDYxMSw2MTEsNjExLDYxMSw1NTYsNjExLDU1Niw3MjIsNTU2LDcyMiw1NTYsNzIyLDU1Niw3MjIsNTU2LDcyMiw1NTYsNzIyLDU1Niw3MjIsNTU2LDcyMiw3MTksNzIyLDYxMSw2NjcsNTU2LDY2Nyw1NTYsNjY3LDU1Niw2NjcsNTU2LDY2Nyw1NTYsNzc4LDYxMSw3NzgsNjExLDc3OCw2MTEsNzc4LDYxMSw3MjIsNjExLDcyMiw2MTEsMjc4LDI3OCwyNzgsMjc4LDI3OCwyNzgsMjc4LDI3OCwyNzgsMjc4LDc4NSw1NTYsNTU2LDI3OCw3MjIsNTU2LDU1Niw2MTEsMjc4LDYxMSwyNzgsNjExLDM4NSw2MTEsNDc5LDYxMSwyNzgsNzIyLDYxMSw3MjIsNjExLDcyMiw2MTEsNzA4LDcyMyw2MTEsNzc4LDYxMSw3NzgsNjExLDc3OCw2MTEsMWUzLDk0NCw3MjIsMzg5LDcyMiwzODksNzIyLDM4OSw2NjcsNTU2LDY2Nyw1NTYsNjY3LDU1Niw2NjcsNTU2LDYxMSwzMzMsNjExLDQ3OSw2MTEsMzMzLDcyMiw2MTEsNzIyLDYxMSw3MjIsNjExLDcyMiw2MTEsNzIyLDYxMSw3MjIsNjExLDk0NCw3NzgsNjY3LDU1Niw2NjcsNjExLDUwMCw2MTEsNTAwLDYxMSw1MDAsMjc4LDU1Niw3MjIsNTU2LDFlMyw4ODksNzc4LDYxMSw2NjcsNTU2LDYxMSwzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDQ2NSw3MjIsMzMzLDg1Myw5MDYsNDc0LDgyNSw5MjcsODM4LDI3OCw3MjIsNzIyLDYwMSw3MTksNjY3LDYxMSw3MjIsNzc4LDI3OCw3MjIsNjY3LDgzMyw3MjIsNjQ0LDc3OCw3MjIsNjY3LDYwMCw2MTEsNjY3LDgyMSw2NjcsODA5LDgwMiwyNzgsNjY3LDYxNSw0NTEsNjExLDI3OCw1ODIsNjE1LDYxMCw1NTYsNjA2LDQ3NSw0NjAsNjExLDU0MSwyNzgsNTU4LDU1Niw2MTIsNTU2LDQ0NSw2MTEsNzY2LDYxOSw1MjAsNjg0LDQ0Niw1ODIsNzE1LDU3Niw3NTMsODQ1LDI3OCw1ODIsNjExLDU4Miw4NDUsNjY3LDY2OSw4ODUsNTY3LDcxMSw2NjcsMjc4LDI3Niw1NTYsMTA5NCwxMDYyLDg3NSw2MTAsNzIyLDYyMiw3MTksNzIyLDcxOSw3MjIsNTY3LDcxMiw2NjcsOTA0LDYyNiw3MTksNzE5LDYxMCw3MDIsODMzLDcyMiw3NzgsNzE5LDY2Nyw3MjIsNjExLDYyMiw4NTQsNjY3LDczMCw3MDMsMTAwNSwxMDE5LDg3MCw5NzksNzE5LDcxMSwxMDMxLDcxOSw1NTYsNjE4LDYxNSw0MTcsNjM1LDU1Niw3MDksNDk3LDYxNSw2MTUsNTAwLDYzNSw3NDAsNjA0LDYxMSw2MDQsNjExLDU1Niw0OTAsNTU2LDg3NSw1NTYsNjE1LDU4MSw4MzMsODQ0LDcyOSw4NTQsNjE1LDU1Miw4NTQsNTgzLDU1Niw1NTYsNjExLDQxNyw1NTIsNTU2LDI3OCwyODEsMjc4LDk2OSw5MDYsNjExLDUwMCw2MTUsNTU2LDYwNCw3NzgsNjExLDQ4Nyw0NDcsOTQ0LDc3OCw5NDQsNzc4LDk0NCw3NzgsNjY3LDU1NiwzMzMsMzMzLDU1NiwxZTMsMWUzLDU1MiwyNzgsMjc4LDI3OCwyNzgsNTAwLDUwMCw1MDAsNTU2LDU1NiwzNTAsMWUzLDFlMywyNDAsNDc5LDMzMywzMzMsNjA0LDMzMywxNjcsMzk2LDU1Niw1NTYsMTA5NCw1NTYsODg1LDQ4OSwxMTE1LDFlMyw3NjgsNjAwLDgzNCw4MzQsODM0LDgzNCwxZTMsNTAwLDFlMyw1MDAsMWUzLDUwMCw1MDAsNDk0LDYxMiw4MjMsNzEzLDU4NCw1NDksNzEzLDk3OSw3MjIsMjc0LDU0OSw1NDksNTgzLDU0OSw1NDksNjA0LDU4NCw2MDQsNjA0LDcwOCw2MjUsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzI5LDYwNCw2MDQsMzU0LDM1NCwxZTMsOTkwLDk5MCw5OTAsOTkwLDQ5NCw2MDQsNjA0LDYwNCw2MDQsMzU0LDEwMjEsMTA1Miw5MTcsNzUwLDc1MCw1MzEsNjU2LDU5NCw1MTAsNTAwLDc1MCw3NTAsNjExLDYxMSwzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDIyMiwyMjIsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzM10sUm49Wy0xLC0xLC0xLDMyLDMzLDM0LDM1LDM2LDM3LDM4LDM5LDQwLDQxLDQyLDQzLDQ0LDQ1LDQ2LDQ3LDQ4LDQ5LDUwLDUxLDUyLDUzLDU0LDU1LDU2LDU3LDU4LDU5LDYwLDYxLDYyLDYzLDY0LDY1LDY2LDY3LDY4LDY5LDcwLDcxLDcyLDczLDc0LDc1LDc2LDc3LDc4LDc5LDgwLDgxLDgyLDgzLDg0LDg1LDg2LDg3LDg4LDg5LDkwLDkxLDkyLDkzLDk0LDk1LDk2LDk3LDk4LDk5LDEwMCwxMDEsMTAyLDEwMywxMDQsMTA1LDEwNiwxMDcsMTA4LDEwOSwxMTAsMTExLDExMiwxMTMsMTE0LDExNSwxMTYsMTE3LDExOCwxMTksMTIwLDEyMSwxMjIsMTIzLDEyNCwxMjUsMTI2LDE2MSwxNjIsMTYzLDE2NCwxNjUsMTY2LDE2NywxNjgsMTY5LDE3MCwxNzEsMTcyLDE3NCwxNzUsMTc2LDE3NywxNzgsMTc5LDE4MCwxODEsMTgyLDE4MywxODQsMTg1LDE4NiwxODcsMTg4LDE4OSwxOTAsMTkxLDE5MiwxOTMsMTk0LDE5NSwxOTYsMTk3LDE5OCwxOTksMjAwLDIwMSwyMDIsMjAzLDIwNCwyMDUsMjA2LDIwNywyMDgsMjA5LDIxMCwyMTEsMjEyLDIxMywyMTQsMjE1LDIxNiwyMTcsMjE4LDIxOSwyMjAsMjIxLDIyMiwyMjMsMjI0LDIyNSwyMjYsMjI3LDIyOCwyMjksMjMwLDIzMSwyMzIsMjMzLDIzNCwyMzUsMjM2LDIzNywyMzgsMjM5LDI0MCwyNDEsMjQyLDI0MywyNDQsMjQ1LDI0NiwyNDcsMjQ4LDI0OSwyNTAsMjUxLDI1MiwyNTMsMjU0LDI1NSwyNTYsMjU3LDI1OCwyNTksMjYwLDI2MSwyNjIsMjYzLDI2NCwyNjUsMjY2LDI2NywyNjgsMjY5LDI3MCwyNzEsMjcyLDI3MywyNzQsMjc1LDI3NiwyNzcsMjc4LDI3OSwyODAsMjgxLDI4MiwyODMsMjg0LDI4NSwyODYsMjg3LDI4OCwyODksMjkwLDI5MSwyOTIsMjkzLDI5NCwyOTUsMjk2LDI5NywyOTgsMjk5LDMwMCwzMDEsMzAyLDMwMywzMDQsMzA1LDMwNiwzMDcsMzA4LDMwOSwzMTAsMzExLDMxMiwzMTMsMzE0LDMxNSwzMTYsMzE3LDMxOCwzMTksMzIwLDMyMSwzMjIsMzIzLDMyNCwzMjUsMzI2LDMyNywzMjgsMzI5LDMzMCwzMzEsMzMyLDMzMywzMzQsMzM1LDMzNiwzMzcsMzM4LDMzOSwzNDAsMzQxLDM0MiwzNDMsMzQ0LDM0NSwzNDYsMzQ3LDM0OCwzNDksMzUwLDM1MSwzNTIsMzUzLDM1NCwzNTUsMzU2LDM1NywzNTgsMzU5LDM2MCwzNjEsMzYyLDM2MywzNjQsMzY1LDM2NiwzNjcsMzY4LDM2OSwzNzAsMzcxLDM3MiwzNzMsMzc0LDM3NSwzNzYsMzc3LDM3OCwzNzksMzgwLDM4MSwzODIsMzgzLDQwMiw1MDYsNTA3LDUwOCw1MDksNTEwLDUxMSw1MzYsNTM3LDUzOCw1MzksNzEwLDcxMSw3MTMsNzI4LDcyOSw3MzAsNzMxLDczMiw3MzMsOTAwLDkwMSw5MDIsOTAzLDkwNCw5MDUsOTA2LDkwOCw5MTAsOTExLDkxMiw5MTMsOTE0LDkxNSw5MTYsOTE3LDkxOCw5MTksOTIwLDkyMSw5MjIsOTIzLDkyNCw5MjUsOTI2LDkyNyw5MjgsOTI5LDkzMSw5MzIsOTMzLDkzNCw5MzUsOTM2LDkzNyw5MzgsOTM5LDk0MCw5NDEsOTQyLDk0Myw5NDQsOTQ1LDk0Niw5NDcsOTQ4LDk0OSw5NTAsOTUxLDk1Miw5NTMsOTU0LDk1NSw5NTYsOTU3LDk1OCw5NTksOTYwLDk2MSw5NjIsOTYzLDk2NCw5NjUsOTY2LDk2Nyw5NjgsOTY5LDk3MCw5NzEsOTcyLDk3Myw5NzQsMTAyNCwxMDI1LDEwMjYsMTAyNywxMDI4LDEwMjksMTAzMCwxMDMxLDEwMzIsMTAzMywxMDM0LDEwMzUsMTAzNiwxMDM3LDEwMzgsMTAzOSwxMDQwLDEwNDEsMTA0MiwxMDQzLDEwNDQsMTA0NSwxMDQ2LDEwNDcsMTA0OCwxMDQ5LDEwNTAsMTA1MSwxMDUyLDEwNTMsMTA1NCwxMDU1LDEwNTYsMTA1NywxMDU4LDEwNTksMTA2MCwxMDYxLDEwNjIsMTA2MywxMDY0LDEwNjUsMTA2NiwxMDY3LDEwNjgsMTA2OSwxMDcwLDEwNzEsMTA3MiwxMDczLDEwNzQsMTA3NSwxMDc2LDEwNzcsMTA3OCwxMDc5LDEwODAsMTA4MSwxMDgyLDEwODMsMTA4NCwxMDg1LDEwODYsMTA4NywxMDg4LDEwODksMTA5MCwxMDkxLDEwOTIsMTA5MywxMDk0LDEwOTUsMTA5NiwxMDk3LDEwOTgsMTA5OSwxMTAwLDExMDEsMTEwMiwxMTAzLDExMDQsMTEwNSwxMTA2LDExMDcsMTEwOCwxMTA5LDExMTAsMTExMSwxMTEyLDExMTMsMTExNCwxMTE1LDExMTYsMTExNywxMTE4LDExMTksMTEzOCwxMTM5LDExNjgsMTE2OSw3ODA4LDc4MDksNzgxMCw3ODExLDc4MTIsNzgxMyw3OTIyLDc5MjMsODIwOCw4MjA5LDgyMTEsODIxMiw4MjEzLDgyMTUsODIxNiw4MjE3LDgyMTgsODIxOSw4MjIwLDgyMjEsODIyMiw4MjI0LDgyMjUsODIyNiw4MjMwLDgyNDAsODI0Miw4MjQzLDgyNDksODI1MCw4MjUyLDgyNTQsODI2MCw4MzE5LDgzNTUsODM1Niw4MzU5LDgzNjQsODQ1Myw4NDY3LDg0NzAsODQ4Miw4NDg2LDg0OTQsODUzOSw4NTQwLDg1NDEsODU0Miw4NTkyLDg1OTMsODU5NCw4NTk1LDg1OTYsODU5Nyw4NjE2LDg3MDYsODcxMCw4NzE5LDg3MjEsODcyMiw4NzMwLDg3MzQsODczNSw4NzQ1LDg3NDcsODc3Niw4ODAwLDg4MDEsODgwNCw4ODA1LDg5NjIsODk3Niw4OTkyLDg5OTMsOTQ3Miw5NDc0LDk0ODQsOTQ4OCw5NDkyLDk0OTYsOTUwMCw5NTA4LDk1MTYsOTUyNCw5NTMyLDk1NTIsOTU1Myw5NTU0LDk1NTUsOTU1Niw5NTU3LDk1NTgsOTU1OSw5NTYwLDk1NjEsOTU2Miw5NTYzLDk1NjQsOTU2NSw5NTY2LDk1NjcsOTU2OCw5NTY5LDk1NzAsOTU3MSw5NTcyLDk1NzMsOTU3NCw5NTc1LDk1NzYsOTU3Nyw5NTc4LDk1NzksOTU4MCw5NjAwLDk2MDQsOTYwOCw5NjEyLDk2MTYsOTYxNyw5NjE4LDk2MTksOTYzMiw5NjMzLDk2NDIsOTY0Myw5NjQ0LDk2NTAsOTY1OCw5NjYwLDk2NjgsOTY3NCw5Njc1LDk2NzksOTY4OCw5Njg5LDk3MDIsOTc4Niw5Nzg3LDk3ODgsOTc5Miw5Nzk0LDk4MjQsOTgyNyw5ODI5LDk4MzAsOTgzNCw5ODM1LDk4MzYsNjE0NDEsNjE0NDIsNjE0NDUsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTEsLTFdLEVuPVszNjUsMCwzMzMsMjc4LDMzMyw0NzQsNTU2LDU1Niw4ODksNzIyLDIzOCwzMzMsMzMzLDM4OSw1ODQsMjc4LDMzMywyNzgsMjc4LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1NiwzMzMsMzMzLDU4NCw1ODQsNTg0LDYxMSw5NzUsNzIyLDcyMiw3MjIsNzIyLDY2Nyw2MTEsNzc4LDcyMiwyNzgsNTU2LDcyMiw2MTEsODMzLDcyMiw3NzgsNjY3LDc3OCw3MjIsNjY3LDYxMSw3MjIsNjY3LDk0NCw2NjcsNjY3LDYxMSwzMzMsMjc4LDMzMyw1ODQsNTU2LDMzMyw1NTYsNjExLDU1Niw2MTEsNTU2LDMzMyw2MTEsNjExLDI3OCwyNzgsNTU2LDI3OCw4ODksNjExLDYxMSw2MTEsNjExLDM4OSw1NTYsMzMzLDYxMSw1NTYsNzc4LDU1Niw1NTYsNTAwLDM4OSwyODAsMzg5LDU4NCwzMzMsNTU2LDU1Niw1NTYsNTU2LDI4MCw1NTYsMzMzLDczNywzNzAsNTU2LDU4NCw3MzcsNTUyLDQwMCw1NDksMzMzLDMzMywzMzMsNTc2LDU1NiwyNzgsMzMzLDMzMywzNjUsNTU2LDgzNCw4MzQsODM0LDYxMSw3MjIsNzIyLDcyMiw3MjIsNzIyLDcyMiwxZTMsNzIyLDY2Nyw2NjcsNjY3LDY2NywyNzgsMjc4LDI3OCwyNzgsNzIyLDcyMiw3NzgsNzc4LDc3OCw3NzgsNzc4LDU4NCw3NzgsNzIyLDcyMiw3MjIsNzIyLDY2Nyw2NjcsNjExLDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDg4OSw1NTYsNTU2LDU1Niw1NTYsNTU2LDI3OCwyNzgsMjc4LDI3OCw2MTEsNjExLDYxMSw2MTEsNjExLDYxMSw2MTEsNTQ5LDYxMSw2MTEsNjExLDYxMSw2MTEsNTU2LDYxMSw1NTYsNzIyLDU1Niw3MjIsNTU2LDcyMiw1NTYsNzIyLDU1Niw3MjIsNTU2LDcyMiw1NTYsNzIyLDU1Niw3MjIsNzQwLDcyMiw2MTEsNjY3LDU1Niw2NjcsNTU2LDY2Nyw1NTYsNjY3LDU1Niw2NjcsNTU2LDc3OCw2MTEsNzc4LDYxMSw3NzgsNjExLDc3OCw2MTEsNzIyLDYxMSw3MjIsNjExLDI3OCwyNzgsMjc4LDI3OCwyNzgsMjc4LDI3OCwyNzgsMjc4LDI3OCw3ODIsNTU2LDU1NiwyNzgsNzIyLDU1Niw1NTYsNjExLDI3OCw2MTEsMjc4LDYxMSwzOTYsNjExLDQ3OSw2MTEsMjc4LDcyMiw2MTEsNzIyLDYxMSw3MjIsNjExLDcwOCw3MjMsNjExLDc3OCw2MTEsNzc4LDYxMSw3NzgsNjExLDFlMyw5NDQsNzIyLDM4OSw3MjIsMzg5LDcyMiwzODksNjY3LDU1Niw2NjcsNTU2LDY2Nyw1NTYsNjY3LDU1Niw2MTEsMzMzLDYxMSw0NzksNjExLDMzMyw3MjIsNjExLDcyMiw2MTEsNzIyLDYxMSw3MjIsNjExLDcyMiw2MTEsNzIyLDYxMSw5NDQsNzc4LDY2Nyw1NTYsNjY3LDYxMSw1MDAsNjExLDUwMCw2MTEsNTAwLDI3OCw1NTYsNzIyLDU1NiwxZTMsODg5LDc3OCw2MTEsNjY3LDU1Niw2MTEsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsNzIyLDMzMyw4NTQsOTA2LDQ3Myw4NDQsOTMwLDg0NywyNzgsNzIyLDcyMiw2MTAsNjcxLDY2Nyw2MTEsNzIyLDc3OCwyNzgsNzIyLDY2Nyw4MzMsNzIyLDY1Nyw3NzgsNzE4LDY2Nyw1OTAsNjExLDY2Nyw4MjIsNjY3LDgyOSw3ODEsMjc4LDY2Nyw2MjAsNDc5LDYxMSwyNzgsNTkxLDYyMCw2MjEsNTU2LDYxMCw0NzksNDkyLDYxMSw1NTgsMjc4LDU2Niw1NTYsNjAzLDU1Niw0NTAsNjExLDcxMiw2MDUsNTMyLDY2NCw0MDksNTkxLDcwNCw1NzgsNzczLDgzNCwyNzgsNTkxLDYxMSw1OTEsODM0LDY2Nyw2NjcsODg2LDYxNCw3MTksNjY3LDI3OCwyNzgsNTU2LDEwOTQsMTA0Miw4NTQsNjIyLDcxOSw2NzcsNzE5LDcyMiw3MDgsNzIyLDYxNCw3MjIsNjY3LDkyNyw2NDMsNzE5LDcxOSw2MTUsNjg3LDgzMyw3MjIsNzc4LDcxOSw2NjcsNzIyLDYxMSw2NzcsNzgxLDY2Nyw3MjksNzA4LDk3OSw5ODksODU0LDFlMyw3MDgsNzE5LDEwNDIsNzI5LDU1Niw2MTksNjA0LDUzNCw2MTgsNTU2LDczNiw1MTAsNjExLDYxMSw1MDcsNjIyLDc0MCw2MDQsNjExLDYxMSw2MTEsNTU2LDg4OSw1NTYsODg1LDU1Niw2NDYsNTgzLDg4OSw5MzUsNzA3LDg1NCw1OTQsNTUyLDg2NSw1ODksNTU2LDU1Niw2MTEsNDY5LDU2Myw1NTYsMjc4LDI3OCwyNzgsOTY5LDkwNiw2MTEsNTA3LDYxOSw1NTYsNjExLDc3OCw2MTEsNTc1LDQ2Nyw5NDQsNzc4LDk0NCw3NzgsOTQ0LDc3OCw2NjcsNTU2LDMzMywzMzMsNTU2LDFlMywxZTMsNTUyLDI3OCwyNzgsMjc4LDI3OCw1MDAsNTAwLDUwMCw1NTYsNTU2LDM1MCwxZTMsMWUzLDI0MCw0NzksMzMzLDMzMyw2MDQsMzMzLDE2NywzOTYsNTU2LDU1NiwxMTA0LDU1Niw4ODUsNTE2LDExNDYsMWUzLDc2OCw2MDAsODM0LDgzNCw4MzQsODM0LDk5OSw1MDAsMWUzLDUwMCwxZTMsNTAwLDUwMCw0OTQsNjEyLDgyMyw3MTMsNTg0LDU0OSw3MTMsOTc5LDcyMiwyNzQsNTQ5LDU0OSw1ODMsNTQ5LDU0OSw2MDQsNTg0LDYwNCw2MDQsNzA4LDYyNSw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MjksNjA0LDYwNCwzNTQsMzU0LDFlMyw5OTAsOTkwLDk5MCw5OTAsNDk0LDYwNCw2MDQsNjA0LDYwNCwzNTQsMTAyMSwxMDUyLDkxNyw3NTAsNzUwLDUzMSw2NTYsNTk0LDUxMCw1MDAsNzUwLDc1MCw2MTEsNjExLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMjIyLDIyMiwzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzXSxObj1bLTEsLTEsLTEsMzIsMzMsMzQsMzUsMzYsMzcsMzgsMzksNDAsNDEsNDIsNDMsNDQsNDUsNDYsNDcsNDgsNDksNTAsNTEsNTIsNTMsNTQsNTUsNTYsNTcsNTgsNTksNjAsNjEsNjIsNjMsNjQsNjUsNjYsNjcsNjgsNjksNzAsNzEsNzIsNzMsNzQsNzUsNzYsNzcsNzgsNzksODAsODEsODIsODMsODQsODUsODYsODcsODgsODksOTAsOTEsOTIsOTMsOTQsOTUsOTYsOTcsOTgsOTksMTAwLDEwMSwxMDIsMTAzLDEwNCwxMDUsMTA2LDEwNywxMDgsMTA5LDExMCwxMTEsMTEyLDExMywxMTQsMTE1LDExNiwxMTcsMTE4LDExOSwxMjAsMTIxLDEyMiwxMjMsMTI0LDEyNSwxMjYsMTYxLDE2MiwxNjMsMTY0LDE2NSwxNjYsMTY3LDE2OCwxNjksMTcwLDE3MSwxNzIsMTc0LDE3NSwxNzYsMTc3LDE3OCwxNzksMTgwLDE4MSwxODIsMTgzLDE4NCwxODUsMTg2LDE4NywxODgsMTg5LDE5MCwxOTEsMTkyLDE5MywxOTQsMTk1LDE5NiwxOTcsMTk4LDE5OSwyMDAsMjAxLDIwMiwyMDMsMjA0LDIwNSwyMDYsMjA3LDIwOCwyMDksMjEwLDIxMSwyMTIsMjEzLDIxNCwyMTUsMjE2LDIxNywyMTgsMjE5LDIyMCwyMjEsMjIyLDIyMywyMjQsMjI1LDIyNiwyMjcsMjI4LDIyOSwyMzAsMjMxLDIzMiwyMzMsMjM0LDIzNSwyMzYsMjM3LDIzOCwyMzksMjQwLDI0MSwyNDIsMjQzLDI0NCwyNDUsMjQ2LDI0NywyNDgsMjQ5LDI1MCwyNTEsMjUyLDI1MywyNTQsMjU1LDI1NiwyNTcsMjU4LDI1OSwyNjAsMjYxLDI2MiwyNjMsMjY0LDI2NSwyNjYsMjY3LDI2OCwyNjksMjcwLDI3MSwyNzIsMjczLDI3NCwyNzUsMjc2LDI3NywyNzgsMjc5LDI4MCwyODEsMjgyLDI4MywyODQsMjg1LDI4NiwyODcsMjg4LDI4OSwyOTAsMjkxLDI5MiwyOTMsMjk0LDI5NSwyOTYsMjk3LDI5OCwyOTksMzAwLDMwMSwzMDIsMzAzLDMwNCwzMDUsMzA2LDMwNywzMDgsMzA5LDMxMCwzMTEsMzEyLDMxMywzMTQsMzE1LDMxNiwzMTcsMzE4LDMxOSwzMjAsMzIxLDMyMiwzMjMsMzI0LDMyNSwzMjYsMzI3LDMyOCwzMjksMzMwLDMzMSwzMzIsMzMzLDMzNCwzMzUsMzM2LDMzNywzMzgsMzM5LDM0MCwzNDEsMzQyLDM0MywzNDQsMzQ1LDM0NiwzNDcsMzQ4LDM0OSwzNTAsMzUxLDM1MiwzNTMsMzU0LDM1NSwzNTYsMzU3LDM1OCwzNTksMzYwLDM2MSwzNjIsMzYzLDM2NCwzNjUsMzY2LDM2NywzNjgsMzY5LDM3MCwzNzEsMzcyLDM3MywzNzQsMzc1LDM3NiwzNzcsMzc4LDM3OSwzODAsMzgxLDM4MiwzODMsNDAyLDUwNiw1MDcsNTA4LDUwOSw1MTAsNTExLDUzNiw1MzcsNTM4LDUzOSw3MTAsNzExLDcxMyw3MjgsNzI5LDczMCw3MzEsNzMyLDczMyw5MDAsOTAxLDkwMiw5MDMsOTA0LDkwNSw5MDYsOTA4LDkxMCw5MTEsOTEyLDkxMyw5MTQsOTE1LDkxNiw5MTcsOTE4LDkxOSw5MjAsOTIxLDkyMiw5MjMsOTI0LDkyNSw5MjYsOTI3LDkyOCw5MjksOTMxLDkzMiw5MzMsOTM0LDkzNSw5MzYsOTM3LDkzOCw5MzksOTQwLDk0MSw5NDIsOTQzLDk0NCw5NDUsOTQ2LDk0Nyw5NDgsOTQ5LDk1MCw5NTEsOTUyLDk1Myw5NTQsOTU1LDk1Niw5NTcsOTU4LDk1OSw5NjAsOTYxLDk2Miw5NjMsOTY0LDk2NSw5NjYsOTY3LDk2OCw5NjksOTcwLDk3MSw5NzIsOTczLDk3NCwxMDI0LDEwMjUsMTAyNiwxMDI3LDEwMjgsMTAyOSwxMDMwLDEwMzEsMTAzMiwxMDMzLDEwMzQsMTAzNSwxMDM2LDEwMzcsMTAzOCwxMDM5LDEwNDAsMTA0MSwxMDQyLDEwNDMsMTA0NCwxMDQ1LDEwNDYsMTA0NywxMDQ4LDEwNDksMTA1MCwxMDUxLDEwNTIsMTA1MywxMDU0LDEwNTUsMTA1NiwxMDU3LDEwNTgsMTA1OSwxMDYwLDEwNjEsMTA2MiwxMDYzLDEwNjQsMTA2NSwxMDY2LDEwNjcsMTA2OCwxMDY5LDEwNzAsMTA3MSwxMDcyLDEwNzMsMTA3NCwxMDc1LDEwNzYsMTA3NywxMDc4LDEwNzksMTA4MCwxMDgxLDEwODIsMTA4MywxMDg0LDEwODUsMTA4NiwxMDg3LDEwODgsMTA4OSwxMDkwLDEwOTEsMTA5MiwxMDkzLDEwOTQsMTA5NSwxMDk2LDEwOTcsMTA5OCwxMDk5LDExMDAsMTEwMSwxMTAyLDExMDMsMTEwNCwxMTA1LDExMDYsMTEwNywxMTA4LDExMDksMTExMCwxMTExLDExMTIsMTExMywxMTE0LDExMTUsMTExNiwxMTE3LDExMTgsMTExOSwxMTM4LDExMzksMTE2OCwxMTY5LDc4MDgsNzgwOSw3ODEwLDc4MTEsNzgxMiw3ODEzLDc5MjIsNzkyMyw4MjA4LDgyMDksODIxMSw4MjEyLDgyMTMsODIxNSw4MjE2LDgyMTcsODIxOCw4MjE5LDgyMjAsODIyMSw4MjIyLDgyMjQsODIyNSw4MjI2LDgyMzAsODI0MCw4MjQyLDgyNDMsODI0OSw4MjUwLDgyNTIsODI1NCw4MjYwLDgzMTksODM1NSw4MzU2LDgzNTksODM2NCw4NDUzLDg0NjcsODQ3MCw4NDgyLDg0ODYsODQ5NCw4NTM5LDg1NDAsODU0MSw4NTQyLDg1OTIsODU5Myw4NTk0LDg1OTUsODU5Niw4NTk3LDg2MTYsODcwNiw4NzEwLDg3MTksODcyMSw4NzIyLDg3MzAsODczNCw4NzM1LDg3NDUsODc0Nyw4Nzc2LDg4MDAsODgwMSw4ODA0LDg4MDUsODk2Miw4OTc2LDg5OTIsODk5Myw5NDcyLDk0NzQsOTQ4NCw5NDg4LDk0OTIsOTQ5Niw5NTAwLDk1MDgsOTUxNiw5NTI0LDk1MzIsOTU1Miw5NTUzLDk1NTQsOTU1NSw5NTU2LDk1NTcsOTU1OCw5NTU5LDk1NjAsOTU2MSw5NTYyLDk1NjMsOTU2NCw5NTY1LDk1NjYsOTU2Nyw5NTY4LDk1NjksOTU3MCw5NTcxLDk1NzIsOTU3Myw5NTc0LDk1NzUsOTU3Niw5NTc3LDk1NzgsOTU3OSw5NTgwLDk2MDAsOTYwNCw5NjA4LDk2MTIsOTYxNiw5NjE3LDk2MTgsOTYxOSw5NjMyLDk2MzMsOTY0Miw5NjQzLDk2NDQsOTY1MCw5NjU4LDk2NjAsOTY2OCw5Njc0LDk2NzUsOTY3OSw5Njg4LDk2ODksOTcwMiw5Nzg2LDk3ODcsOTc4OCw5NzkyLDk3OTQsOTgyNCw5ODI3LDk4MjksOTgzMCw5ODM0LDk4MzUsOTgzNiw2MTQ0MSw2MTQ0Miw2MTQ0NSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMSwtMV0sUG49WzM2NSwwLDMzMywyNzgsMjc4LDM1NSw1NTYsNTU2LDg4OSw2NjcsMTkxLDMzMywzMzMsMzg5LDU4NCwyNzgsMzMzLDI3OCwyNzgsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDI3OCwyNzgsNTg0LDU4NCw1ODQsNTU2LDEwMTUsNjY3LDY2Nyw3MjIsNzIyLDY2Nyw2MTEsNzc4LDcyMiwyNzgsNTAwLDY2Nyw1NTYsODMzLDcyMiw3NzgsNjY3LDc3OCw3MjIsNjY3LDYxMSw3MjIsNjY3LDk0NCw2NjcsNjY3LDYxMSwyNzgsMjc4LDI3OCw0NjksNTU2LDMzMyw1NTYsNTU2LDUwMCw1NTYsNTU2LDI3OCw1NTYsNTU2LDIyMiwyMjIsNTAwLDIyMiw4MzMsNTU2LDU1Niw1NTYsNTU2LDMzMyw1MDAsMjc4LDU1Niw1MDAsNzIyLDUwMCw1MDAsNTAwLDMzNCwyNjAsMzM0LDU4NCwzMzMsNTU2LDU1Niw1NTYsNTU2LDI2MCw1NTYsMzMzLDczNywzNzAsNTU2LDU4NCw3MzcsNTUyLDQwMCw1NDksMzMzLDMzMywzMzMsNTc2LDUzNywyNzgsMzMzLDMzMywzNjUsNTU2LDgzNCw4MzQsODM0LDYxMSw2NjcsNjY3LDY2Nyw2NjcsNjY3LDY2NywxZTMsNzIyLDY2Nyw2NjcsNjY3LDY2NywyNzgsMjc4LDI3OCwyNzgsNzIyLDcyMiw3NzgsNzc4LDc3OCw3NzgsNzc4LDU4NCw3NzgsNzIyLDcyMiw3MjIsNzIyLDY2Nyw2NjcsNjExLDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDg4OSw1MDAsNTU2LDU1Niw1NTYsNTU2LDI3OCwyNzgsMjc4LDI3OCw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTQ5LDYxMSw1NTYsNTU2LDU1Niw1NTYsNTAwLDU1Niw1MDAsNjY3LDU1Niw2NjcsNTU2LDY2Nyw1NTYsNzIyLDUwMCw3MjIsNTAwLDcyMiw1MDAsNzIyLDUwMCw3MjIsNjI1LDcyMiw1NTYsNjY3LDU1Niw2NjcsNTU2LDY2Nyw1NTYsNjY3LDU1Niw2NjcsNTU2LDc3OCw1NTYsNzc4LDU1Niw3NzgsNTU2LDc3OCw1NTYsNzIyLDU1Niw3MjIsNTU2LDI3OCwyNzgsMjc4LDI3OCwyNzgsMjc4LDI3OCwyMjIsMjc4LDI3OCw3MzMsNDQ0LDUwMCwyMjIsNjY3LDUwMCw1MDAsNTU2LDIyMiw1NTYsMjIyLDU1NiwyODEsNTU2LDQwMCw1NTYsMjIyLDcyMiw1NTYsNzIyLDU1Niw3MjIsNTU2LDYxNSw3MjMsNTU2LDc3OCw1NTYsNzc4LDU1Niw3NzgsNTU2LDFlMyw5NDQsNzIyLDMzMyw3MjIsMzMzLDcyMiwzMzMsNjY3LDUwMCw2NjcsNTAwLDY2Nyw1MDAsNjY3LDUwMCw2MTEsMjc4LDYxMSwzNTQsNjExLDI3OCw3MjIsNTU2LDcyMiw1NTYsNzIyLDU1Niw3MjIsNTU2LDcyMiw1NTYsNzIyLDU1Niw5NDQsNzIyLDY2Nyw1MDAsNjY3LDYxMSw1MDAsNjExLDUwMCw2MTEsNTAwLDIyMiw1NTYsNjY3LDU1NiwxZTMsODg5LDc3OCw2MTEsNjY3LDUwMCw2MTEsMjc4LDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsNjY3LDI3OCw3ODksODQ2LDM4OSw3OTQsODY1LDc3NSwyMjIsNjY3LDY2Nyw1NzAsNjcxLDY2Nyw2MTEsNzIyLDc3OCwyNzgsNjY3LDY2Nyw4MzMsNzIyLDY0OCw3NzgsNzI1LDY2Nyw2MDAsNjExLDY2Nyw4MzcsNjY3LDgzMSw3NjEsMjc4LDY2Nyw1NzAsNDM5LDU1NSwyMjIsNTUwLDU3MCw1NzEsNTAwLDU1Niw0MzksNDYzLDU1NSw1NDIsMjIyLDUwMCw0OTIsNTQ4LDUwMCw0NDcsNTU2LDY3MCw1NzMsNDg2LDYwMywzNzQsNTUwLDY1Miw1NDYsNzI4LDc3OSwyMjIsNTUwLDU1Niw1NTAsNzc5LDY2Nyw2NjcsODQzLDU0NCw3MDgsNjY3LDI3OCwyNzgsNTAwLDEwNjYsOTgyLDg0NCw1ODksNzE1LDYzOSw3MjQsNjY3LDY1MSw2NjcsNTQ0LDcwNCw2NjcsOTE3LDYxNCw3MTUsNzE1LDU4OSw2ODYsODMzLDcyMiw3NzgsNzI1LDY2Nyw3MjIsNjExLDYzOSw3OTUsNjY3LDcyNyw2NzMsOTIwLDkyMyw4MDUsODg2LDY1MSw2OTQsMTAyMiw2ODIsNTU2LDU2Miw1MjIsNDkzLDU1Myw1NTYsNjg4LDQ2NSw1NTYsNTU2LDQ3Miw1NjQsNjg2LDU1MCw1NTYsNTU2LDU1Niw1MDAsODMzLDUwMCw4MzUsNTAwLDU3Miw1MTgsODMwLDg1MSw2MjEsNzM2LDUyNiw0OTIsNzUyLDUzNCw1NTYsNTU2LDU1NiwzNzgsNDk2LDUwMCwyMjIsMjIyLDIyMiw5MTAsODI4LDU1Niw0NzIsNTY1LDUwMCw1NTYsNzc4LDU1Niw0OTIsMzM5LDk0NCw3MjIsOTQ0LDcyMiw5NDQsNzIyLDY2Nyw1MDAsMzMzLDMzMyw1NTYsMWUzLDFlMyw1NTIsMjIyLDIyMiwyMjIsMjIyLDMzMywzMzMsMzMzLDU1Niw1NTYsMzUwLDFlMywxZTMsMTg4LDM1NCwzMzMsMzMzLDUwMCwzMzMsMTY3LDM2NSw1NTYsNTU2LDEwOTQsNTU2LDg4NSwzMjMsMTA4MywxZTMsNzY4LDYwMCw4MzQsODM0LDgzNCw4MzQsMWUzLDUwMCw5OTgsNTAwLDFlMyw1MDAsNTAwLDQ5NCw2MTIsODIzLDcxMyw1ODQsNTQ5LDcxMyw5NzksNzE5LDI3NCw1NDksNTQ5LDU4NCw1NDksNTQ5LDYwNCw1ODQsNjA0LDYwNCw3MDgsNjI1LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcyOSw2MDQsNjA0LDM1NCwzNTQsMWUzLDk5MCw5OTAsOTkwLDk5MCw0OTQsNjA0LDYwNCw2MDQsNjA0LDM1NCwxMDIxLDEwNTIsOTE3LDc1MCw3NTAsNTMxLDY1Niw1OTQsNTEwLDUwMCw3NTAsNzUwLDUwMCw1MDAsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywyMjIsMjIyLDI5NCwyOTQsMzI0LDMyNCwzMTYsMzI4LDM5OCwyODVdLF9uPVstMSwtMSwtMSwzMiwzMywzNCwzNSwzNiwzNywzOCwzOSw0MCw0MSw0Miw0Myw0NCw0NSw0Niw0Nyw0OCw0OSw1MCw1MSw1Miw1Myw1NCw1NSw1Niw1Nyw1OCw1OSw2MCw2MSw2Miw2Myw2NCw2NSw2Niw2Nyw2OCw2OSw3MCw3MSw3Miw3Myw3NCw3NSw3Niw3Nyw3OCw3OSw4MCw4MSw4Miw4Myw4NCw4NSw4Niw4Nyw4OCw4OSw5MCw5MSw5Miw5Myw5NCw5NSw5Niw5Nyw5OCw5OSwxMDAsMTAxLDEwMiwxMDMsMTA0LDEwNSwxMDYsMTA3LDEwOCwxMDksMTEwLDExMSwxMTIsMTEzLDExNCwxMTUsMTE2LDExNywxMTgsMTE5LDEyMCwxMjEsMTIyLDEyMywxMjQsMTI1LDEyNiwxNjEsMTYyLDE2MywxNjQsMTY1LDE2NiwxNjcsMTY4LDE2OSwxNzAsMTcxLDE3MiwxNzQsMTc1LDE3NiwxNzcsMTc4LDE3OSwxODAsMTgxLDE4MiwxODMsMTg0LDE4NSwxODYsMTg3LDE4OCwxODksMTkwLDE5MSwxOTIsMTkzLDE5NCwxOTUsMTk2LDE5NywxOTgsMTk5LDIwMCwyMDEsMjAyLDIwMywyMDQsMjA1LDIwNiwyMDcsMjA4LDIwOSwyMTAsMjExLDIxMiwyMTMsMjE0LDIxNSwyMTYsMjE3LDIxOCwyMTksMjIwLDIyMSwyMjIsMjIzLDIyNCwyMjUsMjI2LDIyNywyMjgsMjI5LDIzMCwyMzEsMjMyLDIzMywyMzQsMjM1LDIzNiwyMzcsMjM4LDIzOSwyNDAsMjQxLDI0MiwyNDMsMjQ0LDI0NSwyNDYsMjQ3LDI0OCwyNDksMjUwLDI1MSwyNTIsMjUzLDI1NCwyNTUsMjU2LDI1NywyNTgsMjU5LDI2MCwyNjEsMjYyLDI2MywyNjQsMjY1LDI2NiwyNjcsMjY4LDI2OSwyNzAsMjcxLDI3MiwyNzMsMjc0LDI3NSwyNzYsMjc3LDI3OCwyNzksMjgwLDI4MSwyODIsMjgzLDI4NCwyODUsMjg2LDI4NywyODgsMjg5LDI5MCwyOTEsMjkyLDI5MywyOTQsMjk1LDI5NiwyOTcsMjk4LDI5OSwzMDAsMzAxLDMwMiwzMDMsMzA0LDMwNSwzMDYsMzA3LDMwOCwzMDksMzEwLDMxMSwzMTIsMzEzLDMxNCwzMTUsMzE2LDMxNywzMTgsMzE5LDMyMCwzMjEsMzIyLDMyMywzMjQsMzI1LDMyNiwzMjcsMzI4LDMyOSwzMzAsMzMxLDMzMiwzMzMsMzM0LDMzNSwzMzYsMzM3LDMzOCwzMzksMzQwLDM0MSwzNDIsMzQzLDM0NCwzNDUsMzQ2LDM0NywzNDgsMzQ5LDM1MCwzNTEsMzUyLDM1MywzNTQsMzU1LDM1NiwzNTcsMzU4LDM1OSwzNjAsMzYxLDM2MiwzNjMsMzY0LDM2NSwzNjYsMzY3LDM2OCwzNjksMzcwLDM3MSwzNzIsMzczLDM3NCwzNzUsMzc2LDM3NywzNzgsMzc5LDM4MCwzODEsMzgyLDM4Myw0MDIsNTA2LDUwNyw1MDgsNTA5LDUxMCw1MTEsNTM2LDUzNyw1MzgsNTM5LDcxMCw3MTEsNzEzLDcyOCw3MjksNzMwLDczMSw3MzIsNzMzLDkwMCw5MDEsOTAyLDkwMyw5MDQsOTA1LDkwNiw5MDgsOTEwLDkxMSw5MTIsOTEzLDkxNCw5MTUsOTE2LDkxNyw5MTgsOTE5LDkyMCw5MjEsOTIyLDkyMyw5MjQsOTI1LDkyNiw5MjcsOTI4LDkyOSw5MzEsOTMyLDkzMyw5MzQsOTM1LDkzNiw5MzcsOTM4LDkzOSw5NDAsOTQxLDk0Miw5NDMsOTQ0LDk0NSw5NDYsOTQ3LDk0OCw5NDksOTUwLDk1MSw5NTIsOTUzLDk1NCw5NTUsOTU2LDk1Nyw5NTgsOTU5LDk2MCw5NjEsOTYyLDk2Myw5NjQsOTY1LDk2Niw5NjcsOTY4LDk2OSw5NzAsOTcxLDk3Miw5NzMsOTc0LDEwMjQsMTAyNSwxMDI2LDEwMjcsMTAyOCwxMDI5LDEwMzAsMTAzMSwxMDMyLDEwMzMsMTAzNCwxMDM1LDEwMzYsMTAzNywxMDM4LDEwMzksMTA0MCwxMDQxLDEwNDIsMTA0MywxMDQ0LDEwNDUsMTA0NiwxMDQ3LDEwNDgsMTA0OSwxMDUwLDEwNTEsMTA1MiwxMDUzLDEwNTQsMTA1NSwxMDU2LDEwNTcsMTA1OCwxMDU5LDEwNjAsMTA2MSwxMDYyLDEwNjMsMTA2NCwxMDY1LDEwNjYsMTA2NywxMDY4LDEwNjksMTA3MCwxMDcxLDEwNzIsMTA3MywxMDc0LDEwNzUsMTA3NiwxMDc3LDEwNzgsMTA3OSwxMDgwLDEwODEsMTA4MiwxMDgzLDEwODQsMTA4NSwxMDg2LDEwODcsMTA4OCwxMDg5LDEwOTAsMTA5MSwxMDkyLDEwOTMsMTA5NCwxMDk1LDEwOTYsMTA5NywxMDk4LDEwOTksMTEwMCwxMTAxLDExMDIsMTEwMywxMTA0LDExMDUsMTEwNiwxMTA3LDExMDgsMTEwOSwxMTEwLDExMTEsMTExMiwxMTEzLDExMTQsMTExNSwxMTE2LDExMTcsMTExOCwxMTE5LDExMzgsMTEzOSwxMTY4LDExNjksNzgwOCw3ODA5LDc4MTAsNzgxMSw3ODEyLDc4MTMsNzkyMiw3OTIzLDgyMDgsODIwOSw4MjExLDgyMTIsODIxMyw4MjE1LDgyMTYsODIxNyw4MjE4LDgyMTksODIyMCw4MjIxLDgyMjIsODIyNCw4MjI1LDgyMjYsODIzMCw4MjQwLDgyNDIsODI0Myw4MjQ5LDgyNTAsODI1Miw4MjU0LDgyNjAsODMxOSw4MzU1LDgzNTYsODM1OSw4MzY0LDg0NTMsODQ2Nyw4NDcwLDg0ODIsODQ4Niw4NDk0LDg1MzksODU0MCw4NTQxLDg1NDIsODU5Miw4NTkzLDg1OTQsODU5NSw4NTk2LDg1OTcsODYxNiw4NzA2LDg3MTAsODcxOSw4NzIxLDg3MjIsODczMCw4NzM0LDg3MzUsODc0NSw4NzQ3LDg3NzYsODgwMCw4ODAxLDg4MDQsODgwNSw4OTYyLDg5NzYsODk5Miw4OTkzLDk0NzIsOTQ3NCw5NDg0LDk0ODgsOTQ5Miw5NDk2LDk1MDAsOTUwOCw5NTE2LDk1MjQsOTUzMiw5NTUyLDk1NTMsOTU1NCw5NTU1LDk1NTYsOTU1Nyw5NTU4LDk1NTksOTU2MCw5NTYxLDk1NjIsOTU2Myw5NTY0LDk1NjUsOTU2Niw5NTY3LDk1NjgsOTU2OSw5NTcwLDk1NzEsOTU3Miw5NTczLDk1NzQsOTU3NSw5NTc2LDk1NzcsOTU3OCw5NTc5LDk1ODAsOTYwMCw5NjA0LDk2MDgsOTYxMiw5NjE2LDk2MTcsOTYxOCw5NjE5LDk2MzIsOTYzMyw5NjQyLDk2NDMsOTY0NCw5NjUwLDk2NTgsOTY2MCw5NjY4LDk2NzQsOTY3NSw5Njc5LDk2ODgsOTY4OSw5NzAyLDk3ODYsOTc4Nyw5Nzg4LDk3OTIsOTc5NCw5ODI0LDk4MjcsOTgyOSw5ODMwLDk4MzQsOTgzNSw5ODM2LDYxNDQxLDYxNDQyLDYxNDQ1LC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xXSxMbj1bMzY1LDAsMzMzLDI3OCwyNzgsMzU1LDU1Niw1NTYsODg5LDY2NywxOTEsMzMzLDMzMywzODksNTg0LDI3OCwzMzMsMjc4LDI3OCw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsMjc4LDI3OCw1ODQsNTg0LDU4NCw1NTYsMTAxNSw2NjcsNjY3LDcyMiw3MjIsNjY3LDYxMSw3NzgsNzIyLDI3OCw1MDAsNjY3LDU1Niw4MzMsNzIyLDc3OCw2NjcsNzc4LDcyMiw2NjcsNjExLDcyMiw2NjcsOTQ0LDY2Nyw2NjcsNjExLDI3OCwyNzgsMjc4LDQ2OSw1NTYsMzMzLDU1Niw1NTYsNTAwLDU1Niw1NTYsMjc4LDU1Niw1NTYsMjIyLDIyMiw1MDAsMjIyLDgzMyw1NTYsNTU2LDU1Niw1NTYsMzMzLDUwMCwyNzgsNTU2LDUwMCw3MjIsNTAwLDUwMCw1MDAsMzM0LDI2MCwzMzQsNTg0LDMzMyw1NTYsNTU2LDU1Niw1NTYsMjYwLDU1NiwzMzMsNzM3LDM3MCw1NTYsNTg0LDczNyw1NTIsNDAwLDU0OSwzMzMsMzMzLDMzMyw1NzYsNTM3LDI3OCwzMzMsMzMzLDM2NSw1NTYsODM0LDgzNCw4MzQsNjExLDY2Nyw2NjcsNjY3LDY2Nyw2NjcsNjY3LDFlMyw3MjIsNjY3LDY2Nyw2NjcsNjY3LDI3OCwyNzgsMjc4LDI3OCw3MjIsNzIyLDc3OCw3NzgsNzc4LDc3OCw3NzgsNTg0LDc3OCw3MjIsNzIyLDcyMiw3MjIsNjY3LDY2Nyw2MTEsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NTYsODg5LDUwMCw1NTYsNTU2LDU1Niw1NTYsMjc4LDI3OCwyNzgsMjc4LDU1Niw1NTYsNTU2LDU1Niw1NTYsNTU2LDU1Niw1NDksNjExLDU1Niw1NTYsNTU2LDU1Niw1MDAsNTU2LDUwMCw2NjcsNTU2LDY2Nyw1NTYsNjY3LDU1Niw3MjIsNTAwLDcyMiw1MDAsNzIyLDUwMCw3MjIsNTAwLDcyMiw2MTUsNzIyLDU1Niw2NjcsNTU2LDY2Nyw1NTYsNjY3LDU1Niw2NjcsNTU2LDY2Nyw1NTYsNzc4LDU1Niw3NzgsNTU2LDc3OCw1NTYsNzc4LDU1Niw3MjIsNTU2LDcyMiw1NTYsMjc4LDI3OCwyNzgsMjc4LDI3OCwyNzgsMjc4LDIyMiwyNzgsMjc4LDczNSw0NDQsNTAwLDIyMiw2NjcsNTAwLDUwMCw1NTYsMjIyLDU1NiwyMjIsNTU2LDI5Miw1NTYsMzM0LDU1NiwyMjIsNzIyLDU1Niw3MjIsNTU2LDcyMiw1NTYsNjA0LDcyMyw1NTYsNzc4LDU1Niw3NzgsNTU2LDc3OCw1NTYsMWUzLDk0NCw3MjIsMzMzLDcyMiwzMzMsNzIyLDMzMyw2NjcsNTAwLDY2Nyw1MDAsNjY3LDUwMCw2NjcsNTAwLDYxMSwyNzgsNjExLDM3NSw2MTEsMjc4LDcyMiw1NTYsNzIyLDU1Niw3MjIsNTU2LDcyMiw1NTYsNzIyLDU1Niw3MjIsNTU2LDk0NCw3MjIsNjY3LDUwMCw2NjcsNjExLDUwMCw2MTEsNTAwLDYxMSw1MDAsMjIyLDU1Niw2NjcsNTU2LDFlMyw4ODksNzc4LDYxMSw2NjcsNTAwLDYxMSwyNzgsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMyw2NjcsMjc4LDc4NCw4MzgsMzg0LDc3NCw4NTUsNzUyLDIyMiw2NjcsNjY3LDU1MSw2NjgsNjY3LDYxMSw3MjIsNzc4LDI3OCw2NjcsNjY4LDgzMyw3MjIsNjUwLDc3OCw3MjIsNjY3LDYxOCw2MTEsNjY3LDc5OCw2NjcsODM1LDc0OCwyNzgsNjY3LDU3OCw0NDYsNTU2LDIyMiw1NDcsNTc4LDU3NSw1MDAsNTU3LDQ0Niw0NDEsNTU2LDU1NiwyMjIsNTAwLDUwMCw1NzYsNTAwLDQ0OCw1NTYsNjkwLDU2OSw0ODIsNjE3LDM5NSw1NDcsNjQ4LDUyNSw3MTMsNzgxLDIyMiw1NDcsNTU2LDU0Nyw3ODEsNjY3LDY2Nyw4NjUsNTQyLDcxOSw2NjcsMjc4LDI3OCw1MDAsMTA1NywxMDEwLDg1NCw1ODMsNzIyLDYzNSw3MTksNjY3LDY1Niw2NjcsNTQyLDY3Nyw2NjcsOTIzLDYwNCw3MTksNzE5LDU4Myw2NTYsODMzLDcyMiw3NzgsNzE5LDY2Nyw3MjIsNjExLDYzNSw3NjAsNjY3LDc0MCw2NjcsOTE3LDkzOCw3OTIsODg1LDY1Niw3MTksMTAxMCw3MjIsNTU2LDU3Myw1MzEsMzY1LDU4Myw1NTYsNjY5LDQ1OCw1NTksNTU5LDQzOCw1ODMsNjg4LDU1Miw1NTYsNTQyLDU1Niw1MDAsNDU4LDUwMCw4MjMsNTAwLDU3Myw1MjEsODAyLDgyMyw2MjUsNzE5LDUyMSw1MTAsNzUwLDU0Miw1NTYsNTU2LDU1NiwzNjUsNTEwLDUwMCwyMjIsMjc4LDIyMiw5MDYsODEyLDU1Niw0MzgsNTU5LDUwMCw1NTIsNzc4LDU1Niw0ODksNDExLDk0NCw3MjIsOTQ0LDcyMiw5NDQsNzIyLDY2Nyw1MDAsMzMzLDMzMyw1NTYsMWUzLDFlMyw1NTIsMjIyLDIyMiwyMjIsMjIyLDMzMywzMzMsMzMzLDU1Niw1NTYsMzUwLDFlMywxZTMsMTg4LDM1NCwzMzMsMzMzLDUwMCwzMzMsMTY3LDM2NSw1NTYsNTU2LDEwOTQsNTU2LDg4NSwzMjMsMTA3MywxZTMsNzY4LDYwMCw4MzQsODM0LDgzNCw4MzQsMWUzLDUwMCwxZTMsNTAwLDFlMyw1MDAsNTAwLDQ5NCw2MTIsODIzLDcxMyw1ODQsNTQ5LDcxMyw5NzksNzE5LDI3NCw1NDksNTQ5LDU4Myw1NDksNTQ5LDYwNCw1ODQsNjA0LDYwNCw3MDgsNjI1LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcwOCw3MDgsNzA4LDcyOSw2MDQsNjA0LDM1NCwzNTQsMWUzLDk5MCw5OTAsOTkwLDk5MCw0OTQsNjA0LDYwNCw2MDQsNjA0LDM1NCwxMDIxLDEwNTIsOTE3LDc1MCw3NTAsNTMxLDY1Niw1OTQsNTEwLDUwMCw3NTAsNzUwLDUwMCw1MDAsMzMzLDMzMywzMzMsMzMzLDMzMywzMzMsMzMzLDMzMywyMjIsMjIyLDI5NCwyOTQsMzI0LDMyNCwzMTYsMzI4LDM5OCwyODVdLGpuPVstMSwtMSwtMSwzMiwzMywzNCwzNSwzNiwzNywzOCwzOSw0MCw0MSw0Miw0Myw0NCw0NSw0Niw0Nyw0OCw0OSw1MCw1MSw1Miw1Myw1NCw1NSw1Niw1Nyw1OCw1OSw2MCw2MSw2Miw2Myw2NCw2NSw2Niw2Nyw2OCw2OSw3MCw3MSw3Miw3Myw3NCw3NSw3Niw3Nyw3OCw3OSw4MCw4MSw4Miw4Myw4NCw4NSw4Niw4Nyw4OCw4OSw5MCw5MSw5Miw5Myw5NCw5NSw5Niw5Nyw5OCw5OSwxMDAsMTAxLDEwMiwxMDMsMTA0LDEwNSwxMDYsMTA3LDEwOCwxMDksMTEwLDExMSwxMTIsMTEzLDExNCwxMTUsMTE2LDExNywxMTgsMTE5LDEyMCwxMjEsMTIyLDEyMywxMjQsMTI1LDEyNiwxNjEsMTYyLDE2MywxNjQsMTY1LDE2NiwxNjcsMTY4LDE2OSwxNzAsMTcxLDE3MiwxNzQsMTc1LDE3NiwxNzcsMTc4LDE3OSwxODAsMTgxLDE4MiwxODMsMTg0LDE4NSwxODYsMTg3LDE4OCwxODksMTkwLDE5MSwxOTIsMTkzLDE5NCwxOTUsMTk2LDE5NywxOTgsMTk5LDIwMCwyMDEsMjAyLDIwMywyMDQsMjA1LDIwNiwyMDcsMjA4LDIwOSwyMTAsMjExLDIxMiwyMTMsMjE0LDIxNSwyMTYsMjE3LDIxOCwyMTksMjIwLDIyMSwyMjIsMjIzLDIyNCwyMjUsMjI2LDIyNywyMjgsMjI5LDIzMCwyMzEsMjMyLDIzMywyMzQsMjM1LDIzNiwyMzcsMjM4LDIzOSwyNDAsMjQxLDI0MiwyNDMsMjQ0LDI0NSwyNDYsMjQ3LDI0OCwyNDksMjUwLDI1MSwyNTIsMjUzLDI1NCwyNTUsMjU2LDI1NywyNTgsMjU5LDI2MCwyNjEsMjYyLDI2MywyNjQsMjY1LDI2NiwyNjcsMjY4LDI2OSwyNzAsMjcxLDI3MiwyNzMsMjc0LDI3NSwyNzYsMjc3LDI3OCwyNzksMjgwLDI4MSwyODIsMjgzLDI4NCwyODUsMjg2LDI4NywyODgsMjg5LDI5MCwyOTEsMjkyLDI5MywyOTQsMjk1LDI5NiwyOTcsMjk4LDI5OSwzMDAsMzAxLDMwMiwzMDMsMzA0LDMwNSwzMDYsMzA3LDMwOCwzMDksMzEwLDMxMSwzMTIsMzEzLDMxNCwzMTUsMzE2LDMxNywzMTgsMzE5LDMyMCwzMjEsMzIyLDMyMywzMjQsMzI1LDMyNiwzMjcsMzI4LDMyOSwzMzAsMzMxLDMzMiwzMzMsMzM0LDMzNSwzMzYsMzM3LDMzOCwzMzksMzQwLDM0MSwzNDIsMzQzLDM0NCwzNDUsMzQ2LDM0NywzNDgsMzQ5LDM1MCwzNTEsMzUyLDM1MywzNTQsMzU1LDM1NiwzNTcsMzU4LDM1OSwzNjAsMzYxLDM2MiwzNjMsMzY0LDM2NSwzNjYsMzY3LDM2OCwzNjksMzcwLDM3MSwzNzIsMzczLDM3NCwzNzUsMzc2LDM3NywzNzgsMzc5LDM4MCwzODEsMzgyLDM4Myw0MDIsNTA2LDUwNyw1MDgsNTA5LDUxMCw1MTEsNTM2LDUzNyw1MzgsNTM5LDcxMCw3MTEsNzEzLDcyOCw3MjksNzMwLDczMSw3MzIsNzMzLDkwMCw5MDEsOTAyLDkwMyw5MDQsOTA1LDkwNiw5MDgsOTEwLDkxMSw5MTIsOTEzLDkxNCw5MTUsOTE2LDkxNyw5MTgsOTE5LDkyMCw5MjEsOTIyLDkyMyw5MjQsOTI1LDkyNiw5MjcsOTI4LDkyOSw5MzEsOTMyLDkzMyw5MzQsOTM1LDkzNiw5MzcsOTM4LDkzOSw5NDAsOTQxLDk0Miw5NDMsOTQ0LDk0NSw5NDYsOTQ3LDk0OCw5NDksOTUwLDk1MSw5NTIsOTUzLDk1NCw5NTUsOTU2LDk1Nyw5NTgsOTU5LDk2MCw5NjEsOTYyLDk2Myw5NjQsOTY1LDk2Niw5NjcsOTY4LDk2OSw5NzAsOTcxLDk3Miw5NzMsOTc0LDEwMjQsMTAyNSwxMDI2LDEwMjcsMTAyOCwxMDI5LDEwMzAsMTAzMSwxMDMyLDEwMzMsMTAzNCwxMDM1LDEwMzYsMTAzNywxMDM4LDEwMzksMTA0MCwxMDQxLDEwNDIsMTA0MywxMDQ0LDEwNDUsMTA0NiwxMDQ3LDEwNDgsMTA0OSwxMDUwLDEwNTEsMTA1MiwxMDUzLDEwNTQsMTA1NSwxMDU2LDEwNTcsMTA1OCwxMDU5LDEwNjAsMTA2MSwxMDYyLDEwNjMsMTA2NCwxMDY1LDEwNjYsMTA2NywxMDY4LDEwNjksMTA3MCwxMDcxLDEwNzIsMTA3MywxMDc0LDEwNzUsMTA3NiwxMDc3LDEwNzgsMTA3OSwxMDgwLDEwODEsMTA4MiwxMDgzLDEwODQsMTA4NSwxMDg2LDEwODcsMTA4OCwxMDg5LDEwOTAsMTA5MSwxMDkyLDEwOTMsMTA5NCwxMDk1LDEwOTYsMTA5NywxMDk4LDEwOTksMTEwMCwxMTAxLDExMDIsMTEwMywxMTA0LDExMDUsMTEwNiwxMTA3LDExMDgsMTEwOSwxMTEwLDExMTEsMTExMiwxMTEzLDExMTQsMTExNSwxMTE2LDExMTcsMTExOCwxMTE5LDExMzgsMTEzOSwxMTY4LDExNjksNzgwOCw3ODA5LDc4MTAsNzgxMSw3ODEyLDc4MTMsNzkyMiw3OTIzLDgyMDgsODIwOSw4MjExLDgyMTIsODIxMyw4MjE1LDgyMTYsODIxNyw4MjE4LDgyMTksODIyMCw4MjIxLDgyMjIsODIyNCw4MjI1LDgyMjYsODIzMCw4MjQwLDgyNDIsODI0Myw4MjQ5LDgyNTAsODI1Miw4MjU0LDgyNjAsODMxOSw4MzU1LDgzNTYsODM1OSw4MzY0LDg0NTMsODQ2Nyw4NDcwLDg0ODIsODQ4Niw4NDk0LDg1MzksODU0MCw4NTQxLDg1NDIsODU5Miw4NTkzLDg1OTQsODU5NSw4NTk2LDg1OTcsODYxNiw4NzA2LDg3MTAsODcxOSw4NzIxLDg3MjIsODczMCw4NzM0LDg3MzUsODc0NSw4NzQ3LDg3NzYsODgwMCw4ODAxLDg4MDQsODgwNSw4OTYyLDg5NzYsODk5Miw4OTkzLDk0NzIsOTQ3NCw5NDg0LDk0ODgsOTQ5Miw5NDk2LDk1MDAsOTUwOCw5NTE2LDk1MjQsOTUzMiw5NTUyLDk1NTMsOTU1NCw5NTU1LDk1NTYsOTU1Nyw5NTU4LDk1NTksOTU2MCw5NTYxLDk1NjIsOTU2Myw5NTY0LDk1NjUsOTU2Niw5NTY3LDk1NjgsOTU2OSw5NTcwLDk1NzEsOTU3Miw5NTczLDk1NzQsOTU3NSw5NTc2LDk1NzcsOTU3OCw5NTc5LDk1ODAsOTYwMCw5NjA0LDk2MDgsOTYxMiw5NjE2LDk2MTcsOTYxOCw5NjE5LDk2MzIsOTYzMyw5NjQyLDk2NDMsOTY0NCw5NjUwLDk2NTgsOTY2MCw5NjY4LDk2NzQsOTY3NSw5Njc5LDk2ODgsOTY4OSw5NzAyLDk3ODYsOTc4Nyw5Nzg4LDk3OTIsOTc5NCw5ODI0LDk4MjcsOTgyOSw5ODMwLDk4MzQsOTgzNSw5ODM2LDYxNDQxLDYxNDQyLDYxNDQ1LC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xXSxVbj1bMS4zNjg5OCwxLDEsLjcyNzA2LC44MDQ3OSwuODM3MzQsLjk4ODk0LC45OTc5MywuOTg5NywuOTM4ODQsLjg2MjA5LC45NDI5MiwuOTQyOTIsMS4xNjY2MSwxLjAyMDU4LC45MzU4MiwuOTY2OTQsLjkzNTgyLDEuMTkxMzcsLjk5NzkzLC45OTc5MywuOTk3OTMsLjk5NzkzLC45OTc5MywuOTk3OTMsLjk5NzkzLC45OTc5MywuOTk3OTMsLjk5NzkzLC43ODA3NiwuNzgwNzYsMS4wMjA1OCwxLjAyMDU4LDEuMDIwNTgsLjcyODUxLC43ODk2NiwuOTA4MzgsLjgzNjM3LC44MjM5MSwuOTYzNzYsLjgwMDYxLC44NjI3NSwuODc2OCwuOTU0MDcsMS4wMjU4LC43MzkwMSwuODUwMjIsLjgzNjU1LDEuMDE1NiwuOTU1NDYsLjkyMTc5LC44NzEwNywuOTIxNzksLjgyMTE0LC44MDk2LC44OTcxMywuOTQ0MzgsLjk1MzUzLC45NDA4MywuOTE5MDUsLjkwNDA2LC45NDQ2LC45NDI5MiwxLjE4Nzc3LC45NDI5MiwxLjAyMDU4LC44OTkwMywuOTAwODgsLjk0OTM4LC45Nzg5OCwuODEwOTMsLjk3NTcxLC45NDkzOCwxLjAyNCwuOTU3NywuOTU5MzMsLjk4NjIxLDEuMDQ3NCwuOTc0NTUsLjk4OTgxLC45NjcyLC45NTkzMywuOTQ0NiwuOTc4OTgsLjk3NDA3LC45NzY0NiwuNzgwMzYsMS4xMDIwOCwuOTU0NDIsLjk1Mjk4LC45NzU3OSwuOTMzMiwuOTQwMzksLjkzOCwuODA2ODcsMS4wMTE0OSwuODA2ODcsMS4wMjA1OCwuODA0NzksLjk5NzkzLC45OTc5MywuOTk3OTMsLjk5NzkzLDEuMDExNDksMS4wMDg3MiwuOTAwODgsLjkxODgyLDEuMDIxMywuODM2MSwxLjAyMDU4LC42MjI5NSwuNTQzMjQsLjg5MDIyLDEuMDg1OTUsMSwxLC45MDA4OCwxLC45NzQ1NSwuOTM1ODIsLjkwMDg4LDEsMS4wNTY4NiwuODM2MSwuOTk2NDIsLjk5NjQyLC45OTY0MiwuNzI4NTEsLjkwODM4LC45MDgzOCwuOTA4MzgsLjkwODM4LC45MDgzOCwuOTA4MzgsLjg2OCwuODIzOTEsLjgwMDYxLC44MDA2MSwuODAwNjEsLjgwMDYxLDEuMDI1OCwxLjAyNTgsMS4wMjU4LDEuMDI1OCwuOTc0ODQsLjk1NTQ2LC45MjE3OSwuOTIxNzksLjkyMTc5LC45MjE3OSwuOTIxNzksMS4wMjA1OCwuOTIxNzksLjk0NDM4LC45NDQzOCwuOTQ0MzgsLjk0NDM4LC45MDQwNiwuODY5NTgsLjk4MjI1LC45NDkzOCwuOTQ5MzgsLjk0OTM4LC45NDkzOCwuOTQ5MzgsLjk0OTM4LC45MDMxLC44MTA5MywuOTQ5MzgsLjk0OTM4LC45NDkzOCwuOTQ5MzgsLjk4NjIxLC45ODYyMSwuOTg2MjEsLjk4NjIxLC45Mzk2OSwuOTU5MzMsLjk0NDYsLjk0NDYsLjk0NDYsLjk0NDYsLjk0NDYsMS4wODU5NSwuOTQ0NiwuOTU0NDIsLjk1NDQyLC45NTQ0MiwuOTU0NDIsLjk0MDM5LC45Nzg5OCwuOTQwMzksLjkwODM4LC45NDkzOCwuOTA4MzgsLjk0OTM4LC45MDgzOCwuOTQ5MzgsLjgyMzkxLC44MTA5MywuODIzOTEsLjgxMDkzLC44MjM5MSwuODEwOTMsLjgyMzkxLC44MTA5MywuOTYzNzYsLjg0MzEzLC45NzQ4NCwuOTc1NzEsLjgwMDYxLC45NDkzOCwuODAwNjEsLjk0OTM4LC44MDA2MSwuOTQ5MzgsLjgwMDYxLC45NDkzOCwuODAwNjEsLjk0OTM4LC44NzY4LC45NTc3LC44NzY4LC45NTc3LC44NzY4LC45NTc3LDEsMSwuOTU0MDcsLjk1OTMzLC45NzA2OSwuOTU5MzMsMS4wMjU4LC45ODYyMSwxLjAyNTgsLjk4NjIxLDEuMDI1OCwuOTg2MjEsMS4wMjU4LC45ODYyMSwxLjAyNTgsLjk4NjIxLC44ODcsMS4wMTU5MSwuNzM5MDEsMS4wNDc0LDEsMSwuOTc0NTUsLjgzNjU1LC45ODk4MSwxLDEsLjgzNjU1LC43Mzk3NywuODM2NTUsLjczOTAzLC44NDYzOCwxLjAzMywuOTU1NDYsLjk1OTMzLDEsMSwuOTU1NDYsLjk1OTMzLC44MjcxLC45NTQxNywuOTU5MzMsLjkyMTc5LC45NDQ2LC45MjE3OSwuOTQ0NiwuOTIxNzksLjk0NDYsLjkzNiwuOTE5NjQsLjgyMTE0LC45NzY0NiwxLDEsLjgyMTE0LC45NzY0NiwuODA5NiwuNzgwMzYsLjgwOTYsLjc4MDM2LDEsMSwuODA5NiwuNzgwMzYsMSwxLC44OTcxMywuNzc0NTIsLjg5NzEzLDEuMTAyMDgsLjk0NDM4LC45NTQ0MiwuOTQ0MzgsLjk1NDQyLC45NDQzOCwuOTU0NDIsLjk0NDM4LC45NTQ0MiwuOTQ0MzgsLjk1NDQyLC45NDQzOCwuOTU0NDIsLjk0MDgzLC45NzU3OSwuOTA0MDYsLjk0MDM5LC45MDQwNiwuOTQ0NiwuOTM4LC45NDQ2LC45MzgsLjk0NDYsLjkzOCwxLC45OTc5MywuOTA4MzgsLjk0OTM4LC44NjgsLjkwMzEsLjkyMTc5LC45NDQ2LDEsMSwuODk3MTMsMS4xMDIwOCwuOTAwODgsLjkwMDg4LC45MDA4OCwuOTAwODgsLjkwMDg4LC45MDA4OCwuOTAwODgsLjkwMDg4LC45MDA4OCwuOTA5ODksLjkzNTgsLjkxOTQ1LC44MzE4MSwuNzUyNjEsLjg3OTkyLC44Mjk3NiwuOTYwMzQsLjgzNjg5LC45NzI2OCwxLjAwNzgsLjkwODM4LC44MzYzNywuODAxOSwuOTAxNTcsLjgwMDYxLC45NDQ2LC45NTQwNywuOTI0MzYsMS4wMjU4LC44NTAyMiwuOTcxNTMsMS4wMTU2LC45NTU0NiwuODkxOTIsLjkyMTc5LC45MjM2MSwuODcxMDcsLjk2MzE4LC44OTcxMywuOTM3MDQsLjk1NjM4LC45MTkwNSwuOTE3MDksLjkyNzk2LDEuMDI1OCwuOTM3MDQsLjk0ODM2LDEuMDM3MywuOTU5MzMsMS4wMDc4LC45NTg3MSwuOTQ4MzYsLjk2MTc0LC45MjYwMSwuOTQ5OCwuOTg2MDcsLjk1Nzc2LC45NTkzMywxLjA1NDUzLDEuMDA3OCwuOTgyNzUsLjkzMTQsLjk1NjE3LC45MTcwMSwxLjA1OTkzLC45NDQ2LC43ODM2NywuOTU1MywxLC44NjgzMiwxLjAxMjgsLjk1ODcxLC45OTM5NCwuODc1NDgsLjk2MzYxLC44Njc3NCwxLjAwNzgsLjk1ODcxLC45NDQ2LC45NTg3MSwuODY3NzQsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuOTQwODMsLjk3NTc5LC45NDA4MywuOTc1NzksLjk0MDgzLC45NzU3OSwuOTA0MDYsLjk0MDM5LC45NjY5NCwxLC44OTkwMywxLDEsMSwuOTM1ODIsLjkzNTgyLC45MzU4MiwxLC45MDgsLjkwOCwuOTE4LC45NDIxOSwuOTQyMTksLjk2NTQ0LDEsMS4yODUsMSwxLC44MTA3OSwuODEwNzksMSwxLC43NDg1NCwxLDEsMSwxLC45OTc5MywxLDEsMSwuNjUsMSwxLjM2MTQ1LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLjE3MTczLDEsLjgwNTM1LC43NjE2OSwxLjAyMDU4LDEuMDczMiwxLjA1NDg2LDEsMSwxLjMwNjkyLDEuMDg1OTUsMS4wODU5NSwxLDEuMDg1OTUsMS4wODU5NSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuMTYxNjEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMV0scW49e2xpbmVIZWlnaHQ6MS4yLGxpbmVHYXA6LjJ9LFhuPVsxLjM2ODk4LDEsMSwuNjYyMjcsLjgwNzc5LC44MTYyNSwuOTcyNzYsLjk3Mjc2LC45NzczMywuOTIyMjIsLjgzMjY2LC45NDI5MiwuOTQyOTIsMS4xNjE0OCwxLjAyMDU4LC45MzU4MiwuOTY2OTQsLjkzNTgyLDEuMTczMzcsLjk3Mjc2LC45NzI3NiwuOTcyNzYsLjk3Mjc2LC45NzI3NiwuOTcyNzYsLjk3Mjc2LC45NzI3NiwuOTcyNzYsLjk3Mjc2LC43ODA3NiwuNzgwNzYsMS4wMjA1OCwxLjAyMDU4LDEuMDIwNTgsLjcxNTQxLC43NjgxMywuODU1NzYsLjgwNTkxLC44MDcyOSwuOTQyOTksLjc3NTEyLC44MzY1NSwuODY1MjMsLjkyMjIyLC45ODYyMSwuNzE3NDMsLjgxNjk4LC43OTcyNiwuOTg1NTgsLjkyMjIyLC45MDYzNywuODM4MDksLjkwNjM3LC44MDcyOSwuNzY0NjMsLjg2Mjc1LC45MDY5OSwuOTE2MDUsLjkxNTQsLjg1MzA4LC44NTQ1OCwuOTA1MzEsLjk0MjkyLDEuMjEyOTYsLjk0MjkyLDEuMDIwNTgsLjg5OTAzLDEuMTg2MTYsLjk5NjEzLC45MTY3NywuNzgyMTYsLjkxNjc3LC45MDA4MywuOTg3OTYsLjkxMzUsLjkyMTY4LC45NTM4MSwuOTg5ODEsLjk1Mjk4LC45NTM4MSwuOTM0NTksLjkyMTY4LC45MTUxMywuOTIwMDQsLjkxNjc3LC45NTA3NywuNzQ4LDEuMDQ1MDIsLjkxNjc3LC45MjA2MSwuOTQyMzYsLjg5NTQ0LC44OTM2NCwuOSwuODA2ODcsLjg1NzgsLjgwNjg3LDEuMDIwNTgsLjgwNzc5LC45NzI3NiwuOTcyNzYsLjk3Mjc2LC45NzI3NiwuODU3OCwuOTk5NzMsMS4xODYxNiwuOTEzMzksMS4wODA3NCwuODI4OTEsMS4wMjA1OCwuNTU1MDksLjcxNTI2LC44OTAyMiwxLjA4NTk1LDEsMSwxLjE4NjE2LDEsLjk2NzM2LC45MzU4MiwxLjE4NjE2LDEsMS4wNDg2NCwuODI3MTEsLjk5MDQzLC45OTA0MywuOTkwNDMsLjcxNTQxLC44NTU3NiwuODU1NzYsLjg1NTc2LC44NTU3NiwuODU1NzYsLjg1NTc2LC44NDUsLjgwNzI5LC43NzUxMiwuNzc1MTIsLjc3NTEyLC43NzUxMiwuOTg2MjEsLjk4NjIxLC45ODYyMSwuOTg2MjEsLjk1OTYxLC45MjIyMiwuOTA2MzcsLjkwNjM3LC45MDYzNywuOTA2MzcsLjkwNjM3LDEuMDIwNTgsLjkwMjUxLC45MDY5OSwuOTA2OTksLjkwNjk5LC45MDY5OSwuODU0NTgsLjgzNjU5LC45NDk1MSwuOTk2MTMsLjk5NjEzLC45OTYxMywuOTk2MTMsLjk5NjEzLC45OTYxMywuODU4MTEsLjc4MjE2LC45MDA4MywuOTAwODMsLjkwMDgzLC45MDA4MywuOTUzODEsLjk1MzgxLC45NTM4MSwuOTUzODEsLjkxMzUsLjkyMTY4LC45MTUxMywuOTE1MTMsLjkxNTEzLC45MTUxMywuOTE1MTMsMS4wODU5NSwuOTE2NzcsLjkxNjc3LC45MTY3NywuOTE2NzcsLjkxNjc3LC44OTM2NCwuOTIzMzIsLjg5MzY0LC44NTU3NiwuOTk2MTMsLjg1NTc2LC45OTYxMywuODU1NzYsLjk5NjEzLC44MDcyOSwuNzgyMTYsLjgwNzI5LC43ODIxNiwuODA3MjksLjc4MjE2LC44MDcyOSwuNzgyMTYsLjk0Mjk5LC43Njc4MywuOTU5NjEsLjkxNjc3LC43NzUxMiwuOTAwODMsLjc3NTEyLC45MDA4MywuNzc1MTIsLjkwMDgzLC43NzUxMiwuOTAwODMsLjc3NTEyLC45MDA4MywuODY1MjMsLjkxMzUsLjg2NTIzLC45MTM1LC44NjUyMywuOTEzNSwxLDEsLjkyMjIyLC45MjE2OCwuOTIyMjIsLjkyMTY4LC45ODYyMSwuOTUzODEsLjk4NjIxLC45NTM4MSwuOTg2MjEsLjk1MzgxLC45ODYyMSwuOTUzODEsLjk4NjIxLC45NTM4MSwuODYwMzYsLjk3MDk2LC43MTc0MywuOTg5ODEsMSwxLC45NTI5OCwuNzk3MjYsLjk1MzgxLDEsMSwuNzk3MjYsLjY4OTQsLjc5NzI2LC43NDMyMSwuODE2OTEsMS4wMDA2LC45MjIyMiwuOTIxNjgsMSwxLC45MjIyMiwuOTIxNjgsLjc5NDY0LC45MjA5OCwuOTIxNjgsLjkwNjM3LC45MTUxMywuOTA2MzcsLjkxNTEzLC45MDYzNywuOTE1MTMsLjkwOSwuODc1MTQsLjgwNzI5LC45NTA3NywxLDEsLjgwNzI5LC45NTA3NywuNzY0NjMsLjc0OCwuNzY0NjMsLjc0OCwxLDEsLjc2NDYzLC43NDgsMSwxLC44NjI3NSwuNzI2NTEsLjg2Mjc1LDEuMDQ1MDIsLjkwNjk5LC45MTY3NywuOTA2OTksLjkxNjc3LC45MDY5OSwuOTE2NzcsLjkwNjk5LC45MTY3NywuOTA2OTksLjkxNjc3LC45MDY5OSwuOTE2NzcsLjkxNTQsLjk0MjM2LC44NTQ1OCwuODkzNjQsLjg1NDU4LC45MDUzMSwuOSwuOTA1MzEsLjksLjkwNTMxLC45LDEsLjk3Mjc2LC44NTU3NiwuOTk2MTMsLjg0NSwuODU4MTEsLjkwMjUxLC45MTY3NywxLDEsLjg2Mjc1LDEuMDQ1MDIsMS4xODYxNiwxLjE4NjE2LDEuMTg2MTYsMS4xODYxNiwxLjE4NjE2LDEuMTg2MTYsMS4xODYxNiwxLjE4NjE2LDEuMTg2MTYsMS4wMDg5OSwxLjMwNjI4LC44NTU3NiwuODAxNzgsLjY2ODYyLC43OTI3LC42OTMyMywuODgxMjcsLjcyNDU5LC44OTcxMSwuOTUzODEsLjg1NTc2LC44MDU5MSwuNzgwNSwuOTQ3MjksLjc3NTEyLC45MDUzMSwuOTIyMjIsLjkwNjM3LC45ODYyMSwuODE2OTgsLjkyNjU1LC45ODU1OCwuOTIyMjIsLjg1MzU5LC45MDYzNywuOTA5NzYsLjgzODA5LC45NDUyMywuODYyNzUsLjgzNTA5LC45MzE1NywuODUzMDgsLjgzMzkyLC45MjM0NiwuOTg2MjEsLjgzNTA5LC45Mjg4NiwuOTEzMjQsLjkyMTY4LC45NTM4MSwuOTA2NDYsLjkyODg2LC45MDU1NywuODY4NDcsLjkwMjc2LC45MTMyNCwuODY4NDIsLjkyMTY4LC45OTUzMSwuOTUzODEsLjkyMjQsLjg1NDA4LC45MjY5OSwuODY4NDcsMS4wMDUxLC45MTUxMywuODA0ODcsLjkzNDgxLDEsLjg4MTU5LDEuMDUyMTQsLjkwNjQ2LC45NzM1NSwuODE1MzksLjg5Mzk4LC44NTkyMywuOTUzODEsLjkwNjQ2LC45MTUxMywuOTA2NDYsLjg1OTIzLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjkxNTQsLjk0MjM2LC45MTU0LC45NDIzNiwuOTE1NCwuOTQyMzYsLjg1NDU4LC44OTM2NCwuOTY2OTQsMSwuODk5MDMsMSwxLDEsLjkxNzgyLC45MTc4MiwuOTE3ODIsMSwuODk2LC44OTYsLjg5NiwuOTMzMiwuOTMzMiwuOTU5NzMsMSwxLjI2LDEsMSwuODA0NzksLjgwMTc4LDEsMSwuODU2MzMsMSwxLDEsMSwuOTcyNzYsMSwxLDEsLjY5OCwxLDEuMzYxNDUsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuMTQ1NDIsMSwuNzkxOTksLjc4Njk0LDEuMDIwNTgsMS4wMzQ5MywxLjA1NDg2LDEsMSwxLjIzMDI2LDEuMDg1OTUsMS4wODU5NSwxLDEuMDg1OTUsMS4wODU5NSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuMjAwMDYsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMV0sSG49e2xpbmVIZWlnaHQ6MS4yLGxpbmVHYXA6LjJ9LFduPVsxLjM2ODk4LDEsMSwuNjU1MDcsLjg0OTQzLC44NTYzOSwuODg0NjUsLjg4NDY1LC44NjkzNiwuODgzMDcsLjg2OTQ4LC44NTI4MywuODUyODMsMS4wNjM4MywxLjAyMDU4LC43NTk0NSwuOTIxOSwuNzU5NDUsMS4xNzMzNywuODg0NjUsLjg4NDY1LC44ODQ2NSwuODg0NjUsLjg4NDY1LC44ODQ2NSwuODg0NjUsLjg4NDY1LC44ODQ2NSwuODg0NjUsLjc1OTQ1LC43NTk0NSwxLjAyMDU4LDEuMDIwNTgsMS4wMjA1OCwuNjkwNDYsLjcwOTI2LC44NTE1OCwuNzc4MTIsLjc2ODUyLC44OTU5MSwuNzA0NjYsLjc2MTI1LC44MDA5NCwuODY4MjIsLjgzODY0LC43MjgsLjc3MjEyLC43OTQ3NSwuOTM2MzcsLjg3NTE0LC44NTg4LC43NjAxMywuODU4OCwuNzI0MjEsLjY5ODY2LC43NzU5OCwuODU5OTEsLjgwODExLC44NzgzMiwuNzgxMTIsLjc3NTEyLC44NTYyLDEuMDIyMiwxLjE4NDE3LDEuMDIyMiwxLjI3MDE0LC44OTkwMywxLjE1MDEyLC45Mzg1OSwuOTQzOTksLjg0NiwuOTQzOTksLjgxNDUzLDEuMDE4NiwuOTQyMTksLjk2MDE3LDEuMDMwNzUsMS4wMjE3NSwuOTEyLDEuMDMwNzUsLjk2OTk4LC45NjAxNywuOTM4NTksLjk0Mzk5LC45NDM5OSwuOTU0OTMsLjc0NiwxLjEyNjU4LC45NDU3OCwuOTEsLjk3OSwuODgyLC44ODIsLjgzLC44NTAzNCwuODM1MzcsLjg1MDM0LDEuMDIwNTgsLjcwODY5LC44ODQ2NSwuODg0NjUsLjg4NDY1LC44ODQ2NSwuODM1MzcsLjkwMDgzLDEuMTUwMTIsLjkxNjEsLjk0NTY1LC43MzU0MSwxLjAyMDU4LC41MzYwOSwuNjkzNTMsLjc5NTE5LDEuMDg1OTUsMSwxLDEuMTUwMTIsMSwuOTE5NzQsLjc1OTQ1LDEuMTUwMTIsMSwuOTQ0NiwuNzMzNjEsLjkwMDUsLjkwMDUsLjkwMDUsLjYyODY0LC44NTE1OCwuODUxNTgsLjg1MTU4LC44NTE1OCwuODUxNTgsLjg1MTU4LC43NzMsLjc2ODUyLC43MDQ2NiwuNzA0NjYsLjcwNDY2LC43MDQ2NiwuODM4NjQsLjgzODY0LC44Mzg2NCwuODM4NjQsLjkwNTYxLC44NzUxNCwuODU4OCwuODU4OCwuODU4OCwuODU4OCwuODU4OCwxLjAyMDU4LC44NTc1MSwuODU5OTEsLjg1OTkxLC44NTk5MSwuODU5OTEsLjc3NTEyLC43NjAxMywuODgwNzUsLjkzODU5LC45Mzg1OSwuOTM4NTksLjkzODU5LC45Mzg1OSwuOTM4NTksLjgwNzUsLjg0NiwuODE0NTMsLjgxNDUzLC44MTQ1MywuODE0NTMsLjgyNDI0LC44MjQyNCwuODI0MjQsLjgyNDI0LC45Mjc4LC45NjAxNywuOTM4NTksLjkzODU5LC45Mzg1OSwuOTM4NTksLjkzODU5LDEuMDg1OTUsLjg1NjIsLjk0NTc4LC45NDU3OCwuOTQ1NzgsLjk0NTc4LC44ODIsLjk0NTc4LC44ODIsLjg1MTU4LC45Mzg1OSwuODUxNTgsLjkzODU5LC44NTE1OCwuOTM4NTksLjc2ODUyLC44NDYsLjc2ODUyLC44NDYsLjc2ODUyLC44NDYsLjc2ODUyLC44NDYsLjg5NTkxLC44NTQ0LC45MDU2MSwuOTQzOTksLjcwNDY2LC44MTQ1MywuNzA0NjYsLjgxNDUzLC43MDQ2NiwuODE0NTMsLjcwNDY2LC44MTQ1MywuNzA0NjYsLjgxNDUzLC44MDA5NCwuOTQyMTksLjgwMDk0LC45NDIxOSwuODAwOTQsLjk0MjE5LDEsMSwuODY4MjIsLjk2MDE3LC44NjgyMiwuOTYwMTcsLjgzODY0LC44MjQyNCwuODM4NjQsLjgyNDI0LC44Mzg2NCwuODI0MjQsLjgzODY0LDEuMDMwNzUsLjgzODY0LC44MjQyNCwuODE0MDIsMS4wMjczOCwuNzI4LDEuMDIxNzUsMSwxLC45MTIsLjc5NDc1LDEuMDMwNzUsMSwxLC43OTQ3NSwuODM5MTEsLjc5NDc1LC42NjI2NiwuODA1NTMsMS4wNjY3NiwuODc1MTQsLjk2MDE3LDEsMSwuODc1MTQsLjk2MDE3LC44Njg2NSwuODczOTYsLjk2MDE3LC44NTg4LC45Mzg1OSwuODU4OCwuOTM4NTksLjg1ODgsLjkzODU5LC44NjcsLjg0NzU5LC43MjQyMSwuOTU0OTMsMSwxLC43MjQyMSwuOTU0OTMsLjY5ODY2LC43NDYsLjY5ODY2LC43NDYsMSwxLC42OTg2NiwuNzQ2LDEsMSwuNzc1OTgsLjg4NDE3LC43NzU5OCwxLjEyNjU4LC44NTk5MSwuOTQ1NzgsLjg1OTkxLC45NDU3OCwuODU5OTEsLjk0NTc4LC44NTk5MSwuOTQ1NzgsLjg1OTkxLC45NDU3OCwuODU5OTEsLjk0NTc4LC44NzgzMiwuOTc5LC43NzUxMiwuODgyLC43NzUxMiwuODU2MiwuODMsLjg1NjIsLjgzLC44NTYyLC44MywxLC44ODQ2NSwuODUxNTgsLjkzODU5LC43NzMsLjgwNzUsLjg1NzUxLC44NTYyLDEsMSwuNzc1OTgsMS4xMjY1OCwxLjE1MDEyLDEuMTUwMTIsMS4xNTAxMiwxLjE1MDEyLDEuMTUwMTIsMS4xNTMxMywxLjE1MDEyLDEuMTUwMTIsMS4xNTAxMiwxLjA4MTA2LDEuMDM5MDEsLjg1MTU4LC43NzAyNSwuNjIyNjQsLjc2NDYsLjY1MzUxLC44NjAyNiwuNjk0NjEsLjg5OTQ3LDEuMDMwNzUsLjg1MTU4LC43NzgxMiwuNzY0NDksLjg4ODM2LC43MDQ2NiwuODU2MiwuODY4MjIsLjg1ODgsLjgzODY0LC43NzIxMiwuODUzMDgsLjkzNjM3LC44NzUxNCwuODIzNTIsLjg1ODgsLjg1NzAxLC43NjAxMywuODkwNTgsLjc3NTk4LC44MTU2LC44MjU2NSwuNzgxMTIsLjc3ODk5LC44OTM4NiwuODM4NjQsLjgxNTYsLjk0ODYsLjkyMzg4LC45NjE4NiwxLjAzMDc1LC45MTEyMywuOTQ4NiwuOTMyOTgsLjg3OCwuOTM5NDIsLjkyMzg4LC44NDU5NiwuOTYxODYsLjk1MTE5LDEuMDMwNzUsLjkyMiwuODg3ODcsLjk1ODI5LC44OCwuOTM1NTksLjkzODU5LC43ODgxNSwuOTM3NTgsMSwuODkyMTcsMS4wMzczNywuOTExMjMsLjkzOTY5LC43NzQ4NywuODU3NjksLjg2Nzk5LDEuMDMwNzUsLjkxMTIzLC45Mzg1OSwuOTExMjMsLjg2Nzk5LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjg3ODMyLC45NzksLjg3ODMyLC45NzksLjg3ODMyLC45NzksLjc3NTEyLC44ODIsLjkyMTksMSwuODk5MDMsMSwxLDEsLjg3MzIxLC44NzMyMSwuODczMjEsMSwxLjAyNywxLjAyNywxLjAyNywuODY4NDcsLjg2ODQ3LC43OTEyMSwxLDEuMTI0LDEsMSwuNzM1NzIsLjczNTcyLDEsMSwuODUwMzQsMSwxLDEsMSwuODg0NjUsMSwxLDEsLjY2OSwxLDEuMzYxNDUsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuMDQ4MjgsMSwuNzQ5NDgsLjc1MTg3LDEuMDIwNTgsLjk4MzkxLDEuMDIxMTksMSwxLDEuMDYyMzMsMS4wODU5NSwxLjA4NTk1LDEsMS4wODU5NSwxLjA4NTk1LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMS4wNTIzMywxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxXSx6bj17bGluZUhlaWdodDoxLjIsbGluZUdhcDouMn0sR249WzEuMzY4OTgsMSwxLC43NjMwNSwuODI3ODQsLjk0OTM1LC44OTM2NCwuOTIyNDEsLjg5MDczLC45MDcwNiwuOTg0NzIsLjg1MjgzLC44NTI4MywxLjA2NjQsMS4wMjA1OCwuNzQ1MDUsLjkyMTksLjc0NTA1LDEuMjM0NTYsLjkyMjQxLC45MjI0MSwuOTIyNDEsLjkyMjQxLC45MjI0MSwuOTIyNDEsLjkyMjQxLC45MjI0MSwuOTIyNDEsLjkyMjQxLC43NDUwNSwuNzQ1MDUsMS4wMjA1OCwxLjAyMDU4LDEuMDIwNTgsLjczMDAyLC43MjYwMSwuOTE3NTUsLjgxMjYsLjgwMzE0LC45MjIyMiwuNzM3NjQsLjc5NzI2LC44MzA1MSwuOTAyODQsLjg2MDIzLC43NCwuODEyNiwuODQ4NjksLjk2NTE4LC45MTExNSwuODg1OCwuNzk3NjEsLjg4NTgsLjc0NDk4LC43MzkxNCwuODEzNjMsLjg5NTkxLC44MzY1OSwuODk2MzMsLjg1NjA4LC44MTExLC45MDUzMSwxLjAyMjIsMS4yMjczNiwxLjAyMjIsMS4yNzAxNCwuODk5MDMsLjkwMDg4LC44NjY2NywxLjAyMzEsLjg5NiwxLjAxNDExLC45MDA4MywxLjA1MDk5LDEuMDA1MTIsLjk5NzkzLDEuMDUzMjYsMS4wOTM3NywuOTM4LDEuMDYyMjYsMS4wMDExOSwuOTk3OTMsLjk4NzE0LDEuMDIzMSwxLjAxMjMxLC45ODE5NiwuNzkyLDEuMTkxMzcsLjk5MDc0LC45NjIsMS4wMTkxNSwuOTI2LC45NDIsLjg1NiwuODUwMzQsLjkyMDA2LC44NTAzNCwxLjAyMDU4LC42OTA2NywuOTIyNDEsLjkyMjQxLC45MjI0MSwuOTIyNDEsLjkyMDA2LC45MzMyLC45MDA4OCwuOTE4ODIsLjkzNDg0LC43NTMzOSwxLjAyMDU4LC41Njg2NiwuNTQzMjQsLjc5NTE5LDEuMDg1OTUsMSwxLC45MDA4OCwxLC45NTMyNSwuNzQ1MDUsLjkwMDg4LDEsLjk3MTk4LC43NTMzOSwuOTEwMDksLjkxMDA5LC45MTAwOSwuNjY0NjYsLjkxNzU1LC45MTc1NSwuOTE3NTUsLjkxNzU1LC45MTc1NSwuOTE3NTUsLjc4OCwuODAzMTQsLjczNzY0LC43Mzc2NCwuNzM3NjQsLjczNzY0LC44NjAyMywuODYwMjMsLjg2MDIzLC44NjAyMywuOTI5MTUsLjkxMTE1LC44ODU4LC44ODU4LC44ODU4LC44ODU4LC44ODU4LDEuMDIwNTgsLjg4NTgsLjg5NTkxLC44OTU5MSwuODk1OTEsLjg5NTkxLC44MTExLC43OTYxMSwuODk3MTMsLjg2NjY3LC44NjY2NywuODY2NjcsLjg2NjY3LC44NjY2NywuODY2NjcsLjg2OTM2LC44OTYsLjkwMDgzLC45MDA4MywuOTAwODMsLjkwMDgzLC44NDIyNCwuODQyMjQsLjg0MjI0LC44NDIyNCwuOTcyNzYsLjk5NzkzLC45ODcxNCwuOTg3MTQsLjk4NzE0LC45ODcxNCwuOTg3MTQsMS4wODU5NSwuODk4NzYsLjk5MDc0LC45OTA3NCwuOTkwNzQsLjk5MDc0LC45NDIsMS4wMjMxLC45NDIsLjkxNzU1LC44NjY2NywuOTE3NTUsLjg2NjY3LC45MTc1NSwuODY2NjcsLjgwMzE0LC44OTYsLjgwMzE0LC44OTYsLjgwMzE0LC44OTYsLjgwMzE0LC44OTYsLjkyMjIyLC45MzM3MiwuOTI5MTUsMS4wMTQxMSwuNzM3NjQsLjkwMDgzLC43Mzc2NCwuOTAwODMsLjczNzY0LC45MDA4MywuNzM3NjQsLjkwMDgzLC43Mzc2NCwuOTAwODMsLjgzMDUxLDEuMDA1MTIsLjgzMDUxLDEuMDA1MTIsLjgzMDUxLDEuMDA1MTIsMSwxLC45MDI4NCwuOTk3OTMsLjkwOTc2LC45OTc5MywuODYwMjMsLjg0MjI0LC44NjAyMywuODQyMjQsLjg2MDIzLC44NDIyNCwuODYwMjMsMS4wNTMyNiwuODYwMjMsLjg0MjI0LC44Mjg3MywxLjA3NDY5LC43NCwxLjA5Mzc3LDEsMSwuOTM4LC44NDg2OSwxLjA2MjI2LDEsMSwuODQ4NjksLjgzNzA0LC44NDg2OSwuODE0NDEsLjg1NTg4LDEuMDg5MjcsLjkxMTE1LC45OTc5MywxLDEsLjkxMTE1LC45OTc5MywuOTE4ODcsLjkwOTkxLC45OTc5MywuODg1OCwuOTg3MTQsLjg4NTgsLjk4NzE0LC44ODU4LC45ODcxNCwuODk0LC45MTQzNCwuNzQ0OTgsLjk4MTk2LDEsMSwuNzQ0OTgsLjk4MTk2LC43MzkxNCwuNzkyLC43MzkxNCwuNzkyLDEsMSwuNzM5MTQsLjc5MiwxLDEsLjgxMzYzLC45MDQsLjgxMzYzLDEuMTkxMzcsLjg5NTkxLC45OTA3NCwuODk1OTEsLjk5MDc0LC44OTU5MSwuOTkwNzQsLjg5NTkxLC45OTA3NCwuODk1OTEsLjk5MDc0LC44OTU5MSwuOTkwNzQsLjg5NjMzLDEuMDE5MTUsLjgxMTEsLjk0MiwuODExMSwuOTA1MzEsLjg1NiwuOTA1MzEsLjg1NiwuOTA1MzEsLjg1NiwxLC45MjI0MSwuOTE3NTUsLjg2NjY3LC43ODgsLjg2OTM2LC44ODU4LC44OTg3NiwxLDEsLjgxMzYzLDEuMTkxMzcsLjkwMDg4LC45MDA4OCwuOTAwODgsLjkwMDg4LC45MDA4OCwuOTAwODgsLjkwMDg4LC45MDA4OCwuOTAwODgsLjkwMzg4LDEuMDM5MDEsLjkyMTM4LC43ODEwNSwuNzE1NCwuODYxNjksLjgwNTEzLC45NDAwNywuODI1MjgsLjk4NjEyLDEuMDYyMjYsLjkxNzU1LC44MTI2LC44MTg4NCwuOTI4MTksLjczNzY0LC45MDUzMSwuOTAyODQsLjg4NTgsLjg2MDIzLC44MTI2LC45MTE3MiwuOTY1MTgsLjkxMTE1LC44MzA4OSwuODg1OCwuODc3OTEsLjc5NzYxLC44OTI5NywuODEzNjMsLjg4MTU3LC44OTk5MiwuODU2MDgsLjgxOTkyLC45NDMwNywuODYwMjMsLjg4MTU3LC45NTMwOCwuOTg2OTksLjk5NzkzLDEuMDYyMjYsLjk1ODE3LC45NTMwOCwuOTczNTgsLjkyOCwuOTgwODgsLjk4Njk5LC45Mjc2MSwuOTk3OTMsLjk2MDE3LDEuMDYyMjYsLjk4NiwuOTQ0LC45NTk3OCwuOTM4LC45NjcwNSwuOTg3MTQsLjgwNDQyLC45ODk3MiwxLC44OTc2MiwxLjA0NTUyLC45NTgxNywuOTkwMDcsLjg3MDY0LC45MTg3OSwuODg4ODgsMS4wNjIyNiwuOTU4MTcsLjk4NzE0LC45NTgxNywuODg4ODgsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuODk2MzMsMS4wMTkxNSwuODk2MzMsMS4wMTkxNSwuODk2MzMsMS4wMTkxNSwuODExMSwuOTQyLC45MjE5LDEsLjg5OTAzLDEsMSwxLC45MzE3MywuOTMxNzMsLjkzMTczLDEsMS4wNjMwNCwxLjA2MzA0LDEuMDY5MDQsLjg5OTAzLC44OTkwMywuODA1NDksMSwxLjE1NiwxLDEsLjc2NTc1LC43NjU3NSwxLDEsLjcyNDU4LDEsMSwxLDEsLjkyMjQxLDEsMSwxLC42MTksMSwxLjM2MTQ1LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLjA3MjU3LDEsLjc0NzA1LC43MTExOSwxLjAyMDU4LDEuMDI0LDEuMDIxMTksMSwxLDEuMTUzNiwxLjA4NTk1LDEuMDg1OTUsMSwxLjA4NTk1LDEuMDg1OTUsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLjA1NjM4LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDFdLCRuPXtsaW5lSGVpZ2h0OjEuMixsaW5lR2FwOi4yfSxWbj1bMS43NjczOCwxLDEsLjk5Mjk3LC45ODI0LDEuMDQwMTYsMS4wNjQ5NywxLjAzNDI0LC45NzUyOSwxLjE3NjQ3LDEuMjMyMDMsMS4xMDg1LDEuMTA4NSwxLjE2OTM5LDEuMjEwNywuOTc1NCwxLjIxNDA4LC45NzU0LDEuNTk1NzgsMS4wMzQyNCwxLjAzNDI0LDEuMDM0MjQsMS4wMzQyNCwxLjAzNDI0LDEuMDM0MjQsMS4wMzQyNCwxLjAzNDI0LDEuMDM0MjQsMS4wMzQyNCwuODEzNzgsLjgxMzc4LDEuMjEwNywxLjIxMDcsMS4yMTA3LC43MTcwMywuOTc4NDcsLjk3MzYzLC44ODc3NiwuODY0MSwxLjAyMDk2LC43OTc5NSwuODUxMzIsLjkxNCwxLjA2MDg1LDEuMTQwNiwuODAwNywuODk4NTgsLjgzNjkzLDEuMTQ4ODksMS4wOTM5OCwuOTc0ODksLjkyMDk0LC45NzQ4OSwuOTAzOTksLjg0MDQxLC45NTkyMywxLjAwMTM1LDEsMS4wNjQ2NywuOTgyNDMsLjkwOTk2LC45OTM2MSwxLjEwODUsMS41Njk0MiwxLjEwODUsMS4yMTA3LC43NDYyNywuOTQyODIsLjk2NzUyLDEuMDE1MTksLjg2MzA0LDEuMDEzNTksLjk3Mjc4LDEuMTUxMDMsMS4wMTM1OSwuOTg1NjEsMS4wMjI4NSwxLjAyMjg1LDEuMDA1MjcsMS4wMjI4NSwxLjAzMDIsLjk5MDQxLDEuMDAwOCwxLjAxNTE5LDEuMDEzNTksMS4wMjI1OCwuNzkxMDQsMS4xNjg2MiwuOTkwNDEsLjk3NDU0LDEuMDI1MTEsLjk5Mjk4LC45Njc1MiwuOTU4MDEsLjk0ODU2LDEuMTY1NzksLjk0ODU2LDEuMjEwNywuOTgyNCwxLjAzNDI0LDEuMDM0MjQsMSwxLjAzNDI0LDEuMTY1NzksLjg3MjcsMS4zODcxLDEuMTg2MjIsMS4xMDgxOCwxLjA0NDc4LDEuMjEwNywxLjE4NjIyLC43NTE1NSwuOTQ5OTQsMS4yODgyNiwxLjIxNDA4LDEuMjE0MDgsLjkxMDU2LDEsLjkxNTcyLC45NzU0LC42NDY2MywxLjE4MzI4LDEuMjQ4NjYsMS4wNDQ3OCwxLjE0MTY5LDEuMTU3NDksMS4xNzM4OSwuNzE3MDMsLjk3MzYzLC45NzM2MywuOTczNjMsLjk3MzYzLC45NzM2MywuOTczNjMsLjkzNTA2LC44NjQxLC43OTc5NSwuNzk3OTUsLjc5Nzk1LC43OTc5NSwxLjE0MDYsMS4xNDA2LDEuMTQwNiwxLjE0MDYsMS4wMjA5NiwxLjA5Mzk4LC45NzQyNiwuOTc0MjYsLjk3NDI2LC45NzQyNiwuOTc0MjYsMS4yMTA3LC45NzQ4OSwxLjAwMTM1LDEuMDAxMzUsMS4wMDEzNSwxLjAwMTM1LC45MDk5NiwuOTIwOTQsMS4wMjc5OCwuOTY3NTIsLjk2NzUyLC45Njc1MiwuOTY3NTIsLjk2NzUyLC45Njc1MiwuOTMxMzYsLjg2MzA0LC45NzI3OCwuOTcyNzgsLjk3Mjc4LC45NzI3OCwxLjAyMjg1LDEuMDIyODUsMS4wMjI4NSwxLjAyMjg1LC45NzEyMiwuOTkwNDEsMSwxLDEsMSwxLDEuMjg4MjYsMS4wMDA4LC45OTA0MSwuOTkwNDEsLjk5MDQxLC45OTA0MSwuOTY3NTIsMS4wMTUxOSwuOTY3NTIsLjk3MzYzLC45Njc1MiwuOTczNjMsLjk2NzUyLC45NzM2MywuOTY3NTIsLjg2NDEsLjg2MzA0LC44NjQxLC44NjMwNCwuODY0MSwuODYzMDQsLjg2NDEsLjg2MzA0LDEuMDIwOTYsMS4wMzA1NywxLjAyMDk2LDEuMDM1MTcsLjc5Nzk1LC45NzI3OCwuNzk3OTUsLjk3Mjc4LC43OTc5NSwuOTcyNzgsLjc5Nzk1LC45NzI3OCwuNzk3OTUsLjk3Mjc4LC45MTQsMS4wMTM1OSwuOTE0LDEuMDEzNTksLjkxNCwxLjAxMzU5LDEsMSwxLjA2MDg1LC45ODU2MSwxLjA2MDg1LDEuMDA4NzksMS4xNDA2LDEuMDIyODUsMS4xNDA2LDEuMDIyODUsMS4xNDA2LDEuMDIyODUsMS4xNDA2LDEuMDIyODUsMS4xNDA2LDEuMDIyODUsLjk3MTM4LDEuMDg2OTIsLjgwMDcsMS4wMjI4NSwxLDEsMS4wMDUyNywuODM2OTMsMS4wMjI4NSwxLDEsLjgzNjkzLC45NDU1LC44MzY5MywuOTA0MTgsLjgzNjkzLDEuMTMwMDUsMS4wOTM5OCwuOTkwNDEsMSwxLDEuMDkzOTgsLjk5MDQxLC45NjY5MiwxLjA5MjUxLC45OTA0MSwuOTc0ODksMS4wMDA4LC45NzQ4OSwxLjAwMDgsLjk3NDg5LDEuMDAwOCwuOTM5OTQsLjk3OTMxLC45MDM5OSwxLjAyMjU4LDEsMSwuOTAzOTksMS4wMjI1OCwuODQwNDEsLjc5MTA0LC44NDA0MSwuNzkxMDQsLjg0MDQxLC43OTEwNCwuODQwNDEsLjc5MTA0LDEsMSwuOTU5MjMsMS4wNzAzNCwuOTU5MjMsMS4xNjg2MiwxLjAwMTM1LC45OTA0MSwxLjAwMTM1LC45OTA0MSwxLjAwMTM1LC45OTA0MSwxLjAwMTM1LC45OTA0MSwxLjAwMTM1LC45OTA0MSwxLjAwMTM1LC45OTA0MSwxLjA2NDY3LDEuMDI1MTEsLjkwOTk2LC45Njc1MiwuOTA5OTYsLjk5MzYxLC45NTgwMSwuOTkzNjEsLjk1ODAxLC45OTM2MSwuOTU4MDEsMS4wNzczMywxLjAzNDI0LC45NzM2MywuOTY3NTIsLjkzNTA2LC45MzEzNiwuOTc0ODksMS4wMDA4LDEsMSwuOTU5MjMsMS4xNjg2MiwxLjE1MTAzLDEuMTUxMDMsMS4wMTE3MywxLjAzOTU5LC43NTk1MywuODEzNzgsLjc5OTEyLDEuMTUxMDMsMS4yMTk5NCwuOTUxNjEsLjg3ODE1LDEuMDExNDksLjgxNTI1LC43Njc2LC45ODE2NywxLjAxMTM0LDEuMDI1NDYsLjg0MDk3LDEuMDMwODksMS4xODEwMiwuOTczNjMsLjg4Nzc2LC44NTEzNCwuOTc4MjYsLjc5Nzk1LC45OTM2MSwxLjA2MDg1LC45NzQ4OSwxLjE0MDYsLjg5ODU4LDEuMDM4OCwxLjE0ODg5LDEuMDkzOTgsLjg2MDM5LC45NzQ4OSwxLjA1OTUsLjkyMDk0LC45NDc5MywuOTU5MjMsLjkwOTk2LC45OTM0NiwuOTgyNDMsMS4wMjExMiwuOTU0OTMsMS4xNDA2LC45MDk5NiwxLjAzNTc0LDEuMDI1OTcsMS4wMDA4LDEuMTgxMDIsMS4wNjYyOCwxLjAzNTc0LDEuMDE5MiwxLjAxOTMyLDEuMDA4ODYsLjk3NTMxLDEuMDEwNiwxLjAwMDgsMS4xMzE4OSwxLjE4MTAyLDEuMDIyNzcsLjk4NjgzLDEuMDAxNiwuOTk1NjEsMS4wNzIzNywxLjAwMDgsLjkwNDM0LC45OTkyMSwuOTM4MDMsLjg5NjUsMS4yMzA4NSwxLjA2NjI4LDEuMDQ5ODMsLjk2MjY4LDEuMDQ5OSwuOTg0MzksMS4xODEwMiwxLjA2NjI4LDEuMDAwOCwxLjA2NjI4LC45ODQzOSwuNzk3OTUsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMS4wOTQ2NiwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuOTcyNzgsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMS4wMjA2NSwxLDEsMSwxLDEsMSwxLjA2NDY3LDEuMDI1MTEsMS4wNjQ2NywxLjAyNTExLDEuMDY0NjcsMS4wMjUxMSwuOTA5OTYsLjk2NzUyLDEsMS4yMTQwOCwuODk5MDMsMSwxLC43NTE1NSwxLjA0Mzk0LDEuMDQzOTQsMS4wNDM5NCwxLjA0Mzk0LC45ODYzMywuOTg2MzMsLjk4NjMzLC43MzA0NywuNzMwNDcsMS4yMDY0MiwuOTEyMTEsMS4yNTYzNSwxLjIyMiwxLjAyOTU2LDEuMDMzNzIsMS4wMzM3MiwuOTYwMzksMS4yNDYzMywxLDEuMTI0NTQsLjkzNTAzLDEuMDM0MjQsMS4xOTY4NywxLjAzNDI0LDEsMSwxLC43NzEsMSwxLDEuMTU3NDksMS4xNTc0OSwxLjE1NzQ5LDEuMTA5NDgsLjg2Mjc5LC45NDQzNCwuODYyNzksLjk0NDM0LC44NjE4MiwxLDEsMS4xNjg5NywxLC45NjA4NSwuOTAxMzcsMS4yMTA3LDEuMTg0MTYsMS4xMzk3MywuNjk4MjUsLjk3MTYsMi4xMDMzOSwxLjI5MDA0LDEuMjkwMDQsMS4yMTE3MiwxLjI5MDA0LDEuMjkwMDQsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLjQyNjAzLDEsLjk5ODYyLC45OTg2MiwxLC44NzAyNSwuODcwMjUsLjg3MDI1LC44NzAyNSwxLjE4ODc0LDEuNDI2MDMsMSwxLjQyNjAzLDEuNDI2MDMsLjk5ODYyLDEsMSwxLDEsMSwxLjI4ODYsMS4wNDMxNSwxLjE1Mjk2LDEuMzQxNjMsMSwxLDEsMS4wOTE5MywxLjA5MTkzLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxXSxLbj17bGluZUhlaWdodDoxLjMzMDA4LGxpbmVHYXA6MH0sSm49WzEuNzY3MzgsMSwxLC45ODk0NiwxLjAzOTU5LDEuMDQwMTYsMS4wMjgwOSwxLjAzNiwuOTc2MzksMS4xMDk1MywxLjIzMjAzLDEuMTExNDQsMS4xMTE0NCwxLjE2OTM5LDEuMjEyMzcsLjk3NTQsMS4yMTI2MSwuOTc1NCwxLjU5NzU0LDEuMDM2LDEuMDM2LDEuMDM2LDEuMDM2LDEuMDM2LDEuMDM2LDEuMDM2LDEuMDM2LDEuMDM2LDEuMDM2LC44MTM3OCwuODEzNzgsMS4yMTIzNywxLjIxMjM3LDEuMjEyMzcsLjczNTQxLC45Nzg0NywuOTczNjMsLjg5NzIzLC44Nzg5NywxLjA0MjYsLjc5NDI5LC44NTI5MiwuOTExNDksMS4wNTgxNSwxLjE0MDYsLjc5NjMxLC45MDEyOCwuODM4NTMsMS4wNDM5NiwxLjEwNjE1LC45NzU1MiwuOTQ0MzYsLjk3NTUyLC44ODY0MSwuODA1MjcsLjk2MDgzLDEuMDAxMzUsMSwxLjA2Nzc3LC45ODE3LC45MTE0MiwuOTkzNjEsMS4xMTE0NCwxLjU3MjkzLDEuMTExNDQsMS4yMTIzNywuNzQ2MjcsMS4zMTgxOCwxLjA2NTg1LC45NzA0MiwuODMwNTUsLjk3MDQyLC45MzUwMywxLjEyNjEsLjk3MDQyLC45NzkyMiwxLjE0MjM2LC45NDU1MiwxLjAxMDU0LDEuMTQyMzYsMS4wMjQ3MSwuOTc5MjIsLjk0MTY1LC45NzA0MiwuOTcwNDIsMS4wMjc2LC43ODkyOSwxLjEyNjEsLjk3OTIyLC45NTg3NCwxLjAyMTk3LC45ODUwNywuOTY3NTIsLjk3MTY4LC45NTEwNywxLjE2NTc5LC45NTEwNywxLjIxMjM3LDEuMDM5NTksMS4wMzYsMS4wMzYsMSwxLjAzNiwxLjE2NTc5LC44NzM1NywxLjMxODE4LDEuMTg3NTQsMS4yNjc4MSwxLjA1MzU2LDEuMjEyMzcsMS4xODYyMiwuNzk0ODcsLjk0OTk0LDEuMjkwMDQsMS4yNDA0NywxLjI0MDQ3LDEuMzE4MTgsMSwuOTE0ODQsLjk3NTQsMS4zMTgxOCwxLjEzNDksMS4yNDg2NiwxLjA1MzU2LDEuMTM5MzQsMS4xNTU3NCwxLjE3Mzg5LC43MzU0MSwuOTczNjMsLjk3MzYzLC45NzM2MywuOTczNjMsLjk3MzYzLC45NzM2MywuOTQzODUsLjg3ODk3LC43OTQyOSwuNzk0MjksLjc5NDI5LC43OTQyOSwxLjE0MDYsMS4xNDA2LDEuMTQwNiwxLjE0MDYsMS4wNDI2LDEuMTA2MTUsLjk3NTUyLC45NzU1MiwuOTc1NTIsLjk3NTUyLC45NzU1MiwxLjIxMjM3LC45NzU1MiwxLjAwMTM1LDEuMDAxMzUsMS4wMDEzNSwxLjAwMTM1LC45MTE0MiwuOTQ0MzYsLjk4NzIxLDEuMDY1ODUsMS4wNjU4NSwxLjA2NTg1LDEuMDY1ODUsMS4wNjU4NSwxLjA2NTg1LC45NjcwNSwuODMwNTUsLjkzNTAzLC45MzUwMywuOTM1MDMsLjkzNTAzLDEuMTQyMzYsMS4xNDIzNiwxLjE0MjM2LDEuMTQyMzYsLjkzMTI1LC45NzkyMiwuOTQxNjUsLjk0MTY1LC45NDE2NSwuOTQxNjUsLjk0MTY1LDEuMjkwMDQsLjk0MTY1LC45NzkyMiwuOTc5MjIsLjk3OTIyLC45NzkyMiwuOTY3NTIsLjk3MDQyLC45Njc1MiwuOTczNjMsMS4wNjU4NSwuOTczNjMsMS4wNjU4NSwuOTczNjMsMS4wNjU4NSwuODc4OTcsLjgzMDU1LC44Nzg5NywuODMwNTUsLjg3ODk3LC44MzA1NSwuODc4OTcsLjgzMDU1LDEuMDQyNiwxLjAwMzMsMS4wNDI2LC45NzA0MiwuNzk0MjksLjkzNTAzLC43OTQyOSwuOTM1MDMsLjc5NDI5LC45MzUwMywuNzk0MjksLjkzNTAzLC43OTQyOSwuOTM1MDMsLjkxMTQ5LC45NzA0MiwuOTExNDksLjk3MDQyLC45MTE0OSwuOTcwNDIsMSwxLDEuMDU4MTUsLjk3OTIyLDEuMDU4MTUsLjk3OTIyLDEuMTQwNiwxLjE0MjM2LDEuMTQwNiwxLjE0MjM2LDEuMTQwNiwxLjE0MjM2LDEuMTQwNiwxLjE0MjM2LDEuMTQwNiwxLjE0MjM2LC45NzQ0MSwxLjA0MzAyLC43OTYzMSwxLjAxNTgyLDEsMSwxLjAxMDU0LC44Mzg1MywxLjE0MjM2LDEsMSwuODM4NTMsMS4wOTEyNSwuODM4NTMsLjkwNDE4LC44Mzg1MywxLjE5NTA4LDEuMTA2MTUsLjk3OTIyLDEsMSwxLjEwNjE1LC45NzkyMiwxLjAxMDM0LDEuMTA0NjYsLjk3OTIyLC45NzU1MiwuOTQxNjUsLjk3NTUyLC45NDE2NSwuOTc1NTIsLjk0MTY1LC45MTYwMiwuOTE5ODEsLjg4NjQxLDEuMDI3NiwxLDEsLjg4NjQxLDEuMDI3NiwuODA1MjcsLjc4OTI5LC44MDUyNywuNzg5MjksLjgwNTI3LC43ODkyOSwuODA1MjcsLjc4OTI5LDEsMSwuOTYwODMsMS4wNTQwMywuOTU5MjMsMS4xNjg2MiwxLjAwMTM1LC45NzkyMiwxLjAwMTM1LC45NzkyMiwxLjAwMTM1LC45NzkyMiwxLjAwMTM1LC45NzkyMiwxLjAwMTM1LC45NzkyMiwxLjAwMTM1LC45NzkyMiwxLjA2Nzc3LDEuMDIxOTcsLjkxMTQyLC45Njc1MiwuOTExNDIsLjk5MzYxLC45NzE2OCwuOTkzNjEsLjk3MTY4LC45OTM2MSwuOTcxNjgsMS4yMzE5OSwxLjAzNiwuOTczNjMsMS4wNjU4NSwuOTQzODUsLjk2NzA1LC45NzU1MiwuOTQxNjUsMSwxLC45NjA4MywxLjEyNjEsMS4zMTgxOCwxLjMxODE4LDEuMzE4MTgsMS4zMTgxOCwxLjMxODE4LDEuMzE4MTgsMS4zMTgxOCwxLjMxODE4LDEuMzE4MTgsLjk1MTYxLDEuMjcxMjYsMS4wMDgxMSwuODMyODQsLjc3NzAyLC45OTEzNywuOTUyNTMsMS4wMzQ3LC44NjE0MiwxLjA3MjA1LDEuMTQyMzYsLjk3MzYzLC44OTcyMywuODY4NjksMS4wOTgxOCwuNzk0MjksLjk5MzYxLDEuMDU4MTUsLjk3NTUyLDEuMTQwNiwuOTAxMjgsMS4wNjY2MiwxLjA0Mzk2LDEuMTA2MTUsLjg0OTE4LC45NzU1MiwxLjA0Njk0LC45NDQzNiwuOTgwMTUsLjk2MDgzLC45MTE0MiwxLjAwMzU2LC45ODE3LDEuMDE5NDUsLjk4OTk5LDEuMTQwNiwuOTExNDIsMS4wNDk2MSwuOTg5OCwxLjAwNjM5LDEuMTQyMzYsMS4wNzUxNCwxLjA0OTYxLC45OTYwNywxLjAyODk3LDEuMDA4LC45ODk4LC45NTEzNCwxLjAwNjM5LDEuMTExMjEsMS4xNDIzNiwxLjAwNTE4LC45Nzk4MSwxLjAyMTg2LDEsMS4wODU3OCwuOTQxNjUsLjk5MzE0LC45ODM4NywuOTMwMjgsLjkzMzc3LDEuMzUxMjUsMS4wNzUxNCwxLjEwNjg3LC45MzQ5MSwxLjA0MjMyLDEuMDAzNTEsMS4xNDIzNiwxLjA3NTE0LC45NDE2NSwxLjA3NTE0LDEuMDAzNTEsLjc5NDI5LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuMDkwOTcsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsLjkzNTAzLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC45NjYwOSwxLDEsMSwxLDEsMSwxLjA2Nzc3LDEuMDIxOTcsMS4wNjc3NywxLjAyMTk3LDEuMDY3NzcsMS4wMjE5NywuOTExNDIsLjk2NzUyLDEsMS4yMTI2MSwuODk5MDMsMSwxLC43NTE1NSwxLjA0NzQ1LDEuMDQ3NDUsMS4wNDc0NSwxLjA0Mzk0LC45ODYzMywuOTg2MzMsLjk4NjMzLC43Mjk1OSwuNzI5NTksMS4yMDUwMiwuOTE0MDYsMS4yNjUxNCwxLjIyMiwxLjAyOTU2LDEuMDMzNzIsMS4wMzM3MiwuOTYwMzksMS4yNDYzMywxLDEuMDkxMjUsLjkzMzI3LDEuMDMzMzYsMS4xNjU0MSwxLjAzNiwxLDEsMSwuNzcxLDEsMSwxLjE1NTc0LDEuMTU1NzQsMS4xNTU3NCwxLjE1NTc0LC44NjM2NCwuOTQ0MzQsLjg2Mjc5LC45NDQzNCwuODYyMjQsMSwxLDEuMTY3OTgsMSwuOTYwODUsLjkwMDY4LDEuMjEyMzcsMS4xODQxNiwxLjEzOTA0LC42OTgyNSwuOTcxNiwyLjEwMzM5LDEuMjkwMDQsMS4yOTAwNCwxLjIxMzM5LDEuMjkwMDQsMS4yOTAwNCwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuNDI2MDMsMSwuOTk4NjIsLjk5ODYyLDEsLjg3MDI1LC44NzAyNSwuODcwMjUsLjg3MDI1LDEuMTg3NzUsMS40MjYwMywxLDEuNDI2MDMsMS40MjYwMywuOTk4NjIsMSwxLDEsMSwxLDEuMjg4NiwxLjA0MzE1LDEuMTUyOTYsMS4zNDE2MywxLDEsMSwxLjEzMjY5LDEuMTMyNjksMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDFdLFluPXtsaW5lSGVpZ2h0OjEuMzMwMDgsbGluZUdhcDowfSxabj1bMS43NjczOCwxLDEsLjk4OTQ2LDEuMTQ3NjMsMS4wNTM2NSwxLjA2MjM0LC45NjkyNywuOTI1ODYsMS4xNTM3MywxLjE4NDE0LC45MTM0OSwuOTEzNDksMS4wNzQwMywxLjE3MzA4LC43ODM4MywxLjIwMDg4LC43ODM4MywxLjQyNTMxLC45NjkyNywuOTY5MjcsLjk2OTI3LC45NjkyNywuOTY5MjcsLjk2OTI3LC45NjkyNywuOTY5MjcsLjk2OTI3LC45NjkyNywuNzgzODMsLjc4MzgzLDEuMTczMDgsMS4xNzMwOCwxLjE3MzA4LC43NzM0OSwuOTQ1NjUsLjk0NzI5LC44NTk0NCwuODg1MDYsLjk4NTgsLjc0ODE3LC44MDAxNiwuODg0NDksLjk4MDM5LC45NTc4MiwuNjkyMzgsLjg5ODk4LC44MzIzMSwuOTgxODMsMS4wMzk4OSwuOTY5MjQsLjg2MjM3LC45NjkyNCwuODA1OTUsLjc0NTI0LC44NjA5MSwuOTU0MDIsLjk0MTQzLC45ODQ0OCwuODg1OCwuODMwODksLjkzMjg1LDEuMDk0OSwxLjM5MDE2LDEuMDk0OSwxLjQ1OTk0LC43NDYyNywxLjA0ODM5LC45NzQ1NCwuOTc0NTQsLjg3MjA3LC45NzQ1NCwuODc1MzMsMS4wNjE1MSwuOTc0NTQsMS4wMDE3NiwxLjE2NDg0LDEuMDgxMzIsLjk4MDQ3LDEuMTY0ODQsMS4wMjk4OSwxLjAxMDU0LC45NjIyNSwuOTc0NTQsLjk3NDU0LDEuMDY1OTgsLjc5MDA0LDEuMTYzNDQsMS4wMDM1MSwuOTQ2MjksLjk5NzMsLjkxMDE2LC45Njc3NywuOTA0MywuOTEwODIsLjkyNDgxLC45MTA4MiwxLjE3MzA4LC45NTc0OCwuOTY5MjcsLjk2OTI3LDEsLjk2OTI3LC45MjQ4MSwuODA1OTcsMS4wNDgzOSwxLjIzMzkzLDEuMTc4MSwuOTI0NSwxLjE3MzA4LDEuMjA4MDgsLjYzMjE4LC45NDI2MSwxLjI0ODIyLDEuMDk5NzEsMS4wOTk3MSwxLjA0ODM5LDEsLjg1MjczLC43ODAzMiwxLjA0ODM5LDEuMDk5NzEsMS4yMjMyNiwuOTI0NSwxLjA5ODM2LDEuMTM1MjUsMS4xNTIyMiwuNzA0MjQsLjk0NzI5LC45NDcyOSwuOTQ3MjksLjk0NzI5LC45NDcyOSwuOTQ3MjksLjg1NDk4LC44ODUwNiwuNzQ4MTcsLjc0ODE3LC43NDgxNywuNzQ4MTcsLjk1NzgyLC45NTc4MiwuOTU3ODIsLjk1NzgyLC45ODU4LDEuMDM5ODksLjk2OTI0LC45NjkyNCwuOTY5MjQsLjk2OTI0LC45NjkyNCwxLjE3MzA4LC45NjkyNCwuOTU0MDIsLjk1NDAyLC45NTQwMiwuOTU0MDIsLjgzMDg5LC44NjIzNywuODg0MDksLjk3NDU0LC45NzQ1NCwuOTc0NTQsLjk3NDU0LC45NzQ1NCwuOTc0NTQsLjkyOTE2LC44NzIwNywuODc1MzMsLjg3NTMzLC44NzUzMywuODc1MzMsLjkzMTQ2LC45MzE0NiwuOTMxNDYsLjkzMTQ2LC45Mzg1NCwxLjAxMDU0LC45NjIyNSwuOTYyMjUsLjk2MjI1LC45NjIyNSwuOTYyMjUsMS4yNDgyMiwuODc2MSwxLjAwMzUxLDEuMDAzNTEsMS4wMDM1MSwxLjAwMzUxLC45Njc3NywuOTc0NTQsLjk2Nzc3LC45NDcyOSwuOTc0NTQsLjk0NzI5LC45NzQ1NCwuOTQ3MjksLjk3NDU0LC44ODUwNiwuODcyMDcsLjg4NTA2LC44NzIwNywuODg1MDYsLjg3MjA3LC44ODUwNiwuODcyMDcsLjk4NTgsLjk1MzkxLC45ODU4LC45NzQ1NCwuNzQ4MTcsLjg3NTMzLC43NDgxNywuODc1MzMsLjc0ODE3LC44NzUzMywuNzQ4MTcsLjg3NTMzLC43NDgxNywuODc1MzMsLjg4NDQ5LC45NzQ1NCwuODg0NDksLjk3NDU0LC44ODQ0OSwuOTc0NTQsMSwxLC45ODAzOSwxLjAwMTc2LC45ODAzOSwxLjAwMTc2LC45NTc4MiwuOTMxNDYsLjk1NzgyLC45MzE0NiwuOTU3ODIsLjkzMTQ2LC45NTc4MiwxLjE2NDg0LC45NTc4MiwuOTMxNDYsLjg0NDIxLDEuMTI3NjEsLjY5MjM4LDEuMDgxMzIsMSwxLC45ODA0NywuODMyMzEsMS4xNjQ4NCwxLDEsLjg0NzIzLDEuMDQ4NjEsLjg0NzIzLC43ODc1NSwuODMyMzEsMS4yMzczNiwxLjAzOTg5LDEuMDEwNTQsMSwxLDEuMDM5ODksMS4wMTA1NCwuOTg1NywxLjAzODQ5LDEuMDEwNTQsLjk2OTI0LC45NjIyNSwuOTY5MjQsLjk2MjI1LC45NjkyNCwuOTYyMjUsLjkyMzgzLC45MDE3MSwuODA1OTUsMS4wNjU5OCwxLDEsLjgwNTk1LDEuMDY1OTgsLjc0NTI0LC43OTAwNCwuNzQ1MjQsLjc5MDA0LC43NDUyNCwuNzkwMDQsLjc0NTI0LC43OTAwNCwxLDEsLjg2MDkxLDEuMDI3NTksLjg1NzcxLDEuMTYzNDQsLjk1NDAyLDEuMDAzNTEsLjk1NDAyLDEuMDAzNTEsLjk1NDAyLDEuMDAzNTEsLjk1NDAyLDEuMDAzNTEsLjk1NDAyLDEuMDAzNTEsLjk1NDAyLDEuMDAzNTEsLjk4NDQ4LC45OTczLC44MzA4OSwuOTY3NzcsLjgzMDg5LC45MzI4NSwuOTA0MywuOTMyODUsLjkwNDMsLjkzMjg1LC45MDQzLDEuMzE4NjgsLjk2OTI3LC45NDcyOSwuOTc0NTQsLjg1NDk4LC45MjkxNiwuOTY5MjQsLjg3NjEsMSwxLC44NjA5MSwxLjE2MzQ0LDEuMDQ4MzksMS4wNDgzOSwxLjA0ODM5LDEuMDQ4MzksMS4wNDgzOSwxLjA0ODM5LDEuMDQ4MzksMS4wNDgzOSwxLjA0ODM5LC44MTk2NSwuODE5NjUsLjk0NzI5LC43ODAzMiwuNzEwMjIsLjkwODgzLC44NDE3MSwuOTk4NzcsLjc3NTk2LDEuMDU3MzQsMS4yLC45NDcyOSwuODU5NDQsLjgyNzkxLC45NjA3LC43NDgxNywuOTMyODUsLjk4MDM5LC45NjkyNCwuOTU3ODIsLjg5ODk4LC45ODMxNiwuOTgxODMsMS4wMzk4OSwuNzg2MTQsLjk2OTI0LC45NzY0MiwuODYyMzcsLjg2MDc1LC44NjA5MSwuODMwODksLjkwMDgyLC44ODU4LC45NzI5NiwxLjAxMjg0LC45NTc4MiwuODMwODksMS4wOTc2LDEuMDQsMS4wMzM0MiwxLjIsMS4wNjc1LDEuMDk3NiwuOTgyMDUsMS4wMzgwOSwxLjA1MDk3LDEuMDQsLjk1MzY0LDEuMDMzNDIsMS4wNTQwMSwxLjIsMS4wMjE0OCwxLjAxMTksMS4wNDcyNCwxLjAxMjcsMS4wMjczMiwuOTYyMjUsLjg5NjUsLjk3NzgzLC45MzU3NCwuOTQ4MTgsMS4zMDY3OSwxLjA2NzUsMS4xMTgyNiwuOTk4MjEsMS4wNTU3LDEuMDMyNiwxLjIsMS4wNjc1LC45NjIyNSwxLjA2NzUsMS4wMzI2LC43NDgxNywxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLjAzNzU0LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC44NzUzMywxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwuOTg3MDUsMSwxLDEsMSwxLDEsLjk4NDQ4LC45OTczLC45ODQ0OCwuOTk3MywuOTg0NDgsLjk5NzMsLjgzMDg5LC45Njc3NywxLDEuMjAwODgsLjg5OTAzLDEsMSwuNzUxNTUsLjk0OTQ1LC45NDk0NSwuOTQ5NDUsLjk0OTQ1LDEuMTIzMTcsMS4xMjMxNywxLjEyMzE3LC42NzYwMywuNjc2MDMsMS4xNTYyMSwuNzM1ODQsMS4yMTE5MSwxLjIyMTM1LDEuMDY0ODMsLjk0ODY4LC45NDg2OCwuOTU5OTYsMS4yNDYzMywxLDEuMDc0OTcsLjg3NzA5LC45NjkyNywxLjAxNDczLC45NjkyNywxLDEsMSwuNzcyOTUsMSwxLDEuMDk4MzYsMS4wOTgzNiwxLjA5ODM2LDEuMDE1MjIsLjg2MzIxLC45NDQzNCwuODY0OSwuOTQ0MzQsLjg2MTgyLDEsMSwxLjA4MywxLC45MTU3OCwuODY0MzgsMS4xNzMwOCwxLjE4NDE2LDEuMTQ1ODksLjY5ODI1LC45NzYyMiwxLjk2NzkxLDEuMjQ4MjIsMS4yNDgyMiwxLjE3MzA4LDEuMjQ4MjIsMS4yNDgyMiwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuNDI2MDMsMSwuOTk4NjIsLjk5ODYyLDEsLjg3MDI1LC44NzAyNSwuODcwMjUsLjg3MDI1LDEuMTc5ODQsMS40MjYwMywxLDEuNDI2MDMsMS40MjYwMywuOTk4NjIsMSwxLDEsMSwxLDEuMjg4NiwxLjA0MzE1LDEuMTUyOTYsMS4zNDE2MywxLDEsMSwxLjEwNzQyLDEuMTA3NDIsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDFdLFFuPXtsaW5lSGVpZ2h0OjEuMzMwMDgsbGluZUdhcDowfSxlaT1bMS43NjczOCwxLDEsLjk4NTk0LDEuMDIyODUsMS4xMDQ1NCwxLjA2MjM0LC45NjkyNywuOTIwMzcsMS4xOTk4NSwxLjIwNDYsLjkwNjE2LC45MDYxNiwxLjA3MTUyLDEuMTcxNCwuNzgwMzIsMS4yMDA4OCwuNzgwMzIsMS40MDI0NiwuOTY5MjcsLjk2OTI3LC45NjkyNywuOTY5MjcsLjk2OTI3LC45NjkyNywuOTY5MjcsLjk2OTI3LC45NjkyNywuOTY5MjcsLjc4MDMyLC43ODAzMiwxLjE3MTQsMS4xNzE0LDEuMTcxNCwuODA1OTcsLjk0MDg0LC45NjcwNiwuODU5NDQsLjg1NzM0LC45NzA5MywuNzU4NDIsLjc5OTM2LC44ODE5OCwuOTgzMSwuOTU3ODIsLjcxMzg3LC44Njk2OSwuODQ2MzYsMS4wNzc5NiwxLjAzNTg0LC45NjkyNCwuODM5NjgsLjk2OTI0LC44MjgyNiwuNzk2NDksLjg1NzcxLC45NTEzMiwuOTMxMTksLjk4OTY1LC44ODQzMywuODI4NywuOTMzNjUsMS4wODYxMiwxLjM2MzgsMS4wODYxMiwxLjQ1Nzg2LC43NDYyNywuODA0OTksLjkxNDg0LDEuMDU3MDcsLjkyMzgzLDEuMDU4ODIsLjk0MDMsMS4xMjY1NCwxLjA1ODgyLDEuMDE3NTYsMS4wOTAxMSwxLjA5MDExLC45OTQxNCwxLjA5MDExLDEuMDM0LDEuMDE3NTYsMS4wNTM1NiwxLjA1NzA3LDEuMDU4ODIsMS4wNDM5OSwuODQ4NjMsMS4yMTk2OCwxLjAxNzU2LC45NTgwMSwxLjAwMDY4LC45MTc5NywuOTY3NzcsLjkwNDMsLjkwMzUxLC45MjEwNSwuOTAzNTEsMS4xNzE0LC44NTMzNywuOTY5MjcsLjk2OTI3LC45OTkxMiwuOTY5MjcsLjkyMTA1LC44MDU5NywxLjI0MzQsMS4yMDgwOCwxLjA1OTM3LC45MDk1NywxLjE3MTQsMS4yMDgwOCwuNzUxNTUsLjk0MjYxLDEuMjQ2NDQsMS4wOTk3MSwxLjA5OTcxLC44NDc1MSwxLC44NTI3MywuNzgwMzIsLjYxNTg0LDEuMDU0MjUsMS4xNzkxNCwuOTA5NTcsMS4wODY2NSwxLjExNTkzLDEuMTQxNjksLjczMzgxLC45NjcwNiwuOTY3MDYsLjk2NzA2LC45NjcwNiwuOTY3MDYsLjk2NzA2LC44NjAzNSwuODU3MzQsLjc1ODQyLC43NTg0MiwuNzU4NDIsLjc1ODQyLC45NTc4MiwuOTU3ODIsLjk1NzgyLC45NTc4MiwuOTcwOTMsMS4wMzU4NCwuOTY5MjQsLjk2OTI0LC45NjkyNCwuOTY5MjQsLjk2OTI0LDEuMTcxNCwuOTY5MjQsLjk1MTMyLC45NTEzMiwuOTUxMzIsLjk1MTMyLC44Mjg3LC44Mzk2OCwuODkwNDksLjkxNDg0LC45MTQ4NCwuOTE0ODQsLjkxNDg0LC45MTQ4NCwuOTE0ODQsLjkzNTc1LC45MjM4MywuOTQwMywuOTQwMywuOTQwMywuOTQwMywuODcxNywuODcxNywuODcxNywuODcxNywxLjAwNTI3LDEuMDE3NTYsMS4wNTM1NiwxLjA1MzU2LDEuMDUzNTYsMS4wNTM1NiwxLjA1MzU2LDEuMjQ2NDQsLjk1OTIzLDEuMDE3NTYsMS4wMTc1NiwxLjAxNzU2LDEuMDE3NTYsLjk2Nzc3LDEuMDU3MDcsLjk2Nzc3LC45NjcwNiwuOTE0ODQsLjk2NzA2LC45MTQ4NCwuOTY3MDYsLjkxNDg0LC44NTczNCwuOTIzODMsLjg1NzM0LC45MjM4MywuODU3MzQsLjkyMzgzLC44NTczNCwuOTIzODMsLjk3MDkzLDEuMDk2OSwuOTcwOTMsMS4wNTg4MiwuNzU4NDIsLjk0MDMsLjc1ODQyLC45NDAzLC43NTg0MiwuOTQwMywuNzU4NDIsLjk0MDMsLjc1ODQyLC45NDAzLC44ODE5OCwxLjA1ODgyLC44ODE5OCwxLjA1ODgyLC44ODE5OCwxLjA1ODgyLDEsMSwuOTgzMSwxLjAxNzU2LC45ODMxLDEuMDE3NTYsLjk1NzgyLC44NzE3LC45NTc4MiwuODcxNywuOTU3ODIsLjg3MTcsLjk1NzgyLDEuMDkwMTEsLjk1NzgyLC44NzE3LC44NDc4NCwxLjExNTUxLC43MTM4NywxLjA5MDExLDEsMSwuOTk0MTQsLjg0NjM2LDEuMDkwMTEsMSwxLC44NDYzNiwxLjA1MzYsLjg0NjM2LC45NDI5OCwuODQ2MzYsMS4yMzI5NywxLjAzNTg0LDEuMDE3NTYsMSwxLDEuMDM1ODQsMS4wMTc1NiwxLjAwMzIzLDEuMDM0NDQsMS4wMTc1NiwuOTY5MjQsMS4wNTM1NiwuOTY5MjQsMS4wNTM1NiwuOTY5MjQsMS4wNTM1NiwuOTMwNjYsLjk4MjkzLC44MjgyNiwxLjA0Mzk5LDEsMSwuODI4MjYsMS4wNDM5OSwuNzk2NDksLjg0ODYzLC43OTY0OSwuODQ4NjMsLjc5NjQ5LC44NDg2MywuNzk2NDksLjg0ODYzLDEsMSwuODU3NzEsMS4xNzMxOCwuODU3NzEsMS4yMTk2OCwuOTUxMzIsMS4wMTc1NiwuOTUxMzIsMS4wMTc1NiwuOTUxMzIsMS4wMTc1NiwuOTUxMzIsMS4wMTc1NiwuOTUxMzIsMS4wMTc1NiwuOTUxMzIsMS4wMTc1NiwuOTg5NjUsMS4wMDA2OCwuODI4NywuOTY3NzcsLjgyODcsLjkzMzY1LC45MDQzLC45MzM2NSwuOTA0MywuOTMzNjUsLjkwNDMsMS4wODU3MSwuOTY5MjcsLjk2NzA2LC45MTQ4NCwuODYwMzUsLjkzNTc1LC45NjkyNCwuOTU5MjMsMSwxLC44NTc3MSwxLjIxOTY4LDEuMTE0MzcsMS4xMTQzNywuOTMxMDksLjkxMjAyLC42MDQxMSwuODQxNjQsLjU1NTcyLDEuMDExNzMsLjk3MzYxLC44MTgxOCwuODE4MTgsLjk2NjM1LC43ODAzMiwuNzI3MjcsLjkyMzY2LC45ODYwMSwxLjAzNDA1LC43Nzk2OCwxLjA5Nzk5LDEuMiwuOTY3MDYsLjg1OTQ0LC44NTYzOCwuOTY0OTEsLjc1ODQyLC45MzM2NSwuOTgzMSwuOTY5MjQsLjk1NzgyLC44Njk2OSwuOTQxNTIsMS4wNzc5NiwxLjAzNTg0LC43ODQzNywuOTY5MjQsLjk4NzE1LC44Mzk2OCwuODM0OTEsLjg1NzcxLC44Mjg3LC45NDQ5MiwuODg0MzMsLjkyODcsMS4wMDk4LC45NTc4MiwuODI4NywxLjA2MjUsLjk4MjQ4LDEuMDM0MjQsMS4yLDEuMDEwNzEsMS4wNjI1LC45NTI0NiwxLjAzODA5LDEuMDQ5MTIsLjk4MjQ4LDEuMDAyMjEsMS4wMzQyNCwxLjA1NDQzLDEuMiwxLjA0Nzg1LC45OTYwOSwxLjAwMTY5LDEuMDUxNzYsLjk5MzQ2LDEuMDUzNTYsLjkwODcsMS4wMzAwNCwuOTU1NDIsLjkzMTE3LDEuMjMzNjIsMS4wMTA3MSwxLjA3ODMxLDEuMDI1MTIsMS4wNTIwNSwxLjAzNTAyLDEuMiwxLjAxMDcxLDEuMDUzNTYsMS4wMTA3MSwxLjAzNTAyLC43NTg0MiwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLjAzNzE5LDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLC45NDAzLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEuMDQwMjEsMSwxLDEsMSwxLDEsLjk4OTY1LDEuMDAwNjgsLjk4OTY1LDEuMDAwNjgsLjk4OTY1LDEuMDAwNjgsLjgyODcsLjk2Nzc3LDEsMS4yMDA4OCwuODk5MDMsMSwxLC43NTE1NSwxLjAzMDc3LDEuMDMwNzcsMS4wMzA3NywxLjAzMDc3LDEuMTMxOTYsMS4xMzE5NiwxLjEzMTk2LC42NzQyOCwuNjc0MjgsMS4xNjAzOSwuNzMyOTEsMS4yMDk5NiwxLjIyMTM1LDEuMDY0ODMsLjk0ODY4LC45NDg2OCwuOTU5OTYsMS4yNDYzMywxLDEuMDc0OTcsLjg3Nzk2LC45NjkyNywxLjAxNTE4LC45NjkyNywxLDEsMSwuNzcyOTUsMSwxLDEuMTA1MzksMS4xMDUzOSwxLjExMzU4LDEuMDY5NjcsLjg2Mjc5LC45NDQzNCwuODYyNzksLjk0NDM0LC44NjE4MiwxLDEsMS4wODMsMSwuOTE1NzgsLjg2NTA3LDEuMTcxNCwxLjE4NDE2LDEuMTQ1ODksLjY5ODI1LC45NzYyMiwxLjk2OTcsMS4yNDgyMiwxLjI0ODIyLDEuMTcyMzgsMS4yNDgyMiwxLjI0ODIyLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMS40MjYwMywxLC45OTg2MiwuOTk4NjIsMSwuODcwMjUsLjg3MDI1LC44NzAyNSwuODcwMjUsMS4xODA4MywxLjQyNjAzLDEsMS40MjYwMywxLjQyNjAzLC45OTg2MiwxLDEsMSwxLDEsMS4yODg2LDEuMDQzMTUsMS4xNTI5NiwxLjM0MTYzLDEsMSwxLDEuMTA5MzgsMS4xMDkzOCwxLDEsMSwxLjA1NDI1LDEuMDk5NzEsMS4wOTk3MSwxLjA5OTcxLDEsMSwxLDEsMSwxLDEsMSwxLDEsMV0sdGk9e2xpbmVIZWlnaHQ6MS4zMzAwOCxsaW5lR2FwOjB9LHJpPWdldExvb2t1cFRhYmxlRmFjdG9yeShmdW5jdGlvbihlKXtlWyJNeXJpYWRQcm8tUmVndWxhciJdPWVbIlBkZkpTLUZhbGxiYWNrLVJlZ3VsYXIiXT17bmFtZToiTGliZXJhdGlvblNhbnMtUmVndWxhciIsZmFjdG9yczpHbixiYXNlV2lkdGhzOkxuLGJhc2VNYXBwaW5nOmpuLG1ldHJpY3M6JG59O2VbIk15cmlhZFByby1Cb2xkIl09ZVsiUGRmSlMtRmFsbGJhY2stQm9sZCJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1Cb2xkIixmYWN0b3JzOlVuLGJhc2VXaWR0aHM6Qm4sYmFzZU1hcHBpbmc6Um4sbWV0cmljczpxbn07ZVsiTXlyaWFkUHJvLUl0Il09ZVsiTXlyaWFkUHJvLUl0YWxpYyJdPWVbIlBkZkpTLUZhbGxiYWNrLUl0YWxpYyJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1JdGFsaWMiLGZhY3RvcnM6V24sYmFzZVdpZHRoczpQbixiYXNlTWFwcGluZzpfbixtZXRyaWNzOnpufTtlWyJNeXJpYWRQcm8tQm9sZEl0Il09ZVsiTXlyaWFkUHJvLUJvbGRJdGFsaWMiXT1lWyJQZGZKUy1GYWxsYmFjay1Cb2xkSXRhbGljIl09e25hbWU6IkxpYmVyYXRpb25TYW5zLUJvbGRJdGFsaWMiLGZhY3RvcnM6WG4sYmFzZVdpZHRoczpFbixiYXNlTWFwcGluZzpObixtZXRyaWNzOkhufTtlLkFyaWFsTVQ9ZS5BcmlhbD1lWyJBcmlhbC1SZWd1bGFyIl09e25hbWU6IkxpYmVyYXRpb25TYW5zLVJlZ3VsYXIiLGJhc2VXaWR0aHM6TG4sYmFzZU1hcHBpbmc6am59O2VbIkFyaWFsLUJvbGRNVCJdPWVbIkFyaWFsLUJvbGQiXT17bmFtZToiTGliZXJhdGlvblNhbnMtQm9sZCIsYmFzZVdpZHRoczpCbixiYXNlTWFwcGluZzpSbn07ZVsiQXJpYWwtSXRhbGljTVQiXT1lWyJBcmlhbC1JdGFsaWMiXT17bmFtZToiTGliZXJhdGlvblNhbnMtSXRhbGljIixiYXNlV2lkdGhzOlBuLGJhc2VNYXBwaW5nOl9ufTtlWyJBcmlhbC1Cb2xkSXRhbGljTVQiXT1lWyJBcmlhbC1Cb2xkSXRhbGljIl09e25hbWU6IkxpYmVyYXRpb25TYW5zLUJvbGRJdGFsaWMiLGJhc2VXaWR0aHM6RW4sYmFzZU1hcHBpbmc6Tm59O2VbIkNhbGlicmktUmVndWxhciJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1SZWd1bGFyIixmYWN0b3JzOkFuLGJhc2VXaWR0aHM6TG4sYmFzZU1hcHBpbmc6am4sbWV0cmljczprbn07ZVsiQ2FsaWJyaS1Cb2xkIl09e25hbWU6IkxpYmVyYXRpb25TYW5zLUJvbGQiLGZhY3RvcnM6bW4sYmFzZVdpZHRoczpCbixiYXNlTWFwcGluZzpSbixtZXRyaWNzOmJufTtlWyJDYWxpYnJpLUl0YWxpYyJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1JdGFsaWMiLGZhY3RvcnM6eG4sYmFzZVdpZHRoczpQbixiYXNlTWFwcGluZzpfbixtZXRyaWNzOlNufTtlWyJDYWxpYnJpLUJvbGRJdGFsaWMiXT17bmFtZToiTGliZXJhdGlvblNhbnMtQm9sZEl0YWxpYyIsZmFjdG9yczp5bixiYXNlV2lkdGhzOkVuLGJhc2VNYXBwaW5nOk5uLG1ldHJpY3M6d259O2VbIlNlZ29ldWktUmVndWxhciJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1SZWd1bGFyIixmYWN0b3JzOmVpLGJhc2VXaWR0aHM6TG4sYmFzZU1hcHBpbmc6am4sbWV0cmljczp0aX07ZVsiU2Vnb2V1aS1Cb2xkIl09e25hbWU6IkxpYmVyYXRpb25TYW5zLUJvbGQiLGZhY3RvcnM6Vm4sYmFzZVdpZHRoczpCbixiYXNlTWFwcGluZzpSbixtZXRyaWNzOktufTtlWyJTZWdvZXVpLUl0YWxpYyJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1JdGFsaWMiLGZhY3RvcnM6Wm4sYmFzZVdpZHRoczpQbixiYXNlTWFwcGluZzpfbixtZXRyaWNzOlFufTtlWyJTZWdvZXVpLUJvbGRJdGFsaWMiXT17bmFtZToiTGliZXJhdGlvblNhbnMtQm9sZEl0YWxpYyIsZmFjdG9yczpKbixiYXNlV2lkdGhzOkVuLGJhc2VNYXBwaW5nOk5uLG1ldHJpY3M6WW59O2VbIkhlbHZldGljYS1SZWd1bGFyIl09ZS5IZWx2ZXRpY2E9e25hbWU6IkxpYmVyYXRpb25TYW5zLVJlZ3VsYXIiLGZhY3RvcnM6TW4sYmFzZVdpZHRoczpMbixiYXNlTWFwcGluZzpqbixtZXRyaWNzOkRufTtlWyJIZWx2ZXRpY2EtQm9sZCJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1Cb2xkIixmYWN0b3JzOkNuLGJhc2VXaWR0aHM6Qm4sYmFzZU1hcHBpbmc6Um4sbWV0cmljczp2bn07ZVsiSGVsdmV0aWNhLUl0YWxpYyJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1JdGFsaWMiLGZhY3RvcnM6VG4sYmFzZVdpZHRoczpQbixiYXNlTWFwcGluZzpfbixtZXRyaWNzOk9ufTtlWyJIZWx2ZXRpY2EtQm9sZEl0YWxpYyJdPXtuYW1lOiJMaWJlcmF0aW9uU2Fucy1Cb2xkSXRhbGljIixmYWN0b3JzOkZuLGJhc2VXaWR0aHM6RW4sYmFzZU1hcHBpbmc6Tm4sbWV0cmljczpJbn19KTtmdW5jdGlvbiBnZXRYZmFGb250TmFtZShlKXtjb25zdCB0PW5vcm1hbGl6ZUZvbnROYW1lKGUpO3JldHVybiByaSgpW3RdfWZ1bmN0aW9uIGdldFhmYUZvbnREaWN0KGUpe2NvbnN0IHQ9ZnVuY3Rpb24gZ2V0WGZhRm9udFdpZHRocyhlKXtjb25zdCB0PWdldFhmYUZvbnROYW1lKGUpO2lmKCF0KXJldHVybiBudWxsO2NvbnN0e2Jhc2VXaWR0aHM6cixiYXNlTWFwcGluZzphLGZhY3RvcnM6bn09dCxpPW4/ci5tYXAoKGUsdCk9PmUqblt0XSk6cjtsZXQgcyxvPS0yO2NvbnN0IGM9W107Zm9yKGNvbnN0W2UsdF1vZiBhLm1hcCgoZSx0KT0+W2UsdF0pLnNvcnQoKFtlXSxbdF0pPT5lLXQpKWlmKC0xIT09ZSlpZihlPT09bysxKXtzLnB1c2goaVt0XSk7bys9MX1lbHNle289ZTtzPVtpW3RdXTtjLnB1c2goZSxzKX1yZXR1cm4gY30oZSkscj1uZXcgRGljdChudWxsKTtyLnNldCgiQmFzZUZvbnQiLE5hbWUuZ2V0KGUpKTtyLnNldCgiVHlwZSIsTmFtZS5nZXQoIkZvbnQiKSk7ci5zZXQoIlN1YnR5cGUiLE5hbWUuZ2V0KCJDSURGb250VHlwZTIiKSk7ci5zZXQoIkVuY29kaW5nIixOYW1lLmdldCgiSWRlbnRpdHktSCIpKTtyLnNldCgiQ0lEVG9HSURNYXAiLE5hbWUuZ2V0KCJJZGVudGl0eSIpKTtyLnNldCgiVyIsdCk7ci5zZXQoIkZpcnN0Q2hhciIsdFswXSk7ci5zZXQoIkxhc3RDaGFyIix0LmF0KC0yKSt0LmF0KC0xKS5sZW5ndGgtMSk7Y29uc3QgYT1uZXcgRGljdChudWxsKTtyLnNldCgiRm9udERlc2NyaXB0b3IiLGEpO2NvbnN0IG49bmV3IERpY3QobnVsbCk7bi5zZXQoIk9yZGVyaW5nIiwiSWRlbnRpdHkiKTtuLnNldCgiUmVnaXN0cnkiLCJBZG9iZSIpO24uc2V0KCJTdXBwbGVtZW50IiwwKTtyLnNldCgiQ0lEU3lzdGVtSW5mbyIsbik7cmV0dXJuIHJ9Y2xhc3MgUG9zdFNjcmlwdFBhcnNlcntjb25zdHJ1Y3RvcihlKXt0aGlzLmxleGVyPWU7dGhpcy5vcGVyYXRvcnM9W107dGhpcy50b2tlbj1udWxsO3RoaXMucHJldj1udWxsfW5leHRUb2tlbigpe3RoaXMucHJldj10aGlzLnRva2VuO3RoaXMudG9rZW49dGhpcy5sZXhlci5nZXRUb2tlbigpfWFjY2VwdChlKXtpZih0aGlzLnRva2VuLnR5cGU9PT1lKXt0aGlzLm5leHRUb2tlbigpO3JldHVybiEwfXJldHVybiExfWV4cGVjdChlKXtpZih0aGlzLmFjY2VwdChlKSlyZXR1cm4hMDt0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYFVuZXhwZWN0ZWQgc3ltYm9sOiBmb3VuZCAke3RoaXMudG9rZW4udHlwZX0gZXhwZWN0ZWQgJHtlfS5gKX1wYXJzZSgpe3RoaXMubmV4dFRva2VuKCk7dGhpcy5leHBlY3QoYWkuTEJSQUNFKTt0aGlzLnBhcnNlQmxvY2soKTt0aGlzLmV4cGVjdChhaS5SQlJBQ0UpO3JldHVybiB0aGlzLm9wZXJhdG9yc31wYXJzZUJsb2NrKCl7Zm9yKDs7KWlmKHRoaXMuYWNjZXB0KGFpLk5VTUJFUikpdGhpcy5vcGVyYXRvcnMucHVzaCh0aGlzLnByZXYudmFsdWUpO2Vsc2UgaWYodGhpcy5hY2NlcHQoYWkuT1BFUkFUT1IpKXRoaXMub3BlcmF0b3JzLnB1c2godGhpcy5wcmV2LnZhbHVlKTtlbHNle2lmKCF0aGlzLmFjY2VwdChhaS5MQlJBQ0UpKXJldHVybjt0aGlzLnBhcnNlQ29uZGl0aW9uKCl9fXBhcnNlQ29uZGl0aW9uKCl7Y29uc3QgZT10aGlzLm9wZXJhdG9ycy5sZW5ndGg7dGhpcy5vcGVyYXRvcnMucHVzaChudWxsLG51bGwpO3RoaXMucGFyc2VCbG9jaygpO3RoaXMuZXhwZWN0KGFpLlJCUkFDRSk7aWYodGhpcy5hY2NlcHQoYWkuSUYpKXt0aGlzLm9wZXJhdG9yc1tlXT10aGlzLm9wZXJhdG9ycy5sZW5ndGg7dGhpcy5vcGVyYXRvcnNbZSsxXT0ianoifWVsc2V7aWYoIXRoaXMuYWNjZXB0KGFpLkxCUkFDRSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJQUyBGdW5jdGlvbjogZXJyb3IgcGFyc2luZyBjb25kaXRpb25hbC4iKTt7Y29uc3QgdD10aGlzLm9wZXJhdG9ycy5sZW5ndGg7dGhpcy5vcGVyYXRvcnMucHVzaChudWxsLG51bGwpO2NvbnN0IHI9dGhpcy5vcGVyYXRvcnMubGVuZ3RoO3RoaXMucGFyc2VCbG9jaygpO3RoaXMuZXhwZWN0KGFpLlJCUkFDRSk7dGhpcy5leHBlY3QoYWkuSUZFTFNFKTt0aGlzLm9wZXJhdG9yc1t0XT10aGlzLm9wZXJhdG9ycy5sZW5ndGg7dGhpcy5vcGVyYXRvcnNbdCsxXT0iaiI7dGhpcy5vcGVyYXRvcnNbZV09cjt0aGlzLm9wZXJhdG9yc1tlKzFdPSJqeiJ9fX19Y29uc3QgYWk9e0xCUkFDRTowLFJCUkFDRToxLE5VTUJFUjoyLE9QRVJBVE9SOjMsSUY6NCxJRkVMU0U6NX07Y2xhc3MgUG9zdFNjcmlwdFRva2Vue3N0YXRpYyBnZXQgb3BDYWNoZSgpe3JldHVybiBzaGFkb3codGhpcywib3BDYWNoZSIsT2JqZWN0LmNyZWF0ZShudWxsKSl9Y29uc3RydWN0b3IoZSx0KXt0aGlzLnR5cGU9ZTt0aGlzLnZhbHVlPXR9c3RhdGljIGdldE9wZXJhdG9yKGUpe3JldHVybiBQb3N0U2NyaXB0VG9rZW4ub3BDYWNoZVtlXXx8PW5ldyBQb3N0U2NyaXB0VG9rZW4oYWkuT1BFUkFUT1IsZSl9c3RhdGljIGdldCBMQlJBQ0UoKXtyZXR1cm4gc2hhZG93KHRoaXMsIkxCUkFDRSIsbmV3IFBvc3RTY3JpcHRUb2tlbihhaS5MQlJBQ0UsInsiKSl9c3RhdGljIGdldCBSQlJBQ0UoKXtyZXR1cm4gc2hhZG93KHRoaXMsIlJCUkFDRSIsbmV3IFBvc3RTY3JpcHRUb2tlbihhaS5SQlJBQ0UsIn0iKSl9c3RhdGljIGdldCBJRigpe3JldHVybiBzaGFkb3codGhpcywiSUYiLG5ldyBQb3N0U2NyaXB0VG9rZW4oYWkuSUYsIklGIikpfXN0YXRpYyBnZXQgSUZFTFNFKCl7cmV0dXJuIHNoYWRvdyh0aGlzLCJJRkVMU0UiLG5ldyBQb3N0U2NyaXB0VG9rZW4oYWkuSUZFTFNFLCJJRkVMU0UiKSl9fWNsYXNzIFBvc3RTY3JpcHRMZXhlcntjb25zdHJ1Y3RvcihlKXt0aGlzLnN0cmVhbT1lO3RoaXMubmV4dENoYXIoKTt0aGlzLnN0ckJ1Zj1bXX1uZXh0Q2hhcigpe3JldHVybiB0aGlzLmN1cnJlbnRDaGFyPXRoaXMuc3RyZWFtLmdldEJ5dGUoKX1nZXRUb2tlbigpe2xldCBlPSExLHQ9dGhpcy5jdXJyZW50Q2hhcjtmb3IoOzspe2lmKHQ8MClyZXR1cm4gc3I7aWYoZSkxMCE9PXQmJjEzIT09dHx8KGU9ITEpO2Vsc2UgaWYoMzc9PT10KWU9ITA7ZWxzZSBpZighaXNXaGl0ZVNwYWNlKHQpKWJyZWFrO3Q9dGhpcy5uZXh0Q2hhcigpfXN3aXRjaCgwfHQpe2Nhc2UgNDg6Y2FzZSA0OTpjYXNlIDUwOmNhc2UgNTE6Y2FzZSA1MjpjYXNlIDUzOmNhc2UgNTQ6Y2FzZSA1NTpjYXNlIDU2OmNhc2UgNTc6Y2FzZSA0MzpjYXNlIDQ1OmNhc2UgNDY6cmV0dXJuIG5ldyBQb3N0U2NyaXB0VG9rZW4oYWkuTlVNQkVSLHRoaXMuZ2V0TnVtYmVyKCkpO2Nhc2UgMTIzOnRoaXMubmV4dENoYXIoKTtyZXR1cm4gUG9zdFNjcmlwdFRva2VuLkxCUkFDRTtjYXNlIDEyNTp0aGlzLm5leHRDaGFyKCk7cmV0dXJuIFBvc3RTY3JpcHRUb2tlbi5SQlJBQ0V9Y29uc3Qgcj10aGlzLnN0ckJ1ZjtyLmxlbmd0aD0wO3JbMF09U3RyaW5nLmZyb21DaGFyQ29kZSh0KTtmb3IoOyh0PXRoaXMubmV4dENoYXIoKSk+PTAmJih0Pj02NSYmdDw9OTB8fHQ+PTk3JiZ0PD0xMjIpOylyLnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZSh0KSk7Y29uc3QgYT1yLmpvaW4oIiIpO3N3aXRjaChhLnRvTG93ZXJDYXNlKCkpe2Nhc2UiaWYiOnJldHVybiBQb3N0U2NyaXB0VG9rZW4uSUY7Y2FzZSJpZmVsc2UiOnJldHVybiBQb3N0U2NyaXB0VG9rZW4uSUZFTFNFO2RlZmF1bHQ6cmV0dXJuIFBvc3RTY3JpcHRUb2tlbi5nZXRPcGVyYXRvcihhKX19Z2V0TnVtYmVyKCl7bGV0IGU9dGhpcy5jdXJyZW50Q2hhcjtjb25zdCB0PXRoaXMuc3RyQnVmO3QubGVuZ3RoPTA7dFswXT1TdHJpbmcuZnJvbUNoYXJDb2RlKGUpO2Zvcig7KGU9dGhpcy5uZXh0Q2hhcigpKT49MCYmKGU+PTQ4JiZlPD01N3x8NDU9PT1lfHw0Nj09PWUpOyl0LnB1c2goU3RyaW5nLmZyb21DaGFyQ29kZShlKSk7Y29uc3Qgcj1wYXJzZUZsb2F0KHQuam9pbigiIikpO2lmKGlzTmFOKHIpKXRocm93IG5ldyBGb3JtYXRFcnJvcihgSW52YWxpZCBmbG9hdGluZyBwb2ludCBudW1iZXI6ICR7cn1gKTtyZXR1cm4gcn19Y2xhc3MgQmFzZUxvY2FsQ2FjaGV7Y29uc3RydWN0b3IoZSl7dGhpcy5fb25seVJlZnM9ITA9PT1lPy5vbmx5UmVmcztpZighdGhpcy5fb25seVJlZnMpe3RoaXMuX25hbWVSZWZNYXA9bmV3IE1hcDt0aGlzLl9pbWFnZU1hcD1uZXcgTWFwfXRoaXMuX2ltYWdlQ2FjaGU9bmV3IFJlZlNldENhY2hlfWdldEJ5TmFtZShlKXt0aGlzLl9vbmx5UmVmcyYmdW5yZWFjaGFibGUoIlNob3VsZCBub3QgY2FsbCBgZ2V0QnlOYW1lYCBtZXRob2QuIik7Y29uc3QgdD10aGlzLl9uYW1lUmVmTWFwLmdldChlKTtyZXR1cm4gdD90aGlzLmdldEJ5UmVmKHQpOnRoaXMuX2ltYWdlTWFwLmdldChlKXx8bnVsbH1nZXRCeVJlZihlKXtyZXR1cm4gdGhpcy5faW1hZ2VDYWNoZS5nZXQoZSl8fG51bGx9c2V0KGUsdCxyKXt1bnJlYWNoYWJsZSgiQWJzdHJhY3QgbWV0aG9kIGBzZXRgIGNhbGxlZC4iKX19Y2xhc3MgTG9jYWxJbWFnZUNhY2hlIGV4dGVuZHMgQmFzZUxvY2FsQ2FjaGV7c2V0KGUsdD1udWxsLHIpe2lmKCJzdHJpbmciIT10eXBlb2YgZSl0aHJvdyBuZXcgRXJyb3IoJ0xvY2FsSW1hZ2VDYWNoZS5zZXQgLSBleHBlY3RlZCAibmFtZSIgYXJndW1lbnQuJyk7aWYodCl7aWYodGhpcy5faW1hZ2VDYWNoZS5oYXModCkpcmV0dXJuO3RoaXMuX25hbWVSZWZNYXAuc2V0KGUsdCk7dGhpcy5faW1hZ2VDYWNoZS5wdXQodCxyKX1lbHNlIHRoaXMuX2ltYWdlTWFwLmhhcyhlKXx8dGhpcy5faW1hZ2VNYXAuc2V0KGUscil9fWNsYXNzIExvY2FsQ29sb3JTcGFjZUNhY2hlIGV4dGVuZHMgQmFzZUxvY2FsQ2FjaGV7c2V0KGU9bnVsbCx0PW51bGwscil7aWYoInN0cmluZyIhPXR5cGVvZiBlJiYhdCl0aHJvdyBuZXcgRXJyb3IoJ0xvY2FsQ29sb3JTcGFjZUNhY2hlLnNldCAtIGV4cGVjdGVkICJuYW1lIiBhbmQvb3IgInJlZiIgYXJndW1lbnQuJyk7aWYodCl7aWYodGhpcy5faW1hZ2VDYWNoZS5oYXModCkpcmV0dXJuO251bGwhPT1lJiZ0aGlzLl9uYW1lUmVmTWFwLnNldChlLHQpO3RoaXMuX2ltYWdlQ2FjaGUucHV0KHQscil9ZWxzZSB0aGlzLl9pbWFnZU1hcC5oYXMoZSl8fHRoaXMuX2ltYWdlTWFwLnNldChlLHIpfX1jbGFzcyBMb2NhbEZ1bmN0aW9uQ2FjaGUgZXh0ZW5kcyBCYXNlTG9jYWxDYWNoZXtjb25zdHJ1Y3RvcihlKXtzdXBlcih7b25seVJlZnM6ITB9KX1zZXQoZT1udWxsLHQscil7aWYoIXQpdGhyb3cgbmV3IEVycm9yKCdMb2NhbEZ1bmN0aW9uQ2FjaGUuc2V0IC0gZXhwZWN0ZWQgInJlZiIgYXJndW1lbnQuJyk7dGhpcy5faW1hZ2VDYWNoZS5oYXModCl8fHRoaXMuX2ltYWdlQ2FjaGUucHV0KHQscil9fWNsYXNzIExvY2FsR1N0YXRlQ2FjaGUgZXh0ZW5kcyBCYXNlTG9jYWxDYWNoZXtzZXQoZSx0PW51bGwscil7aWYoInN0cmluZyIhPXR5cGVvZiBlKXRocm93IG5ldyBFcnJvcignTG9jYWxHU3RhdGVDYWNoZS5zZXQgLSBleHBlY3RlZCAibmFtZSIgYXJndW1lbnQuJyk7aWYodCl7aWYodGhpcy5faW1hZ2VDYWNoZS5oYXModCkpcmV0dXJuO3RoaXMuX25hbWVSZWZNYXAuc2V0KGUsdCk7dGhpcy5faW1hZ2VDYWNoZS5wdXQodCxyKX1lbHNlIHRoaXMuX2ltYWdlTWFwLmhhcyhlKXx8dGhpcy5faW1hZ2VNYXAuc2V0KGUscil9fWNsYXNzIExvY2FsVGlsaW5nUGF0dGVybkNhY2hlIGV4dGVuZHMgQmFzZUxvY2FsQ2FjaGV7Y29uc3RydWN0b3IoZSl7c3VwZXIoe29ubHlSZWZzOiEwfSl9c2V0KGU9bnVsbCx0LHIpe2lmKCF0KXRocm93IG5ldyBFcnJvcignTG9jYWxUaWxpbmdQYXR0ZXJuQ2FjaGUuc2V0IC0gZXhwZWN0ZWQgInJlZiIgYXJndW1lbnQuJyk7dGhpcy5faW1hZ2VDYWNoZS5oYXModCl8fHRoaXMuX2ltYWdlQ2FjaGUucHV0KHQscil9fWNsYXNzIFJlZ2lvbmFsSW1hZ2VDYWNoZSBleHRlbmRzIEJhc2VMb2NhbENhY2hle2NvbnN0cnVjdG9yKGUpe3N1cGVyKHtvbmx5UmVmczohMH0pfXNldChlPW51bGwsdCxyKXtpZighdCl0aHJvdyBuZXcgRXJyb3IoJ1JlZ2lvbmFsSW1hZ2VDYWNoZS5zZXQgLSBleHBlY3RlZCAicmVmIiBhcmd1bWVudC4nKTt0aGlzLl9pbWFnZUNhY2hlLmhhcyh0KXx8dGhpcy5faW1hZ2VDYWNoZS5wdXQodCxyKX19Y2xhc3MgR2xvYmFsQ29sb3JTcGFjZUNhY2hlIGV4dGVuZHMgQmFzZUxvY2FsQ2FjaGV7Y29uc3RydWN0b3IoZSl7c3VwZXIoe29ubHlSZWZzOiEwfSl9c2V0KGU9bnVsbCx0LHIpe2lmKCF0KXRocm93IG5ldyBFcnJvcignR2xvYmFsQ29sb3JTcGFjZUNhY2hlLnNldCAtIGV4cGVjdGVkICJyZWYiIGFyZ3VtZW50LicpO3RoaXMuX2ltYWdlQ2FjaGUuaGFzKHQpfHx0aGlzLl9pbWFnZUNhY2hlLnB1dCh0LHIpfWNsZWFyKCl7dGhpcy5faW1hZ2VDYWNoZS5jbGVhcigpfX1jbGFzcyBHbG9iYWxJbWFnZUNhY2hle3N0YXRpYyBOVU1fUEFHRVNfVEhSRVNIT0xEPTI7c3RhdGljIE1JTl9JTUFHRVNfVE9fQ0FDSEU9MTA7c3RhdGljIE1BWF9CWVRFX1NJWkU9NWU3OyNIPW5ldyBSZWZTZXQ7Y29uc3RydWN0b3IoKXt0aGlzLl9yZWZDYWNoZT1uZXcgUmVmU2V0Q2FjaGU7dGhpcy5faW1hZ2VDYWNoZT1uZXcgUmVmU2V0Q2FjaGV9Z2V0I1coKXtsZXQgZT0wO2Zvcihjb25zdCB0IG9mIHRoaXMuX2ltYWdlQ2FjaGUpZSs9dC5ieXRlU2l6ZTtyZXR1cm4gZX1nZXQjeigpe3JldHVybiEodGhpcy5faW1hZ2VDYWNoZS5zaXplPEdsb2JhbEltYWdlQ2FjaGUuTUlOX0lNQUdFU19UT19DQUNIRSkmJiEodGhpcy4jVzxHbG9iYWxJbWFnZUNhY2hlLk1BWF9CWVRFX1NJWkUpfXNob3VsZENhY2hlKGUsdCl7bGV0IHI9dGhpcy5fcmVmQ2FjaGUuZ2V0KGUpO2lmKCFyKXtyPW5ldyBTZXQ7dGhpcy5fcmVmQ2FjaGUucHV0KGUscil9ci5hZGQodCk7cmV0dXJuIShyLnNpemU8R2xvYmFsSW1hZ2VDYWNoZS5OVU1fUEFHRVNfVEhSRVNIT0xEKSYmISghdGhpcy5faW1hZ2VDYWNoZS5oYXMoZSkmJnRoaXMuI3opfWFkZERlY29kZUZhaWxlZChlKXt0aGlzLiNILnB1dChlKX1oYXNEZWNvZGVGYWlsZWQoZSl7cmV0dXJuIHRoaXMuI0guaGFzKGUpfWFkZEJ5dGVTaXplKGUsdCl7Y29uc3Qgcj10aGlzLl9pbWFnZUNhY2hlLmdldChlKTtyJiYoci5ieXRlU2l6ZXx8KHIuYnl0ZVNpemU9dCkpfWdldERhdGEoZSx0KXtjb25zdCByPXRoaXMuX3JlZkNhY2hlLmdldChlKTtpZighcilyZXR1cm4gbnVsbDtpZihyLnNpemU8R2xvYmFsSW1hZ2VDYWNoZS5OVU1fUEFHRVNfVEhSRVNIT0xEKXJldHVybiBudWxsO2NvbnN0IGE9dGhpcy5faW1hZ2VDYWNoZS5nZXQoZSk7aWYoIWEpcmV0dXJuIG51bGw7ci5hZGQodCk7cmV0dXJuIGF9c2V0RGF0YShlLHQpe2lmKCF0aGlzLl9yZWZDYWNoZS5oYXMoZSkpdGhyb3cgbmV3IEVycm9yKCdHbG9iYWxJbWFnZUNhY2hlLnNldERhdGEgLSBleHBlY3RlZCAic2hvdWxkQ2FjaGUiIHRvIGhhdmUgYmVlbiBjYWxsZWQuJyk7dGhpcy5faW1hZ2VDYWNoZS5oYXMoZSl8fCh0aGlzLiN6P3dhcm4oIkdsb2JhbEltYWdlQ2FjaGUuc2V0RGF0YSAtIGNhY2hlIGxpbWl0IHJlYWNoZWQuIik6dGhpcy5faW1hZ2VDYWNoZS5wdXQoZSx0KSl9Y2xlYXIoZT0hMSl7aWYoIWUpe3RoaXMuI0guY2xlYXIoKTt0aGlzLl9yZWZDYWNoZS5jbGVhcigpfXRoaXMuX2ltYWdlQ2FjaGUuY2xlYXIoKX19Y2xhc3MgUERGRnVuY3Rpb25GYWN0b3J5e2NvbnN0cnVjdG9yKHt4cmVmOmUsaXNFdmFsU3VwcG9ydGVkOnQ9ITB9KXt0aGlzLnhyZWY9ZTt0aGlzLmlzRXZhbFN1cHBvcnRlZD0hMSE9PXR9Y3JlYXRlKGUsdD0hMSl7bGV0IHIsYTtlIGluc3RhbmNlb2YgUmVmP3I9ZTplIGluc3RhbmNlb2YgRGljdD9yPWUub2JqSWQ6ZSBpbnN0YW5jZW9mIEJhc2VTdHJlYW0mJihyPWUuZGljdD8ub2JqSWQpO2lmKHIpe2NvbnN0IGU9dGhpcy5fbG9jYWxGdW5jdGlvbkNhY2hlLmdldEJ5UmVmKHIpO2lmKGUpcmV0dXJuIGV9Y29uc3Qgbj10aGlzLnhyZWYuZmV0Y2hJZlJlZihlKTtpZihBcnJheS5pc0FycmF5KG4pKXtpZighdCl0aHJvdyBuZXcgRXJyb3IoJ1BERkZ1bmN0aW9uRmFjdG9yeS5jcmVhdGUgLSBleHBlY3RlZCAicGFyc2VBcnJheSIgYXJndW1lbnQuJyk7YT1QREZGdW5jdGlvbi5wYXJzZUFycmF5KHRoaXMsbil9ZWxzZSBhPVBERkZ1bmN0aW9uLnBhcnNlKHRoaXMsbik7ciYmdGhpcy5fbG9jYWxGdW5jdGlvbkNhY2hlLnNldChudWxsLHIsYSk7cmV0dXJuIGF9Z2V0IF9sb2NhbEZ1bmN0aW9uQ2FjaGUoKXtyZXR1cm4gc2hhZG93KHRoaXMsIl9sb2NhbEZ1bmN0aW9uQ2FjaGUiLG5ldyBMb2NhbEZ1bmN0aW9uQ2FjaGUpfX1mdW5jdGlvbiB0b051bWJlckFycmF5KGUpe3JldHVybiBBcnJheS5pc0FycmF5KGUpP2lzTnVtYmVyQXJyYXkoZSxudWxsKT9lOmUubWFwKGU9PitlKTpudWxsfWNsYXNzIFBERkZ1bmN0aW9ue3N0YXRpYyBnZXRTYW1wbGVBcnJheShlLHQscixhKXtsZXQgbixpLHM9MTtmb3Iobj0wLGk9ZS5sZW5ndGg7bjxpO24rKylzKj1lW25dO3MqPXQ7Y29uc3Qgbz1uZXcgQXJyYXkocyk7bGV0IGM9MCxsPTA7Y29uc3QgaD0xLygyKipyLTEpLHU9YS5nZXRCeXRlcygocypyKzcpLzgpO2xldCBkPTA7Zm9yKG49MDtuPHM7bisrKXtmb3IoO2M8cjspe2w8PD04O2x8PXVbZCsrXTtjKz04fWMtPXI7b1tuXT0obD4+YykqaDtsJj0oMTw8YyktMX1yZXR1cm4gb31zdGF0aWMgcGFyc2UoZSx0KXtjb25zdCByPXQuZGljdHx8dDtzd2l0Y2goci5nZXQoIkZ1bmN0aW9uVHlwZSIpKXtjYXNlIDA6cmV0dXJuIHRoaXMuY29uc3RydWN0U2FtcGxlZChlLHQscik7Y2FzZSAxOmJyZWFrO2Nhc2UgMjpyZXR1cm4gdGhpcy5jb25zdHJ1Y3RJbnRlcnBvbGF0ZWQoZSxyKTtjYXNlIDM6cmV0dXJuIHRoaXMuY29uc3RydWN0U3RpY2hlZChlLHIpO2Nhc2UgNDpyZXR1cm4gdGhpcy5jb25zdHJ1Y3RQb3N0U2NyaXB0KGUsdCxyKX10aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlVua25vd24gdHlwZSBvZiBmdW5jdGlvbiIpfXN0YXRpYyBwYXJzZUFycmF5KGUsdCl7Y29uc3R7eHJlZjpyfT1lLGE9W107Zm9yKGNvbnN0IG4gb2YgdClhLnB1c2godGhpcy5wYXJzZShlLHIuZmV0Y2hJZlJlZihuKSkpO3JldHVybiBmdW5jdGlvbihlLHQscixuKXtmb3IobGV0IGk9MCxzPWEubGVuZ3RoO2k8cztpKyspYVtpXShlLHQscixuK2kpfX1zdGF0aWMgY29uc3RydWN0U2FtcGxlZChlLHQscil7ZnVuY3Rpb24gdG9NdWx0aUFycmF5KGUpe2NvbnN0IHQ9ZS5sZW5ndGgscj1bXTtsZXQgYT0wO2ZvcihsZXQgbj0wO248dDtuKz0yKXJbYSsrXT1bZVtuXSxlW24rMV1dO3JldHVybiByfWZ1bmN0aW9uIGludGVycG9sYXRlKGUsdCxyLGEsbil7cmV0dXJuIGErKG4tYSkvKHItdCkqKGUtdCl9bGV0IGE9dG9OdW1iZXJBcnJheShyLmdldEFycmF5KCJEb21haW4iKSksbj10b051bWJlckFycmF5KHIuZ2V0QXJyYXkoIlJhbmdlIikpO2lmKCFhfHwhbil0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIk5vIGRvbWFpbiBvciByYW5nZSIpO2NvbnN0IGk9YS5sZW5ndGgvMixzPW4ubGVuZ3RoLzI7YT10b011bHRpQXJyYXkoYSk7bj10b011bHRpQXJyYXkobik7Y29uc3Qgbz10b051bWJlckFycmF5KHIuZ2V0QXJyYXkoIlNpemUiKSksYz1yLmdldCgiQml0c1BlclNhbXBsZSIpLGw9ci5nZXQoIk9yZGVyIil8fDE7MSE9PWwmJmluZm8oIk5vIHN1cHBvcnQgZm9yIGN1YmljIHNwbGluZSBpbnRlcnBvbGF0aW9uOiAiK2wpO2xldCBoPXRvTnVtYmVyQXJyYXkoci5nZXRBcnJheSgiRW5jb2RlIikpO2lmKGgpaD10b011bHRpQXJyYXkoaCk7ZWxzZXtoPVtdO2ZvcihsZXQgZT0wO2U8aTsrK2UpaC5wdXNoKFswLG9bZV0tMV0pfWxldCB1PXRvTnVtYmVyQXJyYXkoci5nZXRBcnJheSgiRGVjb2RlIikpO3U9dT90b011bHRpQXJyYXkodSk6bjtjb25zdCBkPXRoaXMuZ2V0U2FtcGxlQXJyYXkobyxzLGMsdCk7cmV0dXJuIGZ1bmN0aW9uIGNvbnN0cnVjdFNhbXBsZWRGbihlLHQscixjKXtjb25zdCBsPTE8PGksZj1uZXcgRmxvYXQ2NEFycmF5KGwpLmZpbGwoMSksZz1uZXcgVWludDMyQXJyYXkobCk7bGV0IHAsbSxiPXMseT0xO2ZvcihwPTA7cDxpOysrcCl7Y29uc3Qgcj1hW3BdWzBdLG49YVtwXVsxXTtsZXQgaT1pbnRlcnBvbGF0ZShNYXRoQ2xhbXAoZVt0K3BdLHIsbikscixuLGhbcF1bMF0saFtwXVsxXSk7Y29uc3Qgcz1vW3BdO2k9TWF0aENsYW1wKGksMCxzLTEpO2NvbnN0IGM9aTxzLTE/TWF0aC5mbG9vcihpKTppLTEsdT1jKzEtaSxkPWktYyx3PWMqYix4PXcrYjtmb3IobT0wO208bDttKyspaWYobSZ5KXtmW21dKj1kO2dbbV0rPXh9ZWxzZXtmW21dKj11O2dbbV0rPXd9Yio9czt5PDw9MX1mb3IobT0wO208czsrK20pe2xldCBlPTA7Zm9yKHA9MDtwPGw7cCsrKWUrPWRbZ1twXSttXSpmW3BdO2U9aW50ZXJwb2xhdGUoZSwwLDEsdVttXVswXSx1W21dWzFdKTtyW2MrbV09TWF0aENsYW1wKGUsblttXVswXSxuW21dWzFdKX19fXN0YXRpYyBjb25zdHJ1Y3RJbnRlcnBvbGF0ZWQoZSx0KXtjb25zdCByPXRvTnVtYmVyQXJyYXkodC5nZXRBcnJheSgiQzAiKSl8fFswXSxhPXRvTnVtYmVyQXJyYXkodC5nZXRBcnJheSgiQzEiKSl8fFsxXSxuPXQuZ2V0KCJOIiksaT1bXTtmb3IobGV0IGU9MCx0PXIubGVuZ3RoO2U8dDsrK2UpaS5wdXNoKGFbZV0tcltlXSk7Y29uc3Qgcz1pLmxlbmd0aDtyZXR1cm4gZnVuY3Rpb24gY29uc3RydWN0SW50ZXJwb2xhdGVkRm4oZSx0LGEsbyl7Y29uc3QgYz0xPT09bj9lW3RdOmVbdF0qKm47Zm9yKGxldCBlPTA7ZTxzOysrZSlhW28rZV09cltlXStjKmlbZV19fXN0YXRpYyBjb25zdHJ1Y3RTdGljaGVkKGUsdCl7Y29uc3Qgcj10b051bWJlckFycmF5KHQuZ2V0QXJyYXkoIkRvbWFpbiIpKTtpZighcil0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIk5vIGRvbWFpbiIpO2lmKDEhPT1yLmxlbmd0aC8yKXRocm93IG5ldyBGb3JtYXRFcnJvcigiQmFkIGRvbWFpbiBmb3Igc3RpY2hlZCBmdW5jdGlvbiIpO2NvbnN0e3hyZWY6YX09ZSxuPVtdO2Zvcihjb25zdCByIG9mIHQuZ2V0KCJGdW5jdGlvbnMiKSluLnB1c2godGhpcy5wYXJzZShlLGEuZmV0Y2hJZlJlZihyKSkpO2NvbnN0IGk9dG9OdW1iZXJBcnJheSh0LmdldEFycmF5KCJCb3VuZHMiKSkscz10b051bWJlckFycmF5KHQuZ2V0QXJyYXkoIkVuY29kZSIpKSxvPW5ldyBGbG9hdDMyQXJyYXkoMSk7cmV0dXJuIGZ1bmN0aW9uIGNvbnN0cnVjdFN0aWNoZWRGbihlLHQsYSxjKXtjb25zdCBsPU1hdGhDbGFtcChlW3RdLHJbMF0sclsxXSksaD1pLmxlbmd0aDtsZXQgdTtmb3IodT0wO3U8aCYmIShsPGlbdV0pOysrdSk7bGV0IGQ9clswXTt1PjAmJihkPWlbdS0xXSk7bGV0IGY9clsxXTt1PGkubGVuZ3RoJiYoZj1pW3VdKTtjb25zdCBnPXNbMip1XSxwPXNbMip1KzFdO29bMF09ZD09PWY/ZzpnKyhsLWQpKihwLWcpLyhmLWQpO25bdV0obywwLGEsYyl9fXN0YXRpYyBjb25zdHJ1Y3RQb3N0U2NyaXB0KGUsdCxyKXtjb25zdCBhPXRvTnVtYmVyQXJyYXkoci5nZXRBcnJheSgiRG9tYWluIikpLG49dG9OdW1iZXJBcnJheShyLmdldEFycmF5KCJSYW5nZSIpKTtpZighYSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIk5vIGRvbWFpbi4iKTtpZighbil0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIk5vIHJhbmdlLiIpO2NvbnN0IGk9bmV3IFBvc3RTY3JpcHRMZXhlcih0KSxzPW5ldyBQb3N0U2NyaXB0UGFyc2VyKGkpLnBhcnNlKCk7aWYoZS5pc0V2YWxTdXBwb3J0ZWQmJkZlYXR1cmVUZXN0LmlzRXZhbFN1cHBvcnRlZCl7Y29uc3QgZT0obmV3IFBvc3RTY3JpcHRDb21waWxlcikuY29tcGlsZShzLGEsbik7aWYoZSlyZXR1cm4gbmV3IEZ1bmN0aW9uKCJzcmMiLCJzcmNPZmZzZXQiLCJkZXN0IiwiZGVzdE9mZnNldCIsZSl9aW5mbygiVW5hYmxlIHRvIGNvbXBpbGUgUFMgZnVuY3Rpb24iKTtjb25zdCBvPW4ubGVuZ3RoPj4xLGM9YS5sZW5ndGg+PjEsbD1uZXcgUG9zdFNjcmlwdEV2YWx1YXRvcihzKSxoPU9iamVjdC5jcmVhdGUobnVsbCk7bGV0IHU9ODE5Mjtjb25zdCBkPW5ldyBGbG9hdDMyQXJyYXkoYyk7cmV0dXJuIGZ1bmN0aW9uIGNvbnN0cnVjdFBvc3RTY3JpcHRGbihlLHQscixhKXtsZXQgaSxzLGY9IiI7Y29uc3QgZz1kO2ZvcihpPTA7aTxjO2krKyl7cz1lW3QraV07Z1tpXT1zO2YrPXMrIl8ifWNvbnN0IHA9aFtmXTtpZih2b2lkIDAhPT1wKXtyLnNldChwLGEpO3JldHVybn1jb25zdCBtPW5ldyBGbG9hdDMyQXJyYXkobyksYj1sLmV4ZWN1dGUoZykseT1iLmxlbmd0aC1vO2ZvcihpPTA7aTxvO2krKyl7cz1iW3kraV07bGV0IGU9blsyKmldO2lmKHM8ZSlzPWU7ZWxzZXtlPW5bMippKzFdO3M+ZSYmKHM9ZSl9bVtpXT1zfWlmKHU+MCl7dS0tO2hbZl09bX1yLnNldChtLGEpfX19ZnVuY3Rpb24gaXNQREZGdW5jdGlvbihlKXtsZXQgdDtpZihlIGluc3RhbmNlb2YgRGljdCl0PWU7ZWxzZXtpZighKGUgaW5zdGFuY2VvZiBCYXNlU3RyZWFtKSlyZXR1cm4hMTt0PWUuZGljdH1yZXR1cm4gdC5oYXMoIkZ1bmN0aW9uVHlwZSIpfWNsYXNzIFBvc3RTY3JpcHRTdGFja3tzdGF0aWMgTUFYX1NUQUNLX1NJWkU9MTAwO2NvbnN0cnVjdG9yKGUpe3RoaXMuc3RhY2s9ZT9BcnJheS5mcm9tKGUpOltdfXB1c2goZSl7aWYodGhpcy5zdGFjay5sZW5ndGg+PVBvc3RTY3JpcHRTdGFjay5NQVhfU1RBQ0tfU0laRSl0aHJvdyBuZXcgRXJyb3IoIlBvc3RTY3JpcHQgZnVuY3Rpb24gc3RhY2sgb3ZlcmZsb3cuIik7dGhpcy5zdGFjay5wdXNoKGUpfXBvcCgpe2lmKHRoaXMuc3RhY2subGVuZ3RoPD0wKXRocm93IG5ldyBFcnJvcigiUG9zdFNjcmlwdCBmdW5jdGlvbiBzdGFjayB1bmRlcmZsb3cuIik7cmV0dXJuIHRoaXMuc3RhY2sucG9wKCl9Y29weShlKXtpZih0aGlzLnN0YWNrLmxlbmd0aCtlPj1Qb3N0U2NyaXB0U3RhY2suTUFYX1NUQUNLX1NJWkUpdGhyb3cgbmV3IEVycm9yKCJQb3N0U2NyaXB0IGZ1bmN0aW9uIHN0YWNrIG92ZXJmbG93LiIpO2NvbnN0IHQ9dGhpcy5zdGFjaztmb3IobGV0IHI9dC5sZW5ndGgtZSxhPWUtMTthPj0wO2EtLSxyKyspdC5wdXNoKHRbcl0pfWluZGV4KGUpe3RoaXMucHVzaCh0aGlzLnN0YWNrW3RoaXMuc3RhY2subGVuZ3RoLWUtMV0pfXJvbGwoZSx0KXtjb25zdCByPXRoaXMuc3RhY2ssYT1yLmxlbmd0aC1lLG49ci5sZW5ndGgtMSxpPWErKHQtTWF0aC5mbG9vcih0L2UpKmUpO2ZvcihsZXQgZT1hLHQ9bjtlPHQ7ZSsrLHQtLSl7Y29uc3QgYT1yW2VdO3JbZV09clt0XTtyW3RdPWF9Zm9yKGxldCBlPWEsdD1pLTE7ZTx0O2UrKyx0LS0pe2NvbnN0IGE9cltlXTtyW2VdPXJbdF07clt0XT1hfWZvcihsZXQgZT1pLHQ9bjtlPHQ7ZSsrLHQtLSl7Y29uc3QgYT1yW2VdO3JbZV09clt0XTtyW3RdPWF9fX1jbGFzcyBQb3N0U2NyaXB0RXZhbHVhdG9ye2NvbnN0cnVjdG9yKGUpe3RoaXMub3BlcmF0b3JzPWV9ZXhlY3V0ZShlKXtjb25zdCB0PW5ldyBQb3N0U2NyaXB0U3RhY2soZSk7bGV0IHI9MDtjb25zdCBhPXRoaXMub3BlcmF0b3JzLG49YS5sZW5ndGg7bGV0IGkscyxvO2Zvcig7cjxuOyl7aT1hW3IrK107aWYoIm51bWJlciIhPXR5cGVvZiBpKXN3aXRjaChpKXtjYXNlImp6IjpvPXQucG9wKCk7cz10LnBvcCgpO3N8fChyPW8pO2JyZWFrO2Nhc2UiaiI6cz10LnBvcCgpO3I9czticmVhaztjYXNlImFicyI6cz10LnBvcCgpO3QucHVzaChNYXRoLmFicyhzKSk7YnJlYWs7Y2FzZSJhZGQiOm89dC5wb3AoKTtzPXQucG9wKCk7dC5wdXNoKHMrbyk7YnJlYWs7Y2FzZSJhbmQiOm89dC5wb3AoKTtzPXQucG9wKCk7ImJvb2xlYW4iPT10eXBlb2YgcyYmImJvb2xlYW4iPT10eXBlb2Ygbz90LnB1c2gocyYmbyk6dC5wdXNoKHMmbyk7YnJlYWs7Y2FzZSJhdGFuIjpvPXQucG9wKCk7cz10LnBvcCgpO3M9TWF0aC5hdGFuMihzLG8pL01hdGguUEkqMTgwO3M8MCYmKHMrPTM2MCk7dC5wdXNoKHMpO2JyZWFrO2Nhc2UiYml0c2hpZnQiOm89dC5wb3AoKTtzPXQucG9wKCk7cz4wP3QucHVzaChzPDxvKTp0LnB1c2gocz4+byk7YnJlYWs7Y2FzZSJjZWlsaW5nIjpzPXQucG9wKCk7dC5wdXNoKE1hdGguY2VpbChzKSk7YnJlYWs7Y2FzZSJjb3B5IjpzPXQucG9wKCk7dC5jb3B5KHMpO2JyZWFrO2Nhc2UiY29zIjpzPXQucG9wKCk7dC5wdXNoKE1hdGguY29zKHMlMzYwLzE4MCpNYXRoLlBJKSk7YnJlYWs7Y2FzZSJjdmkiOnM9MHx0LnBvcCgpO3QucHVzaChzKTticmVhaztjYXNlImN2ciI6YnJlYWs7Y2FzZSJkaXYiOm89dC5wb3AoKTtzPXQucG9wKCk7dC5wdXNoKHMvbyk7YnJlYWs7Y2FzZSJkdXAiOnQuY29weSgxKTticmVhaztjYXNlImVxIjpvPXQucG9wKCk7cz10LnBvcCgpO3QucHVzaChzPT09byk7YnJlYWs7Y2FzZSJleGNoIjp0LnJvbGwoMiwxKTticmVhaztjYXNlImV4cCI6bz10LnBvcCgpO3M9dC5wb3AoKTt0LnB1c2gocyoqbyk7YnJlYWs7Y2FzZSJmYWxzZSI6dC5wdXNoKCExKTticmVhaztjYXNlImZsb29yIjpzPXQucG9wKCk7dC5wdXNoKE1hdGguZmxvb3IocykpO2JyZWFrO2Nhc2UiZ2UiOm89dC5wb3AoKTtzPXQucG9wKCk7dC5wdXNoKHM+PW8pO2JyZWFrO2Nhc2UiZ3QiOm89dC5wb3AoKTtzPXQucG9wKCk7dC5wdXNoKHM+byk7YnJlYWs7Y2FzZSJpZGl2IjpvPXQucG9wKCk7cz10LnBvcCgpO3QucHVzaChzL298MCk7YnJlYWs7Y2FzZSJpbmRleCI6cz10LnBvcCgpO3QuaW5kZXgocyk7YnJlYWs7Y2FzZSJsZSI6bz10LnBvcCgpO3M9dC5wb3AoKTt0LnB1c2goczw9byk7YnJlYWs7Y2FzZSJsbiI6cz10LnBvcCgpO3QucHVzaChNYXRoLmxvZyhzKSk7YnJlYWs7Y2FzZSJsb2ciOnM9dC5wb3AoKTt0LnB1c2goTWF0aC5sb2cxMChzKSk7YnJlYWs7Y2FzZSJsdCI6bz10LnBvcCgpO3M9dC5wb3AoKTt0LnB1c2goczxvKTticmVhaztjYXNlIm1vZCI6bz10LnBvcCgpO3M9dC5wb3AoKTt0LnB1c2gocyVvKTticmVhaztjYXNlIm11bCI6bz10LnBvcCgpO3M9dC5wb3AoKTt0LnB1c2gocypvKTticmVhaztjYXNlIm5lIjpvPXQucG9wKCk7cz10LnBvcCgpO3QucHVzaChzIT09byk7YnJlYWs7Y2FzZSJuZWciOnM9dC5wb3AoKTt0LnB1c2goLXMpO2JyZWFrO2Nhc2Uibm90IjpzPXQucG9wKCk7ImJvb2xlYW4iPT10eXBlb2Ygcz90LnB1c2goIXMpOnQucHVzaCh+cyk7YnJlYWs7Y2FzZSJvciI6bz10LnBvcCgpO3M9dC5wb3AoKTsiYm9vbGVhbiI9PXR5cGVvZiBzJiYiYm9vbGVhbiI9PXR5cGVvZiBvP3QucHVzaChzfHxvKTp0LnB1c2goc3xvKTticmVhaztjYXNlInBvcCI6dC5wb3AoKTticmVhaztjYXNlInJvbGwiOm89dC5wb3AoKTtzPXQucG9wKCk7dC5yb2xsKHMsbyk7YnJlYWs7Y2FzZSJyb3VuZCI6cz10LnBvcCgpO3QucHVzaChNYXRoLnJvdW5kKHMpKTticmVhaztjYXNlInNpbiI6cz10LnBvcCgpO3QucHVzaChNYXRoLnNpbihzJTM2MC8xODAqTWF0aC5QSSkpO2JyZWFrO2Nhc2Uic3FydCI6cz10LnBvcCgpO3QucHVzaChNYXRoLnNxcnQocykpO2JyZWFrO2Nhc2Uic3ViIjpvPXQucG9wKCk7cz10LnBvcCgpO3QucHVzaChzLW8pO2JyZWFrO2Nhc2UidHJ1ZSI6dC5wdXNoKCEwKTticmVhaztjYXNlInRydW5jYXRlIjpzPXQucG9wKCk7cz1zPDA/TWF0aC5jZWlsKHMpOk1hdGguZmxvb3Iocyk7dC5wdXNoKHMpO2JyZWFrO2Nhc2UieG9yIjpvPXQucG9wKCk7cz10LnBvcCgpOyJib29sZWFuIj09dHlwZW9mIHMmJiJib29sZWFuIj09dHlwZW9mIG8/dC5wdXNoKHMhPT1vKTp0LnB1c2goc15vKTticmVhaztkZWZhdWx0OnRocm93IG5ldyBGb3JtYXRFcnJvcihgVW5rbm93biBvcGVyYXRvciAke2l9YCl9ZWxzZSB0LnB1c2goaSl9cmV0dXJuIHQuc3RhY2t9fWNsYXNzIEFzdE5vZGV7Y29uc3RydWN0b3IoZSl7dGhpcy50eXBlPWV9dmlzaXQoZSl7dW5yZWFjaGFibGUoImFic3RyYWN0IG1ldGhvZCIpfX1jbGFzcyBBc3RBcmd1bWVudCBleHRlbmRzIEFzdE5vZGV7Y29uc3RydWN0b3IoZSx0LHIpe3N1cGVyKCJhcmdzIik7dGhpcy5pbmRleD1lO3RoaXMubWluPXQ7dGhpcy5tYXg9cn12aXNpdChlKXtlLnZpc2l0QXJndW1lbnQodGhpcyl9fWNsYXNzIEFzdExpdGVyYWwgZXh0ZW5kcyBBc3ROb2Rle2NvbnN0cnVjdG9yKGUpe3N1cGVyKCJsaXRlcmFsIik7dGhpcy5udW1iZXI9ZTt0aGlzLm1pbj1lO3RoaXMubWF4PWV9dmlzaXQoZSl7ZS52aXNpdExpdGVyYWwodGhpcyl9fWNsYXNzIEFzdEJpbmFyeU9wZXJhdGlvbiBleHRlbmRzIEFzdE5vZGV7Y29uc3RydWN0b3IoZSx0LHIsYSxuKXtzdXBlcigiYmluYXJ5Iik7dGhpcy5vcD1lO3RoaXMuYXJnMT10O3RoaXMuYXJnMj1yO3RoaXMubWluPWE7dGhpcy5tYXg9bn12aXNpdChlKXtlLnZpc2l0QmluYXJ5T3BlcmF0aW9uKHRoaXMpfX1jbGFzcyBBc3RNaW4gZXh0ZW5kcyBBc3ROb2Rle2NvbnN0cnVjdG9yKGUsdCl7c3VwZXIoIm1heCIpO3RoaXMuYXJnPWU7dGhpcy5taW49ZS5taW47dGhpcy5tYXg9dH12aXNpdChlKXtlLnZpc2l0TWluKHRoaXMpfX1jbGFzcyBBc3RWYXJpYWJsZSBleHRlbmRzIEFzdE5vZGV7Y29uc3RydWN0b3IoZSx0LHIpe3N1cGVyKCJ2YXIiKTt0aGlzLmluZGV4PWU7dGhpcy5taW49dDt0aGlzLm1heD1yfXZpc2l0KGUpe2UudmlzaXRWYXJpYWJsZSh0aGlzKX19Y2xhc3MgQXN0VmFyaWFibGVEZWZpbml0aW9uIGV4dGVuZHMgQXN0Tm9kZXtjb25zdHJ1Y3RvcihlLHQpe3N1cGVyKCJkZWZpbml0aW9uIik7dGhpcy52YXJpYWJsZT1lO3RoaXMuYXJnPXR9dmlzaXQoZSl7ZS52aXNpdFZhcmlhYmxlRGVmaW5pdGlvbih0aGlzKX19Y2xhc3MgRXhwcmVzc2lvbkJ1aWxkZXJWaXNpdG9ye2NvbnN0cnVjdG9yKCl7dGhpcy5wYXJ0cz1bXX12aXNpdEFyZ3VtZW50KGUpe3RoaXMucGFydHMucHVzaCgiTWF0aC5tYXgoIixlLm1pbiwiLCBNYXRoLm1pbigiLGUubWF4LCIsIHNyY1tzcmNPZmZzZXQgKyAiLGUuaW5kZXgsIl0pKSIpfXZpc2l0VmFyaWFibGUoZSl7dGhpcy5wYXJ0cy5wdXNoKCJ2IixlLmluZGV4KX12aXNpdExpdGVyYWwoZSl7dGhpcy5wYXJ0cy5wdXNoKGUubnVtYmVyKX12aXNpdEJpbmFyeU9wZXJhdGlvbihlKXt0aGlzLnBhcnRzLnB1c2goIigiKTtlLmFyZzEudmlzaXQodGhpcyk7dGhpcy5wYXJ0cy5wdXNoKCIgIixlLm9wLCIgIik7ZS5hcmcyLnZpc2l0KHRoaXMpO3RoaXMucGFydHMucHVzaCgiKSIpfXZpc2l0VmFyaWFibGVEZWZpbml0aW9uKGUpe3RoaXMucGFydHMucHVzaCgidmFyICIpO2UudmFyaWFibGUudmlzaXQodGhpcyk7dGhpcy5wYXJ0cy5wdXNoKCIgPSAiKTtlLmFyZy52aXNpdCh0aGlzKTt0aGlzLnBhcnRzLnB1c2goIjsiKX12aXNpdE1pbihlKXt0aGlzLnBhcnRzLnB1c2goIk1hdGgubWluKCIpO2UuYXJnLnZpc2l0KHRoaXMpO3RoaXMucGFydHMucHVzaCgiLCAiLGUubWF4LCIpIil9dG9TdHJpbmcoKXtyZXR1cm4gdGhpcy5wYXJ0cy5qb2luKCIiKX19ZnVuY3Rpb24gYnVpbGRBZGRPcGVyYXRpb24oZSx0KXtyZXR1cm4ibGl0ZXJhbCI9PT10LnR5cGUmJjA9PT10Lm51bWJlcj9lOiJsaXRlcmFsIj09PWUudHlwZSYmMD09PWUubnVtYmVyP3Q6ImxpdGVyYWwiPT09dC50eXBlJiYibGl0ZXJhbCI9PT1lLnR5cGU/bmV3IEFzdExpdGVyYWwoZS5udW1iZXIrdC5udW1iZXIpOm5ldyBBc3RCaW5hcnlPcGVyYXRpb24oIisiLGUsdCxlLm1pbit0Lm1pbixlLm1heCt0Lm1heCl9ZnVuY3Rpb24gYnVpbGRNdWxPcGVyYXRpb24oZSx0KXtpZigibGl0ZXJhbCI9PT10LnR5cGUpe2lmKDA9PT10Lm51bWJlcilyZXR1cm4gbmV3IEFzdExpdGVyYWwoMCk7aWYoMT09PXQubnVtYmVyKXJldHVybiBlO2lmKCJsaXRlcmFsIj09PWUudHlwZSlyZXR1cm4gbmV3IEFzdExpdGVyYWwoZS5udW1iZXIqdC5udW1iZXIpfWlmKCJsaXRlcmFsIj09PWUudHlwZSl7aWYoMD09PWUubnVtYmVyKXJldHVybiBuZXcgQXN0TGl0ZXJhbCgwKTtpZigxPT09ZS5udW1iZXIpcmV0dXJuIHR9Y29uc3Qgcj1NYXRoLm1pbihlLm1pbip0Lm1pbixlLm1pbip0Lm1heCxlLm1heCp0Lm1pbixlLm1heCp0Lm1heCksYT1NYXRoLm1heChlLm1pbip0Lm1pbixlLm1pbip0Lm1heCxlLm1heCp0Lm1pbixlLm1heCp0Lm1heCk7cmV0dXJuIG5ldyBBc3RCaW5hcnlPcGVyYXRpb24oIioiLGUsdCxyLGEpfWZ1bmN0aW9uIGJ1aWxkU3ViT3BlcmF0aW9uKGUsdCl7aWYoImxpdGVyYWwiPT09dC50eXBlKXtpZigwPT09dC5udW1iZXIpcmV0dXJuIGU7aWYoImxpdGVyYWwiPT09ZS50eXBlKXJldHVybiBuZXcgQXN0TGl0ZXJhbChlLm51bWJlci10Lm51bWJlcil9cmV0dXJuImJpbmFyeSI9PT10LnR5cGUmJiItIj09PXQub3AmJiJsaXRlcmFsIj09PWUudHlwZSYmMT09PWUubnVtYmVyJiYibGl0ZXJhbCI9PT10LmFyZzEudHlwZSYmMT09PXQuYXJnMS5udW1iZXI/dC5hcmcyOm5ldyBBc3RCaW5hcnlPcGVyYXRpb24oIi0iLGUsdCxlLm1pbi10Lm1heCxlLm1heC10Lm1pbil9ZnVuY3Rpb24gYnVpbGRNaW5PcGVyYXRpb24oZSx0KXtyZXR1cm4gZS5taW4+PXQ/bmV3IEFzdExpdGVyYWwodCk6ZS5tYXg8PXQ/ZTpuZXcgQXN0TWluKGUsdCl9Y2xhc3MgUG9zdFNjcmlwdENvbXBpbGVye2NvbXBpbGUoZSx0LHIpe2NvbnN0IGE9W10sbj1bXSxpPXQubGVuZ3RoPj4xLHM9ci5sZW5ndGg+PjE7bGV0IG8sYyxsLGgsdSxkLGYsZyxwPTA7Zm9yKGxldCBlPTA7ZTxpO2UrKylhLnB1c2gobmV3IEFzdEFyZ3VtZW50KGUsdFsyKmVdLHRbMiplKzFdKSk7Zm9yKGxldCB0PTAscj1lLmxlbmd0aDt0PHI7dCsrKXtnPWVbdF07aWYoIm51bWJlciIhPXR5cGVvZiBnKXN3aXRjaChnKXtjYXNlImFkZCI6aWYoYS5sZW5ndGg8MilyZXR1cm4gbnVsbDtoPWEucG9wKCk7bD1hLnBvcCgpO2EucHVzaChidWlsZEFkZE9wZXJhdGlvbihsLGgpKTticmVhaztjYXNlImN2ciI6aWYoYS5sZW5ndGg8MSlyZXR1cm4gbnVsbDticmVhaztjYXNlIm11bCI6aWYoYS5sZW5ndGg8MilyZXR1cm4gbnVsbDtoPWEucG9wKCk7bD1hLnBvcCgpO2EucHVzaChidWlsZE11bE9wZXJhdGlvbihsLGgpKTticmVhaztjYXNlInN1YiI6aWYoYS5sZW5ndGg8MilyZXR1cm4gbnVsbDtoPWEucG9wKCk7bD1hLnBvcCgpO2EucHVzaChidWlsZFN1Yk9wZXJhdGlvbihsLGgpKTticmVhaztjYXNlImV4Y2giOmlmKGEubGVuZ3RoPDIpcmV0dXJuIG51bGw7dT1hLnBvcCgpO2Q9YS5wb3AoKTthLnB1c2godSxkKTticmVhaztjYXNlInBvcCI6aWYoYS5sZW5ndGg8MSlyZXR1cm4gbnVsbDthLnBvcCgpO2JyZWFrO2Nhc2UiaW5kZXgiOmlmKGEubGVuZ3RoPDEpcmV0dXJuIG51bGw7bD1hLnBvcCgpO2lmKCJsaXRlcmFsIiE9PWwudHlwZSlyZXR1cm4gbnVsbDtvPWwubnVtYmVyO2lmKG88MHx8IU51bWJlci5pc0ludGVnZXIobyl8fGEubGVuZ3RoPG8pcmV0dXJuIG51bGw7dT1hW2EubGVuZ3RoLW8tMV07aWYoImxpdGVyYWwiPT09dS50eXBlfHwidmFyIj09PXUudHlwZSl7YS5wdXNoKHUpO2JyZWFrfWY9bmV3IEFzdFZhcmlhYmxlKHArKyx1Lm1pbix1Lm1heCk7YVthLmxlbmd0aC1vLTFdPWY7YS5wdXNoKGYpO24ucHVzaChuZXcgQXN0VmFyaWFibGVEZWZpbml0aW9uKGYsdSkpO2JyZWFrO2Nhc2UiZHVwIjppZihhLmxlbmd0aDwxKXJldHVybiBudWxsO2lmKCJudW1iZXIiPT10eXBlb2YgZVt0KzFdJiYiZ3QiPT09ZVt0KzJdJiZlW3QrM109PT10KzcmJiJqeiI9PT1lW3QrNF0mJiJwb3AiPT09ZVt0KzVdJiZlW3QrNl09PT1lW3QrMV0pe2w9YS5wb3AoKTthLnB1c2goYnVpbGRNaW5PcGVyYXRpb24obCxlW3QrMV0pKTt0Kz02O2JyZWFrfXU9YS5hdCgtMSk7aWYoImxpdGVyYWwiPT09dS50eXBlfHwidmFyIj09PXUudHlwZSl7YS5wdXNoKHUpO2JyZWFrfWY9bmV3IEFzdFZhcmlhYmxlKHArKyx1Lm1pbix1Lm1heCk7YVthLmxlbmd0aC0xXT1mO2EucHVzaChmKTtuLnB1c2gobmV3IEFzdFZhcmlhYmxlRGVmaW5pdGlvbihmLHUpKTticmVhaztjYXNlInJvbGwiOmlmKGEubGVuZ3RoPDIpcmV0dXJuIG51bGw7aD1hLnBvcCgpO2w9YS5wb3AoKTtpZigibGl0ZXJhbCIhPT1oLnR5cGV8fCJsaXRlcmFsIiE9PWwudHlwZSlyZXR1cm4gbnVsbDtjPWgubnVtYmVyO289bC5udW1iZXI7aWYobzw9MHx8IU51bWJlci5pc0ludGVnZXIobyl8fCFOdW1iZXIuaXNJbnRlZ2VyKGMpfHxhLmxlbmd0aDxvKXJldHVybiBudWxsO2M9KGMlbytvKSVvO2lmKDA9PT1jKWJyZWFrO2EucHVzaCguLi5hLnNwbGljZShhLmxlbmd0aC1vLG8tYykpO2JyZWFrO2RlZmF1bHQ6cmV0dXJuIG51bGx9ZWxzZSBhLnB1c2gobmV3IEFzdExpdGVyYWwoZykpfWlmKGEubGVuZ3RoIT09cylyZXR1cm4gbnVsbDtjb25zdCBtPVtdO2Zvcihjb25zdCBlIG9mIG4pe2NvbnN0IHQ9bmV3IEV4cHJlc3Npb25CdWlsZGVyVmlzaXRvcjtlLnZpc2l0KHQpO20ucHVzaCh0LnRvU3RyaW5nKCkpfWZvcihsZXQgZT0wLHQ9YS5sZW5ndGg7ZTx0O2UrKyl7Y29uc3QgdD1hW2VdLG49bmV3IEV4cHJlc3Npb25CdWlsZGVyVmlzaXRvcjt0LnZpc2l0KG4pO2NvbnN0IGk9clsyKmVdLHM9clsyKmUrMV0sbz1bbi50b1N0cmluZygpXTtpZihpPnQubWluKXtvLnVuc2hpZnQoIk1hdGgubWF4KCIsaSwiLCAiKTtvLnB1c2goIikiKX1pZihzPHQubWF4KXtvLnVuc2hpZnQoIk1hdGgubWluKCIscywiLCAiKTtvLnB1c2goIikiKX1vLnVuc2hpZnQoImRlc3RbZGVzdE9mZnNldCArICIsZSwiXSA9ICIpO28ucHVzaCgiOyIpO20ucHVzaChvLmpvaW4oIiIpKX1yZXR1cm4gbS5qb2luKCJcbiIpfX1jb25zdCBuaT1bIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIlMiLCJCIiwiUyIsIldTIiwiQiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCIiwiQiIsIkIiLCJTIiwiV1MiLCJPTiIsIk9OIiwiRVQiLCJFVCIsIkVUIiwiT04iLCJPTiIsIk9OIiwiT04iLCJPTiIsIkVTIiwiQ1MiLCJFUyIsIkNTIiwiQ1MiLCJFTiIsIkVOIiwiRU4iLCJFTiIsIkVOIiwiRU4iLCJFTiIsIkVOIiwiRU4iLCJFTiIsIkNTIiwiT04iLCJPTiIsIk9OIiwiT04iLCJPTiIsIk9OIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJPTiIsIk9OIiwiT04iLCJPTiIsIk9OIiwiT04iLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIk9OIiwiT04iLCJPTiIsIk9OIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJCTiIsIkJOIiwiQk4iLCJDUyIsIk9OIiwiRVQiLCJFVCIsIkVUIiwiRVQiLCJPTiIsIk9OIiwiT04iLCJPTiIsIkwiLCJPTiIsIk9OIiwiQk4iLCJPTiIsIk9OIiwiRVQiLCJFVCIsIkVOIiwiRU4iLCJPTiIsIkwiLCJPTiIsIk9OIiwiT04iLCJFTiIsIkwiLCJPTiIsIk9OIiwiT04iLCJPTiIsIk9OIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJPTiIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJPTiIsIkwiLCJMIiwiTCIsIkwiLCJMIiwiTCIsIkwiLCJMIl0saWk9WyJBTiIsIkFOIiwiQU4iLCJBTiIsIkFOIiwiQU4iLCJPTiIsIk9OIiwiQUwiLCJFVCIsIkVUIiwiQUwiLCJDUyIsIkFMIiwiT04iLCJPTiIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIk5TTSIsIkFMIiwiQUwiLCIiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJBTiIsIkFOIiwiQU4iLCJBTiIsIkFOIiwiQU4iLCJBTiIsIkFOIiwiQU4iLCJBTiIsIkVUIiwiQU4iLCJBTiIsIkFMIiwiQUwiLCJBTCIsIk5TTSIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJOU00iLCJBTiIsIk9OIiwiTlNNIiwiTlNNIiwiTlNNIiwiTlNNIiwiTlNNIiwiTlNNIiwiQUwiLCJBTCIsIk5TTSIsIk5TTSIsIk9OIiwiTlNNIiwiTlNNIiwiTlNNIiwiTlNNIiwiQUwiLCJBTCIsIkVOIiwiRU4iLCJFTiIsIkVOIiwiRU4iLCJFTiIsIkVOIiwiRU4iLCJFTiIsIkVOIiwiQUwiLCJBTCIsIkFMIiwiQUwiLCJBTCIsIkFMIl07ZnVuY3Rpb24gaXNPZGQoZSl7cmV0dXJuISEoMSZlKX1mdW5jdGlvbiBpc0V2ZW4oZSl7cmV0dXJuISgxJmUpfWZ1bmN0aW9uIGZpbmRVbmVxdWFsKGUsdCxyKXtsZXQgYSxuO2ZvcihhPXQsbj1lLmxlbmd0aDthPG47KythKWlmKGVbYV0hPT1yKXJldHVybiBhO3JldHVybiBhfWZ1bmN0aW9uIHJldmVyc2VWYWx1ZXMoZSx0LHIpe2ZvcihsZXQgYT10LG49ci0xO2E8bjsrK2EsLS1uKXtjb25zdCB0PWVbYV07ZVthXT1lW25dO2Vbbl09dH19ZnVuY3Rpb24gY3JlYXRlQmlkaVRleHQoZSx0LHI9ITEpe2xldCBhPSJsdHIiO3I/YT0idHRiIjp0fHwoYT0icnRsIik7cmV0dXJue3N0cjplLGRpcjphfX1jb25zdCBzaT1bXSxvaT1bXTtmdW5jdGlvbiBiaWRpKGUsdD0tMSxyPSExKXtsZXQgYT0hMDtjb25zdCBuPWUubGVuZ3RoO2lmKDA9PT1ufHxyKXJldHVybiBjcmVhdGVCaWRpVGV4dChlLGEscik7c2kubGVuZ3RoPW47b2kubGVuZ3RoPW47bGV0IGkscyxvPTA7Zm9yKGk9MDtpPG47KytpKXtzaVtpXT1lLmNoYXJBdChpKTtjb25zdCB0PWUuY2hhckNvZGVBdChpKTtsZXQgcj0iTCI7aWYodDw9MjU1KXI9bmlbdF07ZWxzZSBpZigxNDI0PD10JiZ0PD0xNTI0KXI9IlIiO2Vsc2UgaWYoMTUzNjw9dCYmdDw9MTc5MSl7cj1paVsyNTUmdF07cnx8d2FybigiQmlkaTogaW52YWxpZCBVbmljb2RlIGNoYXJhY3RlciAiK3QudG9TdHJpbmcoMTYpKX1lbHNlKDE3OTI8PXQmJnQ8PTIyMjB8fDY0MzM2PD10JiZ0PD02NTAyM3x8NjUxMzY8PXQmJnQ8PTY1Mjc5KSYmKHI9IkFMIik7IlIiIT09ciYmIkFMIiE9PXImJiJBTiIhPT1yfHxvKys7b2lbaV09cn1pZigwPT09byl7YT0hMDtyZXR1cm4gY3JlYXRlQmlkaVRleHQoZSxhKX1pZigtMT09PXQpaWYoby9uPC4zJiZuPjQpe2E9ITA7dD0wfWVsc2V7YT0hMTt0PTF9Y29uc3QgYz1bXTtmb3IoaT0wO2k8bjsrK2kpY1tpXT10O2NvbnN0IGw9aXNPZGQodCk/IlIiOiJMIixoPWwsdT1oO2xldCBkLGY9aDtmb3IoaT0wO2k8bjsrK2kpIk5TTSI9PT1vaVtpXT9vaVtpXT1mOmY9b2lbaV07Zj1oO2ZvcihpPTA7aTxuOysraSl7ZD1vaVtpXTsiRU4iPT09ZD9vaVtpXT0iQUwiPT09Zj8iQU4iOiJFTiI6IlIiIT09ZCYmIkwiIT09ZCYmIkFMIiE9PWR8fChmPWQpfWZvcihpPTA7aTxuOysraSl7ZD1vaVtpXTsiQUwiPT09ZCYmKG9pW2ldPSJSIil9Zm9yKGk9MTtpPG4tMTsrK2kpeyJFUyI9PT1vaVtpXSYmIkVOIj09PW9pW2ktMV0mJiJFTiI9PT1vaVtpKzFdJiYob2lbaV09IkVOIik7IkNTIiE9PW9pW2ldfHwiRU4iIT09b2lbaS0xXSYmIkFOIiE9PW9pW2ktMV18fG9pW2krMV0hPT1vaVtpLTFdfHwob2lbaV09b2lbaS0xXSl9Zm9yKGk9MDtpPG47KytpKWlmKCJFTiI9PT1vaVtpXSl7Zm9yKGxldCBlPWktMTtlPj0wJiYiRVQiPT09b2lbZV07LS1lKW9pW2VdPSJFTiI7Zm9yKGxldCBlPWkrMTtlPG4mJiJFVCI9PT1vaVtlXTsrK2Upb2lbZV09IkVOIn1mb3IoaT0wO2k8bjsrK2kpe2Q9b2lbaV07IldTIiE9PWQmJiJFUyIhPT1kJiYiRVQiIT09ZCYmIkNTIiE9PWR8fChvaVtpXT0iT04iKX1mPWg7Zm9yKGk9MDtpPG47KytpKXtkPW9pW2ldOyJFTiI9PT1kP29pW2ldPSJMIj09PWY/IkwiOiJFTiI6IlIiIT09ZCYmIkwiIT09ZHx8KGY9ZCl9Zm9yKGk9MDtpPG47KytpKWlmKCJPTiI9PT1vaVtpXSl7Y29uc3QgZT1maW5kVW5lcXVhbChvaSxpKzEsIk9OIik7bGV0IHQ9aDtpPjAmJih0PW9pW2ktMV0pO2xldCByPXU7ZSsxPG4mJihyPW9pW2UrMV0pOyJMIiE9PXQmJih0PSJSIik7IkwiIT09ciYmKHI9IlIiKTt0PT09ciYmb2kuZmlsbCh0LGksZSk7aT1lLTF9Zm9yKGk9MDtpPG47KytpKSJPTiI9PT1vaVtpXSYmKG9pW2ldPWwpO2ZvcihpPTA7aTxuOysraSl7ZD1vaVtpXTtpc0V2ZW4oY1tpXSk/IlIiPT09ZD9jW2ldKz0xOiJBTiIhPT1kJiYiRU4iIT09ZHx8KGNbaV0rPTIpOiJMIiE9PWQmJiJBTiIhPT1kJiYiRU4iIT09ZHx8KGNbaV0rPTEpfWxldCBnLHA9LTEsbT05OTtmb3IoaT0wLHM9Yy5sZW5ndGg7aTxzOysraSl7Zz1jW2ldO3A8ZyYmKHA9Zyk7bT5nJiZpc09kZChnKSYmKG09Zyl9Zm9yKGc9cDtnPj1tOy0tZyl7bGV0IGU9LTE7Zm9yKGk9MCxzPWMubGVuZ3RoO2k8czsrK2kpaWYoY1tpXTxnKXtpZihlPj0wKXtyZXZlcnNlVmFsdWVzKHNpLGUsaSk7ZT0tMX19ZWxzZSBlPDAmJihlPWkpO2U+PTAmJnJldmVyc2VWYWx1ZXMoc2ksZSxjLmxlbmd0aCl9Zm9yKGk9MCxzPXNpLmxlbmd0aDtpPHM7KytpKXtjb25zdCBlPXNpW2ldOyI8IiE9PWUmJiI+IiE9PWV8fChzaVtpXT0iIil9cmV0dXJuIGNyZWF0ZUJpZGlUZXh0KHNpLmpvaW4oIiIpLGEpfWNsYXNzIENzc0ZvbnRJbmZveyNOOyNHOyMkO3N0YXRpYyBzdHJpbmdzPVsiZm9udEZhbWlseSIsImZvbnRXZWlnaHQiLCJpdGFsaWNBbmdsZSJdO3N0YXRpYyB3cml0ZShlKXtjb25zdCB0PW5ldyBUZXh0RW5jb2RlcixyPXt9O2xldCBhPTA7Zm9yKGNvbnN0IG4gb2YgQ3NzRm9udEluZm8uc3RyaW5ncyl7Y29uc3QgaT10LmVuY29kZShlW25dKTtyW25dPWk7YSs9NCtpLmxlbmd0aH1jb25zdCBuPW5ldyBBcnJheUJ1ZmZlcihhKSxpPW5ldyBVaW50OEFycmF5KG4pLHM9bmV3IERhdGFWaWV3KG4pO2xldCBvPTA7Zm9yKGNvbnN0IGUgb2YgQ3NzRm9udEluZm8uc3RyaW5ncyl7Y29uc3QgdD1yW2VdLGE9dC5sZW5ndGg7cy5zZXRVaW50MzIobyxhKTtpLnNldCh0LG8rNCk7bys9NCthfWFzc2VydChvPT09bi5ieXRlTGVuZ3RoLCJDc3NGb250SW5mby53cml0ZTogQnVmZmVyIG92ZXJmbG93Iik7cmV0dXJuIG59Y29uc3RydWN0b3IoZSl7dGhpcy4jTj1lO3RoaXMuI0c9bmV3IERhdGFWaWV3KHRoaXMuI04pO3RoaXMuIyQ9bmV3IFRleHREZWNvZGVyfSNWKGUpe2Fzc2VydChlPENzc0ZvbnRJbmZvLnN0cmluZ3MubGVuZ3RoLCJJbnZhbGlkIHN0cmluZyBpbmRleCIpO2xldCB0PTA7Zm9yKGxldCByPTA7cjxlO3IrKyl0Kz10aGlzLiNHLmdldFVpbnQzMih0KSs0O2NvbnN0IHI9dGhpcy4jRy5nZXRVaW50MzIodCk7cmV0dXJuIHRoaXMuIyQuZGVjb2RlKG5ldyBVaW50OEFycmF5KHRoaXMuI04sdCs0LHIpKX1nZXQgZm9udEZhbWlseSgpe3JldHVybiB0aGlzLiNWKDApfWdldCBmb250V2VpZ2h0KCl7cmV0dXJuIHRoaXMuI1YoMSl9Z2V0IGl0YWxpY0FuZ2xlKCl7cmV0dXJuIHRoaXMuI1YoMil9fWNsYXNzIFN5c3RlbUZvbnRJbmZveyNOOyNHOyMkO3N0YXRpYyBzdHJpbmdzPVsiY3NzIiwibG9hZGVkTmFtZSIsImJhc2VGb250TmFtZSIsInNyYyJdO3N0YXRpYyB3cml0ZShlKXtjb25zdCB0PW5ldyBUZXh0RW5jb2RlcixyPXt9O2xldCBhPTA7Zm9yKGNvbnN0IG4gb2YgU3lzdGVtRm9udEluZm8uc3RyaW5ncyl7Y29uc3QgaT10LmVuY29kZShlW25dKTtyW25dPWk7YSs9NCtpLmxlbmd0aH1hKz00O2xldCBuLGkscz0xK2E7aWYoZS5zdHlsZSl7bj10LmVuY29kZShlLnN0eWxlLnN0eWxlKTtpPXQuZW5jb2RlKGUuc3R5bGUud2VpZ2h0KTtzKz00K24ubGVuZ3RoKzQraS5sZW5ndGh9Y29uc3Qgbz1uZXcgQXJyYXlCdWZmZXIocyksYz1uZXcgVWludDhBcnJheShvKSxsPW5ldyBEYXRhVmlldyhvKTtsZXQgaD0wO2wuc2V0VWludDgoaCsrLGUuZ3Vlc3NGYWxsYmFjaz8xOjApO2wuc2V0VWludDMyKGgsMCk7aCs9NDthPTA7Zm9yKGNvbnN0IGUgb2YgU3lzdGVtRm9udEluZm8uc3RyaW5ncyl7Y29uc3QgdD1yW2VdLG49dC5sZW5ndGg7YSs9NCtuO2wuc2V0VWludDMyKGgsbik7Yy5zZXQodCxoKzQpO2grPTQrbn1sLnNldFVpbnQzMihoLWEtNCxhKTtpZihlLnN0eWxlKXtsLnNldFVpbnQzMihoLG4ubGVuZ3RoKTtjLnNldChuLGgrNCk7aCs9NCtuLmxlbmd0aDtsLnNldFVpbnQzMihoLGkubGVuZ3RoKTtjLnNldChpLGgrNCk7aCs9NCtpLmxlbmd0aH1hc3NlcnQoaDw9by5ieXRlTGVuZ3RoLCJTdWJzdGl0aW9uSW5mby53cml0ZTogQnVmZmVyIG92ZXJmbG93Iik7cmV0dXJuIG8udHJhbnNmZXJUb0ZpeGVkTGVuZ3RoKGgpfWNvbnN0cnVjdG9yKGUpe3RoaXMuI049ZTt0aGlzLiNHPW5ldyBEYXRhVmlldyh0aGlzLiNOKTt0aGlzLiMkPW5ldyBUZXh0RGVjb2Rlcn1nZXQgZ3Vlc3NGYWxsYmFjaygpe3JldHVybiAwIT09dGhpcy4jRy5nZXRVaW50OCgwKX0jVihlKXthc3NlcnQoZTxTeXN0ZW1Gb250SW5mby5zdHJpbmdzLmxlbmd0aCwiSW52YWxpZCBzdHJpbmcgaW5kZXgiKTtsZXQgdD01O2ZvcihsZXQgcj0wO3I8ZTtyKyspdCs9dGhpcy4jRy5nZXRVaW50MzIodCkrNDtjb25zdCByPXRoaXMuI0cuZ2V0VWludDMyKHQpO3JldHVybiB0aGlzLiMkLmRlY29kZShuZXcgVWludDhBcnJheSh0aGlzLiNOLHQrNCxyKSl9Z2V0IGNzcygpe3JldHVybiB0aGlzLiNWKDApfWdldCBsb2FkZWROYW1lKCl7cmV0dXJuIHRoaXMuI1YoMSl9Z2V0IGJhc2VGb250TmFtZSgpe3JldHVybiB0aGlzLiNWKDIpfWdldCBzcmMoKXtyZXR1cm4gdGhpcy4jVigzKX1nZXQgc3R5bGUoKXtsZXQgZT0xO2UrPTQrdGhpcy4jRy5nZXRVaW50MzIoZSk7Y29uc3QgdD10aGlzLiNHLmdldFVpbnQzMihlKSxyPXRoaXMuIyQuZGVjb2RlKG5ldyBVaW50OEFycmF5KHRoaXMuI04sZSs0LHQpKTtlKz00K3Q7Y29uc3QgYT10aGlzLiNHLmdldFVpbnQzMihlKTtyZXR1cm57c3R5bGU6cix3ZWlnaHQ6dGhpcy4jJC5kZWNvZGUobmV3IFVpbnQ4QXJyYXkodGhpcy4jTixlKzQsYSkpfX19Y2xhc3MgRm9udEluZm97c3RhdGljIGJvb2xzPVsiYmxhY2siLCJib2xkIiwiZGlzYWJsZUZvbnRGYWNlIiwiZm9udEV4dHJhUHJvcGVydGllcyIsImlzSW52YWxpZFBERmpzRm9udCIsImlzVHlwZTNGb250IiwiaXRhbGljIiwibWlzc2luZ0ZpbGUiLCJyZW1lYXN1cmUiLCJ2ZXJ0aWNhbCJdO3N0YXRpYyBudW1iZXJzPVsiYXNjZW50IiwiZGVmYXVsdFdpZHRoIiwiZGVzY2VudCJdO3N0YXRpYyBzdHJpbmdzPVsiZmFsbGJhY2tOYW1lIiwibG9hZGVkTmFtZSIsIm1pbWV0eXBlIiwibmFtZSJdO3N0YXRpYyNLPU1hdGguY2VpbCgyKnRoaXMuYm9vbHMubGVuZ3RoLzgpO3N0YXRpYyNKPXRoaXMuI0srOCp0aGlzLm51bWJlcnMubGVuZ3RoO3N0YXRpYyNZPXRoaXMuI0orMSs4O3N0YXRpYyNaPXRoaXMuI1krMSs0ODtzdGF0aWMjUT10aGlzLiNaKzErNjsjTjsjJDsjRztjb25zdHJ1Y3Rvcih7ZGF0YTplLGV4dHJhOnR9KXt0aGlzLiNOPWU7dGhpcy4jJD1uZXcgVGV4dERlY29kZXI7dGhpcy4jRz1uZXcgRGF0YVZpZXcodGhpcy4jTik7dCYmT2JqZWN0LmFzc2lnbih0aGlzLHQpfSNlZShlKXthc3NlcnQoZTxGb250SW5mby5ib29scy5sZW5ndGgsIkludmFsaWQgYm9vbGVhbiBpbmRleCIpO2NvbnN0IHQ9TWF0aC5mbG9vcihlLzQpLHI9MiplJTgsYT10aGlzLiNHLmdldFVpbnQ4KHQpPj5yJjM7cmV0dXJuIDA9PT1hP3ZvaWQgMDoyPT09YX1nZXQgYmxhY2soKXtyZXR1cm4gdGhpcy4jZWUoMCl9Z2V0IGJvbGQoKXtyZXR1cm4gdGhpcy4jZWUoMSl9Z2V0IGRpc2FibGVGb250RmFjZSgpe3JldHVybiB0aGlzLiNlZSgyKX1nZXQgZm9udEV4dHJhUHJvcGVydGllcygpe3JldHVybiB0aGlzLiNlZSgzKX1nZXQgaXNJbnZhbGlkUERGanNGb250KCl7cmV0dXJuIHRoaXMuI2VlKDQpfWdldCBpc1R5cGUzRm9udCgpe3JldHVybiB0aGlzLiNlZSg1KX1nZXQgaXRhbGljKCl7cmV0dXJuIHRoaXMuI2VlKDYpfWdldCBtaXNzaW5nRmlsZSgpe3JldHVybiB0aGlzLiNlZSg3KX1nZXQgcmVtZWFzdXJlKCl7cmV0dXJuIHRoaXMuI2VlKDgpfWdldCB2ZXJ0aWNhbCgpe3JldHVybiB0aGlzLiNlZSg5KX0jdGUoZSl7YXNzZXJ0KGU8Rm9udEluZm8ubnVtYmVycy5sZW5ndGgsIkludmFsaWQgbnVtYmVyIGluZGV4Iik7cmV0dXJuIHRoaXMuI0cuZ2V0RmxvYXQ2NChGb250SW5mby4jSys4KmUpfWdldCBhc2NlbnQoKXtyZXR1cm4gdGhpcy4jdGUoMCl9Z2V0IGRlZmF1bHRXaWR0aCgpe3JldHVybiB0aGlzLiN0ZSgxKX1nZXQgZGVzY2VudCgpe3JldHVybiB0aGlzLiN0ZSgyKX1nZXQgYmJveCgpe2xldCBlPUZvbnRJbmZvLiNKO2lmKDA9PT10aGlzLiNHLmdldFVpbnQ4KGUpKXJldHVybjtlKz0xO2NvbnN0IHQ9W107Zm9yKGxldCByPTA7cjw0O3IrKyl7dC5wdXNoKHRoaXMuI0cuZ2V0SW50MTYoZSwhMCkpO2UrPTJ9cmV0dXJuIHR9Z2V0IGZvbnRNYXRyaXgoKXtsZXQgZT1Gb250SW5mby4jWTtpZigwPT09dGhpcy4jRy5nZXRVaW50OChlKSlyZXR1cm47ZSs9MTtjb25zdCB0PVtdO2ZvcihsZXQgcj0wO3I8NjtyKyspe3QucHVzaCh0aGlzLiNHLmdldEZsb2F0NjQoZSwhMCkpO2UrPTh9cmV0dXJuIHR9Z2V0IGRlZmF1bHRWTWV0cmljcygpe2xldCBlPUZvbnRJbmZvLiNaO2lmKDA9PT10aGlzLiNHLmdldFVpbnQ4KGUpKXJldHVybjtlKz0xO2NvbnN0IHQ9W107Zm9yKGxldCByPTA7cjwzO3IrKyl7dC5wdXNoKHRoaXMuI0cuZ2V0SW50MTYoZSwhMCkpO2UrPTJ9cmV0dXJuIHR9I1YoZSl7YXNzZXJ0KGU8Rm9udEluZm8uc3RyaW5ncy5sZW5ndGgsIkludmFsaWQgc3RyaW5nIGluZGV4Iik7bGV0IHQ9Rm9udEluZm8uI1ErNDtmb3IobGV0IHI9MDtyPGU7cisrKXQrPXRoaXMuI0cuZ2V0VWludDMyKHQpKzQ7Y29uc3Qgcj10aGlzLiNHLmdldFVpbnQzMih0KSxhPW5ldyBVaW50OEFycmF5KHIpO2Euc2V0KG5ldyBVaW50OEFycmF5KHRoaXMuI04sdCs0LHIpKTtyZXR1cm4gdGhpcy4jJC5kZWNvZGUoYSl9Z2V0IGZhbGxiYWNrTmFtZSgpe3JldHVybiB0aGlzLiNWKDApfWdldCBsb2FkZWROYW1lKCl7cmV0dXJuIHRoaXMuI1YoMSl9Z2V0IG1pbWV0eXBlKCl7cmV0dXJuIHRoaXMuI1YoMil9Z2V0IG5hbWUoKXtyZXR1cm4gdGhpcy4jVigzKX1nZXQgZGF0YSgpe2xldCBlPUZvbnRJbmZvLiNRO2UrPTQrdGhpcy4jRy5nZXRVaW50MzIoZSk7ZSs9NCt0aGlzLiNHLmdldFVpbnQzMihlKTtlKz00K3RoaXMuI0cuZ2V0VWludDMyKGUpO2NvbnN0IHQ9dGhpcy4jRy5nZXRVaW50MzIoZSk7aWYoMCE9PXQpcmV0dXJuIG5ldyBVaW50OEFycmF5KHRoaXMuI04sZSs0LHQpfWNsZWFyRGF0YSgpe2xldCBlPUZvbnRJbmZvLiNRO2UrPTQrdGhpcy4jRy5nZXRVaW50MzIoZSk7ZSs9NCt0aGlzLiNHLmdldFVpbnQzMihlKTtlKz00K3RoaXMuI0cuZ2V0VWludDMyKGUpO2NvbnN0IHQ9dGhpcy4jRy5nZXRVaW50MzIoZSk7bmV3IFVpbnQ4QXJyYXkodGhpcy4jTixlKzQsdCkuZmlsbCgwKTt0aGlzLiNHLnNldFVpbnQzMihlLDApfWdldCBjc3NGb250SW5mbygpe2xldCBlPUZvbnRJbmZvLiNRO2UrPTQrdGhpcy4jRy5nZXRVaW50MzIoZSk7ZSs9NCt0aGlzLiNHLmdldFVpbnQzMihlKTtjb25zdCB0PXRoaXMuI0cuZ2V0VWludDMyKGUpO2lmKDA9PT10KXJldHVybiBudWxsO2NvbnN0IHI9bmV3IFVpbnQ4QXJyYXkodCk7ci5zZXQobmV3IFVpbnQ4QXJyYXkodGhpcy4jTixlKzQsdCkpO3JldHVybiBuZXcgQ3NzRm9udEluZm8oci5idWZmZXIpfWdldCBzeXN0ZW1Gb250SW5mbygpe2xldCBlPUZvbnRJbmZvLiNRO2UrPTQrdGhpcy4jRy5nZXRVaW50MzIoZSk7Y29uc3QgdD10aGlzLiNHLmdldFVpbnQzMihlKTtpZigwPT09dClyZXR1cm4gbnVsbDtjb25zdCByPW5ldyBVaW50OEFycmF5KHQpO3Iuc2V0KG5ldyBVaW50OEFycmF5KHRoaXMuI04sZSs0LHQpKTtyZXR1cm4gbmV3IFN5c3RlbUZvbnRJbmZvKHIuYnVmZmVyKX1zdGF0aWMgd3JpdGUoZSl7Y29uc3QgdD1lLnN5c3RlbUZvbnRJbmZvP1N5c3RlbUZvbnRJbmZvLndyaXRlKGUuc3lzdGVtRm9udEluZm8pOm51bGwscj1lLmNzc0ZvbnRJbmZvP0Nzc0ZvbnRJbmZvLndyaXRlKGUuY3NzRm9udEluZm8pOm51bGwsYT1uZXcgVGV4dEVuY29kZXIsbj17fTtsZXQgaT0wO2Zvcihjb25zdCB0IG9mIEZvbnRJbmZvLnN0cmluZ3Mpe25bdF09YS5lbmNvZGUoZVt0XSk7aSs9NCtuW3RdLmxlbmd0aH1jb25zdCBzPUZvbnRJbmZvLiNRKzQraSs0Kyh0P3QuYnl0ZUxlbmd0aDowKSs0KyhyP3IuYnl0ZUxlbmd0aDowKSs0KyhlLmRhdGE/ZS5kYXRhLmxlbmd0aDowKSxvPW5ldyBBcnJheUJ1ZmZlcihzKSxjPW5ldyBVaW50OEFycmF5KG8pLGw9bmV3IERhdGFWaWV3KG8pO2xldCBoPTA7Y29uc3QgdT1Gb250SW5mby5ib29scy5sZW5ndGg7bGV0IGQ9MCxmPTA7Zm9yKGxldCB0PTA7dDx1O3QrKyl7Y29uc3Qgcj1lW0ZvbnRJbmZvLmJvb2xzW3RdXTtkfD0odm9pZCAwPT09cj8wOnI/MjoxKTw8ZjtmKz0yO2lmKDg9PT1mfHx0PT09dS0xKXtsLnNldFVpbnQ4KGgrKyxkKTtkPTA7Zj0wfX1hc3NlcnQoaD09PUZvbnRJbmZvLiNLLCJGb250SW5mby53cml0ZTogQm9vbGVhbiBwcm9wZXJ0aWVzIG9mZnNldCBtaXNtYXRjaCIpO2Zvcihjb25zdCB0IG9mIEZvbnRJbmZvLm51bWJlcnMpe2wuc2V0RmxvYXQ2NChoLGVbdF0pO2grPTh9YXNzZXJ0KGg9PT1Gb250SW5mby4jSiwiRm9udEluZm8ud3JpdGU6IE51bWJlciBwcm9wZXJ0aWVzIG9mZnNldCBtaXNtYXRjaCIpO2lmKGUuYmJveCl7bC5zZXRVaW50OChoKyssNCk7Zm9yKGNvbnN0IHQgb2YgZS5iYm94KXtsLnNldEludDE2KGgsdCwhMCk7aCs9Mn19ZWxzZXtsLnNldFVpbnQ4KGgrKywwKTtoKz04fWFzc2VydChoPT09Rm9udEluZm8uI1ksIkZvbnRJbmZvLndyaXRlOiBCQm94IHByb3BlcnRpZXMgb2Zmc2V0IG1pc21hdGNoIik7aWYoZS5mb250TWF0cml4KXtsLnNldFVpbnQ4KGgrKyw2KTtmb3IoY29uc3QgdCBvZiBlLmZvbnRNYXRyaXgpe2wuc2V0RmxvYXQ2NChoLHQsITApO2grPTh9fWVsc2V7bC5zZXRVaW50OChoKyssMCk7aCs9NDh9YXNzZXJ0KGg9PT1Gb250SW5mby4jWiwiRm9udEluZm8ud3JpdGU6IEZvbnRNYXRyaXggcHJvcGVydGllcyBvZmZzZXQgbWlzbWF0Y2giKTtpZihlLmRlZmF1bHRWTWV0cmljcyl7bC5zZXRVaW50OChoKyssMSk7Zm9yKGNvbnN0IHQgb2YgZS5kZWZhdWx0Vk1ldHJpY3Mpe2wuc2V0SW50MTYoaCx0LCEwKTtoKz0yfX1lbHNle2wuc2V0VWludDgoaCsrLDApO2grPTZ9YXNzZXJ0KGg9PT1Gb250SW5mby4jUSwiRm9udEluZm8ud3JpdGU6IERlZmF1bHRWTWV0cmljcyBwcm9wZXJ0aWVzIG9mZnNldCBtaXNtYXRjaCIpO2wuc2V0VWludDMyKEZvbnRJbmZvLiNRLDApO2grPTQ7Zm9yKGNvbnN0IGUgb2YgRm9udEluZm8uc3RyaW5ncyl7Y29uc3QgdD1uW2VdLHI9dC5sZW5ndGg7bC5zZXRVaW50MzIoaCxyKTtjLnNldCh0LGgrNCk7aCs9NCtyfWwuc2V0VWludDMyKEZvbnRJbmZvLiNRLGgtRm9udEluZm8uI1EtNCk7aWYodCl7Y29uc3QgZT10LmJ5dGVMZW5ndGg7bC5zZXRVaW50MzIoaCxlKTthc3NlcnQoaCs0K2U8PW8uYnl0ZUxlbmd0aCwiRm9udEluZm8ud3JpdGU6IEJ1ZmZlciBvdmVyZmxvdyBhdCBzeXN0ZW1Gb250SW5mbyIpO2Muc2V0KG5ldyBVaW50OEFycmF5KHQpLGgrNCk7aCs9NCtlfWVsc2V7bC5zZXRVaW50MzIoaCwwKTtoKz00fWlmKHIpe2NvbnN0IGU9ci5ieXRlTGVuZ3RoO2wuc2V0VWludDMyKGgsZSk7YXNzZXJ0KGgrNCtlPD1vLmJ5dGVMZW5ndGgsIkZvbnRJbmZvLndyaXRlOiBCdWZmZXIgb3ZlcmZsb3cgYXQgY3NzRm9udEluZm8iKTtjLnNldChuZXcgVWludDhBcnJheShyKSxoKzQpO2grPTQrZX1lbHNle2wuc2V0VWludDMyKGgsMCk7aCs9NH1pZih2b2lkIDA9PT1lLmRhdGEpe2wuc2V0VWludDMyKGgsMCk7aCs9NH1lbHNle2wuc2V0VWludDMyKGgsZS5kYXRhLmxlbmd0aCk7Yy5zZXQoZS5kYXRhLGgrNCk7aCs9NCtlLmRhdGEubGVuZ3RofWFzc2VydChoPD1vLmJ5dGVMZW5ndGgsIkZvbnRJbmZvLndyaXRlOiBCdWZmZXIgb3ZlcmZsb3ciKTtyZXR1cm4gby50cmFuc2ZlclRvRml4ZWRMZW5ndGgoaCl9fWNvbnN0IGNpPXtzdHlsZToibm9ybWFsIix3ZWlnaHQ6Im5vcm1hbCJ9LGxpPXtzdHlsZToibm9ybWFsIix3ZWlnaHQ6ImJvbGQifSxoaT17c3R5bGU6Iml0YWxpYyIsd2VpZ2h0OiJub3JtYWwifSx1aT17c3R5bGU6Iml0YWxpYyIsd2VpZ2h0OiJib2xkIn0sZGk9bmV3IE1hcChbWyJUaW1lcy1Sb21hbiIse2xvY2FsOlsiVGltZXMgTmV3IFJvbWFuIiwiVGltZXMtUm9tYW4iLCJUaW1lcyIsIkxpYmVyYXRpb24gU2VyaWYiLCJOaW1idXMgUm9tYW4iLCJOaW1idXMgUm9tYW4gTCIsIlRpbm9zIiwiVGhvcm5kYWxlIiwiVGVYIEd5cmUgVGVybWVzIiwiRnJlZVNlcmlmIiwiTGludXggTGliZXJ0aW5lIE8iLCJMaWJlcnRpbnVzIFNlcmlmIiwiRGVqYVZ1IFNlcmlmIiwiQml0c3RyZWFtIFZlcmEgU2VyaWYiLCJVYnVudHUiXSxzdHlsZTpjaSx1bHRpbWF0ZToic2VyaWYifV0sWyJUaW1lcy1Cb2xkIix7YWxpYXM6IlRpbWVzLVJvbWFuIixzdHlsZTpsaSx1bHRpbWF0ZToic2VyaWYifV0sWyJUaW1lcy1JdGFsaWMiLHthbGlhczoiVGltZXMtUm9tYW4iLHN0eWxlOmhpLHVsdGltYXRlOiJzZXJpZiJ9XSxbIlRpbWVzLUJvbGRJdGFsaWMiLHthbGlhczoiVGltZXMtUm9tYW4iLHN0eWxlOnVpLHVsdGltYXRlOiJzZXJpZiJ9XSxbIkhlbHZldGljYSIse2xvY2FsOlsiSGVsdmV0aWNhIiwiSGVsdmV0aWNhIE5ldWUiLCJBcmlhbCIsIkFyaWFsIE5vdmEiLCJMaWJlcmF0aW9uIFNhbnMiLCJBcmltbyIsIk5pbWJ1cyBTYW5zIiwiTmltYnVzIFNhbnMgTCIsIkEwMzAiLCJUZVggR3lyZSBIZXJvcyIsIkZyZWVTYW5zIiwiRGVqYVZ1IFNhbnMiLCJBbGJhbnkiLCJCaXRzdHJlYW0gVmVyYSBTYW5zIiwiQXJpYWwgVW5pY29kZSBNUyIsIk1pY3Jvc29mdCBTYW5zIFNlcmlmIiwiQXBwbGUgU3ltYm9scyIsIkNhbnRhcmVsbCJdLHBhdGg6IkxpYmVyYXRpb25TYW5zLVJlZ3VsYXIudHRmIixzdHlsZTpjaSx1bHRpbWF0ZToic2Fucy1zZXJpZiJ9XSxbIkhlbHZldGljYS1Cb2xkIix7YWxpYXM6IkhlbHZldGljYSIscGF0aDoiTGliZXJhdGlvblNhbnMtQm9sZC50dGYiLHN0eWxlOmxpLHVsdGltYXRlOiJzYW5zLXNlcmlmIn1dLFsiSGVsdmV0aWNhLU9ibGlxdWUiLHthbGlhczoiSGVsdmV0aWNhIixwYXRoOiJMaWJlcmF0aW9uU2Fucy1JdGFsaWMudHRmIixzdHlsZTpoaSx1bHRpbWF0ZToic2Fucy1zZXJpZiJ9XSxbIkhlbHZldGljYS1Cb2xkT2JsaXF1ZSIse2FsaWFzOiJIZWx2ZXRpY2EiLHBhdGg6IkxpYmVyYXRpb25TYW5zLUJvbGRJdGFsaWMudHRmIixzdHlsZTp1aSx1bHRpbWF0ZToic2Fucy1zZXJpZiJ9XSxbIkNvdXJpZXIiLHtsb2NhbDpbIkNvdXJpZXIiLCJDb3VyaWVyIE5ldyIsIkxpYmVyYXRpb24gTW9ubyIsIk5pbWJ1cyBNb25vIiwiTmltYnVzIE1vbm8gTCIsIkNvdXNpbmUiLCJDdW1iZXJsYW5kIiwiVGVYIEd5cmUgQ3Vyc29yIiwiRnJlZU1vbm8iLCJMaW51eCBMaWJlcnRpbmUgTW9ubyBPIiwiTGliZXJ0aW51cyBNb25vIl0sc3R5bGU6Y2ksdWx0aW1hdGU6Im1vbm9zcGFjZSJ9XSxbIkNvdXJpZXItQm9sZCIse2FsaWFzOiJDb3VyaWVyIixzdHlsZTpsaSx1bHRpbWF0ZToibW9ub3NwYWNlIn1dLFsiQ291cmllci1PYmxpcXVlIix7YWxpYXM6IkNvdXJpZXIiLHN0eWxlOmhpLHVsdGltYXRlOiJtb25vc3BhY2UifV0sWyJDb3VyaWVyLUJvbGRPYmxpcXVlIix7YWxpYXM6IkNvdXJpZXIiLHN0eWxlOnVpLHVsdGltYXRlOiJtb25vc3BhY2UifV0sWyJBcmlhbEJsYWNrIix7bG9jYWw6WyJBcmlhbCBCbGFjayJdLHN0eWxlOntzdHlsZToibm9ybWFsIix3ZWlnaHQ6IjkwMCJ9LGZhbGxiYWNrOiJIZWx2ZXRpY2EtQm9sZCJ9XSxbIkFyaWFsQmxhY2stQm9sZCIse2FsaWFzOiJBcmlhbEJsYWNrIn1dLFsiQXJpYWxCbGFjay1JdGFsaWMiLHthbGlhczoiQXJpYWxCbGFjayIsc3R5bGU6e3N0eWxlOiJpdGFsaWMiLHdlaWdodDoiOTAwIn0sZmFsbGJhY2s6IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSJ9XSxbIkFyaWFsQmxhY2stQm9sZEl0YWxpYyIse2FsaWFzOiJBcmlhbEJsYWNrLUl0YWxpYyJ9XSxbIkFyaWFsTmFycm93Iix7bG9jYWw6WyJBcmlhbCBOYXJyb3ciLCJMaWJlcmF0aW9uIFNhbnMgTmFycm93IiwiSGVsdmV0aWNhIENvbmRlbnNlZCIsIk5pbWJ1cyBTYW5zIE5hcnJvdyIsIlRlWCBHeXJlIEhlcm9zIENuIl0sc3R5bGU6Y2ksZmFsbGJhY2s6IkhlbHZldGljYSJ9XSxbIkFyaWFsTmFycm93LUJvbGQiLHthbGlhczoiQXJpYWxOYXJyb3ciLHN0eWxlOmxpLGZhbGxiYWNrOiJIZWx2ZXRpY2EtQm9sZCJ9XSxbIkFyaWFsTmFycm93LUl0YWxpYyIse2FsaWFzOiJBcmlhbE5hcnJvdyIsc3R5bGU6aGksZmFsbGJhY2s6IkhlbHZldGljYS1PYmxpcXVlIn1dLFsiQXJpYWxOYXJyb3ctQm9sZEl0YWxpYyIse2FsaWFzOiJBcmlhbE5hcnJvdyIsc3R5bGU6dWksZmFsbGJhY2s6IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSJ9XSxbIkNhbGlicmkiLHtsb2NhbDpbIkNhbGlicmkiLCJDYXJsaXRvIl0sc3R5bGU6Y2ksZmFsbGJhY2s6IkhlbHZldGljYSJ9XSxbIkNhbGlicmktQm9sZCIse2FsaWFzOiJDYWxpYnJpIixzdHlsZTpsaSxmYWxsYmFjazoiSGVsdmV0aWNhLUJvbGQifV0sWyJDYWxpYnJpLUl0YWxpYyIse2FsaWFzOiJDYWxpYnJpIixzdHlsZTpoaSxmYWxsYmFjazoiSGVsdmV0aWNhLU9ibGlxdWUifV0sWyJDYWxpYnJpLUJvbGRJdGFsaWMiLHthbGlhczoiQ2FsaWJyaSIsc3R5bGU6dWksZmFsbGJhY2s6IkhlbHZldGljYS1Cb2xkT2JsaXF1ZSJ9XSxbIldpbmdkaW5ncyIse2xvY2FsOlsiV2luZ2RpbmdzIiwiVVJXIERpbmdiYXRzIl0sc3R5bGU6Y2l9XSxbIldpbmdkaW5ncy1SZWd1bGFyIix7YWxpYXM6IldpbmdkaW5ncyJ9XSxbIldpbmdkaW5ncy1Cb2xkIix7YWxpYXM6IldpbmdkaW5ncyJ9XV0pLGZpPW5ldyBNYXAoW1siQXJpYWwtQmxhY2siLCJBcmlhbEJsYWNrIl1dKTtmdW5jdGlvbiBnZXRGYW1pbHlOYW1lKGUpe2NvbnN0IHQ9bmV3IFNldChbInRoaW4iLCJleHRyYWxpZ2h0IiwidWx0cmFsaWdodCIsImRlbWlsaWdodCIsInNlbWlsaWdodCIsImxpZ2h0IiwiYm9vayIsInJlZ3VsYXIiLCJub3JtYWwiLCJtZWRpdW0iLCJkZW1pYm9sZCIsInNlbWlib2xkIiwiYm9sZCIsImV4dHJhYm9sZCIsInVsdHJhYm9sZCIsImJsYWNrIiwiaGVhdnkiLCJleHRyYWJsYWNrIiwidWx0cmFibGFjayIsInJvbWFuIiwiaXRhbGljIiwib2JsaXF1ZSIsInVsdHJhY29uZGVuc2VkIiwiZXh0cmFjb25kZW5zZWQiLCJjb25kZW5zZWQiLCJzZW1pY29uZGVuc2VkIiwibm9ybWFsIiwic2VtaWV4cGFuZGVkIiwiZXhwYW5kZWQiLCJleHRyYWV4cGFuZGVkIiwidWx0cmFleHBhbmRlZCIsImJvbGRpdGFsaWMiXSk7cmV0dXJuIGUuc3BsaXQoL1stICwrXSsvZykuZmlsdGVyKGU9PiF0LmhhcyhlLnRvTG93ZXJDYXNlKCkpKS5qb2luKCIgIil9ZnVuY3Rpb24gZ2VuZXJhdGVGb250KHthbGlhczplLGxvY2FsOnQscGF0aDpyLGZhbGxiYWNrOmEsc3R5bGU6bix1bHRpbWF0ZTppfSxzLG8sYz0hMCxsPSEwLGg9IiIpe2NvbnN0IHU9e3N0eWxlOm51bGwsdWx0aW1hdGU6bnVsbH07aWYodCl7Y29uc3QgZT1oP2AgJHtofWA6IiI7Zm9yKGNvbnN0IHIgb2YgdClzLnB1c2goYGxvY2FsKCR7cn0ke2V9KWApfWlmKGUpe2NvbnN0IHQ9ZGkuZ2V0KGUpLGk9aHx8ZnVuY3Rpb24gZ2V0U3R5bGVUb0FwcGVuZChlKXtzd2l0Y2goZSl7Y2FzZSBsaTpyZXR1cm4iQm9sZCI7Y2FzZSBoaTpyZXR1cm4iSXRhbGljIjtjYXNlIHVpOnJldHVybiJCb2xkIEl0YWxpYyI7ZGVmYXVsdDppZigiYm9sZCI9PT1lPy53ZWlnaHQpcmV0dXJuIkJvbGQiO2lmKCJpdGFsaWMiPT09ZT8uc3R5bGUpcmV0dXJuIkl0YWxpYyJ9cmV0dXJuIiJ9KG4pO09iamVjdC5hc3NpZ24odSxnZW5lcmF0ZUZvbnQodCxzLG8sYyYmIWEsbCYmIXIsaSkpfW4mJih1LnN0eWxlPW4pO2kmJih1LnVsdGltYXRlPWkpO2lmKGMmJmEpe2NvbnN0IGU9ZGkuZ2V0KGEpLHt1bHRpbWF0ZTp0fT1nZW5lcmF0ZUZvbnQoZSxzLG8sYyxsJiYhcixoKTt1LnVsdGltYXRlfHw9dH1sJiZyJiZvJiZzLnB1c2goYHVybCgke299JHtyfSlgKTtyZXR1cm4gdX1mdW5jdGlvbiBnZXRGb250U3Vic3RpdHV0aW9uKGUsdCxyLGEsbixpKXtpZihhLnN0YXJ0c1dpdGgoIkludmFsaWRQREZqc0ZvbnRfIikpcmV0dXJuIG51bGw7IlRydWVUeXBlIiE9PWkmJiJUeXBlMSIhPT1pfHwhL15bQS1aXXs2fVwrLy50ZXN0KGEpfHwoYT1hLnNsaWNlKDcpKTtjb25zdCBzPWE9bm9ybWFsaXplRm9udE5hbWUoYSk7bGV0IG89ZS5nZXQocyk7aWYobylyZXR1cm4gbztsZXQgYz1kaS5nZXQoYSk7aWYoIWMpZm9yKGNvbnN0W2UsdF1vZiBmaSlpZihhLnN0YXJ0c1dpdGgoZSkpe2E9YCR7dH0ke2Euc3Vic3RyaW5nKGUubGVuZ3RoKX1gO2M9ZGkuZ2V0KGEpO2JyZWFrfWxldCBsPSExO2lmKCFjKXtjPWRpLmdldChuKTtsPSEwfWNvbnN0IGg9YCR7dC5nZXREb2NJZCgpfV9zJHt0LmNyZWF0ZUZvbnRJZCgpfWA7aWYoIWMpe2lmKCF2YWxpZGF0ZUZvbnROYW1lKGEpKXt3YXJuKGBDYW5ub3Qgc3Vic3RpdHV0ZSB0aGUgZm9udCBiZWNhdXNlIG9mIGl0cyBuYW1lOiAke2F9YCk7ZS5zZXQocyxudWxsKTtyZXR1cm4gbnVsbH1jb25zdCB0PS9ib2xkL2dpLnRlc3QoYSkscj0vb2JsaXF1ZXxpdGFsaWMvZ2kudGVzdChhKSxuPXQmJnImJnVpfHx0JiZsaXx8ciYmaGl8fGNpO289e2NzczpgIiR7Z2V0RmFtaWx5TmFtZShhKX0iLCR7aH1gLGd1ZXNzRmFsbGJhY2s6ITAsbG9hZGVkTmFtZTpoLGJhc2VGb250TmFtZTphLHNyYzpgbG9jYWwoJHthfSlgLHN0eWxlOm59O2Uuc2V0KHMsbyk7cmV0dXJuIG99Y29uc3QgdT1bXTtsJiZ2YWxpZGF0ZUZvbnROYW1lKGEpJiZ1LnB1c2goYGxvY2FsKCR7YX0pYCk7Y29uc3R7c3R5bGU6ZCx1bHRpbWF0ZTpmfT1nZW5lcmF0ZUZvbnQoYyx1LHIpLGc9bnVsbD09PWYscD1nPyIiOmAsJHtmfWA7bz17Y3NzOmAiJHtnZXRGYW1pbHlOYW1lKGEpfSIsJHtofSR7cH1gLGd1ZXNzRmFsbGJhY2s6Zyxsb2FkZWROYW1lOmgsYmFzZUZvbnROYW1lOmEsc3JjOnUuam9pbigiLCIpLHN0eWxlOmR9O2Uuc2V0KHMsbyk7cmV0dXJuIG99Y29uc3QgZ2k9MzI4NTM3NzUyMCxwaT00Mjk0OTAxNzYwLG1pPTY1NTM1O2NsYXNzIE11cm11ckhhc2gzXzY0e2NvbnN0cnVjdG9yKGUpe3RoaXMuaDE9ZT80Mjk0OTY3Mjk1JmU6Z2k7dGhpcy5oMj1lPzQyOTQ5NjcyOTUmZTpnaX11cGRhdGUoZSl7bGV0IHQscjtpZigic3RyaW5nIj09dHlwZW9mIGUpe3Q9bmV3IFVpbnQ4QXJyYXkoMiplLmxlbmd0aCk7cj0wO2ZvcihsZXQgYT0wLG49ZS5sZW5ndGg7YTxuO2ErKyl7Y29uc3Qgbj1lLmNoYXJDb2RlQXQoYSk7aWYobjw9MjU1KXRbcisrXT1uO2Vsc2V7dFtyKytdPW4+Pj44O3RbcisrXT0yNTUmbn19fWVsc2V7aWYoIUFycmF5QnVmZmVyLmlzVmlldyhlKSl0aHJvdyBuZXcgRXJyb3IoIkludmFsaWQgZGF0YSBmb3JtYXQsIG11c3QgYmUgYSBzdHJpbmcgb3IgVHlwZWRBcnJheS4iKTt0PWUuc2xpY2UoKTtyPXQuYnl0ZUxlbmd0aH1jb25zdCBhPXI+PjIsbj1yLTQqYSxpPW5ldyBVaW50MzJBcnJheSh0LmJ1ZmZlciwwLGEpO2xldCBzPTAsbz0wLGM9dGhpcy5oMSxsPXRoaXMuaDI7Y29uc3QgaD0zNDMyOTE4MzUzLHU9NDYxODQ1OTA3LGQ9MTE2MDEsZj0xMzcxNTtmb3IobGV0IGU9MDtlPGE7ZSsrKWlmKDEmZSl7cz1pW2VdO3M9cypoJnBpfHMqZCZtaTtzPXM8PDE1fHM+Pj4xNztzPXMqdSZwaXxzKmYmbWk7Y149cztjPWM8PDEzfGM+Pj4xOTtjPTUqYyszODY0MjkyMTk2fWVsc2V7bz1pW2VdO289bypoJnBpfG8qZCZtaTtvPW88PDE1fG8+Pj4xNztvPW8qdSZwaXxvKmYmbWk7bF49bztsPWw8PDEzfGw+Pj4xOTtsPTUqbCszODY0MjkyMTk2fXM9MDtzd2l0Y2gobil7Y2FzZSAzOnNePXRbNCphKzJdPDwxNjtjYXNlIDI6c149dFs0KmErMV08PDg7Y2FzZSAxOnNePXRbNCphXTtzPXMqaCZwaXxzKmQmbWk7cz1zPDwxNXxzPj4+MTc7cz1zKnUmcGl8cypmJm1pOzEmYT9jXj1zOmxePXN9dGhpcy5oMT1jO3RoaXMuaDI9bH1oZXhkaWdlc3QoKXtsZXQgZT10aGlzLmgxLHQ9dGhpcy5oMjtlXj10Pj4+MTtlPTM5ODE4MDY3OTcqZSZwaXwzNjA0NSplJm1pO3Q9NDI4MzU0MzUxMSp0JnBpfCgyOTUwMTYzNzk3Kih0PDwxNnxlPj4+MTYpJnBpKT4+PjE2O2VePXQ+Pj4xO2U9NDQ0OTg0NDAzKmUmcGl8NjA0OTkqZSZtaTt0PTMzMDE4ODIzNjYqdCZwaXwoMzEyMDQzNzg5MyoodDw8MTZ8ZT4+PjE2KSZwaSk+Pj4xNjtlXj10Pj4+MTtyZXR1cm4oZT4+PjApLnRvU3RyaW5nKDE2KS5wYWRTdGFydCg4LCIwIikrKHQ+Pj4wKS50b1N0cmluZygxNikucGFkU3RhcnQoOCwiMCIpfX1mdW5jdGlvbiByZXNpemVJbWFnZU1hc2soZSx0LHIsYSxuLGkpe2NvbnN0IHM9bippO2xldCBvO289dDw9OD9uZXcgVWludDhBcnJheShzKTp0PD0xNj9uZXcgVWludDE2QXJyYXkocyk6bmV3IFVpbnQzMkFycmF5KHMpO2NvbnN0IGM9ci9uLGw9YS9pO2xldCBoLHUsZCxmLGc9MDtjb25zdCBwPW5ldyBVaW50MTZBcnJheShuKSxtPXI7Zm9yKGg9MDtoPG47aCsrKXBbaF09TWF0aC5mbG9vcihoKmMpO2ZvcihoPTA7aDxpO2grKyl7ZD1NYXRoLmZsb29yKGgqbCkqbTtmb3IodT0wO3U8bjt1Kyspe2Y9ZCtwW3VdO29bZysrXT1lW2ZdfX1yZXR1cm4gb31jbGFzcyBQREZJbWFnZXtjb25zdHJ1Y3Rvcih7eHJlZjplLHJlczp0LGltYWdlOnIsaXNJbmxpbmU6YT0hMSxzbWFzazpuPW51bGwsbWFzazppPW51bGwsaXNNYXNrOnM9ITEscGRmRnVuY3Rpb25GYWN0b3J5Om8sZ2xvYmFsQ29sb3JTcGFjZUNhY2hlOmMsbG9jYWxDb2xvclNwYWNlQ2FjaGU6bH0pe3RoaXMuaW1hZ2U9cjtjb25zdCBoPXIuZGljdCx1PWguZ2V0KCJGIiwiRmlsdGVyIik7bGV0IGQ7aWYodSBpbnN0YW5jZW9mIE5hbWUpZD11Lm5hbWU7ZWxzZSBpZihBcnJheS5pc0FycmF5KHUpKXtjb25zdCB0PWUuZmV0Y2hJZlJlZih1WzBdKTt0IGluc3RhbmNlb2YgTmFtZSYmKGQ9dC5uYW1lKX1zd2l0Y2goZCl7Y2FzZSJKUFhEZWNvZGUiOih7d2lkdGg6ci53aWR0aCxoZWlnaHQ6ci5oZWlnaHQsY29tcG9uZW50c0NvdW50OnIubnVtQ29tcHMsYml0c1BlckNvbXBvbmVudDpyLmJpdHNQZXJDb21wb25lbnR9PUpweEltYWdlLnBhcnNlSW1hZ2VQcm9wZXJ0aWVzKHIuc3RyZWFtKSk7ci5zdHJlYW0ucmVzZXQoKTtjb25zdCBlPUltYWdlUmVzaXplci5nZXRSZWR1Y2VQb3dlckZvckpQWChyLndpZHRoLHIuaGVpZ2h0LHIubnVtQ29tcHMpO3RoaXMuanB4RGVjb2Rlck9wdGlvbnM9e251bUNvbXBvbmVudHM6MCxpc0luZGV4ZWRDb2xvcm1hcDohMSxzbWFza0luRGF0YTpoLmhhcygiU01hc2tJbkRhdGEiKSxyZWR1Y2VQb3dlcjplfTtpZihlKXtjb25zdCB0PTIqKmU7ci53aWR0aD1NYXRoLmNlaWwoci53aWR0aC90KTtyLmhlaWdodD1NYXRoLmNlaWwoci5oZWlnaHQvdCl9YnJlYWs7Y2FzZSJKQklHMkRlY29kZSI6ci5iaXRzUGVyQ29tcG9uZW50PTE7ci5udW1Db21wcz0xfWxldCBmPWguZ2V0KCJXIiwiV2lkdGgiKSxnPWguZ2V0KCJIIiwiSGVpZ2h0Iik7aWYoTnVtYmVyLmlzSW50ZWdlcihyLndpZHRoKSYmci53aWR0aD4wJiZOdW1iZXIuaXNJbnRlZ2VyKHIuaGVpZ2h0KSYmci5oZWlnaHQ+MCYmKHIud2lkdGghPT1mfHxyLmhlaWdodCE9PWcpKXt3YXJuKCJQREZJbWFnZSAtIHVzaW5nIHRoZSBXaWR0aC9IZWlnaHQgb2YgdGhlIGltYWdlIGRhdGEsIHJhdGhlciB0aGFuIHRoZSBpbWFnZSBkaWN0aW9uYXJ5LiIpO2Y9ci53aWR0aDtnPXIuaGVpZ2h0fWVsc2V7Y29uc3QgZT0ibnVtYmVyIj09dHlwZW9mIGYmJmY+MCx0PSJudW1iZXIiPT10eXBlb2YgZyYmZz4wO2lmKCFlfHwhdCl7aWYoIXIuZmFsbGJhY2tEaW1zKXRocm93IG5ldyBGb3JtYXRFcnJvcihgSW52YWxpZCBpbWFnZSB3aWR0aDogJHtmfSBvciBoZWlnaHQ6ICR7Z31gKTt3YXJuKCJQREZJbWFnZSAtIHVzaW5nIHRoZSBXaWR0aC9IZWlnaHQgb2YgdGhlIHBhcmVudCBpbWFnZSwgZm9yIFNNYXNrL01hc2sgZGF0YS4iKTtlfHwoZj1yLmZhbGxiYWNrRGltcy53aWR0aCk7dHx8KGc9ci5mYWxsYmFja0RpbXMuaGVpZ2h0KX19dGhpcy53aWR0aD1mO3RoaXMuaGVpZ2h0PWc7dGhpcy5pbnRlcnBvbGF0ZT1oLmdldCgiSSIsIkludGVycG9sYXRlIik7dGhpcy5pbWFnZU1hc2s9aC5nZXQoIklNIiwiSW1hZ2VNYXNrIil8fCExO3RoaXMubWF0dGU9aC5nZXQoIk1hdHRlIil8fCExO2xldCBwPXIuYml0c1BlckNvbXBvbmVudDtpZighcCl7cD1oLmdldCgiQlBDIiwiQml0c1BlckNvbXBvbmVudCIpO2lmKCFwKXtpZighdGhpcy5pbWFnZU1hc2spdGhyb3cgbmV3IEZvcm1hdEVycm9yKGBCaXRzIHBlciBjb21wb25lbnQgbWlzc2luZyBpbiBpbWFnZTogJHt0aGlzLmltYWdlTWFza31gKTtwPTF9fXRoaXMuYnBjPXA7aWYoIXRoaXMuaW1hZ2VNYXNrKXtsZXQgbj1oLmdldFJhdygiQ1MiKXx8aC5nZXRSYXcoIkNvbG9yU3BhY2UiKTtjb25zdCBpPSEhbjtpZihpKXRoaXMuanB4RGVjb2Rlck9wdGlvbnM/LnNtYXNrSW5EYXRhJiYobj1OYW1lLmdldCgiRGV2aWNlUkdCQSIpKTtlbHNlIGlmKHRoaXMuanB4RGVjb2Rlck9wdGlvbnMpbj1OYW1lLmdldCgiRGV2aWNlUkdCQSIpO2Vsc2Ugc3dpdGNoKHIubnVtQ29tcHMpe2Nhc2UgMTpuPU5hbWUuZ2V0KCJEZXZpY2VHcmF5Iik7YnJlYWs7Y2FzZSAzOm49TmFtZS5nZXQoIkRldmljZVJHQiIpO2JyZWFrO2Nhc2UgNDpuPU5hbWUuZ2V0KCJEZXZpY2VDTVlLIik7YnJlYWs7ZGVmYXVsdDp0aHJvdyBuZXcgRXJyb3IoYEltYWdlcyB3aXRoICR7ci5udW1Db21wc30gY29sb3IgY29tcG9uZW50cyBub3Qgc3VwcG9ydGVkLmApfXRoaXMuY29sb3JTcGFjZT1Db2xvclNwYWNlVXRpbHMucGFyc2Uoe2NzOm4seHJlZjplLHJlc291cmNlczphP3Q6bnVsbCxwZGZGdW5jdGlvbkZhY3Rvcnk6byxnbG9iYWxDb2xvclNwYWNlQ2FjaGU6Yyxsb2NhbENvbG9yU3BhY2VDYWNoZTpsfSk7dGhpcy5udW1Db21wcz10aGlzLmNvbG9yU3BhY2UubnVtQ29tcHM7aWYodGhpcy5qcHhEZWNvZGVyT3B0aW9ucyl7dGhpcy5qcHhEZWNvZGVyT3B0aW9ucy5udW1Db21wb25lbnRzPWk/dGhpcy5udW1Db21wczowO3RoaXMuanB4RGVjb2Rlck9wdGlvbnMuaXNJbmRleGVkQ29sb3JtYXA9IkluZGV4ZWQiPT09dGhpcy5jb2xvclNwYWNlLm5hbWV9fXRoaXMuZGVjb2RlPWguZ2V0QXJyYXkoIkQiLCJEZWNvZGUiKTt0aGlzLm5lZWRzRGVjb2RlPSExO2lmKHRoaXMuZGVjb2RlJiYodGhpcy5jb2xvclNwYWNlJiYhdGhpcy5jb2xvclNwYWNlLmlzRGVmYXVsdERlY29kZSh0aGlzLmRlY29kZSxwKXx8cyYmIUNvbG9yU3BhY2UuaXNEZWZhdWx0RGVjb2RlKHRoaXMuZGVjb2RlLDEpKSl7dGhpcy5uZWVkc0RlY29kZT0hMDtjb25zdCBlPSgxPDxwKS0xO3RoaXMuZGVjb2RlQ29lZmZpY2llbnRzPVtdO3RoaXMuZGVjb2RlQWRkZW5kcz1bXTtjb25zdCB0PSJJbmRleGVkIj09PXRoaXMuY29sb3JTcGFjZT8ubmFtZTtmb3IobGV0IHI9MCxhPTA7cjx0aGlzLmRlY29kZS5sZW5ndGg7cis9MiwrK2Epe2NvbnN0IG49dGhpcy5kZWNvZGVbcl0saT10aGlzLmRlY29kZVtyKzFdO3RoaXMuZGVjb2RlQ29lZmZpY2llbnRzW2FdPXQ/KGktbikvZTppLW47dGhpcy5kZWNvZGVBZGRlbmRzW2FdPXQ/bjplKm59fWlmKG4pe24uZmFsbGJhY2tEaW1zPz89e3dpZHRoOmYsaGVpZ2h0Omd9O3RoaXMuc21hc2s9bmV3IFBERkltYWdlKHt4cmVmOmUscmVzOnQsaW1hZ2U6bixpc0lubGluZTphLHBkZkZ1bmN0aW9uRmFjdG9yeTpvLGdsb2JhbENvbG9yU3BhY2VDYWNoZTpjLGxvY2FsQ29sb3JTcGFjZUNhY2hlOmx9KX1lbHNlIGlmKGkpaWYoaSBpbnN0YW5jZW9mIEJhc2VTdHJlYW0pe2lmKGkuZGljdC5nZXQoIklNIiwiSW1hZ2VNYXNrIikpe2kuZmFsbGJhY2tEaW1zPz89e3dpZHRoOmYsaGVpZ2h0Omd9O3RoaXMubWFzaz1uZXcgUERGSW1hZ2Uoe3hyZWY6ZSxyZXM6dCxpbWFnZTppLGlzSW5saW5lOmEsaXNNYXNrOiEwLHBkZkZ1bmN0aW9uRmFjdG9yeTpvLGdsb2JhbENvbG9yU3BhY2VDYWNoZTpjLGxvY2FsQ29sb3JTcGFjZUNhY2hlOmx9KX1lbHNlIHdhcm4oIklnbm9yaW5nIC9NYXNrIGluIGltYWdlIHdpdGhvdXQgL0ltYWdlTWFzay4iKX1lbHNlIHRoaXMubWFzaz1pfXN0YXRpYyBhc3luYyBidWlsZEltYWdlKHt4cmVmOmUscmVzOnQsaW1hZ2U6cixpc0lubGluZTphPSExLHBkZkZ1bmN0aW9uRmFjdG9yeTpuLGdsb2JhbENvbG9yU3BhY2VDYWNoZTppLGxvY2FsQ29sb3JTcGFjZUNhY2hlOnN9KXtjb25zdCBvPXI7bGV0IGM9bnVsbCxsPW51bGw7Y29uc3QgaD1yLmRpY3QuZ2V0KCJTTWFzayIpLHU9ci5kaWN0LmdldCgiTWFzayIpO2g/aCBpbnN0YW5jZW9mIEJhc2VTdHJlYW0/Yz1oOndhcm4oIlVuc3VwcG9ydGVkIC9TTWFzayBmb3JtYXQuIik6dSYmKHUgaW5zdGFuY2VvZiBCYXNlU3RyZWFtfHxBcnJheS5pc0FycmF5KHUpP2w9dTp3YXJuKCJVbnN1cHBvcnRlZCAvTWFzayBmb3JtYXQuIikpO3JldHVybiBuZXcgUERGSW1hZ2Uoe3hyZWY6ZSxyZXM6dCxpbWFnZTpvLGlzSW5saW5lOmEsc21hc2s6YyxtYXNrOmwscGRmRnVuY3Rpb25GYWN0b3J5Om4sZ2xvYmFsQ29sb3JTcGFjZUNhY2hlOmksbG9jYWxDb2xvclNwYWNlQ2FjaGU6c30pfXN0YXRpYyBhc3luYyBjcmVhdGVNYXNrKHtpbWFnZTplLGlzT2Zmc2NyZWVuQ2FudmFzU3VwcG9ydGVkOnQ9ITF9KXtjb25zdHtkaWN0OnJ9PWUsYT1yLmdldCgiVyIsIldpZHRoIiksbj1yLmdldCgiSCIsIkhlaWdodCIpLGk9ci5nZXQoIkkiLCJJbnRlcnBvbGF0ZSIpLHM9ci5nZXRBcnJheSgiRCIsIkRlY29kZSIpLG89cz8uWzBdPjAsYz0oYSs3Pj4zKSpuLGw9ZS5nZXRCeXRlcyhjKSxoPTE9PT1hJiYxPT09biYmbz09PSgwPT09bC5sZW5ndGh8fCEhKDEyOCZsWzBdKSk7aWYoaClyZXR1cm57aXNTaW5nbGVPcGFxdWVQaXhlbDpofTtpZih0KXtpZihJbWFnZVJlc2l6ZXIubmVlZHNUb0JlUmVzaXplZChhLG4pKXtjb25zdCBlPW5ldyBVaW50OENsYW1wZWRBcnJheShhKm4qNCk7Y29udmVydEJsYWNrQW5kV2hpdGVUb1JHQkEoe3NyYzpsLGRlc3Q6ZSx3aWR0aDphLGhlaWdodDpuLG5vbkJsYWNrQ29sb3I6MCxpbnZlcnNlRGVjb2RlOm99KTtyZXR1cm4gSW1hZ2VSZXNpemVyLmNyZWF0ZUltYWdlKHtraW5kOk8sZGF0YTplLHdpZHRoOmEsaGVpZ2h0Om4saW50ZXJwb2xhdGU6aX0pfWNvbnN0IGU9bmV3IE9mZnNjcmVlbkNhbnZhcyhhLG4pLHQ9ZS5nZXRDb250ZXh0KCIyZCIpLHI9dC5jcmVhdGVJbWFnZURhdGEoYSxuKTtjb252ZXJ0QmxhY2tBbmRXaGl0ZVRvUkdCQSh7c3JjOmwsZGVzdDpyLmRhdGEsd2lkdGg6YSxoZWlnaHQ6bixub25CbGFja0NvbG9yOjAsaW52ZXJzZURlY29kZTpvfSk7dC5wdXRJbWFnZURhdGEociwwLDApO3JldHVybntkYXRhOm51bGwsd2lkdGg6YSxoZWlnaHQ6bixpbnRlcnBvbGF0ZTppLGJpdG1hcDplLnRyYW5zZmVyVG9JbWFnZUJpdG1hcCgpfX1jb25zdCB1PWwuYnl0ZUxlbmd0aDtsZXQgZDtpZihlIGluc3RhbmNlb2YgRGVjb2RlU3RyZWFtJiYoIW98fGM9PT11KSlkPWw7ZWxzZSBpZihvKXtkPW5ldyBVaW50OEFycmF5KGMpO2Quc2V0KGwpO2QuZmlsbCgyNTUsdSl9ZWxzZSBkPW5ldyBVaW50OEFycmF5KGwpO2lmKG8pZm9yKGxldCBlPTA7ZTx1O2UrKylkW2VdXj0yNTU7cmV0dXJue2RhdGE6ZCx3aWR0aDphLGhlaWdodDpuLGludGVycG9sYXRlOml9fWdldCBkcmF3V2lkdGgoKXtyZXR1cm4gTWF0aC5tYXgodGhpcy53aWR0aCx0aGlzLnNtYXNrPy53aWR0aHx8MCx0aGlzLm1hc2s/LndpZHRofHwwKX1nZXQgZHJhd0hlaWdodCgpe3JldHVybiBNYXRoLm1heCh0aGlzLmhlaWdodCx0aGlzLnNtYXNrPy5oZWlnaHR8fDAsdGhpcy5tYXNrPy5oZWlnaHR8fDApfWRlY29kZUJ1ZmZlcihlKXtjb25zdCB0PXRoaXMuYnBjLHI9dGhpcy5udW1Db21wcyxhPXRoaXMuZGVjb2RlQWRkZW5kcyxuPXRoaXMuZGVjb2RlQ29lZmZpY2llbnRzLGk9KDE8PHQpLTE7bGV0IHMsbztpZigxPT09dCl7Zm9yKHM9MCxvPWUubGVuZ3RoO3M8bztzKyspZVtzXT0rIWVbc107cmV0dXJufWxldCBjPTA7Zm9yKHM9MCxvPXRoaXMud2lkdGgqdGhpcy5oZWlnaHQ7czxvO3MrKylmb3IobGV0IHQ9MDt0PHI7dCsrKXtlW2NdPU1hdGhDbGFtcChhW3RdK2VbY10qblt0XSwwLGkpO2MrK319Z2V0Q29tcG9uZW50cyhlKXtjb25zdCB0PXRoaXMuYnBjO2lmKDg9PT10KXJldHVybiBlO2NvbnN0IHI9dGhpcy53aWR0aCxhPXRoaXMuaGVpZ2h0LG49dGhpcy5udW1Db21wcyxpPXIqYSpuO2xldCBzLG89MDtzPXQ8PTg/bmV3IFVpbnQ4QXJyYXkoaSk6dDw9MTY/bmV3IFVpbnQxNkFycmF5KGkpOm5ldyBVaW50MzJBcnJheShpKTtjb25zdCBjPXIqbixsPSgxPDx0KS0xO2xldCBoLHUsZD0wO2lmKDE9PT10KXtsZXQgdCxyLG47Zm9yKGxldCBpPTA7aTxhO2krKyl7cj1kKygtOCZjKTtuPWQrYztmb3IoO2Q8cjspe3U9ZVtvKytdO3NbZF09dT4+NyYxO3NbZCsxXT11Pj42JjE7c1tkKzJdPXU+PjUmMTtzW2QrM109dT4+NCYxO3NbZCs0XT11Pj4zJjE7c1tkKzVdPXU+PjImMTtzW2QrNl09dT4+MSYxO3NbZCs3XT0xJnU7ZCs9OH1pZihkPG4pe3U9ZVtvKytdO3Q9MTI4O2Zvcig7ZDxuOyl7c1tkKytdPSshISh1JnQpO3Q+Pj0xfX19fWVsc2V7bGV0IHI9MDt1PTA7Zm9yKGQ9MCxoPWk7ZDxoOysrZCl7aWYoZCVjPT09MCl7dT0wO3I9MH1mb3IoO3I8dDspe3U9dTw8OHxlW28rK107cis9OH1jb25zdCBhPXItdDtsZXQgbj11Pj5hO248MD9uPTA6bj5sJiYobj1sKTtzW2RdPW47dSY9KDE8PGEpLTE7cj1hfX1yZXR1cm4gc31hc3luYyBmaWxsT3BhY2l0eShlLHQscixhLG4pe2NvbnN0IGk9dGhpcy5zbWFzayxzPXRoaXMubWFzaztsZXQgbyxjLGwsaCx1LGQ7aWYoaSl7Yz1pLndpZHRoO2w9aS5oZWlnaHQ7bz1uZXcgVWludDhDbGFtcGVkQXJyYXkoYypsKTthd2FpdCBpLmZpbGxHcmF5QnVmZmVyKG8pO2M9PT10JiZsPT09cnx8KG89cmVzaXplSW1hZ2VNYXNrKG8saS5icGMsYyxsLHQscikpfWVsc2UgaWYocylpZihzIGluc3RhbmNlb2YgUERGSW1hZ2Upe2M9cy53aWR0aDtsPXMuaGVpZ2h0O289bmV3IFVpbnQ4Q2xhbXBlZEFycmF5KGMqbCk7cy5udW1Db21wcz0xO2F3YWl0IHMuZmlsbEdyYXlCdWZmZXIobyk7Zm9yKGg9MCx1PWMqbDtoPHU7KytoKW9baF09MjU1LW9baF07Yz09PXQmJmw9PT1yfHwobz1yZXNpemVJbWFnZU1hc2sobyxzLmJwYyxjLGwsdCxyKSl9ZWxzZXtpZighQXJyYXkuaXNBcnJheShzKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlVua25vd24gbWFzayBmb3JtYXQuIik7e289bmV3IFVpbnQ4Q2xhbXBlZEFycmF5KHQqcik7Y29uc3QgZT10aGlzLm51bUNvbXBzO2ZvcihoPTAsdT10KnI7aDx1OysraCl7bGV0IHQ9MDtjb25zdCByPWgqZTtmb3IoZD0wO2Q8ZTsrK2Qpe2NvbnN0IGU9bltyK2RdLGE9MipkO2lmKGU8c1thXXx8ZT5zW2ErMV0pe3Q9MjU1O2JyZWFrfX1vW2hdPXR9fX1pZihvKWZvcihoPTAsZD0zLHU9dCphO2g8dTsrK2gsZCs9NCllW2RdPW9baF07ZWxzZSBmb3IoaD0wLGQ9Myx1PXQqYTtoPHU7KytoLGQrPTQpZVtkXT0yNTV9dW5kb1ByZWJsZW5kKGUsdCxyKXtjb25zdCBhPXRoaXMuc21hc2s/Lm1hdHRlO2lmKCFhKXJldHVybjtjb25zdCBuPXRoaXMuY29sb3JTcGFjZS5nZXRSZ2IoYSwwKSxpPW5bMF0scz1uWzFdLG89blsyXSxjPXQqcio0O2ZvcihsZXQgdD0wO3Q8Yzt0Kz00KXtjb25zdCByPWVbdCszXTtpZigwPT09cil7ZVt0XT0yNTU7ZVt0KzFdPTI1NTtlW3QrMl09MjU1O2NvbnRpbnVlfWNvbnN0IGE9MjU1L3I7ZVt0XT0oZVt0XS1pKSphK2k7ZVt0KzFdPShlW3QrMV0tcykqYStzO2VbdCsyXT0oZVt0KzJdLW8pKmErb319YXN5bmMgY3JlYXRlSW1hZ2VEYXRhKGU9ITEsdD0hMSl7Y29uc3Qgcj10aGlzLmRyYXdXaWR0aCxhPXRoaXMuZHJhd0hlaWdodCxuPXt3aWR0aDpyLGhlaWdodDphLGludGVycG9sYXRlOnRoaXMuaW50ZXJwb2xhdGUsa2luZDowLGRhdGE6bnVsbH0saT10aGlzLm51bUNvbXBzLHM9dGhpcy53aWR0aCxvPXRoaXMuaGVpZ2h0LGM9dGhpcy5icGMsbD1zKmkqYys3Pj4zLGg9dCYmSW1hZ2VSZXNpemVyLm5lZWRzVG9CZVJlc2l6ZWQocixhKTtpZighdGhpcy5zbWFzayYmIXRoaXMubWFzayYmIkRldmljZVJHQkEiPT09dGhpcy5jb2xvclNwYWNlLm5hbWUpe24ua2luZD1PO2NvbnN0IGU9bi5kYXRhPWF3YWl0IHRoaXMuZ2V0SW1hZ2VCeXRlcyhvKnMqNCx7fSk7cmV0dXJuIHQ/aD9JbWFnZVJlc2l6ZXIuY3JlYXRlSW1hZ2UobiwhMSk6dGhpcy5jcmVhdGVCaXRtYXAoTyxyLGEsZSk6bn1pZighZSl7bGV0IGU7IkRldmljZUdyYXkiPT09dGhpcy5jb2xvclNwYWNlLm5hbWUmJjE9PT1jP2U9djoiRGV2aWNlUkdCIiE9PXRoaXMuY29sb3JTcGFjZS5uYW1lfHw4IT09Y3x8dGhpcy5uZWVkc0RlY29kZXx8KGU9VCk7aWYoZSYmIXRoaXMuc21hc2smJiF0aGlzLm1hc2smJnI9PT1zJiZhPT09byl7Y29uc3QgaT1hd2FpdCB0aGlzLiNyZShzLG8pO2lmKGkpcmV0dXJuIGk7Y29uc3QgYz1hd2FpdCB0aGlzLmdldEltYWdlQnl0ZXMobypsLHt9KTtpZih0KXJldHVybiBoP0ltYWdlUmVzaXplci5jcmVhdGVJbWFnZSh7ZGF0YTpjLGtpbmQ6ZSx3aWR0aDpyLGhlaWdodDphLGludGVycG9sYXRlOnRoaXMuaW50ZXJwb2xhdGV9LHRoaXMubmVlZHNEZWNvZGUpOnRoaXMuY3JlYXRlQml0bWFwKGUscyxvLGMpO24ua2luZD1lO24uZGF0YT1jO2lmKHRoaXMubmVlZHNEZWNvZGUpe2Fzc2VydChlPT09diwiUERGSW1hZ2UuY3JlYXRlSW1hZ2VEYXRhOiBUaGUgaW1hZ2UgbXVzdCBiZSBncmF5c2NhbGUuIik7Y29uc3QgdD1uLmRhdGE7Zm9yKGxldCBlPTAscj10Lmxlbmd0aDtlPHI7ZSsrKXRbZV1ePTI1NX1yZXR1cm4gbn1pZih0aGlzLmltYWdlIGluc3RhbmNlb2YgSnBlZ1N0cmVhbSYmIXRoaXMuc21hc2smJiF0aGlzLm1hc2smJiF0aGlzLm5lZWRzRGVjb2RlKXtsZXQgZT1vKmw7aWYodCYmIWgpe2xldCB0PSExO3N3aXRjaCh0aGlzLmNvbG9yU3BhY2UubmFtZSl7Y2FzZSJEZXZpY2VHcmF5IjplKj00O3Q9ITA7YnJlYWs7Y2FzZSJEZXZpY2VSR0IiOmU9ZS8zKjQ7dD0hMDticmVhaztjYXNlIkRldmljZUNNWUsiOnQ9ITB9aWYodCl7Y29uc3QgdD1hd2FpdCB0aGlzLiNyZShyLGEpO2lmKHQpcmV0dXJuIHQ7Y29uc3Qgbj1hd2FpdCB0aGlzLmdldEltYWdlQnl0ZXMoZSx7ZHJhd1dpZHRoOnIsZHJhd0hlaWdodDphLGZvcmNlUkdCQTohMH0pO3JldHVybiB0aGlzLmNyZWF0ZUJpdG1hcChPLHIsYSxuKX19ZWxzZSBzd2l0Y2godGhpcy5jb2xvclNwYWNlLm5hbWUpe2Nhc2UiRGV2aWNlR3JheSI6ZSo9MztjYXNlIkRldmljZVJHQiI6Y2FzZSJEZXZpY2VDTVlLIjpuLmtpbmQ9VDtuLmRhdGE9YXdhaXQgdGhpcy5nZXRJbWFnZUJ5dGVzKGUse2RyYXdXaWR0aDpyLGRyYXdIZWlnaHQ6YSxmb3JjZVJHQjohMH0pO3JldHVybiBoP0ltYWdlUmVzaXplci5jcmVhdGVJbWFnZShuKTpufX19Y29uc3QgdT1hd2FpdCB0aGlzLmdldEltYWdlQnl0ZXMobypsLHtpbnRlcm5hbDohMH0pLGQ9MHx1Lmxlbmd0aC9sKmEvbyxmPXRoaXMuZ2V0Q29tcG9uZW50cyh1KTtsZXQgZyxwLG0sYix5LHc7aWYodCYmIWgpe209bmV3IE9mZnNjcmVlbkNhbnZhcyhyLGEpO2I9bS5nZXRDb250ZXh0KCIyZCIpO3k9Yi5jcmVhdGVJbWFnZURhdGEocixhKTt3PXkuZGF0YX1uLmtpbmQ9TztpZihlfHx0aGlzLnNtYXNrfHx0aGlzLm1hc2spe3QmJiFofHwodz1uZXcgVWludDhDbGFtcGVkQXJyYXkociphKjQpKTtnPTE7cD0hMDthd2FpdCB0aGlzLmZpbGxPcGFjaXR5KHcscixhLGQsZil9ZWxzZXtpZighdHx8aCl7bi5raW5kPVQ7dz1uZXcgVWludDhDbGFtcGVkQXJyYXkociphKjMpO2c9MH1lbHNle25ldyBVaW50MzJBcnJheSh3LmJ1ZmZlcikuZmlsbChGZWF0dXJlVGVzdC5pc0xpdHRsZUVuZGlhbj80Mjc4MTkwMDgwOjI1NSk7Zz0xfXA9ITF9dGhpcy5uZWVkc0RlY29kZSYmdGhpcy5kZWNvZGVCdWZmZXIoZik7dGhpcy5jb2xvclNwYWNlLmZpbGxSZ2IodyxzLG8scixhLGQsYyxmLGcpO3AmJnRoaXMudW5kb1ByZWJsZW5kKHcscixkKTtpZih0JiYhaCl7Yi5wdXRJbWFnZURhdGEoeSwwLDApO3JldHVybntkYXRhOm51bGwsd2lkdGg6cixoZWlnaHQ6YSxiaXRtYXA6bS50cmFuc2ZlclRvSW1hZ2VCaXRtYXAoKSxpbnRlcnBvbGF0ZTp0aGlzLmludGVycG9sYXRlfX1uLmRhdGE9dztyZXR1cm4gaD9JbWFnZVJlc2l6ZXIuY3JlYXRlSW1hZ2Uobik6bn1hc3luYyBmaWxsR3JheUJ1ZmZlcihlKXtjb25zdCB0PXRoaXMubnVtQ29tcHM7aWYoMSE9PXQpdGhyb3cgbmV3IEZvcm1hdEVycm9yKGBSZWFkaW5nIGdyYXkgc2NhbGUgZnJvbSBhIGNvbG9yIGltYWdlOiAke3R9YCk7Y29uc3Qgcj10aGlzLndpZHRoLGE9dGhpcy5oZWlnaHQsbj10aGlzLmJwYyxpPXIqdCpuKzc+PjMscz1hd2FpdCB0aGlzLmdldEltYWdlQnl0ZXMoYSppLHtpbnRlcm5hbDohMH0pLG89dGhpcy5nZXRDb21wb25lbnRzKHMpO2xldCBjLGw7aWYoMT09PW4pe2w9ciphO2lmKHRoaXMubmVlZHNEZWNvZGUpZm9yKGM9MDtjPGw7KytjKWVbY109b1tjXS0xJjI1NTtlbHNlIGZvcihjPTA7YzxsOysrYyllW2NdPTI1NSYtb1tjXTtyZXR1cm59dGhpcy5uZWVkc0RlY29kZSYmdGhpcy5kZWNvZGVCdWZmZXIobyk7bD1yKmE7Y29uc3QgaD0yNTUvKCgxPDxuKS0xKTtmb3IoYz0wO2M8bDsrK2MpZVtjXT1oKm9bY119Y3JlYXRlQml0bWFwKGUsdCxyLGEpe2NvbnN0IG49bmV3IE9mZnNjcmVlbkNhbnZhcyh0LHIpLGk9bi5nZXRDb250ZXh0KCIyZCIpO2xldCBzO2lmKGU9PT1PKXM9bmV3IEltYWdlRGF0YShhLHQscik7ZWxzZXtzPWkuY3JlYXRlSW1hZ2VEYXRhKHQscik7Y29udmVydFRvUkdCQSh7a2luZDplLHNyYzphLGRlc3Q6bmV3IFVpbnQzMkFycmF5KHMuZGF0YS5idWZmZXIpLHdpZHRoOnQsaGVpZ2h0OnIsaW52ZXJzZURlY29kZTp0aGlzLm5lZWRzRGVjb2RlfSl9aS5wdXRJbWFnZURhdGEocywwLDApO3JldHVybntkYXRhOm51bGwsd2lkdGg6dCxoZWlnaHQ6cixiaXRtYXA6bi50cmFuc2ZlclRvSW1hZ2VCaXRtYXAoKSxpbnRlcnBvbGF0ZTp0aGlzLmludGVycG9sYXRlfX1hc3luYyNyZShlLHQpe2NvbnN0IHI9YXdhaXQgdGhpcy5pbWFnZS5nZXRUcmFuc2ZlcmFibGVJbWFnZSgpO3JldHVybiByP3tkYXRhOm51bGwsd2lkdGg6ZSxoZWlnaHQ6dCxiaXRtYXA6cixpbnRlcnBvbGF0ZTp0aGlzLmludGVycG9sYXRlfTpudWxsfWFzeW5jIGdldEltYWdlQnl0ZXMoZSx7ZHJhd1dpZHRoOnQsZHJhd0hlaWdodDpyLGZvcmNlUkdCQTphPSExLGZvcmNlUkdCOm49ITEsaW50ZXJuYWw6aT0hMX0pe3RoaXMuaW1hZ2UucmVzZXQoKTt0aGlzLmltYWdlLmRyYXdXaWR0aD10fHx0aGlzLndpZHRoO3RoaXMuaW1hZ2UuZHJhd0hlaWdodD1yfHx0aGlzLmhlaWdodDt0aGlzLmltYWdlLmZvcmNlUkdCQT0hIWE7dGhpcy5pbWFnZS5mb3JjZVJHQj0hIW47Y29uc3Qgcz1hd2FpdCB0aGlzLmltYWdlLmdldEltYWdlRGF0YShlLHRoaXMuanB4RGVjb2Rlck9wdGlvbnMpO2lmKGl8fHRoaXMuaW1hZ2UgaW5zdGFuY2VvZiBEZWNvZGVTdHJlYW0pcmV0dXJuIHM7YXNzZXJ0KHMgaW5zdGFuY2VvZiBVaW50OEFycmF5LCdQREZJbWFnZS5nZXRJbWFnZUJ5dGVzOiBVbnN1cHBvcnRlZCAiaW1hZ2VCeXRlcyIgdHlwZS4nKTtyZXR1cm4gbmV3IFVpbnQ4QXJyYXkocyl9fWNvbnN0IGJpPU9iamVjdC5mcmVlemUoe21heEltYWdlU2l6ZTotMSxkaXNhYmxlRm9udEZhY2U6ITEsaWdub3JlRXJyb3JzOiExLGlzRXZhbFN1cHBvcnRlZDohMCxpc09mZnNjcmVlbkNhbnZhc1N1cHBvcnRlZDohMSxpc0ltYWdlRGVjb2RlclN1cHBvcnRlZDohMSxjYW52YXNNYXhBcmVhSW5CeXRlczotMSxmb250RXh0cmFQcm9wZXJ0aWVzOiExLHVzZVN5c3RlbUZvbnRzOiEwLHVzZVdhc206ITAsdXNlV29ya2VyRmV0Y2g6ITAsY01hcFVybDpudWxsLGljY1VybDpudWxsLHN0YW5kYXJkRm9udERhdGFVcmw6bnVsbCx3YXNtVXJsOm51bGx9KSx5aT0xLHdpPTIseGk9UHJvbWlzZS5yZXNvbHZlKCk7ZnVuY3Rpb24gbm9ybWFsaXplQmxlbmRNb2RlKGUsdD0hMSl7aWYoQXJyYXkuaXNBcnJheShlKSl7Zm9yKGNvbnN0IHQgb2YgZSl7Y29uc3QgZT1ub3JtYWxpemVCbGVuZE1vZGUodCwhMCk7aWYoZSlyZXR1cm4gZX13YXJuKGBVbnN1cHBvcnRlZCBibGVuZCBtb2RlIEFycmF5OiAke2V9YCk7cmV0dXJuInNvdXJjZS1vdmVyIn1pZighKGUgaW5zdGFuY2VvZiBOYW1lKSlyZXR1cm4gdD9udWxsOiJzb3VyY2Utb3ZlciI7c3dpdGNoKGUubmFtZSl7Y2FzZSJOb3JtYWwiOmNhc2UiQ29tcGF0aWJsZSI6cmV0dXJuInNvdXJjZS1vdmVyIjtjYXNlIk11bHRpcGx5IjpyZXR1cm4ibXVsdGlwbHkiO2Nhc2UiU2NyZWVuIjpyZXR1cm4ic2NyZWVuIjtjYXNlIk92ZXJsYXkiOnJldHVybiJvdmVybGF5IjtjYXNlIkRhcmtlbiI6cmV0dXJuImRhcmtlbiI7Y2FzZSJMaWdodGVuIjpyZXR1cm4ibGlnaHRlbiI7Y2FzZSJDb2xvckRvZGdlIjpyZXR1cm4iY29sb3ItZG9kZ2UiO2Nhc2UiQ29sb3JCdXJuIjpyZXR1cm4iY29sb3ItYnVybiI7Y2FzZSJIYXJkTGlnaHQiOnJldHVybiJoYXJkLWxpZ2h0IjtjYXNlIlNvZnRMaWdodCI6cmV0dXJuInNvZnQtbGlnaHQiO2Nhc2UiRGlmZmVyZW5jZSI6cmV0dXJuImRpZmZlcmVuY2UiO2Nhc2UiRXhjbHVzaW9uIjpyZXR1cm4iZXhjbHVzaW9uIjtjYXNlIkh1ZSI6cmV0dXJuImh1ZSI7Y2FzZSJTYXR1cmF0aW9uIjpyZXR1cm4ic2F0dXJhdGlvbiI7Y2FzZSJDb2xvciI6cmV0dXJuImNvbG9yIjtjYXNlIkx1bWlub3NpdHkiOnJldHVybiJsdW1pbm9zaXR5In1pZih0KXJldHVybiBudWxsO3dhcm4oYFVuc3VwcG9ydGVkIGJsZW5kIG1vZGU6ICR7ZS5uYW1lfWApO3JldHVybiJzb3VyY2Utb3ZlciJ9ZnVuY3Rpb24gYWRkQ2FjaGVkSW1hZ2VPcHMoZSx7b2JqSWQ6dCxmbjpyLGFyZ3M6YSxvcHRpb25hbENvbnRlbnQ6bixoYXNNYXNrOml9KXt0JiZlLmFkZERlcGVuZGVuY3kodCk7ZS5hZGRJbWFnZU9wcyhyLGEsbixpKTtyPT09TnQmJmFbMF0/LmNvdW50PjAmJmFbMF0uY291bnQrK31jbGFzcyBUaW1lU2xvdE1hbmFnZXJ7c3RhdGljIFRJTUVfU0xPVF9EVVJBVElPTl9NUz0yMDtzdGF0aWMgQ0hFQ0tfVElNRV9FVkVSWT0xMDA7Y29uc3RydWN0b3IoKXt0aGlzLnJlc2V0KCl9Y2hlY2soKXtpZigrK3RoaXMuY2hlY2tlZDxUaW1lU2xvdE1hbmFnZXIuQ0hFQ0tfVElNRV9FVkVSWSlyZXR1cm4hMTt0aGlzLmNoZWNrZWQ9MDtyZXR1cm4gdGhpcy5lbmRUaW1lPD1EYXRlLm5vdygpfXJlc2V0KCl7dGhpcy5lbmRUaW1lPURhdGUubm93KCkrVGltZVNsb3RNYW5hZ2VyLlRJTUVfU0xPVF9EVVJBVElPTl9NUzt0aGlzLmNoZWNrZWQ9MH19Y2xhc3MgUGFydGlhbEV2YWx1YXRvcntjb25zdHJ1Y3Rvcih7eHJlZjplLGhhbmRsZXI6dCxwYWdlSW5kZXg6cixpZEZhY3Rvcnk6YSxmb250Q2FjaGU6bixidWlsdEluQ01hcENhY2hlOmksc3RhbmRhcmRGb250RGF0YUNhY2hlOnMsZ2xvYmFsQ29sb3JTcGFjZUNhY2hlOm8sZ2xvYmFsSW1hZ2VDYWNoZTpjLHN5c3RlbUZvbnRDYWNoZTpsLG9wdGlvbnM6aD1udWxsfSl7dGhpcy54cmVmPWU7dGhpcy5oYW5kbGVyPXQ7dGhpcy5wYWdlSW5kZXg9cjt0aGlzLmlkRmFjdG9yeT1hO3RoaXMuZm9udENhY2hlPW47dGhpcy5idWlsdEluQ01hcENhY2hlPWk7dGhpcy5zdGFuZGFyZEZvbnREYXRhQ2FjaGU9czt0aGlzLmdsb2JhbENvbG9yU3BhY2VDYWNoZT1vO3RoaXMuZ2xvYmFsSW1hZ2VDYWNoZT1jO3RoaXMuc3lzdGVtRm9udENhY2hlPWw7dGhpcy5vcHRpb25zPWh8fGJpO3RoaXMudHlwZTNGb250UmVmcz1udWxsO3RoaXMuX3JlZ2lvbmFsSW1hZ2VDYWNoZT1uZXcgUmVnaW9uYWxJbWFnZUNhY2hlO3RoaXMuX2ZldGNoQnVpbHRJbkNNYXBCb3VuZD10aGlzLmZldGNoQnVpbHRJbkNNYXAuYmluZCh0aGlzKX1nZXQgX3BkZkZ1bmN0aW9uRmFjdG9yeSgpe3JldHVybiBzaGFkb3codGhpcywiX3BkZkZ1bmN0aW9uRmFjdG9yeSIsbmV3IFBERkZ1bmN0aW9uRmFjdG9yeSh7eHJlZjp0aGlzLnhyZWYsaXNFdmFsU3VwcG9ydGVkOnRoaXMub3B0aW9ucy5pc0V2YWxTdXBwb3J0ZWR9KSl9Z2V0IHBhcnNpbmdUeXBlM0ZvbnQoKXtyZXR1cm4hIXRoaXMudHlwZTNGb250UmVmc31jbG9uZShlPW51bGwpe2NvbnN0IHQ9T2JqZWN0LmNyZWF0ZSh0aGlzKTt0Lm9wdGlvbnM9T2JqZWN0LmFzc2lnbihPYmplY3QuY3JlYXRlKG51bGwpLHRoaXMub3B0aW9ucyxlKTtyZXR1cm4gdH1oYXNCbGVuZE1vZGVzKGUsdCl7aWYoIShlIGluc3RhbmNlb2YgRGljdCkpcmV0dXJuITE7aWYoZS5vYmpJZCYmdC5oYXMoZS5vYmpJZCkpcmV0dXJuITE7Y29uc3Qgcj1uZXcgUmVmU2V0KHQpO2Uub2JqSWQmJnIucHV0KGUub2JqSWQpO2NvbnN0IGE9W2VdLG49dGhpcy54cmVmO2Zvcig7YS5sZW5ndGg7KXtjb25zdCBlPWEuc2hpZnQoKSx0PWUuZ2V0KCJFeHRHU3RhdGUiKTtpZih0IGluc3RhbmNlb2YgRGljdClmb3IobGV0IGUgb2YgdC5nZXRSYXdWYWx1ZXMoKSl7aWYoZSBpbnN0YW5jZW9mIFJlZil7aWYoci5oYXMoZSkpY29udGludWU7dHJ5e2U9bi5mZXRjaChlKX1jYXRjaCh0KXtyLnB1dChlKTtpbmZvKGBoYXNCbGVuZE1vZGVzIC0gaWdub3JpbmcgRXh0R1N0YXRlOiAiJHt0fSIuYCk7Y29udGludWV9fWlmKCEoZSBpbnN0YW5jZW9mIERpY3QpKWNvbnRpbnVlO2Uub2JqSWQmJnIucHV0KGUub2JqSWQpO2NvbnN0IHQ9ZS5nZXQoIkJNIik7aWYodCBpbnN0YW5jZW9mIE5hbWUpe2lmKCJOb3JtYWwiIT09dC5uYW1lKXJldHVybiEwfWVsc2UgaWYodm9pZCAwIT09dCYmQXJyYXkuaXNBcnJheSh0KSlmb3IoY29uc3QgZSBvZiB0KWlmKGUgaW5zdGFuY2VvZiBOYW1lJiYiTm9ybWFsIiE9PWUubmFtZSlyZXR1cm4hMH1jb25zdCBpPWUuZ2V0KCJYT2JqZWN0Iik7aWYoaSBpbnN0YW5jZW9mIERpY3QpZm9yKGxldCBlIG9mIGkuZ2V0UmF3VmFsdWVzKCkpe2lmKGUgaW5zdGFuY2VvZiBSZWYpe2lmKHIuaGFzKGUpKWNvbnRpbnVlO3RyeXtlPW4uZmV0Y2goZSl9Y2F0Y2godCl7ci5wdXQoZSk7aW5mbyhgaGFzQmxlbmRNb2RlcyAtIGlnbm9yaW5nIFhPYmplY3Q6ICIke3R9Ii5gKTtjb250aW51ZX19aWYoIShlIGluc3RhbmNlb2YgQmFzZVN0cmVhbSkpY29udGludWU7ZS5kaWN0Lm9iaklkJiZyLnB1dChlLmRpY3Qub2JqSWQpO2NvbnN0IHQ9ZS5kaWN0LmdldCgiUmVzb3VyY2VzIik7aWYodCBpbnN0YW5jZW9mIERpY3QmJighdC5vYmpJZHx8IXIuaGFzKHQub2JqSWQpKSl7YS5wdXNoKHQpO3Qub2JqSWQmJnIucHV0KHQub2JqSWQpfX19Zm9yKGNvbnN0IGUgb2Ygcil0LnB1dChlKTtyZXR1cm4hMX1hc3luYyBmZXRjaEJ1aWx0SW5DTWFwKGUpe2NvbnN0IHQ9dGhpcy5idWlsdEluQ01hcENhY2hlLmdldChlKTtpZih0KXJldHVybiB0O2xldCByO3I9dGhpcy5vcHRpb25zLnVzZVdvcmtlckZldGNoP3tjTWFwRGF0YTphd2FpdCBmZXRjaEJpbmFyeURhdGEoYCR7dGhpcy5vcHRpb25zLmNNYXBVcmx9JHtlfS5iY21hcGApLGlzQ29tcHJlc3NlZDohMH06YXdhaXQgdGhpcy5oYW5kbGVyLnNlbmRXaXRoUHJvbWlzZSgiRmV0Y2hCaW5hcnlEYXRhIix7dHlwZToiY01hcFJlYWRlckZhY3RvcnkiLG5hbWU6ZX0pO3RoaXMuYnVpbHRJbkNNYXBDYWNoZS5zZXQoZSxyKTtyZXR1cm4gcn1hc3luYyBmZXRjaFN0YW5kYXJkRm9udERhdGEoZSl7Y29uc3QgdD10aGlzLnN0YW5kYXJkRm9udERhdGFDYWNoZS5nZXQoZSk7aWYodClyZXR1cm4gbmV3IFN0cmVhbSh0KTtpZih0aGlzLm9wdGlvbnMudXNlU3lzdGVtRm9udHMmJiJTeW1ib2wiIT09ZSYmIlphcGZEaW5nYmF0cyIhPT1lKXJldHVybiBudWxsO2NvbnN0IHI9TGEoKVtlXTtsZXQgYTt0cnl7YT10aGlzLm9wdGlvbnMudXNlV29ya2VyRmV0Y2g/YXdhaXQgZmV0Y2hCaW5hcnlEYXRhKGAke3RoaXMub3B0aW9ucy5zdGFuZGFyZEZvbnREYXRhVXJsfSR7cn1gKTphd2FpdCB0aGlzLmhhbmRsZXIuc2VuZFdpdGhQcm9taXNlKCJGZXRjaEJpbmFyeURhdGEiLHt0eXBlOiJzdGFuZGFyZEZvbnREYXRhRmFjdG9yeSIsZmlsZW5hbWU6cn0pfWNhdGNoKGUpe3dhcm4oZSk7cmV0dXJuIG51bGx9dGhpcy5zdGFuZGFyZEZvbnREYXRhQ2FjaGUuc2V0KGUsYSk7cmV0dXJuIG5ldyBTdHJlYW0oYSl9YXN5bmMgYnVpbGRGb3JtWE9iamVjdChlLHQscixhLG4saSxzLG8pe2NvbnN0e2RpY3Q6Y309dCxsPWxvb2t1cE1hdHJpeChjLmdldEFycmF5KCJNYXRyaXgiKSxudWxsKSxoPWxvb2t1cE5vcm1hbFJlY3QoYy5nZXRBcnJheSgiQkJveCIpLG51bGwpO2xldCB1LGQ7Yy5oYXMoIk9DIikmJih1PWF3YWl0IHRoaXMucGFyc2VNYXJrZWRDb250ZW50UHJvcHMoYy5nZXQoIk9DIiksZSkpO3ZvaWQgMCE9PXUmJmEuYWRkT3AodnQsWyJPQyIsdV0pO2NvbnN0IGY9Yy5nZXQoIkdyb3VwIik7aWYoZil7ZD17bWF0cml4OmwsYmJveDpoLHNtYXNrOnIsaXNvbGF0ZWQ6ITEsa25vY2tvdXQ6ITF9O2xldCB0PW51bGw7aWYoaXNOYW1lKGYuZ2V0KCJTIiksIlRyYW5zcGFyZW5jeSIpKXtkLmlzb2xhdGVkPWYuZ2V0KCJJIil8fCExO2Qua25vY2tvdXQ9Zi5nZXQoIksiKXx8ITE7aWYoZi5oYXMoIkNTIikpe2NvbnN0IHI9dGhpcy5fZ2V0Q29sb3JTcGFjZShmLmdldFJhdygiQ1MiKSxlLHMpO3Q9ciBpbnN0YW5jZW9mIENvbG9yU3BhY2U/cjphd2FpdCB0aGlzLl9oYW5kbGVDb2xvclNwYWNlKHIpfX1pZihyPy5iYWNrZHJvcCl7dHx8PUNvbG9yU3BhY2VVdGlscy5yZ2I7ci5iYWNrZHJvcD10LmdldFJnYkhleChyLmJhY2tkcm9wLDApfWEuYWRkT3AoRHQsW2RdKX1jb25zdCBnPVtsJiZuZXcgRmxvYXQzMkFycmF5KGwpLCFmJiZoJiZuZXcgRmxvYXQzMkFycmF5KGgpfHxudWxsXTthLmFkZE9wKE90LGcpO2NvbnN0IHA9Yy5nZXQoIlJlc291cmNlcyIpO2F3YWl0IHRoaXMuZ2V0T3BlcmF0b3JMaXN0KHtzdHJlYW06dCx0YXNrOm4scmVzb3VyY2VzOnAgaW5zdGFuY2VvZiBEaWN0P3A6ZSxvcGVyYXRvckxpc3Q6YSxpbml0aWFsU3RhdGU6aSxwcmV2UmVmczpvfSk7YS5hZGRPcChNdCxbXSk7ZiYmYS5hZGRPcChCdCxbZF0pO3ZvaWQgMCE9PXUmJmEuYWRkT3AoRnQsW10pfV9zZW5kSW1nRGF0YShlLHQscj0hMSl7Y29uc3QgYT10P1t0LmJpdG1hcHx8dC5kYXRhLmJ1ZmZlcl06bnVsbDtyZXR1cm4gdGhpcy5wYXJzaW5nVHlwZTNGb250fHxyP3RoaXMuaGFuZGxlci5zZW5kKCJjb21tb25vYmoiLFtlLCJJbWFnZSIsdF0sYSk6dGhpcy5oYW5kbGVyLnNlbmQoIm9iaiIsW2UsdGhpcy5wYWdlSW5kZXgsIkltYWdlIix0XSxhKX1hc3luYyBidWlsZFBhaW50SW1hZ2VYT2JqZWN0KHtyZXNvdXJjZXM6ZSxpbWFnZTp0LGlzSW5saW5lOnI9ITEsb3BlcmF0b3JMaXN0OmEsY2FjaGVLZXk6bixsb2NhbEltYWdlQ2FjaGU6aSxsb2NhbENvbG9yU3BhY2VDYWNoZTpzfSl7Y29uc3R7bWF4SW1hZ2VTaXplOm8saWdub3JlRXJyb3JzOmMsaXNPZmZzY3JlZW5DYW52YXNTdXBwb3J0ZWQ6bH09dGhpcy5vcHRpb25zLHtkaWN0Omh9PXQsdT1oLm9iaklkLGQ9aC5nZXQoIlciLCJXaWR0aCIpLGY9aC5nZXQoIkgiLCJIZWlnaHQiKTtpZighZHx8Im51bWJlciIhPXR5cGVvZiBkfHwhZnx8Im51bWJlciIhPXR5cGVvZiBmKXt3YXJuKCJJbWFnZSBkaW1lbnNpb25zIGFyZSBtaXNzaW5nLCBvciBub3QgbnVtYmVycy4iKTtyZXR1cm59aWYoLTEhPT1vJiZkKmY+byl7Y29uc3QgZT0iSW1hZ2UgZXhjZWVkZWQgbWF4aW11bSBhbGxvd2VkIHNpemUgYW5kIHdhcyByZW1vdmVkLiI7aWYoIWMpdGhyb3cgbmV3IEVycm9yKGUpO3dhcm4oZSk7cmV0dXJufWxldCBnO2guaGFzKCJPQyIpJiYoZz1hd2FpdCB0aGlzLnBhcnNlTWFya2VkQ29udGVudFByb3BzKGguZ2V0KCJPQyIpLGUpKTtsZXQgcCxtLGI7aWYoaC5nZXQoIklNIiwiSW1hZ2VNYXNrIil8fCExKXtwPWF3YWl0IFBERkltYWdlLmNyZWF0ZU1hc2soe2ltYWdlOnQsaXNPZmZzY3JlZW5DYW52YXNTdXBwb3J0ZWQ6bCYmIXRoaXMucGFyc2luZ1R5cGUzRm9udH0pO2lmKHAuaXNTaW5nbGVPcGFxdWVQaXhlbCl7bT1YdDtiPVtdO2EuYWRkSW1hZ2VPcHMobSxiLGcpO2lmKG4pe2NvbnN0IGU9e2ZuOm0sYXJnczpiLG9wdGlvbmFsQ29udGVudDpnfTtpLnNldChuLHUsZSk7dSYmdGhpcy5fcmVnaW9uYWxJbWFnZUNhY2hlLnNldChudWxsLHUsZSl9cmV0dXJufWlmKHRoaXMucGFyc2luZ1R5cGUzRm9udCl7Yj1mdW5jdGlvbiBjb21waWxlVHlwZTNHbHlwaCh7ZGF0YTplLHdpZHRoOnQsaGVpZ2h0OnJ9KXtpZih0PjFlM3x8cj4xZTMpcmV0dXJuIG51bGw7Y29uc3QgYT1uZXcgVWludDhBcnJheShbMCwyLDQsMCwxLDAsNSw0LDgsMTAsMCw4LDAsMiwxLDBdKSxuPXQrMSxpPW5ldyBVaW50OEFycmF5KG4qKHIrMSkpO2xldCBzLG8sYztjb25zdCBsPXQrNyYtOCxoPW5ldyBVaW50OEFycmF5KGwqcik7bGV0IHU9MDtmb3IoY29uc3QgdCBvZiBlKXtsZXQgZT0xMjg7Zm9yKDtlPjA7KXtoW3UrK109dCZlPzA6MjU1O2U+Pj0xfX1sZXQgZD0wO3U9MDtpZigwIT09aFt1XSl7aVswXT0xOysrZH1mb3Iobz0xO288dDtvKyspe2lmKGhbdV0hPT1oW3UrMV0pe2lbb109aFt1XT8yOjE7KytkfXUrK31pZigwIT09aFt1XSl7aVtvXT0yOysrZH1mb3Iocz0xO3M8cjtzKyspe3U9cypsO2M9cypuO2lmKGhbdS1sXSE9PWhbdV0pe2lbY109aFt1XT8xOjg7KytkfWxldCBlPShoW3VdPzQ6MCkrKGhbdS1sXT84OjApO2ZvcihvPTE7bzx0O28rKyl7ZT0oZT4+MikrKGhbdSsxXT80OjApKyhoW3UtbCsxXT84OjApO2lmKGFbZV0pe2lbYytvXT1hW2VdOysrZH11Kyt9aWYoaFt1LWxdIT09aFt1XSl7aVtjK29dPWhbdV0/Mjo0OysrZH1pZihkPjFlMylyZXR1cm4gbnVsbH11PWwqKHItMSk7Yz1zKm47aWYoMCE9PWhbdV0pe2lbY109ODsrK2R9Zm9yKG89MTtvPHQ7bysrKXtpZihoW3VdIT09aFt1KzFdKXtpW2Mrb109aFt1XT80Ojg7KytkfXUrK31pZigwIT09aFt1XSl7aVtjK29dPTQ7KytkfWlmKGQ+MWUzKXJldHVybiBudWxsO2NvbnN0IGY9bmV3IEludDMyQXJyYXkoWzAsbiwtMSwwLC1uLDAsMCwwLDFdKSxnPVtdLHthOnAsYjptLGM6YixkOnksZTp3LGY6eH09KG5ldyBET01NYXRyaXgpLnNjYWxlU2VsZigxL3QsLTEvcikudHJhbnNsYXRlU2VsZigwLC1yKTtmb3Iocz0wO2QmJnM8PXI7cysrKXtsZXQgZT1zKm47Y29uc3Qgcj1lK3Q7Zm9yKDtlPHImJiFpW2VdOyllKys7aWYoZT09PXIpY29udGludWU7bGV0IGE9ZSVuLG89cztnLnB1c2goJHQscCphK2Iqbyt3LG0qYSt5Km8reCk7Y29uc3QgYz1lO2xldCBsPWlbZV07ZG97Y29uc3QgdD1mW2xdO2Rve2UrPXR9d2hpbGUoIWlbZV0pO2NvbnN0IHI9aVtlXTtpZig1IT09ciYmMTAhPT1yKXtsPXI7aVtlXT0wfWVsc2V7bD1yJjUxKmw+PjQ7aVtlXSY9bD4+MnxsPDwyfWE9ZSVuO289ZS9ufDA7Zy5wdXNoKFZ0LHAqYStiKm8rdyxtKmEreSpvK3gpO2lbZV18fC0tZH13aGlsZShjIT09ZSk7LS1zfXJldHVybltHdCxbbmV3IEZsb2F0MzJBcnJheShnKV0sbmV3IEZsb2F0MzJBcnJheShbMCwwLHQscl0pXX0ocCk7aWYoYil7YS5hZGRJbWFnZU9wcyhIdCxiLGcpO3JldHVybn13YXJuKCJDYW5ub3QgY29tcGlsZSBUeXBlMyBnbHlwaC4iKTthLmFkZEltYWdlT3BzKE50LFtwXSxnKTtyZXR1cm59Y29uc3QgZT1gbWFza18ke3RoaXMuaWRGYWN0b3J5LmNyZWF0ZU9iaklkKCl9YDthLmFkZERlcGVuZGVuY3koZSk7cC5kYXRhTGVuPXAuYml0bWFwP3Aud2lkdGgqcC5oZWlnaHQqNDpwLmRhdGEubGVuZ3RoO3RoaXMuX3NlbmRJbWdEYXRhKGUscCk7bT1OdDtiPVt7ZGF0YTplLHdpZHRoOnAud2lkdGgsaGVpZ2h0OnAuaGVpZ2h0LGludGVycG9sYXRlOnAuaW50ZXJwb2xhdGUsY291bnQ6MX1dO2EuYWRkSW1hZ2VPcHMobSxiLGcpO2lmKG4pe2NvbnN0IHQ9e29iaklkOmUsZm46bSxhcmdzOmIsb3B0aW9uYWxDb250ZW50Omd9O2kuc2V0KG4sdSx0KTt1JiZ0aGlzLl9yZWdpb25hbEltYWdlQ2FjaGUuc2V0KG51bGwsdSx0KX1yZXR1cm59Y29uc3QgeT1oLmhhcygiU01hc2siKXx8aC5oYXMoIk1hc2siKTtpZihyJiZkK2Y8MjAwJiYheSl7dHJ5e2NvbnN0IG49bmV3IFBERkltYWdlKHt4cmVmOnRoaXMueHJlZixyZXM6ZSxpbWFnZTp0LGlzSW5saW5lOnIscGRmRnVuY3Rpb25GYWN0b3J5OnRoaXMuX3BkZkZ1bmN0aW9uRmFjdG9yeSxnbG9iYWxDb2xvclNwYWNlQ2FjaGU6dGhpcy5nbG9iYWxDb2xvclNwYWNlQ2FjaGUsbG9jYWxDb2xvclNwYWNlQ2FjaGU6c30pO3A9YXdhaXQgbi5jcmVhdGVJbWFnZURhdGEoITAsITEpO2EuYWRkSW1hZ2VPcHMoTHQsW3BdLGcpfWNhdGNoKGUpe2NvbnN0IHQ9YFVuYWJsZSB0byBkZWNvZGUgaW5saW5lIGltYWdlOiAiJHtlfSIuYDtpZighYyl0aHJvdyBuZXcgRXJyb3IodCk7d2Fybih0KX1yZXR1cm59bGV0IHc9YGltZ18ke3RoaXMuaWRGYWN0b3J5LmNyZWF0ZU9iaklkKCl9YCx4PSExLFM9bnVsbDtpZih0aGlzLnBhcnNpbmdUeXBlM0ZvbnQpdz1gJHt0aGlzLmlkRmFjdG9yeS5nZXREb2NJZCgpfV90eXBlM18ke3d9YDtlbHNlIGlmKG4mJnUpe3g9dGhpcy5nbG9iYWxJbWFnZUNhY2hlLnNob3VsZENhY2hlKHUsdGhpcy5wYWdlSW5kZXgpO2lmKHgpe2Fzc2VydCghciwiQ2Fubm90IGNhY2hlIGFuIGlubGluZSBpbWFnZSBnbG9iYWxseS4iKTt3PWAke3RoaXMuaWRGYWN0b3J5LmdldERvY0lkKCl9XyR7d31gfX1hLmFkZERlcGVuZGVuY3kodyk7bT1fdDtiPVt3LGQsZl07YS5hZGRJbWFnZU9wcyhtLGIsZyx5KTtpZih4KXtTPXtvYmpJZDp3LGZuOm0sYXJnczpiLG9wdGlvbmFsQ29udGVudDpnLGhhc01hc2s6eSxieXRlU2l6ZTowfTtpZih0aGlzLmdsb2JhbEltYWdlQ2FjaGUuaGFzRGVjb2RlRmFpbGVkKHUpKXt0aGlzLmdsb2JhbEltYWdlQ2FjaGUuc2V0RGF0YSh1LFMpO3RoaXMuX3NlbmRJbWdEYXRhKHcsbnVsbCx4KTtyZXR1cm59aWYoZCpmPjI1ZTR8fHkpe2NvbnN0IGU9YXdhaXQgdGhpcy5oYW5kbGVyLnNlbmRXaXRoUHJvbWlzZSgiY29tbW9ub2JqIixbdywiQ29weUxvY2FsSW1hZ2UiLHtpbWFnZVJlZjp1fV0pO2lmKGUpe3RoaXMuZ2xvYmFsSW1hZ2VDYWNoZS5zZXREYXRhKHUsUyk7dGhpcy5nbG9iYWxJbWFnZUNhY2hlLmFkZEJ5dGVTaXplKHUsZSk7cmV0dXJufX19UERGSW1hZ2UuYnVpbGRJbWFnZSh7eHJlZjp0aGlzLnhyZWYscmVzOmUsaW1hZ2U6dCxpc0lubGluZTpyLHBkZkZ1bmN0aW9uRmFjdG9yeTp0aGlzLl9wZGZGdW5jdGlvbkZhY3RvcnksZ2xvYmFsQ29sb3JTcGFjZUNhY2hlOnRoaXMuZ2xvYmFsQ29sb3JTcGFjZUNhY2hlLGxvY2FsQ29sb3JTcGFjZUNhY2hlOnN9KS50aGVuKGFzeW5jIGU9PntwPWF3YWl0IGUuY3JlYXRlSW1hZ2VEYXRhKCExLGwpO3AuZGF0YUxlbj1wLmJpdG1hcD9wLndpZHRoKnAuaGVpZ2h0KjQ6cC5kYXRhLmxlbmd0aDtwLnJlZj11O3gmJnRoaXMuZ2xvYmFsSW1hZ2VDYWNoZS5hZGRCeXRlU2l6ZSh1LHAuZGF0YUxlbik7cmV0dXJuIHRoaXMuX3NlbmRJbWdEYXRhKHcscCx4KX0pLmNhdGNoKGU9Pnt3YXJuKGBVbmFibGUgdG8gZGVjb2RlIGltYWdlICIke3d9IjogIiR7ZX0iLmApO3UmJnRoaXMuZ2xvYmFsSW1hZ2VDYWNoZS5hZGREZWNvZGVGYWlsZWQodSk7cmV0dXJuIHRoaXMuX3NlbmRJbWdEYXRhKHcsbnVsbCx4KX0pO2lmKG4pe2NvbnN0IGU9e29iaklkOncsZm46bSxhcmdzOmIsb3B0aW9uYWxDb250ZW50OmcsaGFzTWFzazp5fTtpLnNldChuLHUsZSk7aWYodSl7dGhpcy5fcmVnaW9uYWxJbWFnZUNhY2hlLnNldChudWxsLHUsZSk7aWYoeCl7YXNzZXJ0KFMsIlRoZSBnbG9iYWwgY2FjaGUtZGF0YSBtdXN0IGJlIGF2YWlsYWJsZS4iKTt0aGlzLmdsb2JhbEltYWdlQ2FjaGUuc2V0RGF0YSh1LFMpfX19fWhhbmRsZVNNYXNrKGUsdCxyLGEsbixpLHMpe2NvbnN0IG89ZS5nZXQoIkciKSxjPXtzdWJ0eXBlOmUuZ2V0KCJTIikubmFtZSxiYWNrZHJvcDplLmdldCgiQkMiKX0sbD1lLmdldCgiVFIiKTtpZihpc1BERkZ1bmN0aW9uKGwpKXtjb25zdCBlPXRoaXMuX3BkZkZ1bmN0aW9uRmFjdG9yeS5jcmVhdGUobCksdD1uZXcgVWludDhBcnJheSgyNTYpLHI9bmV3IEZsb2F0MzJBcnJheSgxKTtmb3IobGV0IGE9MDthPDI1NjthKyspe3JbMF09YS8yNTU7ZShyLDAsciwwKTt0W2FdPTI1NSpyWzBdfDB9Yy50cmFuc2Zlck1hcD10fXJldHVybiB0aGlzLmJ1aWxkRm9ybVhPYmplY3QodCxvLGMscixhLG4uc3RhdGUuY2xvbmUoe25ld1BhdGg6ITB9KSxpLHMpfWhhbmRsZVRyYW5zZmVyRnVuY3Rpb24oZSl7bGV0IHQ7aWYoQXJyYXkuaXNBcnJheShlKSl0PWU7ZWxzZXtpZighaXNQREZGdW5jdGlvbihlKSlyZXR1cm4gbnVsbDt0PVtlXX1jb25zdCByPVtdO2xldCBhPTAsbj0wO2Zvcihjb25zdCBlIG9mIHQpe2NvbnN0IHQ9dGhpcy54cmVmLmZldGNoSWZSZWYoZSk7YSsrO2lmKGlzTmFtZSh0LCJJZGVudGl0eSIpKXtyLnB1c2gobnVsbCk7Y29udGludWV9aWYoIWlzUERGRnVuY3Rpb24odCkpcmV0dXJuIG51bGw7Y29uc3QgaT10aGlzLl9wZGZGdW5jdGlvbkZhY3RvcnkuY3JlYXRlKHQpLHM9bmV3IFVpbnQ4QXJyYXkoMjU2KSxvPW5ldyBGbG9hdDMyQXJyYXkoMSk7Zm9yKGxldCBlPTA7ZTwyNTY7ZSsrKXtvWzBdPWUvMjU1O2kobywwLG8sMCk7c1tlXT0yNTUqb1swXXwwfXIucHVzaChzKTtuKyt9cmV0dXJuIDEhPT1hJiY0IT09YXx8MD09PW4/bnVsbDpyfWhhbmRsZVRpbGluZ1R5cGUoZSx0LHIsYSxuLGkscyxvKXtjb25zdCBjPW5ldyBPcGVyYXRvckxpc3QsbD1EaWN0Lm1lcmdlKHt4cmVmOnRoaXMueHJlZixkaWN0QXJyYXk6W24uZ2V0KCJSZXNvdXJjZXMiKSxyXX0pO3JldHVybiB0aGlzLmdldE9wZXJhdG9yTGlzdCh7c3RyZWFtOmEsdGFzazpzLHJlc291cmNlczpsLG9wZXJhdG9yTGlzdDpjfSkudGhlbihmdW5jdGlvbigpe2NvbnN0IHI9Yy5nZXRJUigpLGE9Z2V0VGlsaW5nUGF0dGVybklSKHIsbix0KTtpLmFkZERlcGVuZGVuY2llcyhjLmRlcGVuZGVuY2llcyk7aS5hZGRPcChlLGEpO24ub2JqSWQmJm8uc2V0KG51bGwsbi5vYmpJZCx7b3BlcmF0b3JMaXN0SVI6cixkaWN0Om59KX0pLmNhdGNoKGU9PntpZighKGUgaW5zdGFuY2VvZiBBYm9ydEV4Y2VwdGlvbikpe2lmKCF0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzKXRocm93IGU7d2FybihgaGFuZGxlVGlsaW5nVHlwZSAtIGlnbm9yaW5nIHBhdHRlcm46ICIke2V9Ii5gKX19KX1hc3luYyBoYW5kbGVTZXRGb250KGUsdCxyLGEsbixpLHM9bnVsbCxvPW51bGwpe2NvbnN0IGM9dD8uWzBdaW5zdGFuY2VvZiBOYW1lP3RbMF0ubmFtZTpudWxsLGw9YXdhaXQgdGhpcy5sb2FkRm9udChjLHIsZSxuLHMsbyk7bC5mb250LmlzVHlwZTNGb250JiZhLmFkZERlcGVuZGVuY2llcyhsLnR5cGUzRGVwZW5kZW5jaWVzKTtpLmZvbnQ9bC5mb250O2wuc2VuZCh0aGlzLmhhbmRsZXIpO3JldHVybiBsLmxvYWRlZE5hbWV9aGFuZGxlVGV4dChlLHQpe2NvbnN0IHI9dC5mb250LGE9ci5jaGFyc1RvR2x5cGhzKGUpO2lmKHIuZGF0YSl7KCEhKHQudGV4dFJlbmRlcmluZ01vZGUmQyl8fCJQYXR0ZXJuIj09PXQuZmlsbENvbG9yU3BhY2UubmFtZXx8ci5kaXNhYmxlRm9udEZhY2UpJiZQYXJ0aWFsRXZhbHVhdG9yLmJ1aWxkRm9udFBhdGhzKHIsYSx0aGlzLmhhbmRsZXIsdGhpcy5vcHRpb25zKX1yZXR1cm4gYX1lbnN1cmVTdGF0ZUZvbnQoZSl7aWYoZS5mb250KXJldHVybjtjb25zdCB0PW5ldyBGb3JtYXRFcnJvcigiTWlzc2luZyBzZXRGb250IChUZikgb3BlcmF0b3IgYmVmb3JlIHRleHQgcmVuZGVyaW5nIG9wZXJhdG9yLiIpO2lmKCF0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzKXRocm93IHQ7d2FybihgZW5zdXJlU3RhdGVGb250OiAiJHt0fSIuYCl9YXN5bmMgc2V0R1N0YXRlKHtyZXNvdXJjZXM6ZSxnU3RhdGU6dCxvcGVyYXRvckxpc3Q6cixjYWNoZUtleTphLHRhc2s6bixzdGF0ZU1hbmFnZXI6aSxsb2NhbEdTdGF0ZUNhY2hlOnMsbG9jYWxDb2xvclNwYWNlQ2FjaGU6byxzZWVuUmVmczpjfSl7Y29uc3QgbD10Lm9iaklkO2xldCBoPSEwO2NvbnN0IHU9W107bGV0IGQ9UHJvbWlzZS5yZXNvbHZlKCk7Zm9yKGNvbnN0W2Esc11vZiB0KXN3aXRjaChhKXtjYXNlIlR5cGUiOmJyZWFrO2Nhc2UiTFciOmlmKCJudW1iZXIiIT10eXBlb2Ygcyl7d2FybihgSW52YWxpZCBMVyAobGluZSB3aWR0aCk6ICR7c31gKTticmVha311LnB1c2goW2EsTWF0aC5hYnMocyldKTticmVhaztjYXNlIkxDIjpjYXNlIkxKIjpjYXNlIk1MIjpjYXNlIkQiOmNhc2UiUkkiOmNhc2UiRkwiOmNhc2UiQ0EiOmNhc2UiY2EiOnUucHVzaChbYSxzXSk7YnJlYWs7Y2FzZSJGb250IjpoPSExO2Q9ZC50aGVuKCgpPT50aGlzLmhhbmRsZVNldEZvbnQoZSxudWxsLHNbMF0scixuLGkuc3RhdGUpLnRoZW4oZnVuY3Rpb24oZSl7ci5hZGREZXBlbmRlbmN5KGUpO3UucHVzaChbYSxbZSxzWzFdXV0pfSkpO2JyZWFrO2Nhc2UiQk0iOnUucHVzaChbYSxub3JtYWxpemVCbGVuZE1vZGUocyldKTticmVhaztjYXNlIlNNYXNrIjppZihpc05hbWUocywiTm9uZSIpKXt1LnB1c2goW2EsITFdKTticmVha31pZihzIGluc3RhbmNlb2YgRGljdCl7aD0hMTtkPWQudGhlbigoKT0+dGhpcy5oYW5kbGVTTWFzayhzLGUscixuLGksbyxjKSk7dS5wdXNoKFthLCEwXSl9ZWxzZSB3YXJuKCJVbnN1cHBvcnRlZCBTTWFzayB0eXBlIik7YnJlYWs7Y2FzZSJUUiI6Y29uc3QgdD10aGlzLmhhbmRsZVRyYW5zZmVyRnVuY3Rpb24ocyk7dS5wdXNoKFthLHRdKTticmVhaztjYXNlIk9QIjpjYXNlIm9wIjpjYXNlIk9QTSI6Y2FzZSJCRyI6Y2FzZSJCRzIiOmNhc2UiVUNSIjpjYXNlIlVDUjIiOmNhc2UiVFIyIjpjYXNlIkhUIjpjYXNlIlNNIjpjYXNlIlNBIjpjYXNlIkFJUyI6Y2FzZSJUSyI6aW5mbygiZ3JhcGhpYyBzdGF0ZSBvcGVyYXRvciAiK2EpO2JyZWFrO2RlZmF1bHQ6aW5mbygiVW5rbm93biBncmFwaGljIHN0YXRlIG9wZXJhdG9yICIrYSl9YXdhaXQgZDt1Lmxlbmd0aD4wJiZyLmFkZE9wKGJlLFt1XSk7aCYmcy5zZXQoYSxsLHUpfWxvYWRGb250KGUsdCxyLGEsbj1udWxsLGk9bnVsbCl7Y29uc3QgZXJyb3JGb250PWFzeW5jKCk9Pm5ldyBUcmFuc2xhdGVkRm9udCh7bG9hZGVkTmFtZToiZ19mb250X2Vycm9yIixmb250Om5ldyBFcnJvckZvbnQoYEZvbnQgIiR7ZX0iIGlzIG5vdCBhdmFpbGFibGUuYCksZGljdDp0fSk7bGV0IHM7aWYodCl0IGluc3RhbmNlb2YgUmVmJiYocz10KTtlbHNle2NvbnN0IHQ9ci5nZXQoIkZvbnQiKTt0JiYocz10LmdldFJhdyhlKSl9aWYocyl7aWYodGhpcy50eXBlM0ZvbnRSZWZzPy5oYXMocykpcmV0dXJuIGVycm9yRm9udCgpO2lmKHRoaXMuZm9udENhY2hlLmhhcyhzKSlyZXR1cm4gdGhpcy5mb250Q2FjaGUuZ2V0KHMpO3RyeXt0PXRoaXMueHJlZi5mZXRjaElmUmVmKHMpfWNhdGNoKGUpe3dhcm4oYGxvYWRGb250IC0gbG9va3VwIGZhaWxlZDogIiR7ZX0iLmApfX1pZighKHQgaW5zdGFuY2VvZiBEaWN0KSl7aWYoIXRoaXMub3B0aW9ucy5pZ25vcmVFcnJvcnMmJiF0aGlzLnBhcnNpbmdUeXBlM0ZvbnQpe3dhcm4oYEZvbnQgIiR7ZX0iIGlzIG5vdCBhdmFpbGFibGUuYCk7cmV0dXJuIGVycm9yRm9udCgpfXdhcm4oYEZvbnQgIiR7ZX0iIGlzIG5vdCBhdmFpbGFibGUgLS0gYXR0ZW1wdGluZyB0byBmYWxsYmFjayB0byBhIGRlZmF1bHQgZm9udC5gKTt0PW58fFBhcnRpYWxFdmFsdWF0b3IuZmFsbGJhY2tGb250RGljdH1pZih0LmNhY2hlS2V5JiZ0aGlzLmZvbnRDYWNoZS5oYXModC5jYWNoZUtleSkpcmV0dXJuIHRoaXMuZm9udENhY2hlLmdldCh0LmNhY2hlS2V5KTtjb25zdHtwcm9taXNlOm8scmVzb2x2ZTpjfT1Qcm9taXNlLndpdGhSZXNvbHZlcnMoKTtsZXQgbDt0cnl7bD10aGlzLnByZUV2YWx1YXRlRm9udCh0KTtsLmNzc0ZvbnRJbmZvPWl9Y2F0Y2goZSl7d2FybihgbG9hZEZvbnQgLSBwcmVFdmFsdWF0ZUZvbnQgZmFpbGVkOiAiJHtlfSIuYCk7cmV0dXJuIGVycm9yRm9udCgpfWNvbnN0e2Rlc2NyaXB0b3I6aCxoYXNoOnV9PWwsZD1zIGluc3RhbmNlb2YgUmVmO2xldCBmO2lmKHUmJmggaW5zdGFuY2VvZiBEaWN0KXtjb25zdCBlPWguZm9udEFsaWFzZXN8fD1PYmplY3QuY3JlYXRlKG51bGwpO2lmKGVbdV0pe2NvbnN0IHQ9ZVt1XS5hbGlhc1JlZjtpZihkJiZ0JiZ0aGlzLmZvbnRDYWNoZS5oYXModCkpe3RoaXMuZm9udENhY2hlLnB1dEFsaWFzKHMsdCk7cmV0dXJuIHRoaXMuZm9udENhY2hlLmdldChzKX19ZWxzZSBlW3VdPXtmb250SUQ6dGhpcy5pZEZhY3RvcnkuY3JlYXRlRm9udElkKCl9O2QmJihlW3VdLmFsaWFzUmVmPXMpO2Y9ZVt1XS5mb250SUR9ZWxzZSBmPXRoaXMuaWRGYWN0b3J5LmNyZWF0ZUZvbnRJZCgpO2Fzc2VydChmPy5zdGFydHNXaXRoKCJmIiksJ1RoZSAiZm9udElEIiBtdXN0IGJlIChjb3JyZWN0bHkpIGRlZmluZWQuJyk7aWYoZCl0aGlzLmZvbnRDYWNoZS5wdXQocyxvKTtlbHNle3QuY2FjaGVLZXk9YGNhY2hlS2V5XyR7Zn1gO3RoaXMuZm9udENhY2hlLnB1dCh0LmNhY2hlS2V5LG8pfXQubG9hZGVkTmFtZT1gJHt0aGlzLmlkRmFjdG9yeS5nZXREb2NJZCgpfV8ke2Z9YDt0aGlzLnRyYW5zbGF0ZUZvbnQobCkudGhlbihhc3luYyBlPT57Y29uc3Qgbj1uZXcgVHJhbnNsYXRlZEZvbnQoe2xvYWRlZE5hbWU6dC5sb2FkZWROYW1lLGZvbnQ6ZSxkaWN0OnR9KTtpZihlLmlzVHlwZTNGb250KXRyeXthd2FpdCBuLmxvYWRUeXBlM0RhdGEodGhpcyxyLGEpfWNhdGNoKGUpe3Rocm93IG5ldyBFcnJvcihgVHlwZTMgZm9udCBsb2FkIGVycm9yOiAke2V9YCl9YyhuKX0pLmNhdGNoKGU9Pnt3YXJuKGBsb2FkRm9udCAtIHRyYW5zbGF0ZUZvbnQgZmFpbGVkOiAiJHtlfSIuYCk7YyhuZXcgVHJhbnNsYXRlZEZvbnQoe2xvYWRlZE5hbWU6dC5sb2FkZWROYW1lLGZvbnQ6bmV3IEVycm9yRm9udChlPy5tZXNzYWdlKSxkaWN0OnR9KSl9KTtyZXR1cm4gb31idWlsZFBhdGgoZSx0LHIpe2NvbnN0e3BhdGhNaW5NYXg6YSxwYXRoQnVmZmVyOm59PXI7c3dpdGNoKDB8ZSl7Y2FzZSBJZTp7Y29uc3QgZT1yLmN1cnJlbnRQb2ludFg9dFswXSxpPXIuY3VycmVudFBvaW50WT10WzFdLHM9dFsyXSxvPXRbM10sYz1lK3MsbD1pK287MD09PXN8fDA9PT1vP24ucHVzaCgkdCxlLGksVnQsYyxsLEp0KTpuLnB1c2goJHQsZSxpLFZ0LGMsaSxWdCxjLGwsVnQsZSxsLEp0KTtVdGlsLnJlY3RCb3VuZGluZ0JveChlLGksYyxsLGEpO2JyZWFrfWNhc2UgU2U6e2NvbnN0IGU9ci5jdXJyZW50UG9pbnRYPXRbMF0saT1yLmN1cnJlbnRQb2ludFk9dFsxXTtuLnB1c2goJHQsZSxpKTtVdGlsLnBvaW50Qm91bmRpbmdCb3goZSxpLGEpO2JyZWFrfWNhc2UgQWU6e2NvbnN0IGU9ci5jdXJyZW50UG9pbnRYPXRbMF0saT1yLmN1cnJlbnRQb2ludFk9dFsxXTtuLnB1c2goVnQsZSxpKTtVdGlsLnBvaW50Qm91bmRpbmdCb3goZSxpLGEpO2JyZWFrfWNhc2Uga2U6e2NvbnN0IGU9ci5jdXJyZW50UG9pbnRYLGk9ci5jdXJyZW50UG9pbnRZLFtzLG8sYyxsLGgsdV09dDtyLmN1cnJlbnRQb2ludFg9aDtyLmN1cnJlbnRQb2ludFk9dTtuLnB1c2goS3QscyxvLGMsbCxoLHUpO1V0aWwuYmV6aWVyQm91bmRpbmdCb3goZSxpLHMsbyxjLGwsaCx1LGEpO2JyZWFrfWNhc2UgQ2U6e2NvbnN0IGU9ci5jdXJyZW50UG9pbnRYLGk9ci5jdXJyZW50UG9pbnRZLFtzLG8sYyxsXT10O3IuY3VycmVudFBvaW50WD1jO3IuY3VycmVudFBvaW50WT1sO24ucHVzaChLdCxlLGkscyxvLGMsbCk7VXRpbC5iZXppZXJCb3VuZGluZ0JveChlLGksZSxpLHMsbyxjLGwsYSk7YnJlYWt9Y2FzZSB2ZTp7Y29uc3QgZT1yLmN1cnJlbnRQb2ludFgsaT1yLmN1cnJlbnRQb2ludFksW3MsbyxjLGxdPXQ7ci5jdXJyZW50UG9pbnRYPWM7ci5jdXJyZW50UG9pbnRZPWw7bi5wdXNoKEt0LHMsbyxjLGwsYyxsKTtVdGlsLmJlemllckJvdW5kaW5nQm94KGUsaSxzLG8sYyxsLGMsbCxhKTticmVha31jYXNlIEZlOm4ucHVzaChKdCl9fV9nZXRDb2xvclNwYWNlKGUsdCxyKXtyZXR1cm4gQ29sb3JTcGFjZVV0aWxzLnBhcnNlKHtjczplLHhyZWY6dGhpcy54cmVmLHJlc291cmNlczp0LHBkZkZ1bmN0aW9uRmFjdG9yeTp0aGlzLl9wZGZGdW5jdGlvbkZhY3RvcnksZ2xvYmFsQ29sb3JTcGFjZUNhY2hlOnRoaXMuZ2xvYmFsQ29sb3JTcGFjZUNhY2hlLGxvY2FsQ29sb3JTcGFjZUNhY2hlOnIsYXN5bmNJZk5vdENhY2hlZDohMH0pfWFzeW5jIF9oYW5kbGVDb2xvclNwYWNlKGUpe3RyeXtyZXR1cm4gYXdhaXQgZX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgQWJvcnRFeGNlcHRpb24pcmV0dXJuIG51bGw7aWYodGhpcy5vcHRpb25zLmlnbm9yZUVycm9ycyl7d2FybihgX2hhbmRsZUNvbG9yU3BhY2UgLSBpZ25vcmluZyBDb2xvclNwYWNlOiAiJHtlfSIuYCk7cmV0dXJuIG51bGx9dGhyb3cgZX19cGFyc2VTaGFkaW5nKHtzaGFkaW5nOmUscmVzb3VyY2VzOnQsbG9jYWxDb2xvclNwYWNlQ2FjaGU6cixsb2NhbFNoYWRpbmdQYXR0ZXJuQ2FjaGU6YX0pe2xldCBuLGk9YS5nZXQoZSk7aWYoaSlyZXR1cm4gaTt0cnl7bj1QYXR0ZXJuLnBhcnNlU2hhZGluZyhlLHRoaXMueHJlZix0LHRoaXMuX3BkZkZ1bmN0aW9uRmFjdG9yeSx0aGlzLmdsb2JhbENvbG9yU3BhY2VDYWNoZSxyKS5nZXRJUigpfWNhdGNoKHQpe2lmKHQgaW5zdGFuY2VvZiBBYm9ydEV4Y2VwdGlvbilyZXR1cm4gbnVsbDtpZih0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzKXt3YXJuKGBwYXJzZVNoYWRpbmcgLSBpZ25vcmluZyBzaGFkaW5nOiAiJHt0fSIuYCk7YS5zZXQoZSxudWxsKTtyZXR1cm4gbnVsbH10aHJvdyB0fWk9YHBhdHRlcm5fJHt0aGlzLmlkRmFjdG9yeS5jcmVhdGVPYmpJZCgpfWA7dGhpcy5wYXJzaW5nVHlwZTNGb250JiYoaT1gJHt0aGlzLmlkRmFjdG9yeS5nZXREb2NJZCgpfV90eXBlM18ke2l9YCk7YS5zZXQoZSxpKTt0aGlzLnBhcnNpbmdUeXBlM0ZvbnQ/dGhpcy5oYW5kbGVyLnNlbmQoImNvbW1vbm9iaiIsW2ksIlBhdHRlcm4iLG5dKTp0aGlzLmhhbmRsZXIuc2VuZCgib2JqIixbaSx0aGlzLnBhZ2VJbmRleCwiUGF0dGVybiIsbl0pO3JldHVybiBpfWhhbmRsZUNvbG9yTihlLHQscixhLG4saSxzLG8sYyxsKXtjb25zdCBoPXIucG9wKCk7aWYoaCBpbnN0YW5jZW9mIE5hbWUpe2NvbnN0IHU9bi5nZXRSYXcoaC5uYW1lKSxkPXUgaW5zdGFuY2VvZiBSZWYmJmMuZ2V0QnlSZWYodSk7aWYoZCl0cnl7Y29uc3Qgbj1hLmJhc2U/YS5iYXNlLmdldFJnYkhleChyLDApOm51bGwsaT1nZXRUaWxpbmdQYXR0ZXJuSVIoZC5vcGVyYXRvckxpc3RJUixkLmRpY3Qsbik7ZS5hZGRPcCh0LGkpO3JldHVybn1jYXRjaHt9Y29uc3QgZj10aGlzLnhyZWYuZmV0Y2hJZlJlZih1KTtpZihmKXtjb25zdCBuPWYgaW5zdGFuY2VvZiBCYXNlU3RyZWFtP2YuZGljdDpmLGg9bi5nZXQoIlBhdHRlcm5UeXBlIik7aWYoaD09PXlpKXtjb25zdCBvPWEuYmFzZT9hLmJhc2UuZ2V0UmdiSGV4KHIsMCk6bnVsbDtyZXR1cm4gdGhpcy5oYW5kbGVUaWxpbmdUeXBlKHQsbyxpLGYsbixlLHMsYyl9aWYoaD09PXdpKXtjb25zdCByPW4uZ2V0KCJTaGFkaW5nIiksYT10aGlzLnBhcnNlU2hhZGluZyh7c2hhZGluZzpyLHJlc291cmNlczppLGxvY2FsQ29sb3JTcGFjZUNhY2hlOm8sbG9jYWxTaGFkaW5nUGF0dGVybkNhY2hlOmx9KTtpZihhKXtjb25zdCByPWxvb2t1cE1hdHJpeChuLmdldEFycmF5KCJNYXRyaXgiKSxudWxsKTtlLmFkZE9wKHQsWyJTaGFkaW5nIixhLHJdKX1yZXR1cm59dGhyb3cgbmV3IEZvcm1hdEVycm9yKGBVbmtub3duIFBhdHRlcm5UeXBlOiAke2h9YCl9fXRocm93IG5ldyBGb3JtYXRFcnJvcihgVW5rbm93biBQYXR0ZXJuTmFtZTogJHtofWApfV9wYXJzZVZpc2liaWxpdHlFeHByZXNzaW9uKGUsdCxyKXtpZigrK3Q+MTApe3dhcm4oIlZpc2liaWxpdHkgZXhwcmVzc2lvbiBpcyB0b28gZGVlcGx5IG5lc3RlZCIpO3JldHVybn1jb25zdCBhPWUubGVuZ3RoLG49dGhpcy54cmVmLmZldGNoSWZSZWYoZVswXSk7aWYoIShhPDIpJiZuIGluc3RhbmNlb2YgTmFtZSl7c3dpdGNoKG4ubmFtZSl7Y2FzZSJBbmQiOmNhc2UiT3IiOmNhc2UiTm90IjpyLnB1c2gobi5uYW1lKTticmVhaztkZWZhdWx0Ondhcm4oYEludmFsaWQgb3BlcmF0b3IgJHtuLm5hbWV9IGluIHZpc2liaWxpdHkgZXhwcmVzc2lvbmApO3JldHVybn1mb3IobGV0IG49MTtuPGE7bisrKXtjb25zdCBhPWVbbl0saT10aGlzLnhyZWYuZmV0Y2hJZlJlZihhKTtpZihBcnJheS5pc0FycmF5KGkpKXtjb25zdCBlPVtdO3IucHVzaChlKTt0aGlzLl9wYXJzZVZpc2liaWxpdHlFeHByZXNzaW9uKGksdCxlKX1lbHNlIGEgaW5zdGFuY2VvZiBSZWYmJnIucHVzaChhLnRvU3RyaW5nKCkpfX1lbHNlIHdhcm4oIkludmFsaWQgdmlzaWJpbGl0eSBleHByZXNzaW9uIil9YXN5bmMgcGFyc2VNYXJrZWRDb250ZW50UHJvcHMoZSx0KXtsZXQgcjtpZihlIGluc3RhbmNlb2YgTmFtZSl7cj10LmdldCgiUHJvcGVydGllcyIpLmdldChlLm5hbWUpfWVsc2V7aWYoIShlIGluc3RhbmNlb2YgRGljdCkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJPcHRpb25hbCBjb250ZW50IHByb3BlcnRpZXMgbWFsZm9ybWVkLiIpO3I9ZX1jb25zdCBhPXIuZ2V0KCJUeXBlIik/Lm5hbWU7aWYoIk9DRyI9PT1hKXJldHVybnt0eXBlOmEsaWQ6ci5vYmpJZH07aWYoIk9DTUQiPT09YSl7Y29uc3QgZT1yLmdldCgiVkUiKTtpZihBcnJheS5pc0FycmF5KGUpKXtjb25zdCB0PVtdO3RoaXMuX3BhcnNlVmlzaWJpbGl0eUV4cHJlc3Npb24oZSwwLHQpO2lmKHQubGVuZ3RoPjApcmV0dXJue3R5cGU6Ik9DTUQiLGV4cHJlc3Npb246dH19Y29uc3QgdD1yLmdldCgiT0NHcyIpO2lmKEFycmF5LmlzQXJyYXkodCl8fHQgaW5zdGFuY2VvZiBEaWN0KXtjb25zdCBlPVtdO2lmKEFycmF5LmlzQXJyYXkodCkpZm9yKGNvbnN0IHIgb2YgdCllLnB1c2goci50b1N0cmluZygpKTtlbHNlIGUucHVzaCh0Lm9iaklkKTtyZXR1cm57dHlwZTphLGlkczplLHBvbGljeTpyLmdldCgiUCIpaW5zdGFuY2VvZiBOYW1lP3IuZ2V0KCJQIikubmFtZTpudWxsLGV4cHJlc3Npb246bnVsbH19aWYodCBpbnN0YW5jZW9mIFJlZilyZXR1cm57dHlwZTphLGlkOnQudG9TdHJpbmcoKX19cmV0dXJuIG51bGx9Z2V0T3BlcmF0b3JMaXN0KHtzdHJlYW06ZSx0YXNrOnQscmVzb3VyY2VzOnIsb3BlcmF0b3JMaXN0OmEsaW5pdGlhbFN0YXRlOm49bnVsbCxmYWxsYmFja0ZvbnREaWN0Omk9bnVsbCxwcmV2UmVmczpzPW51bGx9KXtjb25zdCBvPWUuZGljdD8ub2JqSWQsYz1uZXcgUmVmU2V0KHMpO2lmKG8pe2lmKHM/LmhhcyhvKSl0aHJvdyBuZXcgRXJyb3IoYGdldE9wZXJhdG9yTGlzdCAtIGlnbm9yaW5nIGNpcmN1bGFyIHJlZmVyZW5jZTogJHtvfWApO2MucHV0KG8pfXJ8fD1EaWN0LmVtcHR5O258fD1uZXcgRXZhbFN0YXRlO2lmKCFhKXRocm93IG5ldyBFcnJvcignZ2V0T3BlcmF0b3JMaXN0OiBtaXNzaW5nICJvcGVyYXRvckxpc3QiIHBhcmFtZXRlcicpO2NvbnN0IGw9dGhpcyxoPXRoaXMueHJlZix1PW5ldyBMb2NhbEltYWdlQ2FjaGUsZD1uZXcgTG9jYWxDb2xvclNwYWNlQ2FjaGUsZj1uZXcgTG9jYWxHU3RhdGVDYWNoZSxnPW5ldyBMb2NhbFRpbGluZ1BhdHRlcm5DYWNoZSxwPW5ldyBNYXAsbT1yLmdldCgiWE9iamVjdCIpfHxEaWN0LmVtcHR5LGI9ci5nZXQoIlBhdHRlcm4iKXx8RGljdC5lbXB0eSx5PW5ldyBTdGF0ZU1hbmFnZXIobiksdz1uZXcgRXZhbHVhdG9yUHJlcHJvY2Vzc29yKGUsaCx5KSx4PW5ldyBUaW1lU2xvdE1hbmFnZXI7ZnVuY3Rpb24gY2xvc2VQZW5kaW5nUmVzdG9yZU9QUyhlKXtmb3IobGV0IGU9MCx0PXcuc2F2ZWRTdGF0ZXNEZXB0aDtlPHQ7ZSsrKWEuYWRkT3Aod2UsW10pfXJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiBwcm9taXNlQm9keShlLG4pe2NvbnN0IG5leHQ9ZnVuY3Rpb24odCl7UHJvbWlzZS5hbGwoW3QsYS5yZWFkeV0pLnRoZW4oZnVuY3Rpb24oKXt0cnl7cHJvbWlzZUJvZHkoZSxuKX1jYXRjaChlKXtuKGUpfX0sbil9O3QuZW5zdXJlTm90VGVybWluYXRlZCgpO3gucmVzZXQoKTtjb25zdCBzPXt9O2xldCBvLFMsayxDLHYsVDtmb3IoOyEobz14LmNoZWNrKCkpOyl7cy5hcmdzPW51bGw7aWYoIXcucmVhZChzKSlicmVhaztsZXQgZT1zLmFyZ3Msbj1zLmZuO3N3aXRjaCgwfG4pe2Nhc2UgU3Q6VD1lWzBdaW5zdGFuY2VvZiBOYW1lO3Y9ZVswXS5uYW1lO2lmKFQpe2NvbnN0IHQ9dS5nZXRCeU5hbWUodik7aWYodCl7YWRkQ2FjaGVkSW1hZ2VPcHMoYSx0KTtlPW51bGw7Y29udGludWV9fW5leHQobmV3IFByb21pc2UoZnVuY3Rpb24oZSxuKXtpZighVCl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlhPYmplY3QgbXVzdCBiZSByZWZlcnJlZCB0byBieSBuYW1lLiIpO2xldCBpPW0uZ2V0UmF3KHYpO2lmKGkgaW5zdGFuY2VvZiBSZWYpe2NvbnN0IHQ9dS5nZXRCeVJlZihpKXx8bC5fcmVnaW9uYWxJbWFnZUNhY2hlLmdldEJ5UmVmKGkpfHxsLmdsb2JhbEltYWdlQ2FjaGUuZ2V0RGF0YShpLGwucGFnZUluZGV4KTtpZih0KXthZGRDYWNoZWRJbWFnZU9wcyhhLHQpO2UoKTtyZXR1cm59aT1oLmZldGNoKGkpfWlmKCEoaSBpbnN0YW5jZW9mIEJhc2VTdHJlYW0pKXRocm93IG5ldyBGb3JtYXRFcnJvcigiWE9iamVjdCBzaG91bGQgYmUgYSBzdHJlYW0iKTtjb25zdCBzPWkuZGljdC5nZXQoIlN1YnR5cGUiKTtpZighKHMgaW5zdGFuY2VvZiBOYW1lKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlhPYmplY3Qgc2hvdWxkIGhhdmUgYSBOYW1lIHN1YnR5cGUiKTtpZigiRm9ybSIhPT1zLm5hbWUpaWYoIkltYWdlIiE9PXMubmFtZSl7aWYoIlBTIiE9PXMubmFtZSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYFVuaGFuZGxlZCBYT2JqZWN0IHN1YnR5cGUgJHtzLm5hbWV9YCk7aW5mbygiSWdub3JlZCBYT2JqZWN0IHN1YnR5cGUgUFMiKTtlKCl9ZWxzZSBsLmJ1aWxkUGFpbnRJbWFnZVhPYmplY3Qoe3Jlc291cmNlczpyLGltYWdlOmksb3BlcmF0b3JMaXN0OmEsY2FjaGVLZXk6dixsb2NhbEltYWdlQ2FjaGU6dSxsb2NhbENvbG9yU3BhY2VDYWNoZTpkfSkudGhlbihlLG4pO2Vsc2V7eS5zYXZlKCk7bC5idWlsZEZvcm1YT2JqZWN0KHIsaSxudWxsLGEsdCx5LnN0YXRlLmNsb25lKHtuZXdQYXRoOiEwfSksZCxjKS50aGVuKGZ1bmN0aW9uKCl7eS5yZXN0b3JlKCk7ZSgpfSxuKX19KS5jYXRjaChmdW5jdGlvbihlKXtpZighKGUgaW5zdGFuY2VvZiBBYm9ydEV4Y2VwdGlvbikpe2lmKCFsLm9wdGlvbnMuaWdub3JlRXJyb3JzKXRocm93IGU7d2FybihgZ2V0T3BlcmF0b3JMaXN0IC0gaWdub3JpbmcgWE9iamVjdDogIiR7ZX0iLmApfX0pKTtyZXR1cm47Y2FzZSB6ZTpjb25zdCBzPWVbMV07bmV4dChsLmhhbmRsZVNldEZvbnQocixlLG51bGwsYSx0LHkuc3RhdGUsaSkudGhlbihmdW5jdGlvbihlKXthLmFkZERlcGVuZGVuY3koZSk7YS5hZGRPcCh6ZSxbZSxzXSl9KSk7cmV0dXJuO2Nhc2UgeHQ6Y29uc3Qgbz1lWzBdLmNhY2hlS2V5O2lmKG8pe2NvbnN0IHQ9dS5nZXRCeU5hbWUobyk7aWYodCl7YWRkQ2FjaGVkSW1hZ2VPcHMoYSx0KTtlPW51bGw7Y29udGludWV9fW5leHQobC5idWlsZFBhaW50SW1hZ2VYT2JqZWN0KHtyZXNvdXJjZXM6cixpbWFnZTplWzBdLGlzSW5saW5lOiEwLG9wZXJhdG9yTGlzdDphLGNhY2hlS2V5Om8sbG9jYWxJbWFnZUNhY2hlOnUsbG9jYWxDb2xvclNwYWNlQ2FjaGU6ZH0pKTtyZXR1cm47Y2FzZSBaZTppZigheS5zdGF0ZS5mb250KXtsLmVuc3VyZVN0YXRlRm9udCh5LnN0YXRlKTtjb250aW51ZX1lWzBdPWwuaGFuZGxlVGV4dChlWzBdLHkuc3RhdGUpO2JyZWFrO2Nhc2UgUWU6aWYoIXkuc3RhdGUuZm9udCl7bC5lbnN1cmVTdGF0ZUZvbnQoeS5zdGF0ZSk7Y29udGludWV9Y29uc3Qgdz1bXSx4PXkuc3RhdGU7Zm9yKGNvbnN0IHQgb2YgZVswXSkic3RyaW5nIj09dHlwZW9mIHQ/dy5wdXNoKC4uLmwuaGFuZGxlVGV4dCh0LHgpKToibnVtYmVyIj09dHlwZW9mIHQmJncucHVzaCh0KTtlWzBdPXc7bj1aZTticmVhaztjYXNlIGV0OmlmKCF5LnN0YXRlLmZvbnQpe2wuZW5zdXJlU3RhdGVGb250KHkuc3RhdGUpO2NvbnRpbnVlfWEuYWRkT3AoWWUpO2VbMF09bC5oYW5kbGVUZXh0KGVbMF0seS5zdGF0ZSk7bj1aZTticmVhaztjYXNlIHR0OmlmKCF5LnN0YXRlLmZvbnQpe2wuZW5zdXJlU3RhdGVGb250KHkuc3RhdGUpO2NvbnRpbnVlfWEuYWRkT3AoWWUpO2EuYWRkT3AoWGUsW2Uuc2hpZnQoKV0pO2EuYWRkT3AocWUsW2Uuc2hpZnQoKV0pO2VbMF09bC5oYW5kbGVUZXh0KGVbMF0seS5zdGF0ZSk7bj1aZTticmVhaztjYXNlIEdlOnkuc3RhdGUudGV4dFJlbmRlcmluZ01vZGU9ZVswXTticmVhaztjYXNlIHN0Ontjb25zdCB0PWwuX2dldENvbG9yU3BhY2UoZVswXSxyLGQpO2lmKHQgaW5zdGFuY2VvZiBDb2xvclNwYWNlKXt5LnN0YXRlLmZpbGxDb2xvclNwYWNlPXQ7Y29udGludWV9bmV4dChsLl9oYW5kbGVDb2xvclNwYWNlKHQpLnRoZW4oZT0+e3kuc3RhdGUuZmlsbENvbG9yU3BhY2U9ZXx8Q29sb3JTcGFjZVV0aWxzLmdyYXl9KSk7cmV0dXJufWNhc2UgaXQ6e2NvbnN0IHQ9bC5fZ2V0Q29sb3JTcGFjZShlWzBdLHIsZCk7aWYodCBpbnN0YW5jZW9mIENvbG9yU3BhY2Upe3kuc3RhdGUuc3Ryb2tlQ29sb3JTcGFjZT10O2NvbnRpbnVlfW5leHQobC5faGFuZGxlQ29sb3JTcGFjZSh0KS50aGVuKGU9Pnt5LnN0YXRlLnN0cm9rZUNvbG9yU3BhY2U9ZXx8Q29sb3JTcGFjZVV0aWxzLmdyYXl9KSk7cmV0dXJufWNhc2UgbHQ6Qz15LnN0YXRlLmZpbGxDb2xvclNwYWNlO2U9W0MuZ2V0UmdiSGV4KGUsMCldO249Z3Q7YnJlYWs7Y2FzZSBvdDpDPXkuc3RhdGUuc3Ryb2tlQ29sb3JTcGFjZTtlPVtDLmdldFJnYkhleChlLDApXTtuPWZ0O2JyZWFrO2Nhc2UgZHQ6eS5zdGF0ZS5maWxsQ29sb3JTcGFjZT1Db2xvclNwYWNlVXRpbHMuZ3JheTtlPVtDb2xvclNwYWNlVXRpbHMuZ3JheS5nZXRSZ2JIZXgoZSwwKV07bj1ndDticmVhaztjYXNlIHV0Onkuc3RhdGUuc3Ryb2tlQ29sb3JTcGFjZT1Db2xvclNwYWNlVXRpbHMuZ3JheTtlPVtDb2xvclNwYWNlVXRpbHMuZ3JheS5nZXRSZ2JIZXgoZSwwKV07bj1mdDticmVhaztjYXNlIG10Onkuc3RhdGUuZmlsbENvbG9yU3BhY2U9Q29sb3JTcGFjZVV0aWxzLmNteWs7ZT1bQ29sb3JTcGFjZVV0aWxzLmNteWsuZ2V0UmdiSGV4KGUsMCldO249Z3Q7YnJlYWs7Y2FzZSBwdDp5LnN0YXRlLnN0cm9rZUNvbG9yU3BhY2U9Q29sb3JTcGFjZVV0aWxzLmNteWs7ZT1bQ29sb3JTcGFjZVV0aWxzLmNteWsuZ2V0UmdiSGV4KGUsMCldO249ZnQ7YnJlYWs7Y2FzZSBndDp5LnN0YXRlLmZpbGxDb2xvclNwYWNlPUNvbG9yU3BhY2VVdGlscy5yZ2I7ZT1bQ29sb3JTcGFjZVV0aWxzLnJnYi5nZXRSZ2JIZXgoZSwwKV07YnJlYWs7Y2FzZSBmdDp5LnN0YXRlLnN0cm9rZUNvbG9yU3BhY2U9Q29sb3JTcGFjZVV0aWxzLnJnYjtlPVtDb2xvclNwYWNlVXRpbHMucmdiLmdldFJnYkhleChlLDApXTticmVhaztjYXNlIGh0OkM9eS5zdGF0ZS5wYXR0ZXJuRmlsbENvbG9yU3BhY2U7aWYoIUMpe2lmKGlzTnVtYmVyQXJyYXkoZSxudWxsKSl7ZT1bQ29sb3JTcGFjZVV0aWxzLmdyYXkuZ2V0UmdiSGV4KGUsMCldO249Z3Q7YnJlYWt9ZT1bXTtuPXp0O2JyZWFrfWlmKCJQYXR0ZXJuIj09PUMubmFtZSl7bmV4dChsLmhhbmRsZUNvbG9yTihhLGh0LGUsQyxiLHIsdCxkLGcscCkpO3JldHVybn1lPVtDLmdldFJnYkhleChlLDApXTtuPWd0O2JyZWFrO2Nhc2UgY3Q6Qz15LnN0YXRlLnBhdHRlcm5TdHJva2VDb2xvclNwYWNlO2lmKCFDKXtpZihpc051bWJlckFycmF5KGUsbnVsbCkpe2U9W0NvbG9yU3BhY2VVdGlscy5ncmF5LmdldFJnYkhleChlLDApXTtuPWZ0O2JyZWFrfWU9W107bj1XdDticmVha31pZigiUGF0dGVybiI9PT1DLm5hbWUpe25leHQobC5oYW5kbGVDb2xvck4oYSxjdCxlLEMsYixyLHQsZCxnLHApKTtyZXR1cm59ZT1bQy5nZXRSZ2JIZXgoZSwwKV07bj1mdDticmVhaztjYXNlIGJ0OmxldCBPO3RyeXtjb25zdCB0PXIuZ2V0KCJTaGFkaW5nIik7aWYoIXQpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJObyBzaGFkaW5nIHJlc291cmNlIGZvdW5kIik7Tz10LmdldChlWzBdLm5hbWUpO2lmKCFPKXRocm93IG5ldyBGb3JtYXRFcnJvcigiTm8gc2hhZGluZyBvYmplY3QgZm91bmQiKX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgQWJvcnRFeGNlcHRpb24pY29udGludWU7aWYobC5vcHRpb25zLmlnbm9yZUVycm9ycyl7d2FybihgZ2V0T3BlcmF0b3JMaXN0IC0gaWdub3JpbmcgU2hhZGluZzogIiR7ZX0iLmApO2NvbnRpbnVlfXRocm93IGV9Y29uc3QgTT1sLnBhcnNlU2hhZGluZyh7c2hhZGluZzpPLHJlc291cmNlczpyLGxvY2FsQ29sb3JTcGFjZUNhY2hlOmQsbG9jYWxTaGFkaW5nUGF0dGVybkNhY2hlOnB9KTtpZighTSljb250aW51ZTtlPVtNXTtuPWJ0O2JyZWFrO2Nhc2UgYmU6VD1lWzBdaW5zdGFuY2VvZiBOYW1lO3Y9ZVswXS5uYW1lO2lmKFQpe2NvbnN0IHQ9Zi5nZXRCeU5hbWUodik7aWYodCl7dC5sZW5ndGg+MCYmYS5hZGRPcChiZSxbdF0pO2U9bnVsbDtjb250aW51ZX19bmV4dChuZXcgUHJvbWlzZShmdW5jdGlvbihlLG4pe2lmKCFUKXRocm93IG5ldyBGb3JtYXRFcnJvcigiR1N0YXRlIG11c3QgYmUgcmVmZXJyZWQgdG8gYnkgbmFtZS4iKTtjb25zdCBpPXIuZ2V0KCJFeHRHU3RhdGUiKTtpZighKGkgaW5zdGFuY2VvZiBEaWN0KSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkV4dEdTdGF0ZSBzaG91bGQgYmUgYSBkaWN0aW9uYXJ5LiIpO2NvbnN0IHM9aS5nZXQodik7aWYoIShzIGluc3RhbmNlb2YgRGljdCkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJHU3RhdGUgc2hvdWxkIGJlIGEgZGljdGlvbmFyeS4iKTtsLnNldEdTdGF0ZSh7cmVzb3VyY2VzOnIsZ1N0YXRlOnMsb3BlcmF0b3JMaXN0OmEsY2FjaGVLZXk6dix0YXNrOnQsc3RhdGVNYW5hZ2VyOnksbG9jYWxHU3RhdGVDYWNoZTpmLGxvY2FsQ29sb3JTcGFjZUNhY2hlOmQsc2VlblJlZnM6Y30pLnRoZW4oZSxuKX0pLmNhdGNoKGZ1bmN0aW9uKGUpe2lmKCEoZSBpbnN0YW5jZW9mIEFib3J0RXhjZXB0aW9uKSl7aWYoIWwub3B0aW9ucy5pZ25vcmVFcnJvcnMpdGhyb3cgZTt3YXJuKGBnZXRPcGVyYXRvckxpc3QgLSBpZ25vcmluZyBFeHRHU3RhdGU6ICIke2V9Ii5gKX19KSk7cmV0dXJuO2Nhc2UgaGU6e2NvbnN0W3RdPWU7aWYoIm51bWJlciIhPXR5cGVvZiB0KXt3YXJuKGBJbnZhbGlkIHNldExpbmVXaWR0aDogJHt0fWApO2NvbnRpbnVlfWVbMF09TWF0aC5hYnModCk7YnJlYWt9Y2FzZSBnZTp7Y29uc3QgdD1lWzFdO2lmKCJudW1iZXIiIT10eXBlb2YgdCl7d2FybihgSW52YWxpZCBzZXREYXNoOiAke3R9YCk7Y29udGludWV9Y29uc3Qgcj1lWzBdO2lmKCFBcnJheS5pc0FycmF5KHIpKXt3YXJuKGBJbnZhbGlkIHNldERhc2g6ICR7cn1gKTtjb250aW51ZX1yLnNvbWUoZT0+Im51bWJlciIhPXR5cGVvZiBlKSYmKGVbMF09ci5maWx0ZXIoZT0+Im51bWJlciI9PXR5cGVvZiBlKSk7YnJlYWt9Y2FzZSBTZTpjYXNlIEFlOmNhc2Uga2U6Y2FzZSBDZTpjYXNlIHZlOmNhc2UgRmU6Y2FzZSBJZTpsLmJ1aWxkUGF0aChuLGUseS5zdGF0ZSk7Y29udGludWU7Y2FzZSBUZTpjYXNlIE9lOmNhc2UgTWU6Y2FzZSBEZTpjYXNlIEJlOmNhc2UgUmU6Y2FzZSBFZTpjYXNlIE5lOmNhc2UgUGU6e2NvbnN0e3N0YXRlOntwYXRoQnVmZmVyOmUscGF0aE1pbk1heDp0fX09eTtuIT09T2UmJm4hPT1FZSYmbiE9PU5lfHxlLnB1c2goSnQpO2lmKDA9PT1lLmxlbmd0aClhLmFkZE9wKEh0LFtuLFtudWxsXSxudWxsXSk7ZWxzZXthLmFkZE9wKEh0LFtuLFtuZXcgRmxvYXQzMkFycmF5KGUpXSx0LnNsaWNlKCldKTtlLmxlbmd0aD0wO3Quc2V0KFsxLzAsMS8wLC0xLzAsLTEvMF0sMCl9Y29udGludWV9Y2FzZSBKZTphLmFkZE9wKG4sW25ldyBGbG9hdDMyQXJyYXkoZSldKTtjb250aW51ZTtjYXNlIEF0OmNhc2Uga3Q6Y2FzZSBJdDpjYXNlIFR0OmNvbnRpbnVlO2Nhc2UgdnQ6aWYoIShlWzBdaW5zdGFuY2VvZiBOYW1lKSl7d2FybihgRXhwZWN0ZWQgbmFtZSBmb3IgYmVnaW5NYXJrZWRDb250ZW50UHJvcHMgYXJnMD0ke2VbMF19YCk7YS5hZGRPcCh2dCxbIk9DIixudWxsXSk7Y29udGludWV9aWYoIk9DIj09PWVbMF0ubmFtZSl7bmV4dChsLnBhcnNlTWFya2VkQ29udGVudFByb3BzKGVbMV0scikudGhlbihlPT57YS5hZGRPcCh2dCxbIk9DIixlXSl9KS5jYXRjaChlPT57aWYoIShlIGluc3RhbmNlb2YgQWJvcnRFeGNlcHRpb24pKXtpZighbC5vcHRpb25zLmlnbm9yZUVycm9ycyl0aHJvdyBlO3dhcm4oYGdldE9wZXJhdG9yTGlzdCAtIGlnbm9yaW5nIGJlZ2luTWFya2VkQ29udGVudFByb3BzOiAiJHtlfSIuYCk7YS5hZGRPcCh2dCxbIk9DIixudWxsXSl9fSkpO3JldHVybn1lPVtlWzBdLm5hbWUsZVsxXWluc3RhbmNlb2YgRGljdD9lWzFdLmdldCgiTUNJRCIpOm51bGxdO2JyZWFrO2RlZmF1bHQ6aWYobnVsbCE9PWUpe2ZvcihTPTAsaz1lLmxlbmd0aDtTPGsmJiEoZVtTXWluc3RhbmNlb2YgRGljdCk7UysrKTtpZihTPGspe3dhcm4oImdldE9wZXJhdG9yTGlzdCAtIGlnbm9yaW5nIG9wZXJhdG9yOiAiK24pO2NvbnRpbnVlfX19YS5hZGRPcChuLGUpfWlmKG8pbmV4dCh4aSk7ZWxzZXtjbG9zZVBlbmRpbmdSZXN0b3JlT1BTKCk7ZSgpfX0pLmNhdGNoKGU9PntpZighKGUgaW5zdGFuY2VvZiBBYm9ydEV4Y2VwdGlvbikpe2lmKCF0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzKXRocm93IGU7d2FybihgZ2V0T3BlcmF0b3JMaXN0IC0gaWdub3JpbmcgZXJyb3JzIGR1cmluZyAiJHt0Lm5hbWV9IiB0YXNrOiAiJHtlfSIuYCk7Y2xvc2VQZW5kaW5nUmVzdG9yZU9QUygpfX0pfWdldFRleHRDb250ZW50KHtzdHJlYW06ZSx0YXNrOnQscmVzb3VyY2VzOnIsc3RhdGVNYW5hZ2VyOm49bnVsbCxpbmNsdWRlTWFya2VkQ29udGVudDppPSExLHNpbms6cyxzZWVuU3R5bGVzOm89bmV3IFNldCx2aWV3Qm94OmMsbGFuZzpsPW51bGwsbWFya2VkQ29udGVudERhdGE6aD1udWxsLGRpc2FibGVOb3JtYWxpemF0aW9uOnU9ITEsa2VlcFdoaXRlU3BhY2U6ZD0hMSxwcmV2UmVmczpmPW51bGwsaW50ZXJzZWN0b3I6Zz1udWxsfSl7Y29uc3QgcD1lLmRpY3Q/Lm9iaklkLG09bmV3IFJlZlNldChmKTtpZihwKXtpZihmPy5oYXMocCkpdGhyb3cgbmV3IEVycm9yKGBnZXRUZXh0Q29udGVudCAtIGlnbm9yaW5nIGNpcmN1bGFyIHJlZmVyZW5jZTogJHtwfWApO20ucHV0KHApfXJ8fD1EaWN0LmVtcHR5O258fD1uZXcgU3RhdGVNYW5hZ2VyKG5ldyBUZXh0U3RhdGUpO2kmJihofHw9e2xldmVsOjB9KTtjb25zdCBiPXtpdGVtczpbXSxzdHlsZXM6T2JqZWN0LmNyZWF0ZShudWxsKSxsYW5nOmx9LHk9e2luaXRpYWxpemVkOiExLHN0cjpbXSx0b3RhbFdpZHRoOjAsdG90YWxIZWlnaHQ6MCx3aWR0aDowLGhlaWdodDowLHZlcnRpY2FsOiExLHByZXZUcmFuc2Zvcm06bnVsbCx0ZXh0QWR2YW5jZVNjYWxlOjAsc3BhY2VJbkZsb3dNaW46MCxzcGFjZUluRmxvd01heDowLHRyYWNraW5nU3BhY2VNaW46MS8wLG5lZ2F0aXZlU3BhY2VNYXg6LTEvMCxub3RBU3BhY2U6LTEvMCx0cmFuc2Zvcm06bnVsbCxmb250TmFtZTpudWxsLGhhc0VPTDohMX0sdz1bIiAiLCIgIl07bGV0IHg9MDtmdW5jdGlvbiBzYXZlTGFzdENoYXIoZSl7Y29uc3QgdD0oeCsxKSUyLHI9IiAiIT09d1t4XSYmIiAiPT09d1t0XTt3W3hdPWU7eD10O3JldHVybiFkJiZyfWZ1bmN0aW9uIHNob3VsZEFkZFdoaXRlcHNhY2UoKXtyZXR1cm4hZCYmIiAiIT09d1t4XSYmIiAiPT09d1soeCsxKSUyXX1mdW5jdGlvbiByZXNldExhc3RDaGFycygpe3dbMF09d1sxXT0iICI7eD0wfWNvbnN0IFM9dGhpcyxrPXRoaXMueHJlZixDPVtdO2xldCB2PW51bGw7Y29uc3QgVD1uZXcgTG9jYWxJbWFnZUNhY2hlLE89bmV3IExvY2FsR1N0YXRlQ2FjaGUsTT1uZXcgRXZhbHVhdG9yUHJlcHJvY2Vzc29yKGUsayxuKTtsZXQgRDtmdW5jdGlvbiBwdXNoV2hpdGVzcGFjZSh7d2lkdGg6ZT0wLGhlaWdodDp0PTAsdHJhbnNmb3JtOnI9eS5wcmV2VHJhbnNmb3JtLGZvbnROYW1lOmE9eS5mb250TmFtZX0pe2c/LmFkZEV4dHJhQ2hhcigiICIpO2IuaXRlbXMucHVzaCh7c3RyOiIgIixkaXI6Imx0ciIsd2lkdGg6ZSxoZWlnaHQ6dCx0cmFuc2Zvcm06cixmb250TmFtZTphLGhhc0VPTDohMX0pfWZ1bmN0aW9uIGdldEN1cnJlbnRUZXh0VHJhbnNmb3JtKCl7Y29uc3QgZT1ELmZvbnQsdD1bRC5mb250U2l6ZSpELnRleHRIU2NhbGUsMCwwLEQuZm9udFNpemUsMCxELnRleHRSaXNlXTtpZihlLmlzVHlwZTNGb250JiYoRC5mb250U2l6ZTw9MXx8ZS5pc0NoYXJCQm94KSYmIWlzQXJyYXlFcXVhbChELmZvbnRNYXRyaXgsYSkpe2NvbnN0IHI9ZS5iYm94WzNdLWUuYmJveFsxXTtyPjAmJih0WzNdKj1yKkQuZm9udE1hdHJpeFszXSl9cmV0dXJuIFV0aWwudHJhbnNmb3JtKEQuY3RtLFV0aWwudHJhbnNmb3JtKEQudGV4dE1hdHJpeCx0KSl9ZnVuY3Rpb24gZW5zdXJlVGV4dENvbnRlbnRJdGVtKCl7aWYoeS5pbml0aWFsaXplZClyZXR1cm4geTtjb25zdHtmb250OmUsbG9hZGVkTmFtZTp0fT1EO2lmKCFvLmhhcyh0KSl7by5hZGQodCk7Yi5zdHlsZXNbdF09e2ZvbnRGYW1pbHk6ZS5mYWxsYmFja05hbWUsYXNjZW50OmUuYXNjZW50LGRlc2NlbnQ6ZS5kZXNjZW50LHZlcnRpY2FsOmUudmVydGljYWx9O2lmKFMub3B0aW9ucy5mb250RXh0cmFQcm9wZXJ0aWVzJiZlLnN5c3RlbUZvbnRJbmZvKXtjb25zdCByPWIuc3R5bGVzW3RdO3IuZm9udFN1YnN0aXR1dGlvbj1lLnN5c3RlbUZvbnRJbmZvLmNzcztyLmZvbnRTdWJzdGl0dXRpb25Mb2FkZWROYW1lPWUuc3lzdGVtRm9udEluZm8ubG9hZGVkTmFtZX19eS5mb250TmFtZT10O2NvbnN0IHI9eS50cmFuc2Zvcm09Z2V0Q3VycmVudFRleHRUcmFuc2Zvcm0oKTtpZihlLnZlcnRpY2FsKXt5LndpZHRoPXkudG90YWxXaWR0aD1NYXRoLmh5cG90KHJbMF0sclsxXSk7eS5oZWlnaHQ9eS50b3RhbEhlaWdodD0wO3kudmVydGljYWw9ITB9ZWxzZXt5LndpZHRoPXkudG90YWxXaWR0aD0wO3kuaGVpZ2h0PXkudG90YWxIZWlnaHQ9TWF0aC5oeXBvdChyWzJdLHJbM10pO3kudmVydGljYWw9ITF9Y29uc3QgYT1NYXRoLmh5cG90KEQudGV4dExpbmVNYXRyaXhbMF0sRC50ZXh0TGluZU1hdHJpeFsxXSksbj1NYXRoLmh5cG90KEQuY3RtWzBdLEQuY3RtWzFdKTt5LnRleHRBZHZhbmNlU2NhbGU9biphO2NvbnN0e2ZvbnRTaXplOml9PUQ7eS50cmFja2luZ1NwYWNlTWluPS4xMDIqaTt5Lm5vdEFTcGFjZT0uMDMqaTt5Lm5lZ2F0aXZlU3BhY2VNYXg9LS4yKmk7eS5zcGFjZUluRmxvd01pbj0uMTAyKmk7eS5zcGFjZUluRmxvd01heD0uNippO3kuaGFzRU9MPSExO3kuaW5pdGlhbGl6ZWQ9ITA7cmV0dXJuIHl9ZnVuY3Rpb24gdXBkYXRlQWR2YW5jZVNjYWxlKCl7aWYoIXkuaW5pdGlhbGl6ZWQpcmV0dXJuO2NvbnN0IGU9TWF0aC5oeXBvdChELnRleHRMaW5lTWF0cml4WzBdLEQudGV4dExpbmVNYXRyaXhbMV0pLHQ9TWF0aC5oeXBvdChELmN0bVswXSxELmN0bVsxXSkqZTtpZih0IT09eS50ZXh0QWR2YW5jZVNjYWxlKXtpZih5LnZlcnRpY2FsKXt5LnRvdGFsSGVpZ2h0Kz15LmhlaWdodCp5LnRleHRBZHZhbmNlU2NhbGU7eS5oZWlnaHQ9MH1lbHNle3kudG90YWxXaWR0aCs9eS53aWR0aCp5LnRleHRBZHZhbmNlU2NhbGU7eS53aWR0aD0wfXkudGV4dEFkdmFuY2VTY2FsZT10fX1mdW5jdGlvbiBydW5CaWRpVHJhbnNmb3JtKGUpe2xldCB0PWUuc3RyLmpvaW4oIiIpO3V8fCh0PWZ1bmN0aW9uIG5vcm1hbGl6ZVVuaWNvZGUoZSl7aWYoIWFyKXthcj0vKFtcdTAwYTBcdTAwYjVcdTAzN2VcdTBlYjNcdTIwMDAtXHUyMDBhXHUyMDJmXHUyMTI2XHVmYjAwLVx1ZmIwNFx1ZmIwNlx1ZmIyMC1cdWZiMzZcdWZiMzgtXHVmYjNjXHVmYjNlXHVmYjQwLVx1ZmI0MVx1ZmI0My1cdWZiNDRcdWZiNDYtXHVmYmExXHVmYmE0LVx1ZmJhOVx1ZmJhZS1cdWZiYjFcdWZiZDMtXHVmYmRjXHVmYmRlLVx1ZmJlN1x1ZmJlYS1cdWZiZjhcdWZiZmMtXHVmYmZkXHVmYzAwLVx1ZmM1ZFx1ZmM2NC1cdWZjZjFcdWZjZjUtXHVmZDNkXHVmZDg4XHVmZGY0XHVmZGZhLVx1ZmRmYlx1ZmU3MVx1ZmU3N1x1ZmU3OVx1ZmU3Ylx1ZmU3ZF0rKXwoXHVmYjA1KykvZ3U7bnI9bmV3IE1hcChbWyLvrIUiLCLFv3QiXV0pfXJldHVybiBlLnJlcGxhY2VBbGwoYXIsKGUsdCxyKT0+dD90Lm5vcm1hbGl6ZSgiTkZLQyIpOm5yLmdldChyKSl9KHQpKTtjb25zdCByPWJpZGkodCwtMSxlLnZlcnRpY2FsKTtyZXR1cm57c3RyOnIuc3RyLGRpcjpyLmRpcix3aWR0aDpNYXRoLmFicyhlLnRvdGFsV2lkdGgpLGhlaWdodDpNYXRoLmFicyhlLnRvdGFsSGVpZ2h0KSx0cmFuc2Zvcm06ZS50cmFuc2Zvcm0sZm9udE5hbWU6ZS5mb250TmFtZSxoYXNFT0w6ZS5oYXNFT0x9fWFzeW5jIGZ1bmN0aW9uIGhhbmRsZVNldEZvbnQoZSxuKXtjb25zdCBpPWF3YWl0IFMubG9hZEZvbnQoZSxuLHIsdCk7RC5sb2FkZWROYW1lPWkubG9hZGVkTmFtZTtELmZvbnQ9aS5mb250O0QuZm9udE1hdHJpeD1pLmZvbnQuZm9udE1hdHJpeHx8YX1mdW5jdGlvbiBhcHBseUludmVyc2VSb3RhdGlvbihlLHQscil7Y29uc3QgYT1NYXRoLmh5cG90KHJbMF0sclsxXSk7cmV0dXJuWyhyWzBdKmUrclsxXSp0KS9hLChyWzJdKmUrclszXSp0KS9hXX1mdW5jdGlvbiBjb21wYXJlV2l0aExhc3RQb3NpdGlvbihlKXtjb25zdCB0PWdldEN1cnJlbnRUZXh0VHJhbnNmb3JtKCk7bGV0IHI9dFs0XSxhPXRbNV07aWYoRC5mb250Py52ZXJ0aWNhbCl7aWYocjxjWzBdfHxyPmNbMl18fGErZTxjWzFdfHxhPmNbM10pcmV0dXJuITF9ZWxzZSBpZihyK2U8Y1swXXx8cj5jWzJdfHxhPGNbMV18fGE+Y1szXSlyZXR1cm4hMTtpZighRC5mb250fHwheS5wcmV2VHJhbnNmb3JtKXJldHVybiEwO2xldCBuPXkucHJldlRyYW5zZm9ybVs0XSxpPXkucHJldlRyYW5zZm9ybVs1XTtpZihuPT09ciYmaT09PWEpcmV0dXJuITA7bGV0IHM9LTE7dFswXSYmMD09PXRbMV0mJjA9PT10WzJdP3M9dFswXT4wPzA6MTgwOnRbMV0mJjA9PT10WzBdJiYwPT09dFszXSYmKHM9dFsxXT4wPzkwOjI3MCk7c3dpdGNoKHMpe2Nhc2UgMDpicmVhaztjYXNlIDkwOltyLGFdPVthLHJdO1tuLGldPVtpLG5dO2JyZWFrO2Nhc2UgMTgwOltyLGEsbixpXT1bLXIsLWEsLW4sLWldO2JyZWFrO2Nhc2UgMjcwOltyLGFdPVstYSwtcl07W24saV09Wy1pLC1uXTticmVhaztkZWZhdWx0OltyLGFdPWFwcGx5SW52ZXJzZVJvdGF0aW9uKHIsYSx0KTtbbixpXT1hcHBseUludmVyc2VSb3RhdGlvbihuLGkseS5wcmV2VHJhbnNmb3JtKX1pZihELmZvbnQudmVydGljYWwpe2NvbnN0IGU9KGktYSkveS50ZXh0QWR2YW5jZVNjYWxlLHQ9ci1uLHM9TWF0aC5zaWduKHkuaGVpZ2h0KTtpZihlPHMqeS5uZWdhdGl2ZVNwYWNlTWF4KXtpZihNYXRoLmFicyh0KT4uNSp5LndpZHRoKXthcHBlbmRFT0woKTtyZXR1cm4hMH1yZXNldExhc3RDaGFycygpO2ZsdXNoVGV4dENvbnRlbnRJdGVtKCk7cmV0dXJuITB9aWYoTWF0aC5hYnModCk+eS53aWR0aCl7YXBwZW5kRU9MKCk7cmV0dXJuITB9ZTw9cyp5Lm5vdEFTcGFjZSYmcmVzZXRMYXN0Q2hhcnMoKTtpZihlPD1zKnkudHJhY2tpbmdTcGFjZU1pbilpZihzaG91bGRBZGRXaGl0ZXBzYWNlKCkpe3Jlc2V0TGFzdENoYXJzKCk7Zmx1c2hUZXh0Q29udGVudEl0ZW0oKTtwdXNoV2hpdGVzcGFjZSh7aGVpZ2h0Ok1hdGguYWJzKGUpfSl9ZWxzZSB5LmhlaWdodCs9ZTtlbHNlIGlmKCFhZGRGYWtlU3BhY2VzKGUseS5wcmV2VHJhbnNmb3JtLHMpKWlmKDA9PT15LnN0ci5sZW5ndGgpe3Jlc2V0TGFzdENoYXJzKCk7cHVzaFdoaXRlc3BhY2Uoe2hlaWdodDpNYXRoLmFicyhlKX0pfWVsc2UgeS5oZWlnaHQrPWU7TWF0aC5hYnModCk+LjI1Knkud2lkdGgmJmZsdXNoVGV4dENvbnRlbnRJdGVtKCk7cmV0dXJuITB9Y29uc3Qgbz0oci1uKS95LnRleHRBZHZhbmNlU2NhbGUsbD1hLWksaD1NYXRoLnNpZ24oeS53aWR0aCk7aWYobzxoKnkubmVnYXRpdmVTcGFjZU1heCl7aWYoTWF0aC5hYnMobCk+LjUqeS5oZWlnaHQpe2FwcGVuZEVPTCgpO3JldHVybiEwfXJlc2V0TGFzdENoYXJzKCk7Zmx1c2hUZXh0Q29udGVudEl0ZW0oKTtyZXR1cm4hMH1pZihNYXRoLmFicyhsKT55LmhlaWdodCl7YXBwZW5kRU9MKCk7cmV0dXJuITB9bzw9aCp5Lm5vdEFTcGFjZSYmcmVzZXRMYXN0Q2hhcnMoKTtpZihvPD1oKnkudHJhY2tpbmdTcGFjZU1pbilpZihzaG91bGRBZGRXaGl0ZXBzYWNlKCkpe3Jlc2V0TGFzdENoYXJzKCk7Zmx1c2hUZXh0Q29udGVudEl0ZW0oKTtwdXNoV2hpdGVzcGFjZSh7d2lkdGg6TWF0aC5hYnMobyl9KX1lbHNlIHkud2lkdGgrPW87ZWxzZSBpZighYWRkRmFrZVNwYWNlcyhvLHkucHJldlRyYW5zZm9ybSxoKSlpZigwPT09eS5zdHIubGVuZ3RoKXtyZXNldExhc3RDaGFycygpO3B1c2hXaGl0ZXNwYWNlKHt3aWR0aDpNYXRoLmFicyhvKX0pfWVsc2UgeS53aWR0aCs9bztNYXRoLmFicyhsKT4uMjUqeS5oZWlnaHQmJmZsdXNoVGV4dENvbnRlbnRJdGVtKCk7cmV0dXJuITB9ZnVuY3Rpb24gYnVpbGRUZXh0Q29udGVudEl0ZW0oe2NoYXJzOmUsZXh0cmFTcGFjaW5nOnR9KXtjb25zdCByPUQuZm9udDtpZighZSl7Y29uc3QgZT1ELmNoYXJTcGFjaW5nK3Q7ZSYmKHIudmVydGljYWw/RC50cmFuc2xhdGVUZXh0TWF0cml4KDAsLWUpOkQudHJhbnNsYXRlVGV4dE1hdHJpeChlKkQudGV4dEhTY2FsZSwwKSk7ZCYmY29tcGFyZVdpdGhMYXN0UG9zaXRpb24oMCk7cmV0dXJufWNvbnN0IGE9ci5jaGFyc1RvR2x5cGhzKGUpLG49RC5mb250TWF0cml4WzBdKkQuZm9udFNpemU7Zm9yKGxldCBlPTAsaT1hLmxlbmd0aDtlPGk7ZSsrKXtjb25zdCBzPWFbZV0se2NhdGVnb3J5Om8sb3JpZ2luYWxDaGFyQ29kZTpjfT1zO2lmKG8uaXNJbnZpc2libGVGb3JtYXRNYXJrKWNvbnRpbnVlO2xldCBsPUQuY2hhclNwYWNpbmcrKGUrMT09PWk/dDowKSxoPXMud2lkdGg7ci52ZXJ0aWNhbCYmKGg9cy52bWV0cmljP3Mudm1ldHJpY1swXTotaCk7bGV0IHU9aCpuOzMyPT09YyYmKGwrPUQud29yZFNwYWNpbmcpO2lmKCFkJiZvLmlzV2hpdGVzcGFjZSl7aWYoci52ZXJ0aWNhbCl7bCs9LXU7RC50cmFuc2xhdGVUZXh0TWF0cml4KDAsLWwpfWVsc2V7bCs9dTtELnRyYW5zbGF0ZVRleHRNYXRyaXgobCpELnRleHRIU2NhbGUsMCl9c2F2ZUxhc3RDaGFyKCIgIik7Y29udGludWV9aWYoIW8uaXNaZXJvV2lkdGhEaWFjcml0aWMmJiFjb21wYXJlV2l0aExhc3RQb3NpdGlvbih1KSl7ci52ZXJ0aWNhbD9ELnRyYW5zbGF0ZVRleHRNYXRyaXgoMCx1KTpELnRyYW5zbGF0ZVRleHRNYXRyaXgodSpELnRleHRIU2NhbGUsMCk7Y29udGludWV9Y29uc3QgZj1lbnN1cmVUZXh0Q29udGVudEl0ZW0oKTtvLmlzWmVyb1dpZHRoRGlhY3JpdGljJiYodT0wKTtpZihyLnZlcnRpY2FsKXtnPy5hZGRHbHlwaChnZXRDdXJyZW50VGV4dFRyYW5zZm9ybSgpLDAsdSxzLnVuaWNvZGUpO0QudHJhbnNsYXRlVGV4dE1hdHJpeCgwLHUpO3U9TWF0aC5hYnModSk7Zi5oZWlnaHQrPXV9ZWxzZXt1Kj1ELnRleHRIU2NhbGU7Zz8uYWRkR2x5cGgoZ2V0Q3VycmVudFRleHRUcmFuc2Zvcm0oKSx1LDAscy51bmljb2RlKTtELnRyYW5zbGF0ZVRleHRNYXRyaXgodSwwKTtmLndpZHRoKz11fXUmJihmLnByZXZUcmFuc2Zvcm09Z2V0Q3VycmVudFRleHRUcmFuc2Zvcm0oKSk7Y29uc3QgcD1zLnVuaWNvZGU7aWYoc2F2ZUxhc3RDaGFyKHApKXtmLnN0ci5wdXNoKCIgIik7Zz8uYWRkRXh0cmFDaGFyKCIgIil9Z3x8Zi5zdHIucHVzaChwKTtsJiYoci52ZXJ0aWNhbD9ELnRyYW5zbGF0ZVRleHRNYXRyaXgoMCwtbCk6RC50cmFuc2xhdGVUZXh0TWF0cml4KGwqRC50ZXh0SFNjYWxlLDApKX19ZnVuY3Rpb24gYXBwZW5kRU9MKCl7Zz8uYWRkRXh0cmFDaGFyKCJcbiIpO3Jlc2V0TGFzdENoYXJzKCk7aWYoeS5pbml0aWFsaXplZCl7eS5oYXNFT0w9ITA7Zmx1c2hUZXh0Q29udGVudEl0ZW0oKX1lbHNlIGIuaXRlbXMucHVzaCh7c3RyOiIiLGRpcjoibHRyIix3aWR0aDowLGhlaWdodDowLHRyYW5zZm9ybTpnZXRDdXJyZW50VGV4dFRyYW5zZm9ybSgpLGZvbnROYW1lOkQubG9hZGVkTmFtZSxoYXNFT0w6ITB9KX1mdW5jdGlvbiBhZGRGYWtlU3BhY2VzKGUsdCxyKXtpZihyKnkuc3BhY2VJbkZsb3dNaW48PWUmJmU8PXIqeS5zcGFjZUluRmxvd01heCl7aWYoeS5pbml0aWFsaXplZCl7cmVzZXRMYXN0Q2hhcnMoKTt5LnN0ci5wdXNoKCIgIik7Zz8uYWRkRXh0cmFDaGFyKCIgIil9cmV0dXJuITF9Y29uc3QgYT15LmZvbnROYW1lO2xldCBuPTA7aWYoeS52ZXJ0aWNhbCl7bj1lO2U9MH1mbHVzaFRleHRDb250ZW50SXRlbSgpO3Jlc2V0TGFzdENoYXJzKCk7cHVzaFdoaXRlc3BhY2Uoe3dpZHRoOk1hdGguYWJzKGUpLGhlaWdodDpNYXRoLmFicyhuKSx0cmFuc2Zvcm06dHx8Z2V0Q3VycmVudFRleHRUcmFuc2Zvcm0oKSxmb250TmFtZTphfSk7cmV0dXJuITB9ZnVuY3Rpb24gZmx1c2hUZXh0Q29udGVudEl0ZW0oKXtpZih5LmluaXRpYWxpemVkJiZ5LnN0cil7eS52ZXJ0aWNhbD95LnRvdGFsSGVpZ2h0Kz15LmhlaWdodCp5LnRleHRBZHZhbmNlU2NhbGU6eS50b3RhbFdpZHRoKz15LndpZHRoKnkudGV4dEFkdmFuY2VTY2FsZTtiLml0ZW1zLnB1c2gocnVuQmlkaVRyYW5zZm9ybSh5KSk7eS5pbml0aWFsaXplZD0hMTt5LnN0ci5sZW5ndGg9MH19ZnVuY3Rpb24gZW5xdWV1ZUNodW5rKGU9ITEpe2NvbnN0IHQ9Yi5pdGVtcy5sZW5ndGg7aWYoMCE9PXQmJiEoZSYmdDwxMCkpe3M/LmVucXVldWUoYix0KTtiLml0ZW1zPVtdO2Iuc3R5bGVzPU9iamVjdC5jcmVhdGUobnVsbCl9fWNvbnN0IFI9bmV3IFRpbWVTbG90TWFuYWdlcjtyZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gcHJvbWlzZUJvZHkoZSxhKXtjb25zdCBuZXh0PWZ1bmN0aW9uKHQpe2VucXVldWVDaHVuayghMCk7UHJvbWlzZS5hbGwoW3Qscz8ucmVhZHldKS50aGVuKGZ1bmN0aW9uKCl7dHJ5e3Byb21pc2VCb2R5KGUsYSl9Y2F0Y2goZSl7YShlKX19LGEpfTt0LmVuc3VyZU5vdFRlcm1pbmF0ZWQoKTtSLnJlc2V0KCk7Y29uc3QgZj17fTtsZXQgZyxwLHksdz1bXTtmb3IoOyEoZz1SLmNoZWNrKCkpOyl7dy5sZW5ndGg9MDtmLmFyZ3M9dztpZighTS5yZWFkKGYpKWJyZWFrO2NvbnN0IGU9RDtEPW4uc3RhdGU7Y29uc3QgYT1mLmZuO3c9Zi5hcmdzO3N3aXRjaCgwfGEpe2Nhc2UgemU6Y29uc3QgYT13WzBdLm5hbWUsZj13WzFdO2lmKEQuZm9udCYmYT09PUQuZm9udE5hbWUmJmY9PT1ELmZvbnRTaXplKWJyZWFrO2ZsdXNoVGV4dENvbnRlbnRJdGVtKCk7RC5mb250TmFtZT1hO0QuZm9udFNpemU9ZjtuZXh0KGhhbmRsZVNldEZvbnQoYSxudWxsKSk7cmV0dXJuO2Nhc2UgJGU6RC50ZXh0UmlzZT13WzBdO2JyZWFrO2Nhc2UgSGU6RC50ZXh0SFNjYWxlPXdbMF0vMTAwO2JyZWFrO2Nhc2UgV2U6RC5sZWFkaW5nPXdbMF07YnJlYWs7Y2FzZSBWZTpELnRyYW5zbGF0ZVRleHRMaW5lTWF0cml4KHdbMF0sd1sxXSk7RC50ZXh0TWF0cml4PUQudGV4dExpbmVNYXRyaXguc2xpY2UoKTticmVhaztjYXNlIEtlOkQubGVhZGluZz0td1sxXTtELnRyYW5zbGF0ZVRleHRMaW5lTWF0cml4KHdbMF0sd1sxXSk7RC50ZXh0TWF0cml4PUQudGV4dExpbmVNYXRyaXguc2xpY2UoKTticmVhaztjYXNlIFllOkQuY2FycmlhZ2VSZXR1cm4oKTticmVhaztjYXNlIEplOkQuc2V0VGV4dE1hdHJpeCh3WzBdLHdbMV0sd1syXSx3WzNdLHdbNF0sd1s1XSk7RC5zZXRUZXh0TGluZU1hdHJpeCh3WzBdLHdbMV0sd1syXSx3WzNdLHdbNF0sd1s1XSk7dXBkYXRlQWR2YW5jZVNjYWxlKCk7YnJlYWs7Y2FzZSBxZTpELmNoYXJTcGFjaW5nPXdbMF07YnJlYWs7Y2FzZSBYZTpELndvcmRTcGFjaW5nPXdbMF07YnJlYWs7Y2FzZSBqZTpELnRleHRNYXRyaXg9ZnIuc2xpY2UoKTtELnRleHRMaW5lTWF0cml4PWZyLnNsaWNlKCk7YnJlYWs7Y2FzZSBRZTppZighbi5zdGF0ZS5mb250KXtTLmVuc3VyZVN0YXRlRm9udChuLnN0YXRlKTtjb250aW51ZX1jb25zdCBnPShELmZvbnQudmVydGljYWw/MTotMSkqRC5mb250U2l6ZS8xZTMseD13WzBdO2ZvcihsZXQgZT0wLHQ9eC5sZW5ndGg7ZTx0O2UrKyl7Y29uc3QgdD14W2VdO2lmKCJzdHJpbmciPT10eXBlb2YgdClDLnB1c2godCk7ZWxzZSBpZigibnVtYmVyIj09dHlwZW9mIHQmJjAhPT10KXtjb25zdCBlPUMuam9pbigiIik7Qy5sZW5ndGg9MDtidWlsZFRleHRDb250ZW50SXRlbSh7Y2hhcnM6ZSxleHRyYVNwYWNpbmc6dCpnfSl9fWlmKEMubGVuZ3RoPjApe2NvbnN0IGU9Qy5qb2luKCIiKTtDLmxlbmd0aD0wO2J1aWxkVGV4dENvbnRlbnRJdGVtKHtjaGFyczplLGV4dHJhU3BhY2luZzowfSl9YnJlYWs7Y2FzZSBaZTppZighbi5zdGF0ZS5mb250KXtTLmVuc3VyZVN0YXRlRm9udChuLnN0YXRlKTtjb250aW51ZX1idWlsZFRleHRDb250ZW50SXRlbSh7Y2hhcnM6d1swXSxleHRyYVNwYWNpbmc6MH0pO2JyZWFrO2Nhc2UgZXQ6aWYoIW4uc3RhdGUuZm9udCl7Uy5lbnN1cmVTdGF0ZUZvbnQobi5zdGF0ZSk7Y29udGludWV9RC5jYXJyaWFnZVJldHVybigpO2J1aWxkVGV4dENvbnRlbnRJdGVtKHtjaGFyczp3WzBdLGV4dHJhU3BhY2luZzowfSk7YnJlYWs7Y2FzZSB0dDppZighbi5zdGF0ZS5mb250KXtTLmVuc3VyZVN0YXRlRm9udChuLnN0YXRlKTtjb250aW51ZX1ELndvcmRTcGFjaW5nPXdbMF07RC5jaGFyU3BhY2luZz13WzFdO0QuY2FycmlhZ2VSZXR1cm4oKTtidWlsZFRleHRDb250ZW50SXRlbSh7Y2hhcnM6d1syXSxleHRyYVNwYWNpbmc6MH0pO2JyZWFrO2Nhc2UgU3Q6Zmx1c2hUZXh0Q29udGVudEl0ZW0oKTt2Pz89ci5nZXQoIlhPYmplY3QiKXx8RGljdC5lbXB0eTt5PXdbMF1pbnN0YW5jZW9mIE5hbWU7cD13WzBdLm5hbWU7aWYoeSYmVC5nZXRCeU5hbWUocCkpYnJlYWs7bmV4dChuZXcgUHJvbWlzZShmdW5jdGlvbihlLGEpe2lmKCF5KXRocm93IG5ldyBGb3JtYXRFcnJvcigiWE9iamVjdCBtdXN0IGJlIHJlZmVycmVkIHRvIGJ5IG5hbWUuIik7bGV0IGY9di5nZXRSYXcocCk7aWYoZiBpbnN0YW5jZW9mIFJlZil7aWYoVC5nZXRCeVJlZihmKSl7ZSgpO3JldHVybn1pZihTLmdsb2JhbEltYWdlQ2FjaGUuZ2V0RGF0YShmLFMucGFnZUluZGV4KSl7ZSgpO3JldHVybn1mPWsuZmV0Y2goZil9aWYoIShmIGluc3RhbmNlb2YgQmFzZVN0cmVhbSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJYT2JqZWN0IHNob3VsZCBiZSBhIHN0cmVhbSIpO2NvbnN0e2RpY3Q6Z309ZixiPWcuZ2V0KCJTdWJ0eXBlIik7aWYoIShiIGluc3RhbmNlb2YgTmFtZSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJYT2JqZWN0IHNob3VsZCBoYXZlIGEgTmFtZSBzdWJ0eXBlIik7aWYoIkZvcm0iIT09Yi5uYW1lKXtULnNldChwLGcub2JqSWQsITApO2UoKTtyZXR1cm59Y29uc3Qgdz1uLnN0YXRlLmNsb25lKCkseD1uZXcgU3RhdGVNYW5hZ2VyKHcpLEM9bG9va3VwTWF0cml4KGcuZ2V0QXJyYXkoIk1hdHJpeCIpLG51bGwpO0MmJngudHJhbnNmb3JtKEMpO2NvbnN0IE89Zy5nZXQoIlJlc291cmNlcyIpO2VucXVldWVDaHVuaygpO2NvbnN0IE09e2VucXVldWVJbnZva2VkOiExLGVucXVldWUoZSx0KXt0aGlzLmVucXVldWVJbnZva2VkPSEwO3MuZW5xdWV1ZShlLHQpfSxnZXQgZGVzaXJlZFNpemUoKXtyZXR1cm4gcy5kZXNpcmVkU2l6ZT8/MH0sZ2V0IHJlYWR5KCl7cmV0dXJuIHMucmVhZHl9fTtTLmdldFRleHRDb250ZW50KHtzdHJlYW06Zix0YXNrOnQscmVzb3VyY2VzOk8gaW5zdGFuY2VvZiBEaWN0P086cixzdGF0ZU1hbmFnZXI6eCxpbmNsdWRlTWFya2VkQ29udGVudDppLHNpbms6cyYmTSxzZWVuU3R5bGVzOm8sdmlld0JveDpjLGxhbmc6bCxtYXJrZWRDb250ZW50RGF0YTpoLGRpc2FibGVOb3JtYWxpemF0aW9uOnUsa2VlcFdoaXRlU3BhY2U6ZCxwcmV2UmVmczptfSkudGhlbihmdW5jdGlvbigpe00uZW5xdWV1ZUludm9rZWR8fFQuc2V0KHAsZy5vYmpJZCwhMCk7ZSgpfSxhKX0pLmNhdGNoKGZ1bmN0aW9uKGUpe2lmKCEoZSBpbnN0YW5jZW9mIEFib3J0RXhjZXB0aW9uKSl7aWYoIVMub3B0aW9ucy5pZ25vcmVFcnJvcnMpdGhyb3cgZTt3YXJuKGBnZXRUZXh0Q29udGVudCAtIGlnbm9yaW5nIFhPYmplY3Q6ICIke2V9Ii5gKX19KSk7cmV0dXJuO2Nhc2UgYmU6eT13WzBdaW5zdGFuY2VvZiBOYW1lO3A9d1swXS5uYW1lO2lmKHkmJk8uZ2V0QnlOYW1lKHApKWJyZWFrO25leHQobmV3IFByb21pc2UoZnVuY3Rpb24oZSx0KXtpZigheSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkdTdGF0ZSBtdXN0IGJlIHJlZmVycmVkIHRvIGJ5IG5hbWUuIik7Y29uc3QgYT1yLmdldCgiRXh0R1N0YXRlIik7aWYoIShhIGluc3RhbmNlb2YgRGljdCkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJFeHRHU3RhdGUgc2hvdWxkIGJlIGEgZGljdGlvbmFyeS4iKTtjb25zdCBuPWEuZ2V0KHApO2lmKCEobiBpbnN0YW5jZW9mIERpY3QpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiR1N0YXRlIHNob3VsZCBiZSBhIGRpY3Rpb25hcnkuIik7Y29uc3QgaT1uLmdldCgiRm9udCIpO2lmKGkpe2ZsdXNoVGV4dENvbnRlbnRJdGVtKCk7RC5mb250TmFtZT1udWxsO0QuZm9udFNpemU9aVsxXTtoYW5kbGVTZXRGb250KG51bGwsaVswXSkudGhlbihlLHQpfWVsc2V7Ty5zZXQocCxuLm9iaklkLCEwKTtlKCl9fSkuY2F0Y2goZnVuY3Rpb24oZSl7aWYoIShlIGluc3RhbmNlb2YgQWJvcnRFeGNlcHRpb24pKXtpZighUy5vcHRpb25zLmlnbm9yZUVycm9ycyl0aHJvdyBlO3dhcm4oYGdldFRleHRDb250ZW50IC0gaWdub3JpbmcgRXh0R1N0YXRlOiAiJHtlfSIuYCl9fSkpO3JldHVybjtjYXNlIEN0OmZsdXNoVGV4dENvbnRlbnRJdGVtKCk7aWYoaSl7aC5sZXZlbCsrO2IuaXRlbXMucHVzaCh7dHlwZToiYmVnaW5NYXJrZWRDb250ZW50Iix0YWc6d1swXWluc3RhbmNlb2YgTmFtZT93WzBdLm5hbWU6bnVsbH0pfWJyZWFrO2Nhc2UgdnQ6Zmx1c2hUZXh0Q29udGVudEl0ZW0oKTtpZihpKXtoLmxldmVsKys7bGV0IGU9bnVsbDt3WzFdaW5zdGFuY2VvZiBEaWN0JiYoZT13WzFdLmdldCgiTUNJRCIpKTtiLml0ZW1zLnB1c2goe3R5cGU6ImJlZ2luTWFya2VkQ29udGVudFByb3BzIixpZDpOdW1iZXIuaXNJbnRlZ2VyKGUpP2Ake1MuaWRGYWN0b3J5LmdldFBhZ2VPYmpJZCgpfV9tYyR7ZX1gOm51bGwsdGFnOndbMF1pbnN0YW5jZW9mIE5hbWU/d1swXS5uYW1lOm51bGx9KX1icmVhaztjYXNlIEZ0OmZsdXNoVGV4dENvbnRlbnRJdGVtKCk7aWYoaSl7aWYoMD09PWgubGV2ZWwpYnJlYWs7aC5sZXZlbC0tO2IuaXRlbXMucHVzaCh7dHlwZToiZW5kTWFya2VkQ29udGVudCJ9KX1icmVhaztjYXNlIHdlOiFlfHxlLmZvbnQ9PT1ELmZvbnQmJmUuZm9udFNpemU9PT1ELmZvbnRTaXplJiZlLmZvbnROYW1lPT09RC5mb250TmFtZXx8Zmx1c2hUZXh0Q29udGVudEl0ZW0oKX1pZihiLml0ZW1zLmxlbmd0aD49KHM/LmRlc2lyZWRTaXplPz8xKSl7Zz0hMDticmVha319aWYoZyluZXh0KHhpKTtlbHNle2ZsdXNoVGV4dENvbnRlbnRJdGVtKCk7ZW5xdWV1ZUNodW5rKCk7ZSgpfX0pLmNhdGNoKGU9PntpZighKGUgaW5zdGFuY2VvZiBBYm9ydEV4Y2VwdGlvbikpe2lmKCF0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzKXRocm93IGU7d2FybihgZ2V0VGV4dENvbnRlbnQgLSBpZ25vcmluZyBlcnJvcnMgZHVyaW5nICIke3QubmFtZX0iIHRhc2s6ICIke2V9Ii5gKTtmbHVzaFRleHRDb250ZW50SXRlbSgpO2VucXVldWVDaHVuaygpfX0pfWFzeW5jIGV4dHJhY3REYXRhU3RydWN0dXJlcyhlLHQpe2NvbnN0IHI9dGhpcy54cmVmO2xldCBhO2NvbnN0IG49dGhpcy5yZWFkVG9Vbmljb2RlKHQudG9Vbmljb2RlKTtpZih0LmNvbXBvc2l0ZSl7Y29uc3Qgcj1lLmdldCgiQ0lEU3lzdGVtSW5mbyIpO3IgaW5zdGFuY2VvZiBEaWN0JiYodC5jaWRTeXN0ZW1JbmZvPXtyZWdpc3RyeTpzdHJpbmdUb1BERlN0cmluZyhyLmdldCgiUmVnaXN0cnkiKSksb3JkZXJpbmc6c3RyaW5nVG9QREZTdHJpbmcoci5nZXQoIk9yZGVyaW5nIikpLHN1cHBsZW1lbnQ6ci5nZXQoIlN1cHBsZW1lbnQiKX0pO3RyeXtjb25zdCB0PWUuZ2V0KCJDSURUb0dJRE1hcCIpO3QgaW5zdGFuY2VvZiBCYXNlU3RyZWFtJiYoYT10LmdldEJ5dGVzKCkpfWNhdGNoKGUpe2lmKCF0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzKXRocm93IGU7d2FybihgZXh0cmFjdERhdGFTdHJ1Y3R1cmVzIC0gaWdub3JpbmcgQ0lEVG9HSURNYXAgZGF0YTogIiR7ZX0iLmApfX1jb25zdCBpPVtdO2xldCBzLG89bnVsbDtpZihlLmhhcygiRW5jb2RpbmciKSl7cz1lLmdldCgiRW5jb2RpbmciKTtpZihzIGluc3RhbmNlb2YgRGljdCl7bz1zLmdldCgiQmFzZUVuY29kaW5nIik7bz1vIGluc3RhbmNlb2YgTmFtZT9vLm5hbWU6bnVsbDtpZihzLmhhcygiRGlmZmVyZW5jZXMiKSl7Y29uc3QgZT1zLmdldCgiRGlmZmVyZW5jZXMiKTtsZXQgdD0wO2Zvcihjb25zdCBhIG9mIGUpe2NvbnN0IGU9ci5mZXRjaElmUmVmKGEpO2lmKCJudW1iZXIiPT10eXBlb2YgZSl0PWU7ZWxzZXtpZighKGUgaW5zdGFuY2VvZiBOYW1lKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoYEludmFsaWQgZW50cnkgaW4gJ0RpZmZlcmVuY2VzJyBhcnJheTogJHtlfWApO2lbdCsrXT1lLm5hbWV9fX19ZWxzZSBpZihzIGluc3RhbmNlb2YgTmFtZSlvPXMubmFtZTtlbHNle2NvbnN0IGU9IkVuY29kaW5nIGlzIG5vdCBhIE5hbWUgbm9yIGEgRGljdCI7aWYoIXRoaXMub3B0aW9ucy5pZ25vcmVFcnJvcnMpdGhyb3cgbmV3IEZvcm1hdEVycm9yKGUpO3dhcm4oZSl9Ik1hY1JvbWFuRW5jb2RpbmciIT09byYmIk1hY0V4cGVydEVuY29kaW5nIiE9PW8mJiJXaW5BbnNpRW5jb2RpbmciIT09byYmKG89bnVsbCl9Y29uc3QgYz0hdC5maWxlfHx0LmlzSW50ZXJuYWxGb250LGw9cWEoKVt0Lm5hbWVdO28mJmMmJmwmJihvPW51bGwpO2lmKG8pdC5kZWZhdWx0RW5jb2Rpbmc9Z2V0RW5jb2Rpbmcobyk7ZWxzZXtsZXQgZT0hISh0LmZsYWdzJmthKTtjb25zdCByPSEhKHQuZmxhZ3MmQ2EpO2lmKCJUcnVlVHlwZSI9PT10LnR5cGUmJmUmJnImJjAhPT1pLmxlbmd0aCl7dC5mbGFncyY9fmthO2U9ITF9cz1oYTsiVHJ1ZVR5cGUiIT09dC50eXBlfHxyfHwocz11YSk7aWYoZXx8bCl7cz1sYTtjJiYoL1N5bWJvbC9pLnRlc3QodC5uYW1lKT9zPWRhOi9EaW5nYmF0cy9pLnRlc3QodC5uYW1lKT9zPWZhOi9XaW5nZGluZ3MvaS50ZXN0KHQubmFtZSkmJihzPXVhKSl9dC5kZWZhdWx0RW5jb2Rpbmc9c310LmRpZmZlcmVuY2VzPWk7dC5iYXNlRW5jb2RpbmdOYW1lPW87dC5oYXNFbmNvZGluZz0hIW98fGkubGVuZ3RoPjA7dC5kaWN0PWU7dC50b1VuaWNvZGU9YXdhaXQgbjtjb25zdCBoPWF3YWl0IHRoaXMuYnVpbGRUb1VuaWNvZGUodCk7dC50b1VuaWNvZGU9aDthJiYodC5jaWRUb0dpZE1hcD10aGlzLnJlYWRDaWRUb0dpZE1hcChhLGgpKTtyZXR1cm4gdH1fc2ltcGxlRm9udFRvVW5pY29kZShlLHQ9ITEpe2Fzc2VydCghZS5jb21wb3NpdGUsIk11c3QgYmUgYSBzaW1wbGUgZm9udC4iKTtjb25zdCByPVtdLGE9ZS5kZWZhdWx0RW5jb2Rpbmcuc2xpY2UoKSxuPWUuYmFzZUVuY29kaW5nTmFtZSxpPWUuZGlmZmVyZW5jZXM7Zm9yKGNvbnN0IGUgaW4gaSl7Y29uc3QgdD1pW2VdOyIubm90ZGVmIiE9PXQmJihhW2VdPXQpfWNvbnN0IHM9Z2EoKTtmb3IoY29uc3QgaSBpbiBhKXtsZXQgbz1hW2ldO2lmKCIiPT09byljb250aW51ZTtsZXQgYz1zW29dO2lmKHZvaWQgMCE9PWMpe3JbaV09U3RyaW5nLmZyb21DaGFyQ29kZShjKTtjb250aW51ZX1sZXQgbD0wO3N3aXRjaChvWzBdKXtjYXNlIkciOjM9PT1vLmxlbmd0aCYmKGw9cGFyc2VJbnQoby5zdWJzdHJpbmcoMSksMTYpKTticmVhaztjYXNlImciOjU9PT1vLmxlbmd0aCYmKGw9cGFyc2VJbnQoby5zdWJzdHJpbmcoMSksMTYpKTticmVhaztjYXNlIkMiOmNhc2UiYyI6aWYoby5sZW5ndGg+PTMmJm8ubGVuZ3RoPD00KXtjb25zdCByPW8uc3Vic3RyaW5nKDEpO2lmKHQpe2w9cGFyc2VJbnQociwxNik7YnJlYWt9bD0rcjtpZihOdW1iZXIuaXNOYU4obCkmJk51bWJlci5pc0ludGVnZXIocGFyc2VJbnQociwxNikpKXJldHVybiB0aGlzLl9zaW1wbGVGb250VG9Vbmljb2RlKGUsITApfWJyZWFrO2Nhc2UidSI6Yz1nZXRVbmljb2RlRm9yR2x5cGgobyxzKTstMSE9PWMmJihsPWMpO2JyZWFrO2RlZmF1bHQ6c3dpdGNoKG8pe2Nhc2UiZl9oIjpjYXNlImZfdCI6Y2FzZSJUX2giOnJbaV09by5yZXBsYWNlQWxsKCJfIiwiIik7Y29udGludWV9fWlmKGw+MCYmbDw9MTExNDExMSYmTnVtYmVyLmlzSW50ZWdlcihsKSl7aWYobiYmbD09PStpKXtjb25zdCBlPWdldEVuY29kaW5nKG4pO2lmKGUmJihvPWVbaV0pKXtyW2ldPVN0cmluZy5mcm9tQ2hhckNvZGUoc1tvXSk7Y29udGludWV9fXJbaV09U3RyaW5nLmZyb21Db2RlUG9pbnQobCl9fXJldHVybiByfWFzeW5jIGJ1aWxkVG9Vbmljb2RlKGUpe2UuaGFzSW5jbHVkZWRUb1VuaWNvZGVNYXA9ZS50b1VuaWNvZGU/Lmxlbmd0aD4wO2lmKGUuaGFzSW5jbHVkZWRUb1VuaWNvZGVNYXApeyFlLmNvbXBvc2l0ZSYmZS5oYXNFbmNvZGluZyYmKGUuZmFsbGJhY2tUb1VuaWNvZGU9dGhpcy5fc2ltcGxlRm9udFRvVW5pY29kZShlKSk7cmV0dXJuIGUudG9Vbmljb2RlfWlmKCFlLmNvbXBvc2l0ZSlyZXR1cm4gbmV3IFRvVW5pY29kZU1hcCh0aGlzLl9zaW1wbGVGb250VG9Vbmljb2RlKGUpKTtpZihlLmNvbXBvc2l0ZSYmKGUuY01hcC5idWlsdEluQ01hcCYmIShlLmNNYXAgaW5zdGFuY2VvZiBJZGVudGl0eUNNYXApfHwiQWRvYmUiPT09ZS5jaWRTeXN0ZW1JbmZvPy5yZWdpc3RyeSYmKCJHQjEiPT09ZS5jaWRTeXN0ZW1JbmZvLm9yZGVyaW5nfHwiQ05TMSI9PT1lLmNpZFN5c3RlbUluZm8ub3JkZXJpbmd8fCJKYXBhbjEiPT09ZS5jaWRTeXN0ZW1JbmZvLm9yZGVyaW5nfHwiS29yZWExIj09PWUuY2lkU3lzdGVtSW5mby5vcmRlcmluZykpKXtjb25zdHtyZWdpc3RyeTp0LG9yZGVyaW5nOnJ9PWUuY2lkU3lzdGVtSW5mbyxhPU5hbWUuZ2V0KGAke3R9LSR7cn0tVUNTMmApLG49YXdhaXQgQ01hcEZhY3RvcnkuY3JlYXRlKHtlbmNvZGluZzphLGZldGNoQnVpbHRJbkNNYXA6dGhpcy5fZmV0Y2hCdWlsdEluQ01hcEJvdW5kLHVzZUNNYXA6bnVsbH0pLGk9W10scz1bXTtlLmNNYXAuZm9yRWFjaChmdW5jdGlvbihlLHQpe2lmKHQ+NjU1MzUpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJNYXggc2l6ZSBvZiBDSUQgaXMgNjUsNTM1Iik7Y29uc3Qgcj1uLmxvb2t1cCh0KTtpZihyKXtzLmxlbmd0aD0wO2ZvcihsZXQgZT0wLHQ9ci5sZW5ndGg7ZTx0O2UrPTIpcy5wdXNoKChyLmNoYXJDb2RlQXQoZSk8PDgpK3IuY2hhckNvZGVBdChlKzEpKTtpW2VdPVN0cmluZy5mcm9tQ2hhckNvZGUoLi4ucyl9fSk7cmV0dXJuIG5ldyBUb1VuaWNvZGVNYXAoaSl9cmV0dXJuIG5ldyBJZGVudGl0eVRvVW5pY29kZU1hcChlLmZpcnN0Q2hhcixlLmxhc3RDaGFyKX1hc3luYyByZWFkVG9Vbmljb2RlKGUpe2lmKCFlKXJldHVybiBudWxsO2lmKGUgaW5zdGFuY2VvZiBOYW1lKXtjb25zdCB0PWF3YWl0IENNYXBGYWN0b3J5LmNyZWF0ZSh7ZW5jb2Rpbmc6ZSxmZXRjaEJ1aWx0SW5DTWFwOnRoaXMuX2ZldGNoQnVpbHRJbkNNYXBCb3VuZCx1c2VDTWFwOm51bGx9KTtyZXR1cm4gdCBpbnN0YW5jZW9mIElkZW50aXR5Q01hcD9uZXcgSWRlbnRpdHlUb1VuaWNvZGVNYXAoMCw2NTUzNSk6bmV3IFRvVW5pY29kZU1hcCh0LmdldE1hcCgpKX1pZihlIGluc3RhbmNlb2YgQmFzZVN0cmVhbSl0cnl7Y29uc3QgdD1hd2FpdCBDTWFwRmFjdG9yeS5jcmVhdGUoe2VuY29kaW5nOmUsZmV0Y2hCdWlsdEluQ01hcDp0aGlzLl9mZXRjaEJ1aWx0SW5DTWFwQm91bmQsdXNlQ01hcDpudWxsfSk7aWYodCBpbnN0YW5jZW9mIElkZW50aXR5Q01hcClyZXR1cm4gbmV3IElkZW50aXR5VG9Vbmljb2RlTWFwKDAsNjU1MzUpO2NvbnN0IHI9bmV3IEFycmF5KHQubGVuZ3RoKTt0LmZvckVhY2goZnVuY3Rpb24oZSx0KXtpZigibnVtYmVyIj09dHlwZW9mIHQpe3JbZV09U3RyaW5nLmZyb21Db2RlUG9pbnQodCk7cmV0dXJufXQubGVuZ3RoJTIhPTAmJih0PSJcMCIrdCk7Y29uc3QgYT1bXTtmb3IobGV0IGU9MDtlPHQubGVuZ3RoO2UrPTIpe2NvbnN0IHI9dC5jaGFyQ29kZUF0KGUpPDw4fHQuY2hhckNvZGVBdChlKzEpO2lmKDU1Mjk2IT0oNjM0ODgmcikpe2EucHVzaChyKTtjb250aW51ZX1lKz0yO2NvbnN0IG49dC5jaGFyQ29kZUF0KGUpPDw4fHQuY2hhckNvZGVBdChlKzEpO2EucHVzaCgoKDEwMjMmcik8PDEwKSsoMTAyMyZuKSs2NTUzNil9cltlXT1TdHJpbmcuZnJvbUNvZGVQb2ludCguLi5hKX0pO3JldHVybiBuZXcgVG9Vbmljb2RlTWFwKHIpfWNhdGNoKGUpe2lmKGUgaW5zdGFuY2VvZiBBYm9ydEV4Y2VwdGlvbilyZXR1cm4gbnVsbDtpZih0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzKXt3YXJuKGByZWFkVG9Vbmljb2RlIC0gaWdub3JpbmcgVG9Vbmljb2RlIGRhdGE6ICIke2V9Ii5gKTtyZXR1cm4gbnVsbH10aHJvdyBlfXJldHVybiBudWxsfXJlYWRDaWRUb0dpZE1hcChlLHQpe2NvbnN0IHI9W107Zm9yKGxldCBhPTAsbj1lLmxlbmd0aDthPG47YSsrKXtjb25zdCBuPWVbYSsrXTw8OHxlW2FdLGk9YT4+MTsoMCE9PW58fHQuaGFzKGkpKSYmKHJbaV09bil9cmV0dXJuIHJ9ZXh0cmFjdFdpZHRocyhlLHQscil7Y29uc3QgYT10aGlzLnhyZWY7bGV0IG49W10saT0wO2NvbnN0IHM9W107bGV0IG87aWYoci5jb21wb3NpdGUpe2NvbnN0IHQ9ZS5nZXQoIkRXIik7aT0ibnVtYmVyIj09dHlwZW9mIHQ/TWF0aC5jZWlsKHQpOjFlMztjb25zdCBjPWUuZ2V0KCJXIik7aWYoQXJyYXkuaXNBcnJheShjKSlmb3IobGV0IGU9MCx0PWMubGVuZ3RoO2U8dDtlKyspe2xldCB0PWEuZmV0Y2hJZlJlZihjW2UrK10pO2lmKCFOdW1iZXIuaXNJbnRlZ2VyKHQpKWJyZWFrO2NvbnN0IHI9YS5mZXRjaElmUmVmKGNbZV0pO2lmKEFycmF5LmlzQXJyYXkocikpZm9yKGNvbnN0IGUgb2Ygcil7Y29uc3Qgcj1hLmZldGNoSWZSZWYoZSk7Im51bWJlciI9PXR5cGVvZiByJiYoblt0XT1yKTt0Kyt9ZWxzZXtpZighTnVtYmVyLmlzSW50ZWdlcihyKSlicmVhazt7Y29uc3QgaT1hLmZldGNoSWZSZWYoY1srK2VdKTtpZigibnVtYmVyIiE9dHlwZW9mIGkpY29udGludWU7Zm9yKGxldCBlPXQ7ZTw9cjtlKyspbltlXT1pfX19aWYoci52ZXJ0aWNhbCl7Y29uc3QgdD1lLmdldEFycmF5KCJEVzIiKTtsZXQgcj1pc051bWJlckFycmF5KHQsMik/dDpbODgwLC0xZTNdO289W3JbMV0sLjUqaSxyWzBdXTtyPWUuZ2V0KCJXMiIpO2lmKEFycmF5LmlzQXJyYXkocikpZm9yKGxldCBlPTAsdD1yLmxlbmd0aDtlPHQ7ZSsrKXtsZXQgdD1hLmZldGNoSWZSZWYocltlKytdKTtpZighTnVtYmVyLmlzSW50ZWdlcih0KSlicmVhaztjb25zdCBuPWEuZmV0Y2hJZlJlZihyW2VdKTtpZihBcnJheS5pc0FycmF5KG4pKWZvcihsZXQgZT0wLHI9bi5sZW5ndGg7ZTxyO2UrKyl7Y29uc3Qgcj1bYS5mZXRjaElmUmVmKG5bZSsrXSksYS5mZXRjaElmUmVmKG5bZSsrXSksYS5mZXRjaElmUmVmKG5bZV0pXTtpc051bWJlckFycmF5KHIsbnVsbCkmJihzW3RdPXIpO3QrK31lbHNle2lmKCFOdW1iZXIuaXNJbnRlZ2VyKG4pKWJyZWFrO3tjb25zdCBpPVthLmZldGNoSWZSZWYoclsrK2VdKSxhLmZldGNoSWZSZWYoclsrK2VdKSxhLmZldGNoSWZSZWYoclsrK2VdKV07aWYoIWlzTnVtYmVyQXJyYXkoaSxudWxsKSljb250aW51ZTtmb3IobGV0IGU9dDtlPD1uO2UrKylzW2VdPWl9fX19fWVsc2V7Y29uc3Qgcz1lLmdldCgiV2lkdGhzIik7aWYoQXJyYXkuaXNBcnJheShzKSl7bGV0IGU9ci5maXJzdENoYXI7Zm9yKGNvbnN0IHQgb2Ygcyl7Y29uc3Qgcj1hLmZldGNoSWZSZWYodCk7Im51bWJlciI9PXR5cGVvZiByJiYobltlXT1yKTtlKyt9Y29uc3Qgbz10LmdldCgiTWlzc2luZ1dpZHRoIik7aT0ibnVtYmVyIj09dHlwZW9mIG8/bzowfWVsc2V7Y29uc3QgdD1lLmdldCgiQmFzZUZvbnQiKTtpZih0IGluc3RhbmNlb2YgTmFtZSl7Y29uc3QgZT10aGlzLmdldEJhc2VGb250TWV0cmljcyh0Lm5hbWUpO249dGhpcy5idWlsZENoYXJDb2RlVG9XaWR0aChlLndpZHRocyxyKTtpPWUuZGVmYXVsdFdpZHRofX19bGV0IGM9ITAsbD1pO2Zvcihjb25zdCBlIGluIG4pe2NvbnN0IHQ9bltlXTtpZih0KWlmKGwpe2lmKGwhPT10KXtjPSExO2JyZWFrfX1lbHNlIGw9dH1jP3IuZmxhZ3N8PVNhOnIuZmxhZ3MmPX5TYTtyLmRlZmF1bHRXaWR0aD1pO3Iud2lkdGhzPW47ci5kZWZhdWx0Vk1ldHJpY3M9bztyLnZtZXRyaWNzPXN9aXNTZXJpZkZvbnQoZSl7Y29uc3QgdD1lLnNwbGl0KCItIiwxKVswXTtyZXR1cm4gdCBpbiBVYSgpfHwvc2VyaWYvZ2kudGVzdCh0KX1nZXRCYXNlRm9udE1ldHJpY3MoZSl7bGV0IHQ9MCxyPU9iamVjdC5jcmVhdGUobnVsbCksYT0hMTtsZXQgbj1fYSgpW2VdfHxlO2NvbnN0IGk9emEoKTtuIGluIGl8fChuPXRoaXMuaXNTZXJpZkZvbnQoZSk/IlRpbWVzLVJvbWFuIjoiSGVsdmV0aWNhIik7Y29uc3Qgcz1pW25dO2lmKCJudW1iZXIiPT10eXBlb2Ygcyl7dD1zO2E9ITB9ZWxzZSByPXMoKTtyZXR1cm57ZGVmYXVsdFdpZHRoOnQsbW9ub3NwYWNlOmEsd2lkdGhzOnJ9fWJ1aWxkQ2hhckNvZGVUb1dpZHRoKGUsdCl7Y29uc3Qgcj1PYmplY3QuY3JlYXRlKG51bGwpLGE9dC5kaWZmZXJlbmNlcyxuPXQuZGVmYXVsdEVuY29kaW5nO2ZvcihsZXQgdD0wO3Q8MjU2O3QrKyl0IGluIGEmJmVbYVt0XV0/clt0XT1lW2FbdF1dOnQgaW4gbiYmZVtuW3RdXSYmKHJbdF09ZVtuW3RdXSk7cmV0dXJuIHJ9cHJlRXZhbHVhdGVGb250KGUpe2NvbnN0IHQ9ZTtsZXQgcj1lLmdldCgiU3VidHlwZSIpO2lmKCEociBpbnN0YW5jZW9mIE5hbWUpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiaW52YWxpZCBmb250IFN1YnR5cGUiKTtsZXQgYSxuPSExO2lmKCJUeXBlMCI9PT1yLm5hbWUpe2NvbnN0IHQ9ZS5nZXQoIkRlc2NlbmRhbnRGb250cyIpO2lmKCF0KXRocm93IG5ldyBGb3JtYXRFcnJvcigiRGVzY2VuZGFudCBmb250cyBhcmUgbm90IHNwZWNpZmllZCIpO2lmKCEoKGU9QXJyYXkuaXNBcnJheSh0KT90aGlzLnhyZWYuZmV0Y2hJZlJlZih0WzBdKTp0KWluc3RhbmNlb2YgRGljdCkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJEZXNjZW5kYW50IGZvbnQgaXMgbm90IGEgZGljdGlvbmFyeS4iKTtyPWUuZ2V0KCJTdWJ0eXBlIik7aWYoIShyIGluc3RhbmNlb2YgTmFtZSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJpbnZhbGlkIGZvbnQgU3VidHlwZSIpO249ITB9bGV0IGk9ZS5nZXQoIkZpcnN0Q2hhciIpO051bWJlci5pc0ludGVnZXIoaSl8fChpPTApO2xldCBzPWUuZ2V0KCJMYXN0Q2hhciIpO051bWJlci5pc0ludGVnZXIocyl8fChzPW4/NjU1MzU6MjU1KTtjb25zdCBvPWUuZ2V0KCJGb250RGVzY3JpcHRvciIpLGM9ZS5nZXQoIlRvVW5pY29kZSIpfHx0LmdldCgiVG9Vbmljb2RlIik7aWYobyl7YT1uZXcgTXVybXVySGFzaDNfNjQ7Y29uc3Qgcj10LmdldFJhdygiRW5jb2RpbmciKTtpZihyIGluc3RhbmNlb2YgTmFtZSlhLnVwZGF0ZShyLm5hbWUpO2Vsc2UgaWYociBpbnN0YW5jZW9mIFJlZilhLnVwZGF0ZShyLnRvU3RyaW5nKCkpO2Vsc2UgaWYociBpbnN0YW5jZW9mIERpY3QpZm9yKGNvbnN0IGUgb2Ygci5nZXRSYXdWYWx1ZXMoKSlpZihlIGluc3RhbmNlb2YgTmFtZSlhLnVwZGF0ZShlLm5hbWUpO2Vsc2UgaWYoZSBpbnN0YW5jZW9mIFJlZilhLnVwZGF0ZShlLnRvU3RyaW5nKCkpO2Vsc2UgaWYoQXJyYXkuaXNBcnJheShlKSl7Y29uc3QgdD1lLmxlbmd0aCxyPW5ldyBBcnJheSh0KTtmb3IobGV0IGE9MDthPHQ7YSsrKXtjb25zdCB0PWVbYV07dCBpbnN0YW5jZW9mIE5hbWU/clthXT10Lm5hbWU6KCJudW1iZXIiPT10eXBlb2YgdHx8dCBpbnN0YW5jZW9mIFJlZikmJihyW2FdPXQudG9TdHJpbmcoKSl9YS51cGRhdGUoci5qb2luKCkpfWEudXBkYXRlKGAke2l9LSR7c31gKTtpZihjIGluc3RhbmNlb2YgQmFzZVN0cmVhbSl7Y29uc3QgZT1jLnN0cnx8Yyx0PWUuYnVmZmVyP25ldyBVaW50OEFycmF5KGUuYnVmZmVyLmJ1ZmZlciwwLGUuYnVmZmVyTGVuZ3RoKTpuZXcgVWludDhBcnJheShlLmJ5dGVzLmJ1ZmZlcixlLnN0YXJ0LGUuZW5kLWUuc3RhcnQpO2EudXBkYXRlKHQpfWVsc2UgYyBpbnN0YW5jZW9mIE5hbWUmJmEudXBkYXRlKGMubmFtZSk7Y29uc3Qgbz1lLmdldCgiV2lkdGhzIil8fHQuZ2V0KCJXaWR0aHMiKTtpZihBcnJheS5pc0FycmF5KG8pKXtjb25zdCBlPVtdO2Zvcihjb25zdCB0IG9mIG8pKCJudW1iZXIiPT10eXBlb2YgdHx8dCBpbnN0YW5jZW9mIFJlZikmJmUucHVzaCh0LnRvU3RyaW5nKCkpO2EudXBkYXRlKGUuam9pbigpKX1pZihuKXthLnVwZGF0ZSgiY29tcG9zaXRlRm9udCIpO2NvbnN0IHI9ZS5nZXQoIlciKXx8dC5nZXQoIlciKTtpZihBcnJheS5pc0FycmF5KHIpKXtjb25zdCBlPVtdO2Zvcihjb25zdCB0IG9mIHIpaWYoIm51bWJlciI9PXR5cGVvZiB0fHx0IGluc3RhbmNlb2YgUmVmKWUucHVzaCh0LnRvU3RyaW5nKCkpO2Vsc2UgaWYoQXJyYXkuaXNBcnJheSh0KSl7Y29uc3Qgcj1bXTtmb3IoY29uc3QgZSBvZiB0KSgibnVtYmVyIj09dHlwZW9mIGV8fGUgaW5zdGFuY2VvZiBSZWYpJiZyLnB1c2goZS50b1N0cmluZygpKTtlLnB1c2goYFske3Iuam9pbigpfV1gKX1hLnVwZGF0ZShlLmpvaW4oKSl9Y29uc3Qgbj1lLmdldFJhdygiQ0lEVG9HSURNYXAiKXx8dC5nZXRSYXcoIkNJRFRvR0lETWFwIik7biBpbnN0YW5jZW9mIE5hbWU/YS51cGRhdGUobi5uYW1lKTpuIGluc3RhbmNlb2YgUmVmP2EudXBkYXRlKG4udG9TdHJpbmcoKSk6biBpbnN0YW5jZW9mIEJhc2VTdHJlYW0mJmEudXBkYXRlKG4ucGVla0J5dGVzKCkpfX1yZXR1cm57ZGVzY3JpcHRvcjpvLGRpY3Q6ZSxiYXNlRGljdDp0LGNvbXBvc2l0ZTpuLHR5cGU6ci5uYW1lLGZpcnN0Q2hhcjppLGxhc3RDaGFyOnMsdG9Vbmljb2RlOmMsaGFzaDphP2EuaGV4ZGlnZXN0KCk6IiJ9fWFzeW5jIHRyYW5zbGF0ZUZvbnQoe2Rlc2NyaXB0b3I6ZSxkaWN0OnQsYmFzZURpY3Q6cixjb21wb3NpdGU6bix0eXBlOmksZmlyc3RDaGFyOnMsbGFzdENoYXI6byx0b1VuaWNvZGU6Yyxjc3NGb250SW5mbzpsfSl7Y29uc3QgaD0iVHlwZTMiPT09aTtpZighZSl7aWYoIWgpe2xldCBlPXQuZ2V0KCJCYXNlRm9udCIpO2lmKCEoZSBpbnN0YW5jZW9mIE5hbWUpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiQmFzZSBmb250IGlzIG5vdCBzcGVjaWZpZWQiKTtlPWUubmFtZS5yZXBsYWNlQWxsKC9bLF9dL2csIi0iKTtjb25zdCBhPXRoaXMuZ2V0QmFzZUZvbnRNZXRyaWNzKGUpLG49ZS5zcGxpdCgiLSIsMSlbMF0sbD0odGhpcy5pc1NlcmlmRm9udChuKT9BYTowKXwoYS5tb25vc3BhY2U/U2E6MCl8KHFhKClbbl0/a2E6Q2EpLHU9e3R5cGU6aSxuYW1lOmUsbG9hZGVkTmFtZTpyLmxvYWRlZE5hbWUsc3lzdGVtRm9udEluZm86bnVsbCx3aWR0aHM6YS53aWR0aHMsZGVmYXVsdFdpZHRoOmEuZGVmYXVsdFdpZHRoLGlzU2ltdWxhdGVkRmxhZ3M6ITAsZmxhZ3M6bCxmaXJzdENoYXI6cyxsYXN0Q2hhcjpvLHRvVW5pY29kZTpjLHhIZWlnaHQ6MCxjYXBIZWlnaHQ6MCxpdGFsaWNBbmdsZTowLGlzVHlwZTNGb250Omh9LGQ9dC5nZXQoIldpZHRocyIpLGY9Z2V0U3RhbmRhcmRGb250TmFtZShlKTtsZXQgZz1udWxsO2lmKGYpe2c9YXdhaXQgdGhpcy5mZXRjaFN0YW5kYXJkRm9udERhdGEoZik7dS5pc0ludGVybmFsRm9udD0hIWd9IXUuaXNJbnRlcm5hbEZvbnQmJnRoaXMub3B0aW9ucy51c2VTeXN0ZW1Gb250cyYmKHUuc3lzdGVtRm9udEluZm89Z2V0Rm9udFN1YnN0aXR1dGlvbih0aGlzLnN5c3RlbUZvbnRDYWNoZSx0aGlzLmlkRmFjdG9yeSx0aGlzLm9wdGlvbnMuc3RhbmRhcmRGb250RGF0YVVybCxlLGYsaSkpO2NvbnN0IHA9YXdhaXQgdGhpcy5leHRyYWN0RGF0YVN0cnVjdHVyZXModCx1KTtpZihBcnJheS5pc0FycmF5KGQpKXtjb25zdCBlPVtdO2xldCB0PXM7Zm9yKGNvbnN0IHIgb2YgZCl7Y29uc3QgYT10aGlzLnhyZWYuZmV0Y2hJZlJlZihyKTsibnVtYmVyIj09dHlwZW9mIGEmJihlW3RdPWEpO3QrK31wLndpZHRocz1lfWVsc2UgcC53aWR0aHM9dGhpcy5idWlsZENoYXJDb2RlVG9XaWR0aChhLndpZHRocyxwKTtyZXR1cm4gbmV3IEZvbnQoZSxnLHAsdGhpcy5vcHRpb25zKX1lPURpY3QuZW1wdHl9bGV0IHU9ZS5nZXQoIkZvbnROYW1lIiksZD10LmdldCgiQmFzZUZvbnQiKTsic3RyaW5nIj09dHlwZW9mIHUmJih1PU5hbWUuZ2V0KHUpKTsic3RyaW5nIj09dHlwZW9mIGQmJihkPU5hbWUuZ2V0KGQpKTtjb25zdCBmPXU/Lm5hbWUsZz1kPy5uYW1lO2lmKGgpZnx8KHU9TmFtZS5nZXQoaSkpO2Vsc2UgaWYoZiE9PWcpe2luZm8oYFRoZSBGb250RGVzY3JpcHRvcidzIEZvbnROYW1lIGlzICIke2Z9IiBidXQgc2hvdWxkIGJlIHRoZSBzYW1lIGFzIHRoZSBGb250J3MgQmFzZUZvbnQgIiR7Z30iLmApO2YmJmcmJihnLnN0YXJ0c1dpdGgoZil8fCFpc0tub3duRm9udE5hbWUoZikmJmlzS25vd25Gb250TmFtZShnKSkmJih1PW51bGwpO3V8fD1kfWlmKCEodSBpbnN0YW5jZW9mIE5hbWUpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiaW52YWxpZCBmb250IG5hbWUiKTtsZXQgcCxtLGIseSx3O3RyeXtwPWUuZ2V0KCJGb250RmlsZSIsIkZvbnRGaWxlMiIsIkZvbnRGaWxlMyIpO2lmKHApe2lmKCEocCBpbnN0YW5jZW9mIEJhc2VTdHJlYW0pKXRocm93IG5ldyBGb3JtYXRFcnJvcigiRm9udEZpbGUgc2hvdWxkIGJlIGEgc3RyZWFtIik7aWYocC5pc0VtcHR5KXRocm93IG5ldyBGb3JtYXRFcnJvcigiRm9udEZpbGUgaXMgZW1wdHkiKX19Y2F0Y2goZSl7aWYoIXRoaXMub3B0aW9ucy5pZ25vcmVFcnJvcnMpdGhyb3cgZTt3YXJuKGB0cmFuc2xhdGVGb250IC0gZmV0Y2hpbmcgIiR7dS5uYW1lfSIgZm9udCBmaWxlOiAiJHtlfSIuYCk7cD1udWxsfWxldCB4PSExLFM9bnVsbCxrPW51bGw7aWYocCl7aWYocC5kaWN0KXtjb25zdCBlPXAuZGljdC5nZXQoIlN1YnR5cGUiKTtlIGluc3RhbmNlb2YgTmFtZSYmKG09ZS5uYW1lKTtiPXAuZGljdC5nZXQoIkxlbmd0aDEiKTt5PXAuZGljdC5nZXQoIkxlbmd0aDIiKTt3PXAuZGljdC5nZXQoIkxlbmd0aDMiKX19ZWxzZSBpZihsKXtjb25zdCBlPWdldFhmYUZvbnROYW1lKHUubmFtZSk7aWYoZSl7bC5mb250RmFtaWx5PWAke2wuZm9udEZhbWlseX0tUGRmSlMtWEZBYDtsLm1ldHJpY3M9ZS5tZXRyaWNzfHxudWxsO1M9ZS5mYWN0b3JzfHxudWxsO3A9YXdhaXQgdGhpcy5mZXRjaFN0YW5kYXJkRm9udERhdGEoZS5uYW1lKTt4PSEhcDtyPXQ9Z2V0WGZhRm9udERpY3QodS5uYW1lKTtuPSEwfX1lbHNlIGlmKCFoKXtjb25zdCBlPWdldFN0YW5kYXJkRm9udE5hbWUodS5uYW1lKTtpZihlKXtwPWF3YWl0IHRoaXMuZmV0Y2hTdGFuZGFyZEZvbnREYXRhKGUpO3g9ISFwfSF4JiZ0aGlzLm9wdGlvbnMudXNlU3lzdGVtRm9udHMmJihrPWdldEZvbnRTdWJzdGl0dXRpb24odGhpcy5zeXN0ZW1Gb250Q2FjaGUsdGhpcy5pZEZhY3RvcnksdGhpcy5vcHRpb25zLnN0YW5kYXJkRm9udERhdGFVcmwsdS5uYW1lLGUsaSkpfWNvbnN0IEM9bG9va3VwTWF0cml4KHQuZ2V0QXJyYXkoIkZvbnRNYXRyaXgiKSxhKSx2PWxvb2t1cE5vcm1hbFJlY3QoZS5nZXRBcnJheSgiRm9udEJCb3giKXx8dC5nZXRBcnJheSgiRm9udEJCb3giKSxoP1swLDAsMCwwXTp2b2lkIDApO2xldCBUPWUuZ2V0KCJBc2NlbnQiKTsibnVtYmVyIiE9dHlwZW9mIFQmJihUPXZvaWQgMCk7bGV0IE89ZS5nZXQoIkRlc2NlbnQiKTsibnVtYmVyIiE9dHlwZW9mIE8mJihPPXZvaWQgMCk7bGV0IE09ZS5nZXQoIlhIZWlnaHQiKTsibnVtYmVyIiE9dHlwZW9mIE0mJihNPTApO2xldCBEPWUuZ2V0KCJDYXBIZWlnaHQiKTsibnVtYmVyIiE9dHlwZW9mIEQmJihEPTApO2xldCBSPWUuZ2V0KCJGbGFncyIpO051bWJlci5pc0ludGVnZXIoUil8fChSPTApO2xldCBFPWUuZ2V0KCJJdGFsaWNBbmdsZSIpOyJudW1iZXIiIT10eXBlb2YgRSYmKEU9MCk7Y29uc3QgTj17dHlwZTppLG5hbWU6dS5uYW1lLHN1YnR5cGU6bSxmaWxlOnAsbGVuZ3RoMTpiLGxlbmd0aDI6eSxsZW5ndGgzOncsaXNJbnRlcm5hbEZvbnQ6eCxsb2FkZWROYW1lOnIubG9hZGVkTmFtZSxjb21wb3NpdGU6bixmaXhlZFBpdGNoOiExLGZvbnRNYXRyaXg6QyxmaXJzdENoYXI6cyxsYXN0Q2hhcjpvLHRvVW5pY29kZTpjLGJib3g6dixhc2NlbnQ6VCxkZXNjZW50Ok8seEhlaWdodDpNLGNhcEhlaWdodDpELGZsYWdzOlIsaXRhbGljQW5nbGU6RSxpc1R5cGUzRm9udDpoLGNzc0ZvbnRJbmZvOmwsc2NhbGVGYWN0b3JzOlMsc3lzdGVtRm9udEluZm86a307aWYobil7Y29uc3QgZT1yLmdldCgiRW5jb2RpbmciKTtlIGluc3RhbmNlb2YgTmFtZSYmKE4uY2lkRW5jb2Rpbmc9ZS5uYW1lKTtjb25zdCB0PWF3YWl0IENNYXBGYWN0b3J5LmNyZWF0ZSh7ZW5jb2Rpbmc6ZSxmZXRjaEJ1aWx0SW5DTWFwOnRoaXMuX2ZldGNoQnVpbHRJbkNNYXBCb3VuZCx1c2VDTWFwOm51bGx9KTtOLmNNYXA9dDtOLnZlcnRpY2FsPU4uY01hcC52ZXJ0aWNhbH1jb25zdCBfPWF3YWl0IHRoaXMuZXh0cmFjdERhdGFTdHJ1Y3R1cmVzKHQsTik7dGhpcy5leHRyYWN0V2lkdGhzKHQsZSxfKTtyZXR1cm4gbmV3IEZvbnQodS5uYW1lLHAsXyx0aGlzLm9wdGlvbnMpfXN0YXRpYyBidWlsZEZvbnRQYXRocyhlLHQscixhKXtmdW5jdGlvbiBidWlsZFBhdGgodCl7Y29uc3Qgbj1gJHtlLmxvYWRlZE5hbWV9X3BhdGhfJHt0fWA7dHJ5e2lmKGUucmVuZGVyZXIuaGFzQnVpbHRQYXRoKHQpKXJldHVybjtyLnNlbmQoImNvbW1vbm9iaiIsW24sIkZvbnRQYXRoIixlLnJlbmRlcmVyLmdldFBhdGhKcyh0KV0pfWNhdGNoKGUpe2lmKGEuaWdub3JlRXJyb3JzKXt3YXJuKGBidWlsZEZvbnRQYXRocyAtIGlnbm9yaW5nICR7bn0gZ2x5cGg6ICIke2V9Ii5gKTtyZXR1cm59dGhyb3cgZX19Zm9yKGNvbnN0IGUgb2YgdCl7YnVpbGRQYXRoKGUuZm9udENoYXIpO2NvbnN0IHQ9ZS5hY2NlbnQ7dD8uZm9udENoYXImJmJ1aWxkUGF0aCh0LmZvbnRDaGFyKX19c3RhdGljIGdldCBmYWxsYmFja0ZvbnREaWN0KCl7Y29uc3QgZT1uZXcgRGljdDtlLnNldCgiQmFzZUZvbnQiLE5hbWUuZ2V0KCJIZWx2ZXRpY2EiKSk7ZS5zZXQoIlR5cGUiLE5hbWUuZ2V0KCJGYWxsYmFja1R5cGUiKSk7ZS5zZXQoIlN1YnR5cGUiLE5hbWUuZ2V0KCJGYWxsYmFja1R5cGUiKSk7ZS5zZXQoIkVuY29kaW5nIixOYW1lLmdldCgiV2luQW5zaUVuY29kaW5nIikpO3JldHVybiBzaGFkb3codGhpcywiZmFsbGJhY2tGb250RGljdCIsZSl9fWNsYXNzIFRyYW5zbGF0ZWRGb250eyNhZT0hMTsjbmU9bnVsbDtjb25zdHJ1Y3Rvcih7bG9hZGVkTmFtZTplLGZvbnQ6dCxkaWN0OnJ9KXt0aGlzLmxvYWRlZE5hbWU9ZTt0aGlzLmZvbnQ9dDt0aGlzLmRpY3Q9cjt0aGlzLnR5cGUzRGVwZW5kZW5jaWVzPXQuaXNUeXBlM0ZvbnQ/bmV3IFNldDpudWxsfXNlbmQoZSl7aWYodGhpcy4jYWUpcmV0dXJuO3RoaXMuI2FlPSEwO2NvbnN0IHQ9dGhpcy5mb250LmV4cG9ydERhdGEoKSxyPVtdO2lmKHQuZGF0YSl7dC5kYXRhLmNoYXJQcm9jT3BlcmF0b3JMaXN0JiYodC5jaGFyUHJvY09wZXJhdG9yTGlzdD10LmRhdGEuY2hhclByb2NPcGVyYXRvckxpc3QpO3QuZGF0YT1Gb250SW5mby53cml0ZSh0LmRhdGEpO3IucHVzaCh0LmRhdGEpfWUuc2VuZCgiY29tbW9ub2JqIixbdGhpcy5sb2FkZWROYW1lLCJGb250Iix0XSxyKX1mYWxsYmFjayhlLHQpe2lmKHRoaXMuZm9udC5kYXRhKXt0aGlzLmZvbnQuZGlzYWJsZUZvbnRGYWNlPSEwO1BhcnRpYWxFdmFsdWF0b3IuYnVpbGRGb250UGF0aHModGhpcy5mb250LHRoaXMuZm9udC5nbHlwaENhY2hlVmFsdWVzLGUsdCl9fWxvYWRUeXBlM0RhdGEoZSx0LHIpe2lmKHRoaXMuI25lKXJldHVybiB0aGlzLiNuZTtjb25zdHtmb250OmEsdHlwZTNEZXBlbmRlbmNpZXM6bn09dGhpczthc3NlcnQoYS5pc1R5cGUzRm9udCwiTXVzdCBiZSBhIFR5cGUzIGZvbnQuIik7Y29uc3QgaT1lLmNsb25lKHtpZ25vcmVFcnJvcnM6ITF9KSxzPW5ldyBSZWZTZXQoZS50eXBlM0ZvbnRSZWZzKTt0aGlzLmRpY3Qub2JqSWQmJiFzLmhhcyh0aGlzLmRpY3Qub2JqSWQpJiZzLnB1dCh0aGlzLmRpY3Qub2JqSWQpO2kudHlwZTNGb250UmVmcz1zO2xldCBvPVByb21pc2UucmVzb2x2ZSgpO2NvbnN0IGM9dGhpcy5kaWN0LmdldCgiQ2hhclByb2NzIiksbD10aGlzLmRpY3QuZ2V0KCJSZXNvdXJjZXMiKXx8dCxoPU9iamVjdC5jcmVhdGUobnVsbCksW3UsZCxmLGddPWEuYmJveCxwPWYtdSxtPWctZCxiPU1hdGguaHlwb3QocCxtKTtmb3IoY29uc3QgZSBvZiBjLmdldEtleXMoKSlvPW8udGhlbigoKT0+e2NvbnN0IHQ9Yy5nZXQoZSksYT1uZXcgT3BlcmF0b3JMaXN0O3JldHVybiBpLmdldE9wZXJhdG9yTGlzdCh7c3RyZWFtOnQsdGFzazpyLHJlc291cmNlczpsLG9wZXJhdG9yTGlzdDphfSkudGhlbigoKT0+e3N3aXRjaChhLmZuQXJyYXlbMF0pe2Nhc2UgbnQ6dGhpcy4jaWUoYSxiKTticmVhaztjYXNlIHJ0OmJ8fHRoaXMuI3NlKGEpfWhbZV09YS5nZXRJUigpO2Zvcihjb25zdCBlIG9mIGEuZGVwZW5kZW5jaWVzKW4uYWRkKGUpfSkuY2F0Y2goZnVuY3Rpb24odCl7d2FybihgVHlwZTMgZm9udCByZXNvdXJjZSAiJHtlfSIgaXMgbm90IGF2YWlsYWJsZS5gKTtjb25zdCByPW5ldyBPcGVyYXRvckxpc3Q7aFtlXT1yLmdldElSKCl9KX0pO3RoaXMuI25lPW8udGhlbigoKT0+e2EuY2hhclByb2NPcGVyYXRvckxpc3Q9aDtpZih0aGlzLl9iYm94KXthLmlzQ2hhckJCb3g9ITA7YS5iYm94PXRoaXMuX2Jib3h9fSk7cmV0dXJuIHRoaXMuI25lfSNpZShlLHQ9TmFOKXtjb25zdCByPVV0aWwubm9ybWFsaXplUmVjdChlLmFyZ3NBcnJheVswXS5zbGljZSgyKSksYT1yWzJdLXJbMF0sbj1yWzNdLXJbMV0saT1NYXRoLmh5cG90KGEsbik7aWYoMD09PWF8fDA9PT1uKXtlLmZuQXJyYXkuc3BsaWNlKDAsMSk7ZS5hcmdzQXJyYXkuc3BsaWNlKDAsMSl9ZWxzZSBpZigwPT09dHx8TWF0aC5yb3VuZChpL3QpPj0xMCl7dGhpcy5fYmJveD8/PVsxLzAsMS8wLC0xLzAsLTEvMF07VXRpbC5yZWN0Qm91bmRpbmdCb3goLi4ucix0aGlzLl9iYm94KX1sZXQgcz0wLG89ZS5sZW5ndGg7Zm9yKDtzPG87KXtzd2l0Y2goZS5mbkFycmF5W3NdKXtjYXNlIG50OmJyZWFrO2Nhc2UgaXQ6Y2FzZSBzdDpjYXNlIG90OmNhc2UgY3Q6Y2FzZSBsdDpjYXNlIGh0OmNhc2UgdXQ6Y2FzZSBkdDpjYXNlIGZ0OmNhc2UgZ3Q6Y2FzZSBwdDpjYXNlIG10OmNhc2UgYnQ6Y2FzZSBwZTplLmZuQXJyYXkuc3BsaWNlKHMsMSk7ZS5hcmdzQXJyYXkuc3BsaWNlKHMsMSk7by0tO2NvbnRpbnVlO2Nhc2UgYmU6Y29uc3RbdF09ZS5hcmdzQXJyYXlbc107bGV0IHI9MCxhPXQubGVuZ3RoO2Zvcig7cjxhOyl7Y29uc3RbZV09dFtyXTtzd2l0Y2goZSl7Y2FzZSJUUiI6Y2FzZSJUUjIiOmNhc2UiSFQiOmNhc2UiQkciOmNhc2UiQkcyIjpjYXNlIlVDUiI6Y2FzZSJVQ1IyIjp0LnNwbGljZShyLDEpO2EtLTtjb250aW51ZX1yKyt9fXMrK319I3NlKGUpe2xldCB0PTE7Y29uc3Qgcj1lLmxlbmd0aDtmb3IoO3Q8cjspe2lmKGUuZm5BcnJheVt0XT09PUh0KXtjb25zdCByPWUuYXJnc0FycmF5W3RdWzJdO3RoaXMuX2Jib3g/Pz1bMS8wLDEvMCwtMS8wLC0xLzBdO1V0aWwucmVjdEJvdW5kaW5nQm94KC4uLnIsdGhpcy5fYmJveCl9dCsrfX19Y2xhc3MgU3RhdGVNYW5hZ2Vye2NvbnN0cnVjdG9yKGU9bmV3IEV2YWxTdGF0ZSl7dGhpcy5zdGF0ZT1lO3RoaXMuc3RhdGVTdGFjaz1bXX1zYXZlKCl7Y29uc3QgZT10aGlzLnN0YXRlO3RoaXMuc3RhdGVTdGFjay5wdXNoKHRoaXMuc3RhdGUpO3RoaXMuc3RhdGU9ZS5jbG9uZSgpfXJlc3RvcmUoKXtjb25zdCBlPXRoaXMuc3RhdGVTdGFjay5wb3AoKTtlJiYodGhpcy5zdGF0ZT1lKX10cmFuc2Zvcm0oZSl7dGhpcy5zdGF0ZS5jdG09VXRpbC50cmFuc2Zvcm0odGhpcy5zdGF0ZS5jdG0sZSl9fWNsYXNzIFRleHRTdGF0ZXtjb25zdHJ1Y3Rvcigpe3RoaXMuY3RtPW5ldyBGbG9hdDMyQXJyYXkoZnIpO3RoaXMuZm9udE5hbWU9bnVsbDt0aGlzLmZvbnRTaXplPTA7dGhpcy5sb2FkZWROYW1lPW51bGw7dGhpcy5mb250PW51bGw7dGhpcy5mb250TWF0cml4PWE7dGhpcy50ZXh0TWF0cml4PWZyLnNsaWNlKCk7dGhpcy50ZXh0TGluZU1hdHJpeD1mci5zbGljZSgpO3RoaXMuY2hhclNwYWNpbmc9MDt0aGlzLndvcmRTcGFjaW5nPTA7dGhpcy5sZWFkaW5nPTA7dGhpcy50ZXh0SFNjYWxlPTE7dGhpcy50ZXh0UmlzZT0wfXNldFRleHRNYXRyaXgoZSx0LHIsYSxuLGkpe2NvbnN0IHM9dGhpcy50ZXh0TWF0cml4O3NbMF09ZTtzWzFdPXQ7c1syXT1yO3NbM109YTtzWzRdPW47c1s1XT1pfXNldFRleHRMaW5lTWF0cml4KGUsdCxyLGEsbixpKXtjb25zdCBzPXRoaXMudGV4dExpbmVNYXRyaXg7c1swXT1lO3NbMV09dDtzWzJdPXI7c1szXT1hO3NbNF09bjtzWzVdPWl9dHJhbnNsYXRlVGV4dE1hdHJpeChlLHQpe2NvbnN0IHI9dGhpcy50ZXh0TWF0cml4O3JbNF09clswXSplK3JbMl0qdCtyWzRdO3JbNV09clsxXSplK3JbM10qdCtyWzVdfXRyYW5zbGF0ZVRleHRMaW5lTWF0cml4KGUsdCl7Y29uc3Qgcj10aGlzLnRleHRMaW5lTWF0cml4O3JbNF09clswXSplK3JbMl0qdCtyWzRdO3JbNV09clsxXSplK3JbM10qdCtyWzVdfWNhcnJpYWdlUmV0dXJuKCl7dGhpcy50cmFuc2xhdGVUZXh0TGluZU1hdHJpeCgwLC10aGlzLmxlYWRpbmcpO3RoaXMudGV4dE1hdHJpeD10aGlzLnRleHRMaW5lTWF0cml4LnNsaWNlKCl9Y2xvbmUoKXtjb25zdCBlPU9iamVjdC5jcmVhdGUodGhpcyk7ZS50ZXh0TWF0cml4PXRoaXMudGV4dE1hdHJpeC5zbGljZSgpO2UudGV4dExpbmVNYXRyaXg9dGhpcy50ZXh0TGluZU1hdHJpeC5zbGljZSgpO2UuZm9udE1hdHJpeD10aGlzLmZvbnRNYXRyaXguc2xpY2UoKTtyZXR1cm4gZX19Y2xhc3MgRXZhbFN0YXRle2NvbnN0cnVjdG9yKCl7dGhpcy5jdG09bmV3IEZsb2F0MzJBcnJheShmcik7dGhpcy5mb250PW51bGw7dGhpcy50ZXh0UmVuZGVyaW5nTW9kZT1rO3RoaXMuX2ZpbGxDb2xvclNwYWNlPXRoaXMuX3N0cm9rZUNvbG9yU3BhY2U9Q29sb3JTcGFjZVV0aWxzLmdyYXk7dGhpcy5wYXR0ZXJuRmlsbENvbG9yU3BhY2U9bnVsbDt0aGlzLnBhdHRlcm5TdHJva2VDb2xvclNwYWNlPW51bGw7dGhpcy5jdXJyZW50UG9pbnRYPXRoaXMuY3VycmVudFBvaW50WT0wO3RoaXMucGF0aE1pbk1heD1uZXcgRmxvYXQzMkFycmF5KFsxLzAsMS8wLC0xLzAsLTEvMF0pO3RoaXMucGF0aEJ1ZmZlcj1bXX1nZXQgZmlsbENvbG9yU3BhY2UoKXtyZXR1cm4gdGhpcy5fZmlsbENvbG9yU3BhY2V9c2V0IGZpbGxDb2xvclNwYWNlKGUpe3RoaXMuX2ZpbGxDb2xvclNwYWNlPXRoaXMucGF0dGVybkZpbGxDb2xvclNwYWNlPWV9Z2V0IHN0cm9rZUNvbG9yU3BhY2UoKXtyZXR1cm4gdGhpcy5fc3Ryb2tlQ29sb3JTcGFjZX1zZXQgc3Ryb2tlQ29sb3JTcGFjZShlKXt0aGlzLl9zdHJva2VDb2xvclNwYWNlPXRoaXMucGF0dGVyblN0cm9rZUNvbG9yU3BhY2U9ZX1jbG9uZSh7bmV3UGF0aDplPSExfT17fSl7Y29uc3QgdD1PYmplY3QuY3JlYXRlKHRoaXMpO2lmKGUpe3QucGF0aEJ1ZmZlcj1bXTt0LnBhdGhNaW5NYXg9bmV3IEZsb2F0MzJBcnJheShbMS8wLDEvMCwtMS8wLC0xLzBdKX1yZXR1cm4gdH19Y2xhc3MgRXZhbHVhdG9yUHJlcHJvY2Vzc29ye3N0YXRpYyBnZXQgb3BNYXAoKXtyZXR1cm4gc2hhZG93KHRoaXMsIm9wTWFwIixPYmplY3QuYXNzaWduKE9iamVjdC5jcmVhdGUobnVsbCkse3c6e2lkOmhlLG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LEo6e2lkOnVlLG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LGo6e2lkOmRlLG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LE06e2lkOmZlLG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LGQ6e2lkOmdlLG51bUFyZ3M6Mix2YXJpYWJsZUFyZ3M6ITF9LHJpOntpZDpwZSxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxpOntpZDptZSxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxnczp7aWQ6YmUsbnVtQXJnczoxLHZhcmlhYmxlQXJnczohMX0scTp7aWQ6eWUsbnVtQXJnczowLHZhcmlhYmxlQXJnczohMX0sUTp7aWQ6d2UsbnVtQXJnczowLHZhcmlhYmxlQXJnczohMX0sY206e2lkOnhlLG51bUFyZ3M6Nix2YXJpYWJsZUFyZ3M6ITF9LG06e2lkOlNlLG51bUFyZ3M6Mix2YXJpYWJsZUFyZ3M6ITF9LGw6e2lkOkFlLG51bUFyZ3M6Mix2YXJpYWJsZUFyZ3M6ITF9LGM6e2lkOmtlLG51bUFyZ3M6Nix2YXJpYWJsZUFyZ3M6ITF9LHY6e2lkOkNlLG51bUFyZ3M6NCx2YXJpYWJsZUFyZ3M6ITF9LHk6e2lkOnZlLG51bUFyZ3M6NCx2YXJpYWJsZUFyZ3M6ITF9LGg6e2lkOkZlLG51bUFyZ3M6MCx2YXJpYWJsZUFyZ3M6ITF9LHJlOntpZDpJZSxudW1BcmdzOjQsdmFyaWFibGVBcmdzOiExfSxTOntpZDpUZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxzOntpZDpPZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxmOntpZDpNZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxGOntpZDpNZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSwiZioiOntpZDpEZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxCOntpZDpCZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSwiQioiOntpZDpSZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxiOntpZDpFZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSwiYioiOntpZDpOZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxuOntpZDpQZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxXOntpZDpfZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSwiVyoiOntpZDpMZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxCVDp7aWQ6amUsbnVtQXJnczowLHZhcmlhYmxlQXJnczohMX0sRVQ6e2lkOlVlLG51bUFyZ3M6MCx2YXJpYWJsZUFyZ3M6ITF9LFRjOntpZDpxZSxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxUdzp7aWQ6WGUsbnVtQXJnczoxLHZhcmlhYmxlQXJnczohMX0sVHo6e2lkOkhlLG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LFRMOntpZDpXZSxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxUZjp7aWQ6emUsbnVtQXJnczoyLHZhcmlhYmxlQXJnczohMX0sVHI6e2lkOkdlLG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LFRzOntpZDokZSxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxUZDp7aWQ6VmUsbnVtQXJnczoyLHZhcmlhYmxlQXJnczohMX0sVEQ6e2lkOktlLG51bUFyZ3M6Mix2YXJpYWJsZUFyZ3M6ITF9LFRtOntpZDpKZSxudW1BcmdzOjYsdmFyaWFibGVBcmdzOiExfSwiVCoiOntpZDpZZSxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxUajp7aWQ6WmUsbnVtQXJnczoxLHZhcmlhYmxlQXJnczohMX0sVEo6e2lkOlFlLG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LCInIjp7aWQ6ZXQsbnVtQXJnczoxLHZhcmlhYmxlQXJnczohMX0sJyInOntpZDp0dCxudW1BcmdzOjMsdmFyaWFibGVBcmdzOiExfSxkMDp7aWQ6cnQsbnVtQXJnczoyLHZhcmlhYmxlQXJnczohMX0sZDE6e2lkOm50LG51bUFyZ3M6Nix2YXJpYWJsZUFyZ3M6ITF9LENTOntpZDppdCxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxjczp7aWQ6c3QsbnVtQXJnczoxLHZhcmlhYmxlQXJnczohMX0sU0M6e2lkOm90LG51bUFyZ3M6NCx2YXJpYWJsZUFyZ3M6ITB9LFNDTjp7aWQ6Y3QsbnVtQXJnczozMyx2YXJpYWJsZUFyZ3M6ITB9LHNjOntpZDpsdCxudW1BcmdzOjQsdmFyaWFibGVBcmdzOiEwfSxzY246e2lkOmh0LG51bUFyZ3M6MzMsdmFyaWFibGVBcmdzOiEwfSxHOntpZDp1dCxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxnOntpZDpkdCxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxSRzp7aWQ6ZnQsbnVtQXJnczozLHZhcmlhYmxlQXJnczohMX0scmc6e2lkOmd0LG51bUFyZ3M6Myx2YXJpYWJsZUFyZ3M6ITF9LEs6e2lkOnB0LG51bUFyZ3M6NCx2YXJpYWJsZUFyZ3M6ITF9LGs6e2lkOm10LG51bUFyZ3M6NCx2YXJpYWJsZUFyZ3M6ITF9LHNoOntpZDpidCxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxCSTp7aWQ6eXQsbnVtQXJnczowLHZhcmlhYmxlQXJnczohMX0sSUQ6e2lkOnd0LG51bUFyZ3M6MCx2YXJpYWJsZUFyZ3M6ITF9LEVJOntpZDp4dCxudW1BcmdzOjEsdmFyaWFibGVBcmdzOiExfSxEbzp7aWQ6U3QsbnVtQXJnczoxLHZhcmlhYmxlQXJnczohMX0sTVA6e2lkOkF0LG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LERQOntpZDprdCxudW1BcmdzOjIsdmFyaWFibGVBcmdzOiExfSxCTUM6e2lkOkN0LG51bUFyZ3M6MSx2YXJpYWJsZUFyZ3M6ITF9LEJEQzp7aWQ6dnQsbnVtQXJnczoyLHZhcmlhYmxlQXJnczohMX0sRU1DOntpZDpGdCxudW1BcmdzOjAsdmFyaWFibGVBcmdzOiExfSxCWDp7aWQ6SXQsbnVtQXJnczowLHZhcmlhYmxlQXJnczohMX0sRVg6e2lkOlR0LG51bUFyZ3M6MCx2YXJpYWJsZUFyZ3M6ITF9LEJNOm51bGwsQkQ6bnVsbCx0cnVlOm51bGwsZmE6bnVsbCxmYWw6bnVsbCxmYWxzOm51bGwsZmFsc2U6bnVsbCxudTpudWxsLG51bDpudWxsLG51bGw6bnVsbH0pKX1zdGF0aWMgTUFYX0lOVkFMSURfUEFUSF9PUFM9MTA7Y29uc3RydWN0b3IoZSx0LHI9bmV3IFN0YXRlTWFuYWdlcil7dGhpcy5wYXJzZXI9bmV3IFBhcnNlcih7bGV4ZXI6bmV3IExleGVyKGUsRXZhbHVhdG9yUHJlcHJvY2Vzc29yLm9wTWFwKSx4cmVmOnR9KTt0aGlzLnN0YXRlTWFuYWdlcj1yO3RoaXMubm9uUHJvY2Vzc2VkQXJncz1bXTt0aGlzLl9pc1BhdGhPcD0hMTt0aGlzLl9udW1JbnZhbGlkUGF0aE9QUz0wfWdldCBzYXZlZFN0YXRlc0RlcHRoKCl7cmV0dXJuIHRoaXMuc3RhdGVNYW5hZ2VyLnN0YXRlU3RhY2subGVuZ3RofXJlYWQoZSl7bGV0IHQ9ZS5hcmdzO2Zvcig7Oyl7Y29uc3Qgcj10aGlzLnBhcnNlci5nZXRPYmooKTtpZihyIGluc3RhbmNlb2YgQ21kKXtjb25zdCBhPXIuY21kLG49RXZhbHVhdG9yUHJlcHJvY2Vzc29yLm9wTWFwW2FdO2lmKCFuKXt3YXJuKGBVbmtub3duIGNvbW1hbmQgIiR7YX0iLmApO2NvbnRpbnVlfWNvbnN0IGk9bi5pZCxzPW4ubnVtQXJncztsZXQgbz1udWxsIT09dD90Lmxlbmd0aDowO3RoaXMuX2lzUGF0aE9wfHwodGhpcy5fbnVtSW52YWxpZFBhdGhPUFM9MCk7dGhpcy5faXNQYXRoT3A9aT49U2UmJmk8PVBlO2lmKG4udmFyaWFibGVBcmdzKW8+cyYmaW5mbyhgQ29tbWFuZCAke2F9OiBleHBlY3RlZCBbMCwgJHtzfV0gYXJncywgYnV0IHJlY2VpdmVkICR7b30gYXJncy5gKTtlbHNle2lmKG8hPT1zKXtjb25zdCBlPXRoaXMubm9uUHJvY2Vzc2VkQXJncztmb3IoO28+czspe2UucHVzaCh0LnNoaWZ0KCkpO28tLX1mb3IoO288cyYmMCE9PWUubGVuZ3RoOyl7bnVsbD09PXQmJih0PVtdKTt0LnVuc2hpZnQoZS5wb3AoKSk7bysrfX1pZihvPHMpe2NvbnN0IGU9YGNvbW1hbmQgJHthfTogZXhwZWN0ZWQgJHtzfSBhcmdzLCBidXQgcmVjZWl2ZWQgJHtvfSBhcmdzLmA7aWYodGhpcy5faXNQYXRoT3AmJisrdGhpcy5fbnVtSW52YWxpZFBhdGhPUFM+RXZhbHVhdG9yUHJlcHJvY2Vzc29yLk1BWF9JTlZBTElEX1BBVEhfT1BTKXRocm93IG5ldyBGb3JtYXRFcnJvcihgSW52YWxpZCAke2V9YCk7d2FybihgU2tpcHBpbmcgJHtlfWApO251bGwhPT10JiYodC5sZW5ndGg9MCk7Y29udGludWV9fXRoaXMucHJlcHJvY2Vzc0NvbW1hbmQoaSx0KTtlLmZuPWk7ZS5hcmdzPXQ7cmV0dXJuITB9aWYocj09PXNyKXJldHVybiExO2lmKG51bGwhPT1yKXtudWxsPT09dCYmKHQ9W10pO3QucHVzaChyKTtpZih0Lmxlbmd0aD4zMyl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIlRvbyBtYW55IGFyZ3VtZW50cyIpfX19cHJlcHJvY2Vzc0NvbW1hbmQoZSx0KXtzd2l0Y2goMHxlKXtjYXNlIHllOnRoaXMuc3RhdGVNYW5hZ2VyLnNhdmUoKTticmVhaztjYXNlIHdlOnRoaXMuc3RhdGVNYW5hZ2VyLnJlc3RvcmUoKTticmVhaztjYXNlIHhlOnRoaXMuc3RhdGVNYW5hZ2VyLnRyYW5zZm9ybSh0KX19fWNsYXNzIERlZmF1bHRBcHBlYXJhbmNlRXZhbHVhdG9yIGV4dGVuZHMgRXZhbHVhdG9yUHJlcHJvY2Vzc29ye2NvbnN0cnVjdG9yKGUpe3N1cGVyKG5ldyBTdHJpbmdTdHJlYW0oZSkpfXBhcnNlKCl7Y29uc3QgZT17Zm46MCxhcmdzOltdfSx0PXtmb250U2l6ZTowLGZvbnROYW1lOiIiLGZvbnRDb2xvcjpuZXcgVWludDhDbGFtcGVkQXJyYXkoMyl9O3RyeXtmb3IoOzspe2UuYXJncy5sZW5ndGg9MDtpZighdGhpcy5yZWFkKGUpKWJyZWFrO2lmKDAhPT10aGlzLnNhdmVkU3RhdGVzRGVwdGgpY29udGludWU7Y29uc3R7Zm46cixhcmdzOmF9PWU7c3dpdGNoKDB8cil7Y2FzZSB6ZTpjb25zdFtlLHJdPWE7ZSBpbnN0YW5jZW9mIE5hbWUmJih0LmZvbnROYW1lPWUubmFtZSk7Im51bWJlciI9PXR5cGVvZiByJiZyPjAmJih0LmZvbnRTaXplPXIpO2JyZWFrO2Nhc2UgZ3Q6Q29sb3JTcGFjZVV0aWxzLnJnYi5nZXRSZ2JJdGVtKGEsMCx0LmZvbnRDb2xvciwwKTticmVhaztjYXNlIGR0OkNvbG9yU3BhY2VVdGlscy5ncmF5LmdldFJnYkl0ZW0oYSwwLHQuZm9udENvbG9yLDApO2JyZWFrO2Nhc2UgbXQ6Q29sb3JTcGFjZVV0aWxzLmNteWsuZ2V0UmdiSXRlbShhLDAsdC5mb250Q29sb3IsMCl9fX1jYXRjaChlKXt3YXJuKGBwYXJzZURlZmF1bHRBcHBlYXJhbmNlIC0gaWdub3JpbmcgZXJyb3JzOiAiJHtlfSIuYCl9cmV0dXJuIHR9fWZ1bmN0aW9uIHBhcnNlRGVmYXVsdEFwcGVhcmFuY2UoZSl7cmV0dXJuIG5ldyBEZWZhdWx0QXBwZWFyYW5jZUV2YWx1YXRvcihlKS5wYXJzZSgpfWNsYXNzIEFwcGVhcmFuY2VTdHJlYW1FdmFsdWF0b3IgZXh0ZW5kcyBFdmFsdWF0b3JQcmVwcm9jZXNzb3J7Y29uc3RydWN0b3IoZSx0LHIsYSl7c3VwZXIoZSk7dGhpcy5zdHJlYW09ZTt0aGlzLmV2YWx1YXRvck9wdGlvbnM9dDt0aGlzLnhyZWY9cjt0aGlzLmdsb2JhbENvbG9yU3BhY2VDYWNoZT1hO3RoaXMucmVzb3VyY2VzPWUuZGljdD8uZ2V0KCJSZXNvdXJjZXMiKX1wYXJzZSgpe2NvbnN0IGU9e2ZuOjAsYXJnczpbXX07bGV0IHQ9e3NjYWxlRmFjdG9yOjEsZm9udFNpemU6MCxmb250TmFtZToiIixmb250Q29sb3I6bmV3IFVpbnQ4Q2xhbXBlZEFycmF5KDMpLGZpbGxDb2xvclNwYWNlOkNvbG9yU3BhY2VVdGlscy5ncmF5fSxyPSExO2NvbnN0IGE9W107dHJ5e2Zvcig7Oyl7ZS5hcmdzLmxlbmd0aD0wO2lmKHJ8fCF0aGlzLnJlYWQoZSkpYnJlYWs7Y29uc3R7Zm46bixhcmdzOml9PWU7c3dpdGNoKDB8bil7Y2FzZSB5ZTphLnB1c2goe3NjYWxlRmFjdG9yOnQuc2NhbGVGYWN0b3IsZm9udFNpemU6dC5mb250U2l6ZSxmb250TmFtZTp0LmZvbnROYW1lLGZvbnRDb2xvcjp0LmZvbnRDb2xvci5zbGljZSgpLGZpbGxDb2xvclNwYWNlOnQuZmlsbENvbG9yU3BhY2V9KTticmVhaztjYXNlIHdlOnQ9YS5wb3AoKXx8dDticmVhaztjYXNlIEplOnQuc2NhbGVGYWN0b3IqPU1hdGguaHlwb3QoaVswXSxpWzFdKTticmVhaztjYXNlIHplOmNvbnN0W2Usbl09aTtlIGluc3RhbmNlb2YgTmFtZSYmKHQuZm9udE5hbWU9ZS5uYW1lKTsibnVtYmVyIj09dHlwZW9mIG4mJm4+MCYmKHQuZm9udFNpemU9bip0LnNjYWxlRmFjdG9yKTticmVhaztjYXNlIHN0OnQuZmlsbENvbG9yU3BhY2U9Q29sb3JTcGFjZVV0aWxzLnBhcnNlKHtjczppWzBdLHhyZWY6dGhpcy54cmVmLHJlc291cmNlczp0aGlzLnJlc291cmNlcyxwZGZGdW5jdGlvbkZhY3Rvcnk6dGhpcy5fcGRmRnVuY3Rpb25GYWN0b3J5LGdsb2JhbENvbG9yU3BhY2VDYWNoZTp0aGlzLmdsb2JhbENvbG9yU3BhY2VDYWNoZSxsb2NhbENvbG9yU3BhY2VDYWNoZTp0aGlzLl9sb2NhbENvbG9yU3BhY2VDYWNoZX0pO2JyZWFrO2Nhc2UgbHQ6dC5maWxsQ29sb3JTcGFjZS5nZXRSZ2JJdGVtKGksMCx0LmZvbnRDb2xvciwwKTticmVhaztjYXNlIGd0OkNvbG9yU3BhY2VVdGlscy5yZ2IuZ2V0UmdiSXRlbShpLDAsdC5mb250Q29sb3IsMCk7YnJlYWs7Y2FzZSBkdDpDb2xvclNwYWNlVXRpbHMuZ3JheS5nZXRSZ2JJdGVtKGksMCx0LmZvbnRDb2xvciwwKTticmVhaztjYXNlIG10OkNvbG9yU3BhY2VVdGlscy5jbXlrLmdldFJnYkl0ZW0oaSwwLHQuZm9udENvbG9yLDApO2JyZWFrO2Nhc2UgWmU6Y2FzZSBRZTpjYXNlIGV0OmNhc2UgdHQ6cj0hMH19fWNhdGNoKGUpe3dhcm4oYHBhcnNlQXBwZWFyYW5jZVN0cmVhbSAtIGlnbm9yaW5nIGVycm9yczogIiR7ZX0iLmApfXRoaXMuc3RyZWFtLnJlc2V0KCk7ZGVsZXRlIHQuc2NhbGVGYWN0b3I7ZGVsZXRlIHQuZmlsbENvbG9yU3BhY2U7cmV0dXJuIHR9Z2V0IF9sb2NhbENvbG9yU3BhY2VDYWNoZSgpe3JldHVybiBzaGFkb3codGhpcywiX2xvY2FsQ29sb3JTcGFjZUNhY2hlIixuZXcgTG9jYWxDb2xvclNwYWNlQ2FjaGUpfWdldCBfcGRmRnVuY3Rpb25GYWN0b3J5KCl7cmV0dXJuIHNoYWRvdyh0aGlzLCJfcGRmRnVuY3Rpb25GYWN0b3J5IixuZXcgUERGRnVuY3Rpb25GYWN0b3J5KHt4cmVmOnRoaXMueHJlZixpc0V2YWxTdXBwb3J0ZWQ6dGhpcy5ldmFsdWF0b3JPcHRpb25zLmlzRXZhbFN1cHBvcnRlZH0pKX19ZnVuY3Rpb24gZ2V0UGRmQ29sb3IoZSx0KXtpZihlWzBdPT09ZVsxXSYmZVsxXT09PWVbMl0pe3JldHVybmAke251bWJlclRvU3RyaW5nKGVbMF0vMjU1KX0gJHt0PyJnIjoiRyJ9YH1yZXR1cm4gQXJyYXkuZnJvbShlLGU9Pm51bWJlclRvU3RyaW5nKGUvMjU1KSkuam9pbigiICIpKyIgIisodD8icmciOiJSRyIpfWNsYXNzIEZha2VVbmljb2RlRm9udHtjb25zdHJ1Y3RvcihlLHQpe3RoaXMueHJlZj1lO3RoaXMud2lkdGhzPW51bGw7dGhpcy5maXJzdENoYXI9MS8wO3RoaXMubGFzdENoYXI9LTEvMDt0aGlzLmZvbnRGYW1pbHk9dDtjb25zdCByPW5ldyBPZmZzY3JlZW5DYW52YXMoMSwxKTt0aGlzLmN0eE1lYXN1cmU9ci5nZXRDb250ZXh0KCIyZCIse3dpbGxSZWFkRnJlcXVlbnRseTohMH0pO0Zha2VVbmljb2RlRm9udC5fZm9udE5hbWVJZHx8KEZha2VVbmljb2RlRm9udC5fZm9udE5hbWVJZD0xKTt0aGlzLmZvbnROYW1lPU5hbWUuZ2V0KGBJbnZhbGlkUERGanNGb250XyR7dH1fJHtGYWtlVW5pY29kZUZvbnQuX2ZvbnROYW1lSWQrK31gKX1nZXQgZm9udERlc2NyaXB0b3JSZWYoKXtpZighRmFrZVVuaWNvZGVGb250Ll9mb250RGVzY3JpcHRvclJlZil7Y29uc3QgZT1uZXcgRGljdCh0aGlzLnhyZWYpO2Uuc2V0SWZOYW1lKCJUeXBlIiwiRm9udERlc2NyaXB0b3IiKTtlLnNldCgiRm9udE5hbWUiLHRoaXMuZm9udE5hbWUpO2Uuc2V0KCJGb250RmFtaWx5IiwiTXlyaWFkUHJvIFJlZ3VsYXIiKTtlLnNldCgiRm9udEJCb3giLFswLDAsMCwwXSk7ZS5zZXRJZk5hbWUoIkZvbnRTdHJldGNoIiwiTm9ybWFsIik7ZS5zZXQoIkZvbnRXZWlnaHQiLDQwMCk7ZS5zZXQoIkl0YWxpY0FuZ2xlIiwwKTtGYWtlVW5pY29kZUZvbnQuX2ZvbnREZXNjcmlwdG9yUmVmPXRoaXMueHJlZi5nZXROZXdQZXJzaXN0ZW50UmVmKGUpfXJldHVybiBGYWtlVW5pY29kZUZvbnQuX2ZvbnREZXNjcmlwdG9yUmVmfWdldCBkZXNjZW5kYW50Rm9udFJlZigpe2NvbnN0IGU9bmV3IERpY3QodGhpcy54cmVmKTtlLnNldCgiQmFzZUZvbnQiLHRoaXMuZm9udE5hbWUpO2Uuc2V0SWZOYW1lKCJUeXBlIiwiRm9udCIpO2Uuc2V0SWZOYW1lKCJTdWJ0eXBlIiwiQ0lERm9udFR5cGUwIik7ZS5zZXRJZk5hbWUoIkNJRFRvR0lETWFwIiwiSWRlbnRpdHkiKTtlLnNldCgiRmlyc3RDaGFyIix0aGlzLmZpcnN0Q2hhcik7ZS5zZXQoIkxhc3RDaGFyIix0aGlzLmxhc3RDaGFyKTtlLnNldCgiRm9udERlc2NyaXB0b3IiLHRoaXMuZm9udERlc2NyaXB0b3JSZWYpO2Uuc2V0KCJEVyIsMWUzKTtjb25zdCB0PVtdLHI9Wy4uLnRoaXMud2lkdGhzLmVudHJpZXMoKV0uc29ydCgpO2xldCBhPW51bGwsbj1udWxsO2Zvcihjb25zdFtlLGldb2YgcilpZihhKWlmKGU9PT1hK24ubGVuZ3RoKW4ucHVzaChpKTtlbHNle3QucHVzaChhLG4pO2E9ZTtuPVtpXX1lbHNle2E9ZTtuPVtpXX1hJiZ0LnB1c2goYSxuKTtlLnNldCgiVyIsdCk7Y29uc3QgaT1uZXcgRGljdCh0aGlzLnhyZWYpO2kuc2V0KCJPcmRlcmluZyIsIklkZW50aXR5Iik7aS5zZXQoIlJlZ2lzdHJ5IiwiQWRvYmUiKTtpLnNldCgiU3VwcGxlbWVudCIsMCk7ZS5zZXQoIkNJRFN5c3RlbUluZm8iLGkpO3JldHVybiB0aGlzLnhyZWYuZ2V0TmV3UGVyc2lzdGVudFJlZihlKX1nZXQgYmFzZUZvbnRSZWYoKXtjb25zdCBlPW5ldyBEaWN0KHRoaXMueHJlZik7ZS5zZXQoIkJhc2VGb250Iix0aGlzLmZvbnROYW1lKTtlLnNldElmTmFtZSgiVHlwZSIsIkZvbnQiKTtlLnNldElmTmFtZSgiU3VidHlwZSIsIlR5cGUwIik7ZS5zZXRJZk5hbWUoIkVuY29kaW5nIiwiSWRlbnRpdHktSCIpO2Uuc2V0KCJEZXNjZW5kYW50Rm9udHMiLFt0aGlzLmRlc2NlbmRhbnRGb250UmVmXSk7ZS5zZXRJZk5hbWUoIlRvVW5pY29kZSIsIklkZW50aXR5LUgiKTtyZXR1cm4gdGhpcy54cmVmLmdldE5ld1BlcnNpc3RlbnRSZWYoZSl9Z2V0IHJlc291cmNlcygpe2NvbnN0IGU9bmV3IERpY3QodGhpcy54cmVmKSx0PW5ldyBEaWN0KHRoaXMueHJlZik7dC5zZXQodGhpcy5mb250TmFtZS5uYW1lLHRoaXMuYmFzZUZvbnRSZWYpO2Uuc2V0KCJGb250Iix0KTtyZXR1cm4gZX1fY3JlYXRlQ29udGV4dCgpe3RoaXMud2lkdGhzPW5ldyBNYXA7dGhpcy5jdHhNZWFzdXJlLmZvbnQ9YDEwMDBweCAke3RoaXMuZm9udEZhbWlseX1gO3JldHVybiB0aGlzLmN0eE1lYXN1cmV9Y3JlYXRlRm9udFJlc291cmNlcyhlKXtjb25zdCB0PXRoaXMuX2NyZWF0ZUNvbnRleHQoKTtmb3IoY29uc3QgciBvZiBlLnNwbGl0KC9cclxuP3xcbi8pKWZvcihjb25zdCBlIG9mIHIuc3BsaXQoIiIpKXtjb25zdCByPWUuY2hhckNvZGVBdCgwKTtpZih0aGlzLndpZHRocy5oYXMocikpY29udGludWU7Y29uc3QgYT10Lm1lYXN1cmVUZXh0KGUpLG49TWF0aC5jZWlsKGEud2lkdGgpO3RoaXMud2lkdGhzLnNldChyLG4pO3RoaXMuZmlyc3RDaGFyPU1hdGgubWluKHIsdGhpcy5maXJzdENoYXIpO3RoaXMubGFzdENoYXI9TWF0aC5tYXgocix0aGlzLmxhc3RDaGFyKX1yZXR1cm4gdGhpcy5yZXNvdXJjZXN9c3RhdGljIGdldEZpcnN0UG9zaXRpb25JbmZvKGUsdCxyKXtjb25zdFthLHMsbyxjXT1lO2xldCBsPW8tYSxoPWMtczt0JTE4MCE9MCYmKFtsLGhdPVtoLGxdKTtjb25zdCB1PW4qcjtyZXR1cm57Y29vcmRzOlswLGgraSpyLXVdLGJib3g6WzAsMCxsLGhdLG1hdHJpeDowIT09dD9nZXRSb3RhdGlvbk1hdHJpeCh0LGgsdSk6dm9pZCAwfX1jcmVhdGVBcHBlYXJhbmNlKGUsdCxyLGEscyxvKXtjb25zdCBjPXRoaXMuX2NyZWF0ZUNvbnRleHQoKSxsPVtdO2xldCBoPS0xLzA7Zm9yKGNvbnN0IHQgb2YgZS5zcGxpdCgvXHJcbj98XG4vKSl7bC5wdXNoKHQpO2NvbnN0IGU9Yy5tZWFzdXJlVGV4dCh0KS53aWR0aDtoPU1hdGgubWF4KGgsZSk7Zm9yKGNvbnN0IGUgb2YgY29kZVBvaW50SXRlcih0KSl7Y29uc3QgdD1TdHJpbmcuZnJvbUNvZGVQb2ludChlKTtsZXQgcj10aGlzLndpZHRocy5nZXQoZSk7aWYodm9pZCAwPT09cil7Y29uc3QgYT1jLm1lYXN1cmVUZXh0KHQpO3I9TWF0aC5jZWlsKGEud2lkdGgpO3RoaXMud2lkdGhzLnNldChlLHIpO3RoaXMuZmlyc3RDaGFyPU1hdGgubWluKGUsdGhpcy5maXJzdENoYXIpO3RoaXMubGFzdENoYXI9TWF0aC5tYXgoZSx0aGlzLmxhc3RDaGFyKX19fWgqPWEvMWUzO2NvbnN0W3UsZCxmLGddPXQ7bGV0IHA9Zi11LG09Zy1kO3IlMTgwIT0wJiYoW3AsbV09W20scF0pO2xldCBiPTE7aD5wJiYoYj1wL2gpO2xldCB5PTE7Y29uc3Qgdz1uKmEseD1pKmEsUz13KmwubGVuZ3RoO1M+bSYmKHk9bS9TKTtjb25zdCBrPWEqTWF0aC5taW4oYix5KSxDPVsicSIsYDAgMCAke251bWJlclRvU3RyaW5nKHApfSAke251bWJlclRvU3RyaW5nKG0pfSByZSBXIG5gLCJCVCIsYDEgMCAwIDEgMCAke251bWJlclRvU3RyaW5nKG0reCl9IFRtIDAgVGMgJHtnZXRQZGZDb2xvcihzLCEwKX1gLGAvJHt0aGlzLmZvbnROYW1lLm5hbWV9ICR7bnVtYmVyVG9TdHJpbmcoayl9IFRmYF0se3Jlc291cmNlczp2fT10aGlzO2lmKDEhPT0obz0ibnVtYmVyIj09dHlwZW9mIG8mJm8+PTAmJm88PTE/bzoxKSl7Qy5wdXNoKCIvUjAgZ3MiKTtjb25zdCBlPW5ldyBEaWN0KHRoaXMueHJlZiksdD1uZXcgRGljdCh0aGlzLnhyZWYpO3Quc2V0KCJjYSIsbyk7dC5zZXQoIkNBIixvKTt0LnNldElmTmFtZSgiVHlwZSIsIkV4dEdTdGF0ZSIpO2Uuc2V0KCJSMCIsdCk7di5zZXQoIkV4dEdTdGF0ZSIsZSl9Y29uc3QgVD1udW1iZXJUb1N0cmluZyh3KTtmb3IoY29uc3QgZSBvZiBsKUMucHVzaChgMCAtJHtUfSBUZCA8JHtzdHJpbmdUb1VURjE2SGV4U3RyaW5nKGUpfT4gVGpgKTtDLnB1c2goIkVUIiwiUSIpO2NvbnN0IE89Qy5qb2luKCJcbiIpLE09bmV3IERpY3QodGhpcy54cmVmKTtNLnNldElmTmFtZSgiU3VidHlwZSIsIkZvcm0iKTtNLnNldElmTmFtZSgiVHlwZSIsIlhPYmplY3QiKTtNLnNldCgiQkJveCIsWzAsMCxwLG1dKTtNLnNldCgiTGVuZ3RoIixPLmxlbmd0aCk7TS5zZXQoIlJlc291cmNlcyIsdik7aWYocil7Y29uc3QgZT1nZXRSb3RhdGlvbk1hdHJpeChyLHAsbSk7TS5zZXQoIk1hdHJpeCIsZSl9Y29uc3QgRD1uZXcgU3RyaW5nU3RyZWFtKE8pO0QuZGljdD1NO3JldHVybiBEfX1jb25zdCBTaT1bIm0vZCIsIm0vZC95eSIsIm1tL2RkL3l5IiwibW0veXkiLCJkLW1tbSIsImQtbW1tLXl5IiwiZGQtbW1tLXl5IiwieXktbW0tZGQiLCJtbW0teXkiLCJtbW1tLXl5IiwibW1tIGQsIHl5eXkiLCJtbW1tIGQsIHl5eXkiLCJtL2QveXkgaDpNTSB0dCIsIm0vZC95eSBISDpNTSJdLEFpPVsiSEg6TU0iLCJoOk1NIHR0IiwiSEg6TU06c3MiLCJoOk1NOnNzIHR0Il07Y2xhc3MgTmFtZU9yTnVtYmVyVHJlZXtjb25zdHJ1Y3RvcihlLHQscil7dGhpcy5yb290PWU7dGhpcy54cmVmPXQ7dGhpcy5fdHlwZT1yfWdldEFsbCgpe2NvbnN0IGU9bmV3IE1hcDtpZighdGhpcy5yb290KXJldHVybiBlO2NvbnN0IHQ9dGhpcy54cmVmLHI9bmV3IFJlZlNldDtyLnB1dCh0aGlzLnJvb3QpO2NvbnN0IGE9W3RoaXMucm9vdF07Zm9yKDthLmxlbmd0aD4wOyl7Y29uc3Qgbj10LmZldGNoSWZSZWYoYS5zaGlmdCgpKTtpZighKG4gaW5zdGFuY2VvZiBEaWN0KSljb250aW51ZTtpZihuLmhhcygiS2lkcyIpKXtjb25zdCBlPW4uZ2V0KCJLaWRzIik7aWYoIUFycmF5LmlzQXJyYXkoZSkpY29udGludWU7Zm9yKGNvbnN0IHQgb2YgZSl7aWYoci5oYXModCkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKGBEdXBsaWNhdGUgZW50cnkgaW4gIiR7dGhpcy5fdHlwZX0iIHRyZWUuYCk7YS5wdXNoKHQpO3IucHV0KHQpfWNvbnRpbnVlfWNvbnN0IGk9bi5nZXQodGhpcy5fdHlwZSk7aWYoQXJyYXkuaXNBcnJheShpKSlmb3IobGV0IHI9MCxhPWkubGVuZ3RoO3I8YTtyKz0yKWUuc2V0KHQuZmV0Y2hJZlJlZihpW3JdKSx0LmZldGNoSWZSZWYoaVtyKzFdKSl9cmV0dXJuIGV9Z2V0UmF3KGUpe2lmKCF0aGlzLnJvb3QpcmV0dXJuIG51bGw7Y29uc3QgdD10aGlzLnhyZWY7bGV0IHI9dC5mZXRjaElmUmVmKHRoaXMucm9vdCksYT0wO2Zvcig7ci5oYXMoIktpZHMiKTspe2lmKCsrYT4xMCl7d2FybihgU2VhcmNoIGRlcHRoIGxpbWl0IHJlYWNoZWQgZm9yICIke3RoaXMuX3R5cGV9IiB0cmVlLmApO3JldHVybiBudWxsfWNvbnN0IG49ci5nZXQoIktpZHMiKTtpZighQXJyYXkuaXNBcnJheShuKSlyZXR1cm4gbnVsbDtsZXQgaT0wLHM9bi5sZW5ndGgtMTtmb3IoO2k8PXM7KXtjb25zdCBhPWkrcz4+MSxvPXQuZmV0Y2hJZlJlZihuW2FdKSxjPW8uZ2V0KCJMaW1pdHMiKTtpZihlPHQuZmV0Y2hJZlJlZihjWzBdKSlzPWEtMTtlbHNle2lmKCEoZT50LmZldGNoSWZSZWYoY1sxXSkpKXtyPW87YnJlYWt9aT1hKzF9fWlmKGk+cylyZXR1cm4gbnVsbH1jb25zdCBuPXIuZ2V0KHRoaXMuX3R5cGUpO2lmKEFycmF5LmlzQXJyYXkobikpe2xldCByPTAsYT1uLmxlbmd0aC0yO2Zvcig7cjw9YTspe2NvbnN0IGk9cithPj4xLHM9aSsoMSZpKSxvPXQuZmV0Y2hJZlJlZihuW3NdKTtpZihlPG8pYT1zLTI7ZWxzZXtpZighKGU+bykpcmV0dXJuIG5bcysxXTtyPXMrMn19fXJldHVybiBudWxsfWdldChlKXtyZXR1cm4gdGhpcy54cmVmLmZldGNoSWZSZWYodGhpcy5nZXRSYXcoZSkpfX1jbGFzcyBOYW1lVHJlZSBleHRlbmRzIE5hbWVPck51bWJlclRyZWV7Y29uc3RydWN0b3IoZSx0KXtzdXBlcihlLHQsIk5hbWVzIil9fWNsYXNzIE51bWJlclRyZWUgZXh0ZW5kcyBOYW1lT3JOdW1iZXJUcmVle2NvbnN0cnVjdG9yKGUsdCl7c3VwZXIoZSx0LCJOdW1zIil9fWZ1bmN0aW9uIGNsZWFyR2xvYmFsQ2FjaGVzKCl7IWZ1bmN0aW9uIGNsZWFyUGF0dGVybkNhY2hlcygpe3BuPU9iamVjdC5jcmVhdGUobnVsbCl9KCk7IWZ1bmN0aW9uIGNsZWFyUHJpbWl0aXZlQ2FjaGVzKCl7b3I9T2JqZWN0LmNyZWF0ZShudWxsKTtjcj1PYmplY3QuY3JlYXRlKG51bGwpO2xyPU9iamVjdC5jcmVhdGUobnVsbCl9KCk7IWZ1bmN0aW9uIGNsZWFyVW5pY29kZUNhY2hlcygpe3dhLmNsZWFyKCl9KCk7SnB4SW1hZ2UuY2xlYW51cCgpfWZ1bmN0aW9uIHBpY2tQbGF0Zm9ybUl0ZW0oZSl7cmV0dXJuIGUgaW5zdGFuY2VvZiBEaWN0P2UuaGFzKCJVRiIpP2UuZ2V0KCJVRiIpOmUuaGFzKCJGIik/ZS5nZXQoIkYiKTplLmhhcygiVW5peCIpP2UuZ2V0KCJVbml4Iik6ZS5oYXMoIk1hYyIpP2UuZ2V0KCJNYWMiKTplLmhhcygiRE9TIik/ZS5nZXQoIkRPUyIpOm51bGw6bnVsbH1jbGFzcyBGaWxlU3BlY3sjb2U9ITE7Y29uc3RydWN0b3IoZSx0LHI9ITEpe2lmKGUgaW5zdGFuY2VvZiBEaWN0KXt0aGlzLnhyZWY9dDt0aGlzLnJvb3Q9ZTtlLmhhcygiRlMiKSYmKHRoaXMuZnM9ZS5nZXQoIkZTIikpO2UuaGFzKCJSRiIpJiZ3YXJuKCJSZWxhdGVkIGZpbGUgc3BlY2lmaWNhdGlvbnMgYXJlIG5vdCBzdXBwb3J0ZWQiKTtyfHwoZS5oYXMoIkVGIik/dGhpcy4jb2U9ITA6d2FybigiTm9uLWVtYmVkZGVkIGZpbGUgc3BlY2lmaWNhdGlvbnMgYXJlIG5vdCBzdXBwb3J0ZWQiKSl9fWdldCBmaWxlbmFtZSgpe2xldCBlPSIiO2NvbnN0IHQ9cGlja1BsYXRmb3JtSXRlbSh0aGlzLnJvb3QpO3QmJiJzdHJpbmciPT10eXBlb2YgdCYmKGU9c3RyaW5nVG9QREZTdHJpbmcodCwhMCkucmVwbGFjZUFsbCgiXFxcXCIsIlxcIikucmVwbGFjZUFsbCgiXFwvIiwiLyIpLnJlcGxhY2VBbGwoIlxcIiwiLyIpKTtyZXR1cm4gc2hhZG93KHRoaXMsImZpbGVuYW1lIixlfHwidW5uYW1lZCIpfWdldCBjb250ZW50KCl7aWYoIXRoaXMuI29lKXJldHVybiBudWxsO3RoaXMuX2NvbnRlbnRSZWZ8fD1waWNrUGxhdGZvcm1JdGVtKHRoaXMucm9vdD8uZ2V0KCJFRiIpKTtsZXQgZT1udWxsO2lmKHRoaXMuX2NvbnRlbnRSZWYpe2NvbnN0IHQ9dGhpcy54cmVmLmZldGNoSWZSZWYodGhpcy5fY29udGVudFJlZik7dCBpbnN0YW5jZW9mIEJhc2VTdHJlYW0/ZT10LmdldEJ5dGVzKCk6d2FybigiRW1iZWRkZWQgZmlsZSBzcGVjaWZpY2F0aW9uIHBvaW50cyB0byBub24tZXhpc3RpbmcvaW52YWxpZCBjb250ZW50Iil9ZWxzZSB3YXJuKCJFbWJlZGRlZCBmaWxlIHNwZWNpZmljYXRpb24gZG9lcyBub3QgaGF2ZSBhbnkgY29udGVudCIpO3JldHVybiBlfWdldCBkZXNjcmlwdGlvbigpe2xldCBlPSIiO2NvbnN0IHQ9dGhpcy5yb290Py5nZXQoIkRlc2MiKTt0JiYic3RyaW5nIj09dHlwZW9mIHQmJihlPXN0cmluZ1RvUERGU3RyaW5nKHQpKTtyZXR1cm4gc2hhZG93KHRoaXMsImRlc2NyaXB0aW9uIixlKX1nZXQgc2VyaWFsaXphYmxlKCl7cmV0dXJue3Jhd0ZpbGVuYW1lOnRoaXMuZmlsZW5hbWUsZmlsZW5hbWU6KGU9dGhpcy5maWxlbmFtZSxlLnN1YnN0cmluZyhlLmxhc3RJbmRleE9mKCIvIikrMSkpLGNvbnRlbnQ6dGhpcy5jb250ZW50LGRlc2NyaXB0aW9uOnRoaXMuZGVzY3JpcHRpb259O3ZhciBlfX1jb25zdCBraT0wLENpPS0yLHZpPS0zLEZpPS00LElpPS01LFRpPS02LE9pPS05O2Z1bmN0aW9uIGlzV2hpdGVzcGFjZShlLHQpe2NvbnN0IHI9ZVt0XTtyZXR1cm4iICI9PT1yfHwiXG4iPT09cnx8IlxyIj09PXJ8fCJcdCI9PT1yfWNsYXNzIFhNTFBhcnNlckJhc2V7X3Jlc29sdmVFbnRpdGllcyhlKXtyZXR1cm4gZS5yZXBsYWNlQWxsKC8mKFteO10rKTsvZywoZSx0KT0+e2lmKCIjeCI9PT10LnN1YnN0cmluZygwLDIpKXJldHVybiBTdHJpbmcuZnJvbUNvZGVQb2ludChwYXJzZUludCh0LnN1YnN0cmluZygyKSwxNikpO2lmKCIjIj09PXQuc3Vic3RyaW5nKDAsMSkpcmV0dXJuIFN0cmluZy5mcm9tQ29kZVBvaW50KHBhcnNlSW50KHQuc3Vic3RyaW5nKDEpLDEwKSk7c3dpdGNoKHQpe2Nhc2UibHQiOnJldHVybiI8IjtjYXNlImd0IjpyZXR1cm4iPiI7Y2FzZSJhbXAiOnJldHVybiImIjtjYXNlInF1b3QiOnJldHVybiciJztjYXNlImFwb3MiOnJldHVybiInIn1yZXR1cm4gdGhpcy5vblJlc29sdmVFbnRpdHkodCl9KX1fcGFyc2VDb250ZW50KGUsdCl7Y29uc3Qgcj1bXTtsZXQgYT10O2Z1bmN0aW9uIHNraXBXcygpe2Zvcig7YTxlLmxlbmd0aCYmaXNXaGl0ZXNwYWNlKGUsYSk7KSsrYX1mb3IoO2E8ZS5sZW5ndGgmJiFpc1doaXRlc3BhY2UoZSxhKSYmIj4iIT09ZVthXSYmIi8iIT09ZVthXTspKythO2NvbnN0IG49ZS5zdWJzdHJpbmcodCxhKTtza2lwV3MoKTtmb3IoO2E8ZS5sZW5ndGgmJiI+IiE9PWVbYV0mJiIvIiE9PWVbYV0mJiI/IiE9PWVbYV07KXtza2lwV3MoKTtsZXQgdD0iIixuPSIiO2Zvcig7YTxlLmxlbmd0aCYmIWlzV2hpdGVzcGFjZShlLGEpJiYiPSIhPT1lW2FdOyl7dCs9ZVthXTsrK2F9c2tpcFdzKCk7aWYoIj0iIT09ZVthXSlyZXR1cm4gbnVsbDsrK2E7c2tpcFdzKCk7Y29uc3QgaT1lW2FdO2lmKCciJyE9PWkmJiInIiE9PWkpcmV0dXJuIG51bGw7Y29uc3Qgcz1lLmluZGV4T2YoaSwrK2EpO2lmKHM8MClyZXR1cm4gbnVsbDtuPWUuc3Vic3RyaW5nKGEscyk7ci5wdXNoKHtuYW1lOnQsdmFsdWU6dGhpcy5fcmVzb2x2ZUVudGl0aWVzKG4pfSk7YT1zKzE7c2tpcFdzKCl9cmV0dXJue25hbWU6bixhdHRyaWJ1dGVzOnIscGFyc2VkOmEtdH19X3BhcnNlUHJvY2Vzc2luZ0luc3RydWN0aW9uKGUsdCl7bGV0IHI9dDtmb3IoO3I8ZS5sZW5ndGgmJiFpc1doaXRlc3BhY2UoZSxyKSYmIj4iIT09ZVtyXSYmIj8iIT09ZVtyXSYmIi8iIT09ZVtyXTspKytyO2NvbnN0IGE9ZS5zdWJzdHJpbmcodCxyKTshZnVuY3Rpb24gc2tpcFdzKCl7Zm9yKDtyPGUubGVuZ3RoJiZpc1doaXRlc3BhY2UoZSxyKTspKytyfSgpO2NvbnN0IG49cjtmb3IoO3I8ZS5sZW5ndGgmJigiPyIhPT1lW3JdfHwiPiIhPT1lW3IrMV0pOykrK3I7cmV0dXJue25hbWU6YSx2YWx1ZTplLnN1YnN0cmluZyhuLHIpLHBhcnNlZDpyLXR9fXBhcnNlWG1sKGUpe2xldCB0PTA7Zm9yKDt0PGUubGVuZ3RoOyl7bGV0IHI9dDtpZigiPCI9PT1lW3RdKXsrK3I7bGV0IHQ7c3dpdGNoKGVbcl0pe2Nhc2UiLyI6KytyO3Q9ZS5pbmRleE9mKCI+IixyKTtpZih0PDApe3RoaXMub25FcnJvcihPaSk7cmV0dXJufXRoaXMub25FbmRFbGVtZW50KGUuc3Vic3RyaW5nKHIsdCkpO3I9dCsxO2JyZWFrO2Nhc2UiPyI6KytyO2NvbnN0IGE9dGhpcy5fcGFyc2VQcm9jZXNzaW5nSW5zdHJ1Y3Rpb24oZSxyKTtpZigiPz4iIT09ZS5zdWJzdHJpbmcocithLnBhcnNlZCxyK2EucGFyc2VkKzIpKXt0aGlzLm9uRXJyb3IodmkpO3JldHVybn10aGlzLm9uUGkoYS5uYW1lLGEudmFsdWUpO3IrPWEucGFyc2VkKzI7YnJlYWs7Y2FzZSIhIjppZigiLS0iPT09ZS5zdWJzdHJpbmcocisxLHIrMykpe3Q9ZS5pbmRleE9mKCItLVx4M2UiLHIrMyk7aWYodDwwKXt0aGlzLm9uRXJyb3IoSWkpO3JldHVybn10aGlzLm9uQ29tbWVudChlLnN1YnN0cmluZyhyKzMsdCkpO3I9dCszfWVsc2UgaWYoIltDREFUQVsiPT09ZS5zdWJzdHJpbmcocisxLHIrOCkpe3Q9ZS5pbmRleE9mKCJdXT4iLHIrOCk7aWYodDwwKXt0aGlzLm9uRXJyb3IoQ2kpO3JldHVybn10aGlzLm9uQ2RhdGEoZS5zdWJzdHJpbmcocis4LHQpKTtyPXQrM31lbHNle2lmKCJET0NUWVBFIiE9PWUuc3Vic3RyaW5nKHIrMSxyKzgpKXt0aGlzLm9uRXJyb3IoVGkpO3JldHVybn17Y29uc3QgYT1lLmluZGV4T2YoIlsiLHIrOCk7bGV0IG49ITE7dD1lLmluZGV4T2YoIj4iLHIrOCk7aWYodDwwKXt0aGlzLm9uRXJyb3IoRmkpO3JldHVybn1pZihhPjAmJnQ+YSl7dD1lLmluZGV4T2YoIl0+IixyKzgpO2lmKHQ8MCl7dGhpcy5vbkVycm9yKEZpKTtyZXR1cm59bj0hMH1jb25zdCBpPWUuc3Vic3RyaW5nKHIrOCx0KyhuPzE6MCkpO3RoaXMub25Eb2N0eXBlKGkpO3I9dCsobj8yOjEpfX1icmVhaztkZWZhdWx0OmNvbnN0IG49dGhpcy5fcGFyc2VDb250ZW50KGUscik7aWYobnVsbD09PW4pe3RoaXMub25FcnJvcihUaSk7cmV0dXJufWxldCBpPSExO2lmKCIvPiI9PT1lLnN1YnN0cmluZyhyK24ucGFyc2VkLHIrbi5wYXJzZWQrMikpaT0hMDtlbHNlIGlmKCI+IiE9PWUuc3Vic3RyaW5nKHIrbi5wYXJzZWQscituLnBhcnNlZCsxKSl7dGhpcy5vbkVycm9yKE9pKTtyZXR1cm59dGhpcy5vbkJlZ2luRWxlbWVudChuLm5hbWUsbi5hdHRyaWJ1dGVzLGkpO3IrPW4ucGFyc2VkKyhpPzI6MSl9fWVsc2V7Zm9yKDtyPGUubGVuZ3RoJiYiPCIhPT1lW3JdOylyKys7Y29uc3QgYT1lLnN1YnN0cmluZyh0LHIpO3RoaXMub25UZXh0KHRoaXMuX3Jlc29sdmVFbnRpdGllcyhhKSl9dD1yfX1vblJlc29sdmVFbnRpdHkoZSl7cmV0dXJuYCYke2V9O2B9b25QaShlLHQpe31vbkNvbW1lbnQoZSl7fW9uQ2RhdGEoZSl7fW9uRG9jdHlwZShlKXt9b25UZXh0KGUpe31vbkJlZ2luRWxlbWVudChlLHQscil7fW9uRW5kRWxlbWVudChlKXt9b25FcnJvcihlKXt9fWNsYXNzIFNpbXBsZURPTU5vZGV7Y29uc3RydWN0b3IoZSx0KXt0aGlzLm5vZGVOYW1lPWU7dGhpcy5ub2RlVmFsdWU9dDtPYmplY3QuZGVmaW5lUHJvcGVydHkodGhpcywicGFyZW50Tm9kZSIse3ZhbHVlOm51bGwsd3JpdGFibGU6ITB9KX1nZXQgZmlyc3RDaGlsZCgpe3JldHVybiB0aGlzLmNoaWxkTm9kZXM/LlswXX1nZXQgbmV4dFNpYmxpbmcoKXtjb25zdCBlPXRoaXMucGFyZW50Tm9kZS5jaGlsZE5vZGVzO2lmKCFlKXJldHVybjtjb25zdCB0PWUuaW5kZXhPZih0aGlzKTtyZXR1cm4tMSE9PXQ/ZVt0KzFdOnZvaWQgMH1nZXQgdGV4dENvbnRlbnQoKXtyZXR1cm4gdGhpcy5jaGlsZE5vZGVzP3RoaXMuY2hpbGROb2Rlcy5tYXAoZT0+ZS50ZXh0Q29udGVudCkuam9pbigiIik6dGhpcy5ub2RlVmFsdWV8fCIifWdldCBjaGlsZHJlbigpe3JldHVybiB0aGlzLmNoaWxkTm9kZXN8fFtdfWhhc0NoaWxkTm9kZXMoKXtyZXR1cm4gdGhpcy5jaGlsZE5vZGVzPy5sZW5ndGg+MH1zZWFyY2hOb2RlKGUsdCl7aWYodD49ZS5sZW5ndGgpcmV0dXJuIHRoaXM7Y29uc3Qgcj1lW3RdO2lmKHIubmFtZS5zdGFydHNXaXRoKCIjIikmJnQ8ZS5sZW5ndGgtMSlyZXR1cm4gdGhpcy5zZWFyY2hOb2RlKGUsdCsxKTtjb25zdCBhPVtdO2xldCBuPXRoaXM7Zm9yKDs7KXtpZihyLm5hbWU9PT1uLm5vZGVOYW1lKXtpZigwIT09ci5wb3Mpe2lmKDA9PT1hLmxlbmd0aClyZXR1cm4gbnVsbDt7Y29uc3RbaV09YS5wb3AoKTtsZXQgcz0wO2Zvcihjb25zdCBhIG9mIGkuY2hpbGROb2RlcylpZihyLm5hbWU9PT1hLm5vZGVOYW1lKXtpZihzPT09ci5wb3MpcmV0dXJuIGEuc2VhcmNoTm9kZShlLHQrMSk7cysrfXJldHVybiBuLnNlYXJjaE5vZGUoZSx0KzEpfX17Y29uc3Qgcj1uLnNlYXJjaE5vZGUoZSx0KzEpO2lmKG51bGwhPT1yKXJldHVybiByfX1pZihuLmNoaWxkTm9kZXM/Lmxlbmd0aD4wKXthLnB1c2goW24sMF0pO249bi5jaGlsZE5vZGVzWzBdfWVsc2V7aWYoMD09PWEubGVuZ3RoKXJldHVybiBudWxsO2Zvcig7MCE9PWEubGVuZ3RoOyl7Y29uc3RbZSx0XT1hLnBvcCgpLHI9dCsxO2lmKHI8ZS5jaGlsZE5vZGVzLmxlbmd0aCl7YS5wdXNoKFtlLHJdKTtuPWUuY2hpbGROb2Rlc1tyXTticmVha319aWYoMD09PWEubGVuZ3RoKXJldHVybiBudWxsfX19ZHVtcChlKXtpZigiI3RleHQiIT09dGhpcy5ub2RlTmFtZSl7ZS5wdXNoKGA8JHt0aGlzLm5vZGVOYW1lfWApO2lmKHRoaXMuYXR0cmlidXRlcylmb3IoY29uc3QgdCBvZiB0aGlzLmF0dHJpYnV0ZXMpZS5wdXNoKGAgJHt0Lm5hbWV9PSIke2VuY29kZVRvWG1sU3RyaW5nKHQudmFsdWUpfSJgKTtpZih0aGlzLmhhc0NoaWxkTm9kZXMoKSl7ZS5wdXNoKCI+Iik7Zm9yKGNvbnN0IHQgb2YgdGhpcy5jaGlsZE5vZGVzKXQuZHVtcChlKTtlLnB1c2goYDwvJHt0aGlzLm5vZGVOYW1lfT5gKX1lbHNlIHRoaXMubm9kZVZhbHVlP2UucHVzaChgPiR7ZW5jb2RlVG9YbWxTdHJpbmcodGhpcy5ub2RlVmFsdWUpfTwvJHt0aGlzLm5vZGVOYW1lfT5gKTplLnB1c2goIi8+Iil9ZWxzZSBlLnB1c2goZW5jb2RlVG9YbWxTdHJpbmcodGhpcy5ub2RlVmFsdWUpKX19Y2xhc3MgU2ltcGxlWE1MUGFyc2VyIGV4dGVuZHMgWE1MUGFyc2VyQmFzZXtjb25zdHJ1Y3Rvcih7aGFzQXR0cmlidXRlczplPSExLGxvd2VyQ2FzZU5hbWU6dD0hMX0pe3N1cGVyKCk7dGhpcy5fY3VycmVudEZyYWdtZW50PW51bGw7dGhpcy5fc3RhY2s9bnVsbDt0aGlzLl9lcnJvckNvZGU9a2k7dGhpcy5faGFzQXR0cmlidXRlcz1lO3RoaXMuX2xvd2VyQ2FzZU5hbWU9dH1wYXJzZUZyb21TdHJpbmcoZSl7dGhpcy5fY3VycmVudEZyYWdtZW50PVtdO3RoaXMuX3N0YWNrPVtdO3RoaXMuX2Vycm9yQ29kZT1raTt0aGlzLnBhcnNlWG1sKGUpO2lmKHRoaXMuX2Vycm9yQ29kZSE9PWtpKXJldHVybjtjb25zdFt0XT10aGlzLl9jdXJyZW50RnJhZ21lbnQ7cmV0dXJuIHQ/e2RvY3VtZW50RWxlbWVudDp0fTp2b2lkIDB9b25UZXh0KGUpe2lmKGZ1bmN0aW9uIGlzV2hpdGVzcGFjZVN0cmluZyhlKXtmb3IobGV0IHQ9MCxyPWUubGVuZ3RoO3Q8cjt0KyspaWYoIWlzV2hpdGVzcGFjZShlLHQpKXJldHVybiExO3JldHVybiEwfShlKSlyZXR1cm47Y29uc3QgdD1uZXcgU2ltcGxlRE9NTm9kZSgiI3RleHQiLGUpO3RoaXMuX2N1cnJlbnRGcmFnbWVudC5wdXNoKHQpfW9uQ2RhdGEoZSl7Y29uc3QgdD1uZXcgU2ltcGxlRE9NTm9kZSgiI3RleHQiLGUpO3RoaXMuX2N1cnJlbnRGcmFnbWVudC5wdXNoKHQpfW9uQmVnaW5FbGVtZW50KGUsdCxyKXt0aGlzLl9sb3dlckNhc2VOYW1lJiYoZT1lLnRvTG93ZXJDYXNlKCkpO2NvbnN0IGE9bmV3IFNpbXBsZURPTU5vZGUoZSk7YS5jaGlsZE5vZGVzPVtdO3RoaXMuX2hhc0F0dHJpYnV0ZXMmJihhLmF0dHJpYnV0ZXM9dCk7dGhpcy5fY3VycmVudEZyYWdtZW50LnB1c2goYSk7aWYoIXIpe3RoaXMuX3N0YWNrLnB1c2godGhpcy5fY3VycmVudEZyYWdtZW50KTt0aGlzLl9jdXJyZW50RnJhZ21lbnQ9YS5jaGlsZE5vZGVzfX1vbkVuZEVsZW1lbnQoZSl7dGhpcy5fY3VycmVudEZyYWdtZW50PXRoaXMuX3N0YWNrLnBvcCgpfHxbXTtjb25zdCB0PXRoaXMuX2N1cnJlbnRGcmFnbWVudC5hdCgtMSk7aWYoIXQpcmV0dXJuIG51bGw7Zm9yKGNvbnN0IGUgb2YgdC5jaGlsZE5vZGVzKWUucGFyZW50Tm9kZT10O3JldHVybiB0fW9uRXJyb3IoZSl7dGhpcy5fZXJyb3JDb2RlPWV9fWNsYXNzIE1ldGFkYXRhUGFyc2Vye2NvbnN0cnVjdG9yKGUpe2U9dGhpcy5fcmVwYWlyKGUpO2NvbnN0IHQ9bmV3IFNpbXBsZVhNTFBhcnNlcih7bG93ZXJDYXNlTmFtZTohMH0pLnBhcnNlRnJvbVN0cmluZyhlKTt0aGlzLl9tZXRhZGF0YU1hcD1uZXcgTWFwO3RoaXMuX2RhdGE9ZTt0JiZ0aGlzLl9wYXJzZSh0KX1fcmVwYWlyKGUpe3JldHVybiBlLnJlcGxhY2UoL15bXjxdKy8sIiIpLnJlcGxhY2VBbGwoLz5cXDM3NlxcMzc3KFtePF0rKS9nLGZ1bmN0aW9uKGUsdCl7Y29uc3Qgcj10LnJlcGxhY2VBbGwoL1xcKFswLTNdKShbMC03XSkoWzAtN10pL2csZnVuY3Rpb24oZSx0LHIsYSl7cmV0dXJuIFN0cmluZy5mcm9tQ2hhckNvZGUoNjQqdCs4KnIrMSphKX0pLnJlcGxhY2VBbGwoLyYoYW1wfGFwb3N8Z3R8bHR8cXVvdCk7L2csZnVuY3Rpb24oZSx0KXtzd2l0Y2godCl7Y2FzZSJhbXAiOnJldHVybiImIjtjYXNlImFwb3MiOnJldHVybiInIjtjYXNlImd0IjpyZXR1cm4iPiI7Y2FzZSJsdCI6cmV0dXJuIjwiO2Nhc2UicXVvdCI6cmV0dXJuJyInfXRocm93IG5ldyBFcnJvcihgX3JlcGFpcjogJHt0fSBpc24ndCBkZWZpbmVkLmApfSksYT1bIj4iXTtmb3IobGV0IGU9MCx0PXIubGVuZ3RoO2U8dDtlKz0yKXtjb25zdCB0PTI1NipyLmNoYXJDb2RlQXQoZSkrci5jaGFyQ29kZUF0KGUrMSk7dD49MzImJnQ8MTI3JiY2MCE9PXQmJjYyIT09dCYmMzghPT10P2EucHVzaChTdHJpbmcuZnJvbUNoYXJDb2RlKHQpKTphLnB1c2goIiYjeCIrKDY1NTM2K3QpLnRvU3RyaW5nKDE2KS5zdWJzdHJpbmcoMSkrIjsiKX1yZXR1cm4gYS5qb2luKCIiKX0pfV9nZXRTZXF1ZW5jZShlKXtjb25zdCB0PWUubm9kZU5hbWU7cmV0dXJuInJkZjpiYWciIT09dCYmInJkZjpzZXEiIT09dCYmInJkZjphbHQiIT09dD9udWxsOmUuY2hpbGROb2Rlcy5maWx0ZXIoZT0+InJkZjpsaSI9PT1lLm5vZGVOYW1lKX1fcGFyc2VBcnJheShlKXtpZighZS5oYXNDaGlsZE5vZGVzKCkpcmV0dXJuO2NvbnN0W3RdPWUuY2hpbGROb2RlcyxyPXRoaXMuX2dldFNlcXVlbmNlKHQpfHxbXTt0aGlzLl9tZXRhZGF0YU1hcC5zZXQoZS5ub2RlTmFtZSxyLm1hcChlPT5lLnRleHRDb250ZW50LnRyaW0oKSkpfV9wYXJzZShlKXtsZXQgdD1lLmRvY3VtZW50RWxlbWVudDtpZigicmRmOnJkZiIhPT10Lm5vZGVOYW1lKXt0PXQuZmlyc3RDaGlsZDtmb3IoO3QmJiJyZGY6cmRmIiE9PXQubm9kZU5hbWU7KXQ9dC5uZXh0U2libGluZ31pZih0JiYicmRmOnJkZiI9PT10Lm5vZGVOYW1lJiZ0Lmhhc0NoaWxkTm9kZXMoKSlmb3IoY29uc3QgZSBvZiB0LmNoaWxkTm9kZXMpaWYoInJkZjpkZXNjcmlwdGlvbiI9PT1lLm5vZGVOYW1lKWZvcihjb25zdCB0IG9mIGUuY2hpbGROb2Rlcyl7Y29uc3QgZT10Lm5vZGVOYW1lO3N3aXRjaChlKXtjYXNlIiN0ZXh0Ijpjb250aW51ZTtjYXNlImRjOmNyZWF0b3IiOmNhc2UiZGM6c3ViamVjdCI6dGhpcy5fcGFyc2VBcnJheSh0KTtjb250aW51ZX10aGlzLl9tZXRhZGF0YU1hcC5zZXQoZSx0LnRleHRDb250ZW50LnRyaW0oKSl9fWdldCBzZXJpYWxpemFibGUoKXtyZXR1cm57cGFyc2VkRGF0YTp0aGlzLl9tZXRhZGF0YU1hcCxyYXdEYXRhOnRoaXMuX2RhdGF9fX1jb25zdCBNaT0xLERpPTIsQmk9MyxSaT00LEVpPTU7Y2xhc3MgU3RydWN0VHJlZVJvb3R7Y29uc3RydWN0b3IoZSx0LHIpe3RoaXMueHJlZj1lO3RoaXMuZGljdD10O3RoaXMucmVmPXIgaW5zdGFuY2VvZiBSZWY/cjpudWxsO3RoaXMucm9sZU1hcD1uZXcgTWFwO3RoaXMuc3RydWN0UGFyZW50SWRzPW51bGx9aW5pdCgpe3RoaXMucmVhZFJvbGVNYXAoKX0jY2UoZSx0LHIpe2lmKCEoZSBpbnN0YW5jZW9mIFJlZil8fHQ8MClyZXR1cm47dGhpcy5zdHJ1Y3RQYXJlbnRJZHN8fD1uZXcgUmVmU2V0Q2FjaGU7bGV0IGE9dGhpcy5zdHJ1Y3RQYXJlbnRJZHMuZ2V0KGUpO2lmKCFhKXthPVtdO3RoaXMuc3RydWN0UGFyZW50SWRzLnB1dChlLGEpfWEucHVzaChbdCxyXSl9YWRkQW5ub3RhdGlvbklkVG9QYWdlKGUsdCl7dGhpcy4jY2UoZSx0LFJpKX1yZWFkUm9sZU1hcCgpe2NvbnN0IGU9dGhpcy5kaWN0LmdldCgiUm9sZU1hcCIpO2lmKGUgaW5zdGFuY2VvZiBEaWN0KWZvcihjb25zdFt0LHJdb2YgZSlyIGluc3RhbmNlb2YgTmFtZSYmdGhpcy5yb2xlTWFwLnNldCh0LHIubmFtZSl9c3RhdGljIGFzeW5jIGNhbkNyZWF0ZVN0cnVjdHVyZVRyZWUoe2NhdGFsb2dSZWY6ZSxwZGZNYW5hZ2VyOnQsbmV3QW5ub3RhdGlvbnNCeVBhZ2U6cn0pe2lmKCEoZSBpbnN0YW5jZW9mIFJlZikpe3dhcm4oIkNhbm5vdCBzYXZlIHRoZSBzdHJ1Y3QgdHJlZTogbm8gY2F0YWxvZyByZWZlcmVuY2UuIik7cmV0dXJuITF9bGV0IGE9MCxuPSEwO2Zvcihjb25zdFtlLGldb2Ygcil7Y29uc3R7cmVmOnJ9PWF3YWl0IHQuZ2V0UGFnZShlKTtpZighKHIgaW5zdGFuY2VvZiBSZWYpKXt3YXJuKGBDYW5ub3Qgc2F2ZSB0aGUgc3RydWN0IHRyZWU6IHBhZ2UgJHtlfSBoYXMgbm8gcmVmLmApO249ITA7YnJlYWt9Zm9yKGNvbnN0IGUgb2YgaSlpZihlLmFjY2Vzc2liaWxpdHlEYXRhPy50eXBlKXtlLnBhcmVudFRyZWVJZD1hKys7bj0hMX19aWYobil7Zm9yKGNvbnN0IGUgb2Ygci52YWx1ZXMoKSlmb3IoY29uc3QgdCBvZiBlKWRlbGV0ZSB0LnBhcmVudFRyZWVJZDtyZXR1cm4hMX1yZXR1cm4hMH1zdGF0aWMgYXN5bmMgY3JlYXRlU3RydWN0dXJlVHJlZSh7bmV3QW5ub3RhdGlvbnNCeVBhZ2U6ZSx4cmVmOnQsY2F0YWxvZ1JlZjpyLHBkZk1hbmFnZXI6YSxjaGFuZ2VzOm59KXtjb25zdCBpPWF3YWl0IGEuZW5zdXJlQ2F0YWxvZygiY2xvbmVEaWN0Iikscz1uZXcgUmVmU2V0Q2FjaGU7cy5wdXQocixpKTtjb25zdCBvPXQuZ2V0TmV3VGVtcG9yYXJ5UmVmKCk7aS5zZXQoIlN0cnVjdFRyZWVSb290IixvKTtjb25zdCBjPW5ldyBEaWN0KHQpO2Muc2V0KCJUeXBlIixOYW1lLmdldCgiU3RydWN0VHJlZVJvb3QiKSk7Y29uc3QgbD10LmdldE5ld1RlbXBvcmFyeVJlZigpO2Muc2V0KCJQYXJlbnRUcmVlIixsKTtjb25zdCBoPVtdO2Muc2V0KCJLIixoKTtzLnB1dChvLGMpO2NvbnN0IHU9bmV3IERpY3QodCksZD1bXTt1LnNldCgiTnVtcyIsZCk7Y29uc3QgZj1hd2FpdCB0aGlzLiNsZSh7bmV3QW5ub3RhdGlvbnNCeVBhZ2U6ZSxzdHJ1Y3RUcmVlUm9vdFJlZjpvLHN0cnVjdFRyZWVSb290Om51bGwsa2lkczpoLG51bXM6ZCx4cmVmOnQscGRmTWFuYWdlcjphLGNoYW5nZXM6bixjYWNoZTpzfSk7Yy5zZXQoIlBhcmVudFRyZWVOZXh0S2V5IixmKTtzLnB1dChsLHUpO2Zvcihjb25zdFtlLHRdb2Ygcy5pdGVtcygpKW4ucHV0KGUse2RhdGE6dH0pfWFzeW5jIGNhblVwZGF0ZVN0cnVjdFRyZWUoe3BkZk1hbmFnZXI6ZSxuZXdBbm5vdGF0aW9uc0J5UGFnZTp0fSl7aWYoIXRoaXMucmVmKXt3YXJuKCJDYW5ub3QgdXBkYXRlIHRoZSBzdHJ1Y3QgdHJlZTogbm8gcm9vdCByZWZlcmVuY2UuIik7cmV0dXJuITF9bGV0IHI9dGhpcy5kaWN0LmdldCgiUGFyZW50VHJlZU5leHRLZXkiKTtpZighTnVtYmVyLmlzSW50ZWdlcihyKXx8cjwwKXt3YXJuKCJDYW5ub3QgdXBkYXRlIHRoZSBzdHJ1Y3QgdHJlZTogaW52YWxpZCBuZXh0IGtleS4iKTtyZXR1cm4hMX1jb25zdCBhPXRoaXMuZGljdC5nZXQoIlBhcmVudFRyZWUiKTtpZighKGEgaW5zdGFuY2VvZiBEaWN0KSl7d2FybigiQ2Fubm90IHVwZGF0ZSB0aGUgc3RydWN0IHRyZWU6IFBhcmVudFRyZWUgaXNuJ3QgYSBkaWN0LiIpO3JldHVybiExfWNvbnN0IG49YS5nZXQoIk51bXMiKTtpZighQXJyYXkuaXNBcnJheShuKSl7d2FybigiQ2Fubm90IHVwZGF0ZSB0aGUgc3RydWN0IHRyZWU6IG51bXMgaXNuJ3QgYW4gYXJyYXkuIik7cmV0dXJuITF9Y29uc3QgaT1uZXcgTnVtYmVyVHJlZShhLHRoaXMueHJlZik7Zm9yKGNvbnN0IHIgb2YgdC5rZXlzKCkpe2NvbnN0e3BhZ2VEaWN0OnR9PWF3YWl0IGUuZ2V0UGFnZShyKTtpZighdC5oYXMoIlN0cnVjdFBhcmVudHMiKSljb250aW51ZTtjb25zdCBhPXQuZ2V0KCJTdHJ1Y3RQYXJlbnRzIik7aWYoIU51bWJlci5pc0ludGVnZXIoYSl8fCFBcnJheS5pc0FycmF5KGkuZ2V0KGEpKSl7d2FybihgQ2Fubm90IHNhdmUgdGhlIHN0cnVjdCB0cmVlOiBwYWdlICR7cn0gaGFzIGEgd3JvbmcgaWQuYCk7cmV0dXJuITF9fWxldCBzPSEwO2Zvcihjb25zdFthLG5db2YgdCl7Y29uc3R7cGFnZURpY3Q6dH09YXdhaXQgZS5nZXRQYWdlKGEpO1N0cnVjdFRyZWVSb290LiNoZSh7ZWxlbWVudHM6bix4cmVmOnRoaXMueHJlZixwYWdlRGljdDp0LG51bWJlclRyZWU6aX0pO2Zvcihjb25zdCBlIG9mIG4paWYoZS5hY2Nlc3NpYmlsaXR5RGF0YT8udHlwZSl7ZS5hY2Nlc3NpYmlsaXR5RGF0YS5zdHJ1Y3RQYXJlbnQ+PTB8fChlLnBhcmVudFRyZWVJZD1yKyspO3M9ITF9fWlmKHMpe2Zvcihjb25zdCBlIG9mIHQudmFsdWVzKCkpZm9yKGNvbnN0IHQgb2YgZSl7ZGVsZXRlIHQucGFyZW50VHJlZUlkO2RlbGV0ZSB0LnN0cnVjdFRyZWVQYXJlbnR9cmV0dXJuITF9cmV0dXJuITB9YXN5bmMgdXBkYXRlU3RydWN0dXJlVHJlZSh7bmV3QW5ub3RhdGlvbnNCeVBhZ2U6ZSxwZGZNYW5hZ2VyOnQsY2hhbmdlczpyfSl7Y29uc3R7cmVmOmEseHJlZjpufT10aGlzLGk9dGhpcy5kaWN0LmNsb25lKCkscz1uZXcgUmVmU2V0Q2FjaGU7cy5wdXQoYSxpKTtsZXQgbyxjPWkuZ2V0UmF3KCJQYXJlbnRUcmVlIik7aWYoYyBpbnN0YW5jZW9mIFJlZilvPW4uZmV0Y2goYyk7ZWxzZXtvPWM7Yz1uLmdldE5ld1RlbXBvcmFyeVJlZigpO2kuc2V0KCJQYXJlbnRUcmVlIixjKX1vPW8uY2xvbmUoKTtzLnB1dChjLG8pO2xldCBsPW8uZ2V0UmF3KCJOdW1zIiksaD1udWxsO2lmKGwgaW5zdGFuY2VvZiBSZWYpe2g9bDtsPW4uZmV0Y2goaCl9bD1sLnNsaWNlKCk7aHx8by5zZXQoIk51bXMiLGwpO2NvbnN0IHU9YXdhaXQgU3RydWN0VHJlZVJvb3QuI2xlKHtuZXdBbm5vdGF0aW9uc0J5UGFnZTplLHN0cnVjdFRyZWVSb290UmVmOmEsc3RydWN0VHJlZVJvb3Q6dGhpcyxraWRzOm51bGwsbnVtczpsLHhyZWY6bixwZGZNYW5hZ2VyOnQsY2hhbmdlczpyLGNhY2hlOnN9KTtpZigtMSE9PXUpe2kuc2V0KCJQYXJlbnRUcmVlTmV4dEtleSIsdSk7aCYmcy5wdXQoaCxsKTtmb3IoY29uc3RbZSx0XW9mIHMuaXRlbXMoKSlyLnB1dChlLHtkYXRhOnR9KX19c3RhdGljIGFzeW5jI2xlKHtuZXdBbm5vdGF0aW9uc0J5UGFnZTplLHN0cnVjdFRyZWVSb290UmVmOnQsc3RydWN0VHJlZVJvb3Q6cixraWRzOmEsbnVtczpuLHhyZWY6aSxwZGZNYW5hZ2VyOnMsY2hhbmdlczpvLGNhY2hlOmN9KXtjb25zdCBsPU5hbWUuZ2V0KCJPQkpSIik7bGV0IGgsdT0tMTtmb3IoY29uc3RbZCxmXW9mIGUpe2NvbnN0IGU9YXdhaXQgcy5nZXRQYWdlKGQpLHtyZWY6Z309ZSxwPWcgaW5zdGFuY2VvZiBSZWY7Zm9yKGNvbnN0e2FjY2Vzc2liaWxpdHlEYXRhOnMscmVmOm0scGFyZW50VHJlZUlkOmIsc3RydWN0VHJlZVBhcmVudDp5fW9mIGYpe2lmKCFzPy50eXBlKWNvbnRpbnVlO2NvbnN0e3N0cnVjdFBhcmVudDpmfT1zO2lmKHImJk51bWJlci5pc0ludGVnZXIoZikmJmY+PTApe2xldCB0PShofHw9bmV3IE1hcCkuZ2V0KGQpO2lmKHZvaWQgMD09PXQpe3Q9bmV3IFN0cnVjdFRyZWVQYWdlKHIsZS5wYWdlRGljdCkuY29sbGVjdE9iamVjdHMoZyk7aC5zZXQoZCx0KX1jb25zdCBhPXQ/LmdldChmKTtpZihhKXtjb25zdCBlPWkuZmV0Y2goYSkuY2xvbmUoKTtTdHJ1Y3RUcmVlUm9vdC4jdWUoZSxzKTtvLnB1dChhLHtkYXRhOmV9KTtjb250aW51ZX19dT1NYXRoLm1heCh1LGIpO2NvbnN0IHc9aS5nZXROZXdUZW1wb3JhcnlSZWYoKSx4PW5ldyBEaWN0KGkpO1N0cnVjdFRyZWVSb290LiN1ZSh4LHMpO2F3YWl0IHRoaXMuI2RlKHtzdHJ1Y3RUcmVlUGFyZW50OnksdGFnRGljdDp4LG5ld1RhZ1JlZjp3LHN0cnVjdFRyZWVSb290UmVmOnQsZmFsbGJhY2tLaWRzOmEseHJlZjppLGNhY2hlOmN9KTtjb25zdCBTPW5ldyBEaWN0KGkpO3guc2V0KCJLIixTKTtTLnNldCgiVHlwZSIsbCk7cCYmUy5zZXQoIlBnIixnKTtTLnNldCgiT2JqIixtKTtjLnB1dCh3LHgpO24ucHVzaChiLHcpfX1yZXR1cm4gdSsxfXN0YXRpYyN1ZShlLHt0eXBlOnQsdGl0bGU6cixsYW5nOmEsYWx0Om4sZXhwYW5kZWQ6aSxhY3R1YWxUZXh0OnN9KXtlLnNldCgiUyIsTmFtZS5nZXQodCkpO3ImJmUuc2V0KCJUIixzdHJpbmdUb0FzY2lpT3JVVEYxNkJFKHIpKTthJiZlLnNldCgiTGFuZyIsc3RyaW5nVG9Bc2NpaU9yVVRGMTZCRShhKSk7biYmZS5zZXQoIkFsdCIsc3RyaW5nVG9Bc2NpaU9yVVRGMTZCRShuKSk7aSYmZS5zZXQoIkUiLHN0cmluZ1RvQXNjaWlPclVURjE2QkUoaSkpO3MmJmUuc2V0KCJBY3R1YWxUZXh0IixzdHJpbmdUb0FzY2lpT3JVVEYxNkJFKHMpKX1zdGF0aWMjaGUoe2VsZW1lbnRzOmUseHJlZjp0LHBhZ2VEaWN0OnIsbnVtYmVyVHJlZTphfSl7Y29uc3Qgbj1uZXcgTWFwO2Zvcihjb25zdCB0IG9mIGUpaWYodC5zdHJ1Y3RUcmVlUGFyZW50SWQpe2NvbnN0IGU9cGFyc2VJbnQodC5zdHJ1Y3RUcmVlUGFyZW50SWQuc3BsaXQoIl9tYyIpWzFdLDEwKTtsZXQgcj1uLmdldChlKTtpZighcil7cj1bXTtuLnNldChlLHIpfXIucHVzaCh0KX1jb25zdCBpPXIuZ2V0KCJTdHJ1Y3RQYXJlbnRzIik7aWYoIU51bWJlci5pc0ludGVnZXIoaSkpcmV0dXJuO2NvbnN0IHM9YS5nZXQoaSksdXBkYXRlRWxlbWVudD0oZSxyLGEpPT57Y29uc3QgaT1uLmdldChlKTtpZihpKXtjb25zdCBlPXIuZ2V0UmF3KCJQIiksbj10LmZldGNoSWZSZWYoZSk7aWYoZSBpbnN0YW5jZW9mIFJlZiYmbiBpbnN0YW5jZW9mIERpY3Qpe2NvbnN0IGU9e3JlZjphLGRpY3Q6cn07Zm9yKGNvbnN0IHQgb2YgaSl0LnN0cnVjdFRyZWVQYXJlbnQ9ZX1yZXR1cm4hMH1yZXR1cm4hMX07Zm9yKGNvbnN0IGUgb2Ygcyl7aWYoIShlIGluc3RhbmNlb2YgUmVmKSljb250aW51ZTtjb25zdCByPXQuZmV0Y2goZSksYT1yLmdldCgiSyIpO2lmKE51bWJlci5pc0ludGVnZXIoYSkpdXBkYXRlRWxlbWVudChhLHIsZSk7ZWxzZSBpZihBcnJheS5pc0FycmF5KGEpKWZvcihsZXQgbiBvZiBhKXtuPXQuZmV0Y2hJZlJlZihuKTtpZihOdW1iZXIuaXNJbnRlZ2VyKG4pJiZ1cGRhdGVFbGVtZW50KG4scixlKSlicmVhaztpZighKG4gaW5zdGFuY2VvZiBEaWN0KSljb250aW51ZTtpZighaXNOYW1lKG4uZ2V0KCJUeXBlIiksIk1DUiIpKWJyZWFrO2NvbnN0IGE9bi5nZXQoIk1DSUQiKTtpZihOdW1iZXIuaXNJbnRlZ2VyKGEpJiZ1cGRhdGVFbGVtZW50KGEscixlKSlicmVha319fXN0YXRpYyBhc3luYyNkZSh7c3RydWN0VHJlZVBhcmVudDplLHRhZ0RpY3Q6dCxuZXdUYWdSZWY6cixzdHJ1Y3RUcmVlUm9vdFJlZjphLGZhbGxiYWNrS2lkczpuLHhyZWY6aSxjYWNoZTpzfSl7bGV0IG8sYz1udWxsO2lmKGUpeyh7cmVmOmN9PWUpO289ZS5kaWN0LmdldFJhdygiUCIpfHxhfWVsc2Ugbz1hO3Quc2V0KCJQIixvKTtjb25zdCBsPWkuZmV0Y2hJZlJlZihvKTtpZighbCl7bi5wdXNoKHIpO3JldHVybn1sZXQgaD1zLmdldChvKTtpZighaCl7aD1sLmNsb25lKCk7cy5wdXQobyxoKX1jb25zdCB1PWguZ2V0UmF3KCJLIik7bGV0IGQ9dSBpbnN0YW5jZW9mIFJlZj9zLmdldCh1KTpudWxsO2lmKCFkKXtkPWkuZmV0Y2hJZlJlZih1KTtkPUFycmF5LmlzQXJyYXkoZCk/ZC5zbGljZSgpOlt1XTtjb25zdCBlPWkuZ2V0TmV3VGVtcG9yYXJ5UmVmKCk7aC5zZXQoIksiLGUpO3MucHV0KGUsZCl9Y29uc3QgZj1kLmluZGV4T2YoYyk7ZC5zcGxpY2UoZj49MD9mKzE6ZC5sZW5ndGgsMCxyKX19Y2xhc3MgU3RydWN0RWxlbWVudE5vZGV7Y29uc3RydWN0b3IoZSx0KXt0aGlzLnRyZWU9ZTt0aGlzLnhyZWY9ZS54cmVmO3RoaXMuZGljdD10O3RoaXMua2lkcz1bXTt0aGlzLnBhcnNlS2lkcygpfWdldCByb2xlKCl7Y29uc3QgZT10aGlzLmRpY3QuZ2V0KCJTIiksdD1lIGluc3RhbmNlb2YgTmFtZT9lLm5hbWU6IiIse3Jvb3Q6cn09dGhpcy50cmVlO3JldHVybiByLnJvbGVNYXAuZ2V0KHQpPz90fXBhcnNlS2lkcygpe2xldCBlPW51bGw7Y29uc3QgdD10aGlzLmRpY3QuZ2V0UmF3KCJQZyIpO3QgaW5zdGFuY2VvZiBSZWYmJihlPXQudG9TdHJpbmcoKSk7Y29uc3Qgcj10aGlzLmRpY3QuZ2V0KCJLIik7aWYoQXJyYXkuaXNBcnJheShyKSlmb3IoY29uc3QgdCBvZiByKXtjb25zdCByPXRoaXMucGFyc2VLaWQoZSx0aGlzLnhyZWYuZmV0Y2hJZlJlZih0KSk7ciYmdGhpcy5raWRzLnB1c2gocil9ZWxzZXtjb25zdCB0PXRoaXMucGFyc2VLaWQoZSxyKTt0JiZ0aGlzLmtpZHMucHVzaCh0KX19cGFyc2VLaWQoZSx0KXtpZihOdW1iZXIuaXNJbnRlZ2VyKHQpKXJldHVybiB0aGlzLnRyZWUucGFnZURpY3Qub2JqSWQhPT1lP251bGw6bmV3IFN0cnVjdEVsZW1lbnQoe3R5cGU6TWksbWNpZDp0LHBhZ2VPYmpJZDplfSk7aWYoISh0IGluc3RhbmNlb2YgRGljdCkpcmV0dXJuIG51bGw7Y29uc3Qgcj10LmdldFJhdygiUGciKTtyIGluc3RhbmNlb2YgUmVmJiYoZT1yLnRvU3RyaW5nKCkpO2NvbnN0IGE9dC5nZXQoIlR5cGUiKWluc3RhbmNlb2YgTmFtZT90LmdldCgiVHlwZSIpLm5hbWU6bnVsbDtpZigiTUNSIj09PWEpe2lmKHRoaXMudHJlZS5wYWdlRGljdC5vYmpJZCE9PWUpcmV0dXJuIG51bGw7Y29uc3Qgcj10LmdldFJhdygiU3RtIik7cmV0dXJuIG5ldyBTdHJ1Y3RFbGVtZW50KHt0eXBlOkRpLHJlZk9iaklkOnIgaW5zdGFuY2VvZiBSZWY/ci50b1N0cmluZygpOm51bGwscGFnZU9iaklkOmUsbWNpZDp0LmdldCgiTUNJRCIpfSl9aWYoIk9CSlIiPT09YSl7aWYodGhpcy50cmVlLnBhZ2VEaWN0Lm9iaklkIT09ZSlyZXR1cm4gbnVsbDtjb25zdCByPXQuZ2V0UmF3KCJPYmoiKTtyZXR1cm4gbmV3IFN0cnVjdEVsZW1lbnQoe3R5cGU6QmkscmVmT2JqSWQ6ciBpbnN0YW5jZW9mIFJlZj9yLnRvU3RyaW5nKCk6bnVsbCxwYWdlT2JqSWQ6ZX0pfXJldHVybiBuZXcgU3RydWN0RWxlbWVudCh7dHlwZTpFaSxkaWN0OnR9KX19Y2xhc3MgU3RydWN0RWxlbWVudHtjb25zdHJ1Y3Rvcih7dHlwZTplLGRpY3Q6dD1udWxsLG1jaWQ6cj1udWxsLHBhZ2VPYmpJZDphPW51bGwscmVmT2JqSWQ6bj1udWxsfSl7dGhpcy50eXBlPWU7dGhpcy5kaWN0PXQ7dGhpcy5tY2lkPXI7dGhpcy5wYWdlT2JqSWQ9YTt0aGlzLnJlZk9iaklkPW47dGhpcy5wYXJlbnROb2RlPW51bGx9fWNsYXNzIFN0cnVjdFRyZWVQYWdle2NvbnN0cnVjdG9yKGUsdCl7dGhpcy5yb290PWU7dGhpcy54cmVmPWU/LnhyZWY/P251bGw7dGhpcy5yb290RGljdD1lPy5kaWN0Pz9udWxsO3RoaXMucGFnZURpY3Q9dDt0aGlzLm5vZGVzPVtdfWNvbGxlY3RPYmplY3RzKGUpe2lmKCEodGhpcy5yb290JiZ0aGlzLnJvb3REaWN0JiZlIGluc3RhbmNlb2YgUmVmKSlyZXR1cm4gbnVsbDtjb25zdCB0PXRoaXMucm9vdERpY3QuZ2V0KCJQYXJlbnRUcmVlIik7aWYoIXQpcmV0dXJuIG51bGw7Y29uc3Qgcj10aGlzLnJvb3Quc3RydWN0UGFyZW50SWRzPy5nZXQoZSk7aWYoIXIpcmV0dXJuIG51bGw7Y29uc3QgYT1uZXcgTWFwLG49bmV3IE51bWJlclRyZWUodCx0aGlzLnhyZWYpO2Zvcihjb25zdFtlXW9mIHIpe2NvbnN0IHQ9bi5nZXRSYXcoZSk7dCBpbnN0YW5jZW9mIFJlZiYmYS5zZXQoZSx0KX1yZXR1cm4gYX1wYXJzZShlKXtpZighKHRoaXMucm9vdCYmdGhpcy5yb290RGljdCYmZSBpbnN0YW5jZW9mIFJlZikpcmV0dXJuO2NvbnN0IHQ9dGhpcy5yb290RGljdC5nZXQoIlBhcmVudFRyZWUiKTtpZighdClyZXR1cm47Y29uc3Qgcj10aGlzLnBhZ2VEaWN0LmdldCgiU3RydWN0UGFyZW50cyIpLGE9dGhpcy5yb290LnN0cnVjdFBhcmVudElkcz8uZ2V0KGUpO2lmKCFOdW1iZXIuaXNJbnRlZ2VyKHIpJiYhYSlyZXR1cm47Y29uc3Qgbj1uZXcgTWFwLGk9bmV3IE51bWJlclRyZWUodCx0aGlzLnhyZWYpO2lmKE51bWJlci5pc0ludGVnZXIocikpe2NvbnN0IGU9aS5nZXQocik7aWYoQXJyYXkuaXNBcnJheShlKSlmb3IoY29uc3QgdCBvZiBlKXQgaW5zdGFuY2VvZiBSZWYmJnRoaXMuYWRkTm9kZSh0aGlzLnhyZWYuZmV0Y2godCksbil9aWYoYSlmb3IoY29uc3RbZSx0XW9mIGEpe2NvbnN0IHI9aS5nZXQoZSk7aWYocil7Y29uc3QgZT10aGlzLmFkZE5vZGUodGhpcy54cmVmLmZldGNoSWZSZWYociksbik7MT09PWU/LmtpZHM/Lmxlbmd0aCYmZS5raWRzWzBdLnR5cGU9PT1CaSYmKGUua2lkc1swXS50eXBlPXQpfX19YWRkTm9kZShlLHQscj0wKXtpZihyPjQwKXt3YXJuKCJTdHJ1Y3RUcmVlIE1BWF9ERVBUSCByZWFjaGVkLiIpO3JldHVybiBudWxsfWlmKCEoZSBpbnN0YW5jZW9mIERpY3QpKXJldHVybiBudWxsO2lmKHQuaGFzKGUpKXJldHVybiB0LmdldChlKTtjb25zdCBhPW5ldyBTdHJ1Y3RFbGVtZW50Tm9kZSh0aGlzLGUpO3Quc2V0KGUsYSk7Y29uc3Qgbj1lLmdldCgiUCIpO2lmKCEobiBpbnN0YW5jZW9mIERpY3QpfHxpc05hbWUobi5nZXQoIlR5cGUiKSwiU3RydWN0VHJlZVJvb3QiKSl7dGhpcy5hZGRUb3BMZXZlbE5vZGUoZSxhKXx8dC5kZWxldGUoZSk7cmV0dXJuIGF9Y29uc3QgaT10aGlzLmFkZE5vZGUobix0LHIrMSk7aWYoIWkpcmV0dXJuIGE7bGV0IHM9ITE7Zm9yKGNvbnN0IHQgb2YgaS5raWRzKWlmKHQudHlwZT09PUVpJiZ0LmRpY3Q9PT1lKXt0LnBhcmVudE5vZGU9YTtzPSEwfXN8fHQuZGVsZXRlKGUpO3JldHVybiBhfWFkZFRvcExldmVsTm9kZShlLHQpe2NvbnN0IHI9dGhpcy5yb290RGljdC5nZXQoIksiKTtpZighcilyZXR1cm4hMTtpZihyIGluc3RhbmNlb2YgRGljdCl7aWYoci5vYmpJZCE9PWUub2JqSWQpcmV0dXJuITE7dGhpcy5ub2Rlc1swXT10O3JldHVybiEwfWlmKCFBcnJheS5pc0FycmF5KHIpKXJldHVybiEwO2xldCBhPSExO2ZvcihsZXQgbj0wO248ci5sZW5ndGg7bisrKXtjb25zdCBpPXJbbl07aWYoaT8udG9TdHJpbmcoKT09PWUub2JqSWQpe3RoaXMubm9kZXNbbl09dDthPSEwfX1yZXR1cm4gYX1nZXQgc2VyaWFsaXphYmxlKCl7ZnVuY3Rpb24gbm9kZVRvU2VyaWFsaXphYmxlKGUsdCxyPTApe2lmKHI+NDApe3dhcm4oIlN0cnVjdFRyZWUgdG9vIGRlZXAgdG8gYmUgZnVsbHkgc2VyaWFsaXplZC4iKTtyZXR1cm59Y29uc3QgYT1PYmplY3QuY3JlYXRlKG51bGwpO2Eucm9sZT1lLnJvbGU7YS5jaGlsZHJlbj1bXTt0LmNoaWxkcmVuLnB1c2goYSk7bGV0IG49ZS5kaWN0LmdldCgiQWx0Iik7InN0cmluZyIhPXR5cGVvZiBuJiYobj1lLmRpY3QuZ2V0KCJBY3R1YWxUZXh0IikpOyJzdHJpbmciPT10eXBlb2YgbiYmKGEuYWx0PXN0cmluZ1RvUERGU3RyaW5nKG4pKTtjb25zdCBpPWUuZGljdC5nZXQoIkEiKTtpZihpIGluc3RhbmNlb2YgRGljdCl7Y29uc3QgZT1sb29rdXBOb3JtYWxSZWN0KGkuZ2V0QXJyYXkoIkJCb3giKSxudWxsKTtpZihlKWEuYmJveD1lO2Vsc2V7Y29uc3QgZT1pLmdldCgiV2lkdGgiKSx0PWkuZ2V0KCJIZWlnaHQiKTsibnVtYmVyIj09dHlwZW9mIGUmJmU+MCYmIm51bWJlciI9PXR5cGVvZiB0JiZ0PjAmJihhLmJib3g9WzAsMCxlLHRdKX19Y29uc3Qgcz1lLmRpY3QuZ2V0KCJMYW5nIik7InN0cmluZyI9PXR5cGVvZiBzJiYoYS5sYW5nPXN0cmluZ1RvUERGU3RyaW5nKHMpKTtmb3IoY29uc3QgdCBvZiBlLmtpZHMpe2NvbnN0IGU9dC50eXBlPT09RWk/dC5wYXJlbnROb2RlOm51bGw7ZT9ub2RlVG9TZXJpYWxpemFibGUoZSxhLHIrMSk6dC50eXBlPT09TWl8fHQudHlwZT09PURpP2EuY2hpbGRyZW4ucHVzaCh7dHlwZToiY29udGVudCIsaWQ6YHAke3QucGFnZU9iaklkfV9tYyR7dC5tY2lkfWB9KTp0LnR5cGU9PT1CaT9hLmNoaWxkcmVuLnB1c2goe3R5cGU6Im9iamVjdCIsaWQ6dC5yZWZPYmpJZH0pOnQudHlwZT09PVJpJiZhLmNoaWxkcmVuLnB1c2goe3R5cGU6ImFubm90YXRpb24iLGlkOmBwZGZqc19pbnRlcm5hbF9pZF8ke3QucmVmT2JqSWR9YH0pfX1jb25zdCBlPU9iamVjdC5jcmVhdGUobnVsbCk7ZS5jaGlsZHJlbj1bXTtlLnJvbGU9IlJvb3QiO2Zvcihjb25zdCB0IG9mIHRoaXMubm9kZXMpdCYmbm9kZVRvU2VyaWFsaXphYmxlKHQsZSk7cmV0dXJuIGV9fWNvbnN0IE5pPWZ1bmN0aW9uIF9pc1ZhbGlkRXhwbGljaXREZXN0KGUsdCxyKXtpZighQXJyYXkuaXNBcnJheShyKXx8ci5sZW5ndGg8MilyZXR1cm4hMTtjb25zdFthLG4sLi4uaV09cjtpZighZShhKSYmIU51bWJlci5pc0ludGVnZXIoYSkpcmV0dXJuITE7aWYoIXQobikpcmV0dXJuITE7Y29uc3Qgcz1pLmxlbmd0aDtsZXQgbz0hMDtzd2l0Y2gobi5uYW1lKXtjYXNlIlhZWiI6aWYoczwyfHxzPjMpcmV0dXJuITE7YnJlYWs7Y2FzZSJGaXQiOmNhc2UiRml0QiI6cmV0dXJuIDA9PT1zO2Nhc2UiRml0SCI6Y2FzZSJGaXRCSCI6Y2FzZSJGaXRWIjpjYXNlIkZpdEJWIjppZihzPjEpcmV0dXJuITE7YnJlYWs7Y2FzZSJGaXRSIjppZig0IT09cylyZXR1cm4hMTtvPSExO2JyZWFrO2RlZmF1bHQ6cmV0dXJuITF9Zm9yKGNvbnN0IGUgb2YgaSlpZighKCJudW1iZXIiPT10eXBlb2YgZXx8byYmbnVsbD09PWUpKXJldHVybiExO3JldHVybiEwfS5iaW5kKG51bGwsZT0+ZSBpbnN0YW5jZW9mIFJlZixpc05hbWUpO2Z1bmN0aW9uIGZldGNoRGVzdChlKXtlIGluc3RhbmNlb2YgRGljdCYmKGU9ZS5nZXQoIkQiKSk7cmV0dXJuIE5pKGUpP2U6bnVsbH1mdW5jdGlvbiBmZXRjaFJlbW90ZURlc3QoZSl7bGV0IHQ9ZS5nZXQoIkQiKTtpZih0KXt0IGluc3RhbmNlb2YgTmFtZSYmKHQ9dC5uYW1lKTtpZigic3RyaW5nIj09dHlwZW9mIHQpcmV0dXJuIHN0cmluZ1RvUERGU3RyaW5nKHQsITApO2lmKE5pKHQpKXJldHVybiBKU09OLnN0cmluZ2lmeSh0KX1yZXR1cm4gbnVsbH1jbGFzcyBDYXRhbG9neyNmZT1udWxsOyNnZT1udWxsO2J1aWx0SW5DTWFwQ2FjaGU9bmV3IE1hcDtmb250Q2FjaGU9bmV3IFJlZlNldENhY2hlO2dsb2JhbENvbG9yU3BhY2VDYWNoZT1uZXcgR2xvYmFsQ29sb3JTcGFjZUNhY2hlO2dsb2JhbEltYWdlQ2FjaGU9bmV3IEdsb2JhbEltYWdlQ2FjaGU7bm9uQmxlbmRNb2Rlc1NldD1uZXcgUmVmU2V0O3BhZ2VEaWN0Q2FjaGU9bmV3IFJlZlNldENhY2hlO3BhZ2VJbmRleENhY2hlPW5ldyBSZWZTZXRDYWNoZTtwYWdlS2lkc0NvdW50Q2FjaGU9bmV3IFJlZlNldENhY2hlO3N0YW5kYXJkRm9udERhdGFDYWNoZT1uZXcgTWFwO3N5c3RlbUZvbnRDYWNoZT1uZXcgTWFwO2NvbnN0cnVjdG9yKGUsdCl7dGhpcy5wZGZNYW5hZ2VyPWU7dGhpcy54cmVmPXQ7dGhpcy4jZ2U9dC5nZXRDYXRhbG9nT2JqKCk7aWYoISh0aGlzLiNnZSBpbnN0YW5jZW9mIERpY3QpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiQ2F0YWxvZyBvYmplY3QgaXMgbm90IGEgZGljdGlvbmFyeS4iKTt0aGlzLnRvcGxldmVsUGFnZXNEaWN0fWNsb25lRGljdCgpe3JldHVybiB0aGlzLiNnZS5jbG9uZSgpfWdldCB2ZXJzaW9uKCl7Y29uc3QgZT10aGlzLiNnZS5nZXQoIlZlcnNpb24iKTtpZihlIGluc3RhbmNlb2YgTmFtZSl7aWYodXIudGVzdChlLm5hbWUpKXJldHVybiBzaGFkb3codGhpcywidmVyc2lvbiIsZS5uYW1lKTt3YXJuKGBJbnZhbGlkIFBERiBjYXRhbG9nIHZlcnNpb246ICR7ZS5uYW1lfWApfXJldHVybiBzaGFkb3codGhpcywidmVyc2lvbiIsbnVsbCl9Z2V0IGxhbmcoKXtjb25zdCBlPXRoaXMuI2dlLmdldCgiTGFuZyIpO3JldHVybiBzaGFkb3codGhpcywibGFuZyIsZSYmInN0cmluZyI9PXR5cGVvZiBlP3N0cmluZ1RvUERGU3RyaW5nKGUpOm51bGwpfWdldCBuZWVkc1JlbmRlcmluZygpe2NvbnN0IGU9dGhpcy4jZ2UuZ2V0KCJOZWVkc1JlbmRlcmluZyIpO3JldHVybiBzaGFkb3codGhpcywibmVlZHNSZW5kZXJpbmciLCJib29sZWFuIj09dHlwZW9mIGUmJmUpfWdldCBjb2xsZWN0aW9uKCl7bGV0IGU9bnVsbDt0cnl7Y29uc3QgdD10aGlzLiNnZS5nZXQoIkNvbGxlY3Rpb24iKTt0IGluc3RhbmNlb2YgRGljdCYmdC5zaXplPjAmJihlPXQpfWNhdGNoKGUpe2lmKGUgaW5zdGFuY2VvZiBNaXNzaW5nRGF0YUV4Y2VwdGlvbil0aHJvdyBlO2luZm8oIkNhbm5vdCBmZXRjaCBDb2xsZWN0aW9uIGVudHJ5OyBhc3N1bWluZyBubyBjb2xsZWN0aW9uIGlzIHByZXNlbnQuIil9cmV0dXJuIHNoYWRvdyh0aGlzLCJjb2xsZWN0aW9uIixlKX1nZXQgYWNyb0Zvcm0oKXtsZXQgZT1udWxsO3RyeXtjb25zdCB0PXRoaXMuI2dlLmdldCgiQWNyb0Zvcm0iKTt0IGluc3RhbmNlb2YgRGljdCYmdC5zaXplPjAmJihlPXQpfWNhdGNoKGUpe2lmKGUgaW5zdGFuY2VvZiBNaXNzaW5nRGF0YUV4Y2VwdGlvbil0aHJvdyBlO2luZm8oIkNhbm5vdCBmZXRjaCBBY3JvRm9ybSBlbnRyeTsgYXNzdW1pbmcgbm8gZm9ybXMgYXJlIHByZXNlbnQuIil9cmV0dXJuIHNoYWRvdyh0aGlzLCJhY3JvRm9ybSIsZSl9Z2V0IGFjcm9Gb3JtUmVmKCl7Y29uc3QgZT10aGlzLiNnZS5nZXRSYXcoIkFjcm9Gb3JtIik7cmV0dXJuIHNoYWRvdyh0aGlzLCJhY3JvRm9ybVJlZiIsZSBpbnN0YW5jZW9mIFJlZj9lOm51bGwpfWdldCBtZXRhZGF0YSgpe2NvbnN0IGU9dGhpcy4jZ2UuZ2V0UmF3KCJNZXRhZGF0YSIpO2lmKCEoZSBpbnN0YW5jZW9mIFJlZikpcmV0dXJuIHNoYWRvdyh0aGlzLCJtZXRhZGF0YSIsbnVsbCk7bGV0IHQ9bnVsbDt0cnl7Y29uc3Qgcj10aGlzLnhyZWYuZmV0Y2goZSwhdGhpcy54cmVmLmVuY3J5cHQ/LmVuY3J5cHRNZXRhZGF0YSk7aWYociBpbnN0YW5jZW9mIEJhc2VTdHJlYW0mJnIuZGljdCBpbnN0YW5jZW9mIERpY3Qpe2NvbnN0IGU9ci5kaWN0LmdldCgiVHlwZSIpLGE9ci5kaWN0LmdldCgiU3VidHlwZSIpO2lmKGlzTmFtZShlLCJNZXRhZGF0YSIpJiZpc05hbWUoYSwiWE1MIikpe2NvbnN0IGU9c3RyaW5nVG9VVEY4U3RyaW5nKHIuZ2V0U3RyaW5nKCkpO2UmJih0PW5ldyBNZXRhZGF0YVBhcnNlcihlKS5zZXJpYWxpemFibGUpfX19Y2F0Y2goZSl7aWYoZSBpbnN0YW5jZW9mIE1pc3NpbmdEYXRhRXhjZXB0aW9uKXRocm93IGU7aW5mbyhgU2tpcHBpbmcgaW52YWxpZCBNZXRhZGF0YTogIiR7ZX0iLmApfXJldHVybiBzaGFkb3codGhpcywibWV0YWRhdGEiLHQpfWdldCBtYXJrSW5mbygpe2xldCBlPW51bGw7dHJ5e2U9dGhpcy4jcGUoKX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgTWlzc2luZ0RhdGFFeGNlcHRpb24pdGhyb3cgZTt3YXJuKCJVbmFibGUgdG8gcmVhZCBtYXJrIGluZm8uIil9cmV0dXJuIHNoYWRvdyh0aGlzLCJtYXJrSW5mbyIsZSl9I3BlKCl7Y29uc3QgZT10aGlzLiNnZS5nZXQoIk1hcmtJbmZvIik7aWYoIShlIGluc3RhbmNlb2YgRGljdCkpcmV0dXJuIG51bGw7Y29uc3QgdD17TWFya2VkOiExLFVzZXJQcm9wZXJ0aWVzOiExLFN1c3BlY3RzOiExfTtmb3IoY29uc3QgciBpbiB0KXtjb25zdCBhPWUuZ2V0KHIpOyJib29sZWFuIj09dHlwZW9mIGEmJih0W3JdPWEpfXJldHVybiB0fWdldCBzdHJ1Y3RUcmVlUm9vdCgpe2xldCBlPW51bGw7dHJ5e2U9dGhpcy4jbWUoKX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgTWlzc2luZ0RhdGFFeGNlcHRpb24pdGhyb3cgZTt3YXJuKCJVbmFibGUgcmVhZCB0byBzdHJ1Y3RUcmVlUm9vdCBpbmZvLiIpfXJldHVybiBzaGFkb3codGhpcywic3RydWN0VHJlZVJvb3QiLGUpfSNtZSgpe2NvbnN0IGU9dGhpcy4jZ2UuZ2V0UmF3KCJTdHJ1Y3RUcmVlUm9vdCIpLHQ9dGhpcy54cmVmLmZldGNoSWZSZWYoZSk7aWYoISh0IGluc3RhbmNlb2YgRGljdCkpcmV0dXJuIG51bGw7Y29uc3Qgcj1uZXcgU3RydWN0VHJlZVJvb3QodGhpcy54cmVmLHQsZSk7ci5pbml0KCk7cmV0dXJuIHJ9Z2V0IHRvcGxldmVsUGFnZXNEaWN0KCl7Y29uc3QgZT10aGlzLiNnZS5nZXQoIlBhZ2VzIik7aWYoIShlIGluc3RhbmNlb2YgRGljdCkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIHRvcC1sZXZlbCBwYWdlcyBkaWN0aW9uYXJ5LiIpO3JldHVybiBzaGFkb3codGhpcywidG9wbGV2ZWxQYWdlc0RpY3QiLGUpfWdldCBkb2N1bWVudE91dGxpbmUoKXtsZXQgZT1udWxsO3RyeXtlPXRoaXMuI2JlKCl9Y2F0Y2goZSl7aWYoZSBpbnN0YW5jZW9mIE1pc3NpbmdEYXRhRXhjZXB0aW9uKXRocm93IGU7d2FybigiVW5hYmxlIHRvIHJlYWQgZG9jdW1lbnQgb3V0bGluZS4iKX1yZXR1cm4gc2hhZG93KHRoaXMsImRvY3VtZW50T3V0bGluZSIsZSl9I2JlKCl7bGV0IGU9dGhpcy4jZ2UuZ2V0KCJPdXRsaW5lcyIpO2lmKCEoZSBpbnN0YW5jZW9mIERpY3QpKXJldHVybiBudWxsO2U9ZS5nZXRSYXcoIkZpcnN0Iik7aWYoIShlIGluc3RhbmNlb2YgUmVmKSlyZXR1cm4gbnVsbDtjb25zdCB0PXtpdGVtczpbXX0scj1be29iajplLHBhcmVudDp0fV0sYT1uZXcgUmVmU2V0O2EucHV0KGUpO2NvbnN0IG49dGhpcy54cmVmLGk9bmV3IFVpbnQ4Q2xhbXBlZEFycmF5KDMpO2Zvcig7ci5sZW5ndGg+MDspe2NvbnN0IHQ9ci5zaGlmdCgpLHM9bi5mZXRjaElmUmVmKHQub2JqKTtpZihudWxsPT09cyljb250aW51ZTtzLmhhcygiVGl0bGUiKXx8d2FybigiSW52YWxpZCBvdXRsaW5lIGl0ZW0gZW5jb3VudGVyZWQuIik7Y29uc3Qgbz17dXJsOm51bGwsZGVzdDpudWxsLGFjdGlvbjpudWxsfTtDYXRhbG9nLnBhcnNlRGVzdERpY3Rpb25hcnkoe2Rlc3REaWN0OnMscmVzdWx0T2JqOm8sZG9jQmFzZVVybDp0aGlzLmJhc2VVcmwsZG9jQXR0YWNobWVudHM6dGhpcy5hdHRhY2htZW50c30pO2NvbnN0IGM9cy5nZXQoIlRpdGxlIiksbD1zLmdldCgiRiIpfHwwLGg9cy5nZXRBcnJheSgiQyIpLHU9cy5nZXQoIkNvdW50Iik7bGV0IGQ9aTshaXNOdW1iZXJBcnJheShoLDMpfHwwPT09aFswXSYmMD09PWhbMV0mJjA9PT1oWzJdfHwoZD1Db2xvclNwYWNlVXRpbHMucmdiLmdldFJnYihoLDApKTtjb25zdCBmPXthY3Rpb246by5hY3Rpb24sYXR0YWNobWVudDpvLmF0dGFjaG1lbnQsZGVzdDpvLmRlc3QsdXJsOm8udXJsLHVuc2FmZVVybDpvLnVuc2FmZVVybCxuZXdXaW5kb3c6by5uZXdXaW5kb3csc2V0T0NHU3RhdGU6by5zZXRPQ0dTdGF0ZSx0aXRsZToic3RyaW5nIj09dHlwZW9mIGM/c3RyaW5nVG9QREZTdHJpbmcoYyk6IiIsY29sb3I6ZCxjb3VudDpOdW1iZXIuaXNJbnRlZ2VyKHUpP3U6dm9pZCAwLGJvbGQ6ISEoMiZsKSxpdGFsaWM6ISEoMSZsKSxpdGVtczpbXX07dC5wYXJlbnQuaXRlbXMucHVzaChmKTtlPXMuZ2V0UmF3KCJGaXJzdCIpO2lmKGUgaW5zdGFuY2VvZiBSZWYmJiFhLmhhcyhlKSl7ci5wdXNoKHtvYmo6ZSxwYXJlbnQ6Zn0pO2EucHV0KGUpfWU9cy5nZXRSYXcoIk5leHQiKTtpZihlIGluc3RhbmNlb2YgUmVmJiYhYS5oYXMoZSkpe3IucHVzaCh7b2JqOmUscGFyZW50OnQucGFyZW50fSk7YS5wdXQoZSl9fXJldHVybiB0Lml0ZW1zLmxlbmd0aD4wP3QuaXRlbXM6bnVsbH1nZXQgcGVybWlzc2lvbnMoKXtsZXQgZT1udWxsO3RyeXtlPXRoaXMuI3llKCl9Y2F0Y2goZSl7aWYoZSBpbnN0YW5jZW9mIE1pc3NpbmdEYXRhRXhjZXB0aW9uKXRocm93IGU7d2FybigiVW5hYmxlIHRvIHJlYWQgcGVybWlzc2lvbnMuIil9cmV0dXJuIHNoYWRvdyh0aGlzLCJwZXJtaXNzaW9ucyIsZSl9I3llKCl7Y29uc3QgZT10aGlzLnhyZWYudHJhaWxlci5nZXQoIkVuY3J5cHQiKTtpZighKGUgaW5zdGFuY2VvZiBEaWN0KSlyZXR1cm4gbnVsbDtsZXQgdD1lLmdldCgiUCIpO2lmKCJudW1iZXIiIT10eXBlb2YgdClyZXR1cm4gbnVsbDt0Kz0yKiozMjtjb25zdCByPVtdO2Zvcihjb25zdCBlIGluIFMpe2NvbnN0IGE9U1tlXTt0JmEmJnIucHVzaChhKX1yZXR1cm4gcn1nZXQgb3B0aW9uYWxDb250ZW50Q29uZmlnKCl7bGV0IGU9bnVsbDt0cnl7Y29uc3QgdD10aGlzLiNnZS5nZXQoIk9DUHJvcGVydGllcyIpO2lmKCF0KXJldHVybiBzaGFkb3codGhpcywib3B0aW9uYWxDb250ZW50Q29uZmlnIixudWxsKTtjb25zdCByPXQuZ2V0KCJEIik7aWYoIXIpcmV0dXJuIHNoYWRvdyh0aGlzLCJvcHRpb25hbENvbnRlbnRDb25maWciLG51bGwpO2NvbnN0IGE9dC5nZXQoIk9DR3MiKTtpZighQXJyYXkuaXNBcnJheShhKSlyZXR1cm4gc2hhZG93KHRoaXMsIm9wdGlvbmFsQ29udGVudENvbmZpZyIsbnVsbCk7Y29uc3Qgbj1uZXcgUmVmU2V0Q2FjaGU7Zm9yKGNvbnN0IGUgb2YgYSllIGluc3RhbmNlb2YgUmVmJiYhbi5oYXMoZSkmJm4ucHV0KGUsdGhpcy4jd2UoZSkpO2U9dGhpcy4jeGUocixuKX1jYXRjaChlKXtpZihlIGluc3RhbmNlb2YgTWlzc2luZ0RhdGFFeGNlcHRpb24pdGhyb3cgZTt3YXJuKGBVbmFibGUgdG8gcmVhZCBvcHRpb25hbCBjb250ZW50IGNvbmZpZzogJHtlfWApfXJldHVybiBzaGFkb3codGhpcywib3B0aW9uYWxDb250ZW50Q29uZmlnIixlKX0jd2UoZSl7Y29uc3QgdD10aGlzLnhyZWYuZmV0Y2goZSkscj17aWQ6ZS50b1N0cmluZygpLG5hbWU6bnVsbCxpbnRlbnQ6bnVsbCx1c2FnZTp7cHJpbnQ6bnVsbCx2aWV3Om51bGx9LHJiR3JvdXBzOltdfSxhPXQuZ2V0KCJOYW1lIik7InN0cmluZyI9PXR5cGVvZiBhJiYoci5uYW1lPXN0cmluZ1RvUERGU3RyaW5nKGEpKTtsZXQgbj10LmdldEFycmF5KCJJbnRlbnQiKTtBcnJheS5pc0FycmF5KG4pfHwobj1bbl0pO24uZXZlcnkoZT0+ZSBpbnN0YW5jZW9mIE5hbWUpJiYoci5pbnRlbnQ9bi5tYXAoZT0+ZS5uYW1lKSk7Y29uc3QgaT10LmdldCgiVXNhZ2UiKTtpZighKGkgaW5zdGFuY2VvZiBEaWN0KSlyZXR1cm4gcjtjb25zdCBzPXIudXNhZ2Usbz1pLmdldCgiUHJpbnQiKTtpZihvIGluc3RhbmNlb2YgRGljdCl7Y29uc3QgZT1vLmdldCgiUHJpbnRTdGF0ZSIpO2lmKGUgaW5zdGFuY2VvZiBOYW1lKXN3aXRjaChlLm5hbWUpe2Nhc2UiT04iOmNhc2UiT0ZGIjpzLnByaW50PXtwcmludFN0YXRlOmUubmFtZX19fWNvbnN0IGM9aS5nZXQoIlZpZXciKTtpZihjIGluc3RhbmNlb2YgRGljdCl7Y29uc3QgZT1jLmdldCgiVmlld1N0YXRlIik7aWYoZSBpbnN0YW5jZW9mIE5hbWUpc3dpdGNoKGUubmFtZSl7Y2FzZSJPTiI6Y2FzZSJPRkYiOnMudmlldz17dmlld1N0YXRlOmUubmFtZX19fXJldHVybiByfSN4ZShlLHQpe2Z1bmN0aW9uIHBhcnNlT25PZmYoZSl7Y29uc3Qgcj1bXTtpZihBcnJheS5pc0FycmF5KGUpKWZvcihjb25zdCBhIG9mIGUpYSBpbnN0YW5jZW9mIFJlZiYmdC5oYXMoYSkmJnIucHVzaChhLnRvU3RyaW5nKCkpO3JldHVybiByfWZ1bmN0aW9uIHBhcnNlT3JkZXIoZSxyPTApe2lmKCFBcnJheS5pc0FycmF5KGUpKXJldHVybiBudWxsO2NvbnN0IG49W107Zm9yKGNvbnN0IGkgb2YgZSl7aWYoaSBpbnN0YW5jZW9mIFJlZiYmdC5oYXMoaSkpe2EucHV0KGkpO24ucHVzaChpLnRvU3RyaW5nKCkpO2NvbnRpbnVlfWNvbnN0IGU9cGFyc2VOZXN0ZWRPcmRlcihpLHIpO2UmJm4ucHVzaChlKX1pZihyPjApcmV0dXJuIG47Y29uc3QgaT1bXTtmb3IoY29uc3RbZV1vZiB0Lml0ZW1zKCkpYS5oYXMoZSl8fGkucHVzaChlLnRvU3RyaW5nKCkpO2kubGVuZ3RoJiZuLnB1c2goe25hbWU6bnVsbCxvcmRlcjppfSk7cmV0dXJuIG59ZnVuY3Rpb24gcGFyc2VOZXN0ZWRPcmRlcihlLHQpe2lmKCsrdD5uKXt3YXJuKCJwYXJzZU5lc3RlZE9yZGVyIC0gcmVhY2hlZCBNQVhfTkVTVEVEX0xFVkVMUy4iKTtyZXR1cm4gbnVsbH1jb25zdCBhPXIuZmV0Y2hJZlJlZihlKTtpZighQXJyYXkuaXNBcnJheShhKSlyZXR1cm4gbnVsbDtjb25zdCBpPXIuZmV0Y2hJZlJlZihhWzBdKTtpZigic3RyaW5nIiE9dHlwZW9mIGkpcmV0dXJuIG51bGw7Y29uc3Qgcz1wYXJzZU9yZGVyKGEuc2xpY2UoMSksdCk7cmV0dXJuIHM/Lmxlbmd0aD97bmFtZTpzdHJpbmdUb1BERlN0cmluZyhpKSxvcmRlcjpzfTpudWxsfWNvbnN0IHI9dGhpcy54cmVmLGE9bmV3IFJlZlNldCxuPTEwOyFmdW5jdGlvbiBwYXJzZVJCR3JvdXBzKGUpe2lmKEFycmF5LmlzQXJyYXkoZSkpZm9yKGNvbnN0IGEgb2YgZSl7Y29uc3QgZT1yLmZldGNoSWZSZWYoYSk7aWYoIUFycmF5LmlzQXJyYXkoZSl8fCFlLmxlbmd0aCljb250aW51ZTtjb25zdCBuPW5ldyBTZXQ7Zm9yKGNvbnN0IHIgb2YgZSlpZihyIGluc3RhbmNlb2YgUmVmJiZ0LmhhcyhyKSYmIW4uaGFzKHIudG9TdHJpbmcoKSkpe24uYWRkKHIudG9TdHJpbmcoKSk7dC5nZXQocikucmJHcm91cHMucHVzaChuKX19fShlLmdldCgiUkJHcm91cHMiKSk7cmV0dXJue25hbWU6InN0cmluZyI9PXR5cGVvZiBlLmdldCgiTmFtZSIpP3N0cmluZ1RvUERGU3RyaW5nKGUuZ2V0KCJOYW1lIikpOm51bGwsY3JlYXRvcjoic3RyaW5nIj09dHlwZW9mIGUuZ2V0KCJDcmVhdG9yIik/c3RyaW5nVG9QREZTdHJpbmcoZS5nZXQoIkNyZWF0b3IiKSk6bnVsbCxiYXNlU3RhdGU6ZS5nZXQoIkJhc2VTdGF0ZSIpaW5zdGFuY2VvZiBOYW1lP2UuZ2V0KCJCYXNlU3RhdGUiKS5uYW1lOm51bGwsb246cGFyc2VPbk9mZihlLmdldCgiT04iKSksb2ZmOnBhcnNlT25PZmYoZS5nZXQoIk9GRiIpKSxvcmRlcjpwYXJzZU9yZGVyKGUuZ2V0KCJPcmRlciIpKSxncm91cHM6Wy4uLnRdfX1zZXRBY3R1YWxOdW1QYWdlcyhlPW51bGwpe3RoaXMuI2ZlPWV9Z2V0IGhhc0FjdHVhbE51bVBhZ2VzKCl7cmV0dXJuIG51bGwhPT10aGlzLiNmZX1nZXQgX3BhZ2VzQ291bnQoKXtjb25zdCBlPXRoaXMudG9wbGV2ZWxQYWdlc0RpY3QuZ2V0KCJDb3VudCIpO2lmKCFOdW1iZXIuaXNJbnRlZ2VyKGUpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiUGFnZSBjb3VudCBpbiB0b3AtbGV2ZWwgcGFnZXMgZGljdGlvbmFyeSBpcyBub3QgYW4gaW50ZWdlci4iKTtyZXR1cm4gc2hhZG93KHRoaXMsIl9wYWdlc0NvdW50IixlKX1nZXQgbnVtUGFnZXMoKXtyZXR1cm4gdGhpcy4jZmU/P3RoaXMuX3BhZ2VzQ291bnR9Z2V0IGRlc3RpbmF0aW9ucygpe2NvbnN0IGU9dGhpcy4jU2UoKSx0PU9iamVjdC5jcmVhdGUobnVsbCk7Zm9yKGNvbnN0IHIgb2YgZSlpZihyIGluc3RhbmNlb2YgTmFtZVRyZWUpZm9yKGNvbnN0W2UsYV1vZiByLmdldEFsbCgpKXtjb25zdCByPWZldGNoRGVzdChhKTtyJiYodFtzdHJpbmdUb1BERlN0cmluZyhlLCEwKV09cil9ZWxzZSBpZihyIGluc3RhbmNlb2YgRGljdClmb3IoY29uc3RbZSxhXW9mIHIpe2NvbnN0IHI9ZmV0Y2hEZXN0KGEpO3ImJih0W3N0cmluZ1RvUERGU3RyaW5nKGUsITApXXx8PXIpfXJldHVybiBzaGFkb3codGhpcywiZGVzdGluYXRpb25zIix0KX1nZXREZXN0aW5hdGlvbihlKXtpZih0aGlzLmhhc093blByb3BlcnR5KCJkZXN0aW5hdGlvbnMiKSlyZXR1cm4gdGhpcy5kZXN0aW5hdGlvbnNbZV0/P251bGw7Y29uc3QgdD10aGlzLiNTZSgpO2Zvcihjb25zdCByIG9mIHQpaWYociBpbnN0YW5jZW9mIE5hbWVUcmVlfHxyIGluc3RhbmNlb2YgRGljdCl7Y29uc3QgdD1mZXRjaERlc3Qoci5nZXQoZSkpO2lmKHQpcmV0dXJuIHR9aWYodC5sZW5ndGgpe2NvbnN0IHQ9dGhpcy5kZXN0aW5hdGlvbnNbZV07aWYodClyZXR1cm4gdH1yZXR1cm4gbnVsbH0jU2UoKXtjb25zdCBlPXRoaXMuI2dlLmdldCgiTmFtZXMiKSx0PVtdO2U/LmhhcygiRGVzdHMiKSYmdC5wdXNoKG5ldyBOYW1lVHJlZShlLmdldFJhdygiRGVzdHMiKSx0aGlzLnhyZWYpKTt0aGlzLiNnZS5oYXMoIkRlc3RzIikmJnQucHVzaCh0aGlzLiNnZS5nZXQoIkRlc3RzIikpO3JldHVybiB0fWdldCBwYWdlTGFiZWxzKCl7bGV0IGU9bnVsbDt0cnl7ZT10aGlzLiNBZSgpfWNhdGNoKGUpe2lmKGUgaW5zdGFuY2VvZiBNaXNzaW5nRGF0YUV4Y2VwdGlvbil0aHJvdyBlO3dhcm4oIlVuYWJsZSB0byByZWFkIHBhZ2UgbGFiZWxzLiIpfXJldHVybiBzaGFkb3codGhpcywicGFnZUxhYmVscyIsZSl9I0FlKCl7Y29uc3QgZT10aGlzLiNnZS5nZXRSYXcoIlBhZ2VMYWJlbHMiKTtpZighZSlyZXR1cm4gbnVsbDtjb25zdCB0PW5ldyBBcnJheSh0aGlzLm51bVBhZ2VzKTtsZXQgcj1udWxsLGE9IiI7Y29uc3Qgbj1uZXcgTnVtYmVyVHJlZShlLHRoaXMueHJlZikuZ2V0QWxsKCk7bGV0IGk9IiIscz0xO2ZvcihsZXQgZT0wLG89dGhpcy5udW1QYWdlcztlPG87ZSsrKXtjb25zdCBvPW4uZ2V0KGUpO2lmKHZvaWQgMCE9PW8pe2lmKCEobyBpbnN0YW5jZW9mIERpY3QpKXRocm93IG5ldyBGb3JtYXRFcnJvcigiUGFnZUxhYmVsIGlzIG5vdCBhIGRpY3Rpb25hcnkuIik7aWYoby5oYXMoIlR5cGUiKSYmIWlzTmFtZShvLmdldCgiVHlwZSIpLCJQYWdlTGFiZWwiKSl0aHJvdyBuZXcgRm9ybWF0RXJyb3IoIkludmFsaWQgdHlwZSBpbiBQYWdlTGFiZWwgZGljdGlvbmFyeS4iKTtpZihvLmhhcygiUyIpKXtjb25zdCBlPW8uZ2V0KCJTIik7aWYoIShlIGluc3RhbmNlb2YgTmFtZSkpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIHN0eWxlIGluIFBhZ2VMYWJlbCBkaWN0aW9uYXJ5LiIpO3I9ZS5uYW1lfWVsc2Ugcj1udWxsO2lmKG8uaGFzKCJQIikpe2NvbnN0IGU9by5nZXQoIlAiKTtpZigic3RyaW5nIiE9dHlwZW9mIGUpdGhyb3cgbmV3IEZvcm1hdEVycm9yKCJJbnZhbGlkIHByZWZpeCBpbiBQYWdlTGFiZWwgZGljdGlvbmFyeS4iKTthPXN0cmluZ1RvUERGU3RyaW5nKGUpfWVsc2UgYT0iIjtpZihvLmhhcygiU3QiK